import 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import 'chrome://resources/cr_elements/icons.html.js';
import '/shared/settings/prefs/prefs.js';
import '../settings_page/settings_section.js';
import '../settings_shared.css.js';
import '../icons.html.js';
import type { CrLinkRowElement } from 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
declare const SettingsAutofillPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("//resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export interface SettingsAutofillPageElement {
    $: {
        passwordManagerButton: CrLinkRowElement;
    };
}
export declare class SettingsAutofillPageElement extends SettingsAutofillPageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        autofillAiAvailable_: {
            type: BooleanConstructor;
            value(): boolean;
        };
    };
    private autofillAiAvailable_;
    private metricsBrowserProxy_;
    /**
     * Shows the manage addresses sub page.
     */
    private onAddressesClick_;
    /**
     * Shows the manage payment methods sub page.
     */
    private onPaymentsClick_;
    /**
     * Shows Password Manager page.
     */
    private onPasswordsClick_;
    /**
     * Shows the Autofill AI settings sub page.
     */
    private onAutofillAiClick_;
    /**
     * @returns the sublabel of the address entry.
     */
    private addressesSublabel_;
    getFocusConfig(): Map<any, any>;
    getAssociatedControlFor(childViewId: string): HTMLElement;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-autofill-page': SettingsAutofillPageElement;
    }
}
export {};
