import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_-->    <style include="settings-shared search-engine-entry">:host([is-default]) .list-item{font-weight:500}.additional-info-column-group{align-items:center;display:flex;flex:6}#controls-column-group{flex:auto;margin-left:auto;display:flex;justify-content:end;align-items:center}cr-policy-indicator{display:inline-flex;justify-content:center;margin-inline-start:16px;vertical-align:middle;width:36px}#downloadedIcon{display:block;height:var(--site-favicon-height,16px);margin-inline-end:8px;min-width:16px;width:var(--site-favicon-width,16px)}#name-column{align-items:center;display:flex;flex:3;word-break:break-word}#shortcut-column{word-break:break-word}#shortcut-column,#url-column{flex:auto;margin-inline-end:10px;max-width:200px}
    </style>

    <div class="list-item cr-row" role="row">
      <span role="cell" id="name-column">
        <site-favicon favicon-url="[[engine.iconURL]]" url="[[engine.url]]"
            icon-path="[[engine.iconPath]]"
            hidden="[[shouldShowDownloadedIcon_(showDownloadedIcon_, engine)]]">
        </site-favicon>
        <img id="downloadedIcon" is="cr-auto-img"
            auto-src="[[engine.iconURL]]" clear-src
            on-load="onDownloadedIconLoadSuccess_"
            on-error="onDownloadedIconLoadError_"
            hidden="[[!shouldShowDownloadedIcon_(showDownloadedIcon_, engine)]]">
        <div>[[engine.displayName]]</div>
      </span>
      <span class="additional-info-column-group">
        <span role="cell" id="shortcut-column" hidden="[[!showShortcut]]">
          <div>[[engine.keyword]]</div>
        </span>
        <span role="cell" id="url-column" hidden="[[!showQueryUrl]]">
          <div class="text-elide">[[engine.url]]</div>
        </span>
        <span role="cell" id="controls-column-group">
          <cr-button class="secondary-button" on-click="onActivateClick_"
              aria-label="[[getActivateButtonAriaLabel_(engine)]]"
              hidden="[[!engine.canBeActivated]]" id="activate">
            $i18n{searchEnginesActivate}
          </cr-button>
          <cr-button class="secondary-button" on-click="onViewOrEditClick_"
              hidden="[[!showSecondaryButton_]]" id="viewDetailsButton">
            $i18n{searchEnginesViewDetails}
          </cr-button>
          <cr-icon-button class="icon-edit" on-click="onViewOrEditClick_"
              title="$i18n{edit}" hidden="[[!showEditIcon_]]"
              aria-label="[[getEditButtonAriaLabel_(engine)]]"
              disabled$="[[!engine.canBeEdited]]" id="editIconButton">
          </cr-icon-button>
          <template is="dom-if" if="[[engine.isManaged]]">
            <cr-policy-indicator indicator-type="userPolicy">
            </cr-policy-indicator>
          </template>
          <cr-icon-button class="icon-more-vert" on-click="onDotsClick_"
              disabled$="[[disableDots_]]" title="$i18n{moreActions}"
              aria-label="[[getMoreActionsAriaLabel_(engine)]]">
          </cr-icon-button>
          <cr-action-menu role-description="$i18n{menu}">
            <button class="dropdown-item" on-click="onMakeDefaultClick_"
                disabled$="[[!engine.canBeDefault]]" id="makeDefault">
              $i18n{searchEnginesMakeDefault}
            </button>
            <button class="dropdown-item" on-click="onDeactivateClick_"
                hidden="[[!engine.canBeDeactivated]]" id="deactivate">
              $i18n{searchEnginesDeactivate}
            </button>
            <button class="dropdown-item" on-click="onDeleteClick_"
                hidden="[[!engine.canBeRemoved]]" id="delete">
              $i18n{delete}
            </button>
          </cr-action-menu>
        </span>
      </span>
    </div>
    <template is="dom-if" if="[[engine.extension]]">
      <extension-controlled-indicator
          extension-id="[[engine.extension.id]]"
          extension-name="[[engine.extension.name]]"
          extension-can-be-disabled="[[engine.extension.canBeDisabled]]">
      </extension-controlled-indicator>
    </template>
<!--_html_template_end_-->`;
}