import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="settings-shared">cr-view-manager [hidden-by-search],cr-view-manager[show-all] [slot=view][data-parent-view-id]{display:none}</style>

<cr-view-manager id="viewManager" class="cr-centered-card-container"
    show-all$="[[shouldShowAll]]">
  <settings-people-page slot="view" id="parent" prefs="{{prefs}}"
      route-path$="[[routes_.PEOPLE.path]]">
  </settings-people-page>

  <settings-sync-page slot="view" id="sync"
      data-parent-view-id="parent" prefs="{{prefs}}"
      route-path$="[[routes_.SYNC.path]]">
  </settings-sync-page>

  <settings-sync-controls-page slot="view" id="syncControls"
      data-parent-view-id="parent" route-path$="[[routes_.SYNC_ADVANCED.path]]">
  </settings-sync-controls-page>


   <settings-manage-profile slot="view" id="manageProfile"
       data-parent-view-id="parent" profile-name="[[profileName_]]"
       route-path$="[[routes_.MANAGE_PROFILE.path]]">
   </settings-manage-profile>

   <template is="dom-if" if="[[replaceSyncPromosWithSignInPromos_]]"
      restamp>
    <!-- TODO(crbug.com/452589374): Remove the no-search attributes once a
     proper solution for making these pages unavailable asynchronously is
     implemented. -->
     <settings-account-page slot="view" id="account" no-search
         data-parent-view-id="parent" prefs="{{prefs}}"
         route-path$="[[routes_.ACCOUNT.path]]">
     </settings-account-page>

     <settings-google-services-page slot="view" id="googleServices"
         no-search data-parent-view-id="parent" prefs="{{prefs}}"
         route-path$="[[routes_.GOOGLE_SERVICES.path]]">
     </settings-google-services-page>
   </template>

</cr-view-manager>
<!--_html_template_end_-->`;
}