import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_-->  <style include="cr-shared-style settings-shared passwords-shared">#autofillSyncToggleWrapper{align-items:center;cursor:pointer;display:flex;min-height:var(--cr-section-two-line-min-height);padding:0 var(--cr-section-padding)}#autofillSyncToggleWrapper:hover{background-color:var(--cr-hover-background-color)}#addressList .start{display:flex;overflow:hidden}#addressSummary{display:flex;flex:1;overflow:hidden}#plusAddressSettingsButton{margin-top:16px}.dropdown-item.external-link-style{display:flex;justify-content:space-between;align-items:center;width:100%}.dropdown-item.external-link-style cr-icon{--cr-icon-color:var(--cr-secondary-text-color)}
  </style>
  <settings-subpage page-title="$i18n{addressesTitle}"
      hide-close-button
      learn-more-url="$i18n{addressesAndPaymentMethodsLearnMoreURL}">
    <settings-toggle-button id="autofillProfileToggle"
        no-extension-indicator label="$i18n{enableProfilesLabel}"
        sub-label="$i18n{enableProfilesSublabel}"
        pref="{{prefs.autofill.profile_enabled}}"
        on-change="onAutofillProfileToggleChanged_">
    </settings-toggle-button>
    <div id="autofillSyncToggleWrapper"
        hidden$="[[!isAutofillSyncToggleVisible_(accountInfo_)]]">
      <div class="flex">
        <div class="label">$i18n{autofillSyncToggleLabel}</div>
        <div class="label cr-secondary-text">[[accountInfo_.email]]</div>
      </div>
      <cr-toggle id="autofillSyncToggle"
          checked="[[accountInfo_.isAutofillSyncToggleEnabled]]"
          on-change="onAutofillSyncEnabledChange_">
      </cr-toggle>
    </div>
    <template is="dom-if" if="[[prefs.autofill.profile_enabled.extensionId]]">
      <div class="cr-row continuation">
        <extension-controlled-indicator class="flex"
            id="autofillExtensionIndicator"
            extension-id="[[prefs.autofill.profile_enabled.extensionId]]"
            extension-name="[[prefs.autofill.profile_enabled.controlledByName]]"
            extension-can-be-disabled="[[
                prefs.autofill.profile_enabled.extensionCanBeDisabled]]">
        </extension-controlled-indicator>
      </div>
    </template>
    <div class="cr-row continuation">
      <h2 class="flex">$i18n{addresses}</h2>
      <cr-button id="addAddress" class="header-aligned-button"
          on-click="onAddAddressClick_" aria-label="$i18n{addAddressTitle}"
          hidden$="[[!prefs.autofill.profile_enabled.value]]">
        $i18n{add}
      </cr-button>
    </div>
    <div class="list-frame" aria-label="$i18n{addressesTableAriaLabel}"
         role="list">
      <div id="addressList" class="vertical-list" role="none">
        <template is="dom-repeat" items="[[addresses]]">
          <div class="list-item" role="listitem">
            <div class="start">
              <span id="addressSummary">
                <span class="ellipses">
                  [[item.metadata.summaryLabel]]
                </span>
                <span class="ellipses">
                  [[item.metadata.summarySublabel]]
                </span>
              </span>
              <cr-icon
                  id="address-row-icon"
                  icon="[[getAddressIcon_(item, accountInfo_)]]"
                  hidden$="[[!shouldShowAddressIcon_(item, accountInfo_)]]"
                  aria-label="[[getA11yLabelForIcon_(item, accountInfo_)]]"
                  role="img">
              </cr-icon>
            </div>
            <cr-icon-button class="icon-more-vert address-menu"
                on-click="onAddressMenuClick_"
                title="[[moreActionsTitle_(item)]]">
            </cr-icon-button>
          </div>
        </template>
      </div>
      <div id="noAddressesLabel" class="list-item"
          hidden$="[[hasSome_(addresses)]]">
        $i18n{noAddressesFound}
      </div>
    </div>
    <cr-action-menu id="addressSharedMenu" role-description="$i18n{menu}">
      <template is="dom-if" if="[[isGoogleProfileAddress]]" restamp>
        <button
            id="menuEditAddress"
            class="dropdown-item external-link-style"
            on-click="onMenuEditAddressClick_"
            role-description="$i18n{homeWorkAddressAccessiblityLabel}">
          <span class="label">$i18n{edit}</span>
          <cr-icon icon="cr:open-in-new" aria-hidden="true"></cr-icon>
        </button>

        <button id="menuRemoveAddress"
            class="dropdown-item"
            on-click="onMenuRemoveAddressClick_">
          [[getMenuRemoveAddressLabel_(activeAddress)]]
        </button>
      </template>

      <template is="dom-if" if="[[!isGoogleProfileAddress]]" restamp>
        <button id="menuEditAddress" class="dropdown-item"
            on-click="onMenuEditAddressClick_">$i18n{edit}</button>

        <button id="menuRemoveAddress" class="dropdown-item"
            on-click="onMenuRemoveAddressClick_">
          [[getMenuRemoveAddressLabel_(activeAddress)]]
        </button>
      </template>
    </cr-action-menu>
    <template is="dom-if" if="[[showAddressDialog_]]" restamp>
      <settings-address-edit-dialog address="[[activeAddress]]"
          account-info="[[accountInfo_]]" on-close="onAddressDialogClose_">
      </settings-address-edit-dialog>
    </template>
    <template is="dom-if" if="[[showAddressRemoveConfirmationDialog_]]" restamp>
      <settings-address-remove-confirmation-dialog
          address="[[activeAddress]]" account-info="[[accountInfo_]]"
          on-close="onAddressRemoveConfirmationDialogClose_">
      </settings-address-remove-confirmation-dialog>
    </template>
    <template is="dom-if" if="[[isPlusAddressEnabled_]]">
      <cr-link-row class="cr-row" id="plusAddressSettingsButton"
          label="$i18n{plusAddressSettings}"
          sub-label="$i18n{plusAddressSettingsSublabel}"
          on-click="onPlusAddressClick_"
          role-description="$i18n{subpageArrowRoleDescription}"
          external>
      </cr-link-row>
    </template>
  </settings-subpage>
<!--_html_template_end_-->`;
}