import{sendWithPromise,addWebUiListener,removeWebUiListener}from"chrome://resources/js/cr.js";import{PolymerElement,html as html$1,dedupingMixin,microTask,useShadow,dom,Polymer,Templatizer,OptionalMutableDataBehavior,animationFrame,idlePeriod,flush,Debouncer,enqueueDebouncer,matches,translate,beforeNextRender,templatize,afterNextRender,calculateSplices,mixinBehaviors}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{css,CrLitElement,html,nothing}from"chrome://resources/lit/v3_0/lit.rollup.js";import"chrome://settings/strings.m.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{mojo}from"chrome://resources/mojo/mojo/public/js/bindings.js";const sheet$1=new CSSStyleSheet;sheet$1.replaceSync(`html{--google-blue-50-rgb:232,240,254;--google-blue-50:rgb(var(--google-blue-50-rgb));--google-blue-100-rgb:210,227,252;--google-blue-100:rgb(var(--google-blue-100-rgb));--google-blue-200-rgb:174,203,250;--google-blue-200:rgb(var(--google-blue-200-rgb));--google-blue-300-rgb:138,180,248;--google-blue-300:rgb(var(--google-blue-300-rgb));--google-blue-400-rgb:102,157,246;--google-blue-400:rgb(var(--google-blue-400-rgb));--google-blue-500-rgb:66,133,244;--google-blue-500:rgb(var(--google-blue-500-rgb));--google-blue-600-rgb:26,115,232;--google-blue-600:rgb(var(--google-blue-600-rgb));--google-blue-700-rgb:25,103,210;--google-blue-700:rgb(var(--google-blue-700-rgb));--google-blue-800-rgb:24,90,188;--google-blue-800:rgb(var(--google-blue-800-rgb));--google-blue-900-rgb:23,78,166;--google-blue-900:rgb(var(--google-blue-900-rgb));--google-green-50-rgb:230,244,234;--google-green-50:rgb(var(--google-green-50-rgb));--google-green-200-rgb:168,218,181;--google-green-200:rgb(var(--google-green-200-rgb));--google-green-300-rgb:129,201,149;--google-green-300:rgb(var(--google-green-300-rgb));--google-green-400-rgb:91,185,116;--google-green-400:rgb(var(--google-green-400-rgb));--google-green-500-rgb:52,168,83;--google-green-500:rgb(var(--google-green-500-rgb));--google-green-600-rgb:30,142,62;--google-green-600:rgb(var(--google-green-600-rgb));--google-green-700-rgb:24,128,56;--google-green-700:rgb(var(--google-green-700-rgb));--google-green-800-rgb:19,115,51;--google-green-800:rgb(var(--google-green-800-rgb));--google-green-900-rgb:13,101,45;--google-green-900:rgb(var(--google-green-900-rgb));--google-grey-50-rgb:248,249,250;--google-grey-50:rgb(var(--google-grey-50-rgb));--google-grey-100-rgb:241,243,244;--google-grey-100:rgb(var(--google-grey-100-rgb));--google-grey-200-rgb:232,234,237;--google-grey-200:rgb(var(--google-grey-200-rgb));--google-grey-300-rgb:218,220,224;--google-grey-300:rgb(var(--google-grey-300-rgb));--google-grey-400-rgb:189,193,198;--google-grey-400:rgb(var(--google-grey-400-rgb));--google-grey-500-rgb:154,160,166;--google-grey-500:rgb(var(--google-grey-500-rgb));--google-grey-600-rgb:128,134,139;--google-grey-600:rgb(var(--google-grey-600-rgb));--google-grey-700-rgb:95,99,104;--google-grey-700:rgb(var(--google-grey-700-rgb));--google-grey-800-rgb:60,64,67;--google-grey-800:rgb(var(--google-grey-800-rgb));--google-grey-900-rgb:32,33,36;--google-grey-900:rgb(var(--google-grey-900-rgb));--google-grey-900-white-4-percent:#292a2d;--google-purple-200-rgb:215,174,251;--google-purple-200:rgb(var(--google-purple-200-rgb));--google-purple-900-rgb:104,29,168;--google-purple-900:rgb(var(--google-purple-900-rgb));--google-red-100-rgb:244,199,195;--google-red-100:rgb(var(--google-red-100-rgb));--google-red-300-rgb:242,139,130;--google-red-300:rgb(var(--google-red-300-rgb));--google-red-500-rgb:234,67,53;--google-red-500:rgb(var(--google-red-500-rgb));--google-red-600-rgb:217,48,37;--google-red-600:rgb(var(--google-red-600-rgb));--google-red-700-rgb:197,57,41;--google-red-700:rgb(var(--google-red-700-rgb));--google-yellow-50-rgb:254,247,224;--google-yellow-50:rgb(var(--google-yellow-50-rgb));--google-yellow-100-rgb:254,239,195;--google-yellow-100:rgb(var(--google-yellow-100-rgb));--google-yellow-200-rgb:253,226,147;--google-yellow-200:rgb(var(--google-yellow-200-rgb));--google-yellow-300-rgb:253,214,51;--google-yellow-300:rgb(var(--google-yellow-300-rgb));--google-yellow-400-rgb:252,201,52;--google-yellow-400:rgb(var(--google-yellow-400-rgb));--google-yellow-500-rgb:251,188,4;--google-yellow-500:rgb(var(--google-yellow-500-rgb));--google-yellow-700-rgb:240,147,0;--google-yellow-700:rgb(var(--google-yellow-700-rgb));--cr-card-background-color:white;--cr-shadow-key-color_:color-mix(in srgb,var(--cr-shadow-color) 30%,transparent);--cr-shadow-ambient-color_:color-mix(in srgb,var(--cr-shadow-color) 15%,transparent);--cr-elevation-1:var(--cr-shadow-key-color_) 0 1px 2px 0,var(--cr-shadow-ambient-color_) 0 1px 3px 1px;--cr-elevation-2:var(--cr-shadow-key-color_) 0 1px 2px 0,var(--cr-shadow-ambient-color_) 0 2px 6px 2px;--cr-elevation-3:var(--cr-shadow-key-color_) 0 1px 3px 0,var(--cr-shadow-ambient-color_) 0 4px 8px 3px;--cr-elevation-4:var(--cr-shadow-key-color_) 0 2px 3px 0,var(--cr-shadow-ambient-color_) 0 6px 10px 4px;--cr-elevation-5:var(--cr-shadow-key-color_) 0 4px 4px 0,var(--cr-shadow-ambient-color_) 0 8px 12px 6px;--cr-card-shadow:var(--cr-elevation-2);--cr-focused-item-color:var(--google-grey-300);--cr-form-field-label-color:var(--google-grey-700);--cr-hairline-rgb:0,0,0;--cr-iph-anchor-highlight-color:rgba(var(--google-blue-600-rgb),0.1);--cr-menu-background-color:white;--cr-menu-background-focus-color:var(--google-grey-400);--cr-menu-shadow:var(--cr-elevation-2);--cr-separator-color:rgba(0,0,0,.06);--cr-title-text-color:rgb(90,90,90);--cr-scrollable-border-color:var(--google-grey-300)}@media (prefers-color-scheme:dark){html{--cr-card-background-color:var(--google-grey-900-white-4-percent);--cr-focused-item-color:var(--google-grey-800);--cr-form-field-label-color:var(--dark-secondary-color);--cr-hairline-rgb:255,255,255;--cr-iph-anchor-highlight-color:rgba(var(--google-grey-100-rgb),0.1);--cr-menu-background-color:var(--google-grey-900);--cr-menu-background-focus-color:var(--google-grey-700);--cr-menu-background-sheen:rgba(255,255,255,.06);--cr-menu-shadow:rgba(0,0,0,.3) 0 1px 2px 0,rgba(0,0,0,.15) 0 3px 6px 2px;--cr-separator-color:rgba(255,255,255,.1);--cr-title-text-color:var(--cr-primary-text-color);--cr-scrollable-border-color:var(--google-grey-700)}}@media (forced-colors:active){html{--cr-focus-outline-hcm:2px solid transparent;--cr-border-hcm:2px solid transparent}}html{--cr-button-edge-spacing:12px;--cr-controlled-by-spacing:24px;--cr-default-input-max-width:264px;--cr-icon-ripple-size:36px;--cr-icon-ripple-padding:8px;--cr-icon-size:20px;--cr-icon-button-margin-start:16px;--cr-icon-ripple-margin:calc(var(--cr-icon-ripple-padding) * -1);--cr-section-min-height:48px;--cr-section-two-line-min-height:64px;--cr-section-padding:20px;--cr-section-vertical-padding:12px;--cr-section-indent-width:40px;--cr-section-indent-padding:calc(var(--cr-section-padding) + var(--cr-section-indent-width));--cr-section-vertical-margin:21px;--cr-centered-card-max-width:680px;--cr-centered-card-width-percentage:0.96;--cr-hairline:1px solid rgba(var(--cr-hairline-rgb),.14);--cr-separator-height:1px;--cr-separator-line:var(--cr-separator-height) solid var(--cr-separator-color);--cr-toolbar-overlay-animation-duration:150ms;--cr-toolbar-height:56px;--cr-container-shadow-height:6px;--cr-container-shadow-margin:calc(-1 * var(--cr-container-shadow-height));--cr-container-shadow-max-opacity:1;--cr-card-border-radius:8px;--cr-disabled-opacity:.38;--cr-form-field-bottom-spacing:16px;--cr-form-field-label-font-size:.625rem;--cr-form-field-label-height:1em;--cr-form-field-label-line-height:1}html{--cr-fallback-color-outline:rgb(116,119,117);--cr-fallback-color-primary:rgb(11,87,208);--cr-fallback-color-on-primary:rgb(255,255,255);--cr-fallback-color-primary-container:rgb(211,227,253);--cr-fallback-color-on-primary-container:rgb(4,30,73);--cr-fallback-color-secondary-container:rgb(194,231,255);--cr-fallback-color-on-secondary-container:rgb(0,29,53);--cr-fallback-color-neutral-container:rgb(242,242,242);--cr-fallback-color-neutral-outline:rgb(199,199,199);--cr-fallback-color-surface:rgb(255,255,255);--cr-fallback-color-surface1:rgb(248,250,253);--cr-fallback-color-surface2:rgb(243,246,252);--cr-fallback-color-surface3:rgb(239,243,250);--cr-fallback-color-on-surface-rgb:31,31,31;--cr-fallback-color-on-surface:rgb(var(--cr-fallback-color-on-surface-rgb));--cr-fallback-color-surface-variant:rgb(225,227,225);--cr-fallback-color-on-surface-variant:rgb(138,141,140);--cr-fallback-color-on-surface-subtle:rgb(71,71,71);--cr-fallback-color-inverse-primary:rgb(168,199,250);--cr-fallback-color-inverse-surface:rgb(48,48,48);--cr-fallback-color-inverse-on-surface:rgb(242,242,242);--cr-fallback-color-tonal-container:rgb(211,227,253);--cr-fallback-color-on-tonal-container:rgb(4,30,73);--cr-fallback-color-tonal-outline:rgb(168,199,250);--cr-fallback-color-error:rgb(179,38,30);--cr-fallback-color-divider:rgb(211,227,253);--cr-fallback-color-state-hover-on-prominent_:rgba(253,252,251,.1);--cr-fallback-color-state-on-subtle-rgb_:31,31,31;--cr-fallback-color-state-hover-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.06);--cr-fallback-color-state-ripple-neutral-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.08);--cr-fallback-color-state-ripple-primary-rgb_:124,172,248;--cr-fallback-color-state-ripple-primary_:rgba(var(--cr-fallback-color-state-ripple-primary-rgb_),0.32);--cr-fallback-color-base-container:rgb(236,239,247);--cr-fallback-color-disabled-background:rgba(var(--cr-fallback-color-on-surface-rgb),.12);--cr-fallback-color-disabled-foreground:rgba(var(--cr-fallback-color-on-surface-rgb),var(--cr-disabled-opacity));--cr-hover-background-color:var(--color-sys-state-hover,rgba(var(--cr-fallback-color-on-surface-rgb),.08));--cr-hover-on-prominent-background-color:var(--color-sys-state-hover-on-prominent,var(--cr-fallback-color-state-hover-on-prominent_));--cr-hover-on-subtle-background-color:var(--color-sys-state-hover-on-subtle,var(--cr-fallback-color-state-hover-on-subtle_));--cr-active-background-color:var(--color-sys-state-pressed,rgba(var(--cr-fallback-color-on-surface-rgb),.12));--cr-active-on-primary-background-color:var(--color-sys-state-ripple-primary,var(--cr-fallback-color-state-ripple-primary_));--cr-active-neutral-on-subtle-background-color:var(--color-sys-state-ripple-neutral-on-subtle,var(--cr-fallback-color-state-ripple-neutral-on-subtle_));--cr-focus-outline-color:var(--color-sys-state-focus-ring,var(--owl-control-accent-color,var(--cr-fallback-color-primary)));--cr-focus-outline-inverse-color:var(--color-sys-state-focus-ring-inverse,var(--cr-fallback-color-inverse-primary));--cr-primary-text-color:var(--color-primary-foreground,var(--cr-fallback-color-on-surface));--cr-secondary-text-color:var(--color-secondary-foreground,var(--cr-fallback-color-on-surface-variant));--cr-link-color:var(--color-link-foreground-default,var(--cr-fallback-color-primary));--cr-button-height:36px;--cr-shadow-color:var(--color-sys-shadow,rgb(0,0,0));--cr-checked-color:var(--color-checkbox-foreground-checked,var(--owl-control-accent-color,var(--cr-fallback-color-primary)))}@media (prefers-color-scheme:dark){html{--cr-fallback-color-outline:rgb(142,145,143);--cr-fallback-color-primary:rgb(168,199,250);--cr-fallback-color-on-primary:rgb(6,46,111);--cr-fallback-color-primary-container:rgb(8,66,160);--cr-fallback-color-on-primary-container:rgb(211,227,253);--cr-fallback-color-secondary-container:rgb(0,74,119);--cr-fallback-color-on-secondary-container:rgb(194,231,255);--cr-fallback-color-neutral-container:rgb(40,40,40);--cr-fallback-color-neutral-outline:rgb(117,117,117);--cr-fallback-color-surface:rgb(31,31,31);--cr-fallback-color-surface1:rgb(39,40,42);--cr-fallback-color-surface2:rgb(45,47,49);--cr-fallback-color-surface3:rgb(51,52,56);--cr-fallback-color-on-surface-rgb:227,227,227;--cr-fallback-color-surface-variant:rgb(68,71,70);--cr-fallback-color-on-surface-variant:rgb(158,161,160);--cr-fallback-color-on-surface-subtle:rgb(199,199,199);--cr-fallback-color-inverse-primary:rgb(11,87,208);--cr-fallback-color-inverse-surface:rgb(227,227,227);--cr-fallback-color-inverse-on-surface:rgb(31,31,31);--cr-fallback-color-tonal-container:rgb(0,74,119);--cr-fallback-color-on-tonal-container:rgb(194,231,255);--cr-fallback-color-tonal-outline:rgb(4,125,183);--cr-fallback-color-error:rgb(242,184,181);--cr-fallback-color-divider:rgb(94,94,94);--cr-fallback-color-state-hover-on-prominent_:rgba(31,31,31,.06);--cr-fallback-color-state-on-subtle-rgb_:253,252,251;--cr-fallback-color-state-hover-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.10);--cr-fallback-color-state-ripple-neutral-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.16);--cr-fallback-color-state-ripple-primary-rgb_:76,141,246;--cr-fallback-color-base-container:rgba(40,40,40,1)}}@media (forced-colors:active){html{--cr-fallback-color-disabled-background:Canvas;--cr-fallback-color-disabled-foreground:GrayText}}`);document.adoptedStyleSheets=[...document.adoptedStyleSheets,sheet$1];
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function assert(value,message){if(value){return}throw new Error("Assertion failed"+(message?`: ${message}`:""))}function assertInstanceof(value,type,message){if(value instanceof type){return}throw new Error(`Value ${value} is not of type ${type.name||typeof type}`)}function assertNotReached(message="Unreachable code hit"){assert(false,message)}function assertNotReachedCase(_param,message){assertNotReached(message)}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getDeepActiveElement(){let a=document.activeElement;while(a&&a.shadowRoot&&a.shadowRoot.activeElement){a=a.shadowRoot.activeElement}return a}function isRTL(){return document.documentElement.dir==="rtl"}function listenOnce(target,eventNames,callback){const eventNamesArray=Array.isArray(eventNames)?eventNames:eventNames.split(/ +/);const removeAllAndCallCallback=function(event){eventNamesArray.forEach((function(eventName){target.removeEventListener(eventName,removeAllAndCallCallback,false)}));return callback(event)};eventNamesArray.forEach((function(eventName){target.addEventListener(eventName,removeAllAndCallCallback,false)}))}function hasKeyModifiers(e){return!!(e.altKey||e.ctrlKey||e.metaKey||e.shiftKey)}function isUndoKeyboardEvent(event){if(event.key!=="z"){return false}const excludedModifiers=[event.altKey,event.shiftKey,event.ctrlKey];let targetModifier=event.ctrlKey;targetModifier=event.metaKey;return targetModifier&&!excludedModifiers.some((modifier=>modifier))}function debounceEnd(fn,time=50){let timerId;return()=>{clearTimeout(timerId);timerId=setTimeout(fn,time)}}let instance$Q=null;function getCss$x(){return instance$Q||(instance$Q=[...[],css`[hidden],:host([hidden]){display:none !important}`])}let instance$P=null;function getCss$w(){return instance$P||(instance$P=[...[getCss$x()],css`:host{align-items:center;display:inline-flex;justify-content:center;position:relative;vertical-align:middle;fill:var(--iron-icon-fill-color,currentcolor);stroke:var(--iron-icon-stroke-color,none);width:var(--iron-icon-width,24px);height:var(--iron-icon-height,24px)}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let iconsetMap=null;class IconsetMap extends EventTarget{iconsets_=new Map;static getInstance(){return iconsetMap||(iconsetMap=new IconsetMap)}static resetInstanceForTesting(instance){iconsetMap=instance}get(id){return this.iconsets_.get(id)||null}set(id,iconset){assert(!this.iconsets_.has(id),`Tried to add a second iconset with id '${id}'`);this.iconsets_.set(id,iconset);this.dispatchEvent(new CustomEvent("cr-iconset-added",{detail:id}))}}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class CrIconElement extends CrLitElement{static get is(){return"cr-icon"}static get styles(){return getCss$w()}static get properties(){return{icon:{type:String}}}#icon_accessor_storage="";get icon(){return this.#icon_accessor_storage}set icon(value){this.#icon_accessor_storage=value}iconsetName_="";iconName_="";iconset_=null;updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("icon")){const[iconsetName,iconName]=this.icon.split(":");this.iconName_=iconName||"";this.iconsetName_=iconsetName||"";this.updateIcon_()}}updateIcon_(){if(this.iconName_===""&&this.iconset_){this.iconset_.removeIcon(this)}else if(this.iconsetName_){const iconsetMap=IconsetMap.getInstance();this.iconset_=iconsetMap.get(this.iconsetName_);assert(this.iconset_,`Could not find iconset for: '${this.iconsetName_}:${this.iconName_}'`);this.iconset_.applyIcon(this,this.iconName_)}}}customElements.define(CrIconElement.is,CrIconElement);
// Copyright 2011 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class EventTracker{listeners_=[];add(target,eventType,listener,capture=false){const h={target:target,eventType:eventType,listener:listener,capture:capture};this.listeners_.push(h);target.addEventListener(eventType,listener,capture)}remove(target,eventType){this.listeners_=this.listeners_.filter((listener=>{if(listener.target===target&&(!eventType||listener.eventType===eventType)){EventTracker.removeEventListener(listener);return false}return true}))}removeAll(){this.listeners_.forEach((listener=>EventTracker.removeEventListener(listener)));this.listeners_=[]}static removeEventListener(entry){entry.target.removeEventListener(entry.eventType,entry.listener,entry.capture)}}let instance$O=null;function getCss$v(){return instance$O||(instance$O=[...[],css`:host{bottom:0;display:block;left:0;overflow:hidden;pointer-events:none;position:absolute;right:0;top:0;transform:translate3d(0,0,0)}.ripple{background-color:currentcolor;left:0;opacity:var(--paper-ripple-opacity,0.25);pointer-events:none;position:absolute;will-change:height,transform,width}.ripple,:host(.circle){border-radius:50%}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class CrRippleElement extends CrLitElement{static get is(){return"cr-ripple"}static get styles(){return getCss$v()}static get properties(){return{holdDown:{type:Boolean},recenters:{type:Boolean},noink:{type:Boolean}}}#holdDown_accessor_storage=false;get holdDown(){return this.#holdDown_accessor_storage}set holdDown(value){this.#holdDown_accessor_storage=value}#recenters_accessor_storage=false;get recenters(){return this.#recenters_accessor_storage}set recenters(value){this.#recenters_accessor_storage=value}#noink_accessor_storage=false;get noink(){return this.#noink_accessor_storage}set noink(value){this.#noink_accessor_storage=value}ripples_=[];eventTracker_=new EventTracker;connectedCallback(){super.connectedCallback();assert(this.parentNode);const keyEventTarget=this.parentNode.nodeType===Node.DOCUMENT_FRAGMENT_NODE?this.parentNode.host:this.parentElement;this.eventTracker_.add(keyEventTarget,"pointerdown",(e=>this.uiDownAction(e)));this.eventTracker_.add(keyEventTarget,"pointerup",(()=>this.uiUpAction()));this.eventTracker_.add(keyEventTarget,"pointerout",(()=>this.uiUpAction()));this.eventTracker_.add(keyEventTarget,"keydown",(e=>{if(e.defaultPrevented){return}if(e.key==="Enter"){this.onEnterKeydown_();return}if(e.key===" "){this.onSpaceKeydown_()}}));this.eventTracker_.add(keyEventTarget,"keyup",(e=>{if(e.defaultPrevented){return}if(e.key===" "){this.onSpaceKeyup_()}}))}disconnectedCallback(){super.disconnectedCallback();this.eventTracker_.removeAll()}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("holdDown")){this.holdDownChanged_(this.holdDown,changedProperties.get("holdDown"))}}uiDownAction(e){if(e!==undefined&&e.button!==0){return}if(!this.noink){this.downAction_(e)}}downAction_(e){if(this.ripples_.length&&this.holdDown){return}this.showRipple_(e)}clear(){this.hideRipple_();this.holdDown=false}showAndHoldDown(){this.ripples_.forEach((ripple=>{ripple.remove()}));this.ripples_=[];this.holdDown=true}showRipple_(e){return}uiUpAction(){if(!this.noink){this.upAction_()}}upAction_(){if(!this.holdDown){this.hideRipple_()}}hideRipple_(){if(this.ripples_.length===0){return}this.ripples_.forEach((function(ripple){const opacity=ripple.computedStyleMap().get("opacity");if(opacity===null){ripple.remove();return}const animation=ripple.animate({opacity:[opacity.value,0]},{duration:150,fill:"forwards"});animation.finished.then((()=>{ripple.remove()}))}));this.ripples_=[]}onEnterKeydown_(){this.uiDownAction();window.setTimeout((()=>{this.uiUpAction()}),1)}onSpaceKeydown_(){this.uiDownAction()}onSpaceKeyup_(){this.uiUpAction()}holdDownChanged_(newHoldDown,oldHoldDown){if(oldHoldDown===undefined){return}if(newHoldDown){this.downAction_()}else{this.upAction_()}}}customElements.define(CrRippleElement.is,CrRippleElement);
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrRippleMixin=superClass=>{class CrRippleMixin extends superClass{static get properties(){return{noink:{type:Boolean}}}#noink_accessor_storage=false;get noink(){return this.#noink_accessor_storage}set noink(value){this.#noink_accessor_storage=value}rippleContainer=null;ripple_=null;updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("noink")&&this.hasRipple()){assert(this.ripple_);this.ripple_.noink=this.noink}}ensureRippleOnPointerdown(){this.addEventListener("pointerdown",(()=>this.ensureRipple()),{capture:true})}ensureRipple(){if(this.hasRipple()){return}this.ripple_=this.createRipple();this.ripple_.noink=this.noink;const rippleContainer=this.rippleContainer||this.shadowRoot;assert(rippleContainer);rippleContainer.appendChild(this.ripple_)}getRipple(){this.ensureRipple();assert(this.ripple_);return this.ripple_}hasRipple(){return Boolean(this.ripple_)}createRipple(){const ripple=document.createElement("cr-ripple");ripple.id="ink";return ripple}}return CrRippleMixin};let instance$N=null;function getCss$u(){return instance$N||(instance$N=[...[],css`:host{--cr-icon-button-fill-color:currentColor;--cr-icon-button-icon-start-offset:0;--cr-icon-button-icon-size:20px;--cr-icon-button-size:32px;--cr-icon-button-height:var(--cr-icon-button-size);--cr-icon-button-transition:150ms ease-in-out;--cr-icon-button-width:var(--cr-icon-button-size);-webkit-tap-highlight-color:transparent;border-radius:50%;color:var(--cr-icon-button-stroke-color,var(--cr-icon-button-fill-color));cursor:pointer;display:inline-flex;flex-shrink:0;height:var(--cr-icon-button-height);margin-inline-end:var(--cr-icon-button-margin-end,var(--cr-icon-ripple-margin));margin-inline-start:var(--cr-icon-button-margin-start);outline:none;overflow:hidden;position:relative;user-select:none;vertical-align:middle;width:var(--cr-icon-button-width)}:host(:hover){background-color:var(--cr-icon-button-hover-background-color,var(--cr-hover-background-color))}:host(:focus-visible:focus){box-shadow:inset 0 0 0 2px var(--cr-icon-button-focus-outline-color,var(--cr-focus-outline-color))}@media (forced-colors:active){:host(:focus-visible:focus){outline:var(--cr-focus-outline-hcm)}}#ink{--paper-ripple-opacity:1;color:var(--cr-icon-button-active-background-color,var(--cr-active-background-color))}:host([disabled]){cursor:initial;opacity:var(--cr-disabled-opacity);pointer-events:none}:host(.no-overlap){--cr-icon-button-margin-end:0;--cr-icon-button-margin-start:0}:host-context([dir=rtl]):host(:not([suppress-rtl-flip]):not([multiple-icons_])){transform:scaleX(-1)}:host-context([dir=rtl]):host(:not([suppress-rtl-flip])[multiple-icons_]) cr-icon{transform:scaleX(-1)}:host(:not([iron-icon])) #maskedImage{-webkit-mask-image:var(--cr-icon-image);-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-icon-button-icon-size);-webkit-transform:var(--cr-icon-image-transform,none);background-color:var(--cr-icon-button-fill-color);height:100%;transition:background-color var(--cr-icon-button-transition);width:100%}@media (forced-colors:active){:host(:not([iron-icon])) #maskedImage{background-color:ButtonText}}#icon{align-items:center;border-radius:4px;display:flex;height:100%;justify-content:center;padding-inline-start:var(--cr-icon-button-icon-start-offset);position:relative;width:100%}cr-icon{--iron-icon-fill-color:var(--cr-icon-button-fill-color);--iron-icon-stroke-color:var(--cr-icon-button-stroke-color,none);--iron-icon-height:var(--cr-icon-button-icon-size);--iron-icon-width:var(--cr-icon-button-icon-size);transition:fill var(--cr-icon-button-transition),stroke var(--cr-icon-button-transition)}@media (prefers-color-scheme:dark){:host{--cr-icon-button-fill-color:var(--google-grey-500)}}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$o(){return html`
<div id="icon">
  <div id="maskedImage"></div>
</div>`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrIconbuttonElementBase=CrRippleMixin(CrLitElement);class CrIconButtonElement extends CrIconbuttonElementBase{static get is(){return"cr-icon-button"}static get styles(){return getCss$u()}render(){return getHtml$o.bind(this)()}static get properties(){return{disabled:{type:Boolean,reflect:true},ironIcon:{type:String,reflect:true},suppressRtlFlip:{type:Boolean,value:false,reflect:true},multipleIcons_:{type:Boolean,reflect:true}}}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#ironIcon_accessor_storage;get ironIcon(){return this.#ironIcon_accessor_storage}set ironIcon(value){this.#ironIcon_accessor_storage=value}#multipleIcons__accessor_storage=false;get multipleIcons_(){return this.#multipleIcons__accessor_storage}set multipleIcons_(value){this.#multipleIcons__accessor_storage=value}spaceKeyDown_=false;constructor(){super();this.addEventListener("blur",this.onBlur_.bind(this));this.addEventListener("click",this.onClick_.bind(this));this.addEventListener("keydown",this.onKeyDown_.bind(this));this.addEventListener("keyup",this.onKeyUp_.bind(this));this.ensureRippleOnPointerdown()}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("ironIcon")){const icons=(this.ironIcon||"").split(",");this.multipleIcons_=icons.length>1}}firstUpdated(){if(!this.hasAttribute("role")){this.setAttribute("role","button")}if(!this.hasAttribute("tabindex")){this.setAttribute("tabindex","0")}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("disabled")){this.setAttribute("aria-disabled",this.disabled?"true":"false");this.disabledChanged_(this.disabled,changedProperties.get("disabled"))}if(changedProperties.has("ironIcon")){this.onIronIconChanged_()}}disabledChanged_(newValue,oldValue){if(!newValue&&oldValue===undefined){return}if(this.disabled){this.blur()}this.setAttribute("tabindex",String(this.disabled?-1:0))}onBlur_(){this.spaceKeyDown_=false}onClick_(e){if(this.disabled){e.stopImmediatePropagation()}}onIronIconChanged_(){this.shadowRoot.querySelectorAll("cr-icon").forEach((el=>el.remove()));if(!this.ironIcon){return}const icons=(this.ironIcon||"").split(",");icons.forEach((async icon=>{const crIcon=document.createElement("cr-icon");crIcon.icon=icon;this.$.icon.appendChild(crIcon);await crIcon.updateComplete;crIcon.shadowRoot.querySelectorAll("svg, img").forEach((child=>child.setAttribute("role","none")))}))}onKeyDown_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(e.repeat){return}if(e.key==="Enter"){this.click()}else if(e.key===" "){this.spaceKeyDown_=true}}onKeyUp_(e){if(e.key===" "||e.key==="Enter"){e.preventDefault();e.stopPropagation()}if(this.spaceKeyDown_&&e.key===" "){this.spaceKeyDown_=false;this.click()}}}customElements.define(CrIconButtonElement.is,CrIconButtonElement);let instance$M=null;function getCss$t(){return instance$M||(instance$M=[...[],css`:host{display:none}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$n(){return html`
<svg id="baseSvg" xmlns="http://www.w3.org/2000/svg"
     viewBox="0 0 ${this.size} ${this.size}"
     preserveAspectRatio="xMidYMid meet" focusable="false"
     style="pointer-events: none; display: block; width: 100%; height: 100%;">
 </svg>
<slot></slot>
`}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const APPLIED_ICON_CLASS="cr-iconset-svg-icon_";class CrIconsetElement extends CrLitElement{static get is(){return"cr-iconset"}static get styles(){return getCss$t()}render(){return getHtml$n.bind(this)()}static get properties(){return{name:{type:String},size:{type:Number}}}#name_accessor_storage="";get name(){return this.#name_accessor_storage}set name(value){this.#name_accessor_storage=value}#size_accessor_storage=24;get size(){return this.#size_accessor_storage}set size(value){this.#size_accessor_storage=value}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("name")){assert(changedProperties.get("name")===undefined);IconsetMap.getInstance().set(this.name,this)}}applyIcon(element,iconName){this.removeIcon(element);const svg=this.cloneIcon_(iconName);if(svg){svg.classList.add(APPLIED_ICON_CLASS);element.shadowRoot.insertBefore(svg,element.shadowRoot.childNodes[0]);return svg}return null}createIcon(iconName){return this.cloneIcon_(iconName)}removeIcon(element){const oldSvg=element.shadowRoot.querySelector(`.${APPLIED_ICON_CLASS}`);if(oldSvg){oldSvg.remove()}}cloneIcon_(id){const sourceSvg=this.querySelector(`g[id="${id}"]`);if(!sourceSvg){return null}const svgClone=this.$.baseSvg.cloneNode(true);const content=sourceSvg.cloneNode(true);content.removeAttribute("id");const contentViewBox=content.getAttribute("viewBox");if(contentViewBox){svgClone.setAttribute("viewBox",contentViewBox)}svgClone.appendChild(content);return svgClone}}customElements.define(CrIconsetElement.is,CrIconsetElement);
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function isValidArray(arr){if(arr instanceof Array&&Object.isFrozen(arr)){return true}return false}function getStaticString(literal){const isStaticString=isValidArray(literal)&&!!literal.raw&&isValidArray(literal.raw)&&literal.length===literal.raw.length&&literal.length===1;assert(isStaticString,"static_types.js only allows static strings");return literal.join("")}function createTypes(_ignore,literal){return getStaticString(literal)}const rules={createHTML:createTypes,createScript:createTypes,createScriptURL:createTypes};let staticPolicy;if(window.trustedTypes){staticPolicy=window.trustedTypes.createPolicy("static-types",rules)}else{staticPolicy=rules}function getTrustedHTML(literal){return staticPolicy.createHTML("",literal)}function getTrustedScriptURL(literal){return staticPolicy.createScriptURL("",literal)}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const div$3=document.createElement("div");div$3.innerHTML=getTrustedHTML`
<cr-iconset name="cr20" size="20">
  <svg>
    <defs>
      <!--
      Keep these in sorted order by id="".
      -->
      <g id="block">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M10 0C4.48 0 0 4.48 0 10C0 15.52 4.48 20 10 20C15.52 20 20 15.52 20 10C20 4.48 15.52 0 10 0ZM2 10C2 5.58 5.58 2 10 2C11.85 2 13.55 2.63 14.9 3.69L3.69 14.9C2.63 13.55 2 11.85 2 10ZM5.1 16.31C6.45 17.37 8.15 18 10 18C14.42 18 18 14.42 18 10C18 8.15 17.37 6.45 16.31 5.1L5.1 16.31Z">
        </path>
      </g>
      <g id="cloud-off">
        <path
          d="M16 18.125L13.875 16H5C3.88889 16 2.94444 15.6111 2.16667 14.8333C1.38889 14.0556 1 13.1111 1 12C1 10.9444 1.36111 10.0347 2.08333 9.27083C2.80556 8.50694 3.6875 8.09028 4.72917 8.02083C4.77083 7.86805 4.8125 7.72222 4.85417 7.58333C4.90972 7.44444 4.97222 7.30555 5.04167 7.16667L1.875 4L2.9375 2.9375L17.0625 17.0625L16 18.125ZM5 14.5H12.375L6.20833 8.33333C6.15278 8.51389 6.09722 8.70139 6.04167 8.89583C6 9.07639 5.95139 9.25694 5.89583 9.4375L4.83333 9.52083C4.16667 9.57639 3.61111 9.84028 3.16667 10.3125C2.72222 10.7708 2.5 11.3333 2.5 12C2.5 12.6944 2.74306 13.2847 3.22917 13.7708C3.71528 14.2569 4.30556 14.5 5 14.5ZM17.5 15.375L16.3958 14.2917C16.7153 14.125 16.9792 13.8819 17.1875 13.5625C17.3958 13.2431 17.5 12.8889 17.5 12.5C17.5 11.9444 17.3056 11.4722 16.9167 11.0833C16.5278 10.6944 16.0556 10.5 15.5 10.5H14.125L14 9.14583C13.9028 8.11806 13.4722 7.25694 12.7083 6.5625C11.9444 5.85417 11.0417 5.5 10 5.5C9.65278 5.5 9.31944 5.54167 9 5.625C8.69444 5.70833 8.39583 5.82639 8.10417 5.97917L7.02083 4.89583C7.46528 4.61806 7.93056 4.40278 8.41667 4.25C8.91667 4.08333 9.44444 4 10 4C11.4306 4 12.6736 4.48611 13.7292 5.45833C14.7847 6.41667 15.375 7.59722 15.5 9C16.4722 9 17.2986 9.34028 17.9792 10.0208C18.6597 10.7014 19 11.5278 19 12.5C19 13.0972 18.8611 13.6458 18.5833 14.1458C18.3194 14.6458 17.9583 15.0556 17.5 15.375Z">
        </path>
      </g>
      <g id="delete">
        <path
          d="M 5.832031 17.5 C 5.375 17.5 4.984375 17.335938 4.65625 17.011719 C 4.328125 16.683594 4.167969 16.292969 4.167969 15.832031 L 4.167969 5 L 3.332031 5 L 3.332031 3.332031 L 7.5 3.332031 L 7.5 2.5 L 12.5 2.5 L 12.5 3.332031 L 16.667969 3.332031 L 16.667969 5 L 15.832031 5 L 15.832031 15.832031 C 15.832031 16.292969 15.671875 16.683594 15.34375 17.011719 C 15.015625 17.335938 14.625 17.5 14.167969 17.5 Z M 14.167969 5 L 5.832031 5 L 5.832031 15.832031 L 14.167969 15.832031 Z M 7.5 14.167969 L 9.167969 14.167969 L 9.167969 6.667969 L 7.5 6.667969 Z M 10.832031 14.167969 L 12.5 14.167969 L 12.5 6.667969 L 10.832031 6.667969 Z M 5.832031 5 L 5.832031 15.832031 Z M 5.832031 5 ">
        </path>
      </g>
      <g id="domain" viewBox="0 -960 960 960">
        <path d="M96-144v-672h384v144h384v528H96Zm72-72h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm168 456h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm144 456h312v-384H480v80h72v72h-72v80h72v72h-72v80Zm168-232v-72h72v72h-72Zm0 152v-72h72v72h-72Z"></path>
      </g>
      <g id="kite">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M4.6327 8.00094L10.3199 2L16 8.00094L10.1848 16.8673C10.0995 16.9873 10.0071 17.1074 9.90047 17.2199C9.42417 17.7225 8.79147 18 8.11611 18C7.44076 18 6.80806 17.7225 6.33175 17.2199C5.85545 16.7173 5.59242 16.0497 5.59242 15.3371C5.59242 14.977 5.46445 14.647 5.22275 14.3919C4.98104 14.1369 4.66825 14.0019 4.32701 14.0019H4V12.6667H4.32701C5.00237 12.6667 5.63507 12.9442 6.11137 13.4468C6.58768 13.9494 6.85071 14.617 6.85071 15.3296C6.85071 15.6896 6.97867 16.0197 7.22038 16.2747C7.46209 16.5298 7.77488 16.6648 8.11611 16.6648C8.45735 16.6648 8.77014 16.5223 9.01185 16.2747C9.02396 16.2601 9.03607 16.246 9.04808 16.2319C9.08541 16.1883 9.12176 16.1458 9.15403 16.0947L9.55213 15.4946L4.6327 8.00094ZM10.3199 13.9371L6.53802 8.17116L10.3199 4.1814L14.0963 8.17103L10.3199 13.9371Z">
        </path>
      </g>
      <g id="menu">
        <path d="M2 4h16v2H2zM2 9h16v2H2zM2 14h16v2H2z"></path>
      </g>
      <g id="password">
        <path d="M5.833 11.667c.458 0 .847-.16 1.167-.479.333-.333.5-.729.5-1.188s-.167-.847-.5-1.167a1.555 1.555 0 0 0-1.167-.5c-.458 0-.854.167-1.188.5A1.588 1.588 0 0 0 4.166 10c0 .458.16.854.479 1.188.333.319.729.479 1.188.479Zm0 3.333c-1.389 0-2.569-.486-3.542-1.458C1.319 12.569.833 11.389.833 10c0-1.389.486-2.569 1.458-3.542C3.264 5.486 4.444 5 5.833 5c.944 0 1.813.243 2.604.729a4.752 4.752 0 0 1 1.833 1.979h7.23c.458 0 .847.167 1.167.5.333.319.5.708.5 1.167v3.958c0 .458-.167.854-.5 1.188A1.588 1.588 0 0 1 17.5 15h-3.75a1.658 1.658 0 0 1-1.188-.479 1.658 1.658 0 0 1-.479-1.188v-1.042H10.27a4.59 4.59 0 0 1-1.813 2A5.1 5.1 0 0 1 5.833 15Zm3.292-4.375h4.625v2.708H15v-1.042a.592.592 0 0 1 .167-.438.623.623 0 0 1 .458-.188c.181 0 .327.063.438.188a.558.558 0 0 1 .188.438v1.042H17.5V9.375H9.125a3.312 3.312 0 0 0-1.167-1.938 3.203 3.203 0 0 0-2.125-.77 3.21 3.21 0 0 0-2.354.979C2.827 8.298 2.5 9.083 2.5 10s.327 1.702.979 2.354a3.21 3.21 0 0 0 2.354.979c.806 0 1.514-.25 2.125-.75.611-.514 1-1.167 1.167-1.958Z"></path>
      </g>
      
  </svg>
</cr-iconset>

<!-- NOTE: In the common case that the final icon will be 20x20, export the SVG
     at 20px and place it in the section above. -->
<cr-iconset name="cr" size="24">
  <svg>
    <defs>
      <!--
      These icons are copied from Polymer's iron-icons and kept in sorted order.
      -->
      <g id="add">
        <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z" />
      </g>
      <g id="arrow-back">
        <path
          d="m7.824 13 5.602 5.602L12 20l-8-8 8-8 1.426 1.398L7.824 11H20v2Zm0 0">
        </path>
      </g>
      <g id="arrow-drop-up">
        <path d="M7 14l5-5 5 5z"></path>
      </g>
      <g id="arrow-drop-down">
        <path d="M7 10l5 5 5-5z"></path>
      </g>
      <g id="arrow-forward">
        <path
          d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z">
        </path>
      </g>
      <g id="arrow-right">
        <path d="M10 7l5 5-5 5z"></path>
      </g>
      <g id="cancel">
        <path
          d="M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm5 13.59L15.59 17 12 13.41 8.41 17 7 15.59 10.59 12 7 8.41 8.41 7 12 10.59 15.59 7 17 8.41 13.41 12 17 15.59z">
        </path>
      </g>
      <g id="check">
        <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"></path>
      </g>
      <g id="check-circle" viewBox="0 -960 960 960">
        <path d="m424-296 282-282-56-56-226 226-114-114-56 56 170 170Zm56 216q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880q83 0 156 31.5T763-763q54 54 85.5 127T880-480q0 83-31.5 156T763-197q-54 54-127 85.5T480-80Zm0-80q134 0 227-93t93-227q0-134-93-227t-227-93q-134 0-227 93t-93 227q0 134 93 227t227 93Zm0-320Z"></path>
      </g>
      <g id="chevron-left">
        <path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"></path>
      </g>
      <g id="chevron-right">
        <path d="M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z"></path>
      </g>
      <g id="clear">
        <path
          d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z">
        </path>
      </g>
      <g id="chrome-product" viewBox="0 -960 960 960">
        <path d="M336-479q0 60 42 102t102 42q60 0 102-42t42-102q0-60-42-102t-102-42q-60 0-102 42t-42 102Zm144 216q11 0 22.5-.5T525-267L427-99q-144-16-237.5-125T96-479q0-43 9.5-84.5T134-645l160 274q28 51 78 79.5T480-263Zm0-432q-71 0-126.5 42T276-545l-98-170q53-71 132.5-109.5T480-863q95 0 179 45t138 123H480Zm356 72q15 35 21.5 71t6.5 73q0 155-100 260.5T509-96l157-275q14-25 22-52t8-56q0-40-15-77t-41-67h196Z">
        </path>
      </g>
      <g id="close">
        <path
          d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z">
        </path>
      </g>
      <g id="computer">
        <path
          d="M20 18c1.1 0 1.99-.9 1.99-2L22 6c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2H0v2h24v-2h-4zM4 6h16v10H4V6z">
        </path>
      </g>
      <g id="create">
        <path
          d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z">
        </path>
      </g>
      <g id="delete" viewBox="0 -960 960 960">
        <path
          d="M309.37-135.87q-34.48 0-58.74-24.26-24.26-24.26-24.26-58.74v-474.5h-53.5v-83H378.5v-53.5h202.52v53.5h206.11v83h-53.5v474.07q0 35.21-24.26 59.32t-58.74 24.11H309.37Zm341.26-557.5H309.37v474.5h341.26v-474.5ZM379.7-288.24h77.5v-336h-77.5v336Zm123.1 0h77.5v-336h-77.5v336ZM309.37-693.37v474.5-474.5Z">
        </path>
      </g>
      <g id="domain">
        <path
          d="M12 7V3H2v18h20V7H12zM6 19H4v-2h2v2zm0-4H4v-2h2v2zm0-4H4V9h2v2zm0-4H4V5h2v2zm4 12H8v-2h2v2zm0-4H8v-2h2v2zm0-4H8V9h2v2zm0-4H8V5h2v2zm10 12h-8v-2h2v-2h-2v-2h2v-2h-2V9h8v10zm-2-8h-2v2h2v-2zm0 4h-2v2h2v-2z">
        </path>
      </g>
      <!-- source: https://fonts.google.com/icons?selected=Material+Symbols+Outlined:family_link:FILL@0;wght@0;GRAD@0;opsz@24&icon.size=24&icon.color=%23e8eaed -->
      <g id="kite" viewBox="0 -960 960 960">
        <path
          d="M390-40q-51 0-90.5-30.5T246-149q-6-23-25-37t-43-14q-16 0-30 6.5T124-175l-61-51q21-26 51.5-40t63.5-14q51 0 91 30t54 79q6 23 25 37t42 14q19 0 34-10t26-25l1-2-276-381q-8-11-11.5-23t-3.5-24q0-16 6-30.5t18-26.5l260-255q11-11 26-17t30-6q15 0 30 6t26 17l260 255q12 12 18 26.5t6 30.5q0 12-3.5 24T825-538L500-88q-18 25-48 36.5T390-40Zm110-185 260-360-260-255-259 256 259 359Zm1-308Z"/>
        </path>
      </g>
      <g id="error">
        <path
          d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z">
        </path>
      </g>
      <g id="error-outline">
        <path
          d="M11 15h2v2h-2zm0-8h2v6h-2zm.99-5C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z">
        </path>
      </g>
      <g id="expand-less">
        <path d="M12 8l-6 6 1.41 1.41L12 10.83l4.59 4.58L18 14z"></path>
      </g>
      <g id="expand-more">
        <path d="M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6z"></path>
      </g>
      <g id="extension">
        <path
          d="M20.5 11H19V7c0-1.1-.9-2-2-2h-4V3.5C13 2.12 11.88 1 10.5 1S8 2.12 8 3.5V5H4c-1.1 0-1.99.9-1.99 2v3.8H3.5c1.49 0 2.7 1.21 2.7 2.7s-1.21 2.7-2.7 2.7H2V20c0 1.1.9 2 2 2h3.8v-1.5c0-1.49 1.21-2.7 2.7-2.7 1.49 0 2.7 1.21 2.7 2.7V22H17c1.1 0 2-.9 2-2v-4h1.5c1.38 0 2.5-1.12 2.5-2.5S21.88 11 20.5 11z">
        </path>
      </g>
      <g id="file-download" viewBox="0 -960 960 960">
        <path d="M480-336 288-528l51-51 105 105v-342h72v342l105-105 51 51-192 192ZM263.72-192Q234-192 213-213.15T192-264v-72h72v72h432v-72h72v72q0 29.7-21.16 50.85Q725.68-192 695.96-192H263.72Z"></path>
      </g>
      <g id="fullscreen">
        <path
          d="M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z">
        </path>
      </g>
      <g id="group">
        <path
          d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5c-1.66 0-3 1.34-3 3s1.34 3 3 3zm-8 0c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5C6.34 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5c0-2.33-4.67-3.5-7-3.5zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z">
        </path>
      </g>
      <g id="help-outline">
        <path
          d="M11 18h2v-2h-2v2zm1-16C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm0-14c-2.21 0-4 1.79-4 4h2c0-1.1.9-2 2-2s2 .9 2 2c0 2-3 1.75-3 5h2c0-2.25 3-2.5 3-5 0-2.21-1.79-4-4-4z">
        </path>
      </g>
      <g id="history">
        <path
          d="M12.945312 22.75 C 10.320312 22.75 8.074219 21.839844 6.207031 20.019531 C 4.335938 18.199219 3.359375 15.972656 3.269531 13.34375 L 5.089844 13.34375 C 5.175781 15.472656 5.972656 17.273438 7.480469 18.742188 C 8.988281 20.210938 10.808594 20.945312 12.945312 20.945312 C 15.179688 20.945312 17.070312 20.164062 18.621094 18.601562 C 20.167969 17.039062 20.945312 15.144531 20.945312 12.910156 C 20.945312 10.714844 20.164062 8.855469 18.601562 7.335938 C 17.039062 5.816406 15.15625 5.054688 12.945312 5.054688 C 11.710938 5.054688 10.554688 5.339844 9.480469 5.902344 C 8.402344 6.46875 7.476562 7.226562 6.699219 8.179688 L 9.585938 8.179688 L 9.585938 9.984375 L 3.648438 9.984375 L 3.648438 4.0625 L 5.453125 4.0625 L 5.453125 6.824219 C 6.386719 5.707031 7.503906 4.828125 8.804688 4.199219 C 10.109375 3.566406 11.488281 3.25 12.945312 3.25 C 14.300781 3.25 15.570312 3.503906 16.761719 4.011719 C 17.949219 4.519531 18.988281 5.214844 19.875 6.089844 C 20.761719 6.964844 21.464844 7.992188 21.976562 9.167969 C 22.492188 10.34375 22.75 11.609375 22.75 12.964844 C 22.75 14.316406 22.492188 15.589844 21.976562 16.777344 C 21.464844 17.964844 20.761719 19.003906 19.875 19.882812 C 18.988281 20.765625 17.949219 21.464844 16.761719 21.976562 C 15.570312 22.492188 14.300781 22.75 12.945312 22.75 Z M 16.269531 17.460938 L 12.117188 13.34375 L 12.117188 7.527344 L 13.921875 7.527344 L 13.921875 12.601562 L 17.550781 16.179688 Z M 16.269531 17.460938">
        </path>
      </g>
      <g id="info">
        <path
          d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z">
        </path>
      </g>
      <g id="info-outline">
        <path
          d="M11 17h2v-6h-2v6zm1-15C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zM11 9h2V7h-2v2z">
        </path>
      </g>
      <g id="insert-drive-file">
        <path
          d="M6 2c-1.1 0-1.99.9-1.99 2L4 20c0 1.1.89 2 1.99 2H18c1.1 0 2-.9 2-2V8l-6-6H6zm7 7V3.5L18.5 9H13z">
        </path>
      </g>
      <g id="location-on">
        <path
          d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z">
        </path>
      </g>
      <g id="mic">
        <path
          d="M12 14c1.66 0 2.99-1.34 2.99-3L15 5c0-1.66-1.34-3-3-3S9 3.34 9 5v6c0 1.66 1.34 3 3 3zm5.3-3c0 3-2.54 5.1-5.3 5.1S6.7 14 6.7 11H5c0 3.41 2.72 6.23 6 6.72V21h2v-3.28c3.28-.48 6-3.3 6-6.72h-1.7z">
        </path>
      </g>
      <g id="more-vert">
        <path
          d="M12 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z">
        </path>
      </g>
      <g id="open-in-new" viewBox="0 -960 960 960">
        <path
          d="M216-144q-29.7 0-50.85-21.15Q144-186.3 144-216v-528q0-29.7 21.15-50.85Q186.3-816 216-816h264v72H216v528h528v-264h72v264q0 29.7-21.15 50.85Q773.7-144 744-144H216Zm171-192-51-51 357-357H576v-72h240v240h-72v-117L387-336Z">
        </path>
      </g>
      <g id="person">
        <path
          d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z">
        </path>
      </g>
      <g id="phonelink">
        <path
          d="M4 6h18V4H4c-1.1 0-2 .9-2 2v11H0v3h14v-3H4V6zm19 2h-6c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h6c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1zm-1 9h-4v-7h4v7z">
        </path>
      </g>
      <g id="print">
        <path
          d="M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z">
        </path>
      </g>
      <g id="schedule">
        <path
          d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z">
        </path>
      </g>
      <g id="search">
        <path
          d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z">
        </path>
      </g>
      <g id="security">
        <path
          d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 10.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11v8.8z">
        </path>
      </g>
      <!-- The <g> IDs are exposed as global variables in Vulcanized mode, which
        conflicts with the "settings" namespace of MD Settings. Using an "_icon"
        suffix prevents the naming conflict. -->
      <g id="settings_icon">
        <path
          d="M19.43 12.98c.04-.32.07-.64.07-.98s-.03-.66-.07-.98l2.11-1.65c.19-.15.24-.42.12-.64l-2-3.46c-.12-.22-.39-.3-.61-.22l-2.49 1c-.52-.4-1.08-.73-1.69-.98l-.38-2.65C14.46 2.18 14.25 2 14 2h-4c-.25 0-.46.18-.49.42l-.38 2.65c-.61.25-1.17.59-1.69.98l-2.49-1c-.23-.09-.49 0-.61.22l-2 3.46c-.13.22-.07.49.12.64l2.11 1.65c-.04.32-.07.65-.07.98s.03.66.07.98l-2.11 1.65c-.19.15-.24.42-.12.64l2 3.46c.12.22.39.3.61.22l2.49-1c.52.4 1.08.73 1.69.98l.38 2.65c.03.24.24.42.49.42h4c.25 0 .46-.18.49-.42l.38-2.65c.61-.25 1.17-.59 1.69-.98l2.49 1c.23.09.49 0 .61-.22l2-3.46c.12-.22.07-.49-.12-.64l-2.11-1.65zM12 15.5c-1.93 0-3.5-1.57-3.5-3.5s1.57-3.5 3.5-3.5 3.5 1.57 3.5 3.5-1.57 3.5-3.5 3.5z">
        </path>
      </g>
      <g id="star">
        <path
          d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z">
        </path>
      </g>
      <g id="sync" viewBox="0 -960 960 960">
        <path
          d="M216-192v-72h74q-45-40-71.5-95.5T192-480q0-101 61-177.5T408-758v75q-63 23-103.5 77.5T264-480q0 48 19.5 89t52.5 70v-63h72v192H216Zm336-10v-75q63-23 103.5-77.5T696-480q0-48-19.5-89T624-639v63h-72v-192h192v72h-74q45 40 71.5 95.5T768-480q0 101-61 177.5T552-202Z">
        </path>
      </g>
      <g id="thumbs-down">
        <path
            d="M6 3h11v13l-7 7-1.25-1.25a1.454 1.454 0 0 1-.3-.475c-.067-.2-.1-.392-.1-.575v-.35L9.45 16H3c-.533 0-1-.2-1.4-.6-.4-.4-.6-.867-.6-1.4v-2c0-.117.017-.242.05-.375s.067-.258.1-.375l3-7.05c.15-.333.4-.617.75-.85C5.25 3.117 5.617 3 6 3Zm9 2H6l-3 7v2h9l-1.35 5.5L15 15.15V5Zm0 10.15V5v10.15Zm2 .85v-2h3V5h-3V3h5v13h-5Z">
        </path>
      </g>
      <g id="thumbs-down-filled">
        <path
            d="M6 3h10v13l-7 7-1.25-1.25a1.336 1.336 0 0 1-.29-.477 1.66 1.66 0 0 1-.108-.574v-.347L8.449 16H3c-.535 0-1-.2-1.398-.602C1.199 15 1 14.535 1 14v-2c0-.117.012-.242.04-.375.022-.133.062-.258.108-.375l3-7.05c.153-.333.403-.618.75-.848A1.957 1.957 0 0 1 6 3Zm12 13V3h4v13Zm0 0">
        </path>
      </g>
      <g id="thumbs-up">
        <path
            d="M18 21H7V8l7-7 1.25 1.25c.117.117.208.275.275.475.083.2.125.392.125.575v.35L14.55 8H21c.533 0 1 .2 1.4.6.4.4.6.867.6 1.4v2c0 .117-.017.242-.05.375s-.067.258-.1.375l-3 7.05c-.15.333-.4.617-.75.85-.35.233-.717.35-1.1.35Zm-9-2h9l3-7v-2h-9l1.35-5.5L9 8.85V19ZM9 8.85V19 8.85ZM7 8v2H4v9h3v2H2V8h5Z">
        </path>
      </g>
      <g id="thumbs-up-filled">
        <path
            d="M18 21H8V8l7-7 1.25 1.25c.117.117.21.273.29.477.073.199.108.39.108.574v.347L15.551 8H21c.535 0 1 .2 1.398.602C22.801 9 23 9.465 23 10v2c0 .117-.012.242-.04.375a1.897 1.897 0 0 1-.108.375l-3 7.05a2.037 2.037 0 0 1-.75.848A1.957 1.957 0 0 1 18 21ZM6 8v13H2V8Zm0 0">
      </g>
      <g id="videocam" viewBox="0 -960 960 960">
        <path
          d="M216-192q-29 0-50.5-21.5T144-264v-432q0-29.7 21.5-50.85Q187-768 216-768h432q29.7 0 50.85 21.15Q720-725.7 720-696v168l144-144v384L720-432v168q0 29-21.15 50.5T648-192H216Zm0-72h432v-432H216v432Zm0 0v-432 432Z">
        </path>
      </g>
      <g id="warning">
        <path d="M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"></path>
      </g>
    </defs>
  </svg>
</cr-iconset>`;const iconsets$3=div$3.querySelectorAll("cr-iconset");for(const iconset of iconsets$3){document.head.appendChild(iconset)}
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrSearchFieldMixinLit=superClass=>{class CrSearchFieldMixinLit extends superClass{static get properties(){return{label:{type:String},clearLabel:{type:String},hasSearchText:{type:Boolean,reflect:true}}}#label_accessor_storage="";get label(){return this.#label_accessor_storage}set label(value){this.#label_accessor_storage=value}#clearLabel_accessor_storage="";get clearLabel(){return this.#clearLabel_accessor_storage}set clearLabel(value){this.#clearLabel_accessor_storage=value}#hasSearchText_accessor_storage=false;get hasSearchText(){return this.#hasSearchText_accessor_storage}set hasSearchText(value){this.#hasSearchText_accessor_storage=value}effectiveValue_="";searchDelayTimer_=-1;getSearchInput(){assertNotReached()}getValue(){return this.getSearchInput().value}setValue(value,noEvent){const updated=this.updateEffectiveValue_(value);this.getSearchInput().value=this.effectiveValue_;if(!updated){if(value===""&&this.hasSearchText){this.hasSearchText=false}return}this.onSearchTermInput();if(!noEvent){this.fire("search-changed",this.effectiveValue_)}}scheduleSearch_(){if(this.searchDelayTimer_>=0){clearTimeout(this.searchDelayTimer_)}const length=this.getValue().length;const timeoutMs=length>0?500-100*(Math.min(length,4)-1):0;this.searchDelayTimer_=setTimeout((()=>{this.getSearchInput().dispatchEvent(new CustomEvent("search",{composed:true,detail:this.getValue()}));this.searchDelayTimer_=-1}),timeoutMs)}onSearchTermSearch(){this.onValueChanged_(this.getValue(),false)}onSearchTermInput(){this.hasSearchText=this.getSearchInput().value!=="";this.scheduleSearch_()}onValueChanged_(newValue,noEvent){const updated=this.updateEffectiveValue_(newValue);if(updated&&!noEvent){this.fire("search-changed",this.effectiveValue_)}}updateEffectiveValue_(value){const effectiveValue=value.replace(/\s+/g," ").replace(/^\s/,"");if(effectiveValue===this.effectiveValue_){return false}this.effectiveValue_=effectiveValue;return true}}return CrSearchFieldMixinLit};let instance$L=null;function getCss$s(){return instance$L||(instance$L=[...[],css`.icon-arrow-back{--cr-icon-image:url(//resources/images/icon_arrow_back.svg)}.icon-arrow-dropdown{--cr-icon-image:url(//resources/images/icon_arrow_dropdown.svg)}.icon-arrow-drop-down-cr23{--cr-icon-image:url(//resources/images/icon_arrow_drop_down_cr23.svg)}.icon-arrow-drop-up-cr23{--cr-icon-image:url(//resources/images/icon_arrow_drop_up_cr23.svg)}.icon-arrow-upward{--cr-icon-image:url(//resources/images/icon_arrow_upward.svg)}.icon-cancel{--cr-icon-image:url(//resources/images/icon_cancel.svg)}.icon-clear{--cr-icon-image:url(//resources/images/icon_clear.svg)}.icon-copy-content{--cr-icon-image:url(//resources/images/icon_copy_content.svg)}.icon-delete-gray{--cr-icon-image:url(//resources/images/icon_delete_gray.svg)}.icon-edit{--cr-icon-image:url(//resources/images/icon_edit.svg)}.icon-file{--cr-icon-image:url(//resources/images/icon_filetype_generic.svg)}.icon-folder-open{--cr-icon-image:url(//resources/images/icon_folder_open.svg)}.icon-picture-delete{--cr-icon-image:url(//resources/images/icon_picture_delete.svg)}.icon-expand-less{--cr-icon-image:url(//resources/images/icon_expand_less.svg)}.icon-expand-more{--cr-icon-image:url(//resources/images/icon_expand_more.svg)}.icon-external{--cr-icon-image:url(//resources/images/open_in_new.svg)}.icon-more-vert{--cr-icon-image:url(//resources/images/icon_more_vert.svg)}.icon-refresh{--cr-icon-image:url(//resources/images/icon_refresh.svg)}.icon-search{--cr-icon-image:url(//resources/images/icon_search.svg)}.icon-settings{--cr-icon-image:url(//resources/images/icon_settings.svg)}.icon-visibility{--cr-icon-image:url(//resources/images/icon_visibility.svg)}.icon-visibility-off{--cr-icon-image:url(//resources/images/icon_visibility_off.svg)}.subpage-arrow{--cr-icon-image:url(//resources/images/arrow_right.svg)}.cr-icon{-webkit-mask-image:var(--cr-icon-image);-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-icon-size);background-color:var(--cr-icon-color,var(--owl-control-accent-color,var(--google-grey-700)));flex-shrink:0;height:var(--cr-icon-ripple-size);margin-inline-end:var(--cr-icon-ripple-margin);margin-inline-start:var(--cr-icon-button-margin-start);user-select:none;width:var(--cr-icon-ripple-size)}:host-context([dir=rtl]) .cr-icon{transform:scaleX(-1)}.cr-icon.no-overlap{margin-inline-end:0;margin-inline-start:0}@media (prefers-color-scheme:dark){.cr-icon{background-color:var(--cr-icon-color,var(--owl-control-accent-color,var(--google-grey-500)))}}`])}let instance$K=null;function getCss$r(){return instance$K||(instance$K=[...[getCss$x(),getCss$s()],css`[actionable]{cursor:pointer}.hr{border-top:var(--cr-separator-line)}iron-list.cr-separators>*:not([first]){border-top:var(--cr-separator-line)}[scrollable]{border-color:transparent;border-style:solid;border-width:1px 0;overflow-y:auto}[scrollable].is-scrolled{border-top-color:var(--cr-scrollable-border-color)}[scrollable].can-scroll:not(.scrolled-to-bottom){border-bottom-color:var(--cr-scrollable-border-color)}[scrollable] iron-list>:not(.no-outline):focus-visible,[selectable]:focus-visible,[selectable]>:focus-visible{outline:solid 2px var(--cr-focus-outline-color);outline-offset:-2px}.scroll-container{display:flex;flex-direction:column;min-height:1px}[selectable]>*{cursor:pointer}.cr-centered-card-container{box-sizing:border-box;display:block;height:inherit;margin:0 auto;max-width:var(--cr-centered-card-max-width);min-width:550px;position:relative;width:calc(100% * var(--cr-centered-card-width-percentage))}.cr-container-shadow{height:var(--cr-container-shadow-height);left:0;margin:0 0 var(--cr-container-shadow-margin);opacity:0;pointer-events:none;position:relative;right:0;top:0;transition:opacity 500ms;z-index:1}#cr-container-shadow-bottom{margin-bottom:0;margin-top:var(--cr-container-shadow-margin);transform:scaleY(-1)}#cr-container-shadow-top:has(+#container.can-scroll:not(.scrolled-to-top)),#container.can-scroll:not(.scrolled-to-bottom)+#cr-container-shadow-bottom,#cr-container-shadow-bottom.force-shadow,#cr-container-shadow-top.force-shadow{opacity:var(--cr-container-shadow-max-opacity)}.cr-row{align-items:center;border-top:var(--cr-separator-line);display:flex;min-height:var(--cr-section-min-height);padding:0 var(--cr-section-padding)}.cr-row.first,.cr-row.continuation{border-top:none}.cr-row-gap{padding-inline-start:16px}.cr-button-gap{margin-inline-start:8px}paper-tooltip::part(tooltip),cr-tooltip::part(tooltip){border-radius:var(--paper-tooltip-border-radius,2px);font-size:92.31%;font-weight:500;max-width:330px;min-width:var(--paper-tooltip-min-width,200px);padding:var(--paper-tooltip-padding,10px 8px)}.cr-padded-text{padding-block-end:var(--cr-section-vertical-padding);padding-block-start:var(--cr-section-vertical-padding)}.cr-title-text{color:var(--cr-title-text-color);font-size:107.6923%;font-weight:500}.cr-secondary-text{color:var(--cr-secondary-text-color);font-weight:400}.cr-form-field-label{color:var(--cr-form-field-label-color);display:block;font-size:var(--cr-form-field-label-font-size);font-weight:500;letter-spacing:.4px;line-height:var(--cr-form-field-label-line-height);margin-bottom:8px}.cr-vertical-tab{align-items:center;display:flex}.cr-vertical-tab::before{border-radius:0 3px 3px 0;content:'';display:block;flex-shrink:0;height:var(--cr-vertical-tab-height,100%);width:4px}.cr-vertical-tab.selected::before{background:var(--cr-vertical-tab-selected-color,var(--cr-checked-color))}:host-context([dir=rtl]) .cr-vertical-tab::before{transform:scaleX(-1)}.iph-anchor-highlight{background-color:var(--cr-iph-anchor-highlight-color)}`])}
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class PromiseResolver{resolve_=()=>{};reject_=()=>{};isFulfilled_=false;promise_;constructor(){this.promise_=new Promise(((resolve,reject)=>{this.resolve_=resolution=>{resolve(resolution);this.isFulfilled_=true};this.reject_=reason=>{reject(reason);this.isFulfilled_=true}}))}get isFulfilled(){return this.isFulfilled_}get promise(){return this.promise_}get resolve(){return this.resolve_}get reject(){return this.reject_}}
// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class CrSettingsPrefsInternal{isInitialized=false;deferInitialization;initializedResolver_=new PromiseResolver;constructor(){this.deferInitialization=false}get initialized(){return this.initializedResolver_.promise}setInitialized(){this.isInitialized=true;this.initializedResolver_.resolve()}resetForTesting(){this.isInitialized=false;this.initializedResolver_=new PromiseResolver}}const CrSettingsPrefs=new CrSettingsPrefsInternal;
/* Copyright 2015 The Chromium Authors
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file. */function deepEqual(val1,val2){if(val1===val2){return true}if(Array.isArray(val1)||Array.isArray(val2)){if(!Array.isArray(val1)||!Array.isArray(val2)){return false}return arraysEqual(val1,val2)}if(val1 instanceof Object&&val2 instanceof Object){return objectsEqual(val1,val2)}return false}function arraysEqual(arr1,arr2){if(arr1.length!==arr2.length){return false}for(let i=0;i<arr1.length;i++){if(!deepEqual(arr1[i],arr2[i])){return false}}return true}function objectsEqual(obj1,obj2){const keys1=Object.keys(obj1);const keys2=Object.keys(obj2);if(keys1.length!==keys2.length){return false}for(let i=0;i<keys1.length;i++){const key=keys1[i];if(!deepEqual(obj1[key],obj2[key])){return false}}return true}class SettingsPrefsElement extends PolymerElement{static get is(){return"settings-prefs"}static get properties(){return{prefs:{type:Object,notify:true}}}static get observers(){return["prefsChanged_(prefs.*)"]}lastPrefValues_=new Map;settingsApi_=chrome.settingsPrivate;initialized_=false;boundPrefsChanged_;constructor(){super();if(!CrSettingsPrefs.deferInitialization){this.initialize()}}disconnectedCallback(){super.disconnectedCallback();CrSettingsPrefs.resetForTesting()}initialize(settingsApi){if(this.initialized_){return}this.initialized_=true;if(settingsApi){this.settingsApi_=settingsApi}this.boundPrefsChanged_=this.onSettingsPrivatePrefsChanged_.bind(this);this.settingsApi_.onPrefsChanged.addListener(this.boundPrefsChanged_);this.settingsApi_.getAllPrefs().then((prefs=>{this.updatePrefs_(prefs);CrSettingsPrefs.setInitialized()}))}prefsChanged_(e){if(!CrSettingsPrefs.isInitialized||e.path==="prefs"){return}const key=this.getPrefKeyFromPath_(e.path);const prefStoreValue=this.lastPrefValues_.get(key);const prefObj=this.get(key,this.prefs);if(!deepEqual(prefStoreValue,prefObj.value)){this.settingsApi_.setPref(key,prefObj.value,"").then((success=>{if(!success){this.refresh(key)}}))}}onSettingsPrivatePrefsChanged_(prefs){if(CrSettingsPrefs.isInitialized){this.updatePrefs_(prefs)}}refresh(key){this.settingsApi_.getPref(key).then((pref=>{this.updatePrefs_([pref])}))}updatePrefPath_(path,value,prefsObject){const parts=path.split(".");let cur=prefsObject;for(let part;parts.length&&(part=parts.shift());){if(!parts.length){cur[part]=value}else if(part in cur){cur=cur[part]}else{cur=cur[part]={}}}}updatePrefs_(newPrefs){const prefs=this.prefs||{};newPrefs.forEach((newPrefObj=>{this.lastPrefValues_.set(newPrefObj.key,structuredClone(newPrefObj.value));if(!deepEqual(this.get(newPrefObj.key,prefs),newPrefObj)){this.updatePrefPath_(newPrefObj.key,newPrefObj,prefs);if(prefs===this.prefs){this.notifyPath("prefs."+newPrefObj.key,newPrefObj)}}}));if(!this.prefs){this.prefs=prefs}}getPrefKeyFromPath_(path){const parts=path.split(".");assert(parts.shift()==="prefs","Path doesn't begin with 'prefs'");for(let i=1;i<=parts.length;i++){const key=parts.slice(0,i).join(".");if(this.lastPrefValues_.has(key)){return key}}return""}resetForTesting(){if(!this.initialized_){return}this.prefs=undefined;this.lastPrefValues_.clear();this.initialized_=false;this.settingsApi_.onPrefsChanged.removeListener(this.boundPrefsChanged_);this.settingsApi_=chrome.settingsPrivate}}customElements.define(SettingsPrefsElement.is,SettingsPrefsElement);const div$2=document.createElement("div");div$2.innerHTML=getTrustedHTML`<!--
List icons here rather than importing large sets of (e.g. Polymer) icons.
Keep in alphabetical ordering.
NOTE: Chrome OS icons go in ./chromeos/os_icons.html.
-->
<cr-iconset name="settings20" size="20">
  <svg>
    <defs>
      <g id="account-box"><path d="M4.5 14.3958C5.27778 13.7569 6.13889 13.2847 7.08333 12.9792C8.02778 12.6597 9 12.5 10 12.5C11 12.5 11.9722 12.6528 12.9167 12.9583C13.8611 13.2639 14.7222 13.7431 15.5 14.3958V4.5H4.5V14.3958ZM10 11.5C10.8333 11.5 11.5417 11.2083 12.125 10.625C12.7083 10.0417 13 9.33333 13 8.5C13 7.66667 12.7083 6.95833 12.125 6.375C11.5417 5.79167 10.8333 5.5 10 5.5C9.16667 5.5 8.45833 5.79167 7.875 6.375C7.29167 6.95833 7 7.66667 7 8.5C7 9.33333 7.29167 10.0417 7.875 10.625C8.45833 11.2083 9.16667 11.5 10 11.5ZM4.5 17C4.08333 17 3.72917 16.8542 3.4375 16.5625C3.14583 16.2708 3 15.9167 3 15.5V4.5C3 4.08333 3.14583 3.72917 3.4375 3.4375C3.72917 3.14583 4.08333 3 4.5 3H15.5C15.9167 3 16.2708 3.14583 16.5625 3.4375C16.8542 3.72917 17 4.08333 17 4.5V15.5C17 15.9167 16.8542 16.2708 16.5625 16.5625C16.2708 16.8542 15.9167 17 15.5 17H4.5ZM5.52083 15.5H14.4792C13.8403 15.0139 13.1389 14.6458 12.375 14.3958C11.6111 14.1319 10.8194 14 10 14C9.18056 14 8.38889 14.1319 7.625 14.3958C6.875 14.6458 6.17361 15.0139 5.52083 15.5ZM10 10C9.58333 10 9.22917 9.85417 8.9375 9.5625C8.64583 9.27083 8.5 8.91667 8.5 8.5C8.5 8.08333 8.64583 7.72917 8.9375 7.4375C9.22917 7.14583 9.58333 7 10 7C10.4167 7 10.7708 7.14583 11.0625 7.4375C11.3542 7.72917 11.5 8.08333 11.5 8.5C11.5 8.91667 11.3542 9.27083 11.0625 9.5625C10.7708 9.85417 10.4167 10 10 10Z"></path></g>
      <g id="account-circle"><path fill-rule="evenodd" clip-rule="evenodd" d="M10 1.667A8.336 8.336 0 0 0 1.667 10c0 4.6 3.733 8.333 8.333 8.333S18.333 14.6 18.333 10 14.6 1.667 10 1.667zM5.89 15.233c.359-.75 2.542-1.483 4.109-1.483 1.566 0 3.758.733 4.108 1.483A6.578 6.578 0 0 1 10 16.667a6.577 6.577 0 0 1-4.109-1.434zM10 12.083c1.216 0 4.108.492 5.3 1.942A6.625 6.625 0 0 0 16.666 10 6.676 6.676 0 0 0 10 3.333 6.676 6.676 0 0 0 3.333 10c0 1.517.517 2.908 1.367 4.025 1.191-1.45 4.083-1.942 5.3-1.942zM10 5a2.91 2.91 0 0 0-2.917 2.917A2.91 2.91 0 0 0 10 10.833a2.91 2.91 0 0 0 2.916-2.916A2.91 2.91 0 0 0 10 5zM8.75 7.917c0 .691.558 1.25 1.25 1.25.691 0 1.25-.559 1.25-1.25 0-.692-.559-1.25-1.25-1.25-.692 0-1.25.558-1.25 1.25z"></path></g>
      <g id="account-circle-filled" viewBox="0 -960 960 960"><path d="M237-285q54-38 115.5-56.5T480-360q66 0 127.5 18.5T723-285q35-41 52-91t17-104q0-129.67-91.23-220.84-91.23-91.16-221-91.16Q350-792 259-700.84 168-609.67 168-480q0 54 17 104t52 91Zm243-123q-60 0-102-42t-42-102q0-60 42-102t102-42q60 0 102 42t42 102q0 60-42 102t-102 42Zm.28 312Q401-96 331-126t-122.5-82.5Q156-261 126-330.96t-30-149.5Q96-560 126-629.5q30-69.5 82.5-122T330.96-834q69.96-30 149.5-30t149.04 30q69.5 30 122 82.5T834-629.28q30 69.73 30 149Q864-401 834-331t-82.5 122.5Q699-156 629.28-126q-69.73 30-149 30Z"></path></g>
      <g id="archive"><path d="M4.5 17C4.08333 17 3.72917 16.8542 3.4375 16.5625C3.14583 16.2708 3 15.9167 3 15.5V5.625C3 5.43055 3.03472 5.24306 3.10417 5.0625C3.1875 4.86805 3.29861 4.70139 3.4375 4.5625L4.5625 3.4375C4.70139 3.29861 4.86111 3.19444 5.04167 3.125C5.23611 3.04167 5.43056 3 5.625 3H14.375C14.5694 3 14.7569 3.04167 14.9375 3.125C15.1319 3.19444 15.2986 3.29861 15.4375 3.4375L16.5625 4.5625C16.7014 4.70139 16.8056 4.86805 16.875 5.0625C16.9583 5.24306 17 5.43055 17 5.625V15.5C17 15.9167 16.8542 16.2708 16.5625 16.5625C16.2708 16.8542 15.9167 17 15.5 17H4.5ZM4.625 5.5H15.375L14.375 4.5H5.625L4.625 5.5ZM4.5 7V15.5H15.5V7H4.5ZM10 14.25L13 11.25L11.9375 10.1875L10.75 11.375V8.25H9.25V11.375L8.0625 10.1875L7 11.25L10 14.25ZM4.5 15.5H15.5H4.5Z"></path></g>
      <g id="auto-delete"><path d="M6.5 5.5v10ZM9.396 17H6.5q-.625 0-1.062-.438Q5 16.125 5 15.5v-10H4V4h4V3h4v1h4v1.5h-1v3.104q-.375-.062-.75-.094-.375-.031-.75.011V5.5h-7v10h2.208q.104.396.282.771.177.375.406.729ZM8 14h.5q0-1.458.5-2.312l.5-.855V7H8Zm2.5-4.25q.292-.229.677-.469.385-.239.823-.406V7h-1.5ZM14 18q-1.667 0-2.833-1.167Q10 15.667 10 14q0-1.667 1.167-2.833Q12.333 10 14 10q1.667 0 2.833 1.167Q18 12.333 18 14q0 1.667-1.167 2.833Q15.667 18 14 18Zm1.146-2.146.708-.708-1.354-1.354V12h-1v2.208Z"></path></g>
      <g id="auto-summarize"><path d="M5.83333 9.16665V7.49998H10.8333V9.16665H5.83333ZM5.83333 12.5V10.8333H17.5V12.5H5.83333ZM5.83333 15.8333V14.1666H17.5V15.8333H5.83333ZM3.33333 9.16665C3.09722 9.16665 2.89931 9.08679 2.73958 8.92706C2.57986 8.76734 2.5 8.56942 2.5 8.33331C2.5 8.0972 2.57986 7.89929 2.73958 7.73956C2.89931 7.57984 3.09722 7.49998 3.33333 7.49998C3.56944 7.49998 3.76736 7.57984 3.92708 7.73956C4.08681 7.89929 4.16667 8.0972 4.16667 8.33331C4.16667 8.56942 4.08681 8.76734 3.92708 8.92706C3.76736 9.08679 3.56944 9.16665 3.33333 9.16665ZM3.33333 12.5C3.09722 12.5 2.89931 12.4201 2.73958 12.2604C2.57986 12.1007 2.5 11.9028 2.5 11.6666C2.5 11.4305 2.57986 11.2326 2.73958 11.0729C2.89931 10.9132 3.09722 10.8333 3.33333 10.8333C3.56944 10.8333 3.76736 10.9132 3.92708 11.0729C4.08681 11.2326 4.16667 11.4305 4.16667 11.6666C4.16667 11.9028 4.08681 12.1007 3.92708 12.2604C3.76736 12.4201 3.56944 12.5 3.33333 12.5ZM3.33333 15.8333C3.09722 15.8333 2.89931 15.7535 2.73958 15.5937C2.57986 15.434 2.5 15.2361 2.5 15C2.5 14.7639 2.57986 14.566 2.73958 14.4062C2.89931 14.2465 3.09722 14.1666 3.33333 14.1666C3.56944 14.1666 3.76736 14.2465 3.92708 14.4062C4.08681 14.566 4.16667 14.7639 4.16667 15C4.16667 15.2361 4.08681 15.434 3.92708 15.5937C3.76736 15.7535 3.56944 15.8333 3.33333 15.8333ZM14.5833 9.99998C14.5833 8.7222 15.0278 7.63887 15.9167 6.74998C16.8056 5.86109 17.8889 5.41665 19.1667 5.41665C17.8889 5.41665 16.8056 4.9722 15.9167 4.08331C15.0278 3.19442 14.5833 2.11109 14.5833 0.833313C14.5833 2.11109 14.1389 3.19442 13.25 4.08331C12.3611 4.9722 11.2778 5.41665 10 5.41665C11.2778 5.41665 12.3611 5.86109 13.25 6.74998C14.1389 7.63887 14.5833 8.7222 14.5833 9.99998Z"></path></g>
      <g id="auto-tab-group"><path d="M6.5 3.5C6.5 3.81944 6.5 4.14583 6.5 4.47917C6.5 4.8125 6.5 5.15972 6.5 5.52083C6.5 7.03472 6.5 8.32639 6.5 9.39583C6.5 10.4653 6.5 11 6.5 11C6.5 11 6.5 10.9653 6.5 10.8958C6.5 10.8264 6.5 10.7292 6.5 10.6042V13.5V3.5ZM3.5 18C3.08333 18 2.72917 17.8542 2.4375 17.5625C2.14583 17.2708 2 16.9167 2 16.5V5H3.5V16.5H15V18H3.5ZM6.5 15C6.08333 15 5.72917 14.8542 5.4375 14.5625C5.14583 14.2708 5 13.9167 5 13.5V3.5C5 3.08333 5.14583 2.72917 5.4375 2.4375C5.72917 2.14583 6.08333 2 6.5 2H10.2708C10.0764 2.22222 9.90278 2.45833 9.75 2.70833C9.61111 2.95833 9.48611 3.22222 9.375 3.5H6.5V13.5H16.5V10.6042C16.7778 10.4931 17.0417 10.3681 17.2917 10.2292C17.5417 10.0764 17.7778 9.90278 18 9.70833V13.5C18 13.9167 17.8542 14.2708 17.5625 14.5625C17.2708 14.8542 16.9167 15 16.5 15H6.5ZM14.5 10C14.5 8.75 14.0625 7.6875 13.1875 6.8125C12.3125 5.9375 11.25 5.5 10 5.5C11.25 5.5 12.3125 5.0625 13.1875 4.1875C14.0625 3.3125 14.5 2.25 14.5 0.999999C14.5 2.25 14.9375 3.3125 15.8125 4.1875C16.6875 5.0625 17.75 5.5 19 5.5C17.75 5.5 16.6875 5.9375 15.8125 6.8125C14.9375 7.6875 14.5 8.75 14.5 10Z"></path></g>
      <g id="background-replace"><path d="M3 8.104V6.333L6.333 3h1.792Zm0-3.896V3h1.208Zm10.188 1.521Q13 5.5 12.76 5.281q-.239-.219-.51-.385L14.167 3h1.791Zm-8.73 6.938 2.063-2.042q.167.25.364.458.198.209.365.375l-.25.25q-.625.146-1.312.407-.688.26-1.23.552Zm9.667-3.979q0-.021.021-.136.021-.114.021-.156 0-.354-.052-.688-.053-.333-.157-.625L17 4.062v1.771Zm-5.354-4.23L10.271 3h1.771l-1.313 1.312q-.187-.041-.364-.052-.177-.01-.344-.01-.354 0-.667.052-.312.052-.583.156Zm-5.729 7.521v-1.771l3.062-3.041q-.104.291-.166.604-.063.312-.063.625 0 .166.01.333.011.167.053.354Zm13.729 1.833q-.167-.25-.365-.479-.198-.229-.489-.416L17 11.854v1.75ZM14.5 12.188q-.125-.042-.292-.105-.166-.062-.312-.104-.167-.062-.354-.114-.188-.053-.375-.094L17 7.938v1.791Zm-4.479-.688q-1.313 0-2.219-.917-.906-.916-.906-2.187 0-1.292.906-2.208.906-.917 2.219-.917 1.291 0 2.198.917.906.916.906 2.208 0 1.271-.906 2.187-.907.917-2.198.917Zm0-1.5q.667 0 1.135-.469.469-.469.469-1.135 0-.667-.469-1.146-.468-.479-1.135-.479t-1.146.479q-.479.479-.479 1.146 0 .666.479 1.135t1.146.469ZM4 17v-1.5q0-.604.323-1.125t.865-.813q1.124-.583 2.333-.895 1.208-.313 2.479-.313 1.25 0 2.458.313 1.209.312 2.334.895.541.292.875.813.333.521.333 1.125V17Zm1.5-1.5h9q0-.208-.125-.354t-.292-.25q-.937-.5-1.979-.771T10 13.854q-1.062 0-2.104.261-1.042.26-1.979.76-.188.104-.302.26-.115.157-.115.365Z"></path></g>
      <g id="bar-chart"><path fill-rule="evenodd" clip-rule="evenodd" d="M4 16V8h3v8Zm4.5 0V4h3v12Zm4.5 0v-6h3v6Z"></path></g>
      <g id="block"><path fill-rule="evenodd" clip-rule="evenodd" d="M9.99984 1.66667C5.39984 1.66667 1.6665 5.40001 1.6665 10C1.6665 14.6 5.39984 18.3333 9.99984 18.3333C14.5998 18.3333 18.3332 14.6 18.3332 10C18.3332 5.40001 14.5998 1.66667 9.99984 1.66667ZM3.33317 10C3.33317 6.31667 6.3165 3.33334 9.99984 3.33334C11.5415 3.33334 12.9582 3.85834 14.0832 4.74167L4.7415 14.0833C3.85817 12.9583 3.33317 11.5417 3.33317 10ZM5.9165 15.2583C7.0415 16.1417 8.45817 16.6667 9.99984 16.6667C13.6832 16.6667 16.6665 13.6833 16.6665 10C16.6665 8.45834 16.1415 7.04167 15.2582 5.91667L5.9165 15.2583Z"></path></g>
      <g id="bolt"><path d="M9.16672 17.5H8.33339L9.16672 11.6667H6.25005C5.76672 11.6667 5.77505 11.4 5.93339 11.1167C6.09172 10.8333 5.97505 11.05 5.99172 11.0167C7.06672 9.11667 8.68339 6.28333 10.8334 2.5H11.6667L10.8334 8.33333H13.7501C14.1584 8.33333 14.2167 8.60833 14.1417 8.75833L14.0834 8.88333C10.8001 14.625 9.16672 17.5 9.16672 17.5Z"></path></g>
      <g id="broken"><path fill-rule="evenodd" clip-rule="evenodd" d="M15.8333 2.5H4.16667C3.25 2.5 2.5 3.25 2.5 4.16667V15.8333C2.5 16.75 3.25 17.5 4.16667 17.5H15.8333C16.75 17.5 17.5 16.75 17.5 15.8333V4.16667C17.5 3.25 16.75 2.5 15.8333 2.5ZM15.8333 4.16667V9.29167L14 7L11.3333 10.3333L8.66667 7L6 10.3333L4.16667 8.04167V4.16667H15.8333ZM4.16667 10.7083V15.8333H15.8417V11.9583L14.0083 9.66667L11.3333 13L8.66667 9.66667L6 13L4.16667 10.7083Z"></path></g>
      <g id="checklist"><path d="M4.833 15.5 2 12.667l1.062-1.063 1.75 1.771 3.542-3.542 1.084 1.063Zm0-6.5L2 6.167l1.062-1.063 1.771 1.771 3.521-3.542 1.084 1.063ZM11 14v-1.5h7V14Zm0-6.5V6h7v1.5Z"></path></g>
      <g id="chrome-filled"><path d="M6.875 10.0208C6.875 10.8958 7.17361 11.6389 7.77083 12.25C8.38194 12.8472 9.125 13.1458 10 13.1458C10.875 13.1458 11.6111 12.8472 12.2083 12.25C12.8194 11.6389 13.125 10.8958 13.125 10.0208C13.125 9.14583 12.8194 8.40972 12.2083 7.8125C11.6111 7.20139 10.875 6.89583 10 6.89583C9.125 6.89583 8.38194 7.20139 7.77083 7.8125C7.17361 8.40972 6.875 9.14583 6.875 10.0208ZM10 14.7083C10.1528 14.7083 10.3125 14.7083 10.4792 14.7083C10.6458 14.6944 10.8125 14.6667 10.9792 14.625L8.85417 18.25C6.78472 18.0139 5.06944 17.1111 3.70833 15.5417C2.36111 13.9722 1.6875 12.1319 1.6875 10.0208C1.6875 9.40972 1.75694 8.80556 1.89583 8.20833C2.03472 7.61111 2.24306 7.02083 2.52083 6.4375L5.97917 12.3542C6.38194 13.0903 6.94444 13.6667 7.66667 14.0833C8.38889 14.5 9.16667 14.7083 10 14.7083ZM10 5.33333C8.97222 5.33333 8.05556 5.63889 7.25 6.25C6.44444 6.84722 5.88889 7.625 5.58333 8.58333L3.45833 4.91667C4.22222 3.90278 5.17361 3.11805 6.3125 2.5625C7.46528 1.99305 8.69444 1.70833 10 1.70833C11.375 1.70833 12.6667 2.03472 13.875 2.6875C15.0833 3.32639 16.0694 4.20833 16.8333 5.33333H10ZM17.6875 6.89583C17.9097 7.40972 18.0694 7.93056 18.1667 8.45833C18.2639 8.97222 18.3125 9.49306 18.3125 10.0208C18.3125 12.2569 17.5903 14.1389 16.1458 15.6667C14.7014 17.1806 12.8681 18.0556 10.6458 18.2917L14.0208 12.3542C14.2292 11.9931 14.3889 11.6181 14.5 11.2292C14.625 10.8403 14.6875 10.4375 14.6875 10.0208C14.6875 9.4375 14.5764 8.88194 14.3542 8.35417C14.1458 7.8125 13.8542 7.32639 13.4792 6.89583H17.6875Z"></path></g>
      <g id="cloud-off"><path d="M16.4732571,13.3443682 C16.8002856,12.9882746 17,12.5134184 17,11.9922 C17,10.8882 16.104,9.9922 15,9.9922 L13.494,9.9922 L13.494,9.0002 C13.494,7.0672 11.927,5.5002 9.994,5.5002 C9.5847901,5.5002 9.1930204,5.57089988 8.82954884,5.70065995 L7.33083687,4.20194798 C8.11843435,3.75577808 9.02717677,3.5002 10,3.5002 C12.71,3.5002 14.957,5.4612 15.411,8.0412 C17.424,8.2502 19,9.9312 19,12.0002 C19,13.0718701 18.5784721,14.0451601 17.8921876,14.7632987 L16.4732571,13.3443682 Z M17.8711111,17 L16.8711111,18 L14.8713111,16.0002 L6,16.0002 C3.239,16.0002 1,13.7622 1,11.0002 C1,8.58475294 2.71868905,6.59044755 4.99627833,6.12516722 L2,3.12888889 L3,2.12888889 L17.8711111,17 Z M6.86331111,7.9922 L6,7.9922 C4.343,7.9922 3,9.3352 3,10.9922 C3,12.6492 4.343,13.9922 6,13.9922 L12.8633111,13.9922 L6.86331111,7.9922 Z"></path></g>
      <g id="credit-card"><path d="M16.4,4 L3.6,4 C2.716,4 2.008,4.7271875 2.008,5.625 L2,15.375 C2,16.2728125 2.716,17 3.6,17 L16.4,17 C17.284,17 18,16.2728125 18,15.375 L18,5.625 C18,4.7271875 17.284,4 16.4,4 Z M16.5,15 L3.5,15 L3.5,10 L16.5,10 L16.5,15 Z M16.5,7 L3.5,7 L3.5,5.5 L16.5,5.5 L16.5,7 Z"></path></g>
      <g id="dashboard"><path d="M3 10.5V4.5C3 4.08333 3.14583 3.72917 3.4375 3.4375C3.74306 3.14583 4.09722 3 4.5 3H9.25V10.5H3ZM10.75 3H15.5C15.9167 3 16.2708 3.14583 16.5625 3.4375C16.8542 3.72917 17 4.08333 17 4.5V8H10.75V3ZM10.75 17V9.5H17V15.5C17 15.9028 16.8542 16.2569 16.5625 16.5625C16.2708 16.8542 15.9167 17 15.5 17H10.75ZM3 12H9.25V17H4.5C4.09722 17 3.74306 16.8542 3.4375 16.5625C3.14583 16.2569 3 15.9028 3 15.5V12ZM4.5 9H7.75V4.5H4.5V9ZM12.25 6.5H15.5V4.5H12.25V6.5ZM12.25 11V15.5H15.5V11H12.25ZM4.5 13.5V15.5H7.75V13.5H4.5Z"></path></g>
      <g id="data"><path d="M0 0h20v20H0z" fill="none" fill-rule="evenodd"></path><path d="M6.5 7v9H4V7h2.5zm5-3v12H9V4h2.5zm5 7v5H14v-5h2.5z"></path></g>
      <g id="data-connectors-system"><path d="M10 4.16667C10.0833 4.16667 10.2333 4.18333 10.3667 4.30833L13.025 6.96667L15.675 9.60833C15.8083 9.74167 15.825 9.9 15.825 10.0167V10.0417C15.825 10.125 15.8 10.2 15.7667 10.2667C15.7583 10.2833 15.75 10.3 15.7417 10.3083C15.725 10.3333 15.7 10.3667 15.675 10.3917L10.4 15.65L10.3583 15.6917C10.2333 15.8167 10.0833 15.8333 10 15.8333C9.91667 15.8333 9.75 15.8167 9.61667 15.675L4.325 10.3833C4.18333 10.2583 4.16667 10.1 4.16667 9.99167C4.16667 9.90833 4.18333 9.75 4.31667 9.60833L6.44167 7.48333L9.60833 4.325C9.75 4.18333 9.91667 4.16667 10 4.16667ZM10 2.5C9.43333 2.5 8.86667 2.71667 8.44167 3.14167L5.275 6.3L3.15 8.425C2.70833 8.85833 2.5 9.43333 2.5 10C2.5 10.5667 2.70833 11.1417 3.14167 11.575L5.26667 13.7L8.43333 16.8583C8.86667 17.2833 9.43333 17.5 10 17.5C10.5667 17.5 11.1333 17.2833 11.5583 16.8583L16.8583 11.575C16.9667 11.4667 17.0583 11.35 17.1417 11.2333C17.1833 11.175 17.2167 11.1083 17.25 11.05C17.4167 10.7333 17.5 10.375 17.5 10.025C17.5 10.0167 17.5 10.0167 17.5 10.0083C17.5083 9.44167 17.2917 8.86667 16.8583 8.43333L11.5583 3.15C11.1333 2.71667 10.5667 2.5 10 2.5Z"></path><path d="M10 11.6667L8.33333 10L10 8.33333L11.6667 10L10 11.6667Z"></path><path d="M10.5917 7.25833C10.9167 6.93333 10.9167 6.40833 10.5917 6.08333C10.2667 5.75833 9.74167 5.75833 9.41667 6.08333C9.09167 6.40833 9.09167 6.93333 9.41667 7.25833C9.73333 7.58333 10.2667 7.58333 10.5917 7.25833Z"></path><path d="M7.25833 10.5917C7.58333 10.2667 7.58333 9.74167 7.25833 9.41667C6.93333 9.09167 6.40833 9.09167 6.08333 9.41667C5.75833 9.74167 5.75833 10.2667 6.08333 10.5917C6.4 10.9167 6.93333 10.9167 7.25833 10.5917Z"></path><path d="M10.5917 13.925C10.9167 13.6 10.9167 13.075 10.5917 12.75C10.2667 12.425 9.74167 12.425 9.41667 12.75C9.09167 13.075 9.09167 13.6 9.41667 13.925C9.73333 14.25 10.2667 14.25 10.5917 13.925Z"></path><path d="M13.925 10.5917C14.25 10.2667 14.25 9.74167 13.925 9.41667C13.6 9.09167 13.075 9.09167 12.75 9.41667C12.425 9.74167 12.425 10.2667 12.75 10.5917C13.0667 10.9167 13.6 10.9167 13.925 10.5917Z"></g>
      <g id="delete"><path d="M6.5 17q-.625 0-1.062-.438Q5 16.125 5 15.5v-10H4V4h4V3h4v1h4v1.5h-1v10q0 .625-.438 1.062Q14.125 17 13.5 17Zm7-11.5h-7v10h7ZM8 14h1.5V7H8Zm2.5 0H12V7h-1.5Zm-4-8.5v10Z"></path></g>
      <g id="delete-forever"><path fill-rule="evenodd" clip-rule="evenodd" d="M12.4999 3.33333V2.5H7.49992V3.33333H3.33325V5H4.16659V15.8333C4.16659 16.75 4.91659 17.5 5.83325 17.5H14.1666C15.0833 17.5 15.8333 16.75 15.8333 15.8333V5H16.6666V3.33333H12.4999ZM14.1666 5V15.8333H5.83325V5H14.1666ZM9.99992 11.5917L7.84158 13.75L6.66658 12.575L8.82492 10.4167L6.66658 8.25833L7.84158 7.08333L9.99992 9.24167L12.1583 7.08333L13.3333 8.25833L11.1749 10.4167L13.3333 12.575L12.1583 13.75L9.99992 11.5917Z"></path></g>
      <g id="difference"><path d="M10.25 9.5H11.75V8H13.25V6.5H11.75V5H10.25V6.5H8.75V8H10.25V9.5ZM8.75 12.5H13.25V11H8.75V12.5ZM6.5 16C6.09722 16 5.74306 15.8542 5.4375 15.5625C5.14583 15.2569 5 14.9028 5 14.5V2.5C5 2.09722 5.14583 1.75 5.4375 1.45833C5.74306 1.15278 6.09722 0.999999 6.5 0.999999H13L17 5V14.5C17 14.9028 16.8472 15.2569 16.5417 15.5625C16.25 15.8542 15.9028 16 15.5 16H6.5ZM6.5 14.5H15.5V5.625L12.375 2.5H6.5V14.5ZM3.5 19C3.09722 19 2.74306 18.8542 2.4375 18.5625C2.14583 18.2569 2 17.9028 2 17.5V6H3.5V17.5H12.5V19H3.5ZM6.5 14.5V2.5V6.5625V14.5Z"></path></g>
      <g id="dns"><path fill-rule="evenodd" clip-rule="evenodd" d="M16.6667 2.5H3.33333C2.875 2.5 2.5 2.875 2.5 3.33333V9.16667C2.5 9.625 2.875 10 3.33333 10H16.6667C17.125 10 17.5 9.625 17.5 9.16667V3.33333C17.5 2.875 17.125 2.5 16.6667 2.5ZM7.5 6.25C7.5 6.94036 6.94036 7.5 6.25 7.5C5.55964 7.5 5 6.94036 5 6.25C5 5.55964 5.55964 5 6.25 5C6.94036 5 7.5 5.55964 7.5 6.25ZM7.5 14.5833C7.5 15.2737 6.94036 15.8333 6.25 15.8333C5.55964 15.8333 5 15.2737 5 14.5833C5 13.893 5.55964 13.3333 6.25 13.3333C6.94036 13.3333 7.5 13.893 7.5 14.5833ZM4.16667 8.33333H15.8333V4.16667H4.16667V8.33333ZM16.6667 10.8333H3.33333C2.875 10.8333 2.5 11.2083 2.5 11.6667V17.5C2.5 17.9583 2.875 18.3333 3.33333 18.3333H16.6667C17.125 18.3333 17.5 17.9583 17.5 17.5V11.6667C17.5 11.2083 17.125 10.8333 16.6667 10.8333ZM4.16667 16.6667H15.8333V12.5H4.16667V16.6667Z"></path></g>
      <g id="download"><path d="M 10 13.292969 L 5.230469 8.519531 L 6.644531 7.144531 L 9.019531 9.519531 L 9.019531 2.792969 L 10.980469 2.792969 L 10.980469 9.519531 L 13.355469 7.144531 L 14.769531 8.519531 Z M 4.769531 17.1875 C 4.226562 17.1875 3.765625 16.996094 3.386719 16.613281 C 3.003906 16.234375 2.8125 15.773438 2.8125 15.230469 L 2.8125 12.25 L 4.769531 12.25 L 4.769531 15.230469 L 15.230469 15.230469 L 15.230469 12.25 L 17.207031 12.25 L 17.207031 15.230469 C 17.207031 15.769531 17.015625 16.234375 16.628906 16.613281 C 16.246094 16.996094 15.777344 17.1875 15.230469 17.1875 Z M 4.769531 17.1875"></path></g>
      <g id="edit-square"><path d="M 4.167969 17.5 C 3.707031 17.5 3.316406 17.335938 2.988281 17.011719 C 2.664062 16.683594 2.5 16.292969 2.5 15.832031 L 2.5 4.167969 C 2.5 3.707031 2.664062 3.316406 2.988281 2.988281 C 3.316406 2.664062 3.707031 2.5 4.167969 2.5 L 11.605469 2.5 L 9.9375 4.167969 L 4.167969 4.167969 L 4.167969 15.832031 L 15.832031 15.832031 L 15.832031 10.042969 L 17.5 8.375 L 17.5 15.832031 C 17.5 16.292969 17.335938 16.683594 17.011719 17.011719 C 16.683594 17.335938 16.292969 17.5 15.832031 17.5 Z M 10 10 Z M 7.5 12.5 L 7.5 8.957031 L 15.144531 1.3125 C 15.3125 1.144531 15.5 1.019531 15.707031 0.9375 C 15.917969 0.855469 16.125 0.8125 16.332031 0.8125 C 16.554688 0.8125 16.765625 0.855469 16.96875 0.9375 C 17.171875 1.019531 17.355469 1.144531 17.519531 1.3125 L 18.6875 2.5 C 18.839844 2.667969 18.957031 2.851562 19.042969 3.050781 C 19.125 3.253906 19.167969 3.457031 19.167969 3.667969 C 19.167969 3.875 19.128906 4.078125 19.050781 4.28125 C 18.976562 4.484375 18.855469 4.667969 18.6875 4.832031 L 11.042969 12.5 Z M 17.519531 3.667969 L 16.355469 2.5 Z M 9.167969 10.832031 L 10.332031 10.832031 L 15.167969 6 L 14.582031 5.417969 L 13.980469 4.832031 L 9.167969 9.644531 Z M 14.582031 5.417969 L 13.980469 4.832031 L 14.582031 5.417969 L 15.167969 6 Z M 14.582031 5.417969 "></path></g>
      <g id="experiment"><path d="M17.2667 14.7583L12.5 8.18332V4.23332H14.1667V2.56665H5.83332V4.23332H7.49998V8.17498L2.61665 14.9166C2.24998 15.425 2.19998 16.0917 2.48332 16.65C2.76665 17.2083 3.34165 17.5583 3.96665 17.5583H16.05C16.9667 17.5583 17.7167 16.8083 17.7167 15.8917C17.7167 15.4583 17.5416 15.0583 17.2667 14.7583Z" fill="#5F6368"></path></g>
      <g id="my_extensions" viewBox="0 -960 960 960"><path d="M216-135.869q-33.287 0-56.709-23.422-23.422-23.422-23.422-56.709v-172.304q37.609-2 63.218-28.424 25.608-26.424 25.608-63.272t-25.608-63.272q-25.609-26.424-63.218-28.424V-744q0-33.287 23.422-56.709 23.422-23.422 56.709-23.422h161.065q2.631-40.956 31.96-69.315 29.329-28.359 70.75-28.359t70.975 28.199q29.554 28.199 32.185 69.475H744q33.287 0 56.709 23.422 23.422 23.422 23.422 56.709v161.065q40.956 2.631 69.315 31.96 28.359 29.329 28.359 70.75t-28.199 70.975q-28.199 29.554-69.475 32.185V-216q0 33.287-23.422 56.709-23.422 23.422-56.709 23.422H216Zm2.87-83.001h522.26v-522.26H218.87v108.652q42.13 22.63 65.597 63.772 23.468 41.141 23.468 88.706 0 49.01-23.468 90.168Q261-348.674 218.87-327.283v108.413ZM480-480Z"></path></g>
      <g id="fact-check" viewBox="0 -960 960 960"><path d="M168-144q-29.7 0-50.85-21.15Q96-186.3 96-216v-528q0-29.7 21.15-50.85Q138.3-816 168-816h624q29.7 0 50.85 21.15Q864-773.7 864-744v528q0 29.7-21.15 50.85Q821.7-144 792-144H168Zm0-72h624v-528H168v528Zm43-71h192v-72H211v72Zm371-73 170-170-51-51-119 119-51-51-51 51 102 102Zm-371-84h192v-72H211v72Zm0-156h192v-72H211v72Zm-43 384v-528 528Z"></path></g>
      <g id="file-save"><path d="M15.25 17.5L18.25 14.5L17.1875 13.4375L16 14.625V11.5H14.5V14.625L13.3125 13.4375L12.25 14.5L15.25 17.5ZM12.25 20V18.5H18.25V20H12.25ZM5.5 17C5.09722 17 4.74306 16.8542 4.4375 16.5625C4.14583 16.2569 4 15.9028 4 15.5V3.5C4 3.09722 4.14583 2.75 4.4375 2.45833C4.74306 2.15278 5.09722 2 5.5 2H12L16 6V10H14.5V7H11V3.5H5.5V15.5H11V17H5.5ZM5.5 15.5V9.41667V7.45833V3.5V15.5Z"></path></g>
      <g id="filter-list"><path d="M8 14.5V13h4v1.5Zm-3-3.75v-1.5h10v1.5ZM3 7V5.5h14V7Z"></path></g>
      <g id="flash-on"><path d="M5.83337 1.66666V10.8333H8.33337V18.3333L14.1667 8.33332H10.8334L13.3334 1.66666H5.83337Z"></path></g>
      <g id="gavel" viewBox="0 -960 960 960"><path d="M160-120v-80h480v80H160Zm226-194L160-540l84-86 228 226-86 86Zm254-254L414-796l86-84 226 226-86 86Zm184 408L302-682l56-56 522 522-56 56Z"></path></g>
      <g id="googleg"><path d="M16.58 8H9v2.75h4.47c-.24 1.2-1.42 3.27-4.47 3.27-2.72 0-4.93-2.25-4.93-5.02S6.28 3.98 9 3.98c1.54 0 2.57.66 3.17 1.22l2.19-2.12C12.97 1.79 11.16 1 9 1 4.58 1 1 4.58 1 9s3.58 8 8 8c4.62 0 7.68-3.25 7.68-7.82 0-.46-.04-.83-.1-1.18z"></path></g>
      <g id="google-lens-2"><path d="M15.5 11V7.5C15.5 7.08333 15.3542 6.72917 15.0625 6.4375C14.7708 6.14583 14.4167 6 14 6H6C5.58333 6 5.22917 6.14583 4.9375 6.4375C4.64583 6.72917 4.5 7.08333 4.5 7.5V10H3V7.5C3 6.66667 3.29167 5.95833 3.875 5.375C4.45833 4.79167 5.16667 4.5 6 4.5H7.75L8.5 3H11.5L12.25 4.5H14C14.8333 4.5 15.5417 4.79167 16.125 5.375C16.7083 5.95833 17 6.66667 17 7.5V11H15.5ZM6 17C5.16667 17 4.45833 16.7083 3.875 16.125C3.29167 15.5417 3 14.8333 3 14V12.5H4.5V14C4.5 14.4167 4.64583 14.7708 4.9375 15.0625C5.22917 15.3542 5.58333 15.5 6 15.5H10V17H6ZM15 16.5C14.5833 16.5 14.2292 16.3542 13.9375 16.0625C13.6458 15.7708 13.5 15.4167 13.5 15C13.5 14.5833 13.6458 14.2292 13.9375 13.9375C14.2292 13.6458 14.5833 13.5 15 13.5C15.4167 13.5 15.7708 13.6458 16.0625 13.9375C16.3542 14.2292 16.5 14.5833 16.5 15C16.5 15.4167 16.3542 15.7708 16.0625 16.0625C15.7708 16.3542 15.4167 16.5 15 16.5ZM10 13.5C9.30556 13.5 8.71528 13.2569 8.22917 12.7708C7.74306 12.2847 7.5 11.6944 7.5 11C7.5 10.3056 7.74306 9.71528 8.22917 9.22917C8.71528 8.74305 9.30556 8.5 10 8.5C10.6944 8.5 11.2847 8.74305 11.7708 9.22917C12.2569 9.71528 12.5 10.3056 12.5 11C12.5 11.6944 12.2569 12.2847 11.7708 12.7708C11.2847 13.2569 10.6944 13.5 10 13.5Z"></path></g>
      <g id="gshield"><path d="M 10.089844 13.9375 C 11.410156 13.9375 12.46875 13.519531 13.265625 12.6875 C 14.058594 11.855469 14.457031 10.785156 14.457031 9.46875 C 14.457031 9.296875 14.449219 9.136719 14.425781 8.988281 C 14.40625 8.84375 14.378906 8.703125 14.351562 8.5625 L 10.082031 8.5625 L 10.082031 10.105469 L 12.75 10.105469 C 12.707031 10.546875 12.484375 11.027344 12.074219 11.542969 C 11.664062 12.054688 11 12.3125 10.085938 12.3125 C 9.277344 12.3125 8.601562 12.023438 8.050781 11.445312 C 7.503906 10.871094 7.230469 10.179688 7.230469 9.375 C 7.230469 8.570312 7.503906 7.882812 8.054688 7.3125 C 8.601562 6.742188 9.277344 6.457031 10.074219 6.457031 C 10.523438 6.457031 10.90625 6.535156 11.21875 6.6875 C 11.53125 6.839844 11.773438 7 11.945312 7.167969 L 13.144531 6.003906 C 12.738281 5.644531 12.28125 5.359375 11.777344 5.148438 C 11.273438 4.9375 10.707031 4.832031 10.082031 4.832031 C 8.8125 4.832031 7.738281 5.273438 6.859375 6.15625 C 5.980469 7.039062 5.542969 8.109375 5.542969 9.375 C 5.542969 10.640625 5.984375 11.714844 6.863281 12.605469 C 7.746094 13.492188 8.820312 13.9375 10.089844 13.9375 Z M 10 18.75 C 9.882812 18.75 9.773438 18.738281 9.667969 18.71875 C 9.5625 18.699219 9.464844 18.667969 9.375 18.625 C 7.375 17.972656 5.78125 16.738281 4.59375 14.925781 C 3.40625 13.109375 2.8125 11.171875 2.8125 9.101562 L 2.8125 5.167969 C 2.8125 4.746094 2.925781 4.363281 3.152344 4.015625 C 3.382812 3.671875 3.691406 3.429688 4.082031 3.292969 L 9.3125 1.332031 C 9.535156 1.25 9.765625 1.207031 10 1.207031 C 10.234375 1.207031 10.464844 1.25 10.6875 1.332031 L 15.917969 3.292969 C 16.308594 3.429688 16.621094 3.671875 16.855469 4.015625 C 17.089844 4.363281 17.207031 4.746094 17.207031 5.167969 L 17.207031 9.101562 C 17.207031 11.171875 16.609375 13.109375 15.417969 14.925781 C 14.222656 16.738281 12.625 17.972656 10.625 18.625 C 10.535156 18.667969 10.4375 18.699219 10.332031 18.71875 C 10.226562 18.738281 10.117188 18.75 10 18.75 Z M 10 16.855469 C 11.527344 16.257812 12.78125 15.257812 13.761719 13.855469 C 14.738281 12.453125 15.230469 10.871094 15.230469 9.109375 L 15.230469 5.167969 L 10 3.1875 L 4.769531 5.175781 L 4.769531 9.101562 C 4.769531 10.867188 5.261719 12.453125 6.238281 13.855469 C 7.21875 15.257812 8.472656 16.257812 10 16.855469 Z M 10 10.019531 Z M 10 10.019531"></path></g>
      <g id="history"><path fill-rule="evenodd" clip-rule="evenodd" d="M3.33341 5.00832V3.33332H1.66675V8.33332H6.66675V6.66666H4.24175C5.39175 4.67499 7.53341 3.33332 10.0001 3.33332C13.6834 3.33332 16.6667 6.31666 16.6667 9.99999C16.6667 13.6833 13.6834 16.6667 10.0001 16.6667C6.31675 16.6667 3.33341 13.6833 3.33341 9.99999H1.66675C1.66675 14.6 5.40008 18.3333 10.0084 18.3333C14.6084 18.3333 18.3334 14.6 18.3334 9.99999C18.3334 5.39999 14.6084 1.66666 10.0084 1.66666C7.27508 1.66666 4.85841 2.98332 3.33341 5.00832ZM10.8334 4.99999V9.99999L14.3584 12.45L13.3084 13.7417L9.16675 10.8333V4.99999H10.8334Z"></path></g>
      <g id="home" viewBox="0 -960 960 960"><path d="M264-216h96v-240h240v240h96v-348L480-726 264-564v348Zm-72 72v-456l288-216 288 216v456H528v-240h-96v240H192Zm288-327Z"></path></g>
      <g id="incognito" fill="#5F6368"><circle cx="6.8" cy="12.964" r="1.764"/><path d="M10 0C4.473 0 0 4.473 0 10s4.473 10 10 10 10-4.473 10-10S15.527 0 10 0zM7.619 4.1a.696.696 0 0 1 .881-.419l1.473.492 1.463-.492a.716.716 0 0 1 .883.419l1.608 4.291H6.02l1.6-4.291zm5.517 11.328a2.463 2.463 0 0 1-2.445-2.256c-.682-.436-1.237-.162-1.455-.017a2.45 2.45 0 0 1-2.445 2.263 2.471 2.471 0 0 1-2.464-2.463 2.47 2.47 0 0 1 2.463-2.464c1.165 0 2.138.809 2.391 1.9a1.934 1.934 0 0 1 1.546.009 2.462 2.462 0 0 1 2.392-1.909 2.47 2.47 0 0 1 2.462 2.463 2.435 2.435 0 0 1-2.445 2.474zM16.31 9.8H3.637v-.709H16.31V9.8h-.001z"/><circle cx="13.136" cy="12.964" r="1.764"/></g>
      <g id="incognito-unfilled"><path d="M17.5 9.16667H2.5V10H17.5V9.16667Z"></path><path d="M14.6833 8.33334L12.775 3.25001C12.6167 2.83334 12.1583 2.60834 11.7333 2.75L10 3.33334L8.25833 2.75C7.83333 2.60834 7.375 2.83334 7.21667 3.25001L5.31667 8.33334H14.6833Z"></path><path d="M13.75 10.8333C12.3667 10.8333 11.2167 11.8 10.9167 13.0917C10.2167 12.7917 9.56667 12.875 9.08333 13.0833C8.775 11.7917 7.625 10.8333 6.25 10.8333C4.64167 10.8333 3.33333 12.1417 3.33333 13.75C3.33333 15.3583 4.64167 16.6667 6.25 16.6667C7.78333 16.6667 9.025 15.4833 9.14167 13.9833C9.39167 13.8083 10.05 13.4833 10.8583 14C10.9917 15.4917 12.225 16.6667 13.75 16.6667C15.3583 16.6667 16.6667 15.3583 16.6667 13.75C16.6667 12.1417 15.3583 10.8333 13.75 10.8333ZM6.25 15.8333C5.1 15.8333 4.16667 14.9 4.16667 13.75C4.16667 12.6 5.1 11.6667 6.25 11.6667C7.4 11.6667 8.33333 12.6 8.33333 13.75C8.33333 14.9 7.4 15.8333 6.25 15.8333ZM13.75 15.8333C12.6 15.8333 11.6667 14.9 11.6667 13.75C11.6667 12.6 12.6 11.6667 13.75 11.6667C14.9 11.6667 15.8333 12.6 15.8333 13.75C15.8333 14.9 14.9 15.8333 13.75 15.8333Z"></path></g>
      <g id="interests"><path d="m2 9 4-7 4 7Zm4 8q-1.25 0-2.125-.875T3 14q0-1.25.875-2.125T6 11q1.25 0 2.125.875T9 14q0 1.25-.875 2.125T6 17Zm0-1.5q.625 0 1.062-.438Q7.5 14.625 7.5 14t-.438-1.062Q6.625 12.5 6 12.5t-1.062.438Q4.5 13.375 4.5 14t.438 1.062Q5.375 15.5 6 15.5Zm-1.396-8h2.792L6 5.021ZM11 17v-6h6v6Zm1.5-1.5h3v-3h-3ZM14 9q-1.125-.938-1.854-1.552-.729-.615-1.167-1.083-.437-.469-.614-.865t-.177-.896q0-.875.583-1.489.583-.615 1.5-.615.541 0 .969.219.427.219.76.677.333-.458.771-.677.437-.219.958-.219.917 0 1.5.615.583.614.583 1.489 0 .5-.166.896-.167.396-.604.854-.438.458-1.177 1.073Q15.125 8.042 14 9Zm0-2q1.417-1.188 1.865-1.635.447-.448.447-.782 0-.229-.166-.406Q15.979 4 15.75 4q-.167 0-.312.083-.146.084-.25.209L14 5.396l-1.167-1.104q-.125-.125-.271-.209Q12.417 4 12.25 4q-.229 0-.396.177-.166.177-.166.406 0 .355.468.813Q12.625 5.854 14 7Zm0-1.604Zm-7.979 1Zm0 7.542Zm7.958 0Z"></path></g>
      <g id="keyboard-lock"><path d="M3.332 14.168V5.832Zm.836-3.336h1.664V9.168H4.168Zm2.5 0h1.664V9.168H6.668Zm2.5 0h1.664V9.168H9.168Zm2.5 0h1.664V9.168h-1.664Zm-7.5-2.5h1.664V6.668H4.168Zm2.5 0h1.664V6.668H6.668Zm2.5 0h1.664V6.668H9.168Zm2.5 0h1.664V6.668h-1.664Zm2.5 0h1.664V6.668h-1.664Zm0 2.023c.25-.113.516-.199.8-.261a4.03 4.03 0 0 1 .864-.094v-.832h-1.664Zm-7.5 2.977h5.082c.07-.316.168-.617.293-.895.125-.277.277-.535.457-.769H6.668Zm-3.336 2.5c-.457 0-.848-.16-1.176-.488a1.599 1.599 0 0 1-.488-1.176V5.832c0-.457.16-.848.488-1.176a1.599 1.599 0 0 1 1.176-.488h13.336c.457 0 .848.16 1.176.488.328.328.488.719.488 1.176v5a3.885 3.885 0 0 0-.77-.457 4.616 4.616 0 0 0-.894-.293v-4.25H3.332v8.336h8.336v1.664Zm10.711 2.5a.67.67 0 0 1-.5-.207.68.68 0 0 1-.211-.5v-2.75c0-.195.07-.36.211-.5a.67.67 0 0 1 .5-.207h.125v-.836c0-.457.16-.848.488-1.176a1.599 1.599 0 0 1 1.176-.488c.461 0 .852.16 1.18.488.324.328.488.719.488 1.176v.836h.125c.195 0 .36.066.5.207.14.14.207.305.207.5v2.75c0 .195-.066.36-.207.5a.675.675 0 0 1-.5.207ZM15 14.168h1.668v-.836a.81.81 0 0 0-.242-.594.8.8 0 0 0-.594-.238.807.807 0 0 0-.594.238.807.807 0 0 0-.238.594Zm0 0"></path></g>
      <g id="keyboard-lock-off"><path d="M7.5 10Zm3.48 3.332H6.668v-1.664h4.312Zm-6.812-2.5V9.168h1.664v1.664Zm2.5 0V9.168h1.664v1.664Zm-2.5-2.5V6.668h1.664v1.664Zm7.5 0h1.664V6.668h-1.664Zm2.5 0h1.664V6.668h-1.664Zm0 2.023c.25-.113.516-.199.8-.261a4.03 4.03 0 0 1 .864-.094v-.832h-1.664Zm-.836.477V9.168h-1.664v.125l1.539 1.539Zm-2.5-2.5V6.668H9.168v.125l1.539 1.539Zm6.23 11.086L.582 2.918 1.75 1.75l16.5 16.5ZM10.75 8.355Zm7.582 2.477a3.885 3.885 0 0 0-.77-.457 4.616 4.616 0 0 0-.894-.293v-4.25H8.207L6.543 4.168h10.125c.457 0 .848.16 1.176.488.328.328.488.719.488 1.176Zm-15 5c-.457 0-.848-.16-1.176-.488a1.599 1.599 0 0 1-.488-1.176V5.832c0-.457.16-.848.488-1.176a1.599 1.599 0 0 1 1.176-.488h.836l1.664 1.664h-2.5v8.336h8.336v1.664Zm10.711 2.5a.67.67 0 0 1-.5-.207.68.68 0 0 1-.211-.5v-2.75c0-.195.07-.36.211-.5a.67.67 0 0 1 .5-.207h.125L17.5 17.5v.832Zm4.289-2.375-1.664-1.664v-.961a.81.81 0 0 0-.242-.594.8.8 0 0 0-.594-.238.85.85 0 0 0-.363.082.746.746 0 0 0-.281.23l-.583-.605a1.71 1.71 0 0 1 .551-.395c.215-.097.442-.144.676-.144.461 0 .852.16 1.18.488.324.328.488.719.488 1.176v.836h.125c.195 0 .36.066.5.207.14.14.207.305.207.5Zm0 0"></path></g>
      <g id="lightbulb"><path d="M7.49996 17.5C7.49996 17.9583 7.87496 18.3333 8.33329 18.3333H11.6666C12.125 18.3333 12.5 17.9583 12.5 17.5V16.6667H7.49996V17.5ZM9.99996 1.66667C6.78329 1.66667 4.16663 4.28334 4.16663 7.50001C4.16663 9.48334 5.15829 11.225 6.66663 12.2833V14.1667C6.66663 14.625 7.04163 15 7.49996 15H12.5C12.9583 15 13.3333 14.625 13.3333 14.1667V12.2833C14.8416 11.225 15.8333 9.48334 15.8333 7.50001C15.8333 4.28334 13.2166 1.66667 9.99996 1.66667ZM12.375 10.9167L11.6666 11.4167V13.3333H8.33329V11.4167L7.62496 10.9167C6.49996 10.1333 5.83329 8.85834 5.83329 7.50001C5.83329 5.20001 7.69996 3.33334 9.99996 3.33334C12.3 3.33334 14.1666 5.20001 14.1666 7.50001C14.1666 8.85834 13.5 10.1333 12.375 10.9167Z"></path></g>
      <g id="link"><path fill-rule="evenodd" clip-rule="evenodd" d="M9.16663 12.5H5.83329C4.45829 12.5 3.33329 11.375 3.33329 10C3.33329 8.62501 4.45829 7.50001 5.83329 7.50001H9.16663V5.83334H5.83329C3.53329 5.83334 1.66663 7.70001 1.66663 10C1.66663 12.3 3.53329 14.1667 5.83329 14.1667H9.16663V12.5ZM14.1666 5.83334H10.8333V7.50001H14.1666C15.5416 7.50001 16.6666 8.62501 16.6666 10C16.6666 11.375 15.5416 12.5 14.1666 12.5H10.8333V14.1667H14.1666C16.4666 14.1667 18.3333 12.3 18.3333 10C18.3333 7.70001 16.4666 5.83334 14.1666 5.83334ZM13.3333 9.16668H6.66663V10.8333H13.3333V9.16668Z"></path></g>
      <g id="location-on" viewBox="0 -960 960 960"><path d="M480.21-480Q510-480 531-501.21t21-51Q552-582 530.79-603t-51-21Q450-624 429-602.79t-21 51Q408-522 429.21-501t51 21ZM480-191q119-107 179.5-197T720-549q0-105-68.5-174T480-792q-103 0-171.5 69T240-549q0 71 60.5 161T480-191Zm0 95Q323.03-227.11 245.51-339.55 168-452 168-549q0-134 89-224.5T479.5-864q133.5 0 223 90.5T792-549q0 97-77 209T480-96Zm0-456Z"></path></g>
      <g id="logout"><path d="M14.1665 5.83333L12.9915 7.00833L15.1415 9.16667H6.6665V10.8333H15.1415L12.9915 12.9833L14.1665 14.1667L18.3332 10L14.1665 5.83333ZM3.33317 4.16667H9.99984V2.5H3.33317C2.4165 2.5 1.6665 3.25 1.6665 4.16667V15.8333C1.6665 16.75 2.4165 17.5 3.33317 17.5H9.99984V15.8333H3.33317V4.16667Z"></path></g>
      <g id="magic"><path d="m11 17-2-2 2-2 2 2-2 2Zm-6-2-5-5 5-5 5 5-5 5Zm7.5-6c0-1.25-.438-2.313-1.313-3.188C10.313 4.938 9.25 4.5 8 4.5c1.25 0 2.313-.438 3.188-1.313C12.062 2.313 12.5 1.25 12.5 0c0 1.25.438 2.313 1.313 3.188C14.687 4.061 15.75 4.5 17 4.5c-1.25 0-2.313.438-3.188 1.313C12.938 6.688 12.5 7.75 12.5 9Z"></path></g>
      <g id="manage-search"><path d="M8 9H2V7h6v2zm0 3H2v2h6v-2zm12.59 7l-3.83-3.83c-.8.52-1.74.83-2.76.83-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5c0 1.02-.31 1.96-.83 2.75L22 17.59 20.59 19zM17 11c0-1.65-1.35-3-3-3s-3 1.35-3 3 1.35 3 3 3 3-1.35 3-3zM2 19h13v-2H2v2z"></path></g>
      <g id="network-ping" viewBox="0 -960 960 960"><path d="M192-237v-72h240L96-645l51-51 333 333 199-199q-3-8-5-17t-2-18q0-40 28-68t68-28q40 0 68 28t28 68q0 40-28 68t-68 28q-11 0-20.5-2t-18.5-7L528-309h240v72H192Z"></path></g>
      <g id="notification-add"><path d="M20,7.69h-2.25V10h-1.5V7.69H14V6.31h2.25V4h1.5v2.31H20V7.69z M13.5,11v3h-7V9c0-1.93,1.57-3.5,3.5-3.5 c0.58,0,1.13,0.14,1.61,0.39l1.1-1.1C12.19,4.47,11.62,4.23,11,4.1V3c0-0.55-0.45-1-1-1S9,2.45,9,3v1.1C6.72,4.56,5,6.58,5,9v5H4 v1.5h12V14h-1v-3H13.5z M10,18c0.83,0,1.5-0.67,1.5-1.5h-3C8.5,17.33,9.17,18,10,18z"></path></g>
      <g id="pen-spark"><path d="M5.5 15.5H6.5625L14.375 7.6875L13.3125 6.625L5.5 14.4375V15.5ZM4 17V13.8125L14.375 3.4375C14.5278 3.28472 14.6944 3.17361 14.875 3.10417C15.0556 3.03472 15.2431 3 15.4375 3C15.6319 3 15.8194 3.03472 16 3.10417C16.1806 3.17361 16.3472 3.28472 16.5 3.4375L17.5625 4.5C17.7153 4.65278 17.8264 4.81944 17.8958 5C17.9653 5.18055 18 5.36806 18 5.5625C18 5.75694 17.9653 5.94444 17.8958 6.125C17.8264 6.30555 17.7153 6.47222 17.5625 6.625L7.1875 17H4ZM16.5 5.5625L15.4375 4.5L16.5 5.5625ZM13.8333 7.16667L13.3125 6.625L14.375 7.6875L13.8333 7.16667ZM5.5 10C5.5 8.75 5.0625 7.6875 4.1875 6.8125C3.3125 5.9375 2.25 5.5 1 5.5C2.25 5.5 3.3125 5.0625 4.1875 4.1875C5.0625 3.3125 5.5 2.25 5.5 0.999999C5.5 2.25 5.9375 3.3125 6.8125 4.1875C7.6875 5.0625 8.75 5.5 10 5.5C8.75 5.5 7.6875 5.9375 6.8125 6.8125C5.9375 7.6875 5.5 8.75 5.5 10Z"></path></g>
      <g id="performance-max"><path d="m4.625 14-1.083-1.062L8 8.5l3.25 3.25 4.146-4.021 1.062 1.063-5.208 5.104L8 10.625Zm6.625-5-.771-1.729L8.75 6.5l1.729-.771L11.25 4l.771 1.729 1.729.771-1.729.771Z"></path></g>
      <g id="pointer-lock"><path d="M10 9.168Zm0 9.164c-1.61 0-2.984-.566-4.125-1.707-1.14-1.14-1.707-2.516-1.707-4.125v-5c0-1.61.566-2.984 1.707-4.125C7.015 2.235 8.391 1.668 10 1.668c1.61 0 2.984.566 4.125 1.707 1.14 1.14 1.707 2.516 1.707 4.125v2.582a4.291 4.291 0 0 0-1.664 0v-.914H5.832V12.5c0 1.152.406 2.137 1.219 2.95.812.812 1.797 1.218 2.949 1.218.152 0 .297-.008.426-.023.133-.012.27-.036.406-.063v1.688a2.977 2.977 0 0 1-.406.054 13.92 13.92 0 0 1-.426.008ZM5.832 7.5h3.336V3.418c-.961.191-1.754.672-2.387 1.437A4.019 4.019 0 0 0 5.832 7.5Zm5 0h3.336c0-1-.316-1.883-.95-2.645-.632-.765-1.425-1.246-2.386-1.437Zm2.375 10.832a.682.682 0 0 1-.5-.207.69.69 0 0 1-.207-.5v-2.75c0-.195.07-.36.207-.5a.682.682 0 0 1 .5-.207h.125v-.836c0-.457.164-.848.492-1.176A1.593 1.593 0 0 1 15 11.668c.457 0 .852.16 1.176.488.328.328.492.719.492 1.176v.836h.125c.191 0 .36.066.5.207a.69.69 0 0 1 .207.5v2.75a.69.69 0 0 1-.207.5.682.682 0 0 1-.5.207Zm.961-4.164h1.664v-.836a.807.807 0 0 0-.238-.594A.807.807 0 0 0 15 12.5a.807.807 0 0 0-.594.238.807.807 0 0 0-.238.594Zm-4.168-5Zm.832-1.668Zm-1.664 0Zm0 0"></path></g>
      <g id="pointer-lock-off"><path d="M9.168 6.832Zm2.312 2.336Zm-2.73 1.937Zm.418-1.937Zm0 0ZM10.832 7.5ZM10 1.668c1.61 0 2.984.566 4.125 1.707 1.14 1.14 1.707 2.516 1.707 4.125v2.582a4.291 4.291 0 0 0-1.664 0v-.914H11.48L9.168 6.832V3.418a3.802 3.802 0 0 0-1.2.437c-.366.208-.698.465-.988.77L5.812 3.437a5.932 5.932 0 0 1 1.875-1.292A5.7 5.7 0 0 1 10 1.668ZM4.812 4.832l4.356 4.336H5.832V12.5c0 1.152.406 2.137 1.219 2.95.812.812 1.797 1.218 2.949 1.218.152 0 .297-.008.426-.023.133-.012.27-.036.406-.063v1.688a2.977 2.977 0 0 1-.406.054 13.92 13.92 0 0 1-.426.008c-1.61 0-2.984-.566-4.125-1.707-1.14-1.14-1.707-2.516-1.707-4.125v-5c0-.484.055-.953.164-1.395.113-.445.273-.87.48-1.273Zm6.02 2.668h3.336c0-1-.316-1.883-.95-2.645-.632-.765-1.425-1.246-2.386-1.437Zm6.23 11.918L.582 2.918 1.75 1.75l16.5 16.5Zm-3.855-1.086a.682.682 0 0 1-.5-.207.69.69 0 0 1-.207-.5V15c0-.234.078-.434.238-.594.16-.16.36-.238.594-.238h.836L17.5 17.5v.125a.69.69 0 0 1-.207.5.682.682 0 0 1-.5.207Zm3.461-3.914-.836-.836v-.25a.807.807 0 0 0-.238-.594A.807.807 0 0 0 15 12.5h-.105a.261.261 0 0 0-.102.02l-.625-.625c.125-.067.254-.125.395-.165.14-.043.285-.062.437-.062.457 0 .852.16 1.176.488.328.328.492.719.492 1.176Zm0 0"></path></g>
      <g id="preview" viewBox="0 -960 960 960"><path d="M216-144q-29.7 0-50.85-21.15Q144-186.3 144-216v-528q0-29.7 21.15-50.85Q186.3-816 216-816h528q29.7 0 50.85 21.15Q816-773.7 816-744v528q0 29.7-21.15 50.85Q773.7-144 744-144H216Zm0-72h528v-456H216v456Zm263.88-84Q406-300 348-340.5T264-444q26-63 84.12-103.5 58.11-40.5 132-40.5Q554-588 612-547.5T696-444q-26 63-84.12 103.5-58.11 40.5-132 40.5Zm.12-48q53 0 95.88-25.44Q618.76-398.88 643-444q-24.24-45.12-67.12-70.56Q533-540 480-540q-53 0-95.88 25.44Q341.24-489.12 317-444q24.24 45.12 67.12 70.56Q427-348 480-348Zm0-96Zm0 60q25 0 42.5-17.5T540-444q0-25-17.5-42.5T480-504q-25 0-42.5 17.5T420-444q0 25 17.5 42.5T480-384Z"></path></g>
      <!-- The polygon ("+" shape) within this icon will always be filled with
           the color #4285F4. Any color fills specified programmatically will
           only be applied to the outer layer. -->
      <g id="printer-add"><path d="M17.8734304,8.29826826 C17.2839707,8.10470383 16.6542128,8 16,8 C13.3875623,8 11.1650842,9.66961525 10.3414114,12 L7,12 L7,15 L10.0829584,15 C10.2034032,15.7179235 10.4513404,16.3926158 10.8026932,17 L5,17 L5,14 L2,14 L2,9 C2,7.8954305 2.8954305,7 4,7 L5,7 L5,3 L15,3 L15,7 L16,7 C16.8576527,7 17.5892179,7.53984453 17.8734304,8.29826826 Z M7,5 L7,7 L13,7 L13,5 L7,5 Z"></path><polygon fill="#4285F4" points="17 13 19 13 19 15 17 15 17 17 15 17 15 15 13 15 13 13 15 13 15 11 17 11"></polygon></g>
      <g id="privacy-screen" viewBox="0 -960 960 960"><path d="m168-555 141-141H168v141Zm0 240 381-381H411L168-453v138Zm51 51h573v-432H651L219-264Zm-51 72q-29.7 0-50.85-21.16Q96-234.32 96-264.04v-432.24Q96-726 117.15-747T168-768h624q29.7 0 50.85 21.16Q864-725.68 864-695.96v432.24Q864-234 842.85-213T792-192H168Z"></path></g>
      <g id="psychiatry"><path d="M9.25 17V10.8125H9.0625C8.27083 10.8125 7.50694 10.6667 6.77083 10.375C6.04861 10.0694 5.40278 9.63889 4.83333 9.08333C4.23611 8.51389 3.77778 7.85417 3.45833 7.10417C3.15278 6.35417 3 5.56944 3 4.75V3H4.75C5.54167 3 6.29861 3.15278 7.02083 3.45833C7.74306 3.75 8.38889 4.17361 8.95833 4.72917C9.36111 5.11805 9.69445 5.55555 9.95833 6.04167C10.2361 6.51389 10.4444 7.01389 10.5833 7.54167C11.1111 6.80556 11.7917 6.24305 12.625 5.85417C13.4583 5.45139 14.3333 5.25 15.25 5.25H17V7C17 7.81944 16.8403 8.60417 16.5208 9.35417C16.2153 10.1042 15.7639 10.7639 15.1667 11.3333C14.6111 11.8194 13.9931 12.1944 13.3125 12.4583C12.6319 12.7222 11.9236 12.8542 11.1875 12.8542H10.75V17H9.25ZM9.25 9.25C9.25 8.61111 9.13889 7.99306 8.91667 7.39583C8.70833 6.78472 8.38194 6.25694 7.9375 5.8125C7.49306 5.36805 6.96528 5.04167 6.35417 4.83333C5.75694 4.61111 5.13889 4.5 4.5 4.5C4.5 5.13889 4.60417 5.76389 4.8125 6.375C5.03472 6.97222 5.36806 7.49306 5.8125 7.9375C6.25694 8.38194 6.77778 8.71528 7.375 8.9375C7.98611 9.14583 8.61111 9.25 9.25 9.25ZM10.75 11.5C11.3889 11.5 12.0069 11.3958 12.6042 11.1875C13.2153 10.9653 13.7431 10.6319 14.1875 10.1875C14.6319 9.74305 14.9583 9.22222 15.1667 8.625C15.3889 8.01389 15.5 7.38889 15.5 6.75C14.8611 6.75 14.2361 6.86111 13.625 7.08333C13.0278 7.29167 12.5069 7.61805 12.0625 8.0625C11.6181 8.50694 11.2847 9.03472 11.0625 9.64583C10.8542 10.2431 10.75 10.8611 10.75 11.5Z"></path></g>
      <g id="public"><path fill-rule="evenodd" clip-rule="evenodd" d="M10 1.667A8.336 8.336 0 0 0 1.667 10c0 4.6 3.733 8.333 8.333 8.333S18.333 14.6 18.333 10 14.6 1.667 10 1.667zM3.333 10c0-.508.067-1.008.175-1.483L7.492 12.5v.833c0 .917.75 1.667 1.666 1.667v1.608C5.883 16.192 3.333 13.392 3.333 10zm9.992 3.333c.75 0 1.367.492 1.583 1.167a6.66 6.66 0 0 0 1.758-4.5 6.67 6.67 0 0 0-4.175-6.175v.342c0 .916-.75 1.666-1.666 1.666H9.158V7.5a.836.836 0 0 1-.833.833H6.658V10h5c.459 0 .834.375.834.833v2.5h.833z"></path></g>
      <g id="quick-reference-all"><path d="M4.5 3.5V7V9.02083C4.5 9.14583 4.5 9.68055 4.5 10.625C4.5 11.5694 4.5 12.6944 4.5 14C4.5 14.4583 4.5 14.9028 4.5 15.3333C4.5 15.75 4.5 16.1389 4.5 16.5V3.5V7V3.5ZM6 12H9.41667C9.54167 11.7222 9.6875 11.4583 9.85417 11.2083C10.0347 10.9583 10.2292 10.7222 10.4375 10.5H6V12ZM6 15H9.10417C9.04861 14.75 9.01389 14.5 9 14.25C8.98611 14 8.99306 13.75 9.02083 13.5H6V15ZM4.5 18C4.08333 18 3.72917 17.8542 3.4375 17.5625C3.14583 17.2708 3 16.9167 3 16.5V3.5C3 3.08333 3.14583 2.72917 3.4375 2.4375C3.72917 2.14583 4.08333 2 4.5 2H11L15 6V9.10417C14.75 9.04861 14.5 9.01389 14.25 9C14 8.98611 13.75 8.99305 13.5 9.02083V7H10V3.5H4.5V16.5H9.66667C9.83333 16.7917 10.0278 17.0694 10.25 17.3333C10.4722 17.5833 10.7222 17.8056 11 18H4.5ZM14 16C14.5556 16 15.0278 15.8056 15.4167 15.4167C15.8056 15.0278 16 14.5556 16 14C16 13.4444 15.8056 12.9722 15.4167 12.5833C15.0278 12.1944 14.5556 12 14 12C13.5556 12 13.1111 12.1667 12.6667 12.5C12.2222 12.8333 12 13.3333 12 14C12 14.5556 12.1944 15.0278 12.5833 15.4167C12.9722 15.8056 13.4444 16 14 16ZM17.9375 19L15.8958 16.9375C15.6181 17.1181 15.3194 17.2569 15 17.3542C14.6806 17.4514 14.3542 17.5 14.0208 17.5C13.0347 17.5 12.2014 17.1597 11.5208 16.4792C10.8403 15.7986 10.5 14.9722 10.5 14C10.5 13.0278 10.8403 12.2014 11.5208 11.5208C12.2014 10.8403 13.0278 10.5 14 10.5C14.9722 10.5 15.7986 10.8403 16.4792 11.5208C17.1597 12.2014 17.5 13.0278 17.5 14C17.5 14.3472 17.4514 14.6806 17.3542 15C17.2569 15.3194 17.1181 15.6181 16.9375 15.8958L19 17.9375L17.9375 19Z"></path></g>
      <g id="reviews"><path d="M7.6875 11.75L10 10.375L12.3125 11.75L11.6875 9.16667L13.7292 7.41667L11.0417 7.1875L10 4.75L8.95833 7.1875L6.27083 7.41667L8.3125 9.16667L7.6875 11.75ZM2 18V3.5C2 3.08333 2.14583 2.72917 2.4375 2.4375C2.72917 2.14583 3.08333 2 3.5 2H16.5C16.9167 2 17.2708 2.14583 17.5625 2.4375C17.8542 2.72917 18 3.08333 18 3.5V13.5C18 13.9167 17.8542 14.2708 17.5625 14.5625C17.2708 14.8542 16.9167 15 16.5 15H5L2 18ZM4.375 13.5H16.5V3.5H3.5V14.375L4.375 13.5ZM3.5 13.5V3.5V13.5Z"></path></g>
      <g id="router"><path d="M4.5 17c-.414 0-.766-.148-1.059-.441A1.449 1.449 0 0 1 3 15.5v-3.004c0-.414.148-.766.441-1.059A1.439 1.439 0 0 1 4.5 11h8V8H14v3h1.5c.426 0 .785.145 1.09.438.3.292.437.644.41 1.062v3a1.637 1.637 0 0 1-.469 1.05c-.285.302-.629.45-1.031.45Zm0-1.5h11v-3h-11Zm1.746-.75c.211 0 .39-.07.535-.215A.716.716 0 0 0 7 14.004c0-.211-.07-.39-.215-.535a.716.716 0 0 0-.531-.219c-.211 0-.39.07-.535.215a.716.716 0 0 0-.219.531c0 .211.07.39.215.535.14.145.32.219.531.219Zm2.75 0c.211 0 .39-.07.535-.215a.716.716 0 0 0 .219-.531c0-.211-.07-.39-.215-.535a.716.716 0 0 0-.531-.219c-.211 0-.39.07-.535.215a.716.716 0 0 0-.219.531c0 .211.07.39.215.535.14.145.32.219.531.219Zm2.75 0c.211 0 .39-.07.535-.215a.716.716 0 0 0 .219-.531c0-.211-.07-.39-.215-.535a.716.716 0 0 0-.531-.219c-.211 0-.39.07-.535.215a.716.716 0 0 0-.219.531c0 .211.07.39.215.535.14.145.32.219.531.219Zm.36-7.895-1.063-1.062c.289-.277.629-.48 1.02-.606a3.868 3.868 0 0 1 2.374 0c.391.125.731.329 1.02.606l-1.062 1.062a1.042 1.042 0 0 0-.532-.293 2.917 2.917 0 0 0-.613-.062c-.207 0-.414.02-.613.063-.203.042-.38.14-.532.292ZM10 4.75 8.918 3.668a5.052 5.052 0 0 1 1.988-1.273A7.132 7.132 0 0 1 13.25 2c.805 0 1.586.133 2.344.395a5.052 5.052 0 0 1 1.988 1.273L16.5 4.75a4.007 4.007 0 0 0-1.488-.95 5.25 5.25 0 0 0-1.762-.3c-.61 0-1.2.102-1.762.3A4.007 4.007 0 0 0 10 4.75ZM4.5 15.5v-3Zm0 0"></path></g>
      <g id="router-off"><path d="m12.105 6.855-1.062-1.062c.289-.277.629-.48 1.02-.606a3.868 3.868 0 0 1 2.374 0c.391.125.731.329 1.02.606l-1.062 1.062a1.042 1.042 0 0 0-.532-.293 2.917 2.917 0 0 0-.613-.062c-.207 0-.414.02-.613.063-.203.042-.38.14-.532.292ZM10 4.75 8.918 3.668a5.052 5.052 0 0 1 1.988-1.273A7.132 7.132 0 0 1 13.25 2c.805 0 1.586.133 2.344.395a5.052 5.052 0 0 1 1.988 1.273L16.5 4.75a4.007 4.007 0 0 0-1.488-.95 5.25 5.25 0 0 0-1.762-.3c-.61 0-1.2.102-1.762.3A4.007 4.007 0 0 0 10 4.75Zm7 10.125-4.5-4.508V8H14v3h1.5c.426 0 .785.145 1.09.438.3.292.437.644.41 1.062ZM4.5 15.5h8.875l-3-3H4.5ZM16 18.125 14.875 17H4.5c-.414 0-.766-.148-1.059-.441A1.449 1.449 0 0 1 3 15.5v-3.004c0-.414.148-.766.441-1.059A1.439 1.439 0 0 1 4.5 11h4.375l-7-7 1.063-1.063 14.124 14.126ZM6.254 14.75c-.211 0-.39-.07-.535-.215a.716.716 0 0 1-.219-.531c0-.211.07-.39.215-.535a.716.716 0 0 1 .531-.219c.211 0 .39.07.535.215.145.14.219.32.219.531 0 .211-.07.39-.215.535a.716.716 0 0 1-.531.219Zm2.75 0c-.211 0-.39-.07-.535-.215a.716.716 0 0 1-.219-.531c0-.211.07-.39.215-.535a.716.716 0 0 1 .531-.219c.211 0 .39.07.535.215.145.14.219.32.219.531 0 .211-.07.39-.215.535a.716.716 0 0 1-.531.219Zm2.75 0c-.211 0-.39-.07-.535-.215a.716.716 0 0 1-.219-.531c0-.211.07-.39.215-.535a.716.716 0 0 1 .531-.219c.211 0 .39.07.535.215.145.14.219.32.219.531 0 .211-.07.39-.215.535a.716.716 0 0 1-.531.219ZM4.5 15.5v-3Zm0 0"></path></g>
      <g id="rule-folder" viewBox="0 -960 960 960"><path d="m313-305 198-198-57-57-141 142-57-57-56 57 113 113Zm263 0 64-64 64 64 56-56-64-64 64-64-56-56-64 64-64-64-56 56 64 64-64 64 56 56ZM160-160q-33 0-56.5-23.5T80-240v-480q0-33 23.5-56.5T160-800h240l80 80h320q33 0 56.5 23.5T880-640v400q0 33-23.5 56.5T800-160H160Zm0-80h640v-400H447l-80-80H160v480Zm0 0v-480 480Z"></path></g>
      <g id="search-spark"><path d="M15.9375 17L10.9583 12.0208C10.5417 12.3264 10.0833 12.5694 9.58333 12.75C9.08333 12.9167 8.55556 13 8 13C6.61111 13 5.43056 12.5139 4.45833 11.5417C3.48611 10.5694 3 9.38889 3 8C3 6.61111 3.48611 5.43055 4.45833 4.45833C5.43056 3.48611 6.61111 3 8 3C8.36111 3 8.70139 3.03472 9.02083 3.10417C9.35417 3.17361 9.67361 3.27778 9.97917 3.41667L8.79167 4.58333C8.66667 4.55555 8.53472 4.53472 8.39583 4.52083C8.27083 4.50694 8.13889 4.5 8 4.5C7.02778 4.5 6.20139 4.84028 5.52083 5.52083C4.84028 6.20139 4.5 7.02778 4.5 8C4.5 8.97222 4.84028 9.79861 5.52083 10.4792C6.20139 11.1597 7.02778 11.5 8 11.5C8.80556 11.5 9.51389 11.2708 10.125 10.8125C10.7361 10.3403 11.1458 9.73611 11.3542 9H12.8958C12.8264 9.36111 12.7153 9.70833 12.5625 10.0417C12.4097 10.3611 12.2292 10.6667 12.0208 10.9583L17 15.9375L15.9375 17ZM14.5 10C14.5 8.75 14.0625 7.6875 13.1875 6.8125C12.3125 5.9375 11.25 5.5 10 5.5C11.25 5.5 12.3125 5.0625 13.1875 4.1875C14.0625 3.3125 14.5 2.25 14.5 0.999999C14.5 2.25 14.9375 3.3125 15.8125 4.1875C16.6875 5.0625 17.75 5.5 19 5.5C17.75 5.5 16.6875 5.9375 15.8125 6.8125C14.9375 7.6875 14.5 8.75 14.5 10Z"></path></g>
      <g id="security"><path fill-rule="evenodd" clip-rule="evenodd" d="M3.183 4.7L10 1.667 16.816 4.7v4.542c0 4.208-2.908 8.133-6.816 9.091-3.909-.958-6.817-4.883-6.817-9.091V4.7zM15.3 9.992H10V3.325L4.7 5.683V10l5.3-.008v6.775c2.816-.875 4.9-3.65 5.3-6.775z"></path></g>
      <g id="select-window"><path d="M17.5 0.833344H6.66671C5.75004 0.833344 5.00004 1.58334 5.00004 2.50001V7.50001H2.50004C1.58337 7.50001 0.833374 8.25001 0.833374 9.16668V17.5C0.833374 18.4167 1.58337 19.1667 2.50004 19.1667H13.3334C14.25 19.1667 15 18.4167 15 17.5V12.5H17.5C18.4167 12.5 19.1667 11.75 19.1667 10.8333V2.50001C19.1667 1.58334 18.4167 0.833344 17.5 0.833344ZM13.3334 17.5H2.50004V10.8333H13.3334V17.5ZM17.5 10.8333H15V9.16668C15 8.25001 14.25 7.50001 13.3334 7.50001H6.66671V4.16668H17.5V10.8333Z"></path></g>
      <g id="spam"><path d="M15.0714 6.66667V3.5H16.5V7.38889H15.0714V6.66667ZM15.0714 9.83333H16.5V8.38889H15.0714V9.83333ZM9.71429 10.9444C11.6214 10.9444 15.4286 11.9122 15.4286 13.8333V16H4V13.8333C4 11.9122 7.80714 10.9444 9.71429 10.9444ZM9.71429 4.44444C10.472 4.44444 11.1988 4.74881 11.7346 5.29058C12.2704 5.83235 12.5714 6.56715 12.5714 7.33333C12.5714 8.09951 12.2704 8.83431 11.7346 9.37609C11.1988 9.91786 10.472 10.2222 9.71429 10.2222C8.95652 10.2222 8.2298 9.91786 7.69398 9.37609C7.15816 8.83431 6.85714 8.09951 6.85714 7.33333C6.85714 6.56715 7.15816 5.83235 7.69398 5.29058C8.2298 4.74881 8.95652 4.44444 9.71429 4.44444ZM9.71429 12.3167C7.59286 12.3167 5.35714 13.3711 5.35714 13.8333V14.6278H14.0714V13.8333C14.0714 13.3711 11.8357 12.3167 9.71429 12.3167ZM9.71429 5.81667C9.31646 5.81667 8.93493 5.97646 8.65363 6.26089C8.37232 6.54532 8.21429 6.93109 8.21429 7.33333C8.21429 7.73558 8.37232 8.12135 8.65363 8.40578C8.93493 8.69021 9.31646 8.85 9.71429 8.85C10.1121 8.85 10.4936 8.69021 10.7749 8.40578C11.0563 8.12135 11.2143 7.73558 11.2143 7.33333C11.2143 6.93109 11.0563 6.54532 10.7749 6.26089C10.4936 5.97646 10.1121 5.81667 9.71429 5.81667Z"></path></g>
      <g id="sync-saved-locally"><path d="M 9.105469 11.707031 L 13.832031 7 L 12.644531 5.8125 L 9.105469 9.355469 L 7.332031 7.582031 L 6.167969 8.75 Z M 0.832031 17.5 L 0.832031 15.832031 L 19.167969 15.832031 L 19.167969 17.5 Z M 3.332031 15 C 2.875 15 2.484375 14.835938 2.15625 14.511719 C 1.828125 14.183594 1.667969 13.792969 1.667969 13.332031 L 1.667969 4.167969 C 1.667969 3.707031 1.828125 3.316406 2.15625 2.988281 C 2.484375 2.664062 2.875 2.5 3.332031 2.5 L 16.667969 2.5 C 17.125 2.5 17.515625 2.664062 17.84375 2.988281 C 18.171875 3.316406 18.332031 3.707031 18.332031 4.167969 L 18.332031 13.332031 C 18.332031 13.792969 18.171875 14.183594 17.84375 14.511719 C 17.515625 14.835938 17.125 15 16.667969 15 Z M 3.332031 13.332031 L 16.667969 13.332031 L 16.667969 4.167969 L 3.332031 4.167969 Z M 3.332031 13.332031 L 3.332031 4.167969 Z M 3.332031 13.332031 "></path></g>
      <g id="summarize"><path d="M6.75 7.5C6.95833 7.5 7.13194 7.43055 7.27083 7.29167C7.42361 7.13889 7.5 6.95833 7.5 6.75C7.5 6.54167 7.42361 6.36805 7.27083 6.22917C7.13194 6.07639 6.95833 6 6.75 6C6.54167 6 6.36111 6.07639 6.20833 6.22917C6.06944 6.36805 6 6.54167 6 6.75C6 6.95833 6.06944 7.13889 6.20833 7.29167C6.36111 7.43055 6.54167 7.5 6.75 7.5ZM6.75 10.75C6.95833 10.75 7.13194 10.6806 7.27083 10.5417C7.42361 10.3889 7.5 10.2083 7.5 10C7.5 9.79167 7.42361 9.61806 7.27083 9.47917C7.13194 9.32639 6.95833 9.25 6.75 9.25C6.54167 9.25 6.36111 9.32639 6.20833 9.47917C6.06944 9.61806 6 9.79167 6 10C6 10.2083 6.06944 10.3889 6.20833 10.5417C6.36111 10.6806 6.54167 10.75 6.75 10.75ZM6.75 14C6.95833 14 7.13194 13.9306 7.27083 13.7917C7.42361 13.6389 7.5 13.4583 7.5 13.25C7.5 13.0417 7.42361 12.8681 7.27083 12.7292C7.13194 12.5764 6.95833 12.5 6.75 12.5C6.54167 12.5 6.36111 12.5764 6.20833 12.7292C6.06944 12.8681 6 13.0417 6 13.25C6 13.4583 6.06944 13.6389 6.20833 13.7917C6.36111 13.9306 6.54167 14 6.75 14ZM4.5 17C4.08333 17 3.72917 16.8542 3.4375 16.5625C3.14583 16.2708 3 15.9167 3 15.5V4.5C3 4.08333 3.14583 3.72917 3.4375 3.4375C3.72917 3.14583 4.08333 3 4.5 3H13L17 7V15.5C17 15.9167 16.8542 16.2708 16.5625 16.5625C16.2708 16.8542 15.9167 17 15.5 17H4.5ZM4.5 15.5H15.5V8H12V4.5H4.5V15.5ZM4.5 4.5V7.75V4.5V7.75V15.5V4.5Z"></path></g>
      <g id="tab"><path d="M3.5 14.5H16.5V9H11V5.5H3.5V14.5ZM3.5 16C3.08333 16 2.72917 15.8542 2.4375 15.5625C2.14583 15.2708 2 14.9167 2 14.5V5.5C2 5.08333 2.14583 4.72917 2.4375 4.4375C2.72917 4.14583 3.08333 4 3.5 4H16.5C16.9167 4 17.2708 4.14583 17.5625 4.4375C17.8542 4.72917 18 5.08333 18 5.5V14.5C18 14.9167 17.8542 15.2708 17.5625 15.5625C17.2708 15.8542 16.9167 16 16.5 16H3.5ZM3.5 14.5V5.5V14.5Z"></path></g>
      <g id="table-chart-organize"><path d="M4.5 17C4.09722 17 3.74306 16.8542 3.4375 16.5625C3.14583 16.2569 3 15.9028 3 15.5V4.5C3 4.08333 3.14583 3.72917 3.4375 3.4375C3.74306 3.14583 4.09722 3 4.5 3H9.58333C9.47222 3.23611 9.36806 3.47917 9.27083 3.72917C9.1875 3.97917 9.125 4.23611 9.08333 4.5H4.5V6.75H9.14583C9.21528 7.02778 9.29861 7.29167 9.39583 7.54167C9.49306 7.77778 9.61111 8.01389 9.75 8.25H8V15.5H12V10.375C12.2361 10.5 12.4792 10.6042 12.7292 10.6875C12.9792 10.7708 13.2361 10.8403 13.5 10.8958V15.5H15.5V10.9167C15.7639 10.875 16.0208 10.8125 16.2708 10.7292C16.5208 10.6319 16.7639 10.5278 17 10.4167V15.5C17 15.9028 16.8472 16.2569 16.5417 16.5625C16.25 16.8542 15.9028 17 15.5 17H4.5ZM4.5 15.5H6.5V8.25H4.5V15.5ZM4.5 17H6.5H3C3 17 3.14583 17 3.4375 17C3.72917 17 4.08333 17 4.5 17ZM3 6.75C3 6.54167 3 6.33333 3 6.125C3 5.90278 3 5.68056 3 5.45833C3 5.01389 3 4.59028 3 4.1875C3 3.77083 3 3.375 3 3C3 3 3 3.14583 3 3.4375C3 3.72917 3 4.08333 3 4.5V6.75ZM8 17H12C11.5278 17 11.0972 17 10.7083 17C10.3333 17 10.0139 17 9.75 17H8ZM13.5 17H15.5C15.9167 17 16.2708 17 16.5625 17C16.8542 17 17 17 17 17C16.625 17 16.2292 17 15.8125 17C15.4097 17 14.9861 17 14.5417 17C14.3611 17 14.1806 17 14 17C13.8333 17 13.6667 17 13.5 17ZM14.5 10C14.5 8.75 14.0625 7.6875 13.1875 6.8125C12.3125 5.9375 11.25 5.5 10 5.5C11.25 5.5 12.3125 5.0625 13.1875 4.1875C14.0625 3.3125 14.5 2.25 14.5 0.999999C14.5 2.25 14.9375 3.3125 15.8125 4.1875C16.6875 5.0625 17.75 5.5 19 5.5C17.75 5.5 16.6875 5.9375 15.8125 6.8125C14.9375 7.6875 14.5 8.75 14.5 10Z"></path></g>
      <g id="text-analysis"><path d="M 2.5 17.5 L 2.5 15.832031 L 12.5 15.832031 L 12.5 17.5 Z M 2.5 13.332031 L 2.5 11.667969 L 17.5 11.667969 L 17.5 13.332031 Z M 2.5 9.167969 L 2.5 7.5 L 11.667969 7.5 L 11.667969 9.167969 Z M 14.582031 10 C 14.582031 8.722656 14.140625 7.640625 13.25 6.75 C 12.359375 5.859375 11.277344 5.417969 10 5.417969 C 11.277344 5.417969 12.359375 4.972656 13.25 4.082031 C 14.140625 3.195312 14.582031 2.109375 14.582031 0.832031 C 14.582031 2.109375 15.027344 3.195312 15.917969 4.082031 C 16.804688 4.972656 17.890625 5.417969 19.167969 5.417969 C 17.890625 5.417969 16.804688 5.859375 15.917969 6.75 C 15.027344 7.640625 14.582031 8.722656 14.582031 10 Z M 14.582031 10 "></path></g>
      <g id="text-compare"><path d="M8.5 19V17H4.5C4.08333 17 3.72917 16.8542 3.4375 16.5625C3.14583 16.2708 3 15.9167 3 15.5V4.5C3 4.08333 3.14583 3.72917 3.4375 3.4375C3.72917 3.14583 4.08333 3 4.5 3H8.5V0.999999H10V19H8.5ZM4.5 15.5H8.5V14H6V12.5H8.5V11H6V9.5H8.5V8H6V6.5H8.5V4.5H4.5V15.5ZM11.5 4.5V3H15.5C15.9167 3 16.2708 3.14583 16.5625 3.4375C16.8542 3.72917 17 4.08333 17 4.5V15.5C17 15.9167 16.8542 16.2708 16.5625 16.5625C16.2708 16.8542 15.9167 17 15.5 17H11.5V15.5H15.5V4.5H11.5ZM11.5 11V9.5H14V11H11.5ZM11.5 8V6.5H14V8H11.5Z"></path></g>
      <g id="timer"><path d="M7.5 3V1.5H12.5V3H7.5ZM9.25 12H10.75V7H9.25V12ZM10 18C9.02778 18 8.11806 17.8194 7.27083 17.4583C6.42361 17.0833 5.68056 16.5833 5.04167 15.9583C4.41667 15.3194 3.91667 14.5764 3.54167 13.7292C3.18056 12.8819 3 11.9722 3 11C3 10.0278 3.18056 9.11806 3.54167 8.27083C3.91667 7.42361 4.41667 6.6875 5.04167 6.0625C5.68056 5.42361 6.42361 4.92361 7.27083 4.5625C8.11806 4.1875 9.02778 4 10 4C10.8056 4 11.5764 4.13889 12.3125 4.41667C13.0625 4.68055 13.7569 5.05555 14.3958 5.54167L15.4792 4.47917L16.5208 5.52083L15.4583 6.60417C15.9444 7.22917 16.3194 7.91667 16.5833 8.66667C16.8611 9.41667 17 10.1944 17 11C17 11.9722 16.8125 12.8819 16.4375 13.7292C16.0764 14.5764 15.5764 15.3194 14.9375 15.9583C14.3125 16.5833 13.5764 17.0833 12.7292 17.4583C11.8819 17.8194 10.9722 18 10 18ZM10 16.5C11.5278 16.5 12.8264 15.9653 13.8958 14.8958C14.9653 13.8264 15.5 12.5278 15.5 11C15.5 9.47222 14.9653 8.17361 13.8958 7.10417C12.8264 6.03472 11.5278 5.5 10 5.5C8.47222 5.5 7.17361 6.03472 6.10417 7.10417C5.03472 8.17361 4.5 9.47222 4.5 11C4.5 12.5278 5.03472 13.8264 6.10417 14.8958C7.17361 15.9653 8.47222 16.5 10 16.5Z"></path></g>
      <g id="undo"><path d="M11.8335 15.8333H5.8335V14.5833H11.8543C12.8266 14.5833 13.6634 14.2604 14.3647 13.6146C15.0661 12.9687 15.4168 12.1666 15.4168 11.2083C15.4168 10.25 15.0661 9.4479 14.3647 8.80206C13.6634 8.15623 12.8266 7.83331 11.8543 7.83331H5.7085L8.0835 10.2083L7.2085 11.0833L3.3335 7.20831L7.2085 3.33331L8.0835 4.20831L5.7085 6.58331H11.8335C13.1529 6.58331 14.2884 7.02776 15.2397 7.91665C16.1911 8.80554 16.6668 9.90276 16.6668 11.2083C16.6668 12.5139 16.1911 13.6111 15.2397 14.5C14.2884 15.3889 13.1529 15.8333 11.8335 15.8333Z"></path></g>
      <g id="user-attributes-filled" viewBox="0 -960 960 960"><path d="M576-696v-72h288v72H576Zm0 156v-72h288v72H576Zm0 156v-72h288v72H576Zm-240-48q-50 0-85-35t-35-85q0-50 35-85t85-35q50 0 85 35t35 85q0 50-35 85t-85 35ZM96-192v-63q0-28 14.5-51t38.5-35q43-21 90-32t97-11q50 0 97 11t90 32q24 12 38.5 35t14.5 51v63H96Z"></path></g>
      <g id="volume-down"><path fill-rule="evenodd" clip-rule="evenodd" d="M1 13H4.46667L8 16.5V3.5L4.46667 7H1V13ZM10 6.5V13.5C11.776 12.8652 12.5 11.0043 12.5 10C12.5 8.99565 11.776 7.14348 10 6.5Z"></path></g>
      <g id="volume-zero"><path fill-rule="evenodd" clip-rule="evenodd" d="M1 13H4.46667L8 16.5V3.5L4.46667 7H1V13Z"></g>
      <g id="vpn-key"><path d="M10.4727273,8 C9.87272727,6.2525 8.26181818,5 6.36363636,5 C3.95272727,5 2,7.01375 2,9.5 C2,11.98625 3.95272727,14 6.36363636,14 C8.26181818,14 9.87272727,12.7475 10.4727273,11 L13.6363636,11 L13.6363636,14 L16.5454545,14 L16.5454545,11 L18,11 L18,8 L10.4727273,8 Z M6.36363636,11 C5.56,11 4.90909091,10.32875 4.90909091,9.5 C4.90909091,8.67125 5.56,8 6.36363636,8 C7.16727273,8 7.81818182,8.67125 7.81818182,9.5 C7.81818182,10.32875 7.16727273,11 6.36363636,11 Z"></path></g>
      <g id="vpn-key-new"><path d="M 5.832031 15.480469 C 4.324219 15.480469 3.035156 14.941406 1.960938 13.871094 C 0.890625 12.796875 0.355469 11.503906 0.355469 9.996094 C 0.355469 8.484375 0.890625 7.195312 1.960938 6.125 C 3.035156 5.054688 4.324219 4.519531 5.832031 4.519531 C 7.070312 4.519531 8.097656 4.828125 8.917969 5.4375 C 9.734375 6.046875 10.3125 6.777344 10.644531 7.625 L 19.644531 7.625 L 19.644531 12.375 L 17.4375 12.375 L 17.4375 15.230469 L 13.082031 15.230469 L 13.082031 12.375 L 10.640625 12.375 C 10.3125 13.222656 9.734375 13.953125 8.917969 14.5625 C 8.097656 15.171875 7.070312 15.480469 5.832031 15.480469 Z M 5.832031 13.75 C 6.890625 13.75 7.734375 13.390625 8.375 12.667969 C 9.015625 11.945312 9.359375 11.277344 9.410156 10.667969 L 14.894531 10.667969 L 14.894531 13.519531 L 15.707031 13.519531 L 15.707031 10.667969 L 17.917969 10.667969 L 17.917969 9.332031 L 9.417969 9.332031 C 9.359375 8.722656 9.015625 8.054688 8.375 7.332031 C 7.734375 6.609375 6.890625 6.25 5.832031 6.25 C 4.792969 6.25 3.90625 6.613281 3.175781 7.34375 C 2.449219 8.074219 2.082031 8.957031 2.082031 10 C 2.082031 11.042969 2.449219 11.925781 3.175781 12.65625 C 3.90625 13.386719 4.792969 13.75 5.832031 13.75 Z M 5.828125 11.644531 C 6.304688 11.644531 6.699219 11.488281 7.011719 11.171875 C 7.324219 10.855469 7.480469 10.46875 7.480469 10.003906 C 7.480469 9.53125 7.324219 9.136719 7.015625 8.824219 C 6.707031 8.511719 6.3125 8.355469 5.839844 8.355469 C 5.375 8.355469 4.984375 8.507812 4.667969 8.816406 C 4.347656 9.125 4.1875 9.519531 4.1875 9.996094 C 4.1875 10.457031 4.34375 10.847656 4.660156 11.167969 C 4.976562 11.484375 5.367188 11.644531 5.828125 11.644531 Z M 5.832031 10 Z M 5.832031 10"></path></g>
      <g id="web" viewBox="0 -960 960 960"><path d="M168-192q-29.7 0-50.85-21.16Q96-234.32 96-264.04v-432.24Q96-726 117.15-747T168-768h624q29.7 0 50.85 21.16Q864-725.68 864-695.96v432.24Q864-234 842.85-213T792-192H168Zm0-72h408v-120H168v120Zm480 0h144v-312H648v312ZM168-456h408v-120H168v120Z"></path></g>
      <g id="web-asset"><path fill-rule="evenodd" clip-rule="evenodd" d="M3.333 3.333h13.334c.924 0 1.666.75 1.666 1.667v10c0 .917-.75 1.667-1.666 1.667H3.332c-.925 0-1.667-.75-1.667-1.667V5c0-.917.742-1.667 1.667-1.667zm0 11.667h13.334V6.667H3.332V15z"></path></g>
      <g id="work" viewBox="0 -960 960 960"><path d="M168-144q-29.7 0-50.85-21.15Q96-186.3 96-216v-432q0-29.7 21.15-50.85Q138.3-720 168-720h168v-72.21Q336-822 357.18-843q21.17-21 50.91-21h144.17Q582-864 603-842.85q21 21.15 21 50.85v72h168q29.7 0 50.85 21.15Q864-677.7 864-648v432q0 29.7-21.15 50.85Q821.7-144 792-144H168Zm0-72h624v-432H168v432Zm240-504h144v-72H408v72ZM168-216v-432 432Z"></path></g>
      <g id="youtube-searched-for"><path d="M16.27 13.27c.77-1.07 1.24-2.36 1.24-3.77 0-3.59-2.91-6.5-6.5-6.5-3.46 0-6.28 2.7-6.48 6.11L3.22 7.79 1.8 9.21l3.71 3.71 3.71-3.71L7.8 7.79 6.56 9.04C6.79 6.77 8.68 5 11.01 5c2.49 0 4.5 2.01 4.5 4.5S13.5 14 11.01 14c-.86 0-1.65-.25-2.33-.67l-1.45 1.45C8.3 15.55 9.6 16 11.01 16c1.41 0 2.7-.47 3.77-1.24l5.73 5.73L22 19l-5.73-5.73z"></path></g>
    </defs>
  </svg>
</cr-iconset>

<!-- NOTE: In the common case that the final icon will be 20x20, export the SVG
     at 20px and place it in the section above. -->
<cr-iconset name="settings" size="24">
  <svg>
    <defs>
      <!-- Location disabled GM3 icon -->
      <g id="location-disabled" viewBox="0 -960 960 960">
        <path d="m784-286-58-58q17-30 25.5-64t8.5-70q0-116-82-198t-198-82q-36 0-70 8.5T346-724l-58-58q35-21 72.5-35t79.5-19v-80h80v80q125 14 214.5 103.5T838-518h80v80h-80q-5 42-19 79.5T784-286ZM440-40v-80q-125-14-214.5-103.5T122-438H42v-80h80q5-42 19-79.5t35-72.5L56-790l56-56 736 736-58 56-118-120q-35 21-72.5 35T520-120v80h-80Zm40-158q36 0 70-8.5t64-25.5L234-612q-17 30-25.5 64t-8.5 70q0 116 82 198t198 82Z"></path>
      </g>

      <!-- Fingerprint off GM3 icon -->
      <g id="fingerprint-off" viewBox="0 -960 960 960">
        <path d="M833-41 435-440q-19 11-29 28.5T396-374q0 92 55.5 161T601-120q8 2 12 9.5t2 15.5q-2 8-9 12t-15 2q-108-28-171.5-107.5T356-374q0-28 13-52.5t37-41.5l-42-42q-34 26-52 61t-18 75q0 75 25.5 132T405-123q6 6 6 14.5T405-94q-6 6-14.5 6T376-94q-66-67-94-130.5T254-374q0-48 22-91.5t60-73.5l-44-43q-58 54-80 99t-22 109q0 36 6.5 73t20.5 72q3 8 0 15t-11 10q-8 3-15.5 0T180-215q-15-42-22-81t-7-78q0-73 25.5-127.5T264-611l-41-41q-20 17-36.5 34.5T156-580q-4 7-12 8.5t-16-3.5q-7-5-8-13t4-15q14-21 32-40t39-37L42-834l42-42L876-84l-43 43ZM688-354q-8 0-14-5.5t-6-14.5q0-72-51-121t-121-54l-40-40q6-1 12.5-1H481q93 0 160 62.5T708-374q0 9-5.5 14.5T688-354ZM481-879q64 0 125 15.5T724-819q9 5 10.5 12t-1.5 14q-3 7-10 11t-17-1q-53-27-109.5-41.5T481-839q-58 0-113.5 13T261-784l-29-29q57-32 120-49t129-17Zm0 98q106 0 200 45.5T838-604q7 9 4.5 16t-8.5 12q-6 5-14 4.5t-14-8.5q-55-78-141.5-119.5T481-741q-39 0-76.5 7T332-713l-30-30q42-19 86.5-28.5T481-781Zm0 94q135 0 232 90t97 223q0 29-13 52.5T763-282l-28-28q16-11 25.5-27.5T770-374q0-116-85-195t-203-79q-20 0-38.5 2.5T407-638l-32-32q25-8 51.5-12.5T481-687Zm193 525q-89 0-152.5-61T458-373q0-8 5.5-14t14.5-6q9 0 14.5 6t5.5 14q0 72 52 121t124 49q6 0 17-.5t23-2.5q9-2 15.5 2.5T738-190q2 8-3 14t-13 8q-18 5-31.5 5.5t-16.5.5Z"></path>
      </g>

      <!-- Visibility off GM3 icon -->
      <g id="visibility-off" viewBox="0 -960 960 960">
        <path d="m644-428-58-58q9-47-27-88t-93-32l-58-58q17-8 34.5-12t37.5-4q75 0 127.5 52.5T660-500q0 20-4 37.5T644-428Zm128 126-58-56q38-29 67.5-63.5T832-500q-50-101-143.5-160.5T480-720q-29 0-57 4t-55 12l-62-62q41-17 84-25.5t90-8.5q151 0 269 83.5T920-500q-23 59-60.5 109.5T772-302Zm20 246L624-222q-35 11-70.5 16.5T480-200q-151 0-269-83.5T40-500q21-53 53-98.5t73-81.5L56-792l56-56 736 736-56 56ZM222-624q-29 26-53 57t-41 67q50 101 143.5 160.5T480-280q20 0 39-2.5t39-5.5l-36-38q-11 3-21 4.5t-21 1.5q-75 0-127.5-52.5T300-500q0-11 1.5-21t4.5-21l-84-82Zm319 93Zm-151 75Z"></path>
      </g>

      <!-- Domain verification GM3 icon -->
      <g id="domain-verification" viewBox="0 -960 960 960">
        <path d="M160-160q-33 0-56.5-23.5T80-240v-480q0-33 23.5-56.5T160-800h640q33 0 56.5 23.5T880-720v480q0 33-23.5 56.5T800-160H160Zm0-80h640v-400H160v400Zm278-58L296-440l58-58 84 84 168-168 58 58-226 226Zm-278 58v-480 480Z"></path>
      </g>

      <!-- Forward GM3 icon -->
      <g id="forward" viewBox="0 -960 960 960">
        <path d="m640-280-57-56 184-184-184-184 57-56 240 240-240 240ZM80-200v-160q0-83 58.5-141.5T280-560h247L383-704l57-56 240 240-240 240-57-56 144-144H280q-50 0-85 35t-35 85v160H80Z"></path>
      </g>

      <!-- Navigation: Accessibility disabled GM3 icon -->
      <g id="accessibility" viewBox="0 -960 960 960">
        <path d="M479.75-696q-34.75 0-59.25-24.75t-24.5-59.5q0-34.75 24.75-59.25t59.5-24.5q34.75 0 59.25 24.75t24.5 59.5q0 34.75-24.75 59.25t-59.5 24.5ZM360-108v-456H144v-72h672v72H600v456h-72l-9-220h-77l-10 220h-72Z"></path>
      </g>

      <!-- Navigation: Assignment disabled GM3 icon -->
      <g id="assignment" viewBox="0 -960 960 960">
        <path d="M288-384q39.6 0 67.8-28.2Q384-440.4 384-480q0-39.6-28.2-67.8Q327.6-576 288-576q-39.6 0-67.8 28.2Q192-519.6 192-480q0 39.6 28.2 67.8Q248.4-384 288-384Zm0 144q-100 0-170-70T48-480q0-100 70-170t170-70q72 0 131 39t89 105h332q29.7 0 50.85 21.15Q912-533.7 912-504v192q0 29.7-21.15 50.85Q869.7-240 840-240H696q-29.7 0-50.85-21.15Q624-282.3 624-312v-72H508q-30 66-89 105t-131 39Zm166-216h242v144h48v-72q0-10.4 6.8-17.2 6.8-6.8 17.2-6.8 10.4 0 17.2 6.8 6.8 6.8 6.8 17.2v72h48v-192H454q-8-63-55.62-103.5Q350.77-648 288-648q-70 0-119 49t-49 119q0 70 49 119t119 49q62.77 0 110.38-40.5Q446-393 454-456Z"></path>
      </g>

      <!-- Navigation: Download GM3 icon -->
      <g id="download" viewBox="0 -960 960 960">
        <path d="M480-336 288-528l51-51 105 105v-342h72v342l105-105 51 51-192 192ZM263.72-192Q234-192 213-213.15T192-264v-72h72v72h432v-72h72v72q0 29.7-21.16 50.85Q725.68-192 695.96-192H263.72Z"></path>
      </g>

      <!-- Navigation: Extension GM3 icon -->
      <g id="extension" viewBox="0 -960 960 960">
        <path d="M216-144q-29.7 0-50.85-21.15Q144-186.3 144-216v-168q40-2 68-29.5t28-66.5q0-39-28-66.5T144-576v-168q0-29.7 21.15-50.85Q186.3-816 216-816h168q0-40 27.77-68 27.78-28 68-28Q520-912 548-884.16q28 27.84 28 68.16h168q29.7 0 50.85 21.15Q816-773.7 816-744v168q40 0 68 27.77 28 27.78 28 68Q912-440 884.16-412q-27.84 28-68.16 28v168q0 29.7-21.15 50.85Q773.7-144 744-144H216Zm0-72h528v-528H216v112q45 20 70.5 61.5T312-480q0 50.21-25.5 91.6Q261-347 216-328v112Zm264-264Z"></path>
      </g>

      <!-- Navigation: Palette GM3 icon -->
      <g id="palette" viewBox="0 -960 960 960">
        <path d="M480-96q-79 0-149-30t-122.5-82.5Q156-261 126-331T96-480q0-80 30.5-149.5t84-122Q264-804 335.5-834T488-864q78 0 146.5 27T754-763q51 47 80.5 110T864-518q0 96-67 163t-163 67h-68q-8 0-14 5t-6 13q0 15 15 25t15 53q0 37-27 66.5T480-96Zm0-384Zm-216 36q25 0 42.5-17.5T324-504q0-25-17.5-42.5T264-564q-25 0-42.5 17.5T204-504q0 25 17.5 42.5T264-444Zm120-144q25 0 42.5-17.5T444-648q0-25-17.5-42.5T384-708q-25 0-42.5 17.5T324-648q0 25 17.5 42.5T384-588Zm192 0q25 0 42.5-17.5T636-648q0-25-17.5-42.5T576-708q-25 0-42.5 17.5T516-648q0 25 17.5 42.5T576-588Zm120 144q25 0 42.5-17.5T756-504q0-25-17.5-42.5T696-564q-25 0-42.5 17.5T636-504q0 25 17.5 42.5T696-444ZM480-168q11 0 17.5-8.5T504-192q0-16-15-28t-15-50q0-38 26.5-64t64.5-26h69q66 0 112-46t46-112q0-115-88.5-194.5T488-792q-134 0-227 91t-93 221q0 130 91 221t221 91Z"></path>
      </g>

      <!-- Navigation: Language GM3 icon -->
      <g id="navigation-language" viewBox="0 -960 960 960">
        <path d="m488-96 171-456h82L912-96h-79l-41-117H608L567-96h-79ZM169-216l-50-51 192-190q-36-38-67-79t-54-89h82q18 32 36 54.5t52 60.5q38-42 70-87.5t52-98.5H48v-72h276v-96h72v96h276v72H558q-21 69-61 127.5T409-457l91 90-28 74-112-112-191 189Zm463-63h136l-66-189-70 189Z"></path>
      </g>

      <!-- Navigation: Performance GM3 icon -->
      <g id="navigation-performance" viewBox="0 -960 960 960">
        <path d="M429-358q23 22 57 20.5t50-25.5l208-309-309.16 208.26Q410-447 408-413.5t21 55.5Zm52-410q60 0 108 15.5t87 38.5l-69 45q-28-13-58.5-20t-67.5-7q-130.09 0-221.55 93.5Q168-509 168-384q0 38 5.5 62.5T191-264h577q13-33 18.5-60.5T792-384q0-42-11.5-84T747-545l43-65q35 48 54.5 106T864-386q0 51-8.5 89T828-227q-10 17-25.5 26t-34.5 9H192q-19 0-34.5-9T132-227q-19-32-27.5-70T96-386q0-79.72 30.5-149.36Q157-605 209-656.5T331.44-738q70.44-30 149.56-30Zm-1 279Z"></path>
      </g>

      <!-- Navigation: Person GM3 icon -->
      <g id="person" viewBox="0 -960 960 960">
        <path d="M480-480q-66 0-113-47t-47-113q0-66 47-113t113-47q66 0 113 47t47 113q0 66-47 113t-113 47ZM160-160v-112q0-34 17.5-62.5T224-378q62-31 126-46.5T480-440q66 0 130 15.5T736-378q29 15 46.5 43.5T800-272v112H160Zm80-80h480v-32q0-11-5.5-20T700-306q-54-27-109-40.5T480-360q-56 0-111 13.5T260-306q-9 5-14.5 14t-5.5 20v32Zm240-320q33 0 56.5-23.5T560-640q0-33-23.5-56.5T480-720q-33 0-56.5 23.5T400-640q0 33 23.5 56.5T480-560Zm0-80Zm0 400Z"></path>
      </g>

      <!-- Navigation: Power settings GM3 icon -->
      <g id="power-settings" viewBox="0 -960 960 960">
        <path d="M444-432v-384h72v384h-72Zm36 288q-70 0-130.92-26.51-60.92-26.5-106.49-72.08-45.58-45.57-72.08-106.49Q144-410 144-480.16 144-556 176.5-624T268-740l51 51q-49 38-76 92.5T216-480q0 110 77.25 187t186.53 77Q590-216 667-293t77-187q0-61.84-26.5-116.92T641-689l51-51q60 48 92 115.8T816-480q0 70-26.6 130.92-26.6 60.92-71.87 106.49-45.26 45.58-106.4 72.08Q550-144 480-144Z"></path>
      </g>

      <!-- Navigation: Restore GM3 icon -->
      <g id="restore" viewBox="0 -960 960 960">
        <path d="M444-144q-107-14-179.5-94.5T192-430q0-61 23-113.5t63-91.5l51 51q-30 29-47.5 69T264-430q0 81 51.5 140T444-217v73Zm72 0v-73q77-13 128.5-72.5T696-430q0-90-63-153t-153-63h-7l46 46-51 50-132-132 132-132 51 51-45 45h6q120 0 204 84t84 204q0 111-72.5 192T516-144Z"></path>
      </g>

      <!-- Navigation: Search GM3 icon -->
      <g id="search" viewBox="0 -960 960 960">
        <path d="M765-144 526-383q-30 22-65.79 34.5-35.79 12.5-76.18 12.5Q284-336 214-406t-70-170q0-100 70-170t170-70q100 0 170 70t70 170.03q0 40.39-12.5 76.18Q599-464 577-434l239 239-51 51ZM384-408q70 0 119-49t49-119q0-70-49-119t-119-49q-70 0-119 49t-49 119q0 70 49 119t119 49Z"></path>
      </g>

      <!-- Navigation: Security GM3 icon -->
      <g id="security" viewBox="0 -960 960 960">
        <path d="M480-96q-135-33-223.5-153T168-515v-229l312-120 312 120v229q0 146-88.5 266T480-96Zm0-75q97-30 161.5-115.5T717-480H480v-307l-240 92v180q0 9 1 17.5t2 17.5h237v309Z"></path>
      </g>


      <!-- Navigation: System GM3 icon -->
      <g id="system" viewBox="0 -960 960 960">
        <path d="M666-163 475-354q-20 8-43.5 12.5T384-337q-99 0-169.5-70T144-576q0-37.78 9.5-71.89T182-711l144 144 70-70-144-144q29-17 62.5-26t69.5-9q100 0 170 71t70 170.19q0 22.81-4.5 42.31Q615-513 607-493l195 194q14 14.35 14 34.67Q816-244 802-230l-68 67q-14.09 14-34.04 14Q680-149 666-163Zm34-68 35-34-215-213q20-24 26-52.5t6-44.5q0-66.85-47.5-116.42Q457-741 390-744l82 81q11 11.18 11 26.09t-11.29 26.12L351.29-491.21Q340-480 325.82-480T301-491l-85-85q0 69 49.5 118T384-409q17 0 47-7t56-28l213 213ZM476-488Z"></path>
      </g>

      <!-- Navigation: Web GM3 icon -->
      <g id="web" viewBox="0 -960 960 960">
        <path d="M168-192q-29.7 0-50.85-21.16Q96-234.32 96-264.04v-432.24Q96-726 117.15-747T168-768h624q29.7 0 50.85 21.16Q864-725.68 864-695.96v432.24Q864-234 842.85-213T792-192H168Zm0-72h624v-360H168v360Z"></path>
      </g>


      <!-- Google Symbols: Print -->
      <g id="printer" viewBox="0 -960 960 960">
        <path d="M648-624v-120H312v120h-72v-192h480v192h-72Zm-480 72h625-625Zm539.789 96Q723-456 733.5-466.289q10.5-10.29 10.5-25.5Q744-507 733.711-517.5q-10.29-10.5-25.5-10.5Q693-528 682.5-517.711q-10.5 10.29-10.5 25.5Q672-477 682.289-466.5q10.29 10.5 25.5 10.5ZM648-216v-144H312v144h336Zm72 72H240v-144H96v-240q0-40 28-68t68-28h576q40 0 68 28t28 68v240H720v144Zm73-216v-153.672Q793-530 781-541t-28-11H206q-16.15 0-27.075 11.04T168-513.6V-360h72v-72h480v72h73Z"/>
      </g>

      <!-- Google Symbols: Print Disabled -->
      <g id="printer-off" viewBox="0 -960 960 960">
        <path d="m768-90-54-54H240v-144H96v-240q0-40 28-68t68-28h42L90-768l51-51 678 678-51 51ZM312-216h330L498-360H312v144Zm462-72-72-72h90v-153.672Q792-530 781.075-541T754-552H510l-72-72h330q40 0 68 28t28 68v240h-90Zm-606-72h72v-72h186L306-552h-99q-16 0-27.5 11.04T168-513.6V-360Zm480-264v-120H318l-72-72h474v192h-72Zm59.789 168Q723-456 733.5-466.289q10.5-10.29 10.5-25.5Q744-507 733.711-517.5q-10.29-10.5-25.5-10.5Q693-528 682.5-517.711q-10.5 10.29-10.5 25.5Q672-477 682.289-466.5q10.29 10.5 25.5 10.5ZM207-552h99-138 39Zm547 0h39-283 244Z"/>
      </g>

      <!-- Cookies Settings SVG -->
      <g id="block"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zM4 12c0-4.42 3.58-8 8-8 1.85 0 3.55.63 4.9 1.69L5.69 16.9C4.63 15.55 4 13.85 4 12zm8 8c-1.85 0-3.55-.63-4.9-1.69L18.31 7.1C19.37 8.45 20 10.15 20 12c0 4.42-3.58 8-8 8z"></path></g>

      <!-- The Google "G" icon in the Clear Browsing Data dialog. -->
      <g id="googleg">
        <path fill="#4285F4" d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z"></path>
        <path fill="#34A853" d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z"></path>
        <path fill="#FBBC05" d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z"></path>
        <path fill="#EA4335" d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z"></path>
        <path fill="none" d="M1 1h22v22H1z"></path>
      </g>

      <!-- Safebrowsing SVG -->
      <g id="public"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 17.93c-3.95-.49-7-3.85-7-7.93 0-.62.08-1.21.21-1.79L9 15v1c0 1.1.9 2 2 2v1.93zm6.9-2.54c-.26-.81-1-1.39-1.9-1.39h-1v-3c0-.55-.45-1-1-1H8v-2h2c.55 0 1-.45 1-1V7h2c1.1 0 2-.9 2-2v-.41c2.93 1.19 5 4.06 5 7.41 0 2.08-.8 3.97-2.1 5.39z"></path></g>

      <!-- Picture-in-picture SVG -->
      <g id="picture-in-picture"><path d="M4 20c-.55 0-1.02-.195-1.414-.586A1.935 1.935 0 0 1 2 18V6c0-.55.195-1.02.586-1.414C2.98 4.196 3.449 4 4 4h16c.55 0 1.02.195 1.414.586.39.394.586.863.586 1.414v12c0 .55-.195 1.02-.586 1.414-.394.39-.863.586-1.414.586Zm0-2h16V6H4Zm0 0V6Zm7-5h8V7h-8Zm2-2V9h4v2Zm0 0"></path></g>
      <g id="picture-in-picture-off"><path d="M15.852 13H19V7h-8v1.148l2 2V9h4v2h-3.148Zm5.921 5.926L20 17.148V6H8.852l-2-2H20c.55 0 1.02.195 1.414.586.39.394.586.863.586 1.414v12c0 .168-.016.328-.05.488-.032.157-.09.305-.177.438Zm-12.199-6.5Zm4.852-.852Zm6.023 11.727L17.15 20H4c-.55 0-1.02-.195-1.414-.586A1.935 1.935 0 0 1 2 18V6c0-.55.195-1.02.586-1.414C2.98 4.196 3.449 4 4 4l2 2H4v12h11.148L.648 3.5l1.426-1.426 19.801 19.801Zm0 0"></path></g>

      <!-- Touchpad-Mouse SVG -->
      <g id="touchpad-mouse"><path d="M16.5 20c.965 0 1.793-.34 2.477-1.023A3.377 3.377 0 0 0 20 16.5V15h-7v1.5c0 .965.34 1.793 1.023 2.477A3.377 3.377 0 0 0 16.5 20Zm-3.477-7H15.5v-2.852a3.438 3.438 0 0 0-1.637 1.051 3.392 3.392 0 0 0-.84 1.801Zm4.477 0h2.477a3.392 3.392 0 0 0-.84-1.8 3.438 3.438 0 0 0-1.637-1.052Zm-1 9c-1.535 0-2.832-.535-3.898-1.602C11.535 19.332 11 18.035 11 16.5v-3c0-1.535.535-2.832 1.602-3.898C13.668 8.535 14.965 8 16.5 8c1.535 0 2.832.535 3.898 1.602C21.465 10.668 22 11.965 22 13.5v3c0 1.535-.535 2.832-1.602 3.898C19.332 21.465 18.035 22 16.5 22ZM4 18V6Zm0 2c-.55 0-1.02-.195-1.414-.586A1.935 1.935 0 0 1 2 18V6c0-.55.195-1.02.586-1.414C2.98 4.196 3.449 4 4 4h16c.55 0 1.02.195 1.414.586.39.394.586.863.586 1.414v2.398a6.878 6.878 0 0 0-.926-.859A6.791 6.791 0 0 0 20 6.852V6H4v12h5.148c.086.352.18.691.29 1.023.109.336.246.66.414.977Zm0 0"></path></g>
      <g id="touchpad-mouse-off"><path d="M16.5 15.023Zm0 0Zm3.977 8.278L.676 3.5l1.426-1.426 19.796 19.801ZM16.5 15.023Zm0 0Zm0 6.977c-1.535 0-2.832-.535-3.898-1.602C11.535 19.332 11 18.035 11 16.5v-3c0-.383.04-.746.113-1.086.075-.344.18-.68.313-1.016L15.023 15H13v1.5c0 .965.34 1.793 1.023 2.477A3.377 3.377 0 0 0 16.5 20a3.4 3.4 0 0 0 1.363-.273 3.312 3.312 0 0 0 1.114-.778l1.421 1.426c-.5.5-1.082.895-1.75 1.188A5.27 5.27 0 0 1 16.5 22Zm5.05-3.324-1.6-1.602c.015-.097.03-.195.038-.285.008-.094.012-.187.012-.289V15h-2.125L15.5 12.625v-2.477a3.518 3.518 0 0 0-.813.364 3.38 3.38 0 0 0-.71.59L12.55 9.676a5.602 5.602 0 0 1 1.761-1.227C14.989 8.15 15.716 8 16.5 8c1.535 0 2.832.535 3.898 1.602C21.465 10.668 22 11.965 22 13.5v3c0 .383-.043.758-.125 1.125a6.991 6.991 0 0 1-.324 1.05ZM17.5 13h2.477a3.392 3.392 0 0 0-.84-1.8 3.438 3.438 0 0 0-1.637-1.052ZM9.926 9.898ZM4 20c-.55 0-1.02-.195-1.414-.586A1.935 1.935 0 0 1 2 18V6c0-.55.195-1.02.586-1.414C2.98 4.196 3.449 4 4 4h.023l2 2H4v12h5.148c.086.352.18.691.29 1.023.109.336.246.66.414.977ZM8.875 6l-2-2H20c.55 0 1.02.195 1.414.586.39.394.586.863.586 1.414Zm2.398 2.398Zm0 0"></path></g>

      <!-- Install-Desktop SVG for Web Install API -->
      <g id="install-desktop"><path d="M8 21v-2H4c-.55 0-1.02-.2-1.41-.59S2 17.55 2 17V5c0-.55.2-1.02.59-1.41S3.45 3 4 3h8v2H4v12h16v-3h2v3c0 .55-.2 1.02-.59 1.41S20.55 19 20 19h-4v2H8Zm9-7-5-5 1.4-1.4 2.6 2.58V3h2v7.18l2.6-2.58L22 9l-5 5Z"></path></g>
      <g id="install-desktop-off"><path d="m20 16.72 1.54 1.54c.3-.36.46-.78.46-1.26v-3h-2v2.72ZM8.28 5H12V3H6.28l2 2zM2.52 2.09 1.1 3.51l.97.97C2.03 4.64 2 4.81 2 5v12c0 .55.2 1.02.59 1.41S3.45 19 4 19h4v2h8v-2h.59l.29.29 2.62 2.62 1.43-1.42L2.52 2.09ZM4 17V6.41l3.3 3.3 5 5L14.59 17H4ZM17 14l-5-5 1.4-1.4 2.6 2.58V3h2v7.18l2.6-2.58L22 9l-5 5Z"></path></g>

      <!--
      These icons are copied from Polymer's iron-icons and kept in sorted order.
      See http://goo.gl/Y1OdAq for instructions on adding additional icons.
      -->
      <g id="apps"><path d="M4 8h4V4H4v4zm6 12h4v-4h-4v4zm-6 0h4v-4H4v4zm0-6h4v-4H4v4zm6 0h4v-4h-4v4zm6-10v4h4V4h-4zm-6 4h4V4h-4v4zm6 6h4v-4h-4v4zm0 6h4v-4h-4v4z"></path></g>
      <g id="bluetooth"><path d="M17.71 7.71L12 2h-1v7.59L6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 11 14.41V22h1l5.71-5.71-4.3-4.29 4.3-4.29zM13 5.83l1.88 1.88L13 9.59V5.83zm1.88 10.46L13 18.17v-3.76l1.88 1.88z"></path></g>
      <g id="bluetooth-off"><path d="M13 5.83l1.88 1.88-1.6 1.6 1.41 1.41 3.02-3.02L12 2h-1v5.03l2 2v-3.2zM5.41 4L4 5.41 10.59 12 5 17.59 6.41 19 11 14.41V22h1l4.29-4.29 2.3 2.29L20 18.59 5.41 4zM13 18.17v-3.76l1.88 1.88L13 18.17z"></path></g>
      <g id="bluetooth-scanning"><path d="M14.24 12.01l2.32 2.32c.28-.72.44-1.51.44-2.33 0-.82-.16-1.59-.43-2.31l-2.33 2.32zm5.29-5.3l-1.26 1.26c.63 1.21.98 2.57.98 4.02s-.36 2.82-.98 4.02l1.2 1.2a9.936 9.936 0 0 0 1.54-5.31c-.01-1.89-.55-3.67-1.48-5.19zm-3.82 1L10 2H9v7.59L4.41 5 3 6.41 8.59 12 3 17.59 4.41 19 9 14.41V22h1l5.71-5.71-4.3-4.29 4.3-4.29zM11 5.83l1.88 1.88L11 9.59V5.83zm1.88 10.46L11 18.17v-3.76l1.88 1.88z"></path></g>
      <g id="cloud"><path d="M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96z"></path></g>
      <g id="compose"><path d="M5.39583 9.97917C5.39583 8.70139 4.95139 7.61806 4.0625 6.72917C3.17361 5.84028 2.09028 5.39583 0.8125 5.39583C2.09028 5.39583 3.17361 4.95139 4.0625 4.0625C4.95139 3.17361 5.39583 2.08333 5.39583 0.791665C5.39583 2.08333 5.84028 3.17361 6.72917 4.0625C7.61806 4.95139 8.70139 5.39583 9.97917 5.39583C8.70139 5.39583 7.61806 5.84028 6.72917 6.72917C5.84028 7.61806 5.39583 8.70139 5.39583 9.97917ZM5.39583 15.6042H6.39583L14.125 7.85417L13.625 7.33333L13.1458 6.875L5.39583 14.625V15.6042ZM3.83333 17.1667V13.9583L14.25 3.52083C14.5694 3.21528 14.9444 3.0625 15.375 3.0625C15.8056 3.0625 16.1736 3.21528 16.4792 3.52083L17.4792 4.52083C17.7847 4.82639 17.9375 5.20139 17.9375 5.64583C17.9375 6.07639 17.7847 6.44444 17.4792 6.75L7.04167 17.1667H3.83333ZM16.3333 5.58333L15.3542 4.64583L16.3333 5.58333ZM14.125 7.85417L13.625 7.33333L13.1458 6.875L14.125 7.85417Z"></path></g>
      <g id="content-copy"><path d="M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"></path></g>
      <g id="devices" viewBox="0 -960 960 960"><path d="M96-192v-96h96v-408q0-29.7 21.15-50.85Q234.3-768 264-768h552v72H264v408h216v96H96Zm516.28 0q-15.28 0-25.78-10.34-10.5-10.34-10.5-25.63v-359.74q0-15.29 10.34-25.79t25.62-10.5h215.76q15.28 0 25.78 10.34 10.5 10.34 10.5 25.63v359.74q0 15.29-10.34 25.79T828.04-192H612.28ZM648-288h144v-264H648v264Zm0 0h144-144Z"></path></g>
      <g id="email"><path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"></path></g>
      <g id="exit-to-app"><path d="M10.09 15.59L11.5 17l5-5-5-5-1.41 1.41L12.67 11H3v2h9.67l-2.58 2.59zM19 3H5c-1.11 0-2 .9-2 2v4h2V5h14v14H5v-4H3v4c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2z"></path></g>
      <g id="feedback" viewBox="0 0 24 24"><path d="M20 2H4c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 14H5.17l-.59.59-.58.58V4h16v12zm-9-4h2v2h-2zm0-6h2v4h-2z"></path></g>
      <g id="file-handling"><path d="M8 16h8v2H8v-2zm0-4h8v2H8v-2zm6-10H6c-1.1 0-2 .9-2 2v16c0 1.1.89 2 1.99 2H18c1.1 0 2-.9 2-2V8l-6-6zm4 18H6V4h7v5h5v11z" fill="#5F6368"></path></g>
      <g id="file-handling-off"><path d="M13.002 4.001H7.106L5.252 2.148c.232-.094.485-.147.75-.147h8l6 6v8.896l-2-2V9.001h-5v-5z" fill="#5F6368"></path><path d="M16.002 12.001h-.896l.896.896v-.896zM.6 3.45l1.414-1.414 19.94 19.94-1.414 1.414L.6 3.45zM3.986 20.01V6.84l2 2V20.01h11.172l1.765 1.766c-.28.15-.599.234-.937.234H5.976c-1.1 0-1.99-.9-1.99-2z" fill="#5F6368"></path><path d="M9.158 12.01H7.986v2h3.172l-2-2zM13.158 16.01H7.986v2h7.172l-2-2z" fill="#5F6368"></path></g>
      <g id="hid-device"><path d="M20 6H4C2.9 6 2 6.9 2 8V16C2 17.1 2.9 18 4 18H20C21.1 18 22 17.1 22 16V8C22 6.9 21.1 6 20 6ZM11 13H9V15H7V13H5V11H7V9H9V11H11V13ZM14.5 15C13.67 15 13 14.33 13 13.5C13 12.67 13.67 12 14.5 12C15.33 12 16 12.67 16 13.5C16 14.33 15.33 15 14.5 15ZM17.5 12C16.67 12 16 11.33 16 10.5C16 9.67 16.67 9 17.5 9C18.33 9 19 9.67 19 10.5C19 11.33 18.33 12 17.5 12Z"></path></g>
      <g id="hid-device-off"><path d="M20.424 17.88C21.108 17.616 21.6 16.932 21.6 16.128V7.872C21.6 6.84 20.796 6 19.8 6H8.54399L20.424 17.88ZM17.4 9.3C18.228 9.3 18.9 9.972 18.9 10.8C18.9 11.628 18.228 12.3 17.4 12.3C16.572 12.3 15.9 11.628 15.9 10.8C15.9 9.972 16.572 9.3 17.4 9.3ZM20.484 20.484L3.51599 3.516L2.24399 4.788L3.57599 6.12C2.89199 6.384 2.39999 7.068 2.39999 7.872V16.128C2.39999 17.16 3.20399 18 4.19999 18H15.456L19.212 21.756L20.484 20.484ZM9.05999 12.9V15H7.25999V12.9H5.15999V11.1H7.25999V9.804L10.356 12.9H9.05999Z"></path></g>
      <g id="language"><path d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zm6.93 6h-2.95c-.32-1.25-.78-2.45-1.38-3.56 1.84.63 3.37 1.91 4.33 3.56zM12 4.04c.83 1.2 1.48 2.53 1.91 3.96h-3.82c.43-1.43 1.08-2.76 1.91-3.96zM4.26 14C4.1 13.36 4 12.69 4 12s.1-1.36.26-2h3.38c-.08.66-.14 1.32-.14 2 0 .68.06 1.34.14 2H4.26zm.82 2h2.95c.32 1.25.78 2.45 1.38 3.56-1.84-.63-3.37-1.9-4.33-3.56zm2.95-8H5.08c.96-1.66 2.49-2.93 4.33-3.56C8.81 5.55 8.35 6.75 8.03 8zM12 19.96c-.83-1.2-1.48-2.53-1.91-3.96h3.82c-.43 1.43-1.08 2.76-1.91 3.96zM14.34 14H9.66c-.09-.66-.16-1.32-.16-2 0-.68.07-1.35.16-2h4.68c.09.65.16 1.32.16 2 0 .68-.07 1.34-.16 2zm.25 5.56c.6-1.11 1.06-2.31 1.38-3.56h2.95c-.96 1.65-2.49 2.93-4.33 3.56zM16.36 14c.08-.66.14-1.32.14-2 0-.68-.06-1.34-.14-2h3.38c.16.64.26 1.31.26 2s-.1 1.36-.26 2h-3.38z"></path></g>
      <g id="location-on" viewBox="0 -960 960 960">
        <path d="M480.28-96q-13.71 0-23.49-7.5Q447-111 443-123q-19-53-45.5-100.5T321-335q-49-63-79.5-121T211-595.21Q211-707 289.3-785.5 367.6-864 480-864q112.4 0 190.7 78.42Q749-707.15 749-594.57q0 87.57-33.5 145.07T639-335q-52 68-78.5 114.5T517-123q-5 12-14.5 19.5T480.28-96ZM480-223q17-34 38.5-67.27Q540-323.55 582-379q42-54 68.5-100.36Q677-525.71 677-595q0-81-58-139t-139.5-58q-81.5 0-139 58T283-595q0 69.29 27 115.64Q337-433 378-379q42 55.45 63.5 88.73Q463-257 480-223Zm0-275q40 0 68.5-28.5T577-595q0-40-28.5-68.5T480-692q-40 0-68.5 28.5T383-595q0 40 28.5 68.5T480-498Zm0-97Z"></path>
      </g>
      <g id="mic-off"><path d="M19,11h-2c0,0.91-0.25,1.76-0.68,2.49l1.45,1.45C18.54,13.82,19,12.47,19,11z M2.81,2.81L1.39,4.22l11.66,11.66 C12.71,15.96,12.36,16,12,16c-2.76,0-5-2.24-5-5H5c0,3.53,2.61,6.43,6,6.92V21h2v-3.08c0.57-0.08,1.12-0.24,1.64-0.45l5.14,5.14 l1.41-1.41L2.81,2.81z M15,11V5c0-1.66-1.34-3-3-3S9,3.34,9,5v1.17l5.81,5.81C14.92,11.67,15,11.35,15,11z"></path></g>
      <g id="music-note"><path d="M12 3v10.55c-.59-.34-1.27-.55-2-.55-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4V7h4V3h-6z"></path></g>
      <g id="notifications-none"><path d="M12 22c1.1 0 2-.9 2-2h-4c0 1.1.9 2 2 2zm6-6v-5c0-3.07-1.63-5.64-4.5-6.32V4c0-.83-.67-1.5-1.5-1.5s-1.5.67-1.5 1.5v.68C7.64 5.36 6 7.92 6 11v5l-2 2v1h16v-1l-2-2zm-2 1H8v-6c0-2.48 1.51-4.5 4-4.5s4 2.02 4 4.5v6z"></path></g>
      <g id="performance"><path d="M0 0h24v24H0z" fill="none"></path><path d="m20.38 8.57-1.23 1.85a8 8 0 0 1-.22 7.58H5.07A8 8 0 0 1 15.58 6.85l1.85-1.23A10 10 0 0 0 3.35 19a2 2 0 0 0 1.72 1h13.85a2 2 0 0 0 1.74-1 10 10 0 0 0-.27-10.44zm-9.79 6.84a2 2 0 0 0 2.83 0l5.66-8.49-8.49 5.66a2 2 0 0 0 0 2.83z"></path></g>
      <g id="refresh"><path d="M17.65 6.35C16.2 4.9 14.21 4 12 4c-4.42 0-7.99 3.58-7.99 8s3.57 8 7.99 8c3.73 0 6.84-2.55 7.73-6h-2.08c-.82 2.33-3.04 4-5.65 4-3.31 0-6-2.69-6-6s2.69-6 6-6c1.66 0 3.14.69 4.22 1.78L13 11h7V4l-2.35 2.35z"></path></g>
      <g id="rotate-right"><path d="M15.55 5.55L11 1v3.07C7.06 4.56 4 7.92 4 12s3.05 7.44 7 7.93v-2.02c-2.84-.48-5-2.94-5-5.91s2.16-5.43 5-5.91V10l4.55-4.45zM19.93 11c-.17-1.39-.72-2.73-1.62-3.89l-1.42 1.42c.54.75.88 1.6 1.02 2.47h2.02zM13 17.9v2.02c1.39-.17 2.74-.71 3.9-1.61l-1.44-1.44c-.75.54-1.59.89-2.46 1.03zm3.89-2.42l1.42 1.41c.9-1.16 1.45-2.5 1.62-3.89h-2.02c-.14.87-.48 1.72-1.02 2.48z"></path></g>
      <g id="sync-disabled"><path d="M10 6.35V4.26c-.8.21-1.55.54-2.23.96l1.46 1.46c.25-.12.5-.24.77-.33zm-7.14-.94l2.36 2.36C4.45 8.99 4 10.44 4 12c0 2.21.91 4.2 2.36 5.64L4 20h6v-6l-2.24 2.24C6.68 15.15 6 13.66 6 12c0-1 .25-1.94.68-2.77l8.08 8.08c-.25.13-.5.25-.77.34v2.09c.8-.21 1.55-.54 2.23-.96l2.36 2.36 1.27-1.27L4.14 4.14 2.86 5.41zM20 4h-6v6l2.24-2.24C17.32 8.85 18 10.34 18 12c0 1-.25 1.94-.68 2.77l1.46 1.46C19.55 15.01 20 13.56 20 12c0-2.21-.91-4.2-2.36-5.64L20 4z"></path></g>
      <g id="sync-problem"><path d="M3 12c0 2.21.91 4.2 2.36 5.64L3 20h6v-6l-2.24 2.24C5.68 15.15 5 13.66 5 12c0-2.61 1.67-4.83 4-5.65V4.26C5.55 5.15 3 8.27 3 12zm8 5h2v-2h-2v2zM21 4h-6v6l2.24-2.24C18.32 8.85 19 10.34 19 12c0 2.61-1.67 4.83-4 5.65v2.09c3.45-.89 6-4.01 6-7.74 0-2.21-.91-4.2-2.36-5.64L21 4zm-10 9h2V7h-2v6z"></path></g>
      <g id="volume-down"><path d="M1 13H4.46667L8 16.5V3.5L4.46667 7H1V13ZM10 6.5V13.5C11.776 12.8652 12.5 11.0043 12.5 10C12.5 8.99565 11.776 7.14348 10 6.5Z"></path></g>
      <g id="volume-up"><path d="M3 9v6h4l5 5V4L7 9H3zm13.5 3c0-1.77-1.02-3.29-2.5-4.03v8.05c1.48-.73 2.5-2.25 2.5-4.02zM14 3.23v2.06c2.89.86 5 3.54 5 6.71s-2.11 5.85-5 6.71v2.06c4.01-.91 7-4.49 7-8.77s-2.99-7.86-7-8.77z"></path></g>
      <g id="volume-up-off"><path d="M16.25,13.42C16.4,12.97,16.5,12.5,16.5,12c0-1.77-1.02-3.29-2.5-4.03v3.2L16.25,13.42z"></path><path d="M19,12c0,1.21-0.31,2.34-0.85,3.32l1.46,1.46C20.48,15.39,21,13.76,21,12c0-4.28-2.99-7.86-7-8.77v2.06 C16.89,6.15,19,8.83,19,12z"></path><path d="M2.81,2.81L1.39,4.22L6.17,9H3v6h4l5,5v-5.17l3.32,3.32c-0.42,0.23-0.85,0.43-1.32,0.56v2.06c1-0.23,1.94-0.62,2.79-1.15 l2.99,2.99l1.41-1.41L2.81,2.81z"></path><polygon points="12,9.17 12,4 9.41,6.59"></polygon></g>
    </defs>
  </svg>
</cr-iconset>
`;const iconsets$2=div$2.querySelectorAll("cr-iconset");for(const iconset of iconsets$2){document.head.appendChild(iconset)}
// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function sanitizeInnerHtmlInternal(rawString,opts){opts=opts||{};const html=parseHtmlSubset(`<b>${rawString}</b>`,opts.tags,opts.attrs).firstElementChild;return html.innerHTML}let sanitizedPolicy=null;function sanitizeInnerHtml(rawString,opts){assert(window.trustedTypes);if(sanitizedPolicy===null){sanitizedPolicy=window.trustedTypes.createPolicy("sanitize-inner-html",{createHTML:sanitizeInnerHtmlInternal,createScript:()=>assertNotReached(),createScriptURL:()=>assertNotReached()})}return sanitizedPolicy.createHTML(rawString,opts)}const allowAttribute=(_node,_value)=>true;const allowedAttributes=new Map([["href",(node,value)=>node.tagName==="A"&&(value.startsWith("chrome://")||value.startsWith("https://")||value==="#")],["target",(node,value)=>node.tagName==="A"&&value==="_blank"]]);const allowedOptionalAttributes=new Map([["class",allowAttribute],["id",allowAttribute],["is",(_node,value)=>value==="action-link"||value===""],["role",(_node,value)=>value==="link"],["src",(node,value)=>node.tagName==="IMG"&&value.startsWith("chrome://")],["tabindex",allowAttribute],["aria-description",allowAttribute],["aria-hidden",allowAttribute],["aria-label",allowAttribute],["aria-labelledby",allowAttribute]]);const allowedTags=new Set(["A","B","I","BR","DIV","EM","KBD","P","PRE","SPAN","STRONG"]);const allowedOptionalTags=new Set(["IMG","LI","UL"]);let unsanitizedPolicy;function mergeTags(optTags){const clone=new Set(allowedTags);optTags.forEach((str=>{const tag=str.toUpperCase();if(allowedOptionalTags.has(tag)){clone.add(tag)}}));return clone}function mergeAttrs(optAttrs){const clone=new Map(allowedAttributes);optAttrs.forEach((key=>{if(allowedOptionalAttributes.has(key)){clone.set(key,allowedOptionalAttributes.get(key))}}));return clone}function walk(n,f){f(n);for(let i=0;i<n.childNodes.length;i++){walk(n.childNodes[i],f)}}function assertElement(tags,node){if(!tags.has(node.tagName)){throw Error(node.tagName+" is not supported")}}function assertAttribute(attrs,attrNode,node){const n=attrNode.nodeName;const v=attrNode.nodeValue||"";if(!attrs.has(n)||!attrs.get(n)(node,v)){throw Error(node.tagName+"["+n+'="'+v+'"] is not supported')}}function parseHtmlSubset(s,extraTags,extraAttrs){const tags=extraTags?mergeTags(extraTags):allowedTags;const attrs=extraAttrs?mergeAttrs(extraAttrs):allowedAttributes;const doc=document.implementation.createHTMLDocument("");const r=doc.createRange();r.selectNode(doc.body);if(window.trustedTypes){if(!unsanitizedPolicy){unsanitizedPolicy=window.trustedTypes.createPolicy("parse-html-subset",{createHTML:untrustedHTML=>untrustedHTML,createScript:()=>assertNotReached(),createScriptURL:()=>assertNotReached()})}s=unsanitizedPolicy.createHTML(s)}const df=r.createContextualFragment(s);walk(df,(function(node){switch(node.nodeType){case Node.ELEMENT_NODE:assertElement(tags,node);const nodeAttrs=node.attributes;for(let i=0;i<nodeAttrs.length;++i){assertAttribute(attrs,nodeAttrs[i],node)}break;case Node.COMMENT_NODE:case Node.DOCUMENT_FRAGMENT_NODE:case Node.TEXT_NODE:break;default:throw Error("Node type "+node.nodeType+" is not supported")}}));return df}
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const I18nMixinLit=superClass=>{class I18nMixinLit extends superClass{i18nRaw_(id,...varArgs){return varArgs.length===0?loadTimeData.getString(id):loadTimeData.getStringF(id,...varArgs)}i18n(id,...varArgs){const rawString=this.i18nRaw_(id,...varArgs);return parseHtmlSubset(`<b>${rawString}</b>`).firstChild.textContent}i18nAdvanced(id,opts){opts=opts||{};const rawString=this.i18nRaw_(id,...opts.substitutions||[]);return sanitizeInnerHtml(rawString,opts)}i18nDynamic(_locale,id,...varArgs){return this.i18n(id,...varArgs)}i18nRecursive(locale,id,...varArgs){let args=varArgs;if(args.length>0){args=args.map((str=>this.i18nExists(str)?loadTimeData.getString(str):str))}return this.i18nDynamic(locale,id,...args)}i18nExists(id){return loadTimeData.valueExists(id)}}return I18nMixinLit};const styleMod$a=document.createElement("dom-module");styleMod$a.appendChild(html$1`
  <template>
    <style>
[hidden],:host([hidden]){display:none !important}
    </style>
  </template>
`.content);styleMod$a.register("cr-hidden-style");const styleMod$9=document.createElement("dom-module");styleMod$9.appendChild(html$1`
  <template>
    <style>
.icon-arrow-back{--cr-icon-image:url(//resources/images/icon_arrow_back.svg)}.icon-arrow-dropdown{--cr-icon-image:url(//resources/images/icon_arrow_dropdown.svg)}.icon-arrow-drop-down-cr23{--cr-icon-image:url(//resources/images/icon_arrow_drop_down_cr23.svg)}.icon-arrow-drop-up-cr23{--cr-icon-image:url(//resources/images/icon_arrow_drop_up_cr23.svg)}.icon-arrow-upward{--cr-icon-image:url(//resources/images/icon_arrow_upward.svg)}.icon-cancel{--cr-icon-image:url(//resources/images/icon_cancel.svg)}.icon-clear{--cr-icon-image:url(//resources/images/icon_clear.svg)}.icon-copy-content{--cr-icon-image:url(//resources/images/icon_copy_content.svg)}.icon-delete-gray{--cr-icon-image:url(//resources/images/icon_delete_gray.svg)}.icon-edit{--cr-icon-image:url(//resources/images/icon_edit.svg)}.icon-file{--cr-icon-image:url(//resources/images/icon_filetype_generic.svg)}.icon-folder-open{--cr-icon-image:url(//resources/images/icon_folder_open.svg)}.icon-picture-delete{--cr-icon-image:url(//resources/images/icon_picture_delete.svg)}.icon-expand-less{--cr-icon-image:url(//resources/images/icon_expand_less.svg)}.icon-expand-more{--cr-icon-image:url(//resources/images/icon_expand_more.svg)}.icon-external{--cr-icon-image:url(//resources/images/open_in_new.svg)}.icon-more-vert{--cr-icon-image:url(//resources/images/icon_more_vert.svg)}.icon-refresh{--cr-icon-image:url(//resources/images/icon_refresh.svg)}.icon-search{--cr-icon-image:url(//resources/images/icon_search.svg)}.icon-settings{--cr-icon-image:url(//resources/images/icon_settings.svg)}.icon-visibility{--cr-icon-image:url(//resources/images/icon_visibility.svg)}.icon-visibility-off{--cr-icon-image:url(//resources/images/icon_visibility_off.svg)}.subpage-arrow{--cr-icon-image:url(//resources/images/arrow_right.svg)}.cr-icon{-webkit-mask-image:var(--cr-icon-image);-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-icon-size);background-color:var(--cr-icon-color,var(--owl-control-accent-color,var(--google-grey-700)));flex-shrink:0;height:var(--cr-icon-ripple-size);margin-inline-end:var(--cr-icon-ripple-margin);margin-inline-start:var(--cr-icon-button-margin-start);user-select:none;width:var(--cr-icon-ripple-size)}:host-context([dir=rtl]) .cr-icon{transform:scaleX(-1)}.cr-icon.no-overlap{margin-inline-end:0;margin-inline-start:0}@media (prefers-color-scheme:dark){.cr-icon{background-color:var(--cr-icon-color,var(--owl-control-accent-color,var(--google-grey-500)))}}
    </style>
  </template>
`.content);styleMod$9.register("cr-icons");const styleMod$8=document.createElement("dom-module");styleMod$8.appendChild(html$1`
  <template>
    <style include="cr-hidden-style cr-icons">
[actionable]{cursor:pointer}.hr{border-top:var(--cr-separator-line)}iron-list.cr-separators>*:not([first]){border-top:var(--cr-separator-line)}[scrollable]{border-color:transparent;border-style:solid;border-width:1px 0;overflow-y:auto}[scrollable].is-scrolled{border-top-color:var(--cr-scrollable-border-color)}[scrollable].can-scroll:not(.scrolled-to-bottom){border-bottom-color:var(--cr-scrollable-border-color)}[scrollable] iron-list>:not(.no-outline):focus-visible,[selectable]:focus-visible,[selectable]>:focus-visible{outline:solid 2px var(--cr-focus-outline-color);outline-offset:-2px}.scroll-container{display:flex;flex-direction:column;min-height:1px}[selectable]>*{cursor:pointer}.cr-centered-card-container{box-sizing:border-box;display:block;height:inherit;margin:0 auto;max-width:var(--cr-centered-card-max-width);min-width:550px;position:relative;width:calc(100% * var(--cr-centered-card-width-percentage))}.cr-container-shadow{height:var(--cr-container-shadow-height);left:0;margin:0 0 var(--cr-container-shadow-margin);opacity:0;pointer-events:none;position:relative;right:0;top:0;transition:opacity 500ms;z-index:1}#cr-container-shadow-bottom{margin-bottom:0;margin-top:var(--cr-container-shadow-margin);transform:scaleY(-1)}#cr-container-shadow-top:has(+#container.can-scroll:not(.scrolled-to-top)),#container.can-scroll:not(.scrolled-to-bottom)+#cr-container-shadow-bottom,#cr-container-shadow-bottom.force-shadow,#cr-container-shadow-top.force-shadow{opacity:var(--cr-container-shadow-max-opacity)}.cr-row{align-items:center;border-top:var(--cr-separator-line);display:flex;min-height:var(--cr-section-min-height);padding:0 var(--cr-section-padding)}.cr-row.first,.cr-row.continuation{border-top:none}.cr-row-gap{padding-inline-start:16px}.cr-button-gap{margin-inline-start:8px}paper-tooltip::part(tooltip),cr-tooltip::part(tooltip){border-radius:var(--paper-tooltip-border-radius,2px);font-size:92.31%;font-weight:500;max-width:330px;min-width:var(--paper-tooltip-min-width,200px);padding:var(--paper-tooltip-padding,10px 8px)}.cr-padded-text{padding-block-end:var(--cr-section-vertical-padding);padding-block-start:var(--cr-section-vertical-padding)}.cr-title-text{color:var(--cr-title-text-color);font-size:107.6923%;font-weight:500}.cr-secondary-text{color:var(--cr-secondary-text-color);font-weight:400}.cr-form-field-label{color:var(--cr-form-field-label-color);display:block;font-size:var(--cr-form-field-label-font-size);font-weight:500;letter-spacing:.4px;line-height:var(--cr-form-field-label-line-height);margin-bottom:8px}.cr-vertical-tab{align-items:center;display:flex}.cr-vertical-tab::before{border-radius:0 3px 3px 0;content:'';display:block;flex-shrink:0;height:var(--cr-vertical-tab-height,100%);width:4px}.cr-vertical-tab.selected::before{background:var(--cr-vertical-tab-selected-color,var(--cr-checked-color))}:host-context([dir=rtl]) .cr-vertical-tab::before{transform:scaleX(-1)}.iph-anchor-highlight{background-color:var(--cr-iph-anchor-highlight-color)}
    </style>
  </template>
`.content);styleMod$8.register("cr-shared-style");let instance$J=null;function getCss$q(){return instance$J||(instance$J=[...[],css`:host ::slotted([slot=view]){bottom:0;display:none;left:0;position:absolute;right:0;top:0}:host([show-all]) ::slotted([slot=view]){display:block;position:initial}:host ::slotted(.active),:host ::slotted(.closing){display:block}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$m(){return html`<slot name="view"></slot>`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getEffectiveView(element){return element.matches("cr-lazy-render, cr-lazy-render-lit")?element.get():element}function dispatchCustomEvent(element,eventType){element.dispatchEvent(new CustomEvent(eventType,{bubbles:true,composed:true}))}const viewAnimations=new Map;viewAnimations.set("fade-in",(element=>{const animation=element.animate([{opacity:0},{opacity:1}],{duration:180,easing:"ease-in-out",iterations:1});return animation.finished}));viewAnimations.set("fade-out",(element=>{const animation=element.animate([{opacity:1},{opacity:0}],{duration:180,easing:"ease-in-out",iterations:1});return animation.finished}));viewAnimations.set("slide-in-fade-in-ltr",(element=>{const animation=element.animate([{transform:"translateX(-8px)",opacity:0},{transform:"translateX(0)",opacity:1}],{duration:300,easing:"cubic-bezier(0.0, 0.0, 0.2, 1)",fill:"forwards",iterations:1});return animation.finished}));viewAnimations.set("slide-in-fade-in-rtl",(element=>{const animation=element.animate([{transform:"translateX(8px)",opacity:0},{transform:"translateX(0)",opacity:1}],{duration:300,easing:"cubic-bezier(0.0, 0.0, 0.2, 1)",fill:"forwards",iterations:1});return animation.finished}));class CrViewManagerElement extends CrLitElement{static get is(){return"cr-view-manager"}static get styles(){return getCss$q()}render(){return getHtml$m.bind(this)()}exit_(element,animation){const animationFunction=viewAnimations.get(animation);element.classList.remove("active");element.classList.add("closing");dispatchCustomEvent(element,"view-exit-start");if(!animationFunction){element.classList.remove("closing");dispatchCustomEvent(element,"view-exit-finish");return Promise.resolve()}return animationFunction(element).then((()=>{element.classList.remove("closing");dispatchCustomEvent(element,"view-exit-finish")}))}enter_(view,animation){const animationFunction=viewAnimations.get(animation);const effectiveView=getEffectiveView(view);effectiveView.classList.add("active");dispatchCustomEvent(effectiveView,"view-enter-start");if(!animationFunction){dispatchCustomEvent(effectiveView,"view-enter-finish");return Promise.resolve()}return animationFunction(effectiveView).then((()=>{dispatchCustomEvent(effectiveView,"view-enter-finish")}))}switchView(newViewId,enterAnimation,exitAnimation){return this.switchViews([newViewId],enterAnimation,exitAnimation)}switchViews(newViewIds,enterAnimation,exitAnimation){const previousViews=this.querySelectorAll(".active");const newViews=newViewIds.length===0?[]:this.querySelectorAll(newViewIds.map((id=>`#${id}`)).join(","));assert(newViews.length===newViewIds.length);const promises=[];for(const view of previousViews){promises.push(this.exit_(view,exitAnimation||"fade-out"))}for(const view of newViews){promises.push(this.enter_(view,enterAnimation||(previousViews.length===0?"no-animation":"fade-out")))}return Promise.all(promises).then((()=>{}))}}customElements.define(CrViewManagerElement.is,CrViewManagerElement);
// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CLASS_NAME="focus-outline-visible";const docsToManager=new Map;class FocusOutlineManager{focusByKeyboard_=true;classList_;constructor(doc){this.classList_=doc.documentElement.classList;doc.addEventListener("keydown",(e=>this.onEvent_(true,e)),true);doc.addEventListener("mousedown",(e=>this.onEvent_(false,e)),true);this.updateVisibility()}onEvent_(focusByKeyboard,e){if(this.focusByKeyboard_===focusByKeyboard){return}if(e instanceof KeyboardEvent&&e.repeat){return}this.focusByKeyboard_=focusByKeyboard;this.updateVisibility()}updateVisibility(){this.visible=this.focusByKeyboard_}set visible(visible){this.classList_.toggle(CLASS_NAME,visible)}get visible(){return this.classList_.contains(CLASS_NAME)}static forDocument(doc){let manager=docsToManager.get(doc);if(!manager){manager=new FocusOutlineManager(doc);docsToManager.set(doc,manager)}return manager}}let instance$I=null;function getCss$p(){return instance$I||(instance$I=[...[getCss$x()],css`:host{--cr-button-background-color:transparent;--cr-button-border-color:var(--color-button-border,var(--cr-fallback-color-tonal-outline));--cr-button-text-color:var(--color-button-foreground,var(--cr-fallback-color-primary));--cr-button-ripple-opacity:1;--cr-button-ripple-color:var(--cr-active-background-color);--cr-button-disabled-background-color:transparent;--cr-button-disabled-border-color:var(--color-button-border-disabled,var(--cr-fallback-color-disabled-background));--cr-button-disabled-text-color:var(--color-button-foreground-disabled,var(--cr-fallback-color-disabled-foreground))}:host(.action-button){--cr-button-background-color:var(--color-button-background-prominent,var(--cr-fallback-color-primary));--cr-button-text-color:var(--color-button-foreground-prominent,var(--cr-fallback-color-on-primary));--cr-button-ripple-color:var(--cr-active-on-primary-background-color);--cr-button-border:none;--cr-button-disabled-background-color:var(--color-button-background-prominent-disabled,var(--cr-fallback-color-disabled-background));--cr-button-disabled-text-color:var(--color-button-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-button-disabled-border:none}:host(.tonal-button),:host(.floating-button){--cr-button-background-color:var(--color-button-background-tonal,var(--cr-fallback-color-secondary-container));--cr-button-text-color:var(--color-button-foreground-tonal,var(--cr-fallback-color-on-tonal-container));--cr-button-border:none;--cr-button-disabled-background-color:var(--color-button-background-tonal-disabled,var(--cr-fallback-color-disabled-background));--cr-button-disabled-text-color:var(--color-button-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-button-disabled-border:none}:host{flex-shrink:0;display:inline-flex;align-items:center;justify-content:center;box-sizing:border-box;min-width:5.14em;height:var(--cr-button-height);padding:8px 16px;outline-width:0;overflow:hidden;position:relative;cursor:pointer;user-select:none;-webkit-tap-highlight-color:transparent;border:var(--cr-button-border,1px solid var(--cr-button-border-color));border-radius:8px;background:var(--cr-button-background-color);color:var(--cr-button-text-color);font-weight:500;line-height:20px;isolation:isolate}@media (forced-colors:active){:host{forced-color-adjust:none}}:host(.floating-button){border-radius:8px;height:40px;transition:box-shadow 80ms linear}:host(.floating-button:hover){box-shadow:var(--cr-elevation-3)}:host([has-prefix-icon_]),:host([has-suffix-icon_]){--iron-icon-height:20px;--iron-icon-width:20px;--icon-block-padding-large:16px;--icon-block-padding-small:12px;gap:8px;padding-block-end:8px;padding-block-start:8px}:host([has-prefix-icon_]){padding-inline-end:var(--icon-block-padding-large);padding-inline-start:var(--icon-block-padding-small)}:host([has-suffix-icon_]){padding-inline-end:var(--icon-block-padding-small);padding-inline-start:var(--icon-block-padding-large)}#background{border-radius:inherit;inset:0;pointer-events:none;position:absolute}#content{display:inline}#hoverBackground{content:'';display:none;inset:0;pointer-events:none;position:absolute;z-index:1}:host(:hover) #hoverBackground{background:var(--cr-hover-background-color);display:block}:host(.action-button:hover) #hoverBackground{background:var(--cr-hover-on-prominent-background-color)}:host([disabled]){background:var(--cr-button-disabled-background-color);border:var(--cr-button-disabled-border,1px solid var(--cr-button-disabled-border-color));color:var(--cr-button-disabled-text-color);cursor:auto;pointer-events:none}:host(.cancel-button){margin-inline-end:8px}:host(.action-button),:host(.cancel-button){line-height:154%}#ink{color:var(--cr-button-ripple-color);--paper-ripple-opacity:var(--cr-button-ripple-opacity)}#background{z-index:0}#hoverBackground,cr-ripple{z-index:1}#content,::slotted(*){z-index:2}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$l(){return html`
<div id="background"></div>
<slot id="prefixIcon" name="prefix-icon"
    @slotchange="${this.onPrefixIconSlotChanged_}">
</slot>
<span id="content"><slot></slot></span>
<slot id="suffixIcon" name="suffix-icon"
    @slotchange="${this.onSuffixIconSlotChanged_}">
</slot>
<div id="hoverBackground" part="hoverBackground"></div>`}
// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrButtonElementBase=CrRippleMixin(CrLitElement);class CrButtonElement extends CrButtonElementBase{static get is(){return"cr-button"}static get styles(){return getCss$p()}render(){return getHtml$l.bind(this)()}static get properties(){return{disabled:{type:Boolean,reflect:true},hasPrefixIcon_:{type:Boolean,reflect:true},hasSuffixIcon_:{type:Boolean,reflect:true}}}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#hasPrefixIcon__accessor_storage=false;get hasPrefixIcon_(){return this.#hasPrefixIcon__accessor_storage}set hasPrefixIcon_(value){this.#hasPrefixIcon__accessor_storage=value}#hasSuffixIcon__accessor_storage=false;get hasSuffixIcon_(){return this.#hasSuffixIcon__accessor_storage}set hasSuffixIcon_(value){this.#hasSuffixIcon__accessor_storage=value}spaceKeyDown_=false;timeoutIds_=new Set;constructor(){super();this.addEventListener("blur",this.onBlur_.bind(this));this.addEventListener("click",this.onClick_.bind(this));this.addEventListener("keydown",this.onKeyDown_.bind(this));this.addEventListener("keyup",this.onKeyUp_.bind(this));this.ensureRippleOnPointerdown()}firstUpdated(){if(!this.hasAttribute("role")){this.setAttribute("role","button")}if(!this.hasAttribute("tabindex")){this.setAttribute("tabindex","0")}FocusOutlineManager.forDocument(document)}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("disabled")){this.setAttribute("aria-disabled",this.disabled?"true":"false");this.disabledChanged_(this.disabled,changedProperties.get("disabled"))}}disconnectedCallback(){super.disconnectedCallback();this.timeoutIds_.forEach(clearTimeout);this.timeoutIds_.clear()}setTimeout_(fn,delay){if(!this.isConnected){return}const id=setTimeout((()=>{this.timeoutIds_.delete(id);fn()}),delay);this.timeoutIds_.add(id)}disabledChanged_(newValue,oldValue){if(!newValue&&oldValue===undefined){return}if(this.disabled){this.blur()}this.setAttribute("tabindex",String(this.disabled?-1:0))}onBlur_(){this.spaceKeyDown_=false;this.setTimeout_((()=>this.getRipple().uiUpAction()),100)}onClick_(e){if(this.disabled){e.stopImmediatePropagation()}}onPrefixIconSlotChanged_(){this.hasPrefixIcon_=this.$.prefixIcon.assignedElements().length>0}onSuffixIconSlotChanged_(){this.hasSuffixIcon_=this.$.suffixIcon.assignedElements().length>0}onKeyDown_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(e.repeat){return}this.getRipple().uiDownAction();if(e.key==="Enter"){this.click();this.setTimeout_((()=>this.getRipple().uiUpAction()),100)}else if(e.key===" "){this.spaceKeyDown_=true}}onKeyUp_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(this.spaceKeyDown_&&e.key===" "){this.spaceKeyDown_=false;this.click();this.getRipple().uiUpAction()}}}customElements.define(CrButtonElement.is,CrButtonElement);let instance$H=null;function getCss$o(){return instance$H||(instance$H=[...[],css`.cr-scrollable{anchor-name:--cr-scrollable;anchor-scope:--cr-scrollable;container-type:scroll-state;overflow:auto}.cr-scrollable-top,.cr-scrollable-top-shadow,.cr-scrollable-bottom{display:none;position:fixed;position-anchor:--cr-scrollable;left:anchor(left);width:anchor-size(width);pointer-events:none;&:where(.force-on){display:block}}.cr-scrollable-top{top:anchor(top);border-top:1px solid var(--cr-scrollable-border-color);@container scroll-state(scrollable:top){display:block}}.cr-scrollable-bottom{bottom:anchor(bottom);border-bottom:1px solid var(--cr-scrollable-border-color);@container scroll-state(scrollable:bottom){display:block}}.cr-scrollable-top-shadow{box-shadow:inset 0 5px 6px -3px rgba(0,0,0,.4);display:block;height:8px;opacity:0;top:anchor(top);transition:opacity 500ms;z-index:1;&:where(.force-on){opacity:1}@container scroll-state(scrollable:top){opacity:1}}`])}let instance$G=null;function getCss$n(){return instance$G||(instance$G=[...[getCss$x(),getCss$s(),getCss$o()],css`dialog{background-color:var(--cr-dialog-background-color,white);border:0;border-radius:var(--cr-dialog-border-radius,8px);bottom:50%;box-shadow:0 0 16px rgba(0,0,0,0.12),0 16px 16px rgba(0,0,0,0.24);color:inherit;line-height:20px;max-height:initial;max-width:initial;overflow-y:hidden;padding:0;position:absolute;top:50%;width:var(--cr-dialog-width,512px)}@media (prefers-color-scheme:dark){dialog{background-color:var(--cr-dialog-background-color,var(--google-grey-900));background-image:linear-gradient(rgba(255,255,255,.04),rgba(255,255,255,.04))}}@media (forced-colors:active){dialog{border:var(--cr-border-hcm)}}dialog[open] #content-wrapper{display:flex;flex-direction:column;max-height:100vh;overflow:auto}.top-container,:host ::slotted([slot=button-container]),:host ::slotted([slot=footer]){flex-shrink:0}dialog::backdrop{background-color:rgba(0,0,0,0.6);bottom:0;left:0;position:fixed;right:0;top:0}:host ::slotted([slot=body]){color:var(--cr-secondary-text-color);padding:0 var(--cr-dialog-body-padding-horizontal,20px)}:host ::slotted([slot=title]){color:var(--cr-primary-text-color);flex:1;font-family:var(--cr-dialog-font-family,inherit);font-size:var(--cr-dialog-title-font-size,calc(15 / 13 * 100%));line-height:1;padding-bottom:var(--cr-dialog-title-slot-padding-bottom,16px);padding-inline-end:var(--cr-dialog-title-slot-padding-end,20px);padding-inline-start:var(--cr-dialog-title-slot-padding-start,20px);padding-top:var(--cr-dialog-title-slot-padding-top,20px)}:host ::slotted([slot=button-container]){display:flex;justify-content:flex-end;padding-bottom:var(--cr-dialog-button-container-padding-bottom,16px);padding-inline-end:var(--cr-dialog-button-container-padding-horizontal,16px);padding-inline-start:var(--cr-dialog-button-container-padding-horizontal,16px);padding-top:var(--cr-dialog-button-container-padding-top,16px)}:host ::slotted([slot=footer]){border-bottom-left-radius:inherit;border-bottom-right-radius:inherit;border-top:1px solid #dbdbdb;margin:0;padding:16px 20px}:host([hide-backdrop]) dialog::backdrop{opacity:0}@media (prefers-color-scheme:dark){:host ::slotted([slot=footer]){border-top-color:var(--cr-separator-color)}}.body-container{box-sizing:border-box;display:flex;flex-direction:column;min-height:1.375rem;overflow:auto}.top-container{align-items:flex-start;display:flex;min-height:var(--cr-dialog-top-container-min-height,31px)}.title-container{display:flex;flex:1;font-size:inherit;font-weight:inherit;margin:0;outline:none}#close{align-self:flex-start;margin-inline-end:4px;margin-top:4px}@container style(--cr-dialog-body-border-top){.cr-scrollable-top{display:block;border-top:var(--cr-dialog-body-border-top)}}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$k(){return html`
<dialog id="dialog" @close="${this.onNativeDialogClose_}"
    @cancel="${this.onNativeDialogCancel_}" part="dialog"
    aria-labelledby="title"
    aria-description="${this.ariaDescriptionText||nothing}">
<!-- This wrapper is necessary, such that the "pulse" animation is not
    erroneously played when the user clicks on the outer-most scrollbar. -->
  <div id="content-wrapper" part="wrapper">
    <div class="top-container">
      <h2 id="title" class="title-container" tabindex="-1">
        <slot name="title"></slot>
      </h2>
      ${this.showCloseButton?html`
        <cr-icon-button id="close" class="icon-clear"
            aria-label="${this.closeText||nothing}"
            title="${this.closeText||nothing}"
            @click="${this.cancel}" @keypress="${this.onCloseKeypress_}">
        </cr-icon-button>
       `:""}
    </div>
    <slot name="header"></slot>
    <div class="body-container cr-scrollable" id="container"
        part="body-container">
      <div class="cr-scrollable-top"></div>
      <slot name="body"></slot>
      <div class="cr-scrollable-bottom"></div>
    </div>
    <slot name="button-container"></slot>
    <slot name="footer"></slot>
  </div>
</dialog>`}
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class CrDialogElement extends CrLitElement{static get is(){return"cr-dialog"}static get styles(){return getCss$n()}render(){return getHtml$k.bind(this)()}static get properties(){return{open:{type:Boolean,reflect:true},closeText:{type:String},ignorePopstate:{type:Boolean},ignoreEnterKey:{type:Boolean},consumeKeydownEvent:{type:Boolean},noCancel:{type:Boolean},showCloseButton:{type:Boolean},showOnAttach:{type:Boolean},ariaDescriptionText:{type:String}}}#closeText_accessor_storage;get closeText(){return this.#closeText_accessor_storage}set closeText(value){this.#closeText_accessor_storage=value}#consumeKeydownEvent_accessor_storage=false;get consumeKeydownEvent(){return this.#consumeKeydownEvent_accessor_storage}set consumeKeydownEvent(value){this.#consumeKeydownEvent_accessor_storage=value}#ignoreEnterKey_accessor_storage=false;get ignoreEnterKey(){return this.#ignoreEnterKey_accessor_storage}set ignoreEnterKey(value){this.#ignoreEnterKey_accessor_storage=value}#ignorePopstate_accessor_storage=false;get ignorePopstate(){return this.#ignorePopstate_accessor_storage}set ignorePopstate(value){this.#ignorePopstate_accessor_storage=value}#noCancel_accessor_storage=false;get noCancel(){return this.#noCancel_accessor_storage}set noCancel(value){this.#noCancel_accessor_storage=value}#open_accessor_storage=false;get open(){return this.#open_accessor_storage}set open(value){this.#open_accessor_storage=value}#showCloseButton_accessor_storage=false;get showCloseButton(){return this.#showCloseButton_accessor_storage}set showCloseButton(value){this.#showCloseButton_accessor_storage=value}#showOnAttach_accessor_storage=false;get showOnAttach(){return this.#showOnAttach_accessor_storage}set showOnAttach(value){this.#showOnAttach_accessor_storage=value}#ariaDescriptionText_accessor_storage;get ariaDescriptionText(){return this.#ariaDescriptionText_accessor_storage}set ariaDescriptionText(value){this.#ariaDescriptionText_accessor_storage=value}mutationObserver_=null;boundKeydown_=null;firstUpdated(){window.addEventListener("popstate",(()=>{if(!this.ignorePopstate&&this.$.dialog.open){this.cancel()}}));if(!this.ignoreEnterKey){this.addEventListener("keypress",this.onKeypress_.bind(this))}this.addEventListener("pointerdown",(e=>this.onPointerdown_(e)))}connectedCallback(){super.connectedCallback();const mutationObserverCallback=()=>{if(this.$.dialog.open){this.addKeydownListener_()}else{this.removeKeydownListener_()}};this.mutationObserver_=new MutationObserver(mutationObserverCallback);this.mutationObserver_.observe(this.$.dialog,{attributes:true,attributeFilter:["open"]});mutationObserverCallback();if(this.showOnAttach){this.showModal()}}disconnectedCallback(){super.disconnectedCallback();this.removeKeydownListener_();if(this.mutationObserver_){this.mutationObserver_.disconnect();this.mutationObserver_=null}}addKeydownListener_(){if(!this.consumeKeydownEvent){return}this.boundKeydown_=this.boundKeydown_||this.onKeydown_.bind(this);this.addEventListener("keydown",this.boundKeydown_);document.body.addEventListener("keydown",this.boundKeydown_)}removeKeydownListener_(){if(!this.boundKeydown_){return}this.removeEventListener("keydown",this.boundKeydown_);document.body.removeEventListener("keydown",this.boundKeydown_);this.boundKeydown_=null}async showModal(){if(this.showOnAttach){const element=this.querySelector("[autofocus]");if(element&&element instanceof CrLitElement&&!element.shadowRoot){element.ensureInitialRender()}}this.$.dialog.showModal();assert(this.$.dialog.open);this.open=true;await this.updateComplete;this.fire("cr-dialog-open")}cancel(){this.fire("cancel");this.$.dialog.close();assert(!this.$.dialog.open);this.open=false}close(){this.$.dialog.close("success");assert(!this.$.dialog.open);this.open=false}setTitleAriaLabel(title){this.$.dialog.removeAttribute("aria-labelledby");this.$.dialog.setAttribute("aria-label",title)}onCloseKeypress_(e){e.stopPropagation()}onNativeDialogClose_(e){if(e.target!==this.getNative()){return}this.fire("close")}async onNativeDialogCancel_(e){if(e.target!==this.getNative()){return}if(this.noCancel){e.preventDefault();return}this.open=false;await this.updateComplete;this.fire("cancel")}getNative(){return this.$.dialog}onKeypress_(e){if(e.key!=="Enter"){return}const accept=e.target===this||e.composedPath().some((el=>el.tagName==="CR-INPUT"&&el.type!=="search"));if(!accept){return}const actionButton=this.querySelector(".action-button:not([disabled]):not([hidden])");if(actionButton){actionButton.click();e.preventDefault()}}onKeydown_(e){assert(this.consumeKeydownEvent);if(!this.getNative().open){return}if(this.ignoreEnterKey&&e.key==="Enter"){return}e.stopPropagation()}onPointerdown_(e){if(e.button!==0||e.composedPath()[0].tagName!=="DIALOG"){return}this.$.dialog.animate([{transform:"scale(1)",offset:0},{transform:"scale(1.02)",offset:.4},{transform:"scale(1.02)",offset:.6},{transform:"scale(1)",offset:1}],{duration:180,easing:"ease-in-out",iterations:1});e.preventDefault()}focus(){const titleContainer=this.shadowRoot.querySelector(".title-container");assert(titleContainer);titleContainer.focus()}}customElements.define(CrDialogElement.is,CrDialogElement);
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class LifetimeBrowserProxyImpl{restart(){chrome.send("restart")}relaunch(){chrome.send("relaunch")}shouldShowRelaunchConfirmationDialog(alwaysShowDialog){return sendWithPromise("shouldShowRelaunchConfirmationDialog",alwaysShowDialog)}getRelaunchConfirmationDialogDescription(isVersionUpdate){return sendWithPromise("getRelaunchConfirmationDialogDescription",isVersionUpdate)}static getInstance(){return instance$F||(instance$F=new LifetimeBrowserProxyImpl)}static setInstance(obj){instance$F=obj}}let instance$F=null;function getTemplate$s(){return html$1`<!--_html_template_start_--><cr-dialog id="dialog" close-text="$i18n{close}" show-on-attach>
  <div slot="title">$i18n{relaunchConfirmationDialogTitle}</div>
  <div slot="body">[[relaunchConfirmationDialogDesc]]</div>
  <div slot="button-container">
    <cr-button id="cancel" class="cancel-button" on-click="onDialogCancel_">
      $i18n{cancel}
    </cr-button>
    <cr-button id="confirm" class="action-button" on-click="onDialogConfirm_">
      $i18n{restart}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var RestartType;(function(RestartType){RestartType[RestartType["RESTART"]=0]="RESTART";RestartType[RestartType["RELAUNCH"]=1]="RELAUNCH"})(RestartType||(RestartType={}));const RelaunchMixin=dedupingMixin((superClass=>{class RelaunchMixin extends superClass{lifetimeBrowserProxy_;static get properties(){return{shouldShowRelaunchDialog:{type:Boolean,value:false},restartTypeEnum:{type:Object,value:RestartType}}}constructor(...args){super(...args);this.lifetimeBrowserProxy_=LifetimeBrowserProxyImpl.getInstance()}onRelaunchDialogClose(_event){this.shouldShowRelaunchDialog=false}performRestartInternal_(restartType){if(RestartType.RESTART===restartType){this.lifetimeBrowserProxy_.restart()}else if(RestartType.RELAUNCH===restartType){this.lifetimeBrowserProxy_.relaunch()}else{assertNotReached()}}async performRestartForNonChromeOs_(restartType,alwaysShowDialog){const shouldShowDialog=await this.lifetimeBrowserProxy_.shouldShowRelaunchConfirmationDialog(alwaysShowDialog);if(!shouldShowDialog){this.performRestartInternal_(restartType);return}this.shouldShowRelaunchDialog=true}performRestart(restartType,alwaysShowDialog){if(alwaysShowDialog==null){alwaysShowDialog=false}this.performRestartForNonChromeOs_(restartType,alwaysShowDialog)}}return RelaunchMixin}));
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class RelaunchConfirmationDialogElement extends PolymerElement{static get is(){return"relaunch-confirmation-dialog"}static get template(){return getTemplate$s()}static get properties(){return{relaunchConfirmationDialogDesc:String,restartType:Object,isVersionUpdate:{type:Boolean,value:false}}}async connectedCallback(){super.connectedCallback();this.relaunchConfirmationDialogDesc=await LifetimeBrowserProxyImpl.getInstance().getRelaunchConfirmationDialogDescription(this.isVersionUpdate)}onDialogCancel_(){this.$.dialog.cancel()}onDialogConfirm_(){if(RestartType.RELAUNCH===this.restartType){LifetimeBrowserProxyImpl.getInstance().relaunch()}else if(RestartType.RESTART===this.restartType){LifetimeBrowserProxyImpl.getInstance().restart()}else{assertNotReached()}}}customElements.define(RelaunchConfirmationDialogElement.is,RelaunchConfirmationDialogElement);function getTemplate$r(){return html$1`<!--_html_template_start_-->    <style>:host{display:flex;flex-direction:column;outline:none;position:relative}#header{display:flex;justify-content:space-between;padding-inline-end:var(--cr-section-padding)}#header .title{color:var(--cr-primary-text-color);font-size:108%;font-weight:400;letter-spacing:.25px;margin-bottom:12px;margin-top:var(--cr-section-vertical-margin);outline:none;padding-bottom:4px;padding-top:8px}#feedback{margin-top:var(--cr-section-vertical-margin)}#card{background-color:var(--cr-card-background-color);border-radius:var(--cr-card-border-radius);box-shadow:var(--cr-card-shadow);flex:1;overflow:hidden}@media (forced-colors:active){#card{border:var(--cr-border-hcm)}}
    </style>
    <div id="header">
      <h2 id="title" class="title" tabindex="-1"
          aria-hidden$="[[getTitleHiddenStatus_(pageTitle)]]">[[pageTitle]]</h2>
      <template is="dom-if" if="[[showSendFeedbackButton]]">
        <cr-icon-button id="feedback" iron-icon="settings:feedback"
            aria-labelledby="title" suppress-rtl-flip
            aria-roledescription="$i18n{sendFeedbackButton}"
            on-click="onSendFeedbackClick_">
        </cr-icon-button>
      </template>
    </div>
    <div id="card">
      <slot></slot>
    </div>
<!--_html_template_end_-->`}
// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsSectionElement extends PolymerElement{static get is(){return"settings-section"}static get template(){return getTemplate$r()}static get properties(){return{pageTitle:{type:String,value:""},showSendFeedbackButton:{type:Boolean,value:false}}}getTitleHiddenStatus_(){return this.pageTitle?false:"true"}focus(){this.shadowRoot.querySelector(".title").focus()}onSendFeedbackClick_(){this.dispatchEvent(new CustomEvent("send-feedback",{bubbles:true,composed:true}))}}customElements.define(SettingsSectionElement.is,SettingsSectionElement);const styleMod$7=document.createElement("dom-module");styleMod$7.appendChild(html$1`
  <template>
    <style>
.search-bubble{--search-bubble-color:#ffeb3b;position:absolute;z-index:1}.search-bubble-innards{align-items:center;background-color:var(--search-bubble-color);border-radius:2px;color:var(--google-grey-900);max-width:100px;min-width:64px;overflow:hidden;padding:4px 10px;text-align:center;text-overflow:ellipsis;white-space:nowrap}.search-bubble-innards::after{background-color:var(--search-bubble-color);content:'';height:10px;left:calc(50% - 5px);position:absolute;top:-5px;transform:rotate(-45deg);width:10px;z-index:-1}.search-bubble-innards.above::after{bottom:-5px;top:auto;transform:rotate(-135deg)}
    </style>
  </template>
`.content);styleMod$7.register("search-highlight-style");const sheet=new CSSStyleSheet;sheet.replaceSync(`html{--settings-error-color:var(--google-red-700);--iron-icon-fill-color:var(--google-grey-700);--iron-icon-height:var(--cr-icon-size);--iron-icon-width:var(--cr-icon-size);--cr-radio-group-item-padding:0}@media (prefers-color-scheme:dark){html{--iron-icon-fill-color:var(--google-grey-500);--settings-error-color:var(--google-red-300)}}`);document.adoptedStyleSheets=[...document.adoptedStyleSheets,sheet];const styleMod$6=document.createElement("dom-module");styleMod$6.appendChild(html$1`
  <template>
    <style include="cr-shared-style search-highlight-style">
a[is=action-link]{user-select:none}h2{align-items:center;align-self:flex-start;color:var(--cr-secondary-text-color);display:flex;font-size:inherit;font-weight:500;margin:0;padding-bottom:12px;padding-top:32px}cr-icon,iron-icon{flex-shrink:0}cr-icon.policy,iron-icon.policy{margin-inline-end:var(--cr-controlled-by-spacing)}iron-list{user-select:none}iron-list[risk-selection]{user-select:text}.separator+cr-icon-button{margin-inline-start:var(--cr-icon-ripple-margin)}.settings-box settings-toggle-button cr-button:last-of-type{margin-inline-end:16px}.settings-box cr-button+cr-button,.settings-box cr-button+controlled-button,.settings-box controlled-button+controlled-button,.settings-box controlled-button+cr-button{margin-inline-start:8px}a[href]{color:var(--cr-link-color)}.inherit-color{color:inherit !important}collapse-radio-button,controlled-radio-button,cr-radio-button{min-height:var(--cr-section-min-height)}cr-radio-group{width:100%}.text-elide{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.no-min-width{min-width:0}.header-aligned-button{margin-top:12px}.link-wrapper{align-items:center;display:flex;flex-grow:1}.list-frame{display:block;padding-block-end:0;padding-block-start:0;padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-indent-padding)}.list-item{align-items:center;display:flex;min-height:var(--cr-section-min-height);padding:0}.list-item.underbar{border-bottom:var(--cr-separator-line)}.list-item.selected{font-weight:500}.list-item .middle{flex:1;margin:8px 16px}.list-item>.start{flex:1}.list-button[is='action-link']{align-items:center;display:flex;flex:1;font-weight:500;min-height:inherit}:host-context(html:not(.focus-outline-visible)) .list-button[is='action-link']{outline:none}.two-line{min-height:var(--cr-section-two-line-min-height)}.settings-box{align-items:center;border-top:var(--cr-separator-line);display:flex;min-height:var(--cr-section-min-height);padding:0 var(--cr-section-padding)}.settings-box.no-padding{padding:0}.settings-box.no-padding .margin-matches-padding{margin:0 var(--cr-section-padding)}.settings-box.no-padding>.link-wrapper{padding:0 var(--cr-section-padding)}.settings-box.two-line{min-height:var(--cr-section-two-line-min-height)}.settings-box-text{box-sizing:border-box;padding-bottom:var(--cr-section-vertical-padding);padding-top:var(--cr-section-vertical-padding)}.settings-box.first,.settings-box.continuation{border-top:none}h2.first{padding-top:0}.settings-box.block{display:block}.single-column{align-items:flex-start;flex-direction:column;justify-content:center}.settings-box.line-only{min-height:0}.settings-box.embedded{padding-inline-start:var(--cr-section-indent-padding)}.secondary{color:var(--cr-secondary-text-color);font-weight:400}.secondary:empty{margin:0}.settings-box .middle{align-items:center;flex:auto;padding-inline-start:16px}.settings-box .middle.two-line,.settings-box .start.two-line{display:flex}.settings-box .start{align-items:center;flex:auto}.settings-row{align-items:center;display:flex;flex-direction:row;max-width:100%;min-width:0}.no-outline{background:none;outline:none}[scrollable],iron-list,.list-item{--cr-icon-button-margin-end:0}.vertical-list>*:not(:first-of-type){border-top:var(--cr-separator-line)}.separator{border-inline-start:var(--cr-separator-line);flex-shrink:0;height:32px;margin:0 16px}.settings-box.no-padding>.link-wrapper~.separator{margin:0}.column-header{color:var(--cr-secondary-text-color);font-size:inherit;font-weight:400}.error-message{color:white;font:13px;padding-bottom:15px;padding-top:15px;text-align:center;white-space:normal}.url-directionality{direction:ltr;unicode-bidi:embed}.flex{flex:1}
    </style>
  </template>
`.content);styleMod$6.register("settings-shared");let instance$E=null;function getCss$m(){return instance$E||(instance$E=[...[],css`:host{align-items:center;align-self:stretch;display:flex;margin:0;outline:none}:host(:not([effectively-disabled_])){cursor:pointer}:host(:not([no-hover],[effectively-disabled_]):hover){background-color:var(--cr-hover-background-color)}:host(:not([no-hover],[effectively-disabled_]):active){background-color:var(--cr-active-background-color)}:host(:not([no-hover],[effectively-disabled_])) cr-icon-button{--cr-icon-button-hover-background-color:transparent;--cr-icon-button-active-background-color:transparent}`])}let instance$D=null;function getCss$l(){return instance$D||(instance$D=[...[getCss$m(),getCss$r(),getCss$x()],css`:host{box-sizing:border-box;flex:1;font-family:inherit;font-size:100%;line-height:154%;min-height:var(--cr-section-min-height);padding:0}:host(:not([embedded])){padding:0 var(--cr-section-padding)}#startIcon{--iron-icon-fill-color:var(--cr-link-row-start-icon-color,var(--google-grey-700));display:flex;flex-shrink:0;padding-inline-end:var(--cr-icon-button-margin-start);width:var(--cr-link-row-icon-width,var(--cr-icon-size))}@media (prefers-color-scheme:dark){#startIcon{--iron-icon-fill-color:var(--cr-link-row-start-icon-color,var(--google-grey-500))}}#labelWrapper{flex:1;flex-basis:0.000000001px;padding-bottom:var(--cr-section-vertical-padding);padding-top:var(--cr-section-vertical-padding);text-align:start}#label,#subLabel{display:flex}#buttonAriaDescription{clip:rect(0,0,0,0);display:block;position:fixed}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$j(){return html`
    ${this.startIcon?html`
<cr-icon id="startIcon" .icon="${this.startIcon}" aria-hidden="true"></cr-icon>
    `:""}
<div id="labelWrapper" ?hidden="${this.shouldHideLabelWrapper_()}">
  <div id="label" aria-hidden="${!this.ariaShowLabel}">
    ${this.label}
    <slot name="label"></slot>
  </div>
  <div id="subLabel" class="cr-secondary-text"
      aria-hidden="${!this.ariaShowSublabel}">
    ${this.subLabel}
    <slot name="sub-label"></slot>
  </div>
</div>
<slot></slot>
<div id="buttonAriaDescription" aria-hidden="true">
  ${this.getButtonAriaDescription_()}
</div>
<cr-icon-button id="icon" iron-icon="${this.getIcon_()}" role="link"
    part="icon" aria-roledescription="${this.roleDescription||nothing}"
    aria-describedby="buttonAriaDescription"
    aria-labelledby="label subLabel" ?disabled="${this.disabled}">
</cr-icon-button>`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class CrLinkRowElement extends CrLitElement{static get is(){return"cr-link-row"}static get styles(){return getCss$l()}render(){return getHtml$j.bind(this)()}static get properties(){return{ariaShowLabel:{type:Boolean,reflect:true},ariaShowSublabel:{type:Boolean,reflect:true},startIcon:{type:String},label:{type:String},subLabel:{type:String},disabled:{type:Boolean,reflect:true},external:{type:Boolean},usingSlottedLabel:{type:Boolean},roleDescription:{type:String},buttonAriaDescription:{type:String}}}#ariaShowLabel_accessor_storage=false;get ariaShowLabel(){return this.#ariaShowLabel_accessor_storage}set ariaShowLabel(value){this.#ariaShowLabel_accessor_storage=value}#ariaShowSublabel_accessor_storage=false;get ariaShowSublabel(){return this.#ariaShowSublabel_accessor_storage}set ariaShowSublabel(value){this.#ariaShowSublabel_accessor_storage=value}#startIcon_accessor_storage="";get startIcon(){return this.#startIcon_accessor_storage}set startIcon(value){this.#startIcon_accessor_storage=value}#label_accessor_storage="";get label(){return this.#label_accessor_storage}set label(value){this.#label_accessor_storage=value}#subLabel_accessor_storage="";get subLabel(){return this.#subLabel_accessor_storage}set subLabel(value){this.#subLabel_accessor_storage=value}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#external_accessor_storage=false;get external(){return this.#external_accessor_storage}set external(value){this.#external_accessor_storage=value}#usingSlottedLabel_accessor_storage=false;get usingSlottedLabel(){return this.#usingSlottedLabel_accessor_storage}set usingSlottedLabel(value){this.#usingSlottedLabel_accessor_storage=value}#roleDescription_accessor_storage;get roleDescription(){return this.#roleDescription_accessor_storage}set roleDescription(value){this.#roleDescription_accessor_storage=value}#buttonAriaDescription_accessor_storage;get buttonAriaDescription(){return this.#buttonAriaDescription_accessor_storage}set buttonAriaDescription(value){this.#buttonAriaDescription_accessor_storage=value}focus(){this.$.icon.focus()}shouldHideLabelWrapper_(){return!(this.label||this.usingSlottedLabel)}getIcon_(){return this.external?"cr:open-in-new":"cr:chevron-right"}getButtonAriaDescription_(){return this.buttonAriaDescription??(this.external?loadTimeData.getString("opensInNewTab"):"")}}customElements.define(CrLinkRowElement.is,CrLinkRowElement);
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const I18nMixin=dedupingMixin((superClass=>{class I18nMixin extends superClass{i18nRaw_(id,...varArgs){return varArgs.length===0?loadTimeData.getString(id):loadTimeData.getStringF(id,...varArgs)}i18n(id,...varArgs){const rawString=this.i18nRaw_(id,...varArgs);return parseHtmlSubset(`<b>${rawString}</b>`).firstChild.textContent}i18nAdvanced(id,opts){opts=opts||{};const rawString=this.i18nRaw_(id,...opts.substitutions||[]);return sanitizeInnerHtml(rawString,opts)}i18nDynamic(_locale,id,...varArgs){return this.i18n(id,...varArgs)}i18nRecursive(locale,id,...varArgs){let args=varArgs;if(args.length>0){args=args.map((str=>this.i18nExists(str)?loadTimeData.getString(str):str))}return this.i18nDynamic(locale,id,...args)}i18nExists(id){return loadTimeData.valueExists(id)}}return I18nMixin}));
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const WebUiListenerMixin=dedupingMixin((superClass=>{class WebUiListenerMixin extends superClass{webUiListeners_=[];addWebUiListener(eventName,callback){this.webUiListeners_.push(addWebUiListener(eventName,callback))}disconnectedCallback(){super.disconnectedCallback();while(this.webUiListeners_.length>0){removeWebUiListener(this.webUiListeners_.pop())}}}return WebUiListenerMixin}));
// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrefsMixin=dedupingMixin((superClass=>{class PrefsMixin extends superClass{static get properties(){return{prefs:{type:Object,notify:true}}}getPref(prefPath){const pref=this.get(prefPath,this.prefs);assert(typeof pref!=="undefined","Pref is missing: "+prefPath);return pref}setPrefValue(prefPath,value){this.getPref(prefPath);this.set("prefs."+prefPath+".value",value)}appendPrefListItem(key,item){const pref=this.getPref(key);assert(pref&&pref.type===chrome.settingsPrivate.PrefType.LIST);if(pref.value.indexOf(item)===-1){this.push("prefs."+key+".value",item)}}updatePrefListItem(key,item,newItem){const pref=this.getPref(key);assert(pref&&pref.type===chrome.settingsPrivate.PrefType.LIST);const index=pref.value.indexOf(item);if(index!==-1){this.set(`prefs.${key}.value.${index}`,newItem)}}deletePrefListItem(key,item){assert(this.getPref(key).type===chrome.settingsPrivate.PrefType.LIST);const index=this.getPref(key).value.indexOf(item);if(index!==-1){this.splice(`prefs.${key}.value`,index,1)}}setPrefDictEntry(prefPath,key,value){const pref=this.getPref(prefPath);assert(pref&&pref.type===chrome.settingsPrivate.PrefType.DICTIONARY);pref.value[key]=value;this.set("prefs."+prefPath+".value",{...pref.value})}deletePrefDictEntry(prefPath,key){const pref=this.getPref(prefPath);assert(pref&&pref.type===chrome.settingsPrivate.PrefType.DICTIONARY);delete pref.value[key];this.set("prefs."+prefPath+".value",{...pref.value})}computePref(pref){return pref}}return PrefsMixin}));
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class OpenWindowProxyImpl{openUrl(url){window.open(url)}static getInstance(){return instance$C||(instance$C=new OpenWindowProxyImpl)}static setInstance(obj){instance$C=obj}}let instance$C=null;
// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var PrivacyElementInteractions;(function(PrivacyElementInteractions){PrivacyElementInteractions[PrivacyElementInteractions["DO_NOT_TRACK"]=2]="DO_NOT_TRACK";PrivacyElementInteractions[PrivacyElementInteractions["PAYMENT_METHOD"]=3]="PAYMENT_METHOD";PrivacyElementInteractions[PrivacyElementInteractions["MANAGE_CERTIFICATES"]=5]="MANAGE_CERTIFICATES";PrivacyElementInteractions[PrivacyElementInteractions["IMPROVE_SECURITY"]=8]="IMPROVE_SECURITY";PrivacyElementInteractions[PrivacyElementInteractions["SITE_DETAILS_CLEAR_DATA"]=19]="SITE_DETAILS_CLEAR_DATA";PrivacyElementInteractions[PrivacyElementInteractions["THIRD_PARTY_COOKIES_ALLOW"]=20]="THIRD_PARTY_COOKIES_ALLOW";PrivacyElementInteractions[PrivacyElementInteractions["THIRD_PARTY_COOKIES_BLOCK_IN_INCOGNITO"]=21]="THIRD_PARTY_COOKIES_BLOCK_IN_INCOGNITO";PrivacyElementInteractions[PrivacyElementInteractions["THIRD_PARTY_COOKIES_BLOCK"]=22]="THIRD_PARTY_COOKIES_BLOCK";PrivacyElementInteractions[PrivacyElementInteractions["BLOCK_ALL_THIRD_PARTY_COOKIES"]=23]="BLOCK_ALL_THIRD_PARTY_COOKIES";PrivacyElementInteractions[PrivacyElementInteractions["IP_PROTECTION"]=24]="IP_PROTECTION";PrivacyElementInteractions[PrivacyElementInteractions["FINGERPRINTING_PROTECTION"]=25]="FINGERPRINTING_PROTECTION";PrivacyElementInteractions[PrivacyElementInteractions["MAX_VALUE"]=26]="MAX_VALUE"})(PrivacyElementInteractions||(PrivacyElementInteractions={}));var SafetyHubCardState;(function(SafetyHubCardState){SafetyHubCardState[SafetyHubCardState["WARNING"]=0]="WARNING";SafetyHubCardState[SafetyHubCardState["WEAK"]=1]="WEAK";SafetyHubCardState[SafetyHubCardState["INFO"]=2]="INFO";SafetyHubCardState[SafetyHubCardState["SAFE"]=3]="SAFE";SafetyHubCardState[SafetyHubCardState["MAX_VALUE"]=4]="MAX_VALUE"})(SafetyHubCardState||(SafetyHubCardState={}));var SafetyCheckNotificationsModuleInteractions;(function(SafetyCheckNotificationsModuleInteractions){SafetyCheckNotificationsModuleInteractions[SafetyCheckNotificationsModuleInteractions["BLOCK"]=0]="BLOCK";SafetyCheckNotificationsModuleInteractions[SafetyCheckNotificationsModuleInteractions["BLOCK_ALL"]=1]="BLOCK_ALL";SafetyCheckNotificationsModuleInteractions[SafetyCheckNotificationsModuleInteractions["IGNORE"]=2]="IGNORE";SafetyCheckNotificationsModuleInteractions[SafetyCheckNotificationsModuleInteractions["MINIMIZE"]=3]="MINIMIZE";SafetyCheckNotificationsModuleInteractions[SafetyCheckNotificationsModuleInteractions["RESET"]=4]="RESET";SafetyCheckNotificationsModuleInteractions[SafetyCheckNotificationsModuleInteractions["UNDO_BLOCK"]=5]="UNDO_BLOCK";SafetyCheckNotificationsModuleInteractions[SafetyCheckNotificationsModuleInteractions["UNDO_IGNORE"]=6]="UNDO_IGNORE";SafetyCheckNotificationsModuleInteractions[SafetyCheckNotificationsModuleInteractions["UNDO_RESET"]=7]="UNDO_RESET";SafetyCheckNotificationsModuleInteractions[SafetyCheckNotificationsModuleInteractions["OPEN_REVIEW_UI"]=8]="OPEN_REVIEW_UI";SafetyCheckNotificationsModuleInteractions[SafetyCheckNotificationsModuleInteractions["UNDO_BLOCK_ALL"]=9]="UNDO_BLOCK_ALL";SafetyCheckNotificationsModuleInteractions[SafetyCheckNotificationsModuleInteractions["GO_TO_SETTINGS"]=10]="GO_TO_SETTINGS";SafetyCheckNotificationsModuleInteractions[SafetyCheckNotificationsModuleInteractions["MAX_VALUE"]=11]="MAX_VALUE"})(SafetyCheckNotificationsModuleInteractions||(SafetyCheckNotificationsModuleInteractions={}));var SafetyCheckUnusedSitePermissionsModuleInteractions;(function(SafetyCheckUnusedSitePermissionsModuleInteractions){SafetyCheckUnusedSitePermissionsModuleInteractions[SafetyCheckUnusedSitePermissionsModuleInteractions["OPEN_REVIEW_UI"]=0]="OPEN_REVIEW_UI";SafetyCheckUnusedSitePermissionsModuleInteractions[SafetyCheckUnusedSitePermissionsModuleInteractions["ALLOW_AGAIN"]=1]="ALLOW_AGAIN";SafetyCheckUnusedSitePermissionsModuleInteractions[SafetyCheckUnusedSitePermissionsModuleInteractions["ACKNOWLEDGE_ALL"]=2]="ACKNOWLEDGE_ALL";SafetyCheckUnusedSitePermissionsModuleInteractions[SafetyCheckUnusedSitePermissionsModuleInteractions["UNDO_ALLOW_AGAIN"]=3]="UNDO_ALLOW_AGAIN";SafetyCheckUnusedSitePermissionsModuleInteractions[SafetyCheckUnusedSitePermissionsModuleInteractions["UNDO_ACKNOWLEDGE_ALL"]=4]="UNDO_ACKNOWLEDGE_ALL";SafetyCheckUnusedSitePermissionsModuleInteractions[SafetyCheckUnusedSitePermissionsModuleInteractions["MINIMIZE"]=5]="MINIMIZE";SafetyCheckUnusedSitePermissionsModuleInteractions[SafetyCheckUnusedSitePermissionsModuleInteractions["GO_TO_SETTINGS"]=6]="GO_TO_SETTINGS";SafetyCheckUnusedSitePermissionsModuleInteractions[SafetyCheckUnusedSitePermissionsModuleInteractions["MAX_VALUE"]=7]="MAX_VALUE"})(SafetyCheckUnusedSitePermissionsModuleInteractions||(SafetyCheckUnusedSitePermissionsModuleInteractions={}));var SafetyHubEntryPoint;(function(SafetyHubEntryPoint){SafetyHubEntryPoint[SafetyHubEntryPoint["PRIVACY_SAFE"]=0]="PRIVACY_SAFE";SafetyHubEntryPoint[SafetyHubEntryPoint["PRIVACY_WARNING"]=1]="PRIVACY_WARNING";SafetyHubEntryPoint[SafetyHubEntryPoint["SITE_SETTINGS"]=2]="SITE_SETTINGS";SafetyHubEntryPoint[SafetyHubEntryPoint["THREE_DOT_MENU"]=3]="THREE_DOT_MENU";SafetyHubEntryPoint[SafetyHubEntryPoint["NOTIFICATIONS"]=4]="NOTIFICATIONS";SafetyHubEntryPoint[SafetyHubEntryPoint["MAX_VALUE"]=5]="MAX_VALUE"})(SafetyHubEntryPoint||(SafetyHubEntryPoint={}));var SafetyHubModuleType;(function(SafetyHubModuleType){SafetyHubModuleType[SafetyHubModuleType["PERMISSIONS"]=0]="PERMISSIONS";SafetyHubModuleType[SafetyHubModuleType["NOTIFICATIONS"]=1]="NOTIFICATIONS";SafetyHubModuleType[SafetyHubModuleType["SAFE_BROWSING"]=2]="SAFE_BROWSING";SafetyHubModuleType[SafetyHubModuleType["EXTENSIONS"]=3]="EXTENSIONS";SafetyHubModuleType[SafetyHubModuleType["PASSWORDS"]=4]="PASSWORDS";SafetyHubModuleType[SafetyHubModuleType["VERSION"]=5]="VERSION";SafetyHubModuleType[SafetyHubModuleType["MAX_VALUE"]=6]="MAX_VALUE"})(SafetyHubModuleType||(SafetyHubModuleType={}));var SafeBrowsingInteractions;(function(SafeBrowsingInteractions){SafeBrowsingInteractions[SafeBrowsingInteractions["SAFE_BROWSING_SHOWED"]=0]="SAFE_BROWSING_SHOWED";SafeBrowsingInteractions[SafeBrowsingInteractions["SAFE_BROWSING_ENHANCED_PROTECTION_CLICKED"]=1]="SAFE_BROWSING_ENHANCED_PROTECTION_CLICKED";SafeBrowsingInteractions[SafeBrowsingInteractions["SAFE_BROWSING_STANDARD_PROTECTION_CLICKED"]=2]="SAFE_BROWSING_STANDARD_PROTECTION_CLICKED";SafeBrowsingInteractions[SafeBrowsingInteractions["SAFE_BROWSING_DISABLE_SAFE_BROWSING_CLICKED"]=3]="SAFE_BROWSING_DISABLE_SAFE_BROWSING_CLICKED";SafeBrowsingInteractions[SafeBrowsingInteractions["SAFE_BROWSING_ENHANCED_PROTECTION_EXPAND_ARROW_CLICKED"]=4]="SAFE_BROWSING_ENHANCED_PROTECTION_EXPAND_ARROW_CLICKED";SafeBrowsingInteractions[SafeBrowsingInteractions["SAFE_BROWSING_STANDARD_PROTECTION_EXPAND_ARROW_CLICKED"]=5]="SAFE_BROWSING_STANDARD_PROTECTION_EXPAND_ARROW_CLICKED";SafeBrowsingInteractions[SafeBrowsingInteractions["SAFE_BROWSING_DISABLE_SAFE_BROWSING_DIALOG_CONFIRMED"]=6]="SAFE_BROWSING_DISABLE_SAFE_BROWSING_DIALOG_CONFIRMED";SafeBrowsingInteractions[SafeBrowsingInteractions["SAFE_BROWSING_DISABLE_SAFE_BROWSING_DIALOG_DENIED"]=7]="SAFE_BROWSING_DISABLE_SAFE_BROWSING_DIALOG_DENIED";SafeBrowsingInteractions[SafeBrowsingInteractions["MAX_VALUE"]=8]="MAX_VALUE"})(SafeBrowsingInteractions||(SafeBrowsingInteractions={}));var PrivacyGuideInteractions;(function(PrivacyGuideInteractions){PrivacyGuideInteractions[PrivacyGuideInteractions["WELCOME_NEXT_BUTTON"]=0]="WELCOME_NEXT_BUTTON";PrivacyGuideInteractions[PrivacyGuideInteractions["MSBB_NEXT_BUTTON"]=1]="MSBB_NEXT_BUTTON";PrivacyGuideInteractions[PrivacyGuideInteractions["HISTORY_SYNC_NEXT_BUTTON"]=2]="HISTORY_SYNC_NEXT_BUTTON";PrivacyGuideInteractions[PrivacyGuideInteractions["SAFE_BROWSING_NEXT_BUTTON"]=3]="SAFE_BROWSING_NEXT_BUTTON";PrivacyGuideInteractions[PrivacyGuideInteractions["COOKIES_NEXT_BUTTON"]=4]="COOKIES_NEXT_BUTTON";PrivacyGuideInteractions[PrivacyGuideInteractions["COMPLETION_NEXT_BUTTON"]=5]="COMPLETION_NEXT_BUTTON";PrivacyGuideInteractions[PrivacyGuideInteractions["SETTINGS_LINK_ROW_ENTRY"]=6]="SETTINGS_LINK_ROW_ENTRY";PrivacyGuideInteractions[PrivacyGuideInteractions["PROMO_ENTRY"]=7]="PROMO_ENTRY";PrivacyGuideInteractions[PrivacyGuideInteractions["SWAA_COMPLETION_LINK"]=8]="SWAA_COMPLETION_LINK";PrivacyGuideInteractions[PrivacyGuideInteractions["PRIVACY_SANDBOX_COMPLETION_LINK"]=9]="PRIVACY_SANDBOX_COMPLETION_LINK";PrivacyGuideInteractions[PrivacyGuideInteractions["SEARCH_SUGGESTIONS_NEXT_BUTTON"]=10]="SEARCH_SUGGESTIONS_NEXT_BUTTON";PrivacyGuideInteractions[PrivacyGuideInteractions["TRACKING_PROTECTION_COMPLETION_LINK"]=11]="TRACKING_PROTECTION_COMPLETION_LINK";PrivacyGuideInteractions[PrivacyGuideInteractions["AD_TOPICS_NEXT_BUTTON"]=12]="AD_TOPICS_NEXT_BUTTON";PrivacyGuideInteractions[PrivacyGuideInteractions["AI_SETTINGS_COMPLETION_LINK"]=13]="AI_SETTINGS_COMPLETION_LINK";PrivacyGuideInteractions[PrivacyGuideInteractions["MAX_VALUE"]=14]="MAX_VALUE"})(PrivacyGuideInteractions||(PrivacyGuideInteractions={}));var PrivacyGuideSettingsStates;(function(PrivacyGuideSettingsStates){PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["MSBB_ON_TO_ON"]=0]="MSBB_ON_TO_ON";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["MSBB_ON_TO_OFF"]=1]="MSBB_ON_TO_OFF";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["MSBB_OFF_TO_ON"]=2]="MSBB_OFF_TO_ON";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["MSBB_OFF_TO_OFF"]=3]="MSBB_OFF_TO_OFF";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["BLOCK_3P_INCOGNITO_TO_3P_INCOGNITO"]=4]="BLOCK_3P_INCOGNITO_TO_3P_INCOGNITO";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["BLOCK_3P_INCOGNITO_TO_3P"]=5]="BLOCK_3P_INCOGNITO_TO_3P";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["BLOCK_3P_TO_3P_INCOGNITO"]=6]="BLOCK_3P_TO_3P_INCOGNITO";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["BLOCK_3P_TO_3P"]=7]="BLOCK_3P_TO_3P";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["HISTORY_SYNC_ON_TO_ON"]=8]="HISTORY_SYNC_ON_TO_ON";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["HISTORY_SYNC_ON_TO_OFF"]=9]="HISTORY_SYNC_ON_TO_OFF";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["HISTORY_SYNC_OFF_TO_ON"]=10]="HISTORY_SYNC_OFF_TO_ON";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["HISTORY_SYNC_OFF_TO_OFF"]=11]="HISTORY_SYNC_OFF_TO_OFF";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["SAFE_BROWSING_ENHANCED_TO_ENHANCED"]=12]="SAFE_BROWSING_ENHANCED_TO_ENHANCED";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["SAFE_BROWSING_ENHANCED_TO_STANDARD"]=13]="SAFE_BROWSING_ENHANCED_TO_STANDARD";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["SAFE_BROWSING_STANDARD_TO_ENHANCED"]=14]="SAFE_BROWSING_STANDARD_TO_ENHANCED";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["SAFE_BROWSING_STANDARD_TO_STANDARD"]=15]="SAFE_BROWSING_STANDARD_TO_STANDARD";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["SEARCH_SUGGESTIONS_ON_TO_ON"]=16]="SEARCH_SUGGESTIONS_ON_TO_ON";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["SEARCH_SUGGESTIONS_ON_TO_OFF"]=17]="SEARCH_SUGGESTIONS_ON_TO_OFF";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["SEARCH_SUGGESTIONS_OFF_TO_ON"]=18]="SEARCH_SUGGESTIONS_OFF_TO_ON";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["SEARCH_SUGGESTIONS_OFF_TO_OFF"]=19]="SEARCH_SUGGESTIONS_OFF_TO_OFF";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["AD_TOPICS_ON_TO_ON"]=20]="AD_TOPICS_ON_TO_ON";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["AD_TOPICS_ON_TO_OFF"]=21]="AD_TOPICS_ON_TO_OFF";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["AD_TOPICS_OFF_TO_ON"]=22]="AD_TOPICS_OFF_TO_ON";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["AD_TOPICS_OFF_TO_OFF"]=23]="AD_TOPICS_OFF_TO_OFF";PrivacyGuideSettingsStates[PrivacyGuideSettingsStates["MAX_VALUE"]=24]="MAX_VALUE"})(PrivacyGuideSettingsStates||(PrivacyGuideSettingsStates={}));var PrivacyGuideStepsEligibleAndReached;(function(PrivacyGuideStepsEligibleAndReached){PrivacyGuideStepsEligibleAndReached[PrivacyGuideStepsEligibleAndReached["MSBB_ELIGIBLE"]=0]="MSBB_ELIGIBLE";PrivacyGuideStepsEligibleAndReached[PrivacyGuideStepsEligibleAndReached["MSBB_REACHED"]=1]="MSBB_REACHED";PrivacyGuideStepsEligibleAndReached[PrivacyGuideStepsEligibleAndReached["HISTORY_SYNC_ELIGIBLE"]=2]="HISTORY_SYNC_ELIGIBLE";PrivacyGuideStepsEligibleAndReached[PrivacyGuideStepsEligibleAndReached["HISTORY_SYNC_REACHED"]=3]="HISTORY_SYNC_REACHED";PrivacyGuideStepsEligibleAndReached[PrivacyGuideStepsEligibleAndReached["SAFE_BROWSING_ELIGIBLE"]=4]="SAFE_BROWSING_ELIGIBLE";PrivacyGuideStepsEligibleAndReached[PrivacyGuideStepsEligibleAndReached["SAFE_BROWSING_REACHED"]=5]="SAFE_BROWSING_REACHED";PrivacyGuideStepsEligibleAndReached[PrivacyGuideStepsEligibleAndReached["COOKIES_ELIGIBLE"]=6]="COOKIES_ELIGIBLE";PrivacyGuideStepsEligibleAndReached[PrivacyGuideStepsEligibleAndReached["COOKIES_REACHED"]=7]="COOKIES_REACHED";PrivacyGuideStepsEligibleAndReached[PrivacyGuideStepsEligibleAndReached["COMPLETION_ELIGIBLE"]=8]="COMPLETION_ELIGIBLE";PrivacyGuideStepsEligibleAndReached[PrivacyGuideStepsEligibleAndReached["COMPLETION_REACHED"]=9]="COMPLETION_REACHED";PrivacyGuideStepsEligibleAndReached[PrivacyGuideStepsEligibleAndReached["SEARCH_SUGGESTIONS_ELIGIBLE"]=10]="SEARCH_SUGGESTIONS_ELIGIBLE";PrivacyGuideStepsEligibleAndReached[PrivacyGuideStepsEligibleAndReached["SEARCH_SUGGESTIONS_REACHED"]=11]="SEARCH_SUGGESTIONS_REACHED";PrivacyGuideStepsEligibleAndReached[PrivacyGuideStepsEligibleAndReached["AD_TOPICS_ELIGIBLE"]=12]="AD_TOPICS_ELIGIBLE";PrivacyGuideStepsEligibleAndReached[PrivacyGuideStepsEligibleAndReached["AD_TOPICS_REACHED"]=13]="AD_TOPICS_REACHED";PrivacyGuideStepsEligibleAndReached[PrivacyGuideStepsEligibleAndReached["COUNT"]=14]="COUNT"})(PrivacyGuideStepsEligibleAndReached||(PrivacyGuideStepsEligibleAndReached={}));var DeleteBrowsingDataAction;(function(DeleteBrowsingDataAction){DeleteBrowsingDataAction[DeleteBrowsingDataAction["CLEAR_BROWSING_DATA_DIALOG"]=0]="CLEAR_BROWSING_DATA_DIALOG";DeleteBrowsingDataAction[DeleteBrowsingDataAction["CLEAR_BROWSING_DATA_ON_EXIT"]=1]="CLEAR_BROWSING_DATA_ON_EXIT";DeleteBrowsingDataAction[DeleteBrowsingDataAction["INCOGNITO_CLOSE_TABS"]=2]="INCOGNITO_CLOSE_TABS";DeleteBrowsingDataAction[DeleteBrowsingDataAction["COOKIES_IN_USE_DIALOG"]=3]="COOKIES_IN_USE_DIALOG";DeleteBrowsingDataAction[DeleteBrowsingDataAction["SITES_SETTINGS_PAGE"]=4]="SITES_SETTINGS_PAGE";DeleteBrowsingDataAction[DeleteBrowsingDataAction["HISTORY_PAGE_ENTRIES"]=5]="HISTORY_PAGE_ENTRIES";DeleteBrowsingDataAction[DeleteBrowsingDataAction["QUICK_DELETE"]=6]="QUICK_DELETE";DeleteBrowsingDataAction[DeleteBrowsingDataAction["PAGE_INFO_RESET_PERMISSIONS"]=7]="PAGE_INFO_RESET_PERMISSIONS";DeleteBrowsingDataAction[DeleteBrowsingDataAction["MAX_VALUE"]=8]="MAX_VALUE"})(DeleteBrowsingDataAction||(DeleteBrowsingDataAction={}));var SafetyHubSurfaces;(function(SafetyHubSurfaces){SafetyHubSurfaces[SafetyHubSurfaces["THREE_DOT_MENU"]=0]="THREE_DOT_MENU";SafetyHubSurfaces[SafetyHubSurfaces["SAFETY_HUB_PAGE"]=1]="SAFETY_HUB_PAGE";SafetyHubSurfaces[SafetyHubSurfaces["MAX_VALUE"]=2]="MAX_VALUE"})(SafetyHubSurfaces||(SafetyHubSurfaces={}));var CvcDeletionUserAction;(function(CvcDeletionUserAction){CvcDeletionUserAction["HYPERLINK_CLICKED"]="BulkCvcDeletionHyperlinkClicked";CvcDeletionUserAction["DIALOG_ACCEPTED"]="BulkCvcDeletionConfirmationDialogAccepted";CvcDeletionUserAction["DIALOG_CANCELLED"]="BulkCvcDeletionConfirmationDialogCancelled"})(CvcDeletionUserAction||(CvcDeletionUserAction={}));var CardBenefitsUserAction;(function(CardBenefitsUserAction){CardBenefitsUserAction["CARD_BENEFITS_TERMS_LINK_CLICKED"]="CardBenefits_TermsLinkClicked"})(CardBenefitsUserAction||(CardBenefitsUserAction={}));var AiPageInteractions;(function(AiPageInteractions){AiPageInteractions[AiPageInteractions["HISTORY_SEARCH_CLICK"]=0]="HISTORY_SEARCH_CLICK";AiPageInteractions[AiPageInteractions["COMPARE_CLICK"]=1]="COMPARE_CLICK";AiPageInteractions[AiPageInteractions["COMPOSE_CLICK"]=2]="COMPOSE_CLICK";AiPageInteractions[AiPageInteractions["TAB_ORGANIZATION_CLICK"]=3]="TAB_ORGANIZATION_CLICK";AiPageInteractions[AiPageInteractions["AUTOFILL_AI_CLICK"]=5]="AUTOFILL_AI_CLICK";AiPageInteractions[AiPageInteractions["PASSWORD_CHANGE_CLICK"]=6]="PASSWORD_CHANGE_CLICK";AiPageInteractions[AiPageInteractions["MAX_VALUE"]=7]="MAX_VALUE"})(AiPageInteractions||(AiPageInteractions={}));var AiPageHistorySearchInteractions;(function(AiPageHistorySearchInteractions){AiPageHistorySearchInteractions[AiPageHistorySearchInteractions["HISTORY_SEARCH_ENABLED"]=0]="HISTORY_SEARCH_ENABLED";AiPageHistorySearchInteractions[AiPageHistorySearchInteractions["HISTORY_SEARCH_DISABLED"]=1]="HISTORY_SEARCH_DISABLED";AiPageHistorySearchInteractions[AiPageHistorySearchInteractions["FEATURE_LINK_CLICKED"]=2]="FEATURE_LINK_CLICKED";AiPageHistorySearchInteractions[AiPageHistorySearchInteractions["LEARN_MORE_LINK_CLICKED"]=3]="LEARN_MORE_LINK_CLICKED";AiPageHistorySearchInteractions[AiPageHistorySearchInteractions["MAX_VALUE"]=4]="MAX_VALUE"})(AiPageHistorySearchInteractions||(AiPageHistorySearchInteractions={}));var AiPageCompareInteractions;(function(AiPageCompareInteractions){AiPageCompareInteractions[AiPageCompareInteractions["FEATURE_LINK_CLICKED"]=0]="FEATURE_LINK_CLICKED";AiPageCompareInteractions[AiPageCompareInteractions["LEARN_MORE_LINK_CLICKED"]=1]="LEARN_MORE_LINK_CLICKED";AiPageCompareInteractions[AiPageCompareInteractions["MAX_VALUE"]=2]="MAX_VALUE"})(AiPageCompareInteractions||(AiPageCompareInteractions={}));var AiPageComposeInteractions;(function(AiPageComposeInteractions){AiPageComposeInteractions[AiPageComposeInteractions["LEARN_MORE_LINK_CLICKED"]=0]="LEARN_MORE_LINK_CLICKED";AiPageComposeInteractions[AiPageComposeInteractions["COMPOSE_PROACTIVE_NUDGE_ENABLED"]=1]="COMPOSE_PROACTIVE_NUDGE_ENABLED";AiPageComposeInteractions[AiPageComposeInteractions["COMPOSE_PROACTIVE_NUDGE_DISABLED"]=2]="COMPOSE_PROACTIVE_NUDGE_DISABLED";AiPageComposeInteractions[AiPageComposeInteractions["MAX_VALUE"]=3]="MAX_VALUE"})(AiPageComposeInteractions||(AiPageComposeInteractions={}));var AiPageTabOrganizationInteractions;(function(AiPageTabOrganizationInteractions){AiPageTabOrganizationInteractions[AiPageTabOrganizationInteractions["LEARN_MORE_LINK_CLICKED"]=0]="LEARN_MORE_LINK_CLICKED";AiPageTabOrganizationInteractions[AiPageTabOrganizationInteractions["MAX_VALUE"]=1]="MAX_VALUE"})(AiPageTabOrganizationInteractions||(AiPageTabOrganizationInteractions={}));var AutofillSettingsReferrer;(function(AutofillSettingsReferrer){AutofillSettingsReferrer[AutofillSettingsReferrer["SETTINGS_MENU"]=1]="SETTINGS_MENU";AutofillSettingsReferrer[AutofillSettingsReferrer["AUTOFILL_AND_PASSWORDS_PAGE"]=2]="AUTOFILL_AND_PASSWORDS_PAGE";AutofillSettingsReferrer[AutofillSettingsReferrer["MAX_VALUE"]=4]="MAX_VALUE"})(AutofillSettingsReferrer||(AutofillSettingsReferrer={}));class MetricsBrowserProxyImpl{recordAction(action){chrome.send("metricsHandler:recordAction",[action])}recordBooleanHistogram(histogramName,visible){chrome.send("metricsHandler:recordBooleanHistogram",[histogramName,visible])}recordSafetyHubCardStateClicked(histogramName,state){chrome.send("metricsHandler:recordInHistogram",[histogramName,state,SafetyHubCardState.MAX_VALUE])}recordSafetyHubEntryPointShown(page){chrome.send("metricsHandler:recordInHistogram",["Settings.SafetyHub.EntryPointImpression",page,SafetyHubEntryPoint.MAX_VALUE])}recordSafetyHubEntryPointClicked(page){chrome.send("metricsHandler:recordInHistogram",["Settings.SafetyHub.EntryPointInteraction",page,SafetyHubEntryPoint.MAX_VALUE])}recordSafetyHubModuleWarningImpression(module){chrome.send("metricsHandler:recordInHistogram",["Settings.SafetyHub.DashboardWarning",module,SafetyHubModuleType.MAX_VALUE])}recordSafetyHubDashboardAnyWarning(visible){chrome.send("metricsHandler:recordBooleanHistogram",["Settings.SafetyHub.HasDashboardShowAnyWarning",visible])}recordSafetyHubNotificationPermissionsModuleInteractionsHistogram(interaction){chrome.send("metricsHandler:recordInHistogram",["Settings.SafetyHub.NotificationPermissionsModule.Interactions",interaction,SafetyCheckNotificationsModuleInteractions.MAX_VALUE])}recordSafetyHubNotificationPermissionsModuleListCountHistogram(suggestions){chrome.send("metricsHandler:recordInHistogram",["Settings.SafetyHub.NotificationPermissionsModule.ListCount",suggestions,99])}recordSafetyHubUnusedSitePermissionsModuleInteractionsHistogram(interaction){chrome.send("metricsHandler:recordInHistogram",["Settings.SafetyHub.UnusedSitePermissionsModule.Interactions",interaction,SafetyCheckUnusedSitePermissionsModuleInteractions.MAX_VALUE])}recordSafetyHubAbusiveNotificationPermissionRevocationInteractionsHistogram(interaction){chrome.send("metricsHandler:recordInHistogram",["Settings.SafetyHub.AbusiveNotificationPermissionRevocation.Interactions",interaction,SafetyCheckUnusedSitePermissionsModuleInteractions.MAX_VALUE])}recordSafetyHubUnusedSitePermissionsModuleListCountHistogram(suggestions){chrome.send("metricsHandler:recordInHistogram",["Settings.SafetyHub.UnusedSitePermissionsModule.ListCount",suggestions,99])}recordSettingsPageHistogram(interaction){chrome.send("metricsHandler:recordInHistogram",["Settings.PrivacyElementInteractions",interaction,PrivacyElementInteractions.MAX_VALUE])}recordSafeBrowsingInteractionHistogram(interaction){chrome.send("metricsHandler:recordInHistogram",["SafeBrowsing.Settings.UserAction.Default",interaction,SafeBrowsingInteractions.MAX_VALUE])}recordPrivacyGuideNextNavigationHistogram(interaction){chrome.send("metricsHandler:recordInHistogram",["Settings.PrivacyGuide.NextNavigation",interaction,PrivacyGuideInteractions.MAX_VALUE])}recordPrivacyGuideEntryExitHistogram(interaction){chrome.send("metricsHandler:recordInHistogram",["Settings.PrivacyGuide.EntryExit",interaction,PrivacyGuideInteractions.MAX_VALUE])}recordPrivacyGuideSettingsStatesHistogram(state){chrome.send("metricsHandler:recordInHistogram",["Settings.PrivacyGuide.SettingsStates",state,PrivacyGuideSettingsStates.MAX_VALUE])}recordPrivacyGuideFlowLengthHistogram(steps){chrome.send("metricsHandler:recordInHistogram",["Settings.PrivacyGuide.FlowLength",steps,5])}recordPrivacyGuideStepsEligibleAndReachedHistogram(status){chrome.send("metricsHandler:recordInHistogram",["Settings.PrivacyGuide.StepsEligibleAndReached",status,PrivacyGuideStepsEligibleAndReached.COUNT])}recordDeleteBrowsingDataAction(action){chrome.send("metricsHandler:recordInHistogram",["Privacy.DeleteBrowsingData.Action",action,DeleteBrowsingDataAction.MAX_VALUE])}recordSafetyHubImpression(surface){chrome.send("metricsHandler:recordInHistogram",["Settings.SafetyHub.Impression",surface,SafetyHubSurfaces.MAX_VALUE])}recordSafetyHubInteraction(surface){chrome.send("metricsHandler:recordInHistogram",["Settings.SafetyHub.Interaction",surface,SafetyHubSurfaces.MAX_VALUE])}recordAiPageInteractions(interaction){chrome.send("metricsHandler:recordInHistogram",["Settings.AiPage.Interactions",interaction,AiPageInteractions.MAX_VALUE])}recordAiPageHistorySearchInteractions(interaction){chrome.send("metricsHandler:recordInHistogram",["Settings.AiPage.HistorySearch.Interactions",interaction,AiPageHistorySearchInteractions.MAX_VALUE])}recordAiPageCompareInteractions(interaction){chrome.send("metricsHandler:recordInHistogram",["Settings.AiPage.Compare.Interactions",interaction,AiPageCompareInteractions.MAX_VALUE])}recordAiPageComposeInteractions(interaction){chrome.send("metricsHandler:recordInHistogram",["Settings.AiPage.Compose.Interactions",interaction,AiPageComposeInteractions.MAX_VALUE])}recordAiPageTabOrganizationInteractions(interaction){chrome.send("metricsHandler:recordInHistogram",["Settings.AiPage.TabOrganization.Interactions",interaction,AiPageTabOrganizationInteractions.MAX_VALUE])}recordAutofillSettingsReferrer(histogramName,referrer){chrome.send("metricsHandler:recordInHistogram",[histogramName,referrer,AutofillSettingsReferrer.MAX_VALUE])}static getInstance(){return instance$B||(instance$B=new MetricsBrowserProxyImpl)}static setInstance(obj){instance$B=obj}}let instance$B=null;
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function createPageVisibility(){if(!loadTimeData.getBoolean("isGuest")){return undefined}const pageVisibility={a11y:false,ai:false,appearance:false,autofill:false,defaultBrowser:false,downloads:false,extensions:false,languages:false,onStartup:false,people:false,performance:false,privacy:false,reset:false,safetyHub:false,system:false,yourSavedInfo:false};return pageVisibility}let pageVisibility=createPageVisibility();function resetPageVisibilityForTesting(testVisibility=createPageVisibility()){pageVisibility=testVisibility}
// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class Route{path;parent=null;depth=0;title;isNavigableDialog=false;section="";constructor(path,title){this.path=path;this.title=title}createChild(path,title){assert(path);const newUrl=path[0]==="/"?path:`${this.path}/${path}`;const route=new Route(newUrl,title);route.parent=this;route.section=this.section;route.depth=this.depth+1;return route}createSection(path,section,title){const route=this.createChild(path,title);route.section=section;return route}getAbsolutePath(){return window.location.origin+this.path}contains(route){for(let r=route;r!=null;r=r.parent){if(this===r){return true}}return false}isSubpage(){return!this.isNavigableDialog&&!!this.parent&&!!this.section&&this.parent.section===this.section}}const CANONICAL_PATH_REGEX=/(^\/)([\/-\w]+)(\/$)/;let routerInstance=null;class Router{routes_;currentRoute;currentQueryParameters_=new URLSearchParams;wasLastRouteChangePopstate_=false;initializeRouteFromUrlCalled_=false;routeObservers_=new Set;static getInstance(){assert(routerInstance);return routerInstance}static setInstance(instance){assert(!routerInstance);routerInstance=instance}static resetInstanceForTesting(instance){if(routerInstance){instance.routeObservers_=routerInstance.routeObservers_}routerInstance=instance}constructor(availableRoutes){this.routes_=availableRoutes;this.currentRoute=this.routes_.BASIC}addObserver(observer){assert(!this.routeObservers_.has(observer));this.routeObservers_.add(observer)}removeObserver(observer){assert(this.routeObservers_.delete(observer))}getRoute(routeName){return this.routeDictionary_()[routeName]}getRoutes(){return this.routes_}setCurrentRoute(route,queryParameters,isPopstate){this.recordMetrics(route.path);const oldRoute=this.currentRoute;this.currentRoute=route;this.currentQueryParameters_=queryParameters;this.wasLastRouteChangePopstate_=isPopstate;new Set(this.routeObservers_).forEach((observer=>{observer.currentRouteChanged(this.currentRoute,oldRoute)}));this.updateTitle_()}updateTitle_(){if(this.currentRoute.title){document.title=loadTimeData.getStringF("settingsAltPageTitle",this.currentRoute.title)}else if(this.currentRoute.isNavigableDialog&&this.currentRoute.parent&&this.currentRoute.parent.title){document.title=loadTimeData.getStringF("settingsAltPageTitle",this.currentRoute.parent.title)}else if(!this.currentRoute.isSubpage()&&!this.routes_.ABOUT.contains(this.currentRoute)){document.title=loadTimeData.getString("settings")}}getCurrentRoute(){return this.currentRoute}getQueryParameters(){return new URLSearchParams(this.currentQueryParameters_)}lastRouteChangeWasPopstate(){return this.wasLastRouteChangePopstate_}routeDictionary_(){return this.routes_}getRouteForPath(path){const canonicalPath=path.replace(CANONICAL_PATH_REGEX,"$1$2");const matchingKey=Object.keys(this.routes_).find((key=>this.routeDictionary_()[key].path===canonicalPath));return matchingKey?this.routeDictionary_()[matchingKey]:null}updateRouteParams(params){let url=this.currentRoute.path;const queryString=params.toString();if(queryString){url+="?"+queryString}window.history.replaceState(window.history.state,"",url);this.currentQueryParameters_=params;new Set(this.routeObservers_).forEach((observer=>{observer.currentRouteChanged(this.currentRoute,this.currentRoute)}))}navigateTo(route,dynamicParameters,removeSearch=false){if(route===this.routes_.ADVANCED){route=this.routes_.BASIC}const params=dynamicParameters||new URLSearchParams;const oldSearchParam=this.getQueryParameters().get("search")||"";const newSearchParam=params.get("search")||"";if(!removeSearch&&oldSearchParam&&!newSearchParam){params.append("search",oldSearchParam)}let url=route.path;const queryString=params.toString();if(queryString){url+="?"+queryString}window.history.pushState(this.currentRoute.path,"",url);this.setCurrentRoute(route,params,false)}navigateToPreviousRoute(){let previousRoute=null;if(window.history.state){previousRoute=this.getRouteForPath(window.history.state);assert(previousRoute)}if(previousRoute&&previousRoute.depth<=this.currentRoute.depth){window.history.back()}else{this.navigateTo(this.currentRoute.parent||this.routes_.BASIC)}}initializeRouteFromUrl(){assert(!this.initializeRouteFromUrlCalled_);this.initializeRouteFromUrlCalled_=true;const route=this.getRouteForPath(window.location.pathname);this.recordMetrics(route?route.path:this.routes_.BASIC.path);if(route&&route!==this.routes_.ADVANCED){this.currentRoute=route;this.currentQueryParameters_=new URLSearchParams(window.location.search)}else{window.history.replaceState(undefined,"",this.routes_.BASIC.path)}this.updateTitle_()}recordMetrics(urlPath){assert(!urlPath.startsWith("chrome://"));assert(!urlPath.startsWith("settings"));assert(urlPath.startsWith("/"));assert(!urlPath.match(/\?/g));const metricName="WebUI.Settings.PathVisited";chrome.metricsPrivate.recordSparseValueWithPersistentHash(metricName,urlPath)}resetRouteForTesting(){this.initializeRouteFromUrlCalled_=false;this.wasLastRouteChangePopstate_=false;this.currentRoute=this.routes_.BASIC;this.currentQueryParameters_=new URLSearchParams}}const RouteObserverMixin=dedupingMixin((superClass=>{class RouteObserverMixin extends superClass{connectedCallback(){super.connectedCallback();assert(routerInstance);routerInstance.addObserver(this);this.currentRouteChanged(routerInstance.currentRoute,undefined)}disconnectedCallback(){super.disconnectedCallback();assert(routerInstance);routerInstance.removeObserver(this)}currentRouteChanged(_newRoute,_oldRoute){assertNotReached()}}return RouteObserverMixin}));
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function addPrivacyChildRoutes(r){assert(r.PRIVACY);r.CLEAR_BROWSER_DATA=r.PRIVACY.createChild("/clearBrowserData");r.CLEAR_BROWSER_DATA.isNavigableDialog=true;const visibility=pageVisibility||{};if(visibility.safetyHub!==false){r.SAFETY_HUB=r.PRIVACY.createChild("/safetyCheck")}if(loadTimeData.getBoolean("showPrivacyGuide")){r.PRIVACY_GUIDE=r.PRIVACY.createChild("guide")}r.SITE_SETTINGS=r.PRIVACY.createChild("/content");r.SECURITY=r.PRIVACY.createChild("/security");r.COOKIES=r.PRIVACY.createChild("/cookies");if(loadTimeData.getBoolean("enableIncognitoTrackingProtections")){r.INCOGNITO_TRACKING_PROTECTIONS=r.PRIVACY.createChild("/incognito")}if(!loadTimeData.getBoolean("isPrivacySandboxRestricted")){r.PRIVACY_SANDBOX=r.PRIVACY.createChild("/adPrivacy");r.PRIVACY_SANDBOX_TOPICS=r.PRIVACY_SANDBOX.createChild("/adPrivacy/interests");r.PRIVACY_SANDBOX_MANAGE_TOPICS=r.PRIVACY_SANDBOX_TOPICS.createChild("/adPrivacy/interests/manage");r.PRIVACY_SANDBOX_FLEDGE=r.PRIVACY_SANDBOX.createChild("/adPrivacy/sites");r.PRIVACY_SANDBOX_AD_MEASUREMENT=r.PRIVACY_SANDBOX.createChild("/adPrivacy/measurement")}else if(loadTimeData.getBoolean("isPrivacySandboxRestrictedNoticeEnabled")){r.PRIVACY_SANDBOX=r.PRIVACY.createChild("/adPrivacy");r.PRIVACY_SANDBOX_AD_MEASUREMENT=r.PRIVACY_SANDBOX.createChild("/adPrivacy/measurement")}if(loadTimeData.getBoolean("enableSecurityKeysSubpage")){r.SECURITY_KEYS=r.SECURITY.createChild("/securityKeys")}r.SITE_SETTINGS_ALL=r.SITE_SETTINGS.createChild("all");r.SITE_SETTINGS_SITE_DETAILS=r.SITE_SETTINGS_ALL.createChild("/content/siteDetails");r.SITE_SETTINGS_HANDLERS=r.SITE_SETTINGS.createChild("/handlers");r.SITE_SETTINGS_ADS=r.SITE_SETTINGS.createChild("ads");r.SITE_SETTINGS_AR=r.SITE_SETTINGS.createChild("ar");r.SITE_SETTINGS_AUTOMATIC_DOWNLOADS=r.SITE_SETTINGS.createChild("automaticDownloads");if(loadTimeData.getBoolean("autoPictureInPictureEnabled")){r.SITE_SETTINGS_AUTO_PICTURE_IN_PICTURE=r.SITE_SETTINGS.createChild("autoPictureInPicture")}if(loadTimeData.getBoolean("capturedSurfaceControlEnabled")){r.SITE_SETTINGS_CAPTURED_SURFACE_CONTROL=r.SITE_SETTINGS.createChild("capturedSurfaceControl")}r.SITE_SETTINGS_AUTO_VERIFY=r.SITE_SETTINGS.createChild("autoVerify");r.SITE_SETTINGS_BACKGROUND_SYNC=r.SITE_SETTINGS.createChild("backgroundSync");r.SITE_SETTINGS_CAMERA=r.SITE_SETTINGS.createChild("camera");r.SITE_SETTINGS_CLIPBOARD=r.SITE_SETTINGS.createChild("clipboard");if(loadTimeData.getBoolean("enableHandTrackingContentSetting")){r.SITE_SETTINGS_HAND_TRACKING=r.SITE_SETTINGS.createChild("handTracking")}r.SITE_SETTINGS_IDLE_DETECTION=r.SITE_SETTINGS.createChild("idleDetection");r.SITE_SETTINGS_IMAGES=r.SITE_SETTINGS.createChild("images");r.SITE_SETTINGS_MIXEDSCRIPT=r.SITE_SETTINGS.createChild("insecureContent");r.SITE_SETTINGS_JAVASCRIPT=r.SITE_SETTINGS.createChild("javascript");r.SITE_SETTINGS_JAVASCRIPT_OPTIMIZER=r.SITE_SETTINGS.createChild("v8");if(loadTimeData.getBoolean("enableKeyboardLockPrompt")){r.SITE_SETTINGS_KEYBOARD_LOCK=r.SITE_SETTINGS.createChild("keyboardLock")}r.SITE_SETTINGS_SOUND=r.SITE_SETTINGS.createChild("sound");r.SITE_SETTINGS_SENSORS=r.SITE_SETTINGS.createChild("sensors");r.SITE_SETTINGS_LOCATION=r.SITE_SETTINGS.createChild("location");r.SITE_SETTINGS_MICROPHONE=r.SITE_SETTINGS.createChild("microphone");r.SITE_SETTINGS_NOTIFICATIONS=r.SITE_SETTINGS.createChild("notifications");r.SITE_SETTINGS_POPUPS=r.SITE_SETTINGS.createChild("popups");r.SITE_SETTINGS_MIDI_DEVICES=r.SITE_SETTINGS.createChild("midiDevices");r.SITE_SETTINGS_USB_DEVICES=r.SITE_SETTINGS.createChild("usbDevices");r.SITE_SETTINGS_HID_DEVICES=r.SITE_SETTINGS.createChild("hidDevices");r.SITE_SETTINGS_SERIAL_PORTS=r.SITE_SETTINGS.createChild("serialPorts");if(loadTimeData.getBoolean("enableWebPrintingContentSetting")){r.SITE_SETTINGS_WEB_PRINTING=r.SITE_SETTINGS.createChild("webPrinting")}if(loadTimeData.getBoolean("enableWebBluetoothNewPermissionsBackend")){r.SITE_SETTINGS_BLUETOOTH_DEVICES=r.SITE_SETTINGS.createChild("bluetoothDevices")}r.SITE_SETTINGS_ZOOM_LEVELS=r.SITE_SETTINGS.createChild("zoomLevels");r.SITE_SETTINGS_PDF_DOCUMENTS=r.SITE_SETTINGS.createChild("pdfDocuments");r.SITE_SETTINGS_PROTECTED_CONTENT=r.SITE_SETTINGS.createChild("protectedContent");if(loadTimeData.getBoolean("enablePaymentHandlerContentSetting")){r.SITE_SETTINGS_PAYMENT_HANDLER=r.SITE_SETTINGS.createChild("paymentHandler")}if(loadTimeData.getBoolean("enableFederatedIdentityApiContentSetting")){r.SITE_SETTINGS_FEDERATED_IDENTITY_API=r.SITE_SETTINGS.createChild("federatedIdentityApi")}r.SITE_SETTINGS_SITE_DATA=r.SITE_SETTINGS.createChild("siteData");r.SITE_SETTINGS_VR=r.SITE_SETTINGS.createChild("vr");if(loadTimeData.getBoolean("enableExperimentalWebPlatformFeatures")){r.SITE_SETTINGS_BLUETOOTH_SCANNING=r.SITE_SETTINGS.createChild("bluetoothScanning")}r.SITE_SETTINGS_WINDOW_MANAGEMENT=r.SITE_SETTINGS.createChild("windowManagement");r.SITE_SETTINGS_FILE_SYSTEM_WRITE=r.SITE_SETTINGS.createChild("filesystem");if(loadTimeData.getBoolean("showPersistentPermissions")){r.SITE_SETTINGS_FILE_SYSTEM_WRITE_DETAILS=r.SITE_SETTINGS_FILE_SYSTEM_WRITE.createChild("siteDetails")}r.SITE_SETTINGS_LOCAL_FONTS=r.SITE_SETTINGS.createChild("localFonts");r.SITE_SETTINGS_STORAGE_ACCESS=r.SITE_SETTINGS.createChild("storageAccess");r.SITE_SETTINGS_AUTOMATIC_FULLSCREEN=r.SITE_SETTINGS.createChild("automaticFullScreen");if(loadTimeData.getBoolean("enableWebAppInstallation")){r.SITE_SETTINGS_WEB_APP_INSTALLATION=r.SITE_SETTINGS.createChild("webApplications")}if(loadTimeData.getBoolean("enableLocalNetworkAccessSetting")){r.SITE_SETTINGS_LOCAL_NETWORK_ACCESS=r.SITE_SETTINGS.createChild("localNetworkAccess")}}function createRoutes(){const r={};r.BASIC=new Route("/");r.ABOUT=r.BASIC.createSection("/help","about",loadTimeData.getString("aboutPageTitle"));r.SEARCH=r.BASIC.createSection("/search","search",loadTimeData.getString("searchPageTitle"));r.SEARCH_ENGINES=r.SEARCH.createChild("/searchEngines");const visibility=pageVisibility||{};if(visibility.people!==false){r.PEOPLE=r.BASIC.createSection("/people","people",loadTimeData.getString("peoplePageTitle"));r.SIGN_OUT=r.PEOPLE.createChild("/signOut");r.SIGN_OUT.isNavigableDialog=true;r.IMPORT_DATA=r.PEOPLE.createChild("/importData");r.IMPORT_DATA.isNavigableDialog=true;if(loadTimeData.getBoolean("replaceSyncPromosWithSignInPromos")){r.ACCOUNT=r.PEOPLE.createChild("/account");r.GOOGLE_SERVICES=r.PEOPLE.createChild("/googleServices")}r.MANAGE_PROFILE=r.PEOPLE.createChild("/manageProfile");r.SYNC=r.PEOPLE.createChild("/syncSetup");r.SYNC_ADVANCED=r.SYNC.createChild("/syncSetup/advanced")}if(visibility.ai!==false&&loadTimeData.getBoolean("showAiPage")){r.AI=r.BASIC.createSection("/ai","ai",loadTimeData.getString("aiInnovationsPageTitle"));if(loadTimeData.getBoolean("showTabOrganizationControl")){r.AI_TAB_ORGANIZATION=r.AI.createChild("/ai/tabOrganizer")}if(loadTimeData.getBoolean("showHistorySearchControl")){r.HISTORY_SEARCH=r.AI.createChild("/ai/historySearch")}if(loadTimeData.getBoolean("showComposeControl")){r.OFFER_WRITING_HELP=r.AI.createChild("/ai/helpMeWrite")}if(loadTimeData.getBoolean("showCompareControl")){r.COMPARE=r.AI.createChild("/ai/compareProducts")}if(loadTimeData.getBoolean("showGlicSettings")){r.GEMINI=r.AI.createChild("/ai/gemini")}}if(visibility.appearance!==false){r.APPEARANCE=r.BASIC.createSection("/appearance","appearance",loadTimeData.getString("appearancePageTitle"));r.FONTS=r.APPEARANCE.createChild("/fonts")}if(visibility.autofill!==false){r.AUTOFILL=r.BASIC.createSection("/autofill","autofill",loadTimeData.getString("autofillPageTitle"));r.PAYMENTS=r.AUTOFILL.createChild("/payments");r.ADDRESSES=r.AUTOFILL.createChild("/addresses");if(loadTimeData.getBoolean("showAutofillAiControl")){r.AUTOFILL_AI=r.AUTOFILL.createChild("/enhancedAutofill")}r.PASSKEYS=r.AUTOFILL.createChild("/passkeys")}if(visibility.yourSavedInfo!==false&&loadTimeData.getBoolean("enableYourSavedInfoSettingsPage")){r.YOUR_SAVED_INFO=r.BASIC.createSection("/yourSavedInfo","yourSavedInfo",loadTimeData.getString("yourSavedInfoPageTitle"))}if(visibility.privacy!==false){r.PRIVACY=r.BASIC.createSection("/privacy","privacy",loadTimeData.getString("privacyPageTitle"));addPrivacyChildRoutes(r)}if(visibility.defaultBrowser!==false){r.DEFAULT_BROWSER=r.BASIC.createSection("/defaultBrowser","defaultBrowser",loadTimeData.getString("defaultBrowser"))}if(visibility.onStartup!==false){r.ON_STARTUP=r.BASIC.createSection("/onStartup","onStartup",loadTimeData.getString("onStartup"))}r.ADVANCED=new Route("/advanced");if(visibility.languages!==false){r.LANGUAGES=r.ADVANCED.createSection("/languages","languages",loadTimeData.getString("languagesPageTitle"));r.SPELL_CHECK=r.LANGUAGES.createSection("/spellCheck","languages")}if(visibility.downloads!==false){r.DOWNLOADS=r.ADVANCED.createSection("/downloads","downloads",loadTimeData.getString("downloadsPageTitle"))}if(visibility.a11y!==false){r.ACCESSIBILITY=r.ADVANCED.createSection("/accessibility","a11y",loadTimeData.getString("a11yPageTitle"))}if(visibility.system!==false){r.SYSTEM=r.ADVANCED.createSection("/system","system",loadTimeData.getString("systemPageTitle"))}if(visibility.reset!==false){r.RESET=r.ADVANCED.createSection("/reset","reset",loadTimeData.getString("resetPageTitle"));r.RESET_DIALOG=r.RESET.createChild("/resetProfileSettings");r.RESET_DIALOG.isNavigableDialog=true;r.TRIGGERED_RESET_DIALOG=r.RESET.createChild("/triggeredResetProfileSettings");r.TRIGGERED_RESET_DIALOG.isNavigableDialog=true}if(visibility.performance!==false){r.PERFORMANCE=r.BASIC.createSection("/performance","performance",loadTimeData.getString("performancePageTitle"))}return r}function buildRouter(){return new Router(createRoutes())}function resetRouterForTesting(router=buildRouter()){Router.resetInstanceForTesting(router);routes=Router.getInstance().getRoutes()}Router.setInstance(buildRouter());window.addEventListener("popstate",(function(){const routerInstance=Router.getInstance();routerInstance.setCurrentRoute(routerInstance.getRouteForPath(window.location.pathname)||routerInstance.getRoutes().BASIC,new URLSearchParams(window.location.search),true)}));let routes=Router.getInstance().getRoutes();function getTopLevelRoute(){if(!loadTimeData.getBoolean("isGuest")){return routes.PEOPLE}let guestTopLevelRoute=routes.SEARCH;return guestTopLevelRoute}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let hideInk=false;document.addEventListener("pointerdown",(function(){hideInk=true}),true);document.addEventListener("keydown",(function(){hideInk=false}),true);function focusWithoutInk(toFocus){if(!("noink"in toFocus)||!hideInk){toFocus.focus();return}const toFocusWithNoInk=toFocus;assert(document===toFocusWithNoInk.ownerDocument);const{noink:noink}=toFocusWithNoInk;toFocusWithNoInk.noink=true;toFocusWithNoInk.focus();toFocusWithNoInk.noink=noink}
// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsViewMixin=dedupingMixin((superClass=>{const superClassBase=RouteObserverMixin(superClass);class SettingsViewMixin extends superClassBase{focusConfig_=null;previousRoute_=null;static get properties(){return{routePath:String}}ready(){super.ready();this.focusConfig_=this.getFocusConfig();this.addEventListener("view-enter-start",this.onViewEnterStart_)}focusBackButton(){}getFocusConfig(){return null}getAssociatedControlFor(_childViewId){assertNotReached()}onViewEnterStart_(){if(this.previousRoute_&&!Router.getInstance().lastRouteChangeWasPopstate()){this.focusBackButton();return}if(!Router.getInstance().lastRouteChangeWasPopstate()){return}if(!this.focusConfig_||!this.previousRoute_){return}const currentRoute=Router.getInstance().getCurrentRoute();const fromToKey=`${this.previousRoute_.path}_${currentRoute.path}`;let pathConfig=this.focusConfig_.get(fromToKey)||this.focusConfig_.get(this.previousRoute_.path);if(pathConfig){let handler;if(typeof pathConfig==="function"){handler=pathConfig}else{handler=()=>{if(typeof pathConfig==="string"){const element=this.shadowRoot.querySelector(pathConfig);assert(element);pathConfig=element}focusWithoutInk(pathConfig)}}handler()}}currentRouteChanged(_newRoute,oldRoute){this.previousRoute_=oldRoute||null}}return SettingsViewMixin}));
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var FeatureOptInState;(function(FeatureOptInState){FeatureOptInState[FeatureOptInState["NOT_INITIALIZED"]=0]="NOT_INITIALIZED";FeatureOptInState[FeatureOptInState["ENABLED"]=1]="ENABLED";FeatureOptInState[FeatureOptInState["DISABLED"]=2]="DISABLED"})(FeatureOptInState||(FeatureOptInState={}));var ModelExecutionEnterprisePolicyValue;(function(ModelExecutionEnterprisePolicyValue){ModelExecutionEnterprisePolicyValue[ModelExecutionEnterprisePolicyValue["ALLOW"]=0]="ALLOW";ModelExecutionEnterprisePolicyValue[ModelExecutionEnterprisePolicyValue["ALLOW_WITHOUT_LOGGING"]=1]="ALLOW_WITHOUT_LOGGING";ModelExecutionEnterprisePolicyValue[ModelExecutionEnterprisePolicyValue["DISABLE"]=2]="DISABLE"})(ModelExecutionEnterprisePolicyValue||(ModelExecutionEnterprisePolicyValue={}));var SettingsAiPageFeaturePrefName;(function(SettingsAiPageFeaturePrefName){SettingsAiPageFeaturePrefName["HISTORY_SEARCH"]="optimization_guide.history_search_setting_state";SettingsAiPageFeaturePrefName["COMPOSE"]="optimization_guide.compose_setting_state";SettingsAiPageFeaturePrefName["TAB_ORGANIZATION"]="optimization_guide.tab_organization_setting_state";SettingsAiPageFeaturePrefName["AUTOFILL_AI"]="autofill.autofill_ai.opt_in_status"})(SettingsAiPageFeaturePrefName||(SettingsAiPageFeaturePrefName={}));var AiEnterpriseFeaturePrefName;(function(AiEnterpriseFeaturePrefName){AiEnterpriseFeaturePrefName["HISTORY_SEARCH"]="optimization_guide.model_execution.history_search_enterprise_policy_allowed";AiEnterpriseFeaturePrefName["COMPOSE"]="optimization_guide.model_execution.compose_enterprise_policy_allowed";AiEnterpriseFeaturePrefName["TAB_ORGANIZATION"]="optimization_guide.model_execution.tab_organization_enterprise_policy_allowed";AiEnterpriseFeaturePrefName["COMPARE"]="optimization_guide.model_execution.tab_compare_settings_enterprise_policy";AiEnterpriseFeaturePrefName["AUTOFILL_AI"]="optimization_guide.model_execution.autofill_prediction_improvements_enterprise_policy_allowed"})(AiEnterpriseFeaturePrefName||(AiEnterpriseFeaturePrefName={}));var AiPageActions;(function(AiPageActions){AiPageActions["HISTORY_SEARCH_ENABLED"]="Settings.AiPage.HistorySearch.Enabled";AiPageActions["HISTORY_SEARCH_DISABLED"]="Settings.AiPage.HistorySearch.Disabled";AiPageActions["HISTORY_SEARCH_FEATURE_LINK_CLICKED"]="Settings.AiPage.HistorySearch.FeatureLinkClicked";AiPageActions["HISTORY_SEARCH_LEARN_MORE_CLICKED"]="Settings.AiPage.HistorySearch.LearnMoreClicked";AiPageActions["COMPARE_FEATURE_LINK_CLICKED"]="Settings.AiPage.Compare.FeatureLinkClicked";AiPageActions["COMPARE_LEARN_MORE_CLICKED"]="Settings.AiPage.Compare.LearnMoreClicked";AiPageActions["COMPOSE_LEARN_MORE_CLICKED"]="Settings.AiPage.Compose.LearnMoreClicked";AiPageActions["COMPOSE_PROACTIVE_NUDGE_ENABLED"]="Settings.AiPage.Compose.ProactiveNudgeEnabled";AiPageActions["COMPOSE_PROACTIVE_NUDGE_DISABLED"]="Settings.AiPage.Compose.ProactiveNudgeDisabled";AiPageActions["TAB_ORGANIZATION_LEARN_MORE_CLICKED"]="Settings.AiPage.TabOrganization.LearnMoreClicked";AiPageActions["GLIC_COLLAPSED_LEARN_MORE_CLICKED"]="Settings.AiPage.GlicCollapsed.LearnMoreClicked";AiPageActions["GLIC_SHORTCUTS_LEARN_MORE_CLICKED"]="Settings.AiPage.GlicShortcuts.LearnMoreClicked";AiPageActions["GLIC_SHORTCUTS_LAUNCHER_TOGGLE_LEARN_MORE_CLICKED"]="Settings.AiPage.GlicShortcuts.LauncherToggleLearnMoreClicked";AiPageActions["GLIC_SHORTCUTS_LOCATION_TOGGLE_LEARN_MORE_CLICKED"]="Settings.AiPage.GlicShortcuts.LocationToggleLearnMoreClicked";AiPageActions["GLIC_SHORTCUTS_TAB_ACCESS_TOGGLE_LEARN_MORE_CLICKED"]="Settings.AiPage.GlicShortcuts.TabAccessToggleLearnMoreClicked";AiPageActions["GLIC_SHORTCUTS_DEFAULT_TAB_ACCESS_TOGGLE_LEARN_MORE_CLICKED"]="Settings.AiPage.GlicShortcuts.DefaultTabAccessToggleLearnMoreClicked"})(AiPageActions||(AiPageActions={}));let instance$A=null;function getCss$k(){return instance$A||(instance$A=[...[],css`:host{--collapse-duration:var(--iron-collapse-transition-duration,300ms);display:block;transition:max-height var(--collapse-duration) ease-out;overflow:visible}:host([no-animation]){transition:none}:host(.collapse-closed){display:none}:host(:not(.collapse-opened)){overflow:hidden}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$i(){return html`<slot></slot>`}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class CrCollapseElement extends CrLitElement{static get is(){return"cr-collapse"}static get styles(){return getCss$k()}render(){return getHtml$i.bind(this)()}static get properties(){return{opened:{type:Boolean,notify:true},noAnimation:{type:Boolean,reflect:true}}}#opened_accessor_storage=false;get opened(){return this.#opened_accessor_storage}set opened(value){this.#opened_accessor_storage=value}#noAnimation_accessor_storage=false;get noAnimation(){return this.#noAnimation_accessor_storage}set noAnimation(value){this.#noAnimation_accessor_storage=value}toggle(){this.opened=!this.opened}show(){this.opened=true}hide(){this.opened=false}firstUpdated(){if(!this.hasAttribute("role")){this.setAttribute("role","group")}this.setAttribute("aria-hidden","true");this.addEventListener("transitionend",(e=>this.onTransitionEnd_(e)))}updated(changedProperties){super.updated(changedProperties);if(!changedProperties.has("opened")){return}this.setAttribute("aria-hidden",this.opened?"false":"true");this.classList.toggle("collapse-closed",false);this.classList.toggle("collapse-opened",false);this.updateHeight_(this.opened,changedProperties.get("opened"));if(this.opened){this.focus()}}updateHeight_(opening,lastOpened){const finalMaxHeight=opening?"":"0px";const animationStartSize=`${this.getBoundingClientRect().height}px`;const animationEndSize=opening?`${this.scrollHeight}px`:"0px";const willAnimate=lastOpened!==undefined&&!this.noAnimation&&this.style.maxHeight!==finalMaxHeight&&animationStartSize!==animationEndSize;if(willAnimate&&!opening){this.style.maxHeight=animationStartSize;this.scrollTop=this.scrollTop}this.style.maxHeight=animationEndSize;if(!willAnimate){this.updateStyles_()}}onTransitionEnd_(e){if(e.composedPath()[0]===this){this.updateStyles_()}}updateStyles_(){this.style.maxHeight=this.opened?"":"0px";this.classList.toggle("collapse-closed",!this.opened);this.classList.toggle("collapse-opened",this.opened)}}customElements.define(CrCollapseElement.is,CrCollapseElement);let instance$z=null;function getCss$j(){return instance$z||(instance$z=[...[],css`:host{--cr-input-background-color:rgba(255,255,255,1.0);--cr-input-border-bottom:0px;--cr-input-border-radius:8px;--cr-input-color:var(--cr-primary-text-color);--cr-input-error-color:var(--color-textfield-filled-error,var(--cr-fallback-color-error));--cr-input-focus-color:var(--color-textfield-filled-underline-focused,var(--cr-fallback-color-primary));--cr-input-hover-background-color:var(--cr-hover-background-color);--cr-input-label-color:var(--color-textfield-foreground-label,var(--cr-fallback-color-on-surface-subtle));--cr-input-padding-bottom:10px;--cr-input-padding-end:10px;--cr-input-padding-start:10px;--cr-input-padding-top:10px;--cr-input-placeholder-color:var(--color-textfield-foreground-placeholder,var(--cr-fallback-on-surface-subtle));display:block;isolation:isolate;outline:none}:host([readonly]){--cr-input-border-radius:8px}#label{color:var(--cr-input-label-color);font-size:11px;line-height:16px}:host([focused_]:not([readonly]):not([invalid])) #label{color:var(--cr-input-focus-label-color,var(--cr-input-label-color))}#input-container{border-radius:8px;overflow:hidden;position:relative;width:var(--cr-input-width,100%)}:host([focused_]) #input-container{outline:var(--cr-input-focus-outline,none)}#inner-input-container{background-color:var(--cr-input-background-color);box-sizing:border-box;padding:0}#inner-input-content ::slotted(*){--cr-icon-button-fill-color:var(--color-textfield-foreground-icon,var(--cr-fallback-color-on-surface-subtle));--cr-icon-button-icon-size:16px;--cr-icon-button-size:24px;--cr-icon-button-margin-start:0;--cr-icon-color:var(--color-textfield-foreground-icon,var(--cr-fallback-color-on-surface-subtle))}#inner-input-content ::slotted([slot='inline-prefix']){--cr-icon-button-margin-start:-8px}#inner-input-content ::slotted([slot='inline-suffix']){--cr-icon-button-margin-end:-4px}:host([invalid]) #inner-input-content ::slotted(*){--cr-icon-color:var(--cr-input-error-color);--cr-icon-button-fill-color:var(--cr-input-error-color)}#hover-layer{display:none;inset:0;pointer-events:none;position:absolute;z-index:0}:host(:not([readonly]):not([disabled])) #input-container:hover #hover-layer{display:block}#input{-webkit-appearance:none;background-color:transparent;border:none;box-sizing:border-box;caret-color:var(--cr-input-focus-color);color:var(--cr-input-color);font-family:inherit;font-size:var(--cr-input-font-size,12px);font-weight:inherit;line-height:16px;min-height:var(--cr-input-min-height,auto);outline:none;padding:0;text-align:inherit;text-overflow:ellipsis;width:100%}#inner-input-content{padding-bottom:var(--cr-input-padding-bottom);padding-inline-end:var(--cr-input-padding-end);padding-inline-start:var(--cr-input-padding-start);padding-top:var(--cr-input-padding-top)}#underline{border-bottom:0;border-radius:8px;bottom:0;box-sizing:border-box;display:var(--cr-input-underline-display);height:var(--cr-input-underline-height,0);left:0;margin:auto;opacity:0;position:absolute;right:0;transition:opacity 120ms ease-out,width 0s linear 180ms;width:0}:host([invalid]) #underline,:host([force-underline]) #underline,:host([focused_]) #underline{opacity:1;transition:opacity 120ms ease-in,width 180ms ease-out;width:100%}#underline-base{display:none}:host([readonly]) #underline{display:none}:host(:not([readonly])) #underline-base{border-bottom:0;bottom:0;display:block;left:0;position:absolute;right:0}:host([disabled]){color:var(--color-textfield-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-input-border-bottom:1px solid currentColor;--cr-input-placeholder-color:currentColor;--cr-input-color:currentColor;--cr-input-background-color:var(--color-textfield-background-disabled,var(--cr-fallback-color-disabled-background))}:host([disabled]) #inner-input-content ::slotted(*){--cr-icon-color:currentColor;--cr-icon-button-fill-color:currentColor}:host(.stroked){--cr-input-background-color:transparent;--cr-input-border:1px solid var(--color-side-panel-textfield-border,var(--cr-fallback-color-neutral-outline));--cr-input-border-bottom:none;--cr-input-border-radius:8px;--cr-input-padding-bottom:9px;--cr-input-padding-end:9px;--cr-input-padding-start:9px;--cr-input-padding-top:9px;--cr-input-underline-display:none;--cr-input-min-height:36px;line-height:16px}:host(.stroked[focused_]){--cr-input-border:2px solid var(--cr-focus-outline-color);--cr-input-padding-bottom:8px;--cr-input-padding-end:8px;--cr-input-padding-start:8px;--cr-input-padding-top:8px}:host(.stroked[invalid]){--cr-input-border:1px solid var(--cr-input-error-color)}:host(.stroked[focused_][invalid]){--cr-input-border:2px solid var(--cr-input-error-color)}@media (prefers-color-scheme:dark){:host{--cr-input-background-color:rgba(33,33,33,1.0)}}`])}let instance$y=null;function getCss$i(){return instance$y||(instance$y=[...[getCss$x(),getCss$j(),getCss$r()],css`:host([disabled]) :-webkit-any(#label,#error,#input-container){opacity:var(--cr-disabled-opacity);pointer-events:none}:host([disabled]) :is(#label,#error,#input-container){opacity:1}:host ::slotted(cr-button[slot=suffix]){margin-inline-start:var(--cr-button-edge-spacing) !important}:host([invalid]) #label{color:var(--cr-input-error-color)}#input{border-bottom:none;letter-spacing:var(--cr-input-letter-spacing)}#input-container{border-radius:8px;border:var(--owl-border-override,1px solid rgba(0,0,0,0.1))}#input::placeholder{color:var(--cr-input-placeholder-color,var(--cr-secondary-text-color));letter-spacing:var(--cr-input-placeholder-letter-spacing)}:host([invalid]) #input{caret-color:var(--cr-input-error-color)}:host([readonly]) #input{opacity:var(--cr-input-readonly-opacity,0.6)}:host([invalid]) #underline{border-color:var(--cr-input-error-color)}#error{color:var(--cr-input-error-color);display:var(--cr-input-error-display,block);font-size:11px;min-height:var(--cr-form-field-label-height);line-height:16px;margin:4px 10px;visibility:hidden;white-space:var(--cr-input-error-white-space);height:auto;overflow:hidden;text-overflow:ellipsis}:host([invalid]) #error{visibility:visible}#row-container,#inner-input-content{align-items:center;display:flex;justify-content:space-between;position:relative}#inner-input-content{gap:4px;height:16px;z-index:1}#input[type='search']::-webkit-search-cancel-button{display:none}:host-context([dir=rtl]) #input[type=url]{text-align:right}#input[type=url]{direction:ltr}@media (prefers-color-scheme:dark){#input-container{border:var(--owl-border-override,1px solid rgba(255,255,255,0.8))}}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$h(){return html`
<div id="label" class="cr-form-field-label" ?hidden="${!this.label}"
    aria-hidden="true">
  ${this.label}
</div>
<div id="row-container" part="row-container">
  <div id="input-container">
    <div id="inner-input-container">
      <div id="hover-layer"></div>
      <div id="inner-input-content">
        <slot name="inline-prefix"></slot>
        <input id="input" ?disabled="${this.disabled}"
            ?autofocus="${this.autofocus}"
            .value="${this.internalValue_}" tabindex="${this.inputTabindex}"
            .type="${this.type}"
            ?readonly="${this.readonly}" maxlength="${this.maxlength}"
            pattern="${this.pattern||nothing}" ?required="${this.required}"
            minlength="${this.minlength}" inputmode="${this.inputmode}"
            aria-description="${this.ariaDescription||nothing}"
            aria-errormessage="${this.getAriaErrorMessage_()||nothing}"
            aria-label="${this.getAriaLabel_()}"
            aria-invalid="${this.getAriaInvalid_()}"
            .max="${this.max||nothing}" .min="${this.min||nothing}"
            @focus="${this.onInputFocus_}"
            @blur="${this.onInputBlur_}" @change="${this.onInputChange_}"
            @input="${this.onInput_}"
            part="input"
            autocomplete="off">
        <slot name="inline-suffix"></slot>
      </div>
    </div>
    <div id="underline-base"></div>
    <div id="underline"></div>
  </div>
  <slot name="suffix"></slot>
</div>
<div id="error" role="${this.getErrorRole_()||nothing}"
    aria-live="assertive">${this.getErrorMessage_()}</div>`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SUPPORTED_INPUT_TYPES=new Set(["number","password","search","text","url"]);class CrInputElement extends CrLitElement{static get is(){return"cr-input"}static get styles(){return getCss$i()}render(){return getHtml$h.bind(this)()}static get properties(){return{ariaDescription:{type:String},ariaLabel:{type:String},autofocus:{type:Boolean,reflect:true},autoValidate:{type:Boolean},disabled:{type:Boolean,reflect:true},errorMessage:{type:String},errorRole_:{type:String},focused_:{type:Boolean,reflect:true},invalid:{type:Boolean,notify:true,reflect:true},max:{type:Number,reflect:true},min:{type:Number,reflect:true},maxlength:{type:Number,reflect:true},minlength:{type:Number,reflect:true},pattern:{type:String,reflect:true},inputmode:{type:String},label:{type:String},placeholder:{type:String},readonly:{type:Boolean,reflect:true},required:{type:Boolean,reflect:true},inputTabindex:{type:Number},type:{type:String},value:{type:String,notify:true},internalValue_:{type:String,state:true}}}#ariaDescription_accessor_storage=null;get ariaDescription(){return this.#ariaDescription_accessor_storage}set ariaDescription(value){this.#ariaDescription_accessor_storage=value}#ariaLabel_accessor_storage="";get ariaLabel(){return this.#ariaLabel_accessor_storage}set ariaLabel(value){this.#ariaLabel_accessor_storage=value}#autofocus_accessor_storage=false;get autofocus(){return this.#autofocus_accessor_storage}set autofocus(value){this.#autofocus_accessor_storage=value}#autoValidate_accessor_storage=false;get autoValidate(){return this.#autoValidate_accessor_storage}set autoValidate(value){this.#autoValidate_accessor_storage=value}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#errorMessage_accessor_storage="";get errorMessage(){return this.#errorMessage_accessor_storage}set errorMessage(value){this.#errorMessage_accessor_storage=value}#inputmode_accessor_storage;get inputmode(){return this.#inputmode_accessor_storage}set inputmode(value){this.#inputmode_accessor_storage=value}#inputTabindex_accessor_storage=0;get inputTabindex(){return this.#inputTabindex_accessor_storage}set inputTabindex(value){this.#inputTabindex_accessor_storage=value}#invalid_accessor_storage=false;get invalid(){return this.#invalid_accessor_storage}set invalid(value){this.#invalid_accessor_storage=value}#label_accessor_storage="";get label(){return this.#label_accessor_storage}set label(value){this.#label_accessor_storage=value}#max_accessor_storage;get max(){return this.#max_accessor_storage}set max(value){this.#max_accessor_storage=value}#min_accessor_storage;get min(){return this.#min_accessor_storage}set min(value){this.#min_accessor_storage=value}#maxlength_accessor_storage;get maxlength(){return this.#maxlength_accessor_storage}set maxlength(value){this.#maxlength_accessor_storage=value}#minlength_accessor_storage;get minlength(){return this.#minlength_accessor_storage}set minlength(value){this.#minlength_accessor_storage=value}#pattern_accessor_storage;get pattern(){return this.#pattern_accessor_storage}set pattern(value){this.#pattern_accessor_storage=value}#placeholder_accessor_storage=null;get placeholder(){return this.#placeholder_accessor_storage}set placeholder(value){this.#placeholder_accessor_storage=value}#readonly_accessor_storage=false;get readonly(){return this.#readonly_accessor_storage}set readonly(value){this.#readonly_accessor_storage=value}#required_accessor_storage=false;get required(){return this.#required_accessor_storage}set required(value){this.#required_accessor_storage=value}#type_accessor_storage="text";get type(){return this.#type_accessor_storage}set type(value){this.#type_accessor_storage=value}#value_accessor_storage="";get value(){return this.#value_accessor_storage}set value(value){this.#value_accessor_storage=value}#internalValue__accessor_storage="";get internalValue_(){return this.#internalValue__accessor_storage}set internalValue_(value){this.#internalValue__accessor_storage=value}#focused__accessor_storage=false;get focused_(){return this.#focused__accessor_storage}set focused_(value){this.#focused__accessor_storage=value}firstUpdated(){assert(!this.hasAttribute("tabindex"))}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("value")){this.internalValue_=this.value===undefined||this.value===null?"":this.value}if(changedProperties.has("inputTabindex")){assert(this.inputTabindex===0||this.inputTabindex===-1)}if(changedProperties.has("type")){assert(SUPPORTED_INPUT_TYPES.has(this.type))}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("value")){const previous=changedProperties.get("value");if((!!this.value||!!previous)&&this.autoValidate){this.invalid=!this.inputElement.checkValidity()}}if(changedProperties.has("placeholder")){if(this.placeholder===null||this.placeholder===undefined){this.inputElement.removeAttribute("placeholder")}else{this.inputElement.setAttribute("placeholder",this.placeholder)}}}get inputElement(){return this.$.input}focus(){this.focusInput()}focusInput(){if(this.shadowRoot.activeElement===this.inputElement){return false}this.inputElement.focus();return true}async onInputChange_(e){await this.updateComplete;this.fire("change",{sourceEvent:e})}onInput_(e){this.internalValue_=e.target.value;this.value=this.internalValue_}onInputFocus_(){this.focused_=true}onInputBlur_(){this.focused_=false}getAriaLabel_(){return this.ariaLabel||this.label||this.placeholder}getAriaInvalid_(){return this.invalid?"true":"false"}getErrorMessage_(){return this.invalid?this.errorMessage:""}getErrorRole_(){return this.invalid?"alert":""}getAriaErrorMessage_(){return this.invalid?"error":""}select(start,end){this.inputElement.focus();if(start!==undefined&&end!==undefined){this.inputElement.setSelectionRange(start,end)}else{assert(start===undefined&&end===undefined);this.inputElement.select()}}validate(){this.performUpdate();this.invalid=!this.inputElement.checkValidity();this.performUpdate();return!this.invalid}}customElements.define(CrInputElement.is,CrInputElement);
// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function emptyHTML(){return window.trustedTypes?window.trustedTypes.emptyHTML:""}class CustomElement extends HTMLElement{static get template(){return emptyHTML()}constructor(){super();this.attachShadow({mode:"open"});const template=document.createElement("template");template.innerHTML=this.constructor.template||emptyHTML();this.shadowRoot.appendChild(template.content.cloneNode(true))}$(query){return this.shadowRoot.querySelector(query)}$all(query){return this.shadowRoot.querySelectorAll(query)}getRequiredElement(query){const el=this.shadowRoot.querySelector(query);assert(el);assert(el instanceof HTMLElement);return el}}function getTemplate$q(){return getTrustedHTML`<!--_html_template_start_--><style>:host{clip:rect(0 0 0 0);height:1px;overflow:hidden;position:fixed;width:1px}</style>

<div id="messages" role="alert" aria-live="polite" aria-relevant="additions">
</div>
<!--_html_template_end_-->`}
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const TIMEOUT_MS=150;const instances=new Map;function getInstance(container=document.body){if(instances.has(container)){return instances.get(container)}assert(container.isConnected);const instance=new CrA11yAnnouncerElement;container.appendChild(instance);instances.set(container,instance);return instance}class CrA11yAnnouncerElement extends CustomElement{static get is(){return"cr-a11y-announcer"}static get template(){return getTemplate$q()}currentTimeout_=null;messages_=[];disconnectedCallback(){if(this.currentTimeout_!==null){clearTimeout(this.currentTimeout_);this.currentTimeout_=null}for(const[parent,instance]of instances){if(instance===this){instances.delete(parent);break}}}announce(message,timeout=TIMEOUT_MS){if(this.currentTimeout_!==null){clearTimeout(this.currentTimeout_);this.currentTimeout_=null}this.messages_.push(message);this.currentTimeout_=setTimeout((()=>{const messagesDiv=this.shadowRoot.querySelector("#messages");messagesDiv.innerHTML=window.trustedTypes.emptyHTML;messagesDiv.removeAttribute("role");messagesDiv.setAttribute("role","alert");for(const message of this.messages_){const div=document.createElement("div");div.textContent=message;messagesDiv.appendChild(div)}this.dispatchEvent(new CustomEvent("cr-a11y-announcer-messages-sent",{bubbles:true,detail:{messages:this.messages_.slice()}}));this.messages_.length=0;this.currentTimeout_=null}),timeout)}}customElements.define(CrA11yAnnouncerElement.is,CrA11yAnnouncerElement);
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const isMac=/Mac/.test(navigator.platform);const isWindows=/Win/.test(navigator.platform);const isChromeOS=(()=>{let returnValue=false;return returnValue})();const isAndroid=/Android/.test(navigator.userAgent);const isIOS=/CriOS/.test(navigator.userAgent);let instance$x=null;function getCss$h(){return instance$x||(instance$x=[...[getCss$s(),getCss$x()],css`#main{position:relative;width:200px}#input{--cr-input-readonly-opacity:1}#input:not([invalid]){--cr-input-error-display:none}#edit{margin-inline-start:var(--cr-icon-ripple-padding)}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$g(){return html`<!--_html_template_start_-->
<div id="main">
  <cr-input id="input" ?readonly="${this.readonly_}"
      aria-label="${this.inputAriaLabel}"
      .placeholder="${this.computePlaceholder_()}"
      ?invalid="${this.getIsInvalid_()}"
      .errorMessage="${this.getErrorString_()}"
      ?disabled="${this.inputDisabled}"
      .inputTabindex="${this.readonly_?-1:0}"
      .value="${this.computeText_()}">
    <cr-icon-button id="edit" title="${this.i18n("edit")}"
        aria-label="${this.editButtonAriaLabel}"
        slot="suffix" class="icon-edit no-overlap"
        ?disabled="${this.inputDisabled}"
        @click="${this.onEditClick_}">
    </cr-icon-button>
  </cr-input>
</div>
<!--_html_template_end_-->`}
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var Key;(function(Key){Key[Key["COMMA"]=188]="COMMA";Key[Key["DEL"]=46]="DEL";Key[Key["DOWN"]=40]="DOWN";Key[Key["END"]=35]="END";Key[Key["ESCAPE"]=27]="ESCAPE";Key[Key["HOME"]=36]="HOME";Key[Key["INS"]=45]="INS";Key[Key["LEFT"]=37]="LEFT";Key[Key["MEDIA_NEXT_TRACK"]=176]="MEDIA_NEXT_TRACK";Key[Key["MEDIA_PLAY_PAUSE"]=179]="MEDIA_PLAY_PAUSE";Key[Key["MEDIA_PREV_TRACK"]=177]="MEDIA_PREV_TRACK";Key[Key["MEDIA_STOP"]=178]="MEDIA_STOP";Key[Key["PAGE_DOWN"]=34]="PAGE_DOWN";Key[Key["PAGE_UP"]=33]="PAGE_UP";Key[Key["PERIOD"]=190]="PERIOD";Key[Key["RIGHT"]=39]="RIGHT";Key[Key["SPACE"]=32]="SPACE";Key[Key["TAB"]=9]="TAB";Key[Key["UP"]=38]="UP"})(Key||(Key={}));var ModifierPolicy;(function(ModifierPolicy){ModifierPolicy[ModifierPolicy["NOT_ALLOWED"]=0]="NOT_ALLOWED";ModifierPolicy[ModifierPolicy["REQUIRED"]=1]="REQUIRED"})(ModifierPolicy||(ModifierPolicy={}));function getModifierPolicy(keyCode){switch(keyCode){case Key.MEDIA_NEXT_TRACK:case Key.MEDIA_PLAY_PAUSE:case Key.MEDIA_PREV_TRACK:case Key.MEDIA_STOP:return ModifierPolicy.NOT_ALLOWED;default:return ModifierPolicy.REQUIRED}}function hasModifier(e,countShiftAsModifier){return e.ctrlKey||e.altKey||isMac&&e.metaKey||isChromeOS||countShiftAsModifier&&e.shiftKey}function isValidKeyCode(keyCode){if(keyCode===Key.ESCAPE){return false}for(const k in Key){if(Key[k]===keyCode){return true}}return keyCode>="A".charCodeAt(0)&&keyCode<="Z".charCodeAt(0)||keyCode>="0".charCodeAt(0)&&keyCode<="9".charCodeAt(0)}function keystrokeToString(e){const output=[];if(isMac&&e.metaKey){output.push("Command")}if(e.ctrlKey){output.push("Ctrl")}if(e.altKey){output.push("Alt")}if(e.shiftKey){output.push("Shift")}const keyCode=e.keyCode;if(isValidKeyCode(keyCode)){if(keyCode>="A".charCodeAt(0)&&keyCode<="Z".charCodeAt(0)||keyCode>="0".charCodeAt(0)&&keyCode<="9".charCodeAt(0)){output.push(String.fromCharCode(keyCode))}else{switch(keyCode){case Key.COMMA:output.push("Comma");break;case Key.DEL:output.push("Delete");break;case Key.DOWN:output.push("Down");break;case Key.END:output.push("End");break;case Key.HOME:output.push("Home");break;case Key.INS:output.push("Insert");break;case Key.LEFT:output.push("Left");break;case Key.MEDIA_NEXT_TRACK:output.push("MediaNextTrack");break;case Key.MEDIA_PLAY_PAUSE:output.push("MediaPlayPause");break;case Key.MEDIA_PREV_TRACK:output.push("MediaPrevTrack");break;case Key.MEDIA_STOP:output.push("MediaStop");break;case Key.PAGE_DOWN:output.push("PageDown");break;case Key.PAGE_UP:output.push("PageUp");break;case Key.PERIOD:output.push("Period");break;case Key.RIGHT:output.push("Right");break;case Key.SPACE:output.push("Space");break;case Key.TAB:output.push("Tab");break;case Key.UP:output.push("Up");break}}}return output.join("+")}function hasValidModifiers(e){switch(getModifierPolicy(e.keyCode)){case ModifierPolicy.REQUIRED:return hasModifier(e,false);case ModifierPolicy.NOT_ALLOWED:return!hasModifier(e,true);default:assertNotReached()}}function formatShortcutText(text){return text.split("+").join(" + ")}
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var ShortcutError;(function(ShortcutError){ShortcutError[ShortcutError["NO_ERROR"]=0]="NO_ERROR";ShortcutError[ShortcutError["INCLUDE_START_MODIFIER"]=1]="INCLUDE_START_MODIFIER";ShortcutError[ShortcutError["TOO_MANY_MODIFIERS"]=2]="TOO_MANY_MODIFIERS";ShortcutError[ShortcutError["NEED_CHARACTER"]=3]="NEED_CHARACTER"})(ShortcutError||(ShortcutError={}));const CrShortcutInputElementBase=I18nMixinLit(CrLitElement);class CrShortcutInputElement extends CrShortcutInputElementBase{static get is(){return"cr-shortcut-input"}static get styles(){return getCss$h()}render(){return getHtml$g.bind(this)()}static get properties(){return{shortcut:{type:String},inputAriaLabel:{type:String},editButtonAriaLabel:{type:String},inputDisabled:{type:Boolean},allowCtrlAltShortcuts:{type:Boolean},error_:{type:Number},readonly_:{type:Boolean,reflect:true}}}#shortcut_accessor_storage="";get shortcut(){return this.#shortcut_accessor_storage}set shortcut(value){this.#shortcut_accessor_storage=value}#inputAriaLabel_accessor_storage="";get inputAriaLabel(){return this.#inputAriaLabel_accessor_storage}set inputAriaLabel(value){this.#inputAriaLabel_accessor_storage=value}#editButtonAriaLabel_accessor_storage="";get editButtonAriaLabel(){return this.#editButtonAriaLabel_accessor_storage}set editButtonAriaLabel(value){this.#editButtonAriaLabel_accessor_storage=value}#inputDisabled_accessor_storage=false;get inputDisabled(){return this.#inputDisabled_accessor_storage}set inputDisabled(value){this.#inputDisabled_accessor_storage=value}#allowCtrlAltShortcuts_accessor_storage=false;get allowCtrlAltShortcuts(){return this.#allowCtrlAltShortcuts_accessor_storage}set allowCtrlAltShortcuts(value){this.#allowCtrlAltShortcuts_accessor_storage=value}#readonly__accessor_storage=true;get readonly_(){return this.#readonly__accessor_storage}set readonly_(value){this.#readonly__accessor_storage=value}capturing_=false;#error__accessor_storage=ShortcutError.NO_ERROR;get error_(){return this.#error__accessor_storage}set error_(value){this.#error__accessor_storage=value}pendingShortcut_="";firstUpdated(){const node=this.$.input;node.addEventListener("mouseup",this.startCapture_.bind(this));node.addEventListener("blur",this.endCapture_.bind(this));node.addEventListener("focus",this.startCapture_.bind(this));node.addEventListener("keydown",this.onKeyDown_.bind(this));node.addEventListener("keyup",this.onKeyUp_.bind(this))}getBubbleAnchor(){return this.$.edit}async startCapture_(){if(this.capturing_||this.readonly_){return}this.capturing_=true;await this.updateComplete;this.fire("input-capture-change",true)}async endCapture_(){if(!this.capturing_){return}this.pendingShortcut_="";this.capturing_=false;this.$.input.blur();this.error_=ShortcutError.NO_ERROR;this.readonly_=true;await this.updateComplete;this.fire("input-capture-change",false)}clearShortcut_(){this.pendingShortcut_="";this.shortcut="";this.commitPending_();this.endCapture_()}onKeyDown_(e){if(this.readonly_){return}if(e.target===this.$.edit){return}if(e.keyCode===Key.ESCAPE){if(!this.capturing_){return}this.endCapture_();e.preventDefault();e.stopPropagation();return}if(e.keyCode===Key.TAB){return}if(!this.capturing_){this.startCapture_()}this.handleKey_(e)}onKeyUp_(e){if(this.readonly_){return}if(e.target===this.$.edit||e.key==="Enter"){return}if(e.keyCode===Key.ESCAPE||e.keyCode===Key.TAB){return}this.handleKey_(e)}getErrorString_(){switch(this.error_){case ShortcutError.INCLUDE_START_MODIFIER:return this.i18n("shortcutIncludeStartModifier");case ShortcutError.TOO_MANY_MODIFIERS:return this.i18n("shortcutTooManyModifiers");case ShortcutError.NEED_CHARACTER:return this.i18n("shortcutNeedCharacter");default:assert(this.error_===ShortcutError.NO_ERROR);return""}}handleKey_(e){e.preventDefault();e.stopPropagation();if(!this.allowCtrlAltShortcuts&&e.altKey&&(e.ctrlKey||isMac&&e.metaKey)){this.error_=ShortcutError.TOO_MANY_MODIFIERS;return}if(this.allowCtrlAltShortcuts&&e.metaKey&&e.altKey&&e.shiftKey&&e.ctrlKey){this.error_=ShortcutError.TOO_MANY_MODIFIERS;return}if(!hasValidModifiers(e)){this.pendingShortcut_="";this.error_=ShortcutError.INCLUDE_START_MODIFIER;return}this.pendingShortcut_=keystrokeToString(e);if(!isValidKeyCode(e.keyCode)){this.error_=ShortcutError.NEED_CHARACTER;return}this.error_=ShortcutError.NO_ERROR;getInstance().announce(this.i18n("shortcutSet",formatShortcutText(this.pendingShortcut_)));this.commitPending_();this.endCapture_()}async commitPending_(){this.shortcut=this.pendingShortcut_;await this.updateComplete;this.fire("shortcut-updated",this.shortcut)}computePlaceholder_(){if(this.readonly_){return this.shortcut?this.i18n("shortcutSet",this.computeText_()):this.i18n("shortcutNotSet")}return this.i18n("shortcutTypeAShortcut")}computeText_(){if(this.inputDisabled){return this.i18n("setShortcutInSystemSettings")}return formatShortcutText(this.shortcut)}getIsInvalid_(){return this.error_!==ShortcutError.NO_ERROR}onEditClick_(){this.clearShortcut_();this.readonly_=false;this.$.input.focus()}}customElements.define(CrShortcutInputElement.is,CrShortcutInputElement);const styleMod$5=document.createElement("dom-module");styleMod$5.appendChild(html$1`
  <template>
    <style>
:host{align-items:center;align-self:stretch;display:flex;margin:0;outline:none}:host(:not([effectively-disabled_])){cursor:pointer}:host(:not([no-hover],[effectively-disabled_]):hover){background-color:var(--cr-hover-background-color)}:host(:not([no-hover],[effectively-disabled_]):active){background-color:var(--cr-active-background-color)}:host(:not([no-hover],[effectively-disabled_])) cr-icon-button{--cr-icon-button-hover-background-color:transparent;--cr-icon-button-active-background-color:transparent}
    </style>
  </template>
`.content);styleMod$5.register("cr-actionable-row-style");const styleMod$4=document.createElement("dom-module");styleMod$4.appendChild(html$1`
  <template>
    <style>
[is='action-link']{cursor:pointer;display:inline-block;text-decoration:underline}[is='action-link'],[is='action-link']:active,[is='action-link']:hover,[is='action-link']:visited{color:var(--cr-link-color)}[is='action-link'][disabled]{color:var(--cr-fallback-color-disabled-foreground);cursor:default;pointer-events:none}[is='action-link'].no-outline{outline:none}
    </style>
  </template>
`.content);styleMod$4.register("action-link");let instance$w=null;function getCss$g(){return instance$w||(instance$w=[...[],css`:host{--cr-toggle-checked-bar-color:var(--owl-control-accent-background-color,var(--color-toggle-button-track-on,var(--cr-fallback-color-primary)));--cr-toggle-checked-button-color:var(--owl-control-accent-color,var(--color-toggle-button-thumb-on,var(--cr-fallback-color-on-primary)));--cr-toggle-checked-ripple-color:var(--owl-control-accent-color,var(--cr-active-neutral-on-subtle-background-color));--cr-toggle-ripple-diameter:20px;--cr-toggle-unchecked-bar-color:var(--color-toggle-button-track-off,var(--cr-fallback-color-surface-variant));--cr-toggle-unchecked-button-color:var(--color-toggle-button-thumb-off,var(--cr-fallback-color-outline));--cr-toggle-unchecked-ripple-color:var(--cr-active-neutral-on-subtle-background-color);--cr-toggle-bar-border-color:var(--cr-toggle-unchecked-button-color);--cr-toggle-bar-border:1px solid var(--cr-toggle-bar-border-color);--cr-toggle-bar-width:26px;--cr-toggle-knob-diameter:8px;-webkit-tap-highlight-color:transparent;cursor:pointer;display:block;height:fit-content;isolation:isolate;min-width:initial;outline:none;position:relative;width:fit-content}@media (forced-colors:active){:host #knob{background-color:CanvasText !important}}:host(:active){--cr-toggle-knob-diameter:10px}:host([checked]){--cr-toggle-bar-border-color:var(--cr-toggle-checked-button-color);--cr-toggle-knob-diameter:12px}:host([checked]:active){--cr-toggle-knob-diameter:14px}:host([disabled]){--cr-toggle-checked-bar-color:var(--color-toggle-button-track-on-disabled,var(--cr-fallback-color-disabled-background));--cr-toggle-checked-button-color:var(--color-toggle-button-thumb-on-disabled,var(--cr-fallback-color-surface));--cr-toggle-unchecked-bar-color:transparent;--cr-toggle-unchecked-button-color:var(--color-toggle-button-thumb-off-disabled,var(--cr-fallback-color-disabled-foreground));--cr-toggle-bar-border-color:var(--cr-toggle-unchecked-button-color);cursor:initial;opacity:1;pointer-events:none}:host([checked][disabled]){--cr-toggle-bar-border:none}#bar{background-color:var(--cr-toggle-unchecked-bar-color);border:var(--cr-toggle-bar-border);border-radius:50px;box-sizing:border-box;display:block;height:16px;left:3px;opacity:1;position:initial;top:2px;transition:background-color linear 80ms;width:var(--cr-toggle-bar-width);z-index:0}:host([checked]) #bar{background-color:var(--cr-toggle-checked-bar-color);opacity:1}:host(:focus-visible) #bar{outline:2px solid var(--cr-toggle-checked-bar-color);outline-offset:2px}#knob{--cr-toggle-knob-center-edge-distance_:8px;--cr-toggle-knob-direction_:1;--cr-toggle-knob-travel-distance_:calc(0.5 * var(--cr-toggle-bar-width) - var(--cr-toggle-knob-center-edge-distance_));--cr-toggle-knob-position-center_:calc(0.5 * var(--cr-toggle-bar-width) + -50%);--cr-toggle-knob-position-start_:calc(var(--cr-toggle-knob-position-center_) - var(--cr-toggle-knob-direction_) * var(--cr-toggle-knob-travel-distance_));--cr-toggle-knob-position-end_:calc(var(--cr-toggle-knob-position-center_) + var(--cr-toggle-knob-direction_) * var(--cr-toggle-knob-travel-distance_));background-color:var(--cr-toggle-unchecked-button-color);border-radius:50%;box-shadow:none;display:block;height:var(--cr-toggle-knob-diameter);position:absolute;top:50%;transform:translate(var(--cr-toggle-knob-position-start_),-50%);transition:transform linear 80ms,background-color linear 80ms,width linear 80ms,height linear 80ms;width:var(--cr-toggle-knob-diameter);z-index:1}:host([checked]) #knob{background-color:var(--cr-toggle-checked-button-color);transform:translate(var(--cr-toggle-knob-position-end_),-50%)}:host-context([dir=rtl]) #knob{left:0;--cr-toggle-knob-direction_:-1}:host([checked]:active) #knob,:host([checked]:hover) #knob{--cr-toggle-checked-button-color:var(--owl-control-accent-color,var(--color-toggle-button-thumb-on-hover,var(--cr-fallback-color-primary-container)))}:host(:hover) #knob::before{background-color:var(--cr-hover-on-subtle-background-color);border-radius:50%;content:'';height:var(--cr-toggle-ripple-diameter);left:50%;position:absolute;top:50%;transform:translate(-50%,-50%);width:var(--cr-toggle-ripple-diameter)}#ink{--paper-ripple-opacity:1;color:var(--cr-toggle-unchecked-ripple-color);height:var(--cr-toggle-ripple-diameter);left:50%;outline:var(--cr-toggle-ripple-ring,none);pointer-events:none;position:absolute;top:50%;transform:translate(-50%,-50%);transition:color linear 80ms;width:var(--cr-toggle-ripple-diameter)}:host([checked]) #ink{color:var(--cr-toggle-checked-ripple-color)}:host-context([dir=rtl]) #ink{left:auto;right:50%;transform:translate(50%,-50%)}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$f(){return html`
<span id="bar"></span>
<span id="knob"></span>`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const MOVE_THRESHOLD_PX=5;const CrToggleElementBase=CrRippleMixin(CrLitElement);class CrToggleElement extends CrToggleElementBase{static get is(){return"cr-toggle"}static get styles(){return getCss$g()}render(){return getHtml$f.bind(this)()}static get properties(){return{checked:{type:Boolean,reflect:true,notify:true},disabled:{type:Boolean,reflect:true}}}#checked_accessor_storage=false;get checked(){return this.#checked_accessor_storage}set checked(value){this.#checked_accessor_storage=value}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}boundPointerMove_=null;handledInPointerMove_=false;pointerDownX_=0;firstUpdated(){if(!this.hasAttribute("role")){this.setAttribute("role","button")}if(!this.hasAttribute("tabindex")){this.setAttribute("tabindex","0")}this.setAttribute("aria-pressed",this.checked?"true":"false");this.setAttribute("aria-disabled",this.disabled?"true":"false");this.addEventListener("click",this.onClick_.bind(this));this.addEventListener("keydown",this.onKeyDown_.bind(this));this.addEventListener("keyup",this.onKeyUp_.bind(this));this.addEventListener("pointerdown",this.onPointerDown_.bind(this));this.addEventListener("pointerup",this.onPointerUp_.bind(this))}connectedCallback(){super.connectedCallback();const direction=this.matches(":host-context([dir=rtl]) cr-toggle")?-1:1;this.boundPointerMove_=e=>{e.preventDefault();const diff=e.clientX-this.pointerDownX_;if(Math.abs(diff)<MOVE_THRESHOLD_PX){return}this.handledInPointerMove_=true;const shouldToggle=diff*direction<0&&this.checked||diff*direction>0&&!this.checked;if(shouldToggle){this.toggleState_(false)}}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("checked")){this.setAttribute("aria-pressed",this.checked?"true":"false")}if(changedProperties.has("disabled")){this.setAttribute("tabindex",this.disabled?"-1":"0");this.setAttribute("aria-disabled",this.disabled?"true":"false")}}hideRipple_(){this.getRipple().clear()}onPointerUp_(){assert(this.boundPointerMove_);this.removeEventListener("pointermove",this.boundPointerMove_);this.hideRipple_()}onPointerDown_(e){if(e.button!==0){return}this.setPointerCapture(e.pointerId);this.pointerDownX_=e.clientX;this.handledInPointerMove_=false;assert(this.boundPointerMove_);this.addEventListener("pointermove",this.boundPointerMove_)}onClick_(e){e.stopPropagation();e.preventDefault();if(this.handledInPointerMove_){return}this.toggleState_(false)}async toggleState_(fromKeyboard){if(this.disabled){return}if(!fromKeyboard){this.hideRipple_()}this.checked=!this.checked;await this.updateComplete;this.fire("change",this.checked)}onKeyDown_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(e.repeat){return}if(e.key==="Enter"){this.toggleState_(true)}}onKeyUp_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(e.key===" "){this.toggleState_(true)}}createRipple(){this.rippleContainer=this.$.knob;const ripple=super.createRipple();ripple.setAttribute("recenters","");ripple.classList.add("circle");return ripple}}customElements.define(CrToggleElement.is,CrToggleElement);let instance$v=null;function getCss$f(){return instance$v||(instance$v=[...[getCss$x()],css`:host{display:block;position:absolute;outline:none;z-index:1002;user-select:none;cursor:default}#tooltip{display:block;outline:none;font-size:10px;line-height:1;background-color:var(--paper-tooltip-background,#616161);color:var(--paper-tooltip-text-color,white);padding:8px;border-radius:2px}@keyframes keyFrameFadeInOpacity{0%{opacity:0}100%{opacity:var(--paper-tooltip-opacity,0.9)}}@keyframes keyFrameFadeOutOpacity{0%{opacity:var(--paper-tooltip-opacity,0.9)}100%{opacity:0}}.fade-in-animation{opacity:0;animation-delay:var(--paper-tooltip-delay-in,500ms);animation-name:keyFrameFadeInOpacity;animation-iteration-count:1;animation-timing-function:ease-in;animation-duration:var(--paper-tooltip-duration-in,500ms);animation-fill-mode:forwards}.fade-out-animation{opacity:var(--paper-tooltip-opacity,0.9);animation-delay:var(--paper-tooltip-delay-out,0ms);animation-name:keyFrameFadeOutOpacity;animation-iteration-count:1;animation-timing-function:ease-in;animation-duration:var(--paper-tooltip-duration-out,500ms);animation-fill-mode:forwards}#tooltipOffsetFiller{position:absolute;:host([position="top"]) &{top:100%}:host([position="bottom"]) &{bottom:100%}:host([position="left"]) &{left:100%}:host([position="right"]) &{right:100%}:host(:is([position="top"],[position="bottom"])) &{left:0;height:var(--cr-tooltip-offset);width:100%}:host(:is([position="left"],[position="right"])) &{top:0;height:100%;width:var(--cr-tooltip-offset)}}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$e(){return html`
    <div id="tooltip" hidden part="tooltip">
      <slot></slot>
    </div>
    <div id="tooltipOffsetFiller"></div>`}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var TooltipPosition;(function(TooltipPosition){TooltipPosition["TOP"]="top";TooltipPosition["BOTTOM"]="bottom";TooltipPosition["LEFT"]="left";TooltipPosition["RIGHT"]="right"})(TooltipPosition||(TooltipPosition={}));class CrTooltipElement extends CrLitElement{static get is(){return"cr-tooltip"}static get styles(){return getCss$f()}render(){return getHtml$e.bind(this)()}static get properties(){return{for:{type:String},manualMode:{type:Boolean},position:{type:String,reflect:true},fitToVisibleBounds:{type:Boolean},offset:{type:Number},animationDelay:{type:Number},hideDelay:{type:Number}}}#animationDelay_accessor_storage=500;get animationDelay(){return this.#animationDelay_accessor_storage}set animationDelay(value){this.#animationDelay_accessor_storage=value}#fitToVisibleBounds_accessor_storage=false;get fitToVisibleBounds(){return this.#fitToVisibleBounds_accessor_storage}set fitToVisibleBounds(value){this.#fitToVisibleBounds_accessor_storage=value}#hideDelay_accessor_storage=600;get hideDelay(){return this.#hideDelay_accessor_storage}set hideDelay(value){this.#hideDelay_accessor_storage=value}#for_accessor_storage="";get for(){return this.#for_accessor_storage}set for(value){this.#for_accessor_storage=value}#manualMode_accessor_storage=false;get manualMode(){return this.#manualMode_accessor_storage}set manualMode(value){this.#manualMode_accessor_storage=value}#offset_accessor_storage=14;get offset(){return this.#offset_accessor_storage}set offset(value){this.#offset_accessor_storage=value}#position_accessor_storage=TooltipPosition.BOTTOM;get position(){return this.#position_accessor_storage}set position(value){this.#position_accessor_storage=value}animationPlaying_=false;showing_=false;manualTarget_;target_=null;tracker_=new EventTracker;hideTimeout_=null;connectedCallback(){super.connectedCallback();this.findTarget_()}disconnectedCallback(){if(!this.manualMode){this.removeListeners_()}this.resetHideTimeout_()}firstUpdated(changedProperties){super.firstUpdated(changedProperties);this.addEventListener("animationend",(()=>this.onAnimationEnd_()))}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("animationDelay")){this.style.setProperty("--paper-tooltip-delay-in",`${this.animationDelay}ms`)}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("for")){this.findTarget_()}if(changedProperties.has("manualMode")){if(this.manualMode){this.removeListeners_()}else{this.addListeners_()}}if(changedProperties.has("offset")){this.style.setProperty("--cr-tooltip-offset",`${this.offset}px`)}}get target(){if(this.manualTarget_){return this.manualTarget_}const ownerRoot=this.getRootNode();if(this.for){return ownerRoot.querySelector(`#${this.for}`)}const parentNode=this.parentNode;return!!parentNode&&parentNode.nodeType===Node.DOCUMENT_FRAGMENT_NODE?ownerRoot.host:parentNode}set target(target){this.manualTarget_=target;this.findTarget_()}show(){this.resetHideTimeout_();if(this.showing_){return}if(!!this.textContent&&this.textContent.trim()===""){const children=this.shadowRoot.querySelector("slot").assignedElements();const hasNonEmptyChild=Array.from(children).some((el=>!!el.textContent&&el.textContent.trim()!==""));if(!hasNonEmptyChild){return}}this.showing_=true;this.$.tooltip.hidden=false;this.$.tooltip.classList.remove("fade-out-animation");this.updatePosition();this.animationPlaying_=true;this.$.tooltip.classList.add("fade-in-animation")}hide(){if(!this.showing_){return}if(this.animationPlaying_){this.showing_=false;this.$.tooltip.classList.remove("fade-in-animation","fade-out-animation");this.$.tooltip.hidden=true;return}this.$.tooltip.classList.remove("fade-in-animation");this.$.tooltip.classList.add("fade-out-animation");this.showing_=false;this.animationPlaying_=true}queueHide_(){this.resetHideTimeout_();this.hideTimeout_=setTimeout((()=>{this.hide();this.hideTimeout_=null}),this.hideDelay)}resetHideTimeout_(){if(this.hideTimeout_!==null){clearTimeout(this.hideTimeout_);this.hideTimeout_=null}}updatePosition(){if(!this.target_){return}const offsetParent=this.offsetParent||this.composedOffsetParent_();if(!offsetParent){return}const offset=this.offset;const parentRect=offsetParent.getBoundingClientRect();const targetRect=this.target_.getBoundingClientRect();const tooltipRect=this.$.tooltip.getBoundingClientRect();const horizontalCenterOffset=(targetRect.width-tooltipRect.width)/2;const verticalCenterOffset=(targetRect.height-tooltipRect.height)/2;const targetLeft=targetRect.left-parentRect.left;const targetTop=targetRect.top-parentRect.top;let tooltipLeft;let tooltipTop;switch(this.position){case TooltipPosition.TOP:tooltipLeft=targetLeft+horizontalCenterOffset;tooltipTop=targetTop-tooltipRect.height-offset;break;case TooltipPosition.BOTTOM:tooltipLeft=targetLeft+horizontalCenterOffset;tooltipTop=targetTop+targetRect.height+offset;break;case TooltipPosition.LEFT:tooltipLeft=targetLeft-tooltipRect.width-offset;tooltipTop=targetTop+verticalCenterOffset;break;case TooltipPosition.RIGHT:tooltipLeft=targetLeft+targetRect.width+offset;tooltipTop=targetTop+verticalCenterOffset;break}if(this.fitToVisibleBounds){if(parentRect.left+tooltipLeft+tooltipRect.width>window.innerWidth){this.style.right="0px";this.style.left="auto"}else{this.style.left=Math.max(0,tooltipLeft)+"px";this.style.right="auto"}if(parentRect.top+tooltipTop+tooltipRect.height>window.innerHeight){this.style.bottom=parentRect.height-targetTop+offset+"px";this.style.top="auto"}else{this.style.top=Math.max(-parentRect.top,tooltipTop)+"px";this.style.bottom="auto"}}else{this.style.left=tooltipLeft+"px";this.style.top=tooltipTop+"px"}}findTarget_(){if(!this.manualMode){this.removeListeners_()}this.target_=this.target;if(!this.manualMode){this.addListeners_()}}onAnimationEnd_(){this.animationPlaying_=false;if(!this.showing_){this.$.tooltip.classList.remove("fade-out-animation");this.$.tooltip.hidden=true}}addListeners_(){if(this.target_){this.tracker_.add(this.target_,"pointerenter",(()=>this.show()));this.tracker_.add(this.target_,"focus",(()=>this.show()));this.tracker_.add(this.target_,"pointerleave",(()=>this.queueHide_()));this.tracker_.add(this.target_,"blur",(()=>this.hide()));this.tracker_.add(this.target_,"click",(()=>this.hide()))}this.tracker_.add(this.$.tooltip,"animationend",(()=>this.onAnimationEnd_()));this.tracker_.add(this,"pointerenter",(()=>this.show()));this.tracker_.add(this,"pointerleave",(()=>this.queueHide_()))}removeListeners_(){this.tracker_.removeAll()}composedOffsetParent_(){if(this.computedStyleMap().get("display").value==="none"){return null}for(let ancestor=flatTreeParent(this);ancestor!==null;ancestor=flatTreeParent(ancestor)){if(!(ancestor instanceof Element)){continue}const style=ancestor.computedStyleMap();if(style.get("display").value==="none"){return null}if(style.get("display").value==="contents"){continue}if(style.get("position").value!=="static"){return ancestor}if(ancestor.tagName==="BODY"){return ancestor}}return null;function flatTreeParent(element){if(element.assignedSlot){return element.assignedSlot}if(element.parentNode instanceof ShadowRoot){return element.parentNode.host}return element.parentElement}}}customElements.define(CrTooltipElement.is,CrTooltipElement);let instance$u=null;function getCss$e(){return instance$u||(instance$u=[...[getCss$r()],css`:host{display:flex}cr-icon{--iron-icon-width:var(--cr-icon-size);--iron-icon-height:var(--cr-icon-size);--iron-icon-fill-color:var(--cr-tooltip-icon-fill-color,var(--google-grey-700))}@media (prefers-color-scheme:dark){cr-icon{--iron-icon-fill-color:var(--cr-tooltip-icon-fill-color,var(--google-grey-500))}}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$d(){return html`
<cr-icon id="indicator" tabindex="0" aria-label="${this.iconAriaLabel}"
    aria-describedby="tooltip" icon="${this.iconClass}" role="img">
</cr-icon>
<cr-tooltip id="tooltip"
    for="indicator" position="${this.tooltipPosition}"
    fit-to-visible-bounds part="tooltip">
  <slot name="tooltip-text">${this.tooltipText}</slot>
</cr-tooltip>`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class CrTooltipIconElement extends CrLitElement{static get is(){return"cr-tooltip-icon"}static get styles(){return getCss$e()}render(){return getHtml$d.bind(this)()}static get properties(){return{iconAriaLabel:{type:String},iconClass:{type:String},tooltipText:{type:String},tooltipPosition:{type:String}}}#iconAriaLabel_accessor_storage="";get iconAriaLabel(){return this.#iconAriaLabel_accessor_storage}set iconAriaLabel(value){this.#iconAriaLabel_accessor_storage=value}#iconClass_accessor_storage="";get iconClass(){return this.#iconClass_accessor_storage}set iconClass(value){this.#iconClass_accessor_storage=value}#tooltipText_accessor_storage="";get tooltipText(){return this.#tooltipText_accessor_storage}set tooltipText(value){this.#tooltipText_accessor_storage=value}#tooltipPosition_accessor_storage="top";get tooltipPosition(){return this.#tooltipPosition_accessor_storage}set tooltipPosition(value){this.#tooltipPosition_accessor_storage=value}getFocusableElement(){return this.$.indicator}}customElements.define(CrTooltipIconElement.is,CrTooltipIconElement);
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var CrPolicyIndicatorType;(function(CrPolicyIndicatorType){CrPolicyIndicatorType["DEVICE_POLICY"]="devicePolicy";CrPolicyIndicatorType["EXTENSION"]="extension";CrPolicyIndicatorType["NONE"]="none";CrPolicyIndicatorType["OWNER"]="owner";CrPolicyIndicatorType["PRIMARY_USER"]="primary_user";CrPolicyIndicatorType["RECOMMENDED"]="recommended";CrPolicyIndicatorType["USER_POLICY"]="userPolicy";CrPolicyIndicatorType["PARENT"]="parent";CrPolicyIndicatorType["CHILD_RESTRICTION"]="childRestriction"})(CrPolicyIndicatorType||(CrPolicyIndicatorType={}));function getTemplate$p(){return html$1`<!--_html_template_start_-->    <style include="cr-hidden-style"></style>
    <cr-tooltip-icon id="tooltipIcon" hidden$="[[!indicatorVisible]]"
        tooltip-text="[[indicatorTooltip]]" icon-class="[[indicatorIcon]]"
        icon-aria-label="[[iconAriaLabel]]" exportparts="tooltip">
    </cr-tooltip-icon>
<!--_html_template_end_-->`}
// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class CrPolicyPrefIndicatorElement extends PolymerElement{static get is(){return"cr-policy-pref-indicator"}static get template(){return getTemplate$p()}static get properties(){return{iconAriaLabel:String,indicatorIcon:{type:String,computed:"getIndicatorIcon_(indicatorType)"},indicatorType:{type:String,value:CrPolicyIndicatorType.NONE,computed:"getIndicatorTypeForPref_(pref.*, associatedValue)"},indicatorTooltip:{type:String,computed:"getIndicatorTooltipForPref_(indicatorType, pref.*)"},indicatorVisible:{type:Boolean,computed:"getIndicatorVisible_(indicatorType)"},pref:Object,associatedValue:Object}}getIndicatorVisible_(type){return type!==CrPolicyIndicatorType.NONE}getIndicatorIcon_(type){switch(type){case CrPolicyIndicatorType.EXTENSION:return"cr:extension";case CrPolicyIndicatorType.NONE:return"";case CrPolicyIndicatorType.PRIMARY_USER:return"cr:group";case CrPolicyIndicatorType.OWNER:return"cr:person";case CrPolicyIndicatorType.USER_POLICY:case CrPolicyIndicatorType.DEVICE_POLICY:case CrPolicyIndicatorType.RECOMMENDED:return"cr20:domain";case CrPolicyIndicatorType.PARENT:case CrPolicyIndicatorType.CHILD_RESTRICTION:return"cr20:kite";default:assertNotReached()}}getIndicatorTooltip_(type,name,matches){if(!window.CrPolicyStrings){return""}const CrPolicyStrings=window.CrPolicyStrings;switch(type){case CrPolicyIndicatorType.EXTENSION:return name.length>0?CrPolicyStrings.controlledSettingExtension.replace("$1",name):CrPolicyStrings.controlledSettingExtensionWithoutName;case CrPolicyIndicatorType.USER_POLICY:case CrPolicyIndicatorType.DEVICE_POLICY:return CrPolicyStrings.controlledSettingPolicy;case CrPolicyIndicatorType.RECOMMENDED:return matches?CrPolicyStrings.controlledSettingRecommendedMatches:CrPolicyStrings.controlledSettingRecommendedDiffers;case CrPolicyIndicatorType.PARENT:return CrPolicyStrings.controlledSettingParent;case CrPolicyIndicatorType.CHILD_RESTRICTION:return CrPolicyStrings.controlledSettingChildRestriction}return""}getIndicatorTypeForPref_(){assert(this.pref);const{enforcement:enforcement,userSelectableValues:userSelectableValues,controlledBy:controlledBy,recommendedValue:recommendedValue}=this.pref;if(enforcement===chrome.settingsPrivate.Enforcement.RECOMMENDED){if(this.associatedValue!==undefined&&this.associatedValue!==recommendedValue){return CrPolicyIndicatorType.NONE}return CrPolicyIndicatorType.RECOMMENDED}if(enforcement===chrome.settingsPrivate.Enforcement.ENFORCED){if(userSelectableValues!==undefined){if(recommendedValue&&this.associatedValue===recommendedValue){return CrPolicyIndicatorType.RECOMMENDED}else if(userSelectableValues.includes(this.associatedValue)){return CrPolicyIndicatorType.NONE}}switch(controlledBy){case chrome.settingsPrivate.ControlledBy.EXTENSION:return CrPolicyIndicatorType.EXTENSION;case chrome.settingsPrivate.ControlledBy.PRIMARY_USER:return CrPolicyIndicatorType.PRIMARY_USER;case chrome.settingsPrivate.ControlledBy.OWNER:return CrPolicyIndicatorType.OWNER;case chrome.settingsPrivate.ControlledBy.USER_POLICY:return CrPolicyIndicatorType.USER_POLICY;case chrome.settingsPrivate.ControlledBy.DEVICE_POLICY:return CrPolicyIndicatorType.DEVICE_POLICY;case chrome.settingsPrivate.ControlledBy.PARENT:return CrPolicyIndicatorType.PARENT;case chrome.settingsPrivate.ControlledBy.CHILD_RESTRICTION:return CrPolicyIndicatorType.CHILD_RESTRICTION}}if(enforcement===chrome.settingsPrivate.Enforcement.PARENT_SUPERVISED){return CrPolicyIndicatorType.PARENT}return CrPolicyIndicatorType.NONE}getIndicatorTooltipForPref_(){if(!this.pref){return""}const matches=this.pref&&this.pref.value===this.pref.recommendedValue;return this.getIndicatorTooltip_(this.indicatorType,this.pref.controlledByName||"",matches)}getFocusableElement(){return this.$.tooltipIcon.getFocusableElement()}}customElements.define(CrPolicyPrefIndicatorElement.is,CrPolicyPrefIndicatorElement);
// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrPolicyPrefMixin=dedupingMixin((superClass=>{class CrPolicyPrefMixin extends superClass{static get properties(){return{noExtensionIndicator:Boolean,pref:Object}}isPrefEnforced(){return!!this.pref&&this.pref.enforcement===chrome.settingsPrivate.Enforcement.ENFORCED}hasPrefPolicyIndicator(){if(!this.pref){return false}if(this.noExtensionIndicator&&this.pref.controlledBy===chrome.settingsPrivate.ControlledBy.EXTENSION){return false}return this.isPrefEnforced()||this.pref.enforcement===chrome.settingsPrivate.Enforcement.RECOMMENDED}}return CrPolicyPrefMixin}));
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrefControlMixin=dedupingMixin((superClass=>{class PrefControlMixin extends superClass{static get properties(){return{pref:{type:Object,notify:true,observer:"validatePref_"}}}connectedCallback(){super.connectedCallback();this.validatePref_()}validatePref_(){CrSettingsPrefs.initialized.then((()=>{if(this.pref===undefined){console.error(this.getErrorInfo("not found"))}else if(typeof this.pref==="string"){console.error(this.getErrorInfo("incorrect type string"))}else if(this.pref.enforcement===chrome.settingsPrivate.Enforcement.PARENT_SUPERVISED){console.error("PARENT_SUPERVISED is not enforced by pref controls")}}))}getErrorInfo(message){let error=`Pref error [${message}] for element ${this.tagName}`;if(this.id){error+=`#${this.id}`}error+=` in ${this.getRootNode().host.tagName}`;return error}}return PrefControlMixin}));
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const DEFAULT_UNCHECKED_VALUE=0;const DEFAULT_CHECKED_VALUE=1;const SettingsBooleanControlMixin=dedupingMixin((superClass=>{const superClassBase=CrPolicyPrefMixin(PrefControlMixin(superClass));class SettingsBooleanControlMixin extends superClassBase{static get properties(){return{inverted:{type:Boolean,value:false},checked:{type:Boolean,value:false,notify:true,reflectToAttribute:true},disabled:{type:Boolean,value:false,notify:true,reflectToAttribute:true},noSetPref:{type:Boolean,value:false},label:{type:String,value:""},subLabel:{type:String,value:""},numericUncheckedValues:{type:Array,value:()=>[DEFAULT_UNCHECKED_VALUE]},numericCheckedValue:{type:Number,value:DEFAULT_CHECKED_VALUE}}}static get observers(){return["prefValueChanged_(pref.value)"]}notifyChangedByUserInteraction(){this.dispatchEvent(new CustomEvent("settings-boolean-control-change",{bubbles:true,composed:true}));if(!this.pref||this.noSetPref){return}this.sendPrefChange()}resetToPrefValue(){if(this.pref===undefined){this.checked=false;return}this.checked=this.getNewValue_(this.pref.value)}sendPrefChange(){if(this.pref.type===chrome.settingsPrivate.PrefType.NUMBER){assert(!this.inverted);assert(this.numericUncheckedValues.length>0);this.set("pref.value",this.checked?this.numericCheckedValue:this.numericUncheckedValues[0]);return}this.set("pref.value",this.inverted?!this.checked:this.checked)}prefValueChanged_(prefValue){this.checked=this.getNewValue_(prefValue)}getNewValue_(value){if(this.pref.type===chrome.settingsPrivate.PrefType.NUMBER){assert(!this.inverted);return!this.numericUncheckedValues.includes(value)}return this.inverted?!value:!!value}controlDisabled(){return this.disabled||this.isPrefEnforced()||!!(this.pref&&this.pref.userControlDisabled)}}return SettingsBooleanControlMixin}));function getTemplate$o(){return html$1`<!--_html_template_start_--><style include="cr-shared-style cr-actionable-row-style action-link">:host{--cr-icon-button-margin-end:20px;padding:0 var(--cr-section-padding)}:host([elide-label]),:host([elide-label]) #outerRow,:host([elide-label]) #outerRow>div.flex{min-width:0}:host([elide-label]) .label{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}div.flex{flex:1}#outerRow{align-items:center;display:flex;min-height:var(--cr-section-two-line-min-height);width:100%}#outerRow[noSubLabel]{min-height:var(--cr-section-min-height)}#icon{margin-inline-end:var(--cr-icon-button-margin-end)}#labelWrapper{padding:var(--cr-section-vertical-padding) 0}#labelWrapper,::slotted([slot='more-actions']){margin-inline-end:20px !important}cr-policy-pref-indicator{margin-inline-end:var(--cr-controlled-by-spacing)}a{color:var(--cr-link-color)}</style>
<div id="outerRow" noSubLabel$="[[!subLabel]]">
  <template is="dom-if" if="[[icon]]">
    <span id="icon" aria-hidden="true">
      <cr-icon slot="icon" icon="[[icon]]">
      </cr-icon>
    </span>
  </template>
  <div class="flex" id="labelWrapper" hidden$="[[!label]]">
    <div class="label" aria-hidden="[[!ariaShowLabel]]">[[label]]</div>
    <div class="cr-secondary-text label" id="sub-label">
      <template is="dom-if" if="[[subLabelIcon]]">
        <span id="sub-label-icon" aria-hidden="true">
          <cr-icon slot="icon" icon="[[subLabelIcon]]">
          </cr-icon>
        </span>
      </template>
      <span id="sub-label-text" aria-hidden="[[!ariaShowSublabel]]">
        [[subLabel]]
      </span>
      <template is="dom-if" if="[[showLearnMoreUrl]]">
        <a id="learn-more" href="[[learnMoreUrl]]" target="_blank"
            aria-labelledby$="[[getLearnMoreAriaLabelledBy_(learnMoreAriaLabel)]]"
            aria-description="$i18n{opensInNewTab}"
            on-click="onLearnMoreClick_">
          $i18n{learnMore}
        </a>
        <span id="learn-more-aria-label" aria-hidden="true" hidden>
          [[learnMoreAriaLabel]]
        </span>
      </template>
      <template is="dom-if" if="[[subLabelWithLink]]">
        <div id="sub-label-text-with-link"
            inner-h-t-m-l="[[getSubLabelWithLinkContent_(subLabelWithLink)]]"
            on-click="onSubLabelTextWithLinkClick_">
        </div>
      </template>
    </div>
  </div>
  <slot name="more-actions"></slot>
  <template is="dom-if" if="[[hasPrefPolicyIndicator(pref.*)]]">
    <cr-policy-pref-indicator pref="[[pref]]" icon-aria-label="[[label]]">
    </cr-policy-pref-indicator>
  </template>
  <cr-toggle id="control" checked="{{checked}}"
      on-change="onChange_"
      aria-label$="[[getAriaLabel_(label, ariaLabel)]]"
      aria-describedby="sub-label-text"
      disabled="[[controlDisabled(disabled, pref)]]">
  </cr-toggle>
  <slot name="more-actions-after"></slot>
</div>
<!--_html_template_end_-->`}
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsToggleButtonElementBase=SettingsBooleanControlMixin(PolymerElement);class SettingsToggleButtonElement extends SettingsToggleButtonElementBase{static get is(){return"settings-toggle-button"}static get template(){return getTemplate$o()}static get properties(){return{ariaLabel:{type:String,reflectToAttribute:false,observer:"onAriaLabelSet_",value:""},ariaShowLabel:{type:Boolean,reflectToAttribute:true,value:false},ariaShowSublabel:{type:Boolean,reflectToAttribute:true,value:false},elideLabel:{type:Boolean,reflectToAttribute:true},learnMoreUrl:{type:String,reflectToAttribute:true},subLabelWithLink:{type:String,reflectToAttribute:true},learnMoreAriaLabel:{type:String,value:""},showLearnMoreUrl:{type:Boolean,value:false},icon:String,subLabelIcon:String,noToggleOnHostClick:{type:Boolean,value:false}}}static get observers(){return["onDisableOrPrefChange_(disabled, pref.*)"]}ready(){super.ready();if(!this.noToggleOnHostClick){this.addEventListener("click",this.onHostClick_)}}fire_(eventName,detail){this.dispatchEvent(new CustomEvent(eventName,{detail:detail,bubbles:true,composed:true}))}focus(){this.$.control.focus()}onAriaLabelSet_(){if(this.hasAttribute("aria-label")){const ariaLabel=this.ariaLabel;this.removeAttribute("aria-label");this.ariaLabel=ariaLabel}}getAriaLabel_(){return this.ariaLabel||this.label}getLearnMoreAriaLabelledBy_(){return this.learnMoreAriaLabel?"learn-more-aria-label":"sub-label-text learn-more"}getBubbleAnchor(){const anchor=this.shadowRoot.querySelector("#control");assert(anchor);return anchor}onDisableOrPrefChange_(){this.toggleAttribute("effectively-disabled_",this.controlDisabled())}onHostClick_(e){assert(!this.noToggleOnHostClick);e.stopPropagation();if(this.controlDisabled()){return}this.updateCheckedAndNotify_(!this.checked)}onLearnMoreClick_(e){e.stopPropagation();this.fire_("learn-more-clicked")}getSubLabelWithLinkContent_(contents){return sanitizeInnerHtml(contents,{attrs:["id","is","aria-description","aria-hidden","aria-label","aria-labelledby","tabindex"]})}onSubLabelTextWithLinkClick_(e){const target=e.target;if(target.tagName==="A"){this.fire_("sub-label-link-clicked",target.id);e.preventDefault();e.stopPropagation()}}onChange_(e){e.stopPropagation();this.updateCheckedAndNotify_(e.detail)}updateCheckedAndNotify_(checked){this.checked=checked;this.notifyChangedByUserInteraction();this.fire_("change",this.checked)}}customElements.define(SettingsToggleButtonElement.is,SettingsToggleButtonElement);let instance$t=null;function getCss$d(){return instance$t||(instance$t=[...[getCss$m()],css`:host([disabled]){opacity:0.65;pointer-events:none}:host([disabled]) cr-icon-button{display:var(--cr-expand-button-disabled-display,initial)}#label{flex:1;padding:var(--cr-section-vertical-padding) 0}cr-icon-button{--cr-icon-button-icon-size:var(--cr-expand-button-icon-size,20px);--cr-icon-button-size:var(--cr-expand-button-size,36px)}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$c(){return html`
<div id="label" aria-hidden="true"><slot></slot></div>
<cr-icon-button id="icon" aria-labelledby="label" ?disabled="${this.disabled}"
    aria-expanded="${this.getAriaExpanded_()}"
    tabindex="${this.tabIndex}" part="icon" iron-icon="${this.getIcon_()}">
</cr-icon-button>`}
// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class CrExpandButtonElement extends CrLitElement{static get is(){return"cr-expand-button"}static get styles(){return getCss$d()}render(){return getHtml$c.bind(this)()}static get properties(){return{expanded:{type:Boolean,notify:true},disabled:{type:Boolean,reflect:true},ariaLabel:{type:String},tabIndex:{type:Number},expandIcon:{type:String},collapseIcon:{type:String},expandTitle:{type:String},collapseTitle:{type:String}}}#expanded_accessor_storage=false;get expanded(){return this.#expanded_accessor_storage}set expanded(value){this.#expanded_accessor_storage=value}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#expandIcon_accessor_storage="cr:expand-more";get expandIcon(){return this.#expandIcon_accessor_storage}set expandIcon(value){this.#expandIcon_accessor_storage=value}#collapseIcon_accessor_storage="cr:expand-less";get collapseIcon(){return this.#collapseIcon_accessor_storage}set collapseIcon(value){this.#collapseIcon_accessor_storage=value}#expandTitle_accessor_storage;get expandTitle(){return this.#expandTitle_accessor_storage}set expandTitle(value){this.#expandTitle_accessor_storage=value}#collapseTitle_accessor_storage;get collapseTitle(){return this.#collapseTitle_accessor_storage}set collapseTitle(value){this.#collapseTitle_accessor_storage=value}#tabIndex_accessor_storage=0;get tabIndex(){return this.#tabIndex_accessor_storage}set tabIndex(value){this.#tabIndex_accessor_storage=value}firstUpdated(){this.addEventListener("click",this.toggleExpand_)}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("expanded")||changedProperties.has("collapseTitle")||changedProperties.has("expandTitle")){this.title=(this.expanded?this.collapseTitle:this.expandTitle)||""}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("ariaLabel")){this.onAriaLabelChange_()}}focus(){this.$.icon.focus()}getIcon_(){return this.expanded?this.collapseIcon:this.expandIcon}getAriaExpanded_(){return this.expanded?"true":"false"}onAriaLabelChange_(){if(this.ariaLabel){this.$.icon.removeAttribute("aria-labelledby");this.$.icon.setAttribute("aria-label",this.ariaLabel)}else{this.$.icon.removeAttribute("aria-label");this.$.icon.setAttribute("aria-labelledby","label")}}toggleExpand_(event){event.stopPropagation();event.preventDefault();this.scrollIntoViewIfNeeded();this.expanded=!this.expanded;focusWithoutInk(this.$.icon)}}customElements.define(CrExpandButtonElement.is,CrExpandButtonElement);const div$1=document.createElement("div");div$1.innerHTML=getTrustedHTML`<cr-iconset name="iph" size="24">
  <svg>
    <defs>
      <!--
      These icons are copied from Material UI and optimized through SVGOMG
      See http://goo.gl/Y1OdAq for instructions on adding additional icons.
      -->
      <g id="celebration">
        <path fill="none" d="M0 0h20v20H0z"></path>
        <path fill-rule="evenodd"
          d="m2 22 14-5-9-9-5 14Zm10.35-5.82L5.3 18.7l2.52-7.05 4.53 4.53ZM14.53 12.53l5.59-5.59a1.25 1.25 0 0 1 1.77 0l.59.59 1.06-1.06-.59-.59a2.758 2.758 0 0 0-3.89 0l-5.59 5.59 1.06 1.06ZM10.06 6.88l-.59.59 1.06 1.06.59-.59a2.758 2.758 0 0 0 0-3.89l-.59-.59-1.06 1.07.59.59c.48.48.48 1.28 0 1.76ZM17.06 11.88l-1.59 1.59 1.06 1.06 1.59-1.59a1.25 1.25 0 0 1 1.77 0l1.61 1.61 1.06-1.06-1.61-1.61a2.758 2.758 0 0 0-3.89 0ZM15.06 5.88l-3.59 3.59 1.06 1.06 3.59-3.59a2.758 2.758 0 0 0 0-3.89l-1.59-1.59-1.06 1.06 1.59 1.59c.48.49.48 1.29 0 1.77Z">
        </path>
      </g>
      <g id="lightbulb_outline">
        <path fill="none" d="M0 0h24v24H0z"></path>
        <path
          d="M9 21c0 .55.45 1 1 1h4c.55 0 1-.45 1-1v-1H9v1zm3-19C8.14 2 5 5.14 5 9c0 2.38 1.19 4.47 3 5.74V17c0 .55.45 1 1 1h6c.55 0 1-.45 1-1v-2.26c1.81-1.27 3-3.36 3-5.74 0-3.86-3.14-7-7-7zm2 11.7V16h-4v-2.3C8.48 12.63 7 11.53 7 9c0-2.76 2.24-5 5-5s5 2.24 5 5c0 2.49-1.51 3.65-3 4.7z">
        </path>
      </g>
      <g id="lightbulb_outline_chrome_refresh" width="20" height="20" viewBox="0 -960 960 960">
        <path
          d="M479.779-81.413q-30.975 0-52.812-22.704-21.837-22.704-21.837-55.035h149.74q0 32.631-22.058 55.185-22.058 22.554-53.033 22.554ZM333.848-209.065v-75.587h292.304v75.587H333.848Zm-15-125.5Q254.696-374 219.282-440.533q-35.413-66.532-35.413-142.163 0-123.288 86.364-209.59 86.363-86.301 209.739-86.301t209.767 86.301q86.392 86.302 86.392 209.59 0 75.87-35.413 142.283Q705.304-374 641.152-334.565H318.848Zm26.348-83h269.608q37.283-30.522 57.805-73.566 20.521-43.043 20.521-91.512 0-89.424-61.812-151.184-61.813-61.76-151.087-61.76-89.274 0-151.318 61.76-62.043 61.76-62.043 151.184 0 48.469 20.521 91.512 20.522 43.044 57.805 73.566Zm134.804 0Z">
        </path>
      </g>
    </defs>
  </svg>
</cr-iconset>
`;const iconsets$1=div$1.querySelectorAll("cr-iconset");for(const iconset of iconsets$1){document.head.appendChild(iconset)}let instance$s=null;function getCss$c(){return instance$s||(instance$s=[...[getCss$x()],css`:host{--help-bubble-background:var(--color-feature-promo-bubble-background,var(--google-blue-700));--help-bubble-foreground:var(--color-feature-promo-bubble-foreground,var(--google-grey-200));--help-bubble-border-radius:12px;--help-bubble-close-button-icon-size:16px;--help-bubble-close-button-size:20px;--help-bubble-element-spacing:8px;--help-bubble-padding:20px;--help-bubble-font-weight:400;border-radius:var(--help-bubble-border-radius);box-shadow:0 6px 10px 4px rgba(60,64,67,0.15),0 2px 3px rgba(60,64,67,0.3);box-sizing:border-box;position:absolute;z-index:1}#arrow{--help-bubble-arrow-size:11.3px;--help-bubble-arrow-size-half:calc(var(--help-bubble-arrow-size) / 2);--help-bubble-arrow-diameter:16px;--help-bubble-arrow-radius:calc(var(--help-bubble-arrow-diameter) / 2);--help-bubble-arrow-edge-offset:22px;--help-bubble-arrow-offset:calc(var(--help-bubble-arrow-edge-offset) + var(--help-bubble-arrow-radius));--help-bubble-arrow-border-radius:2px;position:absolute}#inner-arrow{background-color:var(--help-bubble-background);height:var(--help-bubble-arrow-size);left:calc(0px - var(--help-bubble-arrow-size-half));position:absolute;top:calc(0px - var(--help-bubble-arrow-size-half));transform:rotate(45deg);width:var(--help-bubble-arrow-size);z-index:-1}#arrow.bottom-edge{bottom:0}#arrow.bottom-edge #inner-arrow{border-bottom-right-radius:var(--help-bubble-arrow-border-radius)}#arrow.top-edge{top:0}#arrow.top-edge #inner-arrow{border-top-left-radius:var(--help-bubble-arrow-border-radius)}#arrow.right-edge{right:0}#arrow.right-edge #inner-arrow{border-top-right-radius:var(--help-bubble-arrow-border-radius)}#arrow.left-edge{left:0}#arrow.left-edge #inner-arrow{border-bottom-left-radius:var(--help-bubble-arrow-border-radius)}#arrow.top-position{top:var(--help-bubble-arrow-offset)}#arrow.vertical-center-position{top:50%}#arrow.bottom-position{bottom:var(--help-bubble-arrow-offset)}#arrow.left-position{left:var(--help-bubble-arrow-offset)}#arrow.horizontal-center-position{left:50%}#arrow.right-position{right:var(--help-bubble-arrow-offset)}#topContainer{display:flex;flex-direction:row}#progress{display:inline-block;flex:auto}#progress div{--help-bubble-progress-size:8px;background-color:var(--help-bubble-foreground);border:1px solid var(--help-bubble-foreground);border-radius:50%;display:inline-block;height:var(--help-bubble-progress-size);margin-inline-end:var(--help-bubble-element-spacing);margin-top:5px;width:var(--help-bubble-progress-size)}#progress .total-progress{background-color:var(--help-bubble-background)}#topBody,#mainBody{flex:1;font-size:14px;font-style:normal;font-weight:var(--help-bubble-font-weight);letter-spacing:0.3px;line-height:20px;margin:0}#title{flex:1;font-size:18px;font-style:normal;font-weight:500;line-height:24px;margin:0}.help-bubble{--cr-focus-outline-color:var(--help-bubble-foreground);background-color:var(--help-bubble-background);border-radius:var(--help-bubble-border-radius);box-sizing:border-box;color:var(--help-bubble-foreground);display:flex;flex-direction:column;justify-content:space-between;max-width:340px;min-width:260px;padding:var(--help-bubble-padding);position:relative}#main{display:flex;flex-direction:row;justify-content:flex-start;margin-top:var(--help-bubble-element-spacing)}#middleRowSpacer{margin-inline-start:32px}cr-icon-button,cr-button{--help-bubble-button-foreground:var(--help-bubble-foreground);--help-bubble-button-background:var(--help-bubble-background);--help-bubble-button-hover-alpha:10%}cr-button.default-button{--help-bubble-button-foreground:var(--color-feature-promo-bubble-default-button-foreground,var(--help-bubble-background));--help-bubble-button-background:var(--color-feature-promo-bubble-default-button-background,var(--help-bubble-foreground));--help-bubble-button-hover-alpha:6%}@media (prefers-color-scheme:dark){cr-icon-button,cr-button{--help-bubble-button-hover-alpha:6%}cr-button.default-button{--help-bubble-button-hover-alpha:10%}}cr-icon-button:hover,#buttons cr-button:hover{background-color:color-mix(in srgb,var(--help-bubble-button-foreground) var(--help-bubble-button-hover-alpha),var(--help-bubble-button-background))}cr-icon-button{--cr-icon-button-fill-color:var(--help-bubble-button-foreground);--cr-icon-button-icon-size:var(--help-bubble-close-button-icon-size);--cr-icon-button-size:var(--help-bubble-close-button-size);--cr-icon-button-stroke-color:var(--help-bubble-button-foreground);box-sizing:border-box;display:block;flex:none;float:right;height:var(--cr-icon-button-size);margin:0;margin-inline-start:var(--help-bubble-element-spacing);order:2;width:var(--cr-icon-button-size)}cr-icon-button:focus-visible:focus{box-shadow:inset 0 0 0 1px var(--cr-focus-outline-color)}#bodyIcon{--help-bubble-body-icon-image-size:18px;--help-bubble-body-icon-size:24px;--iron-icon-height:var(--help-bubble-body-icon-image-size);--iron-icon-width:var(--help-bubble-body-icon-image-size);background-color:var(--help-bubble-foreground);border-radius:50%;box-sizing:border-box;color:var(--help-bubble-background);height:var(--help-bubble-body-icon-size);margin-inline-end:var(--help-bubble-element-spacing);padding:calc((var(--help-bubble-body-icon-size) - var(--help-bubble-body-icon-image-size)) / 2);text-align:center;width:var(--help-bubble-body-icon-size)}#bodyIcon cr-icon{display:block}#buttons{display:flex;flex-direction:row;justify-content:flex-end;margin-top:16px}#buttons cr-button{--cr-button-border-color:var(--help-bubble-foreground);--cr-button-text-color:var(--help-bubble-button-foreground);--cr-button-background-color:var(--help-bubble-button-background)}#buttons cr-button:focus{box-shadow:none;outline:2px solid var(--cr-focus-outline-color);outline-offset:1px}#buttons cr-button:not(:first-child){margin-inline-start:var(--help-bubble-element-spacing)}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$b(){return html`
<link rel="stylesheet" href="chrome://theme/colors.css?sets=ui,chrome&shadow_host=true">
<div class="help-bubble" role="alertdialog" aria-modal="true"
    aria-labelledby="title" aria-describedby="body" aria-live="assertive"
    @keydown="${this.onKeyDown_}" @click="${this.blockPropagation_}">
  <div id="topContainer">
    <div id="bodyIcon" ?hidden="${!this.shouldShowBodyIcon_()}"
        role="image" aria-label="${this.bodyIconAltText}">
      <cr-icon icon="iph:${this.bodyIconName}"></cr-icon>
    </div>
    <div id="progress" ?hidden="${!this.progress}" role="progressbar"
        aria-valuenow="${this.progress?this.progress.current:nothing}"
        aria-valuemin="1"
        aria-valuemax="${this.progress?this.progress.total:nothing}">
      ${this.progressData_.map(((_item,index)=>html`
        <div class="${this.getProgressClass_(index)}"></div>`))}
    </div>
    <h1 id="title"
        ?hidden="${!this.shouldShowTitleInTopContainer_()}">
      ${this.titleText}
    </h1>
    <p id="topBody"
        ?hidden="${!this.shouldShowBodyInTopContainer_()}">
      ${this.bodyText}
    </p>
    <cr-icon-button id="close" iron-icon="cr:close"
        aria-label="${this.closeButtonAltText}" @click="${this.dismiss_}"
        tabindex="${this.closeButtonTabIndex}">
    </cr-icon-button>
  </div>
  <div id="main" ?hidden="${!this.shouldShowBodyInMain_()}">
    <div id="middleRowSpacer" ?hidden="!${this.shouldShowBodyIcon_()}">
    </div>
    <p id="mainBody">${this.bodyText}</p>
  </div>
  <div id="buttons" ?hidden="${!this.buttons.length}">
    ${this.sortedButtons.map((item=>html`
      <cr-button id="${this.getButtonId_(item)}"
          tabindex="${this.getButtonTabIndex_(item)}"
          class="${this.getButtonClass_(item.isDefault)}"
          @click="${this.onButtonClick_}"
          role="button" aria-label="${item.text}">${item.text}</cr-button>`))}
  </div>
  <div id="arrow" class="${this.getArrowClass_()}">
    <div id="inner-arrow"></div>
  </div>
</div>`}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class JSTimeDataView{decoder_;version_;fieldSpecs_;constructor(decoder,version,fieldSpecs){this.decoder_=decoder;this.version_=version;this.fieldSpecs_=fieldSpecs}get msec(){const field=this.fieldSpecs_[0];return mojo.internal.decodeStructField(this.decoder_,field,this.version_)}}class JsTimeConverter{msec(date){return date.valueOf()}convert(view){return new Date(view.msec)}}
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const TimeSpec={$:{}};const JSTimeSpec={$:{}};const TimeDeltaSpec={$:{}};const TimeTicksSpec={$:{}};mojo.internal.Struct(TimeSpec.$,"Time",[mojo.internal.StructField("internalValue",0,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined)],[[0,16]]);const converterForJSTime=new JsTimeConverter;mojo.internal.TypemappedStruct(JSTimeSpec.$,"JSTime",JSTimeDataView,converterForJSTime,[mojo.internal.StructField("msec",0,0,mojo.internal.Double,0,false,0,undefined,(value=>converterForJSTime.msec(value)))],[[0,16]]);mojo.internal.Struct(TimeDeltaSpec.$,"TimeDelta",[mojo.internal.StructField("microseconds",0,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(TimeTicksSpec.$,"TimeTicks",[mojo.internal.StructField("internalValue",0,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined)],[[0,16]]);
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PointSpec={$:{}};const PointFSpec={$:{}};const Point3FSpec={$:{}};const SizeSpec={$:{}};const SizeFSpec={$:{}};const RectSpec={$:{}};const RectFSpec={$:{}};const InsetsSpec={$:{}};const InsetsFSpec={$:{}};const Vector2dSpec={$:{}};const Vector2dFSpec={$:{}};const Vector3dFSpec={$:{}};const QuaternionSpec={$:{}};const QuadFSpec={$:{}};mojo.internal.Struct(PointSpec.$,"Point",[mojo.internal.StructField("x",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PointFSpec.$,"PointF",[mojo.internal.StructField("x",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Point3FSpec.$,"Point3F",[mojo.internal.StructField("x",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("z",8,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(SizeSpec.$,"Size",[mojo.internal.StructField("width",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("height",4,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(SizeFSpec.$,"SizeF",[mojo.internal.StructField("width",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("height",4,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(RectSpec.$,"Rect",[mojo.internal.StructField("x",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("width",8,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("height",12,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(RectFSpec.$,"RectF",[mojo.internal.StructField("x",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("width",8,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("height",12,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(InsetsSpec.$,"Insets",[mojo.internal.StructField("top",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("left",4,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("bottom",8,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("right",12,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(InsetsFSpec.$,"InsetsF",[mojo.internal.StructField("top",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("left",4,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("bottom",8,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("right",12,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(Vector2dSpec.$,"Vector2d",[mojo.internal.StructField("x",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Vector2dFSpec.$,"Vector2dF",[mojo.internal.StructField("x",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Vector3dFSpec.$,"Vector3dF",[mojo.internal.StructField("x",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("z",8,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(QuaternionSpec.$,"Quaternion",[mojo.internal.StructField("x",0,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("y",8,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("z",16,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("w",24,0,mojo.internal.Double,0,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(QuadFSpec.$,"QuadF",[mojo.internal.StructField("p1",0,0,PointFSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("p2",8,0,PointFSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("p3",16,0,PointFSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("p4",24,0,PointFSpec.$,null,false,0,undefined,undefined)],[[0,40]]);
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class TrackedElementHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"tracked_element.mojom.TrackedElementHandler",scope)}}class TrackedElementHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(TrackedElementHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}trackedElementVisibilityChanged(nativeIdentifier,visible,rect){this.proxy.sendMessage(0,TrackedElementHandler_TrackedElementVisibilityChanged_ParamsSpec.$,null,[nativeIdentifier,visible,rect],false)}trackedElementActivated(nativeIdentifier){this.proxy.sendMessage(1,TrackedElementHandler_TrackedElementActivated_ParamsSpec.$,null,[nativeIdentifier],false)}trackedElementCustomEvent(nativeIdentifier,customEventName){this.proxy.sendMessage(2,TrackedElementHandler_TrackedElementCustomEvent_ParamsSpec.$,null,[nativeIdentifier,customEventName],false)}}const TrackedElementHandler_TrackedElementVisibilityChanged_ParamsSpec={$:{}};const TrackedElementHandler_TrackedElementActivated_ParamsSpec={$:{}};const TrackedElementHandler_TrackedElementCustomEvent_ParamsSpec={$:{}};mojo.internal.Struct(TrackedElementHandler_TrackedElementVisibilityChanged_ParamsSpec.$,"TrackedElementHandler_TrackedElementVisibilityChanged_Params",[mojo.internal.StructField("nativeIdentifier",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("visible",8,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("rect",16,0,RectFSpec.$,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(TrackedElementHandler_TrackedElementActivated_ParamsSpec.$,"TrackedElementHandler_TrackedElementActivated_Params",[mojo.internal.StructField("nativeIdentifier",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(TrackedElementHandler_TrackedElementCustomEvent_ParamsSpec.$,"TrackedElementHandler_TrackedElementCustomEvent_Params",[mojo.internal.StructField("nativeIdentifier",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("customEventName",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const HelpBubbleArrowPositionSpec={$:mojo.internal.Enum()};var HelpBubbleArrowPosition;(function(HelpBubbleArrowPosition){HelpBubbleArrowPosition[HelpBubbleArrowPosition["MIN_VALUE"]=0]="MIN_VALUE";HelpBubbleArrowPosition[HelpBubbleArrowPosition["MAX_VALUE"]=11]="MAX_VALUE";HelpBubbleArrowPosition[HelpBubbleArrowPosition["TOP_LEFT"]=0]="TOP_LEFT";HelpBubbleArrowPosition[HelpBubbleArrowPosition["TOP_CENTER"]=1]="TOP_CENTER";HelpBubbleArrowPosition[HelpBubbleArrowPosition["TOP_RIGHT"]=2]="TOP_RIGHT";HelpBubbleArrowPosition[HelpBubbleArrowPosition["BOTTOM_LEFT"]=3]="BOTTOM_LEFT";HelpBubbleArrowPosition[HelpBubbleArrowPosition["BOTTOM_CENTER"]=4]="BOTTOM_CENTER";HelpBubbleArrowPosition[HelpBubbleArrowPosition["BOTTOM_RIGHT"]=5]="BOTTOM_RIGHT";HelpBubbleArrowPosition[HelpBubbleArrowPosition["LEFT_TOP"]=6]="LEFT_TOP";HelpBubbleArrowPosition[HelpBubbleArrowPosition["LEFT_CENTER"]=7]="LEFT_CENTER";HelpBubbleArrowPosition[HelpBubbleArrowPosition["LEFT_BOTTOM"]=8]="LEFT_BOTTOM";HelpBubbleArrowPosition[HelpBubbleArrowPosition["RIGHT_TOP"]=9]="RIGHT_TOP";HelpBubbleArrowPosition[HelpBubbleArrowPosition["RIGHT_CENTER"]=10]="RIGHT_CENTER";HelpBubbleArrowPosition[HelpBubbleArrowPosition["RIGHT_BOTTOM"]=11]="RIGHT_BOTTOM"})(HelpBubbleArrowPosition||(HelpBubbleArrowPosition={}));const HelpBubbleClosedReasonSpec={$:mojo.internal.Enum()};var HelpBubbleClosedReason;(function(HelpBubbleClosedReason){HelpBubbleClosedReason[HelpBubbleClosedReason["MIN_VALUE"]=0]="MIN_VALUE";HelpBubbleClosedReason[HelpBubbleClosedReason["MAX_VALUE"]=2]="MAX_VALUE";HelpBubbleClosedReason[HelpBubbleClosedReason["kPageChanged"]=0]="kPageChanged";HelpBubbleClosedReason[HelpBubbleClosedReason["kDismissedByUser"]=1]="kDismissedByUser";HelpBubbleClosedReason[HelpBubbleClosedReason["kTimedOut"]=2]="kTimedOut"})(HelpBubbleClosedReason||(HelpBubbleClosedReason={}));class HelpBubbleHandlerFactoryPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"help_bubble.mojom.HelpBubbleHandlerFactory",scope)}}class HelpBubbleHandlerFactoryRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(HelpBubbleHandlerFactoryPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}createHelpBubbleHandler(client,handler){this.proxy.sendMessage(0,HelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsSpec.$,null,[client,handler],false)}}class HelpBubbleHandlerFactory{static get $interfaceName(){return"help_bubble.mojom.HelpBubbleHandlerFactory"}static getRemote(){let remote=new HelpBubbleHandlerFactoryRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}class HelpBubbleHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"help_bubble.mojom.HelpBubbleHandler",scope)}}class HelpBubbleHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(HelpBubbleHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}bindTrackedElementHandler(handler){this.proxy.sendMessage(0,HelpBubbleHandler_BindTrackedElementHandler_ParamsSpec.$,null,[handler],false)}helpBubbleButtonPressed(nativeIdentifier,buttonIndex){this.proxy.sendMessage(1,HelpBubbleHandler_HelpBubbleButtonPressed_ParamsSpec.$,null,[nativeIdentifier,buttonIndex],false)}helpBubbleClosed(nativeIdentifier,reason){this.proxy.sendMessage(2,HelpBubbleHandler_HelpBubbleClosed_ParamsSpec.$,null,[nativeIdentifier,reason],false)}}class HelpBubbleClientPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"help_bubble.mojom.HelpBubbleClient",scope)}}class HelpBubbleClientRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(HelpBubbleClientPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}showHelpBubble(params){this.proxy.sendMessage(0,HelpBubbleClient_ShowHelpBubble_ParamsSpec.$,null,[params],false)}toggleFocusForAccessibility(nativeIdentifier){this.proxy.sendMessage(1,HelpBubbleClient_ToggleFocusForAccessibility_ParamsSpec.$,null,[nativeIdentifier],false)}hideHelpBubble(nativeIdentifier){this.proxy.sendMessage(2,HelpBubbleClient_HideHelpBubble_ParamsSpec.$,null,[nativeIdentifier],false)}externalHelpBubbleUpdated(nativeIdentifier,shown){this.proxy.sendMessage(3,HelpBubbleClient_ExternalHelpBubbleUpdated_ParamsSpec.$,null,[nativeIdentifier,shown],false)}}class HelpBubbleClientCallbackRouter{helper_internal_;$;router_;showHelpBubble;toggleFocusForAccessibility;hideHelpBubble;externalHelpBubbleUpdated;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(HelpBubbleClientRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.showHelpBubble=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,HelpBubbleClient_ShowHelpBubble_ParamsSpec.$,null,this.showHelpBubble.createReceiverHandler(false),false);this.toggleFocusForAccessibility=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,HelpBubbleClient_ToggleFocusForAccessibility_ParamsSpec.$,null,this.toggleFocusForAccessibility.createReceiverHandler(false),false);this.hideHelpBubble=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,HelpBubbleClient_HideHelpBubble_ParamsSpec.$,null,this.hideHelpBubble.createReceiverHandler(false),false);this.externalHelpBubbleUpdated=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,HelpBubbleClient_ExternalHelpBubbleUpdated_ParamsSpec.$,null,this.externalHelpBubbleUpdated.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}const HelpBubbleButtonParamsSpec={$:{}};const ProgressSpec={$:{}};const HelpBubbleParamsSpec={$:{}};const HelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsSpec={$:{}};const HelpBubbleHandler_BindTrackedElementHandler_ParamsSpec={$:{}};const HelpBubbleHandler_HelpBubbleButtonPressed_ParamsSpec={$:{}};const HelpBubbleHandler_HelpBubbleClosed_ParamsSpec={$:{}};const HelpBubbleClient_ShowHelpBubble_ParamsSpec={$:{}};const HelpBubbleClient_ToggleFocusForAccessibility_ParamsSpec={$:{}};const HelpBubbleClient_HideHelpBubble_ParamsSpec={$:{}};const HelpBubbleClient_ExternalHelpBubbleUpdated_ParamsSpec={$:{}};mojo.internal.Struct(HelpBubbleButtonParamsSpec.$,"HelpBubbleButtonParams",[mojo.internal.StructField("text",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("isDefault",8,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(ProgressSpec.$,"Progress",[mojo.internal.StructField("current",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("total",1,0,mojo.internal.Uint8,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(HelpBubbleParamsSpec.$,"HelpBubbleParams",[mojo.internal.StructField("nativeIdentifier",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("position",8,0,HelpBubbleArrowPositionSpec.$,HelpBubbleArrowPosition.TOP_CENTER,false,0,undefined,undefined),mojo.internal.StructField("titleText",16,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("bodyText",24,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("closeButtonAltText",32,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("bodyIconName",40,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("bodyIconAltText",48,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("progress",56,0,ProgressSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("buttons",64,0,mojo.internal.Array(HelpBubbleButtonParamsSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("focus_on_show_hint_$flag",12,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"focus_on_show_hint_$value",originalFieldName:"focusOnShowHint"},undefined),mojo.internal.StructField("focus_on_show_hint_$value",12,1,mojo.internal.Bool,false,false,0,{isPrimary:false,originalFieldName:"focusOnShowHint"},undefined),mojo.internal.StructField("timeout",72,0,TimeDeltaSpec.$,null,true,0,undefined,undefined)],[[0,88]]);mojo.internal.Struct(HelpBubbleHandlerFactory_CreateHelpBubbleHandler_ParamsSpec.$,"HelpBubbleHandlerFactory_CreateHelpBubbleHandler_Params",[mojo.internal.StructField("client",0,0,mojo.internal.InterfaceProxy(HelpBubbleClientRemote),null,false,0,undefined,undefined),mojo.internal.StructField("handler",8,0,mojo.internal.InterfaceRequest(HelpBubbleHandlerPendingReceiver),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(HelpBubbleHandler_BindTrackedElementHandler_ParamsSpec.$,"HelpBubbleHandler_BindTrackedElementHandler_Params",[mojo.internal.StructField("handler",0,0,mojo.internal.InterfaceRequest(TrackedElementHandlerPendingReceiver),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(HelpBubbleHandler_HelpBubbleButtonPressed_ParamsSpec.$,"HelpBubbleHandler_HelpBubbleButtonPressed_Params",[mojo.internal.StructField("nativeIdentifier",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("buttonIndex",8,0,mojo.internal.Uint8,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(HelpBubbleHandler_HelpBubbleClosed_ParamsSpec.$,"HelpBubbleHandler_HelpBubbleClosed_Params",[mojo.internal.StructField("nativeIdentifier",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("reason",8,0,HelpBubbleClosedReasonSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(HelpBubbleClient_ShowHelpBubble_ParamsSpec.$,"HelpBubbleClient_ShowHelpBubble_Params",[mojo.internal.StructField("params",0,0,HelpBubbleParamsSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(HelpBubbleClient_ToggleFocusForAccessibility_ParamsSpec.$,"HelpBubbleClient_ToggleFocusForAccessibility_Params",[mojo.internal.StructField("nativeIdentifier",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(HelpBubbleClient_HideHelpBubble_ParamsSpec.$,"HelpBubbleClient_HideHelpBubble_Params",[mojo.internal.StructField("nativeIdentifier",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(HelpBubbleClient_ExternalHelpBubbleUpdated_ParamsSpec.$,"HelpBubbleClient_ExternalHelpBubbleUpdated_Params",[mojo.internal.StructField("nativeIdentifier",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("shown",8,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ACTION_BUTTON_ID_PREFIX="action-button-";const HELP_BUBBLE_DISMISSED_EVENT="help-bubble-dismissed";const HELP_BUBBLE_TIMED_OUT_EVENT="help-bubble-timed-out";const HELP_BUBBLE_SCROLL_ANCHOR_OPTIONS={behavior:"smooth",block:"center"};class HelpBubbleElement extends CrLitElement{static get is(){return"help-bubble"}static get styles(){return getCss$c()}render(){return getHtml$b.bind(this)()}static get properties(){return{nativeId:{type:String,reflect:true},position:{type:HelpBubbleArrowPosition,reflect:true},bodyIconName:{type:String},bodyIconAltText:{type:String},progress:{type:Object},titleText:{type:String},bodyText:{type:String},buttons:{type:Array},sortedButtons:{type:Array},closeButtonAltText:{type:String},closeButtonTabIndex:{type:Number},progressData_:{type:Array,state:true}}}#nativeId_accessor_storage="";get nativeId(){return this.#nativeId_accessor_storage}set nativeId(value){this.#nativeId_accessor_storage=value}#bodyText_accessor_storage="";get bodyText(){return this.#bodyText_accessor_storage}set bodyText(value){this.#bodyText_accessor_storage=value}#titleText_accessor_storage="";get titleText(){return this.#titleText_accessor_storage}set titleText(value){this.#titleText_accessor_storage=value}#closeButtonAltText_accessor_storage="";get closeButtonAltText(){return this.#closeButtonAltText_accessor_storage}set closeButtonAltText(value){this.#closeButtonAltText_accessor_storage=value}#closeButtonTabIndex_accessor_storage=0;get closeButtonTabIndex(){return this.#closeButtonTabIndex_accessor_storage}set closeButtonTabIndex(value){this.#closeButtonTabIndex_accessor_storage=value}#position_accessor_storage=HelpBubbleArrowPosition.TOP_CENTER;get position(){return this.#position_accessor_storage}set position(value){this.#position_accessor_storage=value}#buttons_accessor_storage=[];get buttons(){return this.#buttons_accessor_storage}set buttons(value){this.#buttons_accessor_storage=value}#sortedButtons_accessor_storage=[];get sortedButtons(){return this.#sortedButtons_accessor_storage}set sortedButtons(value){this.#sortedButtons_accessor_storage=value}#progress_accessor_storage=null;get progress(){return this.#progress_accessor_storage}set progress(value){this.#progress_accessor_storage=value}#bodyIconName_accessor_storage=null;get bodyIconName(){return this.#bodyIconName_accessor_storage}set bodyIconName(value){this.#bodyIconName_accessor_storage=value}#bodyIconAltText_accessor_storage="";get bodyIconAltText(){return this.#bodyIconAltText_accessor_storage}set bodyIconAltText(value){this.#bodyIconAltText_accessor_storage=value}timeoutMs=null;timeoutTimerId=null;debouncedUpdate=null;padding={top:0,bottom:0,left:0,right:0};fixed=false;focusAnchor=false;buttonListObserver_=null;anchorElement_=null;#progressData__accessor_storage=[];get progressData_(){return this.#progressData__accessor_storage}set progressData_(value){this.#progressData__accessor_storage=value}resizeObserver_=null;willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("buttons")){this.sortedButtons=this.buttons.toSorted(this.buttonSortFunc_)}}show(anchorElement){this.anchorElement_=anchorElement;if(this.progress){this.progressData_=new Array(this.progress.total);this.progressData_.fill(true)}else{this.progressData_=[]}this.closeButtonTabIndex=this.buttons.length?this.buttons.length+2:1;assert(this.anchorElement_,"Tried to show a help bubble but anchorElement does not exist");this.style.display="block";this.style.position=this.fixed?"fixed":"absolute";this.removeAttribute("aria-hidden");this.updatePosition_();this.debouncedUpdate=debounceEnd((()=>{if(this.anchorElement_){this.updatePosition_()}}),50);this.buttonListObserver_=new MutationObserver(this.debouncedUpdate);this.buttonListObserver_.observe(this.$.buttons,{childList:true});window.addEventListener("resize",this.debouncedUpdate);if(this.timeoutMs!==null){const timedOutCallback=()=>{this.fire(HELP_BUBBLE_TIMED_OUT_EVENT,{nativeId:this.nativeId})};this.timeoutTimerId=setTimeout(timedOutCallback,this.timeoutMs)}if(this.offsetParent&&!this.fixed){this.resizeObserver_=new ResizeObserver((()=>{this.updatePosition_();this.anchorElement_?.scrollIntoView(HELP_BUBBLE_SCROLL_ANCHOR_OPTIONS)}));this.resizeObserver_.observe(this.offsetParent)}}hide(){if(this.resizeObserver_){this.resizeObserver_.disconnect();this.resizeObserver_=null}this.style.display="none";this.setAttribute("aria-hidden","true");this.anchorElement_=null;if(this.timeoutTimerId!==null){clearInterval(this.timeoutTimerId);this.timeoutTimerId=null}if(this.buttonListObserver_){this.buttonListObserver_.disconnect();this.buttonListObserver_=null}if(this.debouncedUpdate){window.removeEventListener("resize",this.debouncedUpdate);this.debouncedUpdate=null}}getAnchorElement(){return this.anchorElement_}getButtonForTesting(buttonIndex){return this.$.buttons.querySelector(`[id="${ACTION_BUTTON_ID_PREFIX+buttonIndex}"]`)}focus(){const defaultButton=this.$.buttons.querySelector("cr-button.default-button")||this.$.buttons.querySelector("cr-button");if(defaultButton){defaultButton.focus();return}this.$.close.focus();if(this.anchorElement_&&this.focusAnchor){this.anchorElement_.focus()}}static isDefaultButtonLeading(){return isWindows}dismiss_(){assert(this.nativeId,"Dismiss: expected help bubble to have a native id.");this.fire(HELP_BUBBLE_DISMISSED_EVENT,{nativeId:this.nativeId,fromActionButton:false})}onKeyDown_(e){if(e.key==="Escape"){e.stopPropagation();this.dismiss_()}}blockPropagation_(e){e.stopPropagation()}getProgressClass_(index){return index<this.progress.current?"current-progress":"total-progress"}shouldShowTitleInTopContainer_(){return!!this.titleText&&!this.progress}shouldShowBodyInTopContainer_(){return!this.progress&&!this.titleText}shouldShowBodyInMain_(){return!!this.progress||!!this.titleText}shouldShowBodyIcon_(){return this.bodyIconName!==null&&this.bodyIconName!==""}onButtonClick_(e){assert(this.nativeId,"Action button clicked: expected help bubble to have a native ID.");const index=parseInt(e.target.id.substring(ACTION_BUTTON_ID_PREFIX.length));this.fire(HELP_BUBBLE_DISMISSED_EVENT,{nativeId:this.nativeId,fromActionButton:true,buttonIndex:index})}getButtonId_(item){const index=this.buttons.indexOf(item);assert(index>-1);return ACTION_BUTTON_ID_PREFIX+index}getButtonClass_(isDefault){return isDefault?"default-button focus-outline-visible":"focus-outline-visible"}getButtonTabIndex_(item){const index=this.buttons.indexOf(item);assert(index>-1);return item.isDefault?1:index+2}buttonSortFunc_(button1,button2){if(button1.isDefault){return isWindows?-1:1}if(button2.isDefault){return isWindows?1:-1}return 0}getArrowClass_(){let classList="";switch(this.position){case HelpBubbleArrowPosition.TOP_LEFT:case HelpBubbleArrowPosition.TOP_CENTER:case HelpBubbleArrowPosition.TOP_RIGHT:classList="top-edge ";break;case HelpBubbleArrowPosition.BOTTOM_LEFT:case HelpBubbleArrowPosition.BOTTOM_CENTER:case HelpBubbleArrowPosition.BOTTOM_RIGHT:classList="bottom-edge ";break;case HelpBubbleArrowPosition.LEFT_TOP:case HelpBubbleArrowPosition.LEFT_CENTER:case HelpBubbleArrowPosition.LEFT_BOTTOM:classList="left-edge ";break;case HelpBubbleArrowPosition.RIGHT_TOP:case HelpBubbleArrowPosition.RIGHT_CENTER:case HelpBubbleArrowPosition.RIGHT_BOTTOM:classList="right-edge ";break;default:assertNotReached("Unknown help bubble position: "+this.position)}switch(this.position){case HelpBubbleArrowPosition.TOP_LEFT:case HelpBubbleArrowPosition.BOTTOM_LEFT:classList+="left-position";break;case HelpBubbleArrowPosition.TOP_CENTER:case HelpBubbleArrowPosition.BOTTOM_CENTER:classList+="horizontal-center-position";break;case HelpBubbleArrowPosition.TOP_RIGHT:case HelpBubbleArrowPosition.BOTTOM_RIGHT:classList+="right-position";break;case HelpBubbleArrowPosition.LEFT_TOP:case HelpBubbleArrowPosition.RIGHT_TOP:classList+="top-position";break;case HelpBubbleArrowPosition.LEFT_CENTER:case HelpBubbleArrowPosition.RIGHT_CENTER:classList+="vertical-center-position";break;case HelpBubbleArrowPosition.LEFT_BOTTOM:case HelpBubbleArrowPosition.RIGHT_BOTTOM:classList+="bottom-position";break;default:assertNotReached("Unknown help bubble position: "+this.position)}return classList}updatePosition_(){assert(this.anchorElement_,"Update position: expected valid anchor element.");const ANCHOR_OFFSET=16;const ARROW_WIDTH=16;const ARROW_OFFSET_FROM_EDGE=22+ARROW_WIDTH/2;const anchorRect=this.anchorElement_.getBoundingClientRect();const anchorRectCenter={x:anchorRect.left+anchorRect.width/2,y:anchorRect.top+anchorRect.height/2};const helpBubbleRect=this.getBoundingClientRect();let offsetX=this.anchorElement_.offsetLeft;let offsetY=this.anchorElement_.offsetTop;switch(this.position){case HelpBubbleArrowPosition.TOP_LEFT:case HelpBubbleArrowPosition.TOP_CENTER:case HelpBubbleArrowPosition.TOP_RIGHT:offsetY+=anchorRect.height+ANCHOR_OFFSET+this.padding.bottom;break;case HelpBubbleArrowPosition.BOTTOM_LEFT:case HelpBubbleArrowPosition.BOTTOM_CENTER:case HelpBubbleArrowPosition.BOTTOM_RIGHT:offsetY-=helpBubbleRect.height+ANCHOR_OFFSET+this.padding.top;break;case HelpBubbleArrowPosition.LEFT_TOP:case HelpBubbleArrowPosition.LEFT_CENTER:case HelpBubbleArrowPosition.LEFT_BOTTOM:offsetX+=anchorRect.width+ANCHOR_OFFSET+this.padding.right;break;case HelpBubbleArrowPosition.RIGHT_TOP:case HelpBubbleArrowPosition.RIGHT_CENTER:case HelpBubbleArrowPosition.RIGHT_BOTTOM:offsetX-=helpBubbleRect.width+ANCHOR_OFFSET+this.padding.left;break;default:assertNotReached()}switch(this.position){case HelpBubbleArrowPosition.TOP_LEFT:case HelpBubbleArrowPosition.BOTTOM_LEFT:if(anchorRect.left+ARROW_OFFSET_FROM_EDGE>anchorRectCenter.x){offsetX+=anchorRect.width/2-ARROW_OFFSET_FROM_EDGE}break;case HelpBubbleArrowPosition.TOP_CENTER:case HelpBubbleArrowPosition.BOTTOM_CENTER:offsetX+=anchorRect.width/2-helpBubbleRect.width/2;break;case HelpBubbleArrowPosition.TOP_RIGHT:case HelpBubbleArrowPosition.BOTTOM_RIGHT:if(anchorRect.right-ARROW_OFFSET_FROM_EDGE<anchorRectCenter.x){offsetX+=anchorRect.width/2-helpBubbleRect.width+ARROW_OFFSET_FROM_EDGE}else{offsetX+=anchorRect.width-helpBubbleRect.width}break;case HelpBubbleArrowPosition.LEFT_TOP:case HelpBubbleArrowPosition.RIGHT_TOP:if(anchorRect.top+ARROW_OFFSET_FROM_EDGE>anchorRectCenter.y){offsetY+=anchorRect.height/2-ARROW_OFFSET_FROM_EDGE}break;case HelpBubbleArrowPosition.LEFT_CENTER:case HelpBubbleArrowPosition.RIGHT_CENTER:offsetY+=anchorRect.height/2-helpBubbleRect.height/2;break;case HelpBubbleArrowPosition.LEFT_BOTTOM:case HelpBubbleArrowPosition.RIGHT_BOTTOM:if(anchorRect.bottom-ARROW_OFFSET_FROM_EDGE<anchorRectCenter.y){offsetY+=anchorRect.height/2-helpBubbleRect.height+ARROW_OFFSET_FROM_EDGE}else{offsetY+=anchorRect.height-helpBubbleRect.height}break;default:assertNotReached()}this.style.top=offsetY.toString()+"px";this.style.left=offsetX.toString()+"px"}}customElements.define(HelpBubbleElement.is,HelpBubbleElement);
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ANCHOR_HIGHLIGHT_CLASS="help-anchor-highlight";function isRtlLang(element){return window.getComputedStyle(element).direction==="rtl"}function reflectArrowPosition(position){switch(position){case HelpBubbleArrowPosition.TOP_LEFT:return HelpBubbleArrowPosition.TOP_RIGHT;case HelpBubbleArrowPosition.TOP_RIGHT:return HelpBubbleArrowPosition.TOP_LEFT;case HelpBubbleArrowPosition.BOTTOM_LEFT:return HelpBubbleArrowPosition.BOTTOM_RIGHT;case HelpBubbleArrowPosition.BOTTOM_RIGHT:return HelpBubbleArrowPosition.BOTTOM_LEFT;case HelpBubbleArrowPosition.LEFT_TOP:return HelpBubbleArrowPosition.RIGHT_TOP;case HelpBubbleArrowPosition.LEFT_CENTER:return HelpBubbleArrowPosition.RIGHT_CENTER;case HelpBubbleArrowPosition.LEFT_BOTTOM:return HelpBubbleArrowPosition.RIGHT_BOTTOM;case HelpBubbleArrowPosition.RIGHT_TOP:return HelpBubbleArrowPosition.LEFT_TOP;case HelpBubbleArrowPosition.RIGHT_CENTER:return HelpBubbleArrowPosition.LEFT_CENTER;case HelpBubbleArrowPosition.RIGHT_BOTTOM:return HelpBubbleArrowPosition.LEFT_BOTTOM;default:return position}}class HelpBubbleController{nativeId_;root_;anchor_=null;bubble_=null;options_={padding:{top:0,bottom:0,left:0,right:0},fixed:false};isBubbleShowing_=false;isAnchorVisible_=false;lastAnchorBounds_={x:0,y:0,width:0,height:0};isExternal_=false;constructor(nativeId,root){assert(nativeId,"HelpBubble: nativeId was not defined when registering help bubble");assert(root,"HelpBubble: shadowRoot was not defined when registering help bubble");this.nativeId_=nativeId;this.root_=root}isBubbleShowing(){return this.isBubbleShowing_}canShowBubble(){return this.hasAnchor()}hasBubble(){return!!this.bubble_}getBubble(){return this.bubble_}hasAnchor(){return!!this.anchor_}getAnchor(){return this.anchor_}getNativeId(){return this.nativeId_}getPadding(){return this.options_.padding}getAnchorVisibility(){return this.isAnchorVisible_}getLastAnchorBounds(){return this.lastAnchorBounds_}updateAnchorVisibility(isVisible,bounds){const changed=isVisible!==this.isAnchorVisible_||bounds.x!==this.lastAnchorBounds_.x||bounds.y!==this.lastAnchorBounds_.y||bounds.width!==this.lastAnchorBounds_.width||bounds.height!==this.lastAnchorBounds_.height;this.isAnchorVisible_=isVisible;this.lastAnchorBounds_=bounds;return changed}isAnchorFixed(){return this.options_.fixed}isExternal(){return this.isExternal_}updateExternalShowingStatus(isShowing){this.isExternal_=true;this.isBubbleShowing_=isShowing;this.setAnchorHighlight_(isShowing)}track(trackable,options){assert(!this.anchor_);let anchor=null;if(typeof trackable==="string"){anchor=this.root_.querySelector(trackable)}else if(Array.isArray(trackable)){anchor=this.deepQuery(trackable)}else if(trackable instanceof HTMLElement){anchor=trackable}else{assertNotReached("HelpBubble: anchor argument was unrecognized when registering "+"help bubble")}if(!anchor){return false}anchor.dataset["nativeId"]=this.nativeId_;this.anchor_=anchor;this.options_=options;return true}deepQuery(selectors){let cur=this.root_;for(const selector of selectors){if(cur.shadowRoot){cur=cur.shadowRoot}const el=cur.querySelector(selector);if(!el){return null}else{cur=el}}return cur}show(){this.isExternal_=false;if(!(this.bubble_&&this.anchor_)){return}this.bubble_.show(this.anchor_);this.isBubbleShowing_=true;this.setAnchorHighlight_(true)}hide(){if(!this.bubble_){return}this.bubble_.hide();this.bubble_.remove();this.bubble_=null;this.isBubbleShowing_=false;this.setAnchorHighlight_(false)}createBubble(params){assert(this.anchor_,"HelpBubble: anchor was not defined when showing help bubble");assert(this.anchor_.parentNode,"HelpBubble: anchor element not in DOM");this.bubble_=document.createElement("help-bubble");this.bubble_.nativeId=this.nativeId_;this.bubble_.position=isRtlLang(this.anchor_)?reflectArrowPosition(params.position):params.position;this.bubble_.closeButtonAltText=params.closeButtonAltText;this.bubble_.bodyText=params.bodyText;this.bubble_.bodyIconName=params.bodyIconName||null;this.bubble_.bodyIconAltText=params.bodyIconAltText;this.bubble_.titleText=params.titleText||"";this.bubble_.progress=params.progress||null;this.bubble_.buttons=params.buttons;this.bubble_.padding=this.options_.padding;this.bubble_.focusAnchor=params.focusOnShowHint===false;if(params.timeout){this.bubble_.timeoutMs=Number(params.timeout.microseconds/1000n);assert(this.bubble_.timeoutMs>0)}assert(!this.bubble_.progress||this.bubble_.progress.total>=this.bubble_.progress.current);assert(this.root_);if(getComputedStyle(this.anchor_).getPropertyValue("position")==="fixed"){this.bubble_.fixed=true}this.anchor_.parentNode.insertBefore(this.bubble_,this.anchor_);return this.bubble_}setAnchorHighlight_(highlight){assert(this.anchor_,"Set anchor highlight: expected valid anchor element.");this.anchor_.classList.toggle(ANCHOR_HIGHLIGHT_CLASS,highlight);if(highlight){(this.bubble_||this.anchor_).focus();this.anchor_.scrollIntoView(HELP_BUBBLE_SCROLL_ANCHOR_OPTIONS)}}}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class HelpBubbleProxyImpl{trackedElementHandler_=new TrackedElementHandlerRemote;callbackRouter_=new HelpBubbleClientCallbackRouter;handler_=new HelpBubbleHandlerRemote;constructor(){const factory=HelpBubbleHandlerFactory.getRemote();factory.createHelpBubbleHandler(this.callbackRouter_.$.bindNewPipeAndPassRemote(),this.handler_.$.bindNewPipeAndPassReceiver());this.handler_.bindTrackedElementHandler(this.trackedElementHandler_.$.bindNewPipeAndPassReceiver())}static getInstance(){return instance$r||(instance$r=new HelpBubbleProxyImpl)}static setInstance(obj){instance$r=obj}getTrackedElementHandler(){return this.trackedElementHandler_}getHandler(){return this.handler_}getCallbackRouter(){return this.callbackRouter_}}let instance$r=null;
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const HelpBubbleMixin=dedupingMixin((superClass=>{class HelpBubbleMixin extends superClass{trackedElementHandler_;helpBubbleHandler_;helpBubbleCallbackRouter_;helpBubbleControllerById_=new Map;helpBubbleListenerIds_=[];helpBubbleFixedAnchorObserver_=null;helpBubbleResizeObserver_=null;helpBubbleDismissedEventTracker_=new EventTracker;debouncedAnchorMayHaveChangedCallback_=null;constructor(...args){super(...args);this.trackedElementHandler_=HelpBubbleProxyImpl.getInstance().getTrackedElementHandler();this.helpBubbleHandler_=HelpBubbleProxyImpl.getInstance().getHandler();this.helpBubbleCallbackRouter_=HelpBubbleProxyImpl.getInstance().getCallbackRouter()}connectedCallback(){super.connectedCallback();const router=this.helpBubbleCallbackRouter_;this.helpBubbleListenerIds_.push(router.showHelpBubble.addListener(this.onShowHelpBubble_.bind(this)),router.toggleFocusForAccessibility.addListener(this.onToggleHelpBubbleFocusForAccessibility_.bind(this)),router.hideHelpBubble.addListener(this.onHideHelpBubble_.bind(this)),router.externalHelpBubbleUpdated.addListener(this.onExternalHelpBubbleUpdated_.bind(this)));const isVisible=element=>{const rect=element.getBoundingClientRect();return rect.height>0&&rect.width>0};this.debouncedAnchorMayHaveChangedCallback_=debounceEnd(this.onAnchorBoundsMayHaveChanged_.bind(this),50);this.helpBubbleResizeObserver_=new ResizeObserver((entries=>entries.forEach((({target:target})=>{if(target===document.body){if(this.debouncedAnchorMayHaveChangedCallback_){this.debouncedAnchorMayHaveChangedCallback_()}}else{this.onAnchorVisibilityChanged_(target,isVisible(target))}}))));this.helpBubbleFixedAnchorObserver_=new IntersectionObserver((entries=>entries.forEach((({target:target,isIntersecting:isIntersecting})=>this.onAnchorVisibilityChanged_(target,isIntersecting)))),{root:null});document.addEventListener("scroll",this.debouncedAnchorMayHaveChangedCallback_,{passive:true});this.helpBubbleResizeObserver_.observe(document.body);this.controllers.forEach((ctrl=>this.observeControllerAnchor_(ctrl)))}get controllers(){return Array.from(this.helpBubbleControllerById_.values())}disconnectedCallback(){super.disconnectedCallback();for(const listenerId of this.helpBubbleListenerIds_){this.helpBubbleCallbackRouter_.removeListener(listenerId)}this.helpBubbleListenerIds_=[];assert(this.helpBubbleResizeObserver_);this.helpBubbleResizeObserver_.disconnect();this.helpBubbleResizeObserver_=null;assert(this.helpBubbleFixedAnchorObserver_);this.helpBubbleFixedAnchorObserver_.disconnect();this.helpBubbleFixedAnchorObserver_=null;this.helpBubbleDismissedEventTracker_.removeAll();this.helpBubbleControllerById_.clear();if(this.debouncedAnchorMayHaveChangedCallback_){document.removeEventListener("scroll",this.debouncedAnchorMayHaveChangedCallback_);this.debouncedAnchorMayHaveChangedCallback_=null}}registerHelpBubble(nativeId,trackable,options={}){if(this.helpBubbleControllerById_.has(nativeId)){const ctrl=this.helpBubbleControllerById_.get(nativeId);if(ctrl&&ctrl.isBubbleShowing()){return null}this.unregisterHelpBubble(nativeId)}const controller=new HelpBubbleController(nativeId,this.shadowRoot);controller.track(trackable,parseOptions(options));this.helpBubbleControllerById_.set(nativeId,controller);if(this.helpBubbleResizeObserver_){this.observeControllerAnchor_(controller)}return controller}unregisterHelpBubble(nativeId){const ctrl=this.helpBubbleControllerById_.get(nativeId);if(ctrl&&ctrl.hasAnchor()){this.onAnchorVisibilityChanged_(ctrl.getAnchor(),false);this.unobserveControllerAnchor_(ctrl)}this.helpBubbleControllerById_.delete(nativeId)}observeControllerAnchor_(controller){const anchor=controller.getAnchor();assert(anchor,"Help bubble does not have anchor");if(controller.isAnchorFixed()){assert(this.helpBubbleFixedAnchorObserver_);this.helpBubbleFixedAnchorObserver_.observe(anchor)}else{assert(this.helpBubbleResizeObserver_);this.helpBubbleResizeObserver_.observe(anchor)}}unobserveControllerAnchor_(controller){const anchor=controller.getAnchor();assert(anchor,"Help bubble does not have anchor");if(controller.isAnchorFixed()){assert(this.helpBubbleFixedAnchorObserver_);this.helpBubbleFixedAnchorObserver_.unobserve(anchor)}else{assert(this.helpBubbleResizeObserver_);this.helpBubbleResizeObserver_.unobserve(anchor)}}isHelpBubbleShowing(){return this.controllers.some((ctrl=>ctrl.isBubbleShowing()))}isHelpBubbleShowingForTesting(id){const ctrls=this.controllers.filter(this.filterMatchingIdForTesting_(id));return!!ctrls[0]}getHelpBubbleForTesting(id){const ctrls=this.controllers.filter(this.filterMatchingIdForTesting_(id));return ctrls[0]?ctrls[0].getBubble():null}filterMatchingIdForTesting_(anchorId){return ctrl=>ctrl.isBubbleShowing()&&ctrl.getAnchor()!==null&&ctrl.getAnchor().id===anchorId}getSortedAnchorStatusesForTesting(){return this.controllers.sort(((a,b)=>a.getNativeId().localeCompare(b.getNativeId()))).map((ctrl=>[ctrl.getNativeId(),ctrl.hasAnchor()]))}canShowHelpBubble(controller){if(!this.helpBubbleControllerById_.has(controller.getNativeId())){return false}if(!controller.canShowBubble()){return false}const anchor=controller.getAnchor();const anchorIsUsed=this.controllers.some((otherCtrl=>otherCtrl.isBubbleShowing()&&otherCtrl.getAnchor()===anchor));return!anchorIsUsed}showHelpBubble(controller,params){assert(this.canShowHelpBubble(controller),"Can't show help bubble");const bubble=controller.createBubble(params);this.helpBubbleDismissedEventTracker_.add(bubble,HELP_BUBBLE_DISMISSED_EVENT,this.onHelpBubbleDismissed_.bind(this));this.helpBubbleDismissedEventTracker_.add(bubble,HELP_BUBBLE_TIMED_OUT_EVENT,this.onHelpBubbleTimedOut_.bind(this));controller.show()}hideHelpBubble(nativeId){const ctrl=this.helpBubbleControllerById_.get(nativeId);if(!ctrl||!ctrl.hasBubble()){return false}this.helpBubbleDismissedEventTracker_.remove(ctrl.getBubble(),HELP_BUBBLE_DISMISSED_EVENT);this.helpBubbleDismissedEventTracker_.remove(ctrl.getBubble(),HELP_BUBBLE_TIMED_OUT_EVENT);ctrl.hide();return true}notifyHelpBubbleAnchorActivated(nativeId){const ctrl=this.helpBubbleControllerById_.get(nativeId);if(!ctrl||!ctrl.isBubbleShowing()){return false}this.trackedElementHandler_.trackedElementActivated(nativeId);return true}notifyHelpBubbleAnchorCustomEvent(nativeId,customEvent){const ctrl=this.helpBubbleControllerById_.get(nativeId);if(!ctrl||!ctrl.isBubbleShowing()){return false}this.trackedElementHandler_.trackedElementCustomEvent(nativeId,customEvent);return true}onAnchorVisibilityChanged_(target,isVisible){const nativeId=target.dataset["nativeId"];assert(nativeId);const ctrl=this.helpBubbleControllerById_.get(nativeId);const hidden=this.hideHelpBubble(nativeId);if(hidden){this.helpBubbleHandler_.helpBubbleClosed(nativeId,HelpBubbleClosedReason.kPageChanged)}const bounds=isVisible?this.getElementBounds_(target):{x:0,y:0,width:0,height:0};if(!ctrl||ctrl.updateAnchorVisibility(isVisible,bounds)){this.trackedElementHandler_.trackedElementVisibilityChanged(nativeId,isVisible,bounds)}}onAnchorBoundsMayHaveChanged_(){for(const ctrl of this.controllers){if(ctrl.hasAnchor()&&ctrl.getAnchorVisibility()){const bounds=this.getElementBounds_(ctrl.getAnchor());if(ctrl.updateAnchorVisibility(true,bounds)){this.trackedElementHandler_.trackedElementVisibilityChanged(ctrl.getNativeId(),true,bounds)}}}}getElementBounds_(element){const rect={x:0,y:0,width:0,height:0};const bounds=element.getBoundingClientRect();rect.x=bounds.x;rect.y=bounds.y;rect.width=bounds.width;rect.height=bounds.height;const nativeId=element.dataset["nativeId"];if(!nativeId){return rect}const ctrl=this.helpBubbleControllerById_.get(nativeId);if(ctrl){const padding=ctrl.getPadding();rect.x-=padding.left;rect.y-=padding.top;rect.width+=padding.left+padding.right;rect.height+=padding.top+padding.bottom}return rect}onShowHelpBubble_(params){if(!this.helpBubbleControllerById_.has(params.nativeIdentifier)){return}const ctrl=this.helpBubbleControllerById_.get(params.nativeIdentifier);this.showHelpBubble(ctrl,params)}onToggleHelpBubbleFocusForAccessibility_(nativeId){if(!this.helpBubbleControllerById_.has(nativeId)){return}const ctrl=this.helpBubbleControllerById_.get(nativeId);if(ctrl){const anchor=ctrl.getAnchor();if(anchor){anchor.focus()}}}onHideHelpBubble_(nativeId){this.hideHelpBubble(nativeId)}onExternalHelpBubbleUpdated_(nativeId,shown){if(!this.helpBubbleControllerById_.has(nativeId)){return}const ctrl=this.helpBubbleControllerById_.get(nativeId);ctrl.updateExternalShowingStatus(shown)}onHelpBubbleDismissed_(e){const nativeId=e.detail.nativeId;assert(nativeId);const hidden=this.hideHelpBubble(nativeId);assert(hidden);if(nativeId){if(e.detail.fromActionButton){this.helpBubbleHandler_.helpBubbleButtonPressed(nativeId,e.detail.buttonIndex)}else{this.helpBubbleHandler_.helpBubbleClosed(nativeId,HelpBubbleClosedReason.kDismissedByUser)}}}onHelpBubbleTimedOut_(e){const nativeId=e.detail.nativeId;const ctrl=this.helpBubbleControllerById_.get(nativeId);assert(ctrl);const hidden=this.hideHelpBubble(nativeId);assert(hidden);if(nativeId){this.helpBubbleHandler_.helpBubbleClosed(nativeId,HelpBubbleClosedReason.kTimedOut)}}}return HelpBubbleMixin}));function parseOptions(options){const padding={top:0,bottom:0,left:0,right:0};padding.top=clampPadding(options.anchorPaddingTop);padding.left=clampPadding(options.anchorPaddingLeft);padding.bottom=clampPadding(options.anchorPaddingBottom);padding.right=clampPadding(options.anchorPaddingRight);return{padding:padding,fixed:!!options.fixed}}function clampPadding(n=0){return Math.max(0,Math.min(20,n))}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const WRAPPER_CSS_CLASS="search-highlight-wrapper";const ORIGINAL_CONTENT_CSS_CLASS="search-highlight-original-content";const HIT_CSS_CLASS="search-highlight-hit";const SEARCH_BUBBLE_CSS_CLASS="search-bubble";function removeHighlights(wrappers){for(const wrapper of wrappers){if(!wrapper.parentElement){continue}const originalContent=wrapper.querySelector(`.${ORIGINAL_CONTENT_CSS_CLASS}`);assert(originalContent);const textNode=originalContent.firstChild;assert(textNode);wrapper.parentElement.replaceChild(textNode,wrapper)}}function findAndRemoveHighlights(node){const wrappers=Array.from(node.querySelectorAll(`.${WRAPPER_CSS_CLASS}`));assert(wrappers.length===1);removeHighlights(wrappers)}function highlight(node,ranges){assert(ranges.length>0);const wrapper=document.createElement("span");wrapper.classList.add(WRAPPER_CSS_CLASS);assert(node.parentNode);node.parentNode.replaceChild(wrapper,node);const span=document.createElement("span");span.classList.add(ORIGINAL_CONTENT_CSS_CLASS);span.style.display="none";span.appendChild(node);wrapper.appendChild(span);const text=node.textContent;const tokens=[];for(let i=0;i<ranges.length;++i){const range=ranges[i];const prev=ranges[i-1]||{start:0,length:0};const start=prev.start+prev.length;const length=range.start-start;tokens.push(text.substr(start,length));tokens.push(text.substr(range.start,range.length))}const last=ranges.slice(-1)[0];tokens.push(text.substr(last.start+last.length));for(let i=0;i<tokens.length;++i){if(i%2===0){wrapper.appendChild(document.createTextNode(tokens[i]))}else{const hitSpan=document.createElement("span");hitSpan.classList.add(HIT_CSS_CLASS);hitSpan.style.backgroundColor="var(--search-highlight-hit-background-color, #ffeb3b)";hitSpan.style.color="var(--search-highlight-hit-color, #202124)";hitSpan.textContent=tokens[i];wrapper.appendChild(hitSpan)}}return wrapper}function createEmptySearchBubble(node,horizontallyCenter){let anchor=node;if(node.nodeName==="SELECT"){anchor=node.parentNode}if(anchor instanceof ShadowRoot){anchor=anchor.host.parentNode}let searchBubble=anchor.querySelector(`.${SEARCH_BUBBLE_CSS_CLASS}`);if(searchBubble){return searchBubble}searchBubble=document.createElement("div");searchBubble.classList.add(SEARCH_BUBBLE_CSS_CLASS);const innards=document.createElement("div");innards.classList.add("search-bubble-innards");innards.textContent=" ";searchBubble.appendChild(innards);anchor.appendChild(searchBubble);const updatePosition=function(){const nodeEl=node;assert(searchBubble);assert(typeof nodeEl.offsetTop==="number");searchBubble.style.top=nodeEl.offsetTop+(innards.classList.contains("above")?-searchBubble.offsetHeight:nodeEl.offsetHeight)+"px";if(horizontallyCenter){const width=nodeEl.offsetWidth-searchBubble.offsetWidth;searchBubble.style.left=nodeEl.offsetLeft+width/2+"px"}};updatePosition();searchBubble.addEventListener("mouseover",(function(){innards.classList.toggle("above");updatePosition()}));return searchBubble}function stripDiacritics(text){return text.normalize("NFD").replace(/[\u0300-\u036f]/g,"")}
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SKIP_SEARCH_CSS_ATTRIBUTE="no-search";const IGNORED_ELEMENTS=new Set(["CONTENT","CR-ACTION-MENU","CR-DIALOG","CR-ICON","CR-ICON-BUTTON","CR-RIPPLE","CR-SLIDER","DIALOG","IMG","IRON-ICON","IRON-LIST","PAPER-RIPPLE","PAPER-SPINNER-LITE","SLOT","STYLE","TEMPLATE"]);function findAndHighlightMatches(request,root){let matchCount=0;const highlights=[];function isInSubpage(node){while(node!==null){if(node.nodeName==="SETTINGS-SUBPAGE"){return true}node=node instanceof ShadowRoot?node.host:node.parentNode}return false}function doSearch(node){if(IGNORED_ELEMENTS.has(node.nodeName)){return}if(node instanceof HTMLElement){const element=node;if(element.hasAttribute(SKIP_SEARCH_CSS_ATTRIBUTE)||element.hasAttribute("hidden")||element.style.display==="none"){return}}if(node.nodeType===Node.TEXT_NODE){const textContent=node.nodeValue;if(textContent.trim().length===0){return}const strippedText=stripDiacritics(textContent);const ranges=[];for(let match;match=request.regExp.exec(strippedText);){ranges.push({start:match.index,length:match[0].length})}if(ranges.length>0){matchCount+=ranges.length;if(node.parentNode.nodeName==="OPTION"){const select=node.parentNode.parentNode;assert(select.nodeName==="SELECT");if(isInSubpage(select)){return}showBubble(select,ranges.length,request.bubbles,true)}else{request.addTextObserver(node);highlights.push(highlight(node,ranges))}}return}let child=node.firstChild;while(child!==null){const nextSibling=child.nextSibling;doSearch(child);child=nextSibling}const shadowRoot=node.shadowRoot;if(shadowRoot){doSearch(shadowRoot)}}doSearch(root);request.addHighlights(highlights);return matchCount}function showBubble(control,newResults,bubbles,horizontallyCenter){const bubble=createEmptySearchBubble(control,horizontallyCenter);const totalResults=(Number(bubble.dataset["results"])||0)+newResults;bubble.dataset["results"]=String(totalResults);bubbles.add(bubble);const msgName=totalResults===1?"searchResultBubbleText":"searchResultsBubbleText";bubble.firstChild.textContent=loadTimeData.getStringF(msgName,totalResults)}class Task{request;node;constructor(request,node){this.request=request;this.node=node}}class TopLevelSearchTask extends Task{exec(){const shouldSearch=this.request.regExp!==null;if(shouldSearch){const matchCount=findAndHighlightMatches(this.request,this.node);this.request.updateMatchCount(matchCount)}return Promise.resolve()}}class TaskQueue{request_;queues_;running_;onEmptyCallback_=null;constructor(request){this.request_=request;this.reset();this.running_=false}reset(){this.queues_={high:[],low:[]}}addTopLevelSearchTask(task){this.queues_.high.push(task);this.consumePending_()}addSearchAndHighlightTask(task){this.queues_.low.push(task);this.consumePending_()}onEmpty(onEmptyCallback){this.onEmptyCallback_=onEmptyCallback}popNextTask_(){return this.queues_.high.shift()||this.queues_.low.shift()}consumePending_(){if(this.running_){return}const task=this.popNextTask_();if(!task){this.running_=false;if(this.onEmptyCallback_){this.onEmptyCallback_()}return}this.running_=true;requestIdleCallback((()=>{if(!this.request_.canceled){task.exec().then((()=>{this.running_=false;this.consumePending_()}))}}))}}class SearchRequest{rawQuery_;root_;regExp;canceled;matchCount_=0;resolver=new PromiseResolver;queue;textObservers_;highlights_;bubbles;constructor(rawQuery,root){this.rawQuery_=rawQuery;this.root_=root;this.regExp=this.generateRegExp_();this.canceled=false;this.queue=new TaskQueue(this);this.queue.onEmpty((()=>{this.resolver.resolve(this)}));this.textObservers_=new Set;this.highlights_=[];this.bubbles=new Set}addHighlights(highlights){this.highlights_.push(...highlights)}removeAllTextObservers(){this.textObservers_.forEach((observer=>{observer.disconnect()}));this.textObservers_.clear()}removeAllHighlightsAndBubbles(){removeHighlights(this.highlights_);this.highlights_=[];for(const bubble of this.bubbles){bubble.remove()}this.bubbles.clear()}addTextObserver(textNode){const originalParentNode=textNode.parentNode;const observer=new MutationObserver((mutations=>{const oldValue=mutations[0].oldValue.trim();const newValue=textNode.nodeValue.trim();if(oldValue!==newValue){observer.disconnect();this.textObservers_.delete(observer);findAndRemoveHighlights(originalParentNode)}}));observer.observe(textNode,{characterData:true,characterDataOldValue:true});this.textObservers_.add(observer)}start(){this.queue.addTopLevelSearchTask(new TopLevelSearchTask(this,this.root_))}generateRegExp_(){let regExp=null;const strippedQuery=stripDiacritics(this.rawQuery_.trim());const sanitizedQuery=strippedQuery.replace(SANITIZE_REGEX,"\\$&");if(sanitizedQuery.length>0){regExp=new RegExp(`(${sanitizedQuery})`,"ig")}return regExp}isSame(rawQuery){return this.rawQuery_===rawQuery}updateMatchCount(newMatches){this.matchCount_+=newMatches}getSearchResult(){assert(this.resolver.isFulfilled);return{canceled:this.canceled,matchCount:this.matchCount_,wasClearSearch:this.isSame("")}}}function combineSearchResults(results){assert(results.length>0);return{canceled:results.some((r=>r.canceled)),matchCount:results.reduce(((soFar,r)=>soFar+r.matchCount),0),wasClearSearch:results[0].wasClearSearch}}const SANITIZE_REGEX=/[-[\]{}()*+?.,\\^$|#\s]/g;class SearchManagerImpl{activeRequests_=new Set;completedRequests_=new Set;lastSearchedText_=null;search(text,page){if(text!==this.lastSearchedText_){this.activeRequests_.forEach((function(request){request.removeAllTextObservers();request.removeAllHighlightsAndBubbles();request.canceled=true;request.resolver.resolve(request)}));this.activeRequests_.clear();this.completedRequests_.forEach((request=>{request.removeAllTextObservers();request.removeAllHighlightsAndBubbles()}));this.completedRequests_.clear()}this.lastSearchedText_=text;const request=new SearchRequest(text,page);this.activeRequests_.add(request);request.start();return request.resolver.promise.then((()=>{this.activeRequests_.delete(request);this.completedRequests_.add(request);return request}))}}let instance$q=null;function getSearchManager(){if(instance$q===null){instance$q=new SearchManagerImpl}return instance$q}function setSearchManagerForTesting(searchManager){instance$q=searchManager}
// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const HIDDEN_BY_SEARCH="hidden-by-search";const SearchableViewContainerMixin=dedupingMixin((superClass=>{const superClassBase=RouteObserverMixin(superClass);class SearchableViewContainerMixin extends superClassBase{static get properties(){return{inSearchMode:{type:Boolean,value:false},currentRoute:{type:Object,value:null},shouldShowAll:{type:Boolean,computed:"computeShouldShowAll_(inSearchMode, currentRoute)"}}}getCrViewManager_(){const viewManager=this.shadowRoot.querySelector("cr-view-manager");assert(!!viewManager);return viewManager}currentRouteChanged(route){this.currentRoute=route}async searchContents(query){const parentViews=this.getCrViewManager_().querySelectorAll("[slot=view]:not([data-parent-view-id])");const parentPromises=Array.from(parentViews).map((view=>getSearchManager().search(query,view).then((request=>{const result=request.getSearchResult();if(result.wasClearSearch){view.removeAttribute(HIDDEN_BY_SEARCH);return result}view.toggleAttribute(HIDDEN_BY_SEARCH,result.matchCount===0);return result}))));await Promise.all(parentPromises);const childViews=this.getCrViewManager_().querySelectorAll("[slot=view][data-parent-view-id]");const childPromises=Array.from(childViews).map((view=>getSearchManager().search(query,view).then((request=>{const result=request.getSearchResult();if(result.wasClearSearch||result.matchCount===0){return result}const parentView=this.getCrViewManager_().querySelector(`#${view.dataset["parentViewId"]}`);assert(parentView);parentView.removeAttribute(HIDDEN_BY_SEARCH);const associatedControl=parentView.getAssociatedControlFor(view.id);showBubble(associatedControl,result.matchCount,request.bubbles,false);return result}))));return combineSearchResults(await Promise.all([...parentPromises,...childPromises]))}computeShouldShowAll_(){return this.inSearchMode&&!!this.currentRoute&&!this.currentRoute.isSubpage()}}return SearchableViewContainerMixin}));let instance$p=null;function getCss$b(){return instance$p||(instance$p=[...[],css`cr-icon{--iron-icon-height:var(--cr-icon-size);--iron-icon-width:var(--cr-icon-size);padding-inline-end:10px}cr-dialog::part(body-container){padding-inline-start:35px}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$a(){return html`
<cr-dialog id="dialog" close-text="${this.i18n("close")}" show-on-attach>
  <div slot="title">
    <cr-icon icon="cr:domain" role="img"
        aria-label="${this.i18n("controlledSettingPolicy")}">
    </cr-icon>
    ${this.title}
  </div>
  <div slot="body">${this.body}</div>
  <div slot="button-container">
    <cr-button class="action-button" @click="${this.onOkClick_}">
      ${this.i18n("ok")}
    </cr-button>
  </div>
</cr-dialog>`}
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ManagedDialogElementBase=I18nMixinLit(CrLitElement);class ManagedDialogElement extends ManagedDialogElementBase{static get is(){return"managed-dialog"}static get styles(){return getCss$b()}render(){return getHtml$a.bind(this)()}static get properties(){return{title:{type:String},body:{type:String}}}#title_accessor_storage="";get title(){return this.#title_accessor_storage}set title(value){this.#title_accessor_storage=value}#body_accessor_storage="";get body(){return this.#body_accessor_storage}set body(value){this.#body_accessor_storage=value}onOkClick_(){this.$.dialog.close()}}customElements.define(ManagedDialogElement.is,ManagedDialogElement);const styleMod$3=document.createElement("dom-module");styleMod$3.appendChild(html$1`
  <template>
    <style>
.md-select{--md-arrow-width:7px;--md-select-bg-color:transparent;--md-select-option-bg-color:white;--md-select-side-padding:10px;--md-select-text-color:inherit;-webkit-appearance:none;background:url(//resources/images/arrow_down.svg) calc(100% - var(--md-select-side-padding)) center no-repeat;background-color:var(--md-select-bg-color);background-size:var(--md-arrow-width);border:solid 1px var(--color-combobox-container-outline,var(--cr-fallback-color-neutral-outline));border-radius:8px;box-sizing:border-box;color:var(--md-select-text-color);cursor:pointer;font-family:inherit;font-size:12px;height:36px;max-width:100%;outline:none;padding-block-end:0;padding-block-start:0;padding-inline-end:calc(var(--md-select-side-padding) + var(--md-arrow-width) + 3px);padding-inline-start:var(--md-select-side-padding);width:var(--md-select-width,200px)}@media (prefers-color-scheme:dark){.md-select{--md-select-option-bg-color:var(--google-grey-900-white-4-percent);background-image:url(//resources/images/dark/arrow_down.svg)}}.md-select:hover{background-color:var(--color-comboxbox-ink-drop-hovered,var(--cr-hover-on-subtle-background-color))}.md-select :-webkit-any(option,optgroup){background-color:var(--md-select-option-bg-color)}.md-select[disabled]{background-color:var(--color-combobox-background-disabled,var(--cr-fallback-color-disabled-background));border-color:transparent;color:var(--color-textfield-foreground-disabled,var(--cr-fallback-color-disabled-foreground));opacity:1;pointer-events:none}.md-select:focus{outline:solid 2px var(--cr-focus-outline-color);outline-offset:-1px}:host-context([dir=rtl]) .md-select{background-position-x:var(--md-select-side-padding)}
    </style>
  </template>
`.content);styleMod$3.register("md-select");const styleMod$2=document.createElement("dom-module");styleMod$2.appendChild(html$1`
  <template>
    <style>
:host{--cr-radio-button-checked-color:var(--owl-control-accent-color,var(--color-radio-button-foreground-checked,var(--cr-fallback-color-primary)));--cr-radio-button-checked-ripple-color:var(--cr-active-background-color);--cr-radio-button-ink-size:32px;--cr-radio-button-size:16px;--cr-radio-button-unchecked-color:var(--color-radio-button-foreground-unchecked,var(--cr-fallback-color-outline));--cr-radio-button-unchecked-ripple-color:var(--cr-active-background-color);--ink-to-circle:calc((var(--cr-radio-button-ink-size) - var(--cr-radio-button-size)) / 2);align-items:center;display:flex;flex-shrink:0;gap:var(--cr-radio-button-label-spacing,20px);outline:none}@media (prefers-color-scheme:dark){:host{--cr-radio-button-checked-color:var(--owl-control-accent-color,var(--google-blue-300));--cr-radio-button-checked-ripple-color:rgba(var(--google-blue-300-rgb),.4);--cr-radio-button-unchecked-color:var(--google-grey-500);--cr-radio-button-unchecked-ripple-color:rgba(var(--google-grey-300-rgb),.4)}}@media (forced-colors:active){:host{--cr-radio-button-checked-color:SelectedItem;forced-color-adjust:none}}:host([disabled]){opacity:1;pointer-events:none;--cr-radio-button-checked-color:var(--color-radio-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-radio-button-unchecked-color:var(--color-radio-foreground-disabled,var(--cr-fallback-color-disabled-foreground))}:host(:not([disabled])){cursor:pointer}:host(.label-first){flex-direction:row-reverse}#labelWrapper{flex:1}:host([disabled]) #labelWrapper{opacity:var(--cr-disabled-opacity)}#label{color:inherit}:host([hide-label-text]) #label{clip:rect(0,0,0,0);display:block;position:fixed}.disc-border,.disc,.disc-wrapper,cr-ripple,paper-ripple{border-radius:50%}.disc-wrapper{height:var(--cr-radio-button-size);margin-block-start:var(--cr-radio-button-disc-margin-block-start,0);position:relative;width:var(--cr-radio-button-size)}.disc-border,.disc{box-sizing:border-box;height:var(--cr-radio-button-size);width:var(--cr-radio-button-size)}.disc-border{border:2px solid var(--cr-radio-button-unchecked-color)}:host([checked]) .disc-border{border-color:var(--cr-radio-button-checked-color)}#button:focus{outline:none}.disc{background-color:transparent;position:absolute;top:0;transform:scale(0);transition:border-color 200ms,transform 200ms}:host([checked]) .disc{background-color:var(--cr-radio-button-checked-color);transform:scale(0.5)}#overlay{border-radius:50%;box-sizing:border-box;display:none;height:var(--cr-radio-button-ink-size);left:50%;pointer-events:none;position:absolute;top:50%;transform:translate(-50%,-50%);width:var(--cr-radio-button-ink-size)}#button:hover #overlay{background-color:var(--cr-hover-background-color);display:block}#button:focus-visible #overlay{border:2px solid var(--cr-focus-outline-color);display:block}cr-ripple,paper-ripple{--paper-ripple-opacity:1;color:var(--cr-radio-button-unchecked-ripple-color);height:var(--cr-radio-button-ink-size);left:calc(-1 * var(--ink-to-circle));pointer-events:none;position:absolute;top:calc(-1 * var(--ink-to-circle));transition:color linear 80ms;width:var(--cr-radio-button-ink-size)}:host-context([dir=rtl]) cr-ripple,:host-context([dir=rtl]) paper-ripple{left:auto;right:calc(-1 * var(--ink-to-circle))}:host([checked]) cr-ripple,:host([checked]) paper-ripple{color:var(--cr-radio-button-checked-ripple-color)}
    </style>
  </template>
`.content);styleMod$2.register("cr-radio-button-style");
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrRadioButtonMixin=dedupingMixin((superClass=>{class CrRadioButtonMixin extends superClass{static get properties(){return{checked:{type:Boolean,reflectToAttribute:true,value:false},disabled:{type:Boolean,reflectToAttribute:true,notify:true,value:false},focusable:{type:Boolean,observer:"onFocusableChanged_",value:false},hideLabelText:{type:Boolean,reflectToAttribute:true,value:false},label:{type:String,value:""},name:{type:String,notify:true,reflectToAttribute:true},buttonTabIndex_:{type:Number,computed:"getTabIndex_(focusable)"}}}connectedCallback(){super.connectedCallback();this.addEventListener("blur",this.hideRipple_.bind(this));this.addEventListener("up",this.hideRipple_.bind(this))}focus(){const button=this.shadowRoot.querySelector("#button");assert(button);button.focus()}getPaperRipple(){assertNotReached()}hideRipple_(){this.getPaperRipple().clear()}onFocusableChanged_(){const links=this.querySelectorAll("a");links.forEach((link=>{link.tabIndex=this.checked?0:-1}))}getAriaChecked_(){return this.checked?"true":"false"}getAriaDisabled_(){return this.disabled?"true":"false"}getTabIndex_(){return this.focusable?0:-1}onInputKeydown_(e){if(e.shiftKey&&e.key==="Tab"){this.focus()}}}return CrRadioButtonMixin}));
// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function stringToPrefValue(value,pref){switch(pref.type){case chrome.settingsPrivate.PrefType.BOOLEAN:return value==="true";case chrome.settingsPrivate.PrefType.NUMBER:const n=parseFloat(value);if(isNaN(n)){console.error("Argument to stringToPrefValue for number pref "+"was unparsable: "+value);return undefined}return n;case chrome.settingsPrivate.PrefType.STRING:case chrome.settingsPrivate.PrefType.URL:return value;default:assertNotReached("No conversion from string to "+pref.type+" pref")}}function prefToString(pref){switch(pref.type){case chrome.settingsPrivate.PrefType.BOOLEAN:case chrome.settingsPrivate.PrefType.NUMBER:return pref.value.toString();case chrome.settingsPrivate.PrefType.STRING:case chrome.settingsPrivate.PrefType.URL:return pref.value;default:assertNotReached("No conversion from "+pref.type+" pref to string")}}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrRippleMixinPolymer=superClass=>{class CrRippleMixinPolymer extends superClass{static get properties(){return{noink:{type:Boolean,observer:"onNoinkChanged_",value:false}}}rippleContainer=null;ripple_=null;onNoinkChanged_(){if(this.hasRipple()){assert(this.ripple_);this.ripple_.noink=this.noink}}ensureRippleOnPointerdown(){this.addEventListener("pointerdown",(()=>this.ensureRipple()),{capture:true})}ensureRipple(){if(this.hasRipple()){return}this.ripple_=this.createRipple();this.ripple_.noink=this.noink;const rippleContainer=this.rippleContainer||this.shadowRoot;assert(rippleContainer);rippleContainer.appendChild(this.ripple_)}getRipple(){this.ensureRipple();assert(this.ripple_);return this.ripple_}hasRipple(){return Boolean(this.ripple_)}createRipple(){const ripple=document.createElement("cr-ripple");ripple.id="ink";return ripple}}return CrRippleMixinPolymer};function getTemplate$n(){return html$1`<!--_html_template_start_--><style include="cr-radio-button-style">:host([disabled]){opacity:1}:host([disabled]) .disc-wrapper,:host([disabled]) #labelWrapper{opacity:var(--cr-disabled-opacity)}cr-policy-pref-indicator{margin-inline-start:var(--cr-controlled-by-spacing);pointer-events:all}</style>

<div
    aria-checked$="[[getAriaChecked_(checked)]]"
    aria-describedby="slotted-content"
    aria-disabled$="[[getAriaDisabled_(disabled)]]"
    aria-labelledby="label"
    class="disc-wrapper"
    id="button"
    role="radio"
    tabindex$="[[buttonTabIndex_]]"
    on-keydown="onInputKeydown_">
  <div class="disc-border"></div>
  <div class="disc"></div>
  <div id="overlay"></div>
</div>

<div id="labelWrapper" part="labelWrapper">
  <span id="label" hidden$="[[!label]]">[[label]]</span>
  <span id="slotted-content">
    <slot></slot>
  </span>
</div>

<template is="dom-if" if="[[showIndicator_(disabled, name, pref.*)]]">
  <cr-policy-pref-indicator pref="[[pref]]" on-click="onIndicatorClick_"
      icon-aria-label="[[label]]">
  </cr-policy-pref-indicator>
</template>
<!--_html_template_end_-->`}
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ControlledRadioButtonElementBase=CrRippleMixinPolymer(CrRadioButtonMixin(PrefControlMixin(PolymerElement)));class ControlledRadioButtonElement extends ControlledRadioButtonElementBase{static get is(){return"controlled-radio-button"}static get template(){return getTemplate$n()}static get observers(){return["updateDisabled_(pref.enforcement)"]}getPaperRipple(){return this.getRipple()}createRipple(){this.rippleContainer=this.shadowRoot.querySelector(".disc-wrapper");const ripple=super.createRipple();ripple.setAttribute("recenters","");ripple.classList.add("circle");return ripple}updateDisabled_(){this.disabled=this.pref.enforcement===chrome.settingsPrivate.Enforcement.ENFORCED}showIndicator_(){if(!this.disabled){return false}assert(this.pref);return this.name===prefToString(this.pref)}onIndicatorClick_(e){e.preventDefault();e.stopPropagation()}}customElements.define(ControlledRadioButtonElement.is,ControlledRadioButtonElement);
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class ExtensionControlBrowserProxyImpl{disableExtension(extensionId){chrome.send("disableExtension",[extensionId])}manageExtension(extensionId){window.open("chrome://extensions?id="+extensionId)}static getInstance(){return instance$o||(instance$o=new ExtensionControlBrowserProxyImpl)}static setInstance(obj){instance$o=obj}}let instance$o=null;function getTemplate$m(){return html$1`<!--_html_template_start_--><style

>:host{align-items:center;display:flex;margin-inline-start:36px;min-height:var(--cr-section-min-height)}img{margin-inline-end:16px}iron-icon[icon='cr:open-in-new']{fill:currentColor;height:var(--cr-icon-size);width:var(--cr-icon-size)}#disable{margin-inline-start:8px}:host>span{flex:1;margin-inline-end:8px}</style>
<img role="presentation" src="chrome://extension-icon/[[extensionId]]/20/1">
<span>[[getLabel_(extensionName)]]</span>
<cr-button id="manage" on-click="onManageClick_">
  $i18n{manage}
  <cr-icon icon="cr:open-in-new" slot="suffix-icon"></cr-icon>
</cr-button>
<template is="dom-if" if="[[extensionCanBeDisabled]]" restamp>
  <cr-button id="disable" on-click="onDisableClick_">$i18n{disable}</cr-button>
</template>
<!--_html_template_end_-->`}
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class ExtensionControlledIndicatorElement extends PolymerElement{static get is(){return"extension-controlled-indicator"}static get template(){return getTemplate$m()}static get properties(){return{extensionCanBeDisabled:Boolean,extensionId:String,extensionName:String}}getLabel_(){return loadTimeData.getStringF("controlledByExtension",this.extensionName)}onManageClick_(){const manageUrl="chrome://extensions/?id="+this.extensionId;OpenWindowProxyImpl.getInstance().openUrl(manageUrl)}onDisableClick_(){assert(this.extensionCanBeDisabled);ExtensionControlBrowserProxyImpl.getInstance().disableExtension(this.extensionId);this.dispatchEvent(new CustomEvent("extension-disable",{bubbles:true,composed:true}))}}customElements.define(ExtensionControlledIndicatorElement.is,ExtensionControlledIndicatorElement);let instance$n=null;function getCss$a(){return instance$n||(instance$n=[...[],css`:host{--cr-radio-button-checked-color:var(--owl-control-accent-color,var(--color-radio-button-foreground-checked,var(--cr-fallback-color-primary)));--cr-radio-button-checked-ripple-color:var(--cr-active-background-color);--cr-radio-button-ink-size:32px;--cr-radio-button-size:16px;--cr-radio-button-unchecked-color:var(--color-radio-button-foreground-unchecked,var(--cr-fallback-color-outline));--cr-radio-button-unchecked-ripple-color:var(--cr-active-background-color);--ink-to-circle:calc((var(--cr-radio-button-ink-size) - var(--cr-radio-button-size)) / 2);align-items:center;display:flex;flex-shrink:0;gap:var(--cr-radio-button-label-spacing,20px);outline:none}@media (prefers-color-scheme:dark){:host{--cr-radio-button-checked-color:var(--owl-control-accent-color,var(--google-blue-300));--cr-radio-button-checked-ripple-color:rgba(var(--google-blue-300-rgb),.4);--cr-radio-button-unchecked-color:var(--google-grey-500);--cr-radio-button-unchecked-ripple-color:rgba(var(--google-grey-300-rgb),.4)}}@media (forced-colors:active){:host{--cr-radio-button-checked-color:SelectedItem;forced-color-adjust:none}}:host([disabled]){opacity:1;pointer-events:none;--cr-radio-button-checked-color:var(--color-radio-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-radio-button-unchecked-color:var(--color-radio-foreground-disabled,var(--cr-fallback-color-disabled-foreground))}:host(:not([disabled])){cursor:pointer}:host(.label-first){flex-direction:row-reverse}#labelWrapper{flex:1}:host([disabled]) #labelWrapper{opacity:var(--cr-disabled-opacity)}#label{color:inherit}:host([hide-label-text]) #label{clip:rect(0,0,0,0);display:block;position:fixed}.disc-border,.disc,.disc-wrapper,cr-ripple,paper-ripple{border-radius:50%}.disc-wrapper{height:var(--cr-radio-button-size);margin-block-start:var(--cr-radio-button-disc-margin-block-start,0);position:relative;width:var(--cr-radio-button-size)}.disc-border,.disc{box-sizing:border-box;height:var(--cr-radio-button-size);width:var(--cr-radio-button-size)}.disc-border{border:2px solid var(--cr-radio-button-unchecked-color)}:host([checked]) .disc-border{border-color:var(--cr-radio-button-checked-color)}#button:focus{outline:none}.disc{background-color:transparent;position:absolute;top:0;transform:scale(0);transition:border-color 200ms,transform 200ms}:host([checked]) .disc{background-color:var(--cr-radio-button-checked-color);transform:scale(0.5)}#overlay{border-radius:50%;box-sizing:border-box;display:none;height:var(--cr-radio-button-ink-size);left:50%;pointer-events:none;position:absolute;top:50%;transform:translate(-50%,-50%);width:var(--cr-radio-button-ink-size)}#button:hover #overlay{background-color:var(--cr-hover-background-color);display:block}#button:focus-visible #overlay{border:2px solid var(--cr-focus-outline-color);display:block}cr-ripple,paper-ripple{--paper-ripple-opacity:1;color:var(--cr-radio-button-unchecked-ripple-color);height:var(--cr-radio-button-ink-size);left:calc(-1 * var(--ink-to-circle));pointer-events:none;position:absolute;top:calc(-1 * var(--ink-to-circle));transition:color linear 80ms;width:var(--cr-radio-button-ink-size)}:host-context([dir=rtl]) cr-ripple,:host-context([dir=rtl]) paper-ripple{left:auto;right:calc(-1 * var(--ink-to-circle))}:host([checked]) cr-ripple,:host([checked]) paper-ripple{color:var(--cr-radio-button-checked-ripple-color)}`])}let instance$m=null;function getCss$9(){return instance$m||(instance$m=[...[getCss$a(),getCss$x()],css``])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$9(){return html`
<div aria-checked="${this.getAriaChecked()}"
    aria-describedby="slotted-content"
    aria-disabled="${this.getAriaDisabled()}"
    aria-labelledby="label"
    class="disc-wrapper"
    id="button"
    role="radio"
    tabindex="${this.getButtonTabIndex()}"
    @keydown="${this.onInputKeydown}">
  <div class="disc-border"></div>
  <div class="disc"></div>
  <div id="overlay"></div>
</div>

<div id="labelWrapper">
  <span id="label" ?hidden="${!this.label}" aria-hidden="true">
    ${this.label}
  </span>
  <span id="slotted-content">
    <slot></slot>
  </span>
</div>`}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrRadioButtonMixinLit=superClass=>{class CrRadioButtonMixinLit extends superClass{static get properties(){return{checked:{type:Boolean,reflect:true},disabled:{type:Boolean,reflect:true,notify:true},focusable:{type:Boolean},hideLabelText:{type:Boolean,reflect:true},label:{type:String},name:{type:String,notify:true,reflect:true},ariaCheckedString:{type:String},ariaDisabledString:{type:String}}}#checked_accessor_storage=false;get checked(){return this.#checked_accessor_storage}set checked(value){this.#checked_accessor_storage=value}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#focusable_accessor_storage=false;get focusable(){return this.#focusable_accessor_storage}set focusable(value){this.#focusable_accessor_storage=value}#hideLabelText_accessor_storage=false;get hideLabelText(){return this.#hideLabelText_accessor_storage}set hideLabelText(value){this.#hideLabelText_accessor_storage=value}#label_accessor_storage="";get label(){return this.#label_accessor_storage}set label(value){this.#label_accessor_storage=value}#name_accessor_storage;get name(){return this.#name_accessor_storage}set name(value){this.#name_accessor_storage=value}noRipple=false;#ariaCheckedString_accessor_storage="false";get ariaCheckedString(){return this.#ariaCheckedString_accessor_storage}set ariaCheckedString(value){this.#ariaCheckedString_accessor_storage=value}#ariaDisabledString_accessor_storage="false";get ariaDisabledString(){return this.#ariaDisabledString_accessor_storage}set ariaDisabledString(value){this.#ariaDisabledString_accessor_storage=value}connectedCallback(){super.connectedCallback();if(!this.noRipple){this.addEventListener("blur",this.hideRipple_.bind(this));this.addEventListener("up",this.hideRipple_.bind(this))}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("focusable")){const links=this.querySelectorAll("a");links.forEach((link=>{link.tabIndex=this.checked?0:-1}))}}getAriaDisabled(){return this.disabled?"true":"false"}getAriaChecked(){return this.checked?"true":"false"}getButtonTabIndex(){return this.focusable?0:-1}focus(){const button=this.shadowRoot.querySelector("#button");assert(button);button.focus()}getRipple(){assertNotReached()}hideRipple_(){assert(!this.noRipple);this.getRipple().clear()}onInputKeydown(e){if(e.shiftKey&&e.key==="Tab"){this.focus()}}}return CrRadioButtonMixinLit};
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrRadioButtonElementBase=CrRippleMixin(CrRadioButtonMixinLit(CrLitElement));class CrRadioButtonElement extends CrRadioButtonElementBase{static get is(){return"cr-radio-button"}static get styles(){return getCss$9()}render(){return getHtml$9.bind(this)()}createRipple(){this.rippleContainer=this.shadowRoot.querySelector(".disc-wrapper");const ripple=super.createRipple();ripple.setAttribute("recenters","");ripple.classList.add("circle");return ripple}}customElements.define(CrRadioButtonElement.is,CrRadioButtonElement);let instance$l=null;function getCss$8(){return instance$l||(instance$l=[...[],css`:host{display:inline-block}:host ::slotted(*){padding:var(--cr-radio-group-item-padding,12px)}:host([disabled]){cursor:initial;pointer-events:none;user-select:none}:host([disabled]) ::slotted(*){opacity:var(--cr-disabled-opacity)}
`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$8(){return html`<slot></slot>`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function isEnabled(radio){return radio.matches(":not([disabled]):not([hidden])")&&radio.style.display!=="none"&&radio.style.visibility!=="hidden"}class CrRadioGroupElement extends CrLitElement{static get is(){return"cr-radio-group"}static get styles(){return getCss$8()}render(){return getHtml$8.bind(this)()}static get properties(){return{disabled:{type:Boolean,reflect:true},selected:{type:String,notify:true},selectableElements:{type:String},nestedSelectable:{type:Boolean},selectableRegExp_:{type:Object}}}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#selected_accessor_storage;get selected(){return this.#selected_accessor_storage}set selected(value){this.#selected_accessor_storage=value}#selectableElements_accessor_storage="cr-radio-button, cr-card-radio-button, controlled-radio-button";get selectableElements(){return this.#selectableElements_accessor_storage}set selectableElements(value){this.#selectableElements_accessor_storage=value}#nestedSelectable_accessor_storage=false;get nestedSelectable(){return this.#nestedSelectable_accessor_storage}set nestedSelectable(value){this.#nestedSelectable_accessor_storage=value}#selectableRegExp__accessor_storage=new RegExp("");get selectableRegExp_(){return this.#selectableRegExp__accessor_storage}set selectableRegExp_(value){this.#selectableRegExp__accessor_storage=value}buttons_=null;buttonEventTracker_=new EventTracker;deltaKeyMap_=null;isRtl_=false;populateBound_=null;firstUpdated(){this.addEventListener("keydown",(e=>this.onKeyDown_(e)));this.addEventListener("click",(e=>this.onClick_(e)));if(!this.hasAttribute("role")){this.setAttribute("role","radiogroup")}}connectedCallback(){super.connectedCallback();this.isRtl_=this.matches(":host-context([dir=rtl]) cr-radio-group");this.deltaKeyMap_=new Map([["ArrowDown",1],["ArrowLeft",this.isRtl_?1:-1],["ArrowRight",this.isRtl_?-1:1],["ArrowUp",-1],["PageDown",1],["PageUp",-1]]);this.populateBound_=()=>this.populate_();assert(this.populateBound_);this.shadowRoot.querySelector("slot").addEventListener("slotchange",this.populateBound_);this.populate_()}disconnectedCallback(){super.disconnectedCallback();assert(this.populateBound_);this.shadowRoot.querySelector("slot").removeEventListener("slotchange",this.populateBound_);this.buttonEventTracker_.removeAll()}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("selectableElements")){const tags=this.selectableElements.split(", ").join("|");this.selectableRegExp_=new RegExp(`^(${tags})$`,"i")}}updated(changedProperties){if(changedProperties.has("nestedSelectable")){this.populate_()}if(changedProperties.has("disabled")||changedProperties.has("selected")){this.update_()}this.setAttribute("aria-disabled",`${this.disabled}`);super.updated(changedProperties)}focus(){if(this.disabled||!this.buttons_){return}const radio=this.buttons_.find((radio=>this.isButtonEnabledAndSelected_(radio)));if(radio){radio.focus()}}onKeyDown_(event){if(this.disabled){return}if(event.ctrlKey||event.shiftKey||event.metaKey||event.altKey){return}const targetElement=event.target;if(!this.buttons_||!this.buttons_.includes(targetElement)){return}if(event.key===" "||event.key==="Enter"){event.preventDefault();this.select_(targetElement);return}const enabledRadios=this.buttons_.filter(isEnabled);if(enabledRadios.length===0){return}assert(this.deltaKeyMap_);let selectedIndex;const max=enabledRadios.length-1;if(event.key==="Home"){selectedIndex=0}else if(event.key==="End"){selectedIndex=max}else if(this.deltaKeyMap_.has(event.key)){const delta=this.deltaKeyMap_.get(event.key);const lastSelection=enabledRadios.findIndex((radio=>radio.checked));selectedIndex=Math.max(0,lastSelection)+delta;if(selectedIndex>max){selectedIndex=0}else if(selectedIndex<0){selectedIndex=max}}else{return}const radio=enabledRadios[selectedIndex];const name=`${radio.name}`;if(this.selected!==name){event.preventDefault();event.stopPropagation();this.selected=name;radio.focus()}}onClick_(event){const path=event.composedPath();if(path.some((target=>/^a$/i.test(target.tagName)))){return}const target=path.find((n=>this.selectableRegExp_.test(n.tagName)));if(target&&this.buttons_&&this.buttons_.includes(target)){this.select_(target)}}populate_(){const elements=this.shadowRoot.querySelector("slot").assignedElements({flatten:true});this.buttons_=Array.from(elements).flatMap((el=>{let result=[];if(el.matches(this.selectableElements)){result.push(el)}if(this.nestedSelectable){result=result.concat(Array.from(el.querySelectorAll(this.selectableElements)))}return result}));this.buttonEventTracker_.removeAll();this.buttons_.forEach((el=>{this.buttonEventTracker_.add(el,"disabled-changed",(()=>this.populate_()));this.buttonEventTracker_.add(el,"name-changed",(()=>this.populate_()))}));this.update_()}select_(button){if(!isEnabled(button)){return}const name=`${button.name}`;if(this.selected!==name){this.selected=name}}isButtonEnabledAndSelected_(button){return!this.disabled&&button.checked&&isEnabled(button)}update_(){if(!this.buttons_){return}let noneMadeFocusable=true;this.buttons_.forEach((radio=>{radio.checked=this.selected!==undefined&&`${radio.name}`===`${this.selected}`;const disabled=this.disabled||!isEnabled(radio);const canBeFocused=radio.checked&&!disabled;if(canBeFocused){radio.focusable=true;noneMadeFocusable=false}else{radio.focusable=false}radio.setAttribute("aria-disabled",`${disabled}`)}));if(noneMadeFocusable&&!this.disabled){const radio=this.buttons_.find(isEnabled);if(radio){radio.focusable=true}}}}customElements.define(CrRadioGroupElement.is,CrRadioGroupElement);function getTemplate$l(){return html$1`<!--_html_template_start_--><style>cr-radio-group{width:100%}</style>
<cr-radio-group selected="[[selected]]"
    on-selected-changed="onSelectedChanged_"
    aria-label$="[[groupAriaLabel]]"
    selectable-elements="[[selectableElements]]">
  <slot></slot>
</cr-radio-group>
<!--_html_template_end_-->`}
// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsRadioGroupElementBase=PrefControlMixin(PolymerElement);class SettingsRadioGroupElement extends SettingsRadioGroupElementBase{static get is(){return"settings-radio-group"}static get template(){return getTemplate$l()}static get properties(){return{groupAriaLabel:String,noSetPref:{type:Boolean,value:false},selected:String,selectableElements:{type:String,value:["cr-radio-button","controlled-radio-button"].join(", ")}}}static get observers(){return["resetToPrefValue(pref.*)"]}ready(){super.ready();this.setAttribute("role","none")}focus(){this.shadowRoot.querySelector("cr-radio-group").focus()}resetToPrefValue(){this.selected=prefToString(this.pref)}sendPrefChange(){if(!this.pref){return}this.set("pref.value",stringToPrefValue(this.selected||"",this.pref))}onSelectedChanged_(){const previous=this.selected;this.selected=this.shadowRoot.querySelector("cr-radio-group").selected;if(previous===this.selected){return}if(!this.noSetPref){this.sendPrefChange()}this.dispatchEvent(new CustomEvent("change",{bubbles:true,composed:true}))}}customElements.define(SettingsRadioGroupElement.is,SettingsRadioGroupElement);function getTemplate$k(){return html$1`<!--_html_template_start_--><style include="md-select">:host{align-items:center;display:inline-flex}cr-policy-pref-indicator{height:var(--iron-icon-width,24px);margin:0 var(--cr-controlled-by-spacing);order:var(--settings-dropdown-menu-policy-order,0);width:var(--iron-icon-width,24px)}option:disabled{display:none}</style>
<template is="dom-if" if="[[pref.controlledBy]]" restamp>
  <cr-policy-pref-indicator pref="[[pref]]"></cr-policy-pref-indicator>
</template>
<select class="md-select" id="dropdownMenu" on-change="onChange_"
    aria-label$="[[label]]" part="select"
    disabled="[[shouldDisableMenu_(disabled, menuOptions.*, pref.*)]]">
  <template is="dom-repeat" items="[[menuOptions]]">
    <option value="[[item.value]]" hidden="[[item.hidden]]">
      [[item.name]]
    </option>
  </template>
  <option value="[[notFoundValue]]"
      disabled="[[!showNotFoundValue_(menuOptions, pref.value)]]">
    $i18n{custom}
  </option>
</select>
<!--_html_template_end_-->`}
// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsDropdownMenuElementBase=CrPolicyPrefMixin(PrefControlMixin(PolymerElement));class SettingsDropdownMenuElement extends SettingsDropdownMenuElementBase{static get is(){return"settings-dropdown-menu"}static get template(){return getTemplate$k()}static get properties(){return{menuOptions:Array,disabled:{type:Boolean,reflectToAttribute:true,value:false},prefKey:{type:String,value:null},noSetPref:{type:Boolean,value:false},notFoundValue:{type:String,value:"SETTINGS_DROPDOWN_NOT_FOUND_ITEM",readOnly:true},label:String}}static get observers(){return["updateSelected_(menuOptions, pref.value.*, prefKey)"]}focus(){this.$.dropdownMenu.focus()}sendPrefChange(){assert(this.pref);const selected=this.$.dropdownMenu.value;if(this.prefKey){this.set(`pref.value.${this.prefKey}`,selected)}else{const prefValue=stringToPrefValue(selected,this.pref);if(prefValue!==undefined){this.set("pref.value",prefValue)}}}getSelectedValue(){return this.$.dropdownMenu.value}onChange_(){if(this.$.dropdownMenu.value===this.notFoundValue){return}if(!this.noSetPref){this.sendPrefChange()}this.dispatchEvent(new CustomEvent("settings-control-change",{bubbles:true,composed:true}))}updateSelected_(){if(this.menuOptions===undefined||this.pref===undefined||this.prefKey===undefined){return}if(!this.menuOptions.length){return}const prefValue=this.prefStringValue_();const option=this.menuOptions.find((function(menuItem){return menuItem.value.toString()===prefValue}));microTask.run((()=>{this.$.dropdownMenu.value=option===undefined?this.notFoundValue:prefValue}))}prefStringValue_(){if(this.prefKey){return this.pref.value[this.prefKey]}else{assert(this.pref);return prefToString(this.pref)}}showNotFoundValue_(menuOptions,prefValue){if(menuOptions===undefined||prefValue===undefined){return false}if(menuOptions===null||menuOptions.length===0){return false}const option=menuOptions.find((menuItem=>menuItem.value.toString()===this.prefStringValue_()));return!option}shouldDisableMenu_(){return this.disabled||this.isPrefEnforced()||this.menuOptions===undefined||this.menuOptions.length===0}}customElements.define(SettingsDropdownMenuElement.is,SettingsDropdownMenuElement);
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var PasswordCheckReferrer;(function(PasswordCheckReferrer){PasswordCheckReferrer[PasswordCheckReferrer["SAFETY_CHECK"]=0]="SAFETY_CHECK";PasswordCheckReferrer[PasswordCheckReferrer["PASSWORD_SETTINGS"]=1]="PASSWORD_SETTINGS";PasswordCheckReferrer[PasswordCheckReferrer["PHISH_GUARD_DIALOG"]=2]="PHISH_GUARD_DIALOG";PasswordCheckReferrer[PasswordCheckReferrer["PASSWORD_BREACH_DIALOG"]=3]="PASSWORD_BREACH_DIALOG";PasswordCheckReferrer[PasswordCheckReferrer["COUNT"]=4]="COUNT"})(PasswordCheckReferrer||(PasswordCheckReferrer={}));var PasswordManagerPage;(function(PasswordManagerPage){PasswordManagerPage[PasswordManagerPage["PASSWORDS"]=0]="PASSWORDS";PasswordManagerPage[PasswordManagerPage["CHECKUP"]=1]="CHECKUP"})(PasswordManagerPage||(PasswordManagerPage={}));class PasswordManagerImpl{recordPasswordsPageAccessInSettings(){chrome.passwordsPrivate.recordPasswordsPageAccessInSettings()}recordPasswordCheckReferrer(referrer){chrome.metricsPrivate.recordEnumerationValue("PasswordManager.BulkCheck.PasswordCheckReferrer",referrer,PasswordCheckReferrer.COUNT)}showPasswordManager(page){chrome.send("showPasswordManager",[page])}static getInstance(){return instance$k||(instance$k=new PasswordManagerImpl)}static setInstance(obj){instance$k=obj}}let instance$k=null;
// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class ActionLink extends HTMLAnchorElement{boundOnKeyDown_=null;boundOnMouseDown_=null;boundOnBlur_=null;connectedCallback(){this.tabIndex=this.disabled?-1:0;if(!this.hasAttribute("role")){this.setAttribute("role","link")}this.boundOnKeyDown_=e=>{if(!this.disabled&&e.key==="Enter"&&!this.href){window.setTimeout((()=>this.click()),0)}};this.addEventListener("keydown",this.boundOnKeyDown_);function preventDefault(e){e.preventDefault()}function removePreventDefault(){document.removeEventListener("selectstart",preventDefault);document.removeEventListener("mouseup",removePreventDefault)}this.boundOnMouseDown_=()=>{document.addEventListener("selectstart",preventDefault);document.addEventListener("mouseup",removePreventDefault);if(document.activeElement!==this){this.classList.add("no-outline")}};this.addEventListener("mousedown",this.boundOnMouseDown_);this.boundOnBlur_=()=>this.classList.remove("no-outline");this.addEventListener("blur",this.boundOnBlur_)}disconnectedCallback(){this.removeEventListener("keydown",this.boundOnKeyDown_);this.boundOnKeyDown_=null;this.removeEventListener("mousedown",this.boundOnMouseDown_);this.boundOnMouseDown_=null;this.removeEventListener("blur",this.boundOnBlur_);this.boundOnBlur_=null}set disabled(disabled){if(disabled){HTMLAnchorElement.prototype.setAttribute.call(this,"disabled","")}else{HTMLAnchorElement.prototype.removeAttribute.call(this,"disabled")}this.tabIndex=disabled?-1:0}get disabled(){return this.hasAttribute("disabled")}setAttribute(attr,val){if(attr.toLowerCase()==="disabled"){this.disabled=true}else{super.setAttribute(attr,val)}}removeAttribute(attr){if(attr.toLowerCase()==="disabled"){this.disabled=false}else{super.removeAttribute(attr)}}}customElements.define("action-link",ActionLink,{extends:"a"});
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/var ORPHANS=new Set;const IronResizableBehavior={properties:{_parentResizable:{type:Object,observer:"_parentResizableChanged"},_notifyingDescendant:{type:Boolean,value:false}},listeners:{"iron-request-resize-notifications":"_onIronRequestResizeNotifications"},created:function(){this._interestedResizables=[];this._boundNotifyResize=this.notifyResize.bind(this);this._boundOnDescendantIronResize=this._onDescendantIronResize.bind(this)},attached:function(){this._requestResizeNotifications()},detached:function(){if(this._parentResizable){this._parentResizable.stopResizeNotificationsFor(this)}else{ORPHANS.delete(this);window.removeEventListener("resize",this._boundNotifyResize)}this._parentResizable=null},notifyResize:function(){if(!this.isAttached){return}this._interestedResizables.forEach((function(resizable){if(this.resizerShouldNotify(resizable)){this._notifyDescendant(resizable)}}),this);this._fireResize()},assignParentResizable:function(parentResizable){if(this._parentResizable){this._parentResizable.stopResizeNotificationsFor(this)}this._parentResizable=parentResizable;if(parentResizable&&parentResizable._interestedResizables.indexOf(this)===-1){parentResizable._interestedResizables.push(this);parentResizable._subscribeIronResize(this)}},stopResizeNotificationsFor:function(target){var index=this._interestedResizables.indexOf(target);if(index>-1){this._interestedResizables.splice(index,1);this._unsubscribeIronResize(target)}},_subscribeIronResize:function(target){target.addEventListener("iron-resize",this._boundOnDescendantIronResize)},_unsubscribeIronResize:function(target){target.removeEventListener("iron-resize",this._boundOnDescendantIronResize)},resizerShouldNotify:function(element){return true},_onDescendantIronResize:function(event){if(this._notifyingDescendant){event.stopPropagation();return}if(!useShadow){this._fireResize()}},_fireResize:function(){this.fire("iron-resize",null,{node:this,bubbles:false})},_onIronRequestResizeNotifications:function(event){var target=dom(event).rootTarget;if(target===this){return}target.assignParentResizable(this);this._notifyDescendant(target);event.stopPropagation()},_parentResizableChanged:function(parentResizable){if(parentResizable){window.removeEventListener("resize",this._boundNotifyResize)}},_notifyDescendant:function(descendant){if(!this.isAttached){return}this._notifyingDescendant=true;descendant.notifyResize();this._notifyingDescendant=false},_requestResizeNotifications:function(){if(!this.isAttached){return}if(document.readyState==="loading"){var _requestResizeNotifications=this._requestResizeNotifications.bind(this);document.addEventListener("readystatechange",(function readystatechanged(){document.removeEventListener("readystatechange",readystatechanged);_requestResizeNotifications()}))}else{this._findParent();if(!this._parentResizable){ORPHANS.forEach((function(orphan){if(orphan!==this){orphan._findParent()}}),this);window.addEventListener("resize",this._boundNotifyResize);this.notifyResize()}else{this._parentResizable._interestedResizables.forEach((function(resizable){if(resizable!==this){resizable._findParent()}}),this)}}},_findParent:function(){this.assignParentResizable(null);this.fire("iron-request-resize-notifications",null,{node:this,bubbles:true,cancelable:true});if(!this._parentResizable){ORPHANS.add(this)}else{ORPHANS.delete(this)}}};
/**
@license
Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/const IronScrollTargetBehavior={properties:{scrollTarget:{type:HTMLElement,value:function(){return this._defaultScrollTarget}}},observers:["_scrollTargetChanged(scrollTarget, isAttached)"],_shouldHaveListener:true,_scrollTargetChanged:function(scrollTarget,isAttached){if(this._oldScrollTarget){this._toggleScrollListener(false,this._oldScrollTarget);this._oldScrollTarget=null}if(!isAttached){return}if(scrollTarget==="document"){this.scrollTarget=this._doc}else if(typeof scrollTarget==="string"){var domHost=this.domHost;this.scrollTarget=domHost&&domHost.$?domHost.$[scrollTarget]:dom(this.ownerDocument).querySelector("#"+scrollTarget)}else if(this._isValidScrollTarget()){this._oldScrollTarget=scrollTarget;this._toggleScrollListener(this._shouldHaveListener,scrollTarget)}},_scrollHandler:function scrollHandler(){},get _defaultScrollTarget(){return this._doc},get _doc(){return this.ownerDocument.documentElement},get _scrollTop(){if(this._isValidScrollTarget()){return this.scrollTarget===this._doc?window.pageYOffset:this.scrollTarget.scrollTop}return 0},get _scrollLeft(){if(this._isValidScrollTarget()){return this.scrollTarget===this._doc?window.pageXOffset:this.scrollTarget.scrollLeft}return 0},set _scrollTop(top){if(this.scrollTarget===this._doc){window.scrollTo(window.pageXOffset,top)}else if(this._isValidScrollTarget()){this.scrollTarget.scrollTop=top}},set _scrollLeft(left){if(this.scrollTarget===this._doc){window.scrollTo(left,window.pageYOffset)}else if(this._isValidScrollTarget()){this.scrollTarget.scrollLeft=left}},scroll:function(leftOrOptions,top){var left;if(typeof leftOrOptions==="object"){left=leftOrOptions.left;top=leftOrOptions.top}else{left=leftOrOptions}left=left||0;top=top||0;if(this.scrollTarget===this._doc){window.scrollTo(left,top)}else if(this._isValidScrollTarget()){this.scrollTarget.scrollLeft=left;this.scrollTarget.scrollTop=top}},get _scrollTargetWidth(){if(this._isValidScrollTarget()){return this.scrollTarget===this._doc?window.innerWidth:this.scrollTarget.offsetWidth}return 0},get _scrollTargetHeight(){if(this._isValidScrollTarget()){return this.scrollTarget===this._doc?window.innerHeight:this.scrollTarget.offsetHeight}return 0},_isValidScrollTarget:function(){return this.scrollTarget instanceof HTMLElement},_toggleScrollListener:function(yes,scrollTarget){var eventTarget=scrollTarget===this._doc?window:scrollTarget;if(yes){if(!this._boundScrollHandler){this._boundScrollHandler=this._scrollHandler.bind(this);eventTarget.addEventListener("scroll",this._boundScrollHandler)}}else{if(this._boundScrollHandler){eventTarget.removeEventListener("scroll",this._boundScrollHandler);this._boundScrollHandler=null}}},toggleScrollListener:function(yes){this._shouldHaveListener=yes;this._toggleScrollListener(yes,this.scrollTarget)}};
/**
@license
Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/var IOS=navigator.userAgent.match(/iP(?:hone|ad;(?: U;)? CPU) OS (\d+)/);var IOS_TOUCH_SCROLLING=IOS&&IOS[1]>=8;var DEFAULT_PHYSICAL_COUNT=3;var HIDDEN_Y="-10000px";var SECRET_TABINDEX=-100;Polymer({_template:html$1`
    <style>
      :host {
        display: block;
      }

      @media only screen and (-webkit-max-device-pixel-ratio: 1) {
        :host {
          will-change: transform;
        }
      }

      #items {
        position: relative;
      }

      :host(:not([grid])) #items > ::slotted(*) {
        width: 100%;
      }

      #items > ::slotted(*) {
        box-sizing: border-box;
        margin: 0;
        position: absolute;
        top: 0;
        will-change: transform;
      }
    </style>

    <array-selector id="selector" items="{{items}}" selected="{{selectedItems}}" selected-item="{{selectedItem}}"></array-selector>

    <div id="items">
      <slot></slot>
    </div>
`,is:"iron-list",properties:{items:{type:Array},as:{type:String,value:"item"},indexAs:{type:String,value:"index"},selectedAs:{type:String,value:"selected"},grid:{type:Boolean,value:false,reflectToAttribute:true,observer:"_gridChanged"},selectionEnabled:{type:Boolean,value:false},selectedItem:{type:Object,notify:true},selectedItems:{type:Object,notify:true},multiSelection:{type:Boolean,value:false},scrollOffset:{type:Number,value:0},preserveFocus:{type:Boolean,value:false}},observers:["_itemsChanged(items.*)","_selectionEnabledChanged(selectionEnabled)","_multiSelectionChanged(multiSelection)","_setOverflow(scrollTarget, scrollOffset)"],behaviors:[Templatizer,IronResizableBehavior,IronScrollTargetBehavior,OptionalMutableDataBehavior],_ratio:.5,_scrollerPaddingTop:0,_scrollPosition:0,_physicalSize:0,_physicalAverage:0,_physicalAverageCount:0,_physicalTop:0,_virtualCount:0,_estScrollHeight:0,_scrollHeight:0,_viewportHeight:0,_viewportWidth:0,_physicalItems:null,_physicalSizes:null,_firstVisibleIndexVal:null,_lastVisibleIndexVal:null,_maxPages:2,_focusedItem:null,_focusedVirtualIndex:-1,_focusedPhysicalIndex:-1,_offscreenFocusedItem:null,_focusBackfillItem:null,_itemsPerRow:1,_itemWidth:0,_rowHeight:0,_templateCost:0,_parentModel:true,get _physicalBottom(){return this._physicalTop+this._physicalSize},get _scrollBottom(){return this._scrollPosition+this._viewportHeight},get _virtualEnd(){return this._virtualStart+this._physicalCount-1},get _hiddenContentSize(){var size=this.grid?this._physicalRows*this._rowHeight:this._physicalSize;return size-this._viewportHeight},get _itemsParent(){return dom(dom(this._userTemplate).parentNode)},get _maxScrollTop(){return this._estScrollHeight-this._viewportHeight+this._scrollOffset},get _maxVirtualStart(){var virtualCount=this._convertIndexToCompleteRow(this._virtualCount);return Math.max(0,virtualCount-this._physicalCount)},set _virtualStart(val){val=this._clamp(val,0,this._maxVirtualStart);if(this.grid){val=val-val%this._itemsPerRow}this._virtualStartVal=val},get _virtualStart(){return this._virtualStartVal||0},set _physicalStart(val){val=val%this._physicalCount;if(val<0){val=this._physicalCount+val}if(this.grid){val=val-val%this._itemsPerRow}this._physicalStartVal=val},get _physicalStart(){return this._physicalStartVal||0},get _physicalEnd(){return(this._physicalStart+this._physicalCount-1)%this._physicalCount},set _physicalCount(val){this._physicalCountVal=val},get _physicalCount(){return this._physicalCountVal||0},get _optPhysicalSize(){return this._viewportHeight===0?Infinity:this._viewportHeight*this._maxPages},get _isVisible(){return Boolean(this.offsetWidth||this.offsetHeight)},get firstVisibleIndex(){var idx=this._firstVisibleIndexVal;if(idx==null){var physicalOffset=this._physicalTop+this._scrollOffset;idx=this._iterateItems((function(pidx,vidx){physicalOffset+=this._getPhysicalSizeIncrement(pidx);if(physicalOffset>this._scrollPosition){return this.grid?vidx-vidx%this._itemsPerRow:vidx}if(this.grid&&this._virtualCount-1===vidx){return vidx-vidx%this._itemsPerRow}}))||0;this._firstVisibleIndexVal=idx}return idx},get lastVisibleIndex(){var idx=this._lastVisibleIndexVal;if(idx==null){if(this.grid){idx=Math.min(this._virtualCount,this.firstVisibleIndex+this._estRowsInView*this._itemsPerRow-1)}else{var physicalOffset=this._physicalTop+this._scrollOffset;this._iterateItems((function(pidx,vidx){if(physicalOffset<this._scrollBottom){idx=vidx}physicalOffset+=this._getPhysicalSizeIncrement(pidx)}))}this._lastVisibleIndexVal=idx}return idx},get _defaultScrollTarget(){return this},get _virtualRowCount(){return Math.ceil(this._virtualCount/this._itemsPerRow)},get _estRowsInView(){return Math.ceil(this._viewportHeight/this._rowHeight)},get _physicalRows(){return Math.ceil(this._physicalCount/this._itemsPerRow)},get _scrollOffset(){return this._scrollerPaddingTop+this.scrollOffset},ready:function(){this.addEventListener("focus",this._didFocus.bind(this),true)},attached:function(){this._debounce("_render",this._render,animationFrame);this.listen(this,"iron-resize","_resizeHandler");this.listen(this,"keydown","_keydownHandler")},detached:function(){this.unlisten(this,"iron-resize","_resizeHandler");this.unlisten(this,"keydown","_keydownHandler")},_setOverflow:function(scrollTarget){this.style.webkitOverflowScrolling=scrollTarget===this?"touch":"";this.style.overflowY=scrollTarget===this?"auto":"";this._lastVisibleIndexVal=null;this._firstVisibleIndexVal=null;this._debounce("_render",this._render,animationFrame)},updateViewportBoundaries:function(){var styles=window.getComputedStyle(this);this._scrollerPaddingTop=this.scrollTarget===this?0:parseInt(styles["padding-top"],10);this._isRTL=Boolean(styles.direction==="rtl");this._viewportWidth=this.$.items.offsetWidth;this._viewportHeight=this._scrollTargetHeight;this.grid&&this._updateGridMetrics()},_scrollHandler:function(){var scrollTop=Math.max(0,Math.min(this._maxScrollTop,this._scrollTop));var delta=scrollTop-this._scrollPosition;var isScrollingDown=delta>=0;this._scrollPosition=scrollTop;this._firstVisibleIndexVal=null;this._lastVisibleIndexVal=null;if(Math.abs(delta)>this._physicalSize&&this._physicalSize>0){delta=delta-this._scrollOffset;var idxAdjustment=Math.round(delta/this._physicalAverage)*this._itemsPerRow;this._virtualStart=this._virtualStart+idxAdjustment;this._physicalStart=this._physicalStart+idxAdjustment;this._physicalTop=Math.min(Math.floor(this._virtualStart/this._itemsPerRow)*this._physicalAverage,this._scrollPosition);this._update()}else if(this._physicalCount>0){var reusables=this._getReusables(isScrollingDown);if(isScrollingDown){this._physicalTop=reusables.physicalTop;this._virtualStart=this._virtualStart+reusables.indexes.length;this._physicalStart=this._physicalStart+reusables.indexes.length}else{this._virtualStart=this._virtualStart-reusables.indexes.length;this._physicalStart=this._physicalStart-reusables.indexes.length}this._update(reusables.indexes,isScrollingDown?null:reusables.indexes);this._debounce("_increasePoolIfNeeded",this._increasePoolIfNeeded.bind(this,0),microTask)}},_getReusables:function(fromTop){var ith,offsetContent,physicalItemHeight;var idxs=[];var protectedOffsetContent=this._hiddenContentSize*this._ratio;var virtualStart=this._virtualStart;var virtualEnd=this._virtualEnd;var physicalCount=this._physicalCount;var top=this._physicalTop+this._scrollOffset;var bottom=this._physicalBottom+this._scrollOffset;var scrollTop=this._scrollPosition;var scrollBottom=this._scrollBottom;if(fromTop){ith=this._physicalStart;this._physicalEnd;offsetContent=scrollTop-top}else{ith=this._physicalEnd;this._physicalStart;offsetContent=bottom-scrollBottom}while(true){physicalItemHeight=this._getPhysicalSizeIncrement(ith);offsetContent=offsetContent-physicalItemHeight;if(idxs.length>=physicalCount||offsetContent<=protectedOffsetContent){break}if(fromTop){if(virtualEnd+idxs.length+1>=this._virtualCount){break}if(top+physicalItemHeight>=scrollTop-this._scrollOffset){break}idxs.push(ith);top=top+physicalItemHeight;ith=(ith+1)%physicalCount}else{if(virtualStart-idxs.length<=0){break}if(top+this._physicalSize-physicalItemHeight<=scrollBottom){break}idxs.push(ith);top=top-physicalItemHeight;ith=ith===0?physicalCount-1:ith-1}}return{indexes:idxs,physicalTop:top-this._scrollOffset}},_update:function(itemSet,movingUp){if(itemSet&&itemSet.length===0||this._physicalCount===0){return}this._manageFocus();this._assignModels(itemSet);this._updateMetrics(itemSet);if(movingUp){while(movingUp.length){var idx=movingUp.pop();this._physicalTop-=this._getPhysicalSizeIncrement(idx)}}this._positionItems();this._updateScrollerSize()},_createPool:function(size){this._ensureTemplatized();var i,inst;var physicalItems=new Array(size);for(i=0;i<size;i++){inst=this.stamp(null);physicalItems[i]=inst.root.querySelector("*");this._itemsParent.appendChild(inst.root)}return physicalItems},_isClientFull:function(){return this._scrollBottom!=0&&this._physicalBottom-1>=this._scrollBottom&&this._physicalTop<=this._scrollPosition},_increasePoolIfNeeded:function(count){var nextPhysicalCount=this._clamp(this._physicalCount+count,DEFAULT_PHYSICAL_COUNT,this._virtualCount-this._virtualStart);nextPhysicalCount=this._convertIndexToCompleteRow(nextPhysicalCount);if(this.grid){var correction=nextPhysicalCount%this._itemsPerRow;if(correction&&nextPhysicalCount-correction<=this._physicalCount){nextPhysicalCount+=this._itemsPerRow}nextPhysicalCount-=correction}var delta=nextPhysicalCount-this._physicalCount;var nextIncrease=Math.round(this._physicalCount*.5);if(delta<0){return}if(delta>0){var ts=window.performance.now();[].push.apply(this._physicalItems,this._createPool(delta));for(var i=0;i<delta;i++){this._physicalSizes.push(0)}this._physicalCount=this._physicalCount+delta;if(this._physicalStart>this._physicalEnd&&this._isIndexRendered(this._focusedVirtualIndex)&&this._getPhysicalIndex(this._focusedVirtualIndex)<this._physicalEnd){this._physicalStart=this._physicalStart+delta}this._update();this._templateCost=(window.performance.now()-ts)/delta;nextIncrease=Math.round(this._physicalCount*.5)}if(this._virtualEnd>=this._virtualCount-1||nextIncrease===0);else if(!this._isClientFull()){this._debounce("_increasePoolIfNeeded",this._increasePoolIfNeeded.bind(this,nextIncrease),microTask)}else if(this._physicalSize<this._optPhysicalSize){this._debounce("_increasePoolIfNeeded",this._increasePoolIfNeeded.bind(this,this._clamp(Math.round(50/this._templateCost),1,nextIncrease)),idlePeriod)}},_render:function(){if(!this.isAttached||!this._isVisible){return}if(this._physicalCount!==0){var reusables=this._getReusables(true);this._physicalTop=reusables.physicalTop;this._virtualStart=this._virtualStart+reusables.indexes.length;this._physicalStart=this._physicalStart+reusables.indexes.length;this._update(reusables.indexes);this._update();this._increasePoolIfNeeded(0)}else if(this._virtualCount>0){this.updateViewportBoundaries();this._increasePoolIfNeeded(DEFAULT_PHYSICAL_COUNT)}},_ensureTemplatized:function(){if(this.ctor){return}this._userTemplate=this.queryEffectiveChildren("template");if(!this._userTemplate){console.warn("iron-list requires a template to be provided in light-dom")}var instanceProps={};instanceProps.__key__=true;instanceProps[this.as]=true;instanceProps[this.indexAs]=true;instanceProps[this.selectedAs]=true;instanceProps.tabIndex=true;this._instanceProps=instanceProps;this.templatize(this._userTemplate,this.mutableData)},_gridChanged:function(newGrid,oldGrid){if(typeof oldGrid==="undefined")return;this.notifyResize();flush();newGrid&&this._updateGridMetrics()},_getFocusedElement:function(){function doSearch(node,query){let result=null;let type=node.nodeType;if(type==Node.ELEMENT_NODE||type==Node.DOCUMENT_FRAGMENT_NODE)result=node.querySelector(query);if(result)return result;let child=node.firstChild;while(child!==null&&result===null){result=doSearch(child,query);child=child.nextSibling}if(result)return result;const shadowRoot=node.shadowRoot;return shadowRoot?doSearch(shadowRoot,query):null}const focusWithin=doSearch(this,":focus-within");return focusWithin?doSearch(focusWithin,":focus"):null},_itemsChanged:function(change){var rendering=/^items(\.splices){0,1}$/.test(change.path);var lastFocusedIndex,focusedElement;if(rendering&&this.preserveFocus){lastFocusedIndex=this._focusedVirtualIndex;focusedElement=this._getFocusedElement()}var preservingFocus=rendering&&this.preserveFocus&&focusedElement;if(change.path==="items"){this._virtualStart=0;this._physicalTop=0;this._virtualCount=this.items?this.items.length:0;this._physicalIndexForKey={};this._firstVisibleIndexVal=null;this._lastVisibleIndexVal=null;this._physicalCount=this._physicalCount||0;this._physicalItems=this._physicalItems||[];this._physicalSizes=this._physicalSizes||[];this._physicalStart=0;if(this._scrollTop>this._scrollOffset&&!preservingFocus){this._resetScrollPosition(0)}this._removeFocusedItem();this._debounce("_render",this._render,animationFrame)}else if(change.path==="items.splices"){this._adjustVirtualIndex(change.value.indexSplices);this._virtualCount=this.items?this.items.length:0;var itemAddedOrRemoved=change.value.indexSplices.some((function(splice){return splice.addedCount>0||splice.removed.length>0}));if(itemAddedOrRemoved){var activeElement=this._getActiveElement();if(this.contains(activeElement)){activeElement.blur()}}var affectedIndexRendered=change.value.indexSplices.some((function(splice){return splice.index+splice.addedCount>=this._virtualStart&&splice.index<=this._virtualEnd}),this);if(!this._isClientFull()||affectedIndexRendered){this._debounce("_render",this._render,animationFrame)}}else if(change.path!=="items.length"){this._forwardItemPath(change.path,change.value)}if(preservingFocus){flush();focusedElement.blur();this._focusPhysicalItem(Math.min(this.items.length-1,lastFocusedIndex));if(!this._isIndexVisible(this._focusedVirtualIndex)){this.scrollToIndex(this._focusedVirtualIndex)}}},_forwardItemPath:function(path,value){path=path.slice(6);var dot=path.indexOf(".");if(dot===-1){dot=path.length}var isIndexRendered;var pidx;var inst;var offscreenInstance=this.modelForElement(this._offscreenFocusedItem);var vidx=parseInt(path.substring(0,dot),10);isIndexRendered=this._isIndexRendered(vidx);if(isIndexRendered){pidx=this._getPhysicalIndex(vidx);inst=this.modelForElement(this._physicalItems[pidx])}else if(offscreenInstance){inst=offscreenInstance}if(!inst||inst[this.indexAs]!==vidx){return}path=path.substring(dot+1);path=this.as+(path?"."+path:"");inst._setPendingPropertyOrPath(path,value,false,true);inst._flushProperties&&inst._flushProperties();if(isIndexRendered){this._updateMetrics([pidx]);this._positionItems();this._updateScrollerSize()}},_adjustVirtualIndex:function(splices){splices.forEach((function(splice){splice.removed.forEach(this._removeItem,this);if(splice.index<this._virtualStart){var delta=Math.max(splice.addedCount-splice.removed.length,splice.index-this._virtualStart);this._virtualStart=this._virtualStart+delta;if(this._focusedVirtualIndex>=0){this._focusedVirtualIndex=this._focusedVirtualIndex+delta}}}),this)},_removeItem:function(item){this.$.selector.deselect(item);if(this._focusedItem&&this.modelForElement(this._focusedItem)[this.as]===item){this._removeFocusedItem()}},_iterateItems:function(fn,itemSet){var pidx,vidx,rtn,i;if(arguments.length===2&&itemSet){for(i=0;i<itemSet.length;i++){pidx=itemSet[i];vidx=this._computeVidx(pidx);if((rtn=fn.call(this,pidx,vidx))!=null){return rtn}}}else{pidx=this._physicalStart;vidx=this._virtualStart;for(;pidx<this._physicalCount;pidx++,vidx++){if((rtn=fn.call(this,pidx,vidx))!=null){return rtn}}for(pidx=0;pidx<this._physicalStart;pidx++,vidx++){if((rtn=fn.call(this,pidx,vidx))!=null){return rtn}}}},_computeVidx:function(pidx){if(pidx>=this._physicalStart){return this._virtualStart+(pidx-this._physicalStart)}return this._virtualStart+(this._physicalCount-this._physicalStart)+pidx},_assignModels:function(itemSet){this._iterateItems((function(pidx,vidx){var el=this._physicalItems[pidx];var item=this.items&&this.items[vidx];if(item!=null){var inst=this.modelForElement(el);inst.__key__=null;this._forwardProperty(inst,this.as,item);this._forwardProperty(inst,this.selectedAs,this.$.selector.isSelected(item));this._forwardProperty(inst,this.indexAs,vidx);this._forwardProperty(inst,"tabIndex",this._focusedVirtualIndex===vidx?0:-1);this._physicalIndexForKey[inst.__key__]=pidx;inst._flushProperties&&inst._flushProperties(true);el.removeAttribute("hidden")}else{el.setAttribute("hidden","")}}),itemSet)},_updateMetrics:function(itemSet){flush();var newPhysicalSize=0;var oldPhysicalSize=0;var prevAvgCount=this._physicalAverageCount;var prevPhysicalAvg=this._physicalAverage;this._iterateItems((function(pidx,vidx){oldPhysicalSize+=this._physicalSizes[pidx];this._physicalSizes[pidx]=this._physicalItems[pidx].offsetHeight;newPhysicalSize+=this._physicalSizes[pidx];this._physicalAverageCount+=this._physicalSizes[pidx]?1:0}),itemSet);if(this.grid){this._updateGridMetrics();this._physicalSize=Math.ceil(this._physicalCount/this._itemsPerRow)*this._rowHeight}else{oldPhysicalSize=this._itemsPerRow===1?oldPhysicalSize:Math.ceil(this._physicalCount/this._itemsPerRow)*this._rowHeight;this._physicalSize=this._physicalSize+newPhysicalSize-oldPhysicalSize;this._itemsPerRow=1}if(this._physicalAverageCount!==prevAvgCount){this._physicalAverage=Math.round((prevPhysicalAvg*prevAvgCount+newPhysicalSize)/this._physicalAverageCount)}},_updateGridMetrics:function(){this._itemWidth=this._physicalCount>0?this._physicalItems[0].getBoundingClientRect().width:200;this._rowHeight=this._physicalCount>0?this._physicalItems[0].offsetHeight:200;this._itemsPerRow=this._itemWidth?Math.floor(this._viewportWidth/this._itemWidth):this._itemsPerRow},_positionItems:function(){this._adjustScrollPosition();var y=this._physicalTop;if(this.grid){var totalItemWidth=this._itemsPerRow*this._itemWidth;var rowOffset=(this._viewportWidth-totalItemWidth)/2;this._iterateItems((function(pidx,vidx){var modulus=vidx%this._itemsPerRow;var x=Math.floor(modulus*this._itemWidth+rowOffset);if(this._isRTL){x=x*-1}this.translate3d(x+"px",y+"px",0,this._physicalItems[pidx]);if(this._shouldRenderNextRow(vidx)){y+=this._rowHeight}}))}else{const order=[];this._iterateItems((function(pidx,vidx){const item=this._physicalItems[pidx];this.translate3d(0,y+"px",0,item);y+=this._physicalSizes[pidx];const itemId=item.id;if(itemId){order.push(itemId)}}));if(order.length){this.setAttribute("aria-owns",order.join(" "))}}},_getPhysicalSizeIncrement:function(pidx){if(!this.grid){return this._physicalSizes[pidx]}if(this._computeVidx(pidx)%this._itemsPerRow!==this._itemsPerRow-1){return 0}return this._rowHeight},_shouldRenderNextRow:function(vidx){return vidx%this._itemsPerRow===this._itemsPerRow-1},_adjustScrollPosition:function(){var deltaHeight=this._virtualStart===0?this._physicalTop:Math.min(this._scrollPosition+this._physicalTop,0);if(deltaHeight!==0){this._physicalTop=this._physicalTop-deltaHeight;var scrollTop=this._scrollPosition;if(!IOS_TOUCH_SCROLLING&&scrollTop>0){this._resetScrollPosition(scrollTop-deltaHeight)}}},_resetScrollPosition:function(pos){if(this.scrollTarget&&pos>=0){this._scrollTop=pos;this._scrollPosition=this._scrollTop}},_updateScrollerSize:function(forceUpdate){if(this.grid){this._estScrollHeight=this._virtualRowCount*this._rowHeight}else{this._estScrollHeight=this._physicalBottom+Math.max(this._virtualCount-this._physicalCount-this._virtualStart,0)*this._physicalAverage}forceUpdate=forceUpdate||this._scrollHeight===0;forceUpdate=forceUpdate||this._scrollPosition>=this._estScrollHeight-this._physicalSize;forceUpdate=forceUpdate||this.grid&&this.$.items.style.height<this._estScrollHeight;if(forceUpdate||Math.abs(this._estScrollHeight-this._scrollHeight)>=this._viewportHeight){this.$.items.style.height=this._estScrollHeight+"px";this._scrollHeight=this._estScrollHeight}},scrollToItem:function(item){return this.scrollToIndex(this.items.indexOf(item))},scrollToIndex:function(idx){if(typeof idx!=="number"||idx<0||idx>this.items.length-1){return}flush();if(this._physicalCount===0){return}idx=this._clamp(idx,0,this._virtualCount-1);if(!this._isIndexRendered(idx)||idx>=this._maxVirtualStart){this._virtualStart=this.grid?idx-this._itemsPerRow*2:idx-1}this._manageFocus();this._assignModels();this._updateMetrics();this._physicalTop=Math.floor(this._virtualStart/this._itemsPerRow)*this._physicalAverage;var currentTopItem=this._physicalStart;var currentVirtualItem=this._virtualStart;var targetOffsetTop=0;var hiddenContentSize=this._hiddenContentSize;while(currentVirtualItem<idx&&targetOffsetTop<=hiddenContentSize){targetOffsetTop=targetOffsetTop+this._getPhysicalSizeIncrement(currentTopItem);currentTopItem=(currentTopItem+1)%this._physicalCount;currentVirtualItem++}this._updateScrollerSize(true);this._positionItems();this._resetScrollPosition(this._physicalTop+this._scrollOffset+targetOffsetTop);this._increasePoolIfNeeded(0);this._firstVisibleIndexVal=null;this._lastVisibleIndexVal=null},_resetAverage:function(){this._physicalAverage=0;this._physicalAverageCount=0},_resizeHandler:function(){this._debounce("_render",(function(){this._firstVisibleIndexVal=null;this._lastVisibleIndexVal=null;if(this._isVisible){this.updateViewportBoundaries();this.toggleScrollListener(true);this._resetAverage();this._render()}else{this.toggleScrollListener(false)}}),animationFrame)},selectItem:function(item){return this.selectIndex(this.items.indexOf(item))},selectIndex:function(index){if(index<0||index>=this._virtualCount){return}if(!this.multiSelection&&this.selectedItem){this.clearSelection()}if(this._isIndexRendered(index)){var model=this.modelForElement(this._physicalItems[this._getPhysicalIndex(index)]);if(model){model[this.selectedAs]=true}this.updateSizeForIndex(index)}this.$.selector.selectIndex(index)},deselectItem:function(item){return this.deselectIndex(this.items.indexOf(item))},deselectIndex:function(index){if(index<0||index>=this._virtualCount){return}if(this._isIndexRendered(index)){var model=this.modelForElement(this._physicalItems[this._getPhysicalIndex(index)]);model[this.selectedAs]=false;this.updateSizeForIndex(index)}this.$.selector.deselectIndex(index)},toggleSelectionForItem:function(item){return this.toggleSelectionForIndex(this.items.indexOf(item))},toggleSelectionForIndex:function(index){var isSelected=this.$.selector.isIndexSelected?this.$.selector.isIndexSelected(index):this.$.selector.isSelected(this.items[index]);isSelected?this.deselectIndex(index):this.selectIndex(index)},clearSelection:function(){this._iterateItems((function(pidx,vidx){this.modelForElement(this._physicalItems[pidx])[this.selectedAs]=false}));this.$.selector.clearSelection()},_selectionEnabledChanged:function(selectionEnabled){var handler=selectionEnabled?this.listen:this.unlisten;handler.call(this,this,"tap","_selectionHandler")},_selectionHandler:function(e){var model=this.modelForElement(e.target);if(!model){return}var modelTabIndex,activeElTabIndex;var target=dom(e).path[0];var activeEl=this._getActiveElement();var physicalItem=this._physicalItems[this._getPhysicalIndex(model[this.indexAs])];if(target.localName==="input"||target.localName==="button"||target.localName==="select"){return}modelTabIndex=model.tabIndex;model.tabIndex=SECRET_TABINDEX;activeElTabIndex=activeEl?activeEl.tabIndex:-1;model.tabIndex=modelTabIndex;if(activeEl&&physicalItem!==activeEl&&physicalItem.contains(activeEl)&&activeElTabIndex!==SECRET_TABINDEX){return}this.toggleSelectionForItem(model[this.as])},_multiSelectionChanged:function(multiSelection){this.clearSelection();this.$.selector.multi=multiSelection},updateSizeForItem:function(item){return this.updateSizeForIndex(this.items.indexOf(item))},updateSizeForIndex:function(index){if(!this._isIndexRendered(index)){return null}this._updateMetrics([this._getPhysicalIndex(index)]);this._positionItems();return null},_manageFocus:function(){var fidx=this._focusedVirtualIndex;if(fidx>=0&&fidx<this._virtualCount){if(this._isIndexRendered(fidx)){this._restoreFocusedItem()}else{this._createFocusBackfillItem()}}else if(this._virtualCount>0&&this._physicalCount>0){this._focusedPhysicalIndex=this._physicalStart;this._focusedVirtualIndex=this._virtualStart;this._focusedItem=this._physicalItems[this._physicalStart]}},_convertIndexToCompleteRow:function(idx){this._itemsPerRow=this._itemsPerRow||1;return this.grid?Math.ceil(idx/this._itemsPerRow)*this._itemsPerRow:idx},_isIndexRendered:function(idx){return idx>=this._virtualStart&&idx<=this._virtualEnd},_isIndexVisible:function(idx){return idx>=this.firstVisibleIndex&&idx<=this.lastVisibleIndex},_getPhysicalIndex:function(vidx){return(this._physicalStart+(vidx-this._virtualStart))%this._physicalCount},focusItem:function(idx){this._focusPhysicalItem(idx)},_focusPhysicalItem:function(idx){if(idx<0||idx>=this._virtualCount){return}this._restoreFocusedItem();if(!this._isIndexRendered(idx)){this.scrollToIndex(idx)}var physicalItem=this._physicalItems[this._getPhysicalIndex(idx)];var model=this.modelForElement(physicalItem);var focusable;model.tabIndex=SECRET_TABINDEX;if(physicalItem.tabIndex===SECRET_TABINDEX){focusable=physicalItem}if(!focusable){focusable=dom(physicalItem).querySelector('[tabindex="'+SECRET_TABINDEX+'"]')}model.tabIndex=0;this._focusedVirtualIndex=idx;focusable&&focusable.focus()},_removeFocusedItem:function(){if(this._offscreenFocusedItem){this._itemsParent.removeChild(this._offscreenFocusedItem)}this._offscreenFocusedItem=null;this._focusBackfillItem=null;this._focusedItem=null;this._focusedVirtualIndex=-1;this._focusedPhysicalIndex=-1},_createFocusBackfillItem:function(){var fpidx=this._focusedPhysicalIndex;if(this._offscreenFocusedItem||this._focusedVirtualIndex<0){return}if(!this._focusBackfillItem){var inst=this.stamp(null);this._focusBackfillItem=inst.root.querySelector("*");this._itemsParent.appendChild(inst.root)}this._offscreenFocusedItem=this._physicalItems[fpidx];this.modelForElement(this._offscreenFocusedItem).tabIndex=0;this._physicalItems[fpidx]=this._focusBackfillItem;this._focusedPhysicalIndex=fpidx;this.translate3d(0,HIDDEN_Y,0,this._offscreenFocusedItem)},_restoreFocusedItem:function(){if(!this._offscreenFocusedItem||this._focusedVirtualIndex<0){return}this._assignModels();var fpidx=this._focusedPhysicalIndex=this._getPhysicalIndex(this._focusedVirtualIndex);var onScreenItem=this._physicalItems[fpidx];if(!onScreenItem){return}var onScreenInstance=this.modelForElement(onScreenItem);var offScreenInstance=this.modelForElement(this._offscreenFocusedItem);if(onScreenInstance[this.as]===offScreenInstance[this.as]){this._focusBackfillItem=onScreenItem;onScreenInstance.tabIndex=-1;this._physicalItems[fpidx]=this._offscreenFocusedItem;this.translate3d(0,HIDDEN_Y,0,this._focusBackfillItem)}else{this._removeFocusedItem();this._focusBackfillItem=null}this._offscreenFocusedItem=null},_didFocus:function(e){var targetModel=this.modelForElement(e.target);var focusedModel=this.modelForElement(this._focusedItem);var hasOffscreenFocusedItem=this._offscreenFocusedItem!==null;var fidx=this._focusedVirtualIndex;if(!targetModel){return}if(focusedModel!==targetModel){this._restoreFocusedItem();if(focusedModel){focusedModel.tabIndex=-1}targetModel.tabIndex=0;fidx=targetModel[this.indexAs];this._focusedVirtualIndex=fidx;this._focusedPhysicalIndex=this._getPhysicalIndex(fidx);this._focusedItem=this._physicalItems[this._focusedPhysicalIndex];if(hasOffscreenFocusedItem&&!this._offscreenFocusedItem){this._update()}}},_keydownHandler:function(e){switch(e.keyCode){case 40:if(this._focusedVirtualIndex<this._virtualCount-1)e.preventDefault();this._focusPhysicalItem(this._focusedVirtualIndex+(this.grid?this._itemsPerRow:1));break;case 39:if(this.grid)this._focusPhysicalItem(this._focusedVirtualIndex+(this._isRTL?-1:1));break;case 38:if(this._focusedVirtualIndex>0)e.preventDefault();this._focusPhysicalItem(this._focusedVirtualIndex-(this.grid?this._itemsPerRow:1));break;case 37:if(this.grid)this._focusPhysicalItem(this._focusedVirtualIndex+(this._isRTL?1:-1));break;case 13:this._focusPhysicalItem(this._focusedVirtualIndex);if(this.selectionEnabled)this._selectionHandler(e);break}},_clamp:function(v,min,max){return Math.min(max,Math.max(min,v))},_debounce:function(name,cb,asyncModule){this._debouncers=this._debouncers||{};this._debouncers[name]=Debouncer.debounce(this._debouncers[name],asyncModule,cb.bind(this));enqueueDebouncer(this._debouncers[name])},_forwardProperty:function(inst,name,value){inst._setPendingProperty(name,value)},_forwardHostPropV2:function(prop,value){(this._physicalItems||[]).concat([this._offscreenFocusedItem,this._focusBackfillItem]).forEach((function(item){if(item){this.modelForElement(item).forwardHostProp(prop,value)}}),this)},_notifyInstancePropV2:function(inst,prop,value){if(matches(this.as,prop)){var idx=inst[this.indexAs];if(prop==this.as){this.items[idx]=value}this.notifyPath(translate(this.as,"items."+idx,prop),value)}},_getStampedChildren:function(){return this._physicalItems},_forwardInstancePath:function(inst,path,value){if(path.indexOf(this.as+".")===0){this.notifyPath("items."+inst.__key__+"."+path.slice(this.as.length+1),value)}},_forwardParentPath:function(path,value){(this._physicalItems||[]).concat([this._offscreenFocusedItem,this._focusBackfillItem]).forEach((function(item){if(item){this.modelForElement(item).notifyPath(path,value)}}),this)},_forwardParentProp:function(prop,value){(this._physicalItems||[]).concat([this._offscreenFocusedItem,this._focusBackfillItem]).forEach((function(item){if(item){this.modelForElement(item)[prop]=value}}),this)},_getActiveElement:function(){var itemsHost=this._itemsParent.node.domHost;return dom(itemsHost?itemsHost.root:document).activeElement}});
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ScrollableMixin=dedupingMixin((superClass=>{class ScrollableMixin extends superClass{resizeObserver_;constructor(...args){super(...args);this.resizeObserver_=new ResizeObserver((entries=>{requestAnimationFrame((()=>{for(const entry of entries){this.onScrollableContainerResize_(entry.target)}}))}))}ready(){super.ready();beforeNextRender(this,(()=>{this.requestUpdateScroll();const scrollableElements=this.shadowRoot.querySelectorAll("[scrollable]");for(const scrollableElement of scrollableElements){scrollableElement.addEventListener("scroll",this.updateScrollEvent_.bind(this))}}))}disconnectedCallback(){super.disconnectedCallback();this.resizeObserver_.disconnect()}updateScrollableContents(){this.requestUpdateScroll();const ironLists=this.shadowRoot.querySelectorAll("[scrollable] iron-list");for(const ironList of ironLists){const scrollContainer=ironList.parentElement;const scrollHeight=scrollContainer.scrollHeight;if(scrollHeight<=1&&ironList.items.length>0&&window.getComputedStyle(scrollContainer).display!=="none"){this.resizeObserver_.observe(scrollContainer)}if(scrollHeight!==0){ironList.notifyResize()}}}requestUpdateScroll(){requestAnimationFrame((()=>{const scrollableElements=this.shadowRoot.querySelectorAll("[scrollable]");for(const scrollableElement of scrollableElements){this.updateScroll_(scrollableElement)}}))}saveScroll(list){list.savedScrollTops=list.savedScrollTops||[];list.savedScrollTops.push(list.scrollTarget.scrollTop)}restoreScroll(list){microTask.run((()=>{const scrollTop=list.savedScrollTops.shift();if(scrollTop!==0){list.scroll(0,scrollTop)}}))}updateScrollEvent_(event){const scrollable=event.target;this.updateScroll_(scrollable)}updateScroll_(scrollable){scrollable.classList.toggle("can-scroll",scrollable.clientHeight<scrollable.scrollHeight);scrollable.classList.toggle("is-scrolled",scrollable.scrollTop>0);scrollable.classList.toggle("scrolled-to-bottom",scrollable.scrollTop+scrollable.clientHeight>=scrollable.scrollHeight)}onScrollableContainerResize_(scrollable){const nodeList=scrollable.querySelectorAll("iron-list");if(nodeList.length===0||scrollable.scrollHeight>1){this.resizeObserver_.unobserve(scrollable)}if(scrollable.scrollHeight!==0){for(const node of nodeList){node.notifyResize()}}}}return ScrollableMixin}));
// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ACTIVE_CLASS="focus-row-active";class FocusRow{root;delegate;eventTracker=new EventTracker;boundary_;constructor(root,boundary,delegate){this.root=root;this.boundary_=boundary||document.documentElement;this.delegate=delegate}static isFocusable(element){if(!element||element.disabled){return false}let current=element;while(true){assertInstanceof(current,Element);const style=window.getComputedStyle(current);if(style.visibility==="hidden"||style.display==="none"){return false}const parent=current.parentNode;if(!parent){return false}if(parent===current.ownerDocument||parent instanceof DocumentFragment){return true}current=parent}}static getFocusableElement(element){const withFocusable=element;if(withFocusable.getFocusableElement){return withFocusable.getFocusableElement()}return element}addItem(type,selectorOrElement){assert(type);let element;if(typeof selectorOrElement==="string"){element=this.root.querySelector(selectorOrElement)}else{element=selectorOrElement}if(!element){return false}element.setAttribute("focus-type",type);element.tabIndex=this.isActive()?0:-1;this.eventTracker.add(element,"blur",this.onBlur_.bind(this));this.eventTracker.add(element,"focus",this.onFocus_.bind(this));this.eventTracker.add(element,"keydown",this.onKeydown_.bind(this));this.eventTracker.add(element,"mousedown",this.onMousedown_.bind(this));return true}destroy(){this.eventTracker.removeAll()}getCustomEquivalent(_sampleElement){const focusable=this.getFirstFocusable();assert(focusable);return focusable}getElements(){return Array.from(this.root.querySelectorAll("[focus-type]")).map(FocusRow.getFocusableElement)}getEquivalentElement(sampleElement){if(this.getFocusableElements().indexOf(sampleElement)>=0){return sampleElement}const sampleFocusType=this.getTypeForElement(sampleElement);if(sampleFocusType){const sameType=this.getFirstFocusable(sampleFocusType);if(sameType){return sameType}}return this.getCustomEquivalent(sampleElement)}getFirstFocusable(type){const element=this.getFocusableElements().find((el=>!type||el.getAttribute("focus-type")===type));return element||null}getFocusableElements(){return this.getElements().filter(FocusRow.isFocusable)}getTypeForElement(element){return element.getAttribute("focus-type")||""}isActive(){return this.root.classList.contains(ACTIVE_CLASS)}makeActive(active){if(active===this.isActive()){return}this.getElements().forEach((function(element){element.tabIndex=active?0:-1}));this.root.classList.toggle(ACTIVE_CLASS,active)}onBlur_(e){if(!this.boundary_.contains(e.relatedTarget)){return}const currentTarget=e.currentTarget;if(this.getFocusableElements().indexOf(currentTarget)>=0){this.makeActive(false)}}onFocus_(e){if(this.delegate){this.delegate.onFocus(this,e)}}onMousedown_(e){if(e.button){return}const target=e.currentTarget;if(!target.disabled){target.tabIndex=0}}onKeydown_(e){const elements=this.getFocusableElements();const currentElement=FocusRow.getFocusableElement(e.currentTarget);const elementIndex=elements.indexOf(currentElement);assert(elementIndex>=0);if(this.delegate&&this.delegate.onKeydown(this,e)){return}const isShiftTab=!e.altKey&&!e.ctrlKey&&!e.metaKey&&e.shiftKey&&e.key==="Tab";if(hasKeyModifiers(e)&&!isShiftTab){return}let index=-1;let shouldStopPropagation=true;if(isShiftTab){index=elementIndex-1;if(index<0){return}}else if(e.key==="ArrowLeft"){index=elementIndex+(isRTL()?1:-1)}else if(e.key==="ArrowRight"){index=elementIndex+(isRTL()?-1:1)}else if(e.key==="Home"){index=0}else if(e.key==="End"){index=elements.length-1}else{shouldStopPropagation=false}const elementToFocus=elements[index];if(elementToFocus){this.getEquivalentElement(elementToFocus).focus();e.preventDefault()}if(shouldStopPropagation){e.stopPropagation()}}}class VirtualFocusRow extends FocusRow{constructor(root,delegate){super(root,null,delegate)}getCustomEquivalent(sampleElement){const equivalent=this.delegate?this.delegate.getCustomEquivalent(sampleElement):null;return equivalent||super.getCustomEquivalent(sampleElement)}}let instance$j=null;function getCss$7(){return instance$j||(instance$j=[...[],css`:host{--cr-hairline:1px solid var(--color-menu-separator,var(--cr-fallback-color-divider));--cr-action-menu-disabled-item-color:var(--color-menu-item-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-action-menu-disabled-item-opacity:1;--cr-menu-background-color:var(--color-menu-background,var(--cr-fallback-color-surface));--cr-menu-background-focus-color:var(--cr-hover-background-color);--cr-menu-shadow:var(--cr-elevation-2);--cr-primary-text-color:var(--color-menu-item-foreground,var(--cr-fallback-color-on-surface))}:host dialog{background-color:var(--cr-menu-background-color);border:none;border-radius:var(--cr-menu-border-radius,4px);box-shadow:var(--cr-menu-shadow);margin:0;min-width:128px;outline:none;overflow:var(--cr-action-menu-overflow,auto);padding:0;position:absolute}@media (forced-colors:active){:host dialog{border:var(--cr-border-hcm)}}:host dialog::backdrop{background-color:transparent}:host ::slotted(.dropdown-item){-webkit-tap-highlight-color:transparent;background:none;border:none;border-radius:0;box-sizing:border-box;color:var(--cr-primary-text-color);font:inherit;min-height:32px;padding:8px 24px;text-align:start;user-select:none;width:100%}:host ::slotted(.dropdown-item:not([hidden])){align-items:center;display:flex}:host ::slotted(.dropdown-item[disabled]){color:var(--cr-action-menu-disabled-item-color,var(--cr-primary-text-color));opacity:var(--cr-action-menu-disabled-item-opacity,0.65)}:host ::slotted(.dropdown-item:not([disabled])){cursor:pointer}:host ::slotted(.dropdown-item:focus){background-color:var(--cr-menu-background-focus-color);outline:none}:host ::slotted(.dropdown-item:focus-visible){outline:solid 2px var(--cr-focus-outline-color);outline-offset:-2px}@media (forced-colors:active){:host ::slotted(.dropdown-item:focus){outline:var(--cr-focus-outline-hcm)}}.item-wrapper{outline:none;padding:var(--cr-action-menu-padding,8px 0)}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$7(){return html`
<dialog id="dialog" part="dialog" @close="${this.onNativeDialogClose_}"
    role="application"
    aria-roledescription="${this.roleDescription||nothing}">
  <div id="wrapper" class="item-wrapper" role="menu" tabindex="-1"
      aria-label="${this.accessibilityLabel||nothing}">
    <slot id="contentNode" @slotchange="${this.onSlotchange_}"></slot>
  </div>
</dialog>`}
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var AnchorAlignment;(function(AnchorAlignment){AnchorAlignment[AnchorAlignment["BEFORE_START"]=-2]="BEFORE_START";AnchorAlignment[AnchorAlignment["AFTER_START"]=-1]="AFTER_START";AnchorAlignment[AnchorAlignment["CENTER"]=0]="CENTER";AnchorAlignment[AnchorAlignment["BEFORE_END"]=1]="BEFORE_END";AnchorAlignment[AnchorAlignment["AFTER_END"]=2]="AFTER_END"})(AnchorAlignment||(AnchorAlignment={}));const DROPDOWN_ITEM_CLASS="dropdown-item";const SELECTABLE_DROPDOWN_ITEM_QUERY=`.${DROPDOWN_ITEM_CLASS}:not([hidden]):not([disabled])`;const AFTER_END_OFFSET=10;function getStartPointWithAnchor(start,end,menuLength,anchorAlignment,min,max){let startPoint=0;switch(anchorAlignment){case AnchorAlignment.BEFORE_START:startPoint=start-menuLength;break;case AnchorAlignment.AFTER_START:startPoint=start;break;case AnchorAlignment.CENTER:startPoint=(start+end-menuLength)/2;break;case AnchorAlignment.BEFORE_END:startPoint=end-menuLength;break;case AnchorAlignment.AFTER_END:startPoint=end;break}if(startPoint+menuLength>max){startPoint=end-menuLength}if(startPoint<min){startPoint=start}startPoint=Math.max(min,Math.min(startPoint,max-menuLength));return startPoint}function getDefaultShowConfig(){return{top:0,left:0,height:0,width:0,anchorAlignmentX:AnchorAlignment.AFTER_START,anchorAlignmentY:AnchorAlignment.AFTER_START,minX:0,minY:0,maxX:0,maxY:0}}class CrActionMenuElement extends CrLitElement{static get is(){return"cr-action-menu"}static get styles(){return getCss$7()}render(){return getHtml$7.bind(this)()}static get properties(){return{accessibilityLabel:{type:String},autoReposition:{type:Boolean},open:{type:Boolean,notify:true},roleDescription:{type:String}}}#accessibilityLabel_accessor_storage;get accessibilityLabel(){return this.#accessibilityLabel_accessor_storage}set accessibilityLabel(value){this.#accessibilityLabel_accessor_storage=value}#autoReposition_accessor_storage=false;get autoReposition(){return this.#autoReposition_accessor_storage}set autoReposition(value){this.#autoReposition_accessor_storage=value}#open_accessor_storage=false;get open(){return this.#open_accessor_storage}set open(value){this.#open_accessor_storage=value}#roleDescription_accessor_storage;get roleDescription(){return this.#roleDescription_accessor_storage}set roleDescription(value){this.#roleDescription_accessor_storage=value}boundClose_=null;resizeObserver_=null;hasMousemoveListener_=false;anchorElement_=null;lastConfig_=null;firstUpdated(){this.addEventListener("keydown",this.onKeyDown_.bind(this));this.addEventListener("mouseover",this.onMouseover_);this.addEventListener("click",this.onClick_)}disconnectedCallback(){super.disconnectedCallback();this.removeListeners_()}getDialog(){return this.$.dialog}removeListeners_(){window.removeEventListener("resize",this.boundClose_);window.removeEventListener("popstate",this.boundClose_);if(this.resizeObserver_){this.resizeObserver_.disconnect();this.resizeObserver_=null}}onNativeDialogClose_(e){if(e.target!==this.$.dialog){return}this.fire("close")}onClick_(e){if(e.target===this){this.close();e.stopPropagation()}}onKeyDown_(e){e.stopPropagation();if(e.key==="Tab"||e.key==="Escape"){this.close();if(e.key==="Tab"){this.fire("tabkeyclose",{shiftKey:e.shiftKey})}e.preventDefault();return}if(e.key!=="Enter"&&e.key!=="ArrowUp"&&e.key!=="ArrowDown"){return}const options=Array.from(this.querySelectorAll(SELECTABLE_DROPDOWN_ITEM_QUERY));if(options.length===0){return}const focused=getDeepActiveElement();const index=options.findIndex((option=>FocusRow.getFocusableElement(option)===focused));if(e.key==="Enter"){if(index!==-1){return}if(isWindows||isMac){this.close();e.preventDefault();return}}e.preventDefault();this.updateFocus_(options,index,e.key!=="ArrowUp");if(!this.hasMousemoveListener_){this.hasMousemoveListener_=true;this.addEventListener("mousemove",(e=>{this.onMouseover_(e);this.hasMousemoveListener_=false}),{once:true})}}onMouseover_(e){const item=e.composedPath().find((el=>el.matches&&el.matches(SELECTABLE_DROPDOWN_ITEM_QUERY)));(item||this.$.wrapper).focus()}updateFocus_(options,focusedIndex,next){const numOptions=options.length;assert(numOptions>0);let index;if(focusedIndex===-1){index=next?0:numOptions-1}else{const delta=next?1:-1;index=(numOptions+focusedIndex+delta)%numOptions}options[index].focus()}close(){if(!this.open){return}this.removeListeners_();this.$.dialog.close();this.open=false;if(this.anchorElement_){assert(this.anchorElement_);focusWithoutInk(this.anchorElement_);this.anchorElement_=null}if(this.lastConfig_){this.lastConfig_=null}}showAt(anchorElement,config){this.anchorElement_=anchorElement;this.anchorElement_.scrollIntoViewIfNeeded();const rect=this.anchorElement_.getBoundingClientRect();let height=rect.height;if(config&&!config.noOffset&&config.anchorAlignmentY===AnchorAlignment.AFTER_END){height-=AFTER_END_OFFSET}this.showAtPosition(Object.assign({top:rect.top,left:rect.left,height:height,width:rect.width,anchorAlignmentX:AnchorAlignment.BEFORE_END},config));this.$.wrapper.focus()}showAtPosition(config){const doc=document.scrollingElement;const scrollLeft=doc.scrollLeft;const scrollTop=doc.scrollTop;this.resetStyle_();this.$.dialog.showModal();this.open=true;config.top+=scrollTop;config.left+=scrollLeft;this.positionDialog_(Object.assign({minX:scrollLeft,minY:scrollTop,maxX:scrollLeft+doc.clientWidth,maxY:scrollTop+doc.clientHeight},config));doc.scrollTop=scrollTop;doc.scrollLeft=scrollLeft;this.addListeners_();const openedByKey=FocusOutlineManager.forDocument(document).visible;if(openedByKey){const firstSelectableItem=this.querySelector(SELECTABLE_DROPDOWN_ITEM_QUERY);if(firstSelectableItem){requestAnimationFrame((()=>{firstSelectableItem.focus()}))}}}resetStyle_(){this.$.dialog.style.left="";this.$.dialog.style.right="";this.$.dialog.style.top="0"}positionDialog_(config){this.lastConfig_=config;const c=Object.assign(getDefaultShowConfig(),config);const top=c.top;const left=c.left;const bottom=top+c.height;const right=left+c.width;const rtl=getComputedStyle(this).direction==="rtl";if(rtl){c.anchorAlignmentX*=-1}const offsetWidth=this.$.dialog.offsetWidth;const menuLeft=getStartPointWithAnchor(left,right,offsetWidth,c.anchorAlignmentX,c.minX,c.maxX);if(rtl){const menuRight=document.scrollingElement.clientWidth-menuLeft-offsetWidth;this.$.dialog.style.right=menuRight+"px"}else{this.$.dialog.style.left=menuLeft+"px"}const menuTop=getStartPointWithAnchor(top,bottom,this.$.dialog.offsetHeight,c.anchorAlignmentY,c.minY,c.maxY);this.$.dialog.style.top=menuTop+"px"}onSlotchange_(){for(const node of this.$.contentNode.assignedElements({flatten:true})){if(node.classList.contains(DROPDOWN_ITEM_CLASS)&&!node.getAttribute("role")){node.setAttribute("role","menuitem")}}}addListeners_(){this.boundClose_=this.boundClose_||(()=>{if(this.$.dialog.open){this.close()}});window.addEventListener("resize",this.boundClose_);window.addEventListener("popstate",this.boundClose_);if(this.autoReposition){this.resizeObserver_=new ResizeObserver((()=>{if(this.lastConfig_){this.positionDialog_(this.lastConfig_);this.fire("cr-action-menu-repositioned")}}));this.resizeObserver_.observe(this.$.dialog)}}}customElements.define(CrActionMenuElement.is,CrActionMenuElement);
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class CrLazyRenderElement extends PolymerElement{static get is(){return"cr-lazy-render"}static get template(){return html$1`<slot></slot>`}child_=null;instance_=null;get(){if(!this.child_){this.render_()}assert(this.child_);return this.child_}getIfExists(){return this.child_}render_(){const template=this.shadowRoot.querySelector("slot").assignedNodes({flatten:true}).filter((n=>n.nodeType===Node.ELEMENT_NODE))[0];const TemplateClass=templatize(template,this,{mutableData:false,forwardHostProp:this._forwardHostPropV2});const parentNode=this.parentNode;if(parentNode&&!this.child_){this.instance_=new TemplateClass;this.child_=this.instance_.root.firstElementChild;parentNode.insertBefore(this.instance_.root,this)}}_forwardHostPropV2(prop,value){if(this.instance_){this.instance_.forwardHostProp(prop,value)}}}customElements.define(CrLazyRenderElement.is,CrLazyRenderElement);
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getSupportedScaleFactors(){const supportedScaleFactors=[];if(!isIOS){supportedScaleFactors.push(1)}if(!isIOS&&!isAndroid){supportedScaleFactors.push(2)}else{supportedScaleFactors.push(window.devicePixelRatio)}return supportedScaleFactors}function getUrlForCss(s){const s2=s.replace(/(\(|\)|\,|\s|\'|\"|\\)/g,"\\$1");return`url("${s2}")`}function getImageSet(path){const supportedScaleFactors=getSupportedScaleFactors();const replaceStartIndex=path.indexOf("SCALEFACTOR");if(replaceStartIndex<0){return getUrlForCss(path)}let s="";for(let i=0;i<supportedScaleFactors.length;++i){const scaleFactor=supportedScaleFactors[i];const pathWithScaleFactor=path.substr(0,replaceStartIndex)+scaleFactor+path.substr(replaceStartIndex+"scalefactor".length);s+=getUrlForCss(pathWithScaleFactor)+" "+scaleFactor+"x";if(i!==supportedScaleFactors.length-1){s+=", "}}return"image-set("+s+")"}function getImage(path){const chromeThemePath="chrome://theme";const isChromeThemeUrl=path.slice(0,chromeThemePath.length)===chromeThemePath;return isChromeThemeUrl?getImageSet(path+"@SCALEFACTORx"):getUrlForCss(path)}function getBaseFaviconUrl(){const faviconUrl=new URL("chrome://favicon2/");faviconUrl.searchParams.set("size","16");faviconUrl.searchParams.set("scaleFactor","SCALEFACTORx");return faviconUrl}function getFavicon(url){const faviconUrl=getBaseFaviconUrl();faviconUrl.searchParams.set("iconUrl",url);return getImageSet(faviconUrl.toString())}function getDefaultFaviconUrlParams(){return{isSyncedUrlForHistoryUi:false,remoteIconUrlForUma:"",size:16,forceLightMode:false,fallbackToHost:true,forceEmptyDefaultFavicon:false,scaleFactor:""}}function getFaviconUrl(url,optionalParams){const params=Object.assign(getDefaultFaviconUrlParams(),optionalParams);const faviconUrl=getBaseFaviconUrl();faviconUrl.searchParams.set("pageUrl",url);faviconUrl.searchParams.set("size",params.size.toString());const fallback=params.isSyncedUrlForHistoryUi?"1":"0";faviconUrl.searchParams.set("allowGoogleServerFallback",fallback);if(params.isSyncedUrlForHistoryUi){faviconUrl.searchParams.set("iconUrl",params.remoteIconUrlForUma)}if(params.forceLightMode){faviconUrl.searchParams.set("forceLightMode","true")}if(!params.fallbackToHost){faviconUrl.searchParams.set("fallbackToHost","0")}if(params.forceEmptyDefaultFavicon){faviconUrl.searchParams.set("forceEmptyDefaultFavicon","1")}if(params.scaleFactor){faviconUrl.searchParams.set("scaleFactor",params.scaleFactor)}return faviconUrl.toString()}function getFaviconForPageURL(url,isSyncedUrlForHistoryUi,remoteIconUrlForUma="",size=16,forceLightMode=false,fallbackToHost=true,forceEmptyDefaultFavicon=false,scaleFactor=""){return getImageSet(getFaviconUrl(url,{isSyncedUrlForHistoryUi:isSyncedUrlForHistoryUi,remoteIconUrlForUma:remoteIconUrlForUma,size:size,forceLightMode:forceLightMode,fallbackToHost:fallbackToHost,forceEmptyDefaultFavicon:forceEmptyDefaultFavicon,scaleFactor:scaleFactor}))}function getTemplate$j(){return html$1`<!--_html_template_start_-->    <style>#favicon{background-repeat:no-repeat;background-size:contain;border-radius:var(--site-favicon-border-radius,inherit);display:block;height:var(--site-favicon-height,16px);width:var(--site-favicon-width,16px)}
    </style>
    <div
        id="favicon"
        style="background-image:
            [[getBackgroundImage_(faviconUrl, url, iconPath)]]">
    </div>
<!--_html_template_end_-->`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SiteFaviconElement extends PolymerElement{static get is(){return"site-favicon"}static get template(){return getTemplate$j()}static get properties(){return{faviconUrl:String,url:String,iconPath:String}}getBackgroundImage_(){let backgroundImage=getFavicon("");if(this.iconPath){backgroundImage="url("+this.iconPath+")"}else if(this.faviconUrl){const url=this.ensureUrlHasScheme_(this.faviconUrl);backgroundImage=getFavicon(url)}else if(this.url){let url=this.removePatternWildcard_(this.url);url=this.ensureUrlHasScheme_(url);backgroundImage=getFaviconForPageURL(url||"",false)}return backgroundImage}removePatternWildcard_(pattern){if(!pattern||pattern.length===0){return pattern}if(pattern.startsWith("http://[*.]")){return pattern.replace("http://[*.]","http://")}else if(pattern.startsWith("https://[*.]")){return pattern.replace("https://[*.]","https://")}else if(pattern.startsWith("[*.]")){return pattern.substring(4,pattern.length)}return pattern}ensureUrlHasScheme_(url){if(!url||url.length===0){return url}return url.includes("://")?url:"http://"+url}}customElements.define(SiteFaviconElement.is,SiteFaviconElement);
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class FocusRowMixinDelegate{listItem_;constructor(listItem){this.listItem_=listItem}onFocus(_row,e){const element=e.composedPath()[0];const focusableElement=FocusRow.getFocusableElement(element);if(element!==focusableElement){focusableElement.focus()}this.listItem_.lastFocused=focusableElement}onKeydown(_row,e){if(e.key==="Enter"){e.stopPropagation()}return false}getCustomEquivalent(sampleElement){return this.listItem_.overrideCustomEquivalent?this.listItem_.getCustomEquivalent(sampleElement):null}}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const FocusRowMixin=dedupingMixin((superClass=>{class FocusRowMixin extends superClass{static get properties(){return{row_:{type:Object,value:null},mouseFocused_:{type:Boolean,value:false},id:{type:String,reflectToAttribute:true},isFocused:{type:Boolean,notify:true,value:false},focusRowIndex:{type:Number,observer:"focusRowIndexChanged"},lastFocused:{type:Object,notify:true,value:null},ironListTabIndex:{type:Number,observer:"ironListTabIndexChanged_"},listBlurred:{type:Boolean,notify:true,value:false}}}firstControl_=null;controlObservers_=[];boundOnFirstControlKeydown_=null;connectedCallback(){super.connectedCallback();this.classList.add("no-outline");this.boundOnFirstControlKeydown_=this.onFirstControlKeydown_.bind(this);afterNextRender(this,(()=>{const rowContainer=this.root.querySelector("[focus-row-container]");assert(rowContainer);this.row_=new VirtualFocusRow(rowContainer,new FocusRowMixinDelegate(this));this.addItems_();this.addEventListener("focus",this.onFocus_);this.addEventListener("dom-change",this.addItems_);this.addEventListener("mousedown",this.onMouseDown_);this.addEventListener("blur",this.onBlur_)}))}disconnectedCallback(){super.disconnectedCallback();this.removeEventListener("focus",this.onFocus_);this.removeEventListener("dom-change",this.addItems_);this.removeEventListener("mousedown",this.onMouseDown_);this.removeEventListener("blur",this.onBlur_);this.removeObservers_();if(this.firstControl_&&this.boundOnFirstControlKeydown_){this.firstControl_.removeEventListener("keydown",this.boundOnFirstControlKeydown_);this.boundOnFirstControlKeydown_=null}if(this.row_){this.row_.destroy()}}computeId_(index){return index!==undefined?`frb${index}`:undefined}focusRowIndexChanged(newIndex,oldIndex){this.setAttribute("aria-rowindex",(newIndex+1).toString());if(this.id===this.computeId_(oldIndex)){this.id=this.computeId_(newIndex)||""}}getFocusRow(){assert(this.row_);return this.row_}updateFirstControl_(){assert(this.row_);const newFirstControl=this.row_.getFirstFocusable();if(newFirstControl===this.firstControl_){return}if(this.firstControl_){this.firstControl_.removeEventListener("keydown",this.boundOnFirstControlKeydown_)}this.firstControl_=newFirstControl;if(this.firstControl_){this.firstControl_.addEventListener("keydown",this.boundOnFirstControlKeydown_)}}removeObservers_(){if(this.controlObservers_.length>0){this.controlObservers_.forEach((observer=>{observer.disconnect()}))}this.controlObservers_=[]}addItems_(){this.ironListTabIndexChanged_();if(this.row_){this.removeObservers_();this.row_.destroy();const controls=this.root.querySelectorAll("[focus-row-control]");controls.forEach((control=>{assert(control);assert(this.row_);this.row_.addItem(control.getAttribute("focus-type"),FocusRow.getFocusableElement(control));this.addMutationObservers_(control)}));this.updateFirstControl_()}}createObserver_(){return new MutationObserver((mutations=>{const mutation=mutations[0];if(mutation.attributeName==="style"&&mutation.oldValue){const newStyle=window.getComputedStyle(mutation.target);const oldDisplayValue=mutation.oldValue.match(/^display:(.*)(?=;)/);const oldVisibilityValue=mutation.oldValue.match(/^visibility:(.*)(?=;)/);if(oldDisplayValue&&newStyle.display===oldDisplayValue[1].trim()&&oldVisibilityValue&&newStyle.visibility===oldVisibilityValue[1].trim()){return}}this.updateFirstControl_()}))}addMutationObservers_(control){let current=control;while(current&&current!==this.root){const currentObserver=this.createObserver_();currentObserver.observe(current,{attributes:true,attributeFilter:["hidden","disabled","style"],attributeOldValue:true});this.controlObservers_.push(currentObserver);current=current.parentNode}}onFocus_(e){if(this.mouseFocused_){this.mouseFocused_=false;return}const restoreFocusToFirst=this.listBlurred&&e.composedPath()[0]===this;if(this.lastFocused&&!restoreFocusToFirst){assert(this.row_);focusWithoutInk(this.row_.getEquivalentElement(this.lastFocused))}else{assert(this.firstControl_);const firstFocusable=this.firstControl_;focusWithoutInk(firstFocusable)}this.listBlurred=false;this.isFocused=true}onFirstControlKeydown_(e){const keyEvent=e;if(keyEvent.shiftKey&&keyEvent.key==="Tab"){this.focus()}}ironListTabIndexChanged_(){if(this.row_){this.row_.makeActive(this.ironListTabIndex===0)}if(this.ironListTabIndex===0){this.listBlurred=false}}onMouseDown_(){this.mouseFocused_=true}onBlur_(e){this.mouseFocused_=false;this.isFocused=false;const node=e.relatedTarget?e.relatedTarget:null;if(!this.parentNode.contains(node)){this.listBlurred=true}}}return FocusRowMixin}));let instance$i=null;function getCss$6(){return instance$i||(instance$i=[...[],css`:host{--cr-toast-background:var(--color-toast-background,var(--cr-fallback-color-inverse-surface));--cr-toast-button-color:var(--color-toast-button,var(--cr-fallback-color-inverse-primary));--cr-toast-text-color:var(--color-toast-foreground,var(--cr-fallback-color-inverse-on-surface));--cr-focus-outline-color:var(--cr-focus-outline-inverse-color)}:host{align-items:center;background:var(--cr-toast-background);border-radius:8px;bottom:0;box-shadow:0 2px 4px 0 rgba(0,0,0,0.28);box-sizing:border-box;display:flex;line-height:20px;margin:24px;max-width:var(--cr-toast-max-width,568px);min-height:52px;min-width:288px;opacity:0;padding:0 16px;position:fixed;transform:translateY(100px);transition:opacity 300ms,transform 300ms;visibility:hidden;z-index:1}:host-context([dir=ltr]){left:0}:host-context([dir=rtl]){right:0}:host([open]){opacity:1;transform:translateY(0);visibility:visible}:host(:not([open])) ::slotted(*){display:none}:host ::slotted(*){color:var(--cr-toast-text-color)}:host ::slotted(cr-button){background-color:transparent !important;border:none !important;color:var(--cr-toast-button-color) !important;margin-inline-start:32px !important;min-width:52px !important;padding:8px !important}:host ::slotted(cr-button:hover){background-color:transparent !important}::slotted(cr-button:last-of-type){margin-inline-end:-8px}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$6(){return html`<slot></slot>`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class CrToastElement extends CrLitElement{static get is(){return"cr-toast"}static get styles(){return getCss$6()}render(){return getHtml$6.bind(this)()}static get properties(){return{duration:{type:Number},open:{type:Boolean,reflect:true}}}#duration_accessor_storage=0;get duration(){return this.#duration_accessor_storage}set duration(value){this.#duration_accessor_storage=value}#open_accessor_storage=false;get open(){return this.#open_accessor_storage}set open(value){this.#open_accessor_storage=value}hideTimeoutId_=null;constructor(){super();this.addEventListener("focusin",this.clearTimeout_);this.addEventListener("focusout",this.resetAutoHide_)}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("duration")||changedProperties.has("open")){this.resetAutoHide_()}}clearTimeout_(){if(this.hideTimeoutId_!==null){window.clearTimeout(this.hideTimeoutId_);this.hideTimeoutId_=null}}resetAutoHide_(){this.clearTimeout_();if(this.open&&this.duration!==0){this.hideTimeoutId_=window.setTimeout((()=>{this.hide()}),this.duration)}}async show(){const shouldResetAutohide=this.open;this.removeAttribute("role");this.open=true;await this.updateComplete;this.setAttribute("role","alert");if(shouldResetAutohide){this.resetAutoHide_()}}async hide(){this.open=false;await this.updateComplete}}customElements.define(CrToastElement.is,CrToastElement);let instance$h=null;function getCss$5(){return instance$h||(instance$h=[...[getCss$x()],css``])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$5(){return html`
<cr-tooltip-icon ?hidden="${!this.getIndicatorVisible_()}"
    tooltip-text="${this.getIndicatorTooltip_()}"
    icon-class="${this.getIndicatorIcon_()}"
    icon-aria-label="${this.iconAriaLabel}">
</cr-tooltip-icon>`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class CrPolicyIndicatorElement extends CrLitElement{static get is(){return"cr-policy-indicator"}static get styles(){return getCss$5()}render(){return getHtml$5.bind(this)()}static get properties(){return{iconAriaLabel:{type:String},indicatorType:{type:String},indicatorSourceName:{type:String}}}#iconAriaLabel_accessor_storage="";get iconAriaLabel(){return this.#iconAriaLabel_accessor_storage}set iconAriaLabel(value){this.#iconAriaLabel_accessor_storage=value}#indicatorType_accessor_storage=CrPolicyIndicatorType.NONE;get indicatorType(){return this.#indicatorType_accessor_storage}set indicatorType(value){this.#indicatorType_accessor_storage=value}#indicatorSourceName_accessor_storage="";get indicatorSourceName(){return this.#indicatorSourceName_accessor_storage}set indicatorSourceName(value){this.#indicatorSourceName_accessor_storage=value}getIndicatorVisible_(){return this.indicatorType!==CrPolicyIndicatorType.NONE}getIndicatorIcon_(){switch(this.indicatorType){case CrPolicyIndicatorType.EXTENSION:return"cr:extension";case CrPolicyIndicatorType.NONE:return"";case CrPolicyIndicatorType.PRIMARY_USER:return"cr:group";case CrPolicyIndicatorType.OWNER:return"cr:person";case CrPolicyIndicatorType.USER_POLICY:case CrPolicyIndicatorType.DEVICE_POLICY:case CrPolicyIndicatorType.RECOMMENDED:return"cr20:domain";case CrPolicyIndicatorType.PARENT:case CrPolicyIndicatorType.CHILD_RESTRICTION:return"cr20:kite";default:assertNotReached()}}getIndicatorTooltip_(){if(!window.CrPolicyStrings){return""}const CrPolicyStrings=window.CrPolicyStrings;switch(this.indicatorType){case CrPolicyIndicatorType.EXTENSION:return this.indicatorSourceName.length>0?CrPolicyStrings.controlledSettingExtension.replace("$1",this.indicatorSourceName):CrPolicyStrings.controlledSettingExtensionWithoutName;case CrPolicyIndicatorType.USER_POLICY:case CrPolicyIndicatorType.DEVICE_POLICY:return CrPolicyStrings.controlledSettingPolicy;case CrPolicyIndicatorType.RECOMMENDED:return CrPolicyStrings.controlledSettingRecommendedDiffers;case CrPolicyIndicatorType.PARENT:return CrPolicyStrings.controlledSettingParent;case CrPolicyIndicatorType.CHILD_RESTRICTION:return CrPolicyStrings.controlledSettingChildRestriction}return""}}customElements.define(CrPolicyIndicatorElement.is,CrPolicyIndicatorElement);
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class ProfileInfoBrowserProxyImpl{getProfileInfo(){return sendWithPromise("getProfileInfo")}getProfileStatsCount(){chrome.send("getProfileStatsCount")}static getInstance(){return instance$g||(instance$g=new ProfileInfoBrowserProxyImpl)}static setInstance(obj){instance$g=obj}}let instance$g=null;
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var SignedInState;(function(SignedInState){SignedInState[SignedInState["SIGNED_OUT"]=0]="SIGNED_OUT";SignedInState[SignedInState["SIGNED_IN"]=1]="SIGNED_IN";SignedInState[SignedInState["SYNCING"]=2]="SYNCING";SignedInState[SignedInState["SIGNED_IN_PAUSED"]=3]="SIGNED_IN_PAUSED";SignedInState[SignedInState["WEB_ONLY_SIGNED_IN"]=4]="WEB_ONLY_SIGNED_IN"})(SignedInState||(SignedInState={}));var StatusAction;(function(StatusAction){StatusAction["NO_ACTION"]="noAction";StatusAction["REAUTHENTICATE"]="reauthenticate";StatusAction["UPGRADE_CLIENT"]="upgradeClient";StatusAction["ENTER_PASSPHRASE"]="enterPassphrase";StatusAction["RETRIEVE_TRUSTED_VAULT_KEYS"]="retrieveTrustedVaultKeys";StatusAction["CONFIRM_SYNC_SETTINGS"]="confirmSyncSettings"})(StatusAction||(StatusAction={}));const syncPrefsIndividualDataTypes=["appsSynced","autofillSynced","bookmarksSynced","cookiesSynced","extensionsSynced","readingListSynced","passwordsSynced","paymentsSynced","preferencesSynced","productComparisonSynced","savedTabGroupsSynced","tabsSynced","themesSynced","typedUrlsSynced","wifiConfigurationsSynced"];var UserSelectableType;(function(UserSelectableType){UserSelectableType[UserSelectableType["BOOKMARKS"]=0]="BOOKMARKS";UserSelectableType[UserSelectableType["PREFERENCES"]=1]="PREFERENCES";UserSelectableType[UserSelectableType["PASSWORDS"]=2]="PASSWORDS";UserSelectableType[UserSelectableType["AUTOFILL"]=3]="AUTOFILL";UserSelectableType[UserSelectableType["THEMES"]=4]="THEMES";UserSelectableType[UserSelectableType["HISTORY"]=5]="HISTORY";UserSelectableType[UserSelectableType["EXTENSIONS"]=6]="EXTENSIONS";UserSelectableType[UserSelectableType["APPS"]=7]="APPS";UserSelectableType[UserSelectableType["READING_LIST"]=8]="READING_LIST";UserSelectableType[UserSelectableType["TABS"]=9]="TABS";UserSelectableType[UserSelectableType["SAVED_TAB_GROUPS"]=10]="SAVED_TAB_GROUPS";UserSelectableType[UserSelectableType["PAYMENTS"]=11]="PAYMENTS";UserSelectableType[UserSelectableType["PRODUCT_COMPARISON"]=12]="PRODUCT_COMPARISON";UserSelectableType[UserSelectableType["COOKIES"]=13]="COOKIES"})(UserSelectableType||(UserSelectableType={}));var PageStatus;(function(PageStatus){PageStatus["SPINNER"]="spinner";PageStatus["CONFIGURE"]="configure";PageStatus["DONE"]="done";PageStatus["PASSPHRASE_FAILED"]="passphraseFailed"})(PageStatus||(PageStatus={}));var TrustedVaultBannerState;(function(TrustedVaultBannerState){TrustedVaultBannerState[TrustedVaultBannerState["NOT_SHOWN"]=0]="NOT_SHOWN";TrustedVaultBannerState[TrustedVaultBannerState["OFFER_OPT_IN"]=1]="OFFER_OPT_IN";TrustedVaultBannerState[TrustedVaultBannerState["OPTED_IN"]=2]="OPTED_IN"})(TrustedVaultBannerState||(TrustedVaultBannerState={}));var ChromeSigninUserChoice;(function(ChromeSigninUserChoice){ChromeSigninUserChoice[ChromeSigninUserChoice["NO_CHOICE"]=0]="NO_CHOICE";ChromeSigninUserChoice[ChromeSigninUserChoice["ALWAYS_ASK"]=1]="ALWAYS_ASK";ChromeSigninUserChoice[ChromeSigninUserChoice["SIGNIN"]=2]="SIGNIN";ChromeSigninUserChoice[ChromeSigninUserChoice["DO_NOT_SIGNIN"]=3]="DO_NOT_SIGNIN"})(ChromeSigninUserChoice||(ChromeSigninUserChoice={}));class SyncBrowserProxyImpl{startSignIn(){chrome.send("SyncSetupStartSignIn")}signOut(deleteProfile){chrome.send("SyncSetupSignout",[deleteProfile])}pauseSync(){chrome.send("SyncSetupPauseSync")}didNavigateToAccountSettingsPage(){chrome.send("ShowAccountSettingsUI")}setSyncDatatype(pref,value){return sendWithPromise("SetDatatype",pref,value)}startKeyRetrieval(){chrome.send("SyncStartKeyRetrieval")}showSyncPassphraseDialog(){chrome.send("SyncShowSyncPassphraseDialog")}getSyncStatus(){return sendWithPromise("SyncSetupGetSyncStatus")}getStoredAccounts(){return sendWithPromise("SyncSetupGetStoredAccounts")}getProfileAvatar(){return sendWithPromise("SyncSetupGetProfileAvatar")}didNavigateToSyncPage(){chrome.send("SyncSetupShowSetupUI")}didNavigateAwayFromSyncPage(didAbort){chrome.send("SyncSetupDidClosePage",[didAbort])}setSyncDatatypes(syncPrefs){return sendWithPromise("SyncSetupSetDatatypes",JSON.stringify(syncPrefs))}setEncryptionPassphrase(passphrase){return sendWithPromise("SyncSetupSetEncryptionPassphrase",passphrase)}setDecryptionPassphrase(passphrase){return sendWithPromise("SyncSetupSetDecryptionPassphrase",passphrase)}startSyncingWithEmail(email,isDefaultPromoAccount){chrome.send("SyncSetupStartSyncingWithEmail",[email,isDefaultPromoAccount])}openActivityControlsUrl(){chrome.metricsPrivate.recordUserAction("Signin_AccountSettings_GoogleActivityControlsClicked")}sendSyncPrefsChanged(){chrome.send("SyncPrefsDispatch")}sendTrustedVaultBannerStateChanged(){chrome.send("SyncTrustedVaultBannerStateDispatch")}setChromeSigninUserChoice(choice,signedInEmail){chrome.send("SetChromeSigninUserChoice",[choice,signedInEmail])}getChromeSigninUserChoiceInfo(){return sendWithPromise("GetChromeSigninUserChoiceInfo")}static getInstance(){return instance$f||(instance$f=new SyncBrowserProxyImpl)}static setInstance(obj){instance$f=obj}}let instance$f=null;function getTemplate$i(){return html$1`<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">:host{--shown-avatar-size:40px;--sync-icon-border-size:2px;--sync-icon-size:16px}:host([promo-type_="sync"]){h3{font-size:inherit;margin:0;font-weight:normal}#banner{background:url(chrome://settings/images/sync_banner.svg) no-repeat;background-size:100% auto;display:none;padding-top:calc(120 / 680 * 100%);display:block}@media (prefers-color-scheme:dark){#banner{background-image:url(chrome://settings/images/sync_banner_dark.svg)}}}:host([promo-type_="signin"]){h3{margin-top:4px;margin-bottom:4px;font-size:1rem;font-weight:500;letter-spacing:.25px}#banner{background:url(chrome://settings/images/signin_banner.svg) no-repeat;background-size:100% auto;display:none;padding-top:calc(120 / 680 * 100%);display:block}@media (prefers-color-scheme:dark){#banner{background-image:url(chrome://settings/images/signin_banner_dark.svg)}}}.account-icon{border-radius:50%;flex-shrink:0;height:var(--shown-avatar-size);width:var(--shown-avatar-size)}.account-icon.small{height:20px;width:20px}#menu .dropdown-item{padding:12px}#menu .dropdown-item span{margin-inline-start:8px}.flex{display:flex;flex:1;flex-direction:column}#avatar-container{height:var(--shown-avatar-size);position:relative}#sync-icon-container{align-items:center;background:var(--google-green-700);border:var(--sync-icon-border-size) solid white;border-radius:50%;display:flex;height:var(--sync-icon-size);position:absolute;right:-6px;top:calc(var(--shown-avatar-size) - var(--sync-icon-size) - var(--sync-icon-border-size));width:var(--sync-icon-size)}:host-context([dir='rtl']) #sync-icon-container{left:-6px;right:initial}@media (prefers-color-scheme:dark){#sync-icon-container{background:var(--google-green-300);border-color:var(--google-grey-900)}}#sync-icon-container.sync-problem{background:var(--settings-error-color)}#sync-icon-container.sync-paused{background:var(--google-blue-500)}@media (prefers-color-scheme:dark){#sync-icon-container.sync-paused{background:var(--google-blue-300)}}#sync-icon-container.sync-disabled{background:var(--google-grey-400)}@media (prefers-color-scheme:dark){#sync-icon-container.sync-disabled{background:var(--google-grey-500)}}#sync-icon-container cr-icon{fill:white;height:12px;margin:auto;width:12px}#signIn{min-width:100px}

    </style>
    <div id="banner" hidden="[[shouldHideBanner_(syncStatus.signedInState)]]"
        part="banner"></div>
    <div class="cr-row first"
        id="promo-header" hidden="[[shouldHideBanner_(
              syncStatus.signedInState)]]">
      <div class="flex cr-padded-text">
        <h3 id="promo-title" part="title">
          [[getLabel_(promoLabelWithAccount,
              promoLabelWithNoAccount, shownAccount_)]]
        </h3>
        <div class="secondary">[[subLabel_]]</div>
      </div>
      <cr-button class="action-button cr-button-gap" on-click="onSigninClick_"
          id="signIn"
          disabled="[[shouldDisableSyncButton_(showSetupButtons_,
                  syncStatus.firstSetupInProgress,
                  prefs.signin.allowed_on_next_startup.value)]]"
          hidden="[[shouldShowAvatarRow_]]">
        $i18n{peopleSignInNoAccountAwareness}
      </cr-button>
    </div>
    <template is="dom-if" if="[[shouldShowAvatarRow_]]">
      <div class="cr-row first two-line" id="avatar-row">
        <div id="avatar-container">
          <img class="account-icon" alt=""
              src="[[getProfileImageSrc_(
                shownAccount_.avatarImage,
                profileAvatarURL_)]]">
          <div id="sync-icon-container"
              hidden="[[!isSyncing_(syncStatus.signedInState)]]"
              class$="[[getSyncIconStyle_(
                  syncStatus.hasError, syncStatus.statusAction,
                  syncStatus.disabled)]]">
            <cr-icon icon$="[[getSyncIcon_(
                syncStatus.hasError, syncStatus.statusAction,
                syncStatus.disabled)]]"></cr-icon>
          </div>
        </div>
        <div class="cr-row-gap cr-padded-text flex no-min-width" id="user-info">
          <div class="text-elide">
            [[getAvatarRowTitle_(shownAccount_.fullName,
                '$i18nPolymer{syncNotWorking}',
                '$i18nPolymer{syncPasswordsNotWorking}',
                '$i18nPolymer{syncPaused}',
                '$i18nPolymer{syncDisabled}',
                '$i18nPolymer{accountAwareRowTitle}',
                syncStatus.hasError,
                syncStatus.statusAction, syncStatus.disabled)]]
          </div>
          <div class="secondary text-elide"
              hidden="[[shouldHideSubtitleWithAccountInfoText_(syncStatus)]]">
            [[getAccountLabel_(
                '$i18nPolymer{signedInTo}',
                '$i18nPolymer{syncingTo}',
                shownAccount_.email, syncStatus.hasError,
                syncStatus.signedInState, syncStatus.disabled,
                syncStatus.firstSetupInProgress,
                shownAccount_.isPrimaryAccount)]]
          </div>
          <div class="secondary"
              hidden="[[!shouldHideSubtitleWithAccountInfoText_(syncStatus)]]">
            [[getAvatarSubtitleLabel_(
              '$i18nPolymer{accountAwareRowSubtitle}',
              '$i18nPolymer{pendingStateAvatarRowSubtitle}',
              shownAccount_.email,
              this.syncStatus.signedInState)]]
          </div>
        </div>
        <cr-icon-button class="icon-arrow-dropdown cr-button-gap"
            hidden="[[!shouldAllowAccountSwitch_(syncStatus.signedInState,
                syncStatus.domain, syncStatus.signinPaused)]]"
            on-click="onMenuButtonClick_" id="dropdown-arrow"
            aria-label="$i18n{changeAccount}"
            aria-expanded="false">
        </cr-icon-button>
        <div class="separator"
            hidden="[[!shouldAllowAccountSwitch_(syncStatus.signedInState,
                syncStatus.domain, syncStatus.signinPaused)]]">
        </div>
        <cr-button id="signout-button" class="cr-button-gap"
            hidden="[[shouldHideSignoutButton_(syncStatus.signedInState)]]"
            on-click="onSignoutClick_">
          $i18n{signOutOfChrome}
        </cr-button>
        <cr-button id="sync-button" class="action-button cr-button-gap"
            hidden="[[shouldHideSyncButton_(syncStatus.signedInState,
                syncStatus.signinPaused)]]"
            on-click="onSyncButtonClick_"
            disabled="[[shouldDisableSyncButton_(showSetupButtons_,
                syncStatus.firstSetupInProgress,
                prefs.signin.allowed_on_next_startup.value)]]">
          $i18nPolymer{turnOnSync}
        </cr-button>
        <cr-button id="turn-off"
            class="cr-button-gap"
            hidden="[[!shouldShowTurnOffButton_(syncStatus.signedInState,
                syncStatus.domain, showSetupButtons_)]]"
            on-click="onTurnOffButtonClick_"
            disabled="[[syncStatus.firstSetupInProgress]]">
          [[getTurnOffSyncLabel_(
            '$i18nPolymer{turnOffSync}',
            syncStatus.secondaryButtonActionText)]]
        </cr-button>
        <cr-button id="sync-error-button" class="action-button cr-button-gap"
            hidden="[[!shouldShowErrorActionButton_(syncStatus,
            showSetupButtons_, syncStatus.statusAction)]]"
            on-click="onErrorButtonClick_"
            disabled="[[syncStatus.firstSetupInProgress]]">
          [[syncStatus.statusActionText]]
        </cr-button>
        <cr-button class="action-button cr-button-gap"
            on-click="onSyncButtonClick_" id="account-aware"
            hidden="[[!shouldShowAccountAwareSigninButton_(
                syncStatus.signedInState)]]">
        <img class="account-icon small" alt=""
        src="[[getAccountImageSrc_(shownAccount_.avatarImage)]]"
        slot="prefix-icon">
        [[getAccountAwareSigninButtonLabel_(
          '$i18nPolymer{accountAwareSigninButtonLabel}',
          shownAccount_.givenName)]]
        </cr-button>
        <div id="setup-buttons" hidden="[[!showSetupButtons_]]"
            class="cr-button-gap">
          <cr-button on-click="onSetupCancel_">$i18n{cancel}</cr-button>
          <cr-button class="action-button cr-button-gap"
              on-click="onSetupConfirm_">
            $i18n{confirm}
          </cr-button>
        </div>
        <div id="signin-paused-buttons"
            hidden="[[!shouldShowSigninPausedButtons_(
                syncStatus.signinPaused)]]">
          <cr-button class="cr-button-gap" id="remove-account-button"
              hidden="[[shouldHideRemoveAccountButton_(
                  syncStatus.signedInState)]]"
              on-click="onSignoutClick_">
            $i18n{pendingSecondaryButton}
          </cr-button>
          <cr-button class="action-button cr-button-gap"
              on-click="onSigninClick_">
            $i18n{verifyAccount}
          </cr-button>
        </div>

      </div>
      <template is="dom-if"
          if="[[shouldAllowAccountSwitch_(syncStatus.signedInState,
              syncStatus.domain, syncStatus.signinPaused)]]" restamp>
        <cr-action-menu id="menu" auto-reposition
            role-description="$i18n{menu}" on-close="onDropdownClose_">
          <template is="dom-repeat" items="[[storedAccounts_]]">
            <button class="dropdown-item" on-click="onAccountClick_">
              <img class="account-icon small" alt=""
                  src="[[getAccountImageSrc_(item.avatarImage)]]">
              <span>[[item.email]]</span>
            </button>
          </template>
          <button class="dropdown-item" on-click="onSigninClick_"
                  disabled="[[syncStatus.firstSetupInProgress]]"
                  id="sign-in-item">
            <cr-icon icon="cr:add" class="account-icon small" alt=""></cr-icon>
            <span>$i18n{useAnotherAccount}</span>
          </button>
        </cr-action-menu>
      </template>
    </template>
<!--_html_template_end_-->`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var PromoType;(function(PromoType){PromoType["SIGNIN"]="signin";PromoType["SYNC"]="sync"})(PromoType||(PromoType={}));const SettingsSyncAccountControlElementBase=WebUiListenerMixin(PrefsMixin(PolymerElement));class SettingsSyncAccountControlElement extends SettingsSyncAccountControlElementBase{static get is(){return"settings-sync-account-control"}static get template(){return getTemplate$i()}static get properties(){return{syncStatus:Object,promoLabelWithAccount:String,promoLabelWithNoAccount:String,promoSecondaryLabelWithAccount:String,promoSecondaryLabelWithNoAccount:String,syncing_:{type:Boolean,computed:"isSyncing_(syncStatus.signedInState)",observer:"onSyncChanged_"},storedAccounts_:Object,profileAvatarURL_:{type:String,value:null,observer:"handleUpdateAvatar_"},shownAccount_:Object,embeddedInSubpage:{type:Boolean,reflectToAttribute:true},hideButtons:{type:Boolean,value:false,reflectToAttribute:true},hideBanner:{type:Boolean,value:false,reflectToAttribute:true},shouldShowAvatarRow_:{type:Boolean,value:false,computed:"computeShouldShowAvatarRow_(storedAccounts_, syncStatus,"+"storedAccounts_.length, syncStatus.signedInState)",observer:"onShouldShowAvatarRowChange_"},subLabel_:{type:String,computed:"computeSubLabel_(promoSecondaryLabelWithAccount,"+"promoSecondaryLabelWithNoAccount, shownAccount_)"},showSetupButtons_:{type:Boolean,computed:"computeShowSetupButtons_("+"hideButtons, syncStatus.firstSetupInProgress)"},promoType_:{type:String,reflectToAttribute:true}}}static get observers(){return["onShownAccountShouldChange_(storedAccounts_, syncStatus)"]}syncBrowserProxy_=SyncBrowserProxyImpl.getInstance();connectedCallback(){super.connectedCallback();this.syncBrowserProxy_.getStoredAccounts().then(this.handleStoredAccounts_.bind(this));this.syncBrowserProxy_.getProfileAvatar().then(this.handleUpdateAvatar_.bind(this));this.addWebUiListener("stored-accounts-updated",this.handleStoredAccounts_.bind(this));this.addWebUiListener("profile-avatar-changed",this.handleUpdateAvatar_.bind(this));this.promoType_=loadTimeData.getBoolean("replaceSyncPromosWithSignInPromos")?PromoType.SIGNIN:PromoType.SYNC}recordImpressionUserActions_(){assert(!this.isSyncing_());chrome.metricsPrivate.recordUserAction("Signin_Impression_FromSettings")}onSyncChanged_(){if(this.embeddedInSubpage){return}if(!this.isSyncing_()&&this.shownAccount_!==undefined){this.recordImpressionUserActions_()}}getLabel_(labelWithAccount,labelWithNoAccount){return this.shownAccount_?labelWithAccount:labelWithNoAccount}computeSubLabel_(){return this.getLabel_(this.promoSecondaryLabelWithAccount,this.promoSecondaryLabelWithNoAccount)}getSubstituteLabel_(label,name){return loadTimeData.substituteString(label,name)}getAccountLabel_(signedInLabel,syncingLabel,email){if(this.syncStatus.signedInState===SignedInState.SIGNED_IN_PAUSED){return email}if(this.syncStatus.firstSetupInProgress){return this.syncStatus.statusText||email}if(this.isSyncing_()&&!this.syncStatus.hasError&&!this.syncStatus.disabled){return loadTimeData.substituteString(syncingLabel,email)}return this.shownAccount_&&this.shownAccount_.isPrimaryAccount&&this.promoType_===PromoType.SYNC?loadTimeData.substituteString(signedInLabel,email):email}shouldHideSubtitleWithAccountInfoText_(){if(this.hideButtons){return false}if(this.syncStatus.signedInState===SignedInState.SIGNED_IN_PAUSED){return true}if(this.syncStatus&&this.syncStatus.hasError&&this.syncStatus.statusText){return true}if(this.syncStatus.signedInState===SignedInState.WEB_ONLY_SIGNED_IN){return true}return false}getAvatarSubtitleLabel_(accountAwareRowSubtitle,pendingStateSubtitle,email){if(this.syncStatus.signedInState===SignedInState.WEB_ONLY_SIGNED_IN){return loadTimeData.substituteString(accountAwareRowSubtitle,email)}if(this.syncStatus.signedInState===SignedInState.SIGNED_IN_PAUSED){return loadTimeData.substituteString(pendingStateSubtitle,email)}if(this.syncStatus&&this.syncStatus.hasError&&this.syncStatus.statusText){if(this.syncStatus.statusAction===StatusAction.ENTER_PASSPHRASE){return loadTimeData.substituteString(this.syncStatus.statusText,email)}return this.syncStatus.statusText}return""}getAccountAwareSigninButtonLabel_(accountAwareSigninButtonLabel,givenName){return loadTimeData.substituteString(accountAwareSigninButtonLabel,givenName)}getProfileImageSrc_(image,profileAvatarURL){if(this.syncStatus.signedInState===SignedInState.WEB_ONLY_SIGNED_IN){return profileAvatarURL}return image||"chrome://theme/IDR_PROFILE_AVATAR_PLACEHOLDER_LARGE"}getAccountImageSrc_(image){return image||"chrome://theme/IDR_PROFILE_AVATAR_PLACEHOLDER_LARGE"}getSyncIconStyle_(){if(this.syncStatus.disabled){return"sync-disabled"}if(!this.syncStatus.hasError){return"sync"}if(this.syncStatus.hasUnrecoverableError){return"sync-problem"}if(this.syncStatus.statusAction===StatusAction.REAUTHENTICATE){return"sync-paused"}return"sync-problem"}getSyncIcon_(){switch(this.getSyncIconStyle_()){case"sync-problem":return"settings:sync-problem";case"sync-paused":return"settings:sync-disabled";default:return"cr:sync"}}getAvatarRowTitle_(accountName,syncErrorLabel,syncPasswordsOnlyErrorLabel,authErrorLabel,disabledLabel,webOnlySignedInAccountRowTitle){if(this.syncStatus.signedInState===SignedInState.WEB_ONLY_SIGNED_IN){return webOnlySignedInAccountRowTitle}if(this.syncStatus&&this.syncStatus.hasError&&this.syncStatus.statusText){return accountName}if(this.syncStatus.disabled){return disabledLabel}if(!this.syncStatus.hasError){return accountName}if(this.syncStatus.hasUnrecoverableError){return syncErrorLabel}if(this.syncStatus.statusAction===StatusAction.REAUTHENTICATE){return authErrorLabel}if(this.syncStatus.hasPasswordsOnlyError){return syncPasswordsOnlyErrorLabel}return syncErrorLabel}shouldHideSignoutButton_(){if(this.hideButtons){return true}if(this.syncStatus.domain){return true}return this.syncStatus.signedInState!==SignedInState.SIGNED_IN||this.syncStatus.statusAction!==StatusAction.NO_ACTION}shouldHideRemoveAccountButton_(){return!!this.syncStatus.domain}shouldDisableSyncButton_(){if(this.hideButtons||this.prefs===undefined){return this.computeShowSetupButtons_()}return!this.syncStatus||!!this.syncStatus.firstSetupInProgress||!this.getPref("signin.allowed_on_next_startup").value}shouldHideBanner_(){if(this.hideBanner){return true}if(this.syncStatus&&this.syncStatus.hasError&&this.syncStatus.statusText){return true}switch(this.syncStatus.signedInState){case SignedInState.SIGNED_IN:case SignedInState.SIGNED_OUT:case SignedInState.WEB_ONLY_SIGNED_IN:return false;case SignedInState.SYNCING:case SignedInState.SIGNED_IN_PAUSED:return true}assertNotReached("Invalid SignedInState")}shouldHideSyncButton_(){if(this.promoType_===PromoType.SIGNIN){return true}if(this.syncStatus.signedInState===SignedInState.WEB_ONLY_SIGNED_IN){return true}if(this.syncStatus.statusAction!==StatusAction.NO_ACTION){return true}return this.hideButtons||!!this.syncStatus&&(this.isSyncing_()||this.syncStatus.signedInState===SignedInState.SIGNED_IN_PAUSED)}shouldShowTurnOffButton_(){if(this.hideButtons||this.showSetupButtons_){return false}if(this.syncStatus.statusAction!==StatusAction.NO_ACTION){return true}return this.isSyncing_()}getTurnOffSyncLabel_(turnOffSync){if(this.syncStatus.hasError&&this.syncStatus.secondaryButtonActionText&&this.isSyncing_()){return this.syncStatus.secondaryButtonActionText}if(this.syncStatus.statusAction!==StatusAction.NO_ACTION&&this.syncStatus.secondaryButtonActionText){return this.syncStatus.secondaryButtonActionText}return turnOffSync}shouldShowErrorActionButton_(){if(this.hideButtons||this.showSetupButtons_){return false}if(this.embeddedInSubpage&&this.syncStatus.statusAction===StatusAction.ENTER_PASSPHRASE){return false}if(this.syncStatus.statusAction!==StatusAction.NO_ACTION){return true}return this.isSyncing_()&&!!this.syncStatus.hasError&&this.syncStatus.statusAction!==StatusAction.NO_ACTION}shouldShowAccountAwareSigninButton_(){return!this.hideButtons&&this.syncStatus.signedInState===SignedInState.WEB_ONLY_SIGNED_IN}shouldAllowAccountSwitch_(){if(this.hideButtons){return false}if(this.syncStatus.domain){return false}switch(this.syncStatus.signedInState){case SignedInState.SIGNED_OUT:case SignedInState.WEB_ONLY_SIGNED_IN:return true;case SignedInState.SIGNED_IN_PAUSED:case SignedInState.SYNCING:case SignedInState.SIGNED_IN:return false}assertNotReached("Invalid SignedInState")}handleStoredAccounts_(accounts){this.storedAccounts_=accounts}handleUpdateAvatar_(profileAvatarURL){this.profileAvatarURL_=profileAvatarURL}computeShouldShowAvatarRow_(){if(this.storedAccounts_===undefined||this.syncStatus===undefined){return false}if(this.syncStatus.signedInState===SignedInState.WEB_ONLY_SIGNED_IN){return true}return this.isSyncing_()||this.storedAccounts_.length>0}onErrorButtonClick_(){const router=Router.getInstance();const routes=router.getRoutes();switch(this.syncStatus.statusAction){case StatusAction.REAUTHENTICATE:this.syncBrowserProxy_.startSignIn();break;case StatusAction.UPGRADE_CLIENT:router.navigateTo(routes.ABOUT);break;case StatusAction.RETRIEVE_TRUSTED_VAULT_KEYS:this.syncBrowserProxy_.startKeyRetrieval();break;case StatusAction.ENTER_PASSPHRASE:this.syncBrowserProxy_.showSyncPassphraseDialog();break;case StatusAction.CONFIRM_SYNC_SETTINGS:default:router.navigateTo(routes.SYNC)}}onSigninClick_(){this.syncBrowserProxy_.startSignIn();const actionMenu=this.shadowRoot.querySelector("cr-action-menu");if(actionMenu){actionMenu.close()}}onSignoutClick_(){this.syncBrowserProxy_.signOut(false);const actionMenu=this.shadowRoot.querySelector("cr-action-menu");if(actionMenu){actionMenu.close()}}onDropdownClose_(){const menuAnchor=this.shadowRoot.querySelector("#dropdown-arrow");assert(menuAnchor);menuAnchor.setAttribute("aria-expanded","false")}onSyncButtonClick_(){assert(this.shownAccount_);assert(this.storedAccounts_.length>0);const isDefaultPromoAccount=this.shownAccount_.email===this.storedAccounts_[0].email;this.syncBrowserProxy_.startSyncingWithEmail(this.shownAccount_.email,isDefaultPromoAccount)}onTurnOffButtonClick_(){if(!this.isSyncing_()&&this.syncStatus.statusAction!==StatusAction.NO_ACTION){this.onSignoutClick_()}const router=Router.getInstance();router.navigateTo(router.getRoutes().SIGN_OUT)}onMenuButtonClick_(){const actionMenu=this.shadowRoot.querySelector("cr-action-menu");assert(actionMenu);const anchor=this.shadowRoot.querySelector("#dropdown-arrow");assert(anchor);actionMenu.showAt(anchor);anchor.setAttribute("aria-expanded","true")}onShouldShowAvatarRowChange_(){const actionMenu=this.shadowRoot.querySelector("cr-action-menu");if(!this.shouldShowAvatarRow_&&actionMenu&&actionMenu.open){actionMenu.close()}}onAccountClick_(e){this.shownAccount_=e.model.item;this.shadowRoot.querySelector("cr-action-menu").close()}onShownAccountShouldChange_(){if(this.storedAccounts_===undefined||this.syncStatus===undefined){return}if(this.isSyncing_()){for(let i=0;i<this.storedAccounts_.length;i++){if(this.storedAccounts_[i].email===this.syncStatus.signedInUsername){this.shownAccount_=this.storedAccounts_[i];return}}}else{const firstStoredAccount=this.storedAccounts_.length>0?this.storedAccounts_[0]:null;const shouldRecordImpression=this.shownAccount_===undefined||!this.shownAccount_&&firstStoredAccount||this.shownAccount_&&!firstStoredAccount;this.shownAccount_=firstStoredAccount;if(shouldRecordImpression){this.recordImpressionUserActions_()}}}computeShowSetupButtons_(){return!this.hideButtons&&!!this.syncStatus&&!!this.syncStatus.firstSetupInProgress}onSetupCancel_(){this.dispatchEvent(new CustomEvent("sync-setup-done",{bubbles:true,composed:true,detail:false}))}onSetupConfirm_(){this.dispatchEvent(new CustomEvent("sync-setup-done",{bubbles:true,composed:true,detail:true}))}shouldShowSigninPausedButtons_(){return!this.hideButtons&&!!this.syncStatus&&this.syncStatus.signedInState===SignedInState.SIGNED_IN_PAUSED}isSyncing_(){return this.syncStatus.signedInState===SignedInState.SYNCING}}customElements.define(SettingsSyncAccountControlElement.is,SettingsSyncAccountControlElement);
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ListPropertyUpdateMixin=dedupingMixin((superClass=>{class ListPropertyUpdateMixin extends superClass{updateList(propertyPath,identityGetter,updatedList,identityBasedUpdate=false){const list=this.get(propertyPath);const splices=calculateSplices(updatedList.map((item=>identityGetter(item))),list.map(identityGetter));splices.forEach((splice=>{const index=splice.index;const deleteCount=splice.removed.length;splice.removed=list.slice(index,index+deleteCount);splice.object=list;splice.type="splice";const added=updatedList.slice(index,index+splice.addedCount);const spliceParams=[index,deleteCount].concat(added);list.splice.apply(list,spliceParams)}));let updated=splices.length>0;if(!identityBasedUpdate){list.forEach(((item,index)=>{const updatedItem=updatedList[index];if(JSON.stringify(item)!==JSON.stringify(updatedItem)){this.set([propertyPath,index],updatedItem);updated=true}}))}if(splices.length>0){this.notifySplices(propertyPath,splices)}return updated}}return ListPropertyUpdateMixin}));
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const BaseMixin=dedupingMixin((superClass=>{class BaseMixin extends superClass{$$(query){return this.shadowRoot.querySelector(query)}fire(eventName,detail){this.dispatchEvent(new CustomEvent(eventName,{bubbles:true,composed:true,detail:detail}))}}return BaseMixin}));
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrSelectableMixin=superClass=>{class CrSelectableMixin extends superClass{static get properties(){return{attrForSelected:{type:String},selected:{type:String,notify:true},selectedAttribute:{type:String},selectable:{type:String}}}#attrForSelected_accessor_storage=null;get attrForSelected(){return this.#attrForSelected_accessor_storage}set attrForSelected(value){this.#attrForSelected_accessor_storage=value}#selectable_accessor_storage;get selectable(){return this.#selectable_accessor_storage}set selectable(value){this.#selectable_accessor_storage=value}#selected_accessor_storage;get selected(){return this.#selected_accessor_storage}set selected(value){this.#selected_accessor_storage=value}#selectedAttribute_accessor_storage=null;get selectedAttribute(){return this.#selectedAttribute_accessor_storage}set selectedAttribute(value){this.#selectedAttribute_accessor_storage=value}selectOnClick=true;items_=[];selectedItem_=null;firstUpdated(changedProperties){super.firstUpdated(changedProperties);if(this.selectOnClick){this.addEventListener("click",(e=>this.onClick_(e)))}this.observeItems()}observeItems(){this.getSlot().addEventListener("slotchange",(()=>this.itemsChanged()))}connectedCallback(){super.connectedCallback();this.updateItems_()}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("attrForSelected")){if(this.selectedItem_){assert(this.attrForSelected);const value=this.selectedItem_.getAttribute(this.attrForSelected);assert(value!==null);this.selected=value}}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("selected")){this.updateSelectedItem_()}}select(value){this.selected=value}selectPrevious(){const length=this.items_.length;let index=length-1;if(this.selected!==undefined){index=(this.valueToIndex_(this.selected)-1+length)%length}this.selected=this.indexToValue_(index)}selectNext(){const index=this.selected===undefined?0:(this.valueToIndex_(this.selected)+1)%this.items_.length;this.selected=this.indexToValue_(index)}getItemsForTest(){return this.items_}getSlot(){const slot=this.shadowRoot.querySelector("slot");assert(slot);return slot}queryItems(){const selectable=this.selectable===undefined?"*":this.selectable;return Array.from(this.querySelectorAll(`:scope > ${selectable}`))}queryMatchingItem(selector){const selectable=this.selectable||"*";return this.querySelector(`:scope > :is(${selectable})${selector}`)}updateItems_(){this.items_=this.queryItems();this.items_.forEach(((item,index)=>item.setAttribute("data-selection-index",index.toString())))}get selectedItem(){return this.selectedItem_}updateSelectedItem_(){if(!this.items_){return}const item=this.selected==null?null:this.items_[this.valueToIndex_(this.selected)];if(!!item&&this.selectedItem_!==item){this.setItemSelected_(this.selectedItem_,false);this.setItemSelected_(item,true)}else if(!item){this.setItemSelected_(this.selectedItem_,false)}}setItemSelected_(item,isSelected){if(!item){return}item.classList.toggle("selected",isSelected);if(this.selectedAttribute){item.toggleAttribute(this.selectedAttribute,isSelected)}this.selectedItem_=isSelected?item:null;this.fire("iron-"+(isSelected?"select":"deselect"),{item:item})}valueToIndex_(value){if(!this.attrForSelected){return Number(value)}const match=this.queryMatchingItem(`[${this.attrForSelected}="${value}"]`);return match?Number(match.dataset["selectionIndex"]):-1}indexToValue_(index){if(!this.attrForSelected){return index}const item=this.items_[index];if(!item){return index}return item.getAttribute(this.attrForSelected)||index}itemsChanged(){this.updateItems_();this.updateSelectedItem_();this.fire("iron-items-changed")}onClick_(e){let element=e.target;while(element&&element!==this){const idx=this.items_.indexOf(element);if(idx>=0){const value=this.indexToValue_(idx);assert(value!==null);this.fire("iron-activate",{item:element,selected:value});this.select(value);return}element=element.parentNode}}}return CrSelectableMixin};let instance$e=null;function getCss$4(){return instance$e||(instance$e=[...[],css`:host{display:block}:host(:not([show-all]))>::slotted(:not(slot):not(.selected)){display:none !important}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$4(){return html`<slot></slot>`}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrPageSelectorElementBase=CrSelectableMixin(CrLitElement);class CrPageSelectorElement extends CrPageSelectorElementBase{static get is(){return"cr-page-selector"}static get styles(){return getCss$4()}static get properties(){return{hasNestedSlots:{type:Boolean}}}render(){return getHtml$4.bind(this)()}#hasNestedSlots_accessor_storage=false;get hasNestedSlots(){return this.#hasNestedSlots_accessor_storage}set hasNestedSlots(value){this.#hasNestedSlots_accessor_storage=value}constructor(){super();this.selectOnClick=false}queryItems(){return this.hasNestedSlots?Array.from(this.getSlot().assignedElements({flatten:true})):super.queryItems()}queryMatchingItem(selector){if(this.hasNestedSlots){const match=this.queryItems().find((el=>el.matches(selector)));return match?match:null}return super.queryMatchingItem(selector)}observeItems(){if(this.hasNestedSlots){this.addEventListener("slotchange",(()=>this.itemsChanged()))}super.observeItems()}}customElements.define(CrPageSelectorElement.is,CrPageSelectorElement);let instance$d=null;function getCss$3(){return instance$d||(instance$d=[...[getCss$x()],css`:host{cursor:pointer;display:flex;flex-direction:row;font-size:var(--cr-tabs-font-size,14px);font-weight:500;height:var(--cr-tabs-height,48px);user-select:none}.tab{align-items:center;color:var(--cr-secondary-text-color);display:flex;flex:var(--cr-tabs-flex,auto);height:100%;justify-content:center;opacity:1;outline:none;padding:0 var(--cr-tabs-tab-inline-padding,0);position:relative;transition:opacity 100ms cubic-bezier(.4,0,1,1)}:host-context(.focus-outline-visible) .tab:focus{outline:var(--cr-tabs-focus-outline,auto);outline-offset:var(--cr-tabs-focus-outline-offset,0)}.selected{color:var(--cr-tabs-selected-color,var(--owl-control-accent-color,var(--google-blue-600)));opacity:1}@media (prefers-color-scheme:dark){.selected{color:var(--cr-tabs-selected-color,var(--owl-control-accent-color,var(--google-blue-300)))}}.tab-icon{-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-tabs-icon-size,var(--cr-icon-size));background-color:var(--cr-secondary-text-color);display:none;height:var(--cr-tabs-icon-size,var(--cr-icon-size));margin-inline-end:var(--cr-tabs-icon-margin-end,var(--cr-icon-size));width:var(--cr-tabs-icon-size,var(--cr-icon-size))}.selected .tab-icon{background-color:var(--cr-tabs-selected-color,var(--owl-control-accent-color,var(--google-blue-600)))}@media (prefers-color-scheme:dark){.selected .tab-icon{background-color:var(--cr-tabs-selected-color,var(--owl-control-accent-color,var(--google-blue-300)))}}.tab-indicator,.tab-indicator-background{bottom:0;height:var(--cr-tabs-selection-bar-width,2px);left:var(--cr-tabs-tab-inline-padding,0);position:absolute;right:var(--cr-tabs-tab-inline-padding,0)}.tab-indicator{border-top-left-radius:var(--cr-tabs-selection-bar-radius,var(--cr-tabs-selection-bar-width,2px));border-top-right-radius:var(--cr-tabs-selection-bar-radius,var(--cr-tabs-selection-bar-width,2px));opacity:0;transform-origin:left center;transition:transform}.selected .tab-indicator{background:var(--cr-tabs-selected-color,var(--owl-control-accent-color,var(--google-blue-600)));opacity:1}.tab-indicator.expand{transition-duration:150ms;transition-timing-function:cubic-bezier(.4,0,1,1)}.tab-indicator.contract{transition-duration:180ms;transition-timing-function:cubic-bezier(0,0,.2,1)}.tab-indicator-background{background:var(--cr-tabs-unselected-color,var(--google-blue-600));opacity:var(--cr-tabs-selection-bar-unselected-opacity,0);z-index:-1}@media (prefers-color-scheme:dark){.tab-indicator-background{background:var(--cr-tabs-unselected-color,var(--google-blue-300))}.selected .tab-indicator{background:var(--cr-tabs-selected-color,var(--owl-control-accent-color,var(--google-blue-300)))}}@media (forced-colors:active){.tab-indicator{background:SelectedItem}}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$3(){return html`${this.tabNames.map(((item,index)=>html`
<div role="tab"
    class="tab ${this.getSelectedClass_(index)}"
    aria-selected="${this.getAriaSelected_(index)}"
    tabindex="${this.getTabindex_(index)}"
    data-index="${index}" @click="${this.onTabClick_}">
  <div class="tab-icon" .style="${this.getIconStyle_(index)}"></div>
  ${item}
  <div class="tab-indicator-background"></div>
  <div class="tab-indicator"></div>
</div>
`))}`}
// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const NONE_SELECTED=-1;class CrTabsElement extends CrLitElement{static get is(){return"cr-tabs"}static get styles(){return getCss$3()}render(){return getHtml$3.bind(this)()}static get properties(){return{tabIcons:{type:Array},tabNames:{type:Array},selected:{type:Number,notify:true}}}#tabIcons_accessor_storage=[];get tabIcons(){return this.#tabIcons_accessor_storage}set tabIcons(value){this.#tabIcons_accessor_storage=value}#tabNames_accessor_storage=[];get tabNames(){return this.#tabNames_accessor_storage}set tabNames(value){this.#tabNames_accessor_storage=value}#selected_accessor_storage=NONE_SELECTED;get selected(){return this.#selected_accessor_storage}set selected(value){this.#selected_accessor_storage=value}isRtl_=false;connectedCallback(){super.connectedCallback();this.isRtl_=this.matches(":host-context([dir=rtl]) cr-tabs")}firstUpdated(){this.setAttribute("role","tablist");this.addEventListener("keydown",this.onKeyDown_.bind(this))}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("selected")){this.onSelectedChanged_(this.selected,changedProperties.get("selected"))}}getAriaSelected_(index){return index===this.selected?"true":"false"}getIconStyle_(index){const icon=this.tabIcons[index];return icon?`-webkit-mask-image: url(${icon}); display: block;`:""}getTabindex_(index){return index===this.selected?"0":"-1"}getSelectedClass_(index){return index===this.selected?"selected":""}onSelectedChanged_(newSelected,oldSelected){if(newSelected===NONE_SELECTED||oldSelected===NONE_SELECTED||oldSelected===undefined){return}const tabs=this.shadowRoot.querySelectorAll(".tab");if(tabs.length<=oldSelected){return}const oldTabRect=tabs[oldSelected].getBoundingClientRect();const newTabRect=tabs[newSelected].getBoundingClientRect();const newIndicator=tabs[newSelected].querySelector(".tab-indicator");newIndicator.classList.remove("expand","contract");this.updateIndicator_(newIndicator,newTabRect,oldTabRect.left,oldTabRect.width);newIndicator.getBoundingClientRect();newIndicator.classList.add("expand");newIndicator.addEventListener("transitionend",(e=>this.onIndicatorTransitionEnd_(e)),{once:true});const leftmostEdge=Math.min(oldTabRect.left,newTabRect.left);const fullWidth=newTabRect.left>oldTabRect.left?newTabRect.right-oldTabRect.left:oldTabRect.right-newTabRect.left;this.updateIndicator_(newIndicator,newTabRect,leftmostEdge,fullWidth)}async onKeyDown_(e){const count=this.tabNames.length;let newSelection;if(e.key==="Home"){newSelection=0}else if(e.key==="End"){newSelection=count-1}else if(e.key==="ArrowLeft"||e.key==="ArrowRight"){const delta=e.key==="ArrowLeft"?this.isRtl_?1:-1:this.isRtl_?-1:1;newSelection=(count+this.selected+delta)%count}else{return}e.preventDefault();e.stopPropagation();this.selected=newSelection;await this.updateComplete;this.shadowRoot.querySelector(".tab.selected").focus()}onIndicatorTransitionEnd_(event){const indicator=event.target;indicator.classList.replace("expand","contract");indicator.style.transform=`translateX(0) scaleX(1)`}onTabClick_(e){const target=e.currentTarget;this.selected=Number(target.dataset["index"])}updateIndicator_(indicator,originRect,newLeft,newWidth){const leftDiff=100*(newLeft-originRect.left)/originRect.width;const widthRatio=newWidth/originRect.width;const transform=`translateX(${leftDiff}%) scaleX(${widthRatio})`;indicator.style.transform=transform}}customElements.define(CrTabsElement.is,CrTabsElement);let instance$c=null;function getCss$2(){return instance$c||(instance$c=[...[],css`:host{-webkit-tap-highlight-color:transparent;align-items:center;cursor:pointer;display:flex;outline:none;user-select:none;--cr-checkbox-border-size:2px;--cr-checkbox-size:16px;--cr-checkbox-ripple-size:32px;--cr-checkbox-ripple-offset:50%;--cr-checkbox-checked-box-color:var(--owl-control-accent-color,var(--cr-checked-color));--cr-checkbox-ripple-checked-color:var(--cr-active-background-color);--cr-checkbox-ripple-opacity:1;--cr-checkbox-mark-color:var(--color-checkbox-check,var(--cr-fallback-color-on-primary));--cr-checkbox-ripple-unchecked-color:var(--cr-active-background-color);--cr-checkbox-unchecked-box-color:var(--color-checkbox-foreground-unchecked,var(--cr-fallback-color-outline));--cr-checkbox-checked-ripple-opacity:.2;--cr-checkbox-unchecked-ripple-opacity:.15}@media (prefers-color-scheme:dark){:host{--cr-checkbox-checked-ripple-opacity:.4;--cr-checkbox-unchecked-ripple-opacity:.4}}:host([disabled]){cursor:initial;opacity:1;pointer-events:none;--cr-checkbox-checked-box-color:var(--color-checkbox-container-disabled,var(--cr-fallback-color-disabled-background));--cr-checkbox-unchecked-box-color:var(--color-checkbox-outline-disabled,var(--cr-fallback-color-disabled-background));--cr-checkbox-mark-color:var(--color-checkbox-check-disabled,var(--cr-fallback-color-disabled-foreground))}#checkbox{background:none;border:var(--cr-checkbox-border-size) solid var(--cr-checkbox-unchecked-box-color);border-radius:2px;box-sizing:border-box;cursor:pointer;display:block;flex-shrink:0;height:var(--cr-checkbox-size);isolation:isolate;margin:0;outline:none;padding:0;position:relative;transform:none;width:var(--cr-checkbox-size)}:host([disabled][checked]) #checkbox{border-color:transparent}#hover-layer{display:none}#checkbox:hover #hover-layer{background-color:var(--cr-hover-background-color);border-radius:50%;display:block;height:32px;left:50%;overflow:hidden;pointer-events:none;position:absolute;top:50%;transform:translate(-50%,-50%);width:32px}@media (forced-colors:active){:host(:focus) #checkbox{outline:var(--cr-focus-outline-hcm)}}#checkbox:focus-visible{outline:var(--cr-checkbox-focus-outline,2px solid var(--cr-focus-outline-color));outline-offset:2px}#checkmark{display:block;forced-color-adjust:auto;position:relative;transform:scale(0);z-index:1}#checkmark path{fill:var(--cr-checkbox-mark-color)}:host([checked]) #checkmark{transform:scale(1);transition:transform 140ms ease-out}:host([checked]) #checkbox{background:var(--cr-checkbox-checked-box-background-color,var(--cr-checkbox-checked-box-color));border-color:var(--cr-checkbox-checked-box-color)}#ink{--paper-ripple-opacity:var(--cr-checkbox-ripple-opacity,var(--cr-checkbox-unchecked-ripple-opacity));color:var(--cr-checkbox-ripple-unchecked-color);height:var(--cr-checkbox-ripple-size);left:var(--cr-checkbox-ripple-offset);outline:var(--cr-checkbox-ripple-ring,none);pointer-events:none;top:var(--cr-checkbox-ripple-offset);transform:translate(-50%,-50%);transition:color linear 80ms;width:var(--cr-checkbox-ripple-size)}:host([checked]) #ink{--paper-ripple-opacity:var(--cr-checkbox-ripple-opacity,var(--cr-checkbox-checked-ripple-opacity));color:var(--cr-checkbox-ripple-checked-color)}:host-context([dir=rtl]) #ink{left:auto;right:var(--cr-checkbox-ripple-offset);transform:translate(50%,-50%)}#labelContainer{color:var(--cr-checkbox-label-color,var(--cr-primary-text-color));padding-inline-start:var(--cr-checkbox-label-padding-start,20px);white-space:normal}:host(.label-first) #labelContainer{order:-1;padding-inline-end:var(--cr-checkbox-label-padding-end,20px);padding-inline-start:0}:host(.no-label) #labelContainer{display:none}#ariaDescription{height:0;overflow:hidden;width:0}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$2(){return html`
<div id="checkbox" tabindex="${this.tabIndex}" role="checkbox"
    @keydown="${this.onKeyDown_}" @keyup="${this.onKeyUp_}"

    aria-disabled="${this.getAriaDisabled_()}"
    aria-checked="${this.getAriaChecked_()}"
    aria-label="${this.ariaLabelOverride||nothing}"
    aria-labelledby="${this.ariaLabelOverride?nothing:"labelContainer"}"
    aria-describedby="ariaDescription">
  <!-- Inline SVG paints faster than loading it from a separate file. -->
  <svg id="checkmark" width="12" height="12" viewBox="0 0 12 12"
      fill="none" xmlns="http://www.w3.org/2000/svg">
    <path fill-rule="evenodd" clip-rule="evenodd"
        d="m10.192 2.121-6.01 6.01-2.121-2.12L1 7.07l2.121 2.121.707.707.354.354 7.071-7.071-1.06-1.06Z">
  </svg>
  <div id="hover-layer"></div>
</div>
<div id="labelContainer" part="label-container">
  <slot></slot>
</div>
<div id="ariaDescription" aria-hidden="true">${this.ariaDescription}</div>`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrCheckboxElementBase=CrRippleMixin(CrLitElement);class CrCheckboxElement extends CrCheckboxElementBase{static get is(){return"cr-checkbox"}static get styles(){return getCss$2()}render(){return getHtml$2.bind(this)()}static get properties(){return{checked:{type:Boolean,reflect:true,notify:true},disabled:{type:Boolean,reflect:true},ariaDescription:{type:String},ariaLabelOverride:{type:String},tabIndex:{type:Number}}}#checked_accessor_storage=false;get checked(){return this.#checked_accessor_storage}set checked(value){this.#checked_accessor_storage=value}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#ariaDescription_accessor_storage=null;get ariaDescription(){return this.#ariaDescription_accessor_storage}set ariaDescription(value){this.#ariaDescription_accessor_storage=value}#ariaLabelOverride_accessor_storage;get ariaLabelOverride(){return this.#ariaLabelOverride_accessor_storage}set ariaLabelOverride(value){this.#ariaLabelOverride_accessor_storage=value}#tabIndex_accessor_storage=0;get tabIndex(){return this.#tabIndex_accessor_storage}set tabIndex(value){this.#tabIndex_accessor_storage=value}firstUpdated(){this.addEventListener("click",this.onClick_.bind(this));this.addEventListener("pointerup",this.hideRipple_.bind(this));this.$.labelContainer.addEventListener("pointerdown",this.showRipple_.bind(this));this.$.labelContainer.addEventListener("pointerleave",this.hideRipple_.bind(this))}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("disabled")){const previousTabIndex=changedProperties.get("disabled");if(previousTabIndex!==undefined||this.disabled){this.tabIndex=this.disabled?-1:0}}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("tabIndex")){this.removeAttribute("tabindex")}}focus(){this.$.checkbox.focus()}getFocusableElement(){return this.$.checkbox}getAriaDisabled_(){return this.disabled?"true":"false"}getAriaChecked_(){return this.checked?"true":"false"}showRipple_(){if(this.noink){return}this.getRipple().showAndHoldDown()}hideRipple_(){this.getRipple().clear()}async onClick_(e){if(this.disabled||e.target.tagName==="A"){return}e.stopPropagation();e.preventDefault();this.checked=!this.checked;await this.updateComplete;this.fire("change",this.checked)}onKeyDown_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(e.repeat){return}if(e.key==="Enter"){this.click()}}onKeyUp_(e){if(e.key===" "||e.key==="Enter"){e.preventDefault();e.stopPropagation()}if(e.key===" "){this.click()}}createRipple(){this.rippleContainer=this.$.checkbox;const ripple=super.createRipple();ripple.setAttribute("recenters","");ripple.classList.add("circle");return ripple}}customElements.define(CrCheckboxElement.is,CrCheckboxElement);function getTemplate$h(){return html$1`<!--_html_template_start_--><style include="settings-shared">.ripple-padding{padding-inline-start:20px;padding-inline-end:20px}cr-checkbox::part(label-container){min-width:0}</style>
<cr-checkbox id="checkbox" class="list-item no-outline ripple-padding"
    tab-index="-1" checked="{{checked}}" part="checkbox">
  <slot></slot>
</cr-checkbox>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsCheckboxListEntryElement extends PolymerElement{static get is(){return"settings-checkbox-list-entry"}static get template(){return getTemplate$h()}static get properties(){return{checked:{type:Boolean,value:false,observer:"onCheckedChanged_"},tabindex:{type:Number,value:0,observer:"onTabIndexChanged_",reflectToAttribute:true}}}ready(){super.ready();this.addEventListener("click",this.onClick_);this.addEventListener("keydown",this.onKeyDown_);this.addEventListener("keyup",this.onKeyUp_)}onClick_(){this.$.checkbox.click()}onKeyDown_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(e.repeat){return}if(e.key==="Enter"){this.$.checkbox.click()}}onKeyUp_(e){if(e.key===" "||e.key==="Enter"){e.preventDefault();e.stopPropagation()}if(e.key===" "){this.$.checkbox.click()}}onCheckedChanged_(){this.setAttribute("aria-checked",String(this.$.checkbox.checked))}onTabIndexChanged_(){this.setAttribute("aria-hidden",this.tabindex>=0?"false":"true")}}customElements.define(SettingsCheckboxListEntryElement.is,SettingsCheckboxListEntryElement);
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const TooltipMixin=dedupingMixin((superClass=>{class TooltipMixin extends superClass{showTooltipAtTarget(tooltip,target){if(!tooltip.for){tooltip.target=target;tooltip.updatePosition()}const hide=()=>{tooltip.hide();target.removeEventListener("mouseleave",hide);target.removeEventListener("blur",hide);target.removeEventListener("click",hide);tooltip.removeEventListener("mouseenter",hide)};target.addEventListener("mouseleave",hide);target.addEventListener("blur",hide);target.addEventListener("click",hide);tooltip.addEventListener("mouseenter",hide);tooltip.show()}}return TooltipMixin}));function getTemplate$g(){return html$1`<!--_html_template_start_-->    <style include="settings-shared cr-radio-button-style">:host{display:block}:host([disabled]){opacity:1}cr-policy-pref-indicator,:host([disabled]) cr-expand-button{pointer-events:auto}:host([disabled]) .disc-wrapper{opacity:var(--cr-disabled-opacity)}:host([disabled]) #labelWrapper{opacity:1}cr-collapse{margin-inline-end:0;margin-inline-start:calc(var(--cr-radio-button-label-spacing,20px) + var(--cr-radio-button-size))}.disc-wrapper{margin-inline-end:var(--cr-radio-button-label-spacing,20px)}.separator{margin-inline-end:0;min-height:calc(var(--settings-collapse-toggle-min-height,48px) / 2)}#borderWrapper{align-items:center;border-top:var(--settings-collapse-separator-line);display:flex;min-height:var(--settings-collapse-toggle-min-height);width:100%}#buttonIcon{padding-inline-end:6px}#labelWrapper{--cr-radio-button-label-spacing:0}#radioCollapse{align-items:center;display:flex}slot[name='noSelectionCollapse']{cursor:auto}
    </style>
    <div id="radioCollapse">
      <div aria-checked$="[[getAriaChecked_(checked)]]"
          aria-disabled$="[[getAriaDisabled_(disabled)]]"
          aria-labelledby="label"
          aria-describedby="sub-label"
          class="disc-wrapper"
          id="button"
          role="radio"
          tabindex$="[[buttonTabIndex_]]"
          on-focus="onRadioFocus_"
          on-keydown="onInputKeydown_">
        <div class="disc-border"></div>
        <div class="disc"></div>
      </div>
      <div id="borderWrapper">
        <cr-icon id="buttonIcon" icon="[[icon]]" hidden$="[[!icon]]"></cr-icon>
        <div id="labelWrapper" class="cr-padded-text">
          <div id="label" aria-hidden="true">
            [[label]]
            <slot name="label"></slot>
          </div>
          <div hidden$="[[!subLabel]]" id="sub-label" class="secondary">
            [[subLabel]]
            <slot name="sub-label"></slot>
          </div>
        </div>
        <template is="dom-if" if="[[pref]]">
          <cr-policy-pref-indicator pref="[[pref]]"
              icon-aria-label="[[indicatorAriaLabel]]"
              associated-value="[[name]]" on-focus="onNonRadioFocus_">
          </cr-policy-pref-indicator>
        </template>
        <div hidden$="[[noCollapse]]" class="separator"></div>
        <cr-expand-button id="expandButton" no-hover
              aria-label="[[expandAriaLabel]]"
              hidden$="[[noCollapse]]" expanded="{{expanded}}"
              on-click="onExpandClicked_"
              on-focus="onNonRadioFocus_">
        </cr-expand-button>
      </div>
    </div>

    <cr-collapse opened="[[expanded]]">
      <slot name="collapse"></slot>
      <slot name="noSelectionCollapse"></slot>
    </cr-collapse>
<!--_html_template_end_-->`}
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsCollapseRadioButtonElementBase=CrRippleMixinPolymer(CrRadioButtonMixin(PolymerElement));class SettingsCollapseRadioButtonElement extends SettingsCollapseRadioButtonElementBase{static get is(){return"settings-collapse-radio-button"}static get template(){return getTemplate$g()}static get properties(){return{expanded:{type:Boolean,notify:true,value:false},noAutomaticCollapse:{type:Boolean,value:false},noCollapse:Boolean,label:String,indicatorAriaLabel:String,icon:{type:String,value:""},pref:Object,disabled:{type:Boolean,value:false,reflectToAttribute:true},subLabel:{type:String,value:""},expandAriaLabel:String}}static get observers(){return["onCheckedChanged_(checked)","onPrefChanged_(pref.*)"]}pendingUpdateCollapsed_;constructor(){super();this.pendingUpdateCollapsed_=false}getPaperRipple(){return this.getRipple()}createRipple(){this.rippleContainer=this.shadowRoot.querySelector(".disc-wrapper");const ripple=super.createRipple();ripple.setAttribute("recenters","");ripple.classList.add("circle");return ripple}updateCollapsed(){if(this.pendingUpdateCollapsed_){this.pendingUpdateCollapsed_=false;this.expanded=this.checked}}getBubbleAnchor(){const anchor=this.shadowRoot.querySelector("#button");assert(anchor);return anchor}onCheckedChanged_(){this.pendingUpdateCollapsed_=true;if(!this.noAutomaticCollapse){this.updateCollapsed()}}onPrefChanged_(){this.disabled=!!this.pref&&this.pref.enforcement===chrome.settingsPrivate.Enforcement.ENFORCED&&!(!!this.pref.userSelectableValues&&this.pref.userSelectableValues.includes(this.name))}onExpandClicked_(){this.dispatchEvent(new CustomEvent("expand-clicked",{bubbles:true,composed:true}))}onRadioFocus_(){this.getRipple().showAndHoldDown()}onNonRadioFocus_(e){this.getRipple().clear();e.stopPropagation()}}customElements.define(SettingsCollapseRadioButtonElement.is,SettingsCollapseRadioButtonElement);const styleMod$1=document.createElement("dom-module");styleMod$1.appendChild(html$1`
  <template>
    <style>
.settings-columned-section{display:flex;gap:16px;padding:16px var(--cr-section-padding) 0}settings-collapse-radio-button .settings-columned-section{padding:4px 0 16px 0}.settings-columned-section .column{flex:1;min-width:0}.settings-columned-section .description-header{color:var(--google-blue-600)}.settings-columned-section h2.description-header,.settings-columned-section h3.description-header,.settings-columned-section h4.description-header{font-size:inherit;font-weight:400;margin:0;padding:0}@media (prefers-color-scheme:dark){.settings-columned-section .description-header{color:var(--google-blue-300)}}.settings-columned-section ul{list-style-type:none;padding-inline-start:0}.settings-columned-section ul.icon-bulleted-list li{column-gap:16px;display:flex}.settings-columned-section li{margin:16px 0}
    </style>
  </template>
`.content);styleMod$1.register("settings-columned-section");
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var NetworkPredictionOptions;(function(NetworkPredictionOptions){NetworkPredictionOptions[NetworkPredictionOptions["STANDARD"]=0]="STANDARD";NetworkPredictionOptions[NetworkPredictionOptions["WIFI_ONLY_DEPRECATED"]=1]="WIFI_ONLY_DEPRECATED";NetworkPredictionOptions[NetworkPredictionOptions["DISABLED"]=2]="DISABLED";NetworkPredictionOptions[NetworkPredictionOptions["EXTENDED"]=3]="EXTENDED";NetworkPredictionOptions[NetworkPredictionOptions["DEFAULT"]=1]="DEFAULT"})(NetworkPredictionOptions||(NetworkPredictionOptions={}));function getTemplate$f(){return html$1`<!--_html_template_start_--><style include="cr-shared-style settings-shared">:host{display:block;--separator-line-height:16px;--cr-icon-button-margin-end:0}#header-wrapper{align-items:center;display:flex;flex:1}#header-text-wrapper{flex-direction:column;flex:1;margin-inline-end:24px}#header,#subheader,.display-name{font-size:0.8125rem}#header{margin:0;font-weight:500}#header-wrapper{min-height:calc(2em * 1.54)}cr-icon{--iron-icon-height:20px;--iron-icon-width:20px}cr-icon.green{--iron-icon-fill-color:var(--google-green-700)}cr-icon.blue{--iron-icon-fill-color:var(--google-blue-600)}@media (prefers-color-scheme:dark){cr-icon.green{--iron-icon-fill-color:var(--google-green-300)}cr-icon.blue{--iron-icon-fill-color:var(--google-blue-300)}}.list-item{clip-path:polygon(0 0,0 100%,100% 100%,100% 0)}.display-name{flex:1;max-width:100%}site-favicon,#header-icon,.item-icon{padding-inline-end:16px}#line{box-sizing:border-box;height:var(--separator-line-height);border-bottom:1px solid var(--cr-separator-color);flex:1}cr-tooltip{--paper-tooltip-min-width:max-content}</style>

<template is="dom-if" if="[[animated]]">
  <style>
    :host {
      /**
       * The |animation-duration| parameter corresponds to MODEL_UPDATE_DELAY_MS
       * in the .ts file.
       */
      --animation-duration: 300ms;
    }

    #header-wrapper {
      /**
       * Increse the header height to 3 lines. This is because the header
       * currently isn't animated, only the rows under it are. When we animate
       * the showing or hiding of rows, and at the end we update the header from
       * little content to a lot of content or vice versa, this may change the
       * header's height and appear as a "bump" at the beginning or end of the
       * animation. 3 lines should be a sufficient buffer for headers with a lot
       * of content.
       *
       * We also need to count with 154% line-height.
       */
      min-height: calc(3em * 1.54);
    }

    @keyframes line-hiding-animation {
      0% {
        height: var(--separator-line-height);
        opacity: 1;
      }
      100% {
        height: 0;
        opacity: 0;
        visibility: hidden;
      }
    }

    /**
     * Settings use a line height of 154%. Our items contain two lines (2em)
     * plus a vertical padding on both sides. We slightly increase
     * the coefficient to 160% to avoid that the height immediately contracts at
     * the beginning of the animation in case of rounding error. Note that
     * erring on the side of a slightly larger height is not a problem since
     * this animation uses |max-height| and not |height| directly.
     */
    @keyframes item-hiding-animation {
      0% {
        max-height: calc(1.6 * 2em + 2 * var(--cr-section-vertical-padding));
        opacity: 1;
      }
      100% {
        max-height: 0;
        opacity: 0;
        visibility: hidden;
      }
    }

    /**
     * When new items are added to the list, they must immediately be set
     * invisible. Otherwise, there flash on the screen for a moment before we
     * have a chance to apply the ".showing" animation that is supposed to start
     * with the item not being visible.
     *
     * At any other phase of the animation, while the item is shown or hidden,
     * or when the item is in a steady state, this is overriden to make the item
     * visible.
     */
    #siteList .list-item, #line {
      display: none;
    }

    #siteList .list-item.hiding, #siteList .list-item.showing,
    #line.hiding, #line.showing {
      display: flex;
    }

    /**
     * Showing and hiding animations are largely symmetrical. They only differ
     * in the direction and timing.
     */
    .hiding, .showing {
      animation-duration: var(--animation-duration);
      animation-fill-mode: forwards;
      animation-iteration-count: 1;
      animation-name: item-hiding-animation;
      animation-timing-function: cubic-bezier(0, 0.8, 0, 1);
      min-height: 0;
    }

    .showing {
      animation-direction: reverse;
      animation-timing-function: cubic-bezier(1, 0, 1, 0.4);
    }

    #line.hiding, #line.showing {
      animation-name: line-hiding-animation;
    }
  </style>
</template>

<div id="header-wrapper">
  <cr-icon id="header-icon"
    icon="[[headerIcon]]" class$="[[headerIconColor]]">
  </cr-icon>
  <div id="header-text-wrapper">
    <h3 id="header">[[header]]</h3>
    <div id="subheader" class="cr-secondary-text">[[subheader]]</div>
  </div>
  <slot name="button-container"></slot>
</div>

<template is="dom-if" if="[[sites.length]]">
  <div id="line"></div>
  <div id="siteList">
    <template is="dom-repeat" items="[[sites]]">
      <div class="list-item site-entry">
        <template is="dom-if" if="[[item.icon]]">
          <cr-icon class="item-icon" icon="[[item.icon]]"></cr-icon>
        </template>
        <template is="dom-if" if="[[!item.icon]]">
          <site-favicon url="[[item.origin]]"></site-favicon>
        </template>
        <div class="display-name cr-padded-text">
          <div class="site-representation">[[item.origin]]</div>
          <div class="cr-secondary-text link"
              inner-h-t-m-l="[[sanitizeInnerHtml_(item.detail)]]">
          </div>
        </div>
        <template is="dom-if" if="[[buttonIcon]]">
          <cr-icon-button iron-icon="[[buttonIcon]]" id="mainButton"
              on-click="onItemButtonClick_" actionable
              aria-label$="[[getButtonAriaLabelForOrigin_(item.origin)]]"
              on-focus="onShowTooltip_" on-mouseenter="onShowTooltip_">
          </cr-icon-button>
        </template>
        <template is="dom-if" if="[[moreActionVisible]]">
          <cr-icon-button class="icon-more-vert" id="moreActionButton"
              on-click="onMoreActionClick_" title="$i18n{moreActions}"
              aria-label$="[[getMoreButtonAriaLabelForOrigin_(item.origin)]]"
              actionable>
          </cr-icon-button>
        </template>
      </div>
    </template>
  </div>
  <cr-tooltip fit-to-visible-bounds manual-mode position="top" offset="3">
    [[buttonTooltipText]]
  </cr-tooltip>
</template>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const MODEL_UPDATE_DELAY_MS=310;const SettingsSafetyHubModuleElementBase=TooltipMixin(I18nMixin(PolymerElement));class SettingsSafetyHubModuleElement extends SettingsSafetyHubModuleElementBase{static get is(){return"settings-safety-hub-module"}static get template(){return getTemplate$f()}static get properties(){return{sites:{type:Array,value:()=>[],observer:"onSitesChanged_"},animated:{type:Boolean,value:false},header:String,subheader:String,headerIcon:{String:String,value:"cr:error",observer:"onHeaderIconChanged_"},headerIconColor:String,buttonIcon:String,buttonAriaLabelId:String,buttonTooltipText:String,moreActionVisible:{type:Boolean,value:false},moreButtonAriaLabelId:String}}modelUpdateDelayMsForTesting_=null;setModelUpdateDelayMsForTesting(delayMs){this.modelUpdateDelayMsForTesting_=delayMs}setVisibility_(item,visible){item.style.display=visible?"flex":""}addItemLinkClickListeners(items){for(const item of items){const links=item.querySelectorAll("a");links.forEach((link=>{if(link.target==="_blank"){link.setAttribute("aria-description",this.i18n("opensInNewTab"))}link.addEventListener("click",(function(){this.dispatchEvent(new CustomEvent("sh-module-item-link-click",{bubbles:true,composed:true,detail:item}))}))}))}}onSitesChanged_(){const items=this.shadowRoot.querySelectorAll("#siteList .list-item");for(const item of items){this.setVisibility_(item,true)}if(this.sites&&this.sites.length!==items.length){setTimeout(this.onSitesChanged_.bind(this),0)}this.addItemLinkClickListeners(items)}animateHide(origin,callback){const items=this.shadowRoot.querySelectorAll("#siteList .list-item");if(items.length!==this.sites.length){setTimeout(this.animateHide.bind(this,origin,callback),0);return}let removedAll=origin===null;for(let i=0;i<this.sites.length;++i){if(origin===null||origin===this.sites[i].origin){items[i].classList.add("hiding");if(origin){removedAll||=this.sites.length===1;break}}}if(removedAll){this.shadowRoot.querySelector("#line").classList.add("hiding")}const delayMs=this.modelUpdateDelayMsForTesting_!==null?this.modelUpdateDelayMsForTesting_:MODEL_UPDATE_DELAY_MS;if(callback){setTimeout(callback,delayMs)}setTimeout(this.finalizeAnimation_.bind(this),delayMs)}animateShow(origins,callback){const items=this.shadowRoot.querySelectorAll("#siteList .list-item");if(items.length!==this.sites.length){setTimeout(this.animateShow.bind(this,origins,callback),0);return}let wasEmpty=true;for(let i=0;i<items.length;++i){if(origins.includes(this.sites[i].origin)){items[i].classList.add("showing")}else{wasEmpty=false}}if(wasEmpty){this.shadowRoot.querySelector("#line").classList.add("showing")}const delayMs=this.modelUpdateDelayMsForTesting_!==null?this.modelUpdateDelayMsForTesting_:MODEL_UPDATE_DELAY_MS;if(callback){setTimeout(callback,delayMs)}setTimeout(this.finalizeAnimation_.bind(this),delayMs)}focusOriginMainButton(origin){for(const item of this.shadowRoot.querySelectorAll("#siteList .list-item")){const siteRepresentation=item.querySelector(".site-representation");if(siteRepresentation&&siteRepresentation.innerHTML===origin){item.querySelector("#mainButton").focus();return}}}finalizeAnimation_(){const items=this.shadowRoot.querySelectorAll("#siteList .list-item, #line");for(const item of items){if(item.classList.contains("showing")){item.classList.remove("showing");this.setVisibility_(item,true)}if(item.classList.contains("hiding")){item.classList.remove("hiding");this.setVisibility_(item,false)}}}onItemButtonClick_(e){const item=e.model.item;this.dispatchEvent(new CustomEvent("sh-module-item-button-click",{bubbles:true,composed:true,detail:item}))}onMoreActionClick_(e){const item={...e.model.item,target:e.target};this.dispatchEvent(new CustomEvent("sh-module-more-action-button-click",{bubbles:true,composed:true,detail:item}))}onHeaderIconChanged_(){if(this.headerIcon==="cr:check"){this.headerIconColor="green"}else if(this.headerIcon!=="cr:security"){this.headerIconColor=""}}onShowTooltip_(e){e.stopPropagation();const tooltip=this.shadowRoot.querySelector("cr-tooltip");assert(tooltip);this.showTooltipAtTarget(tooltip,e.target)}sanitizeInnerHtml_(rawString){return sanitizeInnerHtml(rawString)}getButtonAriaLabelForOrigin_(origin){return this.i18n(this.buttonAriaLabelId,origin)}getMoreButtonAriaLabelForOrigin_(origin){return this.i18n(this.moreButtonAriaLabelId,origin)}}customElements.define(SettingsSafetyHubModuleElement.is,SettingsSafetyHubModuleElement);
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var SafetyHubEvent;(function(SafetyHubEvent){SafetyHubEvent["UNUSED_PERMISSIONS_MAYBE_CHANGED"]="unused-permission-review-list-maybe-changed";SafetyHubEvent["NOTIFICATION_PERMISSIONS_MAYBE_CHANGED"]="notification-permission-review-list-maybe-changed";SafetyHubEvent["EXTENSIONS_CHANGED"]="extensions-review-list-maybe-changed"})(SafetyHubEvent||(SafetyHubEvent={}));var PermissionsRevocationType;(function(PermissionsRevocationType){PermissionsRevocationType[PermissionsRevocationType["UNUSED_PERMISSIONS"]=0]="UNUSED_PERMISSIONS";PermissionsRevocationType[PermissionsRevocationType["ABUSIVE_NOTIFICATION_PERMISSIONS"]=1]="ABUSIVE_NOTIFICATION_PERMISSIONS";PermissionsRevocationType[PermissionsRevocationType["DISRUPTIVE_NOTIFICATION_PERMISSIONS"]=2]="DISRUPTIVE_NOTIFICATION_PERMISSIONS";PermissionsRevocationType[PermissionsRevocationType["UNUSED_PERMISSIONS_AND_ABUSIVE_NOTIFICATIONS"]=3]="UNUSED_PERMISSIONS_AND_ABUSIVE_NOTIFICATIONS";PermissionsRevocationType[PermissionsRevocationType["UNUSED_PERMISSIONS_AND_DISRUPTIVE_NOTIFICATIONS"]=4]="UNUSED_PERMISSIONS_AND_DISRUPTIVE_NOTIFICATIONS"})(PermissionsRevocationType||(PermissionsRevocationType={}));var CardState;(function(CardState){CardState[CardState["WARNING"]=0]="WARNING";CardState[CardState["WEAK"]=1]="WEAK";CardState[CardState["INFO"]=2]="INFO";CardState[CardState["SAFE"]=3]="SAFE"})(CardState||(CardState={}));class SafetyHubBrowserProxyImpl{acknowledgeRevokedUnusedSitePermissionsList(){chrome.send("acknowledgeRevokedUnusedSitePermissionsList")}allowPermissionsAgainForUnusedSite(origin){chrome.send("allowPermissionsAgainForUnusedSite",[origin])}getRevokedUnusedSitePermissionsList(){return sendWithPromise("getRevokedUnusedSitePermissionsList")}undoAcknowledgeRevokedUnusedSitePermissionsList(unusedSitePermissionsList){chrome.send("undoAcknowledgeRevokedUnusedSitePermissionsList",[unusedSitePermissionsList])}undoAllowPermissionsAgainForUnusedSite(unusedSitePermissions){chrome.send("undoAllowPermissionsAgainForUnusedSite",[unusedSitePermissions])}getNotificationPermissionReview(){return sendWithPromise("getNotificationPermissionReview")}blockNotificationPermissionForOrigins(origins){chrome.send("blockNotificationPermissionForOrigins",[origins])}allowNotificationPermissionForOrigins(origins){chrome.send("allowNotificationPermissionForOrigins",[origins])}ignoreNotificationPermissionForOrigins(origins){chrome.send("ignoreNotificationPermissionReviewForOrigins",[origins])}undoIgnoreNotificationPermissionForOrigins(origins){chrome.send("undoIgnoreNotificationPermissionReviewForOrigins",[origins])}resetNotificationPermissionForOrigins(origins){chrome.send("resetNotificationPermissionForOrigins",[origins])}dismissActiveMenuNotification(){chrome.send("dismissActiveMenuNotification")}getPasswordCardData(){return sendWithPromise("getPasswordCardData")}getSafeBrowsingCardData(){return sendWithPromise("getSafeBrowsingCardData")}getVersionCardData(){return sendWithPromise("getVersionCardData")}getNumberOfExtensionsThatNeedReview(){return sendWithPromise("getNumberOfExtensionsThatNeedReview")}getSafetyHubEntryPointData(){return sendWithPromise("getSafetyHubEntryPointData")}recordSafetyHubPageVisit(){return sendWithPromise("recordSafetyHubPageVisit")}recordSafetyHubInteraction(){return sendWithPromise("recordSafetyHubInteraction")}static getInstance(){return instance$b||(instance$b=new SafetyHubBrowserProxyImpl)}static setInstance(obj){instance$b=obj}}let instance$b=null;function getTemplate$e(){return html$1`<!--_html_template_start_--><style include="cr-shared-style">#module{padding:8px 16px}</style>

<settings-section page-title="$i18n{safetyHub}">
  <settings-safety-hub-module class="cr-row first" id="module"
      header$="[[headerString_]]" subheader$="[[subheaderString_]]"
      header-icon-color$="[[headerIconColor_]]" header-icon="cr:security">
    <cr-button id="button" on-click="onClick_" slot="button-container"
        class$="[[buttonClass_]]">
      $i18n{safetyHubEntryPointButtonLabel}
    </cr-button>
  </settings-safety-hub-module>
</settings-section>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsSafetyHubEntryPointElementBase=SettingsViewMixin(RouteObserverMixin(I18nMixin(PolymerElement)));class SettingsSafetyHubEntryPointElement extends SettingsSafetyHubEntryPointElementBase{static get is(){return"settings-safety-hub-entry-point"}static get template(){return getTemplate$e()}static get properties(){return{buttonClass_:{type:Boolean,computed:"computeButtonClass_(hasRecommendations_)"},hasRecommendations_:{type:Boolean,value:false},headerString_:String,subheaderString_:String,headerIconColor_:{type:String,computed:"computeHeaderIconColor_(hasRecommendations_)"}}}safetyHubBrowserProxy_=SafetyHubBrowserProxyImpl.getInstance();metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();connectedCallback(){this.safetyHubBrowserProxy_.getSafetyHubEntryPointData().then((entryPoint=>{this.hasRecommendations_=entryPoint.hasRecommendations;this.headerString_=entryPoint.header;this.subheaderString_=entryPoint.subheader}));super.connectedCallback()}currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);if(Router.getInstance().getCurrentRoute()!==routes.PRIVACY){return}if(this.hasRecommendations_){this.metricsBrowserProxy_.recordSafetyHubEntryPointShown(SafetyHubEntryPoint.PRIVACY_WARNING)}else{this.metricsBrowserProxy_.recordSafetyHubEntryPointShown(SafetyHubEntryPoint.PRIVACY_SAFE)}}computeButtonClass_(){return this.hasRecommendations_?"action-button":""}computeHeaderIconColor_(){return this.hasRecommendations_?"blue":""}onClick_(){if(this.hasRecommendations_){this.metricsBrowserProxy_.recordSafetyHubEntryPointClicked(SafetyHubEntryPoint.PRIVACY_WARNING)}else{this.metricsBrowserProxy_.recordSafetyHubEntryPointClicked(SafetyHubEntryPoint.PRIVACY_SAFE)}Router.getInstance().navigateTo(routes.SAFETY_HUB)}getFocusConfig(){return new Map([[routes.SAFETY_HUB.path,"#button"]])}}customElements.define(SettingsSafetyHubEntryPointElement.is,SettingsSafetyHubEntryPointElement);const div=document.createElement("div");div.innerHTML=getTrustedHTML`<!-- Icons used in the privacy_page/*, site_settings/* and site_settings_page/*
 pages. Keep in alphabetical ordering. -->
<cr-iconset name="privacy20" size="20">
  <svg>
    <defs>
      <g id="ads-click" viewBox="0 -960 960 960">
        <path d="M480-240q-100 0-170-70t-70-170q0-100 70-170t170-70q100 0 170 70t70 170l-73-24q-9-62-56.5-103T480-648q-70 0-119 49t-49 119q0 63 41 110.5T456-313l24 73Zm44 141q-11 2-22 2.5t-22 .5q-79 0-149-30t-122.5-82.5Q156-261 126-331T96-480q0-80 30-149.5t82.5-122Q261-804 331-834t149-30q80 0 149.5 30t122 82.5Q804-699 834-629.5T864-480q0 11-.5 22t-1.5 22l-70-22v-22q0-130-91-221t-221-91q-130 0-221 91t-91 221q0 130 91 221t221 91q5 0 11-.5t11-.5l22 70Zm296 27L654-239 600-96 480-480l384 120-143 53 167 167-68 68Z"></path>
      </g>
      <g id="person-check" viewBox="0 -960 960 960">
        <path d="M695-456 576-575l51-51 68 68 153-152 51 50-204 204Zm-311-24q-60 0-102-42t-42-102q0-60 42-102t102-42q60 0 102 42t42 102q0 60-42 102t-102 42ZM96-192v-92q0-25.78 12.5-47.39T143-366q55-32 116-49t125-17q64 0 125 17t116 49q22 13 34.5 34.61T672-284v92H96Zm72-72h432v-20q0-6.47-3.03-11.76-3.02-5.3-7.97-8.24-47-27-99-41.5T384-360q-54 0-106 14.5T179-304q-4.95 2.94-7.98 8.24Q168-290.47 168-284v20Zm216.21-288Q414-552 435-573.21t21-51Q456-654 434.79-675t-51-21Q354-696 333-674.79t-21 51Q312-594 333.21-573t51 21ZM384-312Zm0-312Z"></path>
      </g>

      <g id="signpost" viewBox="0 -960 960 960">
        <path d="M444-96v-192H240l-96-108 96-108h204v-72H192v-216h252v-72h72v72h204l96 108-96 108H516v72h252v216H516v192h-72ZM264-648h424l32-36-32-36H264v72Zm8 288h424v-72H272l-32 36 32 36Zm-8-288v-72 72Zm432 288v-72 72Z"></path>
      </g>
    </defs>
  </svg>
</cr-iconset>
<cr-iconset name="privacy" size="24">
  <svg>
    <defs>
      <g id="account-circle" viewBox="0 -960 960 960">
        <path d="M237-285q54-38 115.5-56.5T480-360q66 0 127.5 18.5T723-285q35-41 52-91t17-104q0-129.67-91.23-220.84-91.23-91.16-221-91.16Q350-792 259-700.84 168-609.67 168-480q0 54 17 104t52 91Zm243-123q-60 0-102-42t-42-102q0-60 42-102t102-42q60 0 102 42t42 102q0 60-42 102t-102 42Zm.28 312Q401-96 331-126t-122.5-82.5Q156-261 126-330.96t-30-149.5Q96-560 126-629.5q30-69.5 82.5-122T330.96-834q69.96-30 149.5-30t149.04 30q69.5 30 122 82.5T834-629.28q30 69.73 30 149Q864-401 834-331t-82.5 122.5Q699-156 629.28-126q-69.73 30-149 30Zm-.28-72q52 0 100-16.5t90-48.5q-43-27-91-41t-99-14q-51 0-99.5 13.5T290-233q42 32 90 48.5T480-168Zm0-312q30 0 51-21t21-51q0-30-21-51t-51-21q-30 0-51 21t-21 51q0 30 21 51t51 21Zm0-72Zm0 319Z"></path>
      </g>
      <g id="account-circle-off" viewBox="0 -960 960 960">
        <path d="M527-535ZM420-420Zm59.96 252Q532-168 580-184.5q48-16.5 90-48.5-43-27-91-41t-99-14q-51 0-99.5 13.5T290-233q42 32 89.96 48.5 47.96 16.5 100 16.5ZM595-466l-52-52q5-8 7-16.67 2-8.66 2-17.33 0-30-21-51t-51-21q-8.67 0-17.33 2-8.67 2-16.67 7l-52-52q19-14 41-21.5t45-7.5q59.66 0 101.83 42.17T624-552q0 23-7.5 45T595-466Zm202 202-52-52q23-37 35-78.66 12-41.65 12-85.34 0-130-91-221t-221-91q-43.69 0-85.34 12Q353-768 316-745l-52-52q48-33 103.02-50 55.02-17 112.98-17 80 0 149.5 30t122 82.5Q804-699 834-629.5T864-480q0 57.96-17 112.98T797-264ZM480-96q-79.38 0-149.19-30T208.5-208.5Q156-261 126-330.81T96-480q0-57.62 17-112.31Q130-647 162-695l-72-73 51-51 678 678-51 51-554-553q-23 37-34.5 78T168-480q0 54 17 104t52 91q54-38 115.41-56.5Q413.83-360 479.66-360q37.34 0 73.34 6.5t71 18.5l127 127q-54 54-124.09 83Q556.81-96 480-96Z"></path>
      </g>
      <g id="cardboard" viewBox="0 -960 960 960">
        <path d="M216-336h153l29.75-58.35Q411-417 432.5-430.5t47.49-13.5q25.99 0 47.5 13T561-395.08L591-336h153v-288H216v288Zm96.21-72Q342-408 363-429.21t21-51Q384-510 362.79-531t-51-21Q282-552 261-530.79t-21 51Q240-450 261.21-429t51 21ZM144-336.06v-288.22Q144-654 165.15-675T216-696h528q29.7 0 50.85 21.17Q816-653.67 816-623.94v288.22Q816-306 794.85-285T744-264H591q-20 0-37.5-10.5T527-303l-30-58q-2.57-5.08-7.29-8.04Q485-372 480-372q-5 0-10 3t-7 8l-30 58q-9 18-26.5 28.5T369-264H216q-29.7 0-50.85-21.17Q144-306.33 144-336.06ZM648.21-408Q678-408 699-429.21t21-51Q720-510 698.79-531t-51-21Q618-552 597-530.79t-21 51Q576-450 597.21-429t51 21ZM480-480Z"></path>
      </g>
      <g id="cardboard-off" viewBox="0 -960 960 960">
        <path d="M768-90 90-768l51-51 678 678-51 51ZM378-480Zm417 195-51-51.25V-624H437l-71-72h378q29.7 0 50.85 21.13Q816-653.73 816-624.06v287.77q0 15.29-5.48 28.34T795-285ZM311.79-408Q282-408 261-429.21t-21-51Q240-510 261.21-531t51-21Q342-552 363-530.79t21 51Q384-450 362.79-429t-51 21ZM650-408l-74-75q2-29 22.5-49t49.5-20q29.7 0 50.85 21.15Q720-509.7 720-480q0 29-20.5 50T650-408Zm-71-72ZM216-264q-29.7 0-50.85-21.17Q144-306.33 144-336.06v-288.22Q144-654 165.15-675T216-696h48l72 72H216v288h153l29.75-58.35Q411-417 432.5-430.5T480-444h36l180 180H591q-20 0-37.5-10.5T527-303l-30-58q-2.57-5.08-7.29-8.04Q485-372 480-372q-5 0-10 3t-7 8l-30 58q-9 18-26.5 28.5T369-264H216Z"></path>
      </g>
      <g id="code" viewBox="0 -960 960 960">
        <path d="M336-240 96-480l240-240 51 51-189 189 189 189-51 51Zm288 0-51-51 189-189-189-189 51-51 240 240-240 240Z"></path>
      </g>
      <g id="code-off" viewBox="0 -960 960 960">
        <path d="M768-90 288-570l-90 90 189 189-51 51L96-480l141-141L90-768l51-51 678 678-51 51Zm-45-249-51-51 90-90-189-189 51-51 240 240-141 141Z"></path>
      </g>
      <g id="content-paste" viewBox="0 -960 960 960">
        <path d="M216-144q-29.7 0-50.85-21.15Q144-186.3 144-216v-528q0-29.7 21.15-50.85Q186.3-816 216-816h171q8-31 33.5-51.5T480-888q34 0 59.5 20.5T573-816h171q29.7 0 50.85 21.15Q816-773.7 816-744v528q0 29.7-21.15 50.85Q773.7-144 744-144H216Zm0-72h528v-528h-72v120H288v-120h-72v528Zm263.79-528q15.21 0 25.71-10.29t10.5-25.5q0-15.21-10.29-25.71t-25.5-10.5q-15.21 0-25.71 10.29t-10.5 25.5q0 15.21 10.29 25.71t25.5 10.5Z"></path>
      </g>
      <g id="content-paste-off" viewBox="0 -960 960 960">
        <path d="m816-246-72-72v-426h-72v120H438L246-816h141q11-32 34.5-52t58.5-20q35 0 59 19.5t34 52.5h171q29.7 0 50.85 21.15Q816-773.7 816-744v498ZM479.79-744q15.21 0 25.71-10.29t10.5-25.5q0-15.21-10.29-25.71t-25.5-10.5q-15.21 0-25.71 10.29t-10.5 25.5q0 15.21 10.29 25.71t25.5 10.5ZM642-216 216-642v426h426Zm-426 72q-29.7 0-50.85-21.15Q144-186.3 144-216v-498l-54-54 51-51 678 678-51 51-54-54H216Z"></path>
      </g>
      <g id="cookie" viewBox="0 -960 960 960">
        <path d="M480-96q-79.38 0-149.19-30T208.5-208.5Q156-261 126-330.81T96-480q0-81 31-151.5t82.5-123Q261-807 329-837.5T470-868q23 0 45 3t45 9q-8 45 5.5 82t42.03 60.96q28.53 23.96 68 33T759-681q-24 57 8.01 108.5 32.01 51.49 95.08 53.4.95 10.49 1.43 19.55T864-480q0 78-30.24 147.98-30.24 69.99-82.08 122.6t-121.92 83.01Q559.68-96 480-96Zm-60-456q25 0 42.5-17.5T480-612q0-25-17.5-42.5T420-672q-25 0-42.5 17.5T360-612q0 25 17.5 42.5T420-552Zm-96 192q25 0 42.5-17.5T384-420q0-25-17.5-42.5T324-480q-25 0-42.5 17.5T264-420q0 25 17.5 42.5T324-360Zm275.79 36q15.21 0 25.71-10.29t10.5-25.5q0-15.21-10.29-25.71t-25.5-10.5q-15.21 0-25.71 10.29t-10.5 25.5q0 15.21 10.29 25.71t25.5 10.5ZM480-168q125 0 214.5-84.5T792-462q-45-18-75-55.5T679-603q-76-11-129-63t-63-126q-63-4-120.5 19.5t-102 66.5Q220-663 194-604.5T168-480q0 129.67 91.16 220.84Q350.33-168 480-168Zm0-311Z"></path>
      </g>
      <g id="credit-card" viewBox="0 -960 960 960">
        <path d="M864-696v432q0 29-21.15 50.5T792-192H168q-29 0-50.5-21.5T96-264v-432q0-29 21.5-50.5T168-768h624q29.7 0 50.85 21.5Q864-725 864-696Zm-696 72h624v-72H168v72Zm0 144v216h624v-216H168Zm0 216v-432 432Z"></path>
      </g>
      <g id="credit-card-off" viewBox="0 -960 960 960">
        <path d="m846-216-54-54v-210H582L438-624h354v-72H366l-72-72h498q29.7 0 50.85 21.15Q864-725.7 864-696v432q0 14-4 25.96-4 11.97-14 22.04ZM378-480Zm204 0Zm-204 0H168v216h426L378-480ZM803-56 666-192H168q-29.7 0-50.85-21.16Q96-234.32 96-264.04v-432.24Q96-726 116.86-747q20.85-21 50.14-21h25l78 78H168v66h66L56-803l51-50 746 746-50 51Z"></path>
      </g>
      <g id="database" viewBox="0 -960 960 960">
        <path d="M479.5-144q-140.5 0-238-41.85T144-288v-384q0-60 98-102t237.5-42q139.5 0 238 42T816-672v384q0 60.3-98 102.15Q620-144 479.5-144Zm.47-456Q566-600 646-621.5t98-50.5q-18-28-98.5-50t-165.53-22Q394-744 313.5-722T216-672q17 29 96.5 50.5T479.97-600Zm.03 192q42 0 80-4.5t71.5-12.5q33.5-8 62-20.5T744-474v-109q-24.25 13.22-53.62 23.61Q661-549 627.17-542.15q-33.83 6.85-71 10.5Q519-528 479.5-528t-77.11-3.65q-37.62-3.65-71-10.5Q298-549 268.5-559.5 239-570 216-583v109q22.41 15.94 50.21 28.47Q294-433 327.5-425q33.5 8 72 12.5T480-408Zm.32 192q43.32 0 88.05-6.4 44.73-6.39 82.4-16.9 37.67-10.5 63.09-23.75Q739.29-276.3 744-290v-101q-24.25 13.22-53.62 23.61Q661-357 627.17-350.15q-33.83 6.85-71 10.5Q519-336 479.5-336t-77.11-3.65q-37.62-3.65-71-10.5Q298-357 268.5-367.5 239-378 216-391v103q5 13 30.5 26t63 23q37.5 10 82.5 16.5t88.32 6.5Z"></path>
      </g>
      <g id="database-off" viewBox="0 -960 960 960">
        <path d="M449-449Zm97-87Zm-97 87Zm97-87Zm-97 87Zm97-87ZM768-90 90-768l51-51 678 678-51 51Zm-287.52-54Q339-144 241.5-185.85T144-288v-384q0-23 16-44.5t45-38.5l226 226q-65-4-120.5-18T216-583v109q44 32 111.5 49T480-408q17.96 0 35.02-.5 17.06-.5 34.12-2.5L612-348q-31 6-64.07 9-33.07 3-67.93 3-80 0-148.5-14.5T216-391v103q10 26 93.5 49T480-216q62 0 123-12t99-29l53 52q-45.91 28.22-117.59 44.61Q565.74-144 480.48-144ZM807-255l-63-63v-73q-11 6-23.94 11.33Q707.12-374.33 693-369l-57-57q32-8 59-20t49-28v-109q-40 22-94.5 35T532-530l-70-70q23 1 65-2.5t85.5-12q43.5-8.5 81-22.5t50.5-35q-18-28-98.5-50T480-744q-37 0-74 4.5T335-727l-59-59q43-14 94.5-22t109.5-8q139.07 0 237.53 42Q816-732 816-672v384q0 8-2 16.5t-7 16.5Z"></path>
      </g>
      <g id="developer-board" viewBox="0 -960 960 960">
        <path d="M168-144q-29 0-50.5-21.5T96-216v-528q0-29.7 21.5-50.85Q139-816 168-816h528q29 0 50.5 21.15T768-744v72h96v72h-96v84h96v72h-96v84h96v72h-96v71.5q0 29.5-21.5 51T696-144H168Zm0-72h528v-528H168v528Zm72-72h192v-144H240v144Zm240-288h144v-96H480v96Zm-240 96h192v-192H240v192Zm240 192h144v-240H480v240ZM168-744v528-528Z"></path>
      </g>
      <g id="developer-board-off" viewBox="0 -960 960 960">
        <path d="M803-56 56-803l51-50 746 746-50 51ZM246-816h449.54Q726-816 747-794.5t21 51v71.5h96v72h-96v84h96v72h-96v84h96v72h-90l-78-78v-378H318l-72-72Zm186 186-42-42h42v42Zm54 54-6-6v-90h144v96H486Zm138 138-90-90h90v90Zm-192 12Zm81-122ZM240-288v-144h192v144H240Zm-90-522 66 66h-48v528h529v-47l71 71q-9 19-29.5 33.5T696-144H168q-29 0-50.5-21.5T96-216v-528q0-22.66 16.5-40.33Q129-802 150-810Zm330 330 160 160v32H480v-192ZM288-672l158 158v34H240v-192h48Z"></path>
      </g>
      <g id="devices-off" viewBox="0 -960 960 960">
        <path d="m366-696-72-72h522v72H366Zm498 480-72-72v-264H648v138l-72-72v-102q0-15.3 10.34-25.65Q596.68-624 611.96-624h215.76q15.28 0 25.78 10.35Q864-603.3 864-588v372ZM768-90 666-192h-54q-15.3 0-25.65-10.35Q576-212.7 576-228v-54L264-594v306h216v96H96v-96h96v-378L90-768l51-51 678 678-51 51Zm-48-261Z"></path>
      </g>
      <g id="drive-pdf" viewBox="0 -960 960 960">
        <path d="M612-384h48v-64h48v-48h-48v-32h48v-48h-96v192Zm-360 0h48v-64h36q20.4 0 34.2-13.8Q384-475.6 384-496v-32q0-20.4-13.8-34.2Q356.4-576 336-576h-84v192Zm48-112v-32h36v32h-36Zm132 112h84q20.4 0 34.2-13.8Q564-411.6 564-432v-96q0-20.4-13.8-34.2Q536.4-576 516-576h-84v192Zm48-48v-96h36v96h-36ZM216-144q-29.7 0-50.85-21.15Q144-186.3 144-216v-528q0-29.7 21.15-50.85Q186.3-816 216-816h528q29.7 0 50.85 21.15Q816-773.7 816-744v528q0 29.7-21.15 50.85Q773.7-144 744-144H216Zm0-72h528v-528H216v528Zm0-528v528-528Z"></path>
      </g>
      <g id="file-download-off" viewBox="0 -960 960 960">
        <path d="M768-90 666-192H264.09q-29.74 0-50.91-21.15Q192-234.3 192-264v-72h72v72h330l-93-93-21 21-192-192 21-21L90-768l51-51 678 678-51 51ZM603-459l-51-51 69-69 51 51-69 69Zm-87-87-72-72v-198h72v270Zm252 252-42-42h42v42Z"></path>
      </g>
      <g id="file-save" viewBox="0 -960 960 960">
        <path d="m732-120 144-144-51-51-57 57v-150h-72v150l-57-57-51 51 144 144ZM588 0v-72h288V0H588ZM264-144q-29 0-50.5-21.5T192-216v-576q0-29 21.5-50.5T264-864h312l192 192v192h-72v-144H528v-168H264v576h264v72H264Zm0-72v-576 576Z"></path>
      </g>
      <g id="file-save-off" viewBox="0 -960 960 960">
        <path d="m837-225-51-51 39-39 51 51-39 39Zm-69-69-72-71.81V-408h72v114ZM588 0v-72h198L264-594v378h265v72H264q-29 0-50.5-21.5T192-216v-450L56-803l51-50L888-72V0H588Zm108-480h72v-192L576-864H264q-13 0-26.5 5T216-846l54 54h258v168h168v144Zm-242 76Zm96-118Z"></path>
      </g>
      <g id="font-download" viewBox="0 -960 960 960">
        <path d="M257-240h83.34L384-363h193l43.31 123H703L523-720h-86L257-240Zm151-192 70-199h3l70 199H408ZM168-96q-29.7 0-50.85-21.15Q96-138.3 96-168v-624q0-29.7 21.15-50.85Q138.3-864 168-864h624q29.7 0 50.85 21.15Q864-821.7 864-792v624q0 29.7-21.15 50.85Q821.7-96 792-96H168Zm0-72h624v-624H168v624Zm0-624v624-624Z"></path>
      </g>
      <g id="font-download-off" viewBox="0 -960 960 960">
        <path d="m803-56-41-40H168q-29.7 0-50.85-21.15Q96-138.3 96-168v-594l-40-41 51-50 746 746-50 51ZM168-168h522L168-690v522Zm696-30-72-72v-522H270l-72-72h594q29.7 0 50.85 21.15Q864-821.7 864-792v594ZM632-430 509-553l-27-78h-4l-12 35-55-55 26-69h86l109 290Zm-205 2Zm82-124Zm105 301-51-146 130 130 6 16h-85Zm-358 11 127-337 57 57-31 88h119.1l68.9 69H386.98L344-240h-88Z"></path>
      </g>
      <g id="hand-gesture" viewBox="0 -960 960 960">
        <path d="M880-759q0-51-35-86t-86-35v-60q75 0 128 53t53 128h-60ZM240-40q-83 0-141.5-58.5T40-240h60q0 58 41 99t99 41v60Zm162 0q-30 0-56-13.5T303-92L48-465l24-23q19-19 45-22t47 12l116 81v-383q0-17 11.5-28.5T320-840q17 0 28.5 11.5T360-800v537L212-367l157 229q5 8 14 13t19 5h278q33 0 56.5-23.5T760-200v-560q0-17 11.5-28.5T800-800q17 0 28.5 11.5T840-760v560q0 66-47 113T680-40H402Zm38-440v-400q0-17 11.5-28.5T480-920q17 0 28.5 11.5T520-880v400h-80Zm160 0v-360q0-17 11.5-28.5T640-880q17 0 28.5 11.5T680-840v360h-80ZM486-300Z"></path>
      </g>
      <g id="hand-gesture-off" viewBox="0 -960 960 960">
        <path d="m840-234-80-80v-446q0-17 11.5-28.5T800-800q17 0 28.5 11.5T840-760v526ZM360-714l-80-80v-6q0-17 11.5-28.5T320-840q17 0 28.5 11.5T360-800v86Zm160 160-80-80v-246q0-17 11.5-28.5T480-920q17 0 28.5 11.5T520-880v326Zm160 75h-80v-361q0-17 11.5-28.5T640-880q17 0 28.5 11.5T680-840v361Zm37 349L360-487v252l-158-79 177 176q8 7 16 12.5t18 5.5h267q10 0 19.5-2.5T717-130ZM413-40q-24 0-46-9t-39-26L39-364l54-43q18-14 41-16.5t44 8.5l102 50v-202L27-820l57-57L876-85l-57 57-44-44q-20 15-44 23.5T680-40H413Zm187-439Zm280-280q0-51-35-86t-86-35v-60q75 0 128 53t53 128h-60ZM240-40q-83 0-141.5-58.5T40-240h60q0 58 41 99t99 41v60Zm304-264Z"></path>
      </g>
      <g id="hide-image" viewBox="0 -960 960 960">
        <path d="m816-246-72-72v-426H318l-72-72h498q29 0 50.5 21.5T816-744v498ZM768-90l-54-54H216q-29 0-50.5-21.5T144-216v-498l-54-54 51-51 678 678-51 51ZM264-288l108-144 72 96 34-45-262-261v426h426l-72-72H264Zm264-240ZM426-426Z"></path>
      </g>
      <g id="imagesmode" viewBox="0 -960 960 960">
        <path d="M216-144q-29.7 0-50.85-21.5Q144-187 144-216v-528q0-29 21.15-50.5T216-816h528q29.7 0 50.85 21.5Q816-773 816-744v528q0 29-21.15 50.5T744-144H216Zm0-72h528v-528H216v528Zm48-72h432L552-480 444-336l-72-96-108 144Zm-48 72v-528 528Zm120-360q20 0 34-14t14-34q0-20-14-34t-34-14q-20 0-34 14t-14 34q0 20 14 34t34 14Z"></path>
      </g>
      <g id="location-off" viewBox="0 -960 960 960">
        <path d="M480.28-96q-13.71 0-23.49-7.5Q447-111 443-123q-19-53-45.5-100.5T321-335q-49.21-63.41-79.61-121.06Q211-513.71 211-595.37q0-33.63 8-64.63 8-31 22-59l55 54q-6 17-9.5 34t-3.5 36q0 69.29 27 115.64Q337-433 378-379q42 55.45 63.5 88.73Q463-257 480-223q17-34 38.5-67.27Q540-323.55 582-379l51 52q-49 64-74 109t-42 95q-5 12-14.5 19.5T480.28-96ZM677-386l-52-52q23-35 37.5-71.3T677-595q0-81-58-139t-139-58q-44 0-81 17.5T335-728l-52-51q37.06-39.53 87.77-62.27Q421.49-864 480-864q112.4 0 190.7 78.3Q749-707.4 749-595q0 67.39-20.5 116.22T677-386Zm91 296L90-769l51-51 678 679-51 51ZM542-521q15.91-13.73 25.45-32.37Q577-572 577-595q0-40-28.5-68.5T480-692q-23 0-41.63 9.55Q419.73-672.91 406-657l136 136Zm-68-68Zm-63 141Z"></path>
      </g>
      <g id="lock" viewBox="0 -960 960 960">
        <path d="M266.59-88.59q-34.26 0-58.49-24.38-24.23-24.38-24.23-58.62v-378.26q0-34.24 24.38-58.62 24.38-24.38 58.62-24.38h17.54v-89.06q0-81.6 57.19-138.95 57.18-57.36 138.63-57.36 81.44 0 138.4 57.36 56.96 57.35 56.96 138.95v89.06h17.54q34.24 0 58.62 24.38 24.38 24.38 24.38 58.62v378.26q0 34.24-24.39 58.62-24.4 24.38-58.65 24.38h-426.5Zm.28-83h426.26v-378.26H266.87v378.26Zm213.34-117.13q29.79 0 50.79-21.21t21-51q0-29.79-21.21-50.79t-51-21q-29.79 0-50.79 21.21-21 21.22-21 51 0 29.79 21.21 50.79t51 21Zm-112.8-344.13h225.18v-89.06q0-47.21-32.73-80.26-32.73-33.05-79.86-33.05t-79.86 33.05q-32.73 33.05-32.73 80.26v89.06ZM266.87-171.59v-378.26 378.26Z"></path>
      </g>
      <g id="mic" viewBox="0 -960 960 960">
        <path d="M480-384q-50 0-85-35t-35-85v-240q0-50 35-85t85-35q50 0 85 35t35 85v240q0 50-35 85t-85 35Zm0-240Zm-36 480v-99q-98.8-13.1-163.4-87.05Q216-404 216-504h72q0 79.68 56.23 135.84 56.22 56.16 136 56.16Q560-312 616-368.16q56-56.16 56-135.84h72q0 100-64.6 173.95Q614.8-256.1 516-243v99h-72Zm36-312q20.4 0 34.2-13.8Q528-483.6 528-504v-240q0-20.4-13.8-34.2Q500.4-792 480-792q-20.4 0-34.2 13.8Q432-764.4 432-744v240q0 20.4 13.8 34.2Q459.6-456 480-456Z"></path>
      </g>
      <g id="mic-off" viewBox="0 -960 960 960">
        <path d="m701-361-53-53q11-21 17.33-43.4 6.33-22.41 6.33-46.6H744q0 38-11.18 74.38Q721.64-393.24 701-361ZM477-583Zm117.24 115L528-534v-210q0-20.4-13.8-34.2Q500.4-792 480-792q-20.4 0-34.2 13.8Q432-764.4 432-744v114l-72-72.38V-744q0-50 35-85t85-35q50 0 85 35t35 85v240q0 9-1.5 18t-4.26 18ZM444-144v-99q-99-12-163.5-86.5T216-504h72q0 79.68 56 135.84T480-312q34 0 64.5-13t56.5-35l52 52q-29.3 25.09-64.15 42.55Q554-248 516-243v99h-72Zm324 54L90-769l51-51 678 679-51 51Z"></path>
      </g>
      <g id="notifications" viewBox="0 -960 960 960">
        <path d="M192-216v-72h48v-240q0-87 53.5-153T432-763v-53q0-20 14-34t34-14q20 0 34 14t14 34v53q85 16 138.5 82T720-528v240h48v72H192Zm288-276Zm-.21 396Q450-96 429-117.15T408-168h144q0 30-21.21 51t-51 21ZM312-288h336v-240q0-70-49-119t-119-49q-70 0-119 49t-49 119v240Z"></path>
      </g>
      <g id="notifications-off" viewBox="0 -960 960 960">
        <path d="M192-216v-72h48v-240q0-41 13.5-78.5T290-677l53 53q-15 21-23 45.75T312-528v240h264L90-774l51-52 678 679-51 51-120-120H192Zm528-132-72-72v-108q0-70-49-119t-119-49q-22.84 0-43.92 6Q415-684 395-673l-52-52.51Q363-740 385.5-749q22.5-9 46.5-14v-53q0-20 14-34t34-14q20 0 34 14t14 34v53q85 16 138.5 82T720-528v180Zm-276-72Zm35.79 324Q450-96 429-117.15T408-168h144q0 30-21.21 51t-51 21ZM522-547Z"></path>
      </g>
      <g id="open-in-browser" viewBox="0 -960 960 960">
        <path d="M216-144q-29.7 0-50.85-21.15Q144-186.3 144-216v-528q0-29.7 21.15-50.85Q186.3-816 216-816h528q29.7 0 50.85 21.15Q816-773.7 816-744v528q0 29.7-21.15 50.85Q773.7-144 744-144H576v-72h168v-456H216v456h168v72H216Zm228 0v-246l-57 57-51-51 144-144 144 144-51 51-57-57v246h-72Z"></path>
      </g>
      <g id="open-in-new-off" viewBox="0 -960 960 960">
        <path d="m768-90-54-54H216q-29.7 0-50.85-21.15Q144-186.3 144-216v-498l-54-54 51-51 678 678-51 51ZM216-216h426L455-404l-68 68-51-51 68-68-188-187v426Zm102-528-72-72h234v72H318Zm238 239-51-51 188-188H576v-72h240v240h-72v-117L556-505Zm260 259-72-72v-162h72v234Z"></path>
      </g>
      <g id="page-info" viewBox="0 -960 960 960">
        <path d="M699.83-133.48q-62.16 0-105.23-43.07-43.08-43.08-43.08-105.23 0-62.16 43.08-105.23 43.07-43.08 105.23-43.08 62.15 0 105.23 43.08 43.07 43.07 43.07 105.23 0 62.15-43.07 105.23-43.08 43.07-105.23 43.07Zm.12-80.61q28.09 0 47.83-19.86t19.74-47.95q0-28.1-19.86-47.84-19.86-19.74-47.96-19.74-28.09 0-47.83 19.86t-19.74 47.96q0 28.09 19.86 47.83t47.96 19.74ZM150.3-240.28v-83h329.22v83H150.3Zm109.87-289.63q-62.15 0-105.23-43.08-43.07-43.07-43.07-105.23 0-62.15 43.07-105.23 43.08-43.07 105.23-43.07 62.16 0 105.23 43.07 43.08 43.08 43.08 105.23 0 62.16-43.08 105.23-43.07 43.08-105.23 43.08Zm.13-80.61q28.09 0 47.83-19.86t19.74-47.96q0-28.09-19.86-47.83t-47.96-19.74q-28.09 0-47.83 19.86t-19.74 47.95q0 28.1 19.86 47.84 19.86 19.74 47.96 19.74Zm220.18-26.2v-83H809.7v83H480.48Zm219.35 354.94ZM260.17-678.22Z"></path>
      </g>
      <g id="piano" viewBox="0 -960 960 960">
        <path d="M216-144q-29 0-50.5-21.5T144-216v-528q0-29.7 21.5-50.85Q187-816 216-816h528q29.7 0 50.85 21.15Q816-773.7 816-744v528q0 29-21.15 50.5T744-144H216Zm0-72h120v-168h-24q-10.2 0-17.1-6.9-6.9-6.9-6.9-17.1v-336h-72v528Zm408 0h120v-528h-72v336q0 10.2-6.9 17.1-6.9 6.9-17.1 6.9h-24v168Zm-240 0h192v-168h-24q-10.2 0-17.1-6.9-6.9-6.9-6.9-17.1v-336h-96v336q0 10.2-6.9 17.1-6.9 6.9-17.1 6.9h-24v168Z"></path>
      </g>
      <g id="piano-off" viewBox="0 -960 960 960">
        <path d="m768-90-54-54H216q-29.7 0-50.85-21.15Q144-186.3 144-216v-498l-54-54 51-51 678 678-51 51Zm48-156-72-72v-426h-72v336q0 3.67-1.5 7.33Q669-397 667-395L528-534v-210h-96v114L246-816h498q29.7 0 50.85 21.15Q816-773.7 816-744v498Zm-600 30h120v-168h-24q-10.2 0-17.1-6.9-6.9-6.9-6.9-17.1v-162l-72-72v426Zm168 0h192v-66L432-426v18q0 10-7 17t-17 7h-24v168Zm240-2h9l-9-9v9Z"></path>
      </g>
      <g id="protocol-handler" viewBox="0 -960 960 960">
        <path d="M378-173q-10 0-19-4t-17-12L108-448q-6-7-9-15.5T96-480q0-9 3-17t9-15l234-259q8-8 17-12t19-4q10 0 18.5 4t16.5 12l67 74 67-74q8-8 16.5-12t18.5-4q10 0 19 4t17 12l234 259q6 7 9 15.5t3 16.5q0 8-3 16.5t-9 15.5L618-189q-8 8-17 12t-19 4q-10 0-18.5-4T547-189l-67-74-67 74q-8 8-16.5 12t-18.5 4Zm0-84 54-59-120-132q-12-14-12-32t12-32l120-132-54-59-202 223 202 223Zm204 0 202-223-202-223-54 59 120 132q12 14 12 32t-12 32L528-316l54 59Z"></path>
      </g>
      <g id="protocol-handler-off" viewBox="0 -960 960 960">
        <path d="M768-90 642-216l-24 27q-7 8-16 12t-20 4q-11 0-20-4t-15-12l-67-74-67 74q-7 8-16 12t-19 4q-11 0-20-4t-16-12L108-448q-6-6-9-14.5T96-480q0-9 3-17t9-15l113-125L90-768l51-51 678 678-51 51ZM591-267l-56-57 56 57Zm-213 10 54-59-120-132q-12-14-12-32t12-32l16-18-56-56-96 106 202 223Zm361-66-51-51 96-106-209-216-47 52 120 132q12 14 12 32t-12 32l-16 18-208-208-55-55-51-51 24-27q8-8 16.5-12t19.5-4q10 0 19 4t16 12l67 74 67-74q7-8 16-12t19-4q11 0 20 4t16 12l234 259q6 7 9 15t3 17q0 9-3 17t-9 15L739-323Z"></path>
      </g>
      <g id="select-window" viewBox="0 -960 960 960">
        <path d="M168-96q-29.7 0-50.85-21.15Q96-138.3 96-168v-336q0-29.7 21.15-50.85Q138.3-576 168-576h72v-216q0-29.7 21.15-50.85Q282.3-864 312-864h480q29.7 0 50.85 21.15Q864-821.7 864-792v336q0 29.7-21.15 50.85Q821.7-384 792-384h-72v216q0 29.7-21.15 50.85Q677.7-96 648-96H168Zm0-72h480v-264H168v264Zm552-288h72v-264H312v144h336q29.7 0 50.85 21.15Q720-533.7 720-504v48Z"></path>
      </g>
      <g id="select-window-off" viewBox="0 -960 960 960">
        <path d="M803-56 427-432H168v264h480v-144l72 71.75v72.65q0 29.6-21.15 50.6T648-96H168q-29.7 0-50.85-21.15Q96-138.3 96-168v-336.18q0-30.82 21-52.32t51-19.5h72v-42L56-803l51-50 746 746-50 51Zm-83-286-98-98-136-136h162q31 0 51.5 20.5T720-504v48h72v-264H342l-97-97q7-22 25.64-34.5Q289.27-864 312-864h480q29.7 0 50.85 21.15Q864-821.7 864-792v336q0 29.7-21.15 50.85Q821.7-384 792-384h-72v42Z"></path>
      </g>
      <g id="sensors" viewBox="0 -960 960 960">
        <path d="M209-209q-53-52-83-121.48T96-479.5q0-80.5 30-150T208-752l51 51q-42 43-66.5 99.6Q168-544.8 168-480.39q0 65.39 24.47 121.93Q216.94-301.92 260-260l-51 51Zm101-101q-32-33-51-76.5t-19-93.23q0-50.73 19-94T310-650l51 51q-22.94 23.21-35.97 53.79Q312-514.62 312-479.81t13.03 65.26Q338.06-384.1 361-361l-51 51Zm169.75-86q-34.75 0-59.25-24.75t-24.5-59.5q0-34.75 24.75-59.25t59.5-24.5q34.75 0 59.25 24.75t24.5 59.5q0 34.75-24.75 59.25t-59.5 24.5ZM649-311l-50-50q22.94-23.21 35.97-53.79Q648-445.38 648-480.19t-13.03-65.26Q621.94-575.9 599-599l51-51q32 33 51 76.34t19 94.16q0 49.82-19 93.16Q682-343 649-311Zm102 102-51-51q43-42 67.5-98.6Q792-415.2 792-479.61q0-65.39-24.5-121.89T701-701l51-51q52 53 82 122.48t30 149.98q0 79.54-30 149.04Q804-261 751-209Z"></path>
      </g>
      <g id="sensors-off" viewBox="0 -960 960 960">
        <path d="M768-90 322-536q-5 13-7.5 27t-2.5 29q0 35 13 65.5t36 53.5l-50 50q-33-32-52-75.5T240-480q0-30 7.5-57.5T268-590l-53-54q-22 36-34.5 77.5T168-480q0 65 24.5 121.5T260-260l-51 51q-53-52-83-121.5T96-480q0-60 17-114.5T162-696l-72-72 51-51 678 678-51 51Zm30-174-53-52q22-36 34.5-77.5T792-480q0-65-24.5-121.5T700-700l51-51q53 52 83 121.5T864-480q0 60-17 115t-49 101ZM693-369l-55-55q5-14 7.5-27.5T648-480q0-35-13-65.5T599-599l50-50q33 32 52 75.5t19 93.5q0 30-6.5 58T693-369Z"></path>
      </g>
      <g id="smart-card-reader" viewBox="0 -960 960 960">
        <path d="M80-80v-120q0-33 23.5-56.5T160-280h640q33 0 56.5 23.5T880-200v120H80Zm80-80h640v-40H160v40Zm40-180v-460q0-33 23.5-56.5T280-880h400q33 0 56.5 23.5T760-800v460h-80v-460H280v460h-80Zm120-60h23q44 0 70.5-44T440-560q0-72-26.5-116T343-720h-23v320Zm240-80q33 0 56.5-23.5T640-560q0-33-23.5-56.5T560-640q-33 0-56.5 23.5T480-560q0 33 23.5 56.5T560-480Zm-80 320Zm0-410Z"></path>
      </g>
      <g id="smart-card-reader-off" viewBox="0 -960 960 960">
        <path d="M680-932q33 0 56.5 23.5T760-852v460h-28l-52-52v-408H273l-53-53q11-13 26.5-20t33.5-7h400Zm-91 396L485-639q9-23 29-38t46-15q33 0 56.5 23.5T640-612q0 26-14 46.5T589-536Zm-269 86v-242l118 118q-7 57-32 90.5T343-450h-23ZM160-212h527l-40-40H160v40ZM819-80l-52-52H80v-120q0-33 23.5-56.5T160-332h407L280-620v228h-80v-308L28-872l56-56 792 791-57 57ZM424-212Zm52-436Zm-82 142Z"></path>
      </g>
      <g id="storage-access" viewBox="0 -960 960 960">
        <path d="M312-255q-97-32-156.5-113.5T96-552q0-130 91-221t221-91q102 0 183.5 59.5T705-648h-77q-29-66-88.5-105T408-792q-100 0-170 70t-70 170q0 72 39 131t105 88v78ZM456-96q-29.7 0-50.85-21.15Q384-138.3 384-168v-336q0-29.7 21.15-50.85Q426.3-576 456-576h336q29.7 0 50.85 21.15Q864-533.7 864-504v336q0 29.7-21.15 50.85Q821.7-96 792-96H456Zm0-72h336v-336H456v336Zm24-48h288l-91-120-72 95-53-71-72 96Zm144-120ZM398-563Z"></path>
      </g>
      <g id="storage-access-off" viewBox="0 -960 960 960">
        <path d="m864-198-72-72v-234H558l-72-72h306q29.7 0 50.85 21.15Q864-533.7 864-504v306ZM628-648q-29-66-88.5-105T408-792q-28.71 0-56.35 7Q324-778 298-764l-54-53q38-23 79.33-35T408-864q102 0 183.5 59.5T705-648h-77Zm-55 363ZM803-55l-41-41H456q-29.7 0-50.85-21.15Q384-138.3 384-168v-306L195-663q-13 25-20 52.95-7 27.95-7 58.05 0 72 39 131t105 88v78q-97-32-156.5-113.5T96-552q0-45.35 12-86.68Q120-680 142-716l-86-86 51-51 747 747-51 51ZM434-646Zm-77 43Zm123 387 71-96 61 62 42-56 90 90H480Zm-24 48h234L456-402v234Zm219-219Z"></path>
      </g>
      <g id="sync-off" viewBox="0 -960 960 960">
        <path d="M768-141 625-284q-17 10-35 18.5T552-252v-76q5-2 10-4.5t10-4.5L286-624q-10 21-16 44.5t-6 48.5q0 48 19.5 89t52.5 70v-63h72v192H216v-72h74q-45-40-71.5-95.5T192-531q0-40 10.5-77t29.5-69L90-820l51-51 678 679-51 51Zm-40-244-54-54q10-21 16-44t6-48q0-48-19.5-89.5T624-691v64h-72v-192h192v72h-74q45 40 71.5 95.5T768-531q0 40-10.5 77T728-385ZM388-725l-53-54q17-10 35-18t38-13v76q-5 2-10 4.5t-10 4.5Z"></path>
      </g>
      <g id="sync-saved-locally" viewBox="0 -960 960 960">
        <path d="m437-402 221-221-55-54-166 166-81-81-55 54 136 136ZM48-144v-72h864v72H48Zm120-120q-29.7 0-50.85-21.15Q96-306.3 96-336v-408q0-29.7 21.15-50.85Q138.3-816 168-816h624q29.7 0 50.85 21.15Q864-773.7 864-744v408q0 29.7-21.15 50.85Q821.7-264 792-264H168Zm0-72h624v-408H168v408Zm0 0v-408 408Z"></path>
      </g>
      <g id="sync-saved-locally-off" viewBox="0 -960 960 960">
        <path d="m797-264-71-72h66v-408H318l-72-72h546q29.7 0 50.85 21.15Q864-773.7 864-744v408q0 27.6-19 48.3-19 20.7-48 23.7Zm6 208-89.05-88H48v-72h594l-48-48H168q-29.7 0-50.85-21.15Q96-306.3 96-336v-408q0-4 .5-8t1.5-8l-42-42 51-51 746 747-50 50ZM522-336 168-690v354h354Zm0-204Zm-177 27Zm149-55 109-109 55 54-109 109-55-54Z"></path>
      </g>
      <g id="usb" viewBox="0 -960 960 960">
        <path d="M479.79-96Q450-96 429-117.15T408-168q0-19.53 9.5-36.26Q427-221 444-230v-106H324q-29.7 0-50.85-21.04Q252-378.08 252-407.63V-490q-17-9-26.5-25.5T216-552q0-29.7 21.21-50.85 21.21-21.15 51-21.15T339-602.85q21 21.15 21 50.85 0 20-9.5 36.5T324-490v82h120v-312h-84l120-144 120 144h-84v312h120v-72h-36v-144h144v144h-36v72q0 29.7-21.15 50.85Q665.7-336 636-336H516v106q17.1 9.11 26.55 25.5 9.45 16.4 9.45 36.44Q552-138 530.79-117q-21.21 21-51 21Z"></path>
      </g>
      <g id="usb-off" viewBox="0 -960 960 960">
        <path d="M768-90 521.58-336H516v106q17.1 8.94 26.55 25.47T552-168q0 29.7-21.21 50.85Q509.58-96 479.79-96T429-117.15Q408-138.3 408-168q0-20 9.5-36t26.5-26v-106H324q-29.7 0-50.85-21.04Q252-378.08 252-407.63V-490q-17-8-26.5-25.22Q216-532.45 216-552q0-17 8.5-32.5T247-611L90-768l51-51 678 678-51 51Zm-73-277-59-59v-54h-36v-144h144v144h-36v72q0 11.08-2.89 21.61T695-367Zm-371-41h120v-6l-97-97q-5 7-10.5 11.5T324-490v82Zm192-138-72-72v-102h-84l120-144 120 144h-84v174Z"></path>
      </g>
      <g id="v8" viewBox="0 -960 960 960">
        <path d="M480-242q-82 0-140.5-58.5T281-441q0-37.71 14-72.36Q309-548 335-575q-9-18-14-36.56-5-18.56-5-38.42 0-68.2 48.21-116.11Q412.41-814 480-814q68.19 0 116.09 47.94Q644-718.11 644-649.87q0 19.87-5 38.87-5 19-14 36 26 27 40 61.64 14 34.65 14 72.36 0 82-58.5 140.5T480-242Zm-.05-48Q543-290 587-333.97T631-441q0-32-13.5-61T579-553l-16-14 12-18q10-14 15.5-30.5T596-650q0-48.18-33.87-82.09-33.87-33.91-82-33.91T398-732.09q-34 33.91-34 82.09 0 17 5.5 33.5T385-585l11 18-15 14q-25 22-38.5 51T329-441q0 63.06 43.95 107.03 43.96 43.97 107 43.97ZM248-523l-50-91h-52L72-744h219q-11 21-17 44.5t-6 49.5q0 16.67 3 33.33 3 16.67 8 33.67-10 14-17.5 29T248-523ZM480-96l-57-106q13.94 3.2 27.87 5.6 13.94 2.4 29.03 2.4 15.1 0 29.1-2.4 14-2.4 28-5.6L480-96Zm232-427q-6.3-15.74-13.65-30.87Q691-569 681-583q5-17 8-33.67 3-16.66 3-33.33 0-26-6-49.5T669-744h219l-74 130h-52l-50 91Zm-232-77q20 0 34-14t14-34q0-20-14-34t-34-14q-20 0-34 14t-14 34q0 20 14 34t34 14Zm.1 228q24.9 0 42.4-17.57T540-432q0-25-17.5-42.5T480-492q-24.86 0-42.43 17.6T420-431.9q0 24.9 17.6 42.4t42.5 17.5Zm-.1-156Z"></path>
      </g>
      <g id="videocam-off" viewBox="0 -960 960 960">
        <path d="M864-289 720-433v90l-72-72v-281H366l-72-72h354q29.7 0 50.85 21.15Q720-725.7 720-696v167l144-144v384ZM803-57 56-803l51-51 747 746-51 51ZM507-556ZM406-455ZM194-766l70 69h-48v433h432v-50l72 72q-8 20-25 35t-46.72 15H216q-29 0-50.5-21.19T144-264.14V-697q0-25.58 14.5-43.79T194-766Z"></path>
      </g>
      <g id="videogame-asset" viewBox="0 -960 960 960">
        <path d="M168-240q-29.7 0-50.85-21.5Q96-283 96-312v-336q0-29 21.15-50.5T168-720h624q29.7 0 50.85 21.5Q864-677 864-648v336q0 29-21.15 50.5T792-240H168Zm0-72h624v-336H168v336Zm122-48h72v-84h84v-72h-84v-84h-72v84h-84v72h84v84Zm286-12q25 0 42.5-17.5T636-432q0-25-17.5-42.5T576-492q-25 0-42.5 17.5T516-432q0 25 17.5 42.5T576-372Zm120-96q25 0 42.5-17.5T756-528q0-25-17.5-42.5T696-588q-25 0-42.5 17.5T636-528q0 25 17.5 42.5T696-468ZM168-312v-336 336Z"></path>
      </g>
      <g id="videogame-asset-off" viewBox="0 -960 960 960">
        <path d="M696-468q-25 0-42.5-17.5T636-528q0-25 17.5-42.5T696-588q25 0 42.5 17.5T756-528q0 25-17.5 42.5T696-468Zm-319-8Zm-89 116v-84h-84v-72h84v-84h72v84h84v72h-84v84h-72ZM168-240q-29 0-50.5-21.5T96-312v-336q0-29 20.2-50.5Q136.39-720 165-720h75l72 72H168v336h378L90-768l51-51 678 678-51 51-150-150H168Zm696-72q0 23.24-12 41.12T817-245l-25-25v-378H414l-72-72h450q29 0 50.5 21.5T864-648v336ZM603-459Z"></path>
      </g>
      <g id="volume-up" viewBox="0 -960 960 960">
        <path d="M552-152v-75q86-23 139-93.26 53-70.25 53-159.5 0-89.24-53.5-158.74Q637-708 552-734v-75q116 25 190 117t74 211q0 119-73.5 211.5T552-152ZM144-385v-192h144l192-192v576L288-385H144Zm408 55v-302q45.12 20.4 70.56 61.2Q648-530 648-480.52q0 48.52-25.44 89.23Q597.12-350.59 552-330ZM408-595l-90 90H216v48h102l90 90v-228Zm-91 113Z"></path>
      </g>
      <g id="volume-off" viewBox="0 -960 960 960">
        <path d="M768-90 661-197q-22 14-52.5 26.5T552-152v-74q12-5 28.5-11.5T608-250L480-378v187L288-383H144v-192h138L90-768l51-51 678 678-51 51Zm-6-209-52-52q16-29 25-61.5t9-66.5q0-89-53.5-158.5T552-733v-74q117 23 190.5 116T816-479q0 48-14 93.5T762-299ZM638-423l-86-86v-122q45 20 70.5 61.5T648-479q0 14-2 28t-8 28ZM480-581l-93-93 93-93v186Zm-72 216v-85l-72-72-18 19H216v48h102l90 90Zm-36-121Z"></path>
      </g>
      <g id="warning" viewBox="0 -960 960 960">
        <path d="m48-144 432-720 432 720H48Zm127-72h610L480-724 175-216Zm304.79-48q15.21 0 25.71-10.29t10.5-25.5q0-15.21-10.29-25.71t-25.5-10.5q-15.21 0-25.71 10.29t-10.5 25.5q0 15.21 10.29 25.71t25.5 10.5ZM444-384h72v-192h-72v192Zm36-86Z"></path>
      </g>
      <g id="web-asset" viewBox="0 -960 960 960">
        <path d="M168-192q-29.7 0-50.85-21.16Q96-234.32 96-264.04v-432.24Q96-726 117.15-747T168-768h624q29.7 0 50.85 21.16Q864-725.68 864-695.96v432.24Q864-234 842.85-213T792-192H168Zm0-72h624v-360H168v360Z"></path>
      </g>
      <g id="web-asset-off" viewBox="0 -960 960 960">
        <path d="M803-56 666-192H168q-29.7 0-50.85-21.16Q96-234.32 96-264.04v-432.24Q96-726 118.03-747T171-768h11v91L56-803l51-50 746 746-50 51ZM168-264h426L234-624h-66v360Zm678 48-54-54v-354H438L294-768h498q29.7 0 50.85 21.15Q864-725.7 864-696v432q0 13.79-5 26.9-5 13.1-13 21.1Z"></path>
      </g>
      <g id="zoom-in" viewBox="0 -960 960 960">
        <path d="M765-144 526-384q-30 23-65.79 35.5-35.79 12.5-76.18 12.5Q284-336 214-406t-70-170q0-100 70-170t170-70q100 0 170 70t70 170.03q0 40.39-12.5 76.18Q599-464 577-434l239 239-51 51ZM384-408q70 0 119-49t49-119q0-70-49-119t-119-49q-70 0-119 49t-49 119q0 70 49 119t119 49Zm-36-60v-72h-72v-72h72v-72h72v72h72v72h-72v72h-72Z"></path>
      </g>
    </defs>
  </svg>
</cr-iconset>
`;const iconsets=div.querySelectorAll("cr-iconset");for(const iconset of iconsets){document.head.appendChild(iconset)}const styleMod=document.createElement("dom-module");styleMod.appendChild(html$1`
  <template>
    <style include="cr-shared-style settings-shared settings-columned-section">
:host{display:block;flex:1;padding:0 24px}.welcome-completion-header{align-items:center;display:flex;flex:1;flex-direction:column;justify-content:space-between;text-align:center}.welcome-completion-header picture{animation:fade-in 1500ms,slide-in 300ms}.welcome-completion-header-label{align-self:center;color:var(--google-grey-800);font-size:22px;font-weight:400;line-height:1.15;justify-content:center;outline:none;padding:0}@media (prefers-color-scheme:dark){.welcome-completion-header-label{color:var(--google-grey-200)}}.settings-fragment-header{align-items:center;display:flex;flex-direction:column;outline:none;padding:24px 0 16px 0}.settings-fragment-header-label{animation:fade-in var(--privacy-guide-animation-duration);align-self:center;color:var(--cr-primary-text-color);font-size:138%;font-weight:400;justify-content:center}@keyframes fade-in{0%{opacity:0}100%{opacity:1}}@keyframes slide-in{0%{transform:translateX(calc(var(--privacy-guide-translate-multiplier) * 20px))}100%{transform:translateX(0)}}.welcome-completion-header-label,.cr-secondary-text,.settings-fragment-header picture,.fragment-content{animation:fade-in var(--privacy-guide-animation-duration),slide-in 450ms}.embedded-setting-wrapper{border:1px solid var(--google-grey-300);border-radius:4px}@media (prefers-color-scheme:dark){.embedded-setting-wrapper{border-color:var(--google-grey-700)}}settings-collapse-radio-button:not(:first-of-type){--settings-collapse-separator-line:var(--cr-separator-line)}settings-toggle-button{padding-bottom:8px;padding-top:8px}picture{align-items:center;display:flex}
    </style>
  </template>
`.content);styleMod.register("privacy-guide-fragment-shared");
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var TimePeriod;(function(TimePeriod){TimePeriod[TimePeriod["LAST_HOUR"]=0]="LAST_HOUR";TimePeriod[TimePeriod["LAST_DAY"]=1]="LAST_DAY";TimePeriod[TimePeriod["LAST_WEEK"]=2]="LAST_WEEK";TimePeriod[TimePeriod["FOUR_WEEKS"]=3]="FOUR_WEEKS";TimePeriod[TimePeriod["ALL_TIME"]=4]="ALL_TIME";TimePeriod[TimePeriod["LAST_15_MINUTES"]=6]="LAST_15_MINUTES";TimePeriod[TimePeriod["TIME_PERIOD_LAST"]=6]="TIME_PERIOD_LAST"})(TimePeriod||(TimePeriod={}));var BrowsingDataType;(function(BrowsingDataType){BrowsingDataType[BrowsingDataType["HISTORY"]=0]="HISTORY";BrowsingDataType[BrowsingDataType["CACHE"]=1]="CACHE";BrowsingDataType[BrowsingDataType["SITE_DATA"]=2]="SITE_DATA";BrowsingDataType[BrowsingDataType["FORM_DATA"]=4]="FORM_DATA";BrowsingDataType[BrowsingDataType["SITE_SETTINGS"]=5]="SITE_SETTINGS";BrowsingDataType[BrowsingDataType["DOWNLOADS"]=6]="DOWNLOADS";BrowsingDataType[BrowsingDataType["HOSTED_APPS_DATA"]=7]="HOSTED_APPS_DATA"})(BrowsingDataType||(BrowsingDataType={}));class ClearBrowsingDataBrowserProxyImpl{clearBrowsingData(dataTypes,timePeriod){return sendWithPromise("clearBrowsingData",dataTypes,timePeriod)}initialize(){return sendWithPromise("initializeClearBrowsingData")}getSyncState(){return sendWithPromise("getSyncState")}restartCounters(isBasic,timePeriod){chrome.send("restartClearBrowsingDataCounters",[isBasic,timePeriod])}recordSettingsClearBrowsingDataBasicTimePeriodHistogram(bucket){chrome.send("metricsHandler:recordInHistogram",["Settings.ClearBrowsingData.Basic.TimePeriod",bucket,TimePeriod.TIME_PERIOD_LAST])}recordSettingsClearBrowsingDataAdvancedTimePeriodHistogram(bucket){chrome.send("metricsHandler:recordInHistogram",["Settings.ClearBrowsingData.Advanced.TimePeriod",bucket,TimePeriod.TIME_PERIOD_LAST])}static getInstance(){return instance$a||(instance$a=new ClearBrowsingDataBrowserProxyImpl)}static setInstance(obj){instance$a=obj}}let instance$a=null;
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var TrustSafetyInteraction;(function(TrustSafetyInteraction){TrustSafetyInteraction[TrustSafetyInteraction["RAN_SAFETY_CHECK"]=0]="RAN_SAFETY_CHECK";TrustSafetyInteraction[TrustSafetyInteraction["USED_PRIVACY_CARD"]=1]="USED_PRIVACY_CARD";TrustSafetyInteraction[TrustSafetyInteraction["OPENED_PASSWORD_MANAGER"]=3]="OPENED_PASSWORD_MANAGER";TrustSafetyInteraction[TrustSafetyInteraction["COMPLETED_PRIVACY_GUIDE"]=4]="COMPLETED_PRIVACY_GUIDE";TrustSafetyInteraction[TrustSafetyInteraction["RAN_PASSWORD_CHECK"]=5]="RAN_PASSWORD_CHECK"})(TrustSafetyInteraction||(TrustSafetyInteraction={}));var SecurityPageInteraction;(function(SecurityPageInteraction){SecurityPageInteraction[SecurityPageInteraction["RADIO_BUTTON_ENHANCED_CLICK"]=0]="RADIO_BUTTON_ENHANCED_CLICK";SecurityPageInteraction[SecurityPageInteraction["RADIO_BUTTON_STANDARD_CLICK"]=1]="RADIO_BUTTON_STANDARD_CLICK";SecurityPageInteraction[SecurityPageInteraction["RADIO_BUTTON_DISABLE_CLICK"]=2]="RADIO_BUTTON_DISABLE_CLICK";SecurityPageInteraction[SecurityPageInteraction["EXPAND_BUTTON_ENHANCED_CLICK"]=3]="EXPAND_BUTTON_ENHANCED_CLICK";SecurityPageInteraction[SecurityPageInteraction["EXPAND_BUTTON_STANDARD_CLICK"]=4]="EXPAND_BUTTON_STANDARD_CLICK";SecurityPageInteraction[SecurityPageInteraction["NO_INTERACTION"]=5]="NO_INTERACTION"})(SecurityPageInteraction||(SecurityPageInteraction={}));var SafeBrowsingSetting$1;(function(SafeBrowsingSetting){SafeBrowsingSetting[SafeBrowsingSetting["ENHANCED"]=0]="ENHANCED";SafeBrowsingSetting[SafeBrowsingSetting["STANDARD"]=1]="STANDARD";SafeBrowsingSetting[SafeBrowsingSetting["DISABLED"]=2]="DISABLED"})(SafeBrowsingSetting$1||(SafeBrowsingSetting$1={}));class HatsBrowserProxyImpl{trustSafetyInteractionOccurred(interaction){chrome.send("trustSafetyInteractionOccurred",[interaction])}securityPageHatsRequest(securityPageInteraction,safeBrowsingSetting,totalTimeOnPage){chrome.send("securityPageHatsRequest",[securityPageInteraction,safeBrowsingSetting,totalTimeOnPage])}now(){return window.performance.now()}static getInstance(){return instance$9||(instance$9=new HatsBrowserProxyImpl)}static setInstance(obj){instance$9=obj}}let instance$9=null;
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class PrivacySandboxBrowserProxyImpl{getFledgeState(){return sendWithPromise("getFledgeState")}setFledgeJoiningAllowed(site,allowed){chrome.send("setFledgeJoiningAllowed",[site,allowed])}getTopicsState(){return sendWithPromise("getTopicsState")}setTopicAllowed(topic,allowed){chrome.send("setTopicAllowed",[topic.topicId,topic.taxonomyVersion,allowed])}topicsToggleChanged(newToggleValue){chrome.send("topicsToggleChanged",[newToggleValue])}getFirstLevelTopics(){return sendWithPromise("getFirstLevelTopics")}getChildTopicsCurrentlyAssigned(topic){return sendWithPromise("getChildTopicsCurrentlyAssigned",topic.topicId,topic.taxonomyVersion)}shouldShowPrivacySandboxAdTopicsContentParity(){return sendWithPromise("shouldShowPrivacySandboxAdTopicsContentParity")}static getInstance(){return instance$8||(instance$8=new PrivacySandboxBrowserProxyImpl)}static setInstance(obj){instance$8=obj}}let instance$8=null;function getTemplate$d(){return html$1`<!--_html_template_start_--><style include="privacy-guide-fragment-shared settings-shared">:host{display:flex;flex-flow:column;min-height:calc(400px - var(--privacy-guide-footer-total-height))}.welcome-completion-header{padding:24px 0 16px 0}cr-link-row{--cr-link-row-icon-width:24px;--iron-icon-height:24px;border-radius:4px;padding-inline-end:8px;padding-inline-start:4px}cr-link-row::part(icon){--cr-icon-button-icon-size:24px}.label{font-size:0.875rem}.footer{align-items:center;bottom:calc(-1 * var(--privacy-guide-footer-total-height));display:flex;justify-content:space-between;padding:var(--privacy-guide-footer-vertical-padding) 0;position:absolute;width:calc(100% - 48px)}</style>
<div class="welcome-completion-header">
  <picture>
    <source
        srcset="./images/privacy_guide/completion_banner_dark_v2.svg"
        media="(prefers-color-scheme: dark)">
    <img alt="" src="./images/privacy_guide/completion_banner_v2.svg">
  </picture>
  <h2 class="welcome-completion-header-label" tabindex="-1">
    $i18n{privacyGuideCompletionCardHeader}
  </h2>
  <div class="cr-secondary-text">[[getSubheader_(isNoLinkLayout_)]]</div>
</div>
<template is="dom-if" if="[[shouldShowPrivacySandbox_]]">
  <cr-link-row id="privacySandboxRow" using-slotted-label
      sub-label="[[computePrivacySandboxRowSubLabel_(
        shouldShowV2AdPrivacySubLabel_)]]"
      start-icon="privacy20:ads-click" external
      on-click="onPrivacySandboxClick_">
    <div slot="label" class="label">
      $i18n{privacyGuideCompletionCardPrivacySandboxLabel}
    </div>
  </cr-link-row>
  <div aria-disabled="true" role="none">
    <a id="privacySandboxLink" href="adPrivacy"
        target="_blank" tabindex="-1" aria-disabled="true"
        role="none"></a>
  </div>
</template>
<template is="dom-if" if="[[shouldShowAiSettings_]]">
  <cr-link-row id="aiRow" using-slotted-label
      sub-label="$i18n{privacyGuideCompletionCardAiSettingsLabel}"
      start-icon="settings20:magic" external on-click="onAiRowClick_">
    <div slot="label" class="label">$i18n{aiInnovationsPageTitle}</div>
  </cr-link-row>
  <div aria-disabled="true" role="none">
    <a id="aiRowLink" href="ai" target="_blank" tabindex="-1"
        aria-disabled="true" role="none"></a>
  </div>
</template>
<template is="dom-if" if="[[shouldShowWaa_]]">
  <cr-link-row id="waaRow" using-slotted-label
      sub-label="$i18n{privacyGuideCompletionCardWaaSubLabel}"
      start-icon="settings:devices" external
      on-click="onWaaClick_">
      <div slot="label" class="label">
        $i18n{privacyGuideCompletionCardWaaLabel}
      </div>
  </cr-link-row>
</template>
<div class="footer">
  <cr-button id="backButton" role="button" on-click="onBackButtonClick_">
    $i18n{privacyGuideBackButton}
  </cr-button>
  <cr-button class="action-button" id="leaveButton"
      on-click="onLeaveButtonClick_">
    $i18n{privacyGuideCompletionCardLeaveButton}
  </cr-button>
</div>
<!--_html_template_end_-->`}
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrivacyGuideCompletionFragmentElementBase=WebUiListenerMixin(I18nMixin(PolymerElement));class PrivacyGuideCompletionFragmentElement extends PrivacyGuideCompletionFragmentElementBase{static get is(){return"privacy-guide-completion-fragment"}static get template(){return getTemplate$d()}static get properties(){return{isNoLinkLayout_:{reflectToAttribute:true,type:Boolean,computed:"computeIsNoLinkLayout_(shouldShowWaa_,"+"shouldShowPrivacySandbox_)"},shouldShowAiSettings_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableAiSettingsInPrivacyGuide")&&loadTimeData.getBoolean("showAiPage")},shouldShowPrivacySandbox_:{type:Boolean,value:()=>!loadTimeData.getBoolean("isPrivacySandboxRestricted")||loadTimeData.getBoolean("isPrivacySandboxRestrictedNoticeEnabled")},shouldShowWaa_:{type:Boolean,value:false},shouldShowV2AdPrivacySubLabel_:{type:Boolean,value:false}}}metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();privacySandboxBrowserProxy_=PrivacySandboxBrowserProxyImpl.getInstance();ready(){super.ready();this.addEventListener("view-enter-start",this.onViewEnterStart_);this.addWebUiListener("update-sync-state",(event=>this.updateWaaLink_(event.signedIn)));ClearBrowsingDataBrowserProxyImpl.getInstance().getSyncState().then((status=>this.updateWaaLink_(status.signedIn)));this.privacySandboxBrowserProxy_.shouldShowPrivacySandboxAdTopicsContentParity().then((state=>{this.shouldShowV2AdPrivacySubLabel_=state}))}focus(){const header=this.shadowRoot.querySelector(".welcome-completion-header-label");assert(header);header.focus()}onViewEnterStart_(){HatsBrowserProxyImpl.getInstance().trustSafetyInteractionOccurred(TrustSafetyInteraction.COMPLETED_PRIVACY_GUIDE);this.metricsBrowserProxy_.recordPrivacyGuideStepsEligibleAndReachedHistogram(PrivacyGuideStepsEligibleAndReached.COMPLETION_REACHED)}computeIsNoLinkLayout_(){return!this.shouldShowWaa_&&!this.shouldShowPrivacySandbox_}getSubheader_(){return this.computeIsNoLinkLayout_()?this.i18n("privacyGuideCompletionCardSubHeaderNoLinks"):this.i18n("privacyGuideCompletionCardSubHeader")}updateWaaLink_(isSignedIn){this.shouldShowWaa_=isSignedIn}onBackButtonClick_(e){e.stopPropagation();this.dispatchEvent(new CustomEvent("back-button-click",{bubbles:true,composed:true}))}onLeaveButtonClick_(){this.metricsBrowserProxy_.recordPrivacyGuideNextNavigationHistogram(PrivacyGuideInteractions.COMPLETION_NEXT_BUTTON);this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.NextClickCompletion");this.dispatchEvent(new CustomEvent("close",{bubbles:true,composed:true}))}onPrivacySandboxClick_(){this.metricsBrowserProxy_.recordPrivacyGuideEntryExitHistogram(PrivacyGuideInteractions.PRIVACY_SANDBOX_COMPLETION_LINK);this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.CompletionPSClick");this.shadowRoot.querySelector("#privacySandboxLink").dispatchEvent(new MouseEvent("click"))}onAiRowClick_(){this.metricsBrowserProxy_.recordPrivacyGuideEntryExitHistogram(PrivacyGuideInteractions.AI_SETTINGS_COMPLETION_LINK);this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.CompletionAiSettingsClick");this.shadowRoot.querySelector("#aiRowLink").dispatchEvent(new MouseEvent("click"))}onWaaClick_(){this.metricsBrowserProxy_.recordPrivacyGuideEntryExitHistogram(PrivacyGuideInteractions.SWAA_COMPLETION_LINK);this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.CompletionSWAAClick");OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("activityControlsUrlInPrivacyGuide"))}computePrivacySandboxRowSubLabel_(){return this.i18n(this.shouldShowV2AdPrivacySubLabel_?"privacyGuideCompletionCardPrivacySandboxSubLabelAdTopics":"privacyGuideCompletionCardPrivacySandboxSubLabel")}}customElements.define(PrivacyGuideCompletionFragmentElement.is,PrivacyGuideCompletionFragmentElement);
// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var ContentSettingsTypes;(function(ContentSettingsTypes){ContentSettingsTypes["ADS"]="ads";ContentSettingsTypes["ANTI_ABUSE"]="anti-abuse";ContentSettingsTypes["AR"]="ar";ContentSettingsTypes["AUTO_PICTURE_IN_PICTURE"]="auto-picture-in-picture";ContentSettingsTypes["AUTOMATIC_DOWNLOADS"]="multiple-automatic-downloads";ContentSettingsTypes["AUTOMATIC_FULLSCREEN"]="automatic-fullscreen";ContentSettingsTypes["BACKGROUND_SYNC"]="background-sync";ContentSettingsTypes["BLUETOOTH_DEVICES"]="bluetooth-devices";ContentSettingsTypes["BLUETOOTH_SCANNING"]="bluetooth-scanning";ContentSettingsTypes["CAMERA"]="media-stream-camera";ContentSettingsTypes["CAPTURED_SURFACE_CONTROL"]="captured-surface-control";ContentSettingsTypes["CLIPBOARD"]="clipboard";ContentSettingsTypes["COOKIES"]="cookies";ContentSettingsTypes["FEDERATED_IDENTITY_API"]="federated-identity-api";ContentSettingsTypes["FILE_SYSTEM_WRITE"]="file-system-write";ContentSettingsTypes["GEOLOCATION"]="location";ContentSettingsTypes["HAND_TRACKING"]="hand-tracking";ContentSettingsTypes["HID_DEVICES"]="hid-devices";ContentSettingsTypes["IDLE_DETECTION"]="idle-detection";ContentSettingsTypes["IMAGES"]="images";ContentSettingsTypes["JAVASCRIPT"]="javascript";ContentSettingsTypes["JAVASCRIPT_OPTIMIZER"]="javascript-optimizer";ContentSettingsTypes["KEYBOARD_LOCK"]="keyboard-lock";ContentSettingsTypes["LOCAL_FONTS"]="local-fonts";ContentSettingsTypes["LOCAL_NETWORK_ACCESS"]="local-network-access";ContentSettingsTypes["MIC"]="media-stream-mic";ContentSettingsTypes["MIDI_DEVICES"]="midi-sysex";ContentSettingsTypes["MIXEDSCRIPT"]="mixed-script";ContentSettingsTypes["NOTIFICATIONS"]="notifications";ContentSettingsTypes["PAYMENT_HANDLER"]="payment-handler";ContentSettingsTypes["PERFORMANCE"]="performance";ContentSettingsTypes["POINTER_LOCK"]="pointer-lock";ContentSettingsTypes["POPUPS"]="popups";ContentSettingsTypes["PRIVATE_NETWORK_DEVICES"]="private-network-devices";ContentSettingsTypes["PROTECTED_CONTENT"]="protected-content";ContentSettingsTypes["PROTOCOL_HANDLERS"]="register-protocol-handler";ContentSettingsTypes["SENSORS"]="sensors";ContentSettingsTypes["SERIAL_PORTS"]="serial-ports";ContentSettingsTypes["SMART_CARD_READERS"]="smart-card-readers";ContentSettingsTypes["SOUND"]="sound";ContentSettingsTypes["STORAGE_ACCESS"]="storage-access";ContentSettingsTypes["TRACKING_PROTECTION"]="tracking-protection";ContentSettingsTypes["TOP_LEVEL_STORAGE_ACCESS"]="top-level-storage-access";ContentSettingsTypes["USB_DEVICES"]="usb-devices";ContentSettingsTypes["VR"]="vr";ContentSettingsTypes["WEB_APP_INSTALLATION"]="web-app-installation";ContentSettingsTypes["WINDOW_MANAGEMENT"]="window-management";ContentSettingsTypes["ZOOM_LEVELS"]="zoom-levels";ContentSettingsTypes["WEB_PRINTING"]="web-printing";ContentSettingsTypes["PDF_DOCUMENTS"]="pdfDocuments";ContentSettingsTypes["SITE_DATA"]="site-data";ContentSettingsTypes["OFFER_WRITING_HELP"]="offer-writing-help"})(ContentSettingsTypes||(ContentSettingsTypes={}));var ContentSetting;(function(ContentSetting){ContentSetting["DEFAULT"]="default";ContentSetting["ALLOW"]="allow";ContentSetting["BLOCK"]="block";ContentSetting["ASK"]="ask";ContentSetting["SESSION_ONLY"]="session_only"})(ContentSetting||(ContentSetting={}));var ChooserType;(function(ChooserType){ChooserType["NONE"]="";ChooserType["USB_DEVICES"]="usb-devices-data";ChooserType["SERIAL_PORTS"]="serial-ports-data";ChooserType["HID_DEVICES"]="hid-devices-data";ChooserType["BLUETOOTH_DEVICES"]="bluetooth-devices-data";ChooserType["PRIVATE_NETWORK_DEVICES"]="private-network-devices-data"})(ChooserType||(ChooserType={}));var CookieControlsMode;(function(CookieControlsMode){CookieControlsMode[CookieControlsMode["OFF"]=0]="OFF";CookieControlsMode[CookieControlsMode["BLOCK_THIRD_PARTY"]=1]="BLOCK_THIRD_PARTY";CookieControlsMode[CookieControlsMode["INCOGNITO_ONLY"]=2]="INCOGNITO_ONLY";CookieControlsMode[CookieControlsMode["LIMITED"]=3]="LIMITED"})(CookieControlsMode||(CookieControlsMode={}));var SiteSettingSource;(function(SiteSettingSource){SiteSettingSource["ADS_FILTER_BLACKLIST"]="ads-filter-blacklist";SiteSettingSource["ALLOWLIST"]="allowlist";SiteSettingSource["DEFAULT"]="default";SiteSettingSource["EMBARGO"]="embargo";SiteSettingSource["EXTENSION"]="extension";SiteSettingSource["HOSTED_APP"]="HostedApp";SiteSettingSource["INSECURE_ORIGIN"]="insecure-origin";SiteSettingSource["KILL_SWITCH"]="kill-switch";SiteSettingSource["POLICY"]="policy";SiteSettingSource["PREFERENCE"]="preference"})(SiteSettingSource||(SiteSettingSource={}));var SettingsState;(function(SettingsState){SettingsState[SettingsState["LOUD"]=0]="LOUD";SettingsState[SettingsState["QUIET"]=1]="QUIET";SettingsState[SettingsState["CPSS"]=2]="CPSS";SettingsState[SettingsState["BLOCK"]=3]="BLOCK"})(SettingsState||(SettingsState={}));var JavascriptOptimizerSetting;(function(JavascriptOptimizerSetting){JavascriptOptimizerSetting[JavascriptOptimizerSetting["BLOCKED"]=0]="BLOCKED";JavascriptOptimizerSetting[JavascriptOptimizerSetting["ALLOWED"]=1]="ALLOWED";JavascriptOptimizerSetting[JavascriptOptimizerSetting["BLOCKED_FOR_UNFAMILIAR_SITES"]=2]="BLOCKED_FOR_UNFAMILIAR_SITES"})(JavascriptOptimizerSetting||(JavascriptOptimizerSetting={}));const INVALID_CATEGORY_SUBTYPE="";var AllSitesAction2;(function(AllSitesAction2){AllSitesAction2[AllSitesAction2["LOAD_PAGE"]=0]="LOAD_PAGE";AllSitesAction2[AllSitesAction2["RESET_SITE_GROUP_PERMISSIONS"]=1]="RESET_SITE_GROUP_PERMISSIONS";AllSitesAction2[AllSitesAction2["RESET_ORIGIN_PERMISSIONS"]=2]="RESET_ORIGIN_PERMISSIONS";AllSitesAction2[AllSitesAction2["CLEAR_ALL_DATA"]=3]="CLEAR_ALL_DATA";AllSitesAction2[AllSitesAction2["CLEAR_SITE_GROUP_DATA"]=4]="CLEAR_SITE_GROUP_DATA";AllSitesAction2[AllSitesAction2["CLEAR_ORIGIN_DATA"]=5]="CLEAR_ORIGIN_DATA";AllSitesAction2[AllSitesAction2["ENTER_SITE_DETAILS"]=6]="ENTER_SITE_DETAILS";AllSitesAction2[AllSitesAction2["REMOVE_SITE_GROUP"]=7]="REMOVE_SITE_GROUP";AllSitesAction2[AllSitesAction2["REMOVE_ORIGIN"]=8]="REMOVE_ORIGIN";AllSitesAction2[AllSitesAction2["REMOVE_ORIGIN_PARTITIONED"]=9]="REMOVE_ORIGIN_PARTITIONED";AllSitesAction2[AllSitesAction2["FILTER_BY_FPS_OWNER"]=10]="FILTER_BY_FPS_OWNER";AllSitesAction2[AllSitesAction2["DELETE_FOR_ENTIRE_FPS"]=11]="DELETE_FOR_ENTIRE_FPS"})(AllSitesAction2||(AllSitesAction2={}));var SortMethod;(function(SortMethod){SortMethod["NAME"]="name";SortMethod["MOST_VISITED"]="most-visited";SortMethod["STORAGE"]="data-stored"})(SortMethod||(SortMethod={}));var AllSitesDialog;(function(AllSitesDialog){AllSitesDialog["CLEAR_DATA"]="ClearData";AllSitesDialog["RESET_PERMISSIONS"]="ResetPermissions"})(AllSitesDialog||(AllSitesDialog={}));const SITE_EXCEPTION_WILDCARD="*";var CookiesExceptionType;(function(CookiesExceptionType){CookiesExceptionType["THIRD_PARTY"]="third-party";CookiesExceptionType["SITE_DATA"]="site-data";CookiesExceptionType["COMBINED"]="combined"})(CookiesExceptionType||(CookiesExceptionType={}));
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var DefaultSettingSource;(function(DefaultSettingSource){DefaultSettingSource["POLICY"]="policy";DefaultSettingSource["SUPERVISED_USER"]="supervised_user";DefaultSettingSource["EXTENSION"]="extension";DefaultSettingSource["PREFERENCE"]="preference";DefaultSettingSource["DEFAULT"]="default"})(DefaultSettingSource||(DefaultSettingSource={}));var ThirdPartyCookieBlockingSetting;(function(ThirdPartyCookieBlockingSetting){ThirdPartyCookieBlockingSetting[ThirdPartyCookieBlockingSetting["BLOCK_THIRD_PARTY"]=0]="BLOCK_THIRD_PARTY";ThirdPartyCookieBlockingSetting[ThirdPartyCookieBlockingSetting["INCOGNITO_ONLY"]=1]="INCOGNITO_ONLY"})(ThirdPartyCookieBlockingSetting||(ThirdPartyCookieBlockingSetting={}));class SiteSettingsPrefsBrowserProxyImpl{setDefaultValueForContentType(contentType,defaultValue){chrome.send("setDefaultValueForContentType",[contentType,defaultValue])}getDefaultValueForContentType(contentType){return sendWithPromise("getDefaultValueForContentType",contentType)}getAllSites(){return sendWithPromise("getAllSites")}getCategoryList(origin){return sendWithPromise("getCategoryList",origin)}getRecentSitePermissions(numSources){return sendWithPromise("getRecentSitePermissions",numSources)}getChooserExceptionList(chooserType){return sendWithPromise("getChooserExceptionList",chooserType)}getFormattedBytes(numBytes){return sendWithPromise("getFormattedBytes",numBytes)}getExceptionList(contentType){return sendWithPromise("getExceptionList",contentType)}getStorageAccessExceptionList(categorySubtype){return sendWithPromise("getStorageAccessExceptionList",categorySubtype)}getFileSystemGrants(){return sendWithPromise("getFileSystemGrants")}revokeFileSystemGrant(origin,filePath){chrome.send("revokeFileSystemGrant",[origin,filePath])}revokeFileSystemGrants(origin){chrome.send("revokeFileSystemGrants",[origin])}getOriginPermissions(origin,contentTypes){return sendWithPromise("getOriginPermissions",origin,contentTypes)}setOriginPermissions(origin,category,blanketSetting){chrome.send("setOriginPermissions",[origin,category,blanketSetting])}resetCategoryPermissionForPattern(primaryPattern,secondaryPattern,contentType,incognito){chrome.send("resetCategoryPermissionForPattern",[primaryPattern,secondaryPattern,contentType,incognito])}resetChooserExceptionForSite(chooserType,origin,exception){chrome.send("resetChooserExceptionForSite",[chooserType,origin,exception])}setCategoryPermissionForPattern(primaryPattern,secondaryPattern,contentType,value,incognito){chrome.send("setCategoryPermissionForPattern",[primaryPattern,secondaryPattern,contentType,value,incognito])}isOriginValid(origin){return sendWithPromise("isOriginValid",origin)}isPatternValidForType(pattern,category){return sendWithPromise("isPatternValidForType",pattern,category)}initializeCaptureDevices(type){chrome.send("initializeCaptureDevices",[type])}setPreferredCaptureDevice(type,defaultValue){chrome.send("setPreferredCaptureDevice",[type,defaultValue])}observeProtocolHandlers(){chrome.send("observeProtocolHandlers")}observeAppProtocolHandlers(){chrome.send("observeAppProtocolHandlers")}observeProtocolHandlersEnabledState(){chrome.send("observeProtocolHandlersEnabledState")}setProtocolHandlerDefault(enabled){chrome.send("setHandlersEnabled",[enabled])}setProtocolDefault(protocol,url){chrome.send("setDefault",[protocol,url])}removeProtocolHandler(protocol,url){chrome.send("removeHandler",[protocol,url])}removeAppAllowedHandler(protocol,url,appId){chrome.send("removeAppAllowedHandler",[protocol,url,appId])}removeAppDisallowedHandler(protocol,url,appId){chrome.send("removeAppDisallowedHandler",[protocol,url,appId])}updateIncognitoStatus(){chrome.send("updateIncognitoStatus")}fetchZoomLevels(){chrome.send("fetchZoomLevels")}removeZoomLevel(host){chrome.send("removeZoomLevel",[host])}fetchBlockAutoplayStatus(){chrome.send("fetchBlockAutoplayStatus")}clearSiteGroupDataAndCookies(groupingKey){chrome.send("clearSiteGroupDataAndCookies",[groupingKey])}clearUnpartitionedOriginDataAndCookies(origin){chrome.send("clearUnpartitionedUsage",[origin])}clearPartitionedOriginDataAndCookies(origin,groupingKey){chrome.send("clearPartitionedUsage",[origin,groupingKey])}recordAction(action){chrome.send("recordAction",[action])}getRwsMembershipLabel(rwsNumMembers,rwsOwner){return sendWithPromise("getRwsMembershipLabel",rwsNumMembers,rwsOwner)}getNumCookiesString(numCookies){return sendWithPromise("getNumCookiesString",numCookies)}getSystemDeniedPermissions(){return sendWithPromise("getSystemDeniedPermissions")}openSystemPermissionSettings(contentType){chrome.send("openSystemPermissionSettings",[contentType])}static getInstance(){return instance$7||(instance$7=new SiteSettingsPrefsBrowserProxyImpl)}static setInstance(obj){instance$7=obj}}let instance$7=null;function getTemplate$c(){return html$1`<!--_html_template_start_--><style include="privacy-guide-fragment-shared"></style>
<div class="settings-fragment-header" focus-element tabindex="-1">
  <picture>
    <source
        srcset="./images/privacy_guide/cookies_graphic_dark_v2.svg"
        media="(prefers-color-scheme: dark)">
    <img alt="" src="./images/privacy_guide/cookies_graphic_v2.svg">
  </picture>
  <h2 class="settings-fragment-header-label">
    $i18n{privacyGuideCookiesCardHeader}
  </h2>
</div>
<div class="fragment-content">
  <settings-radio-group id="cookiesRadioGroup"
      pref="{{prefs.generated.third_party_cookie_blocking_setting}}"
      selectable-elements="settings-collapse-radio-button">
    <settings-collapse-radio-button id="allow3pcs"
        pref="[[prefs.generated.third_party_cookie_blocking_setting]]"
        name="[[thirdPartyCookieBlockingSettingEnum_.INCOGNITO_ONLY]]"
        label="$i18n{privacyGuideCookiesCardBlockTpcAllowSubheader}"
        expand-aria-label="$i18n{allowThirdPartyCookiesExpandA11yLabel}"
        on-click="onCookies3pIncognitoClick_">
      <div slot="collapse" class="settings-columned-section">
        <div class="column">
          <h3 class="description-header">$i18n{columnHeadingWhenOn}</h3>
          <ul class="icon-bulleted-list">
            <li>
              <cr-icon icon="settings20:account-circle-filled"
                  aria-hidden="true"></cr-icon>
              <div class="secondary">
                $i18n{privacyGuideCookieSettingsAllowWhenOnBulletOne}
              </div>
            </li>
            <li>
              <cr-icon icon="settings20:web" aria-hidden="true"></cr-icon>
              <div class="secondary">
                $i18n{privacyGuideCookieSettingsAllowWhenOnBulletTwo}
              </div>
            </li>
          </ul>
        </div>
        <div class="column">
          <h3 class="description-header">$i18n{columnHeadingConsider}</h3>
          <ul class="icon-bulleted-list">
            <li>
              <cr-icon icon="settings20:user-attributes-filled"
                  aria-hidden="true"></cr-icon>
              <div class="secondary">
                $i18n{privacyGuideCookieSettingsAllowThingsToConsiderBulletOne}
              </div>
            </li>
            <li>
              <cr-icon icon="settings20:incognito-unfilled" aria-hidden="true">
              </cr-icon>
              <div class="secondary">
                $i18n{privacyGuideCookieSettingsAllowThingsToConsiderBulletTwo}
              </div>
            </li>
          </ul>
        </div>
      </div>
    </settings-collapse-radio-button>
    <settings-collapse-radio-button id="block3pcs"
        pref="[[prefs.generated.third_party_cookie_blocking_setting]]"
        name="[[thirdPartyCookieBlockingSettingEnum_.BLOCK_THIRD_PARTY]]"
        label="$i18n{privacyGuideCookiesCardBlockTpcBlockSubheader}"
        expand-aria-label="$i18n{blockThirdPartyCookiesExpandA11yLabel}"
        on-click="onCookies3pClick_">
      <div slot="collapse" class="settings-columned-section">
        <div class="column">
          <h3 class="description-header">$i18n{columnHeadingWhenOn}</h3>
          <ul class="icon-bulleted-list">
            <li>
              <cr-icon icon="settings20:block" aria-hidden="true">
              </cr-icon>
              <div class="secondary">
                $i18n{privacyGuideCookieSettingsBlockWhenOnBulletOne}
              </div>
            </li>
            <li>
              <cr-icon icon="settings20:broken" aria-hidden="true"></cr-icon>
              <div class="secondary">
                $i18n{privacyGuideCookieSettingsBlockWhenOnBulletTwo}
              </div>
            </li>
          </ul>
        </div>
        <div class="column">
          <h3 class="description-header">$i18n{columnHeadingConsider}</h3>
          <ul class="icon-bulleted-list">
            <li>
              <cr-icon icon="settings:domain-verification" aria-hidden="true">
              </cr-icon>
              <div class="secondary">
                $i18n{privacyGuideCookieSettingsBlockThingsToConsiderBulletOne}
              </div>
            </li>
            <li>
              <cr-icon icon="settings20:fact-check" aria-hidden="true">
              </cr-icon>
              <div class="secondary">
                $i18n{privacyGuideCookieSettingsBlockThingsToConsiderBulletTwo}
              </div>
            </li>
          </ul>
        </div>
      </div>
    </settings-collapse-radio-button>
  </settings-radio-group>
</div>
<!--_html_template_end_-->`}
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrivacyGuideCookiesFragmentBase=PrefsMixin(PolymerElement);class PrivacyGuideCookiesFragmentElement extends PrivacyGuideCookiesFragmentBase{static get is(){return"privacy-guide-cookies-fragment"}static get template(){return getTemplate$c()}static get properties(){return{cookieControlsModeEnum_:{type:Object,value:CookieControlsMode},thirdPartyCookieBlockingSettingEnum_:{type:Object,value:ThirdPartyCookieBlockingSetting}}}metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();startStateBlock3PIncognito_;ready(){super.ready();this.addEventListener("view-enter-start",this.onViewEnterStart_);this.addEventListener("view-exit-finish",this.onViewExitFinish_)}focus(){this.shadowRoot.querySelector("[focus-element]").focus()}onViewEnterStart_(){this.startStateBlock3PIncognito_=this.getPref("generated.third_party_cookie_blocking_setting").value===ThirdPartyCookieBlockingSetting.INCOGNITO_ONLY;this.metricsBrowserProxy_.recordPrivacyGuideStepsEligibleAndReachedHistogram(PrivacyGuideStepsEligibleAndReached.COOKIES_REACHED)}onViewExitFinish_(){const endStateBlock3PIncognito=this.getPref("generated.third_party_cookie_blocking_setting").value===ThirdPartyCookieBlockingSetting.INCOGNITO_ONLY;let state=null;if(this.startStateBlock3PIncognito_){state=endStateBlock3PIncognito?PrivacyGuideSettingsStates.BLOCK_3P_INCOGNITO_TO_3P_INCOGNITO:PrivacyGuideSettingsStates.BLOCK_3P_INCOGNITO_TO_3P}else{state=endStateBlock3PIncognito?PrivacyGuideSettingsStates.BLOCK_3P_TO_3P_INCOGNITO:PrivacyGuideSettingsStates.BLOCK_3P_TO_3P}this.metricsBrowserProxy_.recordPrivacyGuideSettingsStatesHistogram(state)}onCookies3pIncognitoClick_(){this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.ChangeCookiesBlock3PIncognito")}onCookies3pClick_(){this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.ChangeCookiesBlock3P")}}customElements.define(PrivacyGuideCookiesFragmentElement.is,PrivacyGuideCookiesFragmentElement);
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var PrivacyGuideStep;(function(PrivacyGuideStep){PrivacyGuideStep["WELCOME"]="welcome";PrivacyGuideStep["MSBB"]="msbb";PrivacyGuideStep["HISTORY_SYNC"]="historySync";PrivacyGuideStep["SAFE_BROWSING"]="safeBrowsing";PrivacyGuideStep["COOKIES"]="cookies";PrivacyGuideStep["AD_TOPICS"]="adTopics";PrivacyGuideStep["COMPLETION"]="completion"})(PrivacyGuideStep||(PrivacyGuideStep={}));function getTemplate$b(){return html$1`<!--_html_template_start_--><style include="privacy-guide-fragment-shared"></style>
<div class="settings-fragment-header" focus-element tabindex="-1">
  <picture>
    <source
        srcset="./images/privacy_guide/history_sync_graphic_dark_v2.svg"
        media="(prefers-color-scheme: dark)">
    <img alt="" src="./images/privacy_guide/history_sync_graphic_v2.svg">
  </picture>
  <h2 class="settings-fragment-header-label">
    $i18n{privacyGuideHistorySyncCardHeader}
  </h2>
</div>
<div class="fragment-content">
  <div class="embedded-setting-wrapper">
    <settings-toggle-button id="historyToggle"
        pref="{{historySyncVirtualPref_}}"
        on-change="onToggleClick_"
        label="$i18n{privacyGuideHistorySyncSettingLabel}">
    </settings-toggle-button>
  </div>
  <div class="settings-columned-section">
    <div class="column">
      <h3 class="description-header">
        $i18n{columnHeadingWhenOn}
      </h3>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:history" aria-hidden="true"></cr-icon>
          <div class="secondary">
            $i18n{privacyGuideHistorySyncFeatureDescription1}
          </div>
        </li>
        <li>
          <cr-icon icon="settings20:dns" aria-hidden="true"></cr-icon>
          <div class="secondary">
            $i18n{privacyGuideHistorySyncFeatureDescription2}
          </div>
        </li>
      </ul>
    </div>
    <div class="column">
      <h3 class="description-header">$i18n{columnHeadingConsider}</h3>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:link" aria-hidden="true"></cr-icon>
          <div class="secondary">
            $i18n{privacyGuideHistorySyncPrivacyDescription1}
          </div>
        </li>
      </ul>
    </div>
  </div>
</div>
<!--_html_template_end_-->`}
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrivacyGuideHistorySyncFragmentElementBase=RouteObserverMixin(WebUiListenerMixin(BaseMixin(PolymerElement)));class PrivacyGuideHistorySyncFragmentElement extends PrivacyGuideHistorySyncFragmentElementBase{static get is(){return"privacy-guide-history-sync-fragment"}static get template(){return getTemplate$b()}static get properties(){return{historySyncVirtualPref_:{type:Object,notify:true,value(){return{type:chrome.settingsPrivate.PrefType.BOOLEAN,value:false}}}}}syncBrowserProxy_=SyncBrowserProxyImpl.getInstance();syncPrefs_;syncAllCache_=null;metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();startStateHistorySyncOn_;firstSyncPrefUpdate_=true;ready(){super.ready();this.addEventListener("view-enter-start",this.onViewEnterStart_);this.addEventListener("view-exit-finish",this.onViewExitFinish_);this.addWebUiListener("sync-prefs-changed",(syncPrefs=>this.onSyncPrefsChange_(syncPrefs)));this.syncBrowserProxy_.sendSyncPrefsChanged()}focus(){this.shadowRoot.querySelector("[focus-element]").focus()}onViewEnterStart_(){this.metricsBrowserProxy_.recordPrivacyGuideStepsEligibleAndReachedHistogram(PrivacyGuideStepsEligibleAndReached.HISTORY_SYNC_REACHED)}onViewExitFinish_(){const endStateHistorySyncOn=this.syncPrefs_.typedUrlsSynced;let state=null;if(this.startStateHistorySyncOn_){state=endStateHistorySyncOn?PrivacyGuideSettingsStates.HISTORY_SYNC_ON_TO_ON:PrivacyGuideSettingsStates.HISTORY_SYNC_ON_TO_OFF}else{state=endStateHistorySyncOn?PrivacyGuideSettingsStates.HISTORY_SYNC_OFF_TO_ON:PrivacyGuideSettingsStates.HISTORY_SYNC_OFF_TO_OFF}this.metricsBrowserProxy_.recordPrivacyGuideSettingsStatesHistogram(state);this.firstSyncPrefUpdate_=true}currentRouteChanged(newRoute){if(newRoute===routes.PRIVACY_GUIDE&&Router.getInstance().getQueryParameters().get("step")===PrivacyGuideStep.HISTORY_SYNC){this.syncAllCache_=null}}onSyncPrefsChange_(syncPrefs){this.syncPrefs_=syncPrefs;if(this.syncAllCache_===null){this.syncAllCache_=this.syncPrefs_.syncAllDataTypes}this.set("historySyncVirtualPref_.value",this.syncPrefs_.typedUrlsSynced);if(this.firstSyncPrefUpdate_){this.startStateHistorySyncOn_=this.syncPrefs_.typedUrlsSynced;this.firstSyncPrefUpdate_=false}}onToggleClick_(){this.syncPrefs_.typedUrlsSynced=this.historySyncVirtualPref_.value;this.syncPrefs_.syncAllDataTypes=this.shouldSyncAllBeOn_();this.syncBrowserProxy_.setSyncDatatypes(this.syncPrefs_);if(this.syncPrefs_.typedUrlsSynced){this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.ChangeHistorySyncOn")}else{this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.ChangeHistorySyncOff")}}shouldSyncAllBeOn_(){if(!this.syncAllCache_){return false}for(const datatype of syncPrefsIndividualDataTypes){if(this.syncPrefs_[datatype]){continue}if(datatype==="wifiConfigurationsSynced"&&!this.syncPrefs_.wifiConfigurationsRegistered){continue}return false}return true}}customElements.define(PrivacyGuideHistorySyncFragmentElement.is,PrivacyGuideHistorySyncFragmentElement);function getTemplate$a(){return html$1`<!--_html_template_start_--><style include="privacy-guide-fragment-shared"></style>
<div class="settings-fragment-header" focus-element tabindex="-1">
  <picture>
    <source
        srcset="./images/privacy_guide/msbb_graphic_dark_v2.svg"
        media="(prefers-color-scheme: dark)">
    <img alt="" src="./images/privacy_guide/msbb_graphic_v2.svg">
  </picture>
  <h2 class="settings-fragment-header-label">
    $i18n{privacyGuideMsbbCardHeader}
  </h2>
</div>
<div class="fragment-content">
  <div class="embedded-setting-wrapper">
    <settings-toggle-button id="urlCollectionToggle"
        pref="{{prefs.url_keyed_anonymized_data_collection.enabled}}"
        label="$i18n{urlKeyedAnonymizedDataCollection}"
        on-change="onMsbbToggleClick_">
    </settings-toggle-button>
  </div>
  <div class="settings-columned-section">
    <div class="column">
      <h3 class="description-header">
        $i18n{columnHeadingWhenOn}
      </h3>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:flash-on" aria-hidden="true"></cr-icon>
          <div class="secondary">
            $i18n{privacyGuideMsbbFeatureDescription1}
          </div>
        </li>
        <li>
          <cr-icon icon="settings20:lightbulb" aria-hidden="true"></cr-icon>
          <div class="secondary">
            $i18n{privacyGuideMsbbFeatureDescription2}
          </div>
        </li>
        <li>
          <cr-icon icon="settings20:notification-add" aria-hidden="true">
          </cr-icon>
          <div class="secondary">
            $i18n{privacyGuideMsbbFeatureDescription3}
          </div>
        </li>
      </ul>
    </div>
    <div class="column">
      <h3 class="description-header">$i18n{columnHeadingConsider}</h3>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:link" aria-hidden="true"></cr-icon>
          <div class="secondary">
            $i18n{privacyGuideMsbbPrivacyDescription1}
          </div>
        </li>
        <li>
          <cr-icon icon="settings20:data-connectors-system" aria-hidden="true">
          </cr-icon>
          <div class="secondary">
            $i18n{privacyGuideMsbbPrivacyDescription2}
          </div>
        </li>
      </ul>
    </div>
  </div>
</div>
<!--_html_template_end_-->`}
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrivacyGuideMsbbFragmentBase=PrefsMixin(PolymerElement);class PrivacyGuideMsbbFragmentElement extends PrivacyGuideMsbbFragmentBase{static get is(){return"privacy-guide-msbb-fragment"}static get template(){return getTemplate$a()}metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();startStateMsbbOn_;ready(){super.ready();this.addEventListener("view-enter-start",this.onViewEnterStart_);this.addEventListener("view-exit-finish",this.onViewExitFinish_)}focus(){this.shadowRoot.querySelector("[focus-element]").focus()}onViewEnterStart_(){this.startStateMsbbOn_=this.getPref("url_keyed_anonymized_data_collection.enabled").value;this.metricsBrowserProxy_.recordPrivacyGuideStepsEligibleAndReachedHistogram(PrivacyGuideStepsEligibleAndReached.MSBB_REACHED)}onViewExitFinish_(){const endStateMsbbOn=this.getPref("url_keyed_anonymized_data_collection.enabled").value;let state=null;if(this.startStateMsbbOn_){state=endStateMsbbOn?PrivacyGuideSettingsStates.MSBB_ON_TO_ON:PrivacyGuideSettingsStates.MSBB_ON_TO_OFF}else{state=endStateMsbbOn?PrivacyGuideSettingsStates.MSBB_OFF_TO_ON:PrivacyGuideSettingsStates.MSBB_OFF_TO_OFF}this.metricsBrowserProxy_.recordPrivacyGuideSettingsStatesHistogram(state)}onMsbbToggleClick_(){if(this.getPref("url_keyed_anonymized_data_collection.enabled").value){this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.ChangeMSBBOn")}else{this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.ChangeMSBBOff")}}}customElements.define(PrivacyGuideMsbbFragmentElement.is,PrivacyGuideMsbbFragmentElement);let instance$6=null;function getCss$1(){return instance$6||(instance$6=[...[getCss$x(),getCss$j(),getCss$r()],css`textarea{display:block;resize:none;position:relative;z-index:1}#input-container{background-color:var(--cr-input-background-color);border-radius:8px;border:1px solid rgba(0,0,0,0.1)}@media (prefers-color-scheme:dark){#input-container{border:1px solid rgba(255,255,255,0.8)}}:host([autogrow][has-max-height]) #input-container{box-sizing:content-box;max-height:var(--cr-textarea-autogrow-max-height);min-height:1lh}:host([invalid]) #underline{border-color:var(--cr-input-error-color)}#input{padding-bottom:var(--cr-input-padding-bottom);padding-inline-end:var(--cr-input-padding-end);padding-inline-start:var(--cr-input-padding-start);padding-top:var(--cr-input-padding-top)}#footerContainer{border-top:0;display:var(--cr-textarea-footer-display,none);font-size:var(--cr-form-field-label-font-size);height:var(--cr-form-field-label-height);justify-content:space-between;line-height:var(--cr-form-field-label-line-height);margin:8px 0;min-height:0;padding:0;white-space:var(--cr-input-error-white-space)}:host([invalid]) #label,:host([invalid]) #footerContainer{color:var(--cr-input-error-color)}#mirror{display:none;font-size:12px;line-height:16px}:host([autogrow]) #mirror{display:block;visibility:hidden;white-space:pre-wrap;word-wrap:break-word}:host([autogrow]) #mirror,:host([autogrow]) textarea{border:0;box-sizing:border-box;padding-bottom:var(--cr-input-padding-bottom,6px);padding-inline-end:var(--cr-input-padding-end,8px);padding-inline-start:var(--cr-input-padding-start,8px);padding-top:var(--cr-input-padding-top,6px)}:host([autogrow]) textarea{height:100%;left:0;overflow:hidden;position:absolute;resize:none;top:0;width:100%}:host([autogrow][has-max-height]) #mirror,:host([autogrow][has-max-height]) textarea{overflow-x:hidden;overflow-y:auto}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$1(){return html`
<div id="label" class="cr-form-field-label" ?hidden="${!this.label}"
    aria-hidden="true">
  ${this.label}
</div>
<div id="input-container">
  <!-- The mirror div is used to take up the required space when autogrow is
       set. -->
  <div id="mirror">${this.calculateMirror_()}</div>
  <!-- The textarea is limited to |rows| height. If the content exceeds the
       bounds, it scrolls by default unless autogrow is set. No space or
       comments are allowed before the closing tag. -->
  <div id="hover-layer"></div>
  <textarea id="input" ?autofocus="${this.autofocus}" .rows="${this.rows}"
     .value="${this.internalValue_}" aria-label="${this.label}"
     @input="${this.onInput_}" @focus="${this.onInputFocusChange_}"
     @blur="${this.onInputFocusChange_}" @change="${this.onInputChange_}"
     ?disabled="${this.disabled}" maxlength="${this.maxlength}"
     ?readonly="${this.readonly}" ?required="${this.required}"
     placeholder="${this.placeholder||nothing}">
  </textarea>
  <div id="underline-base"></div>
  <div id="underline"></div>
</div>
<div id="footerContainer" class="cr-row">
  <div id="firstFooter" aria-live="${this.getFooterAria_()}">
    ${this.firstFooter}
  </div>
  <div id="secondFooter" aria-live="${this.getFooterAria_()}">
    ${this.secondFooter}
  </div>
</div>`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class CrTextareaElement extends CrLitElement{static get is(){return"cr-textarea"}static get styles(){return getCss$1()}render(){return getHtml$1.bind(this)()}static get properties(){return{autofocus:{type:Boolean,reflect:true},disabled:{type:Boolean,reflect:true},required:{type:Boolean,reflect:true},maxlength:{type:Number},readonly:{type:Boolean,reflect:true},rows:{type:Number,reflect:true},label:{type:String},value:{type:String,notify:true},internalValue_:{type:String,state:true},placeholder:{type:String},autogrow:{type:Boolean,reflect:true},hasMaxHeight:{type:Boolean,reflect:true},invalid:{type:Boolean,reflect:true},firstFooter:{type:String},secondFooter:{type:String}}}#autofocus_accessor_storage=false;get autofocus(){return this.#autofocus_accessor_storage}set autofocus(value){this.#autofocus_accessor_storage=value}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#readonly_accessor_storage=false;get readonly(){return this.#readonly_accessor_storage}set readonly(value){this.#readonly_accessor_storage=value}#required_accessor_storage=false;get required(){return this.#required_accessor_storage}set required(value){this.#required_accessor_storage=value}#rows_accessor_storage=3;get rows(){return this.#rows_accessor_storage}set rows(value){this.#rows_accessor_storage=value}#label_accessor_storage="";get label(){return this.#label_accessor_storage}set label(value){this.#label_accessor_storage=value}#maxlength_accessor_storage;get maxlength(){return this.#maxlength_accessor_storage}set maxlength(value){this.#maxlength_accessor_storage=value}#value_accessor_storage="";get value(){return this.#value_accessor_storage}set value(value){this.#value_accessor_storage=value}#placeholder_accessor_storage="";get placeholder(){return this.#placeholder_accessor_storage}set placeholder(value){this.#placeholder_accessor_storage=value}#autogrow_accessor_storage=false;get autogrow(){return this.#autogrow_accessor_storage}set autogrow(value){this.#autogrow_accessor_storage=value}#hasMaxHeight_accessor_storage=false;get hasMaxHeight(){return this.#hasMaxHeight_accessor_storage}set hasMaxHeight(value){this.#hasMaxHeight_accessor_storage=value}#invalid_accessor_storage=false;get invalid(){return this.#invalid_accessor_storage}set invalid(value){this.#invalid_accessor_storage=value}#firstFooter_accessor_storage="";get firstFooter(){return this.#firstFooter_accessor_storage}set firstFooter(value){this.#firstFooter_accessor_storage=value}#secondFooter_accessor_storage="";get secondFooter(){return this.#secondFooter_accessor_storage}set secondFooter(value){this.#secondFooter_accessor_storage=value}#internalValue__accessor_storage="";get internalValue_(){return this.#internalValue__accessor_storage}set internalValue_(value){this.#internalValue__accessor_storage=value}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("value")){this.internalValue_=this.value===undefined||this.value===null?"":this.value}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("disabled")){this.setAttribute("aria-disabled",this.disabled?"true":"false")}}focusInput(){this.$.input.focus()}async onInputChange_(e){await this.updateComplete;this.fire("change",{sourceEvent:e})}calculateMirror_(){if(!this.autogrow){return""}const tokens=this.value?this.value.split("\n"):[""];while(this.rows>0&&tokens.length<this.rows){tokens.push("")}return tokens.join("\n")+"&nbsp;"}onInput_(e){this.internalValue_=e.target.value;this.value=this.internalValue_}onInputFocusChange_(){if(this.shadowRoot.activeElement===this.$.input){this.setAttribute("focused_","")}else{this.removeAttribute("focused_")}}getFooterAria_(){return this.invalid?"assertive":"polite"}}customElements.define(CrTextareaElement.is,CrTextareaElement);
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var SecureDnsMode;(function(SecureDnsMode){SecureDnsMode["OFF"]="off";SecureDnsMode["AUTOMATIC"]="automatic";SecureDnsMode["SECURE"]="secure"})(SecureDnsMode||(SecureDnsMode={}));var SecureDnsUiManagementMode;(function(SecureDnsUiManagementMode){SecureDnsUiManagementMode[SecureDnsUiManagementMode["NO_OVERRIDE"]=0]="NO_OVERRIDE";SecureDnsUiManagementMode[SecureDnsUiManagementMode["DISABLED_MANAGED"]=1]="DISABLED_MANAGED";SecureDnsUiManagementMode[SecureDnsUiManagementMode["DISABLED_PARENTAL_CONTROLS"]=2]="DISABLED_PARENTAL_CONTROLS"})(SecureDnsUiManagementMode||(SecureDnsUiManagementMode={}));class PrivacyPageBrowserProxyImpl{setBlockAutoplayEnabled(enabled){chrome.send("setBlockAutoplayEnabled",[enabled])}getSecureDnsResolverList(){return sendWithPromise("getSecureDnsResolverList")}getSecureDnsSetting(){return sendWithPromise("getSecureDnsSetting")}isValidConfig(entry){return sendWithPromise("isValidConfig",entry)}probeConfig(entry){return sendWithPromise("probeConfig",entry)}static getInstance(){return instance$5||(instance$5=new PrivacyPageBrowserProxyImpl)}static setInstance(obj){instance$5=obj}}let instance$5=null;function getTemplate$9(){return html$1`<!--_html_template_start_-->    <style>:host{cursor:auto;display:block;width:100%}cr-textarea{width:100%;--cr-textarea-footer-display:flex}
    </style>
    <!-- Max length of 100 KB to prevent browser from freezing. -->
    <cr-textarea id="input" value="{{value}}" rows=1 autogrow="true"
        placeholder="$i18n{secureDnsCustomPlaceholder}" invalid="[[showError_]]"
        first-footer="[[errorText_]]" maxlength="102400" spellcheck="false"
        on-keypress="onKeyPress_" on-input="onInput_"
        on-blur="validate" on-change="validate">
    </cr-textarea>
<!--_html_template_end_-->`}
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SecureDnsInputElement extends PolymerElement{static get is(){return"secure-dns-input"}static get template(){return getTemplate$9()}static get properties(){return{value:String,showError_:{type:Boolean,computed:"isInvalid_(errorText_)"},errorText_:{type:String,value:""}}}browserProxy_=PrivacyPageBrowserProxyImpl.getInstance();onKeyPress_(e){if(e.key==="Enter"&&!e.shiftKey){e.preventDefault();this.validate()}}onInput_(){this.errorText_=""}async validate(){this.errorText_="";const valueToValidate=this.value;const valid=await this.browserProxy_.isValidConfig(valueToValidate);const successfulProbe=valid&&await this.browserProxy_.probeConfig(valueToValidate);if(valueToValidate===this.value&&this.value!==""&&!successfulProbe){this.errorText_=loadTimeData.getString(valid?"secureDnsCustomConnectionError":"secureDnsCustomFormatError")}this.dispatchEvent(new CustomEvent("value-update",{bubbles:true,composed:true,detail:{isValid:valid,text:valueToValidate}}))}focus(){this.$.input.focusInput()}isInvalid_(){return this.errorText_.length>0}}customElements.define(SecureDnsInputElement.is,SecureDnsInputElement);function getTemplate$8(){return html$1`<!--_html_template_start_-->    <style include="cr-shared-style md-select">:host(.no-hr) settings-toggle-button.hr{border-top:0}#resolverSelect{width:inherit}#resolverLabel{flex:1}#privacyPolicy{display:none;padding:calc(var(--cr-section-padding) / 2) var(--cr-section-padding)}#privacyPolicy a{color:var(--cr-link-color)}#secureDnsInputContainer{margin-top:calc(var(--cr-section-padding) / 2)}
    </style>

    <settings-toggle-button
        id="secureDnsToggle"
        class="hr"
        pref="{{secureDnsToggle_}}"
        label="$i18n{secureDns}"
        sub-label="[[secureDnsDescription_]]"
        on-change="onToggleChanged_">
    </settings-toggle-button>

    <div id="resolverOptions" hidden="[[!showSecureDnsOptions_]]">
      <div class="cr-row continuation">
        <div id="resolverLabel" class="flex cr-padded-text">
          $i18n{secureDnsSecureDropdownModeDescription}
        </div>

        <select id="resolverSelect"
            class="md-select"
            aria-labelledby="resolverLabel"
            on-change="onDropdownSelectionChanged_">
          <option value="[[resolverTypeEnum_.AUTOMATIC]]">
            $i18n{secureDnsAutomaticModeDescription}
          </option>
          <option value="[[resolverTypeEnum_.CUSTOM]]">
            $i18n{secureDnsCustomProviderDescription}
          </option>
          <template is="dom-repeat" items="[[resolverOptions_]]">
            <option data-resolver-type$="[[resolverTypeEnum_.BUILT_IN]]"
                value="[[index]]">
              [[item.name]]
            </option>
          </template>
        </select>
      </div>

      <div id="privacyPolicy">
        <div class="cr-secondary-text"
            inner-h-t-m-l="[[privacyPolicyString_]]"></div>
      </div>

      <div id="secureDnsInputContainer" class="cr-row continuation">
        <secure-dns-input id="secureDnsInput"
            value="[[secureDnsInputValue_]]"
            on-value-update="onSecureDnsInputEvaluated_">
        </secure-dns-input>
      </div>
    </div>
<!--_html_template_end_-->`}
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsSecureDnsElementBase=WebUiListenerMixin(PrefsMixin(I18nMixin(PolymerElement)));var SecureDnsResolverType;(function(SecureDnsResolverType){SecureDnsResolverType["AUTOMATIC"]="automatic";SecureDnsResolverType["BUILT_IN"]="built-in";SecureDnsResolverType["CUSTOM"]="custom"})(SecureDnsResolverType||(SecureDnsResolverType={}));class SettingsSecureDnsElement extends SettingsSecureDnsElementBase{static get is(){return"settings-secure-dns"}static get template(){return getTemplate$8()}static get properties(){return{resolverTypeEnum_:{type:Object,value:SecureDnsResolverType},secureDnsDescription_:String,secureDnsToggle_:{type:Object,value(){return{type:chrome.settingsPrivate.PrefType.BOOLEAN,value:false}}},showSecureDnsOptions_:Boolean,resolverOptions_:Array,privacyPolicyString_:String,secureDnsInputValue_:String}}browserProxy_=PrivacyPageBrowserProxyImpl.getInstance();connectedCallback(){super.connectedCallback();this.browserProxy_.getSecureDnsResolverList().then((resolvers=>{this.resolverOptions_=resolvers;this.browserProxy_.getSecureDnsSetting().then((setting=>this.onSecureDnsPrefsChanged_(setting)));this.addWebUiListener("secure-dns-setting-changed",(setting=>this.onSecureDnsPrefsChanged_(setting)))}))}onSecureDnsPrefsChanged_(setting){switch(setting.mode){case SecureDnsMode.SECURE:case SecureDnsMode.AUTOMATIC:this.set("secureDnsToggle_.value",true);this.updateConfigRepresentation_(setting.mode,setting.config);break;case SecureDnsMode.OFF:this.set("secureDnsToggle_.value",false);break;default:assertNotReached("Received unknown secure DNS mode")}this.updateManagementView_(setting)}onToggleChanged_(){this.showSecureDnsOptions_=this.secureDnsToggle_.value;if(!this.secureDnsToggle_.value){this.updateDnsPrefs_(SecureDnsMode.OFF);return}const resolver=this.$.resolverSelect.value;if(resolver===SecureDnsResolverType.AUTOMATIC){this.updateDnsPrefs_(SecureDnsMode.AUTOMATIC)}else{if(resolver===SecureDnsResolverType.CUSTOM){this.$.secureDnsInput.focus()}this.updateDnsPrefs_(SecureDnsMode.SECURE)}}updateDnsPrefs_(mode,templates=""){switch(mode){case SecureDnsMode.SECURE:const builtInResolver=this.builtInResolver_();if(!builtInResolver){if(!templates){return}this.setPrefValue("dns_over_https.templates",templates)}else{this.setPrefValue("dns_over_https.templates",builtInResolver.value)}this.setPrefValue("dns_over_https.mode",mode);break;case SecureDnsMode.AUTOMATIC:case SecureDnsMode.OFF:this.setPrefValue("dns_over_https.mode",mode);this.setPrefValue("dns_over_https.templates","");break;default:assertNotReached("Received unknown secure DNS mode")}}onDropdownSelectionChanged_(){switch(this.$.resolverSelect.value){case SecureDnsResolverType.AUTOMATIC:this.updateDnsPrefs_(SecureDnsMode.AUTOMATIC);this.updateConfigRepresentation_(SecureDnsMode.AUTOMATIC,"");break;case SecureDnsResolverType.CUSTOM:this.updateDnsPrefs_(SecureDnsMode.SECURE);this.updateConfigRepresentation_(SecureDnsMode.SECURE,"");break;default:const resolver=this.builtInResolver_();assert(resolver);this.updateDnsPrefs_(SecureDnsMode.SECURE,resolver.value);this.updateConfigRepresentation_(SecureDnsMode.SECURE,resolver.value);break}}updateManagementView_(setting){if(this.prefs===undefined){return}const pref={key:"",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:this.secureDnsToggle_.value};const secureDescription=loadTimeData.getString("secureDnsDescription");if(this.getPref("dns_over_https.mode").enforcement===chrome.settingsPrivate.Enforcement.ENFORCED){pref.enforcement=chrome.settingsPrivate.Enforcement.ENFORCED;pref.controlledBy=this.getPref("dns_over_https.mode").controlledBy;this.secureDnsDescription_=secureDescription}else{switch(setting.managementMode){case SecureDnsUiManagementMode.NO_OVERRIDE:this.secureDnsDescription_=secureDescription;break;case SecureDnsUiManagementMode.DISABLED_MANAGED:pref.enforcement=chrome.settingsPrivate.Enforcement.ENFORCED;this.secureDnsDescription_=loadTimeData.getString("secureDnsDisabledForManagedEnvironment");break;case SecureDnsUiManagementMode.DISABLED_PARENTAL_CONTROLS:pref.enforcement=chrome.settingsPrivate.Enforcement.ENFORCED;this.secureDnsDescription_=loadTimeData.getString("secureDnsDisabledForParentalControl");break;default:assertNotReached("Received unknown secure DNS management mode "+setting.managementMode)}}this.secureDnsToggle_=pref;if(this.secureDnsToggle_.enforcement===chrome.settingsPrivate.Enforcement.ENFORCED){this.showSecureDnsOptions_=false}else{this.showSecureDnsOptions_=this.secureDnsToggle_.value}}updateConfigRepresentation_(mode,template){let hideCustomEntry=true;let selectValue="";let privacyPolicy="";const index=this.resolverOptions_.findIndex((r=>r.value===template));if(index!==-1){privacyPolicy=this.resolverOptions_[index].policy}switch(mode){case SecureDnsMode.AUTOMATIC:selectValue=SecureDnsResolverType.AUTOMATIC;break;case SecureDnsMode.SECURE:if(index===-1){selectValue=SecureDnsResolverType.CUSTOM;hideCustomEntry=false}else{selectValue=index.toString()}break;default:assertNotReached(`Unexpected DNS mode ${mode}`)}this.$.resolverSelect.value=selectValue;this.updatePrivacyPolicyLine_(privacyPolicy);this.$.secureDnsInputContainer.hidden=hideCustomEntry;if(!hideCustomEntry){this.secureDnsInputValue_=template;if(!template){this.$.secureDnsInput.focus()}}}updatePrivacyPolicyLine_(policy){if(!policy){this.$.privacyPolicy.style.display="none";return}this.$.privacyPolicy.style.display="block";this.privacyPolicyString_=sanitizeInnerHtml(loadTimeData.substituteString(loadTimeData.getString("secureDnsSecureDropdownModePrivacyPolicy"),policy))}onSecureDnsInputEvaluated_(event){if(event.detail.isValid){this.updateDnsPrefs_(SecureDnsMode.SECURE,event.detail.text)}}builtInResolver_(){if(this.$.resolverSelect.selectedOptions[0].dataset["resolverType"]===SecureDnsResolverType.BUILT_IN){const index=Number.parseInt(this.$.resolverSelect.value);return this.resolverOptions_[index]}return undefined}}customElements.define(SettingsSecureDnsElement.is,SettingsSecureDnsElement);let instance$4=null;function getCss(){return instance$4||(instance$4=[...[getCss$r(),getCss$j()],css`:host{display:flex;user-select:none;--cr-search-field-clear-icon-fill:var(--google-grey-700);--cr-search-field-clear-icon-margin-end:-4px;--cr-search-field-input-border-bottom:1px solid var(--cr-secondary-text-color)}#searchIcon{align-self:center;display:var(--cr-search-field-search-icon-display,inherit);height:16px;padding:4px;vertical-align:middle;width:16px}#searchIconInline{--iron-icon-fill-color:var(--cr-search-field-search-icon-fill,inherit);display:var(--cr-search-field-search-icon-inline-display,none);margin-inline-start:var(--cr-search-field-search-icon-inline-margin-start,0)}#searchInput{--owl-border-override:none;--cr-input-background-color:transparent;--cr-input-border-bottom:var(--cr-search-field-input-border-bottom);--cr-input-border-radius:0;--cr-input-error-display:none;--cr-input-min-height:var(--cr-search-field-input-min-height,24px);--cr-input-padding-end:0;--cr-input-padding-start:var(--cr-search-field-input-padding-start,0);--cr-input-padding-bottom:var(--cr-search-field-input-padding-bottom,2px);--cr-input-padding-top:var(--cr-search-field-input-padding-top,2px);--cr-input-placeholder-color:var(--cr-search-field-placeholder-color);--cr-input-underline-display:var(--cr-search-field-underline-display);--cr-input-underline-border-radius:var(--cr-search-field-input-underline-border-radius,0);--cr-input-underline-height:var(--cr-search-field-input-underline-height,0);align-self:stretch;color:var(--cr-primary-text-color);display:block;font-size:92.3076923%;width:var(--cr-search-field-input-width,160px)}:host([has-search-text]) #searchInput{--cr-input-padding-end:calc(24px + var(--cr-search-field-clear-icon-margin-end))}#clearSearch{--cr-icon-button-fill-color:var(--cr-search-field-clear-icon-fill);--cr-icon-button-icon-size:var(--cr-search-field-clear-icon-size,16px);--cr-icon-button-size:var(--cr-search-field-clear-button-size,24px);margin-inline-end:var(--cr-search-field-clear-icon-margin-end);margin-inline-start:4px;position:absolute;right:0;z-index:1}:host-context([dir='rtl']) #clearSearch{left:0;right:auto}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml(){return html`
<cr-icon id="searchIcon" icon="cr:search" part="searchIcon"></cr-icon>
<cr-input id="searchInput" part="searchInput"
    @search="${this.onSearchTermSearch}" @input="${this.onSearchTermInput}"
    aria-label="${this.label}" type="search" ?autofocus="${this.autofocus}"
    .placeholder="${this.label}" spellcheck="false">
  <cr-icon id="searchIconInline" slot="inline-prefix" icon="cr:search">
  </cr-icon>
  <cr-icon-button id="clearSearch" class="icon-cancel" slot="suffix"
      ?hidden="${!this.hasSearchText}"  @click="${this.onClearSearchClick_}"
      .title="${this.clearLabel}">
  </cr-icon-button>
</cr-input>`}
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrSearchFieldElementBase=CrSearchFieldMixinLit(CrLitElement);class CrSearchFieldElement extends CrSearchFieldElementBase{static get is(){return"cr-search-field"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{autofocus:{type:Boolean}}}#autofocus_accessor_storage=false;get autofocus(){return this.#autofocus_accessor_storage}set autofocus(value){this.#autofocus_accessor_storage=value}getSearchInput(){return this.$.searchInput}onClearSearchClick_(){this.setValue("");setTimeout((()=>{this.$.searchInput.focus()}))}}customElements.define(CrSearchFieldElement.is,CrSearchFieldElement);
// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class KeyboardShortcut{useKeyCode_=false;mods_={};key_=null;keyCode_=null;constructor(shortcut){shortcut.split("|").forEach((part=>{const partLc=part.toLowerCase();switch(partLc){case"alt":case"ctrl":case"meta":case"shift":this.mods_[partLc+"Key"]=true;break;default:if(this.key_){throw Error("Invalid shortcut")}this.key_=part;if(part.match(/^[a-z]$/)){this.useKeyCode_=true;this.keyCode_=part.toUpperCase().charCodeAt(0)}}}))}matchesEvent(e){if(this.useKeyCode_&&e.keyCode===this.keyCode_||e.key===this.key_){const mods=this.mods_;return["altKey","ctrlKey","metaKey","shiftKey"].every((function(k){return e[k]===!!mods[k]}))}return false}}class KeyboardShortcutList{shortcuts_;constructor(shortcuts){this.shortcuts_=shortcuts.split(/\s+/).map((function(shortcut){return new KeyboardShortcut(shortcut)}))}matchesEvent(e){return this.shortcuts_.some((function(keyboardShortcut){return keyboardShortcut.matchesEvent(e)}))}}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const FindShortcutManager=(()=>{const listeners=[];let modalContextOpen=false;const shortcutCtrlF=new KeyboardShortcutList(isMac?"meta|f":"ctrl|f");const shortcutSlash=new KeyboardShortcutList("/");window.addEventListener("keydown",(e=>{if(e.defaultPrevented||listeners.length===0){return}const element=e.composedPath()[0];if(!shortcutCtrlF.matchesEvent(e)&&(element.tagName==="INPUT"||element.tagName==="TEXTAREA"||!shortcutSlash.matchesEvent(e))){return}const focusIndex=listeners.findIndex((listener=>listener.searchInputHasFocus()));const index=focusIndex<=0?listeners.length-1:focusIndex-1;if(listeners[index].handleFindShortcut(modalContextOpen)){e.preventDefault()}}));window.addEventListener("cr-dialog-open",(()=>{modalContextOpen=true}));window.addEventListener("cr-drawer-opened",(()=>{modalContextOpen=true}));window.addEventListener("close",(e=>{if(["CR-DIALOG","CR-DRAWER"].includes(e.composedPath()[0].nodeName)){modalContextOpen=false}}));return Object.freeze({listeners:listeners})})();
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const FindShortcutMixin=dedupingMixin((superClass=>{class FindShortcutMixin extends superClass{findShortcutListenOnAttach=true;connectedCallback(){super.connectedCallback();if(this.findShortcutListenOnAttach){this.becomeActiveFindShortcutListener()}}disconnectedCallback(){super.disconnectedCallback();if(this.findShortcutListenOnAttach){this.removeSelfAsFindShortcutListener()}}becomeActiveFindShortcutListener(){const listeners=FindShortcutManager.listeners;assert(!listeners.includes(this),"Already listening for find shortcuts.");listeners.push(this)}handleFindShortcutInternal_(){assertNotReached("Must override handleFindShortcut()")}handleFindShortcut(_modalContextOpen){this.handleFindShortcutInternal_();return false}removeSelfAsFindShortcutListener(){const listeners=FindShortcutManager.listeners;const index=listeners.indexOf(this);assert(listeners.includes(this),"Find shortcut listener not found.");listeners.splice(index,1)}searchInputHasFocusInternal_(){assertNotReached("Must override searchInputHasFocus()")}searchInputHasFocus(){this.searchInputHasFocusInternal_();return false}}return FindShortcutMixin}));function getTemplate$7(){return html$1`<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">:host{box-sizing:border-box;display:block;left:0;min-height:calc(100vh - var(--cr-toolbar-height) - var(--cr-toolbar-padding-top,0px));padding-bottom:60px;position:absolute;right:0;top:0}:host(:not(.multi-card)){background-color:var(--cr-card-background-color);border:1px solid rgba(0,0,0,0.1);border-top:none;border-radius:0 0 10px 10px}@media (forced-colors:active){:host(:not(.multi-card)){border-inline-end:var(--cr-border-hcm);border-inline-start:var(--cr-border-hcm)}}#headerLine{min-height:40px;padding-bottom:24px;padding-top:8px}#learnMore{align-items:center;display:flex;height:var(--cr-icon-ripple-size);justify-content:center;margin-inline-end:var(--cr-icon-ripple-margin);margin-inline-start:var(--cr-icon-button-margin-start);position:relative;width:var(--cr-icon-ripple-size)}#title-icon{height:36px;width:36px}#title-icon,#favicon{margin-inline-end:12px;margin-inline-start:2px}#closeButton{margin-inline-end:10px;margin-inline-start:-10px}.cr-title-text{white-space:nowrap;overflow:hidden;text-overflow:ellipsis}h1{flex:1}cr-search-field{margin-inline-start:16px}
    </style>
    <div class="cr-row first" id="headerLine">
      <cr-icon-button class="icon-arrow-back" id="closeButton"
          hidden="[[hideCloseButton]]" on-click="onBackClick_"
          aria-label$="[[getBackButtonAriaLabel_(pageTitle)]]"
          aria-roledescription$=
              "[[getBackButtonAriaRoleDescription_(pageTitle)]]">
      </cr-icon-button>
      <template is="dom-if" if="[[titleIcon]]">
        <img id="title-icon" src="[[titleIcon]]" aria-hidden="true">
      </template>
      <template is="dom-if" if="[[faviconSiteUrl]]">
        <site-favicon id="favicon" url="[[faviconSiteUrl]]" aria-hidden="true">
        </site-favicon>
      </template>
      <h1 class="cr-title-text">[[pageTitle]]</h1>
      <slot name="subpage-title-extra"></slot>
      <template is="dom-if" if="[[learnMoreUrl]]">
        <cr-icon-button iron-icon="cr:help-outline" suppress-rtl-flip
            aria-label="[[getLearnMoreAriaLabel_(pageTitle)]]"
            aria-description="$i18n{opensInNewTab}" on-click="onHelpClick_"
            hidden>
        </cr-icon-button>
      </template>
      <template is="dom-if" if="[[searchLabel]]">
        <cr-search-field label="[[searchLabel]]"
            on-search-changed="onSearchChanged_"
            clear-label="$i18n{clearSearch}">
        </cr-search-field>
      </template>
    </div>
    <slot></slot>
<!--_html_template_end_-->`}
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SETTING_ID_URL_PARAM_NAME="settingId";function getSettingIdParameter(){return Router.getInstance().getQueryParameters().get(SETTING_ID_URL_PARAM_NAME)}const SettingsSubpageElementBase=mixinBehaviors([IronResizableBehavior],RouteObserverMixin(FindShortcutMixin(I18nMixin(PolymerElement))));class SettingsSubpageElement extends SettingsSubpageElementBase{static get is(){return"settings-subpage"}static get template(){return getTemplate$7()}static get properties(){return{pageTitle:String,titleIcon:String,faviconSiteUrl:String,learnMoreUrl:String,searchLabel:String,searchTerm:{type:String,notify:true,value:""},hideCloseButton:{type:Boolean,value:false},preserveSearchTerm:{type:Boolean,value:false},active_:{type:Boolean,value:false,observer:"onActiveChanged_"}}}lastActiveValue_=false;eventTracker_=null;constructor(){super();this.findShortcutListenOnAttach=false}connectedCallback(){super.connectedCallback();if(this.searchLabel){this.eventTracker_=new EventTracker;this.eventTracker_.add(this,"clear-subpage-search",this.onClearSubpageSearch_)}}disconnectedCallback(){super.disconnectedCallback();if(this.eventTracker_){this.eventTracker_.removeAll()}}getSearchField_(){let searchField=this.shadowRoot.querySelector("cr-search-field");if(searchField){return Promise.resolve(searchField)}return new Promise((resolve=>{listenOnce(this,"dom-change",(()=>{searchField=this.shadowRoot.querySelector("cr-search-field");assert(!!searchField);resolve(searchField)}))}))}restoreSearchInput_(){const searchField=this.shadowRoot.querySelector("cr-search-field");const urlSearchQuery=Router.getInstance().getQueryParameters().get("searchSubpage")||"";this.searchTerm=urlSearchQuery;searchField.setValue(urlSearchQuery)}preserveSearchInput_(){const query=this.searchTerm;const searchParams=query.length>0?new URLSearchParams("searchSubpage="+encodeURIComponent(query)):undefined;const currentRoute=Router.getInstance().getCurrentRoute();Router.getInstance().navigateTo(currentRoute,searchParams)}focusBackButton(){if(this.hideCloseButton){return}afterNextRender(this,(()=>focusWithoutInk(this.$.closeButton)))}currentRouteChanged(newRoute,oldRoute){this.active_=this.getAttribute("route-path")===newRoute.path;if(this.active_&&this.searchLabel&&this.preserveSearchTerm){this.getSearchField_().then((()=>this.restoreSearchInput_()))}if(!oldRoute&&!getSettingIdParameter()){this.focusBackButton()}}onActiveChanged_(){if(this.lastActiveValue_===this.active_){return}this.lastActiveValue_=this.active_;if(this.active_&&this.pageTitle){document.title=loadTimeData.getStringF("settingsAltPageTitle",this.pageTitle)}if(!this.searchLabel){return}const searchField=this.shadowRoot.querySelector("cr-search-field");if(searchField){searchField.setValue("")}if(this.active_){this.becomeActiveFindShortcutListener()}else{this.removeSelfAsFindShortcutListener()}}onClearSubpageSearch_(e){e.stopPropagation();this.shadowRoot.querySelector("cr-search-field").setValue("")}onBackClick_(){Router.getInstance().navigateToPreviousRoute()}onHelpClick_(){window.open(this.learnMoreUrl)}onSearchChanged_(e){if(this.searchTerm===e.detail){return}this.searchTerm=e.detail;if(this.preserveSearchTerm&&this.active_){this.preserveSearchInput_()}}getBackButtonAriaLabel_(){return this.i18n("subpageBackButtonAriaLabel",this.pageTitle)}getBackButtonAriaRoleDescription_(){return this.i18n("subpageBackButtonAriaRoleDescription",this.pageTitle)}getLearnMoreAriaLabel_(){return this.i18n("subpageLearnMoreAriaLabel",this.pageTitle)}handleFindShortcut(modalContextOpen){if(modalContextOpen){return false}this.shadowRoot.querySelector("cr-search-field").getSearchInput().focus();return true}searchInputHasFocus(){const field=this.shadowRoot.querySelector("cr-search-field");return field.getSearchInput()===field.shadowRoot.activeElement}}customElements.define(SettingsSubpageElement.is,SettingsSubpageElement);function getTemplate$6(){return html$1`<!--_html_template_start_--><cr-dialog id="dialog" close-text="$i18n{close}" show-on-attach>
  <div slot="title">[[titleText]]</div>
  <div slot="body">[[bodyText]]</div>
  <div slot="button-container">
    <cr-button  id="cancel" class="cancel-button" on-click="onCancelClick_">
      $i18n{cancel}
    </cr-button>
    <cr-button id="confirm"
        class$="[[getConfirmButtonCssClass_(noPrimaryButton)]]"
        on-click="onConfirmClick_">
      [[confirmText]]
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsSimpleConfirmationDialogElement extends PolymerElement{static get is(){return"settings-simple-confirmation-dialog"}static get template(){return getTemplate$6()}static get properties(){return{titleText:String,bodyText:String,confirmText:String,noPrimaryButton:{type:Boolean,value:false}}}wasConfirmed(){return this.$.dialog.getNative().returnValue==="success"}onCancelClick_(){this.$.dialog.cancel()}onConfirmClick_(){this.$.dialog.close()}getConfirmButtonCssClass_(){return this.noPrimaryButton?"":"action-button"}}customElements.define(SettingsSimpleConfirmationDialogElement.is,SettingsSimpleConfirmationDialogElement);
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getLocalizationStringForContentType(contentSettingsType){switch(contentSettingsType){case ContentSettingsTypes.ADS:return"siteSettingsAdsMidSentence";case ContentSettingsTypes.AR:return"siteSettingsArMidSentence";case ContentSettingsTypes.AUTO_PICTURE_IN_PICTURE:return"siteSettingsAutoPictureInPictureMidSentence";case ContentSettingsTypes.AUTOMATIC_DOWNLOADS:return"siteSettingsAutomaticDownloadsMidSentence";case ContentSettingsTypes.AUTOMATIC_FULLSCREEN:return"siteSettingsAutomaticFullscreenMidSentence";case ContentSettingsTypes.BACKGROUND_SYNC:return"siteSettingsBackgroundSyncMidSentence";case ContentSettingsTypes.BLUETOOTH_DEVICES:return"siteSettingsBluetoothDevicesMidSentence";case ContentSettingsTypes.BLUETOOTH_SCANNING:return"siteSettingsBluetoothScanningMidSentence";case ContentSettingsTypes.CAMERA:return"siteSettingsCameraMidSentence";case ContentSettingsTypes.CAPTURED_SURFACE_CONTROL:return"siteSettingsCapturedSurfaceControlMidSentence";case ContentSettingsTypes.CLIPBOARD:return"siteSettingsClipboardMidSentence";case ContentSettingsTypes.COOKIES:return"siteSettingsCookiesMidSentence";case ContentSettingsTypes.FEDERATED_IDENTITY_API:return"siteSettingsFederatedIdentityApiMidSentence";case ContentSettingsTypes.FILE_SYSTEM_WRITE:return"siteSettingsFileSystemWriteMidSentence";case ContentSettingsTypes.GEOLOCATION:return"siteSettingsLocationMidSentence";case ContentSettingsTypes.HAND_TRACKING:return"siteSettingsHandTrackingMidSentence";case ContentSettingsTypes.HID_DEVICES:return"siteSettingsHidDevicesMidSentence";case ContentSettingsTypes.IDLE_DETECTION:return"siteSettingsIdleDetectionMidSentence";case ContentSettingsTypes.IMAGES:return"siteSettingsImagesMidSentence";case ContentSettingsTypes.JAVASCRIPT:return"siteSettingsJavascriptMidSentence";case ContentSettingsTypes.JAVASCRIPT_OPTIMIZER:return"siteSettingsJavascriptOptimizerMidsentence";case ContentSettingsTypes.KEYBOARD_LOCK:return"siteSettingsKeyboardLockMidSentence";case ContentSettingsTypes.LOCAL_FONTS:return"siteSettingsFontAccessMidSentence";case ContentSettingsTypes.LOCAL_NETWORK_ACCESS:return"siteSettingsLocalNetworkAccessMidSentence";case ContentSettingsTypes.MIC:return"siteSettingsMicMidSentence";case ContentSettingsTypes.MIDI_DEVICES:return"siteSettingsMidiDevicesMidSentence";case ContentSettingsTypes.MIXEDSCRIPT:return"siteSettingsInsecureContentMidSentence";case ContentSettingsTypes.NOTIFICATIONS:return"siteSettingsNotificationsMidSentence";case ContentSettingsTypes.PAYMENT_HANDLER:return"siteSettingsPaymentHandlerMidSentence";case ContentSettingsTypes.POINTER_LOCK:return"siteSettingsPointerLockMidSentence";case ContentSettingsTypes.POPUPS:return"siteSettingsPopupsMidSentence";case ContentSettingsTypes.PROTECTED_CONTENT:return"siteSettingsProtectedContentMidSentence";case ContentSettingsTypes.PROTOCOL_HANDLERS:return"siteSettingsHandlersMidSentence";case ContentSettingsTypes.SENSORS:return"siteSettingsSensorsMidSentence";case ContentSettingsTypes.SERIAL_PORTS:return"siteSettingsSerialPortsMidSentence";case ContentSettingsTypes.SOUND:return"siteSettingsSoundMidSentence";case ContentSettingsTypes.STORAGE_ACCESS:return"siteSettingsStorageAccessMidSentence";case ContentSettingsTypes.USB_DEVICES:return"siteSettingsUsbDevicesMidSentence";case ContentSettingsTypes.WEB_APP_INSTALLATION:return"siteSettingsWebAppInstallationMidSentence";case ContentSettingsTypes.WEB_PRINTING:return"siteSettingsWebPrintingMidSentence";case ContentSettingsTypes.VR:return"siteSettingsVrMidSentence";case ContentSettingsTypes.WINDOW_MANAGEMENT:return"siteSettingsWindowManagementMidSentence";case ContentSettingsTypes.ZOOM_LEVELS:return"siteSettingsZoomLevelsMidSentence";case ContentSettingsTypes.ANTI_ABUSE:case ContentSettingsTypes.PDF_DOCUMENTS:case ContentSettingsTypes.PERFORMANCE:case ContentSettingsTypes.PRIVATE_NETWORK_DEVICES:case ContentSettingsTypes.SITE_DATA:case ContentSettingsTypes.TRACKING_PROTECTION:case ContentSettingsTypes.OFFER_WRITING_HELP:case ContentSettingsTypes.SMART_CARD_READERS:return null;default:assertNotReached()}}function isSettingEnabled(setting){return setting!==ContentSetting.BLOCK}function getTemplate$5(){return html$1`<!--_html_template_start_-->  <style include="cr-shared-style settings-shared settings-columned-section">#safeBrowsingSection{padding:0 var(--cr-section-padding)}#advancedProtectionProgramLink{display:none}.bullet-line{align-items:center;display:flex;min-height:var(--cr-section-min-height)}.bullet-line>div{padding-inline-start:var(--cr-radio-button-size)}settings-collapse-radio-button:not(:first-of-type){--settings-collapse-separator-line:var(--cr-separator-line)}settings-collapse-radio-button[hidden]+settings-collapse-radio-button{--settings-collapse-separator-line:0}settings-collapse-radio-button .bullet-line:last-child{padding-bottom:12px}settings-toggle-button{padding-inline-end:0;padding-inline-start:0}settings-toggle-button:not([disabled]){pointer-events:all}#safeBrowsingEnhanced .bullet-line:last-of-type{padding-bottom:12px}#safeBrowsingEnhanced{--cr-radio-button-unchecked-ripple-color:var(--cr-radio-button-checked-ripple-color)}#secureConnectionsSection h2{padding:24px var(--cr-section-padding) 8px}#httpsOnlyModeToggle,#passwordsLeakToggle{padding:0 var(--cr-section-padding)}#httpsFirstModeToggle{margin-top:8px}#httpsFirstModeRadioGroup{width:100%}#httpsFirstModeRadioGroup .list-item{padding-inline-end:20px;padding-inline-start:20px}#learnMoreLabelContainer{padding-bottom:12px;pointer-events:auto}
  </style>
  <settings-subpage page-title="$i18n{securityPageTitle}"
      learn-more-url="$i18n{safeBrowsingHelpCenterURL}"
      route-path$="[[routePath]]" hide-close-button>
    <div id="safeBrowsingSection">
      <h2 class="cr-title-text">$i18n{safeBrowsingSectionLabel}</h2>
      <settings-radio-group id="safeBrowsingRadioGroup" no-set-pref
          pref="{{prefs.generated.safe_browsing}}"
          selectable-elements="cr-radio-button, settings-collapse-radio-button"
          on-change="onSafeBrowsingRadioChange_">
        <settings-collapse-radio-button id="safeBrowsingEnhanced"
            name="[[safeBrowsingSettingEnum_.ENHANCED]]"
            pref="[[prefs.generated.safe_browsing]]"
            label="$i18n{safeBrowsingEnhanced}"
            sub-label="$i18n{safeBrowsingEnhancedDescUpdated}"
            indicator-aria-label="$i18n{controlledSettingPolicy}"
            expand-aria-label="$i18n{safeBrowsingEnhancedExpandA11yLabel}"
            on-expand-clicked="onEnhancedProtectionExpandButtonClicked_"
            no-automatic-collapse>
          <div slot="collapse">
            <div id="enhancedProtectionDescContainer"
                class="settings-columned-section">
              <div class="column">
                <h3 class="description-header">
                  $i18n{columnHeadingWhenOn}
                </h3>
                <ul class="icon-bulleted-list">
                  <li>
                    <cr-icon icon="settings20:data" aria-hidden="true">
                    </cr-icon>
                    <div class="secondary">
                      $i18n{safeBrowsingEnhancedWhenOnBulOne}
                    </div>
                  </li>
                  <li>
                    <cr-icon icon="settings20:download" aria-hidden="true">
                    </cr-icon>
                    <div class="secondary">
                      $i18n{safeBrowsingEnhancedWhenOnBulTwo}
                    </div>
                  </li>
                  <li>
                    <cr-icon icon="settings20:gshield" aria-hidden="true">
                    </cr-icon>
                    <div class="secondary">
                      $i18n{safeBrowsingEnhancedWhenOnBulThree}
                    </div>
                  </li>
                  <li>
                    <cr-icon icon="settings:language" aria-hidden="true">
                    </cr-icon>
                    <div class="secondary">
                      $i18n{safeBrowsingEnhancedWhenOnBulFour}
                    </div>
                  </li>
                </ul>
              </div>
              <div class="column">
                <h3 class="description-header">
                  $i18n{columnHeadingConsider}
                </h3>
                <ul class="icon-bulleted-list">
                  <li>
                    <cr-icon icon="settings20:link"></cr-icon>
                    <div class="cr-secondary-text">
                      $i18n{safeBrowsingEnhancedThingsToConsiderBulOne}
                    </div>
                  </li>
                  <li>
                    <cr-icon icon="settings20:account-circle"></cr-icon>
                    <div class="cr-secondary-text">
                      $i18n{safeBrowsingEnhancedThingsToConsiderBulTwo}
                    </div>
                  </li>
                  <li>
                    <cr-icon icon="settings:performance"></cr-icon>
                    <div class="cr-secondary-text">
                      $i18n{safeBrowsingEnhancedThingsToConsiderBulThree}
                    </div>
                  </li>
                </ul>
              </div>
            </div>
            <div id="learnMoreLabelContainer">
              <div class="cr-secondary-text">
                $i18nRaw{safeBrowsingEnhancedLearnMoreLabel}
              </div>
            </div>
          </div>
        </settings-collapse-radio-button>
        <settings-collapse-radio-button id="safeBrowsingStandard"
            no-collapse="[[hideExtendedReportingRadioButton_]]"
            name="[[safeBrowsingSettingEnum_.STANDARD]]"
            pref="[[prefs.generated.safe_browsing]]"
            label="$i18n{safeBrowsingStandard}"
            sub-label="[[getSafeBrowsingStandardSubLabel_(
                        enableHashPrefixRealTimeLookups_)]]"
            indicator-aria-label="$i18n{controlledSettingPolicy}"
            expand-aria-label="$i18n{safeBrowsingStandardExpandA11yLabel}"
            info-opened="{{infoOpened_}}"
            on-expand-clicked="onStandardProtectionExpandButtonClicked_"
            no-automatic-collapse>
          <div slot="noSelectionCollapse">
            <template is="dom-if" if="[[!hideExtendedReportingRadioButton_]]">
              <settings-toggle-button id="safeBrowsingReportingToggle"
                pref="{{prefs.safebrowsing.scout_reporting_enabled}}"
                label="$i18n{safeBrowsingStandardReportingLabel}"
                sub-label="$i18n{safeBrowsingEnableExtendedReportingDesc}"
                on-change="onSafeBrowsingExtendedReportingChange_"
                disabled="[[getDisabledExtendedSafeBrowsing_(
                              prefs.generated.safe_browsing.*)]]">
              </settings-toggle-button>
            </template>
          </div>
        </settings-collapse-radio-button>
        <settings-collapse-radio-button id="safeBrowsingDisabled" no-collapse
            name="[[safeBrowsingSettingEnum_.DISABLED]]"
            pref="[[prefs.generated.safe_browsing]]"
            label="$i18n{safeBrowsingNone}"
            sub-label="$i18n{safeBrowsingNoneDesc}"
            indicator-aria-label="$i18n{controlledSettingPolicy}">
        </settings-collapse-radio-button>
      </settings-radio-group>
    </div>
    <template is="dom-if" if="[[enableHttpsFirstModeNewSettings_]]" restamp>
      <div id="secureConnectionsSection">
        <h2 class="cr-title-text">$i18n{secureConnectionsSectionTitle}</h2>
        <settings-toggle-button id="httpsFirstModeToggle" class="cr-row first"
            pref="{{prefs.generated.https_first_mode_enabled}}"
            label="$i18n{httpsOnlyModeTitle}"
            sub-label="[[getHttpsFirstModeSubLabel_(
                prefs.generated.https_first_mode_enabled.*)]]"
            numeric-unchecked-values="[[httpsFirstModeUncheckedValues_]]"
            numeric-checked-value=
                "[[httpsFirstModeSettingEnum_.ENABLED_BALANCED]]">
        </settings-toggle-button>
        <cr-collapse id="httpsFirstModeRadioGroupCollapse"
            opened="[[isHttpsFirstModeExpanded_(
                        prefs.generated.https_first_mode_enabled.value)]]">
          <div class="cr-row continuation https-first-mode-radio-group">
            <settings-radio-group id="httpsFirstModeRadioGroup"
                pref="{{prefs.generated.https_first_mode_enabled}}">
              <controlled-radio-button id="httpsFirstModeEnabledBalanced"
                name="[[getName_(
                          httpsFirstModeSettingEnum_.ENABLED_BALANCED)]]"
                pref="[[prefs.generated.https_first_mode_enabled]]"
                label="$i18n{httpsFirstModeEnabledBalancedLabel}"
                class="list-item">
            </controlled-radio-button>
              <controlled-radio-button id="httpsFirstModeEnabledStrict"
                  name="[[getName_(httpsFirstModeSettingEnum_.ENABLED_FULL)]]"
                  pref="[[prefs.generated.https_first_mode_enabled]]"
                  label="$i18n{httpsFirstModeEnabledStrictLabel}"
                  class="list-item">
                <div class="cr-secondary-text">
                  $i18n{httpsFirstModeEnabledStrictSubLabel}
                </div>
              </controlled-radio-button>
            </settings-radio-group>
          </div>
        </cr-collapse>
      </div>
    </template>
    <div class="cr-row first">
      <h2 class="cr-title-text">$i18n{advancedPageTitle}</h2>
    </div>
    <settings-toggle-button id="passwordsLeakToggle"
          label="$i18n{passwordsLeakDetectionLabel}"
          pref="{{prefs.generated.password_leak_detection}}"
          sub-label="[[getPasswordsLeakToggleSubLabel_(
                        prefs.profile.password_manager_leak_detection.*,
                        prefs.generated.password_leak_detection.*)]]">
    </settings-toggle-button>
    <template is="dom-if" if="[[!enableHttpsFirstModeNewSettings_]]" restamp>
      <settings-toggle-button id="httpsOnlyModeToggle"
          pref="{{prefs.generated.https_first_mode_enabled}}"
          label="$i18n{httpsOnlyModeTitle}"
          sub-label="[[getHttpsFirstModeSubLabel_(
                         prefs.generated.https_first_mode_enabled.*)]]"
          numeric-checked-value="[[httpsFirstModeSettingEnum_.ENABLED_FULL]]">
      </settings-toggle-button>
      <template is="dom-if" if="[[showSecureDnsSetting_]]">
        <settings-secure-dns prefs="{{prefs}}" id="secureDnsSettingOld">
        </settings-secure-dns>
      </template>
    </template>
    <template is="dom-if" if="[[enableHttpsFirstModeNewSettings_]]" restamp>
      <template is="dom-if" if="[[showSecureDnsSetting_]]">
        <settings-secure-dns prefs="{{prefs}}" class="hr"
            id="secureDnsSettingNew">
        </settings-secure-dns>
      </template>
    </template>

    <cr-link-row id="javascriptOptimizerSettingLink" class="hr"
        on-click="onJavascriptOptimizerSettingsClick_"
        label="$i18n{securityJavascriptOptimizerLinkTitle}"
        sub-label="[[javascriptOptimizerSubLabel_]]"
        role-description="$i18n{subpageArrowRoleDescription}">
    </cr-link-row>
    <template is="dom-if" if="[[enableSecurityKeysSubpage_]]">
        <cr-link-row id="securityKeysSubpageTrigger" class="hr"
            label="$i18n{securityKeysTitle}"
            sub-label="$i18n{securityKeysDesc}"
            on-click="onSecurityKeysClick_"
            role-description="$i18n{subpageArrowRoleDescription}">
        </cr-link-row>
    </template>

    <cr-link-row id="manageCertificatesLinkRow" class="hr"
        role-description="$i18n{subpageArrowRoleDescription}"
        label="$i18n{manageCertificates}"
        sub-label="$i18n{manageCertificatesDescription}"
        on-click="onManageCertificatesClick_" external>
    </cr-link-row>

    <cr-link-row id="advancedProtectionProgramLink" class="hr"
        label="$i18n{advancedProtectionProgramTitle}"
        sub-label="$i18n{advancedProtectionProgramDesc}"
        on-click="onAdvancedProtectionProgramLinkClick_"
        external>
    </cr-link-row>
    <template is="dom-if" if="[[showDisableSafebrowsingDialog_]]" restamp>
      <settings-simple-confirmation-dialog
          title-text="$i18n{safeBrowsingDisableDialog}"
          body-text="$i18n{safeBrowsingDisableDialogDesc}"
          confirm-text="$i18n{safeBrowsingDisableDialogConfirm}"
          on-close="onDisableSafebrowsingDialogClose_">
      </settings-simple-confirmation-dialog>
    </template>
  </settings-subpage>
<!--_html_template_end_-->`}
// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var SafeBrowsingSetting;(function(SafeBrowsingSetting){SafeBrowsingSetting[SafeBrowsingSetting["ENHANCED"]=0]="ENHANCED";SafeBrowsingSetting[SafeBrowsingSetting["STANDARD"]=1]="STANDARD";SafeBrowsingSetting[SafeBrowsingSetting["DISABLED"]=2]="DISABLED"})(SafeBrowsingSetting||(SafeBrowsingSetting={}));var HttpsFirstModeSetting;(function(HttpsFirstModeSetting){HttpsFirstModeSetting[HttpsFirstModeSetting["DISABLED"]=0]="DISABLED";HttpsFirstModeSetting[HttpsFirstModeSetting["ENABLED_FULL"]=2]="ENABLED_FULL";HttpsFirstModeSetting[HttpsFirstModeSetting["ENABLED_BALANCED"]=3]="ENABLED_BALANCED"})(HttpsFirstModeSetting||(HttpsFirstModeSetting={}));const SettingsSecurityPageElementBase=HelpBubbleMixin(RouteObserverMixin(SettingsViewMixin(WebUiListenerMixin(I18nMixin(PrefsMixin(PolymerElement))))));class SettingsSecurityPageElement extends SettingsSecurityPageElementBase{static get is(){return"settings-security-page"}static get template(){return getTemplate$5()}static get properties(){return{showSecureDnsSetting_:{type:Boolean,readOnly:true,value:function(){return loadTimeData.getBoolean("showSecureDnsSetting")}},safeBrowsingSettingEnum_:{type:Object,value:SafeBrowsingSetting},httpsFirstModeSettingEnum_:{type:Object,value:HttpsFirstModeSetting},httpsFirstModeUncheckedValues_:{type:Array,value:()=>[HttpsFirstModeSetting.DISABLED]},javascriptOptimizerSubLabel_:{type:String,value:""},enableHttpsFirstModeNewSettings_:{type:Boolean,readOnly:true,value(){return loadTimeData.getBoolean("enableHttpsFirstModeNewSettings")}},enableSecurityKeysSubpage_:{type:Boolean,readOnly:true,value(){return loadTimeData.getBoolean("enableSecurityKeysSubpage")}},enableHashPrefixRealTimeLookups_:{type:Boolean,value(){return loadTimeData.getBoolean("enableHashPrefixRealTimeLookups")}},hideExtendedReportingRadioButton_:{type:Boolean,value(){return loadTimeData.getBoolean("extendedReportingRemovePrefDependency")&&loadTimeData.getBoolean("hashPrefixRealTimeLookupsSamplePing")}},showDisableSafebrowsingDialog_:Boolean,lastFocusTime_:Number,totalTimeInFocus_:{type:Number,value:0},lastInteraction_:{type:SecurityPageInteraction,value:SecurityPageInteraction.NO_INTERACTION},safeBrowsingStateOnOpen_:SafeBrowsingSetting,isRouteSecurity_:{type:Boolean,value:true}}}eventTracker_=new EventTracker;browserProxy_=PrivacyPageBrowserProxyImpl.getInstance();metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();siteBrowserProxy_=SiteSettingsPrefsBrowserProxyImpl.getInstance();ready(){super.ready();CrSettingsPrefs.initialized.then((()=>{const prefValue=this.getPref("generated.safe_browsing").value;if(prefValue===SafeBrowsingSetting.ENHANCED){this.$.safeBrowsingEnhanced.expanded=true}else if(prefValue===SafeBrowsingSetting.STANDARD){this.$.safeBrowsingStandard.expanded=true}this.safeBrowsingStateOnOpen_=prefValue;if(!loadTimeData.getBoolean("enableHttpsFirstModeNewSettings")){assert(this.getPref("generated.https_first_mode_enabled").value!==HttpsFirstModeSetting.ENABLED_BALANCED)}}));this.registerHelpBubble("kEnhancedProtectionSettingElementId",this.$.safeBrowsingEnhanced.getBubbleAnchor(),{anchorPaddingTop:10});this.lastFocusTime_=HatsBrowserProxyImpl.getInstance().now();this.addWebUiListener("contentSettingCategoryChanged",(category=>{if(category===ContentSettingsTypes.JAVASCRIPT_OPTIMIZER){this.updateJavascriptOptimizerEnabledByDefault_()}}));this.updateJavascriptOptimizerEnabledByDefault_()}currentRouteChanged(route,oldRoute){super.currentRouteChanged(route,oldRoute);if(route!==routes.SECURITY){this.onBeforeUnload_();this.isRouteSecurity_=false;this.eventTracker_.removeAll();return}this.metricsBrowserProxy_.recordSafeBrowsingInteractionHistogram(SafeBrowsingInteractions.SAFE_BROWSING_SHOWED);const queryParams=Router.getInstance().getQueryParameters();const section=queryParams.get("q");if(section==="enhanced"){this.$.safeBrowsingEnhanced.expanded=false;this.$.safeBrowsingStandard.expanded=false}this.eventTracker_.add(window,"focus",this.onFocus_.bind(this));this.eventTracker_.add(window,"blur",this.onBlur_.bind(this));this.eventTracker_.add(window,"beforeunload",this.onBeforeUnload_.bind(this));this.isRouteSecurity_=true;this.lastInteraction_=SecurityPageInteraction.NO_INTERACTION;this.totalTimeInFocus_=0;this.lastFocusTime_=HatsBrowserProxyImpl.getInstance().now()}onBlur_(){if(!this.isRouteSecurity_){return}const timeSinceLastFocus=HatsBrowserProxyImpl.getInstance().now()-this.lastFocusTime_;this.totalTimeInFocus_+=timeSinceLastFocus;this.lastFocusTime_=undefined}onFocus_(){this.lastFocusTime_=HatsBrowserProxyImpl.getInstance().now()}onBeforeUnload_(){if(!this.isRouteSecurity_){return}if(this.lastFocusTime_!==undefined){this.totalTimeInFocus_+=HatsBrowserProxyImpl.getInstance().now()-this.lastFocusTime_}HatsBrowserProxyImpl.getInstance().securityPageHatsRequest(this.lastInteraction_,this.safeBrowsingStateOnOpen_,this.totalTimeInFocus_)}updateCollapsedButtons_(){this.$.safeBrowsingEnhanced.updateCollapsed();this.$.safeBrowsingStandard.updateCollapsed()}async updateJavascriptOptimizerEnabledByDefault_(){const defaultValue=await this.siteBrowserProxy_.getDefaultValueForContentType(ContentSettingsTypes.JAVASCRIPT_OPTIMIZER);this.javascriptOptimizerSubLabel_=this.i18n(isSettingEnabled(defaultValue.setting)?"securityJavascriptOptimizerLinkRowLabelEnabled":"securityJavascriptOptimizerLinkRowLabelDisabled")}onSafeBrowsingRadioChange_(){const selected=Number.parseInt(this.$.safeBrowsingRadioGroup.selected||"",10);const prefValue=this.getPref("generated.safe_browsing").value;if(prefValue!==selected){this.recordInteractionHistogramOnRadioChange_(selected);this.recordActionOnRadioChange_(selected);this.interactedWithPage_(selected)}if(selected===SafeBrowsingSetting.DISABLED){this.showDisableSafebrowsingDialog_=true}else{this.updateCollapsedButtons_();this.$.safeBrowsingRadioGroup.sendPrefChange()}}interactedWithPage_(securityPageInteraction){this.lastInteraction_=securityPageInteraction}getDisabledExtendedSafeBrowsing_(){return this.getPref("generated.safe_browsing").value!==SafeBrowsingSetting.STANDARD}getSafeBrowsingStandardSubLabel_(){return this.i18n(this.enableHashPrefixRealTimeLookups_?"safeBrowsingStandardDescProxy":"safeBrowsingStandardDesc")}getPasswordsLeakToggleSubLabel_(){let subLabel=this.i18n("passwordsLeakDetectionGeneralDescription");if(this.prefs!==undefined){const generatedPref=this.getPref("generated.password_leak_detection");if(this.getPref("profile.password_manager_leak_detection").value&&!generatedPref.value&&generatedPref.userControlDisabled){subLabel+=" "+this.i18n("passwordsLeakDetectionSignedOutEnabledDescription")}}return subLabel}getName_(value){return value.toString()}getHttpsFirstModeSubLabel_(){const generatedPref=this.getPref("generated.https_first_mode_enabled");if(this.enableHttpsFirstModeNewSettings_){return this.i18n(generatedPref.userControlDisabled?"httpsFirstModeDescriptionAdvancedProtection":"httpsFirstModeSectionDescription")}else{return this.i18n(generatedPref.userControlDisabled?"httpsOnlyModeDescriptionAdvancedProtection":"httpsOnlyModeDescription")}}isHttpsFirstModeExpanded_(value){const generatedPref=this.getPref("generated.https_first_mode_enabled");if(generatedPref.userControlDisabled){return false}return value!==HttpsFirstModeSetting.DISABLED}onManageCertificatesClick_(){this.metricsBrowserProxy_.recordSettingsPageHistogram(PrivacyElementInteractions.MANAGE_CERTIFICATES);OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("certManagementV2URL"))}onAdvancedProtectionProgramLinkClick_(){window.open(loadTimeData.getString("advancedProtectionURL"))}onJavascriptOptimizerSettingsClick_(){Router.getInstance().navigateTo(routes.SITE_SETTINGS_JAVASCRIPT_OPTIMIZER)}onSecurityKeysClick_(){Router.getInstance().navigateTo(routes.SECURITY_KEYS)}onEnhancedProtectionLearnMoreClick_(e){OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("enhancedProtectionHelpCenterURL"));e.preventDefault()}onSafeBrowsingExtendedReportingChange_(){this.metricsBrowserProxy_.recordSettingsPageHistogram(PrivacyElementInteractions.IMPROVE_SECURITY)}onDisableSafebrowsingDialogClose_(){const dialog=this.shadowRoot.querySelector("settings-simple-confirmation-dialog");assert(dialog);const confirmed=dialog.wasConfirmed();this.recordInteractionHistogramOnSafeBrowsingDialogClose_(confirmed);this.recordActionOnSafeBrowsingDialogClose_(confirmed);if(confirmed){this.$.safeBrowsingRadioGroup.sendPrefChange();this.updateCollapsedButtons_()}else{this.$.safeBrowsingRadioGroup.resetToPrefValue()}this.showDisableSafebrowsingDialog_=false;focusWithoutInk(this.$.safeBrowsingDisabled)}onEnhancedProtectionExpandButtonClicked_(){this.recordInteractionHistogramOnExpandButtonClicked_(SafeBrowsingSetting.ENHANCED);this.recordActionOnExpandButtonClicked_(SafeBrowsingSetting.ENHANCED);this.interactedWithPage_(SecurityPageInteraction.EXPAND_BUTTON_ENHANCED_CLICK)}onStandardProtectionExpandButtonClicked_(){this.recordInteractionHistogramOnExpandButtonClicked_(SafeBrowsingSetting.STANDARD);this.recordActionOnExpandButtonClicked_(SafeBrowsingSetting.STANDARD);this.interactedWithPage_(SecurityPageInteraction.EXPAND_BUTTON_STANDARD_CLICK)}recordInteractionHistogramOnRadioChange_(safeBrowsingSetting){let action;if(safeBrowsingSetting===SafeBrowsingSetting.ENHANCED){action=SafeBrowsingInteractions.SAFE_BROWSING_ENHANCED_PROTECTION_CLICKED}else if(safeBrowsingSetting===SafeBrowsingSetting.STANDARD){action=SafeBrowsingInteractions.SAFE_BROWSING_STANDARD_PROTECTION_CLICKED}else{action=SafeBrowsingInteractions.SAFE_BROWSING_DISABLE_SAFE_BROWSING_CLICKED}this.metricsBrowserProxy_.recordSafeBrowsingInteractionHistogram(action)}recordInteractionHistogramOnExpandButtonClicked_(safeBrowsingSetting){this.metricsBrowserProxy_.recordSafeBrowsingInteractionHistogram(safeBrowsingSetting===SafeBrowsingSetting.ENHANCED?SafeBrowsingInteractions.SAFE_BROWSING_ENHANCED_PROTECTION_EXPAND_ARROW_CLICKED:SafeBrowsingInteractions.SAFE_BROWSING_STANDARD_PROTECTION_EXPAND_ARROW_CLICKED)}recordInteractionHistogramOnSafeBrowsingDialogClose_(confirmed){this.metricsBrowserProxy_.recordSafeBrowsingInteractionHistogram(confirmed?SafeBrowsingInteractions.SAFE_BROWSING_DISABLE_SAFE_BROWSING_DIALOG_CONFIRMED:SafeBrowsingInteractions.SAFE_BROWSING_DISABLE_SAFE_BROWSING_DIALOG_DENIED)}recordActionOnRadioChange_(safeBrowsingSetting){let actionName;if(safeBrowsingSetting===SafeBrowsingSetting.ENHANCED){actionName="SafeBrowsing.Settings.EnhancedProtectionClicked"}else if(safeBrowsingSetting===SafeBrowsingSetting.STANDARD){actionName="SafeBrowsing.Settings.StandardProtectionClicked"}else{actionName="SafeBrowsing.Settings.DisableSafeBrowsingClicked"}this.metricsBrowserProxy_.recordAction(actionName)}recordActionOnExpandButtonClicked_(safeBrowsingSetting){this.metricsBrowserProxy_.recordAction(safeBrowsingSetting===SafeBrowsingSetting.ENHANCED?"SafeBrowsing.Settings.EnhancedProtectionExpandArrowClicked":"SafeBrowsing.Settings.StandardProtectionExpandArrowClicked")}recordActionOnSafeBrowsingDialogClose_(confirmed){this.metricsBrowserProxy_.recordAction(confirmed?"SafeBrowsing.Settings.DisableSafeBrowsingDialogConfirmed":"SafeBrowsing.Settings.DisableSafeBrowsingDialogDenied")}getFocusConfig(){const map=new Map([[routes.SITE_SETTINGS_JAVASCRIPT_OPTIMIZER.path,"#javascriptOptimizerSettingLink"]]);if(routes.SECURITY_KEYS){map.set(routes.SECURITY_KEYS.path,"#securityKeysSubpageTrigger")}return map}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsSecurityPageElement.is,SettingsSecurityPageElement);function getTemplate$4(){return html$1`<!--_html_template_start_--><style include="privacy-guide-fragment-shared"></style>
<div class="settings-fragment-header" focus-element tabindex="-1">
  <picture>
    <source
        srcset="./images/privacy_guide/safe_browsing_graphic_dark_v2.svg"
        media="(prefers-color-scheme: dark)">
    <img alt="" src="./images/privacy_guide/safe_browsing_graphic_v2.svg">
  </picture>
  <h2 class="settings-fragment-header-label">
    $i18n{privacyGuideSafeBrowsingCardHeader}
  </h2>
</div>
<div class="fragment-content">
  <settings-radio-group id="safeBrowsingRadioGroup"
      pref="{{prefs.generated.safe_browsing}}"
      selectable-elements="settings-collapse-radio-button">
    <settings-collapse-radio-button id="safeBrowsingRadioEnhanced"
        pref="[[prefs.generated.safe_browsing]]"
        name="[[safeBrowsingSettingEnum_.ENHANCED]]"
        label="$i18n{safeBrowsingEnhanced}"
        sub-label="$i18n{safeBrowsingEnhancedDescUpdated}"
        expand-aria-label="$i18n{safeBrowsingEnhancedExpandA11yLabel}"
        on-click="onSafeBrowsingEnhancedClick_">
          <div slot="collapse" class="settings-columned-section">
            <div class="column">
              <h3 class="description-header">
                $i18n{columnHeadingWhenOn}
              </h3>
              <ul id="updatedDescItemContainer" class="icon-bulleted-list">
                <li>
                  <cr-icon icon="settings20:data" aria-hidden="true">
                  </cr-icon>
                  <div class="secondary">
                    $i18n{safeBrowsingEnhancedWhenOnBulOne}
                  </div>
                </li>
                <li>
                  <cr-icon icon="settings20:download" aria-hidden="true">
                  </cr-icon>
                  <div class="secondary">
                    $i18n{safeBrowsingEnhancedWhenOnBulTwo}
                  </div>
                </li>
                <li>
                  <cr-icon icon="settings20:gshield" aria-hidden="true">
                  </cr-icon>
                  <div class="secondary">
                    $i18n{safeBrowsingEnhancedWhenOnBulThree}
                  </div>
                </li>
                <li>
                  <cr-icon icon="settings:language" aria-hidden="true">
                  </cr-icon>
                  <div class="secondary">
                    $i18n{safeBrowsingEnhancedWhenOnBulFour}
                  </div>
                </li>
              </ul>
            </div>
            <div class="column">
              <h3 class="description-header">
                $i18n{columnHeadingConsider}
              </h3>
              <ul class="icon-bulleted-list">
                <li>
                  <cr-icon icon="settings20:link" aria-hidden="true">
                  </cr-icon>
                  <div class="secondary">
                    $i18n{safeBrowsingEnhancedThingsToConsiderBulOne}
                  </div>
                </li>
                <li>
                  <cr-icon icon="settings20:account-circle" aria-hidden="true">
                  </cr-icon>
                  <div class="secondary">
                    $i18n{safeBrowsingEnhancedThingsToConsiderBulTwo}
                  </div>
                </li>
                <li>
                  <cr-icon icon="settings:performance" aria-hidden="true">
                  </cr-icon>
                  <div class="secondary">
                    $i18n{safeBrowsingEnhancedThingsToConsiderBulThree}
                  </div>
                </li>
              </ul>
            </div>
          </div>
    </settings-collapse-radio-button>
    <settings-collapse-radio-button id="safeBrowsingRadioStandard"
        no-collapse
        pref="[[prefs.generated.safe_browsing]]"
        name="[[safeBrowsingSettingEnum_.STANDARD]]"
        label="$i18n{safeBrowsingStandard}"
        sub-label="[[getSafeBrowsingStandardSubLabel_(
                    enableHashPrefixRealTimeLookups_)]]"
        expand-aria-label="$i18n{safeBrowsingStandardExpandA11yLabel}"
        on-click="onSafeBrowsingStandardClick_">
    </settings-collapse-radio-button>
  </settings-radio-group>
</div>
<!--_html_template_end_-->`}
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrivacyGuideSafeBrowsingFragmentBase=I18nMixin(PrefsMixin(PolymerElement));class PrivacyGuideSafeBrowsingFragmentElement extends PrivacyGuideSafeBrowsingFragmentBase{static get is(){return"privacy-guide-safe-browsing-fragment"}static get template(){return getTemplate$4()}static get properties(){return{safeBrowsingSettingEnum_:{type:Object,value:SafeBrowsingSetting},enableHashPrefixRealTimeLookups_:{type:Boolean,value(){return loadTimeData.getBoolean("enableHashPrefixRealTimeLookups")}}}}metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();startStateEnhanced_;ready(){super.ready();this.addEventListener("view-enter-start",this.onViewEnterStart_);this.addEventListener("view-exit-finish",this.onViewExitFinish_)}focus(){this.shadowRoot.querySelector("[focus-element]").focus()}onViewEnterStart_(){this.startStateEnhanced_=this.getPref("generated.safe_browsing").value===SafeBrowsingSetting.ENHANCED;this.metricsBrowserProxy_.recordPrivacyGuideStepsEligibleAndReachedHistogram(PrivacyGuideStepsEligibleAndReached.SAFE_BROWSING_REACHED)}onViewExitFinish_(){const endStateEnhanced=this.getPref("generated.safe_browsing").value===SafeBrowsingSetting.ENHANCED;let state=null;if(this.startStateEnhanced_){state=endStateEnhanced?PrivacyGuideSettingsStates.SAFE_BROWSING_ENHANCED_TO_ENHANCED:PrivacyGuideSettingsStates.SAFE_BROWSING_ENHANCED_TO_STANDARD}else{state=endStateEnhanced?PrivacyGuideSettingsStates.SAFE_BROWSING_STANDARD_TO_ENHANCED:PrivacyGuideSettingsStates.SAFE_BROWSING_STANDARD_TO_STANDARD}this.metricsBrowserProxy_.recordPrivacyGuideSettingsStatesHistogram(state)}onSafeBrowsingEnhancedClick_(){this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.ChangeSafeBrowsingEnhanced")}onSafeBrowsingStandardClick_(){this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.ChangeSafeBrowsingStandard")}getSafeBrowsingStandardSubLabel_(){return this.i18n(this.enableHashPrefixRealTimeLookups_?"safeBrowsingStandardDescProxy":"safeBrowsingStandardDesc")}getStandardProtectionFeatureDescription2_(){return this.i18n(this.enableHashPrefixRealTimeLookups_?"privacyGuideSafeBrowsingCardStandardProtectionFeatureDescription2Proxy":"privacyGuideSafeBrowsingCardStandardProtectionFeatureDescription2")}getStandardProtectionPrivacyDescription1_(){return this.i18n(this.enableHashPrefixRealTimeLookups_?"privacyGuideSafeBrowsingCardStandardProtectionPrivacyDescription1Proxy":"privacyGuideSafeBrowsingCardStandardProtectionPrivacyDescription1")}}customElements.define(PrivacyGuideSafeBrowsingFragmentElement.is,PrivacyGuideSafeBrowsingFragmentElement);function getTemplate$3(){return html$1`<!--_html_template_start_--><style include="privacy-guide-fragment-shared">:host{display:flex;flex-flow:column;min-height:calc(432px - var(--privacy-guide-footer-total-height))}.welcome-completion-header{padding:48px 116px var(--cr-section-padding) 116px;row-gap:12px}.footer{align-items:center;animation:fade-in var(--privacy-guide-animation-duration);bottom:calc(-1 * var(--privacy-guide-footer-total-height));display:flex;justify-content:flex-end;padding-bottom:var(--privacy-guide-footer-vertical-padding);position:absolute;width:calc(100% - 48px)}</style>
<div class="welcome-completion-header">
  <picture>
    <source
        srcset="./images/privacy_guide/welcome_banner_dark.svg"
        media="(prefers-color-scheme: dark)">
    <img alt="" src="./images/privacy_guide/welcome_banner.svg">
  </picture>
  <h2 class="welcome-completion-header-label" tabindex="-1">
    $i18n{privacyGuideWelcomeCardHeader}
  </h2>
  <div class="cr-secondary-text">$i18n{privacyGuideWelcomeCardSubHeader}</div>
</div>
<div class="footer">
  <cr-button class="action-button" id="startButton"
      on-click="onStartButtonClick_">
    $i18n{privacyGuideNextButton}
  </cr-button>
</div>
<!--_html_template_end_-->`}
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class PrivacyGuideWelcomeFragmentElement extends PolymerElement{static get is(){return"privacy-guide-welcome-fragment"}static get template(){return getTemplate$3()}focus(){const header=this.shadowRoot.querySelector(".welcome-completion-header-label");assert(header);header.focus()}onStartButtonClick_(e){e.stopPropagation();this.dispatchEvent(new CustomEvent("start-button-click",{bubbles:true,composed:true}))}}customElements.define(PrivacyGuideWelcomeFragmentElement.is,PrivacyGuideWelcomeFragmentElement);function getTemplate$2(){return html$1`<!--_html_template_start_--><style include="cr-shared-style">:host{align-items:center;display:flex}span{background:var(--google-grey-200);border-radius:50%;display:inline-block;height:8px;margin:0 4px;width:8px}span.active{background:var(--google-blue-600)}.screen-reader-only{clip:rect(0,0,0,0);position:fixed}@media (prefers-color-scheme:dark){span{background:var(--google-grey-500)}span.active{background:var(--google-blue-300)}}</style>
<template is="dom-repeat" items="[[dots_]]">
  <span class$="[[getActiveClass_(index, model.active)]]"></span>
</template>
<div class="screen-reader-only">
  [[computeA11yLabel_(model.active, model.total)]]
</div>
<!--_html_template_end_-->`}
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const StepIndicatorBase=I18nMixin(PolymerElement);class StepIndicator extends StepIndicatorBase{static get is(){return"step-indicator"}static get properties(){return{model:Object,dots_:{type:Array,computed:"computeDots_(model.total)"}}}computeA11yLabel_(){return this.i18n("privacyGuideSteps",this.model.active+1,this.model.total)}computeDots_(){return new Array(this.model.total>1?this.model.total:0)}getActiveClass_(index){return index===this.model.active?"active":""}static get template(){return getTemplate$2()}}customElements.define(StepIndicator.is,StepIndicator);
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrivacyGuideAvailabilityMixin=dedupingMixin((superClass=>{const superClassBase=WebUiListenerMixin(superClass);class PrivacyGuideAvailabilityMixinInternal extends superClassBase{static get properties(){return{isPrivacyGuideAvailable:{type:Boolean,value:()=>loadTimeData.getBoolean("showPrivacyGuide")}}}connectedCallback(){super.connectedCallback();this.addWebUiListener("is-managed-changed",(isManaged=>this.onPrivacyGuideAvailabilityChanged_(!isManaged)));this.addWebUiListener("sync-status-changed",(syncStatus=>this.onPrivacyGuideAvailabilityChanged_(!syncStatus.supervisedUser)))}onPrivacyGuideAvailabilityChanged_(isAvailable){this.isPrivacyGuideAvailable=this.isPrivacyGuideAvailable&&isAvailable}}return PrivacyGuideAvailabilityMixinInternal}));
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const MAX_PRIVACY_GUIDE_PROMO_IMPRESSION=10;const PRIVACY_GUIDE_PROMO_IMPRESSION_COUNT_KEY="privacy-guide-promo-count";class PrivacyGuideBrowserProxyImpl{getPromoImpressionCount(){return parseInt(window.localStorage.getItem(PRIVACY_GUIDE_PROMO_IMPRESSION_COUNT_KEY),10)||0}incrementPromoImpressionCount(){window.localStorage.setItem(PRIVACY_GUIDE_PROMO_IMPRESSION_COUNT_KEY,(this.getPromoImpressionCount()+1).toString())}privacySandboxPrivacyGuideShouldShowAdTopicsCard(){return sendWithPromise("privacySandboxPrivacyGuideShouldShowAdTopicsCard")}static getInstance(){return instance$3||(instance$3=new PrivacyGuideBrowserProxyImpl)}static setInstance(obj){instance$3=obj}}let instance$3=null;function getTemplate$1(){return html$1`<!--_html_template_start_--><style include="cr-shared-style settings-shared">:host{--privacy-guide-animation-duration:900ms;--privacy-guide-footer-vertical-padding:16px;--privacy-guide-footer-total-height:calc(var(--cr-button-height) + 2 * var(--privacy-guide-footer-vertical-padding))}.footer{align-items:center;bottom:0;box-sizing:border-box;display:flex;justify-content:space-between;padding:var(--privacy-guide-footer-vertical-padding) 24px;position:absolute;width:100%}.managed-fragment{bottom:initial;grid-column-start:1;grid-row-start:1;left:initial;position:unset;right:initial;top:initial}#viewManager{position:relative}#viewManager>:not(.active){left:0;position:absolute;top:0}.visibility-hidden{visibility:hidden}#privacyGuideCard{background-color:var(--cr-card-background-color);border-radius:var(--cr-card-border-radius);box-shadow:var(--cr-card-shadow);box-sizing:border-box;display:flex;flex-flow:column;min-height:432px;padding-bottom:var(--privacy-guide-footer-total-height);position:relative}@keyframes fade-in{0%{opacity:0}100%{opacity:1}}#background{animation:fade-in var(--privacy-guide-animation-duration);height:100px;left:50%;position:absolute;top:24px;transform:translateX(-50%);width:360px}#background picture{display:block;height:100%;left:0;position:absolute;top:0;width:100%}#backgroundClouds{transform:translateX(calc(var(--privacy-guide-step) * -4px));transition:transform 300ms cubic-bezier(.4,0,.2,1)}:host-context([dir='rtl']) #backgroundClouds{transform:translateX(calc(var(--privacy-guide-step) * 4px))}#backgroundHills{transform:translateX(calc(var(--privacy-guide-step) * -2px));transition:transform 300ms cubic-bezier(.4,0,.2,1)}:host-context([dir='rtl']) #backgroundHills{transform:translateX(calc(var(--privacy-guide-step) * 2px))}</style>
<div id="privacyGuideCard" on-keydown="onKeyDown_" part="privacyGuideCard"
    style="--privacy-guide-translate-multiplier: [[translateMultiplier_]]">
  <div id="background" aria-hidden="true"
      hidden$="[[!showAnySettingFragment_(privacyGuideStep_)]]"
      style="--privacy-guide-step: [[stepIndicatorModel_.active]]">
    <picture id="backgroundClouds">
      <source
          srcset="./images/privacy_guide/clouds_graphic_dark.svg"
          media="(prefers-color-scheme: dark)">
      <img alt="" src="./images/privacy_guide/clouds_graphic.svg">
    </picture>
    <picture id="backgroundHills">
      <source
          srcset="./images/privacy_guide/hills_graphic_dark.svg"
          media="(prefers-color-scheme: dark)">
      <img alt="" src="./images/privacy_guide/hills_graphic.svg">
    </picture>
    <picture>
      <source
          srcset="./images/privacy_guide/horizon_graphic_dark.svg"
          media="(prefers-color-scheme: dark)">
      <img alt="" src="./images/privacy_guide/horizon_graphic.svg">
    </picture>
  </div>
  <cr-view-manager id="viewManager">
    <privacy-guide-welcome-fragment id="[[privacyGuideStepEnum_.WELCOME]]"
        class="managed-fragment" on-start-button-click="onNextButtonClick_"
        slot="view">
    </privacy-guide-welcome-fragment>
    <privacy-guide-msbb-fragment id="[[privacyGuideStepEnum_.MSBB]]"
        class="managed-fragment" prefs="{{prefs}}" slot="view">
    </privacy-guide-msbb-fragment>
    <privacy-guide-history-sync-fragment
        id="[[privacyGuideStepEnum_.HISTORY_SYNC]]" class="managed-fragment"
        slot="view">
    </privacy-guide-history-sync-fragment>
    <privacy-guide-cookies-fragment id="[[privacyGuideStepEnum_.COOKIES]]"
        class="managed-fragment" prefs="{{prefs}}" slot="view">
    </privacy-guide-cookies-fragment>
    <privacy-guide-safe-browsing-fragment
        id="[[privacyGuideStepEnum_.SAFE_BROWSING]]" class="managed-fragment"
        prefs="{{prefs}}" slot="view">
    </privacy-guide-safe-browsing-fragment>
    <privacy-guide-ad-topics-fragment
        id="[[privacyGuideStepEnum_.AD_TOPICS]]" class="managed-fragment"
        prefs="{{prefs}}" slot="view">
    </privacy-guide-ad-topics-fragment>
    <privacy-guide-completion-fragment
        id="[[privacyGuideStepEnum_.COMPLETION]]" class="managed-fragment"
        on-back-button-click="onBackButtonClick_" slot="view">
    </privacy-guide-completion-fragment>
  </cr-view-manager>
  <template is="dom-if" if="[[showAnySettingFragment_(privacyGuideStep_)]]">
    <div id="settingFooter" class="footer hr">
      <cr-button id="backButton" role="button" on-click="onBackButtonClick_"
          class$="[[computeBackButtonClass_(privacyGuideStep_)]]">
        $i18n{privacyGuideBackButton}
      </cr-button>
      <step-indicator model="[[stepIndicatorModel_]]"></step-indicator>
      <cr-button class="action-button" id="nextButton" role="button"
          tabindex="0" on-click="onNextButtonClick_">
        $i18n{privacyGuideNextButton}
      </cr-button>
    </div>
  </template>
</div>
<!--_html_template_end_-->`}
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function eligibilityToRecord(step){switch(step){case PrivacyGuideStep.MSBB:return PrivacyGuideStepsEligibleAndReached.MSBB_ELIGIBLE;case PrivacyGuideStep.HISTORY_SYNC:return PrivacyGuideStepsEligibleAndReached.HISTORY_SYNC_ELIGIBLE;case PrivacyGuideStep.COOKIES:return PrivacyGuideStepsEligibleAndReached.COOKIES_ELIGIBLE;case PrivacyGuideStep.SAFE_BROWSING:return PrivacyGuideStepsEligibleAndReached.SAFE_BROWSING_ELIGIBLE;case PrivacyGuideStep.AD_TOPICS:return PrivacyGuideStepsEligibleAndReached.AD_TOPICS_ELIGIBLE;case PrivacyGuideStep.COMPLETION:return PrivacyGuideStepsEligibleAndReached.COMPLETION_ELIGIBLE;default:assertNotReached()}}const PrivacyGuideBase=RouteObserverMixin(PrivacyGuideAvailabilityMixin(WebUiListenerMixin(I18nMixin(PrefsMixin(PolymerElement)))));class SettingsPrivacyGuidePageElement extends PrivacyGuideBase{static get is(){return"settings-privacy-guide-page"}static get template(){return getTemplate$1()}static get properties(){return{privacyGuideStepEnum_:{type:Object,value:PrivacyGuideStep},privacyGuideStep_:{type:String,value:undefined},translateMultiplier_:{type:Number,value:1},stepIndicatorModel_:{type:Object,computed:"computeStepIndicatorModel(privacyGuideStep_, prefs.generated.cookie_default_content_setting, prefs.generated.safe_browsing, prefs.generated.third_party_cookie_blocking_setting, prefs.net.network_prediction_options)"},shouldShowAdTopicsCard_:{type:Boolean,value:false},syncStatus_:Object}}static get observers(){return["onPrefsChanged_(prefs.generated.cookie_default_content_setting, prefs.generated.safe_browsing, prefs.generated.third_party_cookie_blocking_setting, prefs.net.network_prediction_options)","exitIfNecessary(isPrivacyGuideAvailable)"]}privacyGuideStepToComponentsMap_;syncBrowserProxy_=SyncBrowserProxyImpl.getInstance();animationsEnabled_=true;metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();privacyGuideBrowserProxy_=PrivacyGuideBrowserProxyImpl.getInstance();constructor(){super();this.privacyGuideStepToComponentsMap_=this.computePrivacyGuideStepToComponentsMap_()}ready(){super.ready();this.addWebUiListener("sync-status-changed",(syncStatus=>this.onSyncStatusChanged_(syncStatus)));this.syncBrowserProxy_.getSyncStatus().then((syncStatus=>this.onSyncStatusChanged_(syncStatus)));this.privacyGuideBrowserProxy_.privacySandboxPrivacyGuideShouldShowAdTopicsCard().then((state=>{this.shouldShowAdTopicsCard_=state}))}disableAnimationsForTesting(){this.animationsEnabled_=false}currentRouteChanged(newRoute){if(newRoute!==routes.PRIVACY_GUIDE||this.exitIfNecessary()){return}this.updateStateFromQueryParameters_()}computePrivacyGuideStepToComponentsMap_(){return new Map([[PrivacyGuideStep.WELCOME,{nextStep:PrivacyGuideStep.MSBB,isAvailable:()=>true,recordForwardNavigationMetrics:()=>{this.metricsBrowserProxy_.recordPrivacyGuideNextNavigationHistogram(PrivacyGuideInteractions.WELCOME_NEXT_BUTTON);this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.NextClickWelcome");this.metricsBrowserProxy_.recordPrivacyGuideFlowLengthHistogram(this.computeStepIndicatorModel().total);this.recordEligibleSteps_()}}],[PrivacyGuideStep.MSBB,{nextStep:PrivacyGuideStep.HISTORY_SYNC,previousStep:PrivacyGuideStep.WELCOME,recordForwardNavigationMetrics:()=>{this.metricsBrowserProxy_.recordPrivacyGuideNextNavigationHistogram(PrivacyGuideInteractions.MSBB_NEXT_BUTTON);this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.NextClickMSBB")},recordBackwardNavigationMetrics:()=>{this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.BackClickMSBB")},isAvailable:()=>true}],[PrivacyGuideStep.HISTORY_SYNC,{nextStep:PrivacyGuideStep.SAFE_BROWSING,previousStep:PrivacyGuideStep.MSBB,recordForwardNavigationMetrics:()=>{this.metricsBrowserProxy_.recordPrivacyGuideNextNavigationHistogram(PrivacyGuideInteractions.HISTORY_SYNC_NEXT_BUTTON);this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.NextClickHistorySync")},recordBackwardNavigationMetrics:()=>{this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.BackClickHistorySync")},isAvailable:()=>!this.syncStatus_||this.shouldShowHistorySyncCard_()}],[PrivacyGuideStep.SAFE_BROWSING,{nextStep:PrivacyGuideStep.COOKIES,previousStep:PrivacyGuideStep.HISTORY_SYNC,recordForwardNavigationMetrics:()=>{this.metricsBrowserProxy_.recordPrivacyGuideNextNavigationHistogram(PrivacyGuideInteractions.SAFE_BROWSING_NEXT_BUTTON);this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.NextClickSafeBrowsing")},recordBackwardNavigationMetrics:()=>{this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.BackClickSafeBrowsing")},isAvailable:()=>this.shouldShowSafeBrowsingCard_()}],[PrivacyGuideStep.COOKIES,{nextStep:PrivacyGuideStep.AD_TOPICS,recordForwardNavigationMetrics:()=>{this.metricsBrowserProxy_.recordPrivacyGuideNextNavigationHistogram(PrivacyGuideInteractions.COOKIES_NEXT_BUTTON);this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.NextClickCookies")},recordBackwardNavigationMetrics:()=>{this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.BackClickCookies")},previousStep:PrivacyGuideStep.SAFE_BROWSING,isAvailable:()=>this.shouldShowCookiesCard_()}],[PrivacyGuideStep.AD_TOPICS,{nextStep:PrivacyGuideStep.COMPLETION,recordForwardNavigationMetrics:()=>{this.metricsBrowserProxy_.recordPrivacyGuideNextNavigationHistogram(PrivacyGuideInteractions.AD_TOPICS_NEXT_BUTTON);this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.NextClickAdTopics")},recordBackwardNavigationMetrics:()=>{this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.BackClickAdTopics")},previousStep:PrivacyGuideStep.COOKIES,isAvailable:()=>this.shouldShowAdTopicsCard_}],[PrivacyGuideStep.COMPLETION,{recordBackwardNavigationMetrics:()=>{this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.BackClickCompletion")},previousStep:PrivacyGuideStep.AD_TOPICS,isAvailable:()=>true}]])}exitIfNecessary(){if(!this.isPrivacyGuideAvailable){Router.getInstance().navigateTo(routes.PRIVACY);return true}return false}onSyncStatusChanged_(syncStatus){this.syncStatus_=syncStatus;this.navigateForwardIfCurrentCardNoLongerAvailable()}onPrefsChanged_(){this.navigateForwardIfCurrentCardNoLongerAvailable()}navigateForwardIfCurrentCardNoLongerAvailable(){if(!this.privacyGuideStep_){return}if(!this.privacyGuideStepToComponentsMap_.get(this.privacyGuideStep_).isAvailable()){this.navigateForward_()}}async updateStateFromQueryParameters_(){assert(Router.getInstance().getCurrentRoute()===routes.PRIVACY_GUIDE);await CrSettingsPrefs.initialized;this.setPrefValue("privacy_guide.viewed",true);const step=Router.getInstance().getQueryParameters().get("step");if(this.privacyGuideStep_&&step===this.privacyGuideStep_){return}if(Object.values(PrivacyGuideStep).includes(step)){this.navigateToCard_(step,false,true)}else{this.navigateToCard_(PrivacyGuideStep.WELCOME,false,true)}}onNextButtonClick_(){this.navigateForward_()}recordEligibleSteps_(){for(const key in PrivacyGuideStep){const step=PrivacyGuideStep[key];if(step===PrivacyGuideStep.WELCOME){continue}const component=this.privacyGuideStepToComponentsMap_.get(step);assert(component);if(!component.isAvailable()){continue}this.metricsBrowserProxy_.recordPrivacyGuideStepsEligibleAndReachedHistogram(eligibilityToRecord(step))}}navigateForward_(){const components=this.privacyGuideStepToComponentsMap_.get(this.privacyGuideStep_);if(components.isAvailable()&&components.recordForwardNavigationMetrics){components.recordForwardNavigationMetrics()}if(components.nextStep){this.navigateToCard_(components.nextStep,false,false)}}onBackButtonClick_(){this.navigateBackward_()}navigateBackward_(){const components=this.privacyGuideStepToComponentsMap_.get(this.privacyGuideStep_);if(components.isAvailable()&&components.recordBackwardNavigationMetrics){components.recordBackwardNavigationMetrics()}if(components.previousStep){this.navigateToCard_(components.previousStep,true,false)}}navigateToCard_(step,isBackwardNavigation,isFirstNavigation){assert(step!==this.privacyGuideStep_);this.privacyGuideStep_=step;const animateFromLeftToRight=isBackwardNavigation===(loadTimeData.getString("textdirection")==="ltr");this.translateMultiplier_=animateFromLeftToRight?-1:1;if(!this.privacyGuideStepToComponentsMap_.get(step).isAvailable()){if(isBackwardNavigation){this.navigateBackward_()}else{this.navigateForward_()}}else{if(this.animationsEnabled_){this.$.viewManager.switchView(this.privacyGuideStep_,"no-animation","fade-out")}else{this.$.viewManager.switchView(this.privacyGuideStep_,"no-animation","no-animation")}Router.getInstance().updateRouteParams(new URLSearchParams("step="+step));if(isFirstNavigation){return}const elementToFocus=this.shadowRoot.querySelector("#"+this.privacyGuideStep_);assert(elementToFocus);afterNextRender(this,(()=>elementToFocus.focus()))}}computeBackButtonClass_(){if(!this.privacyGuideStep_){return""}const components=this.privacyGuideStepToComponentsMap_.get(this.privacyGuideStep_);return components.previousStep===undefined?"visibility-hidden":""}computeStepIndicatorModel(){let stepCount=0;let activeIndex=0;for(const step of Object.values(PrivacyGuideStep)){if(step===PrivacyGuideStep.WELCOME||step===PrivacyGuideStep.COMPLETION){continue}if(this.privacyGuideStepToComponentsMap_.get(step).isAvailable()){if(step===this.privacyGuideStep_){activeIndex=stepCount}++stepCount}}return{active:activeIndex,total:stepCount}}shouldShowHistorySyncCard_(){assert(this.syncStatus_);if(this.syncStatus_.hasError){return false}return this.syncStatus_.signedInState===SignedInState.SYNCING||loadTimeData.getBoolean("replaceSyncPromosWithSignInPromos")&&this.syncStatus_.signedInState===SignedInState.SIGNED_IN}shouldShowCookiesCard_(){if(!this.prefs){return true}if(loadTimeData.getBoolean("is3pcdCookieSettingsRedesignEnabled")){return false}return this.getPref("generated.cookie_default_content_setting").value!==ContentSetting.BLOCK}shouldShowSafeBrowsingCard_(){if(!this.prefs){return true}const currentSafeBrowsingSetting=this.getPref("generated.safe_browsing").value;return currentSafeBrowsingSetting===SafeBrowsingSetting.ENHANCED||currentSafeBrowsingSetting===SafeBrowsingSetting.STANDARD}showAnySettingFragment_(){return this.privacyGuideStep_!==PrivacyGuideStep.WELCOME&&this.privacyGuideStep_!==PrivacyGuideStep.COMPLETION}onKeyDown_(event){const isLtr=loadTimeData.getString("textdirection")==="ltr";switch(event.key){case"ArrowLeft":isLtr?this.navigateBackward_():this.navigateForward_();break;case"ArrowRight":isLtr?this.navigateForward_():this.navigateBackward_();break}}}customElements.define(SettingsPrivacyGuidePageElement.is,SettingsPrivacyGuidePageElement);function getTemplate(){return html$1`<!--_html_template_start_--><style include="cr-shared-style settings-shared">#headerLine{margin:8px}#backToSettingsButton{margin-inline-end:10px;margin-inline-start:-10px}#dialog{background-color:var(--cr-card-background-color);border:0;height:100vh;margin:0;max-height:100vh;max-width:100vw;padding:0;width:100vw}#dialog[open]{display:block}settings-privacy-guide-page::part(privacyGuideCard){background-color:transparent;box-shadow:none;margin:auto;max-width:680px;min-width:550px}</style>
<dialog id="dialog" on-cancel="onDialogCancel_" on-close="onDialogClose_"
    aria-label="$i18n{privacyGuideLabel}">
  <div class="cr-row first" id="headerLine" slot="title">
    <cr-icon-button class="icon-arrow-back" id="backToSettingsButton"
        on-click="onSettingsBackClick_"
        aria-label="$i18n{privacyGuideBackToSettingsAriaLabel}"
        aria-roledescription=
        "$i18n{privacyGuideBackToSettingsAriaRoleDescription}">
    </cr-icon-button>
    <h1 class="cr-title-text">$i18n{privacyGuideLabel}</h1>
  </div>
  <settings-privacy-guide-page on-close="onPrivacyGuidePageClose_"
      prefs="{{prefs}}" slot="body">
  </settings-privacy-guide-page>
</dialog>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsPrivacyGuideDialogElement extends PolymerElement{static get is(){return"settings-privacy-guide-dialog"}static get template(){return getTemplate()}static get properties(){return{prefs:{type:Object,notify:true}}}connectedCallback(){super.connectedCallback();this.$.dialog.showModal();const elementToFocus=this.shadowRoot.querySelector("#backToSettingsButton");afterNextRender(this,(()=>elementToFocus.focus()))}onDialogCancel_(e){if(e.target===this.$.dialog){e.preventDefault()}}onDialogClose_(e){if(e.target!==this.$.dialog){return}this.dispatchEvent(new CustomEvent("close",{bubbles:true,composed:true}))}onPrivacyGuidePageClose_(e){e.stopPropagation();this.$.dialog.close()}onSettingsBackClick_(e){e.stopPropagation();this.$.dialog.close()}}customElements.define(SettingsPrivacyGuideDialogElement.is,SettingsPrivacyGuideDialogElement);
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class ResetBrowserProxyImpl{performResetProfileSettings(sendSettings,requestOrigin){return sendWithPromise("performResetProfileSettings",sendSettings,requestOrigin)}onHideResetProfileDialog(){chrome.send("onHideResetProfileDialog")}onHideResetProfileBanner(){chrome.send("onHideResetProfileBanner")}onShowResetProfileDialog(){chrome.send("onShowResetProfileDialog")}showReportedSettings(){sendWithPromise("getReportedSettings").then((function(settings){const output=settings.map((function(entry){return entry.key+": "+entry.value.replace(/\n/g,", ")}));const win=window.open("about:blank");const div=win.document.createElement("div");div.textContent=output.join("\n");div.style.whiteSpace="pre";win.document.body.appendChild(div)}))}getTriggeredResetToolName(){return sendWithPromise("getTriggeredResetToolName")}static getInstance(){return instance$2||(instance$2=new ResetBrowserProxyImpl)}static setInstance(obj){instance$2=obj}}let instance$2=null;
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var SearchEnginesInteractions;(function(SearchEnginesInteractions){SearchEnginesInteractions[SearchEnginesInteractions["ACTIVATE"]=0]="ACTIVATE";SearchEnginesInteractions[SearchEnginesInteractions["DEACTIVATE"]=1]="DEACTIVATE";SearchEnginesInteractions[SearchEnginesInteractions["KEYBOARD_SHORTCUT_TAB"]=2]="KEYBOARD_SHORTCUT_TAB";SearchEnginesInteractions[SearchEnginesInteractions["KEYBOARD_SHORTCUT_SPACE_OR_TAB"]=3]="KEYBOARD_SHORTCUT_SPACE_OR_TAB";SearchEnginesInteractions[SearchEnginesInteractions["COUNT"]=4]="COUNT"})(SearchEnginesInteractions||(SearchEnginesInteractions={}));var ChoiceMadeLocation;(function(ChoiceMadeLocation){ChoiceMadeLocation[ChoiceMadeLocation["SEARCH_SETTINGS"]=0]="SEARCH_SETTINGS";ChoiceMadeLocation[ChoiceMadeLocation["SEARCH_ENGINE_SETTINGS"]=1]="SEARCH_ENGINE_SETTINGS";ChoiceMadeLocation[ChoiceMadeLocation["CHOICE_SCREEN"]=2]="CHOICE_SCREEN";ChoiceMadeLocation[ChoiceMadeLocation["OTHER"]=3]="OTHER"})(ChoiceMadeLocation||(ChoiceMadeLocation={}));class SearchEnginesBrowserProxyImpl{setDefaultSearchEngine(modelIndex,choiceMadeLocation,saveGuestChoice){chrome.send("setDefaultSearchEngine",[modelIndex,choiceMadeLocation,saveGuestChoice])}setIsActiveSearchEngine(modelIndex,isActive){chrome.send("setIsActiveSearchEngine",[modelIndex,isActive]);this.recordSearchEnginesPageHistogram(isActive?SearchEnginesInteractions.ACTIVATE:SearchEnginesInteractions.DEACTIVATE)}removeSearchEngine(modelIndex){chrome.send("removeSearchEngine",[modelIndex])}searchEngineEditStarted(modelIndex){chrome.send("searchEngineEditStarted",[modelIndex])}searchEngineEditCancelled(){chrome.send("searchEngineEditCancelled")}searchEngineEditCompleted(searchEngine,keyword,queryUrl){chrome.send("searchEngineEditCompleted",[searchEngine,keyword,queryUrl])}getSearchEnginesList(){return sendWithPromise("getSearchEnginesList")}getSaveGuestChoice(){return sendWithPromise("getSaveGuestChoice")}validateSearchEngineInput(fieldName,fieldValue){return sendWithPromise("validateSearchEngineInput",fieldName,fieldValue)}recordSearchEnginesPageHistogram(interaction){chrome.metricsPrivate.recordEnumerationValue("Settings.SearchEngines.Interactions",interaction,SearchEnginesInteractions.COUNT)}static getInstance(){return instance$1||(instance$1=new SearchEnginesBrowserProxyImpl)}static setInstance(obj){instance$1=obj}}let instance$1=null;
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let scrollTargetResolver=new PromiseResolver;const GlobalScrollTargetMixin=dedupingMixin((superClass=>{const superClassBase=RouteObserverMixin(superClass);class GlobalScrollTargetMixin extends superClassBase{static get properties(){return{scrollTarget:Object,subpageScrollTarget:{type:Object,computed:"getActiveTarget_(scrollTarget, active_)"},subpageRoute:Object,active_:Boolean}}connectedCallback(){super.connectedCallback();this.active_=Router.getInstance().getCurrentRoute()===this.subpageRoute;scrollTargetResolver.promise.then((scrollTarget=>{this.scrollTarget=scrollTarget}))}currentRouteChanged(route){if(route===this.subpageRoute){this.active_=true}else{setTimeout((()=>{this.active_=false}))}}getActiveTarget_(target,active){if(target===undefined||active===undefined){return undefined}return active?target:null}}return GlobalScrollTargetMixin}));function setGlobalScrollTarget(scrollTarget){scrollTargetResolver.resolve(scrollTarget)}function resetGlobalScrollTargetForTesting(){scrollTargetResolver=new PromiseResolver}
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class PluralStringProxyImpl{getPluralString(messageName,itemCount){return sendWithPromise("getPluralString",messageName,itemCount)}getPluralStringTupleWithComma(messageName1,itemCount1,messageName2,itemCount2){return sendWithPromise("getPluralStringTupleWithComma",messageName1,itemCount1,messageName2,itemCount2)}getPluralStringTupleWithPeriods(messageName1,itemCount1,messageName2,itemCount2){return sendWithPromise("getPluralStringTupleWithPeriods",messageName1,itemCount1,messageName2,itemCount2)}static getInstance(){return instance||(instance=new PluralStringProxyImpl)}static setInstance(obj){instance=obj}}let instance=null;
// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const kChromeToTranslateCode=new Map([["fil","tl"],["he","iw"],["jv","jw"],["kok","gom"],["nb","no"]]);const kTranslateToChromeCode=new Map([["gom","kok"],["iw","he"],["jw","jv"],["no","nb"],["tl","fil"]]);function getBaseLanguage(languageCode){return languageCode.split("-")[0]}function convertLanguageCodeForChrome(languageCode){return kTranslateToChromeCode.get(languageCode)||languageCode}function convertLanguageCodeForTranslate(languageCode){const base=getBaseLanguage(languageCode);if(base==="zh"){return languageCode==="zh-HK"?"zh-TW":languageCode}return kChromeToTranslateCode.get(base)||base}function getFullName(language){let fullName=language.displayName;if(language.displayName!==language.nativeDisplayName){fullName+=" - "+language.nativeDisplayName}return fullName}function isTranslateBaseLanguage(language){if(!language.supportsTranslate){return false}if(language.code==="zh-CN"||language.code==="zh-TW"){return true}if(language.code==="mni-Mtei"){return true}const baseLanguage=getBaseLanguage(language.code);if(baseLanguage==="nb"){return false}return language.code===baseLanguage}export{PrivacyGuideBrowserProxyImpl as $,AiPageInteractions as A,SyncBrowserProxyImpl as B,CrSearchFieldMixinLit as C,ProfileInfoBrowserProxyImpl as D,SignedInState as E,FeatureOptInState as F,getImage as G,HelpBubbleMixin as H,I18nMixinLit as I,StatusAction as J,BaseMixin as K,ListPropertyUpdateMixin as L,MetricsBrowserProxyImpl as M,NONE_SELECTED as N,OpenWindowProxyImpl as O,PrefsMixin as P,NetworkPredictionOptions as Q,RelaunchMixin as R,SettingsViewMixin as S,TooltipMixin as T,PrivacyGuideInteractions as U,PrivacyGuideAvailabilityMixin as V,WebUiListenerMixin as W,HatsBrowserProxyImpl as X,TrustSafetyInteraction as Y,CookieControlsMode as Z,PromiseResolver as _,assertNotReached as a,SafetyCheckUnusedSitePermissionsModuleInteractions as a$,MAX_PRIVACY_GUIDE_PROMO_IMPRESSION as a0,ResetBrowserProxyImpl as a1,SearchEnginesBrowserProxyImpl as a2,getTrustedScriptURL as a3,getTopLevelRoute as a4,combineSearchResults as a5,getInstance as a6,FocusOutlineManager as a7,CrSelectableMixin as a8,FindShortcutMixin as a9,CrRadioGroupElement as aA,CrToggleElement as aB,PluralStringProxyImpl as aC,getTrustedHTML as aD,ControlledRadioButtonElement as aE,SettingsDropdownMenuElement as aF,SettingsToggleButtonElement as aG,PasswordCheckReferrer as aH,SettingsCheckboxListEntryElement as aI,SafeBrowsingSetting$1 as aJ,SecurityPageInteraction as aK,convertLanguageCodeForChrome as aL,convertLanguageCodeForTranslate as aM,getBaseLanguage as aN,isTranslateBaseLanguage as aO,AiPageCompareInteractions as aP,AiPageComposeInteractions as aQ,AiPageHistorySearchInteractions as aR,AiPageTabOrganizationInteractions as aS,CardBenefitsUserAction as aT,CvcDeletionUserAction as aU,DeleteBrowsingDataAction as aV,PrivacyElementInteractions as aW,PrivacyGuideSettingsStates as aX,PrivacyGuideStepsEligibleAndReached as aY,SafeBrowsingInteractions as aZ,SafetyCheckNotificationsModuleInteractions as a_,setGlobalScrollTarget as aa,resetGlobalScrollTargetForTesting as ab,ModelExecutionEnterprisePolicyValue as ac,ChoiceMadeLocation as ad,CrPolicyPrefIndicatorElement as ae,ExtensionControlledIndicatorElement as af,DEFAULT_CHECKED_VALUE as ag,DEFAULT_UNCHECKED_VALUE as ah,ExtensionControlBrowserProxyImpl as ai,LifetimeBrowserProxyImpl as aj,ChromeSigninUserChoice as ak,PageStatus as al,syncPrefsIndividualDataTypes as am,TrustedVaultBannerState as an,UserSelectableType as ao,prefToString as ap,stringToPrefValue as aq,SettingsPrefsElement as ar,PrivacyPageBrowserProxyImpl as as,SecureDnsMode as at,SecureDnsUiManagementMode as au,CrActionMenuElement as av,CrButtonElement as aw,CrDialogElement as ax,CrLinkRowElement as ay,CrRadioButtonElement as az,getCss$s as b,PrivacyGuideStep as b$,SafetyHubCardState as b0,SafetyHubEntryPoint as b1,SafetyHubModuleType as b2,SafetyHubSurfaces as b3,resetPageVisibilityForTesting as b4,SettingsSyncAccountControlElement as b5,PrivacySandboxBrowserProxyImpl as b6,buildRouter as b7,resetRouterForTesting as b8,Route as b9,SITE_EXCEPTION_WILDCARD as bA,ChooserType as bB,INVALID_CATEGORY_SUBTYPE as bC,AllSitesAction2 as bD,SortMethod as bE,AllSitesDialog as bF,SettingsState as bG,getLocalizationStringForContentType as bH,JavascriptOptimizerSetting as bI,getFullName as bJ,hasKeyModifiers as bK,isWindows as bL,ThirdPartyCookieBlockingSetting as bM,isUndoKeyboardEvent as bN,PermissionsRevocationType as bO,CrShortcutInputElement as bP,CrCheckboxElement as bQ,CrCollapseElement as bR,CrExpandButtonElement as bS,CrIconButtonElement as bT,CrInputElement as bU,CrLazyRenderElement as bV,CrTextareaElement as bW,CrToastElement as bX,CrTooltipElement as bY,SettingsRadioGroupElement as bZ,SettingsCollapseRadioButtonElement as b_,SearchEnginesInteractions as ba,SearchRequest as bb,setSearchManagerForTesting as bc,showBubble as bd,SettingsSectionElement as be,SiteFaviconElement as bf,AiEnterpriseFeaturePrefName as bg,EventTracker as bh,CrRippleMixin as bi,AnchorAlignment as bj,SettingsBooleanControlMixin as bk,TimePeriod as bl,ClearBrowsingDataBrowserProxyImpl as bm,assertNotReachedCase as bn,BrowsingDataType as bo,GlobalScrollTargetMixin as bp,SiteSettingsPrefsBrowserProxyImpl as bq,SiteSettingSource as br,ContentSettingsTypes as bs,DefaultSettingSource as bt,isSettingEnabled as bu,ContentSetting as bv,CardState as bw,SafetyHubBrowserProxyImpl as bx,SafetyHubEvent as by,CookiesExceptionType as bz,getCss$x as c,PrivacyGuideCompletionFragmentElement as c0,PrivacyGuideCookiesFragmentElement as c1,SettingsPrivacyGuideDialogElement as c2,PrivacyGuideHistorySyncFragmentElement as c3,PrivacyGuideMsbbFragmentElement as c4,SettingsPrivacyGuidePageElement as c5,PrivacyGuideSafeBrowsingFragmentElement as c6,PrivacyGuideWelcomeFragmentElement as c7,SecureDnsResolverType as c8,SettingsSecureDnsElement as c9,SecureDnsInputElement as ca,HttpsFirstModeSetting as cb,SafeBrowsingSetting as cc,SettingsSecurityPageElement as cd,SettingsSafetyHubEntryPointElement as ce,SettingsSafetyHubModuleElement as cf,SettingsSimpleConfirmationDialogElement as cg,assert as d,I18nMixin as e,RestartType as f,getCss$r as g,Router as h,SettingsAiPageFeaturePrefName as i,AiPageActions as j,CrSettingsPrefs as k,listenOnce as l,SearchableViewContainerMixin as m,RouteObserverMixin as n,CrPolicyPrefMixin as o,PrefControlMixin as p,pageVisibility as q,routes as r,sanitizeInnerHtml as s,AutofillSettingsReferrer as t,PasswordManagerImpl as u,PasswordManagerPage as v,FocusRowMixin as w,ScrollableMixin as x,focusWithoutInk as y,getSearchManager as z};