// chrome/browser/ui/webui/search_engine_choice/search_engine_choice.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';








export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'search_engine_choice.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(handler: PageHandlerPendingReceiver): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      handler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "search_engine_choice.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'search_engine_choice.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  displayDialog(): void;
  handleSearchEngineChoiceSelected(prepopulateId: number, saveGuestModeSelection: boolean): void;
  handleLearnMoreLinkClicked(): void;
  handleMoreButtonClicked(): void;
  recordScrollState(scrollState: PageHandler_ScrollState): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  displayDialog(): void {
    this.proxy.sendMessage(
        0,
        PageHandler_DisplayDialog_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  handleSearchEngineChoiceSelected(
      prepopulateId: number,
      saveGuestModeSelection: boolean): void {
    this.proxy.sendMessage(
        1,
        PageHandler_HandleSearchEngineChoiceSelected_ParamsSpec.$,
        null,
        [
          prepopulateId,
          saveGuestModeSelection
        ],
        false);
  }

  handleLearnMoreLinkClicked(): void {
    this.proxy.sendMessage(
        2,
        PageHandler_HandleLearnMoreLinkClicked_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  handleMoreButtonClicked(): void {
    this.proxy.sendMessage(
        3,
        PageHandler_HandleMoreButtonClicked_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  recordScrollState(
      scrollState: PageHandler_ScrollState): void {
    this.proxy.sendMessage(
        4,
        PageHandler_RecordScrollState_ParamsSpec.$,
        null,
        [
          scrollState
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_DisplayDialog_ParamsSpec.$,
        null,
        impl.displayDialog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_HandleSearchEngineChoiceSelected_ParamsSpec.$,
        null,
        impl.handleSearchEngineChoiceSelected.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_HandleLearnMoreLinkClicked_ParamsSpec.$,
        null,
        impl.handleLearnMoreLinkClicked.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_HandleMoreButtonClicked_ParamsSpec.$,
        null,
        impl.handleMoreButtonClicked.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_RecordScrollState_ParamsSpec.$,
        null,
        impl.recordScrollState.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "search_engine_choice.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}
export const PageHandler_ScrollStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum PageHandler_ScrollState {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kAtTheBottom = 0,
  kAtTheBottomWithErrorMargin = 1,
  kNotAtTheBottom = 2,
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  displayDialog: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  handleSearchEngineChoiceSelected: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  handleLearnMoreLinkClicked: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  handleMoreButtonClicked: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordScrollState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.displayDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_DisplayDialog_ParamsSpec.$,
        null,
        this.displayDialog.createReceiverHandler(false /* expectsResponse */),
        false);
    this.handleSearchEngineChoiceSelected =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_HandleSearchEngineChoiceSelected_ParamsSpec.$,
        null,
        this.handleSearchEngineChoiceSelected.createReceiverHandler(false /* expectsResponse */),
        false);
    this.handleLearnMoreLinkClicked =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_HandleLearnMoreLinkClicked_ParamsSpec.$,
        null,
        this.handleLearnMoreLinkClicked.createReceiverHandler(false /* expectsResponse */),
        false);
    this.handleMoreButtonClicked =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_HandleMoreButtonClicked_ParamsSpec.$,
        null,
        this.handleMoreButtonClicked.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordScrollState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_RecordScrollState_ParamsSpec.$,
        null,
        this.recordScrollState.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_DisplayDialog_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_HandleSearchEngineChoiceSelected_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_HandleLearnMoreLinkClicked_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_HandleMoreButtonClicked_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordScrollState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  handler: PageHandlerPendingReceiver;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'handler', 0,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_DisplayDialog_ParamsMojoType {
}


export type PageHandler_DisplayDialog_Params = PageHandler_DisplayDialog_ParamsMojoType;
mojo.internal.Struct<PageHandler_DisplayDialog_ParamsMojoType>(
    PageHandler_DisplayDialog_ParamsSpec.$,
    'PageHandler_DisplayDialog_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_HandleSearchEngineChoiceSelected_ParamsMojoType {
  prepopulateId: number;
  saveGuestModeSelection: boolean;
}


export type PageHandler_HandleSearchEngineChoiceSelected_Params = PageHandler_HandleSearchEngineChoiceSelected_ParamsMojoType;
mojo.internal.Struct<PageHandler_HandleSearchEngineChoiceSelected_ParamsMojoType>(
    PageHandler_HandleSearchEngineChoiceSelected_ParamsSpec.$,
    'PageHandler_HandleSearchEngineChoiceSelected_Params',
    [
      mojo.internal.StructField<PageHandler_HandleSearchEngineChoiceSelected_ParamsMojoType, number>(
        'prepopulateId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_HandleSearchEngineChoiceSelected_ParamsMojoType, boolean>(
        'saveGuestModeSelection', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_HandleLearnMoreLinkClicked_ParamsMojoType {
}


export type PageHandler_HandleLearnMoreLinkClicked_Params = PageHandler_HandleLearnMoreLinkClicked_ParamsMojoType;
mojo.internal.Struct<PageHandler_HandleLearnMoreLinkClicked_ParamsMojoType>(
    PageHandler_HandleLearnMoreLinkClicked_ParamsSpec.$,
    'PageHandler_HandleLearnMoreLinkClicked_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_HandleMoreButtonClicked_ParamsMojoType {
}


export type PageHandler_HandleMoreButtonClicked_Params = PageHandler_HandleMoreButtonClicked_ParamsMojoType;
mojo.internal.Struct<PageHandler_HandleMoreButtonClicked_ParamsMojoType>(
    PageHandler_HandleMoreButtonClicked_ParamsSpec.$,
    'PageHandler_HandleMoreButtonClicked_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_RecordScrollState_ParamsMojoType {
  scrollState: PageHandler_ScrollState;
}


export type PageHandler_RecordScrollState_Params = PageHandler_RecordScrollState_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordScrollState_ParamsMojoType>(
    PageHandler_RecordScrollState_ParamsSpec.$,
    'PageHandler_RecordScrollState_Params',
    [
      mojo.internal.StructField<PageHandler_RecordScrollState_ParamsMojoType, PageHandler_ScrollState>(
        'scrollState', 0,
        0,
        PageHandler_ScrollStateSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



