import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-shared-style shared-style"></style>

<div id="notice" fill-content role="main" hidden$="[[hideNoticePage_]]">
  <div class="content-area custom-scrollbar" scrollable tabindex="-1">
    <div class="header">
      <img class="logo" alt="">
      <h1>$i18n{m1NoticeRowTitle}</h1>
    </div>
    <div class="section cr-secondary-text">
      $i18n{m1NoticeRowDescription1}
    </div>
    <div class="section cr-secondary-text">
      $i18n{m1NoticeRowDescription2}
    </div>
    <div class="banner">
      <img class="topics-banner" alt="">
    </div>
    <div class="section cr-secondary-text">
      $i18n{m1NoticeRowDescription3}
    </div>
    <div id="learnMoreAndLastTextV2">
      <privacy-sandbox-dialog-learn-more class="learn-more-section"
          expanded="{{expanded_}}"
          title="$i18n{m1NoticeRowLearnMoreExpandLabel}">
        <div class="paragraph">
          <h2>$i18n{m1NoticeRowLearnMoreHeading1}</h2>
          <div class="cr-secondary-text">
            $i18n{m1NoticeRowLearnMoreDescription1}
          </div>
          <ul class="cr-secondary-text">
            <li>$i18n{m1NoticeRowLearnMoreBullet1}</li>
            <li>$i18n{m1NoticeLearnMoreBullet2V2}</li>
          </ul>
        </div>
        <div class="paragraph cr-secondary-text">
          $i18n{m1NoticeRowLearnMoreDesription2V2}
        </div>
        <div class="paragraph cr-secondary-text">
          $i18n{m1NoticeRowLearnMoreDescription3}
        </div>
        <div class="paragraph">
          <h2>$i18n{m1NoticeRowLearnMoreHeading2}</h2>
          <div class="cr-secondary-text">
            $i18n{m1NoticeRowLearnMoreDescription4}
          </div>
        </div>
        <div class="paragraph">
          <h2>$i18n{m1NoticeRowLearnMoreHeading3}</h2>
          <div class="cr-secondary-text">
            $i18nRaw{m1NoticeRowLearnMoreDescription5V2}
          </div>
        </div>
      </privacy-sandbox-dialog-learn-more>
      <div class="section cr-secondary-text" id="lastTextElementV2">
        $i18n{m1NoticeRowLastText}
      </div>
    </div>
    <div class="buttons-container">
      <cr-button id="settingsButton" on-click="onNoticeOpenSettings">
        $i18n{m1NoticeRowSettingsButton}
      </cr-button>
      <cr-button id="ackButton" class="action-button"
          on-click="onNoticeAcknowledge">
        $i18n{m1NoticeRowAckButton}
      </cr-button>
    </div>
  </div>
  <div id="showMoreOverlay" hidden="[[wasScrolledToBottom]]">
    <cr-button id="moreButton" on-click="onNoticeMoreClicked"
        class="action-button">
      $i18n{m1DialogMoreButton}
      <cr-icon icon="cr:expand-more"></cr-icon>
    </cr-button>
  </div>
</div>
<template is="dom-if" if="[[loadPrivacyPolicy_]]">
  <privacy-sandbox-privacy-policy-dialog
      id="privacyPolicyDialog"
      should-show="[[hideNoticePage_]]"
      on-back-button-clicked="onBackButtonClicked_">
  </privacy-sandbox-privacy-policy-dialog>
</template>
<!--_html_template_end_-->`;
}