import { CustomElement } from 'chrome://resources/js/custom_element.js';
/**
 * A container that expands to show its contents when clicked
 *
 * TODO(crbug.com/427550387): Create a dedicated icon component and use it here.
 */
export declare class ExpandableJsonViewerElement extends CustomElement {
    static get template(): string | TrustedHTML;
    connectedCallback(): void;
    configure(child: HTMLElement, title: string): void;
    getTitleTextForTesting(): string | null;
    /** @private */
    onExpand(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'expandable-json-viewer': ExpandableJsonViewerElement;
    }
}
