// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { getCss as getPdfSharedCss } from './pdf_shared.css.js';
import { getHtml } from './viewer_download_controls.html.js';
import { ViewerSaveControlsMixin } from './viewer_save_controls_mixin.js';
import { getCss as getViewerSaveControlsSharedCss } from './viewer_save_controls_shared.css.js';
const ViewerDownloadControlsBase = ViewerSaveControlsMixin(CrLitElement);
export class ViewerDownloadControlsElement extends ViewerDownloadControlsBase {
    static get is() {
        return 'viewer-download-controls';
    }
    static get styles() {
        return [
            getPdfSharedCss(),
            getViewerSaveControlsSharedCss(),
        ];
    }
    render() {
        return getHtml.bind(this)();
    }
    getSaveButton() {
        return this.$.save;
    }
    getSaveEventType() {
        return 'save';
    }
    getMenu() {
        return this.$.menu;
    }
}
customElements.define(ViewerDownloadControlsElement.is, ViewerDownloadControlsElement);
