import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-page-host-style cr-shared-style shared-style">:host{display:flex;flex-direction:column;height:100%}#container{align-items:flex-start;display:flex;flex:1;overflow:overlay;position:relative}#sidebar,#content,#space-holder{flex:1 1 0}#space-holder{min-width:56px}#sidebar{height:100%;position:sticky;top:0;z-index:1}#content{flex-basis:var(--password-manager-main-basis);height:100%}#checkupDetails,#passwordChange{height:100%}checkup-details-section{height:auto !important;min-height:100%}passwords-section,settings-section,password-details-section{padding-bottom:28px}@media (max-width:1036px){#content{min-width:auto;padding:0 3px}}@media not (max-width:1036px){#content *{min-width:680px}}#cr-container-shadow-top{z-index:2}#toast-message{display:flex;flex:1;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}password-manager-side-bar{min-width:var(--side-bar-width)}</style>
<settings-prefs id="prefs" prefs="{{prefs_}}"></settings-prefs>
<password-manager-toolbar id="toolbar" narrow="[[narrow_]]" page-name="[[pageTitle_]]"
    on-search-enter-click="onSearchEnterClick_">
</password-manager-toolbar>
<div id="container" role="group">
  <password-manager-side-bar id="sidebar" hidden$="[[narrow_]]">
  </password-manager-side-bar>
  <cr-page-selector id="content" attr-for-selected="path"
      selected="[[selectedPage_]]"
      on-iron-select="onIronSelect_">
    <passwords-section id="passwords" path="passwords" prefs="{{prefs_}}"
        focus-config="[[focusConfig_]]" class="cr-centered-card-container"
        on-passwords-moved="onPasswordsMoved_">
    </passwords-section>
    <checkup-section id="checkup" path="checkup" focus-config="[[focusConfig_]]"
        class="cr-centered-card-container">
    </checkup-section>
    <settings-section id="settings" path="settings" prefs="{{prefs_}}"
        class="cr-centered-card-container"
        on-passwords-moved="onPasswordsMoved_">
    </settings-section>
    <div id="passwordDetails" path="password-details">
      <template is="dom-if" restamp
          if="[[showPage(selectedPage_, pagesValueEnum_.PASSWORD_DETAILS)]]">
        <password-details-section class="cr-centered-card-container"
            on-password-removed="onPasswordRemoved_" prefs="{{prefs_}}"
            on-backup-password-removed="onBackupPasswordRemoved_"
            on-passkey-removed="onPasskeyRemoved_"
            on-passwords-moved="onPasswordsMoved_"
            on-value-copied="onValueCopied_">
        </password-details-section>
      </template>
    </div>
    <div id="checkupDetails" path="checkup-details">
      <template is="dom-if" restamp
          if="[[showPage(selectedPage_, pagesValueEnum_.CHECKUP_DETAILS)]]">
        <checkup-details-section class="cr-centered-card-container"
            on-password-removed="onPasswordRemoved_" prefs="{{prefs_}}">
        </checkup-details-section>
      </template>
    </div>
    <div id="passwordChange" path="password-change">
      <template is="dom-if" restamp
          if="[[showPage(selectedPage_, pagesValueEnum_.PASSWORD_CHANGE)]]">
        <password-change-details class="cr-centered-card-container">
        </password-change-details>
      </template>
    </div>
  </cr-page-selector>
  <!-- An additional child of the flex #container to take up space,
      aligned with the right-hand child of the flex toolbar. -->
  <div id="space-holder" hidden$="[[narrow_]]"></div>
<div>
<cr-drawer id="drawer" heading="$i18n{passwordManagerString}"
    align="$i18n{textdirection}">
  <div slot="body">
    <template is="dom-if" id="drawerTemplate">
      <password-manager-side-bar id="drawerSidebar"></password-manager-side-bar>
    </template>
  </div>
</cr-drawer>
<cr-toast id="toast" duration="5000">
  <span id="toast-message">[[toastMessage_]]</span>
  <cr-button id="undo" aria-label="$i18n{undoDescription}"
          on-click="onUndoButtonClick_" hidden$="[[!showUndo_]]">
    $i18n{undoRemovePassword}
  </cr-button>
</cr-toast>
<!--_html_template_end_-->`;
}
