import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="shared-style">a[href]{color:var(--cr-link-color)}#avatar{border-radius:50%;height:32px;margin-inline-end:8px;width:32px}#userAccount{color:var(--cr-secondary-text-color)}#description{padding-bottom:8px}div[slot='footer']{background:var(--google-grey-100);border-top:none;padding:8px 16px}@media (prefers-color-scheme:dark){div[slot='footer']{background:var(--google-grey-900)}}</style>

<cr-dialog id="dialog" close-text="$i18n{close}" show-on-attach>
  <div slot="title">
    <share-password-dialog-header id="header">
      [[dialogTitle]]
    </share-password-dialog-header>
  </div>
  <div slot="body">
    <div id="description"
        inner-h-t-m-l="[[i18nAdvanced('sharePasswordFamilyPickerDescription')]]">
    </div>
    <template is="dom-repeat" items="[[eligibleRecipients_]]">
      <share-password-recipient recipient="[[item]]"
          selected="[[shouldPreselectFirstEntry_(index)]]"
          on-change="recipientSelected_">
      </share-password-recipient>
    </template>
    <template is="dom-repeat" items="[[ineligibleRecipients_]]">
      <share-password-recipient recipient="[[item]]" disabled>
      </share-password-recipient>
    </template>
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" on-click="onClickCancel_" id="cancel">
      $i18n{cancel}
    </cr-button>
    <cr-button class="action-button" id="action" on-click="onClickShare_"
        disabled$="[[!selectedRecipients.length]]">
      $i18n{share}
    </cr-button>
  </div>
  <div slot="footer" class="flex-centered">
    <img id="avatar" src="[[avatarImage]]"></img>
    <div id="footerDescription">
      <a href="$i18n{familyGroupViewURL}" target="_blank" id="viewFamily"
          on-click="onViewFamilyClick_">
        $i18n{sharePasswordViewFamily}</a>
      <span> • </span><span>[[accountEmail]]</span>
    </div>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}