import '//resources/cr_components/searchbox/searchbox_dropdown.js';
import '/strings.m.js';
import type { SearchboxDropdownElement } from '//resources/cr_components/searchbox/searchbox_dropdown.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { AutocompleteResult } from '//resources/mojo/components/omnibox/browser/searchbox.mojom-webui.js';
export interface OmniboxPopupAppElement {
    $: {
        matches: SearchboxDropdownElement;
    };
}
export declare class OmniboxPopupAppElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        /**
         * Whether the secondary side can be shown based on the feature state and
         * the width available to the dropdown.
         */
        canShowSecondarySide: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        hasSecondarySide: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        /**
         * Whether the app is in debug mode.
         */
        isDebug: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        result_: {
            type: ObjectConstructor;
        };
    };
    accessor canShowSecondarySide: boolean;
    accessor hasSecondarySide: boolean;
    accessor isDebug: boolean;
    protected accessor result_: AutocompleteResult | null;
    private callbackRouter_;
    private autocompleteResultChangedListenerId_;
    private selectionChangedListenerId_;
    private eventTracker_;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    private onCanShowSecondarySideChanged_;
    private onAutocompleteResultChanged_;
    protected onResultRepaint_(): void;
    private onUpdateSelection_;
    protected onHasSecondarySideChanged_(e: CustomEvent<{
        value: boolean;
    }>): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'omnibox-popup-app': OmniboxPopupAppElement;
    }
}
