// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import"./omnibox_input.js";import"./omnibox_output.js";import{assert}from"chrome://resources/js/assert.js";import{sendWithPromise}from"chrome://resources/js/cr.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{AutocompleteControllerType,OmniboxPageCallbackRouter,OmniboxPageHandler}from"./omnibox_internals.mojom-webui.js";let browserProxy;let omniboxInput;let omniboxOutput;let exportDelegate;class BrowserProxy{callbackRouter_=new OmniboxPageCallbackRouter;handler_;lastRequest=null;constructor(omniboxOutput){this.callbackRouter_.handleNewAutocompleteResponse.addListener(this.handleNewAutocompleteResponse.bind(this));this.callbackRouter_.handleNewAutocompleteQuery.addListener(this.handleNewAutocompleteQuery.bind(this));this.callbackRouter_.handleAnswerIconImageData.addListener(omniboxOutput.updateAnswerIconImage.bind(omniboxOutput));this.handler_=OmniboxPageHandler.getRemote();this.handler_.setClientPage(this.callbackRouter_.$.bindNewPipeAndPassRemote())}handleNewAutocompleteResponse(controllerType,response){if(controllerType===AutocompleteControllerType.kMlDisabledDebug){return}const isDebugController=controllerType===AutocompleteControllerType.kDebug;const isForLastPageRequest=this.isForLastPageRequest(response.inputText,isDebugController);if(isForLastPageRequest&&this.lastRequest.display||omniboxInput.connectWindowOmnibox&&!isDebugController&&response.combinedResults.length){omniboxOutput.addAutocompleteResponse(response)}if(isForLastPageRequest&&response.done){assert(this.lastRequest);this.lastRequest.callback(response);this.lastRequest=null}}handleNewAutocompleteQuery(controllerType,inputText){if(controllerType===AutocompleteControllerType.kMlDisabledDebug){return}const isDebugController=controllerType===AutocompleteControllerType.kDebug;if(this.isForLastPageRequest(inputText,isDebugController)&&this.lastRequest.display||omniboxInput.connectWindowOmnibox&&!isDebugController){omniboxOutput.prepareNewQuery()}}makeRequest(inputText,resetAutocompleteController,cursorPosition,zeroSuggest,preventInlineAutocomplete,preferKeyword,currentUrl,pageClassification,display){return new Promise((resolve=>{this.lastRequest={inputText:inputText,callback:resolve,display:display};this.handler_.startOmniboxQuery(inputText,resetAutocompleteController,cursorPosition,zeroSuggest,preventInlineAutocomplete,preferKeyword,currentUrl,pageClassification)}))}isForLastPageRequest(inputText,isDebugController){return isDebugController&&!!this.lastRequest&&this.lastRequest.inputText.trimStart()===inputText}}document.addEventListener("DOMContentLoaded",(()=>{omniboxInput=document.querySelector("omnibox-input");omniboxOutput=document.querySelector("omnibox-output");browserProxy=new BrowserProxy(omniboxOutput);exportDelegate=new ExportDelegate(omniboxOutput,omniboxInput);omniboxInput.addEventListener("query-inputs-changed",(e=>{browserProxy.makeRequest(e.detail.inputText,e.detail.resetAutocompleteController,e.detail.cursorPosition,e.detail.zeroSuggest,e.detail.preventInlineAutocomplete,e.detail.preferKeyword,e.detail.currentUrl,e.detail.pageClassification,true)}));omniboxInput.addEventListener("display-inputs-changed",(e=>omniboxOutput.updateDisplayInputs(e.detail)));omniboxInput.addEventListener("filter-input-changed",(e=>omniboxOutput.updateFilterText(e.detail)));omniboxInput.addEventListener("import",(e=>exportDelegate.import(e.detail)));omniboxInput.addEventListener("process-batch",(e=>exportDelegate.processBatchData(e.detail)));omniboxInput.addEventListener("export-clipboard",(()=>exportDelegate.exportClipboard()));omniboxInput.addEventListener("export-file",(()=>exportDelegate.exportFile()));omniboxInput.addEventListener("response-select",(e=>omniboxOutput.updateSelectedResponseIndex(e.detail)));omniboxOutput.addEventListener("responses-count-changed",(e=>omniboxInput.responsesCount=e.detail));omniboxOutput.updateDisplayInputs(omniboxInput.displayInputs)}));class ExportDelegate{omniboxInput_;omniboxOutput_;constructor(omniboxOutput,omniboxInput){this.omniboxInput_=omniboxInput;this.omniboxOutput_=omniboxOutput}import(importData){if(!validateImportData(importData)){return false}this.omniboxInput_.queryInputs=importData.queryInputs;this.omniboxInput_.displayInputs=importData.displayInputs;this.omniboxOutput_.updateDisplayInputs(importData.displayInputs);this.omniboxOutput_.setResponsesHistory(importData.responsesHistory);return true}async processBatch(batchQueryInputs,batchName){const batchExports=[];for(const queryInputs of batchQueryInputs){const omniboxResponse=await browserProxy.makeRequest(queryInputs.inputText,queryInputs.resetAutocompleteController,queryInputs.cursorPosition,queryInputs.zeroSuggest,queryInputs.preventInlineAutocomplete,queryInputs.preferKeyword,queryInputs.currentUrl,queryInputs.pageClassification,false);const exportData={queryInputs:queryInputs,responsesHistory:[[omniboxResponse]],displayInputs:this.omniboxInput_.displayInputs};batchExports.push(exportData)}const variationInfo=await sendWithPromise("requestVariationInfo",true);const pathInfo=await sendWithPromise("requestPathInfo");const now=new Date;const fileName=`omnibox_batch_${ExportDelegate.getTimeStamp(now)}.json`;const batchData={schemaKind:"Omnibox Batch Export",schemaVersion:3,dateCreated:now.toISOString(),author:"",description:"",authorTool:"chrome://omnibox",batchName:batchName,versionDetails:ExportDelegate.getVersionDetails(),variationInfo:variationInfo,pathInfo:pathInfo,appVersion:navigator.appVersion,batchExports:batchExports};ExportDelegate.download(batchData,fileName)}processBatchData(processBatchData){if(processBatchData.batchMode&&processBatchData.batchQueryInputs&&processBatchData.batchName){this.processBatch(processBatchData.batchQueryInputs,processBatchData.batchName)}else{const expected={batchMode:"combined",batchName:"name for this batch of queries",batchQueryInputs:[{inputText:"example input text",cursorPosition:18,resetAutocompleteController:false,cursorLock:false,zeroSuggest:false,preventInlineAutocomplete:false,preferKeyword:false,currentUrl:"",pageClassification:"4"}]};console.error(`Invalid batch specifier data.  Expected format: \n${JSON.stringify(expected,null,2)}`)}}exportClipboard(){navigator.clipboard.writeText(ExportDelegate.jsonStringify(this.exportData)).catch((error=>console.error("unable to export to clipboard:",error)))}exportFile(){const exportData=this.exportData;const timeStamp=ExportDelegate.getTimeStamp();const fileName=`omnibox_debug_export_${exportData.queryInputs.inputText}_${timeStamp}.json`;ExportDelegate.download(exportData,fileName)}get exportData(){return{versionDetails:ExportDelegate.getVersionDetails(),queryInputs:this.omniboxInput_.queryInputs,displayInputs:this.omniboxInput_.displayInputs,responsesHistory:this.omniboxOutput_.responsesHistory.slice(-20)}}static download(object,fileName){const content=ExportDelegate.jsonStringify(object);const blob=new Blob([content],{type:"application/json"});const url=URL.createObjectURL(blob);const a=document.createElement("a");a.href=url;a.download=fileName;a.click()}static jsonStringify(data){return JSON.stringify(data,((_,value)=>typeof value==="bigint"?value.toString():value),2)}static getTimeStamp(date=new Date){const iso=date.toISOString();return iso.replace(/:/g,"").split(".")[0]}static getVersionDetails(){const loadTimeDataKeys=["cl","command_line","executable_path","language","official","os_type","profile_path","useragent","version","version_processor_variation","version_modifier"];return Object.fromEntries(loadTimeDataKeys.map((key=>{let valueOrError;try{valueOrError=loadTimeData.getValue(key)}catch(e){valueOrError=e.toString()}return[key,valueOrError]})))}}function validateImportData(importData){const EXPECTED_FORMAT={queryInputs:{},displayInputs:{},responsesHistory:[[{combinedResults:[],resultsByProvider:[]}]]};const INVALID_MESSAGE=`Invalid import format; expected \n${JSON.stringify(EXPECTED_FORMAT,null,2)};\n`;if(!importData){console.error(INVALID_MESSAGE+"received non object.");return false}if(!importData.queryInputs||!importData.displayInputs){console.error(INVALID_MESSAGE+"import missing objects queryInputs and displayInputs.");return false}if(!Array.isArray(importData.responsesHistory)){console.error(INVALID_MESSAGE+"import missing array responsesHistory.");return false}if(!importData.responsesHistory.every(Array.isArray)){console.error(INVALID_MESSAGE+"responsesHistory contains non arrays.");return false}if(!importData.responsesHistory.every((responses=>responses.every((({combinedResults:combinedResults,resultsByProvider:resultsByProvider})=>Array.isArray(combinedResults)&&Array.isArray(resultsByProvider)))))){console.error(INVALID_MESSAGE+"responsesHistory items' items missing combinedResults and "+"resultsByProvider arrays.");return false}return true}