import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
export declare const ShowNtpPromosResultSpec: {
    $: mojo.internal.MojomType;
};
export declare enum ShowNtpPromosResult {
    MIN_VALUE = 0,
    MAX_VALUE = 2,
    kShown = 0,
    kNotShownNoPromos = 1,
    kNotShownDueToPolicy = 2
}
export type NtpPromoHandlerPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<NtpPromoHandlerPendingReceiver>;
export declare class NtpPromoHandlerPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<NtpPromoHandler> {
    handle: mojo.internal.interfaceSupport.Endpoint<NtpPromoHandlerPendingReceiver>;
    constructor(handle: MojoHandle | NtpPromoHandlerPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface NtpPromoHandlerInterface {
    requestPromos(): void;
    onPromosShown(eligibleShown: string[], completedShown: string[]): void;
    onPromoClicked(promoId: string): void;
    snoozeSetupList(): void;
    unsnoozeSetupList(): void;
    disableSetupList(): void;
    undisableSetupList(): void;
}
export declare class NtpPromoHandlerRemote implements NtpPromoHandlerInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<NtpPromoHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | NtpPromoHandlerPendingReceiverEndpoint);
    requestPromos(): void;
    onPromosShown(eligibleShown: string[], completedShown: string[]): void;
    onPromoClicked(promoId: string): void;
    snoozeSetupList(): void;
    unsnoozeSetupList(): void;
    disableSetupList(): void;
    undisableSetupList(): void;
}
/**
 * An object which receives request messages for the NtpPromoHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class NtpPromoHandlerReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<NtpPromoHandlerRemote, NtpPromoHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: NtpPromoHandlerInterface);
}
export declare class NtpPromoHandler {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): NtpPromoHandlerRemote;
}
/**
 * An object which receives request messages for the NtpPromoHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class NtpPromoHandlerCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<NtpPromoHandlerRemote, NtpPromoHandlerPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    requestPromos: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onPromosShown: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onPromoClicked: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    snoozeSetupList: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    unsnoozeSetupList: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    disableSetupList: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    undisableSetupList: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type NtpPromoClientPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<NtpPromoClientPendingReceiver>;
export declare class NtpPromoClientPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<NtpPromoClient> {
    handle: mojo.internal.interfaceSupport.Endpoint<NtpPromoClientPendingReceiver>;
    constructor(handle: MojoHandle | NtpPromoClientPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface NtpPromoClientInterface {
    setPromos(eligible: Promo[], completed: Promo[]): void;
}
export declare class NtpPromoClientRemote implements NtpPromoClientInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<NtpPromoClientPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | NtpPromoClientPendingReceiverEndpoint);
    setPromos(eligible: Promo[], completed: Promo[]): void;
}
/**
 * An object which receives request messages for the NtpPromoClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class NtpPromoClientReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<NtpPromoClientRemote, NtpPromoClientPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: NtpPromoClientInterface);
}
export declare class NtpPromoClient {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): NtpPromoClientRemote;
}
/**
 * An object which receives request messages for the NtpPromoClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class NtpPromoClientCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<NtpPromoClientRemote, NtpPromoClientPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    setPromos: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type NtpPromoHandlerFactoryPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<NtpPromoHandlerFactoryPendingReceiver>;
export declare class NtpPromoHandlerFactoryPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<NtpPromoHandlerFactory> {
    handle: mojo.internal.interfaceSupport.Endpoint<NtpPromoHandlerFactoryPendingReceiver>;
    constructor(handle: MojoHandle | NtpPromoHandlerFactoryPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface NtpPromoHandlerFactoryInterface {
    createNtpPromoHandler(client: NtpPromoClientRemote, handler: NtpPromoHandlerPendingReceiver): void;
}
export declare class NtpPromoHandlerFactoryRemote implements NtpPromoHandlerFactoryInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<NtpPromoHandlerFactoryPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | NtpPromoHandlerFactoryPendingReceiverEndpoint);
    createNtpPromoHandler(client: NtpPromoClientRemote, handler: NtpPromoHandlerPendingReceiver): void;
}
/**
 * An object which receives request messages for the NtpPromoHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class NtpPromoHandlerFactoryReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<NtpPromoHandlerFactoryRemote, NtpPromoHandlerFactoryPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: NtpPromoHandlerFactoryInterface);
}
export declare class NtpPromoHandlerFactory {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): NtpPromoHandlerFactoryRemote;
}
/**
 * An object which receives request messages for the NtpPromoHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class NtpPromoHandlerFactoryCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<NtpPromoHandlerFactoryRemote, NtpPromoHandlerFactoryPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    createNtpPromoHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export declare const PromosShownSpec: {
    $: mojo.internal.MojomType;
};
export declare const PromoSpec: {
    $: mojo.internal.MojomType;
};
export declare const NtpPromoHandler_RequestPromos_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const NtpPromoHandler_OnPromosShown_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const NtpPromoHandler_OnPromoClicked_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const NtpPromoHandler_SnoozeSetupList_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const NtpPromoHandler_UnsnoozeSetupList_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const NtpPromoHandler_DisableSetupList_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const NtpPromoHandler_UndisableSetupList_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const NtpPromoClient_SetPromos_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const NtpPromoHandlerFactory_CreateNtpPromoHandler_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export interface PromosShownMojoType {
    eligible: string[];
    completed: string[];
}
export type PromosShown = PromosShownMojoType;
export interface PromoMojoType {
    id: string;
    iconName: string;
    bodyText: string;
    buttonText: string;
}
export type Promo = PromoMojoType;
export interface NtpPromoHandler_RequestPromos_ParamsMojoType {
}
export type NtpPromoHandler_RequestPromos_Params = NtpPromoHandler_RequestPromos_ParamsMojoType;
export interface NtpPromoHandler_OnPromosShown_ParamsMojoType {
    eligibleShown: string[];
    completedShown: string[];
}
export type NtpPromoHandler_OnPromosShown_Params = NtpPromoHandler_OnPromosShown_ParamsMojoType;
export interface NtpPromoHandler_OnPromoClicked_ParamsMojoType {
    promoId: string;
}
export type NtpPromoHandler_OnPromoClicked_Params = NtpPromoHandler_OnPromoClicked_ParamsMojoType;
export interface NtpPromoHandler_SnoozeSetupList_ParamsMojoType {
}
export type NtpPromoHandler_SnoozeSetupList_Params = NtpPromoHandler_SnoozeSetupList_ParamsMojoType;
export interface NtpPromoHandler_UnsnoozeSetupList_ParamsMojoType {
}
export type NtpPromoHandler_UnsnoozeSetupList_Params = NtpPromoHandler_UnsnoozeSetupList_ParamsMojoType;
export interface NtpPromoHandler_DisableSetupList_ParamsMojoType {
}
export type NtpPromoHandler_DisableSetupList_Params = NtpPromoHandler_DisableSetupList_ParamsMojoType;
export interface NtpPromoHandler_UndisableSetupList_ParamsMojoType {
}
export type NtpPromoHandler_UndisableSetupList_Params = NtpPromoHandler_UndisableSetupList_ParamsMojoType;
export interface NtpPromoClient_SetPromos_ParamsMojoType {
    eligible: Promo[];
    completed: Promo[];
}
export type NtpPromoClient_SetPromos_Params = NtpPromoClient_SetPromos_ParamsMojoType;
export interface NtpPromoHandlerFactory_CreateNtpPromoHandler_ParamsMojoType {
    client: NtpPromoClientRemote;
    handler: NtpPromoHandlerPendingReceiver;
}
export type NtpPromoHandlerFactory_CreateNtpPromoHandler_Params = NtpPromoHandlerFactory_CreateNtpPromoHandler_ParamsMojoType;
