// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{$}from"chrome://resources/js/util.js";import{setNodeDisplay,setNodePosition}from"./util.js";export class View{constructor(){this.isVisible_=true}setGeometry(left,top,width,height){this.left_=left;this.top_=top;this.width_=width;this.height_=height}show(isVisible){this.isVisible_=isVisible}isVisible(){return this.isVisible_}isActive(){return this.isVisible()}getLeft(){return this.left_}getTop(){return this.top_}getWidth(){return this.width_}getHeight(){return this.height_}getRight(){return this.getLeft()+this.getWidth()}getBottom(){return this.getTop()+this.getHeight()}setParameters(params){}onLoadLogStart(polledData,tabData,logDump){}onLoadLogFinish(polledData,tabData,logDump){return false}}export class DivView extends View{constructor(divId){super();this.node_=$(divId);if(!this.node_){throw new Error("Element "+divId+" not found")}this.width_=this.node_.offsetWidth;this.height_=this.node_.offsetHeight;this.isVisible_=this.node_.style.display!=="none"}setGeometry(left,top,width,height){super.setGeometry(this,left,top,width,height);this.node_.style.position="absolute";setNodePosition(this.node_,left,top,width,height)}show(isVisible){super.show(isVisible);setNodeDisplay(this.node_,isVisible)}getNode(){return this.node_}}export class WindowView extends View{constructor(childView){super();this.childView_=childView;window.addEventListener("resize",this.resetGeometry.bind(this),true)}setGeometry(left,top,width,height){super.setGeometry(this,left,top,width,height);this.childView_.setGeometry(left,top,width,height)}show(){super.show(isVisible);this.childView_.show(isVisible)}resetGeometry(){this.setGeometry(0,0,document.documentElement.clientWidth,document.documentElement.clientHeight)}}export class VerticalSplitView extends View{constructor(topView,bottomView){super();this.topView_=topView;this.bottomView_=bottomView}setGeometry(left,top,width,height){super.setGeometry(this,left,top,width,height);const fixedHeight=this.topView_.getHeight();this.topView_.setGeometry(left,top,width,fixedHeight);this.bottomView_.setGeometry(left,top+fixedHeight,width,height-fixedHeight)}show(isVisible){super.show(isVisible);this.topView_.show(isVisible);this.bottomView_.show(isVisible)}}export class HorizontalSplitView extends View{constructor(leftView,rightView){super();this.leftView_=leftView;this.rightView_=rightView}setGeometry(left,top,width,height){super.setGeometry(left,top,width,height);const fixedWidth=this.leftView_.getWidth();this.leftView_.setGeometry(left,top,fixedWidth,height);this.rightView_.setGeometry(left+fixedWidth,top,width-fixedWidth,height)}show(isVisible){super.show(isVisible);this.leftView_.show(isVisible);this.rightView_.show(isVisible)}}