import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style>:host{height:100%;width:100%}:host([is-selecting-text]){cursor:text}#textRenderCanvas{visibility:hidden}.background-image{position:absolute;pointer-events:none;user-select:none;z-index:0}.translated-line,.word{cursor:text;opacity:0;pointer-events:all;position:absolute;user-select:none}.translated-line{align-items:center;display:flex;flex-wrap:nowrap;opacity:100%;pointer-events:none;white-space:pre;z-index:1}.translated-word{cursor:text;pointer-events:all;user-select:none}:host([debug-mode]) .translated-line{border:1px solid orange}:host([debug-mode]) .translated-word{border:1px solid teal}:host([debug-mode]) .word{border:1px solid blue;opacity:50%}:host(:not([should-render-translate-words])) .translated-line,:host(:not([should-render-translate-words])) .background-image{display:none}.highlighted-line{position:absolute;background-color:var(--color-shader-layer-3);opacity:60%;z-index:1}@media (forced-colors:active){.highlighted-line{background-color:Highlight}}</style>
<template id="wordsContainer" is="dom-repeat" items="[[renderedWords]]"
  index-as="wordIndex">
  <div
    style$="[[getWordStyle(item, wordIndex, shouldRenderTranslateWords, selectionOverlayRect)]]"
    class="word"
    on-pointerenter="handlePointerEnter" on-pointerleave="handlePointerLeave">
  </div>
</template>
<template id="translateContainer" is="dom-repeat"
  items="[[renderedTranslateLines]]" as="translatedLineData"
  index-as="lineIndex">
  <template is="dom-if" if="[[translatedLineData.line.backgroundImageData]]">
    <img class="background-image"
      style$="[[getBackgroundImageDataStyle(translatedLineData,selectionOverlayRect)]]"
      src="[[getBlobUrlFromImageData(translatedLineData.line.backgroundImageData)]]">
  </template>
  <div
    style$="[[getTranslatedLineStyle(translatedLineData,selectionOverlayRect)]]"
    class="translated-line">
    <template is="dom-repeat" items="[[translatedLineData.words]]"
      as="translatedWordData" index-as="wordIndex">
      <span class="translated-word"
        data-line-index$="[[lineIndex]]"
        data-word-index$="[[translatedWordData.index]]"
        lang$="[[currentTranslateLanguage]]">[[translatedWordData.word.plainText]][[translatedWordData.word.textSeparator]]</span>
    </template>
  </div>
</template>
<template is="dom-repeat" items="[[highlightedLines]]">
  <div style$="[[getHighlightedLineStyle(item)]]" class="highlighted-line">
  </div>
</template>
<canvas id="textRenderCanvas"></canvas>
<!--_html_template_end_-->`;
}
