// chrome/browser/lens/core/mojom/text.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  GeometrySpec as lens_mojom_GeometrySpec,
  Geometry as lens_mojom_Geometry
} from './geometry.mojom-webui.js';
import {
  BigBufferSpec as mojoBase_mojom_BigBufferSpec,
  BigBuffer as mojoBase_mojom_BigBuffer
} from '//resources/mojo/mojo/public/mojom/base/big_buffer.mojom-webui.js';
import {
  SkColorSpec as skia_mojom_SkColorSpec,
  SkColor as skia_mojom_SkColor
} from '//resources/mojo/skia/public/mojom/skcolor.mojom-webui.js';
import {
  SizeSpec as gfx_mojom_SizeSpec,
  Size as gfx_mojom_Size
} from '//resources/mojo/ui/gfx/geometry/mojom/geometry.mojom-webui.js';





export const WritingDirectionSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum WritingDirection {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kLeftToRight = 0,
  kRightToLeft = 1,
  kTopToBottom = 2,
}

export const AlignmentSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum Alignment {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kDefaultLeftAlgined = 0,
  kRightAligned = 1,
  kCenterAligned = 2,
}


export const TextSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TextLayoutSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WordSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LineSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BackgroundImageDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TranslatedLineSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TranslatedParagraphSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ParagraphSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const FormulaMetadataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface TextMojoType {
  textLayout: (TextLayout | null);
  contentLanguage: (string | null);
}


export type Text = TextMojoType;
mojo.internal.Struct<TextMojoType>(
    TextSpec.$,
    'Text',
    [
      mojo.internal.StructField<TextMojoType, TextLayout>(
        'textLayout', 0,
        0,
        TextLayoutSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TextMojoType, string>(
        'contentLanguage', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface TextLayoutMojoType {
  paragraphs: Paragraph[];
}


export type TextLayout = TextLayoutMojoType;
mojo.internal.Struct<TextLayoutMojoType>(
    TextLayoutSpec.$,
    'TextLayout',
    [
      mojo.internal.StructField<TextLayoutMojoType, Paragraph[]>(
        'paragraphs', 0,
        0,
        mojo.internal.Array(ParagraphSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WordMojoType {
  plainText: string;
  textSeparator: (string | null);
  geometry: (lens_mojom_Geometry | null);
  writingDirection: (WritingDirection | null);
  formulaMetadata: (FormulaMetadata | null);
}


export type Word = WordMojoType;
mojo.internal.Struct<WordMojoType>(
    WordSpec.$,
    'Word',
    [
      mojo.internal.StructField<WordMojoType, string>(
        'plainText', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WordMojoType, string>(
        'textSeparator', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WordMojoType, lens_mojom_Geometry>(
        'geometry', 16,
        0,
        lens_mojom_GeometrySpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WordMojoType, boolean>(
        'writing_direction_$flag', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "writing_direction_$value",
          originalFieldName: "writingDirection",
        },
        undefined,
    ),
      mojo.internal.StructField<WordMojoType, WritingDirection>(
        'writing_direction_$value', 28,
        0,
        WritingDirectionSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "writingDirection",
        },
        undefined,
    ),
      mojo.internal.StructField<WordMojoType, FormulaMetadata>(
        'formulaMetadata', 32,
        0,
        FormulaMetadataSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface LineMojoType {
  words: Word[];
  geometry: (lens_mojom_Geometry | null);
}


export type Line = LineMojoType;
mojo.internal.Struct<LineMojoType>(
    LineSpec.$,
    'Line',
    [
      mojo.internal.StructField<LineMojoType, Word[]>(
        'words', 0,
        0,
        mojo.internal.Array(WordSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LineMojoType, lens_mojom_Geometry>(
        'geometry', 8,
        0,
        lens_mojom_GeometrySpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface BackgroundImageDataMojoType {
  backgroundImage: mojoBase_mojom_BigBuffer;
  imageSize: gfx_mojom_Size;
  verticalPadding: number;
  horizontalPadding: number;
  textMask: mojoBase_mojom_BigBuffer;
}


export type BackgroundImageData = BackgroundImageDataMojoType;
mojo.internal.Struct<BackgroundImageDataMojoType>(
    BackgroundImageDataSpec.$,
    'BackgroundImageData',
    [
      mojo.internal.StructField<BackgroundImageDataMojoType, mojoBase_mojom_BigBuffer>(
        'backgroundImage', 0,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundImageDataMojoType, gfx_mojom_Size>(
        'imageSize', 16,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundImageDataMojoType, number>(
        'verticalPadding', 24,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundImageDataMojoType, number>(
        'horizontalPadding', 28,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundImageDataMojoType, mojoBase_mojom_BigBuffer>(
        'textMask', 32,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 56],]);





export interface TranslatedLineMojoType {
  words: Word[];
  translation: string;
  textColor: skia_mojom_SkColor;
  backgroundPrimaryColor: skia_mojom_SkColor;
  backgroundImageData: (BackgroundImageData | null);
  geometry: (lens_mojom_Geometry | null);
}


export type TranslatedLine = TranslatedLineMojoType;
mojo.internal.Struct<TranslatedLineMojoType>(
    TranslatedLineSpec.$,
    'TranslatedLine',
    [
      mojo.internal.StructField<TranslatedLineMojoType, Word[]>(
        'words', 0,
        0,
        mojo.internal.Array(WordSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TranslatedLineMojoType, string>(
        'translation', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TranslatedLineMojoType, skia_mojom_SkColor>(
        'textColor', 16,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TranslatedLineMojoType, skia_mojom_SkColor>(
        'backgroundPrimaryColor', 24,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TranslatedLineMojoType, BackgroundImageData>(
        'backgroundImageData', 32,
        0,
        BackgroundImageDataSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TranslatedLineMojoType, lens_mojom_Geometry>(
        'geometry', 40,
        0,
        lens_mojom_GeometrySpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 56],]);





export interface TranslatedParagraphMojoType {
  lines: TranslatedLine[];
  resizedBitmapSize: gfx_mojom_Size;
  alignment: (Alignment | null);
  writingDirection: (WritingDirection | null);
  contentLanguage: (string | null);
}


export type TranslatedParagraph = TranslatedParagraphMojoType;
mojo.internal.Struct<TranslatedParagraphMojoType>(
    TranslatedParagraphSpec.$,
    'TranslatedParagraph',
    [
      mojo.internal.StructField<TranslatedParagraphMojoType, TranslatedLine[]>(
        'lines', 0,
        0,
        mojo.internal.Array(TranslatedLineSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TranslatedParagraphMojoType, gfx_mojom_Size>(
        'resizedBitmapSize', 8,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TranslatedParagraphMojoType, boolean>(
        'alignment_$flag', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "alignment_$value",
          originalFieldName: "alignment",
        },
        undefined,
    ),
      mojo.internal.StructField<TranslatedParagraphMojoType, Alignment>(
        'alignment_$value', 20,
        0,
        AlignmentSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "alignment",
        },
        undefined,
    ),
      mojo.internal.StructField<TranslatedParagraphMojoType, boolean>(
        'writing_direction_$flag', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "writing_direction_$value",
          originalFieldName: "writingDirection",
        },
        undefined,
    ),
      mojo.internal.StructField<TranslatedParagraphMojoType, WritingDirection>(
        'writing_direction_$value', 24,
        0,
        WritingDirectionSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "writingDirection",
        },
        undefined,
    ),
      mojo.internal.StructField<TranslatedParagraphMojoType, string>(
        'contentLanguage', 32,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface ParagraphMojoType {
  lines: Line[];
  translation: (TranslatedParagraph | null);
  geometry: (lens_mojom_Geometry | null);
  writingDirection: (WritingDirection | null);
  contentLanguage: (string | null);
}


export type Paragraph = ParagraphMojoType;
mojo.internal.Struct<ParagraphMojoType>(
    ParagraphSpec.$,
    'Paragraph',
    [
      mojo.internal.StructField<ParagraphMojoType, Line[]>(
        'lines', 0,
        0,
        mojo.internal.Array(LineSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ParagraphMojoType, TranslatedParagraph>(
        'translation', 8,
        0,
        TranslatedParagraphSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ParagraphMojoType, lens_mojom_Geometry>(
        'geometry', 16,
        0,
        lens_mojom_GeometrySpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ParagraphMojoType, boolean>(
        'writing_direction_$flag', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "writing_direction_$value",
          originalFieldName: "writingDirection",
        },
        undefined,
    ),
      mojo.internal.StructField<ParagraphMojoType, WritingDirection>(
        'writing_direction_$value', 28,
        0,
        WritingDirectionSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "writingDirection",
        },
        undefined,
    ),
      mojo.internal.StructField<ParagraphMojoType, string>(
        'contentLanguage', 32,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface FormulaMetadataMojoType {
  latex: (string | null);
}


export type FormulaMetadata = FormulaMetadataMojoType;
mojo.internal.Struct<FormulaMetadataMojoType>(
    FormulaMetadataSpec.$,
    'FormulaMetadata',
    [
      mojo.internal.StructField<FormulaMetadataMojoType, string>(
        'latex', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



