import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><link rel="stylesheet" href="//resources/css/text_defaults_md.css" />
<style>:host{--cursor-img-url:url("lens.svg");align-items:center;display:flex;height:100%;justify-content:center;pointer-events:none;width:100%}#selectionOverlay{cursor:crosshair;display:grid;pointer-events:all;position:relative;user-select:none;-webkit-user-drag:none;-webkit-user-select:none}:host([translate-mode-enabled]) #selectionOverlay{cursor:text}:host([is-initial-size]) #backgroundImageCanvas{animation:initial-blur-animation 700ms cubic-bezier(0.2,0,0,1),initial-inset-animation 400ms cubic-bezier(0.05,0.7,0.1,1),initial-scale-animation 400ms cubic-bezier(0.05,0.7,0.1,1);position:relative}:host([is-resized]) #backgroundImageCanvas{border-radius:16px}:host([is-resized]) #selectionElements{border-radius:16px;position:relative;overflow:hidden}#selectionOverlay>*{grid-column:1;grid-row:1;pointer-events:none}:host([suppress-copy-and-save-as-image]) .copy-as-image-context-menu-item,:host([suppress-copy-and-save-as-image]) .save-as-image-context-menu-item,:host(:not([enable-copy-as-image])) .copy-as-image-context-menu-item,:host(:not([enable-save-as-image])) .save-as-image-context-menu-item,:host(:not([show-detected-text-context-menu-options])) .detected-text-context-menu-option,:host(:not([show-translate-context-menu-item])) .translate-context-menu-item,:host([disable-shimmer]) #overlayShimmerCanvas,:host([disable-shimmer]) #overlayShimmer{display:none}:host([shimmer-on-segmentation]) #objectSelectionLayer,:host([shimmer-on-segmentation]) #overlayShimmer,:host([shimmer-on-segmentation][shimmer-fade-out-complete]) #overlayShimmerCanvas{z-index:4}:host([translate-mode-enabled]) #objectSelectionLayer{visibility:hidden}:host([translate-mode-enabled]) #regionSelectionLayer{visibility:hidden}#backgroundImageCanvas{outline:6vmax outset rgba(0,0,0,0.3);visibility:hidden}:host([is-screenshot-rendered]) #backgroundImageCanvas{visibility:visible}:host([is-resized]) #backgroundImageCanvas{outline:none}#selectionElements{background-color:rgba(var(--color-scrim-rgb),0.05)}:host([translate-mode-enabled]) #selectionElements{background-color:transparent}#selectionOverlay :not(#backgroundImageCanvas){transition:opacity 150ms linear}:host([is-closing]) #selectionOverlay :not(#backgroundImageCanvas){opacity:0}:host([is-initial-size]) #initialFlashScrim{animation:initial-inset-animation 400ms cubic-bezier(0.05,0.7,0.1,1),initial-scale-animation 400ms cubic-bezier(0.05,0.7,0.1,1),initial-flash-animation 700ms cubic-bezier(0.2,0,0,1);background-color:rgb(255,255,255);height:100%;max-height:100vh;max-width:100vw;opacity:0%;width:100%}#extraScrim{background-color:var(--color-scrim);opacity:0%;transition:opacity 0.8s ease-out;pointer-events:none}:host([darken-extra-scrim]) #extraScrim{opacity:10%}#selectionElements>*{inset:0;position:absolute}#closeButton{--cr-icon-button-icon-size:20px;--cr-icon-button-size:36px;--cr-icon-button-fill-color:white;--cr-icon-image:url("icon_clear.svg");background-color:#00000099;height:36px;inset-inline-end:-10px;margin-inline-end:0;margin-inline-start:0;pointer-events:all;position:absolute;top:-10px;width:36px;z-index:6}:host(:not([side-panel-opened])) #closeButton{display:none}#cursor{align-items:center;background:var(--color-selection-element);border-radius:16px 100px 100px 100px;box-shadow:0px 4px 12px 0px rgba(27,28,20,0.24);display:flex;height:32px;justify-content:center;left:0;pointer-events:none;position:fixed;top:0;transform:scale(0);width:32px;z-index:6}#cursorImg{background-color:var(--color-primary);height:100%;mask-image:var(--cursor-img-url);mask-position:center;mask-repeat:no-repeat;mask-size:20px;width:100%}#cursor.hidden{visibility:hidden}:host([is-closing]) #cursor{visibility:hidden}#contextMenuOverlay{height:100%;position:relative;width:100%}.context-menu{align-items:flex-start;animation:scale-out 150ms cubic-bezier(0.2,0,0,1);background:var(--color-selection-element);border-radius:8px;box-shadow:0px 2px 6px 0px rgba(60,64,67,0.16);cursor:default;display:flex;flex-direction:column;justify-content:center;opacity:0;padding:8px 0px;pointer-events:auto;position:absolute;visibility:hidden;transition:opacity 150ms,visibility 150ms;z-index:6}#copyToast{justify-content:space-between}:host([show-selected-text-context-menu]) #selectedTextContextMenu,:host([show-selected-region-context-menu]) #selectedRegionContextMenu{animation:scale-in 250ms cubic-bezier(0.2,0,0,1);opacity:1;visibility:visible}.context-menu-item{align-items:center;align-self:stretch;display:flex;gap:12px;min-height:36px;padding:0 16px}.context-menu-item:hover{background-color:rgba(var(--color-scrim-rgb),0.05)}.context-menu-item:active{background-color:rgba(var(--color-scrim-rgb),0.1)}.menu-item-icon{background-color:var(--color-primary);height:20px;mask-position:center;mask-repeat:no-repeat;mask-size:100%;min-width:20px;width:20px}.menu-item-icon.copy{mask-image:url("copy.svg")}.menu-item-icon.copy-image{mask-image:url("copy_image.svg")}.menu-item-icon.download{mask-image:url("download.svg")}.menu-item-icon.translate{mask-image:url("translate.svg")}.menu-item-icon.text{mask-image:url("text.svg")}.menu-item-label{color:var(--color-scrim);font-size:13px;font-style:normal;font-weight:500;line-height:normal;padding-block-end:3px;padding-block-start:3px}@media (forced-colors:active){#cursor{background:ButtonFace;border:1px solid ButtonBorder}#cursorImg,.menu-item-icon{background-color:ButtonText}}@keyframes initial-inset-animation{50%{animation-timing-function:cubic-bezier(0.2,0,0,1);border-radius:8px}to{border-radius:0px}}@keyframes initial-blur-animation{28.6%{filter:blur(2.5px)}to{filter:none}}@keyframes initial-flash-animation{28.6%{opacity:30%}to{opacity:0%}}@keyframes initial-scale-animation{50%{scale:98%}to{scale:100%}}@keyframes scale-in{from{transform:scale(0)}to{transform:scale(1)}}@keyframes scale-out{from{transform:scale(1)}to{transform:scale(0.8)}}</style>
<div
  id="selectionOverlay"
  on-pointerenter="handlePointerEnter"
  on-pointerleave="handlePointerLeave"
>
  <cr-icon-button id="closeButton" on-click="onCloseButtonClick"
    aria-label="$i18n{close}" title="$i18n{close}"
    on-pointerenter="handlePointerEnterButton"
    on-pointerleave="handlePointerLeaveButton"
  ></cr-icon-button>
  <canvas
    id="backgroundImageCanvas"
    style$="height: [[canvasHeight]]px; width: [[canvasWidth]]px;"
  ></canvas>
  <!-- Wrapper div is needed to stack the selection elements on top of
  background image. -->
  <div id="selectionElements">
    <!-- Other elements that need to be bounded to the image go here -->
    <div id="extraScrim"></div>
    <overlay-shimmer-canvas
      hidden$="[[disableShimmer || enableBorderGlow]]"
      theme="[[theme]]"
      id="overlayShimmerCanvas"
    ></overlay-shimmer-canvas>
    <template is="dom-if" if="[[enableBorderGlow]]">
      <overlay-border-glow
        id="overlayBorderGlow"
        selection-overlay-rect="[[selectionOverlayRect]]"
      ></overlay-border-glow>
    </template>
    <post-selection-renderer
      id="postSelectionRenderer"
      selection-overlay-rect="[[selectionOverlayRect]]"
      region-selected-glow-enabled="[[enableRegionSelectedGlow]]"
    >
    </post-selection-renderer>
    <lens-object-layer
      id="objectSelectionLayer"
      screenshot-data-uri="[[screenshotDataUri]]"
      theme="[[theme]]"
    >
    </lens-object-layer>
    <region-selection
      id="regionSelectionLayer"
      theme="[[theme]]"
      screenshot-data-uri="[[screenshotDataUri]]"
      selection-overlay-rect="[[selectionOverlayRect]]"
      border-glow-enabled="[[enableBorderGlow]]"
    ></region-selection>
    <lens-simplified-text-layer
      id="textLayer"
      selection-overlay-rect="[[selectionOverlayRect]]">
    </lens-simplified-text-layer>
  </div>
  <div id="initialFlashScrim"></div>
  <div id="contextMenuOverlay">
    <div
      id="selectedRegionContextMenu"
      class="context-menu"
      role="menu"
      style$="[[selectedRegionContextMenuHorizontalStyle]]
                [[selectedRegionContextMenuVerticalStyle]]"
      on-pointerenter="handlePointerEnterButton"
      on-pointerleave="handlePointerLeaveButton"
    >
      <div
        id="copyDetectedTextContextMenuItem"
        class="context-menu-item detected-text-context-menu-option"
        role="menuitem" tabindex="0" on-pointerup="handleCopyDetectedText"
        on-keyup="handleCopyDetectedText"
      >
        <span class="menu-item-icon copy"></span>
        <span class="menu-item-label">$i18n{copyText}</span>
      </div>
      <div
        class="context-menu-item translate-context-menu-item detected-text-context-menu-option"
        role="menuitem" tabindex="0" on-pointerup="handleTranslateDetectedText"
        on-keyup="handleTranslateDetectedText"
      >
        <span class="menu-item-icon translate"></span>
        <span class="menu-item-label">$i18n{translate}</span>
      </div>
      <div
        class="context-menu-item copy-as-image-context-menu-item"
        role="menuitem" tabindex="0" on-pointerup="handleCopyAsImage"
        on-keyup="handleCopyAsImage"
      >
        <span class="menu-item-icon copy-image"></span>
        <span class="menu-item-label">$i18n{copyAsImage}</span>
      </div>
      <div
        class="context-menu-item save-as-image-context-menu-item"
        role="menuitem" tabindex="0" on-pointerup="handleSaveAsImage"
        on-keyup="handleSaveAsImage"
      >
        <span class="menu-item-icon download"></span>
        <span class="menu-item-label">$i18n{saveAsImage}</span>
      </div>
    </div>
  </div>
</div>
<div id="cursor" class$="[[getHiddenCursorClass(isPointerInside, currentGesture.state)]]">
  <div id="cursorImg"></div>
</div>
<!--_html_template_end_-->`;
}