import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="searchbox-shared-style">:host{--cr-searchbox-min-width:250px}:host([is-searchbox-focused]){--cr-searchbox-min-width:306px}:host(:not([is-translate-button-enabled])){--cr-searchbox-min-width:306px}.app-container{height:100%;width:100%}#backgroundScrim{background-color:rgba(0,0,0,0.3);cursor:default;forced-color-adjust:none;inset:0;position:absolute}.button-container{display:flex;pointer-events:none;position:absolute}:host(:not([enable-csb-motion-tweaks])) .button-container,:host(:not([enable-csb-motion-tweaks])) #searchboxContainer{transition:opacity 150ms,visibility 150ms}.button-container,#searchboxContainer{z-index:6}#searchboxContainer{animation:searchboxGrow 300ms ease forwards;transform-origin:right;animation-delay:350ms}:host([enable-csb-motion-tweaks]) #searchboxContainer{animation:searchboxEnter 483ms cubic-bezier(0,0,0,1) forwards;animation-delay:0ms;border-bottom-left-radius:26px;border-bottom-right-radius:26px;height:100%;overflow:clip;overflow-clip-margin:26px;opacity:0;padding-bottom:8px;transform-origin:top}:host([enable-csb-motion-tweaks]) cr-searchbox{display:block}@keyframes searchboxGrow{0%{transform:scaleX(.5)}100%{transform:scaleX(1)}}@keyframes searchboxEnter{0%{opacity:0;transform:scale(0.9,0.75)}100%{opacity:1;transform:scale(1,1)}}:host([should-fade-out-buttons]) .button-container,:host(:not([initial-flash-animation-has-ended]):not([enable-csb-motion-tweaks])) .button-container,:host(:not([initial-flash-animation-has-ended]):not([enable-csb-motion-tweaks])) #searchboxContainer{opacity:0;visibility:hidden}#optionsButtonContainer{gap:12px;inset-block-start:34px;inset-inline-end:28px}:host([is-lens-overlay-contextual-searchbox-enabled]) #optionsButtonContainer{inset-block-start:40px}:host([side-panel-opened]) #optionsButtonContainer{inset-inline-end:24px}#translateButtonContainer{inset-block-start:28px;inset-inline-end:135px}:host([side-panel-opened]) #translateButtonContainer{inset-inline-end:84px}:host([is-lens-overlay-contextual-searchbox-enabled]) #translateButtonContainer{inset-inline-end:84px;inset-block-start:40px}:host([is-lens-overlay-contextual-searchbox-enabled][side-panel-opened]) #translateButtonContainer{inset-inline-end:24px}:host(:not([is-translate-button-enabled])) #translateButtonContainer{display:none}:host([is-searchbox-focused]) #translateButtonContainer{z-index:-1}#translateButtonContainer.searchbox-unfocused{transition:opacity 50ms linear,visibility 50ms linear;transition-delay:80ms}.action-button{--cr-icon-button-icon-size:24px;--cr-icon-button-size:36px;--cr-icon-button-fill-color:var(--color-overlay-icon);background-color:rgba(var(--color-scrim-rgb),0.6);margin-inline-end:0;margin-inline-start:0;pointer-events:all}#closeButton{--cr-icon-image:url("icon_clear.svg")}:host([is-lens-overlay-contextual-searchbox-enabled]) #closeButton{background-color:var(--color-selection-element);height:48px;width:48px;--cr-icon-button-fill-color:var(--color-primary)}:host([is-lens-overlay-contextual-searchbox-enabled][enable-csb-motion-tweaks]) #closeButton{transition:none;opacity:0}:host([can-animate-in-close-button][enable-csb-motion-tweaks]) #closeButton{animation:closeButtonEnter 483ms cubic-bezier(0,0,0,1) forwards;transition:inherit}@keyframes closeButtonEnter{0%{opacity:0;transform:scale(0.85)}100%{opacity:1;transform:scale(1)}}:host([is-lens-overlay-contextual-searchbox-enabled][enable-close-button-tweaks]) #closeButton{--cr-icon-button-icon-size:20px;--cr-icon-button-size:36px;--cr-icon-button-fill-color:white;background-color:#00000099;height:36px;width:36px}:host([is-lens-overlay-contextual-searchbox-enabled][enable-close-button-tweaks]) #optionsButtonContainer{inset-block-start:58px;inset-inline-end:26px}:host([side-panel-opened]) #closeButton{display:none}#toast{justify-content:space-between;z-index:7}:host([is-lens-overlay-contextual-searchbox-enabled]) #moreOptions{display:none}#moreOptions{width:156px}#moreOptionsButton{margin-inline-start:120px}#moreOptionsMenu{background:var(--color-selection-element);border-radius:8px;cursor:default;display:none;margin-top:8px;padding:8px 0px;pointer-events:all}:host([more-options-menu-visible]) #moreOptionsMenu{display:flex;flex-direction:column}.menu-item{align-items:center;display:flex;padding-inline-start:16px;height:36px}.menu-item:focus,.menu-item:hover{background-color:rgba(var(--color-scrim-rgb),0.05)}.menu-item:active{background-color:rgba(var(--color-scrim-rgb),0.10)}.menu-item-label{color:var(--color-scrim);font-size:13px;font-style:normal;font-weight:500;line-height:normal}.menu-item-icon{background-color:var(--color-primary);height:20px;mask-position:center;mask-repeat:no-repeat;mask-size:100%;width:20px;margin-inline-end:12px}.feedback{mask-image:url("feedback.svg")}.activity{mask-image:url("//resources/cr_components/searchbox/icons/google_g_cr23.svg")}.learn-more{mask-image:url("learn_more.svg")}:host(:not([is-image-rendered])) lens-selection-overlay{display:none}.app-container :not(lens-selection-overlay){transition:opacity 150ms linear}:host([is-closing]) .app-container :not(lens-selection-overlay){opacity:0}:host([is-closing]) cursor-tooltip{display:none}cursor-tooltip{left:0;position:fixed;top:0;transform:scale(0);width:100%;z-index:6}initial-gradient{pointer-events:none}#searchboxContainer{--color-searchbox-background:#FFFFFF;--color-searchbox-background-hovered:#FFFFFF;--color-searchbox-results-background:#ffffffff;--color-searchbox-google-g-background:var(--color-primary);--cr-searchbox-height:48px;--cr-searchbox-icon-size-in-searchbox:28px;--cr-searchbox-icon-top-position:0px;--color-searchbox-ghost-loader-loading-bar-1:#F1F3F4;--color-searchbox-ghost-loader-loading-bar-2:#ECEDEF;pointer-events:none;position:absolute;inset-block-start:40px;inset-inline-end:140px}#searchboxContainer>*{pointer-events:all}:host(:not([is-translate-button-enabled])) #searchboxContainer{inset-inline-end:84px}:host([show-ghost-loader]) #searchboxContainer{--color-searchbox-background:var(--color-searchbox-results-background)}:host([is-searchbox-focused]) #searchboxContainer{inset-inline-end:84px;--cr-searchbox-height:52px;inset-block-start:38px}:host(:not([enable-csb-motion-tweaks])) #searchboxContainer{transition:inset-inline-end 200ms ease}#searchbox{transition:width 200ms ease}:host(:not([is-lens-overlay-contextual-searchbox-visible])) #searchboxContainer,:host([search-box-hidden]) #searchboxContainer{display:none}:host([enable-close-button-tweaks]) #searchboxContainer{inset-block-start:48px;inset-inline-end:72px;--cr-searchbox-height:52px}cr-searchbox-ghost-loader{display:none;position:absolute;inset-inline-start:0;inset-inline-end:0;top:0}:host([show-ghost-loader]) #searchboxContainer:has(cr-searchbox:not([dropdown-is-visible])) cr-searchbox-ghost-loader{display:block}:host([enable-csb-motion-tweaks][show-ghost-loader]) cr-searchbox-ghost-loader{display:block}:host([enable-csb-motion-tweaks]:not([is-searchbox-focused])) cr-searchbox-ghost-loader{animation:ghost-loader-enter-animation 483ms cubic-bezier(0,0,0,1) forwards}@keyframes ghost-loader-enter-animation{0%{transform:translateY(-10px)}100%{transform:translateY(0px)}}:host([enable-csb-motion-tweaks][show-ghost-loader]) cr-searchbox::part(searchbox-dropdown){opacity:0;display:block}:host([enable-csb-motion-tweaks][show-ghost-loader]) #searchboxContainer:has(cr-searchbox[dropdown-is-visible]) cr-searchbox::part(searchbox-dropdown){transition:opacity 400ms cubic-bezier(0.4,0,0.2,1);opacity:1}@media (forced-colors:active){.menu-item-icon{background-color:ButtonText}}</style>
<div class="app-container"
    on-initial-flash-animation-end="onInitialFlashAnimationEnd"
    on-screenshot-rendered="onScreenshotRendered"
    on-selection-started="handleSelectionStarted"
    on-selection-finished="handleSelectionFinished"
    on-pointerenter="handlePointerEnter"
    on-pointerleave="handlePointerLeave"
    on-escape-searchbox="handleEscapeSearchbox"
    style="
    --color-primary: [[skColorToHex_(theme.primary)]];
    --color-shader-layer-1: [[skColorToHex_(theme.shaderLayer1)]];
    --color-shader-layer-2: [[skColorToHex_(theme.shaderLayer2)]];
    --color-shader-layer-3: [[skColorToHex_(theme.shaderLayer3)]];
    --color-shader-layer-4: [[skColorToHex_(theme.shaderLayer4)]];
    --color-shader-layer-5: [[skColorToHex_(theme.shaderLayer5)]];
    --color-scrim: [[skColorToHex_(theme.scrim)]];
    --color-scrim-rgb: [[skColorToRgb_(theme.scrim)]];
    --color-surface-container-highest-light: [[skColorToHex_(theme.surfaceContainerHighestLight)]];
    --color-surface-container-highest-dark: [[skColorToHex_(theme.surfaceContainerHighestDark)]];
    --color-selection-element: [[skColorToHex_(theme.selectionElement)]];
    --color-overlay-icon: white;
    --color-overlay-button-label: white;
    --color-text-highlight: white;
    --color-text-highlight-actioned: #A6C8FF99">
  <cr-toast id="toast" duration="4000">
    <div>[[toastMessage]]</div>
    <cr-button on-click="onHideToastClick">
      $i18n{dismiss}
    </cr-button>
  </cr-toast>
  <div id="backgroundScrim" on-click="onBackgroundScrimClicked"
      hidden$="[[!isImageRendered]]"
      on-pointerenter="handlePointerEnterBackgroundScrim"
      on-pointerleave="handlePointerLeaveBackgroundScrim"></div>
  <lens-selection-overlay id="selectionOverlay" theme="[[theme]]"
      is-searchbox-focused="[[isSearchboxFocused]]"
      are-language-pickers-open="[[areLanguagePickersOpen]]"
      on-pointerenter="handlePointerEnterSelectionOverlay"
      on-pointerleave="handlePointerLeaveSelectionOverlay">
  </lens-selection-overlay>
  <initial-gradient id="initialGradient"></initial-gradient>
  <div id="searchboxContainer" on-focusout="handleSearchboxBlurred">
    <cr-searchbox
      id="searchbox"
      on-focusin="handleSearchboxFocused"
      placeholder-text="{{placeholderText}}"
      searchbox-aria-description="[[getSearchboxAriaDescription(showErrorState, showGhostLoader)]]">
    </cr-searchbox>
    <cr-searchbox-ghost-loader
      id="searchboxGhostLoader"
      tabindex="-1"
      show-error-state="{{showErrorState}}"
      page-content-type="[[pageContentType]]"
      suggestion-count="[[searchboxSuggestionCount]]">
    </cr-searchbox-ghost-loader>
  </div>
  <div id="translateButtonContainer" class="button-container">
    <translate-button id="translateButton"
      is-lens-overlay-contextual-searchbox-enabled="[[isLensOverlayContextualSearchboxEnabled]]">
    </translate-button>
  </div>
  <div id="optionsButtonContainer" class="button-container">
    <div id="moreOptions">
      <cr-icon-button iron-icon="cr:more-vert" id="moreOptionsButton"
          class="action-button" on-click="onMoreOptionsButtonClick"
          role="button" aria-label="$i18n{moreOptions}"
          aria-controls="moreOptionsMenu" aria-haspopup="menu"
          aria-expanded="[[moreOptionsMenuVisible]]" title="$i18n{moreOptions}">
      </cr-icon-button>
      <div id="moreOptionsMenu" role="menu" aria-labelledby="moreOptionsButton">
        <div class="menu-item" on-click="onMyActivityClick"
            on-keydown="onMyActivityClick" role="menuitem" tabindex="0"
            aria-labelledby="myActivity">
          <span class="menu-item-icon activity"></span>
          <span id="myActivity"
              class="menu-item-label">$i18n{myActivity}</span>
        </div>
        <div class="menu-item" on-click="onLearnMoreClick"
            on-keydown="onLearnMoreClick" role="menuitem" tabindex="0"
            aria-labelledby="learnMore">
          <span class="menu-item-icon learn-more"></span>
          <span id="learnMore"
              class="menu-item-label">$i18n{learnMore}</span>
        </div>
        <div class="menu-item" on-click="onFeedbackClick"
            on-keydown="onFeedbackClick" role="menuitem" tabindex="0"
            aria-labelledby="sendFeedback">
          <span class="menu-item-icon feedback"></span>
          <span id="sendFeedback"
              class="menu-item-label">$i18n{sendFeedback}</span>
        </div>
      </div>
    </div>
    <cr-icon-button id="closeButton" class="action-button"
        on-click="onCloseButtonClick" aria-label="$i18n{close}"
        title="$i18n{close}"></cr-icon-button>
  </div>
  <cursor-tooltip id="cursorTooltip"></cursor-tooltip>
</div>
<!--_html_template_end_-->`;
}