// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import{assert}from"//resources/js/assert.js";import{EventTracker}from"//resources/js/event_tracker.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{BrowserProxyImpl}from"./browser_proxy.js";import{findWordsInRegion}from"./find_words_in_region.js";import{SemanticEvent}from"./lens.mojom-webui.js";import{recordLensOverlaySemanticEvent}from"./metrics_utils.js";import{getCss}from"./simplified_text_layer.css.js";import{getHtml}from"./simplified_text_layer.html.js";import{createHighlightedLines}from"./text_highlights.js";import{getTextSeparator,isWordRenderable,translateWords}from"./text_rendering.js";import{toPercent}from"./values_converter.js";export class SimplifiedTextLayerElement extends CrLitElement{static get is(){return"lens-simplified-text-layer"}static get properties(){return{hasActionedText:{type:Boolean,reflect:true},hideHighlightedLines:{type:Boolean,reflect:true},highlightedLines:{type:Array}}}static get styles(){return getCss()}render(){return getHtml.bind(this)()}#hasActionedText_accessor_storage=false;get hasActionedText(){return this.#hasActionedText_accessor_storage}set hasActionedText(value){this.#hasActionedText_accessor_storage=value}#hideHighlightedLines_accessor_storage=true;get hideHighlightedLines(){return this.#hideHighlightedLines_accessor_storage}set hideHighlightedLines(value){this.#hideHighlightedLines_accessor_storage=value}#highlightedLines_accessor_storage=[];get highlightedLines(){return this.#highlightedLines_accessor_storage}set highlightedLines(value){this.#highlightedLines_accessor_storage=value}fullTextResponse=null;regionTextResponse=null;eventTracker_=new EventTracker;selectionOverlayRect;listenerIds=[];isSelectingRegion=false;shouldShowContextMenuIfDetectsText=true;textReceivedTimeout={timeout:loadTimeData.getInteger("textReceivedTimeout"),timeoutId:-1,timeoutElapsedOrCleared:false};copyTextTimeout={timeout:loadTimeData.getInteger("copyTextTimeout"),timeoutId:-1,timeoutElapsedOrCleared:false};copyTextFunction;translateTimeout={timeout:loadTimeData.getInteger("translateTextTimeout"),timeoutId:-1,timeoutElapsedOrCleared:false};selectedRegion=null;browserProxy=BrowserProxyImpl.getInstance();connectedCallback(){super.connectedCallback();this.eventTracker_.add(document,"detect-text-in-region",(e=>{this.detectTextInRegion(e.detail)}));this.listenerIds=[this.browserProxy.callbackRouter.textReceived.addListener(this.onTextReceived.bind(this)),this.browserProxy.callbackRouter.regionTextReceived.addListener(this.onRegionTextReceived.bind(this)),this.browserProxy.callbackRouter.clearAllSelections.addListener(this.onClearRegionSelection.bind(this)),this.browserProxy.callbackRouter.clearRegionSelection.addListener(this.onClearRegionSelection.bind(this)),this.browserProxy.callbackRouter.setPostRegionSelection.addListener(this.setSelection.bind(this))];this.setTextReceivedTimeout()}disconnectedCallback(){super.disconnectedCallback();if(this.regionTextResponse&&this.regionTextResponse.receivedWords.length>0){recordLensOverlaySemanticEvent(SemanticEvent.kTextGleamsViewEnd)}this.listenerIds.forEach((id=>{const removed=this.browserProxy.callbackRouter.removeListener(id);assert(removed)}));this.listenerIds=[];this.eventTracker_.removeAll()}handleRightClick(_event){return false}handleGestureStart(_event){return false}handleGestureDrag(_event){}handleGestureEnd(){}cancelGesture(){}onSelectionStart(){this.isSelectingRegion=true;this.hasActionedText=false;this.shouldShowContextMenuIfDetectsText=true;this.hideHighlightedLines=true;this.fire("hide-selected-region-context-menu")}onSelectionFinish(){this.isSelectingRegion=false;this.regionTextResponse=null;this.clearTextTimeouts()}selectAndSendWords(_selectionStartIndex,_selectionEndIndex){}selectAndTranslateWords(startIndex,endIndex){if(this.regionTextResponse){this.hasActionedText=true;translateWords(this.getRegionText(),this.regionTextResponse.contentLanguage,0,this.regionTextResponse.receivedWords.length-1,this.browserProxy);return}assert(this.fullTextResponse);if(this.translateTimeout.timeoutElapsedOrCleared){this.hasActionedText=true;translateWords(this.getRegionTextFromFullImage(startIndex,endIndex),this.fullTextResponse.contentLanguage,startIndex,endIndex,this.browserProxy);this.highlightedLines=createHighlightedLines(this.fullTextResponse,startIndex,endIndex);this.hideHighlightedLines=false;return}this.translateTimeout.timeoutId=setTimeout((()=>{this.translateTimeout.timeoutElapsedOrCleared=true;this.translateTimeout.timeoutId=-1;this.selectAndTranslateWords(startIndex,endIndex)}),this.translateTimeout.timeout)}onClearRegionSelection(){this.isSelectingRegion=false;this.hasActionedText=false;this.hideHighlightedLines=true;this.highlightedLines=[]}setTextReceivedTimeout(){this.textReceivedTimeout.timeoutElapsedOrCleared=false;this.textReceivedTimeout.timeoutId=setTimeout((()=>{this.textReceivedTimeout.timeoutElapsedOrCleared=true;this.textReceivedTimeout.timeoutId=-1}),this.textReceivedTimeout.timeout)}detectTextInRegion(box){if(!this.textReceivedTimeout.timeoutElapsedOrCleared){this.fire("hide-selected-region-context-menu");return}const showOrUpdateEventName=this.shouldShowContextMenuIfDetectsText?"show-selected-region-context-menu":"update-selected-region-context-menu";this.shouldShowContextMenuIfDetectsText=false;if(this.regionTextResponse){if(this.regionTextResponse.receivedWords.length>0){this.fire(showOrUpdateEventName,{box:box,selectionStartIndex:0,selectionEndIndex:this.regionTextResponse.receivedWords.length-1,text:this.getRegionText()});return}this.fire(showOrUpdateEventName,{box:box,selectionStartIndex:-1,selectionEndIndex:-1});return}if(this.fullTextResponse&&this.fullTextResponse.receivedWords.length>0){const selection=findWordsInRegion(this.fullTextResponse.receivedWords,box,this.selectionOverlayRect);if(selection.iou>.1){this.fire(showOrUpdateEventName,{box:box,selectionStartIndex:selection.startIndex,selectionEndIndex:selection.endIndex,text:this.getRegionTextFromFullImage(selection.startIndex,selection.endIndex)});return}}this.fire(showOrUpdateEventName,{box:box,selectionStartIndex:-1,selectionEndIndex:-1})}onRegionTextReceived(text,isInjectedImage){if(this.isSelectingRegion){return}if(this.regionTextResponse&&this.regionTextResponse.receivedWords.length>0){recordLensOverlaySemanticEvent(SemanticEvent.kTextGleamsViewEnd)}this.regionTextResponse={contentLanguage:"",receivedWords:[],paragraphNumbers:[],lineNumbers:[],lines:[],paragraphs:[]};let lineNumber=0;let paragraphNumber=0;for(const paragraph of text.textLayout?.paragraphs??[]){for(const line of paragraph.lines){for(const word of line.words){if(isWordRenderable(word)){this.regionTextResponse.receivedWords.push(word);this.regionTextResponse.lineNumbers.push(lineNumber);this.regionTextResponse.paragraphNumbers.push(paragraphNumber);const wordBoundingBox=word.geometry?.boundingBox;assert(wordBoundingBox)}}this.regionTextResponse.lines.push(line);lineNumber++}this.regionTextResponse.paragraphs.push(paragraph);paragraphNumber++}if(this.regionTextResponse.receivedWords.length>0){recordLensOverlaySemanticEvent(SemanticEvent.kTextGleamsViewStart)}assert(this.regionTextResponse.paragraphNumbers.length===this.regionTextResponse.receivedWords.length);if(isInjectedImage&&this.selectedRegion&&this.fullTextResponse){this.tryRenderInjectedImageHighlights()}else if(!isInjectedImage){this.highlightedLines=createHighlightedLines(this.regionTextResponse,0,this.regionTextResponse.receivedWords.length-1)}this.hideHighlightedLines=false;this.fire("finished-receiving-text");if(this.copyTextTimeout.timeoutId!==-1){this.copyTextTimeout.timeoutElapsedOrCleared=true;clearTimeout(this.copyTextTimeout.timeoutId);this.copyTextTimeout.timeoutId=-1;this.onCopyDetectedText(0,this.regionTextResponse.receivedWords.length-1,this.copyTextFunction)}if(this.translateTimeout.timeoutId!==-1){this.translateTimeout.timeoutElapsedOrCleared=true;clearTimeout(this.translateTimeout.timeoutId);this.translateTimeout.timeoutId=-1;this.selectAndTranslateWords(0,this.regionTextResponse.receivedWords.length-1)}}onTextReceived(text){this.fullTextResponse={contentLanguage:"",receivedWords:[],paragraphNumbers:[],lineNumbers:[],lines:[],paragraphs:[]};let paragraphNumber=0;for(const paragraph of text.textLayout?.paragraphs??[]){for(const line of paragraph.lines){for(const word of line.words){if(isWordRenderable(word)){this.fullTextResponse.receivedWords.push(word);this.fullTextResponse.paragraphNumbers.push(paragraphNumber)}}this.fullTextResponse.lines.push(line)}this.fullTextResponse.paragraphs.push(paragraph);paragraphNumber++}assert(this.fullTextResponse.paragraphNumbers.length===this.fullTextResponse.receivedWords.length);this.textReceivedTimeout.timeoutElapsedOrCleared=true;clearTimeout(this.textReceivedTimeout.timeoutId);this.textReceivedTimeout.timeoutId=-1;this.fire("finished-receiving-text");if(this.regionTextResponse&&this.selectedRegion&&!this.isSelectingRegion&&this.highlightedLines.length===0){this.tryRenderInjectedImageHighlights()}}onCopyDetectedText(startIndex,endIndex,callback){if(startIndex<0||endIndex<0){return}this.hasActionedText=true;if(this.regionTextResponse){callback(0,this.regionTextResponse.receivedWords.length-1,this.getRegionText());return}if(this.copyTextTimeout.timeoutElapsedOrCleared){if(this.fullTextResponse){callback(startIndex,endIndex,this.getRegionTextFromFullImage(startIndex,endIndex));this.highlightedLines=createHighlightedLines(this.fullTextResponse,startIndex,endIndex);this.hideHighlightedLines=false}return}if(this.copyTextTimeout.timeoutId===-1){this.copyTextFunction=callback;this.copyTextTimeout.timeoutId=setTimeout((()=>{this.copyTextTimeout.timeoutElapsedOrCleared=true;this.copyTextTimeout.timeoutId=-1;this.onCopyDetectedText(startIndex,endIndex,callback)}),this.copyTextTimeout.timeout)}}getRegionTextFromFullImage(textStartIndex,textEndIndex){if(textStartIndex===-1||textEndIndex===-1||!this.fullTextResponse){return""}const startIndex=Math.min(textStartIndex,textEndIndex);const endIndex=Math.max(textStartIndex,textEndIndex);const selectedWords=this.fullTextResponse.receivedWords.slice(startIndex,endIndex+1);const selectedParagraphNumbers=this.fullTextResponse.paragraphNumbers.slice(startIndex,endIndex+1);return selectedWords.map(((word,index)=>{let separator="";if(index<selectedWords.length-1){if(selectedParagraphNumbers[index]!==selectedParagraphNumbers[index+1]){separator="\r\n"}else{separator=getTextSeparator(word)}}return word.plainText+separator})).join("")}getRegionText(){if(!this.regionTextResponse||this.regionTextResponse.receivedWords.length<=0){return""}const startIndex=0;const endIndex=this.regionTextResponse.receivedWords.length-1;const selectedWords=this.regionTextResponse.receivedWords.slice(startIndex,endIndex+1);const selectedParagraphNumbers=this.regionTextResponse.paragraphNumbers.slice(startIndex,endIndex+1);return selectedWords.map(((word,index)=>{let separator="";if(index<selectedWords.length-1){if(selectedParagraphNumbers[index]!==selectedParagraphNumbers[index+1]){separator="\r\n"}else{separator=getTextSeparator(word)}}return word.plainText+separator})).join("")}setSelection(box){this.selectedRegion=box}getHighlightedLineStyle(line){const styles=[`width: ${toPercent(line.width)}`,`height: ${toPercent(line.height)}`,`top: ${toPercent(line.top)}`,`left: ${toPercent(line.left)}`,`transform: rotate(${line.rotation}rad)`];return styles.join(";")}clearTextTimeouts(){clearTimeout(this.copyTextTimeout.timeoutId);this.copyTextTimeout.timeoutElapsedOrCleared=false;this.copyTextTimeout.timeoutId=-1;clearTimeout(this.translateTimeout.timeoutId);this.translateTimeout.timeoutElapsedOrCleared=false;this.translateTimeout.timeoutId=-1}tryRenderInjectedImageHighlights(){assert(this.fullTextResponse);assert(this.selectedRegion);const selection=findWordsInRegion(this.fullTextResponse.receivedWords,this.selectedRegion,this.selectionOverlayRect);this.highlightedLines=createHighlightedLines(this.fullTextResponse,selection.startIndex,selection.endIndex);this.hideHighlightedLines=false}getElementForTesting(){return this}getHasActionedTextForTesting(){return this.hasActionedText}setSelectionOverlayRectForTesting(rect){this.selectionOverlayRect=rect}}customElements.define(SimplifiedTextLayerElement.is,SimplifiedTextLayerElement);