// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// LINT.IfChange(ApiRequestType)
// New values here must be added to histograms.xml and to enums.xml.
export const HOST_REQUEST_TYPES = (() => {
    const result = {
        WebClientCreated: 1,
        WebClientInitialized: 2,
        CreateTab: 3,
        OpenGlicSettingsPage: 4,
        ClosePanel: 5,
        ClosePanelAndShutdown: 6,
        ShowProfilePicker: 7,
        GetModelQualityClientId: 8,
        GetContextFromFocusedTab: 9,
        GetContextFromTab: 10,
        GetContextForActorFromTab: 11,
        SetMaximumNumberOfPinnedTabs: 12,
        StopActorTask: 13,
        PauseActorTask: 14,
        ResumeActorTask: 15,
        CaptureScreenshot: 16,
        ResizeWindow: 17,
        EnableDragResize: 18,
        SetWindowDraggableAreas: 19,
        SetMinimumWidgetSize: 20,
        SetMicrophonePermissionState: 21,
        SetLocationPermissionState: 22,
        SetTabContextPermissionState: 23,
        SetContextAccessIndicator: 24,
        GetUserProfileInfo: 25,
        RefreshSignInCookies: 26,
        AttachPanel: 27,
        DetachPanel: 28,
        SetAudioDucking: 29,
        LogBeginAsyncEvent: 30,
        LogEndAsyncEvent: 31,
        LogInstantEvent: 32,
        JournalClear: 33,
        JournalSnapshot: 34,
        JournalStart: 35,
        JournalStop: 36,
        JournalRecordFeedback: 37,
        OnUserInputSubmitted: 38,
        OnResponseRated: 39,
        OnResponseStarted: 40,
        OnResponseStopped: 41,
        OnSessionTerminated: 42,
        OnTurnCompleted: 43,
        OnModelChanged: 44,
        ScrollTo: 45,
        SetSyntheticExperimentState: 46,
        OpenOsPermissionSettingsMenu: 47,
        GetOsMicrophonePermissionStatus: 48,
        PinTabs: 49,
        UnpinTabs: 50,
        UnpinAllTabs: 51,
        SubscribeToPinCandidates: 52,
        UnsubscribeFromPinCandidates: 53,
        GetZeroStateSuggestionsForFocusedTab: 54,
        GetZeroStateSuggestionsAndSubscribe: 55,
        SetClosedCaptioningSetting: 56,
        DropScrollToHighlight: 57,
        MaybeRefreshUserStatus: 58,
        OnClosedCaptionsShown: 59,
        CreateTask: 60,
        PerformActions: 61,
        OnViewChanged: 62,
        SubscribeToPageMetadata: 63,
        SwitchConversation: 64,
        RegisterConversation: 65,
        OnReaction: 66,
        OnContextUploadCompleted: 67,
        OnContextUploadStarted: 68,
    };
    return { ...result, MAX_VALUE: Math.max(...Object.values(result)) };
})();
// clang-format off
// LINT.ThenChange(//tools/metrics/histograms/metadata/glic/histograms.xml:ApiRequestType, //tools/metrics/histograms/metadata/glic/enums.xml:GlicHostApiRequestType)
// clang-format on
export function requestTypeToHistogramSuffix(type) {
    if (!type.startsWith('glicBrowser')) {
        return undefined;
    }
    return type.substring(11);
}
/* eslint-disable-next-line @typescript-eslint/naming-convention */
function assertNever() { }
assertNever();
assertNever();
export var ImageAlphaType;
(function (ImageAlphaType) {
    // RGB values are unmodified.
    ImageAlphaType[ImageAlphaType["UNPREMUL"] = 0] = "UNPREMUL";
    // RGB values have been premultiplied by alpha.
    ImageAlphaType[ImageAlphaType["PREMUL"] = 1] = "PREMUL";
})(ImageAlphaType || (ImageAlphaType = {}));
// Chromium currently only uses a single color type for BitmapN32.
export var ImageColorType;
(function (ImageColorType) {
    ImageColorType[ImageColorType["BGRA"] = 0] = "BGRA";
})(ImageColorType || (ImageColorType = {}));
/** Reasons why the credential selection dialog request failed. */
export var SelectCredentialDialogErrorReason;
(function (SelectCredentialDialogErrorReason) {
    // The hosting WebUI received the request, but the web client has not
    // subscribed to the request yet. We couldn't show the dialog in this case.
    SelectCredentialDialogErrorReason[SelectCredentialDialogErrorReason["DIALOG_PROMISE_NO_SUBSCRIBER"] = 0] = "DIALOG_PROMISE_NO_SUBSCRIBER";
})(SelectCredentialDialogErrorReason || (SelectCredentialDialogErrorReason = {}));
export var UserConfirmationDialogErrorReason;
(function (UserConfirmationDialogErrorReason) {
    // The hosting WebUI received the request, but the web client has not
    // subscribed to the request yet. We couldn't show the dialog in this case.
    UserConfirmationDialogErrorReason[UserConfirmationDialogErrorReason["DIALOG_PROMISE_NO_SUBSCRIBER"] = 0] = "DIALOG_PROMISE_NO_SUBSCRIBER";
    // The task requested a new user confirmation dialog before the current
    // one completed.
    UserConfirmationDialogErrorReason[UserConfirmationDialogErrorReason["PREEMPTED_BY_NEW_REQUEST"] = 1] = "PREEMPTED_BY_NEW_REQUEST";
})(UserConfirmationDialogErrorReason || (UserConfirmationDialogErrorReason = {}));
export class ErrorWithReasonImpl extends Error {
    reasonType;
    reason;
    constructor(reasonType, reason, message) {
        super(message ?? `${reasonType} Error: ${reason}`);
        this.reasonType = reasonType;
        this.reason = reason;
    }
}
// Constructs an exception from a TransferableException.
export function exceptionFromTransferable(e) {
    // Error types are serializable, but they do not serialize all members.
    // If exceptionReason is provided, we use it to reconstruct a
    // ErrorWithReason by just setting additional fields after
    // serialization.
    if (e.exceptionReason !== undefined) {
        const withReason = e.exception;
        withReason.reason = e.exceptionReason.reason;
        withReason.reasonType = e.exceptionReason.reasonType;
    }
    return e.exception;
}
// Transform an Error into a TransferableException.
export function newTransferableException(e) {
    let exceptionReason = undefined;
    const maybeWithReason = e;
    if (maybeWithReason.reasonType !== undefined &&
        maybeWithReason.reason !== undefined) {
        exceptionReason = {
            reason: maybeWithReason.reason,
            reasonType: maybeWithReason.reasonType,
        };
    }
    return { exception: e, exceptionReason };
}
