// chrome/common/actor_webui.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  BitmapN32Spec as skia_mojom_BitmapN32Spec,
  BitmapN32 as skia_mojom_BitmapN32
} from '//resources/mojo/skia/public/mojom/bitmap.mojom-webui.js';
import {
  OriginSpec as url_mojom_OriginSpec,
  Origin as url_mojom_Origin
} from '//resources/mojo/url/mojom/origin.mojom-webui.js';





export const UserGrantedPermissionDurationSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum UserGrantedPermissionDuration {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kOneTime = 0,
  kAlwaysAllow = 1,
}

export const SelectCredentialDialogErrorReasonSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum SelectCredentialDialogErrorReason {

  MIN_VALUE = 0,
  MAX_VALUE = 0,
  kDialogPromiseNoSubscriber = 0,
}

export const UserConfirmationDialogErrorReasonSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum UserConfirmationDialogErrorReason {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kDialogPromiseNoSubscriber = 0,
  kPreemptedByNewRequest = 1,
}


export const TaskOptionsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CredentialSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SelectCredentialDialogRequestSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SelectCredentialDialogResponseSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserConfirmationDialogRequestSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserConfirmationDialogResponseSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserConfirmationDialogPayloadSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserConfirmationDialogResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface TaskOptionsMojoType {
  title: (string | null);
}


export type TaskOptions = TaskOptionsMojoType;
mojo.internal.Struct<TaskOptionsMojoType>(
    TaskOptionsSpec.$,
    'TaskOptions',
    [
      mojo.internal.StructField<TaskOptionsMojoType, string>(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CredentialMojoType {
  id: number;
  username: string;
  sourceSiteOrApp: string;
}


export type Credential = CredentialMojoType;
mojo.internal.Struct<CredentialMojoType>(
    CredentialSpec.$,
    'Credential',
    [
      mojo.internal.StructField<CredentialMojoType, number>(
        'id', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CredentialMojoType, string>(
        'username', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CredentialMojoType, string>(
        'sourceSiteOrApp', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface SelectCredentialDialogRequestMojoType {
  taskId: number;
  showDialog: boolean;
  credentials: Credential[];
  icons: {[key: string]: skia_mojom_BitmapN32};
}


export type SelectCredentialDialogRequest = SelectCredentialDialogRequestMojoType;
mojo.internal.Struct<SelectCredentialDialogRequestMojoType>(
    SelectCredentialDialogRequestSpec.$,
    'SelectCredentialDialogRequest',
    [
      mojo.internal.StructField<SelectCredentialDialogRequestMojoType, number>(
        'taskId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SelectCredentialDialogRequestMojoType, boolean>(
        'showDialog', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SelectCredentialDialogRequestMojoType, Credential[]>(
        'credentials', 8,
        0,
        mojo.internal.Array(CredentialSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SelectCredentialDialogRequestMojoType, {[key: string]: skia_mojom_BitmapN32}>(
        'icons', 16,
        0,
        mojo.internal.Map(mojo.internal.String, skia_mojom_BitmapN32Spec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface SelectCredentialDialogResponseMojoType {
  taskId: number;
  errorReason: (SelectCredentialDialogErrorReason | null);
  permissionDuration: (UserGrantedPermissionDuration | null);
  selectedCredentialId: (number | null);
}


export type SelectCredentialDialogResponse = SelectCredentialDialogResponseMojoType;
mojo.internal.Struct<SelectCredentialDialogResponseMojoType>(
    SelectCredentialDialogResponseSpec.$,
    'SelectCredentialDialogResponse',
    [
      mojo.internal.StructField<SelectCredentialDialogResponseMojoType, number>(
        'taskId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SelectCredentialDialogResponseMojoType, boolean>(
        'error_reason_$flag', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "error_reason_$value",
          originalFieldName: "errorReason",
        },
        undefined,
    ),
      mojo.internal.StructField<SelectCredentialDialogResponseMojoType, SelectCredentialDialogErrorReason>(
        'error_reason_$value', 8,
        0,
        SelectCredentialDialogErrorReasonSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "errorReason",
        },
        undefined,
    ),
      mojo.internal.StructField<SelectCredentialDialogResponseMojoType, boolean>(
        'permission_duration_$flag', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "permission_duration_$value",
          originalFieldName: "permissionDuration",
        },
        undefined,
    ),
      mojo.internal.StructField<SelectCredentialDialogResponseMojoType, UserGrantedPermissionDuration>(
        'permission_duration_$value', 12,
        0,
        UserGrantedPermissionDurationSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "permissionDuration",
        },
        undefined,
    ),
      mojo.internal.StructField<SelectCredentialDialogResponseMojoType, boolean>(
        'selected_credential_id_$flag', 4,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "selected_credential_id_$value",
          originalFieldName: "selectedCredentialId",
        },
        undefined,
    ),
      mojo.internal.StructField<SelectCredentialDialogResponseMojoType, number>(
        'selected_credential_id_$value', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "selectedCredentialId",
        },
        undefined,
    ),
    ],
    [[0, 32],]);





export interface UserConfirmationDialogRequestMojoType {
  payload: UserConfirmationDialogPayload;
}


export type UserConfirmationDialogRequest = UserConfirmationDialogRequestMojoType;
mojo.internal.Struct<UserConfirmationDialogRequestMojoType>(
    UserConfirmationDialogRequestSpec.$,
    'UserConfirmationDialogRequest',
    [
      mojo.internal.StructField<UserConfirmationDialogRequestMojoType, UserConfirmationDialogPayload>(
        'payload', 0,
        0,
        UserConfirmationDialogPayloadSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface UserConfirmationDialogResponseMojoType {
  result: UserConfirmationDialogResult;
}


export type UserConfirmationDialogResponse = UserConfirmationDialogResponseMojoType;
mojo.internal.Struct<UserConfirmationDialogResponseMojoType>(
    UserConfirmationDialogResponseSpec.$,
    'UserConfirmationDialogResponse',
    [
      mojo.internal.StructField<UserConfirmationDialogResponseMojoType, UserConfirmationDialogResult>(
        'result', 0,
        0,
        UserConfirmationDialogResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);



mojo.internal.Union(
    UserConfirmationDialogPayloadSpec.$, 'UserConfirmationDialogPayload',
    {
      'navigationOrigin': {
        'ordinal': 0,
        'type': url_mojom_OriginSpec.$,
      },
      'downloadId': {
        'ordinal': 1,
        'type': mojo.internal.Int32,
      },
    });

export interface UserConfirmationDialogPayload {
  navigationOrigin?: url_mojom_Origin,
  downloadId?: number,
}

export enum UserConfirmationDialogPayloadFieldTags {
  NAVIGATION_ORIGIN,
  DOWNLOAD_ID,
}

export function whichUserConfirmationDialogPayload(u: UserConfirmationDialogPayload): UserConfirmationDialogPayloadFieldTags {
  if (u.navigationOrigin !== null && u.navigationOrigin !== undefined) {
    return UserConfirmationDialogPayloadFieldTags.NAVIGATION_ORIGIN;
  }
  if (u.downloadId !== null && u.downloadId !== undefined) {
    return UserConfirmationDialogPayloadFieldTags.DOWNLOAD_ID;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    UserConfirmationDialogResultSpec.$, 'UserConfirmationDialogResult',
    {
      'permissionGranted': {
        'ordinal': 0,
        'type': mojo.internal.Bool,
      },
      'errorReason': {
        'ordinal': 1,
        'type': UserConfirmationDialogErrorReasonSpec.$,
      },
    });

export interface UserConfirmationDialogResult {
  permissionGranted?: boolean,
  errorReason?: UserConfirmationDialogErrorReason,
}

export enum UserConfirmationDialogResultFieldTags {
  PERMISSION_GRANTED,
  ERROR_REASON,
}

export function whichUserConfirmationDialogResult(u: UserConfirmationDialogResult): UserConfirmationDialogResultFieldTags {
  if (u.permissionGranted !== null && u.permissionGranted !== undefined) {
    return UserConfirmationDialogResultFieldTags.PERMISSION_GRANTED;
  }
  if (u.errorReason !== null && u.errorReason !== undefined) {
    return UserConfirmationDialogResultFieldTags.ERROR_REASON;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
