/**
 * @fileoverview
 * This file contains enums for Glic FRE metrics recorded from the WebUI.
 * These values are persisted to logs and should not be renumbered or reused.
 * See tools/metrics/histograms/metadata/glic/enums.xml.
 */
export declare enum GlicFreWebviewLoadAbortReason {
    UNKNOWN = 0,
    ERR_ABORTED = 1,
    ERR_INVALID_URL = 2,
    ERR_DISALLOWED_URL_SCHEME = 3,
    ERR_BLOCKED_BY_CLIENT = 4,
    ERR_ADDRESS_UNREACHABLE = 5,
    ERR_EMPTY_RESPONSE = 6,
    ERR_FILE_NOT_FOUND = 7,
    ERR_UNKNOWN_URL_SCHEME = 8,
    ERR_TIMED_OUT = 9,
    ERR_HTTP_RESPONSE_CODE_FAILURE = 10,
    MAX_VALUE = 10
}
