import './icons.html.js';
import '/strings.m.js';
import '//resources/cr_elements/cr_shared_vars.css.js';
import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface ComposeResultTextElement {
    $: {
        resultText: HTMLElement;
        partialResultText: HTMLElement;
        root: HTMLElement;
    };
}
export interface TextInput {
    text: string;
    isPartial: boolean;
    streamingEnabled: boolean;
}
export declare class ComposeResultTextElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        textInput: {
            type: ObjectConstructor;
            value: () => {
                text: string;
                isPartial: boolean;
                streamingEnabled: boolean;
            };
        };
        isOutputComplete: {
            type: BooleanConstructor;
            notify: boolean;
            value: boolean;
        };
        hasOutput: {
            type: BooleanConstructor;
            computed: string;
            notify: boolean;
        };
        hasPartialOutput_: {
            type: BooleanConstructor;
            computed: string;
            notify: boolean;
        };
        displayedChunks_: {
            type: ObjectConstructor;
            readOnly: boolean;
            value: () => never[];
        };
        displayedFullText_: {
            type: StringConstructor;
            readOnly: boolean;
            value: string;
        };
    };
    static get observers(): string[];
    textInput: TextInput;
    isOutputComplete: boolean;
    hasOutput: boolean;
    private hasPartialOutput_;
    private displayedChunks_;
    private displayedFullText_;
    private wordStreamer_;
    private initialText_;
    constructor();
    updateInputs(): void;
    enableInstantStreamingForTesting(): void;
    private onFocusIn_;
    private onFocusOut_;
    private partialTextCanEdit_;
    private hasOutput_;
    private getHasPartialOutput_;
    private setStreamedWords_;
}
declare global {
    interface HTMLElementTagNameMap {
        'compose-result-text': ComposeResultTextElement;
    }
}
