// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./icons.html.js";import"/strings.m.js";import"./textarea.js";import"./result_text.js";import"//resources/cr_elements/cr_button/cr_button.js";import"//resources/cr_elements/cr_chip/cr_chip.js";import"//resources/cr_elements/cr_feedback_buttons/cr_feedback_buttons.js";import"//resources/cr_elements/cr_icon_button/cr_icon_button.js";import"//resources/cr_elements/cr_loading_gradient/cr_loading_gradient.js";import"//resources/cr_elements/cr_scrollable.css.js";import"//resources/cr_elements/cr_shared_vars.css.js";import"//resources/cr_elements/icons.html.js";import"//resources/cr_elements/md_select.css.js";import"//resources/cr_elements/cr_icon/cr_icon.js";import{ColorChangeUpdater}from"//resources/cr_components/color_change_listener/colors_css_updater.js";import{getInstance as getAnnouncerInstance}from"//resources/cr_elements/cr_a11y_announcer/cr_a11y_announcer.js";import{CrFeedbackOption}from"//resources/cr_elements/cr_feedback_buttons/cr_feedback_buttons.js";import{I18nMixin}from"//resources/cr_elements/i18n_mixin.js";import{assert}from"//resources/js/assert.js";import{EventTracker}from"//resources/js/event_tracker.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{isMac}from"//resources/js/platform.js";import{Debouncer,microTask,PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{ComposeAppAnimator}from"./animations/app_animator.js";import{getTemplate}from"./app.html.js";import{CloseReason,InputMode,StyleModifier,UserFeedback}from"./compose.mojom-webui.js";import{ComposeApiProxyImpl}from"./compose_api_proxy.js";import{ComposeStatus}from"./compose_enums.mojom-webui.js";export const TIMEOUT_MS=700;const ComposeAppElementBase=I18nMixin(PolymerElement);var TriggerElement;(function(TriggerElement){TriggerElement[TriggerElement["SUBMIT_INPUT"]=0]="SUBMIT_INPUT";TriggerElement[TriggerElement["MODIFIER"]=1]="MODIFIER";TriggerElement[TriggerElement["UNDO"]=2]="UNDO";TriggerElement[TriggerElement["REDO"]=3]="REDO"})(TriggerElement||(TriggerElement={}));export class ComposeAppElement extends ComposeAppElementBase{static get is(){return"compose-app"}static get template(){return getTemplate()}static get properties(){return{editedInput_:{type:String,observer:"onEditedInputChanged_"},enableAnimations:{type:Boolean,value:loadTimeData.getBoolean("enableAnimations"),reflectToAttribute:true},enableUpfrontInputModes:{type:Boolean,value:loadTimeData.getBoolean("enableUpfrontInputModes")},feedbackState_:{type:String,value:CrFeedbackOption.UNSPECIFIED},hasPartialOutput_:{type:Boolean},input_:{type:String,observer:"onInputChanged_"},inputParams_:{type:Object},isEditingSubmittedInput_:{type:Boolean,reflectToAttribute:true,value:false,observer:"onIsEditingSubmittedInputChanged_"},isEditingResultText_:{type:Boolean,reflectToAttribute:true,value:false},isEditSubmitEnabled_:{type:Boolean,value:true},isSubmitEnabled_:{type:Boolean,value:true},loading_:{type:Boolean,value:false,reflectToAttribute:true},loadingIndicatorShown_:{type:Boolean,reflectToAttribute:true,computed:"isLoadingIndicatorShown_(loading_, hasOutput_)"},response_:{type:Object,value:null},partialResponse_:{type:Object,value:null},showInputModes_:{type:Boolean,reflectToAttribute:true,computed:"shouldShowInputModes_(submitted_, enableUpfrontInputModes)"},selectedInputMode_:{type:Number,value:InputMode.kUnset},selectedModifier_:{type:String},polishChipIcon_:{type:String,value:"cr:check",reflectToAttribute:true},elaborateChipIcon_:{type:String,value:"compose:elaborate",reflectToAttribute:true},formalizeChipIcon_:{type:String,value:"compose:formalize",reflectToAttribute:true},textSelected_:{type:Boolean},enterprise_:{type:Boolean,value:loadTimeData.getBoolean("useEnterpriseWithoutLoggingPolicy")},showMainAppDialog_:{type:Boolean,value:false},submitted_:{type:Boolean,value:false,reflectToAttribute:true},undoEnabled_:{type:Boolean,value:false},redoEnabled_:{type:Boolean,value:false},feedbackEnabled_:{type:Boolean,value:true},responseText_:{type:String,computed:"getResponseText_(response_, partialResponse_)"},showFirstRunDialog_:{type:Boolean},showMSBBDialog_:{type:Boolean},outputComplete_:{type:Boolean,value:true},hasOutput_:{type:Boolean,value:false},displayedText_:{type:String},modifierOptions_:{type:Array,value:()=>[{value:StyleModifier.kUnset,label:loadTimeData.getString("modifierMenuTitle"),isDefault:true},{value:StyleModifier.kLonger,label:loadTimeData.getString("longerOption")},{value:StyleModifier.kShorter,label:loadTimeData.getString("shorterOption")},{value:StyleModifier.kFormal,label:loadTimeData.getString("formalToneOption")},{value:StyleModifier.kCasual,label:loadTimeData.getString("casualToneOption")},{value:StyleModifier.kRetry,label:loadTimeData.getString("retryOption")}]}}}static get observers(){return["debounceSaveComposeAppState_(input_, isEditingSubmittedInput_, "+"editedInput_)","debounceUpdateResultComplete_(outputComplete_, response_)"]}animator_;apiProxy_=ComposeApiProxyImpl.getInstance();eventTracker_=new EventTracker;router_=this.apiProxy_.getRouter();shouldShowMSBBDialog_;saveAppStateDebouncer_;scrollCheckDebouncer_;updateResultCompleteDebouncer_;userHasModifiedState_=false;lastTriggerElement_;userResponseText_;constructor(){super();ColorChangeUpdater.forDocument().start();this.animator_=new ComposeAppAnimator(this,loadTimeData.getBoolean("enableAnimations"));this.getInitialState_();if(this.enableUpfrontInputModes){this.selectedInputMode_=InputMode.kPolish}this.router_.responseReceived.addListener((response=>{this.composeResponseReceived_(response)}));this.router_.partialResponseReceived.addListener((partialResponse=>{this.partialComposeResponseReceived_(partialResponse)}))}getResponseText_(){if(this.userResponseText_!==undefined){return{text:this.userResponseText_,isPartial:false,streamingEnabled:false}}else if(this.response_){return{text:this.response_.status===ComposeStatus.kOk?this.response_.result.trim():"",isPartial:false,streamingEnabled:this.partialResponse_!==undefined}}else if(this.partialResponse_){return{text:this.partialResponse_?.result.trim(),isPartial:true,streamingEnabled:true}}else{return{text:"",isPartial:false,streamingEnabled:false}}}connectedCallback(){super.connectedCallback();this.eventTracker_.add(document,"visibilitychange",(()=>{if(document.visibilityState!=="visible"){this.saveComposeAppState_()}}))}disconnectedCallback(){super.disconnectedCallback();this.eventTracker_.removeAll()}debounceSaveComposeAppState_(){this.saveAppStateDebouncer_=Debouncer.debounce(this.saveAppStateDebouncer_,microTask,(()=>this.saveComposeAppState_()))}getInitialState_(){this.apiProxy_.requestInitialState().then((initialState=>{this.inputParams_=initialState.configurableParams;this.showFirstRunDialog_=!initialState.freComplete;this.showMSBBDialog_=initialState.freComplete&&!initialState.msbbState;this.shouldShowMSBBDialog_=!initialState.msbbState;this.showMainAppDialog_=initialState.freComplete&&initialState.msbbState;if(initialState.initialInput){this.input_=initialState.initialInput}this.textSelected_=initialState.textSelected;this.partialResponse_=undefined;const composeState=initialState.composeState;this.feedbackState_=userFeedbackToFeedbackOption(composeState.feedback);this.loading_=composeState.hasPendingRequest;this.submitted_=composeState.hasPendingRequest||Boolean(composeState.response);if(!composeState.hasPendingRequest){this.response_=composeState.response;this.undoEnabled_=Boolean(this.response_?.undoAvailable);this.redoEnabled_=Boolean(this.response_?.redoAvailable);this.feedbackEnabled_=Boolean(!this.response_?.providedByUser)}if(composeState.webuiState){const appState=JSON.parse(composeState.webuiState);this.input_=appState.input;this.selectedInputMode_=appState.inputMode;this.updateInputMode_();if(appState.isEditingSubmittedInput){this.isEditingSubmittedInput_=appState.isEditingSubmittedInput;this.editedInput_=appState.editedInput}}if(this.showFirstRunDialog_){this.animator_.transitionToFirstRun()}else{this.animator_.transitionInDialog()}setTimeout((()=>{requestAnimationFrame((()=>this.apiProxy_.showUi()))}))}))}getTrimmedResult_(){return this.response_?.result.trim()}getTrimmedPartialResult_(){return this.partialResponse_?.result.trim()}onFirstRunOkButtonClick_(){this.apiProxy_.completeFirstRun();if(this.shouldShowMSBBDialog_){this.showMSBBDialog_=true}else{this.showMainAppDialog_=true;this.animator_.transitionToInput()}this.showFirstRunDialog_=false}onFirstRunBottomTextClick_(e){e.preventDefault();if(e.target.tagName==="A"){if(this.enterprise_){this.apiProxy_.openEnterpriseComposeLearnMorePage()}else{this.apiProxy_.openComposeLearnMorePage()}}}onCancelEditClick_(){const fullBodyHeight=this.$.body.offsetHeight;const resultContainerHeight=this.$.resultContainer.offsetHeight;this.isEditingSubmittedInput_=false;this.$.textarea.focusEditButton();this.animator_.transitionFromEditingToResult(resultContainerHeight);this.$.textarea.transitionToResult(fullBodyHeight);this.$.editTextarea.transitionToResult(fullBodyHeight);this.apiProxy_.logCancelEdit()}onClose_(e){switch(e.target.id){case"firstRunCloseButton":{this.apiProxy_.closeUi(CloseReason.kFirstRunCloseButton);break}case"closeButtonMSBB":{this.apiProxy_.closeUi(CloseReason.kMSBBCloseButton);break}case"closeButton":{this.apiProxy_.closeUi(CloseReason.kCloseButton);break}}}onEditedInputChanged_(){this.userHasModifiedState_=true;if(!this.isEditSubmitEnabled_){this.isEditSubmitEnabled_=this.$.editTextarea.validate()}}onEditClick_(){const fullBodyHeight=this.$.body.offsetHeight;const resultContainerHeight=this.$.resultContainer.offsetHeight;this.editedInput_=this.input_;this.isEditingSubmittedInput_=true;this.animator_.transitionFromResultToEditing(resultContainerHeight);this.$.textarea.transitionToEditing(fullBodyHeight);this.$.editTextarea.transitionToEditing(fullBodyHeight);this.apiProxy_.logEditInput()}onIsEditingSubmittedInputChanged_(){if(this.isEditingSubmittedInput_){this.$.editTextarea.focusInput()}}onSubmit_(){this.isSubmitEnabled_=this.$.textarea.validate();if(!this.isSubmitEnabled_){this.$.textarea.focusInput();return}this.$.textarea.scrollInputToTop();const bodyHeight=this.$.body.offsetHeight;const footerHeight=this.$.submitFooter.offsetHeight;this.submitted_=true;this.animator_.transitionOutSubmitFooter(bodyHeight,footerHeight);this.$.textarea.transitionToReadonly();this.compose_();this.lastTriggerElement_=TriggerElement.SUBMIT_INPUT}onSubmitEdit_(){this.isEditSubmitEnabled_=this.$.editTextarea.validate();if(!this.isEditSubmitEnabled_){this.$.editTextarea.focusInput();return}const bodyHeight=this.$.bodyAndFooter.offsetHeight;const editTextareaHeight=this.$.editTextarea.offsetHeight;this.isEditingSubmittedInput_=false;this.input_=this.editedInput_;this.animator_.transitionFromEditingToLoading(bodyHeight);this.$.textarea.transitionToReadonly(editTextareaHeight);this.$.editTextarea.transitionToReadonly(editTextareaHeight);this.compose_(true);this.lastTriggerElement_=TriggerElement.SUBMIT_INPUT}onAccept_(){this.apiProxy_.acceptComposeResult().then((success=>{if(success){this.apiProxy_.closeUi(CloseReason.kInsertButton)}}))}onInputChanged_(){this.userHasModifiedState_=true;if(!this.isSubmitEnabled_){this.isSubmitEnabled_=this.$.textarea.validate()}}onModifierChanged_(){const selectedModifier=Number(this.$.modifierMenu.value);this.rewrite_(selectedModifier);this.lastTriggerElement_=TriggerElement.MODIFIER;this.$.modifierMenu.selectedIndex=0}shouldShowInputModes_(){return!this.submitted_&&this.enableUpfrontInputModes}onPolishChipClick_(){this.selectedInputMode_=InputMode.kPolish;this.updateInputMode_()}onElaborateChipClick_(){this.selectedInputMode_=InputMode.kElaborate;this.updateInputMode_()}onFormalizeChipClick_(){this.selectedInputMode_=InputMode.kFormalize;this.updateInputMode_()}updateInputMode_(){this.userHasModifiedState_=true;this.$.polishChip.selected=this.selectedInputMode_===InputMode.kPolish;this.polishChipIcon_=this.$.polishChip.selected?"cr:check":"compose:polish";this.$.elaborateChip.selected=this.selectedInputMode_===InputMode.kElaborate;this.elaborateChipIcon_=this.$.elaborateChip.selected?"cr:check":"compose:elaborate";this.$.formalizeChip.selected=this.selectedInputMode_===InputMode.kFormalize;this.formalizeChipIcon_=this.$.formalizeChip.selected?"cr:check":"compose:formalize";this.saveComposeAppState_()}openModifierMenuOnKeyDown_(e){if(isMac){return}if(e.key==="ArrowDown"||e.key==="ArrowUp"){e.preventDefault();this.$.modifierMenu.showPicker()}}onFooterClick_(e){if(e.target.tagName!=="A"){return}e.preventDefault();switch(e.target.id){case"bugLink":this.apiProxy_.openBugReportingLink();break;case"surveyLink":this.apiProxy_.openFeedbackSurveyLink();break;case"signInLink":this.apiProxy_.openSignInPage();break;case"enterpriseLearnMore":this.apiProxy_.openEnterpriseComposeLearnMorePage();break;default:this.apiProxy_.openComposeLearnMorePage()}}onMsbbSettingsClick_(e){e.preventDefault();this.apiProxy_.openComposeSettings()}compose_(inputEdited=false){assert(this.$.textarea.validate());assert(this.submitted_);this.screenReaderAnnounce_(this.i18n("resultLoadingA11yMessage"));this.$.body.scrollTop=0;this.loading_=true;this.animator_.transitionInLoading();this.userResponseText_=undefined;this.response_=null;this.partialResponse_=undefined;this.feedbackEnabled_=true;this.saveComposeAppState_();this.apiProxy_.compose(this.input_,this.selectedInputMode_,inputEdited)}rewrite_(style){assert(this.$.textarea.validate());assert(this.submitted_);this.screenReaderAnnounce_(this.i18n("resultLoadingA11yMessage"));const bodyHeight=this.$.body.offsetHeight;const resultHeight=this.$.resultContainer.offsetHeight;this.$.body.scrollTop=0;this.loading_=true;this.userResponseText_=undefined;this.response_=null;this.partialResponse_=undefined;this.feedbackEnabled_=true;this.saveComposeAppState_();this.apiProxy_.rewrite(style);this.animator_.transitionFromResultToLoading(bodyHeight,resultHeight)}debounceUpdateResultComplete_(){this.updateResultCompleteDebouncer_=Debouncer.debounce(this.updateResultCompleteDebouncer_,microTask,(()=>this.updateResultComplete_()))}updateResultComplete_(){if(!this.response_){return}if(this.response_.status===ComposeStatus.kOk){if(!this.outputComplete_){return}}this.userResponseText_=undefined;const loadingHeight=this.$.loading.offsetHeight;this.loading_=false;this.undoEnabled_=this.response_.undoAvailable;this.$.textarea.transitionToEditable();if(!this.partialResponse_){if(this.response_.status===ComposeStatus.kOk){this.animator_.transitionFromLoadingToCompleteResult(loadingHeight)}}else{if(this.outputComplete_&&this.response_.status===ComposeStatus.kOk){this.animator_.transitionFromPartialToCompleteResult()}}switch(this.lastTriggerElement_){case TriggerElement.SUBMIT_INPUT:this.$.textarea.focusEditButton();break;case TriggerElement.MODIFIER:this.$.modifierMenu.focus({preventScroll:true});break;case TriggerElement.UNDO:this.$.undoButton.focus();break;case TriggerElement.REDO:this.$.redoButton.focus();break}this.screenReaderAnnounce_(this.i18n("resultUpdatedA11yMessage"),TIMEOUT_MS)}composeResponseReceived_(response){this.feedbackState_=CrFeedbackOption.UNSPECIFIED;this.response_=response;this.redoEnabled_=false;this.feedbackEnabled_=true}partialComposeResponseReceived_(partialResponse){assert(!this.response_);this.feedbackState_=CrFeedbackOption.UNSPECIFIED;this.partialResponse_=partialResponse}isLoadingIndicatorShown_(){return this.loading_&&!this.hasOutput_}hideResults_(){return!this.hasOutput_&&this.feedbackEnabled_}hasSuccessfulResponse_(){return this.response_?.status===ComposeStatus.kOk}hasPartialResponse_(){return Boolean(this.partialResponse_)}hasPartialOrCompleteResponse_(){return Boolean(this.partialResponse_)||this.hasSuccessfulResponse_()}hasFailedResponse_(){if(!this.response_){return false}return this.response_.status!==ComposeStatus.kOk}hasErrorWithLink_(){return this.hasUnsupportedLanguageResponse_()||this.hasPermissionDeniedResponse_()}hasUnsupportedLanguageResponse_(){if(!this.response_){return false}return this.response_.status===ComposeStatus.kUnsupportedLanguage}hasPermissionDeniedResponse_(){if(!this.response_){return false}return this.response_.status===ComposeStatus.kPermissionDenied}onDeviceEvaluationUsed_(){return Boolean(this.response_?.onDeviceEvaluationUsed)}showOnDeviceDogfoodFooter_(){return Boolean(this.response_?.onDeviceEvaluationUsed)&&loadTimeData.getBoolean("enableOnDeviceDogfoodFooter")}acceptButtonText_(){return this.textSelected_?this.i18n("replaceButton"):this.i18n("insertButton")}failedResponseErrorText_(){switch(this.response_?.status){case ComposeStatus.kFiltered:return this.i18n("errorFiltered");case ComposeStatus.kRequestThrottled:return this.i18n("errorRequestThrottled");case ComposeStatus.kOffline:return this.i18n("errorOffline");case ComposeStatus.kRequestTimeout:return this.i18n("errorTryAgainLater");case ComposeStatus.kClientError:case ComposeStatus.kMisconfiguration:case ComposeStatus.kServerError:case ComposeStatus.kInvalidRequest:case ComposeStatus.kRetryableError:case ComposeStatus.kNonRetryableError:case ComposeStatus.kDisabled:case ComposeStatus.kCancelled:case ComposeStatus.kNoResponse:default:return this.i18n("errorTryAgain")}}isBackFromErrorAvailable_(){return Boolean(this.response_?.status===ComposeStatus.kFiltered&&this.response_?.triggeredFromModifier)}onResultEdit_(e){this.userResponseText_=e.detail;this.apiProxy_.editResult(this.userResponseText_).then((isEdited=>{if(isEdited){this.undoEnabled_=true;this.redoEnabled_=false;this.feedbackEnabled_=false;this.feedbackState_=CrFeedbackOption.UNSPECIFIED}}))}onSetResultFocus_(e){this.isEditingResultText_=e.detail}saveComposeAppState_(){if(this.saveAppStateDebouncer_?.isActive()){this.saveAppStateDebouncer_.flush();return}if(!this.userHasModifiedState_){return}const state={input:this.input_,inputMode:this.selectedInputMode_};if(this.isEditingSubmittedInput_){state.isEditingSubmittedInput=this.isEditingSubmittedInput_;state.editedInput=this.editedInput_}this.apiProxy_.saveWebuiState(JSON.stringify(state))}async onUndoClick_(){this.screenReaderAnnounce_(this.i18n("undoResultA11yMessage"));try{const state=await this.apiProxy_.undo();if(state==null){this.undoEnabled_=false;return}this.updateWithNewState_(state);if(this.undoEnabled_){this.lastTriggerElement_=TriggerElement.UNDO}else{this.lastTriggerElement_=TriggerElement.REDO}}catch(error){}}async onErrorGoBackButton_(){try{const state=await this.apiProxy_.recoverFromErrorState();assert(state);this.updateWithNewState_(state)}catch(error){}}async onRedoClick_(){this.screenReaderAnnounce_(this.i18n("redoResultA11yMessage"));try{const state=await this.apiProxy_.redo();if(state==null){this.redoEnabled_=false;return}this.updateWithNewState_(state);if(this.redoEnabled_){this.lastTriggerElement_=TriggerElement.REDO}else{this.lastTriggerElement_=TriggerElement.UNDO}}catch(error){}}updateWithNewState_(state){this.feedbackEnabled_=!state.response?.providedByUser;this.userResponseText_=this.feedbackEnabled_?undefined:state.response?.result;this.response_=state.response;this.partialResponse_=undefined;this.undoEnabled_=Boolean(state.response?.undoAvailable);this.redoEnabled_=Boolean(state.response?.redoAvailable);this.feedbackState_=userFeedbackToFeedbackOption(state.feedback);if(state.webuiState){const appState=JSON.parse(state.webuiState);this.input_=appState.input}}screenReaderAnnounce_(message,wait=0){setTimeout((()=>{const announcer=getAnnouncerInstance();announcer.announce(message,wait)}))}onFeedbackSelectedOptionChanged_(e){this.feedbackState_=e.detail.value;switch(e.detail.value){case CrFeedbackOption.UNSPECIFIED:this.apiProxy_.setUserFeedback(UserFeedback.kUserFeedbackUnspecified);return;case CrFeedbackOption.THUMBS_UP:this.apiProxy_.setUserFeedback(UserFeedback.kUserFeedbackPositive);return;case CrFeedbackOption.THUMBS_DOWN:this.apiProxy_.setUserFeedback(UserFeedback.kUserFeedbackNegative);return}}}function userFeedbackToFeedbackOption(userFeedback){switch(userFeedback){case UserFeedback.kUserFeedbackUnspecified:return CrFeedbackOption.UNSPECIFIED;case UserFeedback.kUserFeedbackPositive:return CrFeedbackOption.THUMBS_UP;case UserFeedback.kUserFeedbackNegative:return CrFeedbackOption.THUMBS_DOWN}}customElements.define(ComposeAppElement.is,ComposeAppElement);