import type { TableElement } from './table.js';
/**
 * @fileoverview
 * DragAndDropManager facilitates drag-and-drop interactions within a
 * `product-specifications-table` HTMLElement, allowing users to reorder columns
 * by dragging them over one another.
 *
 * Note: DragAndDropManager relies on the table being a CSS Grid.
 *
 * Upon the table's owner document firing a 'dragstart' event,
 * DragAndDropManager adds listeners to the owner document and table for
 * relevant drag events.
 *
 * When the dragging column hovers over another column, its potential new
 * position is visually indicated by updating its 'order' CSS property.
 *
 * Releasing the dragging column over a valid drop target (another column),
 * notifies the `product-specifications-table` to update its internal column
 * order and, subsequently, their DOM positions. Listeners are then removed from
 * the document and table for non-'dragstart' drag events.
 *
 * Leaving the table mid-drag drops the dragging column at the position where
 * the 'dragleave' event was triggered.
 *
 * Once drag-and-drop ends regardless of its outcome (success, failure, or
 * cancellation), each column's CSS 'order' property is removed, to ensure the
 * visual layout matches the underlying data structure.
 */
export declare const IS_FIRST_COLUMN_ATTR: string;
export declare class DragAndDropManager {
    private dragImage_;
    private eventTracker_;
    private tableElement_;
    private pendingOrder_;
    constructor(tableElement: TableElement);
    private get columnElements_();
    destroy(): void;
    tablePropertiesUpdated(): void;
    private syncVisualOrderWithDom;
    private resetVisualOrder;
    private onDragStart_;
    private dragStart_;
    private dragOver_;
    private drop_;
    private dragEnd_;
}
