// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import './description_citation.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { getCss } from './description_section.css.js';
import { getHtml } from './description_section.html.js';
export class DescriptionSectionElement extends CrLitElement {
    static get is() {
        return 'description-section';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    willUpdate(changedProperties) {
        this.citationCount = (this.description.summary || [])
            .map(summary => summary.urls.length)
            .reduce((count, current) => count + current, 0);
        super.willUpdate(changedProperties);
    }
    static get properties() {
        return {
            citationCount: { type: Number },
            description: { type: Object },
            productName: { type: String },
        };
    }
    #description_accessor_storage = {
        attributes: [],
        summary: [],
    };
    get description() { return this.#description_accessor_storage; }
    set description(value) { this.#description_accessor_storage = value; }
    #productName_accessor_storage = '';
    get productName() { return this.#productName_accessor_storage; }
    set productName(value) { this.#productName_accessor_storage = value; }
    #citationCount_accessor_storage = 0;
    get citationCount() { return this.#citationCount_accessor_storage; }
    set citationCount(value) { this.#citationCount_accessor_storage = value; }
    computeCitationIndex_(summaryIndex, urlIndex) {
        // Citations should start from 1.
        let citationIndex = 1;
        for (let i = 0; i < summaryIndex; i++) {
            citationIndex += this.description.summary[i]?.urls.length || 0;
        }
        return citationIndex + urlIndex;
    }
    summaryIsEmpty_(summary) {
        return summary.length === 0 || summary.every(summary => {
            return summary.text.length === 0 || summary.text === 'N/A';
        });
    }
}
customElements.define(DescriptionSectionElement.is, DescriptionSectionElement);
