// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import 'chrome://resources/cr_elements/cr_icons.css.js';
import { OpenWindowProxyImpl } from 'chrome://resources/js/open_window_proxy.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { getCss } from './buying_options_section.css.js';
import { getHtml } from './buying_options_section.html.js';
export class BuyingOptionsSectionElement extends CrLitElement {
    static get is() {
        return 'buying-options-section';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            price: { type: String },
            jackpotUrl: { type: String },
        };
    }
    #price_accessor_storage = '';
    get price() { return this.#price_accessor_storage; }
    set price(value) { this.#price_accessor_storage = value; }
    #jackpotUrl_accessor_storage = '';
    get jackpotUrl() { return this.#jackpotUrl_accessor_storage; }
    set jackpotUrl(value) { this.#jackpotUrl_accessor_storage = value; }
    openJackpotUrl_() {
        OpenWindowProxyImpl.getInstance().openUrl(this.jackpotUrl);
        chrome.metricsPrivate.recordUserAction('Commerce.Compare.BuyingOptionsClicked');
    }
}
customElements.define(BuyingOptionsSectionElement.is, BuyingOptionsSectionElement);
