// chrome/browser/resources/certificate_manager/certificate_manager.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/resources/certificate_manager/certificate_manager.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/resources/certificate_manager/certificate_manager.mojom-params-data.h"
namespace certificate_manager {
namespace mojom {

NOINLINE static const char* CertificateSourceToStringHelper(CertificateSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CertificateSource::kChromeRootStore:
      return "kChromeRootStore";
    case CertificateSource::kPlatformClientCert:
      return "kPlatformClientCert";
    case CertificateSource::kEnterpriseTrustedCerts:
      return "kEnterpriseTrustedCerts";
    case CertificateSource::kEnterpriseIntermediateCerts:
      return "kEnterpriseIntermediateCerts";
    case CertificateSource::kEnterpriseDistrustedCerts:
      return "kEnterpriseDistrustedCerts";
    case CertificateSource::kPlatformUserTrustedCerts:
      return "kPlatformUserTrustedCerts";
    case CertificateSource::kPlatformUserIntermediateCerts:
      return "kPlatformUserIntermediateCerts";
    case CertificateSource::kPlatformUserDistrustedCerts:
      return "kPlatformUserDistrustedCerts";
    case CertificateSource::kProvisionedClientCert:
      return "kProvisionedClientCert";
    case CertificateSource::kUserTrustedCerts:
      return "kUserTrustedCerts";
    case CertificateSource::kUserIntermediateCerts:
      return "kUserIntermediateCerts";
    case CertificateSource::kUserDistrustedCerts:
      return "kUserDistrustedCerts";
    default:
      return nullptr;
  }
}

std::string CertificateSourceToString(CertificateSource value) {
  const char *str = CertificateSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CertificateSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CertificateSource value) {
  return os << CertificateSourceToString(value);
}

NOINLINE static const char* SuccessResultToStringHelper(SuccessResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SuccessResult::kSuccess:
      return "kSuccess";
    default:
      return nullptr;
  }
}

std::string SuccessResultToString(SuccessResult value) {
  const char *str = SuccessResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SuccessResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SuccessResult value) {
  return os << SuccessResultToString(value);
}

namespace internal {
// static
bool ActionResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const ActionResult_Data* object = static_cast<const ActionResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case ActionResult_Tag::kError: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& error_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_error, validation_context,
                                             &error_validate_params)) {
        return false;
      }
      return true;
    }
    case ActionResult_Tag::kSuccess: {


      if (!::certificate_manager::mojom::internal::SuccessResult_Data
            ::Validate(object->data.f_success, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in ActionResult");
      return false;
    }
  }
}


// static
bool SummaryCertInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SummaryCertInfo_Data* object =
      static_cast<const SummaryCertInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sha256hash_hex, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sha256hash_hex_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sha256hash_hex, validation_context,
                                         &sha256hash_hex_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_name, validation_context,
                                         &display_name_validate_params)) {
    return false;
  }

  return true;
}

SummaryCertInfo_Data::SummaryCertInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertManagementMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertManagementMetadata_Data* object =
      static_cast<const CertManagementMetadata_Data*>(data);

  return true;
}

CertManagementMetadata_Data::CertManagementMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_Params_Data* object =
      static_cast<const CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_Params_Data::CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateManagerPageHandler_GetCertificates_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateManagerPageHandler_GetCertificates_Params_Data* object =
      static_cast<const CertificateManagerPageHandler_GetCertificates_Params_Data*>(data);


  if (!::certificate_manager::mojom::internal::CertificateSource_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

CertificateManagerPageHandler_GetCertificates_Params_Data::CertificateManagerPageHandler_GetCertificates_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateManagerPageHandler_GetCertificates_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateManagerPageHandler_GetCertificates_ResponseParams_Data* object =
      static_cast<const CertificateManagerPageHandler_GetCertificates_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->certs, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& certs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->certs, validation_context,
                                         &certs_validate_params)) {
    return false;
  }

  return true;
}

CertificateManagerPageHandler_GetCertificates_ResponseParams_Data::CertificateManagerPageHandler_GetCertificates_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateManagerPageHandler_GetCertManagementMetadata_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateManagerPageHandler_GetCertManagementMetadata_Params_Data* object =
      static_cast<const CertificateManagerPageHandler_GetCertManagementMetadata_Params_Data*>(data);

  return true;
}

CertificateManagerPageHandler_GetCertManagementMetadata_Params_Data::CertificateManagerPageHandler_GetCertManagementMetadata_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParams_Data* object =
      static_cast<const CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  return true;
}

CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParams_Data::CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateManagerPageHandler_ViewCertificate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateManagerPageHandler_ViewCertificate_Params_Data* object =
      static_cast<const CertificateManagerPageHandler_ViewCertificate_Params_Data*>(data);


  if (!::certificate_manager::mojom::internal::CertificateSource_Data
        ::Validate(object->source, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sha256_hash_hex, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sha256_hash_hex_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sha256_hash_hex, validation_context,
                                         &sha256_hash_hex_validate_params)) {
    return false;
  }

  return true;
}

CertificateManagerPageHandler_ViewCertificate_Params_Data::CertificateManagerPageHandler_ViewCertificate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateManagerPageHandler_ExportCertificates_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateManagerPageHandler_ExportCertificates_Params_Data* object =
      static_cast<const CertificateManagerPageHandler_ExportCertificates_Params_Data*>(data);


  if (!::certificate_manager::mojom::internal::CertificateSource_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

CertificateManagerPageHandler_ExportCertificates_Params_Data::CertificateManagerPageHandler_ExportCertificates_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateManagerPageHandler_ImportCertificate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateManagerPageHandler_ImportCertificate_Params_Data* object =
      static_cast<const CertificateManagerPageHandler_ImportCertificate_Params_Data*>(data);


  if (!::certificate_manager::mojom::internal::CertificateSource_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

CertificateManagerPageHandler_ImportCertificate_Params_Data::CertificateManagerPageHandler_ImportCertificate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateManagerPageHandler_ImportCertificate_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateManagerPageHandler_ImportCertificate_ResponseParams_Data* object =
      static_cast<const CertificateManagerPageHandler_ImportCertificate_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

CertificateManagerPageHandler_ImportCertificate_ResponseParams_Data::CertificateManagerPageHandler_ImportCertificate_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateManagerPageHandler_ImportAndBindCertificate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateManagerPageHandler_ImportAndBindCertificate_Params_Data* object =
      static_cast<const CertificateManagerPageHandler_ImportAndBindCertificate_Params_Data*>(data);


  if (!::certificate_manager::mojom::internal::CertificateSource_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

CertificateManagerPageHandler_ImportAndBindCertificate_Params_Data::CertificateManagerPageHandler_ImportAndBindCertificate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParams_Data* object =
      static_cast<const CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParams_Data::CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateManagerPageHandler_DeleteCertificate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateManagerPageHandler_DeleteCertificate_Params_Data* object =
      static_cast<const CertificateManagerPageHandler_DeleteCertificate_Params_Data*>(data);


  if (!::certificate_manager::mojom::internal::CertificateSource_Data
        ::Validate(object->source, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_name, validation_context,
                                         &display_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sha256_hash_hex, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sha256_hash_hex_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sha256_hash_hex, validation_context,
                                         &sha256_hash_hex_validate_params)) {
    return false;
  }

  return true;
}

CertificateManagerPageHandler_DeleteCertificate_Params_Data::CertificateManagerPageHandler_DeleteCertificate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateManagerPageHandler_DeleteCertificate_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateManagerPageHandler_DeleteCertificate_ResponseParams_Data* object =
      static_cast<const CertificateManagerPageHandler_DeleteCertificate_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

CertificateManagerPageHandler_DeleteCertificate_ResponseParams_Data::CertificateManagerPageHandler_DeleteCertificate_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateManagerPageHandler_ShowNativeManageCertificates_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateManagerPageHandler_ShowNativeManageCertificates_Params_Data* object =
      static_cast<const CertificateManagerPageHandler_ShowNativeManageCertificates_Params_Data*>(data);

  return true;
}

CertificateManagerPageHandler_ShowNativeManageCertificates_Params_Data::CertificateManagerPageHandler_ShowNativeManageCertificates_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateManagerPageHandler_SetIncludeSystemTrustStore_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateManagerPageHandler_SetIncludeSystemTrustStore_Params_Data* object =
      static_cast<const CertificateManagerPageHandler_SetIncludeSystemTrustStore_Params_Data*>(data);

  return true;
}

CertificateManagerPageHandler_SetIncludeSystemTrustStore_Params_Data::CertificateManagerPageHandler_SetIncludeSystemTrustStore_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateManagerPage_AskForImportPassword_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateManagerPage_AskForImportPassword_Params_Data* object =
      static_cast<const CertificateManagerPage_AskForImportPassword_Params_Data*>(data);

  return true;
}

CertificateManagerPage_AskForImportPassword_Params_Data::CertificateManagerPage_AskForImportPassword_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateManagerPage_AskForImportPassword_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateManagerPage_AskForImportPassword_ResponseParams_Data* object =
      static_cast<const CertificateManagerPage_AskForImportPassword_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& password_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->password, validation_context,
                                         &password_validate_params)) {
    return false;
  }

  return true;
}

CertificateManagerPage_AskForImportPassword_ResponseParams_Data::CertificateManagerPage_AskForImportPassword_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateManagerPage_AskForConfirmation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateManagerPage_AskForConfirmation_Params_Data* object =
      static_cast<const CertificateManagerPage_AskForConfirmation_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

CertificateManagerPage_AskForConfirmation_Params_Data::CertificateManagerPage_AskForConfirmation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateManagerPage_AskForConfirmation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateManagerPage_AskForConfirmation_ResponseParams_Data* object =
      static_cast<const CertificateManagerPage_AskForConfirmation_ResponseParams_Data*>(data);

  return true;
}

CertificateManagerPage_AskForConfirmation_ResponseParams_Data::CertificateManagerPage_AskForConfirmation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateManagerPage_TriggerReload_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateManagerPage_TriggerReload_Params_Data* object =
      static_cast<const CertificateManagerPage_TriggerReload_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sources, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sources_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::certificate_manager::mojom::internal::CertificateSource_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->sources, validation_context,
                                         &sources_validate_params)) {
    return false;
  }

  return true;
}

CertificateManagerPage_TriggerReload_Params_Data::CertificateManagerPage_TriggerReload_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateManagerPage_TriggerMetadataUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateManagerPage_TriggerMetadataUpdate_Params_Data* object =
      static_cast<const CertificateManagerPage_TriggerMetadataUpdate_Params_Data*>(data);

  return true;
}

CertificateManagerPage_TriggerMetadataUpdate_Params_Data::CertificateManagerPage_TriggerMetadataUpdate_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace certificate_manager

namespace perfetto {

// static
void TraceFormatTraits<::certificate_manager::mojom::CertificateSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::certificate_manager::mojom::CertificateSource value) {
  return std::move(context).WriteString(::certificate_manager::mojom::CertificateSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::certificate_manager::mojom::SuccessResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::certificate_manager::mojom::SuccessResult value) {
  return std::move(context).WriteString(::certificate_manager::mojom::SuccessResultToString(value));
}

} // namespace perfetto