/**
 * A list item that displays the properties of a CharacteristicInfo object.
 * Two fieldsets are created within the element: one for the primitive
 * properties, 'id' and 'uuid', and one for the 'properties' bitfield in the
 * CharacteristicInfo object.
 */
export class CharacteristicListItemElement extends CustomElement {
    /** @type {?CharacteristicInfo} */
    info: CharacteristicInfo | null;
    /** @private {string} */
    private deviceAddress_;
    /** @private {string} */
    private serviceId_;
    connectedCallback(): void;
    /**
     * @param {!CharacteristicInfo} characteristicInfo
     * @param {string} deviceAddress
     * @param {string} serviceId
     */
    initialize(characteristicInfo: CharacteristicInfo, deviceAddress: string, serviceId: string): void;
}
import { CustomElement } from 'chrome://resources/js/custom_element.js';
