// chrome/browser/new_tab_page/modules/safe_browsing/safe_browsing.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_NEW_TAB_PAGE_MODULES_SAFE_BROWSING_SAFE_BROWSING_MOJOM_H_
#define CHROME_BROWSER_NEW_TAB_PAGE_MODULES_SAFE_BROWSING_SAFE_BROWSING_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/new_tab_page/modules/safe_browsing/safe_browsing.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/new_tab_page/modules/safe_browsing/safe_browsing.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/new_tab_page/modules/safe_browsing/safe_browsing.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace ntp::safe_browsing::mojom {

class SafeBrowsingHandlerProxy;

template <typename ImplRefTraits>
class SafeBrowsingHandlerStub;

class SafeBrowsingHandlerRequestValidator;
class SafeBrowsingHandlerResponseValidator;


class SafeBrowsingHandler
    : public SafeBrowsingHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "ntp.safe_browsing.mojom.SafeBrowsingHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SafeBrowsingHandlerInterfaceBase;
  using Proxy_ = SafeBrowsingHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = SafeBrowsingHandlerStub<ImplRefTraits>;

  using RequestValidator_ = SafeBrowsingHandlerRequestValidator;
  using ResponseValidator_ = SafeBrowsingHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCanShowModuleMinVersion = 0,
    kProcessModuleClickMinVersion = 0,
    kDismissModuleMinVersion = 0,
    kRestoreModuleMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CanShowModule_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ProcessModuleClick_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DismissModule_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RestoreModule_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SafeBrowsingHandler() = default;

  using CanShowModuleCallback = base::OnceCallback<void(bool)>;
  using CanShowModuleMojoCallback = base::OnceCallback<void(bool)>;

  virtual void CanShowModule(CanShowModuleCallback callback) = 0;

  virtual void ProcessModuleClick() = 0;

  virtual void DismissModule() = 0;

  virtual void RestoreModule() = 0;
};



class  SafeBrowsingHandlerProxy
    : public SafeBrowsingHandler {
 public:
  using InterfaceType = SafeBrowsingHandler;

  explicit SafeBrowsingHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CanShowModule(CanShowModuleCallback callback) final;
  
  void ProcessModuleClick() final;
  
  void DismissModule() final;
  
  void RestoreModule() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SafeBrowsingHandlerStubDispatch {
 public:
  static bool Accept(SafeBrowsingHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SafeBrowsingHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SafeBrowsingHandler>>
class SafeBrowsingHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SafeBrowsingHandlerStub() = default;
  ~SafeBrowsingHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SafeBrowsingHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SafeBrowsingHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SafeBrowsingHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SafeBrowsingHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // ntp::safe_browsing::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_BROWSER_NEW_TAB_PAGE_MODULES_SAFE_BROWSING_SAFE_BROWSING_MOJOM_H_