// chrome/browser/media/media_engagement_score_details.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_MEDIA_MEDIA_ENGAGEMENT_SCORE_DETAILS_MOJOM_H_
#define CHROME_BROWSER_MEDIA_MEDIA_ENGAGEMENT_SCORE_DETAILS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/media/media_engagement_score_details.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/media/media_engagement_score_details.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/media/media_engagement_score_details.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace media::mojom {

class MediaEngagementScoreDetailsProviderProxy;

template <typename ImplRefTraits>
class MediaEngagementScoreDetailsProviderStub;

class MediaEngagementScoreDetailsProviderRequestValidator;
class MediaEngagementScoreDetailsProviderResponseValidator;


class MediaEngagementScoreDetailsProvider
    : public MediaEngagementScoreDetailsProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.MediaEngagementScoreDetailsProvider";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaEngagementScoreDetailsProviderInterfaceBase;
  using Proxy_ = MediaEngagementScoreDetailsProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaEngagementScoreDetailsProviderStub<ImplRefTraits>;

  using RequestValidator_ = MediaEngagementScoreDetailsProviderRequestValidator;
  using ResponseValidator_ = MediaEngagementScoreDetailsProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetMediaEngagementScoreDetailsMinVersion = 0,
    kGetMediaEngagementConfigMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetMediaEngagementScoreDetails_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetMediaEngagementConfig_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaEngagementScoreDetailsProvider() = default;

  using GetMediaEngagementScoreDetailsCallback = base::OnceCallback<void(std::vector<MediaEngagementScoreDetailsPtr>)>;
  using GetMediaEngagementScoreDetailsMojoCallback = base::OnceCallback<void(std::vector<MediaEngagementScoreDetailsPtr>)>;

  virtual void GetMediaEngagementScoreDetails(GetMediaEngagementScoreDetailsCallback callback) = 0;

  using GetMediaEngagementConfigCallback = base::OnceCallback<void(MediaEngagementConfigPtr)>;
  using GetMediaEngagementConfigMojoCallback = base::OnceCallback<void(MediaEngagementConfigPtr)>;

  virtual void GetMediaEngagementConfig(GetMediaEngagementConfigCallback callback) = 0;
};



class  MediaEngagementScoreDetailsProviderProxy
    : public MediaEngagementScoreDetailsProvider {
 public:
  using InterfaceType = MediaEngagementScoreDetailsProvider;

  explicit MediaEngagementScoreDetailsProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetMediaEngagementScoreDetails(GetMediaEngagementScoreDetailsCallback callback) final;
  
  void GetMediaEngagementConfig(GetMediaEngagementConfigCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MediaEngagementScoreDetailsProviderStubDispatch {
 public:
  static bool Accept(MediaEngagementScoreDetailsProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaEngagementScoreDetailsProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaEngagementScoreDetailsProvider>>
class MediaEngagementScoreDetailsProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaEngagementScoreDetailsProviderStub() = default;
  ~MediaEngagementScoreDetailsProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaEngagementScoreDetailsProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaEngagementScoreDetailsProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaEngagementScoreDetailsProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaEngagementScoreDetailsProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  MediaEngagementScoreDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaEngagementScoreDetails, T>::value>;
  using DataView = MediaEngagementScoreDetailsDataView;
  using Data_ = internal::MediaEngagementScoreDetails_Data;

  template <typename... Args>
  static MediaEngagementScoreDetailsPtr New(Args&&... args) {
    return MediaEngagementScoreDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaEngagementScoreDetailsPtr From(const U& u) {
    return mojo::TypeConverter<MediaEngagementScoreDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaEngagementScoreDetails>::Convert(*this);
  }


  MediaEngagementScoreDetails();

  MediaEngagementScoreDetails(
      const ::url::Origin& origin,
      double total_score,
      int32_t visits,
      int32_t media_playbacks,
      double last_media_playback_time,
      bool is_high);


  ~MediaEngagementScoreDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaEngagementScoreDetailsPtr>
  MediaEngagementScoreDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaEngagementScoreDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MediaEngagementScoreDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MediaEngagementScoreDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaEngagementScoreDetails::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaEngagementScoreDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaEngagementScoreDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaEngagementScoreDetails_UnserializedMessageContext<
            UserType, MediaEngagementScoreDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MediaEngagementScoreDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MediaEngagementScoreDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaEngagementScoreDetails_UnserializedMessageContext<
            UserType, MediaEngagementScoreDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaEngagementScoreDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin origin;
  
  double total_score;
  
  int32_t visits;
  
  int32_t media_playbacks;
  
  double last_media_playback_time;
  
  bool is_high;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaEngagementScoreDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaEngagementScoreDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaEngagementScoreDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaEngagementScoreDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MediaEngagementConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaEngagementConfig, T>::value>;
  using DataView = MediaEngagementConfigDataView;
  using Data_ = internal::MediaEngagementConfig_Data;

  template <typename... Args>
  static MediaEngagementConfigPtr New(Args&&... args) {
    return MediaEngagementConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaEngagementConfigPtr From(const U& u) {
    return mojo::TypeConverter<MediaEngagementConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaEngagementConfig>::Convert(*this);
  }


  MediaEngagementConfig();

  MediaEngagementConfig(
      int32_t score_min_visits,
      double high_score_lower_threshold,
      double high_score_upper_threshold,
      bool feature_record_data,
      bool feature_bypass_autoplay,
      bool feature_preload_data,
      bool feature_https_only,
      bool feature_autoplay_disable_settings,
      bool pref_disable_unified_autoplay,
      bool has_custom_autoplay_policy,
      const std::string& autoplay_policy,
      const std::string& preload_version);


  ~MediaEngagementConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaEngagementConfigPtr>
  MediaEngagementConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaEngagementConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MediaEngagementConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MediaEngagementConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaEngagementConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaEngagementConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaEngagementConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaEngagementConfig_UnserializedMessageContext<
            UserType, MediaEngagementConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MediaEngagementConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MediaEngagementConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaEngagementConfig_UnserializedMessageContext<
            UserType, MediaEngagementConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaEngagementConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t score_min_visits;
  
  double high_score_lower_threshold;
  
  double high_score_upper_threshold;
  
  bool feature_record_data;
  
  bool feature_bypass_autoplay;
  
  bool feature_preload_data;
  
  bool feature_https_only;
  
  bool feature_autoplay_disable_settings;
  
  bool pref_disable_unified_autoplay;
  
  bool has_custom_autoplay_policy;
  
  std::string autoplay_policy;
  
  std::string preload_version;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaEngagementConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaEngagementConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaEngagementConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaEngagementConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
MediaEngagementScoreDetailsPtr MediaEngagementScoreDetails::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(total_score),
      mojo::Clone(visits),
      mojo::Clone(media_playbacks),
      mojo::Clone(last_media_playback_time),
      mojo::Clone(is_high)
  );
}

template <typename T, MediaEngagementScoreDetails::EnableIfSame<T>*>
bool MediaEngagementScoreDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->total_score, other_struct.total_score))
    return false;
  if (!mojo::Equals(this->visits, other_struct.visits))
    return false;
  if (!mojo::Equals(this->media_playbacks, other_struct.media_playbacks))
    return false;
  if (!mojo::Equals(this->last_media_playback_time, other_struct.last_media_playback_time))
    return false;
  if (!mojo::Equals(this->is_high, other_struct.is_high))
    return false;
  return true;
}

template <typename T, MediaEngagementScoreDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.total_score < rhs.total_score)
    return true;
  if (rhs.total_score < lhs.total_score)
    return false;
  if (lhs.visits < rhs.visits)
    return true;
  if (rhs.visits < lhs.visits)
    return false;
  if (lhs.media_playbacks < rhs.media_playbacks)
    return true;
  if (rhs.media_playbacks < lhs.media_playbacks)
    return false;
  if (lhs.last_media_playback_time < rhs.last_media_playback_time)
    return true;
  if (rhs.last_media_playback_time < lhs.last_media_playback_time)
    return false;
  if (lhs.is_high < rhs.is_high)
    return true;
  if (rhs.is_high < lhs.is_high)
    return false;
  return false;
}
template <typename StructPtrType>
MediaEngagementConfigPtr MediaEngagementConfig::Clone() const {
  return New(
      mojo::Clone(score_min_visits),
      mojo::Clone(high_score_lower_threshold),
      mojo::Clone(high_score_upper_threshold),
      mojo::Clone(feature_record_data),
      mojo::Clone(feature_bypass_autoplay),
      mojo::Clone(feature_preload_data),
      mojo::Clone(feature_https_only),
      mojo::Clone(feature_autoplay_disable_settings),
      mojo::Clone(pref_disable_unified_autoplay),
      mojo::Clone(has_custom_autoplay_policy),
      mojo::Clone(autoplay_policy),
      mojo::Clone(preload_version)
  );
}

template <typename T, MediaEngagementConfig::EnableIfSame<T>*>
bool MediaEngagementConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->score_min_visits, other_struct.score_min_visits))
    return false;
  if (!mojo::Equals(this->high_score_lower_threshold, other_struct.high_score_lower_threshold))
    return false;
  if (!mojo::Equals(this->high_score_upper_threshold, other_struct.high_score_upper_threshold))
    return false;
  if (!mojo::Equals(this->feature_record_data, other_struct.feature_record_data))
    return false;
  if (!mojo::Equals(this->feature_bypass_autoplay, other_struct.feature_bypass_autoplay))
    return false;
  if (!mojo::Equals(this->feature_preload_data, other_struct.feature_preload_data))
    return false;
  if (!mojo::Equals(this->feature_https_only, other_struct.feature_https_only))
    return false;
  if (!mojo::Equals(this->feature_autoplay_disable_settings, other_struct.feature_autoplay_disable_settings))
    return false;
  if (!mojo::Equals(this->pref_disable_unified_autoplay, other_struct.pref_disable_unified_autoplay))
    return false;
  if (!mojo::Equals(this->has_custom_autoplay_policy, other_struct.has_custom_autoplay_policy))
    return false;
  if (!mojo::Equals(this->autoplay_policy, other_struct.autoplay_policy))
    return false;
  if (!mojo::Equals(this->preload_version, other_struct.preload_version))
    return false;
  return true;
}

template <typename T, MediaEngagementConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.score_min_visits < rhs.score_min_visits)
    return true;
  if (rhs.score_min_visits < lhs.score_min_visits)
    return false;
  if (lhs.high_score_lower_threshold < rhs.high_score_lower_threshold)
    return true;
  if (rhs.high_score_lower_threshold < lhs.high_score_lower_threshold)
    return false;
  if (lhs.high_score_upper_threshold < rhs.high_score_upper_threshold)
    return true;
  if (rhs.high_score_upper_threshold < lhs.high_score_upper_threshold)
    return false;
  if (lhs.feature_record_data < rhs.feature_record_data)
    return true;
  if (rhs.feature_record_data < lhs.feature_record_data)
    return false;
  if (lhs.feature_bypass_autoplay < rhs.feature_bypass_autoplay)
    return true;
  if (rhs.feature_bypass_autoplay < lhs.feature_bypass_autoplay)
    return false;
  if (lhs.feature_preload_data < rhs.feature_preload_data)
    return true;
  if (rhs.feature_preload_data < lhs.feature_preload_data)
    return false;
  if (lhs.feature_https_only < rhs.feature_https_only)
    return true;
  if (rhs.feature_https_only < lhs.feature_https_only)
    return false;
  if (lhs.feature_autoplay_disable_settings < rhs.feature_autoplay_disable_settings)
    return true;
  if (rhs.feature_autoplay_disable_settings < lhs.feature_autoplay_disable_settings)
    return false;
  if (lhs.pref_disable_unified_autoplay < rhs.pref_disable_unified_autoplay)
    return true;
  if (rhs.pref_disable_unified_autoplay < lhs.pref_disable_unified_autoplay)
    return false;
  if (lhs.has_custom_autoplay_policy < rhs.has_custom_autoplay_policy)
    return true;
  if (rhs.has_custom_autoplay_policy < lhs.has_custom_autoplay_policy)
    return false;
  if (lhs.autoplay_policy < rhs.autoplay_policy)
    return true;
  if (rhs.autoplay_policy < lhs.autoplay_policy)
    return false;
  if (lhs.preload_version < rhs.preload_version)
    return true;
  if (rhs.preload_version < lhs.preload_version)
    return false;
  return false;
}


}  // media::mojom

namespace mojo {


template <>
struct  StructTraits<::media::mojom::MediaEngagementScoreDetails::DataView,
                                         ::media::mojom::MediaEngagementScoreDetailsPtr> {
  static bool IsNull(const ::media::mojom::MediaEngagementScoreDetailsPtr& input) { return !input; }
  static void SetToNull(::media::mojom::MediaEngagementScoreDetailsPtr* output) { output->reset(); }

  static const decltype(::media::mojom::MediaEngagementScoreDetails::origin)& origin(
      const ::media::mojom::MediaEngagementScoreDetailsPtr& input) {
    return input->origin;
  }

  static decltype(::media::mojom::MediaEngagementScoreDetails::total_score) total_score(
      const ::media::mojom::MediaEngagementScoreDetailsPtr& input) {
    return input->total_score;
  }

  static decltype(::media::mojom::MediaEngagementScoreDetails::visits) visits(
      const ::media::mojom::MediaEngagementScoreDetailsPtr& input) {
    return input->visits;
  }

  static decltype(::media::mojom::MediaEngagementScoreDetails::media_playbacks) media_playbacks(
      const ::media::mojom::MediaEngagementScoreDetailsPtr& input) {
    return input->media_playbacks;
  }

  static decltype(::media::mojom::MediaEngagementScoreDetails::last_media_playback_time) last_media_playback_time(
      const ::media::mojom::MediaEngagementScoreDetailsPtr& input) {
    return input->last_media_playback_time;
  }

  static decltype(::media::mojom::MediaEngagementScoreDetails::is_high) is_high(
      const ::media::mojom::MediaEngagementScoreDetailsPtr& input) {
    return input->is_high;
  }

  static bool Read(::media::mojom::MediaEngagementScoreDetails::DataView input, ::media::mojom::MediaEngagementScoreDetailsPtr* output);
};


template <>
struct  StructTraits<::media::mojom::MediaEngagementConfig::DataView,
                                         ::media::mojom::MediaEngagementConfigPtr> {
  static bool IsNull(const ::media::mojom::MediaEngagementConfigPtr& input) { return !input; }
  static void SetToNull(::media::mojom::MediaEngagementConfigPtr* output) { output->reset(); }

  static decltype(::media::mojom::MediaEngagementConfig::score_min_visits) score_min_visits(
      const ::media::mojom::MediaEngagementConfigPtr& input) {
    return input->score_min_visits;
  }

  static decltype(::media::mojom::MediaEngagementConfig::high_score_lower_threshold) high_score_lower_threshold(
      const ::media::mojom::MediaEngagementConfigPtr& input) {
    return input->high_score_lower_threshold;
  }

  static decltype(::media::mojom::MediaEngagementConfig::high_score_upper_threshold) high_score_upper_threshold(
      const ::media::mojom::MediaEngagementConfigPtr& input) {
    return input->high_score_upper_threshold;
  }

  static decltype(::media::mojom::MediaEngagementConfig::feature_record_data) feature_record_data(
      const ::media::mojom::MediaEngagementConfigPtr& input) {
    return input->feature_record_data;
  }

  static decltype(::media::mojom::MediaEngagementConfig::feature_bypass_autoplay) feature_bypass_autoplay(
      const ::media::mojom::MediaEngagementConfigPtr& input) {
    return input->feature_bypass_autoplay;
  }

  static decltype(::media::mojom::MediaEngagementConfig::feature_preload_data) feature_preload_data(
      const ::media::mojom::MediaEngagementConfigPtr& input) {
    return input->feature_preload_data;
  }

  static decltype(::media::mojom::MediaEngagementConfig::feature_https_only) feature_https_only(
      const ::media::mojom::MediaEngagementConfigPtr& input) {
    return input->feature_https_only;
  }

  static decltype(::media::mojom::MediaEngagementConfig::feature_autoplay_disable_settings) feature_autoplay_disable_settings(
      const ::media::mojom::MediaEngagementConfigPtr& input) {
    return input->feature_autoplay_disable_settings;
  }

  static decltype(::media::mojom::MediaEngagementConfig::pref_disable_unified_autoplay) pref_disable_unified_autoplay(
      const ::media::mojom::MediaEngagementConfigPtr& input) {
    return input->pref_disable_unified_autoplay;
  }

  static decltype(::media::mojom::MediaEngagementConfig::has_custom_autoplay_policy) has_custom_autoplay_policy(
      const ::media::mojom::MediaEngagementConfigPtr& input) {
    return input->has_custom_autoplay_policy;
  }

  static const decltype(::media::mojom::MediaEngagementConfig::autoplay_policy)& autoplay_policy(
      const ::media::mojom::MediaEngagementConfigPtr& input) {
    return input->autoplay_policy;
  }

  static const decltype(::media::mojom::MediaEngagementConfig::preload_version)& preload_version(
      const ::media::mojom::MediaEngagementConfigPtr& input) {
    return input->preload_version;
  }

  static bool Read(::media::mojom::MediaEngagementConfig::DataView input, ::media::mojom::MediaEngagementConfigPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_MEDIA_MEDIA_ENGAGEMENT_SCORE_DETAILS_MOJOM_H_