// chrome/browser/lens/core/mojom/text.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/lens/core/mojom/text.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/lens/core/mojom/text.mojom-params-data.h"
#include "chrome/browser/lens/core/mojom/text.mojom-shared-message-ids.h"

#include "chrome/browser/lens/core/mojom/text.mojom-import-headers.h"
#include "chrome/browser/lens/core/mojom/text.mojom-test-utils.h"


namespace lens::mojom {
Text::Text()
    : text_layout(),
      content_language() {}

Text::Text(
    TextLayoutPtr text_layout_in,
    const std::optional<std::string>& content_language_in)
    : text_layout(std::move(text_layout_in)),
      content_language(std::move(content_language_in)) {}

Text::~Text() = default;

void Text::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_layout"), this->text_layout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TextLayoutPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_language"), this->content_language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Text::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TextLayout::TextLayout()
    : paragraphs() {}

TextLayout::TextLayout(
    std::vector<ParagraphPtr> paragraphs_in)
    : paragraphs(std::move(paragraphs_in)) {}

TextLayout::~TextLayout() = default;

void TextLayout::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "paragraphs"), this->paragraphs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ParagraphPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TextLayout::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Word::Word()
    : plain_text(),
      text_separator(),
      geometry(),
      writing_direction(),
      formula_metadata() {}

Word::Word(
    const std::string& plain_text_in,
    const std::optional<std::string>& text_separator_in,
    ::lens::mojom::GeometryPtr geometry_in,
    std::optional<WritingDirection> writing_direction_in,
    FormulaMetadataPtr formula_metadata_in)
    : plain_text(std::move(plain_text_in)),
      text_separator(std::move(text_separator_in)),
      geometry(std::move(geometry_in)),
      writing_direction(std::move(writing_direction_in)),
      formula_metadata(std::move(formula_metadata_in)) {}

Word::~Word() = default;

void Word::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "plain_text"), this->plain_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_separator"), this->text_separator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "geometry"), this->geometry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::lens::mojom::GeometryPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "writing_direction"), this->writing_direction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<WritingDirection>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "formula_metadata"), this->formula_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FormulaMetadataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Word::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Line::Line()
    : words(),
      geometry() {}

Line::Line(
    std::vector<WordPtr> words_in,
    ::lens::mojom::GeometryPtr geometry_in)
    : words(std::move(words_in)),
      geometry(std::move(geometry_in)) {}

Line::~Line() = default;

void Line::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "words"), this->words,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<WordPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "geometry"), this->geometry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::lens::mojom::GeometryPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Line::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BackgroundImageData::BackgroundImageData()
    : background_image(),
      image_size(),
      vertical_padding(),
      horizontal_padding(),
      text_mask() {}

BackgroundImageData::BackgroundImageData(
    ::mojo_base::BigBuffer background_image_in,
    const ::gfx::Size& image_size_in,
    float vertical_padding_in,
    float horizontal_padding_in,
    ::mojo_base::BigBuffer text_mask_in)
    : background_image(std::move(background_image_in)),
      image_size(std::move(image_size_in)),
      vertical_padding(std::move(vertical_padding_in)),
      horizontal_padding(std::move(horizontal_padding_in)),
      text_mask(std::move(text_mask_in)) {}

BackgroundImageData::~BackgroundImageData() = default;

void BackgroundImageData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_image"), this->background_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo_base::BigBuffer>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_size"), this->image_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vertical_padding"), this->vertical_padding,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "horizontal_padding"), this->horizontal_padding,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_mask"), this->text_mask,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo_base::BigBuffer>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BackgroundImageData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TranslatedLine::TranslatedLine()
    : words(),
      translation(),
      text_color(),
      background_primary_color(),
      background_image_data(),
      geometry() {}

TranslatedLine::TranslatedLine(
    std::vector<WordPtr> words_in,
    const std::string& translation_in,
    ::SkColor text_color_in,
    ::SkColor background_primary_color_in,
    BackgroundImageDataPtr background_image_data_in,
    ::lens::mojom::GeometryPtr geometry_in)
    : words(std::move(words_in)),
      translation(std::move(translation_in)),
      text_color(std::move(text_color_in)),
      background_primary_color(std::move(background_primary_color_in)),
      background_image_data(std::move(background_image_data_in)),
      geometry(std::move(geometry_in)) {}

TranslatedLine::~TranslatedLine() = default;

void TranslatedLine::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "words"), this->words,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<WordPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "translation"), this->translation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_color"), this->text_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_primary_color"), this->background_primary_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_image_data"), this->background_image_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BackgroundImageDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "geometry"), this->geometry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::lens::mojom::GeometryPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TranslatedLine::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TranslatedParagraph::TranslatedParagraph()
    : lines(),
      resized_bitmap_size(),
      alignment(),
      writing_direction(),
      content_language() {}

TranslatedParagraph::TranslatedParagraph(
    std::vector<TranslatedLinePtr> lines_in,
    const ::gfx::Size& resized_bitmap_size_in,
    std::optional<Alignment> alignment_in,
    std::optional<WritingDirection> writing_direction_in,
    const std::optional<std::string>& content_language_in)
    : lines(std::move(lines_in)),
      resized_bitmap_size(std::move(resized_bitmap_size_in)),
      alignment(std::move(alignment_in)),
      writing_direction(std::move(writing_direction_in)),
      content_language(std::move(content_language_in)) {}

TranslatedParagraph::~TranslatedParagraph() = default;

void TranslatedParagraph::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lines"), this->lines,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<TranslatedLinePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resized_bitmap_size"), this->resized_bitmap_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alignment"), this->alignment,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<Alignment>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "writing_direction"), this->writing_direction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<WritingDirection>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_language"), this->content_language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TranslatedParagraph::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Paragraph::Paragraph()
    : lines(),
      translation(),
      geometry(),
      writing_direction(),
      content_language() {}

Paragraph::Paragraph(
    std::vector<LinePtr> lines_in,
    TranslatedParagraphPtr translation_in,
    ::lens::mojom::GeometryPtr geometry_in,
    std::optional<WritingDirection> writing_direction_in,
    const std::optional<std::string>& content_language_in)
    : lines(std::move(lines_in)),
      translation(std::move(translation_in)),
      geometry(std::move(geometry_in)),
      writing_direction(std::move(writing_direction_in)),
      content_language(std::move(content_language_in)) {}

Paragraph::~Paragraph() = default;

void Paragraph::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lines"), this->lines,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<LinePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "translation"), this->translation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TranslatedParagraphPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "geometry"), this->geometry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::lens::mojom::GeometryPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "writing_direction"), this->writing_direction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<WritingDirection>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_language"), this->content_language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Paragraph::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FormulaMetadata::FormulaMetadata()
    : latex() {}

FormulaMetadata::FormulaMetadata(
    const std::optional<std::string>& latex_in)
    : latex(std::move(latex_in)) {}

FormulaMetadata::~FormulaMetadata() = default;

void FormulaMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "latex"), this->latex,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FormulaMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // lens::mojom


namespace mojo {


// static
bool StructTraits<::lens::mojom::Text::DataView, ::lens::mojom::TextPtr>::Read(
    ::lens::mojom::Text::DataView input,
    ::lens::mojom::TextPtr* output) {
  bool success = true;
  ::lens::mojom::TextPtr result(::lens::mojom::Text::New());
  
      if (success && !input.ReadTextLayout(&result->text_layout))
        success = false;
      if (success && !input.ReadContentLanguage(&result->content_language))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::lens::mojom::TextLayout::DataView, ::lens::mojom::TextLayoutPtr>::Read(
    ::lens::mojom::TextLayout::DataView input,
    ::lens::mojom::TextLayoutPtr* output) {
  bool success = true;
  ::lens::mojom::TextLayoutPtr result(::lens::mojom::TextLayout::New());
  
      if (success && !input.ReadParagraphs(&result->paragraphs))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::lens::mojom::Word::DataView, ::lens::mojom::WordPtr>::Read(
    ::lens::mojom::Word::DataView input,
    ::lens::mojom::WordPtr* output) {
  bool success = true;
  ::lens::mojom::WordPtr result(::lens::mojom::Word::New());
  
      if (success && !input.ReadPlainText(&result->plain_text))
        success = false;
      if (success && !input.ReadTextSeparator(&result->text_separator))
        success = false;
      if (success && !input.ReadGeometry(&result->geometry))
        success = false;
      if (success && !input.ReadWritingDirection(&result->writing_direction)) {
        success = false;
      }
      if (success && !input.ReadFormulaMetadata(&result->formula_metadata))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::lens::mojom::Line::DataView, ::lens::mojom::LinePtr>::Read(
    ::lens::mojom::Line::DataView input,
    ::lens::mojom::LinePtr* output) {
  bool success = true;
  ::lens::mojom::LinePtr result(::lens::mojom::Line::New());
  
      if (success && !input.ReadWords(&result->words))
        success = false;
      if (success && !input.ReadGeometry(&result->geometry))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::lens::mojom::BackgroundImageData::DataView, ::lens::mojom::BackgroundImageDataPtr>::Read(
    ::lens::mojom::BackgroundImageData::DataView input,
    ::lens::mojom::BackgroundImageDataPtr* output) {
  bool success = true;
  ::lens::mojom::BackgroundImageDataPtr result(::lens::mojom::BackgroundImageData::New());
  
      if (success && !input.ReadBackgroundImage(&result->background_image))
        success = false;
      if (success && !input.ReadImageSize(&result->image_size))
        success = false;
      if (success)
        result->vertical_padding = input.vertical_padding();
      if (success)
        result->horizontal_padding = input.horizontal_padding();
      if (success && !input.ReadTextMask(&result->text_mask))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::lens::mojom::TranslatedLine::DataView, ::lens::mojom::TranslatedLinePtr>::Read(
    ::lens::mojom::TranslatedLine::DataView input,
    ::lens::mojom::TranslatedLinePtr* output) {
  bool success = true;
  ::lens::mojom::TranslatedLinePtr result(::lens::mojom::TranslatedLine::New());
  
      if (success && !input.ReadWords(&result->words))
        success = false;
      if (success && !input.ReadTranslation(&result->translation))
        success = false;
      if (success && !input.ReadTextColor(&result->text_color))
        success = false;
      if (success && !input.ReadBackgroundPrimaryColor(&result->background_primary_color))
        success = false;
      if (success && !input.ReadBackgroundImageData(&result->background_image_data))
        success = false;
      if (success && !input.ReadGeometry(&result->geometry))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::lens::mojom::TranslatedParagraph::DataView, ::lens::mojom::TranslatedParagraphPtr>::Read(
    ::lens::mojom::TranslatedParagraph::DataView input,
    ::lens::mojom::TranslatedParagraphPtr* output) {
  bool success = true;
  ::lens::mojom::TranslatedParagraphPtr result(::lens::mojom::TranslatedParagraph::New());
  
      if (success && !input.ReadLines(&result->lines))
        success = false;
      if (success && !input.ReadResizedBitmapSize(&result->resized_bitmap_size))
        success = false;
      if (success && !input.ReadAlignment(&result->alignment)) {
        success = false;
      }
      if (success && !input.ReadWritingDirection(&result->writing_direction)) {
        success = false;
      }
      if (success && !input.ReadContentLanguage(&result->content_language))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::lens::mojom::Paragraph::DataView, ::lens::mojom::ParagraphPtr>::Read(
    ::lens::mojom::Paragraph::DataView input,
    ::lens::mojom::ParagraphPtr* output) {
  bool success = true;
  ::lens::mojom::ParagraphPtr result(::lens::mojom::Paragraph::New());
  
      if (success && !input.ReadLines(&result->lines))
        success = false;
      if (success && !input.ReadTranslation(&result->translation))
        success = false;
      if (success && !input.ReadGeometry(&result->geometry))
        success = false;
      if (success && !input.ReadWritingDirection(&result->writing_direction)) {
        success = false;
      }
      if (success && !input.ReadContentLanguage(&result->content_language))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::lens::mojom::FormulaMetadata::DataView, ::lens::mojom::FormulaMetadataPtr>::Read(
    ::lens::mojom::FormulaMetadata::DataView input,
    ::lens::mojom::FormulaMetadataPtr* output) {
  bool success = true;
  ::lens::mojom::FormulaMetadataPtr result(::lens::mojom::FormulaMetadata::New());
  
      if (success && !input.ReadLatex(&result->latex))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace lens::mojom {




}  // lens::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif