// chrome/browser/lens/core/mojom/polygon.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_LENS_CORE_MOJOM_POLYGON_MOJOM_SEND_VALIDATION_H_
#define CHROME_BROWSER_LENS_CORE_MOJOM_POLYGON_MOJOM_SEND_VALIDATION_H_

#include "chrome/browser/lens/core/mojom/polygon.mojom-shared-internal.h"

#include "chrome/browser/lens/core/mojom/polygon.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::lens::mojom::PolygonDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::PolygonDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::Polygon_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::vertex(input)) in_vertex = Traits::vertex(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->vertex)::BaseType>
          vertex_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& vertex_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::lens::mojom::VertexDataView>, send_validation>(
        in_vertex,
        vertex_fragment,
        &vertex_validate_params);

      fragment->vertex.Set(
          vertex_fragment.is_null() ? nullptr : vertex_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->vertex.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null vertex in Polygon struct");

      
      mojo::internal::Serialize<::lens::mojom::Polygon_VertexOrdering>(
        Traits::vertex_ordering(input),
        &fragment->vertex_ordering);

      
      mojo::internal::Serialize<::lens::mojom::Polygon_CoordinateType>(
        Traits::coordinate_type(input),
        &fragment->coordinate_type);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::lens::mojom::VertexDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::VertexDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::Vertex_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->x = Traits::x(input);

      fragment->y = Traits::y(input);
  }
};

}  // namespace mojo::internal

#endif  // CHROME_BROWSER_LENS_CORE_MOJOM_POLYGON_MOJOM_SEND_VALIDATION_H_