// chrome/browser/lens/core/mojom/lens_side_panel.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  PageContentTypeSpec as lens_mojom_PageContentTypeSpec,
  PageContentType as lens_mojom_PageContentType
} from './page_content_type.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const SidePanelResultStatusSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum SidePanelResultStatus {

  MIN_VALUE = 0,
  MAX_VALUE = 4,
  kUnknown = 0,
  kResultShown = 1,
  kErrorPageShownOffline = 2,
  kErrorPageShownStartQueryError = 3,
  kErrorPageShownProtected = 4,
}



export type LensSidePanelPageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<LensSidePanelPageHandlerFactoryPendingReceiver>;

export class LensSidePanelPageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<LensSidePanelPageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<LensSidePanelPageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|LensSidePanelPageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'lens.mojom.LensSidePanelPageHandlerFactory',
        scope);
  }
}

export interface LensSidePanelPageHandlerFactoryInterface {
  createSidePanelPageHandler(handler: LensSidePanelPageHandlerPendingReceiver, page: LensSidePanelPageRemote): void;
}

export class LensSidePanelPageHandlerFactoryRemote implements LensSidePanelPageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<LensSidePanelPageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<LensSidePanelPageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|LensSidePanelPageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          LensSidePanelPageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createSidePanelPageHandler(
      handler: LensSidePanelPageHandlerPendingReceiver,
      page: LensSidePanelPageRemote): void {
    this.proxy.sendMessage(
        0,
        LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_ParamsSpec.$,
        null,
        [
          handler,
          page
        ],
        false);
  }
};

/**
 * An object which receives request messages for the LensSidePanelPageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LensSidePanelPageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    LensSidePanelPageHandlerFactoryRemote, LensSidePanelPageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    LensSidePanelPageHandlerFactoryRemote, LensSidePanelPageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: LensSidePanelPageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        LensSidePanelPageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_ParamsSpec.$,
        null,
        impl.createSidePanelPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class LensSidePanelPageHandlerFactory {
  static get $interfaceName(): string {
    return "lens.mojom.LensSidePanelPageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): LensSidePanelPageHandlerFactoryRemote {
    let remote = new LensSidePanelPageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the LensSidePanelPageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LensSidePanelPageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    LensSidePanelPageHandlerFactoryRemote, LensSidePanelPageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    LensSidePanelPageHandlerFactoryRemote, LensSidePanelPageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createSidePanelPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      LensSidePanelPageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createSidePanelPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_ParamsSpec.$,
        null,
        this.createSidePanelPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type LensSidePanelPageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<LensSidePanelPageHandlerPendingReceiver>;

export class LensSidePanelPageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<LensSidePanelPageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<LensSidePanelPageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|LensSidePanelPageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'lens.mojom.LensSidePanelPageHandler',
        scope);
  }
}

export interface LensSidePanelPageHandlerInterface {
  popAndLoadQueryFromHistory(): void;
  getIsContextualSearchbox(): Promise<{
        isContextualSearchbox: boolean, }>;
  onScrollToMessage(textFragments: string[], pdfPageNumber: number): void;
  requestSendFeedback(): void;
  onAimMessage(message: number[]): void;
  onImageQueryWithEmptyText(): void;
}

export class LensSidePanelPageHandlerRemote implements LensSidePanelPageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<LensSidePanelPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<LensSidePanelPageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|LensSidePanelPageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          LensSidePanelPageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  popAndLoadQueryFromHistory(): void {
    this.proxy.sendMessage(
        0,
        LensSidePanelPageHandler_PopAndLoadQueryFromHistory_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  getIsContextualSearchbox(): Promise<{
        isContextualSearchbox: boolean, }> {
    return this.proxy.sendMessage(
        1,
        LensSidePanelPageHandler_GetIsContextualSearchbox_ParamsSpec.$,
        LensSidePanelPageHandler_GetIsContextualSearchbox_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  onScrollToMessage(
      textFragments: string[],
      pdfPageNumber: number): void {
    this.proxy.sendMessage(
        2,
        LensSidePanelPageHandler_OnScrollToMessage_ParamsSpec.$,
        null,
        [
          textFragments,
          pdfPageNumber
        ],
        false);
  }

  requestSendFeedback(): void {
    this.proxy.sendMessage(
        3,
        LensSidePanelPageHandler_RequestSendFeedback_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  onAimMessage(
      message: number[]): void {
    this.proxy.sendMessage(
        4,
        LensSidePanelPageHandler_OnAimMessage_ParamsSpec.$,
        null,
        [
          message
        ],
        false);
  }

  onImageQueryWithEmptyText(): void {
    this.proxy.sendMessage(
        5,
        LensSidePanelPageHandler_OnImageQueryWithEmptyText_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the LensSidePanelPageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LensSidePanelPageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    LensSidePanelPageHandlerRemote, LensSidePanelPageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    LensSidePanelPageHandlerRemote, LensSidePanelPageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: LensSidePanelPageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        LensSidePanelPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        LensSidePanelPageHandler_PopAndLoadQueryFromHistory_ParamsSpec.$,
        null,
        impl.popAndLoadQueryFromHistory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        LensSidePanelPageHandler_GetIsContextualSearchbox_ParamsSpec.$,
        LensSidePanelPageHandler_GetIsContextualSearchbox_ResponseParamsSpec.$,
        impl.getIsContextualSearchbox.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        LensSidePanelPageHandler_OnScrollToMessage_ParamsSpec.$,
        null,
        impl.onScrollToMessage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        LensSidePanelPageHandler_RequestSendFeedback_ParamsSpec.$,
        null,
        impl.requestSendFeedback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        LensSidePanelPageHandler_OnAimMessage_ParamsSpec.$,
        null,
        impl.onAimMessage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        LensSidePanelPageHandler_OnImageQueryWithEmptyText_ParamsSpec.$,
        null,
        impl.onImageQueryWithEmptyText.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class LensSidePanelPageHandler {
  static get $interfaceName(): string {
    return "lens.mojom.LensSidePanelPageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): LensSidePanelPageHandlerRemote {
    let remote = new LensSidePanelPageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the LensSidePanelPageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LensSidePanelPageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    LensSidePanelPageHandlerRemote, LensSidePanelPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    LensSidePanelPageHandlerRemote, LensSidePanelPageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  popAndLoadQueryFromHistory: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getIsContextualSearchbox: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onScrollToMessage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  requestSendFeedback: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onAimMessage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onImageQueryWithEmptyText: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      LensSidePanelPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.popAndLoadQueryFromHistory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        LensSidePanelPageHandler_PopAndLoadQueryFromHistory_ParamsSpec.$,
        null,
        this.popAndLoadQueryFromHistory.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getIsContextualSearchbox =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        LensSidePanelPageHandler_GetIsContextualSearchbox_ParamsSpec.$,
        LensSidePanelPageHandler_GetIsContextualSearchbox_ResponseParamsSpec.$,
        this.getIsContextualSearchbox.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onScrollToMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        LensSidePanelPageHandler_OnScrollToMessage_ParamsSpec.$,
        null,
        this.onScrollToMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.requestSendFeedback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        LensSidePanelPageHandler_RequestSendFeedback_ParamsSpec.$,
        null,
        this.requestSendFeedback.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onAimMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        LensSidePanelPageHandler_OnAimMessage_ParamsSpec.$,
        null,
        this.onAimMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onImageQueryWithEmptyText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        LensSidePanelPageHandler_OnImageQueryWithEmptyText_ParamsSpec.$,
        null,
        this.onImageQueryWithEmptyText.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type LensSidePanelPagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<LensSidePanelPagePendingReceiver>;

export class LensSidePanelPagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<LensSidePanelPage> {

  handle: mojo.internal.interfaceSupport.Endpoint<LensSidePanelPagePendingReceiver>;
  constructor(handle: MojoHandle|LensSidePanelPagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'lens.mojom.LensSidePanelPage',
        scope);
  }
}

export interface LensSidePanelPageInterface {
  loadResultsInFrame(resultsUrl: url_mojom_Url): void;
  setIsLoadingResults(isLoading: boolean): void;
  setPageContentUploadProgress(progress: number): void;
  setBackArrowVisible(visible: boolean): void;
  setShowErrorPage(shouldShowErrorPage: boolean, status: SidePanelResultStatus): void;
  suppressGhostLoader(): void;
  pageContentTypeChanged(newPageContentType: lens_mojom_PageContentType): void;
  showToast(message: string): void;
  sendClientMessageToAim(serializedMessage: number[]): void;
  aimHandshakeReceived(): void;
  aimResultsChanged(onAim: boolean): void;
  focusResultsFrame(): void;
  setIsOverlayShowing(isShowing: boolean): void;
}

export class LensSidePanelPageRemote implements LensSidePanelPageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<LensSidePanelPagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<LensSidePanelPagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|LensSidePanelPagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          LensSidePanelPagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  loadResultsInFrame(
      resultsUrl: url_mojom_Url): void {
    this.proxy.sendMessage(
        0,
        LensSidePanelPage_LoadResultsInFrame_ParamsSpec.$,
        null,
        [
          resultsUrl
        ],
        false);
  }

  setIsLoadingResults(
      isLoading: boolean): void {
    this.proxy.sendMessage(
        1,
        LensSidePanelPage_SetIsLoadingResults_ParamsSpec.$,
        null,
        [
          isLoading
        ],
        false);
  }

  setPageContentUploadProgress(
      progress: number): void {
    this.proxy.sendMessage(
        2,
        LensSidePanelPage_SetPageContentUploadProgress_ParamsSpec.$,
        null,
        [
          progress
        ],
        false);
  }

  setBackArrowVisible(
      visible: boolean): void {
    this.proxy.sendMessage(
        3,
        LensSidePanelPage_SetBackArrowVisible_ParamsSpec.$,
        null,
        [
          visible
        ],
        false);
  }

  setShowErrorPage(
      shouldShowErrorPage: boolean,
      status: SidePanelResultStatus): void {
    this.proxy.sendMessage(
        4,
        LensSidePanelPage_SetShowErrorPage_ParamsSpec.$,
        null,
        [
          shouldShowErrorPage,
          status
        ],
        false);
  }

  suppressGhostLoader(): void {
    this.proxy.sendMessage(
        5,
        LensSidePanelPage_SuppressGhostLoader_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  pageContentTypeChanged(
      newPageContentType: lens_mojom_PageContentType): void {
    this.proxy.sendMessage(
        6,
        LensSidePanelPage_PageContentTypeChanged_ParamsSpec.$,
        null,
        [
          newPageContentType
        ],
        false);
  }

  showToast(
      message: string): void {
    this.proxy.sendMessage(
        7,
        LensSidePanelPage_ShowToast_ParamsSpec.$,
        null,
        [
          message
        ],
        false);
  }

  sendClientMessageToAim(
      serializedMessage: number[]): void {
    this.proxy.sendMessage(
        8,
        LensSidePanelPage_SendClientMessageToAim_ParamsSpec.$,
        null,
        [
          serializedMessage
        ],
        false);
  }

  aimHandshakeReceived(): void {
    this.proxy.sendMessage(
        9,
        LensSidePanelPage_AimHandshakeReceived_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  aimResultsChanged(
      onAim: boolean): void {
    this.proxy.sendMessage(
        10,
        LensSidePanelPage_AimResultsChanged_ParamsSpec.$,
        null,
        [
          onAim
        ],
        false);
  }

  focusResultsFrame(): void {
    this.proxy.sendMessage(
        11,
        LensSidePanelPage_FocusResultsFrame_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setIsOverlayShowing(
      isShowing: boolean): void {
    this.proxy.sendMessage(
        12,
        LensSidePanelPage_SetIsOverlayShowing_ParamsSpec.$,
        null,
        [
          isShowing
        ],
        false);
  }
};

/**
 * An object which receives request messages for the LensSidePanelPage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LensSidePanelPageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    LensSidePanelPageRemote, LensSidePanelPagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    LensSidePanelPageRemote, LensSidePanelPagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: LensSidePanelPageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        LensSidePanelPageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        LensSidePanelPage_LoadResultsInFrame_ParamsSpec.$,
        null,
        impl.loadResultsInFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        LensSidePanelPage_SetIsLoadingResults_ParamsSpec.$,
        null,
        impl.setIsLoadingResults.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        LensSidePanelPage_SetPageContentUploadProgress_ParamsSpec.$,
        null,
        impl.setPageContentUploadProgress.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        LensSidePanelPage_SetBackArrowVisible_ParamsSpec.$,
        null,
        impl.setBackArrowVisible.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        LensSidePanelPage_SetShowErrorPage_ParamsSpec.$,
        null,
        impl.setShowErrorPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        LensSidePanelPage_SuppressGhostLoader_ParamsSpec.$,
        null,
        impl.suppressGhostLoader.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        LensSidePanelPage_PageContentTypeChanged_ParamsSpec.$,
        null,
        impl.pageContentTypeChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        LensSidePanelPage_ShowToast_ParamsSpec.$,
        null,
        impl.showToast.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        LensSidePanelPage_SendClientMessageToAim_ParamsSpec.$,
        null,
        impl.sendClientMessageToAim.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        LensSidePanelPage_AimHandshakeReceived_ParamsSpec.$,
        null,
        impl.aimHandshakeReceived.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        LensSidePanelPage_AimResultsChanged_ParamsSpec.$,
        null,
        impl.aimResultsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        LensSidePanelPage_FocusResultsFrame_ParamsSpec.$,
        null,
        impl.focusResultsFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        LensSidePanelPage_SetIsOverlayShowing_ParamsSpec.$,
        null,
        impl.setIsOverlayShowing.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class LensSidePanelPage {
  static get $interfaceName(): string {
    return "lens.mojom.LensSidePanelPage";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): LensSidePanelPageRemote {
    let remote = new LensSidePanelPageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the LensSidePanelPage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LensSidePanelPageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    LensSidePanelPageRemote, LensSidePanelPagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    LensSidePanelPageRemote, LensSidePanelPagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  loadResultsInFrame: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setIsLoadingResults: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setPageContentUploadProgress: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setBackArrowVisible: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setShowErrorPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  suppressGhostLoader: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  pageContentTypeChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showToast: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  sendClientMessageToAim: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  aimHandshakeReceived: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  aimResultsChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  focusResultsFrame: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setIsOverlayShowing: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      LensSidePanelPageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.loadResultsInFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        LensSidePanelPage_LoadResultsInFrame_ParamsSpec.$,
        null,
        this.loadResultsInFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setIsLoadingResults =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        LensSidePanelPage_SetIsLoadingResults_ParamsSpec.$,
        null,
        this.setIsLoadingResults.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setPageContentUploadProgress =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        LensSidePanelPage_SetPageContentUploadProgress_ParamsSpec.$,
        null,
        this.setPageContentUploadProgress.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setBackArrowVisible =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        LensSidePanelPage_SetBackArrowVisible_ParamsSpec.$,
        null,
        this.setBackArrowVisible.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setShowErrorPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        LensSidePanelPage_SetShowErrorPage_ParamsSpec.$,
        null,
        this.setShowErrorPage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.suppressGhostLoader =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        LensSidePanelPage_SuppressGhostLoader_ParamsSpec.$,
        null,
        this.suppressGhostLoader.createReceiverHandler(false /* expectsResponse */),
        false);
    this.pageContentTypeChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        LensSidePanelPage_PageContentTypeChanged_ParamsSpec.$,
        null,
        this.pageContentTypeChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showToast =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        LensSidePanelPage_ShowToast_ParamsSpec.$,
        null,
        this.showToast.createReceiverHandler(false /* expectsResponse */),
        false);
    this.sendClientMessageToAim =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        LensSidePanelPage_SendClientMessageToAim_ParamsSpec.$,
        null,
        this.sendClientMessageToAim.createReceiverHandler(false /* expectsResponse */),
        false);
    this.aimHandshakeReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        LensSidePanelPage_AimHandshakeReceived_ParamsSpec.$,
        null,
        this.aimHandshakeReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    this.aimResultsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        LensSidePanelPage_AimResultsChanged_ParamsSpec.$,
        null,
        this.aimResultsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.focusResultsFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        LensSidePanelPage_FocusResultsFrame_ParamsSpec.$,
        null,
        this.focusResultsFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setIsOverlayShowing =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        LensSidePanelPage_SetIsOverlayShowing_ParamsSpec.$,
        null,
        this.setIsOverlayShowing.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensSidePanelPageHandler_PopAndLoadQueryFromHistory_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensSidePanelPageHandler_GetIsContextualSearchbox_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensSidePanelPageHandler_GetIsContextualSearchbox_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensSidePanelPageHandler_OnScrollToMessage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensSidePanelPageHandler_RequestSendFeedback_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensSidePanelPageHandler_OnAimMessage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensSidePanelPageHandler_OnImageQueryWithEmptyText_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensSidePanelPage_LoadResultsInFrame_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensSidePanelPage_SetIsLoadingResults_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensSidePanelPage_SetPageContentUploadProgress_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensSidePanelPage_SetBackArrowVisible_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensSidePanelPage_SetShowErrorPage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensSidePanelPage_SuppressGhostLoader_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensSidePanelPage_PageContentTypeChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensSidePanelPage_ShowToast_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensSidePanelPage_SendClientMessageToAim_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensSidePanelPage_AimHandshakeReceived_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensSidePanelPage_AimResultsChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensSidePanelPage_FocusResultsFrame_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensSidePanelPage_SetIsOverlayShowing_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_ParamsMojoType {
  handler: LensSidePanelPageHandlerPendingReceiver;
  page: LensSidePanelPageRemote;
}


export type LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_Params = LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_ParamsMojoType;
mojo.internal.Struct<LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_ParamsMojoType>(
    LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_ParamsSpec.$,
    'LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_Params',
    [
      mojo.internal.StructField<LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_ParamsMojoType, LensSidePanelPageHandlerPendingReceiver>(
        'handler', 0,
        0,
        mojo.internal.InterfaceRequest(LensSidePanelPageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_ParamsMojoType, LensSidePanelPageRemote>(
        'page', 4,
        0,
        mojo.internal.InterfaceProxy(LensSidePanelPageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface LensSidePanelPageHandler_PopAndLoadQueryFromHistory_ParamsMojoType {
}


export type LensSidePanelPageHandler_PopAndLoadQueryFromHistory_Params = LensSidePanelPageHandler_PopAndLoadQueryFromHistory_ParamsMojoType;
mojo.internal.Struct<LensSidePanelPageHandler_PopAndLoadQueryFromHistory_ParamsMojoType>(
    LensSidePanelPageHandler_PopAndLoadQueryFromHistory_ParamsSpec.$,
    'LensSidePanelPageHandler_PopAndLoadQueryFromHistory_Params',
    [
    ],
    [[0, 8],]);





export interface LensSidePanelPageHandler_GetIsContextualSearchbox_ParamsMojoType {
}


export type LensSidePanelPageHandler_GetIsContextualSearchbox_Params = LensSidePanelPageHandler_GetIsContextualSearchbox_ParamsMojoType;
mojo.internal.Struct<LensSidePanelPageHandler_GetIsContextualSearchbox_ParamsMojoType>(
    LensSidePanelPageHandler_GetIsContextualSearchbox_ParamsSpec.$,
    'LensSidePanelPageHandler_GetIsContextualSearchbox_Params',
    [
    ],
    [[0, 8],]);





export interface LensSidePanelPageHandler_GetIsContextualSearchbox_ResponseParamsMojoType {
  isContextualSearchbox: boolean;
}


export type LensSidePanelPageHandler_GetIsContextualSearchbox_ResponseParams = LensSidePanelPageHandler_GetIsContextualSearchbox_ResponseParamsMojoType;
mojo.internal.Struct<LensSidePanelPageHandler_GetIsContextualSearchbox_ResponseParamsMojoType>(
    LensSidePanelPageHandler_GetIsContextualSearchbox_ResponseParamsSpec.$,
    'LensSidePanelPageHandler_GetIsContextualSearchbox_ResponseParams',
    [
      mojo.internal.StructField<LensSidePanelPageHandler_GetIsContextualSearchbox_ResponseParamsMojoType, boolean>(
        'isContextualSearchbox', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensSidePanelPageHandler_OnScrollToMessage_ParamsMojoType {
  textFragments: string[];
  pdfPageNumber: number;
}


export type LensSidePanelPageHandler_OnScrollToMessage_Params = LensSidePanelPageHandler_OnScrollToMessage_ParamsMojoType;
mojo.internal.Struct<LensSidePanelPageHandler_OnScrollToMessage_ParamsMojoType>(
    LensSidePanelPageHandler_OnScrollToMessage_ParamsSpec.$,
    'LensSidePanelPageHandler_OnScrollToMessage_Params',
    [
      mojo.internal.StructField<LensSidePanelPageHandler_OnScrollToMessage_ParamsMojoType, string[]>(
        'textFragments', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensSidePanelPageHandler_OnScrollToMessage_ParamsMojoType, number>(
        'pdfPageNumber', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface LensSidePanelPageHandler_RequestSendFeedback_ParamsMojoType {
}


export type LensSidePanelPageHandler_RequestSendFeedback_Params = LensSidePanelPageHandler_RequestSendFeedback_ParamsMojoType;
mojo.internal.Struct<LensSidePanelPageHandler_RequestSendFeedback_ParamsMojoType>(
    LensSidePanelPageHandler_RequestSendFeedback_ParamsSpec.$,
    'LensSidePanelPageHandler_RequestSendFeedback_Params',
    [
    ],
    [[0, 8],]);





export interface LensSidePanelPageHandler_OnAimMessage_ParamsMojoType {
  message: number[];
}


export type LensSidePanelPageHandler_OnAimMessage_Params = LensSidePanelPageHandler_OnAimMessage_ParamsMojoType;
mojo.internal.Struct<LensSidePanelPageHandler_OnAimMessage_ParamsMojoType>(
    LensSidePanelPageHandler_OnAimMessage_ParamsSpec.$,
    'LensSidePanelPageHandler_OnAimMessage_Params',
    [
      mojo.internal.StructField<LensSidePanelPageHandler_OnAimMessage_ParamsMojoType, number[]>(
        'message', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensSidePanelPageHandler_OnImageQueryWithEmptyText_ParamsMojoType {
}


export type LensSidePanelPageHandler_OnImageQueryWithEmptyText_Params = LensSidePanelPageHandler_OnImageQueryWithEmptyText_ParamsMojoType;
mojo.internal.Struct<LensSidePanelPageHandler_OnImageQueryWithEmptyText_ParamsMojoType>(
    LensSidePanelPageHandler_OnImageQueryWithEmptyText_ParamsSpec.$,
    'LensSidePanelPageHandler_OnImageQueryWithEmptyText_Params',
    [
    ],
    [[0, 8],]);





export interface LensSidePanelPage_LoadResultsInFrame_ParamsMojoType {
  resultsUrl: url_mojom_Url;
}


export type LensSidePanelPage_LoadResultsInFrame_Params = LensSidePanelPage_LoadResultsInFrame_ParamsMojoType;
mojo.internal.Struct<LensSidePanelPage_LoadResultsInFrame_ParamsMojoType>(
    LensSidePanelPage_LoadResultsInFrame_ParamsSpec.$,
    'LensSidePanelPage_LoadResultsInFrame_Params',
    [
      mojo.internal.StructField<LensSidePanelPage_LoadResultsInFrame_ParamsMojoType, url_mojom_Url>(
        'resultsUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensSidePanelPage_SetIsLoadingResults_ParamsMojoType {
  isLoading: boolean;
}


export type LensSidePanelPage_SetIsLoadingResults_Params = LensSidePanelPage_SetIsLoadingResults_ParamsMojoType;
mojo.internal.Struct<LensSidePanelPage_SetIsLoadingResults_ParamsMojoType>(
    LensSidePanelPage_SetIsLoadingResults_ParamsSpec.$,
    'LensSidePanelPage_SetIsLoadingResults_Params',
    [
      mojo.internal.StructField<LensSidePanelPage_SetIsLoadingResults_ParamsMojoType, boolean>(
        'isLoading', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensSidePanelPage_SetPageContentUploadProgress_ParamsMojoType {
  progress: number;
}


export type LensSidePanelPage_SetPageContentUploadProgress_Params = LensSidePanelPage_SetPageContentUploadProgress_ParamsMojoType;
mojo.internal.Struct<LensSidePanelPage_SetPageContentUploadProgress_ParamsMojoType>(
    LensSidePanelPage_SetPageContentUploadProgress_ParamsSpec.$,
    'LensSidePanelPage_SetPageContentUploadProgress_Params',
    [
      mojo.internal.StructField<LensSidePanelPage_SetPageContentUploadProgress_ParamsMojoType, number>(
        'progress', 0,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensSidePanelPage_SetBackArrowVisible_ParamsMojoType {
  visible: boolean;
}


export type LensSidePanelPage_SetBackArrowVisible_Params = LensSidePanelPage_SetBackArrowVisible_ParamsMojoType;
mojo.internal.Struct<LensSidePanelPage_SetBackArrowVisible_ParamsMojoType>(
    LensSidePanelPage_SetBackArrowVisible_ParamsSpec.$,
    'LensSidePanelPage_SetBackArrowVisible_Params',
    [
      mojo.internal.StructField<LensSidePanelPage_SetBackArrowVisible_ParamsMojoType, boolean>(
        'visible', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensSidePanelPage_SetShowErrorPage_ParamsMojoType {
  shouldShowErrorPage: boolean;
  status: SidePanelResultStatus;
}


export type LensSidePanelPage_SetShowErrorPage_Params = LensSidePanelPage_SetShowErrorPage_ParamsMojoType;
mojo.internal.Struct<LensSidePanelPage_SetShowErrorPage_ParamsMojoType>(
    LensSidePanelPage_SetShowErrorPage_ParamsSpec.$,
    'LensSidePanelPage_SetShowErrorPage_Params',
    [
      mojo.internal.StructField<LensSidePanelPage_SetShowErrorPage_ParamsMojoType, boolean>(
        'shouldShowErrorPage', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensSidePanelPage_SetShowErrorPage_ParamsMojoType, SidePanelResultStatus>(
        'status', 4,
        0,
        SidePanelResultStatusSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensSidePanelPage_SuppressGhostLoader_ParamsMojoType {
}


export type LensSidePanelPage_SuppressGhostLoader_Params = LensSidePanelPage_SuppressGhostLoader_ParamsMojoType;
mojo.internal.Struct<LensSidePanelPage_SuppressGhostLoader_ParamsMojoType>(
    LensSidePanelPage_SuppressGhostLoader_ParamsSpec.$,
    'LensSidePanelPage_SuppressGhostLoader_Params',
    [
    ],
    [[0, 8],]);





export interface LensSidePanelPage_PageContentTypeChanged_ParamsMojoType {
  newPageContentType: lens_mojom_PageContentType;
}


export type LensSidePanelPage_PageContentTypeChanged_Params = LensSidePanelPage_PageContentTypeChanged_ParamsMojoType;
mojo.internal.Struct<LensSidePanelPage_PageContentTypeChanged_ParamsMojoType>(
    LensSidePanelPage_PageContentTypeChanged_ParamsSpec.$,
    'LensSidePanelPage_PageContentTypeChanged_Params',
    [
      mojo.internal.StructField<LensSidePanelPage_PageContentTypeChanged_ParamsMojoType, lens_mojom_PageContentType>(
        'newPageContentType', 0,
        0,
        lens_mojom_PageContentTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensSidePanelPage_ShowToast_ParamsMojoType {
  message: string;
}


export type LensSidePanelPage_ShowToast_Params = LensSidePanelPage_ShowToast_ParamsMojoType;
mojo.internal.Struct<LensSidePanelPage_ShowToast_ParamsMojoType>(
    LensSidePanelPage_ShowToast_ParamsSpec.$,
    'LensSidePanelPage_ShowToast_Params',
    [
      mojo.internal.StructField<LensSidePanelPage_ShowToast_ParamsMojoType, string>(
        'message', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensSidePanelPage_SendClientMessageToAim_ParamsMojoType {
  serializedMessage: number[];
}


export type LensSidePanelPage_SendClientMessageToAim_Params = LensSidePanelPage_SendClientMessageToAim_ParamsMojoType;
mojo.internal.Struct<LensSidePanelPage_SendClientMessageToAim_ParamsMojoType>(
    LensSidePanelPage_SendClientMessageToAim_ParamsSpec.$,
    'LensSidePanelPage_SendClientMessageToAim_Params',
    [
      mojo.internal.StructField<LensSidePanelPage_SendClientMessageToAim_ParamsMojoType, number[]>(
        'serializedMessage', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensSidePanelPage_AimHandshakeReceived_ParamsMojoType {
}


export type LensSidePanelPage_AimHandshakeReceived_Params = LensSidePanelPage_AimHandshakeReceived_ParamsMojoType;
mojo.internal.Struct<LensSidePanelPage_AimHandshakeReceived_ParamsMojoType>(
    LensSidePanelPage_AimHandshakeReceived_ParamsSpec.$,
    'LensSidePanelPage_AimHandshakeReceived_Params',
    [
    ],
    [[0, 8],]);





export interface LensSidePanelPage_AimResultsChanged_ParamsMojoType {
  onAim: boolean;
}


export type LensSidePanelPage_AimResultsChanged_Params = LensSidePanelPage_AimResultsChanged_ParamsMojoType;
mojo.internal.Struct<LensSidePanelPage_AimResultsChanged_ParamsMojoType>(
    LensSidePanelPage_AimResultsChanged_ParamsSpec.$,
    'LensSidePanelPage_AimResultsChanged_Params',
    [
      mojo.internal.StructField<LensSidePanelPage_AimResultsChanged_ParamsMojoType, boolean>(
        'onAim', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensSidePanelPage_FocusResultsFrame_ParamsMojoType {
}


export type LensSidePanelPage_FocusResultsFrame_Params = LensSidePanelPage_FocusResultsFrame_ParamsMojoType;
mojo.internal.Struct<LensSidePanelPage_FocusResultsFrame_ParamsMojoType>(
    LensSidePanelPage_FocusResultsFrame_ParamsSpec.$,
    'LensSidePanelPage_FocusResultsFrame_Params',
    [
    ],
    [[0, 8],]);





export interface LensSidePanelPage_SetIsOverlayShowing_ParamsMojoType {
  isShowing: boolean;
}


export type LensSidePanelPage_SetIsOverlayShowing_Params = LensSidePanelPage_SetIsOverlayShowing_ParamsMojoType;
mojo.internal.Struct<LensSidePanelPage_SetIsOverlayShowing_ParamsMojoType>(
    LensSidePanelPage_SetIsOverlayShowing_ParamsSpec.$,
    'LensSidePanelPage_SetIsOverlayShowing_Params',
    [
      mojo.internal.StructField<LensSidePanelPage_SetIsOverlayShowing_ParamsMojoType, boolean>(
        'isShowing', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



