// chrome/browser/lens/core/mojom/lens.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_LENS_CORE_MOJOM_LENS_MOJOM_H_
#define CHROME_BROWSER_LENS_CORE_MOJOM_LENS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/lens/core/mojom/lens.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/lens/core/mojom/lens.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/lens/core/mojom/lens.mojom-forward.h"  // IWYU pragma: export
#include "chrome/browser/lens/core/mojom/geometry.mojom-forward.h"
#include "chrome/browser/lens/core/mojom/overlay_object.mojom-forward.h"
#include "chrome/browser/lens/core/mojom/page_content_type.mojom-forward.h"
#include "chrome/browser/lens/core/mojom/text.mojom-forward.h"
#include "chrome/browser/lens/core/mojom/translate.mojom-forward.h"
#include "mojo/public/mojom/base/big_string.mojom-forward.h"
#include "skia/public/mojom/bitmap.mojom.h"
#include "skia/public/mojom/skcolor.mojom.h"
#include "ui/base/mojom/window_open_disposition.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace lens::mojom {

class LensPageHandlerFactoryProxy;

template <typename ImplRefTraits>
class LensPageHandlerFactoryStub;

class LensPageHandlerFactoryRequestValidator;


class LensPageHandlerFactory
    : public LensPageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "lens.mojom.LensPageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LensPageHandlerFactoryInterfaceBase;
  using Proxy_ = LensPageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = LensPageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = LensPageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LensPageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingReceiver<LensPageHandler> handler, ::mojo::PendingRemote<LensPage> page) = 0;
};

class LensPageHandlerProxy;

template <typename ImplRefTraits>
class LensPageHandlerStub;

class LensPageHandlerRequestValidator;
class LensPageHandlerResponseValidator;


class LensPageHandler
    : public LensPageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "lens.mojom.LensPageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LensPageHandlerInterfaceBase;
  using Proxy_ = LensPageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = LensPageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = LensPageHandlerRequestValidator;
  using ResponseValidator_ = LensPageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kActivityRequestedByOverlayMinVersion = 0,
    kCloseRequestedByOverlayCloseButtonMinVersion = 0,
    kCloseRequestedByOverlayBackgroundClickMinVersion = 0,
    kNotifyOverlayInitializedMinVersion = 0,
    kAddBackgroundBlurMinVersion = 0,
    kSetLiveBlurMinVersion = 0,
    kFeedbackRequestedByOverlayMinVersion = 0,
    kGetOverlayInvocationSourceMinVersion = 0,
    kInfoRequestedByOverlayMinVersion = 0,
    kIssueLensRegionRequestMinVersion = 0,
    kIssueLensObjectRequestMinVersion = 0,
    kIssueTextSelectionRequestMinVersion = 0,
    kIssueTranslateSelectionRequestMinVersion = 0,
    kIssueMathSelectionRequestMinVersion = 0,
    kIssueTranslateFullPageRequestMinVersion = 0,
    kIssueEndTranslateModeRequestMinVersion = 0,
    kCopyTextMinVersion = 0,
    kCopyImageMinVersion = 0,
    kSaveAsImageMinVersion = 0,
    kClosePreselectionBubbleMinVersion = 0,
    kRecordUkmAndTaskCompletionForLensOverlayInteractionMinVersion = 0,
    kRecordLensOverlaySemanticEventMinVersion = 0,
    kMaybeShowTranslateFeaturePromoMinVersion = 0,
    kMaybeCloseTranslateFeaturePromoMinVersion = 0,
    kFetchSupportedLanguagesMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ActivityRequestedByOverlay_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseRequestedByOverlayCloseButton_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseRequestedByOverlayBackgroundClick_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyOverlayInitialized_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddBackgroundBlur_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetLiveBlur_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FeedbackRequestedByOverlay_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetOverlayInvocationSource_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InfoRequestedByOverlay_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IssueLensRegionRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IssueLensObjectRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IssueTextSelectionRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IssueTranslateSelectionRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IssueMathSelectionRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IssueTranslateFullPageRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IssueEndTranslateModeRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CopyText_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CopyImage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SaveAsImage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClosePreselectionBubble_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordUkmAndTaskCompletionForLensOverlayInteraction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordLensOverlaySemanticEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MaybeShowTranslateFeaturePromo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MaybeCloseTranslateFeaturePromo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FetchSupportedLanguages_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LensPageHandler() = default;

  virtual void ActivityRequestedByOverlay(::ui::mojom::ClickModifiersPtr click_modifiers) = 0;

  virtual void CloseRequestedByOverlayCloseButton() = 0;

  virtual void CloseRequestedByOverlayBackgroundClick() = 0;

  virtual void NotifyOverlayInitialized() = 0;

  virtual void AddBackgroundBlur() = 0;

  virtual void SetLiveBlur(bool enabled) = 0;

  virtual void FeedbackRequestedByOverlay() = 0;

  using GetOverlayInvocationSourceCallback = base::OnceCallback<void(const std::string&)>;
  using GetOverlayInvocationSourceMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void GetOverlayInvocationSource(GetOverlayInvocationSourceCallback callback) = 0;

  virtual void InfoRequestedByOverlay(::ui::mojom::ClickModifiersPtr click_modifiers) = 0;

  virtual void IssueLensRegionRequest(::lens::mojom::CenterRotatedBoxPtr region, bool is_click) = 0;

  virtual void IssueLensObjectRequest(::lens::mojom::CenterRotatedBoxPtr region, bool is_mask_click) = 0;

  virtual void IssueTextSelectionRequest(const std::string& query, int32_t selection_start_index, int32_t selection_end_index, bool is_translate) = 0;

  virtual void IssueTranslateSelectionRequest(const std::string& query, const std::string& content_language, int32_t selection_start_index, int32_t selection_end_index) = 0;

  virtual void IssueMathSelectionRequest(const std::string& query, const std::string& formula, int32_t selection_start_index, int32_t selection_end_index) = 0;

  virtual void IssueTranslateFullPageRequest(const std::string& source_language, const std::string& target_language) = 0;

  virtual void IssueEndTranslateModeRequest() = 0;

  virtual void CopyText(const std::string& text) = 0;

  virtual void CopyImage(::lens::mojom::CenterRotatedBoxPtr region) = 0;

  virtual void SaveAsImage(::lens::mojom::CenterRotatedBoxPtr region) = 0;

  virtual void ClosePreselectionBubble() = 0;

  virtual void RecordUkmAndTaskCompletionForLensOverlayInteraction(UserAction user_action) = 0;

  virtual void RecordLensOverlaySemanticEvent(SemanticEvent event) = 0;

  virtual void MaybeShowTranslateFeaturePromo() = 0;

  virtual void MaybeCloseTranslateFeaturePromo(bool feature_engaged) = 0;

  using FetchSupportedLanguagesCallback = base::OnceCallback<void(const std::string&, std::vector<::lens::mojom::LanguagePtr>, std::vector<::lens::mojom::LanguagePtr>)>;
  using FetchSupportedLanguagesMojoCallback = base::OnceCallback<void(const std::string&, std::vector<::lens::mojom::LanguagePtr>, std::vector<::lens::mojom::LanguagePtr>)>;

  virtual void FetchSupportedLanguages(FetchSupportedLanguagesCallback callback) = 0;
};

class LensPageProxy;

template <typename ImplRefTraits>
class LensPageStub;

class LensPageRequestValidator;


class LensPage
    : public LensPageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "lens.mojom.LensPage";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LensPageInterfaceBase;
  using Proxy_ = LensPageProxy;

  template <typename ImplRefTraits>
  using Stub_ = LensPageStub<ImplRefTraits>;

  using RequestValidator_ = LensPageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kScreenshotDataReceivedMinVersion = 0,
    kNotifyHandshakeCompleteMinVersion = 0,
    kNotifyResultsPanelOpenedMinVersion = 0,
    kNotifyOverlayClosingMinVersion = 0,
    kObjectsReceivedMinVersion = 0,
    kTextReceivedMinVersion = 0,
    kRegionTextReceivedMinVersion = 0,
    kThemeReceivedMinVersion = 0,
    kShouldShowContextualSearchBoxMinVersion = 0,
    kPageContentTypeChangedMinVersion = 0,
    kSetPostRegionSelectionMinVersion = 0,
    kSetTextSelectionMinVersion = 0,
    kSetTranslateModeMinVersion = 0,
    kClearRegionSelectionMinVersion = 0,
    kClearTextSelectionMinVersion = 0,
    kClearAllSelectionsMinVersion = 0,
    kOnCopyCommandMinVersion = 0,
    kSuppressGhostLoaderMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ScreenshotDataReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyHandshakeComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyResultsPanelOpened_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyOverlayClosing_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ObjectsReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TextReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegionTextReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ThemeReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShouldShowContextualSearchBox_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PageContentTypeChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPostRegionSelection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTextSelection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTranslateMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearRegionSelection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearTextSelection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearAllSelections_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCopyCommand_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SuppressGhostLoader_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LensPage() = default;

  virtual void ScreenshotDataReceived(const ::SkBitmap& screenshot_data) = 0;

  virtual void NotifyHandshakeComplete() = 0;

  virtual void NotifyResultsPanelOpened() = 0;

  virtual void NotifyOverlayClosing() = 0;

  virtual void ObjectsReceived(std::vector<::lens::mojom::OverlayObjectPtr> objects) = 0;

  virtual void TextReceived(::lens::mojom::TextPtr text) = 0;

  virtual void RegionTextReceived(::lens::mojom::TextPtr text, bool is_injected_image) = 0;

  virtual void ThemeReceived(OverlayThemePtr theme) = 0;

  virtual void ShouldShowContextualSearchBox(bool should_show) = 0;

  virtual void PageContentTypeChanged(::lens::mojom::PageContentType new_page_content_type) = 0;

  virtual void SetPostRegionSelection(::lens::mojom::CenterRotatedBoxPtr region) = 0;

  virtual void SetTextSelection(int32_t selection_start_index, int32_t selection_end_index) = 0;

  virtual void SetTranslateMode(const std::string& source_language, const std::string& target_language) = 0;

  virtual void ClearRegionSelection() = 0;

  virtual void ClearTextSelection() = 0;

  virtual void ClearAllSelections() = 0;

  virtual void OnCopyCommand() = 0;

  virtual void SuppressGhostLoader() = 0;
};



class  LensPageHandlerFactoryProxy
    : public LensPageHandlerFactory {
 public:
  using InterfaceType = LensPageHandlerFactory;

  explicit LensPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingReceiver<LensPageHandler> handler, ::mojo::PendingRemote<LensPage> page) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  LensPageHandlerProxy
    : public LensPageHandler {
 public:
  using InterfaceType = LensPageHandler;

  explicit LensPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ActivityRequestedByOverlay(::ui::mojom::ClickModifiersPtr click_modifiers) final;
  
  void CloseRequestedByOverlayCloseButton() final;
  
  void CloseRequestedByOverlayBackgroundClick() final;
  
  void NotifyOverlayInitialized() final;
  
  void AddBackgroundBlur() final;
  
  void SetLiveBlur(bool enabled) final;
  
  void FeedbackRequestedByOverlay() final;
  
  void GetOverlayInvocationSource(GetOverlayInvocationSourceCallback callback) final;
  
  void InfoRequestedByOverlay(::ui::mojom::ClickModifiersPtr click_modifiers) final;
  
  void IssueLensRegionRequest(::lens::mojom::CenterRotatedBoxPtr region, bool is_click) final;
  
  void IssueLensObjectRequest(::lens::mojom::CenterRotatedBoxPtr region, bool is_mask_click) final;
  
  void IssueTextSelectionRequest(const std::string& query, int32_t selection_start_index, int32_t selection_end_index, bool is_translate) final;
  
  void IssueTranslateSelectionRequest(const std::string& query, const std::string& content_language, int32_t selection_start_index, int32_t selection_end_index) final;
  
  void IssueMathSelectionRequest(const std::string& query, const std::string& formula, int32_t selection_start_index, int32_t selection_end_index) final;
  
  void IssueTranslateFullPageRequest(const std::string& source_language, const std::string& target_language) final;
  
  void IssueEndTranslateModeRequest() final;
  
  void CopyText(const std::string& text) final;
  
  void CopyImage(::lens::mojom::CenterRotatedBoxPtr region) final;
  
  void SaveAsImage(::lens::mojom::CenterRotatedBoxPtr region) final;
  
  void ClosePreselectionBubble() final;
  
  void RecordUkmAndTaskCompletionForLensOverlayInteraction(UserAction user_action) final;
  
  void RecordLensOverlaySemanticEvent(SemanticEvent event) final;
  
  void MaybeShowTranslateFeaturePromo() final;
  
  void MaybeCloseTranslateFeaturePromo(bool feature_engaged) final;
  
  void FetchSupportedLanguages(FetchSupportedLanguagesCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  LensPageProxy
    : public LensPage {
 public:
  using InterfaceType = LensPage;

  explicit LensPageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ScreenshotDataReceived(const ::SkBitmap& screenshot_data) final;
  
  void NotifyHandshakeComplete() final;
  
  void NotifyResultsPanelOpened() final;
  
  void NotifyOverlayClosing() final;
  
  void ObjectsReceived(std::vector<::lens::mojom::OverlayObjectPtr> objects) final;
  
  void TextReceived(::lens::mojom::TextPtr text) final;
  
  void RegionTextReceived(::lens::mojom::TextPtr text, bool is_injected_image) final;
  
  void ThemeReceived(OverlayThemePtr theme) final;
  
  void ShouldShowContextualSearchBox(bool should_show) final;
  
  void PageContentTypeChanged(::lens::mojom::PageContentType new_page_content_type) final;
  
  void SetPostRegionSelection(::lens::mojom::CenterRotatedBoxPtr region) final;
  
  void SetTextSelection(int32_t selection_start_index, int32_t selection_end_index) final;
  
  void SetTranslateMode(const std::string& source_language, const std::string& target_language) final;
  
  void ClearRegionSelection() final;
  
  void ClearTextSelection() final;
  
  void ClearAllSelections() final;
  
  void OnCopyCommand() final;
  
  void SuppressGhostLoader() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  LensPageHandlerFactoryStubDispatch {
 public:
  static bool Accept(LensPageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LensPageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LensPageHandlerFactory>>
class LensPageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LensPageHandlerFactoryStub() = default;
  ~LensPageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LensPageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LensPageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  LensPageHandlerStubDispatch {
 public:
  static bool Accept(LensPageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LensPageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LensPageHandler>>
class LensPageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LensPageHandlerStub() = default;
  ~LensPageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LensPageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LensPageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  LensPageStubDispatch {
 public:
  static bool Accept(LensPage* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LensPage* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LensPage>>
class LensPageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LensPageStub() = default;
  ~LensPageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LensPageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LensPageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  LensPageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  LensPageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  LensPageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  LensPageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  OverlayTheme {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OverlayTheme, T>::value>;
  using DataView = OverlayThemeDataView;
  using Data_ = internal::OverlayTheme_Data;

  template <typename... Args>
  static OverlayThemePtr New(Args&&... args) {
    return OverlayThemePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OverlayThemePtr From(const U& u) {
    return mojo::TypeConverter<OverlayThemePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OverlayTheme>::Convert(*this);
  }


  OverlayTheme();

  OverlayTheme(
      ::SkColor primary,
      ::SkColor shader_layer_1,
      ::SkColor shader_layer_2,
      ::SkColor shader_layer_3,
      ::SkColor shader_layer_4,
      ::SkColor shader_layer_5,
      ::SkColor scrim,
      ::SkColor surface_container_highest_light,
      ::SkColor surface_container_highest_dark,
      ::SkColor selection_element);


  ~OverlayTheme();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OverlayThemePtr>
  OverlayThemePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OverlayTheme::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OverlayTheme::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OverlayTheme::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OverlayTheme::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OverlayTheme::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OverlayTheme::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OverlayTheme_UnserializedMessageContext<
            UserType, OverlayTheme::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OverlayTheme::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OverlayTheme::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OverlayTheme_UnserializedMessageContext<
            UserType, OverlayTheme::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OverlayTheme::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::SkColor primary;
  
  ::SkColor shader_layer_1;
  
  ::SkColor shader_layer_2;
  
  ::SkColor shader_layer_3;
  
  ::SkColor shader_layer_4;
  
  ::SkColor shader_layer_5;
  
  ::SkColor scrim;
  
  ::SkColor surface_container_highest_light;
  
  ::SkColor surface_container_highest_dark;
  
  ::SkColor selection_element;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OverlayTheme::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OverlayTheme::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OverlayTheme::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OverlayTheme::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
OverlayThemePtr OverlayTheme::Clone() const {
  return New(
      mojo::Clone(primary),
      mojo::Clone(shader_layer_1),
      mojo::Clone(shader_layer_2),
      mojo::Clone(shader_layer_3),
      mojo::Clone(shader_layer_4),
      mojo::Clone(shader_layer_5),
      mojo::Clone(scrim),
      mojo::Clone(surface_container_highest_light),
      mojo::Clone(surface_container_highest_dark),
      mojo::Clone(selection_element)
  );
}

template <typename T, OverlayTheme::EnableIfSame<T>*>
bool OverlayTheme::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->primary, other_struct.primary))
    return false;
  if (!mojo::Equals(this->shader_layer_1, other_struct.shader_layer_1))
    return false;
  if (!mojo::Equals(this->shader_layer_2, other_struct.shader_layer_2))
    return false;
  if (!mojo::Equals(this->shader_layer_3, other_struct.shader_layer_3))
    return false;
  if (!mojo::Equals(this->shader_layer_4, other_struct.shader_layer_4))
    return false;
  if (!mojo::Equals(this->shader_layer_5, other_struct.shader_layer_5))
    return false;
  if (!mojo::Equals(this->scrim, other_struct.scrim))
    return false;
  if (!mojo::Equals(this->surface_container_highest_light, other_struct.surface_container_highest_light))
    return false;
  if (!mojo::Equals(this->surface_container_highest_dark, other_struct.surface_container_highest_dark))
    return false;
  if (!mojo::Equals(this->selection_element, other_struct.selection_element))
    return false;
  return true;
}

template <typename T, OverlayTheme::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.primary < rhs.primary)
    return true;
  if (rhs.primary < lhs.primary)
    return false;
  if (lhs.shader_layer_1 < rhs.shader_layer_1)
    return true;
  if (rhs.shader_layer_1 < lhs.shader_layer_1)
    return false;
  if (lhs.shader_layer_2 < rhs.shader_layer_2)
    return true;
  if (rhs.shader_layer_2 < lhs.shader_layer_2)
    return false;
  if (lhs.shader_layer_3 < rhs.shader_layer_3)
    return true;
  if (rhs.shader_layer_3 < lhs.shader_layer_3)
    return false;
  if (lhs.shader_layer_4 < rhs.shader_layer_4)
    return true;
  if (rhs.shader_layer_4 < lhs.shader_layer_4)
    return false;
  if (lhs.shader_layer_5 < rhs.shader_layer_5)
    return true;
  if (rhs.shader_layer_5 < lhs.shader_layer_5)
    return false;
  if (lhs.scrim < rhs.scrim)
    return true;
  if (rhs.scrim < lhs.scrim)
    return false;
  if (lhs.surface_container_highest_light < rhs.surface_container_highest_light)
    return true;
  if (rhs.surface_container_highest_light < lhs.surface_container_highest_light)
    return false;
  if (lhs.surface_container_highest_dark < rhs.surface_container_highest_dark)
    return true;
  if (rhs.surface_container_highest_dark < lhs.surface_container_highest_dark)
    return false;
  if (lhs.selection_element < rhs.selection_element)
    return true;
  if (rhs.selection_element < lhs.selection_element)
    return false;
  return false;
}


}  // lens::mojom

namespace mojo {


template <>
struct  StructTraits<::lens::mojom::OverlayTheme::DataView,
                                         ::lens::mojom::OverlayThemePtr> {
  static bool IsNull(const ::lens::mojom::OverlayThemePtr& input) { return !input; }
  static void SetToNull(::lens::mojom::OverlayThemePtr* output) { output->reset(); }

  static const decltype(::lens::mojom::OverlayTheme::primary)& primary(
      const ::lens::mojom::OverlayThemePtr& input) {
    return input->primary;
  }

  static const decltype(::lens::mojom::OverlayTheme::shader_layer_1)& shader_layer_1(
      const ::lens::mojom::OverlayThemePtr& input) {
    return input->shader_layer_1;
  }

  static const decltype(::lens::mojom::OverlayTheme::shader_layer_2)& shader_layer_2(
      const ::lens::mojom::OverlayThemePtr& input) {
    return input->shader_layer_2;
  }

  static const decltype(::lens::mojom::OverlayTheme::shader_layer_3)& shader_layer_3(
      const ::lens::mojom::OverlayThemePtr& input) {
    return input->shader_layer_3;
  }

  static const decltype(::lens::mojom::OverlayTheme::shader_layer_4)& shader_layer_4(
      const ::lens::mojom::OverlayThemePtr& input) {
    return input->shader_layer_4;
  }

  static const decltype(::lens::mojom::OverlayTheme::shader_layer_5)& shader_layer_5(
      const ::lens::mojom::OverlayThemePtr& input) {
    return input->shader_layer_5;
  }

  static const decltype(::lens::mojom::OverlayTheme::scrim)& scrim(
      const ::lens::mojom::OverlayThemePtr& input) {
    return input->scrim;
  }

  static const decltype(::lens::mojom::OverlayTheme::surface_container_highest_light)& surface_container_highest_light(
      const ::lens::mojom::OverlayThemePtr& input) {
    return input->surface_container_highest_light;
  }

  static const decltype(::lens::mojom::OverlayTheme::surface_container_highest_dark)& surface_container_highest_dark(
      const ::lens::mojom::OverlayThemePtr& input) {
    return input->surface_container_highest_dark;
  }

  static const decltype(::lens::mojom::OverlayTheme::selection_element)& selection_element(
      const ::lens::mojom::OverlayThemePtr& input) {
    return input->selection_element;
  }

  static bool Read(::lens::mojom::OverlayTheme::DataView input, ::lens::mojom::OverlayThemePtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_LENS_CORE_MOJOM_LENS_MOJOM_H_