// chrome/browser/glic/host/glic.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/glic/host/glic.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/glic/host/glic.mojom-params-data.h"
#include "chrome/browser/glic/host/glic.mojom-shared-message-ids.h"

#include "chrome/browser/glic/host/glic.mojom-import-headers.h"
#include "chrome/browser/glic/host/glic.mojom-test-utils.h"


namespace glic::mojom {
UserProfileInfo::UserProfileInfo()
    : avatar_icon(),
      display_name(),
      local_profile_name(),
      email(),
      given_name(),
      is_managed() {}

UserProfileInfo::UserProfileInfo(
    const ::SkBitmap& avatar_icon_in,
    const std::string& display_name_in,
    const std::string& local_profile_name_in,
    const std::string& email_in,
    const std::string& given_name_in,
    bool is_managed_in)
    : avatar_icon(std::move(avatar_icon_in)),
      display_name(std::move(display_name_in)),
      local_profile_name(std::move(local_profile_name_in)),
      email(std::move(email_in)),
      given_name(std::move(given_name_in)),
      is_managed(std::move(is_managed_in)) {}

UserProfileInfo::~UserProfileInfo() = default;

void UserProfileInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "avatar_icon"), this->avatar_icon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::SkBitmap&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "local_profile_name"), this->local_profile_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "email"), this->email,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "given_name"), this->given_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_managed"), this->is_managed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UserProfileInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ActiveBrowserInfo::ActiveBrowserInfo()
    : window_id(),
      using_this_profile() {}

ActiveBrowserInfo::ActiveBrowserInfo(
    int32_t window_id_in,
    bool using_this_profile_in)
    : window_id(std::move(window_id_in)),
      using_this_profile(std::move(using_this_profile_in)) {}

ActiveBrowserInfo::~ActiveBrowserInfo() = default;
size_t ActiveBrowserInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->window_id);
  seed = mojo::internal::Hash(seed, this->using_this_profile);
  return seed;
}

void ActiveBrowserInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "window_id"), this->window_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "using_this_profile"), this->using_this_profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ActiveBrowserInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebClientInitialState::WebClientInitialState()
    : panel_state(),
      focused_tab_data(),
      microphone_permission_enabled(),
      location_permission_enabled(),
      tab_context_permission_enabled(),
      os_location_permission_enabled(),
      hotkey(),
      chrome_version(),
      can_attach(),
      panel_is_active(),
      browser_is_open(),
      browser_is_active(),
      active_browser_info(),
      always_detached_mode(),
      enable_zero_state_suggestions(),
      enable_act_in_focused_tab(),
      enable_scroll_to(),
      enable_default_tab_context_setting_feature(),
      default_tab_context_setting_enabled(),
      enable_closed_captioning_feature(),
      closed_captioning_setting_enabled(),
      enable_maybe_refresh_user_status(),
      enable_multi_tab(),
      enable_get_context_actor(),
      host_capabilities(),
      enable_get_page_metadata(),
      enable_api_activation_gating() {}

WebClientInitialState::WebClientInitialState(
    PanelStatePtr panel_state_in,
    FocusedTabDataPtr focused_tab_data_in,
    bool microphone_permission_enabled_in,
    bool location_permission_enabled_in,
    bool tab_context_permission_enabled_in,
    bool os_location_permission_enabled_in,
    const std::string& hotkey_in,
    const ::base::Version& chrome_version_in,
    bool can_attach_in,
    bool panel_is_active_in,
    bool browser_is_open_in,
    bool browser_is_active_in,
    ActiveBrowserInfoPtr active_browser_info_in,
    bool always_detached_mode_in,
    bool enable_zero_state_suggestions_in,
    bool enable_act_in_focused_tab_in,
    bool enable_scroll_to_in,
    bool enable_default_tab_context_setting_feature_in,
    bool default_tab_context_setting_enabled_in,
    bool enable_closed_captioning_feature_in,
    bool closed_captioning_setting_enabled_in,
    bool enable_maybe_refresh_user_status_in,
    bool enable_multi_tab_in,
    bool enable_get_context_actor_in,
    std::vector<HostCapability> host_capabilities_in,
    bool enable_get_page_metadata_in,
    bool enable_api_activation_gating_in)
    : panel_state(std::move(panel_state_in)),
      focused_tab_data(std::move(focused_tab_data_in)),
      microphone_permission_enabled(std::move(microphone_permission_enabled_in)),
      location_permission_enabled(std::move(location_permission_enabled_in)),
      tab_context_permission_enabled(std::move(tab_context_permission_enabled_in)),
      os_location_permission_enabled(std::move(os_location_permission_enabled_in)),
      hotkey(std::move(hotkey_in)),
      chrome_version(std::move(chrome_version_in)),
      can_attach(std::move(can_attach_in)),
      panel_is_active(std::move(panel_is_active_in)),
      browser_is_open(std::move(browser_is_open_in)),
      browser_is_active(std::move(browser_is_active_in)),
      active_browser_info(std::move(active_browser_info_in)),
      always_detached_mode(std::move(always_detached_mode_in)),
      enable_zero_state_suggestions(std::move(enable_zero_state_suggestions_in)),
      enable_act_in_focused_tab(std::move(enable_act_in_focused_tab_in)),
      enable_scroll_to(std::move(enable_scroll_to_in)),
      enable_default_tab_context_setting_feature(std::move(enable_default_tab_context_setting_feature_in)),
      default_tab_context_setting_enabled(std::move(default_tab_context_setting_enabled_in)),
      enable_closed_captioning_feature(std::move(enable_closed_captioning_feature_in)),
      closed_captioning_setting_enabled(std::move(closed_captioning_setting_enabled_in)),
      enable_maybe_refresh_user_status(std::move(enable_maybe_refresh_user_status_in)),
      enable_multi_tab(std::move(enable_multi_tab_in)),
      enable_get_context_actor(std::move(enable_get_context_actor_in)),
      host_capabilities(std::move(host_capabilities_in)),
      enable_get_page_metadata(std::move(enable_get_page_metadata_in)),
      enable_api_activation_gating(std::move(enable_api_activation_gating_in)) {}

WebClientInitialState::~WebClientInitialState() = default;

void WebClientInitialState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "panel_state"), this->panel_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PanelStatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "focused_tab_data"), this->focused_tab_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FocusedTabDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "microphone_permission_enabled"), this->microphone_permission_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "location_permission_enabled"), this->location_permission_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_context_permission_enabled"), this->tab_context_permission_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "os_location_permission_enabled"), this->os_location_permission_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hotkey"), this->hotkey,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "chrome_version"), this->chrome_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::Version&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_attach"), this->can_attach,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "panel_is_active"), this->panel_is_active,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "browser_is_open"), this->browser_is_open,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "browser_is_active"), this->browser_is_active,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active_browser_info"), this->active_browser_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ActiveBrowserInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "always_detached_mode"), this->always_detached_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_zero_state_suggestions"), this->enable_zero_state_suggestions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_act_in_focused_tab"), this->enable_act_in_focused_tab,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_scroll_to"), this->enable_scroll_to,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_default_tab_context_setting_feature"), this->enable_default_tab_context_setting_feature,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "default_tab_context_setting_enabled"), this->default_tab_context_setting_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_closed_captioning_feature"), this->enable_closed_captioning_feature,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "closed_captioning_setting_enabled"), this->closed_captioning_setting_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_maybe_refresh_user_status"), this->enable_maybe_refresh_user_status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_multi_tab"), this->enable_multi_tab,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_get_context_actor"), this->enable_get_context_actor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_capabilities"), this->host_capabilities,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<HostCapability>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_get_page_metadata"), this->enable_get_page_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_api_activation_gating"), this->enable_api_activation_gating,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebClientInitialState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GetTabContextOptions::GetTabContextOptions()
    : include_inner_text(),
      inner_text_bytes_limit(),
      include_viewport_screenshot(),
      include_annotated_page_content(),
      max_meta_tags(),
      include_pdf(),
      pdf_size_limit(),
      annotated_page_content_mode(0U) {}

GetTabContextOptions::GetTabContextOptions(
    bool include_inner_text_in,
    uint32_t inner_text_bytes_limit_in,
    bool include_viewport_screenshot_in,
    bool include_annotated_page_content_in,
    uint32_t max_meta_tags_in,
    bool include_pdf_in,
    uint32_t pdf_size_limit_in,
    uint32_t annotated_page_content_mode_in)
    : include_inner_text(std::move(include_inner_text_in)),
      inner_text_bytes_limit(std::move(inner_text_bytes_limit_in)),
      include_viewport_screenshot(std::move(include_viewport_screenshot_in)),
      include_annotated_page_content(std::move(include_annotated_page_content_in)),
      max_meta_tags(std::move(max_meta_tags_in)),
      include_pdf(std::move(include_pdf_in)),
      pdf_size_limit(std::move(pdf_size_limit_in)),
      annotated_page_content_mode(std::move(annotated_page_content_mode_in)) {}

GetTabContextOptions::~GetTabContextOptions() = default;
size_t GetTabContextOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->include_inner_text);
  seed = mojo::internal::Hash(seed, this->inner_text_bytes_limit);
  seed = mojo::internal::Hash(seed, this->include_viewport_screenshot);
  seed = mojo::internal::Hash(seed, this->include_annotated_page_content);
  seed = mojo::internal::Hash(seed, this->max_meta_tags);
  seed = mojo::internal::Hash(seed, this->include_pdf);
  seed = mojo::internal::Hash(seed, this->pdf_size_limit);
  seed = mojo::internal::Hash(seed, this->annotated_page_content_mode);
  return seed;
}

void GetTabContextOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_inner_text"), this->include_inner_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inner_text_bytes_limit"), this->inner_text_bytes_limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_viewport_screenshot"), this->include_viewport_screenshot,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_annotated_page_content"), this->include_annotated_page_content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_meta_tags"), this->max_meta_tags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_pdf"), this->include_pdf,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pdf_size_limit"), this->pdf_size_limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "annotated_page_content_mode"), this->annotated_page_content_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GetTabContextOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GetPinCandidatesOptions::GetPinCandidatesOptions()
    : max_candidates(),
      query() {}

GetPinCandidatesOptions::GetPinCandidatesOptions(
    uint32_t max_candidates_in,
    const std::optional<std::string>& query_in)
    : max_candidates(std::move(max_candidates_in)),
      query(std::move(query_in)) {}

GetPinCandidatesOptions::~GetPinCandidatesOptions() = default;

void GetPinCandidatesOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_candidates"), this->max_candidates,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "query"), this->query,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GetPinCandidatesOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScrollToParams::ScrollToParams()
    : selector(),
      highlight(),
      document_id(),
      url() {}

ScrollToParams::ScrollToParams(
    ScrollToSelectorPtr selector_in,
    bool highlight_in,
    const std::optional<::base::UnguessableToken>& document_id_in,
    const std::optional<::GURL>& url_in)
    : selector(std::move(selector_in)),
      highlight(std::move(highlight_in)),
      document_id(std::move(document_id_in)),
      url(std::move(url_in)) {}

ScrollToParams::~ScrollToParams() = default;

void ScrollToParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selector"), this->selector,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ScrollToSelectorPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "highlight"), this->highlight,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_id"), this->document_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScrollToParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScrollToTextSelector::ScrollToTextSelector()
    : text(),
      search_range_start_node_id() {}

ScrollToTextSelector::ScrollToTextSelector(
    const std::string& text_in,
    std::optional<int32_t> search_range_start_node_id_in)
    : text(std::move(text_in)),
      search_range_start_node_id(std::move(search_range_start_node_id_in)) {}

ScrollToTextSelector::~ScrollToTextSelector() = default;

void ScrollToTextSelector::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "search_range_start_node_id"), this->search_range_start_node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScrollToTextSelector::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScrollToTextFragmentSelector::ScrollToTextFragmentSelector()
    : text_start(),
      text_end(),
      search_range_start_node_id() {}

ScrollToTextFragmentSelector::ScrollToTextFragmentSelector(
    const std::string& text_start_in,
    const std::string& text_end_in,
    std::optional<int32_t> search_range_start_node_id_in)
    : text_start(std::move(text_start_in)),
      text_end(std::move(text_end_in)),
      search_range_start_node_id(std::move(search_range_start_node_id_in)) {}

ScrollToTextFragmentSelector::~ScrollToTextFragmentSelector() = default;

void ScrollToTextFragmentSelector::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_start"), this->text_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_end"), this->text_end,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "search_range_start_node_id"), this->search_range_start_node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScrollToTextFragmentSelector::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScrollToNodeSelector::ScrollToNodeSelector()
    : node_id() {}

ScrollToNodeSelector::ScrollToNodeSelector(
    int32_t node_id_in)
    : node_id(std::move(node_id_in)) {}

ScrollToNodeSelector::~ScrollToNodeSelector() = default;
size_t ScrollToNodeSelector::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->node_id);
  return seed;
}

void ScrollToNodeSelector::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "node_id"), this->node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScrollToNodeSelector::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SuggestionContent::SuggestionContent()
    : suggestion() {}

SuggestionContent::SuggestionContent(
    const std::string& suggestion_in)
    : suggestion(std::move(suggestion_in)) {}

SuggestionContent::~SuggestionContent() = default;
size_t SuggestionContent::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->suggestion);
  return seed;
}

void SuggestionContent::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggestion"), this->suggestion,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SuggestionContent::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ZeroStateSuggestions::ZeroStateSuggestions()
    : suggestions(),
      tab_id(),
      tab_url() {}

ZeroStateSuggestions::ZeroStateSuggestions(
    std::vector<SuggestionContentPtr> suggestions_in,
    int32_t tab_id_in,
    const ::GURL& tab_url_in)
    : suggestions(std::move(suggestions_in)),
      tab_id(std::move(tab_id_in)),
      tab_url(std::move(tab_url_in)) {}

ZeroStateSuggestions::~ZeroStateSuggestions() = default;

void ZeroStateSuggestions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggestions"), this->suggestions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<SuggestionContentPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_id"), this->tab_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_url"), this->tab_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ZeroStateSuggestions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ZeroStateSuggestionsV2::ZeroStateSuggestionsV2()
    : suggestions(),
      is_pending() {}

ZeroStateSuggestionsV2::ZeroStateSuggestionsV2(
    std::vector<SuggestionContentPtr> suggestions_in,
    bool is_pending_in)
    : suggestions(std::move(suggestions_in)),
      is_pending(std::move(is_pending_in)) {}

ZeroStateSuggestionsV2::~ZeroStateSuggestionsV2() = default;

void ZeroStateSuggestionsV2::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggestions"), this->suggestions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<SuggestionContentPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_pending"), this->is_pending,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ZeroStateSuggestionsV2::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ZeroStateSuggestionsOptions::ZeroStateSuggestionsOptions()
    : is_first_run(),
      supported_tools() {}

ZeroStateSuggestionsOptions::ZeroStateSuggestionsOptions(
    bool is_first_run_in,
    std::vector<std::string> supported_tools_in)
    : is_first_run(std::move(is_first_run_in)),
      supported_tools(std::move(supported_tools_in)) {}

ZeroStateSuggestionsOptions::~ZeroStateSuggestionsOptions() = default;

void ZeroStateSuggestionsOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_first_run"), this->is_first_run,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supported_tools"), this->supported_tools,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ZeroStateSuggestionsOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PinCandidate::PinCandidate()
    : tab_data() {}

PinCandidate::PinCandidate(
    TabDataPtr tab_data_in)
    : tab_data(std::move(tab_data_in)) {}

PinCandidate::~PinCandidate() = default;

void PinCandidate::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_data"), this->tab_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TabDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PinCandidate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ConversationInfo::ConversationInfo()
    : conversation_id(),
      conversation_title() {}

ConversationInfo::ConversationInfo(
    const std::string& conversation_id_in,
    const std::string& conversation_title_in)
    : conversation_id(std::move(conversation_id_in)),
      conversation_title(std::move(conversation_title_in)) {}

ConversationInfo::~ConversationInfo() = default;
size_t ConversationInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->conversation_id);
  seed = mojo::internal::Hash(seed, this->conversation_title);
  return seed;
}

void ConversationInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "conversation_id"), this->conversation_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "conversation_title"), this->conversation_title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ConversationInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PanelOpeningData::PanelOpeningData()
    : panel_state(),
      invocation_source(),
      conversation_id() {}

PanelOpeningData::PanelOpeningData(
    PanelStatePtr panel_state_in,
    InvocationSource invocation_source_in,
    const std::optional<std::string>& conversation_id_in)
    : panel_state(std::move(panel_state_in)),
      invocation_source(std::move(invocation_source_in)),
      conversation_id(std::move(conversation_id_in)) {}

PanelOpeningData::~PanelOpeningData() = default;

void PanelOpeningData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "panel_state"), this->panel_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PanelStatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "invocation_source"), this->invocation_source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type InvocationSource>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "conversation_id"), this->conversation_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PanelOpeningData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PanelState::PanelState()
    : kind(),
      window_id() {}

PanelState::PanelState(
    PanelState::Kind kind_in,
    std::optional<int32_t> window_id_in)
    : kind(std::move(kind_in)),
      window_id(std::move(window_id_in)) {}

PanelState::~PanelState() = default;

void PanelState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "kind"), this->kind,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PanelState::Kind>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "window_id"), this->window_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PanelState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OnResponseStoppedDetails::OnResponseStoppedDetails()
    : cause() {}

OnResponseStoppedDetails::OnResponseStoppedDetails(
    ResponseStopCause cause_in)
    : cause(std::move(cause_in)) {}

OnResponseStoppedDetails::~OnResponseStoppedDetails() = default;
size_t OnResponseStoppedDetails::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->cause);
  return seed;
}

void OnResponseStoppedDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cause"), this->cause,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ResponseStopCause>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OnResponseStoppedDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OpenPanelInfo::OpenPanelInfo()
    : web_client_mode(),
      panelSize(),
      resizeDuration(),
      can_user_resize() {}

OpenPanelInfo::OpenPanelInfo(
    WebClientMode web_client_mode_in,
    const std::optional<::gfx::Size>& panelSize_in,
    ::base::TimeDelta resizeDuration_in,
    bool can_user_resize_in)
    : web_client_mode(std::move(web_client_mode_in)),
      panelSize(std::move(panelSize_in)),
      resizeDuration(std::move(resizeDuration_in)),
      can_user_resize(std::move(can_user_resize_in)) {}

OpenPanelInfo::~OpenPanelInfo() = default;

void OpenPanelInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "web_client_mode"), this->web_client_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebClientMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "panelSize"), this->panelSize,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Size>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resizeDuration"), this->resizeDuration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_user_resize"), this->can_user_resize,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OpenPanelInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ContextData::ContextData()
    : mime_type(),
      data() {}

ContextData::ContextData(
    const std::string& mime_type_in,
    ::mojo_base::BigBuffer data_in)
    : mime_type(std::move(mime_type_in)),
      data(std::move(data_in)) {}

ContextData::~ContextData() = default;

void ContextData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_type"), this->mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo_base::BigBuffer>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ContextData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AdditionalContext::AdditionalContext()
    : name(),
      tab_id(),
      origin(),
      frameUrl(),
      parts() {}

AdditionalContext::AdditionalContext(
    const std::optional<std::string>& name_in,
    std::optional<int32_t> tab_id_in,
    const std::optional<::url::Origin>& origin_in,
    const std::optional<::GURL>& frameUrl_in,
    std::vector<AdditionalContextPartPtr> parts_in)
    : name(std::move(name_in)),
      tab_id(std::move(tab_id_in)),
      origin(std::move(origin_in)),
      frameUrl(std::move(frameUrl_in)),
      parts(std::move(parts_in)) {}

AdditionalContext::~AdditionalContext() = default;

void AdditionalContext::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_id"), this->tab_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frameUrl"), this->frameUrl,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parts"), this->parts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AdditionalContextPartPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AdditionalContext::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TabContext::TabContext()
    : tab_data(),
      web_page_data(),
      viewport_screenshot(),
      pdf_document_data(),
      annotated_page_data() {}

TabContext::TabContext(
    TabDataPtr tab_data_in,
    WebPageDataPtr web_page_data_in,
    ScreenshotPtr viewport_screenshot_in,
    PdfDocumentDataPtr pdf_document_data_in,
    AnnotatedPageDataPtr annotated_page_data_in)
    : tab_data(std::move(tab_data_in)),
      web_page_data(std::move(web_page_data_in)),
      viewport_screenshot(std::move(viewport_screenshot_in)),
      pdf_document_data(std::move(pdf_document_data_in)),
      annotated_page_data(std::move(annotated_page_data_in)) {}

TabContext::~TabContext() = default;

void TabContext::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_data"), this->tab_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TabDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "web_page_data"), this->web_page_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebPageDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "viewport_screenshot"), this->viewport_screenshot,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ScreenshotPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pdf_document_data"), this->pdf_document_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PdfDocumentDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "annotated_page_data"), this->annotated_page_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AnnotatedPageDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabContext::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebPageData::WebPageData()
    : main_document() {}

WebPageData::WebPageData(
    DocumentDataPtr main_document_in)
    : main_document(std::move(main_document_in)) {}

WebPageData::~WebPageData() = default;

void WebPageData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_document"), this->main_document,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DocumentDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebPageData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DocumentData::DocumentData()
    : origin(),
      inner_text(),
      inner_text_truncated() {}

DocumentData::DocumentData(
    const ::url::Origin& origin_in,
    const std::string& inner_text_in,
    bool inner_text_truncated_in)
    : origin(std::move(origin_in)),
      inner_text(std::move(inner_text_in)),
      inner_text_truncated(std::move(inner_text_truncated_in)) {}

DocumentData::~DocumentData() = default;

void DocumentData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inner_text"), this->inner_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inner_text_truncated"), this->inner_text_truncated,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DocumentData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PdfDocumentData::PdfDocumentData()
    : origin(),
      pdf_data(),
      size_limit_exceeded() {}

PdfDocumentData::PdfDocumentData(
    const ::url::Origin& origin_in,
    std::optional<std::vector<uint8_t>> pdf_data_in,
    bool size_limit_exceeded_in)
    : origin(std::move(origin_in)),
      pdf_data(std::move(pdf_data_in)),
      size_limit_exceeded(std::move(size_limit_exceeded_in)) {}

PdfDocumentData::~PdfDocumentData() = default;

void PdfDocumentData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pdf_data"), this->pdf_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size_limit_exceeded"), this->size_limit_exceeded,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PdfDocumentData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TabData::TabData()
    : tab_id(),
      window_id(),
      url(),
      title(),
      favicon(),
      favicon_url(),
      document_mime_type(),
      is_observable(),
      is_media_active(),
      is_tab_content_captured() {}

TabData::TabData(
    int32_t tab_id_in,
    int32_t window_id_in,
    const ::GURL& url_in,
    const std::optional<std::string>& title_in,
    const ::SkBitmap& favicon_in,
    const std::optional<::GURL>& favicon_url_in,
    const std::string& document_mime_type_in,
    std::optional<bool> is_observable_in,
    std::optional<bool> is_media_active_in,
    std::optional<bool> is_tab_content_captured_in)
    : tab_id(std::move(tab_id_in)),
      window_id(std::move(window_id_in)),
      url(std::move(url_in)),
      title(std::move(title_in)),
      favicon(std::move(favicon_in)),
      favicon_url(std::move(favicon_url_in)),
      document_mime_type(std::move(document_mime_type_in)),
      is_observable(std::move(is_observable_in)),
      is_media_active(std::move(is_media_active_in)),
      is_tab_content_captured(std::move(is_tab_content_captured_in)) {}

TabData::~TabData() = default;

void TabData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_id"), this->tab_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "window_id"), this->window_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "favicon"), this->favicon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::SkBitmap&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "favicon_url"), this->favicon_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_mime_type"), this->document_mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_observable"), this->is_observable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_media_active"), this->is_media_active,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_tab_content_captured"), this->is_tab_content_captured,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NoFocusedTabData::NoFocusedTabData()
    : active_tab_data(),
      no_focus_reason() {}

NoFocusedTabData::NoFocusedTabData(
    TabDataPtr active_tab_data_in,
    const std::string& no_focus_reason_in)
    : active_tab_data(std::move(active_tab_data_in)),
      no_focus_reason(std::move(no_focus_reason_in)) {}

NoFocusedTabData::~NoFocusedTabData() = default;

void NoFocusedTabData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active_tab_data"), this->active_tab_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TabDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "no_focus_reason"), this->no_focus_reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NoFocusedTabData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnnotatedPageData::AnnotatedPageData()
    : annotated_page_content(),
      metadata() {}

AnnotatedPageData::AnnotatedPageData(
    std::optional<::mojo_base::ProtoWrapper> annotated_page_content_in,
    ::blink::mojom::PageMetadataPtr metadata_in)
    : annotated_page_content(std::move(annotated_page_content_in)),
      metadata(std::move(metadata_in)) {}

AnnotatedPageData::~AnnotatedPageData() = default;

void AnnotatedPageData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "annotated_page_content"), this->annotated_page_content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::mojo_base::ProtoWrapper>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metadata"), this->metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::PageMetadataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnnotatedPageData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ImageOriginAnnotations::ImageOriginAnnotations() {}

ImageOriginAnnotations::~ImageOriginAnnotations() = default;
size_t ImageOriginAnnotations::Hash(size_t seed) const {
  return seed;
}

void ImageOriginAnnotations::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool ImageOriginAnnotations::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Journal::Journal()
    : data() {}

Journal::Journal(
    std::vector<uint8_t> data_in)
    : data(std::move(data_in)) {}

Journal::~Journal() = default;

void Journal::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Journal::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Screenshot::Screenshot()
    : width_pixels(),
      height_pixels(),
      data(),
      mime_type(),
      origin_annotations() {}

Screenshot::Screenshot(
    uint32_t width_pixels_in,
    uint32_t height_pixels_in,
    std::vector<uint8_t> data_in,
    const std::string& mime_type_in,
    ImageOriginAnnotationsPtr origin_annotations_in)
    : width_pixels(std::move(width_pixels_in)),
      height_pixels(std::move(height_pixels_in)),
      data(std::move(data_in)),
      mime_type(std::move(mime_type_in)),
      origin_annotations(std::move(origin_annotations_in)) {}

Screenshot::~Screenshot() = default;

void Screenshot::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width_pixels"), this->width_pixels,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "height_pixels"), this->height_pixels,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_type"), this->mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin_annotations"), this->origin_annotations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ImageOriginAnnotationsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Screenshot::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OpenSettingsOptions::OpenSettingsOptions()
    : highlightField() {}

OpenSettingsOptions::OpenSettingsOptions(
    SettingsPageField highlightField_in)
    : highlightField(std::move(highlightField_in)) {}

OpenSettingsOptions::~OpenSettingsOptions() = default;
size_t OpenSettingsOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->highlightField);
  return seed;
}

void OpenSettingsOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "highlightField"), this->highlightField,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SettingsPageField>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OpenSettingsOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ViewChangeRequestActuation::ViewChangeRequestActuation() {}

ViewChangeRequestActuation::~ViewChangeRequestActuation() = default;
size_t ViewChangeRequestActuation::Hash(size_t seed) const {
  return seed;
}

void ViewChangeRequestActuation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool ViewChangeRequestActuation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ViewChangeRequestConversation::ViewChangeRequestConversation() {}

ViewChangeRequestConversation::~ViewChangeRequestConversation() = default;
size_t ViewChangeRequestConversation::Hash(size_t seed) const {
  return seed;
}

void ViewChangeRequestConversation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool ViewChangeRequestConversation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ViewChangeRequest::ViewChangeRequest()
    : details() {}

ViewChangeRequest::ViewChangeRequest(
    ViewChangeRequestDetailsPtr details_in)
    : details(std::move(details_in)) {}

ViewChangeRequest::~ViewChangeRequest() = default;
size_t ViewChangeRequest::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->details);
  return seed;
}

void ViewChangeRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "details"), this->details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ViewChangeRequestDetailsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ViewChangeRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ViewChangedNotification::ViewChangedNotification()
    : current_view() {}

ViewChangedNotification::ViewChangedNotification(
    CurrentView current_view_in)
    : current_view(std::move(current_view_in)) {}

ViewChangedNotification::~ViewChangedNotification() = default;
size_t ViewChangedNotification::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->current_view);
  return seed;
}

void ViewChangedNotification::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current_view"), this->current_view,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CurrentView>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ViewChangedNotification::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GetContextResultPtr
GetContextResult::NewErrorReason(
    const std::string& value) {
  return GetContextResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kErrorReason)>,
      std::move(value));
}

GetContextResultPtr
GetContextResult::NewTabContext(
    TabContextPtr value) {
  return GetContextResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTabContext)>,
      std::move(value));
}

GetContextResult::GetContextResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
    const std::string& value)
    : tag_(Tag::kErrorReason),
      data_(std::in_place_index<static_cast<size_t>(Tag::kErrorReason)>,
            std::move(value)) {}

GetContextResult::GetContextResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kTabContext)>,
    TabContextPtr value)
    : tag_(Tag::kTabContext),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTabContext)>,
            std::move(value)) {}
GetContextResult::~GetContextResult() {
  DestroyActive();
}

void GetContextResult::set_error_reason(const std::string& error_reason) {
  if (tag_ == Tag::kErrorReason) {
    data_.error_reason = std::move(error_reason);
  } else {
    DestroyActive();
    tag_ = Tag::kErrorReason;
    new (&data_.error_reason) std::string(
        std::move(error_reason));
  }
}

void GetContextResult::set_tab_context(TabContextPtr tab_context) {
  if (tag_ == Tag::kTabContext) {
    data_.tab_context = std::move(tab_context);
  } else {
    DestroyActive();
    tag_ = Tag::kTabContext;
    new (&data_.tab_context) TabContextPtr(
        std::move(tab_context));
  }
}


GetContextResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
    const std::string& value)
    : error_reason(std::move(value)) {}

GetContextResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTabContext)>,
    TabContextPtr value)
    : tab_context(std::move(value)) {}

void GetContextResult::DestroyActive() {
  switch (tag_) {

    case Tag::kErrorReason:
      std::destroy_at(&data_.error_reason);
      break;
    case Tag::kTabContext:
      std::destroy_at(&data_.tab_context);
      break;
  }
}

bool GetContextResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
CaptureScreenshotResultPtr
CaptureScreenshotResult::NewErrorReason(
    CaptureScreenshotErrorReason value) {
  return CaptureScreenshotResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kErrorReason)>,
      std::move(value));
}

CaptureScreenshotResultPtr
CaptureScreenshotResult::NewScreenshot(
    ScreenshotPtr value) {
  return CaptureScreenshotResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kScreenshot)>,
      std::move(value));
}

CaptureScreenshotResult::CaptureScreenshotResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
    CaptureScreenshotErrorReason value)
    : tag_(Tag::kErrorReason),
      data_(std::in_place_index<static_cast<size_t>(Tag::kErrorReason)>,
            std::move(value)) {}

CaptureScreenshotResult::CaptureScreenshotResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kScreenshot)>,
    ScreenshotPtr value)
    : tag_(Tag::kScreenshot),
      data_(std::in_place_index<static_cast<size_t>(Tag::kScreenshot)>,
            std::move(value)) {}
CaptureScreenshotResult::~CaptureScreenshotResult() {
  DestroyActive();
}

void CaptureScreenshotResult::set_error_reason(CaptureScreenshotErrorReason error_reason) {
  if (tag_ != Tag::kErrorReason) {
    DestroyActive();
    tag_ = Tag::kErrorReason;
  }
  data_.error_reason = error_reason;
}

void CaptureScreenshotResult::set_screenshot(ScreenshotPtr screenshot) {
  if (tag_ == Tag::kScreenshot) {
    data_.screenshot = std::move(screenshot);
  } else {
    DestroyActive();
    tag_ = Tag::kScreenshot;
    new (&data_.screenshot) ScreenshotPtr(
        std::move(screenshot));
  }
}


CaptureScreenshotResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
    CaptureScreenshotErrorReason value)
    : error_reason(std::move(value)) {}

CaptureScreenshotResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kScreenshot)>,
    ScreenshotPtr value)
    : screenshot(std::move(value)) {}

void CaptureScreenshotResult::DestroyActive() {
  switch (tag_) {

    case Tag::kErrorReason:
      std::destroy_at(&data_.error_reason);
      break;
    case Tag::kScreenshot:
      std::destroy_at(&data_.screenshot);
      break;
  }
}

bool CaptureScreenshotResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
ScrollToSelectorPtr
ScrollToSelector::NewExactTextSelector(
    ScrollToTextSelectorPtr value) {
  return ScrollToSelectorPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kExactTextSelector)>,
      std::move(value));
}

ScrollToSelectorPtr
ScrollToSelector::NewTextFragmentSelector(
    ScrollToTextFragmentSelectorPtr value) {
  return ScrollToSelectorPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTextFragmentSelector)>,
      std::move(value));
}

ScrollToSelectorPtr
ScrollToSelector::NewNodeSelector(
    ScrollToNodeSelectorPtr value) {
  return ScrollToSelectorPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNodeSelector)>,
      std::move(value));
}

ScrollToSelector::ScrollToSelector(
    std::in_place_index_t<static_cast<size_t>(Tag::kExactTextSelector)>,
    ScrollToTextSelectorPtr value)
    : tag_(Tag::kExactTextSelector),
      data_(std::in_place_index<static_cast<size_t>(Tag::kExactTextSelector)>,
            std::move(value)) {}

ScrollToSelector::ScrollToSelector(
    std::in_place_index_t<static_cast<size_t>(Tag::kTextFragmentSelector)>,
    ScrollToTextFragmentSelectorPtr value)
    : tag_(Tag::kTextFragmentSelector),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTextFragmentSelector)>,
            std::move(value)) {}

ScrollToSelector::ScrollToSelector(
    std::in_place_index_t<static_cast<size_t>(Tag::kNodeSelector)>,
    ScrollToNodeSelectorPtr value)
    : tag_(Tag::kNodeSelector),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNodeSelector)>,
            std::move(value)) {}
ScrollToSelector::~ScrollToSelector() {
  DestroyActive();
}

void ScrollToSelector::set_exact_text_selector(ScrollToTextSelectorPtr exact_text_selector) {
  if (tag_ == Tag::kExactTextSelector) {
    data_.exact_text_selector = std::move(exact_text_selector);
  } else {
    DestroyActive();
    tag_ = Tag::kExactTextSelector;
    new (&data_.exact_text_selector) ScrollToTextSelectorPtr(
        std::move(exact_text_selector));
  }
}

void ScrollToSelector::set_text_fragment_selector(ScrollToTextFragmentSelectorPtr text_fragment_selector) {
  if (tag_ == Tag::kTextFragmentSelector) {
    data_.text_fragment_selector = std::move(text_fragment_selector);
  } else {
    DestroyActive();
    tag_ = Tag::kTextFragmentSelector;
    new (&data_.text_fragment_selector) ScrollToTextFragmentSelectorPtr(
        std::move(text_fragment_selector));
  }
}

void ScrollToSelector::set_node_selector(ScrollToNodeSelectorPtr node_selector) {
  if (tag_ == Tag::kNodeSelector) {
    data_.node_selector = std::move(node_selector);
  } else {
    DestroyActive();
    tag_ = Tag::kNodeSelector;
    new (&data_.node_selector) ScrollToNodeSelectorPtr(
        std::move(node_selector));
  }
}


ScrollToSelector::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kExactTextSelector)>,
    ScrollToTextSelectorPtr value)
    : exact_text_selector(std::move(value)) {}

ScrollToSelector::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTextFragmentSelector)>,
    ScrollToTextFragmentSelectorPtr value)
    : text_fragment_selector(std::move(value)) {}

ScrollToSelector::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNodeSelector)>,
    ScrollToNodeSelectorPtr value)
    : node_selector(std::move(value)) {}

void ScrollToSelector::DestroyActive() {
  switch (tag_) {

    case Tag::kExactTextSelector:
      std::destroy_at(&data_.exact_text_selector);
      break;
    case Tag::kTextFragmentSelector:
      std::destroy_at(&data_.text_fragment_selector);
      break;
    case Tag::kNodeSelector:
      std::destroy_at(&data_.node_selector);
      break;
  }
}

bool ScrollToSelector::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
AdditionalContextPartPtr
AdditionalContextPart::NewData(
    ContextDataPtr value) {
  return AdditionalContextPartPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kData)>,
      std::move(value));
}

AdditionalContextPartPtr
AdditionalContextPart::NewScreenshot(
    ScreenshotPtr value) {
  return AdditionalContextPartPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kScreenshot)>,
      std::move(value));
}

AdditionalContextPartPtr
AdditionalContextPart::NewWebPageData(
    WebPageDataPtr value) {
  return AdditionalContextPartPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kWebPageData)>,
      std::move(value));
}

AdditionalContextPartPtr
AdditionalContextPart::NewAnnotatedPageData(
    AnnotatedPageDataPtr value) {
  return AdditionalContextPartPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kAnnotatedPageData)>,
      std::move(value));
}

AdditionalContextPartPtr
AdditionalContextPart::NewPdfDocumentData(
    PdfDocumentDataPtr value) {
  return AdditionalContextPartPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPdfDocumentData)>,
      std::move(value));
}

AdditionalContextPart::AdditionalContextPart(
    std::in_place_index_t<static_cast<size_t>(Tag::kData)>,
    ContextDataPtr value)
    : tag_(Tag::kData),
      data_(std::in_place_index<static_cast<size_t>(Tag::kData)>,
            std::move(value)) {}

AdditionalContextPart::AdditionalContextPart(
    std::in_place_index_t<static_cast<size_t>(Tag::kScreenshot)>,
    ScreenshotPtr value)
    : tag_(Tag::kScreenshot),
      data_(std::in_place_index<static_cast<size_t>(Tag::kScreenshot)>,
            std::move(value)) {}

AdditionalContextPart::AdditionalContextPart(
    std::in_place_index_t<static_cast<size_t>(Tag::kWebPageData)>,
    WebPageDataPtr value)
    : tag_(Tag::kWebPageData),
      data_(std::in_place_index<static_cast<size_t>(Tag::kWebPageData)>,
            std::move(value)) {}

AdditionalContextPart::AdditionalContextPart(
    std::in_place_index_t<static_cast<size_t>(Tag::kAnnotatedPageData)>,
    AnnotatedPageDataPtr value)
    : tag_(Tag::kAnnotatedPageData),
      data_(std::in_place_index<static_cast<size_t>(Tag::kAnnotatedPageData)>,
            std::move(value)) {}

AdditionalContextPart::AdditionalContextPart(
    std::in_place_index_t<static_cast<size_t>(Tag::kPdfDocumentData)>,
    PdfDocumentDataPtr value)
    : tag_(Tag::kPdfDocumentData),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPdfDocumentData)>,
            std::move(value)) {}
AdditionalContextPart::~AdditionalContextPart() {
  DestroyActive();
}

void AdditionalContextPart::set_data(ContextDataPtr data) {
  if (tag_ == Tag::kData) {
    data_.data = std::move(data);
  } else {
    DestroyActive();
    tag_ = Tag::kData;
    new (&data_.data) ContextDataPtr(
        std::move(data));
  }
}

void AdditionalContextPart::set_screenshot(ScreenshotPtr screenshot) {
  if (tag_ == Tag::kScreenshot) {
    data_.screenshot = std::move(screenshot);
  } else {
    DestroyActive();
    tag_ = Tag::kScreenshot;
    new (&data_.screenshot) ScreenshotPtr(
        std::move(screenshot));
  }
}

void AdditionalContextPart::set_web_page_data(WebPageDataPtr web_page_data) {
  if (tag_ == Tag::kWebPageData) {
    data_.web_page_data = std::move(web_page_data);
  } else {
    DestroyActive();
    tag_ = Tag::kWebPageData;
    new (&data_.web_page_data) WebPageDataPtr(
        std::move(web_page_data));
  }
}

void AdditionalContextPart::set_annotated_page_data(AnnotatedPageDataPtr annotated_page_data) {
  if (tag_ == Tag::kAnnotatedPageData) {
    data_.annotated_page_data = std::move(annotated_page_data);
  } else {
    DestroyActive();
    tag_ = Tag::kAnnotatedPageData;
    new (&data_.annotated_page_data) AnnotatedPageDataPtr(
        std::move(annotated_page_data));
  }
}

void AdditionalContextPart::set_pdf_document_data(PdfDocumentDataPtr pdf_document_data) {
  if (tag_ == Tag::kPdfDocumentData) {
    data_.pdf_document_data = std::move(pdf_document_data);
  } else {
    DestroyActive();
    tag_ = Tag::kPdfDocumentData;
    new (&data_.pdf_document_data) PdfDocumentDataPtr(
        std::move(pdf_document_data));
  }
}


AdditionalContextPart::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kData)>,
    ContextDataPtr value)
    : data(std::move(value)) {}

AdditionalContextPart::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kScreenshot)>,
    ScreenshotPtr value)
    : screenshot(std::move(value)) {}

AdditionalContextPart::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kWebPageData)>,
    WebPageDataPtr value)
    : web_page_data(std::move(value)) {}

AdditionalContextPart::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kAnnotatedPageData)>,
    AnnotatedPageDataPtr value)
    : annotated_page_data(std::move(value)) {}

AdditionalContextPart::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPdfDocumentData)>,
    PdfDocumentDataPtr value)
    : pdf_document_data(std::move(value)) {}

void AdditionalContextPart::DestroyActive() {
  switch (tag_) {

    case Tag::kData:
      std::destroy_at(&data_.data);
      break;
    case Tag::kScreenshot:
      std::destroy_at(&data_.screenshot);
      break;
    case Tag::kWebPageData:
      std::destroy_at(&data_.web_page_data);
      break;
    case Tag::kAnnotatedPageData:
      std::destroy_at(&data_.annotated_page_data);
      break;
    case Tag::kPdfDocumentData:
      std::destroy_at(&data_.pdf_document_data);
      break;
  }
}

bool AdditionalContextPart::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
FocusedTabDataPtr
FocusedTabData::NewFocusedTab(
    TabDataPtr value) {
  return FocusedTabDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFocusedTab)>,
      std::move(value));
}

FocusedTabDataPtr
FocusedTabData::NewNoFocusedTabData(
    NoFocusedTabDataPtr value) {
  return FocusedTabDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNoFocusedTabData)>,
      std::move(value));
}

FocusedTabData::FocusedTabData(
    std::in_place_index_t<static_cast<size_t>(Tag::kFocusedTab)>,
    TabDataPtr value)
    : tag_(Tag::kFocusedTab),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFocusedTab)>,
            std::move(value)) {}

FocusedTabData::FocusedTabData(
    std::in_place_index_t<static_cast<size_t>(Tag::kNoFocusedTabData)>,
    NoFocusedTabDataPtr value)
    : tag_(Tag::kNoFocusedTabData),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNoFocusedTabData)>,
            std::move(value)) {}
FocusedTabData::~FocusedTabData() {
  DestroyActive();
}

void FocusedTabData::set_focused_tab(TabDataPtr focused_tab) {
  if (tag_ == Tag::kFocusedTab) {
    data_.focused_tab = std::move(focused_tab);
  } else {
    DestroyActive();
    tag_ = Tag::kFocusedTab;
    new (&data_.focused_tab) TabDataPtr(
        std::move(focused_tab));
  }
}

void FocusedTabData::set_no_focused_tab_data(NoFocusedTabDataPtr no_focused_tab_data) {
  if (tag_ == Tag::kNoFocusedTabData) {
    data_.no_focused_tab_data = std::move(no_focused_tab_data);
  } else {
    DestroyActive();
    tag_ = Tag::kNoFocusedTabData;
    new (&data_.no_focused_tab_data) NoFocusedTabDataPtr(
        std::move(no_focused_tab_data));
  }
}


FocusedTabData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFocusedTab)>,
    TabDataPtr value)
    : focused_tab(std::move(value)) {}

FocusedTabData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNoFocusedTabData)>,
    NoFocusedTabDataPtr value)
    : no_focused_tab_data(std::move(value)) {}

void FocusedTabData::DestroyActive() {
  switch (tag_) {

    case Tag::kFocusedTab:
      std::destroy_at(&data_.focused_tab);
      break;
    case Tag::kNoFocusedTabData:
      std::destroy_at(&data_.no_focused_tab_data);
      break;
  }
}

bool FocusedTabData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
ViewChangeRequestDetailsPtr
ViewChangeRequestDetails::NewActuation(
    ViewChangeRequestActuationPtr value) {
  return ViewChangeRequestDetailsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kActuation)>,
      std::move(value));
}

ViewChangeRequestDetailsPtr
ViewChangeRequestDetails::NewConversation(
    ViewChangeRequestConversationPtr value) {
  return ViewChangeRequestDetailsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kConversation)>,
      std::move(value));
}

ViewChangeRequestDetails::ViewChangeRequestDetails(
    std::in_place_index_t<static_cast<size_t>(Tag::kActuation)>,
    ViewChangeRequestActuationPtr value)
    : tag_(Tag::kActuation),
      data_(std::in_place_index<static_cast<size_t>(Tag::kActuation)>,
            std::move(value)) {}

ViewChangeRequestDetails::ViewChangeRequestDetails(
    std::in_place_index_t<static_cast<size_t>(Tag::kConversation)>,
    ViewChangeRequestConversationPtr value)
    : tag_(Tag::kConversation),
      data_(std::in_place_index<static_cast<size_t>(Tag::kConversation)>,
            std::move(value)) {}
ViewChangeRequestDetails::~ViewChangeRequestDetails() {
  DestroyActive();
}

void ViewChangeRequestDetails::set_actuation(ViewChangeRequestActuationPtr actuation) {
  if (tag_ == Tag::kActuation) {
    data_.actuation = std::move(actuation);
  } else {
    DestroyActive();
    tag_ = Tag::kActuation;
    new (&data_.actuation) ViewChangeRequestActuationPtr(
        std::move(actuation));
  }
}

void ViewChangeRequestDetails::set_conversation(ViewChangeRequestConversationPtr conversation) {
  if (tag_ == Tag::kConversation) {
    data_.conversation = std::move(conversation);
  } else {
    DestroyActive();
    tag_ = Tag::kConversation;
    new (&data_.conversation) ViewChangeRequestConversationPtr(
        std::move(conversation));
  }
}


ViewChangeRequestDetails::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kActuation)>,
    ViewChangeRequestActuationPtr value)
    : actuation(std::move(value)) {}

ViewChangeRequestDetails::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kConversation)>,
    ViewChangeRequestConversationPtr value)
    : conversation(std::move(value)) {}

void ViewChangeRequestDetails::DestroyActive() {
  switch (tag_) {

    case Tag::kActuation:
      std::destroy_at(&data_.actuation);
      break;
    case Tag::kConversation:
      std::destroy_at(&data_.conversation);
      break;
  }
}
size_t ViewChangeRequestDetails::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kActuation:
      return mojo::internal::Hash(seed, data_.actuation);
    case Tag::kConversation:
      return mojo::internal::Hash(seed, data_.conversation);
    default:
      NOTREACHED();
  }
}

bool ViewChangeRequestDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
WebClientHandler_CreateTask_ResponseParam_ResultPtr
WebClientHandler_CreateTask_ResponseParam_Result::NewSuccess(
    int32_t value) {
  return WebClientHandler_CreateTask_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

WebClientHandler_CreateTask_ResponseParam_ResultPtr
WebClientHandler_CreateTask_ResponseParam_Result::NewFailure(
    CreateTaskErrorReason value) {
  return WebClientHandler_CreateTask_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

WebClientHandler_CreateTask_ResponseParam_Result::WebClientHandler_CreateTask_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    int32_t value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

WebClientHandler_CreateTask_ResponseParam_Result::WebClientHandler_CreateTask_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    CreateTaskErrorReason value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
WebClientHandler_CreateTask_ResponseParam_Result::~WebClientHandler_CreateTask_ResponseParam_Result() {
  DestroyActive();
}

void WebClientHandler_CreateTask_ResponseParam_Result::set_success(int32_t success) {
  if (tag_ != Tag::kSuccess) {
    DestroyActive();
    tag_ = Tag::kSuccess;
  }
  data_.success = success;
}

void WebClientHandler_CreateTask_ResponseParam_Result::set_failure(CreateTaskErrorReason failure) {
  if (tag_ != Tag::kFailure) {
    DestroyActive();
    tag_ = Tag::kFailure;
  }
  data_.failure = failure;
}


WebClientHandler_CreateTask_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    int32_t value)
    : success(std::move(value)) {}

WebClientHandler_CreateTask_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    CreateTaskErrorReason value)
    : failure(std::move(value)) {}

void WebClientHandler_CreateTask_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}
size_t WebClientHandler_CreateTask_ResponseParam_Result::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kSuccess:
      return mojo::internal::Hash(seed, data_.success);
    case Tag::kFailure:
      return mojo::internal::Hash(seed, data_.failure);
    default:
      NOTREACHED();
  }
}

bool WebClientHandler_CreateTask_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
WebClientHandler_PerformActions_ResponseParam_ResultPtr
WebClientHandler_PerformActions_ResponseParam_Result::NewSuccess(
    ::mojo_base::ProtoWrapper value) {
  return WebClientHandler_PerformActions_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

WebClientHandler_PerformActions_ResponseParam_ResultPtr
WebClientHandler_PerformActions_ResponseParam_Result::NewFailure(
    PerformActionsErrorReason value) {
  return WebClientHandler_PerformActions_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

WebClientHandler_PerformActions_ResponseParam_Result::WebClientHandler_PerformActions_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    ::mojo_base::ProtoWrapper value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

WebClientHandler_PerformActions_ResponseParam_Result::WebClientHandler_PerformActions_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    PerformActionsErrorReason value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
WebClientHandler_PerformActions_ResponseParam_Result::~WebClientHandler_PerformActions_ResponseParam_Result() {
  DestroyActive();
}

void WebClientHandler_PerformActions_ResponseParam_Result::set_success(::mojo_base::ProtoWrapper success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) ::mojo_base::ProtoWrapper(
        std::move(success));
  }
}

void WebClientHandler_PerformActions_ResponseParam_Result::set_failure(PerformActionsErrorReason failure) {
  if (tag_ != Tag::kFailure) {
    DestroyActive();
    tag_ = Tag::kFailure;
  }
  data_.failure = failure;
}


WebClientHandler_PerformActions_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    ::mojo_base::ProtoWrapper value)
    : success(std::move(value)) {}

WebClientHandler_PerformActions_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    PerformActionsErrorReason value)
    : failure(std::move(value)) {}

void WebClientHandler_PerformActions_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool WebClientHandler_PerformActions_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kIntentToShow: {
      return &Page::IntentToShow_Sym::IPCStableHash;
    }
    case messages::Page::kSetProfileReadyState: {
      return &Page::SetProfileReadyState_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kIntentToShow:
            return "Receive glic::mojom::Page::IntentToShow";
      case messages::Page::kSetProfileReadyState:
            return "Receive glic::mojom::Page::SetProfileReadyState";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kIntentToShow:
            return "Receive reply glic::mojom::Page::IntentToShow";
      case messages::Page::kSetProfileReadyState:
            return "Receive reply glic::mojom::Page::SetProfileReadyState";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::IntentToShow_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc8a3395b;  // IPCStableHash for glic::mojom::Page::IntentToShow
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::SetProfileReadyState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x946e3d49;  // IPCStableHash for glic::mojom::Page::SetProfileReadyState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::IntentToShow(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::Page::IntentToShow");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kIntentToShow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::Page_IntentToShow_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("IntentToShow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::SetProfileReadyState(
    ProfileReadyState in_ready_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::Page::SetProfileReadyState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ready_state"), in_ready_state,
                        "<value of type ProfileReadyState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSetProfileReadyState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::Page_SetProfileReadyState_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::glic::mojom::ProfileReadyState>(
    in_ready_state,
    &params->ready_state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SetProfileReadyState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kIntentToShow: {
      DCHECK(message->is_serialized());
      internal::Page_IntentToShow_Params_Data* params =
          reinterpret_cast<internal::Page_IntentToShow_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      Page_IntentToShow_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IntentToShow(        );
      return true;
    }
    case messages::Page::kSetProfileReadyState: {
      DCHECK(message->is_serialized());
      internal::Page_SetProfileReadyState_Params_Data* params =
          reinterpret_cast<internal::Page_SetProfileReadyState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.1
      bool success = true;
      ProfileReadyState p_ready_state{};
      Page_SetProfileReadyState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReadyState(&p_ready_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetProfileReadyState(        
        std::move(p_ready_state));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kIntentToShow: {
      break;
    }
    case messages::Page::kSetProfileReadyState: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_IntentToShow_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_SetProfileReadyState_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::glic::mojom::Page::Name_,
    kPageValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      return &PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive glic::mojom::PageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive reply glic::mojom::PageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x60411242;  // IPCStableHash for glic::mojom::PageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingReceiver<PageHandler> in_receiver, ::mojo::PendingRemote<Page> in_page) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::PageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::PageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::glic::mojom::PageHandlerInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in PageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::glic::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingReceiver<PageHandler> p_receiver{};
      ::mojo::PendingRemote<Page> p_page{};
      PageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_receiver), 
        std::move(p_page));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::glic::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kCreateWebClient: {
      return &PageHandler::CreateWebClient_Sym::IPCStableHash;
    }
    case messages::PageHandler::kPrepareForClient: {
      return &PageHandler::PrepareForClient_Sym::IPCStableHash;
    }
    case messages::PageHandler::kWebviewCommitted: {
      return &PageHandler::WebviewCommitted_Sym::IPCStableHash;
    }
    case messages::PageHandler::kClosePanel: {
      return &PageHandler::ClosePanel_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenProfilePickerAndClosePanel: {
      return &PageHandler::OpenProfilePickerAndClosePanel_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenDisabledByAdminLinkAndClosePanel: {
      return &PageHandler::OpenDisabledByAdminLinkAndClosePanel_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSignInAndClosePanel: {
      return &PageHandler::SignInAndClosePanel_Sym::IPCStableHash;
    }
    case messages::PageHandler::kResizeWidget: {
      return &PageHandler::ResizeWidget_Sym::IPCStableHash;
    }
    case messages::PageHandler::kEnableDragResize: {
      return &PageHandler::EnableDragResize_Sym::IPCStableHash;
    }
    case messages::PageHandler::kWebUiStateChanged: {
      return &PageHandler::WebUiStateChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kCreateWebClient:
            return "Receive glic::mojom::PageHandler::CreateWebClient";
      case messages::PageHandler::kPrepareForClient:
            return "Receive glic::mojom::PageHandler::PrepareForClient";
      case messages::PageHandler::kWebviewCommitted:
            return "Receive glic::mojom::PageHandler::WebviewCommitted";
      case messages::PageHandler::kClosePanel:
            return "Receive glic::mojom::PageHandler::ClosePanel";
      case messages::PageHandler::kOpenProfilePickerAndClosePanel:
            return "Receive glic::mojom::PageHandler::OpenProfilePickerAndClosePanel";
      case messages::PageHandler::kOpenDisabledByAdminLinkAndClosePanel:
            return "Receive glic::mojom::PageHandler::OpenDisabledByAdminLinkAndClosePanel";
      case messages::PageHandler::kSignInAndClosePanel:
            return "Receive glic::mojom::PageHandler::SignInAndClosePanel";
      case messages::PageHandler::kResizeWidget:
            return "Receive glic::mojom::PageHandler::ResizeWidget";
      case messages::PageHandler::kEnableDragResize:
            return "Receive glic::mojom::PageHandler::EnableDragResize";
      case messages::PageHandler::kWebUiStateChanged:
            return "Receive glic::mojom::PageHandler::WebUiStateChanged";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kCreateWebClient:
            return "Receive reply glic::mojom::PageHandler::CreateWebClient";
      case messages::PageHandler::kPrepareForClient:
            return "Receive reply glic::mojom::PageHandler::PrepareForClient";
      case messages::PageHandler::kWebviewCommitted:
            return "Receive reply glic::mojom::PageHandler::WebviewCommitted";
      case messages::PageHandler::kClosePanel:
            return "Receive reply glic::mojom::PageHandler::ClosePanel";
      case messages::PageHandler::kOpenProfilePickerAndClosePanel:
            return "Receive reply glic::mojom::PageHandler::OpenProfilePickerAndClosePanel";
      case messages::PageHandler::kOpenDisabledByAdminLinkAndClosePanel:
            return "Receive reply glic::mojom::PageHandler::OpenDisabledByAdminLinkAndClosePanel";
      case messages::PageHandler::kSignInAndClosePanel:
            return "Receive reply glic::mojom::PageHandler::SignInAndClosePanel";
      case messages::PageHandler::kResizeWidget:
            return "Receive reply glic::mojom::PageHandler::ResizeWidget";
      case messages::PageHandler::kEnableDragResize:
            return "Receive reply glic::mojom::PageHandler::EnableDragResize";
      case messages::PageHandler::kWebUiStateChanged:
            return "Receive reply glic::mojom::PageHandler::WebUiStateChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::CreateWebClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x93bcdc3a;  // IPCStableHash for glic::mojom::PageHandler::CreateWebClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::PrepareForClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbfaaed9f;  // IPCStableHash for glic::mojom::PageHandler::PrepareForClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::WebviewCommitted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa01f6fcc;  // IPCStableHash for glic::mojom::PageHandler::WebviewCommitted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ClosePanel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf5f6f919;  // IPCStableHash for glic::mojom::PageHandler::ClosePanel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenProfilePickerAndClosePanel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0b4330bf;  // IPCStableHash for glic::mojom::PageHandler::OpenProfilePickerAndClosePanel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenDisabledByAdminLinkAndClosePanel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x08b5eccd;  // IPCStableHash for glic::mojom::PageHandler::OpenDisabledByAdminLinkAndClosePanel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SignInAndClosePanel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb3dba5d3;  // IPCStableHash for glic::mojom::PageHandler::SignInAndClosePanel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ResizeWidget_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf0d016d6;  // IPCStableHash for glic::mojom::PageHandler::ResizeWidget
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::EnableDragResize_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x90845c5a;  // IPCStableHash for glic::mojom::PageHandler::EnableDragResize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::WebUiStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7c35699d;  // IPCStableHash for glic::mojom::PageHandler::WebUiStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_PrepareForClient_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_PrepareForClient_ForwardToCallback(
      PageHandler::PrepareForClientCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_PrepareForClient_ForwardToCallback(const PageHandler_PrepareForClient_ForwardToCallback&) = delete;
  PageHandler_PrepareForClient_ForwardToCallback& operator=(const PageHandler_PrepareForClient_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::PrepareForClientCallback callback_;
};

class PageHandler_ClosePanel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_ClosePanel_ForwardToCallback(
      PageHandler::ClosePanelCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_ClosePanel_ForwardToCallback(const PageHandler_ClosePanel_ForwardToCallback&) = delete;
  PageHandler_ClosePanel_ForwardToCallback& operator=(const PageHandler_ClosePanel_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::ClosePanelCallback callback_;
};

class PageHandler_ResizeWidget_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_ResizeWidget_ForwardToCallback(
      PageHandler::ResizeWidgetCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_ResizeWidget_ForwardToCallback(const PageHandler_ResizeWidget_ForwardToCallback&) = delete;
  PageHandler_ResizeWidget_ForwardToCallback& operator=(const PageHandler_ResizeWidget_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::ResizeWidgetCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::CreateWebClient(
    ::mojo::PendingReceiver<WebClientHandler> in_web_client_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::PageHandler::CreateWebClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("web_client_receiver"), in_web_client_receiver,
                        "<value of type ::mojo::PendingReceiver<WebClientHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kCreateWebClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::PageHandler_CreateWebClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::glic::mojom::WebClientHandlerInterfaceBase>>(
    in_web_client_receiver,
    &params->web_client_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->web_client_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid web_client_receiver in PageHandler.CreateWebClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("CreateWebClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::PrepareForClient(
    PrepareForClientCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::PageHandler::PrepareForClient");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kPrepareForClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::PageHandler_PrepareForClient_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("PrepareForClient");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_PrepareForClient_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::WebviewCommitted(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::PageHandler::WebviewCommitted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kWebviewCommitted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::PageHandler_WebviewCommitted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PageHandler.WebviewCommitted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("WebviewCommitted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ClosePanel(
    ClosePanelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::PageHandler::ClosePanel");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kClosePanel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::PageHandler_ClosePanel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ClosePanel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_ClosePanel_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::OpenProfilePickerAndClosePanel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::PageHandler::OpenProfilePickerAndClosePanel");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenProfilePickerAndClosePanel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::PageHandler_OpenProfilePickerAndClosePanel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenProfilePickerAndClosePanel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OpenDisabledByAdminLinkAndClosePanel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::PageHandler::OpenDisabledByAdminLinkAndClosePanel");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenDisabledByAdminLinkAndClosePanel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::PageHandler_OpenDisabledByAdminLinkAndClosePanel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenDisabledByAdminLinkAndClosePanel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SignInAndClosePanel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::PageHandler::SignInAndClosePanel");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSignInAndClosePanel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::PageHandler_SignInAndClosePanel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SignInAndClosePanel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ResizeWidget(
    const ::gfx::Size& in_size, ::base::TimeDelta in_duration, ResizeWidgetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::PageHandler::ResizeWidget", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("duration"), in_duration,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kResizeWidget), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::PageHandler_ResizeWidget_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_size,
    size_fragment);

  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null size in PageHandler.ResizeWidget request");
  mojo::internal::MessageFragment<
      typename decltype(params->duration)::BaseType> duration_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_duration,
    duration_fragment);

  params->duration.Set(
      duration_fragment.is_null() ? nullptr : duration_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->duration.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null duration in PageHandler.ResizeWidget request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ResizeWidget");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_ResizeWidget_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::EnableDragResize(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::PageHandler::EnableDragResize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kEnableDragResize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::PageHandler_EnableDragResize_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("EnableDragResize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::WebUiStateChanged(
    WebUiState in_new_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::PageHandler::WebUiStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_state"), in_new_state,
                        "<value of type WebUiState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kWebUiStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::PageHandler_WebUiStateChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::glic::mojom::WebUiState>(
    in_new_state,
    &params->new_state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("WebUiStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PageHandler_PrepareForClient_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::PrepareForClientCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_PrepareForClient_ProxyToResponder> proxy(
        new PageHandler_PrepareForClient_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_PrepareForClient_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_PrepareForClient_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_PrepareForClient_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::PrepareForClientCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PrepareForClientResult in_result);
};

bool PageHandler_PrepareForClient_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_PrepareForClient_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_PrepareForClient_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.1
  bool success = true;
  PrepareForClientResult p_result{};
  PageHandler_PrepareForClient_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void PageHandler_PrepareForClient_ProxyToResponder::Run(
    PrepareForClientResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::PageHandler::PrepareForClient", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type PrepareForClientResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kPrepareForClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::PageHandler_PrepareForClient_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::glic::mojom::PrepareForClientResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("PrepareForClient");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_ClosePanel_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::ClosePanelCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_ClosePanel_ProxyToResponder> proxy(
        new PageHandler_ClosePanel_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_ClosePanel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_ClosePanel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_ClosePanel_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::ClosePanelCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PageHandler_ClosePanel_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_ClosePanel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_ClosePanel_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.3
  bool success = true;
  PageHandler_ClosePanel_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void PageHandler_ClosePanel_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply glic::mojom::PageHandler::ClosePanel");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kClosePanel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::PageHandler_ClosePanel_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ClosePanel");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_ResizeWidget_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::ResizeWidgetCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_ResizeWidget_ProxyToResponder> proxy(
        new PageHandler_ResizeWidget_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_ResizeWidget_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_ResizeWidget_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_ResizeWidget_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::ResizeWidgetCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PageHandler_ResizeWidget_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_ResizeWidget_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_ResizeWidget_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.7
  bool success = true;
  PageHandler_ResizeWidget_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void PageHandler_ResizeWidget_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply glic::mojom::PageHandler::ResizeWidget");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kResizeWidget), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::PageHandler_ResizeWidget_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ResizeWidget");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kCreateWebClient: {
      DCHECK(message->is_serialized());
      internal::PageHandler_CreateWebClient_Params_Data* params =
          reinterpret_cast<internal::PageHandler_CreateWebClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      ::mojo::PendingReceiver<WebClientHandler> p_web_client_receiver{};
      PageHandler_CreateWebClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_web_client_receiver =
            input_data_view.TakeWebClientReceiver<decltype(p_web_client_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWebClient(        
        std::move(p_web_client_receiver));
      return true;
    }
    case messages::PageHandler::kPrepareForClient: {
      break;
    }
    case messages::PageHandler::kWebviewCommitted: {
      DCHECK(message->is_serialized());
      internal::PageHandler_WebviewCommitted_Params_Data* params =
          reinterpret_cast<internal::PageHandler_WebviewCommitted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      ::GURL p_url{};
      PageHandler_WebviewCommitted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WebviewCommitted(        
        std::move(p_url));
      return true;
    }
    case messages::PageHandler::kClosePanel: {
      break;
    }
    case messages::PageHandler::kOpenProfilePickerAndClosePanel: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenProfilePickerAndClosePanel_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenProfilePickerAndClosePanel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      PageHandler_OpenProfilePickerAndClosePanel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenProfilePickerAndClosePanel(        );
      return true;
    }
    case messages::PageHandler::kOpenDisabledByAdminLinkAndClosePanel: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenDisabledByAdminLinkAndClosePanel_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenDisabledByAdminLinkAndClosePanel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.5
      bool success = true;
      PageHandler_OpenDisabledByAdminLinkAndClosePanel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenDisabledByAdminLinkAndClosePanel(        );
      return true;
    }
    case messages::PageHandler::kSignInAndClosePanel: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SignInAndClosePanel_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SignInAndClosePanel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.6
      bool success = true;
      PageHandler_SignInAndClosePanel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SignInAndClosePanel(        );
      return true;
    }
    case messages::PageHandler::kResizeWidget: {
      break;
    }
    case messages::PageHandler::kEnableDragResize: {
      DCHECK(message->is_serialized());
      internal::PageHandler_EnableDragResize_Params_Data* params =
          reinterpret_cast<internal::PageHandler_EnableDragResize_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.8
      bool success = true;
      bool p_enabled{};
      PageHandler_EnableDragResize_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableDragResize(        
        std::move(p_enabled));
      return true;
    }
    case messages::PageHandler::kWebUiStateChanged: {
      DCHECK(message->is_serialized());
      internal::PageHandler_WebUiStateChanged_Params_Data* params =
          reinterpret_cast<internal::PageHandler_WebUiStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.9
      bool success = true;
      WebUiState p_new_state{};
      PageHandler_WebUiStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNewState(&p_new_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WebUiStateChanged(        
        std::move(p_new_state));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kCreateWebClient: {
      break;
    }
    case messages::PageHandler::kPrepareForClient: {
      internal::PageHandler_PrepareForClient_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_PrepareForClient_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      PageHandler_PrepareForClient_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          PageHandler_PrepareForClient_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrepareForClient(std::move(callback));
      return true;
    }
    case messages::PageHandler::kWebviewCommitted: {
      break;
    }
    case messages::PageHandler::kClosePanel: {
      internal::PageHandler_ClosePanel_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_ClosePanel_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      PageHandler_ClosePanel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          PageHandler_ClosePanel_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClosePanel(std::move(callback));
      return true;
    }
    case messages::PageHandler::kOpenProfilePickerAndClosePanel: {
      break;
    }
    case messages::PageHandler::kOpenDisabledByAdminLinkAndClosePanel: {
      break;
    }
    case messages::PageHandler::kSignInAndClosePanel: {
      break;
    }
    case messages::PageHandler::kResizeWidget: {
      internal::PageHandler_ResizeWidget_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_ResizeWidget_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.7
      bool success = true;
      ::gfx::Size p_size{};
      ::base::TimeDelta p_duration{};
      PageHandler_ResizeWidget_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (success && !input_data_view.ReadDuration(&p_duration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 7, false);
        return false;
      }
      auto callback =
          PageHandler_ResizeWidget_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResizeWidget(        
        std::move(p_size), 
        std::move(p_duration), std::move(callback));
      return true;
    }
    case messages::PageHandler::kEnableDragResize: {
      break;
    }
    case messages::PageHandler::kWebUiStateChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_CreateWebClient_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_PrepareForClient_Params_Data::Validate,
     &internal::PageHandler_PrepareForClient_ResponseParams_Data::Validate},
    { &internal::PageHandler_WebviewCommitted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ClosePanel_Params_Data::Validate,
     &internal::PageHandler_ClosePanel_ResponseParams_Data::Validate},
    { &internal::PageHandler_OpenProfilePickerAndClosePanel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OpenDisabledByAdminLinkAndClosePanel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SignInAndClosePanel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ResizeWidget_Params_Data::Validate,
     &internal::PageHandler_ResizeWidget_ResponseParams_Data::Validate},
    { &internal::PageHandler_EnableDragResize_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_WebUiStateChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::glic::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::glic::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

PinCandidatesObserver::IPCStableHashFunction PinCandidatesObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PinCandidatesObserver>(message.name())) {
    case messages::PinCandidatesObserver::kOnPinCandidatesChanged: {
      return &PinCandidatesObserver::OnPinCandidatesChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PinCandidatesObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PinCandidatesObserver>(message.name())) {
      case messages::PinCandidatesObserver::kOnPinCandidatesChanged:
            return "Receive glic::mojom::PinCandidatesObserver::OnPinCandidatesChanged";
    }
  } else {
    switch (static_cast<messages::PinCandidatesObserver>(message.name())) {
      case messages::PinCandidatesObserver::kOnPinCandidatesChanged:
            return "Receive reply glic::mojom::PinCandidatesObserver::OnPinCandidatesChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PinCandidatesObserver::OnPinCandidatesChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x66dd6fda;  // IPCStableHash for glic::mojom::PinCandidatesObserver::OnPinCandidatesChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PinCandidatesObserverProxy::PinCandidatesObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PinCandidatesObserverProxy::OnPinCandidatesChanged(
    std::vector<PinCandidatePtr> in_candidates) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::PinCandidatesObserver::OnPinCandidatesChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("candidates"), in_candidates,
                        "<value of type std::vector<PinCandidatePtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PinCandidatesObserver::kOnPinCandidatesChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::PinCandidatesObserver_OnPinCandidatesChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->candidates)::BaseType>
      candidates_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& candidates_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::glic::mojom::PinCandidateDataView>>(
    in_candidates,
    candidates_fragment,
    &candidates_validate_params);

  params->candidates.Set(
      candidates_fragment.is_null() ? nullptr : candidates_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->candidates.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null candidates in PinCandidatesObserver.OnPinCandidatesChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PinCandidatesObserver::Name_);
  message.set_method_name("OnPinCandidatesChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PinCandidatesObserverStubDispatch::Accept(
    PinCandidatesObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PinCandidatesObserver>(message->header()->name)) {
    case messages::PinCandidatesObserver::kOnPinCandidatesChanged: {
      DCHECK(message->is_serialized());
      internal::PinCandidatesObserver_OnPinCandidatesChanged_Params_Data* params =
          reinterpret_cast<internal::PinCandidatesObserver_OnPinCandidatesChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PinCandidatesObserver.0
      bool success = true;
      std::vector<PinCandidatePtr> p_candidates{};
      PinCandidatesObserver_OnPinCandidatesChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCandidates(&p_candidates))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PinCandidatesObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPinCandidatesChanged(        
        std::move(p_candidates));
      return true;
    }
  }
  return false;
}

// static
bool PinCandidatesObserverStubDispatch::AcceptWithResponder(
    PinCandidatesObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PinCandidatesObserver>(message->header()->name)) {
    case messages::PinCandidatesObserver::kOnPinCandidatesChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPinCandidatesObserverValidationInfo[] = {
    { &internal::PinCandidatesObserver_OnPinCandidatesChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool PinCandidatesObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::glic::mojom::PinCandidatesObserver::Name_,
    kPinCandidatesObserverValidationInfo);
}

// The declaration includes the definition on other builds.

WebClientHandler::IPCStableHashFunction WebClientHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebClientHandler>(message.name())) {
    case messages::WebClientHandler::kWebClientCreated: {
      return &WebClientHandler::WebClientCreated_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kWebClientInitialized: {
      return &WebClientHandler::WebClientInitialized_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kWebClientInitializeFailed: {
      return &WebClientHandler::WebClientInitializeFailed_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kCreateTab: {
      return &WebClientHandler::CreateTab_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kOpenGlicSettingsPage: {
      return &WebClientHandler::OpenGlicSettingsPage_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kClosePanel: {
      return &WebClientHandler::ClosePanel_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kClosePanelAndShutdown: {
      return &WebClientHandler::ClosePanelAndShutdown_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kAttachPanel: {
      return &WebClientHandler::AttachPanel_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kDetachPanel: {
      return &WebClientHandler::DetachPanel_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kShowProfilePicker: {
      return &WebClientHandler::ShowProfilePicker_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kGetModelQualityClientId: {
      return &WebClientHandler::GetModelQualityClientId_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kGetContextFromFocusedTab: {
      return &WebClientHandler::GetContextFromFocusedTab_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kGetContextFromTab: {
      return &WebClientHandler::GetContextFromTab_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kGetContextForActorFromTab: {
      return &WebClientHandler::GetContextForActorFromTab_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kSetMaximumNumberOfPinnedTabs: {
      return &WebClientHandler::SetMaximumNumberOfPinnedTabs_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kPinTabs: {
      return &WebClientHandler::PinTabs_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kUnpinTabs: {
      return &WebClientHandler::UnpinTabs_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kUnpinAllTabs: {
      return &WebClientHandler::UnpinAllTabs_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kSubscribeToPinCandidates: {
      return &WebClientHandler::SubscribeToPinCandidates_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kCreateTask: {
      return &WebClientHandler::CreateTask_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kPerformActions: {
      return &WebClientHandler::PerformActions_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kStopActorTask: {
      return &WebClientHandler::StopActorTask_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kPauseActorTask: {
      return &WebClientHandler::PauseActorTask_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kResumeActorTask: {
      return &WebClientHandler::ResumeActorTask_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kResizeWidget: {
      return &WebClientHandler::ResizeWidget_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kCaptureScreenshot: {
      return &WebClientHandler::CaptureScreenshot_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kSetAudioDucking: {
      return &WebClientHandler::SetAudioDucking_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kSetPanelDraggableAreas: {
      return &WebClientHandler::SetPanelDraggableAreas_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kSetMinimumPanelSize: {
      return &WebClientHandler::SetMinimumPanelSize_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kSetMicrophonePermissionState: {
      return &WebClientHandler::SetMicrophonePermissionState_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kSetLocationPermissionState: {
      return &WebClientHandler::SetLocationPermissionState_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kSetTabContextPermissionState: {
      return &WebClientHandler::SetTabContextPermissionState_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kSetClosedCaptioningSetting: {
      return &WebClientHandler::SetClosedCaptioningSetting_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kShouldAllowMediaPermissionRequest: {
      return &WebClientHandler::ShouldAllowMediaPermissionRequest_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kShouldAllowGeolocationPermissionRequest: {
      return &WebClientHandler::ShouldAllowGeolocationPermissionRequest_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kSetContextAccessIndicator: {
      return &WebClientHandler::SetContextAccessIndicator_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kGetUserProfileInfo: {
      return &WebClientHandler::GetUserProfileInfo_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kSyncCookies: {
      return &WebClientHandler::SyncCookies_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kLogBeginAsyncEvent: {
      return &WebClientHandler::LogBeginAsyncEvent_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kLogEndAsyncEvent: {
      return &WebClientHandler::LogEndAsyncEvent_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kLogInstantEvent: {
      return &WebClientHandler::LogInstantEvent_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kJournalClear: {
      return &WebClientHandler::JournalClear_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kJournalSnapshot: {
      return &WebClientHandler::JournalSnapshot_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kJournalStart: {
      return &WebClientHandler::JournalStart_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kJournalStop: {
      return &WebClientHandler::JournalStop_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kJournalRecordFeedback: {
      return &WebClientHandler::JournalRecordFeedback_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kOnUserInputSubmitted: {
      return &WebClientHandler::OnUserInputSubmitted_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kOnContextUploadStarted: {
      return &WebClientHandler::OnContextUploadStarted_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kOnContextUploadCompleted: {
      return &WebClientHandler::OnContextUploadCompleted_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kOnReaction: {
      return &WebClientHandler::OnReaction_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kOnResponseStarted: {
      return &WebClientHandler::OnResponseStarted_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kOnResponseStopped: {
      return &WebClientHandler::OnResponseStopped_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kOnSessionTerminated: {
      return &WebClientHandler::OnSessionTerminated_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kOnTurnCompleted: {
      return &WebClientHandler::OnTurnCompleted_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kOnModelChanged: {
      return &WebClientHandler::OnModelChanged_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kOnResponseRated: {
      return &WebClientHandler::OnResponseRated_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kOnClosedCaptionsShown: {
      return &WebClientHandler::OnClosedCaptionsShown_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kScrollTo: {
      return &WebClientHandler::ScrollTo_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kDropScrollToHighlight: {
      return &WebClientHandler::DropScrollToHighlight_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kSetSyntheticExperimentState: {
      return &WebClientHandler::SetSyntheticExperimentState_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kOpenOsPermissionSettingsMenu: {
      return &WebClientHandler::OpenOsPermissionSettingsMenu_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kGetOsMicrophonePermissionStatus: {
      return &WebClientHandler::GetOsMicrophonePermissionStatus_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kGetZeroStateSuggestionsAndSubscribe: {
      return &WebClientHandler::GetZeroStateSuggestionsAndSubscribe_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kGetZeroStateSuggestionsForFocusedTab: {
      return &WebClientHandler::GetZeroStateSuggestionsForFocusedTab_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kMaybeRefreshUserStatus: {
      return &WebClientHandler::MaybeRefreshUserStatus_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kIsDebuggerAttached: {
      return &WebClientHandler::IsDebuggerAttached_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kOnViewChanged: {
      return &WebClientHandler::OnViewChanged_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kSubscribeToPageMetadata: {
      return &WebClientHandler::SubscribeToPageMetadata_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kSwitchConversation: {
      return &WebClientHandler::SwitchConversation_Sym::IPCStableHash;
    }
    case messages::WebClientHandler::kRegisterConversation: {
      return &WebClientHandler::RegisterConversation_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebClientHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebClientHandler>(message.name())) {
      case messages::WebClientHandler::kWebClientCreated:
            return "Receive glic::mojom::WebClientHandler::WebClientCreated";
      case messages::WebClientHandler::kWebClientInitialized:
            return "Receive glic::mojom::WebClientHandler::WebClientInitialized";
      case messages::WebClientHandler::kWebClientInitializeFailed:
            return "Receive glic::mojom::WebClientHandler::WebClientInitializeFailed";
      case messages::WebClientHandler::kCreateTab:
            return "Receive glic::mojom::WebClientHandler::CreateTab";
      case messages::WebClientHandler::kOpenGlicSettingsPage:
            return "Receive glic::mojom::WebClientHandler::OpenGlicSettingsPage";
      case messages::WebClientHandler::kClosePanel:
            return "Receive glic::mojom::WebClientHandler::ClosePanel";
      case messages::WebClientHandler::kClosePanelAndShutdown:
            return "Receive glic::mojom::WebClientHandler::ClosePanelAndShutdown";
      case messages::WebClientHandler::kAttachPanel:
            return "Receive glic::mojom::WebClientHandler::AttachPanel";
      case messages::WebClientHandler::kDetachPanel:
            return "Receive glic::mojom::WebClientHandler::DetachPanel";
      case messages::WebClientHandler::kShowProfilePicker:
            return "Receive glic::mojom::WebClientHandler::ShowProfilePicker";
      case messages::WebClientHandler::kGetModelQualityClientId:
            return "Receive glic::mojom::WebClientHandler::GetModelQualityClientId";
      case messages::WebClientHandler::kGetContextFromFocusedTab:
            return "Receive glic::mojom::WebClientHandler::GetContextFromFocusedTab";
      case messages::WebClientHandler::kGetContextFromTab:
            return "Receive glic::mojom::WebClientHandler::GetContextFromTab";
      case messages::WebClientHandler::kGetContextForActorFromTab:
            return "Receive glic::mojom::WebClientHandler::GetContextForActorFromTab";
      case messages::WebClientHandler::kSetMaximumNumberOfPinnedTabs:
            return "Receive glic::mojom::WebClientHandler::SetMaximumNumberOfPinnedTabs";
      case messages::WebClientHandler::kPinTabs:
            return "Receive glic::mojom::WebClientHandler::PinTabs";
      case messages::WebClientHandler::kUnpinTabs:
            return "Receive glic::mojom::WebClientHandler::UnpinTabs";
      case messages::WebClientHandler::kUnpinAllTabs:
            return "Receive glic::mojom::WebClientHandler::UnpinAllTabs";
      case messages::WebClientHandler::kSubscribeToPinCandidates:
            return "Receive glic::mojom::WebClientHandler::SubscribeToPinCandidates";
      case messages::WebClientHandler::kCreateTask:
            return "Receive glic::mojom::WebClientHandler::CreateTask";
      case messages::WebClientHandler::kPerformActions:
            return "Receive glic::mojom::WebClientHandler::PerformActions";
      case messages::WebClientHandler::kStopActorTask:
            return "Receive glic::mojom::WebClientHandler::StopActorTask";
      case messages::WebClientHandler::kPauseActorTask:
            return "Receive glic::mojom::WebClientHandler::PauseActorTask";
      case messages::WebClientHandler::kResumeActorTask:
            return "Receive glic::mojom::WebClientHandler::ResumeActorTask";
      case messages::WebClientHandler::kResizeWidget:
            return "Receive glic::mojom::WebClientHandler::ResizeWidget";
      case messages::WebClientHandler::kCaptureScreenshot:
            return "Receive glic::mojom::WebClientHandler::CaptureScreenshot";
      case messages::WebClientHandler::kSetAudioDucking:
            return "Receive glic::mojom::WebClientHandler::SetAudioDucking";
      case messages::WebClientHandler::kSetPanelDraggableAreas:
            return "Receive glic::mojom::WebClientHandler::SetPanelDraggableAreas";
      case messages::WebClientHandler::kSetMinimumPanelSize:
            return "Receive glic::mojom::WebClientHandler::SetMinimumPanelSize";
      case messages::WebClientHandler::kSetMicrophonePermissionState:
            return "Receive glic::mojom::WebClientHandler::SetMicrophonePermissionState";
      case messages::WebClientHandler::kSetLocationPermissionState:
            return "Receive glic::mojom::WebClientHandler::SetLocationPermissionState";
      case messages::WebClientHandler::kSetTabContextPermissionState:
            return "Receive glic::mojom::WebClientHandler::SetTabContextPermissionState";
      case messages::WebClientHandler::kSetClosedCaptioningSetting:
            return "Receive glic::mojom::WebClientHandler::SetClosedCaptioningSetting";
      case messages::WebClientHandler::kShouldAllowMediaPermissionRequest:
            return "Receive glic::mojom::WebClientHandler::ShouldAllowMediaPermissionRequest";
      case messages::WebClientHandler::kShouldAllowGeolocationPermissionRequest:
            return "Receive glic::mojom::WebClientHandler::ShouldAllowGeolocationPermissionRequest";
      case messages::WebClientHandler::kSetContextAccessIndicator:
            return "Receive glic::mojom::WebClientHandler::SetContextAccessIndicator";
      case messages::WebClientHandler::kGetUserProfileInfo:
            return "Receive glic::mojom::WebClientHandler::GetUserProfileInfo";
      case messages::WebClientHandler::kSyncCookies:
            return "Receive glic::mojom::WebClientHandler::SyncCookies";
      case messages::WebClientHandler::kLogBeginAsyncEvent:
            return "Receive glic::mojom::WebClientHandler::LogBeginAsyncEvent";
      case messages::WebClientHandler::kLogEndAsyncEvent:
            return "Receive glic::mojom::WebClientHandler::LogEndAsyncEvent";
      case messages::WebClientHandler::kLogInstantEvent:
            return "Receive glic::mojom::WebClientHandler::LogInstantEvent";
      case messages::WebClientHandler::kJournalClear:
            return "Receive glic::mojom::WebClientHandler::JournalClear";
      case messages::WebClientHandler::kJournalSnapshot:
            return "Receive glic::mojom::WebClientHandler::JournalSnapshot";
      case messages::WebClientHandler::kJournalStart:
            return "Receive glic::mojom::WebClientHandler::JournalStart";
      case messages::WebClientHandler::kJournalStop:
            return "Receive glic::mojom::WebClientHandler::JournalStop";
      case messages::WebClientHandler::kJournalRecordFeedback:
            return "Receive glic::mojom::WebClientHandler::JournalRecordFeedback";
      case messages::WebClientHandler::kOnUserInputSubmitted:
            return "Receive glic::mojom::WebClientHandler::OnUserInputSubmitted";
      case messages::WebClientHandler::kOnContextUploadStarted:
            return "Receive glic::mojom::WebClientHandler::OnContextUploadStarted";
      case messages::WebClientHandler::kOnContextUploadCompleted:
            return "Receive glic::mojom::WebClientHandler::OnContextUploadCompleted";
      case messages::WebClientHandler::kOnReaction:
            return "Receive glic::mojom::WebClientHandler::OnReaction";
      case messages::WebClientHandler::kOnResponseStarted:
            return "Receive glic::mojom::WebClientHandler::OnResponseStarted";
      case messages::WebClientHandler::kOnResponseStopped:
            return "Receive glic::mojom::WebClientHandler::OnResponseStopped";
      case messages::WebClientHandler::kOnSessionTerminated:
            return "Receive glic::mojom::WebClientHandler::OnSessionTerminated";
      case messages::WebClientHandler::kOnTurnCompleted:
            return "Receive glic::mojom::WebClientHandler::OnTurnCompleted";
      case messages::WebClientHandler::kOnModelChanged:
            return "Receive glic::mojom::WebClientHandler::OnModelChanged";
      case messages::WebClientHandler::kOnResponseRated:
            return "Receive glic::mojom::WebClientHandler::OnResponseRated";
      case messages::WebClientHandler::kOnClosedCaptionsShown:
            return "Receive glic::mojom::WebClientHandler::OnClosedCaptionsShown";
      case messages::WebClientHandler::kScrollTo:
            return "Receive glic::mojom::WebClientHandler::ScrollTo";
      case messages::WebClientHandler::kDropScrollToHighlight:
            return "Receive glic::mojom::WebClientHandler::DropScrollToHighlight";
      case messages::WebClientHandler::kSetSyntheticExperimentState:
            return "Receive glic::mojom::WebClientHandler::SetSyntheticExperimentState";
      case messages::WebClientHandler::kOpenOsPermissionSettingsMenu:
            return "Receive glic::mojom::WebClientHandler::OpenOsPermissionSettingsMenu";
      case messages::WebClientHandler::kGetOsMicrophonePermissionStatus:
            return "Receive glic::mojom::WebClientHandler::GetOsMicrophonePermissionStatus";
      case messages::WebClientHandler::kGetZeroStateSuggestionsAndSubscribe:
            return "Receive glic::mojom::WebClientHandler::GetZeroStateSuggestionsAndSubscribe";
      case messages::WebClientHandler::kGetZeroStateSuggestionsForFocusedTab:
            return "Receive glic::mojom::WebClientHandler::GetZeroStateSuggestionsForFocusedTab";
      case messages::WebClientHandler::kMaybeRefreshUserStatus:
            return "Receive glic::mojom::WebClientHandler::MaybeRefreshUserStatus";
      case messages::WebClientHandler::kIsDebuggerAttached:
            return "Receive glic::mojom::WebClientHandler::IsDebuggerAttached";
      case messages::WebClientHandler::kOnViewChanged:
            return "Receive glic::mojom::WebClientHandler::OnViewChanged";
      case messages::WebClientHandler::kSubscribeToPageMetadata:
            return "Receive glic::mojom::WebClientHandler::SubscribeToPageMetadata";
      case messages::WebClientHandler::kSwitchConversation:
            return "Receive glic::mojom::WebClientHandler::SwitchConversation";
      case messages::WebClientHandler::kRegisterConversation:
            return "Receive glic::mojom::WebClientHandler::RegisterConversation";
    }
  } else {
    switch (static_cast<messages::WebClientHandler>(message.name())) {
      case messages::WebClientHandler::kWebClientCreated:
            return "Receive reply glic::mojom::WebClientHandler::WebClientCreated";
      case messages::WebClientHandler::kWebClientInitialized:
            return "Receive reply glic::mojom::WebClientHandler::WebClientInitialized";
      case messages::WebClientHandler::kWebClientInitializeFailed:
            return "Receive reply glic::mojom::WebClientHandler::WebClientInitializeFailed";
      case messages::WebClientHandler::kCreateTab:
            return "Receive reply glic::mojom::WebClientHandler::CreateTab";
      case messages::WebClientHandler::kOpenGlicSettingsPage:
            return "Receive reply glic::mojom::WebClientHandler::OpenGlicSettingsPage";
      case messages::WebClientHandler::kClosePanel:
            return "Receive reply glic::mojom::WebClientHandler::ClosePanel";
      case messages::WebClientHandler::kClosePanelAndShutdown:
            return "Receive reply glic::mojom::WebClientHandler::ClosePanelAndShutdown";
      case messages::WebClientHandler::kAttachPanel:
            return "Receive reply glic::mojom::WebClientHandler::AttachPanel";
      case messages::WebClientHandler::kDetachPanel:
            return "Receive reply glic::mojom::WebClientHandler::DetachPanel";
      case messages::WebClientHandler::kShowProfilePicker:
            return "Receive reply glic::mojom::WebClientHandler::ShowProfilePicker";
      case messages::WebClientHandler::kGetModelQualityClientId:
            return "Receive reply glic::mojom::WebClientHandler::GetModelQualityClientId";
      case messages::WebClientHandler::kGetContextFromFocusedTab:
            return "Receive reply glic::mojom::WebClientHandler::GetContextFromFocusedTab";
      case messages::WebClientHandler::kGetContextFromTab:
            return "Receive reply glic::mojom::WebClientHandler::GetContextFromTab";
      case messages::WebClientHandler::kGetContextForActorFromTab:
            return "Receive reply glic::mojom::WebClientHandler::GetContextForActorFromTab";
      case messages::WebClientHandler::kSetMaximumNumberOfPinnedTabs:
            return "Receive reply glic::mojom::WebClientHandler::SetMaximumNumberOfPinnedTabs";
      case messages::WebClientHandler::kPinTabs:
            return "Receive reply glic::mojom::WebClientHandler::PinTabs";
      case messages::WebClientHandler::kUnpinTabs:
            return "Receive reply glic::mojom::WebClientHandler::UnpinTabs";
      case messages::WebClientHandler::kUnpinAllTabs:
            return "Receive reply glic::mojom::WebClientHandler::UnpinAllTabs";
      case messages::WebClientHandler::kSubscribeToPinCandidates:
            return "Receive reply glic::mojom::WebClientHandler::SubscribeToPinCandidates";
      case messages::WebClientHandler::kCreateTask:
            return "Receive reply glic::mojom::WebClientHandler::CreateTask";
      case messages::WebClientHandler::kPerformActions:
            return "Receive reply glic::mojom::WebClientHandler::PerformActions";
      case messages::WebClientHandler::kStopActorTask:
            return "Receive reply glic::mojom::WebClientHandler::StopActorTask";
      case messages::WebClientHandler::kPauseActorTask:
            return "Receive reply glic::mojom::WebClientHandler::PauseActorTask";
      case messages::WebClientHandler::kResumeActorTask:
            return "Receive reply glic::mojom::WebClientHandler::ResumeActorTask";
      case messages::WebClientHandler::kResizeWidget:
            return "Receive reply glic::mojom::WebClientHandler::ResizeWidget";
      case messages::WebClientHandler::kCaptureScreenshot:
            return "Receive reply glic::mojom::WebClientHandler::CaptureScreenshot";
      case messages::WebClientHandler::kSetAudioDucking:
            return "Receive reply glic::mojom::WebClientHandler::SetAudioDucking";
      case messages::WebClientHandler::kSetPanelDraggableAreas:
            return "Receive reply glic::mojom::WebClientHandler::SetPanelDraggableAreas";
      case messages::WebClientHandler::kSetMinimumPanelSize:
            return "Receive reply glic::mojom::WebClientHandler::SetMinimumPanelSize";
      case messages::WebClientHandler::kSetMicrophonePermissionState:
            return "Receive reply glic::mojom::WebClientHandler::SetMicrophonePermissionState";
      case messages::WebClientHandler::kSetLocationPermissionState:
            return "Receive reply glic::mojom::WebClientHandler::SetLocationPermissionState";
      case messages::WebClientHandler::kSetTabContextPermissionState:
            return "Receive reply glic::mojom::WebClientHandler::SetTabContextPermissionState";
      case messages::WebClientHandler::kSetClosedCaptioningSetting:
            return "Receive reply glic::mojom::WebClientHandler::SetClosedCaptioningSetting";
      case messages::WebClientHandler::kShouldAllowMediaPermissionRequest:
            return "Receive reply glic::mojom::WebClientHandler::ShouldAllowMediaPermissionRequest";
      case messages::WebClientHandler::kShouldAllowGeolocationPermissionRequest:
            return "Receive reply glic::mojom::WebClientHandler::ShouldAllowGeolocationPermissionRequest";
      case messages::WebClientHandler::kSetContextAccessIndicator:
            return "Receive reply glic::mojom::WebClientHandler::SetContextAccessIndicator";
      case messages::WebClientHandler::kGetUserProfileInfo:
            return "Receive reply glic::mojom::WebClientHandler::GetUserProfileInfo";
      case messages::WebClientHandler::kSyncCookies:
            return "Receive reply glic::mojom::WebClientHandler::SyncCookies";
      case messages::WebClientHandler::kLogBeginAsyncEvent:
            return "Receive reply glic::mojom::WebClientHandler::LogBeginAsyncEvent";
      case messages::WebClientHandler::kLogEndAsyncEvent:
            return "Receive reply glic::mojom::WebClientHandler::LogEndAsyncEvent";
      case messages::WebClientHandler::kLogInstantEvent:
            return "Receive reply glic::mojom::WebClientHandler::LogInstantEvent";
      case messages::WebClientHandler::kJournalClear:
            return "Receive reply glic::mojom::WebClientHandler::JournalClear";
      case messages::WebClientHandler::kJournalSnapshot:
            return "Receive reply glic::mojom::WebClientHandler::JournalSnapshot";
      case messages::WebClientHandler::kJournalStart:
            return "Receive reply glic::mojom::WebClientHandler::JournalStart";
      case messages::WebClientHandler::kJournalStop:
            return "Receive reply glic::mojom::WebClientHandler::JournalStop";
      case messages::WebClientHandler::kJournalRecordFeedback:
            return "Receive reply glic::mojom::WebClientHandler::JournalRecordFeedback";
      case messages::WebClientHandler::kOnUserInputSubmitted:
            return "Receive reply glic::mojom::WebClientHandler::OnUserInputSubmitted";
      case messages::WebClientHandler::kOnContextUploadStarted:
            return "Receive reply glic::mojom::WebClientHandler::OnContextUploadStarted";
      case messages::WebClientHandler::kOnContextUploadCompleted:
            return "Receive reply glic::mojom::WebClientHandler::OnContextUploadCompleted";
      case messages::WebClientHandler::kOnReaction:
            return "Receive reply glic::mojom::WebClientHandler::OnReaction";
      case messages::WebClientHandler::kOnResponseStarted:
            return "Receive reply glic::mojom::WebClientHandler::OnResponseStarted";
      case messages::WebClientHandler::kOnResponseStopped:
            return "Receive reply glic::mojom::WebClientHandler::OnResponseStopped";
      case messages::WebClientHandler::kOnSessionTerminated:
            return "Receive reply glic::mojom::WebClientHandler::OnSessionTerminated";
      case messages::WebClientHandler::kOnTurnCompleted:
            return "Receive reply glic::mojom::WebClientHandler::OnTurnCompleted";
      case messages::WebClientHandler::kOnModelChanged:
            return "Receive reply glic::mojom::WebClientHandler::OnModelChanged";
      case messages::WebClientHandler::kOnResponseRated:
            return "Receive reply glic::mojom::WebClientHandler::OnResponseRated";
      case messages::WebClientHandler::kOnClosedCaptionsShown:
            return "Receive reply glic::mojom::WebClientHandler::OnClosedCaptionsShown";
      case messages::WebClientHandler::kScrollTo:
            return "Receive reply glic::mojom::WebClientHandler::ScrollTo";
      case messages::WebClientHandler::kDropScrollToHighlight:
            return "Receive reply glic::mojom::WebClientHandler::DropScrollToHighlight";
      case messages::WebClientHandler::kSetSyntheticExperimentState:
            return "Receive reply glic::mojom::WebClientHandler::SetSyntheticExperimentState";
      case messages::WebClientHandler::kOpenOsPermissionSettingsMenu:
            return "Receive reply glic::mojom::WebClientHandler::OpenOsPermissionSettingsMenu";
      case messages::WebClientHandler::kGetOsMicrophonePermissionStatus:
            return "Receive reply glic::mojom::WebClientHandler::GetOsMicrophonePermissionStatus";
      case messages::WebClientHandler::kGetZeroStateSuggestionsAndSubscribe:
            return "Receive reply glic::mojom::WebClientHandler::GetZeroStateSuggestionsAndSubscribe";
      case messages::WebClientHandler::kGetZeroStateSuggestionsForFocusedTab:
            return "Receive reply glic::mojom::WebClientHandler::GetZeroStateSuggestionsForFocusedTab";
      case messages::WebClientHandler::kMaybeRefreshUserStatus:
            return "Receive reply glic::mojom::WebClientHandler::MaybeRefreshUserStatus";
      case messages::WebClientHandler::kIsDebuggerAttached:
            return "Receive reply glic::mojom::WebClientHandler::IsDebuggerAttached";
      case messages::WebClientHandler::kOnViewChanged:
            return "Receive reply glic::mojom::WebClientHandler::OnViewChanged";
      case messages::WebClientHandler::kSubscribeToPageMetadata:
            return "Receive reply glic::mojom::WebClientHandler::SubscribeToPageMetadata";
      case messages::WebClientHandler::kSwitchConversation:
            return "Receive reply glic::mojom::WebClientHandler::SwitchConversation";
      case messages::WebClientHandler::kRegisterConversation:
            return "Receive reply glic::mojom::WebClientHandler::RegisterConversation";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebClientHandler::WebClientCreated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5577db8b;  // IPCStableHash for glic::mojom::WebClientHandler::WebClientCreated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::WebClientInitialized_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdf1de908;  // IPCStableHash for glic::mojom::WebClientHandler::WebClientInitialized
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::WebClientInitializeFailed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc8ca96a3;  // IPCStableHash for glic::mojom::WebClientHandler::WebClientInitializeFailed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::CreateTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x076b050c;  // IPCStableHash for glic::mojom::WebClientHandler::CreateTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::OpenGlicSettingsPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x39a402e6;  // IPCStableHash for glic::mojom::WebClientHandler::OpenGlicSettingsPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::ClosePanel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0a28f614;  // IPCStableHash for glic::mojom::WebClientHandler::ClosePanel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::ClosePanelAndShutdown_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1522641a;  // IPCStableHash for glic::mojom::WebClientHandler::ClosePanelAndShutdown
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::AttachPanel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xadfbc7fd;  // IPCStableHash for glic::mojom::WebClientHandler::AttachPanel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::DetachPanel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x71aa5698;  // IPCStableHash for glic::mojom::WebClientHandler::DetachPanel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::ShowProfilePicker_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaec7f803;  // IPCStableHash for glic::mojom::WebClientHandler::ShowProfilePicker
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::GetModelQualityClientId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xded80892;  // IPCStableHash for glic::mojom::WebClientHandler::GetModelQualityClientId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::GetContextFromFocusedTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xac51b530;  // IPCStableHash for glic::mojom::WebClientHandler::GetContextFromFocusedTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::GetContextFromTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x48ef89d1;  // IPCStableHash for glic::mojom::WebClientHandler::GetContextFromTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::GetContextForActorFromTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbcd0ac02;  // IPCStableHash for glic::mojom::WebClientHandler::GetContextForActorFromTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::SetMaximumNumberOfPinnedTabs_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa607417e;  // IPCStableHash for glic::mojom::WebClientHandler::SetMaximumNumberOfPinnedTabs
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::PinTabs_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb6a9fabb;  // IPCStableHash for glic::mojom::WebClientHandler::PinTabs
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::UnpinTabs_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1255c451;  // IPCStableHash for glic::mojom::WebClientHandler::UnpinTabs
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::UnpinAllTabs_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x35530cf2;  // IPCStableHash for glic::mojom::WebClientHandler::UnpinAllTabs
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::SubscribeToPinCandidates_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x40392fcf;  // IPCStableHash for glic::mojom::WebClientHandler::SubscribeToPinCandidates
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::CreateTask_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x69f08a0a;  // IPCStableHash for glic::mojom::WebClientHandler::CreateTask
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::PerformActions_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x07a4d8aa;  // IPCStableHash for glic::mojom::WebClientHandler::PerformActions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::StopActorTask_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd7448b88;  // IPCStableHash for glic::mojom::WebClientHandler::StopActorTask
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::PauseActorTask_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7e2c4df1;  // IPCStableHash for glic::mojom::WebClientHandler::PauseActorTask
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::ResumeActorTask_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3f8d4fcb;  // IPCStableHash for glic::mojom::WebClientHandler::ResumeActorTask
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::ResizeWidget_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6b233a5a;  // IPCStableHash for glic::mojom::WebClientHandler::ResizeWidget
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::CaptureScreenshot_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5657ec2e;  // IPCStableHash for glic::mojom::WebClientHandler::CaptureScreenshot
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::SetAudioDucking_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x29e43b27;  // IPCStableHash for glic::mojom::WebClientHandler::SetAudioDucking
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::SetPanelDraggableAreas_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x615e6a23;  // IPCStableHash for glic::mojom::WebClientHandler::SetPanelDraggableAreas
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::SetMinimumPanelSize_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6662b0cd;  // IPCStableHash for glic::mojom::WebClientHandler::SetMinimumPanelSize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::SetMicrophonePermissionState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeacb4b69;  // IPCStableHash for glic::mojom::WebClientHandler::SetMicrophonePermissionState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::SetLocationPermissionState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd2dc2048;  // IPCStableHash for glic::mojom::WebClientHandler::SetLocationPermissionState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::SetTabContextPermissionState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdc9e749b;  // IPCStableHash for glic::mojom::WebClientHandler::SetTabContextPermissionState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::SetClosedCaptioningSetting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x592a66a5;  // IPCStableHash for glic::mojom::WebClientHandler::SetClosedCaptioningSetting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::ShouldAllowMediaPermissionRequest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0f5e2b61;  // IPCStableHash for glic::mojom::WebClientHandler::ShouldAllowMediaPermissionRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::ShouldAllowGeolocationPermissionRequest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf3e658e2;  // IPCStableHash for glic::mojom::WebClientHandler::ShouldAllowGeolocationPermissionRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::SetContextAccessIndicator_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf5954118;  // IPCStableHash for glic::mojom::WebClientHandler::SetContextAccessIndicator
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::GetUserProfileInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe14629dc;  // IPCStableHash for glic::mojom::WebClientHandler::GetUserProfileInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::SyncCookies_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa9b3d03a;  // IPCStableHash for glic::mojom::WebClientHandler::SyncCookies
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::LogBeginAsyncEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4d05bd9a;  // IPCStableHash for glic::mojom::WebClientHandler::LogBeginAsyncEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::LogEndAsyncEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x71476a98;  // IPCStableHash for glic::mojom::WebClientHandler::LogEndAsyncEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::LogInstantEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf44414b7;  // IPCStableHash for glic::mojom::WebClientHandler::LogInstantEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::JournalClear_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfec7b637;  // IPCStableHash for glic::mojom::WebClientHandler::JournalClear
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::JournalSnapshot_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe5253feb;  // IPCStableHash for glic::mojom::WebClientHandler::JournalSnapshot
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::JournalStart_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8eb640fb;  // IPCStableHash for glic::mojom::WebClientHandler::JournalStart
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::JournalStop_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcc3b3419;  // IPCStableHash for glic::mojom::WebClientHandler::JournalStop
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::JournalRecordFeedback_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x24476471;  // IPCStableHash for glic::mojom::WebClientHandler::JournalRecordFeedback
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::OnUserInputSubmitted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3822de54;  // IPCStableHash for glic::mojom::WebClientHandler::OnUserInputSubmitted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::OnContextUploadStarted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5a367bae;  // IPCStableHash for glic::mojom::WebClientHandler::OnContextUploadStarted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::OnContextUploadCompleted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf4db4b1d;  // IPCStableHash for glic::mojom::WebClientHandler::OnContextUploadCompleted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::OnReaction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x62b6e7e8;  // IPCStableHash for glic::mojom::WebClientHandler::OnReaction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::OnResponseStarted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xce56812f;  // IPCStableHash for glic::mojom::WebClientHandler::OnResponseStarted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::OnResponseStopped_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7ac31e8e;  // IPCStableHash for glic::mojom::WebClientHandler::OnResponseStopped
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::OnSessionTerminated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7342f9d7;  // IPCStableHash for glic::mojom::WebClientHandler::OnSessionTerminated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::OnTurnCompleted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x357eceb8;  // IPCStableHash for glic::mojom::WebClientHandler::OnTurnCompleted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::OnModelChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x357e136f;  // IPCStableHash for glic::mojom::WebClientHandler::OnModelChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::OnResponseRated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeaa89b64;  // IPCStableHash for glic::mojom::WebClientHandler::OnResponseRated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::OnClosedCaptionsShown_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4bc0ff9d;  // IPCStableHash for glic::mojom::WebClientHandler::OnClosedCaptionsShown
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::ScrollTo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x843554e9;  // IPCStableHash for glic::mojom::WebClientHandler::ScrollTo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::DropScrollToHighlight_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeb561d5e;  // IPCStableHash for glic::mojom::WebClientHandler::DropScrollToHighlight
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::SetSyntheticExperimentState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5d17a3d1;  // IPCStableHash for glic::mojom::WebClientHandler::SetSyntheticExperimentState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::OpenOsPermissionSettingsMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x35cf2b00;  // IPCStableHash for glic::mojom::WebClientHandler::OpenOsPermissionSettingsMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::GetOsMicrophonePermissionStatus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x76b7e8b8;  // IPCStableHash for glic::mojom::WebClientHandler::GetOsMicrophonePermissionStatus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::GetZeroStateSuggestionsAndSubscribe_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa928e83f;  // IPCStableHash for glic::mojom::WebClientHandler::GetZeroStateSuggestionsAndSubscribe
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::GetZeroStateSuggestionsForFocusedTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4f10d15e;  // IPCStableHash for glic::mojom::WebClientHandler::GetZeroStateSuggestionsForFocusedTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::MaybeRefreshUserStatus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf6eb9f3d;  // IPCStableHash for glic::mojom::WebClientHandler::MaybeRefreshUserStatus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::IsDebuggerAttached_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf73fad99;  // IPCStableHash for glic::mojom::WebClientHandler::IsDebuggerAttached
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::OnViewChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa2b53fa9;  // IPCStableHash for glic::mojom::WebClientHandler::OnViewChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::SubscribeToPageMetadata_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5f6df065;  // IPCStableHash for glic::mojom::WebClientHandler::SubscribeToPageMetadata
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::SwitchConversation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x141a6c86;  // IPCStableHash for glic::mojom::WebClientHandler::SwitchConversation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClientHandler::RegisterConversation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6f1492fa;  // IPCStableHash for glic::mojom::WebClientHandler::RegisterConversation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebClientHandler_WebClientCreated_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_WebClientCreated_ForwardToCallback(
      WebClientHandler::WebClientCreatedCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_WebClientCreated_ForwardToCallback(const WebClientHandler_WebClientCreated_ForwardToCallback&) = delete;
  WebClientHandler_WebClientCreated_ForwardToCallback& operator=(const WebClientHandler_WebClientCreated_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::WebClientCreatedCallback callback_;
};

class WebClientHandler_CreateTab_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_CreateTab_ForwardToCallback(
      WebClientHandler::CreateTabCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_CreateTab_ForwardToCallback(const WebClientHandler_CreateTab_ForwardToCallback&) = delete;
  WebClientHandler_CreateTab_ForwardToCallback& operator=(const WebClientHandler_CreateTab_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::CreateTabCallback callback_;
};

class WebClientHandler_GetModelQualityClientId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_GetModelQualityClientId_ForwardToCallback(
      WebClientHandler::GetModelQualityClientIdCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_GetModelQualityClientId_ForwardToCallback(const WebClientHandler_GetModelQualityClientId_ForwardToCallback&) = delete;
  WebClientHandler_GetModelQualityClientId_ForwardToCallback& operator=(const WebClientHandler_GetModelQualityClientId_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::GetModelQualityClientIdCallback callback_;
};

class WebClientHandler_GetContextFromFocusedTab_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_GetContextFromFocusedTab_ForwardToCallback(
      WebClientHandler::GetContextFromFocusedTabCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_GetContextFromFocusedTab_ForwardToCallback(const WebClientHandler_GetContextFromFocusedTab_ForwardToCallback&) = delete;
  WebClientHandler_GetContextFromFocusedTab_ForwardToCallback& operator=(const WebClientHandler_GetContextFromFocusedTab_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::GetContextFromFocusedTabCallback callback_;
};

class WebClientHandler_GetContextFromTab_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_GetContextFromTab_ForwardToCallback(
      WebClientHandler::GetContextFromTabCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_GetContextFromTab_ForwardToCallback(const WebClientHandler_GetContextFromTab_ForwardToCallback&) = delete;
  WebClientHandler_GetContextFromTab_ForwardToCallback& operator=(const WebClientHandler_GetContextFromTab_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::GetContextFromTabCallback callback_;
};

class WebClientHandler_GetContextForActorFromTab_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_GetContextForActorFromTab_ForwardToCallback(
      WebClientHandler::GetContextForActorFromTabCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_GetContextForActorFromTab_ForwardToCallback(const WebClientHandler_GetContextForActorFromTab_ForwardToCallback&) = delete;
  WebClientHandler_GetContextForActorFromTab_ForwardToCallback& operator=(const WebClientHandler_GetContextForActorFromTab_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::GetContextForActorFromTabCallback callback_;
};

class WebClientHandler_SetMaximumNumberOfPinnedTabs_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_SetMaximumNumberOfPinnedTabs_ForwardToCallback(
      WebClientHandler::SetMaximumNumberOfPinnedTabsCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_SetMaximumNumberOfPinnedTabs_ForwardToCallback(const WebClientHandler_SetMaximumNumberOfPinnedTabs_ForwardToCallback&) = delete;
  WebClientHandler_SetMaximumNumberOfPinnedTabs_ForwardToCallback& operator=(const WebClientHandler_SetMaximumNumberOfPinnedTabs_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::SetMaximumNumberOfPinnedTabsCallback callback_;
};

class WebClientHandler_PinTabs_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_PinTabs_ForwardToCallback(
      WebClientHandler::PinTabsCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_PinTabs_ForwardToCallback(const WebClientHandler_PinTabs_ForwardToCallback&) = delete;
  WebClientHandler_PinTabs_ForwardToCallback& operator=(const WebClientHandler_PinTabs_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::PinTabsCallback callback_;
};

class WebClientHandler_UnpinTabs_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_UnpinTabs_ForwardToCallback(
      WebClientHandler::UnpinTabsCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_UnpinTabs_ForwardToCallback(const WebClientHandler_UnpinTabs_ForwardToCallback&) = delete;
  WebClientHandler_UnpinTabs_ForwardToCallback& operator=(const WebClientHandler_UnpinTabs_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::UnpinTabsCallback callback_;
};

class WebClientHandler_CreateTask_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_CreateTask_ForwardToCallback(
      WebClientHandler::CreateTaskCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_CreateTask_ForwardToCallback(const WebClientHandler_CreateTask_ForwardToCallback&) = delete;
  WebClientHandler_CreateTask_ForwardToCallback& operator=(const WebClientHandler_CreateTask_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::CreateTaskCallback callback_;
};

class WebClientHandler_PerformActions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_PerformActions_ForwardToCallback(
      WebClientHandler::PerformActionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_PerformActions_ForwardToCallback(const WebClientHandler_PerformActions_ForwardToCallback&) = delete;
  WebClientHandler_PerformActions_ForwardToCallback& operator=(const WebClientHandler_PerformActions_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::PerformActionsCallback callback_;
};

class WebClientHandler_ResumeActorTask_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_ResumeActorTask_ForwardToCallback(
      WebClientHandler::ResumeActorTaskCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_ResumeActorTask_ForwardToCallback(const WebClientHandler_ResumeActorTask_ForwardToCallback&) = delete;
  WebClientHandler_ResumeActorTask_ForwardToCallback& operator=(const WebClientHandler_ResumeActorTask_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::ResumeActorTaskCallback callback_;
};

class WebClientHandler_ResizeWidget_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_ResizeWidget_ForwardToCallback(
      WebClientHandler::ResizeWidgetCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_ResizeWidget_ForwardToCallback(const WebClientHandler_ResizeWidget_ForwardToCallback&) = delete;
  WebClientHandler_ResizeWidget_ForwardToCallback& operator=(const WebClientHandler_ResizeWidget_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::ResizeWidgetCallback callback_;
};

class WebClientHandler_CaptureScreenshot_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_CaptureScreenshot_ForwardToCallback(
      WebClientHandler::CaptureScreenshotCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_CaptureScreenshot_ForwardToCallback(const WebClientHandler_CaptureScreenshot_ForwardToCallback&) = delete;
  WebClientHandler_CaptureScreenshot_ForwardToCallback& operator=(const WebClientHandler_CaptureScreenshot_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::CaptureScreenshotCallback callback_;
};

class WebClientHandler_SetAudioDucking_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_SetAudioDucking_ForwardToCallback(
      WebClientHandler::SetAudioDuckingCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_SetAudioDucking_ForwardToCallback(const WebClientHandler_SetAudioDucking_ForwardToCallback&) = delete;
  WebClientHandler_SetAudioDucking_ForwardToCallback& operator=(const WebClientHandler_SetAudioDucking_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::SetAudioDuckingCallback callback_;
};

class WebClientHandler_SetPanelDraggableAreas_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_SetPanelDraggableAreas_ForwardToCallback(
      WebClientHandler::SetPanelDraggableAreasCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_SetPanelDraggableAreas_ForwardToCallback(const WebClientHandler_SetPanelDraggableAreas_ForwardToCallback&) = delete;
  WebClientHandler_SetPanelDraggableAreas_ForwardToCallback& operator=(const WebClientHandler_SetPanelDraggableAreas_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::SetPanelDraggableAreasCallback callback_;
};

class WebClientHandler_SetMicrophonePermissionState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_SetMicrophonePermissionState_ForwardToCallback(
      WebClientHandler::SetMicrophonePermissionStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_SetMicrophonePermissionState_ForwardToCallback(const WebClientHandler_SetMicrophonePermissionState_ForwardToCallback&) = delete;
  WebClientHandler_SetMicrophonePermissionState_ForwardToCallback& operator=(const WebClientHandler_SetMicrophonePermissionState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::SetMicrophonePermissionStateCallback callback_;
};

class WebClientHandler_SetLocationPermissionState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_SetLocationPermissionState_ForwardToCallback(
      WebClientHandler::SetLocationPermissionStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_SetLocationPermissionState_ForwardToCallback(const WebClientHandler_SetLocationPermissionState_ForwardToCallback&) = delete;
  WebClientHandler_SetLocationPermissionState_ForwardToCallback& operator=(const WebClientHandler_SetLocationPermissionState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::SetLocationPermissionStateCallback callback_;
};

class WebClientHandler_SetTabContextPermissionState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_SetTabContextPermissionState_ForwardToCallback(
      WebClientHandler::SetTabContextPermissionStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_SetTabContextPermissionState_ForwardToCallback(const WebClientHandler_SetTabContextPermissionState_ForwardToCallback&) = delete;
  WebClientHandler_SetTabContextPermissionState_ForwardToCallback& operator=(const WebClientHandler_SetTabContextPermissionState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::SetTabContextPermissionStateCallback callback_;
};

class WebClientHandler_SetClosedCaptioningSetting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_SetClosedCaptioningSetting_ForwardToCallback(
      WebClientHandler::SetClosedCaptioningSettingCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_SetClosedCaptioningSetting_ForwardToCallback(const WebClientHandler_SetClosedCaptioningSetting_ForwardToCallback&) = delete;
  WebClientHandler_SetClosedCaptioningSetting_ForwardToCallback& operator=(const WebClientHandler_SetClosedCaptioningSetting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::SetClosedCaptioningSettingCallback callback_;
};

class WebClientHandler_ShouldAllowMediaPermissionRequest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_ShouldAllowMediaPermissionRequest_ForwardToCallback(
      WebClientHandler::ShouldAllowMediaPermissionRequestCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_ShouldAllowMediaPermissionRequest_ForwardToCallback(const WebClientHandler_ShouldAllowMediaPermissionRequest_ForwardToCallback&) = delete;
  WebClientHandler_ShouldAllowMediaPermissionRequest_ForwardToCallback& operator=(const WebClientHandler_ShouldAllowMediaPermissionRequest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::ShouldAllowMediaPermissionRequestCallback callback_;
};

class WebClientHandler_ShouldAllowGeolocationPermissionRequest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_ShouldAllowGeolocationPermissionRequest_ForwardToCallback(
      WebClientHandler::ShouldAllowGeolocationPermissionRequestCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_ShouldAllowGeolocationPermissionRequest_ForwardToCallback(const WebClientHandler_ShouldAllowGeolocationPermissionRequest_ForwardToCallback&) = delete;
  WebClientHandler_ShouldAllowGeolocationPermissionRequest_ForwardToCallback& operator=(const WebClientHandler_ShouldAllowGeolocationPermissionRequest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::ShouldAllowGeolocationPermissionRequestCallback callback_;
};

class WebClientHandler_GetUserProfileInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_GetUserProfileInfo_ForwardToCallback(
      WebClientHandler::GetUserProfileInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_GetUserProfileInfo_ForwardToCallback(const WebClientHandler_GetUserProfileInfo_ForwardToCallback&) = delete;
  WebClientHandler_GetUserProfileInfo_ForwardToCallback& operator=(const WebClientHandler_GetUserProfileInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::GetUserProfileInfoCallback callback_;
};

class WebClientHandler_SyncCookies_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_SyncCookies_ForwardToCallback(
      WebClientHandler::SyncCookiesCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_SyncCookies_ForwardToCallback(const WebClientHandler_SyncCookies_ForwardToCallback&) = delete;
  WebClientHandler_SyncCookies_ForwardToCallback& operator=(const WebClientHandler_SyncCookies_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::SyncCookiesCallback callback_;
};

class WebClientHandler_JournalSnapshot_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_JournalSnapshot_ForwardToCallback(
      WebClientHandler::JournalSnapshotCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_JournalSnapshot_ForwardToCallback(const WebClientHandler_JournalSnapshot_ForwardToCallback&) = delete;
  WebClientHandler_JournalSnapshot_ForwardToCallback& operator=(const WebClientHandler_JournalSnapshot_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::JournalSnapshotCallback callback_;
};

class WebClientHandler_ScrollTo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_ScrollTo_ForwardToCallback(
      WebClientHandler::ScrollToCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_ScrollTo_ForwardToCallback(const WebClientHandler_ScrollTo_ForwardToCallback&) = delete;
  WebClientHandler_ScrollTo_ForwardToCallback& operator=(const WebClientHandler_ScrollTo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::ScrollToCallback callback_;
};

class WebClientHandler_GetOsMicrophonePermissionStatus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_GetOsMicrophonePermissionStatus_ForwardToCallback(
      WebClientHandler::GetOsMicrophonePermissionStatusCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_GetOsMicrophonePermissionStatus_ForwardToCallback(const WebClientHandler_GetOsMicrophonePermissionStatus_ForwardToCallback&) = delete;
  WebClientHandler_GetOsMicrophonePermissionStatus_ForwardToCallback& operator=(const WebClientHandler_GetOsMicrophonePermissionStatus_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::GetOsMicrophonePermissionStatusCallback callback_;
};

class WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ForwardToCallback(
      WebClientHandler::GetZeroStateSuggestionsAndSubscribeCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ForwardToCallback(const WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ForwardToCallback&) = delete;
  WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ForwardToCallback& operator=(const WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::GetZeroStateSuggestionsAndSubscribeCallback callback_;
};

class WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ForwardToCallback(
      WebClientHandler::GetZeroStateSuggestionsForFocusedTabCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ForwardToCallback(const WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ForwardToCallback&) = delete;
  WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ForwardToCallback& operator=(const WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::GetZeroStateSuggestionsForFocusedTabCallback callback_;
};

class WebClientHandler_IsDebuggerAttached_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_IsDebuggerAttached_ForwardToCallback(
      WebClientHandler::IsDebuggerAttachedCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_IsDebuggerAttached_ForwardToCallback(const WebClientHandler_IsDebuggerAttached_ForwardToCallback&) = delete;
  WebClientHandler_IsDebuggerAttached_ForwardToCallback& operator=(const WebClientHandler_IsDebuggerAttached_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::IsDebuggerAttachedCallback callback_;
};

class WebClientHandler_SubscribeToPageMetadata_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_SubscribeToPageMetadata_ForwardToCallback(
      WebClientHandler::SubscribeToPageMetadataCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_SubscribeToPageMetadata_ForwardToCallback(const WebClientHandler_SubscribeToPageMetadata_ForwardToCallback&) = delete;
  WebClientHandler_SubscribeToPageMetadata_ForwardToCallback& operator=(const WebClientHandler_SubscribeToPageMetadata_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::SubscribeToPageMetadataCallback callback_;
};

class WebClientHandler_SwitchConversation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_SwitchConversation_ForwardToCallback(
      WebClientHandler::SwitchConversationCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_SwitchConversation_ForwardToCallback(const WebClientHandler_SwitchConversation_ForwardToCallback&) = delete;
  WebClientHandler_SwitchConversation_ForwardToCallback& operator=(const WebClientHandler_SwitchConversation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::SwitchConversationCallback callback_;
};

class WebClientHandler_RegisterConversation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClientHandler_RegisterConversation_ForwardToCallback(
      WebClientHandler::RegisterConversationCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClientHandler_RegisterConversation_ForwardToCallback(const WebClientHandler_RegisterConversation_ForwardToCallback&) = delete;
  WebClientHandler_RegisterConversation_ForwardToCallback& operator=(const WebClientHandler_RegisterConversation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClientHandler::RegisterConversationCallback callback_;
};

WebClientHandlerProxy::WebClientHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebClientHandlerProxy::WebClientCreated(
    ::mojo::PendingRemote<WebClient> in_web_client, WebClientCreatedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::WebClientCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("web_client"), in_web_client,
                        "<value of type ::mojo::PendingRemote<WebClient>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kWebClientCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_WebClientCreated_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::glic::mojom::WebClientInterfaceBase>>(
    in_web_client,
    &params->web_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->web_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid web_client in WebClientHandler.WebClientCreated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("WebClientCreated");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_WebClientCreated_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::WebClientInitialized(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::WebClientInitialized");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kWebClientInitialized), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_WebClientInitialized_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("WebClientInitialized");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::WebClientInitializeFailed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::WebClientInitializeFailed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kWebClientInitializeFailed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_WebClientInitializeFailed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("WebClientInitializeFailed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::CreateTab(
    const ::GURL& in_url, bool in_open_in_background, std::optional<int32_t> in_window_id, CreateTabCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::CreateTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("open_in_background"), in_open_in_background,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_id"), in_window_id,
                        "<value of type std::optional<int32_t>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kCreateTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_CreateTab_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in WebClientHandler.CreateTab request");

  params->open_in_background = in_open_in_background;
  params->window_id_$flag = in_window_id.has_value();
  if (in_window_id.has_value()) {
    params->window_id_$value = in_window_id.value();
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("CreateTab");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_CreateTab_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::OpenGlicSettingsPage(
    OpenSettingsOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::OpenGlicSettingsPage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type OpenSettingsOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kOpenGlicSettingsPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_OpenGlicSettingsPage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::OpenSettingsOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in WebClientHandler.OpenGlicSettingsPage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("OpenGlicSettingsPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::ClosePanel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::ClosePanel");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kClosePanel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_ClosePanel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("ClosePanel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::ClosePanelAndShutdown(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::ClosePanelAndShutdown");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kClosePanelAndShutdown), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_ClosePanelAndShutdown_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("ClosePanelAndShutdown");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::AttachPanel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::AttachPanel");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kAttachPanel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_AttachPanel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("AttachPanel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::DetachPanel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::DetachPanel");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kDetachPanel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_DetachPanel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("DetachPanel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::ShowProfilePicker(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::ShowProfilePicker");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kShowProfilePicker), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_ShowProfilePicker_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("ShowProfilePicker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::GetModelQualityClientId(
    GetModelQualityClientIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::GetModelQualityClientId");
#endif

  CHECK(base::FeatureList::IsEnabled(::glic::mojom::features::kGlicAppendModelQualityClientId));
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kGetModelQualityClientId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_GetModelQualityClientId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("GetModelQualityClientId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_GetModelQualityClientId_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::GetContextFromFocusedTab(
    GetTabContextOptionsPtr in_options, GetContextFromFocusedTabCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::GetContextFromFocusedTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type GetTabContextOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kGetContextFromFocusedTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_GetContextFromFocusedTab_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::GetTabContextOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in WebClientHandler.GetContextFromFocusedTab request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("GetContextFromFocusedTab");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_GetContextFromFocusedTab_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::GetContextFromTab(
    int32_t in_tab_id, GetTabContextOptionsPtr in_options, GetContextFromTabCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::GetContextFromTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type GetTabContextOptionsPtr>");
   });
#endif

  CHECK(base::FeatureList::IsEnabled(::glic::mojom::features::kGlicMultiTab));
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kGetContextFromTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_GetContextFromTab_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::GetTabContextOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in WebClientHandler.GetContextFromTab request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("GetContextFromTab");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_GetContextFromTab_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::GetContextForActorFromTab(
    int32_t in_tab_id, GetTabContextOptionsPtr in_options, GetContextForActorFromTabCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::GetContextForActorFromTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type GetTabContextOptionsPtr>");
   });
#endif

  CHECK(base::FeatureList::IsEnabled(::glic::mojom::features::kGlicActorTabContext));
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kGetContextForActorFromTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_GetContextForActorFromTab_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::GetTabContextOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in WebClientHandler.GetContextForActorFromTab request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("GetContextForActorFromTab");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_GetContextForActorFromTab_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::SetMaximumNumberOfPinnedTabs(
    uint32_t in_requested_max, SetMaximumNumberOfPinnedTabsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::SetMaximumNumberOfPinnedTabs", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requested_max"), in_requested_max,
                        "<value of type uint32_t>");
   });
#endif

  CHECK(base::FeatureList::IsEnabled(::glic::mojom::features::kGlicMultiTab));
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSetMaximumNumberOfPinnedTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SetMaximumNumberOfPinnedTabs_Params_Data> params(
          message);
  params.Allocate();

  params->requested_max = in_requested_max;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SetMaximumNumberOfPinnedTabs");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_SetMaximumNumberOfPinnedTabs_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::PinTabs(
    const std::vector<int32_t>& in_tab_ids, PinTabsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::PinTabs", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_ids"), in_tab_ids,
                        "<value of type const std::vector<int32_t>&>");
   });
#endif

  CHECK(base::FeatureList::IsEnabled(::glic::mojom::features::kGlicMultiTab));
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kPinTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_PinTabs_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tab_ids)::BaseType>
      tab_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& tab_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
    in_tab_ids,
    tab_ids_fragment,
    &tab_ids_validate_params);

  params->tab_ids.Set(
      tab_ids_fragment.is_null() ? nullptr : tab_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tab_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tab_ids in WebClientHandler.PinTabs request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("PinTabs");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_PinTabs_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::UnpinTabs(
    const std::vector<int32_t>& in_tab_ids, UnpinTabsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::UnpinTabs", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_ids"), in_tab_ids,
                        "<value of type const std::vector<int32_t>&>");
   });
#endif

  CHECK(base::FeatureList::IsEnabled(::glic::mojom::features::kGlicMultiTab));
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kUnpinTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_UnpinTabs_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tab_ids)::BaseType>
      tab_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& tab_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
    in_tab_ids,
    tab_ids_fragment,
    &tab_ids_validate_params);

  params->tab_ids.Set(
      tab_ids_fragment.is_null() ? nullptr : tab_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tab_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tab_ids in WebClientHandler.UnpinTabs request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("UnpinTabs");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_UnpinTabs_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::UnpinAllTabs(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::UnpinAllTabs");
#endif

  CHECK(base::FeatureList::IsEnabled(::glic::mojom::features::kGlicMultiTab));
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kUnpinAllTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_UnpinAllTabs_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("UnpinAllTabs");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::SubscribeToPinCandidates(
    GetPinCandidatesOptionsPtr in_options, ::mojo::PendingRemote<PinCandidatesObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::SubscribeToPinCandidates", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type GetPinCandidatesOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<PinCandidatesObserver>>");
   });
#endif

  CHECK(base::FeatureList::IsEnabled(::glic::mojom::features::kGlicMultiTab));
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSubscribeToPinCandidates), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SubscribeToPinCandidates_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::GetPinCandidatesOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in WebClientHandler.SubscribeToPinCandidates request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::glic::mojom::PinCandidatesObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in WebClientHandler.SubscribeToPinCandidates request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SubscribeToPinCandidates");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::CreateTask(
    ::actor::webui::mojom::TaskOptionsPtr in_task_options, CreateTaskCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::CreateTask", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("task_options"), in_task_options,
                        "<value of type ::actor::webui::mojom::TaskOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kCreateTask), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_CreateTask_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->task_options)::BaseType> task_options_fragment(
          params.message());
  
  mojo::internal::Serialize<::actor::webui::mojom::TaskOptionsDataView>(
    in_task_options,
    task_options_fragment);

  params->task_options.Set(
      task_options_fragment.is_null() ? nullptr : task_options_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("CreateTask");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_CreateTask_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::PerformActions(
    const std::vector<uint8_t>& in_actions_proto, PerformActionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::PerformActions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("actions_proto"), in_actions_proto,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kPerformActions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_PerformActions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->actions_proto)::BaseType>
      actions_proto_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& actions_proto_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_actions_proto,
    actions_proto_fragment,
    &actions_proto_validate_params);

  params->actions_proto.Set(
      actions_proto_fragment.is_null() ? nullptr : actions_proto_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->actions_proto.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null actions_proto in WebClientHandler.PerformActions request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("PerformActions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_PerformActions_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::StopActorTask(
    int32_t in_task_id, ActorTaskStopReason in_stop_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::StopActorTask", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("task_id"), in_task_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stop_reason"), in_stop_reason,
                        "<value of type ActorTaskStopReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kStopActorTask), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_StopActorTask_Params_Data> params(
          message);
  params.Allocate();

  params->task_id = in_task_id;

  
  mojo::internal::Serialize<::glic::mojom::ActorTaskStopReason>(
    in_stop_reason,
    &params->stop_reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("StopActorTask");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::PauseActorTask(
    int32_t in_task_id, ActorTaskPauseReason in_pause_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::PauseActorTask", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("task_id"), in_task_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pause_reason"), in_pause_reason,
                        "<value of type ActorTaskPauseReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kPauseActorTask), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_PauseActorTask_Params_Data> params(
          message);
  params.Allocate();

  params->task_id = in_task_id;

  
  mojo::internal::Serialize<::glic::mojom::ActorTaskPauseReason>(
    in_pause_reason,
    &params->pause_reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("PauseActorTask");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::ResumeActorTask(
    int32_t in_task_id, GetTabContextOptionsPtr in_context_options, ResumeActorTaskCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::ResumeActorTask", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("task_id"), in_task_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context_options"), in_context_options,
                        "<value of type GetTabContextOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kResumeActorTask), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_ResumeActorTask_Params_Data> params(
          message);
  params.Allocate();

  params->task_id = in_task_id;
  mojo::internal::MessageFragment<
      typename decltype(params->context_options)::BaseType> context_options_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::GetTabContextOptionsDataView>(
    in_context_options,
    context_options_fragment);

  params->context_options.Set(
      context_options_fragment.is_null() ? nullptr : context_options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->context_options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null context_options in WebClientHandler.ResumeActorTask request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("ResumeActorTask");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_ResumeActorTask_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::ResizeWidget(
    const ::gfx::Size& in_size, ::base::TimeDelta in_duration, ResizeWidgetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::ResizeWidget", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("duration"), in_duration,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kResizeWidget), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_ResizeWidget_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_size,
    size_fragment);

  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null size in WebClientHandler.ResizeWidget request");
  mojo::internal::MessageFragment<
      typename decltype(params->duration)::BaseType> duration_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_duration,
    duration_fragment);

  params->duration.Set(
      duration_fragment.is_null() ? nullptr : duration_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->duration.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null duration in WebClientHandler.ResizeWidget request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("ResizeWidget");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_ResizeWidget_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::CaptureScreenshot(
    CaptureScreenshotCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::CaptureScreenshot");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kCaptureScreenshot), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_CaptureScreenshot_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("CaptureScreenshot");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_CaptureScreenshot_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::SetAudioDucking(
    bool in_enable, SetAudioDuckingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::SetAudioDucking", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enable"), in_enable,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSetAudioDucking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SetAudioDucking_Params_Data> params(
          message);
  params.Allocate();

  params->enable = in_enable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SetAudioDucking");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_SetAudioDucking_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::SetPanelDraggableAreas(
    const std::vector<::gfx::Rect>& in_draggable_areas, SetPanelDraggableAreasCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::SetPanelDraggableAreas", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("draggable_areas"), in_draggable_areas,
                        "<value of type const std::vector<::gfx::Rect>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSetPanelDraggableAreas), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SetPanelDraggableAreas_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->draggable_areas)::BaseType>
      draggable_areas_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& draggable_areas_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
    in_draggable_areas,
    draggable_areas_fragment,
    &draggable_areas_validate_params);

  params->draggable_areas.Set(
      draggable_areas_fragment.is_null() ? nullptr : draggable_areas_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->draggable_areas.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null draggable_areas in WebClientHandler.SetPanelDraggableAreas request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SetPanelDraggableAreas");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_SetPanelDraggableAreas_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::SetMinimumPanelSize(
    const ::gfx::Size& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::SetMinimumPanelSize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSetMinimumPanelSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SetMinimumPanelSize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_size,
    size_fragment);

  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null size in WebClientHandler.SetMinimumPanelSize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SetMinimumPanelSize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::SetMicrophonePermissionState(
    bool in_enabled, SetMicrophonePermissionStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::SetMicrophonePermissionState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSetMicrophonePermissionState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SetMicrophonePermissionState_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SetMicrophonePermissionState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_SetMicrophonePermissionState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::SetLocationPermissionState(
    bool in_enabled, SetLocationPermissionStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::SetLocationPermissionState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSetLocationPermissionState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SetLocationPermissionState_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SetLocationPermissionState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_SetLocationPermissionState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::SetTabContextPermissionState(
    bool in_enabled, SetTabContextPermissionStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::SetTabContextPermissionState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSetTabContextPermissionState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SetTabContextPermissionState_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SetTabContextPermissionState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_SetTabContextPermissionState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::SetClosedCaptioningSetting(
    bool in_enabled, SetClosedCaptioningSettingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::SetClosedCaptioningSetting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSetClosedCaptioningSetting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SetClosedCaptioningSetting_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SetClosedCaptioningSetting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_SetClosedCaptioningSetting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::ShouldAllowMediaPermissionRequest(
    ShouldAllowMediaPermissionRequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::ShouldAllowMediaPermissionRequest");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kShouldAllowMediaPermissionRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_ShouldAllowMediaPermissionRequest_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("ShouldAllowMediaPermissionRequest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_ShouldAllowMediaPermissionRequest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::ShouldAllowGeolocationPermissionRequest(
    ShouldAllowGeolocationPermissionRequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::ShouldAllowGeolocationPermissionRequest");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kShouldAllowGeolocationPermissionRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_ShouldAllowGeolocationPermissionRequest_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("ShouldAllowGeolocationPermissionRequest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_ShouldAllowGeolocationPermissionRequest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::SetContextAccessIndicator(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::SetContextAccessIndicator", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSetContextAccessIndicator), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SetContextAccessIndicator_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SetContextAccessIndicator");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::GetUserProfileInfo(
    GetUserProfileInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::GetUserProfileInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kGetUserProfileInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_GetUserProfileInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("GetUserProfileInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_GetUserProfileInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::SyncCookies(
    SyncCookiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::SyncCookies");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSyncCookies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SyncCookies_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SyncCookies");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_SyncCookies_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::LogBeginAsyncEvent(
    uint64_t in_event_async_id, int32_t in_task_id, const std::string& in_event, const std::string& in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::LogBeginAsyncEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_async_id"), in_event_async_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("task_id"), in_task_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kLogBeginAsyncEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_LogBeginAsyncEvent_Params_Data> params(
          message);
  params.Allocate();

  params->event_async_id = in_event_async_id;

  params->task_id = in_task_id;
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in WebClientHandler.LogBeginAsyncEvent request");
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_details,
    details_fragment);

  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->details.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null details in WebClientHandler.LogBeginAsyncEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("LogBeginAsyncEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::LogEndAsyncEvent(
    uint64_t in_event_async_id, const std::string& in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::LogEndAsyncEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_async_id"), in_event_async_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kLogEndAsyncEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_LogEndAsyncEvent_Params_Data> params(
          message);
  params.Allocate();

  params->event_async_id = in_event_async_id;
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_details,
    details_fragment);

  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->details.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null details in WebClientHandler.LogEndAsyncEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("LogEndAsyncEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::LogInstantEvent(
    int32_t in_task_id, const std::string& in_event, const std::string& in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::LogInstantEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("task_id"), in_task_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kLogInstantEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_LogInstantEvent_Params_Data> params(
          message);
  params.Allocate();

  params->task_id = in_task_id;
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in WebClientHandler.LogInstantEvent request");
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_details,
    details_fragment);

  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->details.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null details in WebClientHandler.LogInstantEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("LogInstantEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::JournalClear(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::JournalClear");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kJournalClear), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_JournalClear_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("JournalClear");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::JournalSnapshot(
    bool in_clear_journal, JournalSnapshotCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::JournalSnapshot", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("clear_journal"), in_clear_journal,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kJournalSnapshot), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_JournalSnapshot_Params_Data> params(
          message);
  params.Allocate();

  params->clear_journal = in_clear_journal;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("JournalSnapshot");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_JournalSnapshot_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::JournalStart(
    uint64_t in_max_bytes, bool in_capture_screenshots) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::JournalStart", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_bytes"), in_max_bytes,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capture_screenshots"), in_capture_screenshots,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kJournalStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_JournalStart_Params_Data> params(
          message);
  params.Allocate();

  params->max_bytes = in_max_bytes;

  params->capture_screenshots = in_capture_screenshots;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("JournalStart");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::JournalStop(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::JournalStop");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kJournalStop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_JournalStop_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("JournalStop");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::JournalRecordFeedback(
    bool in_positive, const std::string& in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::JournalRecordFeedback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("positive"), in_positive,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kJournalRecordFeedback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_JournalRecordFeedback_Params_Data> params(
          message);
  params.Allocate();

  params->positive = in_positive;
  mojo::internal::MessageFragment<
      typename decltype(params->reason)::BaseType> reason_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_reason,
    reason_fragment);

  params->reason.Set(
      reason_fragment.is_null() ? nullptr : reason_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->reason.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null reason in WebClientHandler.JournalRecordFeedback request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("JournalRecordFeedback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::OnUserInputSubmitted(
    WebClientMode in_mode) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::OnUserInputSubmitted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type WebClientMode>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kOnUserInputSubmitted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_OnUserInputSubmitted_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::glic::mojom::WebClientMode>(
    in_mode,
    &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("OnUserInputSubmitted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::OnContextUploadStarted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::OnContextUploadStarted");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kOnContextUploadStarted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_OnContextUploadStarted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("OnContextUploadStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::OnContextUploadCompleted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::OnContextUploadCompleted");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kOnContextUploadCompleted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_OnContextUploadCompleted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("OnContextUploadCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::OnReaction(
    MetricUserInputReactionType in_reactionType) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::OnReaction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reactionType"), in_reactionType,
                        "<value of type MetricUserInputReactionType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kOnReaction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_OnReaction_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::glic::mojom::MetricUserInputReactionType>(
    in_reactionType,
    &params->reactionType);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("OnReaction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::OnResponseStarted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::OnResponseStarted");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kOnResponseStarted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_OnResponseStarted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("OnResponseStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::OnResponseStopped(
    OnResponseStoppedDetailsPtr in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::OnResponseStopped", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type OnResponseStoppedDetailsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kOnResponseStopped), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_OnResponseStopped_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::OnResponseStoppedDetailsDataView>(
    in_details,
    details_fragment);

  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->details.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null details in WebClientHandler.OnResponseStopped request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("OnResponseStopped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::OnSessionTerminated(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::OnSessionTerminated");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kOnSessionTerminated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_OnSessionTerminated_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("OnSessionTerminated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::OnTurnCompleted(
    WebClientModel in_model, ::base::TimeDelta in_duration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::OnTurnCompleted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("model"), in_model,
                        "<value of type WebClientModel>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("duration"), in_duration,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kOnTurnCompleted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_OnTurnCompleted_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::glic::mojom::WebClientModel>(
    in_model,
    &params->model);
  mojo::internal::MessageFragment<
      typename decltype(params->duration)::BaseType> duration_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_duration,
    duration_fragment);

  params->duration.Set(
      duration_fragment.is_null() ? nullptr : duration_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->duration.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null duration in WebClientHandler.OnTurnCompleted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("OnTurnCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::OnModelChanged(
    WebClientModel in_model) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::OnModelChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("model"), in_model,
                        "<value of type WebClientModel>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kOnModelChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_OnModelChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::glic::mojom::WebClientModel>(
    in_model,
    &params->model);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("OnModelChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::OnResponseRated(
    bool in_positive) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::OnResponseRated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("positive"), in_positive,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kOnResponseRated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_OnResponseRated_Params_Data> params(
          message);
  params.Allocate();

  params->positive = in_positive;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("OnResponseRated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::OnClosedCaptionsShown(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::OnClosedCaptionsShown");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kOnClosedCaptionsShown), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_OnClosedCaptionsShown_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("OnClosedCaptionsShown");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::ScrollTo(
    ScrollToParamsPtr in_params, ScrollToCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::ScrollTo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ScrollToParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kScrollTo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_ScrollTo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::ScrollToParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in WebClientHandler.ScrollTo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("ScrollTo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_ScrollTo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::DropScrollToHighlight(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::DropScrollToHighlight");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kDropScrollToHighlight), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_DropScrollToHighlight_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("DropScrollToHighlight");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::SetSyntheticExperimentState(
    const std::string& in_trial_name, const std::string& in_group_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::SetSyntheticExperimentState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trial_name"), in_trial_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_name"), in_group_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSetSyntheticExperimentState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SetSyntheticExperimentState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->trial_name)::BaseType> trial_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_trial_name,
    trial_name_fragment);

  params->trial_name.Set(
      trial_name_fragment.is_null() ? nullptr : trial_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->trial_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null trial_name in WebClientHandler.SetSyntheticExperimentState request");
  mojo::internal::MessageFragment<
      typename decltype(params->group_name)::BaseType> group_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_group_name,
    group_name_fragment);

  params->group_name.Set(
      group_name_fragment.is_null() ? nullptr : group_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_name in WebClientHandler.SetSyntheticExperimentState request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SetSyntheticExperimentState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::OpenOsPermissionSettingsMenu(
    ::content_settings::mojom::ContentSettingsType in_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::OpenOsPermissionSettingsMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::content_settings::mojom::ContentSettingsType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kOpenOsPermissionSettingsMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_OpenOsPermissionSettingsMenu_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::content_settings::mojom::ContentSettingsType>(
    in_type,
    &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("OpenOsPermissionSettingsMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::GetOsMicrophonePermissionStatus(
    GetOsMicrophonePermissionStatusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::GetOsMicrophonePermissionStatus");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kGetOsMicrophonePermissionStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_GetOsMicrophonePermissionStatus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("GetOsMicrophonePermissionStatus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_GetOsMicrophonePermissionStatus_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::GetZeroStateSuggestionsAndSubscribe(
    bool in_is_live, ZeroStateSuggestionsOptionsPtr in_options, GetZeroStateSuggestionsAndSubscribeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::GetZeroStateSuggestionsAndSubscribe", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_live"), in_is_live,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ZeroStateSuggestionsOptionsPtr>");
   });
#endif

  CHECK(base::FeatureList::IsEnabled(::glic::mojom::features::kZeroStateSuggestionsV2));
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kGetZeroStateSuggestionsAndSubscribe), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_GetZeroStateSuggestionsAndSubscribe_Params_Data> params(
          message);
  params.Allocate();

  params->is_live = in_is_live;
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::ZeroStateSuggestionsOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in WebClientHandler.GetZeroStateSuggestionsAndSubscribe request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("GetZeroStateSuggestionsAndSubscribe");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::GetZeroStateSuggestionsForFocusedTab(
    std::optional<bool> in_is_first_run, GetZeroStateSuggestionsForFocusedTabCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::GetZeroStateSuggestionsForFocusedTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_first_run"), in_is_first_run,
                        "<value of type std::optional<bool>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kGetZeroStateSuggestionsForFocusedTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_GetZeroStateSuggestionsForFocusedTab_Params_Data> params(
          message);
  params.Allocate();
  params->is_first_run_$flag = in_is_first_run.has_value();
  if (in_is_first_run.has_value()) {
    params->is_first_run_$value = in_is_first_run.value();
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("GetZeroStateSuggestionsForFocusedTab");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::MaybeRefreshUserStatus(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::MaybeRefreshUserStatus");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kMaybeRefreshUserStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_MaybeRefreshUserStatus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("MaybeRefreshUserStatus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::IsDebuggerAttached(
    IsDebuggerAttachedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClientHandler::IsDebuggerAttached");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kIsDebuggerAttached), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_IsDebuggerAttached_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("IsDebuggerAttached");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_IsDebuggerAttached_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::OnViewChanged(
    ViewChangedNotificationPtr in_notification) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::OnViewChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification"), in_notification,
                        "<value of type ViewChangedNotificationPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kOnViewChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_OnViewChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->notification)::BaseType> notification_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::ViewChangedNotificationDataView>(
    in_notification,
    notification_fragment);

  params->notification.Set(
      notification_fragment.is_null() ? nullptr : notification_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->notification.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null notification in WebClientHandler.OnViewChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("OnViewChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientHandlerProxy::SubscribeToPageMetadata(
    int32_t in_tab_id, const std::vector<std::string>& in_names, SubscribeToPageMetadataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::SubscribeToPageMetadata", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("names"), in_names,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSubscribeToPageMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SubscribeToPageMetadata_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;
  mojo::internal::MessageFragment<
      typename decltype(params->names)::BaseType>
      names_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& names_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_names,
    names_fragment,
    &names_validate_params);

  params->names.Set(
      names_fragment.is_null() ? nullptr : names_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->names.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null names in WebClientHandler.SubscribeToPageMetadata request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SubscribeToPageMetadata");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_SubscribeToPageMetadata_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::SwitchConversation(
    ConversationInfoPtr in_info, SwitchConversationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::SwitchConversation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type ConversationInfoPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSwitchConversation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SwitchConversation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::ConversationInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SwitchConversation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_SwitchConversation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientHandlerProxy::RegisterConversation(
    ConversationInfoPtr in_info, RegisterConversationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClientHandler::RegisterConversation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type ConversationInfoPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kRegisterConversation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_RegisterConversation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::ConversationInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in WebClientHandler.RegisterConversation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("RegisterConversation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClientHandler_RegisterConversation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WebClientHandler_WebClientCreated_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::WebClientCreatedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_WebClientCreated_ProxyToResponder> proxy(
        new WebClientHandler_WebClientCreated_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_WebClientCreated_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_WebClientCreated_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_WebClientCreated_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::WebClientCreatedCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebClientInitialStatePtr in_initial_state);
};

bool WebClientHandler_WebClientCreated_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_WebClientCreated_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_WebClientCreated_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.0
  bool success = true;
  WebClientInitialStatePtr p_initial_state{};
  WebClientHandler_WebClientCreated_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInitialState(&p_initial_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_initial_state));
  }
  return true;
}

void WebClientHandler_WebClientCreated_ProxyToResponder::Run(
    WebClientInitialStatePtr in_initial_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::WebClientCreated", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initial_state"), in_initial_state,
                        "<value of type WebClientInitialStatePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kWebClientCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_WebClientCreated_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->initial_state)::BaseType> initial_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::WebClientInitialStateDataView>(
    in_initial_state,
    initial_state_fragment);

  params->initial_state.Set(
      initial_state_fragment.is_null() ? nullptr : initial_state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->initial_state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null initial_state in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("WebClientCreated");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_CreateTab_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::CreateTabCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_CreateTab_ProxyToResponder> proxy(
        new WebClientHandler_CreateTab_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_CreateTab_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_CreateTab_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_CreateTab_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::CreateTabCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      TabDataPtr in_tab_data);
};

bool WebClientHandler_CreateTab_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_CreateTab_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_CreateTab_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.3
  bool success = true;
  TabDataPtr p_tab_data{};
  WebClientHandler_CreateTab_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTabData(&p_tab_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_tab_data));
  }
  return true;
}

void WebClientHandler_CreateTab_ProxyToResponder::Run(
    TabDataPtr in_tab_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::CreateTab", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_data"), in_tab_data,
                        "<value of type TabDataPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kCreateTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_CreateTab_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tab_data)::BaseType> tab_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::TabDataDataView>(
    in_tab_data,
    tab_data_fragment);

  params->tab_data.Set(
      tab_data_fragment.is_null() ? nullptr : tab_data_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("CreateTab");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_GetModelQualityClientId_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::GetModelQualityClientIdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_GetModelQualityClientId_ProxyToResponder> proxy(
        new WebClientHandler_GetModelQualityClientId_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_GetModelQualityClientId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_GetModelQualityClientId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_GetModelQualityClientId_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::GetModelQualityClientIdCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_model_quality_client_id);
};

bool WebClientHandler_GetModelQualityClientId_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_GetModelQualityClientId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_GetModelQualityClientId_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.10
  bool success = true;
  std::string p_model_quality_client_id{};
  WebClientHandler_GetModelQualityClientId_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadModelQualityClientId(&p_model_quality_client_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_model_quality_client_id));
  }
  return true;
}

void WebClientHandler_GetModelQualityClientId_ProxyToResponder::Run(
    const std::string& in_model_quality_client_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::GetModelQualityClientId", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("model_quality_client_id"), in_model_quality_client_id,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kGetModelQualityClientId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_GetModelQualityClientId_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->model_quality_client_id)::BaseType> model_quality_client_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_model_quality_client_id,
    model_quality_client_id_fragment);

  params->model_quality_client_id.Set(
      model_quality_client_id_fragment.is_null() ? nullptr : model_quality_client_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->model_quality_client_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null model_quality_client_id in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("GetModelQualityClientId");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_GetContextFromFocusedTab_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::GetContextFromFocusedTabCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_GetContextFromFocusedTab_ProxyToResponder> proxy(
        new WebClientHandler_GetContextFromFocusedTab_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_GetContextFromFocusedTab_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_GetContextFromFocusedTab_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_GetContextFromFocusedTab_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::GetContextFromFocusedTabCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      GetContextResultPtr in_result);
};

bool WebClientHandler_GetContextFromFocusedTab_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_GetContextFromFocusedTab_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_GetContextFromFocusedTab_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.11
  bool success = true;
  GetContextResultPtr p_result{};
  WebClientHandler_GetContextFromFocusedTab_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebClientHandler_GetContextFromFocusedTab_ProxyToResponder::Run(
    GetContextResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::GetContextFromFocusedTab", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type GetContextResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kGetContextFromFocusedTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_GetContextFromFocusedTab_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::glic::mojom::GetContextResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("GetContextFromFocusedTab");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_GetContextFromTab_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::GetContextFromTabCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_GetContextFromTab_ProxyToResponder> proxy(
        new WebClientHandler_GetContextFromTab_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_GetContextFromTab_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_GetContextFromTab_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_GetContextFromTab_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::GetContextFromTabCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      GetContextResultPtr in_result);
};

bool WebClientHandler_GetContextFromTab_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_GetContextFromTab_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_GetContextFromTab_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.12
  bool success = true;
  GetContextResultPtr p_result{};
  WebClientHandler_GetContextFromTab_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebClientHandler_GetContextFromTab_ProxyToResponder::Run(
    GetContextResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::GetContextFromTab", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type GetContextResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kGetContextFromTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_GetContextFromTab_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::glic::mojom::GetContextResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("GetContextFromTab");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_GetContextForActorFromTab_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::GetContextForActorFromTabCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_GetContextForActorFromTab_ProxyToResponder> proxy(
        new WebClientHandler_GetContextForActorFromTab_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_GetContextForActorFromTab_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_GetContextForActorFromTab_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_GetContextForActorFromTab_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::GetContextForActorFromTabCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      GetContextResultPtr in_result);
};

bool WebClientHandler_GetContextForActorFromTab_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_GetContextForActorFromTab_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_GetContextForActorFromTab_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.13
  bool success = true;
  GetContextResultPtr p_result{};
  WebClientHandler_GetContextForActorFromTab_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebClientHandler_GetContextForActorFromTab_ProxyToResponder::Run(
    GetContextResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::GetContextForActorFromTab", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type GetContextResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kGetContextForActorFromTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_GetContextForActorFromTab_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::glic::mojom::GetContextResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("GetContextForActorFromTab");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_SetMaximumNumberOfPinnedTabs_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::SetMaximumNumberOfPinnedTabsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_SetMaximumNumberOfPinnedTabs_ProxyToResponder> proxy(
        new WebClientHandler_SetMaximumNumberOfPinnedTabs_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_SetMaximumNumberOfPinnedTabs_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_SetMaximumNumberOfPinnedTabs_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_SetMaximumNumberOfPinnedTabs_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::SetMaximumNumberOfPinnedTabsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_effective_max);
};

bool WebClientHandler_SetMaximumNumberOfPinnedTabs_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.14
  bool success = true;
  uint32_t p_effective_max{};
  WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_effective_max = input_data_view.effective_max();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_effective_max));
  }
  return true;
}

void WebClientHandler_SetMaximumNumberOfPinnedTabs_ProxyToResponder::Run(
    uint32_t in_effective_max) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::SetMaximumNumberOfPinnedTabs", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("effective_max"), in_effective_max,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSetMaximumNumberOfPinnedTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->effective_max = in_effective_max;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SetMaximumNumberOfPinnedTabs");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_PinTabs_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::PinTabsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_PinTabs_ProxyToResponder> proxy(
        new WebClientHandler_PinTabs_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_PinTabs_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_PinTabs_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_PinTabs_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::PinTabsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_pinned_all);
};

bool WebClientHandler_PinTabs_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_PinTabs_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_PinTabs_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.15
  bool success = true;
  bool p_pinned_all{};
  WebClientHandler_PinTabs_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_pinned_all = input_data_view.pinned_all();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 15, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_pinned_all));
  }
  return true;
}

void WebClientHandler_PinTabs_ProxyToResponder::Run(
    bool in_pinned_all) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::PinTabs", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pinned_all"), in_pinned_all,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kPinTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_PinTabs_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->pinned_all = in_pinned_all;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("PinTabs");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_UnpinTabs_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::UnpinTabsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_UnpinTabs_ProxyToResponder> proxy(
        new WebClientHandler_UnpinTabs_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_UnpinTabs_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_UnpinTabs_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_UnpinTabs_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::UnpinTabsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_unpinned_all);
};

bool WebClientHandler_UnpinTabs_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_UnpinTabs_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_UnpinTabs_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.16
  bool success = true;
  bool p_unpinned_all{};
  WebClientHandler_UnpinTabs_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_unpinned_all = input_data_view.unpinned_all();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 16, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_unpinned_all));
  }
  return true;
}

void WebClientHandler_UnpinTabs_ProxyToResponder::Run(
    bool in_unpinned_all) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::UnpinTabs", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unpinned_all"), in_unpinned_all,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kUnpinTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_UnpinTabs_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->unpinned_all = in_unpinned_all;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("UnpinTabs");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_CreateTask_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::CreateTaskCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_CreateTask_ProxyToResponder> proxy(
        new WebClientHandler_CreateTask_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&WebClientHandler_CreateTask_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static WebClientHandler_CreateTask_ResponseParam_ResultPtr Transform(base::expected<
  int32_t,
  CreateTaskErrorReason> in) {
    return in.has_value() ? ::glic::mojom::WebClientHandler_CreateTask_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::glic::mojom::WebClientHandler_CreateTask_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~WebClientHandler_CreateTask_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_CreateTask_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::CreateTaskCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebClientHandler_CreateTask_ResponseParam_ResultPtr in_result);
};

bool WebClientHandler_CreateTask_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_CreateTask_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_CreateTask_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.19
  bool success = true;
  WebClientHandler_CreateTask_ResponseParam_ResultPtr p_result{};
  WebClientHandler_CreateTask_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 19, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void WebClientHandler_CreateTask_ProxyToResponder::Run(
    WebClientHandler_CreateTask_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::CreateTask", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebClientHandler_CreateTask_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kCreateTask), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_CreateTask_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::glic::mojom::WebClientHandler_CreateTask_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("CreateTask");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_PerformActions_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::PerformActionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_PerformActions_ProxyToResponder> proxy(
        new WebClientHandler_PerformActions_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&WebClientHandler_PerformActions_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static WebClientHandler_PerformActions_ResponseParam_ResultPtr Transform(base::expected<
  ::mojo_base::ProtoWrapper,
  PerformActionsErrorReason> in) {
    return in.has_value() ? ::glic::mojom::WebClientHandler_PerformActions_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::glic::mojom::WebClientHandler_PerformActions_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~WebClientHandler_PerformActions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_PerformActions_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::PerformActionsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebClientHandler_PerformActions_ResponseParam_ResultPtr in_result);
};

bool WebClientHandler_PerformActions_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_PerformActions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_PerformActions_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.20
  bool success = true;
  WebClientHandler_PerformActions_ResponseParam_ResultPtr p_result{};
  WebClientHandler_PerformActions_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 20, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void WebClientHandler_PerformActions_ProxyToResponder::Run(
    WebClientHandler_PerformActions_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::PerformActions", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebClientHandler_PerformActions_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kPerformActions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_PerformActions_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::glic::mojom::WebClientHandler_PerformActions_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("PerformActions");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_ResumeActorTask_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::ResumeActorTaskCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_ResumeActorTask_ProxyToResponder> proxy(
        new WebClientHandler_ResumeActorTask_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_ResumeActorTask_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_ResumeActorTask_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_ResumeActorTask_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::ResumeActorTaskCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      GetContextResultPtr in_result);
};

bool WebClientHandler_ResumeActorTask_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_ResumeActorTask_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_ResumeActorTask_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.23
  bool success = true;
  GetContextResultPtr p_result{};
  WebClientHandler_ResumeActorTask_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 23, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebClientHandler_ResumeActorTask_ProxyToResponder::Run(
    GetContextResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::ResumeActorTask", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type GetContextResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kResumeActorTask), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_ResumeActorTask_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::glic::mojom::GetContextResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("ResumeActorTask");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_ResizeWidget_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::ResizeWidgetCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_ResizeWidget_ProxyToResponder> proxy(
        new WebClientHandler_ResizeWidget_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_ResizeWidget_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_ResizeWidget_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_ResizeWidget_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::ResizeWidgetCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool WebClientHandler_ResizeWidget_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_ResizeWidget_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_ResizeWidget_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.24
  bool success = true;
  WebClientHandler_ResizeWidget_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 24, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void WebClientHandler_ResizeWidget_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply glic::mojom::WebClientHandler::ResizeWidget");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kResizeWidget), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_ResizeWidget_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("ResizeWidget");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_CaptureScreenshot_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::CaptureScreenshotCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_CaptureScreenshot_ProxyToResponder> proxy(
        new WebClientHandler_CaptureScreenshot_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_CaptureScreenshot_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_CaptureScreenshot_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_CaptureScreenshot_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::CaptureScreenshotCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CaptureScreenshotResultPtr in_result);
};

bool WebClientHandler_CaptureScreenshot_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_CaptureScreenshot_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_CaptureScreenshot_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.25
  bool success = true;
  CaptureScreenshotResultPtr p_result{};
  WebClientHandler_CaptureScreenshot_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 25, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebClientHandler_CaptureScreenshot_ProxyToResponder::Run(
    CaptureScreenshotResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::CaptureScreenshot", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CaptureScreenshotResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kCaptureScreenshot), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_CaptureScreenshot_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::glic::mojom::CaptureScreenshotResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("CaptureScreenshot");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_SetAudioDucking_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::SetAudioDuckingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_SetAudioDucking_ProxyToResponder> proxy(
        new WebClientHandler_SetAudioDucking_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_SetAudioDucking_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_SetAudioDucking_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_SetAudioDucking_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::SetAudioDuckingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);
};

bool WebClientHandler_SetAudioDucking_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_SetAudioDucking_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_SetAudioDucking_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.26
  bool success = true;
  bool p_result{};
  WebClientHandler_SetAudioDucking_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 26, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebClientHandler_SetAudioDucking_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::SetAudioDucking", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSetAudioDucking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SetAudioDucking_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SetAudioDucking");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_SetPanelDraggableAreas_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::SetPanelDraggableAreasCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_SetPanelDraggableAreas_ProxyToResponder> proxy(
        new WebClientHandler_SetPanelDraggableAreas_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_SetPanelDraggableAreas_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_SetPanelDraggableAreas_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_SetPanelDraggableAreas_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::SetPanelDraggableAreasCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool WebClientHandler_SetPanelDraggableAreas_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_SetPanelDraggableAreas_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_SetPanelDraggableAreas_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.27
  bool success = true;
  WebClientHandler_SetPanelDraggableAreas_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 27, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void WebClientHandler_SetPanelDraggableAreas_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply glic::mojom::WebClientHandler::SetPanelDraggableAreas");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSetPanelDraggableAreas), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SetPanelDraggableAreas_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SetPanelDraggableAreas");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_SetMicrophonePermissionState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::SetMicrophonePermissionStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_SetMicrophonePermissionState_ProxyToResponder> proxy(
        new WebClientHandler_SetMicrophonePermissionState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_SetMicrophonePermissionState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_SetMicrophonePermissionState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_SetMicrophonePermissionState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::SetMicrophonePermissionStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool WebClientHandler_SetMicrophonePermissionState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_SetMicrophonePermissionState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_SetMicrophonePermissionState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.29
  bool success = true;
  WebClientHandler_SetMicrophonePermissionState_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 29, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void WebClientHandler_SetMicrophonePermissionState_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply glic::mojom::WebClientHandler::SetMicrophonePermissionState");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSetMicrophonePermissionState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SetMicrophonePermissionState_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SetMicrophonePermissionState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_SetLocationPermissionState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::SetLocationPermissionStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_SetLocationPermissionState_ProxyToResponder> proxy(
        new WebClientHandler_SetLocationPermissionState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_SetLocationPermissionState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_SetLocationPermissionState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_SetLocationPermissionState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::SetLocationPermissionStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool WebClientHandler_SetLocationPermissionState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_SetLocationPermissionState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_SetLocationPermissionState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.30
  bool success = true;
  WebClientHandler_SetLocationPermissionState_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 30, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void WebClientHandler_SetLocationPermissionState_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply glic::mojom::WebClientHandler::SetLocationPermissionState");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSetLocationPermissionState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SetLocationPermissionState_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SetLocationPermissionState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_SetTabContextPermissionState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::SetTabContextPermissionStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_SetTabContextPermissionState_ProxyToResponder> proxy(
        new WebClientHandler_SetTabContextPermissionState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_SetTabContextPermissionState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_SetTabContextPermissionState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_SetTabContextPermissionState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::SetTabContextPermissionStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool WebClientHandler_SetTabContextPermissionState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_SetTabContextPermissionState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_SetTabContextPermissionState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.31
  bool success = true;
  WebClientHandler_SetTabContextPermissionState_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 31, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void WebClientHandler_SetTabContextPermissionState_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply glic::mojom::WebClientHandler::SetTabContextPermissionState");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSetTabContextPermissionState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SetTabContextPermissionState_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SetTabContextPermissionState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_SetClosedCaptioningSetting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::SetClosedCaptioningSettingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_SetClosedCaptioningSetting_ProxyToResponder> proxy(
        new WebClientHandler_SetClosedCaptioningSetting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_SetClosedCaptioningSetting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_SetClosedCaptioningSetting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_SetClosedCaptioningSetting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::SetClosedCaptioningSettingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool WebClientHandler_SetClosedCaptioningSetting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_SetClosedCaptioningSetting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_SetClosedCaptioningSetting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.32
  bool success = true;
  WebClientHandler_SetClosedCaptioningSetting_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 32, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void WebClientHandler_SetClosedCaptioningSetting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply glic::mojom::WebClientHandler::SetClosedCaptioningSetting");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSetClosedCaptioningSetting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SetClosedCaptioningSetting_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SetClosedCaptioningSetting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_ShouldAllowMediaPermissionRequest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::ShouldAllowMediaPermissionRequestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_ShouldAllowMediaPermissionRequest_ProxyToResponder> proxy(
        new WebClientHandler_ShouldAllowMediaPermissionRequest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_ShouldAllowMediaPermissionRequest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_ShouldAllowMediaPermissionRequest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_ShouldAllowMediaPermissionRequest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::ShouldAllowMediaPermissionRequestCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_allowed);
};

bool WebClientHandler_ShouldAllowMediaPermissionRequest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.33
  bool success = true;
  bool p_is_allowed{};
  WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_allowed = input_data_view.is_allowed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 33, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_allowed));
  }
  return true;
}

void WebClientHandler_ShouldAllowMediaPermissionRequest_ProxyToResponder::Run(
    bool in_is_allowed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::ShouldAllowMediaPermissionRequest", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_allowed"), in_is_allowed,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kShouldAllowMediaPermissionRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_allowed = in_is_allowed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("ShouldAllowMediaPermissionRequest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_ShouldAllowGeolocationPermissionRequest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::ShouldAllowGeolocationPermissionRequestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_ShouldAllowGeolocationPermissionRequest_ProxyToResponder> proxy(
        new WebClientHandler_ShouldAllowGeolocationPermissionRequest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_ShouldAllowGeolocationPermissionRequest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_ShouldAllowGeolocationPermissionRequest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_ShouldAllowGeolocationPermissionRequest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::ShouldAllowGeolocationPermissionRequestCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_allowed);
};

bool WebClientHandler_ShouldAllowGeolocationPermissionRequest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.34
  bool success = true;
  bool p_is_allowed{};
  WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_allowed = input_data_view.is_allowed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 34, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_allowed));
  }
  return true;
}

void WebClientHandler_ShouldAllowGeolocationPermissionRequest_ProxyToResponder::Run(
    bool in_is_allowed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::ShouldAllowGeolocationPermissionRequest", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_allowed"), in_is_allowed,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kShouldAllowGeolocationPermissionRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_allowed = in_is_allowed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("ShouldAllowGeolocationPermissionRequest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_GetUserProfileInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::GetUserProfileInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_GetUserProfileInfo_ProxyToResponder> proxy(
        new WebClientHandler_GetUserProfileInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_GetUserProfileInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_GetUserProfileInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_GetUserProfileInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::GetUserProfileInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      UserProfileInfoPtr in_profile_info);
};

bool WebClientHandler_GetUserProfileInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_GetUserProfileInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_GetUserProfileInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.36
  bool success = true;
  UserProfileInfoPtr p_profile_info{};
  WebClientHandler_GetUserProfileInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadProfileInfo(&p_profile_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 36, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_profile_info));
  }
  return true;
}

void WebClientHandler_GetUserProfileInfo_ProxyToResponder::Run(
    UserProfileInfoPtr in_profile_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::GetUserProfileInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("profile_info"), in_profile_info,
                        "<value of type UserProfileInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kGetUserProfileInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_GetUserProfileInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->profile_info)::BaseType> profile_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::UserProfileInfoDataView>(
    in_profile_info,
    profile_info_fragment);

  params->profile_info.Set(
      profile_info_fragment.is_null() ? nullptr : profile_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("GetUserProfileInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_SyncCookies_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::SyncCookiesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_SyncCookies_ProxyToResponder> proxy(
        new WebClientHandler_SyncCookies_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_SyncCookies_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_SyncCookies_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_SyncCookies_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::SyncCookiesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool WebClientHandler_SyncCookies_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_SyncCookies_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_SyncCookies_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.37
  bool success = true;
  bool p_success{};
  WebClientHandler_SyncCookies_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 37, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void WebClientHandler_SyncCookies_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::SyncCookies", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSyncCookies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SyncCookies_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SyncCookies");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_JournalSnapshot_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::JournalSnapshotCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_JournalSnapshot_ProxyToResponder> proxy(
        new WebClientHandler_JournalSnapshot_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_JournalSnapshot_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_JournalSnapshot_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_JournalSnapshot_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::JournalSnapshotCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      JournalPtr in_journal);
};

bool WebClientHandler_JournalSnapshot_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_JournalSnapshot_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_JournalSnapshot_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.42
  bool success = true;
  JournalPtr p_journal{};
  WebClientHandler_JournalSnapshot_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadJournal(&p_journal))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 42, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_journal));
  }
  return true;
}

void WebClientHandler_JournalSnapshot_ProxyToResponder::Run(
    JournalPtr in_journal) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::JournalSnapshot", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("journal"), in_journal,
                        "<value of type JournalPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kJournalSnapshot), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_JournalSnapshot_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->journal)::BaseType> journal_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::JournalDataView>(
    in_journal,
    journal_fragment);

  params->journal.Set(
      journal_fragment.is_null() ? nullptr : journal_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->journal.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null journal in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("JournalSnapshot");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_ScrollTo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::ScrollToCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_ScrollTo_ProxyToResponder> proxy(
        new WebClientHandler_ScrollTo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_ScrollTo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_ScrollTo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_ScrollTo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::ScrollToCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<ScrollToErrorReason> in_error_reason);
};

bool WebClientHandler_ScrollTo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_ScrollTo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_ScrollTo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.57
  bool success = true;
  std::optional<ScrollToErrorReason> p_error_reason{};
  WebClientHandler_ScrollTo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorReason(&p_error_reason)) {
    success = false;
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 57, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error_reason));
  }
  return true;
}

void WebClientHandler_ScrollTo_ProxyToResponder::Run(
    std::optional<ScrollToErrorReason> in_error_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::ScrollTo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_reason"), in_error_reason,
                        "<value of type std::optional<ScrollToErrorReason>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kScrollTo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_ScrollTo_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->error_reason_$flag = in_error_reason.has_value();
  if (in_error_reason.has_value()) {
    
    mojo::internal::Serialize<::glic::mojom::ScrollToErrorReason>(
      in_error_reason.value(),
      &params->error_reason_$value);
  } else {
    params->error_reason_$value =
        static_cast<int32_t>(::glic::mojom::ScrollToErrorReason::kMinValue);
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("ScrollTo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_GetOsMicrophonePermissionStatus_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::GetOsMicrophonePermissionStatusCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_GetOsMicrophonePermissionStatus_ProxyToResponder> proxy(
        new WebClientHandler_GetOsMicrophonePermissionStatus_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_GetOsMicrophonePermissionStatus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_GetOsMicrophonePermissionStatus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_GetOsMicrophonePermissionStatus_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::GetOsMicrophonePermissionStatusCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_enabled);
};

bool WebClientHandler_GetOsMicrophonePermissionStatus_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.61
  bool success = true;
  bool p_enabled{};
  WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_enabled = input_data_view.enabled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 61, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_enabled));
  }
  return true;
}

void WebClientHandler_GetOsMicrophonePermissionStatus_ProxyToResponder::Run(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::GetOsMicrophonePermissionStatus", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kGetOsMicrophonePermissionStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("GetOsMicrophonePermissionStatus");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::GetZeroStateSuggestionsAndSubscribeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ProxyToResponder> proxy(
        new WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::GetZeroStateSuggestionsAndSubscribeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ZeroStateSuggestionsV2Ptr in_zero_state_suggestions);
};

bool WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.62
  bool success = true;
  ZeroStateSuggestionsV2Ptr p_zero_state_suggestions{};
  WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadZeroStateSuggestions(&p_zero_state_suggestions))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 62, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_zero_state_suggestions));
  }
  return true;
}

void WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ProxyToResponder::Run(
    ZeroStateSuggestionsV2Ptr in_zero_state_suggestions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::GetZeroStateSuggestionsAndSubscribe", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("zero_state_suggestions"), in_zero_state_suggestions,
                        "<value of type ZeroStateSuggestionsV2Ptr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kGetZeroStateSuggestionsAndSubscribe), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->zero_state_suggestions)::BaseType> zero_state_suggestions_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::ZeroStateSuggestionsV2DataView>(
    in_zero_state_suggestions,
    zero_state_suggestions_fragment);

  params->zero_state_suggestions.Set(
      zero_state_suggestions_fragment.is_null() ? nullptr : zero_state_suggestions_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("GetZeroStateSuggestionsAndSubscribe");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::GetZeroStateSuggestionsForFocusedTabCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ProxyToResponder> proxy(
        new WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::GetZeroStateSuggestionsForFocusedTabCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ZeroStateSuggestionsPtr in_suggestions);
};

bool WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.63
  bool success = true;
  ZeroStateSuggestionsPtr p_suggestions{};
  WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSuggestions(&p_suggestions))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 63, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_suggestions));
  }
  return true;
}

void WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ProxyToResponder::Run(
    ZeroStateSuggestionsPtr in_suggestions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::GetZeroStateSuggestionsForFocusedTab", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("suggestions"), in_suggestions,
                        "<value of type ZeroStateSuggestionsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kGetZeroStateSuggestionsForFocusedTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->suggestions)::BaseType> suggestions_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::ZeroStateSuggestionsDataView>(
    in_suggestions,
    suggestions_fragment);

  params->suggestions.Set(
      suggestions_fragment.is_null() ? nullptr : suggestions_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("GetZeroStateSuggestionsForFocusedTab");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_IsDebuggerAttached_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::IsDebuggerAttachedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_IsDebuggerAttached_ProxyToResponder> proxy(
        new WebClientHandler_IsDebuggerAttached_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_IsDebuggerAttached_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_IsDebuggerAttached_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_IsDebuggerAttached_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::IsDebuggerAttachedCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_attached_to_webview);
};

bool WebClientHandler_IsDebuggerAttached_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_IsDebuggerAttached_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_IsDebuggerAttached_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.65
  bool success = true;
  bool p_is_attached_to_webview{};
  WebClientHandler_IsDebuggerAttached_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_attached_to_webview = input_data_view.is_attached_to_webview();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 65, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_attached_to_webview));
  }
  return true;
}

void WebClientHandler_IsDebuggerAttached_ProxyToResponder::Run(
    bool in_is_attached_to_webview) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::IsDebuggerAttached", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_attached_to_webview"), in_is_attached_to_webview,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kIsDebuggerAttached), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_IsDebuggerAttached_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_attached_to_webview = in_is_attached_to_webview;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("IsDebuggerAttached");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_SubscribeToPageMetadata_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::SubscribeToPageMetadataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_SubscribeToPageMetadata_ProxyToResponder> proxy(
        new WebClientHandler_SubscribeToPageMetadata_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_SubscribeToPageMetadata_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_SubscribeToPageMetadata_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_SubscribeToPageMetadata_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::SubscribeToPageMetadataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool WebClientHandler_SubscribeToPageMetadata_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_SubscribeToPageMetadata_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_SubscribeToPageMetadata_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.67
  bool success = true;
  bool p_success{};
  WebClientHandler_SubscribeToPageMetadata_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 67, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void WebClientHandler_SubscribeToPageMetadata_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::SubscribeToPageMetadata", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSubscribeToPageMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SubscribeToPageMetadata_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SubscribeToPageMetadata");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_SwitchConversation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::SwitchConversationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_SwitchConversation_ProxyToResponder> proxy(
        new WebClientHandler_SwitchConversation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_SwitchConversation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_SwitchConversation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_SwitchConversation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::SwitchConversationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<SwitchConversationErrorReason> in_error_reason);
};

bool WebClientHandler_SwitchConversation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_SwitchConversation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_SwitchConversation_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.68
  bool success = true;
  std::optional<SwitchConversationErrorReason> p_error_reason{};
  WebClientHandler_SwitchConversation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorReason(&p_error_reason)) {
    success = false;
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 68, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error_reason));
  }
  return true;
}

void WebClientHandler_SwitchConversation_ProxyToResponder::Run(
    std::optional<SwitchConversationErrorReason> in_error_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::SwitchConversation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_reason"), in_error_reason,
                        "<value of type std::optional<SwitchConversationErrorReason>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kSwitchConversation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_SwitchConversation_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->error_reason_$flag = in_error_reason.has_value();
  if (in_error_reason.has_value()) {
    
    mojo::internal::Serialize<::glic::mojom::SwitchConversationErrorReason>(
      in_error_reason.value(),
      &params->error_reason_$value);
  } else {
    params->error_reason_$value =
        static_cast<int32_t>(::glic::mojom::SwitchConversationErrorReason::kMinValue);
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("SwitchConversation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClientHandler_RegisterConversation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClientHandler::RegisterConversationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClientHandler_RegisterConversation_ProxyToResponder> proxy(
        new WebClientHandler_RegisterConversation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClientHandler_RegisterConversation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClientHandler_RegisterConversation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClientHandler_RegisterConversation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClientHandler::RegisterConversationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<RegisterConversationErrorReason> in_error_reason);
};

bool WebClientHandler_RegisterConversation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClientHandler_RegisterConversation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClientHandler_RegisterConversation_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClientHandler.69
  bool success = true;
  std::optional<RegisterConversationErrorReason> p_error_reason{};
  WebClientHandler_RegisterConversation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorReason(&p_error_reason)) {
    success = false;
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClientHandler::Name_, 69, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error_reason));
  }
  return true;
}

void WebClientHandler_RegisterConversation_ProxyToResponder::Run(
    std::optional<RegisterConversationErrorReason> in_error_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClientHandler::RegisterConversation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_reason"), in_error_reason,
                        "<value of type std::optional<RegisterConversationErrorReason>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClientHandler::kRegisterConversation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClientHandler_RegisterConversation_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->error_reason_$flag = in_error_reason.has_value();
  if (in_error_reason.has_value()) {
    
    mojo::internal::Serialize<::glic::mojom::RegisterConversationErrorReason>(
      in_error_reason.value(),
      &params->error_reason_$value);
  } else {
    params->error_reason_$value =
        static_cast<int32_t>(::glic::mojom::RegisterConversationErrorReason::kMinValue);
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClientHandler::Name_);
  message.set_method_name("RegisterConversation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebClientHandlerStubDispatch::Accept(
    WebClientHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebClientHandler>(message->header()->name)) {
    case messages::WebClientHandler::kWebClientCreated: {
      break;
    }
    case messages::WebClientHandler::kWebClientInitialized: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_WebClientInitialized_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_WebClientInitialized_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.1
      bool success = true;
      WebClientHandler_WebClientInitialized_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WebClientInitialized(        );
      return true;
    }
    case messages::WebClientHandler::kWebClientInitializeFailed: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_WebClientInitializeFailed_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_WebClientInitializeFailed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.2
      bool success = true;
      WebClientHandler_WebClientInitializeFailed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WebClientInitializeFailed(        );
      return true;
    }
    case messages::WebClientHandler::kCreateTab: {
      break;
    }
    case messages::WebClientHandler::kOpenGlicSettingsPage: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_OpenGlicSettingsPage_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_OpenGlicSettingsPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.4
      bool success = true;
      OpenSettingsOptionsPtr p_options{};
      WebClientHandler_OpenGlicSettingsPage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenGlicSettingsPage(        
        std::move(p_options));
      return true;
    }
    case messages::WebClientHandler::kClosePanel: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_ClosePanel_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_ClosePanel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.5
      bool success = true;
      WebClientHandler_ClosePanel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClosePanel(        );
      return true;
    }
    case messages::WebClientHandler::kClosePanelAndShutdown: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_ClosePanelAndShutdown_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_ClosePanelAndShutdown_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.6
      bool success = true;
      WebClientHandler_ClosePanelAndShutdown_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClosePanelAndShutdown(        );
      return true;
    }
    case messages::WebClientHandler::kAttachPanel: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_AttachPanel_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_AttachPanel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.7
      bool success = true;
      WebClientHandler_AttachPanel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AttachPanel(        );
      return true;
    }
    case messages::WebClientHandler::kDetachPanel: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_DetachPanel_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_DetachPanel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.8
      bool success = true;
      WebClientHandler_DetachPanel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DetachPanel(        );
      return true;
    }
    case messages::WebClientHandler::kShowProfilePicker: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_ShowProfilePicker_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_ShowProfilePicker_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.9
      bool success = true;
      WebClientHandler_ShowProfilePicker_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowProfilePicker(        );
      return true;
    }
    case messages::WebClientHandler::kGetModelQualityClientId: {
      break;
    }
    case messages::WebClientHandler::kGetContextFromFocusedTab: {
      break;
    }
    case messages::WebClientHandler::kGetContextFromTab: {
      break;
    }
    case messages::WebClientHandler::kGetContextForActorFromTab: {
      break;
    }
    case messages::WebClientHandler::kSetMaximumNumberOfPinnedTabs: {
      break;
    }
    case messages::WebClientHandler::kPinTabs: {
      break;
    }
    case messages::WebClientHandler::kUnpinTabs: {
      break;
    }
    case messages::WebClientHandler::kUnpinAllTabs: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_UnpinAllTabs_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_UnpinAllTabs_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.17
      bool success = true;
      WebClientHandler_UnpinAllTabs_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnpinAllTabs(        );
      return true;
    }
    case messages::WebClientHandler::kSubscribeToPinCandidates: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_SubscribeToPinCandidates_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_SubscribeToPinCandidates_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.18
      bool success = true;
      GetPinCandidatesOptionsPtr p_options{};
      ::mojo::PendingRemote<PinCandidatesObserver> p_observer{};
      WebClientHandler_SubscribeToPinCandidates_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubscribeToPinCandidates(        
        std::move(p_options), 
        std::move(p_observer));
      return true;
    }
    case messages::WebClientHandler::kCreateTask: {
      break;
    }
    case messages::WebClientHandler::kPerformActions: {
      break;
    }
    case messages::WebClientHandler::kStopActorTask: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_StopActorTask_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_StopActorTask_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.21
      bool success = true;
      int32_t p_task_id{};
      ActorTaskStopReason p_stop_reason{};
      WebClientHandler_StopActorTask_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_task_id = input_data_view.task_id();
      if (success && !input_data_view.ReadStopReason(&p_stop_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopActorTask(        
        std::move(p_task_id), 
        std::move(p_stop_reason));
      return true;
    }
    case messages::WebClientHandler::kPauseActorTask: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_PauseActorTask_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_PauseActorTask_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.22
      bool success = true;
      int32_t p_task_id{};
      ActorTaskPauseReason p_pause_reason{};
      WebClientHandler_PauseActorTask_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_task_id = input_data_view.task_id();
      if (success && !input_data_view.ReadPauseReason(&p_pause_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PauseActorTask(        
        std::move(p_task_id), 
        std::move(p_pause_reason));
      return true;
    }
    case messages::WebClientHandler::kResumeActorTask: {
      break;
    }
    case messages::WebClientHandler::kResizeWidget: {
      break;
    }
    case messages::WebClientHandler::kCaptureScreenshot: {
      break;
    }
    case messages::WebClientHandler::kSetAudioDucking: {
      break;
    }
    case messages::WebClientHandler::kSetPanelDraggableAreas: {
      break;
    }
    case messages::WebClientHandler::kSetMinimumPanelSize: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_SetMinimumPanelSize_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_SetMinimumPanelSize_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.28
      bool success = true;
      ::gfx::Size p_size{};
      WebClientHandler_SetMinimumPanelSize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 28, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMinimumPanelSize(        
        std::move(p_size));
      return true;
    }
    case messages::WebClientHandler::kSetMicrophonePermissionState: {
      break;
    }
    case messages::WebClientHandler::kSetLocationPermissionState: {
      break;
    }
    case messages::WebClientHandler::kSetTabContextPermissionState: {
      break;
    }
    case messages::WebClientHandler::kSetClosedCaptioningSetting: {
      break;
    }
    case messages::WebClientHandler::kShouldAllowMediaPermissionRequest: {
      break;
    }
    case messages::WebClientHandler::kShouldAllowGeolocationPermissionRequest: {
      break;
    }
    case messages::WebClientHandler::kSetContextAccessIndicator: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_SetContextAccessIndicator_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_SetContextAccessIndicator_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.35
      bool success = true;
      bool p_enabled{};
      WebClientHandler_SetContextAccessIndicator_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 35, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetContextAccessIndicator(        
        std::move(p_enabled));
      return true;
    }
    case messages::WebClientHandler::kGetUserProfileInfo: {
      break;
    }
    case messages::WebClientHandler::kSyncCookies: {
      break;
    }
    case messages::WebClientHandler::kLogBeginAsyncEvent: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_LogBeginAsyncEvent_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_LogBeginAsyncEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.38
      bool success = true;
      uint64_t p_event_async_id{};
      int32_t p_task_id{};
      std::string p_event{};
      std::string p_details{};
      WebClientHandler_LogBeginAsyncEvent_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_event_async_id = input_data_view.event_async_id();
      if (success)
        p_task_id = input_data_view.task_id();
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 38, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LogBeginAsyncEvent(        
        std::move(p_event_async_id), 
        std::move(p_task_id), 
        std::move(p_event), 
        std::move(p_details));
      return true;
    }
    case messages::WebClientHandler::kLogEndAsyncEvent: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_LogEndAsyncEvent_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_LogEndAsyncEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.39
      bool success = true;
      uint64_t p_event_async_id{};
      std::string p_details{};
      WebClientHandler_LogEndAsyncEvent_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_event_async_id = input_data_view.event_async_id();
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 39, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LogEndAsyncEvent(        
        std::move(p_event_async_id), 
        std::move(p_details));
      return true;
    }
    case messages::WebClientHandler::kLogInstantEvent: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_LogInstantEvent_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_LogInstantEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.40
      bool success = true;
      int32_t p_task_id{};
      std::string p_event{};
      std::string p_details{};
      WebClientHandler_LogInstantEvent_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_task_id = input_data_view.task_id();
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 40, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LogInstantEvent(        
        std::move(p_task_id), 
        std::move(p_event), 
        std::move(p_details));
      return true;
    }
    case messages::WebClientHandler::kJournalClear: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_JournalClear_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_JournalClear_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.41
      bool success = true;
      WebClientHandler_JournalClear_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 41, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JournalClear(        );
      return true;
    }
    case messages::WebClientHandler::kJournalSnapshot: {
      break;
    }
    case messages::WebClientHandler::kJournalStart: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_JournalStart_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_JournalStart_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.43
      bool success = true;
      uint64_t p_max_bytes{};
      bool p_capture_screenshots{};
      WebClientHandler_JournalStart_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_max_bytes = input_data_view.max_bytes();
      if (success)
        p_capture_screenshots = input_data_view.capture_screenshots();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 43, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JournalStart(        
        std::move(p_max_bytes), 
        std::move(p_capture_screenshots));
      return true;
    }
    case messages::WebClientHandler::kJournalStop: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_JournalStop_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_JournalStop_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.44
      bool success = true;
      WebClientHandler_JournalStop_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 44, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JournalStop(        );
      return true;
    }
    case messages::WebClientHandler::kJournalRecordFeedback: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_JournalRecordFeedback_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_JournalRecordFeedback_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.45
      bool success = true;
      bool p_positive{};
      std::string p_reason{};
      WebClientHandler_JournalRecordFeedback_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_positive = input_data_view.positive();
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 45, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JournalRecordFeedback(        
        std::move(p_positive), 
        std::move(p_reason));
      return true;
    }
    case messages::WebClientHandler::kOnUserInputSubmitted: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_OnUserInputSubmitted_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_OnUserInputSubmitted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.46
      bool success = true;
      WebClientMode p_mode{};
      WebClientHandler_OnUserInputSubmitted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 46, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnUserInputSubmitted(        
        std::move(p_mode));
      return true;
    }
    case messages::WebClientHandler::kOnContextUploadStarted: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_OnContextUploadStarted_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_OnContextUploadStarted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.47
      bool success = true;
      WebClientHandler_OnContextUploadStarted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 47, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnContextUploadStarted(        );
      return true;
    }
    case messages::WebClientHandler::kOnContextUploadCompleted: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_OnContextUploadCompleted_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_OnContextUploadCompleted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.48
      bool success = true;
      WebClientHandler_OnContextUploadCompleted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 48, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnContextUploadCompleted(        );
      return true;
    }
    case messages::WebClientHandler::kOnReaction: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_OnReaction_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_OnReaction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.49
      bool success = true;
      MetricUserInputReactionType p_reactionType{};
      WebClientHandler_OnReaction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReactionType(&p_reactionType))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 49, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReaction(        
        std::move(p_reactionType));
      return true;
    }
    case messages::WebClientHandler::kOnResponseStarted: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_OnResponseStarted_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_OnResponseStarted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.50
      bool success = true;
      WebClientHandler_OnResponseStarted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 50, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResponseStarted(        );
      return true;
    }
    case messages::WebClientHandler::kOnResponseStopped: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_OnResponseStopped_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_OnResponseStopped_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.51
      bool success = true;
      OnResponseStoppedDetailsPtr p_details{};
      WebClientHandler_OnResponseStopped_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 51, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResponseStopped(        
        std::move(p_details));
      return true;
    }
    case messages::WebClientHandler::kOnSessionTerminated: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_OnSessionTerminated_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_OnSessionTerminated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.52
      bool success = true;
      WebClientHandler_OnSessionTerminated_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 52, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSessionTerminated(        );
      return true;
    }
    case messages::WebClientHandler::kOnTurnCompleted: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_OnTurnCompleted_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_OnTurnCompleted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.53
      bool success = true;
      WebClientModel p_model{};
      ::base::TimeDelta p_duration{};
      WebClientHandler_OnTurnCompleted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModel(&p_model))
        success = false;
      if (success && !input_data_view.ReadDuration(&p_duration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 53, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTurnCompleted(        
        std::move(p_model), 
        std::move(p_duration));
      return true;
    }
    case messages::WebClientHandler::kOnModelChanged: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_OnModelChanged_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_OnModelChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.54
      bool success = true;
      WebClientModel p_model{};
      WebClientHandler_OnModelChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModel(&p_model))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 54, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnModelChanged(        
        std::move(p_model));
      return true;
    }
    case messages::WebClientHandler::kOnResponseRated: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_OnResponseRated_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_OnResponseRated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.55
      bool success = true;
      bool p_positive{};
      WebClientHandler_OnResponseRated_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_positive = input_data_view.positive();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 55, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResponseRated(        
        std::move(p_positive));
      return true;
    }
    case messages::WebClientHandler::kOnClosedCaptionsShown: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_OnClosedCaptionsShown_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_OnClosedCaptionsShown_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.56
      bool success = true;
      WebClientHandler_OnClosedCaptionsShown_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 56, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnClosedCaptionsShown(        );
      return true;
    }
    case messages::WebClientHandler::kScrollTo: {
      break;
    }
    case messages::WebClientHandler::kDropScrollToHighlight: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_DropScrollToHighlight_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_DropScrollToHighlight_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.58
      bool success = true;
      WebClientHandler_DropScrollToHighlight_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 58, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DropScrollToHighlight(        );
      return true;
    }
    case messages::WebClientHandler::kSetSyntheticExperimentState: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_SetSyntheticExperimentState_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_SetSyntheticExperimentState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.59
      bool success = true;
      std::string p_trial_name{};
      std::string p_group_name{};
      WebClientHandler_SetSyntheticExperimentState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTrialName(&p_trial_name))
        success = false;
      if (success && !input_data_view.ReadGroupName(&p_group_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 59, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSyntheticExperimentState(        
        std::move(p_trial_name), 
        std::move(p_group_name));
      return true;
    }
    case messages::WebClientHandler::kOpenOsPermissionSettingsMenu: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_OpenOsPermissionSettingsMenu_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_OpenOsPermissionSettingsMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.60
      bool success = true;
      ::content_settings::mojom::ContentSettingsType p_type{};
      WebClientHandler_OpenOsPermissionSettingsMenu_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 60, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenOsPermissionSettingsMenu(        
        std::move(p_type));
      return true;
    }
    case messages::WebClientHandler::kGetOsMicrophonePermissionStatus: {
      break;
    }
    case messages::WebClientHandler::kGetZeroStateSuggestionsAndSubscribe: {
      break;
    }
    case messages::WebClientHandler::kGetZeroStateSuggestionsForFocusedTab: {
      break;
    }
    case messages::WebClientHandler::kMaybeRefreshUserStatus: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_MaybeRefreshUserStatus_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_MaybeRefreshUserStatus_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.64
      bool success = true;
      WebClientHandler_MaybeRefreshUserStatus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 64, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MaybeRefreshUserStatus(        );
      return true;
    }
    case messages::WebClientHandler::kIsDebuggerAttached: {
      break;
    }
    case messages::WebClientHandler::kOnViewChanged: {
      DCHECK(message->is_serialized());
      internal::WebClientHandler_OnViewChanged_Params_Data* params =
          reinterpret_cast<internal::WebClientHandler_OnViewChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClientHandler.66
      bool success = true;
      ViewChangedNotificationPtr p_notification{};
      WebClientHandler_OnViewChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNotification(&p_notification))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 66, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnViewChanged(        
        std::move(p_notification));
      return true;
    }
    case messages::WebClientHandler::kSubscribeToPageMetadata: {
      break;
    }
    case messages::WebClientHandler::kSwitchConversation: {
      break;
    }
    case messages::WebClientHandler::kRegisterConversation: {
      break;
    }
  }
  return false;
}

// static
bool WebClientHandlerStubDispatch::AcceptWithResponder(
    WebClientHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebClientHandler>(message->header()->name)) {
    case messages::WebClientHandler::kWebClientCreated: {
      internal::WebClientHandler_WebClientCreated_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_WebClientCreated_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.0
      bool success = true;
      ::mojo::PendingRemote<WebClient> p_web_client{};
      WebClientHandler_WebClientCreated_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_web_client =
            input_data_view.TakeWebClient<decltype(p_web_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          WebClientHandler_WebClientCreated_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WebClientCreated(        
        std::move(p_web_client), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kWebClientInitialized: {
      break;
    }
    case messages::WebClientHandler::kWebClientInitializeFailed: {
      break;
    }
    case messages::WebClientHandler::kCreateTab: {
      internal::WebClientHandler_CreateTab_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_CreateTab_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.3
      bool success = true;
      ::GURL p_url{};
      bool p_open_in_background{};
      std::optional<int32_t> p_window_id{};
      WebClientHandler_CreateTab_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_open_in_background = input_data_view.open_in_background();
      if (success) {
        p_window_id = input_data_view.window_id();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          WebClientHandler_CreateTab_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateTab(        
        std::move(p_url), 
        std::move(p_open_in_background), 
        std::move(p_window_id), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kOpenGlicSettingsPage: {
      break;
    }
    case messages::WebClientHandler::kClosePanel: {
      break;
    }
    case messages::WebClientHandler::kClosePanelAndShutdown: {
      break;
    }
    case messages::WebClientHandler::kAttachPanel: {
      break;
    }
    case messages::WebClientHandler::kDetachPanel: {
      break;
    }
    case messages::WebClientHandler::kShowProfilePicker: {
      break;
    }
    case messages::WebClientHandler::kGetModelQualityClientId: {
      internal::WebClientHandler_GetModelQualityClientId_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_GetModelQualityClientId_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.10
      bool success = true;
      WebClientHandler_GetModelQualityClientId_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 10, false);
        return false;
      }
      auto callback =
          WebClientHandler_GetModelQualityClientId_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetModelQualityClientId(std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kGetContextFromFocusedTab: {
      internal::WebClientHandler_GetContextFromFocusedTab_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_GetContextFromFocusedTab_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.11
      bool success = true;
      GetTabContextOptionsPtr p_options{};
      WebClientHandler_GetContextFromFocusedTab_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 11, false);
        return false;
      }
      auto callback =
          WebClientHandler_GetContextFromFocusedTab_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetContextFromFocusedTab(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kGetContextFromTab: {
      internal::WebClientHandler_GetContextFromTab_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_GetContextFromTab_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.12
      bool success = true;
      int32_t p_tab_id{};
      GetTabContextOptionsPtr p_options{};
      WebClientHandler_GetContextFromTab_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 12, false);
        return false;
      }
      auto callback =
          WebClientHandler_GetContextFromTab_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetContextFromTab(        
        std::move(p_tab_id), 
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kGetContextForActorFromTab: {
      internal::WebClientHandler_GetContextForActorFromTab_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_GetContextForActorFromTab_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.13
      bool success = true;
      int32_t p_tab_id{};
      GetTabContextOptionsPtr p_options{};
      WebClientHandler_GetContextForActorFromTab_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 13, false);
        return false;
      }
      auto callback =
          WebClientHandler_GetContextForActorFromTab_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetContextForActorFromTab(        
        std::move(p_tab_id), 
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kSetMaximumNumberOfPinnedTabs: {
      internal::WebClientHandler_SetMaximumNumberOfPinnedTabs_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_SetMaximumNumberOfPinnedTabs_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.14
      bool success = true;
      uint32_t p_requested_max{};
      WebClientHandler_SetMaximumNumberOfPinnedTabs_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_requested_max = input_data_view.requested_max();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 14, false);
        return false;
      }
      auto callback =
          WebClientHandler_SetMaximumNumberOfPinnedTabs_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMaximumNumberOfPinnedTabs(        
        std::move(p_requested_max), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kPinTabs: {
      internal::WebClientHandler_PinTabs_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_PinTabs_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.15
      bool success = true;
      std::vector<int32_t> p_tab_ids{};
      WebClientHandler_PinTabs_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTabIds(&p_tab_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 15, false);
        return false;
      }
      auto callback =
          WebClientHandler_PinTabs_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PinTabs(        
        std::move(p_tab_ids), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kUnpinTabs: {
      internal::WebClientHandler_UnpinTabs_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_UnpinTabs_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.16
      bool success = true;
      std::vector<int32_t> p_tab_ids{};
      WebClientHandler_UnpinTabs_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTabIds(&p_tab_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 16, false);
        return false;
      }
      auto callback =
          WebClientHandler_UnpinTabs_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnpinTabs(        
        std::move(p_tab_ids), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kUnpinAllTabs: {
      break;
    }
    case messages::WebClientHandler::kSubscribeToPinCandidates: {
      break;
    }
    case messages::WebClientHandler::kCreateTask: {
      internal::WebClientHandler_CreateTask_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_CreateTask_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.19
      bool success = true;
      ::actor::webui::mojom::TaskOptionsPtr p_task_options{};
      WebClientHandler_CreateTask_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTaskOptions(&p_task_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 19, false);
        return false;
      }
      auto callback =
          WebClientHandler_CreateTask_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateTask(        
        std::move(p_task_options), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kPerformActions: {
      internal::WebClientHandler_PerformActions_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_PerformActions_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.20
      bool success = true;
      std::vector<uint8_t> p_actions_proto{};
      WebClientHandler_PerformActions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadActionsProto(&p_actions_proto))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 20, false);
        return false;
      }
      auto callback =
          WebClientHandler_PerformActions_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PerformActions(        
        std::move(p_actions_proto), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kStopActorTask: {
      break;
    }
    case messages::WebClientHandler::kPauseActorTask: {
      break;
    }
    case messages::WebClientHandler::kResumeActorTask: {
      internal::WebClientHandler_ResumeActorTask_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_ResumeActorTask_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.23
      bool success = true;
      int32_t p_task_id{};
      GetTabContextOptionsPtr p_context_options{};
      WebClientHandler_ResumeActorTask_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_task_id = input_data_view.task_id();
      if (success && !input_data_view.ReadContextOptions(&p_context_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 23, false);
        return false;
      }
      auto callback =
          WebClientHandler_ResumeActorTask_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResumeActorTask(        
        std::move(p_task_id), 
        std::move(p_context_options), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kResizeWidget: {
      internal::WebClientHandler_ResizeWidget_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_ResizeWidget_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.24
      bool success = true;
      ::gfx::Size p_size{};
      ::base::TimeDelta p_duration{};
      WebClientHandler_ResizeWidget_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (success && !input_data_view.ReadDuration(&p_duration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 24, false);
        return false;
      }
      auto callback =
          WebClientHandler_ResizeWidget_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResizeWidget(        
        std::move(p_size), 
        std::move(p_duration), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kCaptureScreenshot: {
      internal::WebClientHandler_CaptureScreenshot_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_CaptureScreenshot_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.25
      bool success = true;
      WebClientHandler_CaptureScreenshot_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 25, false);
        return false;
      }
      auto callback =
          WebClientHandler_CaptureScreenshot_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CaptureScreenshot(std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kSetAudioDucking: {
      internal::WebClientHandler_SetAudioDucking_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_SetAudioDucking_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.26
      bool success = true;
      bool p_enable{};
      WebClientHandler_SetAudioDucking_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enable = input_data_view.enable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 26, false);
        return false;
      }
      auto callback =
          WebClientHandler_SetAudioDucking_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAudioDucking(        
        std::move(p_enable), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kSetPanelDraggableAreas: {
      internal::WebClientHandler_SetPanelDraggableAreas_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_SetPanelDraggableAreas_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.27
      bool success = true;
      std::vector<::gfx::Rect> p_draggable_areas{};
      WebClientHandler_SetPanelDraggableAreas_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDraggableAreas(&p_draggable_areas))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 27, false);
        return false;
      }
      auto callback =
          WebClientHandler_SetPanelDraggableAreas_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPanelDraggableAreas(        
        std::move(p_draggable_areas), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kSetMinimumPanelSize: {
      break;
    }
    case messages::WebClientHandler::kSetMicrophonePermissionState: {
      internal::WebClientHandler_SetMicrophonePermissionState_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_SetMicrophonePermissionState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.29
      bool success = true;
      bool p_enabled{};
      WebClientHandler_SetMicrophonePermissionState_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 29, false);
        return false;
      }
      auto callback =
          WebClientHandler_SetMicrophonePermissionState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMicrophonePermissionState(        
        std::move(p_enabled), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kSetLocationPermissionState: {
      internal::WebClientHandler_SetLocationPermissionState_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_SetLocationPermissionState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.30
      bool success = true;
      bool p_enabled{};
      WebClientHandler_SetLocationPermissionState_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 30, false);
        return false;
      }
      auto callback =
          WebClientHandler_SetLocationPermissionState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetLocationPermissionState(        
        std::move(p_enabled), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kSetTabContextPermissionState: {
      internal::WebClientHandler_SetTabContextPermissionState_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_SetTabContextPermissionState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.31
      bool success = true;
      bool p_enabled{};
      WebClientHandler_SetTabContextPermissionState_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 31, false);
        return false;
      }
      auto callback =
          WebClientHandler_SetTabContextPermissionState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTabContextPermissionState(        
        std::move(p_enabled), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kSetClosedCaptioningSetting: {
      internal::WebClientHandler_SetClosedCaptioningSetting_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_SetClosedCaptioningSetting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.32
      bool success = true;
      bool p_enabled{};
      WebClientHandler_SetClosedCaptioningSetting_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 32, false);
        return false;
      }
      auto callback =
          WebClientHandler_SetClosedCaptioningSetting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClosedCaptioningSetting(        
        std::move(p_enabled), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kShouldAllowMediaPermissionRequest: {
      internal::WebClientHandler_ShouldAllowMediaPermissionRequest_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_ShouldAllowMediaPermissionRequest_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.33
      bool success = true;
      WebClientHandler_ShouldAllowMediaPermissionRequest_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 33, false);
        return false;
      }
      auto callback =
          WebClientHandler_ShouldAllowMediaPermissionRequest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShouldAllowMediaPermissionRequest(std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kShouldAllowGeolocationPermissionRequest: {
      internal::WebClientHandler_ShouldAllowGeolocationPermissionRequest_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_ShouldAllowGeolocationPermissionRequest_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.34
      bool success = true;
      WebClientHandler_ShouldAllowGeolocationPermissionRequest_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 34, false);
        return false;
      }
      auto callback =
          WebClientHandler_ShouldAllowGeolocationPermissionRequest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShouldAllowGeolocationPermissionRequest(std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kSetContextAccessIndicator: {
      break;
    }
    case messages::WebClientHandler::kGetUserProfileInfo: {
      internal::WebClientHandler_GetUserProfileInfo_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_GetUserProfileInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.36
      bool success = true;
      WebClientHandler_GetUserProfileInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 36, false);
        return false;
      }
      auto callback =
          WebClientHandler_GetUserProfileInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUserProfileInfo(std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kSyncCookies: {
      internal::WebClientHandler_SyncCookies_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_SyncCookies_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.37
      bool success = true;
      WebClientHandler_SyncCookies_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 37, false);
        return false;
      }
      auto callback =
          WebClientHandler_SyncCookies_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SyncCookies(std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kLogBeginAsyncEvent: {
      break;
    }
    case messages::WebClientHandler::kLogEndAsyncEvent: {
      break;
    }
    case messages::WebClientHandler::kLogInstantEvent: {
      break;
    }
    case messages::WebClientHandler::kJournalClear: {
      break;
    }
    case messages::WebClientHandler::kJournalSnapshot: {
      internal::WebClientHandler_JournalSnapshot_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_JournalSnapshot_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.42
      bool success = true;
      bool p_clear_journal{};
      WebClientHandler_JournalSnapshot_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_clear_journal = input_data_view.clear_journal();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 42, false);
        return false;
      }
      auto callback =
          WebClientHandler_JournalSnapshot_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JournalSnapshot(        
        std::move(p_clear_journal), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kJournalStart: {
      break;
    }
    case messages::WebClientHandler::kJournalStop: {
      break;
    }
    case messages::WebClientHandler::kJournalRecordFeedback: {
      break;
    }
    case messages::WebClientHandler::kOnUserInputSubmitted: {
      break;
    }
    case messages::WebClientHandler::kOnContextUploadStarted: {
      break;
    }
    case messages::WebClientHandler::kOnContextUploadCompleted: {
      break;
    }
    case messages::WebClientHandler::kOnReaction: {
      break;
    }
    case messages::WebClientHandler::kOnResponseStarted: {
      break;
    }
    case messages::WebClientHandler::kOnResponseStopped: {
      break;
    }
    case messages::WebClientHandler::kOnSessionTerminated: {
      break;
    }
    case messages::WebClientHandler::kOnTurnCompleted: {
      break;
    }
    case messages::WebClientHandler::kOnModelChanged: {
      break;
    }
    case messages::WebClientHandler::kOnResponseRated: {
      break;
    }
    case messages::WebClientHandler::kOnClosedCaptionsShown: {
      break;
    }
    case messages::WebClientHandler::kScrollTo: {
      internal::WebClientHandler_ScrollTo_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_ScrollTo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.57
      bool success = true;
      ScrollToParamsPtr p_params{};
      WebClientHandler_ScrollTo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 57, false);
        return false;
      }
      auto callback =
          WebClientHandler_ScrollTo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScrollTo(        
        std::move(p_params), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kDropScrollToHighlight: {
      break;
    }
    case messages::WebClientHandler::kSetSyntheticExperimentState: {
      break;
    }
    case messages::WebClientHandler::kOpenOsPermissionSettingsMenu: {
      break;
    }
    case messages::WebClientHandler::kGetOsMicrophonePermissionStatus: {
      internal::WebClientHandler_GetOsMicrophonePermissionStatus_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_GetOsMicrophonePermissionStatus_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.61
      bool success = true;
      WebClientHandler_GetOsMicrophonePermissionStatus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 61, false);
        return false;
      }
      auto callback =
          WebClientHandler_GetOsMicrophonePermissionStatus_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetOsMicrophonePermissionStatus(std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kGetZeroStateSuggestionsAndSubscribe: {
      internal::WebClientHandler_GetZeroStateSuggestionsAndSubscribe_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_GetZeroStateSuggestionsAndSubscribe_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.62
      bool success = true;
      bool p_is_live{};
      ZeroStateSuggestionsOptionsPtr p_options{};
      WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_live = input_data_view.is_live();
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 62, false);
        return false;
      }
      auto callback =
          WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetZeroStateSuggestionsAndSubscribe(        
        std::move(p_is_live), 
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kGetZeroStateSuggestionsForFocusedTab: {
      internal::WebClientHandler_GetZeroStateSuggestionsForFocusedTab_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_GetZeroStateSuggestionsForFocusedTab_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.63
      bool success = true;
      std::optional<bool> p_is_first_run{};
      WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_is_first_run = input_data_view.is_first_run();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 63, false);
        return false;
      }
      auto callback =
          WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetZeroStateSuggestionsForFocusedTab(        
        std::move(p_is_first_run), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kMaybeRefreshUserStatus: {
      break;
    }
    case messages::WebClientHandler::kIsDebuggerAttached: {
      internal::WebClientHandler_IsDebuggerAttached_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_IsDebuggerAttached_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.65
      bool success = true;
      WebClientHandler_IsDebuggerAttached_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 65, false);
        return false;
      }
      auto callback =
          WebClientHandler_IsDebuggerAttached_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsDebuggerAttached(std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kOnViewChanged: {
      break;
    }
    case messages::WebClientHandler::kSubscribeToPageMetadata: {
      internal::WebClientHandler_SubscribeToPageMetadata_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_SubscribeToPageMetadata_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.67
      bool success = true;
      int32_t p_tab_id{};
      std::vector<std::string> p_names{};
      WebClientHandler_SubscribeToPageMetadata_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success && !input_data_view.ReadNames(&p_names))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 67, false);
        return false;
      }
      auto callback =
          WebClientHandler_SubscribeToPageMetadata_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubscribeToPageMetadata(        
        std::move(p_tab_id), 
        std::move(p_names), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kSwitchConversation: {
      internal::WebClientHandler_SwitchConversation_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_SwitchConversation_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.68
      bool success = true;
      ConversationInfoPtr p_info{};
      WebClientHandler_SwitchConversation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 68, false);
        return false;
      }
      auto callback =
          WebClientHandler_SwitchConversation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SwitchConversation(        
        std::move(p_info), std::move(callback));
      return true;
    }
    case messages::WebClientHandler::kRegisterConversation: {
      internal::WebClientHandler_RegisterConversation_Params_Data* params =
          reinterpret_cast<
              internal::WebClientHandler_RegisterConversation_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClientHandler.69
      bool success = true;
      ConversationInfoPtr p_info{};
      WebClientHandler_RegisterConversation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClientHandler::Name_, 69, false);
        return false;
      }
      auto callback =
          WebClientHandler_RegisterConversation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterConversation(        
        std::move(p_info), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {

bool ValidateWithRuntimeFeature_WebClientHandler_GetModelQualityClientId(
  const void* data, mojo::internal::ValidationContext* validation_context) {
  if (!base::FeatureList::IsEnabled(::glic::mojom::features::kGlicAppendModelQualityClientId)) {
    return false;
  }
  return internal::WebClientHandler_GetModelQualityClientId_Params_Data::Validate(
    data, validation_context);
}

bool ValidateWithRuntimeFeature_WebClientHandler_GetContextFromTab(
  const void* data, mojo::internal::ValidationContext* validation_context) {
  if (!base::FeatureList::IsEnabled(::glic::mojom::features::kGlicMultiTab)) {
    return false;
  }
  return internal::WebClientHandler_GetContextFromTab_Params_Data::Validate(
    data, validation_context);
}

bool ValidateWithRuntimeFeature_WebClientHandler_GetContextForActorFromTab(
  const void* data, mojo::internal::ValidationContext* validation_context) {
  if (!base::FeatureList::IsEnabled(::glic::mojom::features::kGlicActorTabContext)) {
    return false;
  }
  return internal::WebClientHandler_GetContextForActorFromTab_Params_Data::Validate(
    data, validation_context);
}

bool ValidateWithRuntimeFeature_WebClientHandler_SetMaximumNumberOfPinnedTabs(
  const void* data, mojo::internal::ValidationContext* validation_context) {
  if (!base::FeatureList::IsEnabled(::glic::mojom::features::kGlicMultiTab)) {
    return false;
  }
  return internal::WebClientHandler_SetMaximumNumberOfPinnedTabs_Params_Data::Validate(
    data, validation_context);
}

bool ValidateWithRuntimeFeature_WebClientHandler_PinTabs(
  const void* data, mojo::internal::ValidationContext* validation_context) {
  if (!base::FeatureList::IsEnabled(::glic::mojom::features::kGlicMultiTab)) {
    return false;
  }
  return internal::WebClientHandler_PinTabs_Params_Data::Validate(
    data, validation_context);
}

bool ValidateWithRuntimeFeature_WebClientHandler_UnpinTabs(
  const void* data, mojo::internal::ValidationContext* validation_context) {
  if (!base::FeatureList::IsEnabled(::glic::mojom::features::kGlicMultiTab)) {
    return false;
  }
  return internal::WebClientHandler_UnpinTabs_Params_Data::Validate(
    data, validation_context);
}

bool ValidateWithRuntimeFeature_WebClientHandler_UnpinAllTabs(
  const void* data, mojo::internal::ValidationContext* validation_context) {
  if (!base::FeatureList::IsEnabled(::glic::mojom::features::kGlicMultiTab)) {
    return false;
  }
  return internal::WebClientHandler_UnpinAllTabs_Params_Data::Validate(
    data, validation_context);
}

bool ValidateWithRuntimeFeature_WebClientHandler_SubscribeToPinCandidates(
  const void* data, mojo::internal::ValidationContext* validation_context) {
  if (!base::FeatureList::IsEnabled(::glic::mojom::features::kGlicMultiTab)) {
    return false;
  }
  return internal::WebClientHandler_SubscribeToPinCandidates_Params_Data::Validate(
    data, validation_context);
}

bool ValidateWithRuntimeFeature_WebClientHandler_GetZeroStateSuggestionsAndSubscribe(
  const void* data, mojo::internal::ValidationContext* validation_context) {
  if (!base::FeatureList::IsEnabled(::glic::mojom::features::kZeroStateSuggestionsV2)) {
    return false;
  }
  return internal::WebClientHandler_GetZeroStateSuggestionsAndSubscribe_Params_Data::Validate(
    data, validation_context);
}
}  // namespace
static const mojo::internal::GenericValidationInfo kWebClientHandlerValidationInfo[] = {
    { &internal::WebClientHandler_WebClientCreated_Params_Data::Validate,
     &internal::WebClientHandler_WebClientCreated_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_WebClientInitialized_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_WebClientInitializeFailed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_CreateTab_Params_Data::Validate,
     &internal::WebClientHandler_CreateTab_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_OpenGlicSettingsPage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_ClosePanel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_ClosePanelAndShutdown_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_AttachPanel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_DetachPanel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_ShowProfilePicker_Params_Data::Validate,
     nullptr /* no response */},
    { &ValidateWithRuntimeFeature_WebClientHandler_GetModelQualityClientId,
     &internal::WebClientHandler_GetModelQualityClientId_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_GetContextFromFocusedTab_Params_Data::Validate,
     &internal::WebClientHandler_GetContextFromFocusedTab_ResponseParams_Data::Validate},
    { &ValidateWithRuntimeFeature_WebClientHandler_GetContextFromTab,
     &internal::WebClientHandler_GetContextFromTab_ResponseParams_Data::Validate},
    { &ValidateWithRuntimeFeature_WebClientHandler_GetContextForActorFromTab,
     &internal::WebClientHandler_GetContextForActorFromTab_ResponseParams_Data::Validate},
    { &ValidateWithRuntimeFeature_WebClientHandler_SetMaximumNumberOfPinnedTabs,
     &internal::WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParams_Data::Validate},
    { &ValidateWithRuntimeFeature_WebClientHandler_PinTabs,
     &internal::WebClientHandler_PinTabs_ResponseParams_Data::Validate},
    { &ValidateWithRuntimeFeature_WebClientHandler_UnpinTabs,
     &internal::WebClientHandler_UnpinTabs_ResponseParams_Data::Validate},
    { &ValidateWithRuntimeFeature_WebClientHandler_UnpinAllTabs,
     nullptr /* no response */},
    { &ValidateWithRuntimeFeature_WebClientHandler_SubscribeToPinCandidates,
     nullptr /* no response */},
    { &internal::WebClientHandler_CreateTask_Params_Data::Validate,
     &internal::WebClientHandler_CreateTask_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_PerformActions_Params_Data::Validate,
     &internal::WebClientHandler_PerformActions_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_StopActorTask_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_PauseActorTask_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_ResumeActorTask_Params_Data::Validate,
     &internal::WebClientHandler_ResumeActorTask_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_ResizeWidget_Params_Data::Validate,
     &internal::WebClientHandler_ResizeWidget_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_CaptureScreenshot_Params_Data::Validate,
     &internal::WebClientHandler_CaptureScreenshot_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_SetAudioDucking_Params_Data::Validate,
     &internal::WebClientHandler_SetAudioDucking_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_SetPanelDraggableAreas_Params_Data::Validate,
     &internal::WebClientHandler_SetPanelDraggableAreas_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_SetMinimumPanelSize_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_SetMicrophonePermissionState_Params_Data::Validate,
     &internal::WebClientHandler_SetMicrophonePermissionState_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_SetLocationPermissionState_Params_Data::Validate,
     &internal::WebClientHandler_SetLocationPermissionState_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_SetTabContextPermissionState_Params_Data::Validate,
     &internal::WebClientHandler_SetTabContextPermissionState_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_SetClosedCaptioningSetting_Params_Data::Validate,
     &internal::WebClientHandler_SetClosedCaptioningSetting_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_ShouldAllowMediaPermissionRequest_Params_Data::Validate,
     &internal::WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_ShouldAllowGeolocationPermissionRequest_Params_Data::Validate,
     &internal::WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_SetContextAccessIndicator_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_GetUserProfileInfo_Params_Data::Validate,
     &internal::WebClientHandler_GetUserProfileInfo_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_SyncCookies_Params_Data::Validate,
     &internal::WebClientHandler_SyncCookies_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_LogBeginAsyncEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_LogEndAsyncEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_LogInstantEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_JournalClear_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_JournalSnapshot_Params_Data::Validate,
     &internal::WebClientHandler_JournalSnapshot_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_JournalStart_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_JournalStop_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_JournalRecordFeedback_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_OnUserInputSubmitted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_OnContextUploadStarted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_OnContextUploadCompleted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_OnReaction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_OnResponseStarted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_OnResponseStopped_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_OnSessionTerminated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_OnTurnCompleted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_OnModelChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_OnResponseRated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_OnClosedCaptionsShown_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_ScrollTo_Params_Data::Validate,
     &internal::WebClientHandler_ScrollTo_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_DropScrollToHighlight_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_SetSyntheticExperimentState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_OpenOsPermissionSettingsMenu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_GetOsMicrophonePermissionStatus_Params_Data::Validate,
     &internal::WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParams_Data::Validate},
    { &ValidateWithRuntimeFeature_WebClientHandler_GetZeroStateSuggestionsAndSubscribe,
     &internal::WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_GetZeroStateSuggestionsForFocusedTab_Params_Data::Validate,
     &internal::WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_MaybeRefreshUserStatus_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_IsDebuggerAttached_Params_Data::Validate,
     &internal::WebClientHandler_IsDebuggerAttached_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_OnViewChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClientHandler_SubscribeToPageMetadata_Params_Data::Validate,
     &internal::WebClientHandler_SubscribeToPageMetadata_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_SwitchConversation_Params_Data::Validate,
     &internal::WebClientHandler_SwitchConversation_ResponseParams_Data::Validate},
    { &internal::WebClientHandler_RegisterConversation_Params_Data::Validate,
     &internal::WebClientHandler_RegisterConversation_ResponseParams_Data::Validate},
};

bool WebClientHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::glic::mojom::WebClientHandler::Name_,
    kWebClientHandlerValidationInfo);
}

bool WebClientHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::glic::mojom::WebClientHandler::Name_,
    kWebClientHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

WebClient::IPCStableHashFunction WebClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebClient>(message.name())) {
    case messages::WebClient::kNotifyPanelWillOpen: {
      return &WebClient::NotifyPanelWillOpen_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyPanelWasClosed: {
      return &WebClient::NotifyPanelWasClosed_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyPanelStateChange: {
      return &WebClient::NotifyPanelStateChange_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyPanelActiveChange: {
      return &WebClient::NotifyPanelActiveChange_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyPanelCanAttachChange: {
      return &WebClient::NotifyPanelCanAttachChange_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyMicrophonePermissionStateChanged: {
      return &WebClient::NotifyMicrophonePermissionStateChanged_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyLocationPermissionStateChanged: {
      return &WebClient::NotifyLocationPermissionStateChanged_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyTabContextPermissionStateChanged: {
      return &WebClient::NotifyTabContextPermissionStateChanged_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyOsLocationPermissionStateChanged: {
      return &WebClient::NotifyOsLocationPermissionStateChanged_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyFocusedTabChanged: {
      return &WebClient::NotifyFocusedTabChanged_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyManualResizeChanged: {
      return &WebClient::NotifyManualResizeChanged_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyOsHotkeyStateChanged: {
      return &WebClient::NotifyOsHotkeyStateChanged_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyBrowserIsOpenChanged: {
      return &WebClient::NotifyBrowserIsOpenChanged_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyBrowserIsActiveChanged: {
      return &WebClient::NotifyBrowserIsActiveChanged_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyActiveBrowserChanged: {
      return &WebClient::NotifyActiveBrowserChanged_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyClosedCaptioningSettingChanged: {
      return &WebClient::NotifyClosedCaptioningSettingChanged_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyPinnedTabsChanged: {
      return &WebClient::NotifyPinnedTabsChanged_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyPinnedTabDataChanged: {
      return &WebClient::NotifyPinnedTabDataChanged_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyZeroStateSuggestionsChanged: {
      return &WebClient::NotifyZeroStateSuggestionsChanged_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyActorTaskStateChanged: {
      return &WebClient::NotifyActorTaskStateChanged_Sym::IPCStableHash;
    }
    case messages::WebClient::kRequestViewChange: {
      return &WebClient::RequestViewChange_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyPageMetadataChanged: {
      return &WebClient::NotifyPageMetadataChanged_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyDefaultTabContextPermissionStateChanged: {
      return &WebClient::NotifyDefaultTabContextPermissionStateChanged_Sym::IPCStableHash;
    }
    case messages::WebClient::kRequestToShowCredentialSelectionDialog: {
      return &WebClient::RequestToShowCredentialSelectionDialog_Sym::IPCStableHash;
    }
    case messages::WebClient::kRequestToShowUserConfirmationDialog: {
      return &WebClient::RequestToShowUserConfirmationDialog_Sym::IPCStableHash;
    }
    case messages::WebClient::kNotifyAdditionalContext: {
      return &WebClient::NotifyAdditionalContext_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebClient>(message.name())) {
      case messages::WebClient::kNotifyPanelWillOpen:
            return "Receive glic::mojom::WebClient::NotifyPanelWillOpen";
      case messages::WebClient::kNotifyPanelWasClosed:
            return "Receive glic::mojom::WebClient::NotifyPanelWasClosed";
      case messages::WebClient::kNotifyPanelStateChange:
            return "Receive glic::mojom::WebClient::NotifyPanelStateChange";
      case messages::WebClient::kNotifyPanelActiveChange:
            return "Receive glic::mojom::WebClient::NotifyPanelActiveChange";
      case messages::WebClient::kNotifyPanelCanAttachChange:
            return "Receive glic::mojom::WebClient::NotifyPanelCanAttachChange";
      case messages::WebClient::kNotifyMicrophonePermissionStateChanged:
            return "Receive glic::mojom::WebClient::NotifyMicrophonePermissionStateChanged";
      case messages::WebClient::kNotifyLocationPermissionStateChanged:
            return "Receive glic::mojom::WebClient::NotifyLocationPermissionStateChanged";
      case messages::WebClient::kNotifyTabContextPermissionStateChanged:
            return "Receive glic::mojom::WebClient::NotifyTabContextPermissionStateChanged";
      case messages::WebClient::kNotifyOsLocationPermissionStateChanged:
            return "Receive glic::mojom::WebClient::NotifyOsLocationPermissionStateChanged";
      case messages::WebClient::kNotifyFocusedTabChanged:
            return "Receive glic::mojom::WebClient::NotifyFocusedTabChanged";
      case messages::WebClient::kNotifyManualResizeChanged:
            return "Receive glic::mojom::WebClient::NotifyManualResizeChanged";
      case messages::WebClient::kNotifyOsHotkeyStateChanged:
            return "Receive glic::mojom::WebClient::NotifyOsHotkeyStateChanged";
      case messages::WebClient::kNotifyBrowserIsOpenChanged:
            return "Receive glic::mojom::WebClient::NotifyBrowserIsOpenChanged";
      case messages::WebClient::kNotifyBrowserIsActiveChanged:
            return "Receive glic::mojom::WebClient::NotifyBrowserIsActiveChanged";
      case messages::WebClient::kNotifyActiveBrowserChanged:
            return "Receive glic::mojom::WebClient::NotifyActiveBrowserChanged";
      case messages::WebClient::kNotifyClosedCaptioningSettingChanged:
            return "Receive glic::mojom::WebClient::NotifyClosedCaptioningSettingChanged";
      case messages::WebClient::kNotifyPinnedTabsChanged:
            return "Receive glic::mojom::WebClient::NotifyPinnedTabsChanged";
      case messages::WebClient::kNotifyPinnedTabDataChanged:
            return "Receive glic::mojom::WebClient::NotifyPinnedTabDataChanged";
      case messages::WebClient::kNotifyZeroStateSuggestionsChanged:
            return "Receive glic::mojom::WebClient::NotifyZeroStateSuggestionsChanged";
      case messages::WebClient::kNotifyActorTaskStateChanged:
            return "Receive glic::mojom::WebClient::NotifyActorTaskStateChanged";
      case messages::WebClient::kRequestViewChange:
            return "Receive glic::mojom::WebClient::RequestViewChange";
      case messages::WebClient::kNotifyPageMetadataChanged:
            return "Receive glic::mojom::WebClient::NotifyPageMetadataChanged";
      case messages::WebClient::kNotifyDefaultTabContextPermissionStateChanged:
            return "Receive glic::mojom::WebClient::NotifyDefaultTabContextPermissionStateChanged";
      case messages::WebClient::kRequestToShowCredentialSelectionDialog:
            return "Receive glic::mojom::WebClient::RequestToShowCredentialSelectionDialog";
      case messages::WebClient::kRequestToShowUserConfirmationDialog:
            return "Receive glic::mojom::WebClient::RequestToShowUserConfirmationDialog";
      case messages::WebClient::kNotifyAdditionalContext:
            return "Receive glic::mojom::WebClient::NotifyAdditionalContext";
    }
  } else {
    switch (static_cast<messages::WebClient>(message.name())) {
      case messages::WebClient::kNotifyPanelWillOpen:
            return "Receive reply glic::mojom::WebClient::NotifyPanelWillOpen";
      case messages::WebClient::kNotifyPanelWasClosed:
            return "Receive reply glic::mojom::WebClient::NotifyPanelWasClosed";
      case messages::WebClient::kNotifyPanelStateChange:
            return "Receive reply glic::mojom::WebClient::NotifyPanelStateChange";
      case messages::WebClient::kNotifyPanelActiveChange:
            return "Receive reply glic::mojom::WebClient::NotifyPanelActiveChange";
      case messages::WebClient::kNotifyPanelCanAttachChange:
            return "Receive reply glic::mojom::WebClient::NotifyPanelCanAttachChange";
      case messages::WebClient::kNotifyMicrophonePermissionStateChanged:
            return "Receive reply glic::mojom::WebClient::NotifyMicrophonePermissionStateChanged";
      case messages::WebClient::kNotifyLocationPermissionStateChanged:
            return "Receive reply glic::mojom::WebClient::NotifyLocationPermissionStateChanged";
      case messages::WebClient::kNotifyTabContextPermissionStateChanged:
            return "Receive reply glic::mojom::WebClient::NotifyTabContextPermissionStateChanged";
      case messages::WebClient::kNotifyOsLocationPermissionStateChanged:
            return "Receive reply glic::mojom::WebClient::NotifyOsLocationPermissionStateChanged";
      case messages::WebClient::kNotifyFocusedTabChanged:
            return "Receive reply glic::mojom::WebClient::NotifyFocusedTabChanged";
      case messages::WebClient::kNotifyManualResizeChanged:
            return "Receive reply glic::mojom::WebClient::NotifyManualResizeChanged";
      case messages::WebClient::kNotifyOsHotkeyStateChanged:
            return "Receive reply glic::mojom::WebClient::NotifyOsHotkeyStateChanged";
      case messages::WebClient::kNotifyBrowserIsOpenChanged:
            return "Receive reply glic::mojom::WebClient::NotifyBrowserIsOpenChanged";
      case messages::WebClient::kNotifyBrowserIsActiveChanged:
            return "Receive reply glic::mojom::WebClient::NotifyBrowserIsActiveChanged";
      case messages::WebClient::kNotifyActiveBrowserChanged:
            return "Receive reply glic::mojom::WebClient::NotifyActiveBrowserChanged";
      case messages::WebClient::kNotifyClosedCaptioningSettingChanged:
            return "Receive reply glic::mojom::WebClient::NotifyClosedCaptioningSettingChanged";
      case messages::WebClient::kNotifyPinnedTabsChanged:
            return "Receive reply glic::mojom::WebClient::NotifyPinnedTabsChanged";
      case messages::WebClient::kNotifyPinnedTabDataChanged:
            return "Receive reply glic::mojom::WebClient::NotifyPinnedTabDataChanged";
      case messages::WebClient::kNotifyZeroStateSuggestionsChanged:
            return "Receive reply glic::mojom::WebClient::NotifyZeroStateSuggestionsChanged";
      case messages::WebClient::kNotifyActorTaskStateChanged:
            return "Receive reply glic::mojom::WebClient::NotifyActorTaskStateChanged";
      case messages::WebClient::kRequestViewChange:
            return "Receive reply glic::mojom::WebClient::RequestViewChange";
      case messages::WebClient::kNotifyPageMetadataChanged:
            return "Receive reply glic::mojom::WebClient::NotifyPageMetadataChanged";
      case messages::WebClient::kNotifyDefaultTabContextPermissionStateChanged:
            return "Receive reply glic::mojom::WebClient::NotifyDefaultTabContextPermissionStateChanged";
      case messages::WebClient::kRequestToShowCredentialSelectionDialog:
            return "Receive reply glic::mojom::WebClient::RequestToShowCredentialSelectionDialog";
      case messages::WebClient::kRequestToShowUserConfirmationDialog:
            return "Receive reply glic::mojom::WebClient::RequestToShowUserConfirmationDialog";
      case messages::WebClient::kNotifyAdditionalContext:
            return "Receive reply glic::mojom::WebClient::NotifyAdditionalContext";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebClient::NotifyPanelWillOpen_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb98b6bf3;  // IPCStableHash for glic::mojom::WebClient::NotifyPanelWillOpen
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyPanelWasClosed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6298f317;  // IPCStableHash for glic::mojom::WebClient::NotifyPanelWasClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyPanelStateChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd3acd43e;  // IPCStableHash for glic::mojom::WebClient::NotifyPanelStateChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyPanelActiveChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x63119508;  // IPCStableHash for glic::mojom::WebClient::NotifyPanelActiveChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyPanelCanAttachChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa4192190;  // IPCStableHash for glic::mojom::WebClient::NotifyPanelCanAttachChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyMicrophonePermissionStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf6db09ad;  // IPCStableHash for glic::mojom::WebClient::NotifyMicrophonePermissionStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyLocationPermissionStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x44cfdef8;  // IPCStableHash for glic::mojom::WebClient::NotifyLocationPermissionStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyTabContextPermissionStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf90395f3;  // IPCStableHash for glic::mojom::WebClient::NotifyTabContextPermissionStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyOsLocationPermissionStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeacba04b;  // IPCStableHash for glic::mojom::WebClient::NotifyOsLocationPermissionStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyFocusedTabChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc23d08ad;  // IPCStableHash for glic::mojom::WebClient::NotifyFocusedTabChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyManualResizeChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2789b022;  // IPCStableHash for glic::mojom::WebClient::NotifyManualResizeChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyOsHotkeyStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6f94b4e1;  // IPCStableHash for glic::mojom::WebClient::NotifyOsHotkeyStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyBrowserIsOpenChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe68550fc;  // IPCStableHash for glic::mojom::WebClient::NotifyBrowserIsOpenChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyBrowserIsActiveChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3eaaf7bf;  // IPCStableHash for glic::mojom::WebClient::NotifyBrowserIsActiveChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyActiveBrowserChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x372ce695;  // IPCStableHash for glic::mojom::WebClient::NotifyActiveBrowserChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyClosedCaptioningSettingChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd0975143;  // IPCStableHash for glic::mojom::WebClient::NotifyClosedCaptioningSettingChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyPinnedTabsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0bd1a686;  // IPCStableHash for glic::mojom::WebClient::NotifyPinnedTabsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyPinnedTabDataChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb8964440;  // IPCStableHash for glic::mojom::WebClient::NotifyPinnedTabDataChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyZeroStateSuggestionsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x75fd7c59;  // IPCStableHash for glic::mojom::WebClient::NotifyZeroStateSuggestionsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyActorTaskStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7ae770f1;  // IPCStableHash for glic::mojom::WebClient::NotifyActorTaskStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::RequestViewChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6cfe6b0d;  // IPCStableHash for glic::mojom::WebClient::RequestViewChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyPageMetadataChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x47203df2;  // IPCStableHash for glic::mojom::WebClient::NotifyPageMetadataChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyDefaultTabContextPermissionStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6ef754c7;  // IPCStableHash for glic::mojom::WebClient::NotifyDefaultTabContextPermissionStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::RequestToShowCredentialSelectionDialog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe5e8990c;  // IPCStableHash for glic::mojom::WebClient::RequestToShowCredentialSelectionDialog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::RequestToShowUserConfirmationDialog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4d4d1052;  // IPCStableHash for glic::mojom::WebClient::RequestToShowUserConfirmationDialog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebClient::NotifyAdditionalContext_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf86f8984;  // IPCStableHash for glic::mojom::WebClient::NotifyAdditionalContext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebClient_NotifyPanelWillOpen_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClient_NotifyPanelWillOpen_ForwardToCallback(
      WebClient::NotifyPanelWillOpenCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClient_NotifyPanelWillOpen_ForwardToCallback(const WebClient_NotifyPanelWillOpen_ForwardToCallback&) = delete;
  WebClient_NotifyPanelWillOpen_ForwardToCallback& operator=(const WebClient_NotifyPanelWillOpen_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClient::NotifyPanelWillOpenCallback callback_;
};

class WebClient_NotifyPanelWasClosed_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClient_NotifyPanelWasClosed_ForwardToCallback(
      WebClient::NotifyPanelWasClosedCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClient_NotifyPanelWasClosed_ForwardToCallback(const WebClient_NotifyPanelWasClosed_ForwardToCallback&) = delete;
  WebClient_NotifyPanelWasClosed_ForwardToCallback& operator=(const WebClient_NotifyPanelWasClosed_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClient::NotifyPanelWasClosedCallback callback_;
};

class WebClient_RequestToShowCredentialSelectionDialog_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClient_RequestToShowCredentialSelectionDialog_ForwardToCallback(
      WebClient::RequestToShowCredentialSelectionDialogCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClient_RequestToShowCredentialSelectionDialog_ForwardToCallback(const WebClient_RequestToShowCredentialSelectionDialog_ForwardToCallback&) = delete;
  WebClient_RequestToShowCredentialSelectionDialog_ForwardToCallback& operator=(const WebClient_RequestToShowCredentialSelectionDialog_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClient::RequestToShowCredentialSelectionDialogCallback callback_;
};

class WebClient_RequestToShowUserConfirmationDialog_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebClient_RequestToShowUserConfirmationDialog_ForwardToCallback(
      WebClient::RequestToShowUserConfirmationDialogCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebClient_RequestToShowUserConfirmationDialog_ForwardToCallback(const WebClient_RequestToShowUserConfirmationDialog_ForwardToCallback&) = delete;
  WebClient_RequestToShowUserConfirmationDialog_ForwardToCallback& operator=(const WebClient_RequestToShowUserConfirmationDialog_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebClient::RequestToShowUserConfirmationDialogCallback callback_;
};

WebClientProxy::WebClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebClientProxy::NotifyPanelWillOpen(
    PanelOpeningDataPtr in_panel_opening_data, NotifyPanelWillOpenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyPanelWillOpen", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("panel_opening_data"), in_panel_opening_data,
                        "<value of type PanelOpeningDataPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyPanelWillOpen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyPanelWillOpen_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->panel_opening_data)::BaseType> panel_opening_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::PanelOpeningDataDataView>(
    in_panel_opening_data,
    panel_opening_data_fragment);

  params->panel_opening_data.Set(
      panel_opening_data_fragment.is_null() ? nullptr : panel_opening_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->panel_opening_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null panel_opening_data in WebClient.NotifyPanelWillOpen request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyPanelWillOpen");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClient_NotifyPanelWillOpen_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientProxy::NotifyPanelWasClosed(
    NotifyPanelWasClosedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::WebClient::NotifyPanelWasClosed");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyPanelWasClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyPanelWasClosed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyPanelWasClosed");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClient_NotifyPanelWasClosed_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientProxy::NotifyPanelStateChange(
    PanelStatePtr in_panel_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyPanelStateChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("panel_state"), in_panel_state,
                        "<value of type PanelStatePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyPanelStateChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyPanelStateChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->panel_state)::BaseType> panel_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::PanelStateDataView>(
    in_panel_state,
    panel_state_fragment);

  params->panel_state.Set(
      panel_state_fragment.is_null() ? nullptr : panel_state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->panel_state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null panel_state in WebClient.NotifyPanelStateChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyPanelStateChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientProxy::NotifyPanelActiveChange(
    bool in_panel_active) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyPanelActiveChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("panel_active"), in_panel_active,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyPanelActiveChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyPanelActiveChange_Params_Data> params(
          message);
  params.Allocate();

  params->panel_active = in_panel_active;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyPanelActiveChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientProxy::NotifyPanelCanAttachChange(
    bool in_can_attach) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyPanelCanAttachChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("can_attach"), in_can_attach,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyPanelCanAttachChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyPanelCanAttachChange_Params_Data> params(
          message);
  params.Allocate();

  params->can_attach = in_can_attach;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyPanelCanAttachChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientProxy::NotifyMicrophonePermissionStateChanged(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyMicrophonePermissionStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyMicrophonePermissionStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyMicrophonePermissionStateChanged_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyMicrophonePermissionStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientProxy::NotifyLocationPermissionStateChanged(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyLocationPermissionStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyLocationPermissionStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyLocationPermissionStateChanged_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyLocationPermissionStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientProxy::NotifyTabContextPermissionStateChanged(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyTabContextPermissionStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyTabContextPermissionStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyTabContextPermissionStateChanged_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyTabContextPermissionStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientProxy::NotifyOsLocationPermissionStateChanged(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyOsLocationPermissionStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyOsLocationPermissionStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyOsLocationPermissionStateChanged_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyOsLocationPermissionStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientProxy::NotifyFocusedTabChanged(
    FocusedTabDataPtr in_focused_tab_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyFocusedTabChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focused_tab_data"), in_focused_tab_data,
                        "<value of type FocusedTabDataPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyFocusedTabChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyFocusedTabChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->focused_tab_data)>
      focused_tab_data_fragment(params.message());
  focused_tab_data_fragment.Claim(&params->focused_tab_data);
  
  mojo::internal::Serialize<::glic::mojom::FocusedTabDataDataView>(
    in_focused_tab_data,
    focused_tab_data_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->focused_tab_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null focused_tab_data in WebClient.NotifyFocusedTabChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyFocusedTabChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientProxy::NotifyManualResizeChanged(
    bool in_resizing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyManualResizeChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resizing"), in_resizing,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyManualResizeChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyManualResizeChanged_Params_Data> params(
          message);
  params.Allocate();

  params->resizing = in_resizing;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyManualResizeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientProxy::NotifyOsHotkeyStateChanged(
    const std::string& in_hotkey) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyOsHotkeyStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hotkey"), in_hotkey,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyOsHotkeyStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyOsHotkeyStateChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->hotkey)::BaseType> hotkey_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_hotkey,
    hotkey_fragment);

  params->hotkey.Set(
      hotkey_fragment.is_null() ? nullptr : hotkey_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->hotkey.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null hotkey in WebClient.NotifyOsHotkeyStateChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyOsHotkeyStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientProxy::NotifyBrowserIsOpenChanged(
    bool in_browser_is_open) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyBrowserIsOpenChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_is_open"), in_browser_is_open,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyBrowserIsOpenChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyBrowserIsOpenChanged_Params_Data> params(
          message);
  params.Allocate();

  params->browser_is_open = in_browser_is_open;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyBrowserIsOpenChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientProxy::NotifyBrowserIsActiveChanged(
    bool in_browser_active) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyBrowserIsActiveChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_active"), in_browser_active,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyBrowserIsActiveChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyBrowserIsActiveChanged_Params_Data> params(
          message);
  params.Allocate();

  params->browser_active = in_browser_active;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyBrowserIsActiveChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientProxy::NotifyActiveBrowserChanged(
    ActiveBrowserInfoPtr in_active_browser_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyActiveBrowserChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("active_browser_info"), in_active_browser_info,
                        "<value of type ActiveBrowserInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyActiveBrowserChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyActiveBrowserChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->active_browser_info)::BaseType> active_browser_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::ActiveBrowserInfoDataView>(
    in_active_browser_info,
    active_browser_info_fragment);

  params->active_browser_info.Set(
      active_browser_info_fragment.is_null() ? nullptr : active_browser_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyActiveBrowserChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientProxy::NotifyClosedCaptioningSettingChanged(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyClosedCaptioningSettingChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyClosedCaptioningSettingChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyClosedCaptioningSettingChanged_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyClosedCaptioningSettingChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientProxy::NotifyPinnedTabsChanged(
    std::vector<TabDataPtr> in_tab_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyPinnedTabsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_data"), in_tab_data,
                        "<value of type std::vector<TabDataPtr>>");
   });
#endif

  CHECK(base::FeatureList::IsEnabled(::glic::mojom::features::kGlicMultiTab));
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyPinnedTabsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyPinnedTabsChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tab_data)::BaseType>
      tab_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& tab_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::glic::mojom::TabDataDataView>>(
    in_tab_data,
    tab_data_fragment,
    &tab_data_validate_params);

  params->tab_data.Set(
      tab_data_fragment.is_null() ? nullptr : tab_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tab_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tab_data in WebClient.NotifyPinnedTabsChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyPinnedTabsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientProxy::NotifyPinnedTabDataChanged(
    TabDataPtr in_tab_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyPinnedTabDataChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_data"), in_tab_data,
                        "<value of type TabDataPtr>");
   });
#endif

  CHECK(base::FeatureList::IsEnabled(::glic::mojom::features::kGlicMultiTab));
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyPinnedTabDataChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyPinnedTabDataChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tab_data)::BaseType> tab_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::TabDataDataView>(
    in_tab_data,
    tab_data_fragment);

  params->tab_data.Set(
      tab_data_fragment.is_null() ? nullptr : tab_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tab_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tab_data in WebClient.NotifyPinnedTabDataChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyPinnedTabDataChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientProxy::NotifyZeroStateSuggestionsChanged(
    ZeroStateSuggestionsV2Ptr in_suggestions, ZeroStateSuggestionsOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyZeroStateSuggestionsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("suggestions"), in_suggestions,
                        "<value of type ZeroStateSuggestionsV2Ptr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ZeroStateSuggestionsOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyZeroStateSuggestionsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyZeroStateSuggestionsChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->suggestions)::BaseType> suggestions_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::ZeroStateSuggestionsV2DataView>(
    in_suggestions,
    suggestions_fragment);

  params->suggestions.Set(
      suggestions_fragment.is_null() ? nullptr : suggestions_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::ZeroStateSuggestionsOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in WebClient.NotifyZeroStateSuggestionsChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyZeroStateSuggestionsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientProxy::NotifyActorTaskStateChanged(
    int32_t in_task_id, ActorTaskState in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyActorTaskStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("task_id"), in_task_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type ActorTaskState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyActorTaskStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyActorTaskStateChanged_Params_Data> params(
          message);
  params.Allocate();

  params->task_id = in_task_id;

  
  mojo::internal::Serialize<::glic::mojom::ActorTaskState>(
    in_state,
    &params->state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyActorTaskStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientProxy::RequestViewChange(
    ViewChangeRequestPtr in_request) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::RequestViewChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type ViewChangeRequestPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kRequestViewChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_RequestViewChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::ViewChangeRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in WebClient.RequestViewChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("RequestViewChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientProxy::NotifyPageMetadataChanged(
    int32_t in_tab_id, ::blink::mojom::PageMetadataPtr in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyPageMetadataChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type ::blink::mojom::PageMetadataPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyPageMetadataChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyPageMetadataChanged_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PageMetadataDataView>(
    in_metadata,
    metadata_fragment);

  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyPageMetadataChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientProxy::NotifyDefaultTabContextPermissionStateChanged(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyDefaultTabContextPermissionStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyDefaultTabContextPermissionStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyDefaultTabContextPermissionStateChanged_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyDefaultTabContextPermissionStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebClientProxy::RequestToShowCredentialSelectionDialog(
    ::actor::webui::mojom::SelectCredentialDialogRequestPtr in_request, RequestToShowCredentialSelectionDialogCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::RequestToShowCredentialSelectionDialog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type ::actor::webui::mojom::SelectCredentialDialogRequestPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kRequestToShowCredentialSelectionDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_RequestToShowCredentialSelectionDialog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::actor::webui::mojom::SelectCredentialDialogRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in WebClient.RequestToShowCredentialSelectionDialog request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("RequestToShowCredentialSelectionDialog");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClient_RequestToShowCredentialSelectionDialog_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientProxy::RequestToShowUserConfirmationDialog(
    ::actor::webui::mojom::UserConfirmationDialogRequestPtr in_request, RequestToShowUserConfirmationDialogCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::RequestToShowUserConfirmationDialog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type ::actor::webui::mojom::UserConfirmationDialogRequestPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kRequestToShowUserConfirmationDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_RequestToShowUserConfirmationDialog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::actor::webui::mojom::UserConfirmationDialogRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in WebClient.RequestToShowUserConfirmationDialog request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("RequestToShowUserConfirmationDialog");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebClient_RequestToShowUserConfirmationDialog_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebClientProxy::NotifyAdditionalContext(
    AdditionalContextPtr in_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::WebClient::NotifyAdditionalContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context"), in_context,
                        "<value of type AdditionalContextPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyAdditionalContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyAdditionalContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->context)::BaseType> context_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::AdditionalContextDataView>(
    in_context,
    context_fragment);

  params->context.Set(
      context_fragment.is_null() ? nullptr : context_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->context.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null context in WebClient.NotifyAdditionalContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyAdditionalContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class WebClient_NotifyPanelWillOpen_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClient::NotifyPanelWillOpenCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClient_NotifyPanelWillOpen_ProxyToResponder> proxy(
        new WebClient_NotifyPanelWillOpen_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClient_NotifyPanelWillOpen_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClient_NotifyPanelWillOpen_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClient_NotifyPanelWillOpen_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClient::NotifyPanelWillOpenCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      OpenPanelInfoPtr in_openPanelInfo);
};

bool WebClient_NotifyPanelWillOpen_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClient_NotifyPanelWillOpen_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClient_NotifyPanelWillOpen_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClient.0
  bool success = true;
  OpenPanelInfoPtr p_openPanelInfo{};
  WebClient_NotifyPanelWillOpen_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadOpenPanelInfo(&p_openPanelInfo))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_openPanelInfo));
  }
  return true;
}

void WebClient_NotifyPanelWillOpen_ProxyToResponder::Run(
    OpenPanelInfoPtr in_openPanelInfo) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClient::NotifyPanelWillOpen", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("openPanelInfo"), in_openPanelInfo,
                        "<value of type OpenPanelInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyPanelWillOpen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyPanelWillOpen_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->openPanelInfo)::BaseType> openPanelInfo_fragment(
          params.message());
  
  mojo::internal::Serialize<::glic::mojom::OpenPanelInfoDataView>(
    in_openPanelInfo,
    openPanelInfo_fragment);

  params->openPanelInfo.Set(
      openPanelInfo_fragment.is_null() ? nullptr : openPanelInfo_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->openPanelInfo.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null openPanelInfo in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyPanelWillOpen");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClient_NotifyPanelWasClosed_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClient::NotifyPanelWasClosedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClient_NotifyPanelWasClosed_ProxyToResponder> proxy(
        new WebClient_NotifyPanelWasClosed_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClient_NotifyPanelWasClosed_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClient_NotifyPanelWasClosed_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClient_NotifyPanelWasClosed_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClient::NotifyPanelWasClosedCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool WebClient_NotifyPanelWasClosed_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClient_NotifyPanelWasClosed_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClient_NotifyPanelWasClosed_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClient.1
  bool success = true;
  WebClient_NotifyPanelWasClosed_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClient::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void WebClient_NotifyPanelWasClosed_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply glic::mojom::WebClient::NotifyPanelWasClosed");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kNotifyPanelWasClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_NotifyPanelWasClosed_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("NotifyPanelWasClosed");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClient_RequestToShowCredentialSelectionDialog_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClient::RequestToShowCredentialSelectionDialogCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClient_RequestToShowCredentialSelectionDialog_ProxyToResponder> proxy(
        new WebClient_RequestToShowCredentialSelectionDialog_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClient_RequestToShowCredentialSelectionDialog_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClient_RequestToShowCredentialSelectionDialog_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClient_RequestToShowCredentialSelectionDialog_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClient::RequestToShowCredentialSelectionDialogCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::actor::webui::mojom::SelectCredentialDialogResponsePtr in_response);
};

bool WebClient_RequestToShowCredentialSelectionDialog_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClient_RequestToShowCredentialSelectionDialog_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClient_RequestToShowCredentialSelectionDialog_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClient.23
  bool success = true;
  ::actor::webui::mojom::SelectCredentialDialogResponsePtr p_response{};
  WebClient_RequestToShowCredentialSelectionDialog_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResponse(&p_response))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClient::Name_, 23, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_response));
  }
  return true;
}

void WebClient_RequestToShowCredentialSelectionDialog_ProxyToResponder::Run(
    ::actor::webui::mojom::SelectCredentialDialogResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClient::RequestToShowCredentialSelectionDialog", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type ::actor::webui::mojom::SelectCredentialDialogResponsePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kRequestToShowCredentialSelectionDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_RequestToShowCredentialSelectionDialog_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  
  mojo::internal::Serialize<::actor::webui::mojom::SelectCredentialDialogResponseDataView>(
    in_response,
    response_fragment);

  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("RequestToShowCredentialSelectionDialog");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebClient_RequestToShowUserConfirmationDialog_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebClient::RequestToShowUserConfirmationDialogCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebClient_RequestToShowUserConfirmationDialog_ProxyToResponder> proxy(
        new WebClient_RequestToShowUserConfirmationDialog_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebClient_RequestToShowUserConfirmationDialog_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebClient_RequestToShowUserConfirmationDialog_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebClient_RequestToShowUserConfirmationDialog_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebClient::RequestToShowUserConfirmationDialogCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::actor::webui::mojom::UserConfirmationDialogResponsePtr in_response);
};

bool WebClient_RequestToShowUserConfirmationDialog_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebClient_RequestToShowUserConfirmationDialog_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebClient_RequestToShowUserConfirmationDialog_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebClient.24
  bool success = true;
  ::actor::webui::mojom::UserConfirmationDialogResponsePtr p_response{};
  WebClient_RequestToShowUserConfirmationDialog_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResponse(&p_response))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebClient::Name_, 24, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_response));
  }
  return true;
}

void WebClient_RequestToShowUserConfirmationDialog_ProxyToResponder::Run(
    ::actor::webui::mojom::UserConfirmationDialogResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::WebClient::RequestToShowUserConfirmationDialog", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type ::actor::webui::mojom::UserConfirmationDialogResponsePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebClient::kRequestToShowUserConfirmationDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::WebClient_RequestToShowUserConfirmationDialog_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  
  mojo::internal::Serialize<::actor::webui::mojom::UserConfirmationDialogResponseDataView>(
    in_response,
    response_fragment);

  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebClient::Name_);
  message.set_method_name("RequestToShowUserConfirmationDialog");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebClientStubDispatch::Accept(
    WebClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebClient>(message->header()->name)) {
    case messages::WebClient::kNotifyPanelWillOpen: {
      break;
    }
    case messages::WebClient::kNotifyPanelWasClosed: {
      break;
    }
    case messages::WebClient::kNotifyPanelStateChange: {
      DCHECK(message->is_serialized());
      internal::WebClient_NotifyPanelStateChange_Params_Data* params =
          reinterpret_cast<internal::WebClient_NotifyPanelStateChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.2
      bool success = true;
      PanelStatePtr p_panel_state{};
      WebClient_NotifyPanelStateChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPanelState(&p_panel_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyPanelStateChange(        
        std::move(p_panel_state));
      return true;
    }
    case messages::WebClient::kNotifyPanelActiveChange: {
      DCHECK(message->is_serialized());
      internal::WebClient_NotifyPanelActiveChange_Params_Data* params =
          reinterpret_cast<internal::WebClient_NotifyPanelActiveChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.3
      bool success = true;
      bool p_panel_active{};
      WebClient_NotifyPanelActiveChange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_panel_active = input_data_view.panel_active();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyPanelActiveChange(        
        std::move(p_panel_active));
      return true;
    }
    case messages::WebClient::kNotifyPanelCanAttachChange: {
      DCHECK(message->is_serialized());
      internal::WebClient_NotifyPanelCanAttachChange_Params_Data* params =
          reinterpret_cast<internal::WebClient_NotifyPanelCanAttachChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.4
      bool success = true;
      bool p_can_attach{};
      WebClient_NotifyPanelCanAttachChange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_can_attach = input_data_view.can_attach();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyPanelCanAttachChange(        
        std::move(p_can_attach));
      return true;
    }
    case messages::WebClient::kNotifyMicrophonePermissionStateChanged: {
      DCHECK(message->is_serialized());
      internal::WebClient_NotifyMicrophonePermissionStateChanged_Params_Data* params =
          reinterpret_cast<internal::WebClient_NotifyMicrophonePermissionStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.5
      bool success = true;
      bool p_enabled{};
      WebClient_NotifyMicrophonePermissionStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyMicrophonePermissionStateChanged(        
        std::move(p_enabled));
      return true;
    }
    case messages::WebClient::kNotifyLocationPermissionStateChanged: {
      DCHECK(message->is_serialized());
      internal::WebClient_NotifyLocationPermissionStateChanged_Params_Data* params =
          reinterpret_cast<internal::WebClient_NotifyLocationPermissionStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.6
      bool success = true;
      bool p_enabled{};
      WebClient_NotifyLocationPermissionStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyLocationPermissionStateChanged(        
        std::move(p_enabled));
      return true;
    }
    case messages::WebClient::kNotifyTabContextPermissionStateChanged: {
      DCHECK(message->is_serialized());
      internal::WebClient_NotifyTabContextPermissionStateChanged_Params_Data* params =
          reinterpret_cast<internal::WebClient_NotifyTabContextPermissionStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.7
      bool success = true;
      bool p_enabled{};
      WebClient_NotifyTabContextPermissionStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyTabContextPermissionStateChanged(        
        std::move(p_enabled));
      return true;
    }
    case messages::WebClient::kNotifyOsLocationPermissionStateChanged: {
      DCHECK(message->is_serialized());
      internal::WebClient_NotifyOsLocationPermissionStateChanged_Params_Data* params =
          reinterpret_cast<internal::WebClient_NotifyOsLocationPermissionStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.8
      bool success = true;
      bool p_enabled{};
      WebClient_NotifyOsLocationPermissionStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyOsLocationPermissionStateChanged(        
        std::move(p_enabled));
      return true;
    }
    case messages::WebClient::kNotifyFocusedTabChanged: {
      DCHECK(message->is_serialized());
      internal::WebClient_NotifyFocusedTabChanged_Params_Data* params =
          reinterpret_cast<internal::WebClient_NotifyFocusedTabChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.9
      bool success = true;
      FocusedTabDataPtr p_focused_tab_data{};
      WebClient_NotifyFocusedTabChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFocusedTabData(&p_focused_tab_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyFocusedTabChanged(        
        std::move(p_focused_tab_data));
      return true;
    }
    case messages::WebClient::kNotifyManualResizeChanged: {
      DCHECK(message->is_serialized());
      internal::WebClient_NotifyManualResizeChanged_Params_Data* params =
          reinterpret_cast<internal::WebClient_NotifyManualResizeChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.10
      bool success = true;
      bool p_resizing{};
      WebClient_NotifyManualResizeChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_resizing = input_data_view.resizing();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyManualResizeChanged(        
        std::move(p_resizing));
      return true;
    }
    case messages::WebClient::kNotifyOsHotkeyStateChanged: {
      DCHECK(message->is_serialized());
      internal::WebClient_NotifyOsHotkeyStateChanged_Params_Data* params =
          reinterpret_cast<internal::WebClient_NotifyOsHotkeyStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.11
      bool success = true;
      std::string p_hotkey{};
      WebClient_NotifyOsHotkeyStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHotkey(&p_hotkey))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyOsHotkeyStateChanged(        
        std::move(p_hotkey));
      return true;
    }
    case messages::WebClient::kNotifyBrowserIsOpenChanged: {
      DCHECK(message->is_serialized());
      internal::WebClient_NotifyBrowserIsOpenChanged_Params_Data* params =
          reinterpret_cast<internal::WebClient_NotifyBrowserIsOpenChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.12
      bool success = true;
      bool p_browser_is_open{};
      WebClient_NotifyBrowserIsOpenChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_browser_is_open = input_data_view.browser_is_open();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyBrowserIsOpenChanged(        
        std::move(p_browser_is_open));
      return true;
    }
    case messages::WebClient::kNotifyBrowserIsActiveChanged: {
      DCHECK(message->is_serialized());
      internal::WebClient_NotifyBrowserIsActiveChanged_Params_Data* params =
          reinterpret_cast<internal::WebClient_NotifyBrowserIsActiveChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.13
      bool success = true;
      bool p_browser_active{};
      WebClient_NotifyBrowserIsActiveChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_browser_active = input_data_view.browser_active();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyBrowserIsActiveChanged(        
        std::move(p_browser_active));
      return true;
    }
    case messages::WebClient::kNotifyActiveBrowserChanged: {
      DCHECK(message->is_serialized());
      internal::WebClient_NotifyActiveBrowserChanged_Params_Data* params =
          reinterpret_cast<internal::WebClient_NotifyActiveBrowserChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.14
      bool success = true;
      ActiveBrowserInfoPtr p_active_browser_info{};
      WebClient_NotifyActiveBrowserChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadActiveBrowserInfo(&p_active_browser_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyActiveBrowserChanged(        
        std::move(p_active_browser_info));
      return true;
    }
    case messages::WebClient::kNotifyClosedCaptioningSettingChanged: {
      DCHECK(message->is_serialized());
      internal::WebClient_NotifyClosedCaptioningSettingChanged_Params_Data* params =
          reinterpret_cast<internal::WebClient_NotifyClosedCaptioningSettingChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.15
      bool success = true;
      bool p_enabled{};
      WebClient_NotifyClosedCaptioningSettingChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyClosedCaptioningSettingChanged(        
        std::move(p_enabled));
      return true;
    }
    case messages::WebClient::kNotifyPinnedTabsChanged: {
      DCHECK(message->is_serialized());
      internal::WebClient_NotifyPinnedTabsChanged_Params_Data* params =
          reinterpret_cast<internal::WebClient_NotifyPinnedTabsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.16
      bool success = true;
      std::vector<TabDataPtr> p_tab_data{};
      WebClient_NotifyPinnedTabsChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTabData(&p_tab_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyPinnedTabsChanged(        
        std::move(p_tab_data));
      return true;
    }
    case messages::WebClient::kNotifyPinnedTabDataChanged: {
      DCHECK(message->is_serialized());
      internal::WebClient_NotifyPinnedTabDataChanged_Params_Data* params =
          reinterpret_cast<internal::WebClient_NotifyPinnedTabDataChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.17
      bool success = true;
      TabDataPtr p_tab_data{};
      WebClient_NotifyPinnedTabDataChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTabData(&p_tab_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyPinnedTabDataChanged(        
        std::move(p_tab_data));
      return true;
    }
    case messages::WebClient::kNotifyZeroStateSuggestionsChanged: {
      DCHECK(message->is_serialized());
      internal::WebClient_NotifyZeroStateSuggestionsChanged_Params_Data* params =
          reinterpret_cast<internal::WebClient_NotifyZeroStateSuggestionsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.18
      bool success = true;
      ZeroStateSuggestionsV2Ptr p_suggestions{};
      ZeroStateSuggestionsOptionsPtr p_options{};
      WebClient_NotifyZeroStateSuggestionsChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSuggestions(&p_suggestions))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyZeroStateSuggestionsChanged(        
        std::move(p_suggestions), 
        std::move(p_options));
      return true;
    }
    case messages::WebClient::kNotifyActorTaskStateChanged: {
      DCHECK(message->is_serialized());
      internal::WebClient_NotifyActorTaskStateChanged_Params_Data* params =
          reinterpret_cast<internal::WebClient_NotifyActorTaskStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.19
      bool success = true;
      int32_t p_task_id{};
      ActorTaskState p_state{};
      WebClient_NotifyActorTaskStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_task_id = input_data_view.task_id();
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyActorTaskStateChanged(        
        std::move(p_task_id), 
        std::move(p_state));
      return true;
    }
    case messages::WebClient::kRequestViewChange: {
      DCHECK(message->is_serialized());
      internal::WebClient_RequestViewChange_Params_Data* params =
          reinterpret_cast<internal::WebClient_RequestViewChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.20
      bool success = true;
      ViewChangeRequestPtr p_request{};
      WebClient_RequestViewChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestViewChange(        
        std::move(p_request));
      return true;
    }
    case messages::WebClient::kNotifyPageMetadataChanged: {
      DCHECK(message->is_serialized());
      internal::WebClient_NotifyPageMetadataChanged_Params_Data* params =
          reinterpret_cast<internal::WebClient_NotifyPageMetadataChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.21
      bool success = true;
      int32_t p_tab_id{};
      ::blink::mojom::PageMetadataPtr p_metadata{};
      WebClient_NotifyPageMetadataChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyPageMetadataChanged(        
        std::move(p_tab_id), 
        std::move(p_metadata));
      return true;
    }
    case messages::WebClient::kNotifyDefaultTabContextPermissionStateChanged: {
      DCHECK(message->is_serialized());
      internal::WebClient_NotifyDefaultTabContextPermissionStateChanged_Params_Data* params =
          reinterpret_cast<internal::WebClient_NotifyDefaultTabContextPermissionStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.22
      bool success = true;
      bool p_enabled{};
      WebClient_NotifyDefaultTabContextPermissionStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyDefaultTabContextPermissionStateChanged(        
        std::move(p_enabled));
      return true;
    }
    case messages::WebClient::kRequestToShowCredentialSelectionDialog: {
      break;
    }
    case messages::WebClient::kRequestToShowUserConfirmationDialog: {
      break;
    }
    case messages::WebClient::kNotifyAdditionalContext: {
      DCHECK(message->is_serialized());
      internal::WebClient_NotifyAdditionalContext_Params_Data* params =
          reinterpret_cast<internal::WebClient_NotifyAdditionalContext_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebClient.25
      bool success = true;
      AdditionalContextPtr p_context{};
      WebClient_NotifyAdditionalContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadContext(&p_context))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyAdditionalContext(        
        std::move(p_context));
      return true;
    }
  }
  return false;
}

// static
bool WebClientStubDispatch::AcceptWithResponder(
    WebClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebClient>(message->header()->name)) {
    case messages::WebClient::kNotifyPanelWillOpen: {
      internal::WebClient_NotifyPanelWillOpen_Params_Data* params =
          reinterpret_cast<
              internal::WebClient_NotifyPanelWillOpen_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClient.0
      bool success = true;
      PanelOpeningDataPtr p_panel_opening_data{};
      WebClient_NotifyPanelWillOpen_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPanelOpeningData(&p_panel_opening_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 0, false);
        return false;
      }
      auto callback =
          WebClient_NotifyPanelWillOpen_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyPanelWillOpen(        
        std::move(p_panel_opening_data), std::move(callback));
      return true;
    }
    case messages::WebClient::kNotifyPanelWasClosed: {
      internal::WebClient_NotifyPanelWasClosed_Params_Data* params =
          reinterpret_cast<
              internal::WebClient_NotifyPanelWasClosed_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClient.1
      bool success = true;
      WebClient_NotifyPanelWasClosed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 1, false);
        return false;
      }
      auto callback =
          WebClient_NotifyPanelWasClosed_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyPanelWasClosed(std::move(callback));
      return true;
    }
    case messages::WebClient::kNotifyPanelStateChange: {
      break;
    }
    case messages::WebClient::kNotifyPanelActiveChange: {
      break;
    }
    case messages::WebClient::kNotifyPanelCanAttachChange: {
      break;
    }
    case messages::WebClient::kNotifyMicrophonePermissionStateChanged: {
      break;
    }
    case messages::WebClient::kNotifyLocationPermissionStateChanged: {
      break;
    }
    case messages::WebClient::kNotifyTabContextPermissionStateChanged: {
      break;
    }
    case messages::WebClient::kNotifyOsLocationPermissionStateChanged: {
      break;
    }
    case messages::WebClient::kNotifyFocusedTabChanged: {
      break;
    }
    case messages::WebClient::kNotifyManualResizeChanged: {
      break;
    }
    case messages::WebClient::kNotifyOsHotkeyStateChanged: {
      break;
    }
    case messages::WebClient::kNotifyBrowserIsOpenChanged: {
      break;
    }
    case messages::WebClient::kNotifyBrowserIsActiveChanged: {
      break;
    }
    case messages::WebClient::kNotifyActiveBrowserChanged: {
      break;
    }
    case messages::WebClient::kNotifyClosedCaptioningSettingChanged: {
      break;
    }
    case messages::WebClient::kNotifyPinnedTabsChanged: {
      break;
    }
    case messages::WebClient::kNotifyPinnedTabDataChanged: {
      break;
    }
    case messages::WebClient::kNotifyZeroStateSuggestionsChanged: {
      break;
    }
    case messages::WebClient::kNotifyActorTaskStateChanged: {
      break;
    }
    case messages::WebClient::kRequestViewChange: {
      break;
    }
    case messages::WebClient::kNotifyPageMetadataChanged: {
      break;
    }
    case messages::WebClient::kNotifyDefaultTabContextPermissionStateChanged: {
      break;
    }
    case messages::WebClient::kRequestToShowCredentialSelectionDialog: {
      internal::WebClient_RequestToShowCredentialSelectionDialog_Params_Data* params =
          reinterpret_cast<
              internal::WebClient_RequestToShowCredentialSelectionDialog_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClient.23
      bool success = true;
      ::actor::webui::mojom::SelectCredentialDialogRequestPtr p_request{};
      WebClient_RequestToShowCredentialSelectionDialog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 23, false);
        return false;
      }
      auto callback =
          WebClient_RequestToShowCredentialSelectionDialog_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestToShowCredentialSelectionDialog(        
        std::move(p_request), std::move(callback));
      return true;
    }
    case messages::WebClient::kRequestToShowUserConfirmationDialog: {
      internal::WebClient_RequestToShowUserConfirmationDialog_Params_Data* params =
          reinterpret_cast<
              internal::WebClient_RequestToShowUserConfirmationDialog_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebClient.24
      bool success = true;
      ::actor::webui::mojom::UserConfirmationDialogRequestPtr p_request{};
      WebClient_RequestToShowUserConfirmationDialog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebClient::Name_, 24, false);
        return false;
      }
      auto callback =
          WebClient_RequestToShowUserConfirmationDialog_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestToShowUserConfirmationDialog(        
        std::move(p_request), std::move(callback));
      return true;
    }
    case messages::WebClient::kNotifyAdditionalContext: {
      break;
    }
  }
  return false;
}
namespace {

bool ValidateWithRuntimeFeature_WebClient_NotifyPinnedTabsChanged(
  const void* data, mojo::internal::ValidationContext* validation_context) {
  if (!base::FeatureList::IsEnabled(::glic::mojom::features::kGlicMultiTab)) {
    return false;
  }
  return internal::WebClient_NotifyPinnedTabsChanged_Params_Data::Validate(
    data, validation_context);
}

bool ValidateWithRuntimeFeature_WebClient_NotifyPinnedTabDataChanged(
  const void* data, mojo::internal::ValidationContext* validation_context) {
  if (!base::FeatureList::IsEnabled(::glic::mojom::features::kGlicMultiTab)) {
    return false;
  }
  return internal::WebClient_NotifyPinnedTabDataChanged_Params_Data::Validate(
    data, validation_context);
}
}  // namespace
static const mojo::internal::GenericValidationInfo kWebClientValidationInfo[] = {
    { &internal::WebClient_NotifyPanelWillOpen_Params_Data::Validate,
     &internal::WebClient_NotifyPanelWillOpen_ResponseParams_Data::Validate},
    { &internal::WebClient_NotifyPanelWasClosed_Params_Data::Validate,
     &internal::WebClient_NotifyPanelWasClosed_ResponseParams_Data::Validate},
    { &internal::WebClient_NotifyPanelStateChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClient_NotifyPanelActiveChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClient_NotifyPanelCanAttachChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClient_NotifyMicrophonePermissionStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClient_NotifyLocationPermissionStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClient_NotifyTabContextPermissionStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClient_NotifyOsLocationPermissionStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClient_NotifyFocusedTabChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClient_NotifyManualResizeChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClient_NotifyOsHotkeyStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClient_NotifyBrowserIsOpenChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClient_NotifyBrowserIsActiveChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClient_NotifyActiveBrowserChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClient_NotifyClosedCaptioningSettingChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &ValidateWithRuntimeFeature_WebClient_NotifyPinnedTabsChanged,
     nullptr /* no response */},
    { &ValidateWithRuntimeFeature_WebClient_NotifyPinnedTabDataChanged,
     nullptr /* no response */},
    { &internal::WebClient_NotifyZeroStateSuggestionsChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClient_NotifyActorTaskStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClient_RequestViewChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClient_NotifyPageMetadataChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClient_NotifyDefaultTabContextPermissionStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebClient_RequestToShowCredentialSelectionDialog_Params_Data::Validate,
     &internal::WebClient_RequestToShowCredentialSelectionDialog_ResponseParams_Data::Validate},
    { &internal::WebClient_RequestToShowUserConfirmationDialog_Params_Data::Validate,
     &internal::WebClient_RequestToShowUserConfirmationDialog_ResponseParams_Data::Validate},
    { &internal::WebClient_NotifyAdditionalContext_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::glic::mojom::WebClient::Name_,
    kWebClientValidationInfo);
}

bool WebClientResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::glic::mojom::WebClient::Name_,
    kWebClientValidationInfo);
}


}  // glic::mojom


namespace mojo {


// static
bool StructTraits<::glic::mojom::UserProfileInfo::DataView, ::glic::mojom::UserProfileInfoPtr>::Read(
    ::glic::mojom::UserProfileInfo::DataView input,
    ::glic::mojom::UserProfileInfoPtr* output) {
  bool success = true;
  ::glic::mojom::UserProfileInfoPtr result(::glic::mojom::UserProfileInfo::New());
  
      if (success && !input.ReadAvatarIcon(&result->avatar_icon))
        success = false;
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
      if (success && !input.ReadLocalProfileName(&result->local_profile_name))
        success = false;
      if (success && !input.ReadEmail(&result->email))
        success = false;
      if (success && !input.ReadGivenName(&result->given_name))
        success = false;
      if (success)
        result->is_managed = input.is_managed();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::ActiveBrowserInfo::DataView, ::glic::mojom::ActiveBrowserInfoPtr>::Read(
    ::glic::mojom::ActiveBrowserInfo::DataView input,
    ::glic::mojom::ActiveBrowserInfoPtr* output) {
  bool success = true;
  ::glic::mojom::ActiveBrowserInfoPtr result(::glic::mojom::ActiveBrowserInfo::New());
  
      if (success)
        result->window_id = input.window_id();
      if (success)
        result->using_this_profile = input.using_this_profile();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::WebClientInitialState::DataView, ::glic::mojom::WebClientInitialStatePtr>::Read(
    ::glic::mojom::WebClientInitialState::DataView input,
    ::glic::mojom::WebClientInitialStatePtr* output) {
  bool success = true;
  ::glic::mojom::WebClientInitialStatePtr result(::glic::mojom::WebClientInitialState::New());
  
      if (success && !input.ReadPanelState(&result->panel_state))
        success = false;
      if (success && !input.ReadFocusedTabData(&result->focused_tab_data))
        success = false;
      if (success)
        result->microphone_permission_enabled = input.microphone_permission_enabled();
      if (success)
        result->location_permission_enabled = input.location_permission_enabled();
      if (success)
        result->tab_context_permission_enabled = input.tab_context_permission_enabled();
      if (success)
        result->os_location_permission_enabled = input.os_location_permission_enabled();
      if (success && !input.ReadHotkey(&result->hotkey))
        success = false;
      if (success && !input.ReadChromeVersion(&result->chrome_version))
        success = false;
      if (success)
        result->can_attach = input.can_attach();
      if (success)
        result->panel_is_active = input.panel_is_active();
      if (success)
        result->browser_is_open = input.browser_is_open();
      if (success)
        result->browser_is_active = input.browser_is_active();
      if (success && !input.ReadActiveBrowserInfo(&result->active_browser_info))
        success = false;
      if (success)
        result->always_detached_mode = input.always_detached_mode();
      if (success)
        result->enable_zero_state_suggestions = input.enable_zero_state_suggestions();
      if (success)
        result->enable_act_in_focused_tab = input.enable_act_in_focused_tab();
      if (success)
        result->enable_scroll_to = input.enable_scroll_to();
      if (success)
        result->enable_default_tab_context_setting_feature = input.enable_default_tab_context_setting_feature();
      if (success)
        result->default_tab_context_setting_enabled = input.default_tab_context_setting_enabled();
      if (success)
        result->enable_closed_captioning_feature = input.enable_closed_captioning_feature();
      if (success)
        result->closed_captioning_setting_enabled = input.closed_captioning_setting_enabled();
      if (success)
        result->enable_maybe_refresh_user_status = input.enable_maybe_refresh_user_status();
      if (success)
        result->enable_multi_tab = input.enable_multi_tab();
      if (success)
        result->enable_get_context_actor = input.enable_get_context_actor();
      if (success && !input.ReadHostCapabilities(&result->host_capabilities))
        success = false;
      if (success)
        result->enable_get_page_metadata = input.enable_get_page_metadata();
      if (success)
        result->enable_api_activation_gating = input.enable_api_activation_gating();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::GetTabContextOptions::DataView, ::glic::mojom::GetTabContextOptionsPtr>::Read(
    ::glic::mojom::GetTabContextOptions::DataView input,
    ::glic::mojom::GetTabContextOptionsPtr* output) {
  bool success = true;
  ::glic::mojom::GetTabContextOptionsPtr result(::glic::mojom::GetTabContextOptions::New());
  
      if (success)
        result->include_inner_text = input.include_inner_text();
      if (success)
        result->inner_text_bytes_limit = input.inner_text_bytes_limit();
      if (success)
        result->include_viewport_screenshot = input.include_viewport_screenshot();
      if (success)
        result->include_annotated_page_content = input.include_annotated_page_content();
      if (success)
        result->max_meta_tags = input.max_meta_tags();
      if (success)
        result->include_pdf = input.include_pdf();
      if (success)
        result->pdf_size_limit = input.pdf_size_limit();
      if (success)
        result->annotated_page_content_mode = input.annotated_page_content_mode();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::GetPinCandidatesOptions::DataView, ::glic::mojom::GetPinCandidatesOptionsPtr>::Read(
    ::glic::mojom::GetPinCandidatesOptions::DataView input,
    ::glic::mojom::GetPinCandidatesOptionsPtr* output) {
  bool success = true;
  ::glic::mojom::GetPinCandidatesOptionsPtr result(::glic::mojom::GetPinCandidatesOptions::New());
  
      if (success)
        result->max_candidates = input.max_candidates();
      if (success && !input.ReadQuery(&result->query))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::ScrollToParams::DataView, ::glic::mojom::ScrollToParamsPtr>::Read(
    ::glic::mojom::ScrollToParams::DataView input,
    ::glic::mojom::ScrollToParamsPtr* output) {
  bool success = true;
  ::glic::mojom::ScrollToParamsPtr result(::glic::mojom::ScrollToParams::New());
  
      if (success && !input.ReadSelector(&result->selector))
        success = false;
      if (success)
        result->highlight = input.highlight();
      if (success && !input.ReadDocumentId(&result->document_id))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::ScrollToTextSelector::DataView, ::glic::mojom::ScrollToTextSelectorPtr>::Read(
    ::glic::mojom::ScrollToTextSelector::DataView input,
    ::glic::mojom::ScrollToTextSelectorPtr* output) {
  bool success = true;
  ::glic::mojom::ScrollToTextSelectorPtr result(::glic::mojom::ScrollToTextSelector::New());
  
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success) {
        result->search_range_start_node_id = input.search_range_start_node_id();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::ScrollToTextFragmentSelector::DataView, ::glic::mojom::ScrollToTextFragmentSelectorPtr>::Read(
    ::glic::mojom::ScrollToTextFragmentSelector::DataView input,
    ::glic::mojom::ScrollToTextFragmentSelectorPtr* output) {
  bool success = true;
  ::glic::mojom::ScrollToTextFragmentSelectorPtr result(::glic::mojom::ScrollToTextFragmentSelector::New());
  
      if (success && !input.ReadTextStart(&result->text_start))
        success = false;
      if (success && !input.ReadTextEnd(&result->text_end))
        success = false;
      if (success) {
        result->search_range_start_node_id = input.search_range_start_node_id();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::ScrollToNodeSelector::DataView, ::glic::mojom::ScrollToNodeSelectorPtr>::Read(
    ::glic::mojom::ScrollToNodeSelector::DataView input,
    ::glic::mojom::ScrollToNodeSelectorPtr* output) {
  bool success = true;
  ::glic::mojom::ScrollToNodeSelectorPtr result(::glic::mojom::ScrollToNodeSelector::New());
  
      if (success)
        result->node_id = input.node_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::SuggestionContent::DataView, ::glic::mojom::SuggestionContentPtr>::Read(
    ::glic::mojom::SuggestionContent::DataView input,
    ::glic::mojom::SuggestionContentPtr* output) {
  bool success = true;
  ::glic::mojom::SuggestionContentPtr result(::glic::mojom::SuggestionContent::New());
  
      if (success && !input.ReadSuggestion(&result->suggestion))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::ZeroStateSuggestions::DataView, ::glic::mojom::ZeroStateSuggestionsPtr>::Read(
    ::glic::mojom::ZeroStateSuggestions::DataView input,
    ::glic::mojom::ZeroStateSuggestionsPtr* output) {
  bool success = true;
  ::glic::mojom::ZeroStateSuggestionsPtr result(::glic::mojom::ZeroStateSuggestions::New());
  
      if (success && !input.ReadSuggestions(&result->suggestions))
        success = false;
      if (success)
        result->tab_id = input.tab_id();
      if (success && !input.ReadTabUrl(&result->tab_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::ZeroStateSuggestionsV2::DataView, ::glic::mojom::ZeroStateSuggestionsV2Ptr>::Read(
    ::glic::mojom::ZeroStateSuggestionsV2::DataView input,
    ::glic::mojom::ZeroStateSuggestionsV2Ptr* output) {
  bool success = true;
  ::glic::mojom::ZeroStateSuggestionsV2Ptr result(::glic::mojom::ZeroStateSuggestionsV2::New());
  
      if (success && !input.ReadSuggestions(&result->suggestions))
        success = false;
      if (success)
        result->is_pending = input.is_pending();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::ZeroStateSuggestionsOptions::DataView, ::glic::mojom::ZeroStateSuggestionsOptionsPtr>::Read(
    ::glic::mojom::ZeroStateSuggestionsOptions::DataView input,
    ::glic::mojom::ZeroStateSuggestionsOptionsPtr* output) {
  bool success = true;
  ::glic::mojom::ZeroStateSuggestionsOptionsPtr result(::glic::mojom::ZeroStateSuggestionsOptions::New());
  
      if (success)
        result->is_first_run = input.is_first_run();
      if (success && !input.ReadSupportedTools(&result->supported_tools))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::PinCandidate::DataView, ::glic::mojom::PinCandidatePtr>::Read(
    ::glic::mojom::PinCandidate::DataView input,
    ::glic::mojom::PinCandidatePtr* output) {
  bool success = true;
  ::glic::mojom::PinCandidatePtr result(::glic::mojom::PinCandidate::New());
  
      if (success && !input.ReadTabData(&result->tab_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::ConversationInfo::DataView, ::glic::mojom::ConversationInfoPtr>::Read(
    ::glic::mojom::ConversationInfo::DataView input,
    ::glic::mojom::ConversationInfoPtr* output) {
  bool success = true;
  ::glic::mojom::ConversationInfoPtr result(::glic::mojom::ConversationInfo::New());
  
      if (success && !input.ReadConversationId(&result->conversation_id))
        success = false;
      if (success && !input.ReadConversationTitle(&result->conversation_title))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::PanelOpeningData::DataView, ::glic::mojom::PanelOpeningDataPtr>::Read(
    ::glic::mojom::PanelOpeningData::DataView input,
    ::glic::mojom::PanelOpeningDataPtr* output) {
  bool success = true;
  ::glic::mojom::PanelOpeningDataPtr result(::glic::mojom::PanelOpeningData::New());
  
      if (success && !input.ReadPanelState(&result->panel_state))
        success = false;
      if (success && !input.ReadInvocationSource(&result->invocation_source))
        success = false;
      if (success && !input.ReadConversationId(&result->conversation_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::PanelState::DataView, ::glic::mojom::PanelStatePtr>::Read(
    ::glic::mojom::PanelState::DataView input,
    ::glic::mojom::PanelStatePtr* output) {
  bool success = true;
  ::glic::mojom::PanelStatePtr result(::glic::mojom::PanelState::New());
  
      if (success && !input.ReadKind(&result->kind))
        success = false;
      if (success) {
        result->window_id = input.window_id();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::OnResponseStoppedDetails::DataView, ::glic::mojom::OnResponseStoppedDetailsPtr>::Read(
    ::glic::mojom::OnResponseStoppedDetails::DataView input,
    ::glic::mojom::OnResponseStoppedDetailsPtr* output) {
  bool success = true;
  ::glic::mojom::OnResponseStoppedDetailsPtr result(::glic::mojom::OnResponseStoppedDetails::New());
  
      if (success && !input.ReadCause(&result->cause))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::OpenPanelInfo::DataView, ::glic::mojom::OpenPanelInfoPtr>::Read(
    ::glic::mojom::OpenPanelInfo::DataView input,
    ::glic::mojom::OpenPanelInfoPtr* output) {
  bool success = true;
  ::glic::mojom::OpenPanelInfoPtr result(::glic::mojom::OpenPanelInfo::New());
  
      if (success && !input.ReadWebClientMode(&result->web_client_mode))
        success = false;
      if (success && !input.ReadPanelSize(&result->panelSize))
        success = false;
      if (success && !input.ReadResizeDuration(&result->resizeDuration))
        success = false;
      if (success)
        result->can_user_resize = input.can_user_resize();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::ContextData::DataView, ::glic::mojom::ContextDataPtr>::Read(
    ::glic::mojom::ContextData::DataView input,
    ::glic::mojom::ContextDataPtr* output) {
  bool success = true;
  ::glic::mojom::ContextDataPtr result(::glic::mojom::ContextData::New());
  
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::AdditionalContext::DataView, ::glic::mojom::AdditionalContextPtr>::Read(
    ::glic::mojom::AdditionalContext::DataView input,
    ::glic::mojom::AdditionalContextPtr* output) {
  bool success = true;
  ::glic::mojom::AdditionalContextPtr result(::glic::mojom::AdditionalContext::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success) {
        result->tab_id = input.tab_id();
      }
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadFrameUrl(&result->frameUrl))
        success = false;
      if (success && !input.ReadParts(&result->parts))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::TabContext::DataView, ::glic::mojom::TabContextPtr>::Read(
    ::glic::mojom::TabContext::DataView input,
    ::glic::mojom::TabContextPtr* output) {
  bool success = true;
  ::glic::mojom::TabContextPtr result(::glic::mojom::TabContext::New());
  
      if (success && !input.ReadTabData(&result->tab_data))
        success = false;
      if (success && !input.ReadWebPageData(&result->web_page_data))
        success = false;
      if (success && !input.ReadViewportScreenshot(&result->viewport_screenshot))
        success = false;
      if (success && !input.ReadPdfDocumentData(&result->pdf_document_data))
        success = false;
      if (success && !input.ReadAnnotatedPageData(&result->annotated_page_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::WebPageData::DataView, ::glic::mojom::WebPageDataPtr>::Read(
    ::glic::mojom::WebPageData::DataView input,
    ::glic::mojom::WebPageDataPtr* output) {
  bool success = true;
  ::glic::mojom::WebPageDataPtr result(::glic::mojom::WebPageData::New());
  
      if (success && !input.ReadMainDocument(&result->main_document))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::DocumentData::DataView, ::glic::mojom::DocumentDataPtr>::Read(
    ::glic::mojom::DocumentData::DataView input,
    ::glic::mojom::DocumentDataPtr* output) {
  bool success = true;
  ::glic::mojom::DocumentDataPtr result(::glic::mojom::DocumentData::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadInnerText(&result->inner_text))
        success = false;
      if (success)
        result->inner_text_truncated = input.inner_text_truncated();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::PdfDocumentData::DataView, ::glic::mojom::PdfDocumentDataPtr>::Read(
    ::glic::mojom::PdfDocumentData::DataView input,
    ::glic::mojom::PdfDocumentDataPtr* output) {
  bool success = true;
  ::glic::mojom::PdfDocumentDataPtr result(::glic::mojom::PdfDocumentData::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadPdfData(&result->pdf_data))
        success = false;
      if (success)
        result->size_limit_exceeded = input.size_limit_exceeded();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::TabData::DataView, ::glic::mojom::TabDataPtr>::Read(
    ::glic::mojom::TabData::DataView input,
    ::glic::mojom::TabDataPtr* output) {
  bool success = true;
  ::glic::mojom::TabDataPtr result(::glic::mojom::TabData::New());
  
      if (success)
        result->tab_id = input.tab_id();
      if (success)
        result->window_id = input.window_id();
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadFavicon(&result->favicon))
        success = false;
      if (success && !input.ReadFaviconUrl(&result->favicon_url))
        success = false;
      if (success && !input.ReadDocumentMimeType(&result->document_mime_type))
        success = false;
      if (success) {
        result->is_observable = input.is_observable();
      }
      if (success) {
        result->is_media_active = input.is_media_active();
      }
      if (success) {
        result->is_tab_content_captured = input.is_tab_content_captured();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::NoFocusedTabData::DataView, ::glic::mojom::NoFocusedTabDataPtr>::Read(
    ::glic::mojom::NoFocusedTabData::DataView input,
    ::glic::mojom::NoFocusedTabDataPtr* output) {
  bool success = true;
  ::glic::mojom::NoFocusedTabDataPtr result(::glic::mojom::NoFocusedTabData::New());
  
      if (success && !input.ReadActiveTabData(&result->active_tab_data))
        success = false;
      if (success && !input.ReadNoFocusReason(&result->no_focus_reason))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::AnnotatedPageData::DataView, ::glic::mojom::AnnotatedPageDataPtr>::Read(
    ::glic::mojom::AnnotatedPageData::DataView input,
    ::glic::mojom::AnnotatedPageDataPtr* output) {
  bool success = true;
  ::glic::mojom::AnnotatedPageDataPtr result(::glic::mojom::AnnotatedPageData::New());
  
      if (success && !input.ReadAnnotatedPageContent(&result->annotated_page_content))
        success = false;
      if (success && !input.ReadMetadata(&result->metadata))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::ImageOriginAnnotations::DataView, ::glic::mojom::ImageOriginAnnotationsPtr>::Read(
    ::glic::mojom::ImageOriginAnnotations::DataView input,
    ::glic::mojom::ImageOriginAnnotationsPtr* output) {
  bool success = true;
  ::glic::mojom::ImageOriginAnnotationsPtr result(::glic::mojom::ImageOriginAnnotations::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::Journal::DataView, ::glic::mojom::JournalPtr>::Read(
    ::glic::mojom::Journal::DataView input,
    ::glic::mojom::JournalPtr* output) {
  bool success = true;
  ::glic::mojom::JournalPtr result(::glic::mojom::Journal::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::Screenshot::DataView, ::glic::mojom::ScreenshotPtr>::Read(
    ::glic::mojom::Screenshot::DataView input,
    ::glic::mojom::ScreenshotPtr* output) {
  bool success = true;
  ::glic::mojom::ScreenshotPtr result(::glic::mojom::Screenshot::New());
  
      if (success)
        result->width_pixels = input.width_pixels();
      if (success)
        result->height_pixels = input.height_pixels();
      if (success && !input.ReadData(&result->data))
        success = false;
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success && !input.ReadOriginAnnotations(&result->origin_annotations))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::OpenSettingsOptions::DataView, ::glic::mojom::OpenSettingsOptionsPtr>::Read(
    ::glic::mojom::OpenSettingsOptions::DataView input,
    ::glic::mojom::OpenSettingsOptionsPtr* output) {
  bool success = true;
  ::glic::mojom::OpenSettingsOptionsPtr result(::glic::mojom::OpenSettingsOptions::New());
  
      if (success && !input.ReadHighlightField(&result->highlightField))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::ViewChangeRequestActuation::DataView, ::glic::mojom::ViewChangeRequestActuationPtr>::Read(
    ::glic::mojom::ViewChangeRequestActuation::DataView input,
    ::glic::mojom::ViewChangeRequestActuationPtr* output) {
  bool success = true;
  ::glic::mojom::ViewChangeRequestActuationPtr result(::glic::mojom::ViewChangeRequestActuation::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::ViewChangeRequestConversation::DataView, ::glic::mojom::ViewChangeRequestConversationPtr>::Read(
    ::glic::mojom::ViewChangeRequestConversation::DataView input,
    ::glic::mojom::ViewChangeRequestConversationPtr* output) {
  bool success = true;
  ::glic::mojom::ViewChangeRequestConversationPtr result(::glic::mojom::ViewChangeRequestConversation::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::ViewChangeRequest::DataView, ::glic::mojom::ViewChangeRequestPtr>::Read(
    ::glic::mojom::ViewChangeRequest::DataView input,
    ::glic::mojom::ViewChangeRequestPtr* output) {
  bool success = true;
  ::glic::mojom::ViewChangeRequestPtr result(::glic::mojom::ViewChangeRequest::New());
  
      if (success && !input.ReadDetails(&result->details))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::glic::mojom::ViewChangedNotification::DataView, ::glic::mojom::ViewChangedNotificationPtr>::Read(
    ::glic::mojom::ViewChangedNotification::DataView input,
    ::glic::mojom::ViewChangedNotificationPtr* output) {
  bool success = true;
  ::glic::mojom::ViewChangedNotificationPtr result(::glic::mojom::ViewChangedNotification::New());
  
      if (success && !input.ReadCurrentView(&result->current_view))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::glic::mojom::GetContextResult::DataView, ::glic::mojom::GetContextResultPtr>::Read(
    ::glic::mojom::GetContextResult::DataView input,
    ::glic::mojom::GetContextResultPtr* output) {
  using UnionType = ::glic::mojom::GetContextResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kErrorReason: {
      std::string result_error_reason{};
      if (!input.ReadErrorReason(&result_error_reason))
        return false;

      *output = UnionType::NewErrorReason(
          std::move(result_error_reason));
      break;
    }
    case Tag::kTabContext: {
      ::glic::mojom::TabContextPtr result_tab_context{};
      if (!input.ReadTabContext(&result_tab_context))
        return false;

      *output = UnionType::NewTabContext(
          std::move(result_tab_context));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::glic::mojom::CaptureScreenshotResult::DataView, ::glic::mojom::CaptureScreenshotResultPtr>::Read(
    ::glic::mojom::CaptureScreenshotResult::DataView input,
    ::glic::mojom::CaptureScreenshotResultPtr* output) {
  using UnionType = ::glic::mojom::CaptureScreenshotResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kErrorReason: {
      ::glic::mojom::CaptureScreenshotErrorReason result_error_reason;
      if (!input.ReadErrorReason(&result_error_reason))
        return false;

      *output = UnionType::NewErrorReason(result_error_reason);
      break;
    }
    case Tag::kScreenshot: {
      ::glic::mojom::ScreenshotPtr result_screenshot{};
      if (!input.ReadScreenshot(&result_screenshot))
        return false;

      *output = UnionType::NewScreenshot(
          std::move(result_screenshot));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::glic::mojom::ScrollToSelector::DataView, ::glic::mojom::ScrollToSelectorPtr>::Read(
    ::glic::mojom::ScrollToSelector::DataView input,
    ::glic::mojom::ScrollToSelectorPtr* output) {
  using UnionType = ::glic::mojom::ScrollToSelector;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kExactTextSelector: {
      ::glic::mojom::ScrollToTextSelectorPtr result_exact_text_selector{};
      if (!input.ReadExactTextSelector(&result_exact_text_selector))
        return false;

      *output = UnionType::NewExactTextSelector(
          std::move(result_exact_text_selector));
      break;
    }
    case Tag::kTextFragmentSelector: {
      ::glic::mojom::ScrollToTextFragmentSelectorPtr result_text_fragment_selector{};
      if (!input.ReadTextFragmentSelector(&result_text_fragment_selector))
        return false;

      *output = UnionType::NewTextFragmentSelector(
          std::move(result_text_fragment_selector));
      break;
    }
    case Tag::kNodeSelector: {
      ::glic::mojom::ScrollToNodeSelectorPtr result_node_selector{};
      if (!input.ReadNodeSelector(&result_node_selector))
        return false;

      *output = UnionType::NewNodeSelector(
          std::move(result_node_selector));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::glic::mojom::AdditionalContextPart::DataView, ::glic::mojom::AdditionalContextPartPtr>::Read(
    ::glic::mojom::AdditionalContextPart::DataView input,
    ::glic::mojom::AdditionalContextPartPtr* output) {
  using UnionType = ::glic::mojom::AdditionalContextPart;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kData: {
      ::glic::mojom::ContextDataPtr result_data{};
      if (!input.ReadData(&result_data))
        return false;

      *output = UnionType::NewData(
          std::move(result_data));
      break;
    }
    case Tag::kScreenshot: {
      ::glic::mojom::ScreenshotPtr result_screenshot{};
      if (!input.ReadScreenshot(&result_screenshot))
        return false;

      *output = UnionType::NewScreenshot(
          std::move(result_screenshot));
      break;
    }
    case Tag::kWebPageData: {
      ::glic::mojom::WebPageDataPtr result_web_page_data{};
      if (!input.ReadWebPageData(&result_web_page_data))
        return false;

      *output = UnionType::NewWebPageData(
          std::move(result_web_page_data));
      break;
    }
    case Tag::kAnnotatedPageData: {
      ::glic::mojom::AnnotatedPageDataPtr result_annotated_page_data{};
      if (!input.ReadAnnotatedPageData(&result_annotated_page_data))
        return false;

      *output = UnionType::NewAnnotatedPageData(
          std::move(result_annotated_page_data));
      break;
    }
    case Tag::kPdfDocumentData: {
      ::glic::mojom::PdfDocumentDataPtr result_pdf_document_data{};
      if (!input.ReadPdfDocumentData(&result_pdf_document_data))
        return false;

      *output = UnionType::NewPdfDocumentData(
          std::move(result_pdf_document_data));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::glic::mojom::FocusedTabData::DataView, ::glic::mojom::FocusedTabDataPtr>::Read(
    ::glic::mojom::FocusedTabData::DataView input,
    ::glic::mojom::FocusedTabDataPtr* output) {
  using UnionType = ::glic::mojom::FocusedTabData;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kFocusedTab: {
      ::glic::mojom::TabDataPtr result_focused_tab{};
      if (!input.ReadFocusedTab(&result_focused_tab))
        return false;

      *output = UnionType::NewFocusedTab(
          std::move(result_focused_tab));
      break;
    }
    case Tag::kNoFocusedTabData: {
      ::glic::mojom::NoFocusedTabDataPtr result_no_focused_tab_data{};
      if (!input.ReadNoFocusedTabData(&result_no_focused_tab_data))
        return false;

      *output = UnionType::NewNoFocusedTabData(
          std::move(result_no_focused_tab_data));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::glic::mojom::ViewChangeRequestDetails::DataView, ::glic::mojom::ViewChangeRequestDetailsPtr>::Read(
    ::glic::mojom::ViewChangeRequestDetails::DataView input,
    ::glic::mojom::ViewChangeRequestDetailsPtr* output) {
  using UnionType = ::glic::mojom::ViewChangeRequestDetails;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kActuation: {
      ::glic::mojom::ViewChangeRequestActuationPtr result_actuation{};
      if (!input.ReadActuation(&result_actuation))
        return false;

      *output = UnionType::NewActuation(
          std::move(result_actuation));
      break;
    }
    case Tag::kConversation: {
      ::glic::mojom::ViewChangeRequestConversationPtr result_conversation{};
      if (!input.ReadConversation(&result_conversation))
        return false;

      *output = UnionType::NewConversation(
          std::move(result_conversation));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::glic::mojom::WebClientHandler_CreateTask_ResponseParam_Result::DataView, ::glic::mojom::WebClientHandler_CreateTask_ResponseParam_ResultPtr>::Read(
    ::glic::mojom::WebClientHandler_CreateTask_ResponseParam_Result::DataView input,
    ::glic::mojom::WebClientHandler_CreateTask_ResponseParam_ResultPtr* output) {
  using UnionType = ::glic::mojom::WebClientHandler_CreateTask_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      *output = UnionType::NewSuccess(input.success());
      break;
    }
    case Tag::kFailure: {
      ::glic::mojom::CreateTaskErrorReason result_failure;
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(result_failure);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::glic::mojom::WebClientHandler_PerformActions_ResponseParam_Result::DataView, ::glic::mojom::WebClientHandler_PerformActions_ResponseParam_ResultPtr>::Read(
    ::glic::mojom::WebClientHandler_PerformActions_ResponseParam_Result::DataView input,
    ::glic::mojom::WebClientHandler_PerformActions_ResponseParam_ResultPtr* output) {
  using UnionType = ::glic::mojom::WebClientHandler_PerformActions_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::mojo_base::ProtoWrapper result_success{mojo::internal::DefaultConstructTag()};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::glic::mojom::PerformActionsErrorReason result_failure;
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(result_failure);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace glic::mojom {


void PageInterceptorForTesting::IntentToShow() {
  GetForwardingInterface()->IntentToShow();
}
void PageInterceptorForTesting::SetProfileReadyState(ProfileReadyState ready_state) {
  GetForwardingInterface()->SetProfileReadyState(
    std::move(ready_state)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;





void PageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingReceiver<PageHandler> receiver, ::mojo::PendingRemote<Page> page) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(receiver)
    , 
    std::move(page)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::CreateWebClient(::mojo::PendingReceiver<WebClientHandler> web_client_receiver) {
  GetForwardingInterface()->CreateWebClient(
    std::move(web_client_receiver)
    );
}
void PageHandlerInterceptorForTesting::PrepareForClient(PrepareForClientCallback callback) {
  GetForwardingInterface()->PrepareForClient(std::move(callback));
}
void PageHandlerInterceptorForTesting::WebviewCommitted(const ::GURL& url) {
  GetForwardingInterface()->WebviewCommitted(
    std::move(url)
    );
}
void PageHandlerInterceptorForTesting::ClosePanel(ClosePanelCallback callback) {
  GetForwardingInterface()->ClosePanel(std::move(callback));
}
void PageHandlerInterceptorForTesting::OpenProfilePickerAndClosePanel() {
  GetForwardingInterface()->OpenProfilePickerAndClosePanel();
}
void PageHandlerInterceptorForTesting::OpenDisabledByAdminLinkAndClosePanel() {
  GetForwardingInterface()->OpenDisabledByAdminLinkAndClosePanel();
}
void PageHandlerInterceptorForTesting::SignInAndClosePanel() {
  GetForwardingInterface()->SignInAndClosePanel();
}
void PageHandlerInterceptorForTesting::ResizeWidget(const ::gfx::Size& size, ::base::TimeDelta duration, ResizeWidgetCallback callback) {
  GetForwardingInterface()->ResizeWidget(
    std::move(size)
    , 
    std::move(duration)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::EnableDragResize(bool enabled) {
  GetForwardingInterface()->EnableDragResize(
    std::move(enabled)
    );
}
void PageHandlerInterceptorForTesting::WebUiStateChanged(WebUiState new_state) {
  GetForwardingInterface()->WebUiStateChanged(
    std::move(new_state)
    );
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::PrepareForClient(
    PrepareForClientResult* out_result) {
  base::RunLoop loop;
  proxy_->PrepareForClient(
      base::BindOnce(
          [](base::RunLoop* loop,
             PrepareForClientResult* out_result
,
             PrepareForClientResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

PrepareForClientResult PageHandlerAsyncWaiter::PrepareForClient(
    ) {
  PrepareForClientResult async_wait_result;
  PrepareForClient(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::ClosePanel(
    ) {
  base::RunLoop loop;
  proxy_->ClosePanel(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void PageHandlerAsyncWaiter::ResizeWidget(
    const ::gfx::Size& size, ::base::TimeDelta duration) {
  base::RunLoop loop;
  proxy_->ResizeWidget(
      std::move(size),
      std::move(duration),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void PinCandidatesObserverInterceptorForTesting::OnPinCandidatesChanged(std::vector<PinCandidatePtr> candidates) {
  GetForwardingInterface()->OnPinCandidatesChanged(
    std::move(candidates)
    );
}
PinCandidatesObserverAsyncWaiter::PinCandidatesObserverAsyncWaiter(
    PinCandidatesObserver* proxy) : proxy_(proxy) {}

PinCandidatesObserverAsyncWaiter::~PinCandidatesObserverAsyncWaiter() = default;





void WebClientHandlerInterceptorForTesting::WebClientCreated(::mojo::PendingRemote<WebClient> web_client, WebClientCreatedCallback callback) {
  GetForwardingInterface()->WebClientCreated(
    std::move(web_client)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::WebClientInitialized() {
  GetForwardingInterface()->WebClientInitialized();
}
void WebClientHandlerInterceptorForTesting::WebClientInitializeFailed() {
  GetForwardingInterface()->WebClientInitializeFailed();
}
void WebClientHandlerInterceptorForTesting::CreateTab(const ::GURL& url, bool open_in_background, std::optional<int32_t> window_id, CreateTabCallback callback) {
  GetForwardingInterface()->CreateTab(
    std::move(url)
    , 
    std::move(open_in_background)
    , 
    std::move(window_id)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::OpenGlicSettingsPage(OpenSettingsOptionsPtr options) {
  GetForwardingInterface()->OpenGlicSettingsPage(
    std::move(options)
    );
}
void WebClientHandlerInterceptorForTesting::ClosePanel() {
  GetForwardingInterface()->ClosePanel();
}
void WebClientHandlerInterceptorForTesting::ClosePanelAndShutdown() {
  GetForwardingInterface()->ClosePanelAndShutdown();
}
void WebClientHandlerInterceptorForTesting::AttachPanel() {
  GetForwardingInterface()->AttachPanel();
}
void WebClientHandlerInterceptorForTesting::DetachPanel() {
  GetForwardingInterface()->DetachPanel();
}
void WebClientHandlerInterceptorForTesting::ShowProfilePicker() {
  GetForwardingInterface()->ShowProfilePicker();
}
void WebClientHandlerInterceptorForTesting::GetModelQualityClientId(GetModelQualityClientIdCallback callback) {
  GetForwardingInterface()->GetModelQualityClientId(std::move(callback));
}
void WebClientHandlerInterceptorForTesting::GetContextFromFocusedTab(GetTabContextOptionsPtr options, GetContextFromFocusedTabCallback callback) {
  GetForwardingInterface()->GetContextFromFocusedTab(
    std::move(options)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::GetContextFromTab(int32_t tab_id, GetTabContextOptionsPtr options, GetContextFromTabCallback callback) {
  GetForwardingInterface()->GetContextFromTab(
    std::move(tab_id)
    , 
    std::move(options)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::GetContextForActorFromTab(int32_t tab_id, GetTabContextOptionsPtr options, GetContextForActorFromTabCallback callback) {
  GetForwardingInterface()->GetContextForActorFromTab(
    std::move(tab_id)
    , 
    std::move(options)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::SetMaximumNumberOfPinnedTabs(uint32_t requested_max, SetMaximumNumberOfPinnedTabsCallback callback) {
  GetForwardingInterface()->SetMaximumNumberOfPinnedTabs(
    std::move(requested_max)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::PinTabs(const std::vector<int32_t>& tab_ids, PinTabsCallback callback) {
  GetForwardingInterface()->PinTabs(
    std::move(tab_ids)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::UnpinTabs(const std::vector<int32_t>& tab_ids, UnpinTabsCallback callback) {
  GetForwardingInterface()->UnpinTabs(
    std::move(tab_ids)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::UnpinAllTabs() {
  GetForwardingInterface()->UnpinAllTabs();
}
void WebClientHandlerInterceptorForTesting::SubscribeToPinCandidates(GetPinCandidatesOptionsPtr options, ::mojo::PendingRemote<PinCandidatesObserver> observer) {
  GetForwardingInterface()->SubscribeToPinCandidates(
    std::move(options)
    , 
    std::move(observer)
    );
}
void WebClientHandlerInterceptorForTesting::CreateTask(::actor::webui::mojom::TaskOptionsPtr task_options, CreateTaskCallback callback) {
  GetForwardingInterface()->CreateTask(
    std::move(task_options)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::PerformActions(const std::vector<uint8_t>& actions_proto, PerformActionsCallback callback) {
  GetForwardingInterface()->PerformActions(
    std::move(actions_proto)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::StopActorTask(int32_t task_id, ActorTaskStopReason stop_reason) {
  GetForwardingInterface()->StopActorTask(
    std::move(task_id)
    , 
    std::move(stop_reason)
    );
}
void WebClientHandlerInterceptorForTesting::PauseActorTask(int32_t task_id, ActorTaskPauseReason pause_reason) {
  GetForwardingInterface()->PauseActorTask(
    std::move(task_id)
    , 
    std::move(pause_reason)
    );
}
void WebClientHandlerInterceptorForTesting::ResumeActorTask(int32_t task_id, GetTabContextOptionsPtr context_options, ResumeActorTaskCallback callback) {
  GetForwardingInterface()->ResumeActorTask(
    std::move(task_id)
    , 
    std::move(context_options)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::ResizeWidget(const ::gfx::Size& size, ::base::TimeDelta duration, ResizeWidgetCallback callback) {
  GetForwardingInterface()->ResizeWidget(
    std::move(size)
    , 
    std::move(duration)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::CaptureScreenshot(CaptureScreenshotCallback callback) {
  GetForwardingInterface()->CaptureScreenshot(std::move(callback));
}
void WebClientHandlerInterceptorForTesting::SetAudioDucking(bool enable, SetAudioDuckingCallback callback) {
  GetForwardingInterface()->SetAudioDucking(
    std::move(enable)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::SetPanelDraggableAreas(const std::vector<::gfx::Rect>& draggable_areas, SetPanelDraggableAreasCallback callback) {
  GetForwardingInterface()->SetPanelDraggableAreas(
    std::move(draggable_areas)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::SetMinimumPanelSize(const ::gfx::Size& size) {
  GetForwardingInterface()->SetMinimumPanelSize(
    std::move(size)
    );
}
void WebClientHandlerInterceptorForTesting::SetMicrophonePermissionState(bool enabled, SetMicrophonePermissionStateCallback callback) {
  GetForwardingInterface()->SetMicrophonePermissionState(
    std::move(enabled)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::SetLocationPermissionState(bool enabled, SetLocationPermissionStateCallback callback) {
  GetForwardingInterface()->SetLocationPermissionState(
    std::move(enabled)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::SetTabContextPermissionState(bool enabled, SetTabContextPermissionStateCallback callback) {
  GetForwardingInterface()->SetTabContextPermissionState(
    std::move(enabled)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::SetClosedCaptioningSetting(bool enabled, SetClosedCaptioningSettingCallback callback) {
  GetForwardingInterface()->SetClosedCaptioningSetting(
    std::move(enabled)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::ShouldAllowMediaPermissionRequest(ShouldAllowMediaPermissionRequestCallback callback) {
  GetForwardingInterface()->ShouldAllowMediaPermissionRequest(std::move(callback));
}
void WebClientHandlerInterceptorForTesting::ShouldAllowGeolocationPermissionRequest(ShouldAllowGeolocationPermissionRequestCallback callback) {
  GetForwardingInterface()->ShouldAllowGeolocationPermissionRequest(std::move(callback));
}
void WebClientHandlerInterceptorForTesting::SetContextAccessIndicator(bool enabled) {
  GetForwardingInterface()->SetContextAccessIndicator(
    std::move(enabled)
    );
}
void WebClientHandlerInterceptorForTesting::GetUserProfileInfo(GetUserProfileInfoCallback callback) {
  GetForwardingInterface()->GetUserProfileInfo(std::move(callback));
}
void WebClientHandlerInterceptorForTesting::SyncCookies(SyncCookiesCallback callback) {
  GetForwardingInterface()->SyncCookies(std::move(callback));
}
void WebClientHandlerInterceptorForTesting::LogBeginAsyncEvent(uint64_t event_async_id, int32_t task_id, const std::string& event, const std::string& details) {
  GetForwardingInterface()->LogBeginAsyncEvent(
    std::move(event_async_id)
    , 
    std::move(task_id)
    , 
    std::move(event)
    , 
    std::move(details)
    );
}
void WebClientHandlerInterceptorForTesting::LogEndAsyncEvent(uint64_t event_async_id, const std::string& details) {
  GetForwardingInterface()->LogEndAsyncEvent(
    std::move(event_async_id)
    , 
    std::move(details)
    );
}
void WebClientHandlerInterceptorForTesting::LogInstantEvent(int32_t task_id, const std::string& event, const std::string& details) {
  GetForwardingInterface()->LogInstantEvent(
    std::move(task_id)
    , 
    std::move(event)
    , 
    std::move(details)
    );
}
void WebClientHandlerInterceptorForTesting::JournalClear() {
  GetForwardingInterface()->JournalClear();
}
void WebClientHandlerInterceptorForTesting::JournalSnapshot(bool clear_journal, JournalSnapshotCallback callback) {
  GetForwardingInterface()->JournalSnapshot(
    std::move(clear_journal)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::JournalStart(uint64_t max_bytes, bool capture_screenshots) {
  GetForwardingInterface()->JournalStart(
    std::move(max_bytes)
    , 
    std::move(capture_screenshots)
    );
}
void WebClientHandlerInterceptorForTesting::JournalStop() {
  GetForwardingInterface()->JournalStop();
}
void WebClientHandlerInterceptorForTesting::JournalRecordFeedback(bool positive, const std::string& reason) {
  GetForwardingInterface()->JournalRecordFeedback(
    std::move(positive)
    , 
    std::move(reason)
    );
}
void WebClientHandlerInterceptorForTesting::OnUserInputSubmitted(WebClientMode mode) {
  GetForwardingInterface()->OnUserInputSubmitted(
    std::move(mode)
    );
}
void WebClientHandlerInterceptorForTesting::OnContextUploadStarted() {
  GetForwardingInterface()->OnContextUploadStarted();
}
void WebClientHandlerInterceptorForTesting::OnContextUploadCompleted() {
  GetForwardingInterface()->OnContextUploadCompleted();
}
void WebClientHandlerInterceptorForTesting::OnReaction(MetricUserInputReactionType reactionType) {
  GetForwardingInterface()->OnReaction(
    std::move(reactionType)
    );
}
void WebClientHandlerInterceptorForTesting::OnResponseStarted() {
  GetForwardingInterface()->OnResponseStarted();
}
void WebClientHandlerInterceptorForTesting::OnResponseStopped(OnResponseStoppedDetailsPtr details) {
  GetForwardingInterface()->OnResponseStopped(
    std::move(details)
    );
}
void WebClientHandlerInterceptorForTesting::OnSessionTerminated() {
  GetForwardingInterface()->OnSessionTerminated();
}
void WebClientHandlerInterceptorForTesting::OnTurnCompleted(WebClientModel model, ::base::TimeDelta duration) {
  GetForwardingInterface()->OnTurnCompleted(
    std::move(model)
    , 
    std::move(duration)
    );
}
void WebClientHandlerInterceptorForTesting::OnModelChanged(WebClientModel model) {
  GetForwardingInterface()->OnModelChanged(
    std::move(model)
    );
}
void WebClientHandlerInterceptorForTesting::OnResponseRated(bool positive) {
  GetForwardingInterface()->OnResponseRated(
    std::move(positive)
    );
}
void WebClientHandlerInterceptorForTesting::OnClosedCaptionsShown() {
  GetForwardingInterface()->OnClosedCaptionsShown();
}
void WebClientHandlerInterceptorForTesting::ScrollTo(ScrollToParamsPtr params, ScrollToCallback callback) {
  GetForwardingInterface()->ScrollTo(
    std::move(params)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::DropScrollToHighlight() {
  GetForwardingInterface()->DropScrollToHighlight();
}
void WebClientHandlerInterceptorForTesting::SetSyntheticExperimentState(const std::string& trial_name, const std::string& group_name) {
  GetForwardingInterface()->SetSyntheticExperimentState(
    std::move(trial_name)
    , 
    std::move(group_name)
    );
}
void WebClientHandlerInterceptorForTesting::OpenOsPermissionSettingsMenu(::content_settings::mojom::ContentSettingsType type) {
  GetForwardingInterface()->OpenOsPermissionSettingsMenu(
    std::move(type)
    );
}
void WebClientHandlerInterceptorForTesting::GetOsMicrophonePermissionStatus(GetOsMicrophonePermissionStatusCallback callback) {
  GetForwardingInterface()->GetOsMicrophonePermissionStatus(std::move(callback));
}
void WebClientHandlerInterceptorForTesting::GetZeroStateSuggestionsAndSubscribe(bool is_live, ZeroStateSuggestionsOptionsPtr options, GetZeroStateSuggestionsAndSubscribeCallback callback) {
  GetForwardingInterface()->GetZeroStateSuggestionsAndSubscribe(
    std::move(is_live)
    , 
    std::move(options)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::GetZeroStateSuggestionsForFocusedTab(std::optional<bool> is_first_run, GetZeroStateSuggestionsForFocusedTabCallback callback) {
  GetForwardingInterface()->GetZeroStateSuggestionsForFocusedTab(
    std::move(is_first_run)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::MaybeRefreshUserStatus() {
  GetForwardingInterface()->MaybeRefreshUserStatus();
}
void WebClientHandlerInterceptorForTesting::IsDebuggerAttached(IsDebuggerAttachedCallback callback) {
  GetForwardingInterface()->IsDebuggerAttached(std::move(callback));
}
void WebClientHandlerInterceptorForTesting::OnViewChanged(ViewChangedNotificationPtr notification) {
  GetForwardingInterface()->OnViewChanged(
    std::move(notification)
    );
}
void WebClientHandlerInterceptorForTesting::SubscribeToPageMetadata(int32_t tab_id, const std::vector<std::string>& names, SubscribeToPageMetadataCallback callback) {
  GetForwardingInterface()->SubscribeToPageMetadata(
    std::move(tab_id)
    , 
    std::move(names)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::SwitchConversation(ConversationInfoPtr info, SwitchConversationCallback callback) {
  GetForwardingInterface()->SwitchConversation(
    std::move(info)
    , std::move(callback));
}
void WebClientHandlerInterceptorForTesting::RegisterConversation(ConversationInfoPtr info, RegisterConversationCallback callback) {
  GetForwardingInterface()->RegisterConversation(
    std::move(info)
    , std::move(callback));
}
WebClientHandlerAsyncWaiter::WebClientHandlerAsyncWaiter(
    WebClientHandler* proxy) : proxy_(proxy) {}

WebClientHandlerAsyncWaiter::~WebClientHandlerAsyncWaiter() = default;


void WebClientHandlerAsyncWaiter::WebClientCreated(
    ::mojo::PendingRemote<WebClient> web_client, WebClientInitialStatePtr* out_initial_state) {
  base::RunLoop loop;
  proxy_->WebClientCreated(
      std::move(web_client),
      base::BindOnce(
          [](base::RunLoop* loop,
             WebClientInitialStatePtr* out_initial_state
,
             WebClientInitialStatePtr initial_state) {*out_initial_state = std::move(initial_state);
            loop->Quit();
          },
          &loop,
          out_initial_state));
  loop.Run();
}

WebClientInitialStatePtr WebClientHandlerAsyncWaiter::WebClientCreated(
    ::mojo::PendingRemote<WebClient> web_client) {
  WebClientInitialStatePtr async_wait_result;
  WebClientCreated(std::move(web_client),&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::CreateTab(
    const ::GURL& url, bool open_in_background, std::optional<int32_t> window_id, TabDataPtr* out_tab_data) {
  base::RunLoop loop;
  proxy_->CreateTab(
      std::move(url),
      std::move(open_in_background),
      std::move(window_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             TabDataPtr* out_tab_data
,
             TabDataPtr tab_data) {*out_tab_data = std::move(tab_data);
            loop->Quit();
          },
          &loop,
          out_tab_data));
  loop.Run();
}

TabDataPtr WebClientHandlerAsyncWaiter::CreateTab(
    const ::GURL& url, bool open_in_background, std::optional<int32_t> window_id) {
  TabDataPtr async_wait_result;
  CreateTab(std::move(url),std::move(open_in_background),std::move(window_id),&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::GetModelQualityClientId(
    std::string* out_model_quality_client_id) {
  base::RunLoop loop;
  proxy_->GetModelQualityClientId(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_model_quality_client_id
,
             const std::string& model_quality_client_id) {*out_model_quality_client_id = std::move(model_quality_client_id);
            loop->Quit();
          },
          &loop,
          out_model_quality_client_id));
  loop.Run();
}

std::string WebClientHandlerAsyncWaiter::GetModelQualityClientId(
    ) {
  std::string async_wait_result;
  GetModelQualityClientId(&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::GetContextFromFocusedTab(
    GetTabContextOptionsPtr options, GetContextResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetContextFromFocusedTab(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             GetContextResultPtr* out_result
,
             GetContextResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

GetContextResultPtr WebClientHandlerAsyncWaiter::GetContextFromFocusedTab(
    GetTabContextOptionsPtr options) {
  GetContextResultPtr async_wait_result;
  GetContextFromFocusedTab(std::move(options),&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::GetContextFromTab(
    int32_t tab_id, GetTabContextOptionsPtr options, GetContextResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetContextFromTab(
      std::move(tab_id),
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             GetContextResultPtr* out_result
,
             GetContextResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

GetContextResultPtr WebClientHandlerAsyncWaiter::GetContextFromTab(
    int32_t tab_id, GetTabContextOptionsPtr options) {
  GetContextResultPtr async_wait_result;
  GetContextFromTab(std::move(tab_id),std::move(options),&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::GetContextForActorFromTab(
    int32_t tab_id, GetTabContextOptionsPtr options, GetContextResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetContextForActorFromTab(
      std::move(tab_id),
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             GetContextResultPtr* out_result
,
             GetContextResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

GetContextResultPtr WebClientHandlerAsyncWaiter::GetContextForActorFromTab(
    int32_t tab_id, GetTabContextOptionsPtr options) {
  GetContextResultPtr async_wait_result;
  GetContextForActorFromTab(std::move(tab_id),std::move(options),&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::SetMaximumNumberOfPinnedTabs(
    uint32_t requested_max, uint32_t* out_effective_max) {
  base::RunLoop loop;
  proxy_->SetMaximumNumberOfPinnedTabs(
      std::move(requested_max),
      base::BindOnce(
          [](base::RunLoop* loop,
             uint32_t* out_effective_max
,
             uint32_t effective_max) {*out_effective_max = std::move(effective_max);
            loop->Quit();
          },
          &loop,
          out_effective_max));
  loop.Run();
}

uint32_t WebClientHandlerAsyncWaiter::SetMaximumNumberOfPinnedTabs(
    uint32_t requested_max) {
  uint32_t async_wait_result;
  SetMaximumNumberOfPinnedTabs(std::move(requested_max),&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::PinTabs(
    const std::vector<int32_t>& tab_ids, bool* out_pinned_all) {
  base::RunLoop loop;
  proxy_->PinTabs(
      std::move(tab_ids),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_pinned_all
,
             bool pinned_all) {*out_pinned_all = std::move(pinned_all);
            loop->Quit();
          },
          &loop,
          out_pinned_all));
  loop.Run();
}

bool WebClientHandlerAsyncWaiter::PinTabs(
    const std::vector<int32_t>& tab_ids) {
  bool async_wait_result;
  PinTabs(std::move(tab_ids),&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::UnpinTabs(
    const std::vector<int32_t>& tab_ids, bool* out_unpinned_all) {
  base::RunLoop loop;
  proxy_->UnpinTabs(
      std::move(tab_ids),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_unpinned_all
,
             bool unpinned_all) {*out_unpinned_all = std::move(unpinned_all);
            loop->Quit();
          },
          &loop,
          out_unpinned_all));
  loop.Run();
}

bool WebClientHandlerAsyncWaiter::UnpinTabs(
    const std::vector<int32_t>& tab_ids) {
  bool async_wait_result;
  UnpinTabs(std::move(tab_ids),&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::ResumeActorTask(
    int32_t task_id, GetTabContextOptionsPtr context_options, GetContextResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->ResumeActorTask(
      std::move(task_id),
      std::move(context_options),
      base::BindOnce(
          [](base::RunLoop* loop,
             GetContextResultPtr* out_result
,
             GetContextResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

GetContextResultPtr WebClientHandlerAsyncWaiter::ResumeActorTask(
    int32_t task_id, GetTabContextOptionsPtr context_options) {
  GetContextResultPtr async_wait_result;
  ResumeActorTask(std::move(task_id),std::move(context_options),&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::ResizeWidget(
    const ::gfx::Size& size, ::base::TimeDelta duration) {
  base::RunLoop loop;
  proxy_->ResizeWidget(
      std::move(size),
      std::move(duration),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void WebClientHandlerAsyncWaiter::CaptureScreenshot(
    CaptureScreenshotResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->CaptureScreenshot(
      base::BindOnce(
          [](base::RunLoop* loop,
             CaptureScreenshotResultPtr* out_result
,
             CaptureScreenshotResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

CaptureScreenshotResultPtr WebClientHandlerAsyncWaiter::CaptureScreenshot(
    ) {
  CaptureScreenshotResultPtr async_wait_result;
  CaptureScreenshot(&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::SetAudioDucking(
    bool enable, bool* out_result) {
  base::RunLoop loop;
  proxy_->SetAudioDucking(
      std::move(enable),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

bool WebClientHandlerAsyncWaiter::SetAudioDucking(
    bool enable) {
  bool async_wait_result;
  SetAudioDucking(std::move(enable),&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::SetPanelDraggableAreas(
    const std::vector<::gfx::Rect>& draggable_areas) {
  base::RunLoop loop;
  proxy_->SetPanelDraggableAreas(
      std::move(draggable_areas),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void WebClientHandlerAsyncWaiter::SetMicrophonePermissionState(
    bool enabled) {
  base::RunLoop loop;
  proxy_->SetMicrophonePermissionState(
      std::move(enabled),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void WebClientHandlerAsyncWaiter::SetLocationPermissionState(
    bool enabled) {
  base::RunLoop loop;
  proxy_->SetLocationPermissionState(
      std::move(enabled),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void WebClientHandlerAsyncWaiter::SetTabContextPermissionState(
    bool enabled) {
  base::RunLoop loop;
  proxy_->SetTabContextPermissionState(
      std::move(enabled),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void WebClientHandlerAsyncWaiter::SetClosedCaptioningSetting(
    bool enabled) {
  base::RunLoop loop;
  proxy_->SetClosedCaptioningSetting(
      std::move(enabled),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void WebClientHandlerAsyncWaiter::ShouldAllowMediaPermissionRequest(
    bool* out_is_allowed) {
  base::RunLoop loop;
  proxy_->ShouldAllowMediaPermissionRequest(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_allowed
,
             bool is_allowed) {*out_is_allowed = std::move(is_allowed);
            loop->Quit();
          },
          &loop,
          out_is_allowed));
  loop.Run();
}

bool WebClientHandlerAsyncWaiter::ShouldAllowMediaPermissionRequest(
    ) {
  bool async_wait_result;
  ShouldAllowMediaPermissionRequest(&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::ShouldAllowGeolocationPermissionRequest(
    bool* out_is_allowed) {
  base::RunLoop loop;
  proxy_->ShouldAllowGeolocationPermissionRequest(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_allowed
,
             bool is_allowed) {*out_is_allowed = std::move(is_allowed);
            loop->Quit();
          },
          &loop,
          out_is_allowed));
  loop.Run();
}

bool WebClientHandlerAsyncWaiter::ShouldAllowGeolocationPermissionRequest(
    ) {
  bool async_wait_result;
  ShouldAllowGeolocationPermissionRequest(&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::GetUserProfileInfo(
    UserProfileInfoPtr* out_profile_info) {
  base::RunLoop loop;
  proxy_->GetUserProfileInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             UserProfileInfoPtr* out_profile_info
,
             UserProfileInfoPtr profile_info) {*out_profile_info = std::move(profile_info);
            loop->Quit();
          },
          &loop,
          out_profile_info));
  loop.Run();
}

UserProfileInfoPtr WebClientHandlerAsyncWaiter::GetUserProfileInfo(
    ) {
  UserProfileInfoPtr async_wait_result;
  GetUserProfileInfo(&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::SyncCookies(
    bool* out_success) {
  base::RunLoop loop;
  proxy_->SyncCookies(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool WebClientHandlerAsyncWaiter::SyncCookies(
    ) {
  bool async_wait_result;
  SyncCookies(&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::JournalSnapshot(
    bool clear_journal, JournalPtr* out_journal) {
  base::RunLoop loop;
  proxy_->JournalSnapshot(
      std::move(clear_journal),
      base::BindOnce(
          [](base::RunLoop* loop,
             JournalPtr* out_journal
,
             JournalPtr journal) {*out_journal = std::move(journal);
            loop->Quit();
          },
          &loop,
          out_journal));
  loop.Run();
}

JournalPtr WebClientHandlerAsyncWaiter::JournalSnapshot(
    bool clear_journal) {
  JournalPtr async_wait_result;
  JournalSnapshot(std::move(clear_journal),&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::ScrollTo(
    ScrollToParamsPtr params, std::optional<ScrollToErrorReason>* out_error_reason) {
  base::RunLoop loop;
  proxy_->ScrollTo(
      std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<ScrollToErrorReason>* out_error_reason
,
             std::optional<ScrollToErrorReason> error_reason) {*out_error_reason = std::move(error_reason);
            loop->Quit();
          },
          &loop,
          out_error_reason));
  loop.Run();
}

std::optional<ScrollToErrorReason> WebClientHandlerAsyncWaiter::ScrollTo(
    ScrollToParamsPtr params) {
  std::optional<ScrollToErrorReason> async_wait_result;
  ScrollTo(std::move(params),&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::GetOsMicrophonePermissionStatus(
    bool* out_enabled) {
  base::RunLoop loop;
  proxy_->GetOsMicrophonePermissionStatus(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_enabled
,
             bool enabled) {*out_enabled = std::move(enabled);
            loop->Quit();
          },
          &loop,
          out_enabled));
  loop.Run();
}

bool WebClientHandlerAsyncWaiter::GetOsMicrophonePermissionStatus(
    ) {
  bool async_wait_result;
  GetOsMicrophonePermissionStatus(&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::GetZeroStateSuggestionsAndSubscribe(
    bool is_live, ZeroStateSuggestionsOptionsPtr options, ZeroStateSuggestionsV2Ptr* out_zero_state_suggestions) {
  base::RunLoop loop;
  proxy_->GetZeroStateSuggestionsAndSubscribe(
      std::move(is_live),
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             ZeroStateSuggestionsV2Ptr* out_zero_state_suggestions
,
             ZeroStateSuggestionsV2Ptr zero_state_suggestions) {*out_zero_state_suggestions = std::move(zero_state_suggestions);
            loop->Quit();
          },
          &loop,
          out_zero_state_suggestions));
  loop.Run();
}

ZeroStateSuggestionsV2Ptr WebClientHandlerAsyncWaiter::GetZeroStateSuggestionsAndSubscribe(
    bool is_live, ZeroStateSuggestionsOptionsPtr options) {
  ZeroStateSuggestionsV2Ptr async_wait_result;
  GetZeroStateSuggestionsAndSubscribe(std::move(is_live),std::move(options),&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::GetZeroStateSuggestionsForFocusedTab(
    std::optional<bool> is_first_run, ZeroStateSuggestionsPtr* out_suggestions) {
  base::RunLoop loop;
  proxy_->GetZeroStateSuggestionsForFocusedTab(
      std::move(is_first_run),
      base::BindOnce(
          [](base::RunLoop* loop,
             ZeroStateSuggestionsPtr* out_suggestions
,
             ZeroStateSuggestionsPtr suggestions) {*out_suggestions = std::move(suggestions);
            loop->Quit();
          },
          &loop,
          out_suggestions));
  loop.Run();
}

ZeroStateSuggestionsPtr WebClientHandlerAsyncWaiter::GetZeroStateSuggestionsForFocusedTab(
    std::optional<bool> is_first_run) {
  ZeroStateSuggestionsPtr async_wait_result;
  GetZeroStateSuggestionsForFocusedTab(std::move(is_first_run),&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::IsDebuggerAttached(
    bool* out_is_attached_to_webview) {
  base::RunLoop loop;
  proxy_->IsDebuggerAttached(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_attached_to_webview
,
             bool is_attached_to_webview) {*out_is_attached_to_webview = std::move(is_attached_to_webview);
            loop->Quit();
          },
          &loop,
          out_is_attached_to_webview));
  loop.Run();
}

bool WebClientHandlerAsyncWaiter::IsDebuggerAttached(
    ) {
  bool async_wait_result;
  IsDebuggerAttached(&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::SubscribeToPageMetadata(
    int32_t tab_id, const std::vector<std::string>& names, bool* out_success) {
  base::RunLoop loop;
  proxy_->SubscribeToPageMetadata(
      std::move(tab_id),
      std::move(names),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool WebClientHandlerAsyncWaiter::SubscribeToPageMetadata(
    int32_t tab_id, const std::vector<std::string>& names) {
  bool async_wait_result;
  SubscribeToPageMetadata(std::move(tab_id),std::move(names),&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::SwitchConversation(
    ConversationInfoPtr info, std::optional<SwitchConversationErrorReason>* out_error_reason) {
  base::RunLoop loop;
  proxy_->SwitchConversation(
      std::move(info),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<SwitchConversationErrorReason>* out_error_reason
,
             std::optional<SwitchConversationErrorReason> error_reason) {*out_error_reason = std::move(error_reason);
            loop->Quit();
          },
          &loop,
          out_error_reason));
  loop.Run();
}

std::optional<SwitchConversationErrorReason> WebClientHandlerAsyncWaiter::SwitchConversation(
    ConversationInfoPtr info) {
  std::optional<SwitchConversationErrorReason> async_wait_result;
  SwitchConversation(std::move(info),&async_wait_result);
  return async_wait_result;
}

void WebClientHandlerAsyncWaiter::RegisterConversation(
    ConversationInfoPtr info, std::optional<RegisterConversationErrorReason>* out_error_reason) {
  base::RunLoop loop;
  proxy_->RegisterConversation(
      std::move(info),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<RegisterConversationErrorReason>* out_error_reason
,
             std::optional<RegisterConversationErrorReason> error_reason) {*out_error_reason = std::move(error_reason);
            loop->Quit();
          },
          &loop,
          out_error_reason));
  loop.Run();
}

std::optional<RegisterConversationErrorReason> WebClientHandlerAsyncWaiter::RegisterConversation(
    ConversationInfoPtr info) {
  std::optional<RegisterConversationErrorReason> async_wait_result;
  RegisterConversation(std::move(info),&async_wait_result);
  return async_wait_result;
}




void WebClientInterceptorForTesting::NotifyPanelWillOpen(PanelOpeningDataPtr panel_opening_data, NotifyPanelWillOpenCallback callback) {
  GetForwardingInterface()->NotifyPanelWillOpen(
    std::move(panel_opening_data)
    , std::move(callback));
}
void WebClientInterceptorForTesting::NotifyPanelWasClosed(NotifyPanelWasClosedCallback callback) {
  GetForwardingInterface()->NotifyPanelWasClosed(std::move(callback));
}
void WebClientInterceptorForTesting::NotifyPanelStateChange(PanelStatePtr panel_state) {
  GetForwardingInterface()->NotifyPanelStateChange(
    std::move(panel_state)
    );
}
void WebClientInterceptorForTesting::NotifyPanelActiveChange(bool panel_active) {
  GetForwardingInterface()->NotifyPanelActiveChange(
    std::move(panel_active)
    );
}
void WebClientInterceptorForTesting::NotifyPanelCanAttachChange(bool can_attach) {
  GetForwardingInterface()->NotifyPanelCanAttachChange(
    std::move(can_attach)
    );
}
void WebClientInterceptorForTesting::NotifyMicrophonePermissionStateChanged(bool enabled) {
  GetForwardingInterface()->NotifyMicrophonePermissionStateChanged(
    std::move(enabled)
    );
}
void WebClientInterceptorForTesting::NotifyLocationPermissionStateChanged(bool enabled) {
  GetForwardingInterface()->NotifyLocationPermissionStateChanged(
    std::move(enabled)
    );
}
void WebClientInterceptorForTesting::NotifyTabContextPermissionStateChanged(bool enabled) {
  GetForwardingInterface()->NotifyTabContextPermissionStateChanged(
    std::move(enabled)
    );
}
void WebClientInterceptorForTesting::NotifyOsLocationPermissionStateChanged(bool enabled) {
  GetForwardingInterface()->NotifyOsLocationPermissionStateChanged(
    std::move(enabled)
    );
}
void WebClientInterceptorForTesting::NotifyFocusedTabChanged(FocusedTabDataPtr focused_tab_data) {
  GetForwardingInterface()->NotifyFocusedTabChanged(
    std::move(focused_tab_data)
    );
}
void WebClientInterceptorForTesting::NotifyManualResizeChanged(bool resizing) {
  GetForwardingInterface()->NotifyManualResizeChanged(
    std::move(resizing)
    );
}
void WebClientInterceptorForTesting::NotifyOsHotkeyStateChanged(const std::string& hotkey) {
  GetForwardingInterface()->NotifyOsHotkeyStateChanged(
    std::move(hotkey)
    );
}
void WebClientInterceptorForTesting::NotifyBrowserIsOpenChanged(bool browser_is_open) {
  GetForwardingInterface()->NotifyBrowserIsOpenChanged(
    std::move(browser_is_open)
    );
}
void WebClientInterceptorForTesting::NotifyBrowserIsActiveChanged(bool browser_active) {
  GetForwardingInterface()->NotifyBrowserIsActiveChanged(
    std::move(browser_active)
    );
}
void WebClientInterceptorForTesting::NotifyActiveBrowserChanged(ActiveBrowserInfoPtr active_browser_info) {
  GetForwardingInterface()->NotifyActiveBrowserChanged(
    std::move(active_browser_info)
    );
}
void WebClientInterceptorForTesting::NotifyClosedCaptioningSettingChanged(bool enabled) {
  GetForwardingInterface()->NotifyClosedCaptioningSettingChanged(
    std::move(enabled)
    );
}
void WebClientInterceptorForTesting::NotifyPinnedTabsChanged(std::vector<TabDataPtr> tab_data) {
  GetForwardingInterface()->NotifyPinnedTabsChanged(
    std::move(tab_data)
    );
}
void WebClientInterceptorForTesting::NotifyPinnedTabDataChanged(TabDataPtr tab_data) {
  GetForwardingInterface()->NotifyPinnedTabDataChanged(
    std::move(tab_data)
    );
}
void WebClientInterceptorForTesting::NotifyZeroStateSuggestionsChanged(ZeroStateSuggestionsV2Ptr suggestions, ZeroStateSuggestionsOptionsPtr options) {
  GetForwardingInterface()->NotifyZeroStateSuggestionsChanged(
    std::move(suggestions)
    , 
    std::move(options)
    );
}
void WebClientInterceptorForTesting::NotifyActorTaskStateChanged(int32_t task_id, ActorTaskState state) {
  GetForwardingInterface()->NotifyActorTaskStateChanged(
    std::move(task_id)
    , 
    std::move(state)
    );
}
void WebClientInterceptorForTesting::RequestViewChange(ViewChangeRequestPtr request) {
  GetForwardingInterface()->RequestViewChange(
    std::move(request)
    );
}
void WebClientInterceptorForTesting::NotifyPageMetadataChanged(int32_t tab_id, ::blink::mojom::PageMetadataPtr metadata) {
  GetForwardingInterface()->NotifyPageMetadataChanged(
    std::move(tab_id)
    , 
    std::move(metadata)
    );
}
void WebClientInterceptorForTesting::NotifyDefaultTabContextPermissionStateChanged(bool enabled) {
  GetForwardingInterface()->NotifyDefaultTabContextPermissionStateChanged(
    std::move(enabled)
    );
}
void WebClientInterceptorForTesting::RequestToShowCredentialSelectionDialog(::actor::webui::mojom::SelectCredentialDialogRequestPtr request, RequestToShowCredentialSelectionDialogCallback callback) {
  GetForwardingInterface()->RequestToShowCredentialSelectionDialog(
    std::move(request)
    , std::move(callback));
}
void WebClientInterceptorForTesting::RequestToShowUserConfirmationDialog(::actor::webui::mojom::UserConfirmationDialogRequestPtr request, RequestToShowUserConfirmationDialogCallback callback) {
  GetForwardingInterface()->RequestToShowUserConfirmationDialog(
    std::move(request)
    , std::move(callback));
}
void WebClientInterceptorForTesting::NotifyAdditionalContext(AdditionalContextPtr context) {
  GetForwardingInterface()->NotifyAdditionalContext(
    std::move(context)
    );
}
WebClientAsyncWaiter::WebClientAsyncWaiter(
    WebClient* proxy) : proxy_(proxy) {}

WebClientAsyncWaiter::~WebClientAsyncWaiter() = default;


void WebClientAsyncWaiter::NotifyPanelWillOpen(
    PanelOpeningDataPtr panel_opening_data, OpenPanelInfoPtr* out_openPanelInfo) {
  base::RunLoop loop;
  proxy_->NotifyPanelWillOpen(
      std::move(panel_opening_data),
      base::BindOnce(
          [](base::RunLoop* loop,
             OpenPanelInfoPtr* out_openPanelInfo
,
             OpenPanelInfoPtr openPanelInfo) {*out_openPanelInfo = std::move(openPanelInfo);
            loop->Quit();
          },
          &loop,
          out_openPanelInfo));
  loop.Run();
}

OpenPanelInfoPtr WebClientAsyncWaiter::NotifyPanelWillOpen(
    PanelOpeningDataPtr panel_opening_data) {
  OpenPanelInfoPtr async_wait_result;
  NotifyPanelWillOpen(std::move(panel_opening_data),&async_wait_result);
  return async_wait_result;
}

void WebClientAsyncWaiter::NotifyPanelWasClosed(
    ) {
  base::RunLoop loop;
  proxy_->NotifyPanelWasClosed(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void WebClientAsyncWaiter::RequestToShowCredentialSelectionDialog(
    ::actor::webui::mojom::SelectCredentialDialogRequestPtr request, ::actor::webui::mojom::SelectCredentialDialogResponsePtr* out_response) {
  base::RunLoop loop;
  proxy_->RequestToShowCredentialSelectionDialog(
      std::move(request),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::actor::webui::mojom::SelectCredentialDialogResponsePtr* out_response
,
             ::actor::webui::mojom::SelectCredentialDialogResponsePtr response) {*out_response = std::move(response);
            loop->Quit();
          },
          &loop,
          out_response));
  loop.Run();
}

::actor::webui::mojom::SelectCredentialDialogResponsePtr WebClientAsyncWaiter::RequestToShowCredentialSelectionDialog(
    ::actor::webui::mojom::SelectCredentialDialogRequestPtr request) {
  ::actor::webui::mojom::SelectCredentialDialogResponsePtr async_wait_result;
  RequestToShowCredentialSelectionDialog(std::move(request),&async_wait_result);
  return async_wait_result;
}

void WebClientAsyncWaiter::RequestToShowUserConfirmationDialog(
    ::actor::webui::mojom::UserConfirmationDialogRequestPtr request, ::actor::webui::mojom::UserConfirmationDialogResponsePtr* out_response) {
  base::RunLoop loop;
  proxy_->RequestToShowUserConfirmationDialog(
      std::move(request),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::actor::webui::mojom::UserConfirmationDialogResponsePtr* out_response
,
             ::actor::webui::mojom::UserConfirmationDialogResponsePtr response) {*out_response = std::move(response);
            loop->Quit();
          },
          &loop,
          out_response));
  loop.Run();
}

::actor::webui::mojom::UserConfirmationDialogResponsePtr WebClientAsyncWaiter::RequestToShowUserConfirmationDialog(
    ::actor::webui::mojom::UserConfirmationDialogRequestPtr request) {
  ::actor::webui::mojom::UserConfirmationDialogResponsePtr async_wait_result;
  RequestToShowUserConfirmationDialog(std::move(request),&async_wait_result);
  return async_wait_result;
}






}  // glic::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif