// chrome/browser/glic/host/glic.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_GLIC_HOST_GLIC_MOJOM_SEND_VALIDATION_H_
#define CHROME_BROWSER_GLIC_HOST_GLIC_MOJOM_SEND_VALIDATION_H_

#include "chrome/browser/glic/host/glic.mojom-shared-internal.h"
#include "chrome/browser/glic/host/glic_features.mojom-shared.h"
#include "chrome/common/actor_webui.mojom-shared.h"
#include "components/content_settings/core/common/content_settings_types.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/proto_wrapper.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/version.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "third_party/blink/public/mojom/content_extraction/ai_page_content_metadata.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "chrome/browser/glic/host/glic.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::glic::mojom::ProfileReadyState, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::glic::mojom::WebUiState, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::glic::mojom::MetricUserInputReactionType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::glic::mojom::PrepareForClientResult, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::glic::mojom::PerformActionsErrorReason, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::glic::mojom::CreateTaskErrorReason, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::glic::mojom::ActorTaskState, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::glic::mojom::ActorTaskPauseReason, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::glic::mojom::ActorTaskStopReason, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::glic::mojom::CaptureScreenshotErrorReason, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::glic::mojom::ScrollToErrorReason, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::glic::mojom::SwitchConversationErrorReason, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::glic::mojom::RegisterConversationErrorReason, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::glic::mojom::InvocationSource, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::glic::mojom::WebClientMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::glic::mojom::WebClientModel, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::glic::mojom::ResponseStopCause, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::glic::mojom::SettingsPageField, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::glic::mojom::HostCapability, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::glic::mojom::CurrentView, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::UserProfileInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::UserProfileInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::UserProfileInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::avatar_icon(input)) in_avatar_icon = Traits::avatar_icon(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->avatar_icon)::BaseType> avatar_icon_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::BitmapN32DataView, send_validation>(
        in_avatar_icon,
        avatar_icon_fragment);

      fragment->avatar_icon.Set(
          avatar_icon_fragment.is_null() ? nullptr : avatar_icon_fragment.data());

      decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->display_name)::BaseType> display_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_display_name,
        display_name_fragment);

      fragment->display_name.Set(
          display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->display_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_name in UserProfileInfo struct");

      decltype(Traits::local_profile_name(input)) in_local_profile_name = Traits::local_profile_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->local_profile_name)::BaseType> local_profile_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_local_profile_name,
        local_profile_name_fragment);

      fragment->local_profile_name.Set(
          local_profile_name_fragment.is_null() ? nullptr : local_profile_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->local_profile_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null local_profile_name in UserProfileInfo struct");

      decltype(Traits::email(input)) in_email = Traits::email(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->email)::BaseType> email_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_email,
        email_fragment);

      fragment->email.Set(
          email_fragment.is_null() ? nullptr : email_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->email.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null email in UserProfileInfo struct");

      decltype(Traits::given_name(input)) in_given_name = Traits::given_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->given_name)::BaseType> given_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_given_name,
        given_name_fragment);

      fragment->given_name.Set(
          given_name_fragment.is_null() ? nullptr : given_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->given_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null given_name in UserProfileInfo struct");

      fragment->is_managed = Traits::is_managed(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::ActiveBrowserInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ActiveBrowserInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ActiveBrowserInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->window_id = Traits::window_id(input);

      fragment->using_this_profile = Traits::using_this_profile(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::WebClientInitialStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::WebClientInitialStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::WebClientInitialState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::panel_state(input)) in_panel_state = Traits::panel_state(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->panel_state)::BaseType> panel_state_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::glic::mojom::PanelStateDataView, send_validation>(
        in_panel_state,
        panel_state_fragment);

      fragment->panel_state.Set(
          panel_state_fragment.is_null() ? nullptr : panel_state_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->panel_state.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null panel_state in WebClientInitialState struct");

      decltype(Traits::focused_tab_data(input)) in_focused_tab_data = Traits::focused_tab_data(input);
      mojo::internal::MessageFragment<decltype(fragment->focused_tab_data)>
          focused_tab_data_fragment(fragment.message());
      focused_tab_data_fragment.Claim(&fragment->focused_tab_data);
      
      mojo::internal::Serialize<::glic::mojom::FocusedTabDataDataView, send_validation>(
        in_focused_tab_data,
        focused_tab_data_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->focused_tab_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null focused_tab_data in WebClientInitialState struct");

      fragment->microphone_permission_enabled = Traits::microphone_permission_enabled(input);

      fragment->location_permission_enabled = Traits::location_permission_enabled(input);

      fragment->tab_context_permission_enabled = Traits::tab_context_permission_enabled(input);

      fragment->os_location_permission_enabled = Traits::os_location_permission_enabled(input);

      decltype(Traits::hotkey(input)) in_hotkey = Traits::hotkey(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hotkey)::BaseType> hotkey_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_hotkey,
        hotkey_fragment);

      fragment->hotkey.Set(
          hotkey_fragment.is_null() ? nullptr : hotkey_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->hotkey.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hotkey in WebClientInitialState struct");

      decltype(Traits::chrome_version(input)) in_chrome_version = Traits::chrome_version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->chrome_version)::BaseType> chrome_version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::VersionDataView, send_validation>(
        in_chrome_version,
        chrome_version_fragment);

      fragment->chrome_version.Set(
          chrome_version_fragment.is_null() ? nullptr : chrome_version_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->chrome_version.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null chrome_version in WebClientInitialState struct");

      fragment->can_attach = Traits::can_attach(input);

      fragment->panel_is_active = Traits::panel_is_active(input);

      fragment->browser_is_open = Traits::browser_is_open(input);

      fragment->browser_is_active = Traits::browser_is_active(input);

      decltype(Traits::active_browser_info(input)) in_active_browser_info = Traits::active_browser_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->active_browser_info)::BaseType> active_browser_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::glic::mojom::ActiveBrowserInfoDataView, send_validation>(
        in_active_browser_info,
        active_browser_info_fragment);

      fragment->active_browser_info.Set(
          active_browser_info_fragment.is_null() ? nullptr : active_browser_info_fragment.data());

      fragment->always_detached_mode = Traits::always_detached_mode(input);

      fragment->enable_zero_state_suggestions = Traits::enable_zero_state_suggestions(input);

      fragment->enable_act_in_focused_tab = Traits::enable_act_in_focused_tab(input);

      fragment->enable_scroll_to = Traits::enable_scroll_to(input);

      fragment->enable_default_tab_context_setting_feature = Traits::enable_default_tab_context_setting_feature(input);

      fragment->default_tab_context_setting_enabled = Traits::default_tab_context_setting_enabled(input);

      fragment->enable_closed_captioning_feature = Traits::enable_closed_captioning_feature(input);

      fragment->closed_captioning_setting_enabled = Traits::closed_captioning_setting_enabled(input);

      fragment->enable_maybe_refresh_user_status = Traits::enable_maybe_refresh_user_status(input);

      fragment->enable_multi_tab = Traits::enable_multi_tab(input);

      fragment->enable_get_context_actor = Traits::enable_get_context_actor(input);

      decltype(Traits::host_capabilities(input)) in_host_capabilities = Traits::host_capabilities(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->host_capabilities)::BaseType>
          host_capabilities_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& host_capabilities_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::glic::mojom::internal::HostCapability_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::glic::mojom::HostCapability>, send_validation>(
        in_host_capabilities,
        host_capabilities_fragment,
        &host_capabilities_validate_params);

      fragment->host_capabilities.Set(
          host_capabilities_fragment.is_null() ? nullptr : host_capabilities_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->host_capabilities.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null host_capabilities in WebClientInitialState struct");

      fragment->enable_get_page_metadata = Traits::enable_get_page_metadata(input);

      fragment->enable_api_activation_gating = Traits::enable_api_activation_gating(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::GetTabContextOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::GetTabContextOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::GetTabContextOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->include_inner_text = Traits::include_inner_text(input);

      fragment->inner_text_bytes_limit = Traits::inner_text_bytes_limit(input);

      fragment->include_viewport_screenshot = Traits::include_viewport_screenshot(input);

      fragment->include_annotated_page_content = Traits::include_annotated_page_content(input);

      fragment->max_meta_tags = Traits::max_meta_tags(input);

      fragment->include_pdf = Traits::include_pdf(input);

      fragment->pdf_size_limit = Traits::pdf_size_limit(input);

      fragment->annotated_page_content_mode = Traits::annotated_page_content_mode(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::GetPinCandidatesOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::GetPinCandidatesOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::GetPinCandidatesOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->max_candidates = Traits::max_candidates(input);

      decltype(Traits::query(input)) in_query = Traits::query(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->query)::BaseType> query_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_query,
        query_fragment);

      fragment->query.Set(
          query_fragment.is_null() ? nullptr : query_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::ScrollToParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ScrollToParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ScrollToParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::selector(input)) in_selector = Traits::selector(input);
      mojo::internal::MessageFragment<decltype(fragment->selector)>
          selector_fragment(fragment.message());
      selector_fragment.Claim(&fragment->selector);
      
      mojo::internal::Serialize<::glic::mojom::ScrollToSelectorDataView, send_validation>(
        in_selector,
        selector_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->selector.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null selector in ScrollToParams struct");

      fragment->highlight = Traits::highlight(input);

      decltype(Traits::document_id(input)) in_document_id = Traits::document_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->document_id)::BaseType> document_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_document_id,
        document_id_fragment);

      fragment->document_id.Set(
          document_id_fragment.is_null() ? nullptr : document_id_fragment.data());

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::ScrollToTextSelectorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ScrollToTextSelectorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ScrollToTextSelector_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::text(input)) in_text = Traits::text(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text)::BaseType> text_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_text,
        text_fragment);

      fragment->text.Set(
          text_fragment.is_null() ? nullptr : text_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->text.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text in ScrollToTextSelector struct");
      fragment->search_range_start_node_id_$flag = Traits::search_range_start_node_id(input).has_value();
      if (Traits::search_range_start_node_id(input).has_value()) {
        fragment->search_range_start_node_id_$value = Traits::search_range_start_node_id(input).value();
      }
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::ScrollToTextFragmentSelectorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ScrollToTextFragmentSelectorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ScrollToTextFragmentSelector_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::text_start(input)) in_text_start = Traits::text_start(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text_start)::BaseType> text_start_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_text_start,
        text_start_fragment);

      fragment->text_start.Set(
          text_start_fragment.is_null() ? nullptr : text_start_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->text_start.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_start in ScrollToTextFragmentSelector struct");

      decltype(Traits::text_end(input)) in_text_end = Traits::text_end(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text_end)::BaseType> text_end_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_text_end,
        text_end_fragment);

      fragment->text_end.Set(
          text_end_fragment.is_null() ? nullptr : text_end_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->text_end.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_end in ScrollToTextFragmentSelector struct");
      fragment->search_range_start_node_id_$flag = Traits::search_range_start_node_id(input).has_value();
      if (Traits::search_range_start_node_id(input).has_value()) {
        fragment->search_range_start_node_id_$value = Traits::search_range_start_node_id(input).value();
      }
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::ScrollToNodeSelectorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ScrollToNodeSelectorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ScrollToNodeSelector_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->node_id = Traits::node_id(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::SuggestionContentDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::SuggestionContentDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::SuggestionContent_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::suggestion(input)) in_suggestion = Traits::suggestion(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->suggestion)::BaseType> suggestion_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_suggestion,
        suggestion_fragment);

      fragment->suggestion.Set(
          suggestion_fragment.is_null() ? nullptr : suggestion_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->suggestion.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null suggestion in SuggestionContent struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::ZeroStateSuggestionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ZeroStateSuggestionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ZeroStateSuggestions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::suggestions(input)) in_suggestions = Traits::suggestions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->suggestions)::BaseType>
          suggestions_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& suggestions_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::glic::mojom::SuggestionContentDataView>, send_validation>(
        in_suggestions,
        suggestions_fragment,
        &suggestions_validate_params);

      fragment->suggestions.Set(
          suggestions_fragment.is_null() ? nullptr : suggestions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->suggestions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null suggestions in ZeroStateSuggestions struct");

      fragment->tab_id = Traits::tab_id(input);

      decltype(Traits::tab_url(input)) in_tab_url = Traits::tab_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tab_url)::BaseType> tab_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_tab_url,
        tab_url_fragment);

      fragment->tab_url.Set(
          tab_url_fragment.is_null() ? nullptr : tab_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tab_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tab_url in ZeroStateSuggestions struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::ZeroStateSuggestionsV2DataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ZeroStateSuggestionsV2DataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ZeroStateSuggestionsV2_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::suggestions(input)) in_suggestions = Traits::suggestions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->suggestions)::BaseType>
          suggestions_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& suggestions_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::glic::mojom::SuggestionContentDataView>, send_validation>(
        in_suggestions,
        suggestions_fragment,
        &suggestions_validate_params);

      fragment->suggestions.Set(
          suggestions_fragment.is_null() ? nullptr : suggestions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->suggestions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null suggestions in ZeroStateSuggestionsV2 struct");

      fragment->is_pending = Traits::is_pending(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::ZeroStateSuggestionsOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ZeroStateSuggestionsOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ZeroStateSuggestionsOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->is_first_run = Traits::is_first_run(input);

      decltype(Traits::supported_tools(input)) in_supported_tools = Traits::supported_tools(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->supported_tools)::BaseType>
          supported_tools_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& supported_tools_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_supported_tools,
        supported_tools_fragment,
        &supported_tools_validate_params);

      fragment->supported_tools.Set(
          supported_tools_fragment.is_null() ? nullptr : supported_tools_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->supported_tools.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null supported_tools in ZeroStateSuggestionsOptions struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::PinCandidateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::PinCandidateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::PinCandidate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::tab_data(input)) in_tab_data = Traits::tab_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tab_data)::BaseType> tab_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::glic::mojom::TabDataDataView, send_validation>(
        in_tab_data,
        tab_data_fragment);

      fragment->tab_data.Set(
          tab_data_fragment.is_null() ? nullptr : tab_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tab_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tab_data in PinCandidate struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::ConversationInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ConversationInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ConversationInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::conversation_id(input)) in_conversation_id = Traits::conversation_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->conversation_id)::BaseType> conversation_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_conversation_id,
        conversation_id_fragment);

      fragment->conversation_id.Set(
          conversation_id_fragment.is_null() ? nullptr : conversation_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->conversation_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null conversation_id in ConversationInfo struct");

      decltype(Traits::conversation_title(input)) in_conversation_title = Traits::conversation_title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->conversation_title)::BaseType> conversation_title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_conversation_title,
        conversation_title_fragment);

      fragment->conversation_title.Set(
          conversation_title_fragment.is_null() ? nullptr : conversation_title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->conversation_title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null conversation_title in ConversationInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::PanelOpeningDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::PanelOpeningDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::PanelOpeningData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::panel_state(input)) in_panel_state = Traits::panel_state(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->panel_state)::BaseType> panel_state_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::glic::mojom::PanelStateDataView, send_validation>(
        in_panel_state,
        panel_state_fragment);

      fragment->panel_state.Set(
          panel_state_fragment.is_null() ? nullptr : panel_state_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->panel_state.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null panel_state in PanelOpeningData struct");

      
      mojo::internal::Serialize<::glic::mojom::InvocationSource>(
        Traits::invocation_source(input),
        &fragment->invocation_source);

      decltype(Traits::conversation_id(input)) in_conversation_id = Traits::conversation_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->conversation_id)::BaseType> conversation_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_conversation_id,
        conversation_id_fragment);

      fragment->conversation_id.Set(
          conversation_id_fragment.is_null() ? nullptr : conversation_id_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::PanelStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::PanelStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::PanelState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::glic::mojom::PanelState_Kind>(
        Traits::kind(input),
        &fragment->kind);
      fragment->window_id_$flag = Traits::window_id(input).has_value();
      if (Traits::window_id(input).has_value()) {
        fragment->window_id_$value = Traits::window_id(input).value();
      }
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::OnResponseStoppedDetailsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::OnResponseStoppedDetailsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::OnResponseStoppedDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::glic::mojom::ResponseStopCause>(
        Traits::cause(input),
        &fragment->cause);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::OpenPanelInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::OpenPanelInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::OpenPanelInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::glic::mojom::WebClientMode>(
        Traits::web_client_mode(input),
        &fragment->web_client_mode);

      decltype(Traits::panelSize(input)) in_panelSize = Traits::panelSize(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->panelSize)::BaseType> panelSize_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_panelSize,
        panelSize_fragment);

      fragment->panelSize.Set(
          panelSize_fragment.is_null() ? nullptr : panelSize_fragment.data());

      decltype(Traits::resizeDuration(input)) in_resizeDuration = Traits::resizeDuration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->resizeDuration)::BaseType> resizeDuration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_resizeDuration,
        resizeDuration_fragment);

      fragment->resizeDuration.Set(
          resizeDuration_fragment.is_null() ? nullptr : resizeDuration_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->resizeDuration.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null resizeDuration in OpenPanelInfo struct");

      fragment->can_user_resize = Traits::can_user_resize(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::ContextDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ContextDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ContextData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_mime_type,
        mime_type_fragment);

      fragment->mime_type.Set(
          mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mime_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mime_type in ContextData struct");

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<decltype(fragment->data)>
          data_fragment(fragment.message());
      data_fragment.Claim(&fragment->data);
      
      mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView, send_validation>(
        in_data,
        data_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in ContextData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::AdditionalContextDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::AdditionalContextDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::AdditionalContext_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());
      fragment->tab_id_$flag = Traits::tab_id(input).has_value();
      if (Traits::tab_id(input).has_value()) {
        fragment->tab_id_$value = Traits::tab_id(input).value();
      }

      decltype(Traits::origin(input)) in_origin = Traits::origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin)::BaseType> origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_origin,
        origin_fragment);

      fragment->origin.Set(
          origin_fragment.is_null() ? nullptr : origin_fragment.data());

      decltype(Traits::frameUrl(input)) in_frameUrl = Traits::frameUrl(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->frameUrl)::BaseType> frameUrl_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_frameUrl,
        frameUrl_fragment);

      fragment->frameUrl.Set(
          frameUrl_fragment.is_null() ? nullptr : frameUrl_fragment.data());

      decltype(Traits::parts(input)) in_parts = Traits::parts(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->parts)::BaseType>
          parts_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& parts_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::glic::mojom::AdditionalContextPartDataView>, send_validation>(
        in_parts,
        parts_fragment,
        &parts_validate_params);

      fragment->parts.Set(
          parts_fragment.is_null() ? nullptr : parts_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->parts.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null parts in AdditionalContext struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::TabContextDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::TabContextDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::TabContext_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::tab_data(input)) in_tab_data = Traits::tab_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tab_data)::BaseType> tab_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::glic::mojom::TabDataDataView, send_validation>(
        in_tab_data,
        tab_data_fragment);

      fragment->tab_data.Set(
          tab_data_fragment.is_null() ? nullptr : tab_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tab_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tab_data in TabContext struct");

      decltype(Traits::web_page_data(input)) in_web_page_data = Traits::web_page_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->web_page_data)::BaseType> web_page_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::glic::mojom::WebPageDataDataView, send_validation>(
        in_web_page_data,
        web_page_data_fragment);

      fragment->web_page_data.Set(
          web_page_data_fragment.is_null() ? nullptr : web_page_data_fragment.data());

      decltype(Traits::viewport_screenshot(input)) in_viewport_screenshot = Traits::viewport_screenshot(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->viewport_screenshot)::BaseType> viewport_screenshot_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::glic::mojom::ScreenshotDataView, send_validation>(
        in_viewport_screenshot,
        viewport_screenshot_fragment);

      fragment->viewport_screenshot.Set(
          viewport_screenshot_fragment.is_null() ? nullptr : viewport_screenshot_fragment.data());

      decltype(Traits::pdf_document_data(input)) in_pdf_document_data = Traits::pdf_document_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pdf_document_data)::BaseType> pdf_document_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::glic::mojom::PdfDocumentDataDataView, send_validation>(
        in_pdf_document_data,
        pdf_document_data_fragment);

      fragment->pdf_document_data.Set(
          pdf_document_data_fragment.is_null() ? nullptr : pdf_document_data_fragment.data());

      decltype(Traits::annotated_page_data(input)) in_annotated_page_data = Traits::annotated_page_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->annotated_page_data)::BaseType> annotated_page_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::glic::mojom::AnnotatedPageDataDataView, send_validation>(
        in_annotated_page_data,
        annotated_page_data_fragment);

      fragment->annotated_page_data.Set(
          annotated_page_data_fragment.is_null() ? nullptr : annotated_page_data_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::WebPageDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::WebPageDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::WebPageData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::main_document(input)) in_main_document = Traits::main_document(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->main_document)::BaseType> main_document_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::glic::mojom::DocumentDataDataView, send_validation>(
        in_main_document,
        main_document_fragment);

      fragment->main_document.Set(
          main_document_fragment.is_null() ? nullptr : main_document_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->main_document.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null main_document in WebPageData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::DocumentDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::DocumentDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::DocumentData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::origin(input)) in_origin = Traits::origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin)::BaseType> origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_origin,
        origin_fragment);

      fragment->origin.Set(
          origin_fragment.is_null() ? nullptr : origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in DocumentData struct");

      decltype(Traits::inner_text(input)) in_inner_text = Traits::inner_text(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->inner_text)::BaseType> inner_text_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_inner_text,
        inner_text_fragment);

      fragment->inner_text.Set(
          inner_text_fragment.is_null() ? nullptr : inner_text_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->inner_text.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null inner_text in DocumentData struct");

      fragment->inner_text_truncated = Traits::inner_text_truncated(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::PdfDocumentDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::PdfDocumentDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::PdfDocumentData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::origin(input)) in_origin = Traits::origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin)::BaseType> origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_origin,
        origin_fragment);

      fragment->origin.Set(
          origin_fragment.is_null() ? nullptr : origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in PdfDocumentData struct");

      decltype(Traits::pdf_data(input)) in_pdf_data = Traits::pdf_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pdf_data)::BaseType>
          pdf_data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& pdf_data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_pdf_data,
        pdf_data_fragment,
        &pdf_data_validate_params);

      fragment->pdf_data.Set(
          pdf_data_fragment.is_null() ? nullptr : pdf_data_fragment.data());

      fragment->size_limit_exceeded = Traits::size_limit_exceeded(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::TabDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::TabDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::TabData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->tab_id = Traits::tab_id(input);

      fragment->window_id = Traits::window_id(input);

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in TabData struct");

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      decltype(Traits::favicon(input)) in_favicon = Traits::favicon(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->favicon)::BaseType> favicon_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::BitmapN32DataView, send_validation>(
        in_favicon,
        favicon_fragment);

      fragment->favicon.Set(
          favicon_fragment.is_null() ? nullptr : favicon_fragment.data());

      decltype(Traits::favicon_url(input)) in_favicon_url = Traits::favicon_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->favicon_url)::BaseType> favicon_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_favicon_url,
        favicon_url_fragment);

      fragment->favicon_url.Set(
          favicon_url_fragment.is_null() ? nullptr : favicon_url_fragment.data());

      decltype(Traits::document_mime_type(input)) in_document_mime_type = Traits::document_mime_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->document_mime_type)::BaseType> document_mime_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_document_mime_type,
        document_mime_type_fragment);

      fragment->document_mime_type.Set(
          document_mime_type_fragment.is_null() ? nullptr : document_mime_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->document_mime_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null document_mime_type in TabData struct");
      fragment->is_observable_$flag = Traits::is_observable(input).has_value();
      if (Traits::is_observable(input).has_value()) {
        fragment->is_observable_$value = Traits::is_observable(input).value();
      }
      fragment->is_media_active_$flag = Traits::is_media_active(input).has_value();
      if (Traits::is_media_active(input).has_value()) {
        fragment->is_media_active_$value = Traits::is_media_active(input).value();
      }
      fragment->is_tab_content_captured_$flag = Traits::is_tab_content_captured(input).has_value();
      if (Traits::is_tab_content_captured(input).has_value()) {
        fragment->is_tab_content_captured_$value = Traits::is_tab_content_captured(input).value();
      }
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::NoFocusedTabDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::NoFocusedTabDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::NoFocusedTabData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::active_tab_data(input)) in_active_tab_data = Traits::active_tab_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->active_tab_data)::BaseType> active_tab_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::glic::mojom::TabDataDataView, send_validation>(
        in_active_tab_data,
        active_tab_data_fragment);

      fragment->active_tab_data.Set(
          active_tab_data_fragment.is_null() ? nullptr : active_tab_data_fragment.data());

      decltype(Traits::no_focus_reason(input)) in_no_focus_reason = Traits::no_focus_reason(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->no_focus_reason)::BaseType> no_focus_reason_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_no_focus_reason,
        no_focus_reason_fragment);

      fragment->no_focus_reason.Set(
          no_focus_reason_fragment.is_null() ? nullptr : no_focus_reason_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->no_focus_reason.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null no_focus_reason in NoFocusedTabData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::AnnotatedPageDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::AnnotatedPageDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::AnnotatedPageData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::annotated_page_content(input)) in_annotated_page_content = Traits::annotated_page_content(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->annotated_page_content)::BaseType> annotated_page_content_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ProtoWrapperDataView, send_validation>(
        in_annotated_page_content,
        annotated_page_content_fragment);

      fragment->annotated_page_content.Set(
          annotated_page_content_fragment.is_null() ? nullptr : annotated_page_content_fragment.data());

      decltype(Traits::metadata(input)) in_metadata = Traits::metadata(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->metadata)::BaseType> metadata_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::PageMetadataDataView, send_validation>(
        in_metadata,
        metadata_fragment);

      fragment->metadata.Set(
          metadata_fragment.is_null() ? nullptr : metadata_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::ImageOriginAnnotationsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ImageOriginAnnotationsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ImageOriginAnnotations_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::JournalDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::JournalDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::Journal_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->data)::BaseType>
          data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_data,
        data_fragment,
        &data_validate_params);

      fragment->data.Set(
          data_fragment.is_null() ? nullptr : data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in Journal struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::ScreenshotDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ScreenshotDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::Screenshot_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->width_pixels = Traits::width_pixels(input);

      fragment->height_pixels = Traits::height_pixels(input);

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->data)::BaseType>
          data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_data,
        data_fragment,
        &data_validate_params);

      fragment->data.Set(
          data_fragment.is_null() ? nullptr : data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in Screenshot struct");

      decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_mime_type,
        mime_type_fragment);

      fragment->mime_type.Set(
          mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mime_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mime_type in Screenshot struct");

      decltype(Traits::origin_annotations(input)) in_origin_annotations = Traits::origin_annotations(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin_annotations)::BaseType> origin_annotations_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::glic::mojom::ImageOriginAnnotationsDataView, send_validation>(
        in_origin_annotations,
        origin_annotations_fragment);

      fragment->origin_annotations.Set(
          origin_annotations_fragment.is_null() ? nullptr : origin_annotations_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->origin_annotations.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin_annotations in Screenshot struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::OpenSettingsOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::OpenSettingsOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::OpenSettingsOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::glic::mojom::SettingsPageField>(
        Traits::highlightField(input),
        &fragment->highlightField);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::ViewChangeRequestActuationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ViewChangeRequestActuationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ViewChangeRequestActuation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::ViewChangeRequestConversationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ViewChangeRequestConversationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ViewChangeRequestConversation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::ViewChangeRequestDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ViewChangeRequestDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ViewChangeRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::details(input)) in_details = Traits::details(input);
      mojo::internal::MessageFragment<decltype(fragment->details)>
          details_fragment(fragment.message());
      details_fragment.Claim(&fragment->details);
      
      mojo::internal::Serialize<::glic::mojom::ViewChangeRequestDetailsDataView, send_validation>(
        in_details,
        details_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->details.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null details in ViewChangeRequest struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::ViewChangedNotificationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ViewChangedNotificationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ViewChangedNotification_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::glic::mojom::CurrentView>(
        Traits::current_view(input),
        &fragment->current_view);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::GetContextResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::glic::mojom::GetContextResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::glic::mojom::internal::GetContextResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::glic::mojom::GetContextResultDataView::Tag::kErrorReason: {
    decltype(Traits::error_reason(input))
    in_error_reason = Traits::error_reason(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error_reason)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView, send_validation>(
  in_error_reason,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error_reason in GetContextResult union");
    fragment->data.f_error_reason.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::glic::mojom::GetContextResultDataView::Tag::kTabContext: {
    decltype(Traits::tab_context(input))
    in_tab_context = Traits::tab_context(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tab_context)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::TabContextDataView, send_validation>(
  in_tab_context,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tab_context in GetContextResult union");
    fragment->data.f_tab_context.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::CaptureScreenshotResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::glic::mojom::CaptureScreenshotResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::glic::mojom::internal::CaptureScreenshotResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::glic::mojom::CaptureScreenshotResultDataView::Tag::kErrorReason: {
    decltype(Traits::error_reason(input))
    in_error_reason = Traits::error_reason(input);
        
mojo::internal::Serialize<::glic::mojom::CaptureScreenshotErrorReason, send_validation>(
  in_error_reason,
  &fragment->data.f_error_reason);
    break;
  }
  case ::glic::mojom::CaptureScreenshotResultDataView::Tag::kScreenshot: {
    decltype(Traits::screenshot(input))
    in_screenshot = Traits::screenshot(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_screenshot)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::ScreenshotDataView, send_validation>(
  in_screenshot,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null screenshot in CaptureScreenshotResult union");
    fragment->data.f_screenshot.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::ScrollToSelectorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::glic::mojom::ScrollToSelectorDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::glic::mojom::internal::ScrollToSelector_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::glic::mojom::ScrollToSelectorDataView::Tag::kExactTextSelector: {
    decltype(Traits::exact_text_selector(input))
    in_exact_text_selector = Traits::exact_text_selector(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_exact_text_selector)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::ScrollToTextSelectorDataView, send_validation>(
  in_exact_text_selector,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null exact_text_selector in ScrollToSelector union");
    fragment->data.f_exact_text_selector.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::glic::mojom::ScrollToSelectorDataView::Tag::kTextFragmentSelector: {
    decltype(Traits::text_fragment_selector(input))
    in_text_fragment_selector = Traits::text_fragment_selector(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_text_fragment_selector)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::ScrollToTextFragmentSelectorDataView, send_validation>(
  in_text_fragment_selector,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null text_fragment_selector in ScrollToSelector union");
    fragment->data.f_text_fragment_selector.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::glic::mojom::ScrollToSelectorDataView::Tag::kNodeSelector: {
    decltype(Traits::node_selector(input))
    in_node_selector = Traits::node_selector(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_node_selector)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::ScrollToNodeSelectorDataView, send_validation>(
  in_node_selector,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null node_selector in ScrollToSelector union");
    fragment->data.f_node_selector.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::AdditionalContextPartDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::glic::mojom::AdditionalContextPartDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::glic::mojom::internal::AdditionalContextPart_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::glic::mojom::AdditionalContextPartDataView::Tag::kData: {
    decltype(Traits::data(input))
    in_data = Traits::data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::ContextDataDataView, send_validation>(
  in_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null data in AdditionalContextPart union");
    fragment->data.f_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::glic::mojom::AdditionalContextPartDataView::Tag::kScreenshot: {
    decltype(Traits::screenshot(input))
    in_screenshot = Traits::screenshot(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_screenshot)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::ScreenshotDataView, send_validation>(
  in_screenshot,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null screenshot in AdditionalContextPart union");
    fragment->data.f_screenshot.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::glic::mojom::AdditionalContextPartDataView::Tag::kWebPageData: {
    decltype(Traits::web_page_data(input))
    in_web_page_data = Traits::web_page_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_web_page_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::WebPageDataDataView, send_validation>(
  in_web_page_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null web_page_data in AdditionalContextPart union");
    fragment->data.f_web_page_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::glic::mojom::AdditionalContextPartDataView::Tag::kAnnotatedPageData: {
    decltype(Traits::annotated_page_data(input))
    in_annotated_page_data = Traits::annotated_page_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_annotated_page_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::AnnotatedPageDataDataView, send_validation>(
  in_annotated_page_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null annotated_page_data in AdditionalContextPart union");
    fragment->data.f_annotated_page_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::glic::mojom::AdditionalContextPartDataView::Tag::kPdfDocumentData: {
    decltype(Traits::pdf_document_data(input))
    in_pdf_document_data = Traits::pdf_document_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_pdf_document_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::PdfDocumentDataDataView, send_validation>(
  in_pdf_document_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null pdf_document_data in AdditionalContextPart union");
    fragment->data.f_pdf_document_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::FocusedTabDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::glic::mojom::FocusedTabDataDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::glic::mojom::internal::FocusedTabData_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::glic::mojom::FocusedTabDataDataView::Tag::kFocusedTab: {
    decltype(Traits::focused_tab(input))
    in_focused_tab = Traits::focused_tab(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_focused_tab)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::TabDataDataView, send_validation>(
  in_focused_tab,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null focused_tab in FocusedTabData union");
    fragment->data.f_focused_tab.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::glic::mojom::FocusedTabDataDataView::Tag::kNoFocusedTabData: {
    decltype(Traits::no_focused_tab_data(input))
    in_no_focused_tab_data = Traits::no_focused_tab_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_no_focused_tab_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::NoFocusedTabDataDataView, send_validation>(
  in_no_focused_tab_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null no_focused_tab_data in FocusedTabData union");
    fragment->data.f_no_focused_tab_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::ViewChangeRequestDetailsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::glic::mojom::ViewChangeRequestDetailsDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::glic::mojom::internal::ViewChangeRequestDetails_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::glic::mojom::ViewChangeRequestDetailsDataView::Tag::kActuation: {
    decltype(Traits::actuation(input))
    in_actuation = Traits::actuation(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_actuation)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::ViewChangeRequestActuationDataView, send_validation>(
  in_actuation,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null actuation in ViewChangeRequestDetails union");
    fragment->data.f_actuation.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::glic::mojom::ViewChangeRequestDetailsDataView::Tag::kConversation: {
    decltype(Traits::conversation(input))
    in_conversation = Traits::conversation(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_conversation)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::ViewChangeRequestConversationDataView, send_validation>(
  in_conversation,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null conversation in ViewChangeRequestDetails union");
    fragment->data.f_conversation.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::WebClientHandler_CreateTask_ResponseParam_ResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::glic::mojom::WebClientHandler_CreateTask_ResponseParam_ResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::glic::mojom::internal::WebClientHandler_CreateTask_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::glic::mojom::WebClientHandler_CreateTask_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    fragment->data.f_success = in_success;
    break;
  }
  case ::glic::mojom::WebClientHandler_CreateTask_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
        
mojo::internal::Serialize<::glic::mojom::CreateTaskErrorReason, send_validation>(
  in_failure,
  &fragment->data.f_failure);
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::glic::mojom::WebClientHandler_PerformActions_ResponseParam_ResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::glic::mojom::WebClientHandler_PerformActions_ResponseParam_ResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::glic::mojom::internal::WebClientHandler_PerformActions_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::glic::mojom::WebClientHandler_PerformActions_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ProtoWrapperDataView, send_validation>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in WebClientHandler_PerformActions_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::glic::mojom::WebClientHandler_PerformActions_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
        
mojo::internal::Serialize<::glic::mojom::PerformActionsErrorReason, send_validation>(
  in_failure,
  &fragment->data.f_failure);
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // CHROME_BROWSER_GLIC_HOST_GLIC_MOJOM_SEND_VALIDATION_H_