// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef protocol_Target_h
#define protocol_Target_h

#include "chrome/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace protocol {
namespace Target {
using TargetID = String;
class RemoteLocation;
using WindowState = String;

// ------------- Forward and enum declarations.

namespace WindowStateEnum {
 extern const char Normal[];
 extern const char Minimized[];
 extern const char Maximized[];
 extern const char Fullscreen[];
} // namespace WindowStateEnum

// ------------- Type and builder declarations.

class  RemoteLocation : public ::crdtp::ProtocolObject<RemoteLocation> {
public:
    ~RemoteLocation() override { }

    String GetHost() { return m_host; }
    void SetHost(const String& value) { m_host = value; }

    int GetPort() { return m_port; }
    void SetPort(int value) { m_port = value; }

    template<int STATE>
    class RemoteLocationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            HostSet = 1 << 1,
            PortSet = 1 << 2,
            AllFieldsSet = (HostSet | PortSet | 0)};


        RemoteLocationBuilder<STATE | HostSet>& SetHost(const String& value)
        {
            static_assert(!(STATE & HostSet), "property host should not be set yet");
            m_result->SetHost(value);
            return castState<HostSet>();
        }

        RemoteLocationBuilder<STATE | PortSet>& SetPort(int value)
        {
            static_assert(!(STATE & PortSet), "property port should not be set yet");
            m_result->SetPort(value);
            return castState<PortSet>();
        }

        std::unique_ptr<RemoteLocation> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class RemoteLocation;
        RemoteLocationBuilder() : m_result(new RemoteLocation()) { }

        template<int STEP> RemoteLocationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RemoteLocationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Target::RemoteLocation> m_result;
    };

    static RemoteLocationBuilder<0> Create()
    {
        return RemoteLocationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    RemoteLocation()
    {
          m_port = 0;
    }

    String m_host;
    int m_port;
};


// ------------- Backend interface.

class  Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse CreateTarget(const String& in_url, std::optional<int> in_left, std::optional<int> in_top, std::optional<int> in_width, std::optional<int> in_height, std::optional<String> in_windowState, std::optional<String> in_browserContextId, std::optional<bool> in_enableBeginFrameControl, std::optional<bool> in_newWindow, std::optional<bool> in_background, std::optional<bool> in_forTab, std::optional<bool> in_hidden, String* out_targetId) = 0;
    virtual DispatchResponse SetRemoteLocations(std::unique_ptr<protocol::Array<protocol::Target::RemoteLocation>> in_locations) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class  Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class  Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class  Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Target
} // namespace protocol

#endif // !defined(protocol_Target_h)
