// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef protocol_Page_h
#define protocol_Page_h

#include "chrome/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace protocol {
namespace Page {
using FrameId = String;
class InstallabilityErrorArgument;
class InstallabilityError;

// ------------- Forward and enum declarations.

namespace CaptureScreenshot {
namespace FormatEnum {
 extern const char* Jpeg;
 extern const char* Png;
 extern const char* Webp;
} // FormatEnum
} // CaptureScreenshot

namespace CaptureSnapshot {
namespace FormatEnum {
 extern const char* Mhtml;
} // FormatEnum
} // CaptureSnapshot

namespace PrintToPDF {
namespace TransferModeEnum {
 extern const char* ReturnAsBase64;
 extern const char* ReturnAsStream;
} // TransferModeEnum
} // PrintToPDF

namespace SetDownloadBehavior {
namespace BehaviorEnum {
 extern const char* Deny;
 extern const char* Allow;
 extern const char* Default;
} // BehaviorEnum
} // SetDownloadBehavior

namespace SetTouchEmulationEnabled {
namespace ConfigurationEnum {
 extern const char* Mobile;
 extern const char* Desktop;
} // ConfigurationEnum
} // SetTouchEmulationEnabled

namespace StartScreencast {
namespace FormatEnum {
 extern const char* Jpeg;
 extern const char* Png;
} // FormatEnum
} // StartScreencast

namespace SetWebLifecycleState {
namespace StateEnum {
 extern const char* Frozen;
 extern const char* Active;
} // StateEnum
} // SetWebLifecycleState

namespace SetSPCTransactionMode {
namespace ModeEnum {
 extern const char* None;
 extern const char* AutoAccept;
 extern const char* AutoChooseToAuthAnotherWay;
 extern const char* AutoReject;
 extern const char* AutoOptOut;
} // ModeEnum
} // SetSPCTransactionMode

namespace SetRPHRegistrationMode {
namespace ModeEnum {
 extern const char* None;
 extern const char* AutoAccept;
 extern const char* AutoReject;
} // ModeEnum
} // SetRPHRegistrationMode

namespace FileChooserOpened {
namespace ModeEnum {
 extern const char* SelectSingle;
 extern const char* SelectMultiple;
} // ModeEnum
} // FileChooserOpened

namespace FrameDetached {
namespace ReasonEnum {
 extern const char* Remove;
 extern const char* Swap;
} // ReasonEnum
} // FrameDetached

namespace FrameStartedNavigating {
namespace NavigationTypeEnum {
 extern const char* Reload;
 extern const char* ReloadBypassingCache;
 extern const char* Restore;
 extern const char* RestoreWithPost;
 extern const char* HistorySameDocument;
 extern const char* HistoryDifferentDocument;
 extern const char* SameDocument;
 extern const char* DifferentDocument;
} // NavigationTypeEnum
} // FrameStartedNavigating

namespace DownloadProgress {
namespace StateEnum {
 extern const char* InProgress;
 extern const char* Completed;
 extern const char* Canceled;
} // StateEnum
} // DownloadProgress

namespace NavigatedWithinDocument {
namespace NavigationTypeEnum {
 extern const char* Fragment;
 extern const char* HistoryApi;
 extern const char* Other;
} // NavigationTypeEnum
} // NavigatedWithinDocument

// ------------- Type and builder declarations.

class  InstallabilityErrorArgument : public ::crdtp::ProtocolObject<InstallabilityErrorArgument> {
public:
    ~InstallabilityErrorArgument() override { }

    String GetName() { return m_name; }
    void SetName(const String& value) { m_name = value; }

    String GetValue() { return m_value; }
    void SetValue(const String& value) { m_value = value; }

    template<int STATE>
    class InstallabilityErrorArgumentBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (NameSet | ValueSet | 0)};


        InstallabilityErrorArgumentBuilder<STATE | NameSet>& SetName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->SetName(value);
            return castState<NameSet>();
        }

        InstallabilityErrorArgumentBuilder<STATE | ValueSet>& SetValue(const String& value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->SetValue(value);
            return castState<ValueSet>();
        }

        std::unique_ptr<InstallabilityErrorArgument> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InstallabilityErrorArgument;
        InstallabilityErrorArgumentBuilder() : m_result(new InstallabilityErrorArgument()) { }

        template<int STEP> InstallabilityErrorArgumentBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InstallabilityErrorArgumentBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::InstallabilityErrorArgument> m_result;
    };

    static InstallabilityErrorArgumentBuilder<0> Create()
    {
        return InstallabilityErrorArgumentBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InstallabilityErrorArgument()
    {
    }

    String m_name;
    String m_value;
};


class  InstallabilityError : public ::crdtp::ProtocolObject<InstallabilityError> {
public:
    ~InstallabilityError() override { }

    String GetErrorId() { return m_errorId; }
    void SetErrorId(const String& value) { m_errorId = value; }

    protocol::Array<protocol::Page::InstallabilityErrorArgument>* GetErrorArguments() { return m_errorArguments.get(); }
    void SetErrorArguments(std::unique_ptr<protocol::Array<protocol::Page::InstallabilityErrorArgument>> value) { m_errorArguments = std::move(value); }

    template<int STATE>
    class InstallabilityErrorBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ErrorIdSet = 1 << 1,
            ErrorArgumentsSet = 1 << 2,
            AllFieldsSet = (ErrorIdSet | ErrorArgumentsSet | 0)};


        InstallabilityErrorBuilder<STATE | ErrorIdSet>& SetErrorId(const String& value)
        {
            static_assert(!(STATE & ErrorIdSet), "property errorId should not be set yet");
            m_result->SetErrorId(value);
            return castState<ErrorIdSet>();
        }

        InstallabilityErrorBuilder<STATE | ErrorArgumentsSet>& SetErrorArguments(std::unique_ptr<protocol::Array<protocol::Page::InstallabilityErrorArgument>> value)
        {
            static_assert(!(STATE & ErrorArgumentsSet), "property errorArguments should not be set yet");
            m_result->SetErrorArguments(std::move(value));
            return castState<ErrorArgumentsSet>();
        }

        std::unique_ptr<InstallabilityError> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InstallabilityError;
        InstallabilityErrorBuilder() : m_result(new InstallabilityError()) { }

        template<int STEP> InstallabilityErrorBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InstallabilityErrorBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::InstallabilityError> m_result;
    };

    static InstallabilityErrorBuilder<0> Create()
    {
        return InstallabilityErrorBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InstallabilityError()
    {
    }

    String m_errorId;
    std::unique_ptr<protocol::Array<protocol::Page::InstallabilityErrorArgument>> m_errorArguments;
};


// ------------- Backend interface.

class  Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse Disable() = 0;
    virtual DispatchResponse Enable(std::optional<bool> in_enableFileChooserOpenedEvent) = 0;
    class  GetInstallabilityErrorsCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<protocol::Page::InstallabilityError>> installabilityErrors) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetInstallabilityErrorsCallback() { }
    };
    virtual void GetInstallabilityErrors(std::unique_ptr<GetInstallabilityErrorsCallback> callback) = 0;
    class  GetManifestIconsCallback {
    public:
        virtual void sendSuccess(std::optional<Binary> primaryIcon) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetManifestIconsCallback() { }
    };
    virtual void GetManifestIcons(std::unique_ptr<GetManifestIconsCallback> callback) = 0;
    class  GetAppIdCallback {
    public:
        virtual void sendSuccess(std::optional<String> appId, std::optional<String> recommendedId) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetAppIdCallback() { }
    };
    virtual void GetAppId(std::unique_ptr<GetAppIdCallback> callback) = 0;
    class  PrintToPDFCallback {
    public:
        virtual void sendSuccess(const Binary& data, std::optional<String> stream) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~PrintToPDFCallback() { }
    };
    virtual void PrintToPDF(std::optional<bool> in_landscape, std::optional<bool> in_displayHeaderFooter, std::optional<bool> in_printBackground, std::optional<double> in_scale, std::optional<double> in_paperWidth, std::optional<double> in_paperHeight, std::optional<double> in_marginTop, std::optional<double> in_marginBottom, std::optional<double> in_marginLeft, std::optional<double> in_marginRight, std::optional<String> in_pageRanges, std::optional<String> in_headerTemplate, std::optional<String> in_footerTemplate, std::optional<bool> in_preferCSSPageSize, std::optional<String> in_transferMode, std::optional<bool> in_generateTaggedPDF, std::optional<bool> in_generateDocumentOutline, std::unique_ptr<PrintToPDFCallback> callback) = 0;
    virtual DispatchResponse SetAdBlockingEnabled(bool in_enabled) = 0;
    virtual DispatchResponse SetSPCTransactionMode(const String& in_mode) = 0;
    virtual DispatchResponse SetRPHRegistrationMode(const String& in_mode) = 0;

};

// ------------- Frontend interface.

class  Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class  Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class  Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Page
} // namespace protocol

#endif // !defined(protocol_Page_h)
