// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef protocol_Autofill_h
#define protocol_Autofill_h

#include "chrome/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace protocol {
namespace Autofill {
class CreditCard;
class AddressField;
class AddressFields;
class Address;
class AddressUI;
using FillingStrategy = String;
class FilledField;

// ------------- Forward and enum declarations.

namespace FillingStrategyEnum {
 extern const char AutocompleteAttribute[];
 extern const char AutofillInferred[];
} // namespace FillingStrategyEnum

// ------------- Type and builder declarations.

class  CreditCard : public ::crdtp::ProtocolObject<CreditCard> {
public:
    ~CreditCard() override { }

    String GetNumber() { return m_number; }
    void SetNumber(const String& value) { m_number = value; }

    String GetName() { return m_name; }
    void SetName(const String& value) { m_name = value; }

    String GetExpiryMonth() { return m_expiryMonth; }
    void SetExpiryMonth(const String& value) { m_expiryMonth = value; }

    String GetExpiryYear() { return m_expiryYear; }
    void SetExpiryYear(const String& value) { m_expiryYear = value; }

    String GetCvc() { return m_cvc; }
    void SetCvc(const String& value) { m_cvc = value; }

    template<int STATE>
    class CreditCardBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NumberSet = 1 << 1,
            NameSet = 1 << 2,
            ExpiryMonthSet = 1 << 3,
            ExpiryYearSet = 1 << 4,
            CvcSet = 1 << 5,
            AllFieldsSet = (NumberSet | NameSet | ExpiryMonthSet | ExpiryYearSet | CvcSet | 0)};


        CreditCardBuilder<STATE | NumberSet>& SetNumber(const String& value)
        {
            static_assert(!(STATE & NumberSet), "property number should not be set yet");
            m_result->SetNumber(value);
            return castState<NumberSet>();
        }

        CreditCardBuilder<STATE | NameSet>& SetName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->SetName(value);
            return castState<NameSet>();
        }

        CreditCardBuilder<STATE | ExpiryMonthSet>& SetExpiryMonth(const String& value)
        {
            static_assert(!(STATE & ExpiryMonthSet), "property expiryMonth should not be set yet");
            m_result->SetExpiryMonth(value);
            return castState<ExpiryMonthSet>();
        }

        CreditCardBuilder<STATE | ExpiryYearSet>& SetExpiryYear(const String& value)
        {
            static_assert(!(STATE & ExpiryYearSet), "property expiryYear should not be set yet");
            m_result->SetExpiryYear(value);
            return castState<ExpiryYearSet>();
        }

        CreditCardBuilder<STATE | CvcSet>& SetCvc(const String& value)
        {
            static_assert(!(STATE & CvcSet), "property cvc should not be set yet");
            m_result->SetCvc(value);
            return castState<CvcSet>();
        }

        std::unique_ptr<CreditCard> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CreditCard;
        CreditCardBuilder() : m_result(new CreditCard()) { }

        template<int STEP> CreditCardBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CreditCardBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Autofill::CreditCard> m_result;
    };

    static CreditCardBuilder<0> Create()
    {
        return CreditCardBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CreditCard()
    {
    }

    String m_number;
    String m_name;
    String m_expiryMonth;
    String m_expiryYear;
    String m_cvc;
};


class  AddressField : public ::crdtp::ProtocolObject<AddressField> {
public:
    ~AddressField() override { }

    String GetName() { return m_name; }
    void SetName(const String& value) { m_name = value; }

    String GetValue() { return m_value; }
    void SetValue(const String& value) { m_value = value; }

    template<int STATE>
    class AddressFieldBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (NameSet | ValueSet | 0)};


        AddressFieldBuilder<STATE | NameSet>& SetName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->SetName(value);
            return castState<NameSet>();
        }

        AddressFieldBuilder<STATE | ValueSet>& SetValue(const String& value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->SetValue(value);
            return castState<ValueSet>();
        }

        std::unique_ptr<AddressField> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AddressField;
        AddressFieldBuilder() : m_result(new AddressField()) { }

        template<int STEP> AddressFieldBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AddressFieldBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Autofill::AddressField> m_result;
    };

    static AddressFieldBuilder<0> Create()
    {
        return AddressFieldBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AddressField()
    {
    }

    String m_name;
    String m_value;
};


class  AddressFields : public ::crdtp::ProtocolObject<AddressFields> {
public:
    ~AddressFields() override { }

    protocol::Array<protocol::Autofill::AddressField>* GetFields() { return m_fields.get(); }
    void SetFields(std::unique_ptr<protocol::Array<protocol::Autofill::AddressField>> value) { m_fields = std::move(value); }

    template<int STATE>
    class AddressFieldsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FieldsSet = 1 << 1,
            AllFieldsSet = (FieldsSet | 0)};


        AddressFieldsBuilder<STATE | FieldsSet>& SetFields(std::unique_ptr<protocol::Array<protocol::Autofill::AddressField>> value)
        {
            static_assert(!(STATE & FieldsSet), "property fields should not be set yet");
            m_result->SetFields(std::move(value));
            return castState<FieldsSet>();
        }

        std::unique_ptr<AddressFields> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AddressFields;
        AddressFieldsBuilder() : m_result(new AddressFields()) { }

        template<int STEP> AddressFieldsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AddressFieldsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Autofill::AddressFields> m_result;
    };

    static AddressFieldsBuilder<0> Create()
    {
        return AddressFieldsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AddressFields()
    {
    }

    std::unique_ptr<protocol::Array<protocol::Autofill::AddressField>> m_fields;
};


class  Address : public ::crdtp::ProtocolObject<Address> {
public:
    ~Address() override { }

    protocol::Array<protocol::Autofill::AddressField>* GetFields() { return m_fields.get(); }
    void SetFields(std::unique_ptr<protocol::Array<protocol::Autofill::AddressField>> value) { m_fields = std::move(value); }

    template<int STATE>
    class AddressBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FieldsSet = 1 << 1,
            AllFieldsSet = (FieldsSet | 0)};


        AddressBuilder<STATE | FieldsSet>& SetFields(std::unique_ptr<protocol::Array<protocol::Autofill::AddressField>> value)
        {
            static_assert(!(STATE & FieldsSet), "property fields should not be set yet");
            m_result->SetFields(std::move(value));
            return castState<FieldsSet>();
        }

        std::unique_ptr<Address> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Address;
        AddressBuilder() : m_result(new Address()) { }

        template<int STEP> AddressBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AddressBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Autofill::Address> m_result;
    };

    static AddressBuilder<0> Create()
    {
        return AddressBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Address()
    {
    }

    std::unique_ptr<protocol::Array<protocol::Autofill::AddressField>> m_fields;
};


class  AddressUI : public ::crdtp::ProtocolObject<AddressUI> {
public:
    ~AddressUI() override { }

    protocol::Array<protocol::Autofill::AddressFields>* GetAddressFields() { return m_addressFields.get(); }
    void SetAddressFields(std::unique_ptr<protocol::Array<protocol::Autofill::AddressFields>> value) { m_addressFields = std::move(value); }

    template<int STATE>
    class AddressUIBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AddressFieldsSet = 1 << 1,
            AllFieldsSet = (AddressFieldsSet | 0)};


        AddressUIBuilder<STATE | AddressFieldsSet>& SetAddressFields(std::unique_ptr<protocol::Array<protocol::Autofill::AddressFields>> value)
        {
            static_assert(!(STATE & AddressFieldsSet), "property addressFields should not be set yet");
            m_result->SetAddressFields(std::move(value));
            return castState<AddressFieldsSet>();
        }

        std::unique_ptr<AddressUI> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AddressUI;
        AddressUIBuilder() : m_result(new AddressUI()) { }

        template<int STEP> AddressUIBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AddressUIBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Autofill::AddressUI> m_result;
    };

    static AddressUIBuilder<0> Create()
    {
        return AddressUIBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AddressUI()
    {
    }

    std::unique_ptr<protocol::Array<protocol::Autofill::AddressFields>> m_addressFields;
};


class  FilledField : public ::crdtp::ProtocolObject<FilledField> {
public:
    ~FilledField() override { }

    String GetHtmlType() { return m_htmlType; }
    void SetHtmlType(const String& value) { m_htmlType = value; }

    String GetId() { return m_id; }
    void SetId(const String& value) { m_id = value; }

    String GetName() { return m_name; }
    void SetName(const String& value) { m_name = value; }

    String GetValue() { return m_value; }
    void SetValue(const String& value) { m_value = value; }

    String GetAutofillType() { return m_autofillType; }
    void SetAutofillType(const String& value) { m_autofillType = value; }

    String GetFillingStrategy() { return m_fillingStrategy; }
    void SetFillingStrategy(const String& value) { m_fillingStrategy = value; }

    String GetFrameId() { return m_frameId; }
    void SetFrameId(const String& value) { m_frameId = value; }

    int GetFieldId() { return m_fieldId; }
    void SetFieldId(int value) { m_fieldId = value; }

    template<int STATE>
    class FilledFieldBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            HtmlTypeSet = 1 << 1,
            IdSet = 1 << 2,
            NameSet = 1 << 3,
            ValueSet = 1 << 4,
            AutofillTypeSet = 1 << 5,
            FillingStrategySet = 1 << 6,
            FrameIdSet = 1 << 7,
            FieldIdSet = 1 << 8,
            AllFieldsSet = (HtmlTypeSet | IdSet | NameSet | ValueSet | AutofillTypeSet | FillingStrategySet | FrameIdSet | FieldIdSet | 0)};


        FilledFieldBuilder<STATE | HtmlTypeSet>& SetHtmlType(const String& value)
        {
            static_assert(!(STATE & HtmlTypeSet), "property htmlType should not be set yet");
            m_result->SetHtmlType(value);
            return castState<HtmlTypeSet>();
        }

        FilledFieldBuilder<STATE | IdSet>& SetId(const String& value)
        {
            static_assert(!(STATE & IdSet), "property id should not be set yet");
            m_result->SetId(value);
            return castState<IdSet>();
        }

        FilledFieldBuilder<STATE | NameSet>& SetName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->SetName(value);
            return castState<NameSet>();
        }

        FilledFieldBuilder<STATE | ValueSet>& SetValue(const String& value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->SetValue(value);
            return castState<ValueSet>();
        }

        FilledFieldBuilder<STATE | AutofillTypeSet>& SetAutofillType(const String& value)
        {
            static_assert(!(STATE & AutofillTypeSet), "property autofillType should not be set yet");
            m_result->SetAutofillType(value);
            return castState<AutofillTypeSet>();
        }

        FilledFieldBuilder<STATE | FillingStrategySet>& SetFillingStrategy(const String& value)
        {
            static_assert(!(STATE & FillingStrategySet), "property fillingStrategy should not be set yet");
            m_result->SetFillingStrategy(value);
            return castState<FillingStrategySet>();
        }

        FilledFieldBuilder<STATE | FrameIdSet>& SetFrameId(const String& value)
        {
            static_assert(!(STATE & FrameIdSet), "property frameId should not be set yet");
            m_result->SetFrameId(value);
            return castState<FrameIdSet>();
        }

        FilledFieldBuilder<STATE | FieldIdSet>& SetFieldId(int value)
        {
            static_assert(!(STATE & FieldIdSet), "property fieldId should not be set yet");
            m_result->SetFieldId(value);
            return castState<FieldIdSet>();
        }

        std::unique_ptr<FilledField> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FilledField;
        FilledFieldBuilder() : m_result(new FilledField()) { }

        template<int STEP> FilledFieldBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FilledFieldBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Autofill::FilledField> m_result;
    };

    static FilledFieldBuilder<0> Create()
    {
        return FilledFieldBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FilledField()
    {
          m_fieldId = 0;
    }

    String m_htmlType;
    String m_id;
    String m_name;
    String m_value;
    String m_autofillType;
    String m_fillingStrategy;
    String m_frameId;
    int m_fieldId;
};


// ------------- Backend interface.

class  Backend {
public:
    virtual ~Backend() { }

    class  TriggerCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~TriggerCallback() { }
    };
    virtual void Trigger(int in_fieldId, std::optional<String> in_frameId, std::unique_ptr<protocol::Autofill::CreditCard> in_card, std::unique_ptr<protocol::Autofill::Address> in_address, std::unique_ptr<TriggerCallback> callback) = 0;
    class  SetAddressesCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SetAddressesCallback() { }
    };
    virtual void SetAddresses(std::unique_ptr<protocol::Array<protocol::Autofill::Address>> in_addresses, std::unique_ptr<SetAddressesCallback> callback) = 0;
    virtual DispatchResponse Disable() = 0;
    virtual DispatchResponse Enable() = 0;

};

// ------------- Frontend interface.

class  Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void AddressFormFilled(std::unique_ptr<protocol::Array<protocol::Autofill::FilledField>> filledFields, std::unique_ptr<protocol::Autofill::AddressUI> addressUi);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class  Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class  Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Autofill
} // namespace protocol

#endif // !defined(protocol_Autofill_h)
