// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/apps/platform_apps/api/generated_api_registration.h"

#include "build/android_buildflags.h"
#include "build/build_config.h"

#include "chrome/browser/apps/platform_apps/api/browser/browser_api.h"
#include "chrome/browser/apps/platform_apps/api/media_galleries/media_galleries_api.h"
#include "chrome/browser/apps/platform_apps/api/sync_file_system/sync_file_system_api.h"

#include "extensions/browser/extension_function_registry.h"

namespace chrome_apps {
namespace api {

// static
void ChromeAppsGeneratedFunctionRegistry::RegisterAll(ExtensionFunctionRegistry* registry) {
  constexpr ExtensionFunctionRegistry::FactoryEntry kEntries[] = {
    {
      &NewExtensionFunction<BrowserOpenTabFunction>,
      BrowserOpenTabFunction::static_function_name(),
      BrowserOpenTabFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MediaGalleriesGetMediaFileSystemsFunction>,
      MediaGalleriesGetMediaFileSystemsFunction::static_function_name(),
      MediaGalleriesGetMediaFileSystemsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MediaGalleriesAddUserSelectedFolderFunction>,
      MediaGalleriesAddUserSelectedFolderFunction::static_function_name(),
      MediaGalleriesAddUserSelectedFolderFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MediaGalleriesGetMetadataFunction>,
      MediaGalleriesGetMetadataFunction::static_function_name(),
      MediaGalleriesGetMetadataFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MediaGalleriesAddGalleryWatchFunction>,
      MediaGalleriesAddGalleryWatchFunction::static_function_name(),
      MediaGalleriesAddGalleryWatchFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MediaGalleriesRemoveGalleryWatchFunction>,
      MediaGalleriesRemoveGalleryWatchFunction::static_function_name(),
      MediaGalleriesRemoveGalleryWatchFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SyncFileSystemRequestFileSystemFunction>,
      SyncFileSystemRequestFileSystemFunction::static_function_name(),
      SyncFileSystemRequestFileSystemFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SyncFileSystemSetConflictResolutionPolicyFunction>,
      SyncFileSystemSetConflictResolutionPolicyFunction::static_function_name(),
      SyncFileSystemSetConflictResolutionPolicyFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SyncFileSystemGetConflictResolutionPolicyFunction>,
      SyncFileSystemGetConflictResolutionPolicyFunction::static_function_name(),
      SyncFileSystemGetConflictResolutionPolicyFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SyncFileSystemGetUsageAndQuotaFunction>,
      SyncFileSystemGetUsageAndQuotaFunction::static_function_name(),
      SyncFileSystemGetUsageAndQuotaFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SyncFileSystemGetFileStatusFunction>,
      SyncFileSystemGetFileStatusFunction::static_function_name(),
      SyncFileSystemGetFileStatusFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SyncFileSystemGetFileStatusesFunction>,
      SyncFileSystemGetFileStatusesFunction::static_function_name(),
      SyncFileSystemGetFileStatusesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SyncFileSystemGetServiceStatusFunction>,
      SyncFileSystemGetServiceStatusFunction::static_function_name(),
      SyncFileSystemGetServiceStatusFunction::static_histogram_value(),
    },
  };
  for (const auto& entry : kEntries) {
      registry->Register(entry);
  }
}

}  // namespace api
}  // namespace chrome_apps
