// chrome/browser/actor/ui/actor_overlay.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/actor/ui/actor_overlay.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/actor/ui/actor_overlay.mojom-params-data.h"
#include "chrome/browser/actor/ui/actor_overlay.mojom-shared-message-ids.h"

#include "chrome/browser/actor/ui/actor_overlay.mojom-import-headers.h"
#include "chrome/browser/actor/ui/actor_overlay.mojom-test-utils.h"


namespace actor::ui::mojom {
// The declaration includes the definition on other builds.

ActorOverlayPageHandlerFactory::IPCStableHashFunction ActorOverlayPageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ActorOverlayPageHandlerFactory>(message.name())) {
    case messages::ActorOverlayPageHandlerFactory::kCreatePageHandler: {
      return &ActorOverlayPageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ActorOverlayPageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ActorOverlayPageHandlerFactory>(message.name())) {
      case messages::ActorOverlayPageHandlerFactory::kCreatePageHandler:
            return "Receive actor::ui::mojom::ActorOverlayPageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::ActorOverlayPageHandlerFactory>(message.name())) {
      case messages::ActorOverlayPageHandlerFactory::kCreatePageHandler:
            return "Receive reply actor::ui::mojom::ActorOverlayPageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ActorOverlayPageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa9802811;  // IPCStableHash for actor::ui::mojom::ActorOverlayPageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ActorOverlayPageHandlerFactoryProxy::ActorOverlayPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ActorOverlayPageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<ActorOverlayPage> in_page, ::mojo::PendingReceiver<ActorOverlayPageHandler> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send actor::ui::mojom::ActorOverlayPageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<ActorOverlayPage>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<ActorOverlayPageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ActorOverlayPageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::actor::ui::mojom::internal::ActorOverlayPageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::actor::ui::mojom::ActorOverlayPageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in ActorOverlayPageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::actor::ui::mojom::ActorOverlayPageHandlerInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in ActorOverlayPageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ActorOverlayPageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ActorOverlayPageHandlerFactoryStubDispatch::Accept(
    ActorOverlayPageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ActorOverlayPageHandlerFactory>(message->header()->name)) {
    case messages::ActorOverlayPageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::ActorOverlayPageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::ActorOverlayPageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ActorOverlayPageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<ActorOverlayPage> p_page{};
      ::mojo::PendingReceiver<ActorOverlayPageHandler> p_receiver{};
      ActorOverlayPageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ActorOverlayPageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool ActorOverlayPageHandlerFactoryStubDispatch::AcceptWithResponder(
    ActorOverlayPageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ActorOverlayPageHandlerFactory>(message->header()->name)) {
    case messages::ActorOverlayPageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kActorOverlayPageHandlerFactoryValidationInfo[] = {
    { &internal::ActorOverlayPageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool ActorOverlayPageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::actor::ui::mojom::ActorOverlayPageHandlerFactory::Name_,
    kActorOverlayPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

ActorOverlayPageHandler::IPCStableHashFunction ActorOverlayPageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ActorOverlayPageHandler>(message.name())) {
    case messages::ActorOverlayPageHandler::kOnHoverStatusChanged: {
      return &ActorOverlayPageHandler::OnHoverStatusChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ActorOverlayPageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ActorOverlayPageHandler>(message.name())) {
      case messages::ActorOverlayPageHandler::kOnHoverStatusChanged:
            return "Receive actor::ui::mojom::ActorOverlayPageHandler::OnHoverStatusChanged";
    }
  } else {
    switch (static_cast<messages::ActorOverlayPageHandler>(message.name())) {
      case messages::ActorOverlayPageHandler::kOnHoverStatusChanged:
            return "Receive reply actor::ui::mojom::ActorOverlayPageHandler::OnHoverStatusChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ActorOverlayPageHandler::OnHoverStatusChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8b519a7f;  // IPCStableHash for actor::ui::mojom::ActorOverlayPageHandler::OnHoverStatusChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ActorOverlayPageHandlerProxy::ActorOverlayPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ActorOverlayPageHandlerProxy::OnHoverStatusChanged(
    bool in_is_hovering) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send actor::ui::mojom::ActorOverlayPageHandler::OnHoverStatusChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_hovering"), in_is_hovering,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ActorOverlayPageHandler::kOnHoverStatusChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::actor::ui::mojom::internal::ActorOverlayPageHandler_OnHoverStatusChanged_Params_Data> params(
          message);
  params.Allocate();

  params->is_hovering = in_is_hovering;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ActorOverlayPageHandler::Name_);
  message.set_method_name("OnHoverStatusChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ActorOverlayPageHandlerStubDispatch::Accept(
    ActorOverlayPageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ActorOverlayPageHandler>(message->header()->name)) {
    case messages::ActorOverlayPageHandler::kOnHoverStatusChanged: {
      DCHECK(message->is_serialized());
      internal::ActorOverlayPageHandler_OnHoverStatusChanged_Params_Data* params =
          reinterpret_cast<internal::ActorOverlayPageHandler_OnHoverStatusChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ActorOverlayPageHandler.0
      bool success = true;
      bool p_is_hovering{};
      ActorOverlayPageHandler_OnHoverStatusChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_hovering = input_data_view.is_hovering();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ActorOverlayPageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHoverStatusChanged(        
        std::move(p_is_hovering));
      return true;
    }
  }
  return false;
}

// static
bool ActorOverlayPageHandlerStubDispatch::AcceptWithResponder(
    ActorOverlayPageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ActorOverlayPageHandler>(message->header()->name)) {
    case messages::ActorOverlayPageHandler::kOnHoverStatusChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kActorOverlayPageHandlerValidationInfo[] = {
    { &internal::ActorOverlayPageHandler_OnHoverStatusChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool ActorOverlayPageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::actor::ui::mojom::ActorOverlayPageHandler::Name_,
    kActorOverlayPageHandlerValidationInfo);
}

// The declaration includes the definition on other builds.

ActorOverlayPage::IPCStableHashFunction ActorOverlayPage::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ActorOverlayPage>(message.name())) {
    case messages::ActorOverlayPage::kSetScrimBackground: {
      return &ActorOverlayPage::SetScrimBackground_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ActorOverlayPage::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ActorOverlayPage>(message.name())) {
      case messages::ActorOverlayPage::kSetScrimBackground:
            return "Receive actor::ui::mojom::ActorOverlayPage::SetScrimBackground";
    }
  } else {
    switch (static_cast<messages::ActorOverlayPage>(message.name())) {
      case messages::ActorOverlayPage::kSetScrimBackground:
            return "Receive reply actor::ui::mojom::ActorOverlayPage::SetScrimBackground";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ActorOverlayPage::SetScrimBackground_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1444c612;  // IPCStableHash for actor::ui::mojom::ActorOverlayPage::SetScrimBackground
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ActorOverlayPageProxy::ActorOverlayPageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ActorOverlayPageProxy::SetScrimBackground(
    bool in_is_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send actor::ui::mojom::ActorOverlayPage::SetScrimBackground", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_visible"), in_is_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ActorOverlayPage::kSetScrimBackground), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::actor::ui::mojom::internal::ActorOverlayPage_SetScrimBackground_Params_Data> params(
          message);
  params.Allocate();

  params->is_visible = in_is_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ActorOverlayPage::Name_);
  message.set_method_name("SetScrimBackground");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ActorOverlayPageStubDispatch::Accept(
    ActorOverlayPage* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ActorOverlayPage>(message->header()->name)) {
    case messages::ActorOverlayPage::kSetScrimBackground: {
      DCHECK(message->is_serialized());
      internal::ActorOverlayPage_SetScrimBackground_Params_Data* params =
          reinterpret_cast<internal::ActorOverlayPage_SetScrimBackground_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ActorOverlayPage.0
      bool success = true;
      bool p_is_visible{};
      ActorOverlayPage_SetScrimBackground_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_visible = input_data_view.is_visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ActorOverlayPage::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetScrimBackground(        
        std::move(p_is_visible));
      return true;
    }
  }
  return false;
}

// static
bool ActorOverlayPageStubDispatch::AcceptWithResponder(
    ActorOverlayPage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ActorOverlayPage>(message->header()->name)) {
    case messages::ActorOverlayPage::kSetScrimBackground: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kActorOverlayPageValidationInfo[] = {
    { &internal::ActorOverlayPage_SetScrimBackground_Params_Data::Validate,
     nullptr /* no response */},
};

bool ActorOverlayPageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::actor::ui::mojom::ActorOverlayPage::Name_,
    kActorOverlayPageValidationInfo);
}



}  // actor::ui::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace actor::ui::mojom {


void ActorOverlayPageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<ActorOverlayPage> page, ::mojo::PendingReceiver<ActorOverlayPageHandler> receiver) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(receiver)
    );
}
ActorOverlayPageHandlerFactoryAsyncWaiter::ActorOverlayPageHandlerFactoryAsyncWaiter(
    ActorOverlayPageHandlerFactory* proxy) : proxy_(proxy) {}

ActorOverlayPageHandlerFactoryAsyncWaiter::~ActorOverlayPageHandlerFactoryAsyncWaiter() = default;





void ActorOverlayPageHandlerInterceptorForTesting::OnHoverStatusChanged(bool is_hovering) {
  GetForwardingInterface()->OnHoverStatusChanged(
    std::move(is_hovering)
    );
}
ActorOverlayPageHandlerAsyncWaiter::ActorOverlayPageHandlerAsyncWaiter(
    ActorOverlayPageHandler* proxy) : proxy_(proxy) {}

ActorOverlayPageHandlerAsyncWaiter::~ActorOverlayPageHandlerAsyncWaiter() = default;





void ActorOverlayPageInterceptorForTesting::SetScrimBackground(bool is_visible) {
  GetForwardingInterface()->SetScrimBackground(
    std::move(is_visible)
    );
}
ActorOverlayPageAsyncWaiter::ActorOverlayPageAsyncWaiter(
    ActorOverlayPage* proxy) : proxy_(proxy) {}

ActorOverlayPageAsyncWaiter::~ActorOverlayPageAsyncWaiter() = default;







}  // actor::ui::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif