// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// vector_icons.cc.template is used to generate vector_icons.cc. Edit the former
// rather than the latter.

#include "chrome/app/vector_icons/vector_icons.h"

#include "components/vector_icons/cc_macros.h"
#include "ui/gfx/animation/tween.h"
#include "ui/gfx/vector_icon_types.h"

#define DECLARE_VECTOR_COMMAND(x) using gfx::x;
DECLARE_VECTOR_COMMANDS

VECTOR_ICON_REP_TEMPLATE(kAccountAddChromeRefreshPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 11.87, 8.63,
V_LINE_TO, 7.26,
R_H_LINE_TO, -1.37,
V_LINE_TO, 6,
R_H_LINE_TO, 1.37,
V_LINE_TO, 4.63,
R_H_LINE_TO, 1.27,
R_V_LINE_TO, 1.37,
R_H_LINE_TO, 1.37,
R_V_LINE_TO, 1.27,
R_H_LINE_TO, -1.37,
R_V_LINE_TO, 1.37,
CLOSE,
R_MOVE_TO, -5.46, -0.69,
R_ARC_TO, 2.45, 2.45, 0, 0, 1, -1.8, -0.74,
R_ARC_TO, 2.45, 2.45, 0, 0, 1, -0.74, -1.8,
R_CUBIC_TO, 0, -0.71, 0.25, -1.31, 0.74, -1.8,
R_ARC_TO, 2.45, 2.45, 0, 0, 1, 1.8, -0.74,
R_CUBIC_TO, 0.71, 0, 1.31, 0.25, 1.8, 0.74,
R_CUBIC_TO, 0.49, 0.49, 0.74, 1.09, 0.74, 1.8,
R_ARC_TO, 2.45, 2.45, 0, 0, 1, -0.74, 1.8,
R_ARC_TO, 2.45, 2.45, 0, 0, 1, -1.8, 0.74,
CLOSE,
R_MOVE_TO, -4.93, 5.07,
R_V_LINE_TO, -1.68,
R_CUBIC_TO, 0, -0.31, 0.08, -0.6, 0.23, -0.86,
R_CUBIC_TO, 0.15, -0.26, 0.36, -0.47, 0.63, -0.62,
R_ARC_TO, 8.32, 8.32, 0, 0, 1, 1.96, -0.82,
R_ARC_TO, 7.86, 7.86, 0, 0, 1, 2.11, -0.29,
R_ARC_TO, 8.04, 8.04, 0, 0, 1, 4.08, 1.11,
R_CUBIC_TO, 0.27, 0.16, 0.48, 0.36, 0.63, 0.62,
R_CUBIC_TO, 0.15, 0.26, 0.23, 0.55, 0.23, 0.87,
R_V_LINE_TO, 1.68,
CLOSE,
R_MOVE_TO, 1.38, -1.38,
R_H_LINE_TO, 7.11,
R_V_LINE_TO, -0.27,
R_ARC_TO, 0.36, 0.36, 0, 0, 0, -0.05, -0.19,
R_ARC_TO, 0.39, 0.39, 0, 0, 0, -0.13, -0.13,
R_ARC_TO, 7.14, 7.14, 0, 0, 0, -1.61, -0.67,
R_ARC_TO, 6.62, 6.62, 0, 0, 0, -1.76, -0.23,
R_CUBIC_TO, -0.59, 0, -1.18, 0.08, -1.75, 0.24,
R_ARC_TO, 6.93, 6.93, 0, 0, 0, -1.61, 0.67,
R_ARC_TO, 0.39, 0.39, 0, 0, 0, -0.13, 0.13,
R_ARC_TO, 0.36, 0.36, 0, 0, 0, -0.05, 0.19,
CLOSE,
R_MOVE_TO, 3.56, -5.07,
R_CUBIC_TO, 0.32, 0, 0.59, -0.11, 0.81, -0.34,
R_CUBIC_TO, 0.23, -0.23, 0.34, -0.5, 0.34, -0.82,
R_CUBIC_TO, 0, -0.32, -0.11, -0.59, -0.33, -0.81,
R_ARC_TO, 1.12, 1.12, 0, 0, 0, -0.82, -0.33,
R_CUBIC_TO, -0.32, 0, -0.59, 0.11, -0.81, 0.34,
R_ARC_TO, 1.1, 1.1, 0, 0, 0, -0.34, 0.81,
R_CUBIC_TO, 0, 0.32, 0.11, 0.59, 0.34, 0.82,
R_CUBIC_TO, 0.23, 0.22, 0.5, 0.34, 0.82, 0.34,
CLOSE,
MOVE_TO, 6.41, 5.38,
CLOSE,
R_MOVE_TO, 0, 6.24,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAccountAddChromeRefreshRepList, kAccountAddChromeRefreshIcon, {kAccountAddChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kAccountBoxPath, CANVAS_DIMENSIONS, 960,
FILL_RULE_NONZERO,
MOVE_TO, 200, 714,
R_QUADRATIC_TO, 54, -53, 125.5, -83.5,
QUADRATIC_TO_SHORTHAND, 480, 600,
R_QUADRATIC_TO, 83, 0, 154.5, 30.5,
QUADRATIC_TO_SHORTHAND, 760, 714,
R_V_LINE_TO, -514,
H_LINE_TO, 200,
R_V_LINE_TO, 514,
CLOSE,
R_MOVE_TO, 280, -194,
R_QUADRATIC_TO, 58, 0, 99, -41,
R_QUADRATIC_TO, 41, -41, 41, -99,
R_QUADRATIC_TO, 0, -58, -41, -99,
R_QUADRATIC_TO, -41, -41, -99, -41,
R_QUADRATIC_TO, -58, 0, -99, 41,
R_QUADRATIC_TO, -41, 41, -41, 99,
R_QUADRATIC_TO, 0, 58, 41, 99,
R_QUADRATIC_TO, 41, 41, 99, 41,
CLOSE,
MOVE_TO, 200, 840,
R_QUADRATIC_TO, -33, 0, -56.5, -23.5,
QUADRATIC_TO_SHORTHAND, 120, 760,
R_V_LINE_TO, -560,
R_QUADRATIC_TO, 0, -33, 23.5, -56.5,
QUADRATIC_TO_SHORTHAND, 200, 120,
R_H_LINE_TO, 560,
R_QUADRATIC_TO, 33, 0, 56.5, 23.5,
QUADRATIC_TO_SHORTHAND, 840, 200,
R_V_LINE_TO, 560,
R_QUADRATIC_TO, 0, 33, -23.5, 56.5,
QUADRATIC_TO_SHORTHAND, 760, 840,
H_LINE_TO, 200,
CLOSE,
R_MOVE_TO, 69, -80,
R_H_LINE_TO, 422,
R_QUADRATIC_TO, -44, -39, -99.5, -59.5,
QUADRATIC_TO_SHORTHAND, 480, 680,
R_QUADRATIC_TO, -56, 0, -112.5, 20.5,
QUADRATIC_TO_SHORTHAND, 269, 760,
CLOSE,
R_MOVE_TO, 211, -320,
R_QUADRATIC_TO, -25, 0, -42.5, -17.5,
QUADRATIC_TO_SHORTHAND, 420, 380,
R_QUADRATIC_TO, 0, -25, 17.5, -42.5,
QUADRATIC_TO_SHORTHAND, 480, 320,
R_QUADRATIC_TO, 25, 0, 42.5, 17.5,
QUADRATIC_TO_SHORTHAND, 540, 380,
R_QUADRATIC_TO, 0, 25, -17.5, 42.5,
QUADRATIC_TO_SHORTHAND, 480, 440,
CLOSE,
R_MOVE_TO, 0, 17,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAccountBoxRepList, kAccountBoxIcon, {kAccountBoxPath})
VECTOR_ICON_REP_TEMPLATE(kAccountChildCirclePath, CANVAS_DIMENSIONS, 24,
CIRCLE, 12, 13.49, 1.5,
MOVE_TO, 12, 2,
CUBIC_TO, 6.48, 2, 2, 6.48, 2, 12,
R_CUBIC_TO, 0, 5.52, 4.48, 10, 10, 10,
R_CUBIC_TO, 5.52, 0, 10, -4.48, 10, -10,
CUBIC_TO, 22, 6.48, 17.52, 2, 12, 2,
CLOSE,
R_MOVE_TO, 0, 2,
R_CUBIC_TO, 1.38, 0, 2.5, 1.12, 2.5, 2.5,
CUBIC_TO, 14.5, 7.88, 13.38, 9, 12, 9,
CUBIC_TO, 10.62, 9, 9.5, 7.88, 9.5, 6.5,
CUBIC_TO, 9.5, 5.12, 10.62, 4, 12, 4,
CLOSE,
R_MOVE_TO, 5, 13.22,
R_CUBIC_TO, 0, 0.89, -0.84, 1.66, -2, 2.17,
R_V_LINE_TO, -1.72,
R_CUBIC_TO, 0, -0.73, -0.93, -1.32, -2, -1.55,
R_CUBIC_TO, -0.33, -0.08, -0.67, -0.12, -1, -0.12,
R_CUBIC_TO, -1.29, 0, -2.7, 0.59, -2.95, 1.4,
R_CUBIC_TO, 0.88, 0.38, 1.94, 0.6, 2.95, 0.6,
R_CUBIC_TO, 0.33, 0, 0.67, -0.03, 1, -0.08,
R_V_LINE_TO, 2,
R_CUBIC_TO, -0.33, 0.05, -0.67, 0.08, -1, 0.08,
R_CUBIC_TO, -1.03, 0, -2.11, -0.23, -3, -0.61,
R_CUBIC_TO, -1.16, -0.5, -2, -1.27, -2, -2.17,
R_V_LINE_TO, -4.44,
CUBIC_TO, 7, 11.2, 9.63, 10, 12, 10,
R_CUBIC_TO, 2.37, 0, 5, 1.2, 5, 2.78,
R_V_LINE_TO, 4.44,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAccountChildCircleRepList, kAccountChildCircleIcon, {kAccountChildCirclePath})
VECTOR_ICON_REP_TEMPLATE(kAccountCirclePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 12, 2,
CUBIC_TO, 6.48, 2, 2, 6.48, 2, 12,
R_CUBIC_TO, 0, 5.52, 4.48, 10, 10, 10,
R_CUBIC_TO, 5.52, 0, 10, -4.48, 10, -10,
CUBIC_TO_SHORTHAND, 17.52, 2, 12, 2,
CLOSE,
R_MOVE_TO, 6.14, 15.12,
R_ARC_TO, 9.95, 9.95, 0, 0, 0, -12.28, 0,
ARC_TO, 7.96, 7.96, 0, 0, 1, 4, 12,
R_CUBIC_TO, 0, -4.42, 3.58, -8, 8, -8,
R_CUBIC_TO, 4.42, 0, 8, 3.58, 8, 8,
R_CUBIC_TO, 0, 1.95, -0.7, 3.73, -1.86, 5.12,
CLOSE,
NEW_PATH,
MOVE_TO, 12, 6,
R_CUBIC_TO, -1.93, 0, -3.5, 1.57, -3.5, 3.5,
CUBIC_TO_SHORTHAND, 10.07, 13, 12, 13,
R_CUBIC_TO, 1.93, 0, 3.5, -1.57, 3.5, -3.5,
CUBIC_TO_SHORTHAND, 13.93, 6, 12, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAccountCircleRepList, kAccountCircleIcon, {kAccountCirclePath})
VECTOR_ICON_REP_TEMPLATE(kAccountCircleChromeRefreshPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 5.85, 17.1,
R_ARC_TO, 10.32, 10.32, 0, 0, 1, 2.85, -1.54,
ARC_TO, 9.75, 9.75, 0, 0, 1, 12, 15,
R_CUBIC_TO, 1.15, 0, 2.25, 0.19, 3.3, 0.56,
R_CUBIC_TO, 1.05, 0.37, 2, 0.89, 2.85, 1.54,
R_ARC_TO, 7.67, 7.67, 0, 0, 0, 1.36, -2.33,
ARC_TO, 7.83, 7.83, 0, 0, 0, 20, 12,
R_CUBIC_TO, 0, -2.21, -0.78, -4.11, -2.34, -5.66,
CUBIC_TO, 16.11, 4.78, 14.21, 4, 12, 4,
R_CUBIC_TO, -2.21, 0, -4.11, 0.78, -5.66, 2.34,
CUBIC_TO, 4.78, 7.9, 4, 9.79, 4, 12,
R_CUBIC_TO, 0, 0.98, 0.16, 1.91, 0.49, 2.77,
R_ARC_TO, 7.67, 7.67, 0, 0, 0, 1.36, 2.33,
CLOSE,
MOVE_TO, 12, 13,
R_CUBIC_TO, -0.98, 0, -1.81, -0.34, -2.49, -1.01,
CUBIC_TO, 8.84, 11.31, 8.5, 10.48, 8.5, 9.5,
R_CUBIC_TO, 0, -0.98, 0.34, -1.81, 1.01, -2.49,
CUBIC_TO, 10.19, 6.34, 11.02, 6, 12, 6,
R_CUBIC_TO, 0.98, 0, 1.81, 0.34, 2.49, 1.01,
R_CUBIC_TO, 0.68, 0.68, 1.01, 1.5, 1.01, 2.49,
R_CUBIC_TO, 0, 0.99, -0.34, 1.81, -1.01, 2.49,
CUBIC_TO, 13.81, 12.66, 12.98, 13, 12, 13,
CLOSE,
R_MOVE_TO, 0, 9,
R_ARC_TO, 9.69, 9.69, 0, 0, 1, -3.9, -0.79,
R_ARC_TO, 9.99, 9.99, 0, 0, 1, -3.18, -2.14,
R_ARC_TO, 9.99, 9.99, 0, 0, 1, -2.14, -3.18,
ARC_TO, 9.69, 9.69, 0, 0, 1, 2, 12,
R_CUBIC_TO, 0, -1.38, 0.26, -2.68, 0.79, -3.9,
R_ARC_TO, 9.99, 9.99, 0, 0, 1, 2.14, -3.18,
R_ARC_TO, 9.99, 9.99, 0, 0, 1, 3.18, -2.14,
ARC_TO, 9.69, 9.69, 0, 0, 1, 12, 2,
R_CUBIC_TO, 1.38, 0, 2.68, 0.26, 3.9, 0.79,
R_ARC_TO, 9.99, 9.99, 0, 0, 1, 3.18, 2.14,
R_ARC_TO, 9.99, 9.99, 0, 0, 1, 2.14, 3.18,
ARC_TO, 9.69, 9.69, 0, 0, 1, 22, 12,
R_ARC_TO, 9.69, 9.69, 0, 0, 1, -0.79, 3.9,
R_ARC_TO, 9.99, 9.99, 0, 0, 1, -2.14, 3.18,
R_ARC_TO, 9.99, 9.99, 0, 0, 1, -3.18, 2.14,
ARC_TO, 9.69, 9.69, 0, 0, 1, 12, 22,
CLOSE,
R_MOVE_TO, 0, -2,
R_CUBIC_TO, 0.88, 0, 1.72, -0.13, 2.5, -0.39,
R_ARC_TO, 7.44, 7.44, 0, 0, 0, 2.15, -1.11,
R_ARC_TO, 7.44, 7.44, 0, 0, 0, -2.15, -1.11,
ARC_TO, 7.96, 7.96, 0, 0, 0, 12, 17,
R_CUBIC_TO, -0.88, 0, -1.71, 0.13, -2.5, 0.39,
ARC_TO, 7.44, 7.44, 0, 0, 0, 7.35, 18.5,
ARC_TO, 7.44, 7.44, 0, 0, 0, 9.5, 19.61,
ARC_TO, 7.96, 7.96, 0, 0, 0, 12, 20,
CLOSE,
R_MOVE_TO, 0, -9,
R_CUBIC_TO, 0.43, 0, 0.79, -0.14, 1.07, -0.43,
R_CUBIC_TO, 0.28, -0.28, 0.43, -0.64, 0.43, -1.07,
R_CUBIC_TO, 0, -0.43, -0.14, -0.79, -0.43, -1.07,
CUBIC_TO, 12.79, 8.14, 12.43, 8, 12, 8,
R_CUBIC_TO, -0.43, 0, -0.79, 0.14, -1.07, 0.43,
R_CUBIC_TO, -0.28, 0.28, -0.43, 0.64, -0.43, 1.07,
R_CUBIC_TO, 0, 0.43, 0.14, 0.79, 0.43, 1.07,
R_CUBIC_TO, 0.28, 0.28, 0.64, 0.43, 1.07, 0.43,
CLOSE,
R_MOVE_TO, 0, -1.5,
CLOSE,
R_MOVE_TO, 0, 9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAccountCircleChromeRefreshRepList, kAccountCircleChromeRefreshIcon, {kAccountCircleChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kAccountManageChromeRefreshPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 6.4, 7.93,
R_ARC_TO, 2.45, 2.45, 0, 0, 1, -1.8, -0.74,
R_ARC_TO, 2.45, 2.45, 0, 0, 1, -0.74, -1.8,
R_CUBIC_TO, 0, -0.71, 0.25, -1.31, 0.74, -1.8,
R_ARC_TO, 2.45, 2.45, 0, 0, 1, 1.8, -0.74,
R_CUBIC_TO, 0.71, 0, 1.31, 0.25, 1.8, 0.74,
R_CUBIC_TO, 0.49, 0.49, 0.74, 1.09, 0.74, 1.8,
R_CUBIC_TO, 0, 0.7, -0.24, 1.31, -0.73, 1.8,
R_ARC_TO, 2.45, 2.45, 0, 0, 1, -1.8, 0.74,
CLOSE,
R_MOVE_TO, -4.93, 5.07,
R_V_LINE_TO, -1.68,
R_CUBIC_TO, 0, -0.33, 0.08, -0.62, 0.25, -0.88,
R_ARC_TO, 1.84, 1.84, 0, 0, 1, 0.61, -0.6,
R_ARC_TO, 8.2, 8.2, 0, 0, 1, 1.96, -0.82,
R_ARC_TO, 7.81, 7.81, 0, 0, 1, 2.11, -0.29,
R_CUBIC_TO, 0.13, 0, 0.25, 0, 0.38, 0.01,
R_CUBIC_TO, 0.12, 0, 0.26, 0.01, 0.39, 0.02,
R_CUBIC_TO, -0.09, 0.19, -0.16, 0.41, -0.21, 0.66,
R_ARC_TO, 7.18, 7.18, 0, 0, 0, -0.13, 0.7,
R_LINE_TO, -0.41, -0.02,
R_CUBIC_TO, -0.58, 0, -1.16, 0.07, -1.73, 0.22,
R_ARC_TO, 6.36, 6.36, 0, 0, 0, -1.64, 0.69,
R_ARC_TO, 0.38, 0.38, 0, 0, 0, -0.13, 0.13,
R_ARC_TO, 0.34, 0.34, 0, 0, 0, -0.05, 0.19,
R_V_LINE_TO, 0.27,
R_H_LINE_TO, 4.13,
R_CUBIC_TO, 0.06, 0.23, 0.14, 0.47, 0.26, 0.72,
R_CUBIC_TO, 0.11, 0.24, 0.24, 0.47, 0.38, 0.67,
CLOSE,
R_MOVE_TO, 9.25, 0.73,
R_LINE_TO, -0.21, -0.95,
R_ARC_TO, 2.64, 2.64, 0, 0, 1, -0.79, -0.44,
R_LINE_TO, -0.93, 0.29,
R_LINE_TO, -0.58, -1,
R_LINE_TO, 0.7, -0.68,
R_ARC_TO, 1.36, 1.36, 0, 0, 1, -0.06, -0.46,
R_ARC_TO, 2.43, 2.43, 0, 0, 1, 0.06, -0.46,
LINE_TO, 8.2, 9.37,
R_LINE_TO, 0.58, -1.01,
R_LINE_TO, 0.92, 0.27,
R_CUBIC_TO, 0.11, -0.1, 0.24, -0.19, 0.38, -0.28,
R_CUBIC_TO, 0.14, -0.08, 0.28, -0.14, 0.43, -0.18,
R_LINE_TO, 0.22, -0.95,
R_H_LINE_TO, 1.17,
R_LINE_TO, 0.22, 0.95,
R_CUBIC_TO, 0.14, 0.05, 0.29, 0.11, 0.43, 0.19,
R_CUBIC_TO, 0.14, 0.08, 0.27, 0.17, 0.38, 0.27,
R_LINE_TO, 0.92, -0.26,
R_LINE_TO, 0.59, 1,
R_LINE_TO, -0.69, 0.65,
R_CUBIC_TO, 0.02, 0.16, 0.04, 0.32, 0.04, 0.48,
R_CUBIC_TO, 0, 0.16, -0.02, 0.31, -0.05, 0.46,
R_LINE_TO, 0.7, 0.66,
R_LINE_TO, -0.59, 1,
R_LINE_TO, -0.93, -0.27,
R_CUBIC_TO, -0.11, 0.09, -0.24, 0.18, -0.37, 0.26,
R_CUBIC_TO, -0.13, 0.08, -0.27, 0.14, -0.42, 0.18,
R_LINE_TO, -0.24, 0.95,
CLOSE,
R_MOVE_TO, 0.61, -2.09,
R_CUBIC_TO, 0.32, 0, 0.59, -0.12, 0.82, -0.35,
R_CUBIC_TO, 0.23, -0.23, 0.34, -0.51, 0.34, -0.83,
R_CUBIC_TO, 0, -0.32, -0.12, -0.59, -0.35, -0.82,
R_ARC_TO, 1.13, 1.13, 0, 0, 0, -0.82, -0.34,
R_CUBIC_TO, -0.32, 0, -0.6, 0.11, -0.82, 0.34,
R_ARC_TO, 1.13, 1.13, 0, 0, 0, -0.34, 0.83,
R_CUBIC_TO, 0, 0.32, 0.11, 0.59, 0.35, 0.82,
R_CUBIC_TO, 0.23, 0.23, 0.51, 0.34, 0.83, 0.34,
CLOSE,
MOVE_TO, 6.4, 6.55,
R_CUBIC_TO, 0.32, 0, 0.59, -0.11, 0.81, -0.34,
R_CUBIC_TO, 0.23, -0.23, 0.34, -0.5, 0.34, -0.82,
R_CUBIC_TO, 0, -0.32, -0.11, -0.59, -0.34, -0.81,
R_ARC_TO, 1.11, 1.11, 0, 0, 0, -0.81, -0.33,
R_CUBIC_TO, -0.32, 0, -0.59, 0.11, -0.82, 0.34,
R_ARC_TO, 1.12, 1.12, 0, 0, 0, -0.34, 0.81,
R_CUBIC_TO, 0, 0.32, 0.11, 0.59, 0.34, 0.82,
R_CUBIC_TO, 0.23, 0.22, 0.5, 0.34, 0.82, 0.34,
CLOSE,
R_MOVE_TO, 0, -1.15,
CLOSE,
R_MOVE_TO, 0.58, 6.22,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAccountManageChromeRefreshRepList, kAccountManageChromeRefreshIcon, {kAccountManageChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kAddPath, CANVAS_DIMENSIONS, 16,
STROKE, 2.f,
CAP_SQUARE,
MOVE_TO, 3, 8,
R_H_LINE_TO, 10,
MOVE_TO, 8, 3,
R_V_LINE_TO, 10)
VECTOR_ICON_TEMPLATE_CC(kAddRepList, kAddIcon, {kAddPath})
VECTOR_ICON_REP_TEMPLATE(kAddChromeRefreshPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 7.18, 12.22,
V_LINE_TO, 8.82,
H_LINE_TO, 3.79,
V_LINE_TO, 7.18,
R_H_LINE_TO, 3.4,
V_LINE_TO, 3.79,
R_H_LINE_TO, 1.63,
R_V_LINE_TO, 3.4,
R_H_LINE_TO, 3.4,
R_V_LINE_TO, 1.63,
H_LINE_TO, 8.82,
R_V_LINE_TO, 3.4,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAddChromeRefreshRepList, kAddChromeRefreshIcon, {kAddChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kAddCirclePath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 11, 17,
R_H_LINE_TO, 2,
R_V_LINE_TO, -4,
R_H_LINE_TO, 4,
R_V_LINE_TO, -2,
R_H_LINE_TO, -4,
V_LINE_TO, 7,
R_H_LINE_TO, -2,
R_V_LINE_TO, 4,
H_LINE_TO, 7,
R_V_LINE_TO, 2,
R_H_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 1, 5,
R_ARC_TO, 9.69, 9.69, 0, 0, 1, -3.9, -0.79,
R_ARC_TO, 9.99, 9.99, 0, 0, 1, -3.18, -2.14,
R_ARC_TO, 9.99, 9.99, 0, 0, 1, -2.14, -3.18,
ARC_TO, 9.69, 9.69, 0, 0, 1, 2, 12,
R_CUBIC_TO, 0, -1.38, 0.26, -2.68, 0.79, -3.9,
R_ARC_TO, 9.99, 9.99, 0, 0, 1, 2.14, -3.18,
R_ARC_TO, 9.99, 9.99, 0, 0, 1, 3.18, -2.14,
ARC_TO, 9.69, 9.69, 0, 0, 1, 12, 2,
R_CUBIC_TO, 1.38, 0, 2.68, 0.26, 3.9, 0.79,
R_ARC_TO, 9.99, 9.99, 0, 0, 1, 3.18, 2.14,
R_ARC_TO, 9.99, 9.99, 0, 0, 1, 2.14, 3.18,
ARC_TO, 9.69, 9.69, 0, 0, 1, 22, 12,
R_ARC_TO, 9.69, 9.69, 0, 0, 1, -0.79, 3.9,
R_ARC_TO, 9.99, 9.99, 0, 0, 1, -2.14, 3.18,
R_ARC_TO, 9.99, 9.99, 0, 0, 1, -3.18, 2.14,
ARC_TO, 9.69, 9.69, 0, 0, 1, 12, 22,
CLOSE,
R_MOVE_TO, 0, -2,
R_CUBIC_TO, 2.23, 0, 4.13, -0.77, 5.68, -2.32,
CUBIC_TO, 19.23, 16.13, 20, 14.23, 20, 12,
R_CUBIC_TO, 0, -2.23, -0.77, -4.12, -2.32, -5.68,
CUBIC_TO, 16.13, 4.77, 14.23, 4, 12, 4,
R_CUBIC_TO, -2.23, 0, -4.12, 0.77, -5.68, 2.32,
CUBIC_TO, 4.77, 7.88, 4, 9.77, 4, 12,
R_CUBIC_TO, 0, 2.23, 0.77, 4.13, 2.32, 5.68,
CUBIC_TO, 7.88, 19.23, 9.77, 20, 12, 20,
CLOSE,
R_MOVE_TO, 0, -8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAddCircleRepList, kAddCircleIcon, {kAddCirclePath})
VECTOR_ICON_REP_TEMPLATE(kAutoTabGroupsPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 8, 4,
R_V_LINE_TO, 9,
V_LINE_TO, 16,
CLOSE,
MOVE_TO, 4, 22,
R_ARC_TO, 1.99, 1.99, 0, 0, 1, -1.42, -0.57,
ARC_TO, 1.99, 1.99, 0, 0, 1, 2, 20,
V_LINE_TO, 6,
R_H_LINE_TO, 2,
R_V_LINE_TO, 14,
R_H_LINE_TO, 14,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 4, -4,
R_ARC_TO, 1.99, 1.99, 0, 0, 1, -1.42, -0.57,
ARC_TO, 1.99, 1.99, 0, 0, 1, 6, 16,
V_LINE_TO, 4,
R_CUBIC_TO, 0, -0.55, 0.19, -1.02, 0.57, -1.4,
R_CUBIC_TO, 0.4, -0.4, 0.88, -0.6, 1.43, -0.6,
R_H_LINE_TO, 4.83,
R_ARC_TO, 5.7, 5.7, 0, 0, 0, -0.75, 0.93,
ARC_TO, 7.33, 7.33, 0, 0, 0, 11.5, 4,
H_LINE_TO, 8,
R_V_LINE_TO, 12,
R_H_LINE_TO, 12,
R_V_LINE_TO, -3.5,
R_ARC_TO, 7.33, 7.33, 0, 0, 0, 1.08, -0.57,
R_CUBIC_TO, 0.33, -0.22, 0.64, -0.47, 0.93, -0.75,
V_LINE_TO, 16,
R_CUBIC_TO, 0, 0.55, -0.2, 1.02, -0.6, 1.43,
R_CUBIC_TO, -0.38, 0.38, -0.85, 0.57, -1.4, 0.57,
CLOSE,
R_MOVE_TO, 9.5, -6,
R_CUBIC_TO, 0, -1.53, -0.53, -2.83, -1.6, -3.9,
R_CUBIC_TO, -1.07, -1.07, -2.37, -1.6, -3.9, -1.6,
R_CUBIC_TO, 1.53, 0, 2.83, -0.53, 3.9, -1.6,
R_CUBIC_TO, 1.07, -1.07, 1.6, -2.37, 1.6, -3.9,
R_CUBIC_TO, 0, 1.53, 0.53, 2.83, 1.6, 3.9,
R_CUBIC_TO, 1.07, 1.07, 2.37, 1.6, 3.9, 1.6,
R_CUBIC_TO, -1.53, 0, -2.83, 0.53, -3.9, 1.6,
R_CUBIC_TO, -1.07, 1.07, -1.6, 2.37, -1.6, 3.9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAutoTabGroupsRepList, kAutoTabGroupsIcon, {kAutoTabGroupsPath})
VECTOR_ICON_REP_TEMPLATE(kLocalOfferFlippedRefreshPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 10.57, 17.72,
R_ARC_TO, 1.66, 1.66, 0, 0, 1, -1.22, 0.51,
R_CUBIC_TO, -0.48, 0, -0.89, -0.17, -1.22, -0.51,
R_LINE_TO, -5.86, -5.86,
R_ARC_TO, 1.66, 1.66, 0, 0, 1, -0.51, -1.22,
R_CUBIC_TO, 0, -0.48, 0.17, -0.89, 0.51, -1.23,
LINE_TO, 9.43, 2.27,
R_CUBIC_TO, 0.17, -0.17, 0.36, -0.3, 0.56, -0.38,
R_CUBIC_TO, 0.21, -0.08, 0.42, -0.12, 0.65, -0.12,
H_LINE_TO, 16.5,
R_CUBIC_TO, 0.48, 0, 0.88, 0.17, 1.22, 0.51,
R_CUBIC_TO, 0.34, 0.34, 0.51, 0.75, 0.51, 1.22,
R_V_LINE_TO, 5.88,
R_ARC_TO, 1.66, 1.66, 0, 0, 1, -0.51, 1.2,
CLOSE,
MOVE_TO, 14.5, 6.75,
R_CUBIC_TO, 0.35, 0, 0.64, -0.12, 0.89, -0.36,
R_CUBIC_TO, 0.24, -0.25, 0.36, -0.54, 0.36, -0.89,
R_CUBIC_TO, 0, -0.35, -0.12, -0.64, -0.36, -0.89,
R_ARC_TO, 1.22, 1.22, 0, 0, 0, -0.89, -0.36,
R_CUBIC_TO, -0.35, 0, -0.64, 0.12, -0.89, 0.36,
R_CUBIC_TO, -0.24, 0.25, -0.36, 0.54, -0.36, 0.89,
R_CUBIC_TO, 0, 0.35, 0.12, 0.64, 0.36, 0.89,
R_CUBIC_TO, 0.25, 0.24, 0.54, 0.36, 0.89, 0.36,
CLOSE,
MOVE_TO, 9.35, 16.5,
LINE_TO, 16.5, 9.38,
V_LINE_TO, 3.5,
R_H_LINE_TO, -5.85,
R_LINE_TO, -7.15, 7.15,
CLOSE,
MOVE_TO, 16.48, 3.58,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kLocalOfferFlippedRefreshRepList, kLocalOfferFlippedRefreshIcon, {kLocalOfferFlippedRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kWebauthnDialogHeaderPath, CANVAS_DIMENSIONS, 448,
NEW_PATH,
PATH_COLOR_ARGB, 0x0A, 0x00, 0x00, 0x00,
MOVE_TO, 0, 0,
R_H_LINE_TO, 448,
R_V_LINE_TO, 119,
H_LINE_TO, 0,
CLOSE,
NEW_PATH,
STROKE, 1,
PATH_COLOR_ARGB, 0xFF, 0xE8, 0xE9, 0xEB,
MOVE_TO, 318.49, 67.44,
H_LINE_TO, 275,
R_CUBIC_TO, 0.36, -5.48, 4.94, -9.83, 10.51, -9.83,
R_CUBIC_TO, 1.18, 0, 2.36, 0.21, 3.51, 0.61,
R_LINE_TO, 0.47, 0.17,
R_LINE_TO, 0.31, -0.39,
ARC_TO, 16.09, 16.09, 0, 0, 1, 302.36, 52,
R_CUBIC_TO, 8.67, 0, 15.76, 6.87, 16.13, 15.44,
CLOSE,
MOVE_TO, 372.49, 33.44,
H_LINE_TO, 329,
R_CUBIC_TO, 0.36, -5.48, 4.94, -9.83, 10.51, -9.83,
R_CUBIC_TO, 1.18, 0, 2.36, 0.21, 3.51, 0.61,
R_LINE_TO, 0.47, 0.17,
R_LINE_TO, 0.31, -0.39,
ARC_TO, 16.09, 16.09, 0, 0, 1, 356.36, 18,
R_CUBIC_TO, 8.67, 0, 15.76, 6.87, 16.13, 15.44,
CLOSE,
MOVE_TO, 60.49, 72.44,
H_LINE_TO, 17,
R_CUBIC_TO, 0.36, -5.48, 4.94, -9.83, 10.51, -9.83,
R_CUBIC_TO, 1.18, 0, 2.36, 0.21, 3.51, 0.61,
R_LINE_TO, 0.47, 0.17,
R_LINE_TO, 0.31, -0.39,
ARC_TO, 16.09, 16.09, 0, 0, 1, 44.36, 57,
R_CUBIC_TO, 8.67, 0, 15.76, 6.87, 16.13, 15.44,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xFF, 0xFF,
CIRCLE, 128, 87, 37.058,
NEW_PATH,
STROKE, 1,
PATH_COLOR_ARGB, 0xFF, 0xE8, 0xE9, 0xEB,
CIRCLE, 128, 87, 37.058,
NEW_PATH,
STROKE, 1,
PATH_COLOR_ARGB, 0xFF, 0xBD, 0xC0, 0xC5,
MOVE_TO, 140.08, 47.81,
ARC_TO, 40.99, 40.99, 0, 0, 0, 128, 46,
R_CUBIC_TO, -5.24, 0, -10.25, 0.98, -14.85, 2.77,
R_ARC_TO, 41.07, 41.07, 0, 0, 0, -15.34, 10.49,
MOVE_TO, 87, 87,
R_CUBIC_TO, 0, 4.36, 0.68, 8.56, 1.94, 12.5,
R_MOVE_TO, 12.64, 18.86,
ARC_TO, 40.85, 40.85, 0, 0, 0, 128, 128,
R_CUBIC_TO, 11.43, 0, 21.77, -4.68, 29.21, -12.23,
ARC_TO, 40.96, 40.96, 0, 0, 0, 167.45, 98.2,
MOVE_TO, 169, 87,
R_ARC_TO, 40.84, 40.84, 0, 0, 0, -3.94, -17.57,
ARC_TO, 41.14, 41.14, 0, 0, 0, 154.73, 55.91,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x1A, 0x73, 0xE8,
MOVE_TO, 115.96, 76.75,
H_LINE_TO, 144.63,
V_LINE_TO, 73.17,
H_LINE_TO, 115.96,
CUBIC_TO, 113.99, 73.17, 112.38, 74.78, 112.38, 76.75,
V_LINE_TO, 96.46,
H_LINE_TO, 108.79,
V_LINE_TO, 101.83,
H_LINE_TO, 128.5,
V_LINE_TO, 96.46,
H_LINE_TO, 115.96,
V_LINE_TO, 76.75,
CLOSE,
MOVE_TO, 144.63, 80.33,
H_LINE_TO, 133.88,
CUBIC_TO, 132.89, 80.33, 132.08, 81.14, 132.08, 82.13,
V_LINE_TO, 100.04,
CUBIC_TO, 132.08, 101.03, 132.89, 101.83, 133.88, 101.83,
H_LINE_TO, 144.63,
CUBIC_TO, 145.61, 101.83, 146.42, 101.03, 146.42, 100.04,
V_LINE_TO, 82.13,
CUBIC_TO, 146.42, 81.14, 145.61, 80.33, 144.63, 80.33,
CLOSE,
MOVE_TO, 135.67, 96.46,
H_LINE_TO, 142.83,
V_LINE_TO, 83.92,
H_LINE_TO, 135.67,
V_LINE_TO, 96.46,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kWebauthnDialogHeaderRepList, kWebauthnDialogHeaderIcon, {kWebauthnDialogHeaderPath})
VECTOR_ICON_REP_TEMPLATE(kWebauthnDialogHeaderDarkPath, CANVAS_DIMENSIONS, 448,
PATH_COLOR_ARGB, 0x18, 0x00, 0x00, 0x00,
MOVE_TO, 318.49, 67.44,
H_LINE_TO, 275,
R_CUBIC_TO, 0.36, -5.48, 4.94, -9.83, 10.51, -9.83,
R_CUBIC_TO, 1.18, 0, 2.36, 0.21, 3.51, 0.61,
R_LINE_TO, 0.47, 0.17,
R_LINE_TO, 0.31, -0.39,
ARC_TO, 16.09, 16.09, 0, 0, 1, 302.36, 52,
R_CUBIC_TO, 8.67, 0, 15.76, 6.87, 16.13, 15.44,
CLOSE,
MOVE_TO, 372.49, 33.44,
H_LINE_TO, 329,
R_CUBIC_TO, 0.36, -5.48, 4.94, -9.83, 10.51, -9.83,
R_CUBIC_TO, 1.18, 0, 2.36, 0.21, 3.51, 0.61,
R_LINE_TO, 0.47, 0.17,
R_LINE_TO, 0.31, -0.39,
ARC_TO, 16.09, 16.09, 0, 0, 1, 356.36, 18,
R_CUBIC_TO, 8.67, 0, 15.76, 6.87, 16.13, 15.44,
CLOSE,
MOVE_TO, 60.49, 72.44,
H_LINE_TO, 17,
R_CUBIC_TO, 0.36, -5.48, 4.94, -9.83, 10.51, -9.83,
R_CUBIC_TO, 1.18, 0, 2.36, 0.21, 3.51, 0.61,
R_LINE_TO, 0.47, 0.17,
R_LINE_TO, 0.31, -0.39,
ARC_TO, 16.09, 16.09, 0, 0, 1, 44.36, 57,
R_CUBIC_TO, 8.67, 0, 15.76, 6.87, 16.13, 15.44,
CLOSE,
MOVE_TO, 60.49, 72.44,
H_LINE_TO, 17,
R_CUBIC_TO, 0.36, -5.48, 4.94, -9.83, 10.51, -9.83,
R_CUBIC_TO, 1.18, 0, 2.36, 0.21, 3.51, 0.61,
R_LINE_TO, 0.47, 0.17,
R_LINE_TO, 0.31, -0.39,
ARC_TO, 16.09, 16.09, 0, 0, 1, 44.36, 57,
R_CUBIC_TO, 8.67, 0, 15.76, 6.87, 16.13, 15.44,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x41, 0x44, 0x47,
CIRCLE, 128, 87, 37.058,
NEW_PATH,
STROKE, 1,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
CIRCLE, 128, 87, 37.058,
NEW_PATH,
STROKE, 1,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
MOVE_TO, 140.08, 47.81,
ARC_TO, 40.99, 40.99, 0, 0, 0, 128, 46,
R_CUBIC_TO, -5.24, 0, -10.25, 0.98, -14.85, 2.77,
R_ARC_TO, 41.07, 41.07, 0, 0, 0, -15.34, 10.49,
MOVE_TO, 87, 87,
R_CUBIC_TO, 0, 4.36, 0.68, 8.56, 1.94, 12.5,
R_MOVE_TO, 12.64, 18.86,
ARC_TO, 40.85, 40.85, 0, 0, 0, 128, 128,
R_CUBIC_TO, 11.43, 0, 21.77, -4.68, 29.21, -12.23,
ARC_TO, 40.96, 40.96, 0, 0, 0, 167.45, 98.2,
MOVE_TO, 169, 87,
R_ARC_TO, 40.84, 40.84, 0, 0, 0, -3.94, -17.57,
ARC_TO, 41.14, 41.14, 0, 0, 0, 154.73, 55.91,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x8A, 0xB4, 0xF8,
MOVE_TO, 115.96, 76.75,
H_LINE_TO, 144.63,
V_LINE_TO, 73.17,
H_LINE_TO, 115.96,
CUBIC_TO, 113.99, 73.17, 112.38, 74.78, 112.38, 76.75,
V_LINE_TO, 96.46,
H_LINE_TO, 108.79,
V_LINE_TO, 101.83,
H_LINE_TO, 128.5,
V_LINE_TO, 96.46,
H_LINE_TO, 115.96,
V_LINE_TO, 76.75,
CLOSE,
MOVE_TO, 144.63, 80.33,
H_LINE_TO, 133.88,
CUBIC_TO, 132.89, 80.33, 132.08, 81.14, 132.08, 82.13,
V_LINE_TO, 100.04,
CUBIC_TO, 132.08, 101.03, 132.89, 101.83, 133.88, 101.83,
H_LINE_TO, 144.63,
CUBIC_TO, 145.61, 101.83, 146.42, 101.03, 146.42, 100.04,
V_LINE_TO, 82.13,
CUBIC_TO, 146.42, 81.14, 145.61, 80.33, 144.63, 80.33,
CLOSE,
MOVE_TO, 135.67, 96.46,
H_LINE_TO, 142.83,
V_LINE_TO, 83.92,
H_LINE_TO, 135.67,
V_LINE_TO, 96.46,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kWebauthnDialogHeaderDarkRepList, kWebauthnDialogHeaderDarkIcon, {kWebauthnDialogHeaderDarkPath})
VECTOR_ICON_REP_TEMPLATE(kBackArrowTouchPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 12.91, 18.59,
R_LINE_TO, 0.09, -0.09,
LINE_TO, 7.49, 13,
H_LINE_TO, 19,
R_ARC_TO, 1, 1, 0, 0, 0, 0, -2,
H_LINE_TO, 7.49,
LINE_TO, 13, 5.49,
R_LINE_TO, -0.09, -0.09,
R_ARC_TO, 1, 1, 0, 0, 0, -1.32, -1.32,
R_H_LINE_TO, 0,
LINE_TO, 11.51, 4,
LINE_TO, 4, 11.51,
R_LINE_TO, 0.09, 0.09,
R_ARC_TO, 1, 1, 0, 0, 0, 0, 0.82,
LINE_TO, 4, 12.5,
LINE_TO, 11.51, 20,
R_LINE_TO, 0.09, -0.09,
R_ARC_TO, 1, 1, 0, 0, 0, 1.32, -1.32,
R_V_LINE_TO, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBackArrowTouchRepList, kBackArrowTouchIcon, {kBackArrowTouchPath})
VECTOR_ICON_REP_TEMPLATE(kBackspacePath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 4.48, 3,
CUBIC_TO, 4.18, 3, 3.89, 3.14, 3.7, 3.38,
LINE_TO, 0, 8,
LINE_TO, 3.7, 12.62,
CUBIC_TO, 3.89, 12.86, 4.18, 13, 4.48, 13,
H_LINE_TO, 12.5,
CUBIC_TO, 13.33, 13, 14, 12.33, 14, 11.5,
V_LINE_TO, 4.5,
CUBIC_TO, 14, 3.67, 13.33, 3, 12.5, 3,
H_LINE_TO, 4.48,
CLOSE,
MOVE_TO, 5, 6,
LINE_TO, 6, 5,
LINE_TO, 8, 7,
LINE_TO, 10, 5,
LINE_TO, 11, 6,
LINE_TO, 9, 8,
LINE_TO, 11, 10,
LINE_TO, 10, 11,
LINE_TO, 8, 9,
LINE_TO, 6, 11,
LINE_TO, 5, 10,
LINE_TO, 7, 8,
LINE_TO, 5, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBackspaceRepList, kBackspaceIcon, {kBackspacePath})
VECTOR_ICON_REP_TEMPLATE(kBatterySaverRefreshPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 9.67, 15.49,
R_CUBIC_TO, 0.67, 0, 1.29, -0.12, 1.88, -0.37,
R_ARC_TO, 4.73, 4.73, 0, 0, 0, 1.56, -1.09,
ARC_TO, 7.52, 7.52, 0, 0, 0, 15, 10.69,
R_CUBIC_TO, 0.34, -1.27, 0.51, -2.56, 0.51, -3.88,
R_CUBIC_TO, 0, -0.37, -0.02, -0.73, -0.06, -1.09,
R_CUBIC_TO, -0.04, -0.36, -0.07, -0.71, -0.09, -1.08,
R_CUBIC_TO, -0.35, -0.04, -0.7, -0.07, -1.03, -0.11,
R_CUBIC_TO, -0.34, -0.03, -0.68, -0.05, -1.03, -0.05,
R_CUBIC_TO, -1.36, 0, -2.69, 0.17, -3.99, 0.51,
R_ARC_TO, 7.44, 7.44, 0, 0, 0, -3.4, 1.95,
R_CUBIC_TO, -0.45, 0.45, -0.8, 0.97, -1.04, 1.56,
R_ARC_TO, 4.76, 4.76, 0, 0, 0, -0.37, 1.85,
ARC_TO, 5.14, 5.14, 0, 0, 0, 6, 14,
R_CUBIC_TO, 0.48, 0.48, 1.04, 0.85, 1.68, 1.11,
R_ARC_TO, 5.25, 5.25, 0, 0, 0, 1.99, 0.38,
CLOSE,
R_MOVE_TO, -0.1, 1.68,
R_CUBIC_TO, -0.75, 0, -1.47, -0.12, -2.16, -0.37,
R_ARC_TO, 7.2, 7.2, 0, 0, 1, -1.93, -1.04,
R_LINE_TO, -1.41, 1.41,
R_LINE_TO, -1.23, -1.23,
R_LINE_TO, 1.41, -1.41,
R_CUBIC_TO, -0.45, -0.59, -0.8, -1.23, -1.04, -1.91,
R_ARC_TO, 6.32, 6.32, 0, 0, 1, -0.37, -2.16,
R_CUBIC_TO, 0, -0.89, 0.17, -1.75, 0.51, -2.57,
R_CUBIC_TO, 0.34, -0.82, 0.84, -1.54, 1.47, -2.16,
ARC_TO, 9.13, 9.13, 0, 0, 1, 8.72, 3.47,
R_ARC_TO, 16.37, 16.37, 0, 0, 1, 4.55, -0.64,
R_CUBIC_TO, 0.61, 0, 1.2, 0.02, 1.79, 0.08,
R_CUBIC_TO, 0.59, 0.05, 1.18, 0.14, 1.77, 0.25,
R_CUBIC_TO, 0.13, 0.6, 0.22, 1.21, 0.27, 1.82,
R_CUBIC_TO, 0.05, 0.61, 0.07, 1.22, 0.07, 1.83,
R_CUBIC_TO, 0, 1.54, -0.21, 3.05, -0.64, 4.52,
R_ARC_TO, 9.06, 9.06, 0, 0, 1, -2.25, 3.87,
R_ARC_TO, 6.31, 6.31, 0, 0, 1, -2.15, 1.47,
R_ARC_TO, 6.65, 6.65, 0, 0, 1, -2.57, 0.5,
CLOSE,
R_MOVE_TO, -0.61, -3.18,
R_LINE_TO, 3.95, -3.69,
R_ARC_TO, 0.5, 0.5, 0, 0, 0, 0.15, -0.56,
R_CUBIC_TO, -0.07, -0.22, -0.23, -0.34, -0.46, -0.35,
LINE_TO, 9.57, 9.21,
R_LINE_TO, 2.07, -2.64,
R_ARC_TO, 0.52, 0.52, 0, 0, 0, 0.07, -0.28,
R_ARC_TO, 0.36, 0.36, 0, 0, 0, -0.11, -0.25,
R_ARC_TO, 0.51, 0.51, 0, 0, 0, -0.29, -0.12,
R_ARC_TO, 0.33, 0.33, 0, 0, 0, -0.26, 0.09,
LINE_TO, 7.09, 9.7,
R_CUBIC_TO, -0.19, 0.16, -0.23, 0.34, -0.15, 0.56,
R_CUBIC_TO, 0.09, 0.22, 0.25, 0.34, 0.49, 0.35,
R_LINE_TO, 3, 0.18,
R_LINE_TO, -2.07, 2.65,
R_ARC_TO, 0.34, 0.34, 0, 0, 0, -0.09, 0.28,
R_ARC_TO, 0.5, 0.5, 0, 0, 0, 0.13, 0.27,
R_CUBIC_TO, 0.07, 0.07, 0.16, 0.11, 0.27, 0.12,
R_CUBIC_TO, 0.11, 0, 0.2, -0.04, 0.28, -0.1,
CLOSE,
MOVE_TO, 10, 10,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBatterySaverRefreshRepList, kBatterySaverRefreshIcon, {kBatterySaverRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kBookmarkAllTabsChromeRefreshPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
R_MOVE_TO, 11.23, 9.52,
R_LINE_TO, 2.43, -2.08,
R_LINE_TO, 2.02, 0.18,
R_LINE_TO, -2.91, 2.49,
R_LINE_TO, 0.89, 3.71,
R_LINE_TO, -1.64, -1,
CLOSE,
MOVE_TO, 9.7, 4.84,
R_LINE_TO, -0.69, -1.59,
R_LINE_TO, 0.86, -1.98,
LINE_TO, 11.46, 4.98,
CLOSE,
R_MOVE_TO, -4.55, 6.17,
R_LINE_TO, 2.06, -1.22,
R_LINE_TO, 2.07, 1.22,
R_LINE_TO, -0.55, -2.31,
R_LINE_TO, 1.79, -1.53,
R_LINE_TO, -2.36, -0.21,
R_LINE_TO, -0.95, -2.2,
R_LINE_TO, -0.94, 2.2,
R_LINE_TO, -2.36, 0.2,
R_LINE_TO, 1.8, 1.52,
CLOSE,
R_MOVE_TO, -2.09, 2.87,
R_LINE_TO, 1.11, -4.66,
R_LINE_TO, -3.68, -3.14,
LINE_TO, 5.31, 5.66,
R_LINE_TO, 1.89, -4.4,
R_LINE_TO, 1.89, 4.41,
R_LINE_TO, 4.83, 0.4,
R_LINE_TO, -3.68, 3.14,
R_LINE_TO, 1.11, 4.66,
R_LINE_TO, -4.15, -2.47,
CLOSE,
R_MOVE_TO, 4.15, -5.65,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBookmarkAllTabsChromeRefreshRepList, kBookmarkAllTabsChromeRefreshIcon, {kBookmarkAllTabsChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kBookmarkbarOverflowRefreshPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 9.57, 12,
LINE_TO, 5, 7.4,
LINE_TO, 6.4, 6,
R_LINE_TO, 6, 6,
R_LINE_TO, -6, 6,
LINE_TO, 5, 16.6,
CLOSE,
R_MOVE_TO, 6.6, 0,
R_LINE_TO, -4.57, -4.6,
LINE_TO, 13, 6,
R_LINE_TO, 6, 6,
R_LINE_TO, -6, 6,
R_LINE_TO, -1.4, -1.4,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kBookmarkbarOverflowRefresh16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 6.2, 8,
LINE_TO, 3.05, 4.85,
R_LINE_TO, 0.98, -0.98,
LINE_TO, 8.15, 8,
R_LINE_TO, -4.12, 4.13,
R_LINE_TO, -0.98, -0.98,
CLOSE,
MOVE_TO, 11, 8,
LINE_TO, 7.85, 4.85,
R_LINE_TO, 0.98, -0.98,
LINE_TO, 12.95, 8,
R_LINE_TO, -4.13, 4.13,
R_LINE_TO, -0.98, -0.98,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBookmarkbarOverflowRefreshRepList, kBookmarkbarOverflowRefreshIcon, {kBookmarkbarOverflowRefreshPath}, {kBookmarkbarOverflowRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kBookmarksListsMenuPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 5.94, 11.01,
LINE_TO, 8, 9.79,
R_LINE_TO, 2.07, 1.22,
R_LINE_TO, -0.55, -2.31,
R_LINE_TO, 1.79, -1.53,
R_LINE_TO, -2.36, -0.21,
LINE_TO, 8, 4.76,
LINE_TO, 7.05, 6.97,
R_LINE_TO, -2.36, 0.2,
R_LINE_TO, 1.8, 1.52,
CLOSE,
R_MOVE_TO, -2.09, 2.87,
R_LINE_TO, 1.11, -4.66,
R_LINE_TO, -3.68, -3.14,
LINE_TO, 6.11, 5.66,
LINE_TO, 8, 1.26,
R_LINE_TO, 1.89, 4.41,
R_LINE_TO, 4.83, 0.4,
R_LINE_TO, -3.68, 3.14,
R_LINE_TO, 1.11, 4.66,
LINE_TO, 8, 11.4,
CLOSE,
MOVE_TO, 8, 8.06,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBookmarksListsMenuRepList, kBookmarksListsMenuIcon, {kBookmarksListsMenuPath})
VECTOR_ICON_REP_TEMPLATE(kBookmarksManagerPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 3.5, 14.5,
R_V_LINE_TO, -9,
CLOSE,
R_MOVE_TO, 0, 1.5,
R_ARC_TO, 1.45, 1.45, 0, 0, 1, -1.05, -0.44,
CUBIC_TO, 2.15, 15.27, 2, 14.91, 2, 14.5,
V_LINE_TO, 5.49,
R_CUBIC_TO, 0, -0.41, 0.15, -0.76, 0.44, -1.05,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3.5, 4,
H_LINE_TO, 8,
R_LINE_TO, 2, 2,
R_H_LINE_TO, 6.5,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 2.19,
R_ARC_TO, 2.83, 2.83, 0, 0, 0, -0.74, -0.18,
R_ARC_TO, 1.92, 1.92, 0, 0, 0, -0.76, 0.06,
V_LINE_TO, 7.5,
H_LINE_TO, 9.38,
R_LINE_TO, -2, -2,
H_LINE_TO, 3.5,
R_V_LINE_TO, 9,
R_H_LINE_TO, 7.52,
R_LINE_TO, -0.52, 0.52,
V_LINE_TO, 16,
CLOSE,
R_MOVE_TO, 8.5, 2,
R_V_LINE_TO, -2.35,
R_LINE_TO, 4.38, -4.35,
R_ARC_TO, 0.84, 0.84, 0, 0, 1, 0.34, -0.22,
R_CUBIC_TO, 0.13, -0.05, 0.25, -0.07, 0.37, -0.07,
R_ARC_TO, 1, 1, 0, 0, 1, 0.72, 0.29,
R_LINE_TO, 0.91, 0.94,
R_CUBIC_TO, 0.09, 0.1, 0.16, 0.21, 0.22, 0.34,
R_ARC_TO, 0.96, 0.96, 0, 0, 1, 0.01, 0.74,
R_ARC_TO, 0.81, 0.81, 0, 0, 1, -0.22, 0.34,
LINE_TO, 14.36, 18,
CLOSE,
R_MOVE_TO, 6, -5.06,
LINE_TO, 17.06, 12,
CLOSE,
MOVE_TO, 13, 17,
R_H_LINE_TO, 0.94,
R_LINE_TO, 2.39, -2.39,
R_LINE_TO, -0.46, -0.48,
R_LINE_TO, -0.46, -0.46,
LINE_TO, 13, 16.06,
CLOSE,
R_MOVE_TO, 2.88, -2.87,
R_LINE_TO, -0.46, -0.46,
R_LINE_TO, 0.91, 0.94,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBookmarksManagerRepList, kBookmarksManagerIcon, {kBookmarksManagerPath})
VECTOR_ICON_REP_TEMPLATE(kBookmarksSidePanelPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 14, 12.9,
R_LINE_TO, 3, -2.6,
R_LINE_TO, 2.5, 0.2,
LINE_TO, 16, 13.6,
R_LINE_TO, 1.1, 4.6,
LINE_TO, 15, 17,
CUBIC_TO, 15, 17, 14, 12.9, 14, 12.9,
CLOSE,
MOVE_TO, 12.1, 7,
R_LINE_TO, -0.9, -2,
R_LINE_TO, 1.1, -2.5,
R_LINE_TO, 2, 4.6,
LINE_TO, 12.1, 7,
CLOSE,
MOVE_TO, 6.4, 14.8,
LINE_TO, 9, 13.2,
R_LINE_TO, 2.6, 1.5,
R_LINE_TO, -0.7, -2.9,
R_LINE_TO, 2.2, -1.9,
R_LINE_TO, -3, -0.3,
LINE_TO, 9, 7,
LINE_TO, 7.8, 9.7,
R_LINE_TO, -3, 0.3,
R_LINE_TO, 2.3, 1.9,
CUBIC_TO, 7.1, 11.9, 6.4, 14.8, 6.4, 14.8,
CLOSE,
MOVE_TO, 3.8, 18.3,
R_LINE_TO, 1.4, -5.8,
LINE_TO, 0.6, 8.6,
R_LINE_TO, 6, -0.5,
LINE_TO, 9, 2.6,
R_LINE_TO, 2.4, 5.5,
R_LINE_TO, 6, 0.5,
R_LINE_TO, -4.6, 3.9,
R_LINE_TO, 1.4, 5.8,
LINE_TO, 9, 15.3,
LINE_TO, 3.8, 18.3,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBookmarksSidePanelRepList, kBookmarksSidePanelIcon, {kBookmarksSidePanelPath})
VECTOR_ICON_REP_TEMPLATE(kBookmarksSidePanelRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 13.75, 11.81,
R_LINE_TO, 3.04, -2.61,
LINE_TO, 19, 9.4,
R_LINE_TO, -3.58, 3.06,
LINE_TO, 16.5, 17,
R_LINE_TO, -1.77, -1.06,
CLOSE,
R_MOVE_TO, -1.81, -5.52,
R_LINE_TO, -0.89, -2.06,
LINE_TO, 12, 2,
R_LINE_TO, 1.92, 4.46,
CLOSE,
R_MOVE_TO, -5.6, 7.6,
LINE_TO, 9, 12.31,
R_LINE_TO, 2.69, 1.58,
R_LINE_TO, -0.71, -3,
R_LINE_TO, 2.31, -1.98,
R_LINE_TO, -3.06, -0.27,
LINE_TO, 9, 5.79,
LINE_TO, 7.77, 8.65,
R_LINE_TO, -3.06, 0.27,
R_LINE_TO, 2.34, 1.98,
CLOSE,
MOVE_TO, 4.06, 17,
R_LINE_TO, 1.31, -5.54,
LINE_TO, 1, 7.73,
R_LINE_TO, 5.75, -0.5,
LINE_TO, 9, 2,
R_LINE_TO, 2.25, 5.25,
R_LINE_TO, 5.75, 0.48,
R_LINE_TO, -4.37, 3.73,
LINE_TO, 13.94, 17,
LINE_TO, 9, 14.06,
CLOSE,
MOVE_TO, 9, 10.27,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBookmarksSidePanelRefreshRepList, kBookmarksSidePanelRefreshIcon, {kBookmarksSidePanelRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kBottomPanelClosePath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 12, 11.5f,
LINE_TO, 16, 7.5f,
LINE_TO, 8, 7.5f,
CLOSE,
MOVE_TO, 19, 3,
CUBIC_TO, 19.55f, 3, 20.02f, 3.2f, 20.41f, 3.59f,
CUBIC_TO, 20.8f, 3.98f, 21, 4.45f, 21, 5,
LINE_TO, 21, 19,
CUBIC_TO, 21, 19.55f, 20.8f, 20.02f, 20.41f, 20.41f,
CUBIC_TO, 20.02f, 20.8f, 19.55f, 21, 19, 21,
LINE_TO, 5, 21,
CUBIC_TO, 4.45f, 21, 3.98f, 20.8f, 3.59f, 20.41f,
CUBIC_TO, 3.2f, 20.02f, 3, 19.55f, 3, 19,
LINE_TO, 3, 5,
CUBIC_TO, 3, 4.45f, 3.2f, 3.98f, 3.59f, 3.59f,
CUBIC_TO, 3.98f, 3.2f, 4.45f, 3, 5, 3,
CLOSE,
MOVE_TO, 5, 16,
LINE_TO, 5, 19,
LINE_TO, 19, 19,
LINE_TO, 19, 16,
CLOSE,
MOVE_TO, 19, 14,
LINE_TO, 19, 5,
LINE_TO, 5, 5,
LINE_TO, 5, 14,
CLOSE,
MOVE_TO, 5, 16,
LINE_TO, 5, 19,
CLOSE,
MOVE_TO, 5, 16,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBottomPanelCloseRepList, kBottomPanelCloseIcon, {kBottomPanelClosePath})
VECTOR_ICON_REP_TEMPLATE(kBrowserLogoPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 5.5, 8.02,
R_CUBIC_TO, 0, 0.7, 0.24, 1.29, 0.73, 1.77,
R_ARC_TO, 2.41, 2.41, 0, 0, 0, 1.77, 0.73,
R_CUBIC_TO, 0.7, 0, 1.29, -0.24, 1.77, -0.73,
R_ARC_TO, 2.41, 2.41, 0, 0, 0, 0.73, -1.77,
R_CUBIC_TO, 0, -0.69, -0.24, -1.28, -0.73, -1.77,
ARC_TO, 2.41, 2.41, 0, 0, 0, 8, 5.52,
R_CUBIC_TO, -0.69, 0, -1.28, 0.24, -1.77, 0.73,
R_ARC_TO, 2.41, 2.41, 0, 0, 0, -0.73, 1.77,
CLOSE,
MOVE_TO, 8, 11.77,
R_CUBIC_TO, 0.13, 0, 0.25, 0, 0.39, -0.01,
R_CUBIC_TO, 0.14, -0.01, 0.26, -0.03, 0.39, -0.06,
LINE_TO, 7.09, 14.59,
R_CUBIC_TO, -1.66, -0.18, -3.03, -0.9, -4.11, -2.16,
R_CUBIC_TO, -1.08, -1.26, -1.62, -2.73, -1.62, -4.41,
R_ARC_TO, 6.54, 6.54, 0, 0, 1, 0.66, -2.86,
R_LINE_TO, 2.77, 4.73,
R_CUBIC_TO, 0.33, 0.59, 0.77, 1.05, 1.35, 1.38,
R_CUBIC_TO, 0.58, 0.33, 1.2, 0.5, 1.87, 0.5,
CLOSE,
MOVE_TO, 8, 4.27,
R_CUBIC_TO, -0.82, 0, -1.55, 0.24, -2.19, 0.73,
ARC_TO, 3.79, 3.79, 0, 0, 0, 4.46, 6.87,
LINE_TO, 2.77, 3.94,
R_ARC_TO, 6.2, 6.2, 0, 0, 1, 2.29, -1.9,
ARC_TO, 6.64, 6.64, 0, 0, 1, 8, 1.38,
R_CUBIC_TO, 1.09, 0, 2.13, 0.26, 3.09, 0.77,
R_ARC_TO, 6.72, 6.72, 0, 0, 1, 2.38, 2.12,
CLOSE,
R_MOVE_TO, 6.16, 1.25,
R_CUBIC_TO, 0.17, 0.41, 0.3, 0.82, 0.37, 1.23,
R_CUBIC_TO, 0.08, 0.42, 0.12, 0.84, 0.12, 1.27,
R_CUBIC_TO, 0, 1.79, -0.58, 3.29, -1.73, 4.5,
R_CUBIC_TO, -1.15, 1.22, -2.62, 1.93, -4.41, 2.12,
R_LINE_TO, 2.71, -4.75,
R_CUBIC_TO, 0.16, -0.29, 0.29, -0.59, 0.38, -0.9,
R_ARC_TO, 3.34, 3.34, 0, 0, 0, 0.14, -0.97,
R_CUBIC_TO, 0, -0.46, -0.09, -0.91, -0.26, -1.34,
R_ARC_TO, 4.12, 4.12, 0, 0, 0, -0.71, -1.16,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBrowserLogoRepList, kBrowserLogoIcon, {kBrowserLogoPath})
VECTOR_ICON_REP_TEMPLATE(kBrowserToolsPath, CANVAS_DIMENSIONS, 32,
MOVE_TO, 16, 9,
CUBIC_TO, 17.66, 9, 19, 7.66, 19, 6,
CUBIC_TO, 19, 4.34, 17.66, 3, 16, 3,
CUBIC_TO, 14.34, 3, 13, 4.34, 13, 6,
CUBIC_TO, 13, 7.66, 14.34, 9, 16, 9,
CLOSE,
MOVE_TO, 16, 19,
CUBIC_TO, 17.66, 19, 19, 17.66, 19, 16,
CUBIC_TO, 19, 14.34, 17.66, 13, 16, 13,
CUBIC_TO, 14.34, 13, 13, 14.34, 13, 16,
CUBIC_TO, 13, 17.66, 14.34, 19, 16, 19,
CLOSE,
MOVE_TO, 16, 29,
CUBIC_TO, 17.66, 29, 19, 27.66, 19, 26,
CUBIC_TO, 19, 24.34, 17.66, 23, 16, 23,
CUBIC_TO, 14.34, 23, 13, 24.34, 13, 26,
CUBIC_TO, 13, 27.66, 14.34, 29, 16, 29,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kBrowserTools16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 7, 3.5,
CUBIC_TO, 7, 2.67, 7.67, 2, 8.5, 2,
CUBIC_TO, 9.33, 2, 10, 2.67, 10, 3.5,
CUBIC_TO, 10, 4.33, 9.33, 5, 8.5, 5,
CUBIC_TO, 7.67, 5, 7, 4.33, 7, 3.5,
CLOSE,
MOVE_TO, 7, 8.5,
CUBIC_TO, 7, 7.67, 7.67, 7, 8.5, 7,
CUBIC_TO, 9.33, 7, 10, 7.67, 10, 8.5,
CUBIC_TO, 10, 9.33, 9.33, 10, 8.5, 10,
CUBIC_TO, 7.67, 10, 7, 9.33, 7, 8.5,
CLOSE,
MOVE_TO, 7, 13.5,
CUBIC_TO, 7, 12.67, 7.67, 12, 8.5, 12,
CUBIC_TO, 9.33, 12, 10, 12.67, 10, 13.5,
CUBIC_TO, 10, 14.33, 9.33, 15, 8.5, 15,
CUBIC_TO, 7.67, 15, 7, 14.33, 7, 13.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBrowserToolsRepList, kBrowserToolsIcon, {kBrowserToolsPath}, {kBrowserTools16Path})
VECTOR_ICON_REP_TEMPLATE(kBrowserToolsChromeRefreshPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 10, 6,
R_CUBIC_TO, 0.83, 0, 1.5, -0.68, 1.5, -1.5,
R_CUBIC_TO, 0, -0.82, -0.67, -1.5, -1.5, -1.5,
R_CUBIC_TO, -0.83, 0, -1.5, 0.68, -1.5, 1.5,
R_CUBIC_TO, 0, 0.82, 0.67, 1.5, 1.5, 1.5,
CLOSE,
R_MOVE_TO, 0, 2.5,
R_CUBIC_TO, -0.83, 0, -1.5, 0.67, -1.5, 1.5,
R_CUBIC_TO, 0, 0.83, 0.67, 1.5, 1.5, 1.5,
R_CUBIC_TO, 0.83, 0, 1.5, -0.67, 1.5, -1.5,
R_CUBIC_TO, 0, -0.83, -0.67, -1.5, -1.5, -1.5,
CLOSE,
R_MOVE_TO, 0, 5.5,
R_CUBIC_TO, -0.83, 0, -1.5, 0.67, -1.5, 1.5,
R_CUBIC_TO, 0, 0.83, 0.67, 1.5, 1.5, 1.5,
R_CUBIC_TO, 0.83, 0, 1.5, -0.67, 1.5, -1.5,
R_CUBIC_TO, 0, -0.83, -0.67, -1.5, -1.5, -1.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBrowserToolsChromeRefreshRepList, kBrowserToolsChromeRefreshIcon, {kBrowserToolsChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kBrowserToolsErrorPath, CANVAS_DIMENSIONS, 16,
CIRCLE, 8, 8, 8,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xFF, 0xFF,
MOVE_TO, 9, 8,
H_LINE_TO, 7,
V_LINE_TO, 4,
R_H_LINE_TO, 2,
R_V_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 0, 4,
H_LINE_TO, 7,
R_V_LINE_TO, -2,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBrowserToolsErrorRepList, kBrowserToolsErrorIcon, {kBrowserToolsErrorPath})
VECTOR_ICON_REP_TEMPLATE(kBrowserToolsTouchPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 12, 8,
R_ARC_TO, 2, 2, 0, 1, 0, 0, -4,
R_ARC_TO, 2, 2, 0, 0, 0, 0, 4,
CLOSE,
R_MOVE_TO, 0, 2,
R_ARC_TO, 2, 2, 0, 1, 0, 0, 4,
R_ARC_TO, 2, 2, 0, 0, 0, 0, -4,
CLOSE,
R_MOVE_TO, 0, 6,
R_ARC_TO, 2, 2, 0, 1, 0, 0, 4,
R_ARC_TO, 2, 2, 0, 0, 0, 0, -4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBrowserToolsTouchRepList, kBrowserToolsTouchIcon, {kBrowserToolsTouchPath})
VECTOR_ICON_REP_TEMPLATE(kBrowserToolsUpdatePath, CANVAS_DIMENSIONS, 16,
CIRCLE, 8, 8, 8,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xFF, 0xFF,
MOVE_TO, 6, 12,
R_H_LINE_TO, 4,
V_LINE_TO, 9,
R_H_LINE_TO, 2,
LINE_TO, 8, 4,
LINE_TO, 4, 9,
R_H_LINE_TO, 2,
R_V_LINE_TO, 3,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBrowserToolsUpdateRepList, kBrowserToolsUpdateIcon, {kBrowserToolsUpdatePath})
VECTOR_ICON_REP_TEMPLATE(kBrowserToolsUpdateChromeRefreshPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
R_MOVE_TO, 4.06, 6.75,
R_LINE_TO, 1.21, 0.4,
R_CUBIC_TO, 0.15, -0.28, 0.31, -0.55, 0.47, -0.82,
R_CUBIC_TO, 0.16, -0.27, 0.33, -0.54, 0.52, -0.8,
R_LINE_TO, -0.86, -0.1,
CLOSE,
R_MOVE_TO, 2.36, 1.15,
R_LINE_TO, 1.66, 1.67,
R_ARC_TO, 17.77, 17.77, 0, 0, 0, 1.52, -0.92,
R_ARC_TO, 9.17, 9.17, 0, 0, 0, 1.32, -1.1,
R_ARC_TO, 9.62, 9.62, 0, 0, 0, 1.64, -2.17,
R_CUBIC_TO, 0.43, -0.79, 0.66, -1.66, 0.67, -2.61,
R_CUBIC_TO, -0.96, 0.01, -1.84, 0.23, -2.63, 0.66,
R_CUBIC_TO, -0.79, 0.43, -1.51, 0.97, -2.16, 1.63,
R_CUBIC_TO, -0.42, 0.42, -0.79, 0.86, -1.11, 1.33,
R_ARC_TO, 13.83, 13.83, 0, 0, 0, -0.91, 1.52,
CLOSE,
R_MOVE_TO, 2.88, -1.19,
R_ARC_TO, 1.13, 1.13, 0, 0, 1, -0.34, -0.83,
R_CUBIC_TO, 0, -0.32, 0.11, -0.6, 0.34, -0.83,
R_CUBIC_TO, 0.23, -0.23, 0.5, -0.34, 0.83, -0.34,
R_CUBIC_TO, 0.32, 0, 0.6, 0.12, 0.83, 0.34,
R_CUBIC_TO, 0.23, 0.23, 0.34, 0.5, 0.34, 0.83,
R_CUBIC_TO, 0, 0.33, -0.12, 0.61, -0.34, 0.83,
R_CUBIC_TO, -0.23, 0.23, -0.5, 0.34, -0.83, 0.34,
R_CUBIC_TO, -0.32, 0, -0.6, -0.11, -0.83, -0.34,
CLOSE,
R_MOVE_TO, -0.05, 5.23,
R_LINE_TO, 1.34, -1.34,
R_LINE_TO, -0.1, -0.86,
R_CUBIC_TO, -0.27, 0.18, -0.54, 0.36, -0.8, 0.52,
R_CUBIC_TO, -0.27, 0.16, -0.54, 0.32, -0.82, 0.47,
CLOSE,
R_MOVE_TO, 5.24, -10.43,
R_CUBIC_TO, 0.28, 1.24, 0.17, 2.47, -0.33, 3.7,
R_ARC_TO, 9.47, 9.47, 0, 0, 1, -2.1, 3.19,
R_CUBIC_TO, 0, 0.01, -0.05, 0.06, -0.15, 0.16,
R_LINE_TO, -0.15, 0.16,
R_LINE_TO, 0.2, 1.7,
R_CUBIC_TO, 0.03, 0.22, 0.01, 0.43, -0.06, 0.63,
R_CUBIC_TO, -0.07, 0.2, -0.18, 0.38, -0.34, 0.54,
R_LINE_TO, -2.89, 2.89,
R_LINE_TO, -1.22, -3.59,
LINE_TO, 5.12, 8.57,
LINE_TO, 1.52, 7.35,
R_LINE_TO, 2.9, -2.91,
R_CUBIC_TO, 0.16, -0.16, 0.34, -0.27, 0.54, -0.34,
R_CUBIC_TO, 0.2, -0.07, 0.41, -0.09, 0.63, -0.06,
R_LINE_TO, 1.69, 0.22,
R_ARC_TO, 39.7, 39.7, 0, 0, 1, 0.35, -0.33,
R_ARC_TO, 9.59, 9.59, 0, 0, 1, 3.17, -2.1,
R_CUBIC_TO, 1.22, -0.5, 2.44, -0.61, 3.68, -0.32,
CLOSE,
MOVE_TO, 2.81, 10.51,
R_ARC_TO, 1.85, 1.85, 0, 0, 1, 1.34, -0.53,
R_CUBIC_TO, 0.51, 0, 0.96, 0.2, 1.34, 0.58,
R_CUBIC_TO, 0.36, 0.36, 0.54, 0.79, 0.55, 1.29,
R_CUBIC_TO, 0.01, 0.5, -0.16, 0.95, -0.5, 1.33,
R_CUBIC_TO, -0.5, 0.57, -1.14, 0.93, -1.91, 1.08,
R_CUBIC_TO, -0.77, 0.15, -1.52, 0.28, -2.26, 0.4,
R_ARC_TO, 58.28, 58.28, 0, 0, 1, 0.39, -2.23,
R_ARC_TO, 3.5, 3.5, 0, 0, 1, 1.04, -1.92,
CLOSE,
R_MOVE_TO, 0.88, 1.08,
R_CUBIC_TO, -0.18, 0.18, -0.3, 0.39, -0.35, 0.61,
R_ARC_TO, 6.42, 6.42, 0, 0, 1, -0.19, 0.7,
R_ARC_TO, 49.4, 49.4, 0, 0, 1, 0.69, -0.19,
R_CUBIC_TO, 0.22, -0.06, 0.42, -0.18, 0.59, -0.36,
R_ARC_TO, 0.78, 0.78, 0, 0, 0, 0.2, -0.42,
R_ARC_TO, 0.43, 0.43, 0, 0, 0, -0.13, -0.4,
R_ARC_TO, 0.44, 0.44, 0, 0, 0, -0.39, -0.14,
R_ARC_TO, 0.78, 0.78, 0, 0, 0, -0.41, 0.2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBrowserToolsUpdateChromeRefreshRepList, kBrowserToolsUpdateChromeRefreshIcon, {kBrowserToolsUpdateChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kCastChromeRefreshPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 8, 8,
CLOSE,
R_MOVE_TO, 5.15, 4.93,
H_LINE_TO, 9.25,
R_CUBIC_TO, 0, -0.23, -0.01, -0.46, -0.03, -0.69,
R_ARC_TO, 8.41, 8.41, 0, 0, 0, -0.1, -0.69,
R_H_LINE_TO, 4.04,
V_LINE_TO, 4.45,
H_LINE_TO, 2.85,
R_V_LINE_TO, 0.84,
R_ARC_TO, 7.02, 7.02, 0, 0, 0, -1.38, -0.13,
V_LINE_TO, 4.45,
R_CUBIC_TO, 0, -0.38, 0.13, -0.71, 0.4, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.4, 0.98, -0.4,
R_H_LINE_TO, 10.31,
R_CUBIC_TO, 0.38, 0, 0.71, 0.13, 0.98, 0.4,
R_CUBIC_TO, 0.27, 0.27, 0.4, 0.6, 0.4, 0.98,
R_V_LINE_TO, 7.11,
R_CUBIC_TO, 0, 0.38, -0.13, 0.71, -0.4, 0.98,
R_CUBIC_TO, -0.27, 0.27, -0.6, 0.4, -0.98, 0.4,
CLOSE,
R_MOVE_TO, -11.69, 0,
R_V_LINE_TO, -1.66,
R_CUBIC_TO, 0.46, 0, 0.86, 0.16, 1.18, 0.48,
R_CUBIC_TO, 0.32, 0.32, 0.48, 0.72, 0.48, 1.18,
CLOSE,
R_MOVE_TO, 2.86, 0,
R_CUBIC_TO, 0, -0.79, -0.28, -1.47, -0.84, -2.03,
R_ARC_TO, 2.78, 2.78, 0, 0, 0, -2.03, -0.84,
V_LINE_TO, 8.81,
R_CUBIC_TO, 1.14, 0, 2.12, 0.4, 2.92, 1.2,
R_CUBIC_TO, 0.8, 0.8, 1.2, 1.77, 1.2, 2.92,
CLOSE,
R_MOVE_TO, 2.46, 0,
R_CUBIC_TO, 0, -0.73, -0.14, -1.42, -0.42, -2.07,
R_ARC_TO, 5.43, 5.43, 0, 0, 0, -1.14, -1.69,
R_ARC_TO, 5.42, 5.42, 0, 0, 0, -1.69, -1.14,
R_ARC_TO, 5.19, 5.19, 0, 0, 0, -2.07, -0.41,
V_LINE_TO, 6.35,
R_CUBIC_TO, 0.91, 0, 1.77, 0.17, 2.57, 0.52,
R_ARC_TO, 6.64, 6.64, 0, 0, 1, 2.09, 1.41,
R_ARC_TO, 6.58, 6.58, 0, 0, 1, 1.41, 2.09,
R_ARC_TO, 6.41, 6.41, 0, 0, 1, 0.52, 2.57,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCastChromeRefreshRepList, kCastChromeRefreshIcon, {kCastChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kChevronRightPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 7.59, 18.59,
LINE_TO, 9, 20,
R_LINE_TO, 8, -8,
R_LINE_TO, -8, -8,
R_LINE_TO, -1.41, 1.41,
LINE_TO, 14.17, 12,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kChevronRightRepList, kChevronRightIcon, {kChevronRightPath})
VECTOR_ICON_REP_TEMPLATE(kChevronRightChromeRefreshPath, CANVAS_DIMENSIONS, 20,
R_MOVE_TO, 8, 15.16,
R_LINE_TO, -1.22, -1.22,
LINE_TO, 10.72, 10,
LINE_TO, 6.78, 6.06,
LINE_TO, 8, 4.84,
LINE_TO, 13.16, 10,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kChevronRightChromeRefreshRepList, kChevronRightChromeRefreshIcon, {kChevronRightChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kChromiumMinimizePath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 4, 20,
R_V_LINE_TO, -2,
R_H_LINE_TO, 16,
R_V_LINE_TO, 2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kChromiumMinimizeRepList, kChromiumMinimizeIcon, {kChromiumMinimizePath})
VECTOR_ICON_REP_TEMPLATE(kClickToCallIllustrationPath, CANVAS_DIMENSIONS, 320,
PATH_COLOR_ARGB, 0xFF, 0xF8, 0xF9, 0xFA,
MOVE_TO, -12, -5,
R_H_LINE_TO, 358,
R_V_LINE_TO, 94,
H_LINE_TO, -12,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xE8, 0xE9, 0xEB,
MOVE_TO, 223.44, 14.8,
R_CUBIC_TO, 0, -13.05, -3.67, -23.31, -10.9, -30.5,
R_CUBIC_TO, -11.35, -11.3, -27.96, -11.35, -28.12, -11.35,
R_LINE_TO, -0.05, -6.38,
R_CUBIC_TO, 0.78, 0, 19.34, 0, 32.62, 13.16,
R_CUBIC_TO, 8.5, 8.43, 12.82, 20.23, 12.82, 35.07,
R_H_LINE_TO, -6.37,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xBD, 0xC0, 0xC5,
STROKE, 0.8,
MOVE_TO, 240.5, 14.36,
R_H_LINE_TO, 2.98,
R_ARC_TO, 7.99, 7.99, 0, 0, 1, 8, 8,
V_LINE_TO, 80,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xE5, 0x44, 0x40,
STROKE, 0.8,
MOVE_TO, 251.5, 86.25,
R_V_LINE_TO, 4.8,
R_ARC_TO, 7.99, 7.99, 0, 0, 1, -8, 8,
R_H_LINE_TO, -6.18,
R_MOVE_TO, 14.18, -12.8,
R_V_LINE_TO, 4.8,
R_ARC_TO, 7.99, 7.99, 0, 0, 1, -8, 8,
R_H_LINE_TO, -6.18,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xBD, 0xC0, 0xC5,
STROKE, 0.8,
MOVE_TO, 229.56, 14.36,
R_H_LINE_TO, -17.82,
R_ARC_TO, 7.99, 7.99, 0, 0, 0, -7.98, 8,
R_V_LINE_TO, 68.7,
R_ARC_TO, 7.99, 7.99, 0, 0, 0, 7.98, 7.98,
R_H_LINE_TO, 15.6,
R_MOVE_TO, 2.22, -84.68,
R_H_LINE_TO, -17.82,
R_ARC_TO, 7.99, 7.99, 0, 0, 0, -7.98, 8,
R_V_LINE_TO, 68.7,
R_ARC_TO, 7.99, 7.99, 0, 0, 0, 7.98, 7.98,
R_H_LINE_TO, 15.6,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xE8, 0xE9, 0xEB,
MOVE_TO, 101.18, 64.25,
R_LINE_TO, -4.5, -4.5,
R_CUBIC_TO, 0.3, -0.33, 7.9, -7.81, 19.76, -11.17,
R_CUBIC_TO, 11.04, -3.13, 27.9, -3.14, 45.6, 14.54,
R_LINE_TO, -4.52, 4.5,
R_CUBIC_TO, -12.44, -12.43, -25.68, -16.78, -39.34, -12.91,
R_ARC_TO, 42.99, 42.99, 0, 0, 0, -17, 9.53,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xF4, 0xF4, 0xF4,
MOVE_TO, 123.86, 27.94,
R_H_LINE_TO, -85.8,
R_ARC_TO, 4.5, 4.5, 0, 0, 0, -4.52, 4.43,
R_V_LINE_TO, 61.97,
R_H_LINE_TO, 94.83,
V_LINE_TO, 32.37,
R_ARC_TO, 4.48, 4.48, 0, 0, 0, -4.5, -4.43,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xBD, 0xC0, 0xC5,
STROKE, 0.8,
MOVE_TO, 123.86, 27.94,
R_H_LINE_TO, -85.8,
R_ARC_TO, 4.5, 4.5, 0, 0, 0, -4.52, 4.43,
R_V_LINE_TO, 61.97,
R_H_LINE_TO, 94.83,
V_LINE_TO, 32.37,
R_ARC_TO, 4.48, 4.48, 0, 0, 0, -4.5, -4.43,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xBD, 0xC0, 0xC5,
STROKE, 0.8,
MOVE_TO, 14.72, 99.04,
R_H_LINE_TO, 131.95,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xFF, 0xFF,
MOVE_TO, 214.44, 20.75,
R_ARC_TO, 4.3, 4.3, 0, 0, 0, -4.3, 4.28,
R_V_LINE_TO, 63.34,
R_ARC_TO, 4.3, 4.3, 0, 0, 0, 4.3, 4.27,
R_H_LINE_TO, 26.57,
R_ARC_TO, 4.3, 4.3, 0, 0, 0, 4.3, -4.28,
V_LINE_TO, 25.03,
R_ARC_TO, 4.3, 4.3, 0, 0, 0, -4.3, -4.28,
R_H_LINE_TO, -26.57,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xE8, 0xE9, 0xEB,
STROKE, 0.8,
MOVE_TO, 214.44, 20.75,
R_ARC_TO, 4.3, 4.3, 0, 0, 0, -4.3, 4.28,
R_V_LINE_TO, 63.34,
R_ARC_TO, 4.3, 4.3, 0, 0, 0, 4.3, 4.27,
R_H_LINE_TO, 26.57,
R_ARC_TO, 4.3, 4.3, 0, 0, 0, 4.3, -4.28,
V_LINE_TO, 25.03,
R_ARC_TO, 4.3, 4.3, 0, 0, 0, -4.3, -4.28,
R_H_LINE_TO, -26.57,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x42, 0x85, 0xF4,
MOVE_TO, 161.91, 62.98,
R_CUBIC_TO, 9.24, 9.23, 19.1, 13.9, 29.29, 13.87,
R_CUBIC_TO, 16.02, -0.04, 27.8, -11.74, 27.91, -11.86,
R_LINE_TO, 4.57, 4.47,
R_CUBIC_TO, -0.55, 0.56, -13.66, 13.68, -32.36, 13.76,
R_CUBIC_TO, -12, 0.05, -23.4, -5.24, -33.9, -15.74,
R_LINE_TO, 4.5, -4.5,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFB, 0xBC, 0x06,
MOVE_TO, 262.1, 8.96,
R_CUBIC_TO, -0.27, 1.02, -0.61, 1.73, -1.03, 2.15,
R_CUBIC_TO, -0.48, 0.48, -1.44, 0.94, -2.88, 1.39,
R_CUBIC_TO, 1.21, 0.31, 2.1, 0.74, 2.66, 1.31,
R_CUBIC_TO, 0.56, 0.56, 1, 1.45, 1.31, 2.66,
R_CUBIC_TO, 0.45, -1.44, 0.9, -2.4, 1.39, -2.88,
R_CUBIC_TO, 0.42, -0.42, 1.14, -0.76, 2.15, -1.03,
R_CUBIC_TO, -1.06, -0.3, -1.85, -0.71, -2.37, -1.23,
R_CUBIC_TO, -0.52, -0.52, -0.92, -1.31, -1.23, -2.37,
CLOSE,
MOVE_TO, 132.61, 17.72,
R_CUBIC_TO, -0.37, 1.62, -0.86, 2.74, -1.48, 3.35,
R_CUBIC_TO, -0.68, 0.68, -2.11, 1.33, -4.3, 1.98,
R_CUBIC_TO, 1.86, 0.42, 3.2, 1.03, 4.01, 1.84,
R_CUBIC_TO, 0.81, 0.81, 1.42, 2.15, 1.84, 4.01,
R_CUBIC_TO, 0.64, -2.19, 1.29, -3.62, 1.98, -4.3,
R_CUBIC_TO, 0.62, -0.62, 1.73, -1.1, 3.35, -1.48,
R_CUBIC_TO, -1.67, -0.41, -2.89, -0.99, -3.65, -1.75,
R_CUBIC_TO, -0.76, -0.76, -1.34, -1.97, -1.75, -3.65,
CLOSE,
MOVE_TO, 144.45, 12.85,
R_CUBIC_TO, -0.18, 0.55, -0.39, 0.95, -0.65, 1.21,
R_CUBIC_TO, -0.31, 0.32, -0.88, 0.61, -1.72, 0.89,
R_CUBIC_TO, 0.69, 0.22, 1.21, 0.5, 1.57, 0.85,
R_CUBIC_TO, 0.36, 0.36, 0.64, 0.88, 0.85, 1.57,
R_CUBIC_TO, 0.28, -0.84, 0.58, -1.41, 0.89, -1.72,
R_CUBIC_TO, 0.26, -0.26, 0.66, -0.48, 1.21, -0.65,
R_CUBIC_TO, -0.59, -0.2, -1.04, -0.46, -1.36, -0.78,
R_CUBIC_TO, -0.32, -0.32, -0.58, -0.77, -0.78, -1.36,
CLOSE,
MOVE_TO, 274.52, 4.46,
R_CUBIC_TO, -0.18, 0.55, -0.39, 0.95, -0.65, 1.21,
R_CUBIC_TO, -0.31, 0.32, -0.88, 0.61, -1.72, 0.89,
R_CUBIC_TO, 0.69, 0.22, 1.21, 0.5, 1.57, 0.85,
R_CUBIC_TO, 0.36, 0.36, 0.64, 0.88, 0.85, 1.57,
R_CUBIC_TO, 0.28, -0.84, 0.58, -1.41, 0.89, -1.72,
R_CUBIC_TO, 0.26, -0.26, 0.66, -0.48, 1.21, -0.65,
R_CUBIC_TO, -0.59, -0.2, -1.04, -0.46, -1.36, -0.78,
R_CUBIC_TO, -0.32, -0.32, -0.58, -0.77, -0.78, -1.36,
CLOSE,
MOVE_TO, 270.89, 45.28,
R_CUBIC_TO, -0.14, 0.39, -0.31, 0.68, -0.51, 0.88,
R_CUBIC_TO, -0.25, 0.25, -0.68, 0.49, -1.31, 0.71,
R_CUBIC_TO, 0.51, 0.18, 0.9, 0.4, 1.18, 0.68,
R_CUBIC_TO, 0.28, 0.28, 0.5, 0.67, 0.68, 1.18,
R_CUBIC_TO, 0.23, -0.62, 0.46, -1.06, 0.71, -1.31,
R_CUBIC_TO, 0.2, -0.2, 0.5, -0.37, 0.88, -0.51,
R_CUBIC_TO, -0.43, -0.17, -0.77, -0.37, -1.01, -0.62,
R_CUBIC_TO, -0.25, -0.25, -0.45, -0.58, -0.62, -1.01,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFB, 0xBC, 0x06,
STROKE, 0.8,
MOVE_TO, 262.1, 8.96,
R_CUBIC_TO, -0.27, 1.02, -0.61, 1.73, -1.03, 2.15,
R_CUBIC_TO, -0.48, 0.48, -1.44, 0.94, -2.88, 1.39,
R_CUBIC_TO, 1.21, 0.31, 2.1, 0.74, 2.66, 1.31,
R_CUBIC_TO, 0.56, 0.56, 1, 1.45, 1.31, 2.66,
R_CUBIC_TO, 0.45, -1.44, 0.9, -2.4, 1.39, -2.88,
R_CUBIC_TO, 0.42, -0.42, 1.14, -0.76, 2.15, -1.03,
R_CUBIC_TO, -1.06, -0.3, -1.85, -0.71, -2.37, -1.23,
R_CUBIC_TO, -0.52, -0.52, -0.92, -1.31, -1.23, -2.37,
CLOSE,
MOVE_TO, 132.61, 17.72,
R_CUBIC_TO, -0.37, 1.62, -0.86, 2.74, -1.48, 3.35,
R_CUBIC_TO, -0.68, 0.68, -2.11, 1.33, -4.3, 1.98,
R_CUBIC_TO, 1.86, 0.42, 3.2, 1.03, 4.01, 1.84,
R_CUBIC_TO, 0.81, 0.81, 1.42, 2.15, 1.84, 4.01,
R_CUBIC_TO, 0.64, -2.19, 1.29, -3.62, 1.98, -4.3,
R_CUBIC_TO, 0.62, -0.62, 1.73, -1.1, 3.35, -1.48,
R_CUBIC_TO, -1.67, -0.41, -2.89, -0.99, -3.65, -1.75,
R_CUBIC_TO, -0.76, -0.76, -1.34, -1.97, -1.75, -3.65,
CLOSE,
MOVE_TO, 144.45, 12.85,
R_CUBIC_TO, -0.18, 0.55, -0.39, 0.95, -0.65, 1.21,
R_CUBIC_TO, -0.31, 0.32, -0.88, 0.61, -1.72, 0.89,
R_CUBIC_TO, 0.69, 0.22, 1.21, 0.5, 1.57, 0.85,
R_CUBIC_TO, 0.36, 0.36, 0.64, 0.88, 0.85, 1.57,
R_CUBIC_TO, 0.28, -0.84, 0.58, -1.41, 0.89, -1.72,
R_CUBIC_TO, 0.26, -0.26, 0.66, -0.48, 1.21, -0.65,
R_CUBIC_TO, -0.59, -0.2, -1.04, -0.46, -1.36, -0.78,
R_CUBIC_TO, -0.32, -0.32, -0.58, -0.77, -0.78, -1.36,
CLOSE,
MOVE_TO, 274.52, 4.46,
R_CUBIC_TO, -0.18, 0.55, -0.39, 0.95, -0.65, 1.21,
R_CUBIC_TO, -0.31, 0.32, -0.88, 0.61, -1.72, 0.89,
R_CUBIC_TO, 0.69, 0.22, 1.21, 0.5, 1.57, 0.85,
R_CUBIC_TO, 0.36, 0.36, 0.64, 0.88, 0.85, 1.57,
R_CUBIC_TO, 0.28, -0.84, 0.58, -1.41, 0.89, -1.72,
R_CUBIC_TO, 0.26, -0.26, 0.66, -0.48, 1.21, -0.65,
R_CUBIC_TO, -0.59, -0.2, -1.04, -0.46, -1.36, -0.78,
R_CUBIC_TO, -0.32, -0.32, -0.58, -0.77, -0.78, -1.36,
CLOSE,
MOVE_TO, 270.89, 45.28,
R_CUBIC_TO, -0.14, 0.39, -0.31, 0.68, -0.51, 0.88,
R_CUBIC_TO, -0.25, 0.25, -0.68, 0.49, -1.31, 0.71,
R_CUBIC_TO, 0.51, 0.18, 0.9, 0.4, 1.18, 0.68,
R_CUBIC_TO, 0.28, 0.28, 0.5, 0.67, 0.68, 1.18,
R_CUBIC_TO, 0.23, -0.62, 0.46, -1.06, 0.71, -1.31,
R_CUBIC_TO, 0.2, -0.2, 0.5, -0.37, 0.88, -0.51,
R_CUBIC_TO, -0.43, -0.17, -0.77, -0.37, -1.01, -0.62,
R_CUBIC_TO, -0.25, -0.25, -0.45, -0.58, -0.62, -1.01,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xF8, 0xF9, 0xFA,
MOVE_TO, 302.43, 39.28,
R_H_LINE_TO, -34.75,
R_ARC_TO, 8.42, 8.42, 0, 0, 1, 11.2, -7.36,
R_LINE_TO, 0.38, 0.13,
R_LINE_TO, 0.25, -0.3,
R_ARC_TO, 12.86, 12.86, 0, 0, 1, 10.03, -4.8,
R_CUBIC_TO, 6.93, 0, 12.6, 5.48, 12.9, 12.33,
CLOSE,
R_MOVE_TO, 37.32, 42.06,
H_LINE_TO, 305,
R_ARC_TO, 8.42, 8.42, 0, 0, 1, 11.2, -7.37,
R_LINE_TO, 0.37, 0.14,
R_LINE_TO, 0.25, -0.3,
ARC_TO, 12.86, 12.86, 0, 0, 1, 326.86, 69,
R_ARC_TO, 12.9, 12.9, 0, 0, 1, 12.89, 12.34,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xE8, 0xE9, 0xEB,
STROKE, 0.8,
MOVE_TO, 302.43, 39.28,
R_H_LINE_TO, -34.75,
R_ARC_TO, 8.42, 8.42, 0, 0, 1, 11.2, -7.36,
R_LINE_TO, 0.38, 0.13,
R_LINE_TO, 0.25, -0.3,
R_ARC_TO, 12.86, 12.86, 0, 0, 1, 10.03, -4.8,
R_CUBIC_TO, 6.93, 0, 12.6, 5.48, 12.9, 12.33,
CLOSE,
R_MOVE_TO, 37.32, 42.06,
H_LINE_TO, 305,
R_ARC_TO, 8.42, 8.42, 0, 0, 1, 11.2, -7.37,
R_LINE_TO, 0.37, 0.14,
R_LINE_TO, 0.25, -0.3,
ARC_TO, 12.86, 12.86, 0, 0, 1, 326.86, 69,
R_ARC_TO, 12.9, 12.9, 0, 0, 1, 12.89, 12.34,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xBD, 0xC0, 0xC5,
MOVE_TO, 89.97, 67.82,
R_V_LINE_TO, 4.15,
R_ARC_TO, 1, 1, 0, 0, 1, -1.03, 1,
R_ARC_TO, 17.92, 17.92, 0, 0, 1, -8, -2.43,
R_ARC_TO, 18.08, 18.08, 0, 0, 1, -6.5, -6.5,
ARC_TO, 17.92, 17.92, 0, 0, 1, 72, 56.03,
ARC_TO, 1, 1, 0, 0, 1, 73, 55,
R_H_LINE_TO, 4.15,
R_ARC_TO, 1, 1, 0, 0, 1, 0.98, 0.8,
R_LINE_TO, 0.65, 3.26,
R_ARC_TO, 0.99, 0.99, 0, 0, 1, -0.27, 0.9,
R_LINE_TO, -2.62, 2.62,
R_CUBIC_TO, 1.5, 2.75, 3.75, 5, 6.5, 6.5,
R_LINE_TO, 2.6, -2.62,
R_ARC_TO, 0.98, 0.98, 0, 0, 1, 0.91, -0.27,
R_LINE_TO, 3.26, 0.65,
R_CUBIC_TO, 0.47, 0.1, 0.8, 0.5, 0.8, 0.98,
CLOSE,
MOVE_TO, 83, 58,
R_H_LINE_TO, 2.6,
R_LINE_TO, -4.32, 4.31,
R_LINE_TO, 1.41, 1.41,
LINE_TO, 87, 59.41,
V_LINE_TO, 62,
R_H_LINE_TO, 2,
R_V_LINE_TO, -6,
R_H_LINE_TO, -6,
R_V_LINE_TO, 2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kClickToCallIllustrationRepList, kClickToCallIllustrationIcon, {kClickToCallIllustrationPath})
VECTOR_ICON_REP_TEMPLATE(kClickToCallIllustrationDarkPath, CANVAS_DIMENSIONS, 320,
PATH_COLOR_ARGB, 0xFF, 0x20, 0x21, 0x24,
MOVE_TO, -12, -5,
R_H_LINE_TO, 358,
R_V_LINE_TO, 94,
H_LINE_TO, -12,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x3C, 0x40, 0x43,
MOVE_TO, 223.44, 14.8,
R_CUBIC_TO, 0, -13.05, -3.67, -23.31, -10.9, -30.5,
R_CUBIC_TO, -11.35, -11.3, -27.96, -11.35, -28.12, -11.35,
R_LINE_TO, -0.05, -6.38,
R_CUBIC_TO, 0.78, 0, 19.34, 0, 32.62, 13.16,
R_CUBIC_TO, 8.5, 8.43, 12.82, 20.23, 12.82, 35.07,
R_H_LINE_TO, -6.37,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
STROKE, 0.8,
MOVE_TO, 240.5, 14.36,
R_H_LINE_TO, 2.98,
R_ARC_TO, 7.99, 7.99, 0, 0, 1, 8, 8,
V_LINE_TO, 80,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xF6, 0xAE, 0xA9,
STROKE, 0.8,
MOVE_TO, 251.5, 86.25,
R_V_LINE_TO, 4.8,
R_ARC_TO, 7.99, 7.99, 0, 0, 1, -8, 8,
R_H_LINE_TO, -6.18,
R_MOVE_TO, 14.18, -12.8,
R_V_LINE_TO, 4.8,
R_ARC_TO, 7.99, 7.99, 0, 0, 1, -8, 8,
R_H_LINE_TO, -6.18,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
STROKE, 0.8,
MOVE_TO, 229.56, 14.36,
R_H_LINE_TO, -17.82,
R_ARC_TO, 7.99, 7.99, 0, 0, 0, -7.98, 8,
R_V_LINE_TO, 68.7,
R_ARC_TO, 7.99, 7.99, 0, 0, 0, 7.98, 7.98,
R_H_LINE_TO, 15.6,
R_MOVE_TO, 2.22, -84.68,
R_H_LINE_TO, -17.82,
R_ARC_TO, 7.99, 7.99, 0, 0, 0, -7.98, 8,
R_V_LINE_TO, 68.7,
R_ARC_TO, 7.99, 7.99, 0, 0, 0, 7.98, 7.98,
R_H_LINE_TO, 15.6,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x3C, 0x40, 0x43,
MOVE_TO, 101.18, 64.25,
R_LINE_TO, -4.5, -4.5,
R_CUBIC_TO, 0.3, -0.33, 7.9, -7.81, 19.76, -11.17,
R_CUBIC_TO, 11.04, -3.13, 27.9, -3.14, 45.6, 14.54,
R_LINE_TO, -4.52, 4.5,
R_CUBIC_TO, -12.44, -12.43, -25.68, -16.78, -39.34, -12.91,
R_ARC_TO, 42.99, 42.99, 0, 0, 0, -17, 9.53,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x20, 0x21, 0x24,
MOVE_TO, 123.86, 27.94,
R_H_LINE_TO, -85.8,
R_ARC_TO, 4.5, 4.5, 0, 0, 0, -4.52, 4.43,
R_V_LINE_TO, 61.97,
R_H_LINE_TO, 94.83,
V_LINE_TO, 32.37,
R_ARC_TO, 4.48, 4.48, 0, 0, 0, -4.5, -4.43,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
STROKE, 0.8,
MOVE_TO, 123.86, 27.94,
R_H_LINE_TO, -85.8,
R_ARC_TO, 4.5, 4.5, 0, 0, 0, -4.52, 4.43,
R_V_LINE_TO, 61.97,
R_H_LINE_TO, 94.83,
V_LINE_TO, 32.37,
R_ARC_TO, 4.48, 4.48, 0, 0, 0, -4.5, -4.43,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
STROKE, 0.8,
MOVE_TO, 14.72, 99.04,
R_H_LINE_TO, 131.95,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x20, 0x21, 0x24,
MOVE_TO, 214.44, 20.75,
R_ARC_TO, 4.3, 4.3, 0, 0, 0, -4.3, 4.28,
R_V_LINE_TO, 63.34,
R_ARC_TO, 4.3, 4.3, 0, 0, 0, 4.3, 4.27,
R_H_LINE_TO, 26.57,
R_ARC_TO, 4.3, 4.3, 0, 0, 0, 4.3, -4.28,
V_LINE_TO, 25.03,
R_ARC_TO, 4.3, 4.3, 0, 0, 0, -4.3, -4.28,
R_H_LINE_TO, -26.57,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
STROKE, 0.8,
MOVE_TO, 214.44, 20.75,
R_ARC_TO, 4.3, 4.3, 0, 0, 0, -4.3, 4.28,
R_V_LINE_TO, 63.34,
R_ARC_TO, 4.3, 4.3, 0, 0, 0, 4.3, 4.27,
R_H_LINE_TO, 26.57,
R_ARC_TO, 4.3, 4.3, 0, 0, 0, 4.3, -4.28,
V_LINE_TO, 25.03,
R_ARC_TO, 4.3, 4.3, 0, 0, 0, -4.3, -4.28,
R_H_LINE_TO, -26.57,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x8A, 0xB4, 0xF8,
MOVE_TO, 161.91, 62.98,
R_CUBIC_TO, 9.24, 9.23, 19.1, 13.9, 29.29, 13.87,
R_CUBIC_TO, 16.02, -0.04, 27.8, -11.74, 27.91, -11.86,
R_LINE_TO, 4.57, 4.47,
R_CUBIC_TO, -0.55, 0.56, -13.66, 13.68, -32.36, 13.76,
R_CUBIC_TO, -12, 0.05, -23.4, -5.24, -33.9, -15.74,
R_LINE_TO, 4.5, -4.5,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFD, 0xD6, 0x63,
MOVE_TO, 262.1, 8.96,
R_CUBIC_TO, -0.27, 1.02, -0.61, 1.73, -1.03, 2.15,
R_CUBIC_TO, -0.48, 0.48, -1.44, 0.94, -2.88, 1.39,
R_CUBIC_TO, 1.21, 0.31, 2.1, 0.74, 2.66, 1.31,
R_CUBIC_TO, 0.56, 0.56, 1, 1.45, 1.31, 2.66,
R_CUBIC_TO, 0.45, -1.44, 0.9, -2.4, 1.39, -2.88,
R_CUBIC_TO, 0.42, -0.42, 1.14, -0.76, 2.15, -1.03,
R_CUBIC_TO, -1.06, -0.3, -1.85, -0.71, -2.37, -1.23,
R_CUBIC_TO, -0.52, -0.52, -0.92, -1.31, -1.23, -2.37,
CLOSE,
MOVE_TO, 132.61, 17.72,
R_CUBIC_TO, -0.37, 1.62, -0.86, 2.74, -1.48, 3.35,
R_CUBIC_TO, -0.68, 0.68, -2.11, 1.33, -4.3, 1.98,
R_CUBIC_TO, 1.86, 0.42, 3.2, 1.03, 4.01, 1.84,
R_CUBIC_TO, 0.81, 0.81, 1.42, 2.15, 1.84, 4.01,
R_CUBIC_TO, 0.64, -2.19, 1.29, -3.62, 1.98, -4.3,
R_CUBIC_TO, 0.62, -0.62, 1.73, -1.1, 3.35, -1.48,
R_CUBIC_TO, -1.67, -0.41, -2.89, -0.99, -3.65, -1.75,
R_CUBIC_TO, -0.76, -0.76, -1.34, -1.97, -1.75, -3.65,
CLOSE,
MOVE_TO, 144.45, 12.85,
R_CUBIC_TO, -0.18, 0.55, -0.39, 0.95, -0.65, 1.21,
R_CUBIC_TO, -0.31, 0.32, -0.88, 0.61, -1.72, 0.89,
R_CUBIC_TO, 0.69, 0.22, 1.21, 0.5, 1.57, 0.85,
R_CUBIC_TO, 0.36, 0.36, 0.64, 0.88, 0.85, 1.57,
R_CUBIC_TO, 0.28, -0.84, 0.58, -1.41, 0.89, -1.72,
R_CUBIC_TO, 0.26, -0.26, 0.66, -0.48, 1.21, -0.65,
R_CUBIC_TO, -0.59, -0.2, -1.04, -0.46, -1.36, -0.78,
R_CUBIC_TO, -0.32, -0.32, -0.58, -0.77, -0.78, -1.36,
CLOSE,
MOVE_TO, 274.52, 4.46,
R_CUBIC_TO, -0.18, 0.55, -0.39, 0.95, -0.65, 1.21,
R_CUBIC_TO, -0.31, 0.32, -0.88, 0.61, -1.72, 0.89,
R_CUBIC_TO, 0.69, 0.22, 1.21, 0.5, 1.57, 0.85,
R_CUBIC_TO, 0.36, 0.36, 0.64, 0.88, 0.85, 1.57,
R_CUBIC_TO, 0.28, -0.84, 0.58, -1.41, 0.89, -1.72,
R_CUBIC_TO, 0.26, -0.26, 0.66, -0.48, 1.21, -0.65,
R_CUBIC_TO, -0.59, -0.2, -1.04, -0.46, -1.36, -0.78,
R_CUBIC_TO, -0.32, -0.32, -0.58, -0.77, -0.78, -1.36,
CLOSE,
MOVE_TO, 270.89, 45.28,
R_CUBIC_TO, -0.14, 0.39, -0.31, 0.68, -0.51, 0.88,
R_CUBIC_TO, -0.25, 0.25, -0.68, 0.49, -1.31, 0.71,
R_CUBIC_TO, 0.51, 0.18, 0.9, 0.4, 1.18, 0.68,
R_CUBIC_TO, 0.28, 0.28, 0.5, 0.67, 0.68, 1.18,
R_CUBIC_TO, 0.23, -0.62, 0.46, -1.06, 0.71, -1.31,
R_CUBIC_TO, 0.2, -0.2, 0.5, -0.37, 0.88, -0.51,
R_CUBIC_TO, -0.43, -0.17, -0.77, -0.37, -1.01, -0.62,
R_CUBIC_TO, -0.25, -0.25, -0.45, -0.58, -0.62, -1.01,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFD, 0xD6, 0x63,
STROKE, 0.8,
MOVE_TO, 262.1, 8.96,
R_CUBIC_TO, -0.27, 1.02, -0.61, 1.73, -1.03, 2.15,
R_CUBIC_TO, -0.48, 0.48, -1.44, 0.94, -2.88, 1.39,
R_CUBIC_TO, 1.21, 0.31, 2.1, 0.74, 2.66, 1.31,
R_CUBIC_TO, 0.56, 0.56, 1, 1.45, 1.31, 2.66,
R_CUBIC_TO, 0.45, -1.44, 0.9, -2.4, 1.39, -2.88,
R_CUBIC_TO, 0.42, -0.42, 1.14, -0.76, 2.15, -1.03,
R_CUBIC_TO, -1.06, -0.3, -1.85, -0.71, -2.37, -1.23,
R_CUBIC_TO, -0.52, -0.52, -0.92, -1.31, -1.23, -2.37,
CLOSE,
MOVE_TO, 132.61, 17.72,
R_CUBIC_TO, -0.37, 1.62, -0.86, 2.74, -1.48, 3.35,
R_CUBIC_TO, -0.68, 0.68, -2.11, 1.33, -4.3, 1.98,
R_CUBIC_TO, 1.86, 0.42, 3.2, 1.03, 4.01, 1.84,
R_CUBIC_TO, 0.81, 0.81, 1.42, 2.15, 1.84, 4.01,
R_CUBIC_TO, 0.64, -2.19, 1.29, -3.62, 1.98, -4.3,
R_CUBIC_TO, 0.62, -0.62, 1.73, -1.1, 3.35, -1.48,
R_CUBIC_TO, -1.67, -0.41, -2.89, -0.99, -3.65, -1.75,
R_CUBIC_TO, -0.76, -0.76, -1.34, -1.97, -1.75, -3.65,
CLOSE,
MOVE_TO, 144.45, 12.85,
R_CUBIC_TO, -0.18, 0.55, -0.39, 0.95, -0.65, 1.21,
R_CUBIC_TO, -0.31, 0.32, -0.88, 0.61, -1.72, 0.89,
R_CUBIC_TO, 0.69, 0.22, 1.21, 0.5, 1.57, 0.85,
R_CUBIC_TO, 0.36, 0.36, 0.64, 0.88, 0.85, 1.57,
R_CUBIC_TO, 0.28, -0.84, 0.58, -1.41, 0.89, -1.72,
R_CUBIC_TO, 0.26, -0.26, 0.66, -0.48, 1.21, -0.65,
R_CUBIC_TO, -0.59, -0.2, -1.04, -0.46, -1.36, -0.78,
R_CUBIC_TO, -0.32, -0.32, -0.58, -0.77, -0.78, -1.36,
CLOSE,
MOVE_TO, 274.52, 4.46,
R_CUBIC_TO, -0.18, 0.55, -0.39, 0.95, -0.65, 1.21,
R_CUBIC_TO, -0.31, 0.32, -0.88, 0.61, -1.72, 0.89,
R_CUBIC_TO, 0.69, 0.22, 1.21, 0.5, 1.57, 0.85,
R_CUBIC_TO, 0.36, 0.36, 0.64, 0.88, 0.85, 1.57,
R_CUBIC_TO, 0.28, -0.84, 0.58, -1.41, 0.89, -1.72,
R_CUBIC_TO, 0.26, -0.26, 0.66, -0.48, 1.21, -0.65,
R_CUBIC_TO, -0.59, -0.2, -1.04, -0.46, -1.36, -0.78,
R_CUBIC_TO, -0.32, -0.32, -0.58, -0.77, -0.78, -1.36,
CLOSE,
MOVE_TO, 270.89, 45.28,
R_CUBIC_TO, -0.14, 0.39, -0.31, 0.68, -0.51, 0.88,
R_CUBIC_TO, -0.25, 0.25, -0.68, 0.49, -1.31, 0.71,
R_CUBIC_TO, 0.51, 0.18, 0.9, 0.4, 1.18, 0.68,
R_CUBIC_TO, 0.28, 0.28, 0.5, 0.67, 0.68, 1.18,
R_CUBIC_TO, 0.23, -0.62, 0.46, -1.06, 0.71, -1.31,
R_CUBIC_TO, 0.2, -0.2, 0.5, -0.37, 0.88, -0.51,
R_CUBIC_TO, -0.43, -0.17, -0.77, -0.37, -1.01, -0.62,
R_CUBIC_TO, -0.25, -0.25, -0.45, -0.58, -0.62, -1.01,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x29, 0x2A, 0x2D,
MOVE_TO, 302.43, 39.28,
R_H_LINE_TO, -34.75,
R_ARC_TO, 8.42, 8.42, 0, 0, 1, 11.2, -7.36,
R_LINE_TO, 0.38, 0.13,
R_LINE_TO, 0.25, -0.3,
R_ARC_TO, 12.86, 12.86, 0, 0, 1, 10.03, -4.8,
R_CUBIC_TO, 6.93, 0, 12.6, 5.48, 12.9, 12.33,
CLOSE,
R_MOVE_TO, 37.32, 42.06,
H_LINE_TO, 305,
R_ARC_TO, 8.42, 8.42, 0, 0, 1, 11.2, -7.37,
R_LINE_TO, 0.37, 0.14,
R_LINE_TO, 0.25, -0.3,
ARC_TO, 12.86, 12.86, 0, 0, 1, 326.86, 69,
R_ARC_TO, 12.9, 12.9, 0, 0, 1, 12.89, 12.34,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
STROKE, 0.8,
MOVE_TO, 302.43, 39.28,
R_H_LINE_TO, -34.75,
R_ARC_TO, 8.42, 8.42, 0, 0, 1, 11.2, -7.36,
R_LINE_TO, 0.38, 0.13,
R_LINE_TO, 0.25, -0.3,
R_ARC_TO, 12.86, 12.86, 0, 0, 1, 10.03, -4.8,
R_CUBIC_TO, 6.93, 0, 12.6, 5.48, 12.9, 12.33,
CLOSE,
R_MOVE_TO, 37.32, 42.06,
H_LINE_TO, 305,
R_ARC_TO, 8.42, 8.42, 0, 0, 1, 11.2, -7.37,
R_LINE_TO, 0.37, 0.14,
R_LINE_TO, 0.25, -0.3,
ARC_TO, 12.86, 12.86, 0, 0, 1, 326.86, 69,
R_ARC_TO, 12.9, 12.9, 0, 0, 1, 12.89, 12.34,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
MOVE_TO, 89.97, 67.82,
R_V_LINE_TO, 4.15,
R_ARC_TO, 1, 1, 0, 0, 1, -1.03, 1,
R_ARC_TO, 17.92, 17.92, 0, 0, 1, -8, -2.43,
R_ARC_TO, 18.08, 18.08, 0, 0, 1, -6.5, -6.5,
ARC_TO, 17.92, 17.92, 0, 0, 1, 72, 56.03,
ARC_TO, 1, 1, 0, 0, 1, 73, 55,
R_H_LINE_TO, 4.15,
R_ARC_TO, 1, 1, 0, 0, 1, 0.98, 0.8,
R_LINE_TO, 0.65, 3.26,
R_ARC_TO, 0.99, 0.99, 0, 0, 1, -0.27, 0.9,
R_LINE_TO, -2.62, 2.62,
R_CUBIC_TO, 1.5, 2.75, 3.75, 5, 6.5, 6.5,
R_LINE_TO, 2.6, -2.62,
R_ARC_TO, 0.98, 0.98, 0, 0, 1, 0.91, -0.27,
R_LINE_TO, 3.26, 0.65,
R_CUBIC_TO, 0.47, 0.1, 0.8, 0.5, 0.8, 0.98,
CLOSE,
MOVE_TO, 83, 58,
R_H_LINE_TO, 2.6,
R_LINE_TO, -4.32, 4.31,
R_LINE_TO, 1.41, 1.41,
LINE_TO, 87, 59.41,
V_LINE_TO, 62,
R_H_LINE_TO, 2,
R_V_LINE_TO, -6,
R_H_LINE_TO, -6,
R_V_LINE_TO, 2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kClickToCallIllustrationDarkRepList, kClickToCallIllustrationDarkIcon, {kClickToCallIllustrationDarkPath})
VECTOR_ICON_REP_TEMPLATE(kCloseChromeRefreshPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 6.06, 15.16,
LINE_TO, 4.84, 13.94,
LINE_TO, 8.78, 10,
LINE_TO, 4.84, 6.06,
LINE_TO, 6.06, 4.84,
LINE_TO, 10, 8.78,
R_LINE_TO, 3.94, -3.94,
R_LINE_TO, 1.22, 1.22,
LINE_TO, 11.22, 10,
R_LINE_TO, 3.94, 3.94,
R_LINE_TO, -1.22, 1.22,
LINE_TO, 10, 11.22,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCloseChromeRefreshRepList, kCloseChromeRefreshIcon, {kCloseChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kCloseGroupRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 9.56, 11.5,
LINE_TO, 11.5, 9.56,
R_LINE_TO, 1.94, 1.94,
R_LINE_TO, 1.06, -1.06,
LINE_TO, 12.56, 8.5,
LINE_TO, 14.5, 6.56,
LINE_TO, 13.44, 5.5,
LINE_TO, 11.5, 7.44,
LINE_TO, 9.56, 5.5,
LINE_TO, 8.5, 6.56,
LINE_TO, 10.44, 8.5,
LINE_TO, 8.5, 10.44,
CLOSE,
MOVE_TO, 6.5, 15,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 5, 13.5,
R_V_LINE_TO, -10,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 6.5, 2,
R_H_LINE_TO, 10,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 10,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 16.5, 15,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_H_LINE_TO, 10,
R_V_LINE_TO, -10,
R_H_LINE_TO, -10,
CLOSE,
R_MOVE_TO, -3, 4.5,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 2, 16.5,
V_LINE_TO, 5,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 11.5,
H_LINE_TO, 15,
V_LINE_TO, 18,
CLOSE,
R_MOVE_TO, 3, -14.5,
R_V_LINE_TO, 10,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kCloseGroupRefresh16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
R_MOVE_TO, 7.74, 9.24,
R_LINE_TO, 1.55, -1.55,
R_LINE_TO, 1.55, 1.55,
R_LINE_TO, 0.98, -0.98,
R_LINE_TO, -1.55, -1.55,
R_LINE_TO, 1.55, -1.55,
R_LINE_TO, -0.98, -0.98,
R_LINE_TO, -1.55, 1.55,
R_LINE_TO, -1.55, -1.55,
R_LINE_TO, -0.98, 0.98,
R_LINE_TO, 1.55, 1.55,
R_LINE_TO, -1.55, 1.55,
CLOSE,
MOVE_TO, 5.34, 12.04,
R_CUBIC_TO, -0.38, 0, -0.71, -0.13, -0.98, -0.4,
R_ARC_TO, 1.34, 1.34, 0, 0, 1, -0.4, -0.98,
V_LINE_TO, 2.76,
R_CUBIC_TO, 0, -0.39, 0.13, -0.71, 0.4, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.41, 0.98, -0.41,
R_H_LINE_TO, 7.9,
R_CUBIC_TO, 0.39, 0, 0.71, 0.14, 0.98, 0.41,
R_CUBIC_TO, 0.27, 0.27, 0.41, 0.59, 0.41, 0.98,
R_V_LINE_TO, 7.9,
R_CUBIC_TO, 0, 0.38, -0.14, 0.71, -0.41, 0.98,
R_ARC_TO, 1.33, 1.33, 0, 0, 1, -0.98, 0.4,
CLOSE,
R_MOVE_TO, 0, -1.38,
R_H_LINE_TO, 7.9,
V_LINE_TO, 2.76,
H_LINE_TO, 5.34,
CLOSE,
MOVE_TO, 2.76, 14.63,
R_CUBIC_TO, -0.39, 0, -0.71, -0.14, -0.98, -0.41,
R_ARC_TO, 1.33, 1.33, 0, 0, 1, -0.41, -0.98,
V_LINE_TO, 3.96,
R_H_LINE_TO, 1.39,
R_V_LINE_TO, 9.29,
R_H_LINE_TO, 9.29,
R_V_LINE_TO, 1.39,
CLOSE,
MOVE_TO, 5.34, 2.76,
R_V_LINE_TO, 7.9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCloseGroupRefreshRepList, kCloseGroupRefreshIcon, {kCloseGroupRefreshPath}, {kCloseGroupRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kCloseTabChromeRefreshPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 10.94, 4,
LINE_TO, 4, 10.94,
LINE_TO, 5.06, 12,
LINE_TO, 12, 5.07,
LINE_TO, 10.94, 4,
CLOSE,
NEW_PATH,
MOVE_TO, 5.06, 4,
LINE_TO, 4, 5.06,
LINE_TO, 10.94, 12,
LINE_TO, 12, 10.93,
LINE_TO, 5.06, 4,
CLOSE,
NEW_PATH)
VECTOR_ICON_TEMPLATE_CC(kCloseTabChromeRefreshRepList, kCloseTabChromeRefreshIcon, {kCloseTabChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kComparePath, CANVAS_DIMENSIONS, 14,
FILL_RULE_NONZERO,
MOVE_TO, 1.33, 14,
CUBIC_TO, 0.97, 14, 0.65, 13.87, 0.39, 13.61,
CUBIC_TO, 0.13, 13.35, 0, 13.03, 0, 12.67,
V_LINE_TO, 3.33,
CUBIC_TO, 0, 2.97, 0.13, 2.65, 0.39, 2.39,
CUBIC_TO, 0.65, 2.13, 0.97, 2, 1.33, 2,
H_LINE_TO, 6.02,
CUBIC_TO, 5.89, 2.2, 5.78, 2.41, 5.68, 2.63,
CUBIC_TO, 5.58, 2.86, 5.51, 3.09, 5.45, 3.33,
H_LINE_TO, 1.33,
V_LINE_TO, 5.33,
H_LINE_TO, 5.45,
CUBIC_TO, 5.51, 5.58, 5.58, 5.81, 5.68, 6.03,
CUBIC_TO, 5.77, 6.26, 5.88, 6.47, 6.02, 6.67,
H_LINE_TO, 4.33,
V_LINE_TO, 12.67,
H_LINE_TO, 7.67,
V_LINE_TO, 8.18,
CUBIC_TO, 7.88, 8.29, 8.09, 8.39, 8.32, 8.46,
CUBIC_TO, 8.54, 8.53, 8.77, 8.58, 9, 8.62,
V_LINE_TO, 12.67,
H_LINE_TO, 10.67,
V_LINE_TO, 8.55,
CUBIC_TO, 10.91, 8.49, 11.14, 8.42, 11.37, 8.32,
CUBIC_TO, 11.59, 8.22, 11.8, 8.11, 12, 7.98,
V_LINE_TO, 12.67,
CUBIC_TO, 12, 13.03, 11.87, 13.35, 11.61, 13.61,
CUBIC_TO, 11.35, 13.87, 11.03, 14, 10.67, 14,
H_LINE_TO, 1.33,
CLOSE,
MOVE_TO, 1.33, 12.67,
H_LINE_TO, 3,
V_LINE_TO, 6.67,
H_LINE_TO, 1.33,
V_LINE_TO, 12.67,
CLOSE,
MOVE_TO, 1.33, 14,
H_LINE_TO, 3,
H_LINE_TO, 0,
H_LINE_TO, 1.33,
CLOSE,
MOVE_TO, 9.67, 8,
CUBIC_TO, 9.67, 6.98, 9.31, 6.11, 8.6, 5.4,
CUBIC_TO, 7.89, 4.69, 7.02, 4.33, 6, 4.33,
CUBIC_TO, 7.02, 4.33, 7.89, 3.98, 8.6, 3.27,
CUBIC_TO, 9.31, 2.56, 9.67, 1.69, 9.67, 0.67,
CUBIC_TO, 9.67, 1.69, 10.02, 2.56, 10.73, 3.27,
CUBIC_TO, 11.44, 3.98, 12.31, 4.33, 13.33, 4.33,
CUBIC_TO, 12.31, 4.33, 11.44, 4.69, 10.73, 5.4,
CUBIC_TO, 10.02, 6.11, 9.67, 6.98, 9.67, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCompareRepList, kCompareIcon, {kComparePath})
VECTOR_ICON_REP_TEMPLATE(kComputerWithCircleBackgroundPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 17.6, 16.2,
R_CUBIC_TO, 0.77, 0, 1.39, -0.63, 1.39, -1.4,
R_LINE_TO, 0.01, -7,
R_CUBIC_TO, 0, -0.77, -0.63, -1.4, -1.4, -1.4,
H_LINE_TO, 6.4,
R_CUBIC_TO, -0.77, 0, -1.4, 0.63, -1.4, 1.4,
R_V_LINE_TO, 7,
R_CUBIC_TO, 0, 0.77, 0.63, 1.4, 1.4, 1.4,
R_H_LINE_TO, 11.2,
CLOSE,
R_MOVE_TO, -11.2, -8.4,
R_H_LINE_TO, 11.2,
R_V_LINE_TO, 7,
H_LINE_TO, 6.4,
R_V_LINE_TO, -7,
CLOSE,
R_MOVE_TO, -2.1, 9.1,
R_H_LINE_TO, 15.4,
R_V_LINE_TO, 1.4,
H_LINE_TO, 4.3,
R_V_LINE_TO, -1.4,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 50, 0x9A, 0xA0, 0xA6,
ROUND_RECT, 0, 0, 24, 24, 12,)
VECTOR_ICON_TEMPLATE_CC(kComputerWithCircleBackgroundRepList, kComputerWithCircleBackgroundIcon, {kComputerWithCircleBackgroundPath})
VECTOR_ICON_REP_TEMPLATE(kCopyPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 16, 1,
H_LINE_TO, 4,
R_CUBIC_TO, -1.1, 0, -2, 0.9, -2, 2,
R_V_LINE_TO, 14,
R_H_LINE_TO, 2,
V_LINE_TO, 3,
R_H_LINE_TO, 12,
V_LINE_TO, 1,
CLOSE,
R_MOVE_TO, 3, 4,
H_LINE_TO, 8,
R_CUBIC_TO, -1.1, 0, -2, 0.9, -2, 2,
R_V_LINE_TO, 14,
R_CUBIC_TO, 0, 1.1, 0.9, 2, 2, 2,
R_H_LINE_TO, 11,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
V_LINE_TO, 7,
R_CUBIC_TO, 0, -1.1, -0.9, -2, -2, -2,
CLOSE,
R_MOVE_TO, 0, 16,
H_LINE_TO, 8,
V_LINE_TO, 7,
R_H_LINE_TO, 11,
R_V_LINE_TO, 14,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCopyRepList, kCopyIcon, {kCopyPath})
VECTOR_ICON_REP_TEMPLATE(kCopyMenuPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 6.14, 12.04,
R_CUBIC_TO, -0.38, 0, -0.71, -0.13, -0.98, -0.4,
R_ARC_TO, 1.34, 1.34, 0, 0, 1, -0.4, -0.98,
V_LINE_TO, 2.76,
R_CUBIC_TO, 0, -0.39, 0.13, -0.71, 0.4, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.41, 0.98, -0.41,
R_H_LINE_TO, 6.31,
R_CUBIC_TO, 0.38, 0, 0.71, 0.14, 0.98, 0.41,
R_CUBIC_TO, 0.27, 0.27, 0.41, 0.59, 0.41, 0.98,
R_V_LINE_TO, 7.9,
R_CUBIC_TO, 0, 0.38, -0.14, 0.71, -0.41, 0.98,
R_CUBIC_TO, -0.27, 0.27, -0.59, 0.4, -0.98, 0.4,
CLOSE,
R_MOVE_TO, 0, -1.38,
R_H_LINE_TO, 6.31,
V_LINE_TO, 2.76,
H_LINE_TO, 6.14,
CLOSE,
MOVE_TO, 3.56, 14.63,
R_ARC_TO, 1.33, 1.33, 0, 0, 1, -0.98, -0.41,
R_ARC_TO, 1.33, 1.33, 0, 0, 1, -0.41, -0.98,
V_LINE_TO, 3.96,
R_H_LINE_TO, 1.38,
R_V_LINE_TO, 9.29,
R_H_LINE_TO, 7.69,
R_V_LINE_TO, 1.39,
CLOSE,
MOVE_TO, 6.14, 10.66,
V_LINE_TO, 2.76,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCopyMenuRepList, kCopyMenuIcon, {kCopyMenuPath})
VECTOR_ICON_REP_TEMPLATE(kCrashedTabPath, STROKE, 3,
CAP_SQUARE,
MOVE_TO, 1.5, 8.5,
R_V_LINE_TO, 34,
R_H_LINE_TO, 45,
R_V_LINE_TO, -28,
R_MOVE_TO, -3, -3,
R_H_LINE_TO, -10,
R_V_LINE_TO, -3,
R_MOVE_TO, -3, -3,
R_H_LINE_TO, -10,
R_MOVE_TO, 15, 6,
R_H_LINE_TO, -18,
R_V_LINE_TO, -3,
R_MOVE_TO, -3, -3,
R_H_LINE_TO, -10,
NEW_PATH,
STROKE, 2,
CAP_SQUARE,
MOVE_TO, 12, 35,
R_H_LINE_TO, 2,
R_MOVE_TO, 2, -2,
R_H_LINE_TO, 12,
R_MOVE_TO, 2, 2,
R_H_LINE_TO, 3,
R_MOVE_TO, 2, 2,
R_H_LINE_TO, 3,
MOVE_TO, 11, 21,
R_LINE_TO, 0, 0,
R_MOVE_TO, 0, 4,
R_LINE_TO, 0, 0,
R_MOVE_TO, 4, 0,
R_LINE_TO, 0, 0,
R_MOVE_TO, 0, -4,
R_LINE_TO, 0, 0,
R_MOVE_TO, -2, 2,
R_LINE_TO, 0, 0,
MOVE_TO, 33, 21,
R_LINE_TO, 0, 0,
R_MOVE_TO, 0, 4,
R_LINE_TO, 0, 0,
R_MOVE_TO, 4, 0,
R_LINE_TO, 0, 0,
R_MOVE_TO, 0, -4,
R_LINE_TO, 0, 0,
R_MOVE_TO, -2, 2,
R_LINE_TO, 0, 0)
VECTOR_ICON_TEMPLATE_CC(kCrashedTabRepList, kCrashedTabIcon, {kCrashedTabPath})
VECTOR_ICON_REP_TEMPLATE(kCreateNewTabGroupPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 10.86, 11.89,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, -2.75,
R_H_LINE_TO, 2.75,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, -2.75,
R_V_LINE_TO, -2.75,
R_H_LINE_TO, -1.5,
R_V_LINE_TO, 2.75,
R_H_LINE_TO, -2.75,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, 2.75,
CLOSE,
R_MOVE_TO, -4.19, 3.17,
R_CUBIC_TO, -0.48, 0, -0.89, -0.17, -1.23, -0.5,
R_ARC_TO, 1.68, 1.68, 0, 0, 1, -0.5, -1.23,
V_LINE_TO, 3.45,
R_CUBIC_TO, 0, -0.48, 0.17, -0.89, 0.5, -1.22,
R_CUBIC_TO, 0.34, -0.34, 0.75, -0.51, 1.23, -0.51,
R_H_LINE_TO, 9.88,
R_CUBIC_TO, 0.48, 0, 0.89, 0.17, 1.22, 0.51,
R_CUBIC_TO, 0.34, 0.34, 0.51, 0.74, 0.51, 1.22,
R_V_LINE_TO, 9.88,
R_CUBIC_TO, 0, 0.48, -0.17, 0.89, -0.51, 1.23,
R_ARC_TO, 1.66, 1.66, 0, 0, 1, -1.22, 0.5,
CLOSE,
R_MOVE_TO, 0, -1.73,
R_H_LINE_TO, 9.88,
R_V_LINE_TO, -9.88,
R_H_LINE_TO, -9.88,
CLOSE,
R_MOVE_TO, -3.23, 4.96,
R_CUBIC_TO, -0.48, 0, -0.89, -0.17, -1.22, -0.51,
R_ARC_TO, 1.65, 1.65, 0, 0, 1, -0.51, -1.22,
V_LINE_TO, 4.95,
R_H_LINE_TO, 1.73,
R_V_LINE_TO, 11.61,
R_H_LINE_TO, 11.61,
R_V_LINE_TO, 1.73,
CLOSE,
R_MOVE_TO, 3.23, -14.84,
R_V_LINE_TO, 9.88,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCreateNewTabGroupRepList, kCreateNewTabGroupIcon, {kCreateNewTabGroupPath})
VECTOR_ICON_REP_TEMPLATE(kCreditCardPath, CANVAS_DIMENSIONS, 32,
MOVE_TO, 27, 5,
H_LINE_TO, 5,
CUBIC_TO, 3.25, 5, 2.01, 6.22, 2, 8,
R_V_LINE_TO, 16,
R_CUBIC_TO, 0, 1.78, 1.25, 3, 3, 3,
R_H_LINE_TO, 22,
R_CUBIC_TO, 1.75, 0, 3, -1.22, 3, -3,
V_LINE_TO, 8,
R_CUBIC_TO, 0, -1.78, -1.25, -3, -3, -3,
CLOSE,
R_MOVE_TO, 0, 19,
H_LINE_TO, 5,
R_V_LINE_TO, -8,
R_H_LINE_TO, 22,
R_V_LINE_TO, 8,
CLOSE,
R_MOVE_TO, 0, -13,
H_LINE_TO, 5,
V_LINE_TO, 8,
R_H_LINE_TO, 22,
R_V_LINE_TO, 3,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kCreditCard16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 13.6, 2,
LINE_TO, 2.4, 2,
CUBIC_TO, 1.63, 2, 1.01, 2.62, 1.01, 3.38,
LINE_TO, 1, 12.12,
CUBIC_TO, 1, 12.88, 1.63, 13.5, 2.4, 13.5,
LINE_TO, 13.6, 13.5,
CUBIC_TO, 14.37, 13.5, 15, 12.88, 15, 12.12,
LINE_TO, 15, 3.38,
CUBIC_TO, 15, 2.62, 14.37, 2, 13.6, 2,
CLOSE,
MOVE_TO, 13.5, 12,
LINE_TO, 2.5, 12,
LINE_TO, 2.5, 7.5,
LINE_TO, 13.5, 7.5,
LINE_TO, 13.5, 12,
CLOSE,
MOVE_TO, 13.5, 5,
LINE_TO, 2.5, 5,
LINE_TO, 2.5, 3.5,
LINE_TO, 13.5, 3.5,
LINE_TO, 13.5, 5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCreditCardRepList, kCreditCardIcon, {kCreditCardPath}, {kCreditCard16Path})
VECTOR_ICON_REP_TEMPLATE(kCreditCardChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 18, 5.5,
R_V_LINE_TO, 9,
R_CUBIC_TO, 0, 0.4, -0.15, 0.75, -0.44, 1.05,
R_CUBIC_TO, -0.29, 0.3, -0.64, 0.45, -1.06, 0.45,
R_H_LINE_TO, -13,
R_CUBIC_TO, -0.4, 0, -0.75, -0.15, -1.05, -0.45,
R_CUBIC_TO, -0.3, -0.3, -0.45, -0.65, -0.45, -1.05,
R_V_LINE_TO, -9,
R_CUBIC_TO, 0, -0.4, 0.15, -0.75, 0.45, -1.05,
R_CUBIC_TO, 0.3, -0.3, 0.65, -0.45, 1.05, -0.45,
R_H_LINE_TO, 13,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.45,
R_CUBIC_TO, 0.29, 0.3, 0.44, 0.65, 0.44, 1.05,
CLOSE,
MOVE_TO, 3.5, 7,
R_H_LINE_TO, 13,
V_LINE_TO, 5.5,
R_H_LINE_TO, -13,
CLOSE,
R_MOVE_TO, 0, 3,
R_V_LINE_TO, 4.5,
R_H_LINE_TO, 13,
V_LINE_TO, 10,
CLOSE,
R_MOVE_TO, 0, 4.5,
R_V_LINE_TO, -9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCreditCardChromeRefreshRepList, kCreditCardChromeRefreshIcon, {kCreditCardChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kCutMenuPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 12.36, 13.66,
LINE_TO, 7.98, 9.3,
LINE_TO, 6.58, 10.72,
R_CUBIC_TO, 0.08, 0.18, 0.14, 0.35, 0.18, 0.54,
R_CUBIC_TO, 0.04, 0.18, 0.06, 0.36, 0.06, 0.54,
R_CUBIC_TO, 0, 0.74, -0.25, 1.36, -0.76, 1.87,
R_CUBIC_TO, -0.51, 0.51, -1.13, 0.77, -1.87, 0.77,
R_ARC_TO, 2.54, 2.54, 0, 0, 1, -1.86, -0.77,
R_ARC_TO, 2.53, 2.53, 0, 0, 1, -0.77, -1.86,
R_CUBIC_TO, 0, -0.73, 0.26, -1.36, 0.77, -1.87,
R_CUBIC_TO, 0.51, -0.51, 1.13, -0.77, 1.87, -0.77,
R_CUBIC_TO, 0.18, 0, 0.36, 0.02, 0.54, 0.07,
R_CUBIC_TO, 0.18, 0.04, 0.36, 0.11, 0.54, 0.18,
R_LINE_TO, 1.42, -1.4,
R_LINE_TO, -1.42, -1.42,
R_CUBIC_TO, -0.18, 0.08, -0.36, 0.14, -0.54, 0.18,
R_CUBIC_TO, -0.18, 0.04, -0.36, 0.05, -0.54, 0.05,
R_CUBIC_TO, -0.74, 0, -1.36, -0.25, -1.87, -0.77,
ARC_TO, 2.55, 2.55, 0, 0, 1, 1.55, 4.2,
R_CUBIC_TO, 0, -0.73, 0.26, -1.35, 0.77, -1.86,
R_ARC_TO, 2.53, 2.53, 0, 0, 1, 1.86, -0.77,
R_CUBIC_TO, 0.73, 0, 1.36, 0.26, 1.87, 0.77,
R_ARC_TO, 2.55, 2.55, 0, 0, 1, 0.77, 1.87,
R_CUBIC_TO, 0, 0.18, -0.02, 0.36, -0.06, 0.54,
R_ARC_TO, 2.26, 2.26, 0, 0, 1, -0.18, 0.53,
R_LINE_TO, 7.86, 7.83,
R_V_LINE_TO, 0.55,
CLOSE,
MOVE_TO, 9.99, 7.33,
R_LINE_TO, -1.32, -1.32,
R_LINE_TO, 3.69, -3.68,
R_H_LINE_TO, 2.09,
R_V_LINE_TO, 0.55,
CLOSE,
R_MOVE_TO, -5.8, -1.77,
R_CUBIC_TO, 0.38, 0, 0.7, -0.13, 0.97, -0.4,
R_CUBIC_TO, 0.27, -0.27, 0.4, -0.59, 0.4, -0.97,
R_ARC_TO, 1.3, 1.3, 0, 0, 0, -0.4, -0.96,
R_ARC_TO, 1.34, 1.34, 0, 0, 0, -0.97, -0.4,
R_ARC_TO, 1.3, 1.3, 0, 0, 0, -0.96, 0.4,
R_CUBIC_TO, -0.27, 0.27, -0.4, 0.59, -0.4, 0.97,
R_CUBIC_TO, 0, 0.38, 0.13, 0.7, 0.4, 0.96,
R_CUBIC_TO, 0.27, 0.26, 0.59, 0.4, 0.97, 0.4,
CLOSE,
R_MOVE_TO, 3.8, 2.93,
R_CUBIC_TO, 0.13, 0, 0.25, -0.05, 0.34, -0.14,
R_ARC_TO, 0.48, 0.48, 0, 0, 0, 0, -0.7,
R_ARC_TO, 0.48, 0.48, 0, 0, 0, -0.34, -0.14,
R_ARC_TO, 0.49, 0.49, 0, 0, 0, -0.35, 0.84,
R_ARC_TO, 0.49, 0.49, 0, 0, 0, 0.35, 0.14,
CLOSE,
R_MOVE_TO, -3.8, 4.68,
R_CUBIC_TO, 0.38, 0, 0.7, -0.13, 0.97, -0.4,
R_CUBIC_TO, 0.27, -0.27, 0.4, -0.59, 0.4, -0.97,
R_ARC_TO, 1.3, 1.3, 0, 0, 0, -0.4, -0.96,
R_ARC_TO, 1.34, 1.34, 0, 0, 0, -0.97, -0.4,
R_ARC_TO, 1.3, 1.3, 0, 0, 0, -0.96, 0.4,
R_CUBIC_TO, -0.27, 0.27, -0.4, 0.59, -0.4, 0.97,
R_CUBIC_TO, 0, 0.38, 0.13, 0.7, 0.4, 0.97,
R_CUBIC_TO, 0.27, 0.27, 0.59, 0.4, 0.97, 0.4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCutMenuRepList, kCutMenuIcon, {kCutMenuPath})
VECTOR_ICON_REP_TEMPLATE(kDefaultTouchFaviconPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 0, 0,
LINE_TO, 16, 0,
LINE_TO, 16, 16,
LINE_TO, 0, 16,
CLOSE,
MOVE_TO, 5, 5,
LINE_TO, 8, 5,
LINE_TO, 11, 8,
LINE_TO, 11, 15,
LINE_TO, 5, 15,
CLOSE,
MOVE_TO, 10, 9,
LINE_TO, 7, 6,
LINE_TO, 7, 9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDefaultTouchFaviconRepList, kDefaultTouchFaviconIcon, {kDefaultTouchFaviconPath})
VECTOR_ICON_REP_TEMPLATE(kDefaultTouchFaviconMaskPath, CANVAS_DIMENSIONS, 16,
CIRCLE, 8, 8, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDefaultTouchFaviconMaskRepList, kDefaultTouchFaviconMaskIcon, {kDefaultTouchFaviconMaskPath})
VECTOR_ICON_REP_TEMPLATE(kDesktopWindowsChromeRefreshPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 5.54, 13.72,
R_V_LINE_TO, -1.38,
R_H_LINE_TO, 1.2,
R_V_LINE_TO, -1.2,
R_H_LINE_TO, -3.89,
R_CUBIC_TO, -0.38, 0, -0.71, -0.14, -0.98, -0.41,
R_ARC_TO, 1.33, 1.33, 0, 0, 1, -0.4, -0.98,
V_LINE_TO, 3.64,
R_CUBIC_TO, 0, -0.38, 0.13, -0.71, 0.4, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.41, 0.98, -0.41,
R_H_LINE_TO, 10.31,
R_CUBIC_TO, 0.38, 0, 0.71, 0.14, 0.98, 0.41,
R_CUBIC_TO, 0.27, 0.27, 0.4, 0.6, 0.4, 0.98,
R_V_LINE_TO, 6.12,
R_CUBIC_TO, 0, 0.38, -0.13, 0.71, -0.4, 0.98,
R_CUBIC_TO, -0.27, 0.27, -0.6, 0.41, -0.98, 0.41,
H_LINE_TO, 9.26,
R_V_LINE_TO, 1.2,
R_H_LINE_TO, 1.2,
R_V_LINE_TO, 1.38,
CLOSE,
MOVE_TO, 2.85, 9.75,
R_H_LINE_TO, 10.3,
V_LINE_TO, 3.64,
H_LINE_TO, 2.85,
CLOSE,
R_MOVE_TO, 0, 0,
V_LINE_TO, 3.64,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDesktopWindowsChromeRefreshRepList, kDesktopWindowsChromeRefreshIcon, {kDesktopWindowsChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kDeveloperToolsPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 5.54, 12.13,
LINE_TO, 1.41, 8,
R_LINE_TO, 4.13, -4.13,
R_LINE_TO, 0.98, 0.98,
R_LINE_TO, -3.15, 3.15,
R_LINE_TO, 3.15, 3.15,
CLOSE,
R_MOVE_TO, 4.92, 0,
R_LINE_TO, -0.98, -0.98,
R_LINE_TO, 3.15, -3.15,
R_LINE_TO, -3.15, -3.15,
R_LINE_TO, 0.98, -0.98,
LINE_TO, 14.59, 8,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDeveloperToolsRepList, kDeveloperToolsIcon, {kDeveloperToolsPath})
VECTOR_ICON_REP_TEMPLATE(kDevicesPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 2.5, 4.21,
R_H_LINE_TO, 11.25,
V_LINE_TO, 3,
H_LINE_TO, 2.5,
R_CUBIC_TO, -0.69, 0, -1.25, 0.54, -1.25, 1.21,
R_V_LINE_TO, 6.63,
H_LINE_TO, 0,
R_V_LINE_TO, 1.81,
R_H_LINE_TO, 8.75,
R_V_LINE_TO, -1.81,
H_LINE_TO, 2.5,
R_V_LINE_TO, -6.63,
CLOSE,
R_MOVE_TO, 11.88, 1.21,
R_H_LINE_TO, -3.75,
R_ARC_TO, 0.62, 0.62, 0, 0, 0, -0.62, 0.6,
R_V_LINE_TO, 6.03,
R_CUBIC_TO, 0, 0.33, 0.28, 0.6, 0.63, 0.6,
R_H_LINE_TO, 3.75,
ARC_TO, 0.62, 0.62, 0, 0, 0, 15, 12.04,
V_LINE_TO, 6.01,
R_ARC_TO, 0.62, 0.62, 0, 0, 0, -0.62, -0.6,
CLOSE,
R_MOVE_TO, -0.62, 5.42,
R_H_LINE_TO, -2.5,
V_LINE_TO, 6.62,
R_H_LINE_TO, 2.5,
R_V_LINE_TO, 4.22,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDevicesRepList, kDevicesIcon, {kDevicesPath})
VECTOR_ICON_REP_TEMPLATE(kDevicesChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 2, 16,
R_V_LINE_TO, -2,
R_H_LINE_TO, 2,
V_LINE_TO, 5.5,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 5.5, 4,
H_LINE_TO, 17,
R_V_LINE_TO, 1.5,
H_LINE_TO, 5.5,
V_LINE_TO, 14,
H_LINE_TO, 10,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 10.76, 0,
R_ARC_TO, 0.73, 0.73, 0, 0, 1, -0.54, -0.21,
R_ARC_TO, 0.73, 0.73, 0, 0, 1, -0.22, -0.53,
V_LINE_TO, 7.76,
R_ARC_TO, 0.73, 0.73, 0, 0, 1, 0.22, -0.54,
ARC_TO, 0.73, 0.73, 0, 0, 1, 12.75, 7,
R_H_LINE_TO, 4.49,
R_ARC_TO, 0.73, 0.73, 0, 0, 1, 0.54, 0.22,
R_ARC_TO, 0.73, 0.73, 0, 0, 1, 0.22, 0.54,
R_V_LINE_TO, 7.49,
R_ARC_TO, 0.73, 0.73, 0, 0, 1, -0.21, 0.54,
R_ARC_TO, 0.73, 0.73, 0, 0, 1, -0.53, 0.22,
CLOSE,
R_MOVE_TO, 0.74, -2,
R_H_LINE_TO, 3,
V_LINE_TO, 8.5,
R_H_LINE_TO, -3,
CLOSE,
R_MOVE_TO, 0, 0,
R_H_LINE_TO, 3,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kDevicesChromeRefresh16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 1.47, 12.93,
R_V_LINE_TO, -1.78,
R_H_LINE_TO, 1.6,
V_LINE_TO, 4.45,
R_CUBIC_TO, 0, -0.38, 0.13, -0.71, 0.4, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.4, 0.98, -0.4,
R_H_LINE_TO, 9.29,
V_LINE_TO, 4.45,
H_LINE_TO, 4.45,
R_V_LINE_TO, 6.7,
R_H_LINE_TO, 3.5,
R_V_LINE_TO, 1.78,
CLOSE,
R_MOVE_TO, 8.79, 0,
R_ARC_TO, 0.68, 0.68, 0, 0, 1, -0.7, -0.69,
V_LINE_TO, 6.34,
R_CUBIC_TO, 0, -0.19, 0.07, -0.36, 0.2, -0.49,
R_ARC_TO, 0.66, 0.66, 0, 0, 1, 0.49, -0.2,
R_H_LINE_TO, 3.6,
R_CUBIC_TO, 0.19, 0, 0.36, 0.07, 0.49, 0.2,
R_ARC_TO, 0.66, 0.66, 0, 0, 1, 0.2, 0.49,
R_V_LINE_TO, 5.9,
R_ARC_TO, 0.68, 0.68, 0, 0, 1, -0.69, 0.7,
CLOSE,
R_MOVE_TO, 0.61, -1.78,
R_H_LINE_TO, 2.38,
V_LINE_TO, 6.95,
R_H_LINE_TO, -2.37,
CLOSE,
R_MOVE_TO, 0, 0,
R_H_LINE_TO, 2.38,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDevicesChromeRefreshRepList, kDevicesChromeRefreshIcon, {kDevicesChromeRefreshPath}, {kDevicesChromeRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kDownloadInProgressChromeRefreshPath, CANVAS_DIMENSIONS, 20,
R_MOVE_TO, 10, 15,
R_LINE_TO, -5, -5,
R_LINE_TO, 1.4, -1.45,
R_LINE_TO, 2.6, 2.6,
V_LINE_TO, 5,
R_H_LINE_TO, 2,
R_V_LINE_TO, 6.15,
R_LINE_TO, 2.6, -2.6,
LINE_TO, 15, 10,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDownloadInProgressChromeRefreshRepList, kDownloadInProgressChromeRefreshIcon, {kDownloadInProgressChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kDownloadInProgressTouchPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 16.67, 10.99,
LINE_TO, 18.5, 12.75,
LINE_TO, 12, 19,
LINE_TO, 5.5, 12.75,
LINE_TO, 7.33, 10.99,
LINE_TO, 10.82, 14.38,
V_LINE_TO, 5,
H_LINE_TO, 13.18,
V_LINE_TO, 14.38,
LINE_TO, 16.67, 10.99,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDownloadInProgressTouchRepList, kDownloadInProgressTouchIcon, {kDownloadInProgressTouchPath})
VECTOR_ICON_REP_TEMPLATE(kDownloadMenuPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 8, 10.35,
LINE_TO, 4.61, 6.96,
R_LINE_TO, 0.98, -0.97,
R_LINE_TO, 1.72, 1.72,
V_LINE_TO, 2.27,
H_LINE_TO, 8.69,
V_LINE_TO, 7.71,
R_LINE_TO, 1.72, -1.72,
R_LINE_TO, 0.98, 0.97,
CLOSE,
R_MOVE_TO, -3.56, 2.58,
R_CUBIC_TO, -0.38, 0, -0.71, -0.13, -0.98, -0.4,
R_ARC_TO, 1.35, 1.35, 0, 0, 1, -0.4, -0.98,
R_V_LINE_TO, -1.2,
H_LINE_TO, 4.45,
R_V_LINE_TO, 1.2,
R_H_LINE_TO, 7.1,
R_V_LINE_TO, -1.2,
R_H_LINE_TO, 1.38,
R_V_LINE_TO, 1.2,
R_CUBIC_TO, 0, 0.38, -0.13, 0.71, -0.4, 0.98,
R_CUBIC_TO, -0.27, 0.27, -0.6, 0.4, -0.98, 0.4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDownloadMenuRepList, kDownloadMenuIcon, {kDownloadMenuPath})
VECTOR_ICON_REP_TEMPLATE(kDownloadToolbarButtonPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 14, 11,
V_LINE_TO, 14,
H_LINE_TO, 2,
V_LINE_TO, 11,
H_LINE_TO, 0,
V_LINE_TO, 14,
CUBIC_TO, 0, 15.1, 0.9, 16, 2, 16,
H_LINE_TO, 14,
CUBIC_TO, 15.1, 16, 16, 15.1, 16, 14,
V_LINE_TO, 11,
H_LINE_TO, 14,
CLOSE,
MOVE_TO, 13, 7,
LINE_TO, 11.59, 5.59,
LINE_TO, 9, 8.17,
V_LINE_TO, 0,
H_LINE_TO, 7,
V_LINE_TO, 8.17,
LINE_TO, 4.41, 5.59,
LINE_TO, 3, 7,
LINE_TO, 8, 12,
LINE_TO, 13, 7,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDownloadToolbarButtonRepList, kDownloadToolbarButtonIcon, {kDownloadToolbarButtonPath})
VECTOR_ICON_REP_TEMPLATE(kDownloadToolbarButtonChromeRefreshPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 4, 18,
R_ARC_TO, 1.99, 1.99, 0, 0, 1, -1.42, -0.57,
ARC_TO, 1.99, 1.99, 0, 0, 1, 2, 16,
R_V_LINE_TO, -3,
R_H_LINE_TO, 2,
R_V_LINE_TO, 3,
R_H_LINE_TO, 12,
R_V_LINE_TO, -3,
R_H_LINE_TO, 2,
R_V_LINE_TO, 3,
R_CUBIC_TO, 0, 0.55, -0.2, 1.02, -0.6, 1.43,
R_CUBIC_TO, -0.38, 0.38, -0.85, 0.57, -1.4, 0.57,
CLOSE,
R_MOVE_TO, 6, -4,
LINE_TO, 5, 9,
R_LINE_TO, 1.4, -1.45,
R_LINE_TO, 2.6, 2.6,
V_LINE_TO, 2,
R_H_LINE_TO, 2,
R_V_LINE_TO, 8.15,
R_LINE_TO, 2.6, -2.6,
LINE_TO, 15, 9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDownloadToolbarButtonChromeRefreshRepList, kDownloadToolbarButtonChromeRefreshIcon, {kDownloadToolbarButtonChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kDownloadToolbarButtonTouchPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 18.88, 18,
V_LINE_TO, 14,
H_LINE_TO, 21,
V_LINE_TO, 18,
CUBIC_TO, 21, 19.21, 20.04, 20.25, 18.88, 20.25,
H_LINE_TO, 5.13,
CUBIC_TO, 3.96, 20.25, 3, 19.21, 3, 18,
V_LINE_TO, 14,
H_LINE_TO, 5.13,
V_LINE_TO, 18,
H_LINE_TO, 18.88,
CLOSE,
NEW_PATH,
MOVE_TO, 15.95, 9.06,
LINE_TO, 17.5, 10.58,
LINE_TO, 12, 16,
LINE_TO, 6.5, 10.58,
LINE_TO, 8.05, 9.06,
LINE_TO, 11, 12,
V_LINE_TO, 3,
H_LINE_TO, 13,
V_LINE_TO, 12,
LINE_TO, 15.95, 9.06,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDownloadToolbarButtonTouchRepList, kDownloadToolbarButtonTouchIcon, {kDownloadToolbarButtonTouchPath})
VECTOR_ICON_REP_TEMPLATE(kDownloadWarningPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 1, 17,
LINE_TO, 10, 2,
LINE_TO, 19, 17,
CLOSE,
MOVE_TO, 10, 14.5,
CUBIC_TO, 10.21, 14.5, 10.39, 14.43, 10.53, 14.29,
CUBIC_TO, 10.68, 14.14, 10.75, 13.96, 10.75, 13.75,
CUBIC_TO, 10.75, 13.54, 10.68, 13.36, 10.54, 13.22,
CUBIC_TO, 10.39, 13.07, 10.21, 13, 10, 13,
CUBIC_TO, 9.79, 13, 9.61, 13.07, 9.47, 13.21,
CUBIC_TO, 9.32, 13.36, 9.25, 13.54, 9.25, 13.75,
CUBIC_TO, 9.25, 13.96, 9.32, 14.14, 9.46, 14.28,
CUBIC_TO, 9.61, 14.43, 9.79, 14.5, 10, 14.5,
CLOSE,
MOVE_TO, 9.25, 12,
LINE_TO, 10.75, 12,
LINE_TO, 10.75, 8,
LINE_TO, 9.25, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDownloadWarningRepList, kDownloadWarningIcon, {kDownloadWarningPath})
VECTOR_ICON_REP_TEMPLATE(kDragHandlePath, CANVAS_DIMENSIONS, 17,
MOVE_TO, 6, 0,
LINE_TO, 8, 0,
V_LINE_TO, 16,
H_LINE_TO, 6,
V_LINE_TO, 0,
CLOSE,
NEW_PATH,
MOVE_TO, 10, 0,
LINE_TO, 12, 0,
V_LINE_TO, 16,
H_LINE_TO, 10,
V_LINE_TO, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDragHandleRepList, kDragHandleIcon, {kDragHandlePath})
VECTOR_ICON_REP_TEMPLATE(kDriveShortcutChromeRefreshPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 10.49, 14.54,
R_CUBIC_TO, -1.49, -0.41, -2.7, -1.22, -3.64, -2.43,
R_ARC_TO, 6.55, 6.55, 0, 0, 1, -1.4, -4.11,
R_CUBIC_TO, 0, -0.99, 0.21, -1.93, 0.63, -2.83,
R_ARC_TO, 6.6, 6.6, 0, 0, 1, 1.78, -2.31,
H_LINE_TO, 5.51,
V_LINE_TO, 1.47,
R_H_LINE_TO, 4.98,
R_V_LINE_TO, 4.98,
H_LINE_TO, 9.11,
V_LINE_TO, 3.63,
R_ARC_TO, 5.56, 5.56, 0, 0, 0, -1.66, 1.91,
R_ARC_TO, 5.12, 5.12, 0, 0, 0, -0.61, 2.44,
R_CUBIC_TO, 0, 1.16, 0.34, 2.2, 1.01, 3.13,
R_ARC_TO, 5.37, 5.37, 0, 0, 0, 2.65, 1.96,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDriveShortcutChromeRefreshRepList, kDriveShortcutChromeRefreshIcon, {kDriveShortcutChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kEditChromeRefreshPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 5, 19,
R_H_LINE_TO, 1.43,
R_LINE_TO, 9.77, -9.77,
LINE_TO, 14.77, 7.8,
LINE_TO, 5, 17.57,
CLOSE,
R_MOVE_TO, -2, 2,
R_V_LINE_TO, -4.25,
LINE_TO, 16.2, 3.57,
R_CUBIC_TO, 0.2, -0.18, 0.42, -0.32, 0.66, -0.43,
ARC_TO, 2.02, 2.02, 0, 0, 1, 17.63, 3,
R_CUBIC_TO, 0.27, 0, 0.52, 0.05, 0.77, 0.15,
R_CUBIC_TO, 0.25, 0.1, 0.47, 0.25, 0.65, 0.45,
LINE_TO, 20.43, 5,
R_CUBIC_TO, 0.2, 0.18, 0.34, 0.4, 0.44, 0.65,
R_ARC_TO, 2.18, 2.18, 0, 0, 1, 0, 1.52,
R_CUBIC_TO, -0.09, 0.24, -0.24, 0.46, -0.44, 0.66,
LINE_TO, 7.25, 21,
CLOSE,
MOVE_TO, 19, 6.4,
LINE_TO, 17.6, 5,
CLOSE,
R_MOVE_TO, -3.52, 2.13,
R_LINE_TO, -0.7, -0.72,
LINE_TO, 16.2, 9.23,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kEditChromeRefreshRepList, kEditChromeRefreshIcon, {kEditChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kExitMenuPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 3.65, 13.73,
R_CUBIC_TO, -0.38, 0, -0.71, -0.13, -0.98, -0.4,
R_ARC_TO, 1.34, 1.34, 0, 0, 1, -0.4, -0.98,
R_V_LINE_TO, -2.66,
R_H_LINE_TO, 1.38,
R_V_LINE_TO, 2.66,
R_H_LINE_TO, 8.7,
V_LINE_TO, 3.65,
H_LINE_TO, 3.65,
R_V_LINE_TO, 2.66,
H_LINE_TO, 2.27,
R_V_LINE_TO, -2.66,
R_CUBIC_TO, 0, -0.38, 0.13, -0.71, 0.4, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.4, 0.98, -0.4,
R_H_LINE_TO, 8.7,
R_CUBIC_TO, 0.38, 0, 0.71, 0.13, 0.98, 0.4,
R_CUBIC_TO, 0.27, 0.27, 0.4, 0.6, 0.4, 0.98,
R_V_LINE_TO, 8.7,
R_CUBIC_TO, 0, 0.38, -0.13, 0.71, -0.4, 0.98,
R_CUBIC_TO, -0.27, 0.27, -0.6, 0.4, -0.98, 0.4,
CLOSE,
R_MOVE_TO, 3.63, -2.37,
R_LINE_TO, -0.98, -0.97,
LINE_TO, 7.99, 8.69,
H_LINE_TO, 2.27,
V_LINE_TO, 7.31,
R_H_LINE_TO, 5.72,
LINE_TO, 6.29, 5.61,
R_LINE_TO, 0.98, -0.97,
LINE_TO, 10.63, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kExitMenuRepList, kExitMenuIcon, {kExitMenuPath})
VECTOR_ICON_REP_TEMPLATE(kExtensionCrashedPath, MOVE_TO, 37, 23,
LINE_TO, 40, 23,
CUBIC_TO, 42.76, 23, 45, 25.24, 45, 28,
CUBIC_TO, 45, 30.76, 42.76, 33, 40, 33,
LINE_TO, 37, 33,
LINE_TO, 37, 41,
CUBIC_TO, 37, 43.2, 35.2, 45, 33, 45,
LINE_TO, 25.4, 45,
LINE_TO, 25.4, 42,
CUBIC_TO, 25.4, 39.02, 22.98, 36.6, 20, 36.6,
CUBIC_TO, 17.02, 36.6, 14.6, 39.02, 14.6, 42,
LINE_TO, 14.6, 45,
LINE_TO, 7, 45,
CUBIC_TO, 4.8, 45, 3, 43.2, 3, 41,
LINE_TO, 3, 33.4,
LINE_TO, 6, 33.4,
CUBIC_TO, 8.98, 33.4, 11.4, 30.98, 11.4, 28,
CUBIC_TO, 11.4, 25.02, 8.98, 22.6, 6, 22.6,
LINE_TO, 3.02, 22.6,
LINE_TO, 3.02, 15,
CUBIC_TO, 3.02, 12.8, 4.8, 11, 7, 11,
LINE_TO, 15, 11,
LINE_TO, 15, 8,
CUBIC_TO, 15, 5.24, 17.24, 3, 20, 3,
CUBIC_TO, 22.76, 3, 25, 5.24, 25, 8,
LINE_TO, 25, 11,
LINE_TO, 29.5, 11,
LINE_TO, 16, 31.5,
LINE_TO, 37, 17.5,
LINE_TO, 37, 23,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kExtensionCrashedRepList, kExtensionCrashedIcon, {kExtensionCrashedPath})
VECTOR_ICON_REP_TEMPLATE(kFileDownloadShelfPath, CANVAS_DIMENSIONS, 72,
PATH_COLOR_ARGB, 0xE6, 0xFF, 0xFF, 0xFF,
CIRCLE, 36, 36, 36,
NEW_PATH,
MOVE_TO, 32, 22,
R_H_LINE_TO, 8,
R_V_LINE_TO, 10,
R_H_LINE_TO, 6,
R_LINE_TO, -10, 10,
R_LINE_TO, -10, -10,
R_H_LINE_TO, 6,
R_V_LINE_TO, -10,
CLOSE,
MOVE_TO, 20, 56,
R_H_LINE_TO, 32,
R_V_LINE_TO, 4,
R_H_LINE_TO, -32,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFileDownloadShelfRepList, kFileDownloadShelfIcon, {kFileDownloadShelfPath})
VECTOR_ICON_REP_TEMPLATE(kFileSavePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 11, 17,
H_LINE_TO, 6,
V_LINE_TO, 4,
R_H_LINE_TO, 5,
R_V_LINE_TO, 4,
R_H_LINE_TO, 4,
R_V_LINE_TO, 2,
R_H_LINE_TO, 2,
V_LINE_TO, 7,
R_LINE_TO, -5, -5,
H_LINE_TO, 6,
R_CUBIC_TO, -1.1, 0, -2, 0.9, -2, 2,
R_V_LINE_TO, 13,
R_CUBIC_TO, 0, 1.1, 0.9, 2, 2, 2,
R_H_LINE_TO, 5,
R_V_LINE_TO, -2,
CLOSE,
R_MOVE_TO, 9, 5,
R_H_LINE_TO, -8,
R_V_LINE_TO, -2,
R_H_LINE_TO, 8,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, -7,
R_LINE_TO, -4, 4,
R_LINE_TO, -4, -4,
R_H_LINE_TO, 3,
R_V_LINE_TO, -3,
R_H_LINE_TO, 2,
R_V_LINE_TO, 3,
R_H_LINE_TO, 3,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFileSaveRepList, kFileSaveIcon, {kFileSavePath})
VECTOR_ICON_REP_TEMPLATE(kFileSaveChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 15.25, 17.5,
R_LINE_TO, 3, -3,
R_LINE_TO, -1.06, -1.06,
LINE_TO, 16, 14.63,
V_LINE_TO, 11.5,
R_H_LINE_TO, -1.5,
R_V_LINE_TO, 3.13,
R_LINE_TO, -1.19, -1.19,
LINE_TO, 12.25, 14.5,
CLOSE,
R_MOVE_TO, -3, 2.5,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 6,
V_LINE_TO, 20,
CLOSE,
MOVE_TO, 5.5, 17,
R_CUBIC_TO, -0.4, 0, -0.75, -0.15, -1.05, -0.45,
R_CUBIC_TO, -0.3, -0.3, -0.45, -0.65, -0.45, -1.05,
R_V_LINE_TO, -12,
R_CUBIC_TO, 0, -0.4, 0.15, -0.75, 0.45, -1.05,
R_CUBIC_TO, 0.3, -0.3, 0.65, -0.45, 1.05, -0.45,
H_LINE_TO, 12,
R_LINE_TO, 4, 4,
R_V_LINE_TO, 4,
R_H_LINE_TO, -1.5,
V_LINE_TO, 7,
H_LINE_TO, 11,
V_LINE_TO, 3.5,
H_LINE_TO, 5.5,
R_V_LINE_TO, 12,
H_LINE_TO, 11,
V_LINE_TO, 17,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_V_LINE_TO, -12,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kFileSaveChromeRefresh16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
R_MOVE_TO, 12.2, 14,
R_LINE_TO, 2.41, -2.41,
R_LINE_TO, -0.85, -0.85,
R_LINE_TO, -0.96, 0.96,
V_LINE_TO, 9.2,
R_H_LINE_TO, -1.2,
R_V_LINE_TO, 2.5,
R_LINE_TO, -0.96, -0.96,
R_LINE_TO, -0.85, 0.85,
CLOSE,
R_MOVE_TO, -2.4, 2,
R_V_LINE_TO, -1.2,
R_H_LINE_TO, 4.8,
V_LINE_TO, 16,
CLOSE,
R_MOVE_TO, -5.31, -2.31,
R_CUBIC_TO, -0.37, 0, -0.7, -0.14, -0.97, -0.41,
R_ARC_TO, 1.33, 1.33, 0, 0, 1, -0.41, -0.97,
V_LINE_TO, 2.89,
R_CUBIC_TO, 0, -0.37, 0.14, -0.7, 0.41, -0.97,
R_ARC_TO, 1.33, 1.33, 0, 0, 1, 0.97, -0.41,
H_LINE_TO, 9.7,
R_LINE_TO, 3.19, 3.19,
V_LINE_TO, 8,
R_H_LINE_TO, -1.38,
V_LINE_TO, 5.63,
H_LINE_TO, 8.77,
V_LINE_TO, 2.89,
H_LINE_TO, 4.49,
R_V_LINE_TO, 9.42,
R_H_LINE_TO, 4.31,
R_V_LINE_TO, 1.38,
CLOSE,
R_MOVE_TO, 0, -1.38,
V_LINE_TO, 2.89,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFileSaveChromeRefreshRepList, kFileSaveChromeRefreshIcon, {kFileSaveChromeRefreshPath}, {kFileSaveChromeRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kFileSaveOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 17.44, 15.31,
R_LINE_TO, -1.06, -1.06,
R_LINE_TO, 0.81, -0.81,
LINE_TO, 18.25, 14.5,
CLOSE,
MOVE_TO, 16, 13.87,
R_LINE_TO, -1.5, -1.5,
V_LINE_TO, 11.5,
H_LINE_TO, 16,
CLOSE,
MOVE_TO, 12.25, 20,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 4.13,
LINE_TO, 5.5, 7.63,
V_LINE_TO, 15.5,
R_H_LINE_TO, 5.52,
V_LINE_TO, 17,
H_LINE_TO, 5.5,
R_CUBIC_TO, -0.4, 0, -0.75, -0.15, -1.05, -0.45,
R_CUBIC_TO, -0.3, -0.3, -0.45, -0.65, -0.45, -1.05,
V_LINE_TO, 6.13,
LINE_TO, 1.17, 3.27,
LINE_TO, 2.23, 2.23,
LINE_TO, 18.5, 18.5,
V_LINE_TO, 20,
CLOSE,
R_MOVE_TO, 2.25, -10,
H_LINE_TO, 16,
V_LINE_TO, 6,
R_LINE_TO, -4, -4,
H_LINE_TO, 5.5,
R_CUBIC_TO, -0.18, 0, -0.36, 0.04, -0.55, 0.11,
R_CUBIC_TO, -0.19, 0.07, -0.34, 0.16, -0.45, 0.27,
LINE_TO, 5.63, 3.5,
H_LINE_TO, 11,
V_LINE_TO, 7,
R_H_LINE_TO, 3.5,
CLOSE,
R_MOVE_TO, -5.04, 1.58,
CLOSE,
R_MOVE_TO, 2, -2.46,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFileSaveOffChromeRefreshRepList, kFileSaveOffChromeRefreshIcon, {kFileSaveOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kFingerprintPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 17.81, 4.47,
R_CUBIC_TO, -0.08, 0, -0.16, -0.02, -0.23, -0.06,
CUBIC_TO, 15.66, 3.42, 14, 3, 12.01, 3,
R_CUBIC_TO, -1.98, 0, -3.86, 0.47, -5.57, 1.41,
R_CUBIC_TO, -0.24, 0.13, -0.54, 0.04, -0.68, -0.2,
R_CUBIC_TO, -0.13, -0.24, -0.04, -0.55, 0.2, -0.68,
CUBIC_TO, 7.82, 2.52, 9.86, 2, 12.01, 2,
R_CUBIC_TO, 2.13, 0, 3.99, 0.47, 6.03, 1.52,
R_CUBIC_TO, 0.25, 0.13, 0.34, 0.43, 0.21, 0.67,
R_CUBIC_TO, -0.09, 0.18, -0.26, 0.28, -0.44, 0.28,
CLOSE,
MOVE_TO, 3.5, 9.72,
R_CUBIC_TO, -0.1, 0, -0.2, -0.03, -0.29, -0.09,
R_CUBIC_TO, -0.23, -0.16, -0.28, -0.47, -0.12, -0.7,
R_CUBIC_TO, 0.99, -1.4, 2.25, -2.5, 3.75, -3.27,
CUBIC_TO, 9.98, 4.04, 14, 4.03, 17.15, 5.65,
R_CUBIC_TO, 1.5, 0.77, 2.76, 1.86, 3.75, 3.25,
R_CUBIC_TO, 0.16, 0.22, 0.11, 0.54, -0.12, 0.7,
R_CUBIC_TO, -0.23, 0.16, -0.54, 0.11, -0.7, -0.12,
R_CUBIC_TO, -0.9, -1.26, -2.04, -2.25, -3.39, -2.94,
R_CUBIC_TO, -2.87, -1.47, -6.54, -1.47, -9.4, 0.01,
R_CUBIC_TO, -1.36, 0.7, -2.5, 1.7, -3.4, 2.96,
R_CUBIC_TO, -0.08, 0.14, -0.23, 0.21, -0.39, 0.21,
CLOSE,
R_MOVE_TO, 6.25, 12.07,
R_CUBIC_TO, -0.13, 0, -0.26, -0.05, -0.35, -0.15,
R_CUBIC_TO, -0.87, -0.87, -1.34, -1.43, -2.01, -2.64,
R_CUBIC_TO, -0.69, -1.23, -1.05, -2.73, -1.05, -4.34,
R_CUBIC_TO, 0, -2.97, 2.54, -5.39, 5.66, -5.39,
R_CUBIC_TO, 3.12, 0, 5.66, 2.42, 5.66, 5.39,
R_CUBIC_TO, 0, 0.28, -0.22, 0.5, -0.5, 0.5,
R_CUBIC_TO, -0.28, 0, -0.5, -0.22, -0.5, -0.5,
R_CUBIC_TO, 0, -2.42, -2.09, -4.39, -4.66, -4.39,
R_CUBIC_TO, -2.57, 0, -4.66, 1.97, -4.66, 4.39,
R_CUBIC_TO, 0, 1.44, 0.32, 2.77, 0.93, 3.85,
R_CUBIC_TO, 0.64, 1.15, 1.08, 1.64, 1.85, 2.42,
R_CUBIC_TO, 0.19, 0.2, 0.19, 0.51, 0, 0.71,
R_CUBIC_TO, -0.11, 0.1, -0.24, 0.15, -0.37, 0.15,
CLOSE,
R_MOVE_TO, 7.17, -1.85,
R_CUBIC_TO, -1.19, 0, -2.24, -0.3, -3.1, -0.89,
R_CUBIC_TO, -1.49, -1.01, -2.38, -2.65, -2.38, -4.39,
R_CUBIC_TO, 0, -0.28, 0.22, -0.5, 0.5, -0.5,
R_CUBIC_TO, 0.28, 0, 0.5, 0.22, 0.5, 0.5,
R_CUBIC_TO, 0, 1.41, 0.72, 2.74, 1.94, 3.56,
R_CUBIC_TO, 0.71, 0.48, 1.54, 0.71, 2.54, 0.71,
R_CUBIC_TO, 0.24, 0, 0.64, -0.03, 1.04, -0.1,
R_CUBIC_TO, 0.27, -0.05, 0.53, 0.13, 0.58, 0.41,
R_CUBIC_TO, 0.05, 0.27, -0.13, 0.53, -0.41, 0.58,
R_CUBIC_TO, -0.57, 0.11, -1.07, 0.12, -1.21, 0.12,
CLOSE,
MOVE_TO, 14.91, 22,
R_CUBIC_TO, -0.04, 0, -0.09, -0.01, -0.13, -0.02,
R_CUBIC_TO, -1.59, -0.44, -2.63, -1.03, -3.72, -2.1,
R_CUBIC_TO, -1.4, -1.39, -2.17, -3.24, -2.17, -5.22,
R_CUBIC_TO, 0, -1.62, 1.38, -2.94, 3.08, -2.94,
R_CUBIC_TO, 1.7, 0, 3.08, 1.32, 3.08, 2.94,
R_CUBIC_TO, 0, 1.07, 0.93, 1.94, 2.08, 1.94,
R_CUBIC_TO, 1.15, 0, 2.08, -0.87, 2.08, -1.94,
R_CUBIC_TO, 0, -3.77, -3.25, -6.83, -7.25, -6.83,
R_CUBIC_TO, -2.84, 0, -5.44, 1.58, -6.61, 4.03,
R_CUBIC_TO, -0.39, 0.81, -0.59, 1.76, -0.59, 2.8,
R_CUBIC_TO, 0, 0.78, 0.07, 2.01, 0.67, 3.61,
R_CUBIC_TO, 0.1, 0.26, -0.03, 0.55, -0.29, 0.64,
R_CUBIC_TO, -0.26, 0.1, -0.55, -0.04, -0.64, -0.29,
R_CUBIC_TO, -0.49, -1.31, -0.73, -2.61, -0.73, -3.96,
R_CUBIC_TO, 0, -1.2, 0.23, -2.29, 0.68, -3.24,
R_CUBIC_TO, 1.33, -2.79, 4.28, -4.6, 7.51, -4.6,
R_CUBIC_TO, 4.55, 0, 8.25, 3.51, 8.25, 7.83,
R_CUBIC_TO, 0, 1.62, -1.38, 2.94, -3.08, 2.94,
R_CUBIC_TO, -1.7, 0, -3.08, -1.32, -3.08, -2.94,
R_CUBIC_TO, 0, -1.07, -0.93, -1.94, -2.08, -1.94,
R_CUBIC_TO, -1.15, 0, -2.08, 0.87, -2.08, 1.94,
R_CUBIC_TO, 0, 1.71, 0.66, 3.31, 1.87, 4.51,
R_CUBIC_TO, 0.95, 0.94, 1.86, 1.46, 3.27, 1.85,
R_CUBIC_TO, 0.27, 0.07, 0.42, 0.35, 0.35, 0.61,
R_CUBIC_TO, -0.05, 0.23, -0.26, 0.38, -0.47, 0.38,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFingerprintRepList, kFingerprintIcon, {kFingerprintPath})
VECTOR_ICON_REP_TEMPLATE(kForwardArrowTouchPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 11.09, 18.59,
LINE_TO, 11, 18.51,
LINE_TO, 16.51, 13,
H_LINE_TO, 5,
R_ARC_TO, 1, 1, 0, 0, 1, 0, -2,
R_H_LINE_TO, 11.51,
LINE_TO, 11, 5.49,
R_LINE_TO, 0.09, -0.09,
R_ARC_TO, 1, 1, 0, 0, 1, 1.32, -1.32,
R_H_LINE_TO, 0,
LINE_TO, 12.49, 4,
LINE_TO, 20, 11.51,
R_LINE_TO, -0.09, 0.09,
R_ARC_TO, 1, 1, 0, 0, 1, 0, 0.82,
R_LINE_TO, 0.09, 0.09,
LINE_TO, 12.49, 20,
R_LINE_TO, -0.09, -0.09,
R_ARC_TO, 1, 1, 0, 0, 1, -1.32, -1.32,
R_V_LINE_TO, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kForwardArrowTouchRepList, kForwardArrowTouchIcon, {kForwardArrowTouchPath})
VECTOR_ICON_REP_TEMPLATE(kFullscreenPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 7, 14,
H_LINE_TO, 5,
R_V_LINE_TO, 5,
R_H_LINE_TO, 5,
R_V_LINE_TO, -2,
H_LINE_TO, 7,
R_V_LINE_TO, -3,
CLOSE,
R_MOVE_TO, -2, -4,
R_H_LINE_TO, 2,
V_LINE_TO, 7,
R_H_LINE_TO, 3,
V_LINE_TO, 5,
H_LINE_TO, 5,
R_V_LINE_TO, 5,
CLOSE,
R_MOVE_TO, 12, 7,
R_H_LINE_TO, -3,
R_V_LINE_TO, 2,
R_H_LINE_TO, 5,
R_V_LINE_TO, -5,
R_H_LINE_TO, -2,
R_V_LINE_TO, 3,
CLOSE,
MOVE_TO, 14, 5,
R_V_LINE_TO, 2,
R_H_LINE_TO, 3,
R_V_LINE_TO, 3,
R_H_LINE_TO, 2,
V_LINE_TO, 5,
R_H_LINE_TO, -5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFullscreenRepList, kFullscreenIcon, {kFullscreenPath})
VECTOR_ICON_REP_TEMPLATE(kFullscreenRefreshPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 2.27, 13.73,
R_V_LINE_TO, -3.44,
R_H_LINE_TO, 1.38,
R_V_LINE_TO, 2.06,
R_H_LINE_TO, 2.06,
R_V_LINE_TO, 1.38,
CLOSE,
R_MOVE_TO, 8.04, 0,
R_V_LINE_TO, -1.38,
R_H_LINE_TO, 2.05,
R_V_LINE_TO, -2.06,
R_H_LINE_TO, 1.38,
R_V_LINE_TO, 3.44,
CLOSE,
MOVE_TO, 2.27, 5.7,
V_LINE_TO, 2.27,
R_H_LINE_TO, 3.44,
R_V_LINE_TO, 1.38,
H_LINE_TO, 3.65,
V_LINE_TO, 5.7,
CLOSE,
R_MOVE_TO, 10.09, 0,
V_LINE_TO, 3.65,
H_LINE_TO, 10.3,
V_LINE_TO, 2.27,
R_H_LINE_TO, 3.43,
R_V_LINE_TO, 3.43,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFullscreenRefreshRepList, kFullscreenRefreshIcon, {kFullscreenRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kGenericStopPath, CANVAS_DIMENSIONS, 20,
ROUND_RECT, 7, 7, 6, 6, 0,
NEW_PATH,
STROKE, 2,
CIRCLE, 10, 10, 7,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kGenericStopRepList, kGenericStopIcon, {kGenericStopPath})
VECTOR_ICON_REP_TEMPLATE(kGlobePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 12, 22.8,
CUBIC_TO, 10.51, 22.8, 9.1, 22.52, 7.79, 21.95,
CUBIC_TO, 6.47, 21.38, 5.33, 20.61, 4.36, 19.64,
CUBIC_TO, 3.39, 18.67, 2.62, 17.53, 2.05, 16.21,
CUBIC_TO, 1.48, 14.9, 1.2, 13.49, 1.2, 12,
CUBIC_TO, 1.2, 10.5, 1.48, 9.09, 2.05, 7.78,
CUBIC_TO, 2.62, 6.46, 3.39, 5.31, 4.36, 4.34,
CUBIC_TO, 5.34, 3.36, 6.48, 2.6, 7.79, 2.04,
CUBIC_TO, 9.11, 1.48, 10.51, 1.2, 12, 1.2,
CUBIC_TO, 13.5, 1.2, 14.91, 1.48, 16.22, 2.04,
CUBIC_TO, 17.54, 2.6, 18.69, 3.36, 19.66, 4.34,
CUBIC_TO, 20.64, 5.31, 21.4, 6.46, 21.96, 7.78,
CUBIC_TO, 22.52, 9.09, 22.8, 10.5, 22.8, 12,
CUBIC_TO, 22.8, 13.5, 22.52, 14.9, 21.96, 16.21,
CUBIC_TO, 21.4, 17.52, 20.64, 18.66, 19.66, 19.64,
CUBIC_TO, 18.69, 20.61, 17.54, 21.38, 16.22, 21.95,
CUBIC_TO, 14.91, 22.52, 13.5, 22.8, 12, 22.8,
CLOSE,
MOVE_TO, 12, 20.15,
CUBIC_TO, 14.08, 20.15, 15.88, 19.48, 17.39, 18.14,
CUBIC_TO, 18.89, 16.8, 19.79, 15.13, 20.07, 13.13,
CUBIC_TO, 19.88, 13.44, 19.61, 13.7, 19.26, 13.89,
CUBIC_TO, 18.92, 14.08, 18.55, 14.18, 18.15, 14.18,
LINE_TO, 15.85, 14.18,
CUBIC_TO, 15.22, 14.18, 14.68, 13.95, 14.23, 13.5,
CUBIC_TO, 13.77, 13.05, 13.55, 12.51, 13.55, 11.88,
LINE_TO, 13.55, 10.73,
LINE_TO, 9.2, 10.73,
LINE_TO, 9.2, 8.2,
CUBIC_TO, 9.2, 7.57, 9.43, 7.03, 9.88, 6.57,
CUBIC_TO, 10.32, 6.13, 10.87, 5.9, 11.5, 5.9,
LINE_TO, 12.4, 5.9,
CUBIC_TO, 12.4, 5.48, 12.5, 5.11, 12.69, 4.77,
CUBIC_TO, 12.88, 4.44, 13.13, 4.18, 13.45, 3.98,
CUBIC_TO, 13.22, 3.94, 12.98, 3.91, 12.74, 3.88,
CUBIC_TO, 12.5, 3.86, 12.26, 3.85, 12, 3.85,
CUBIC_TO, 9.73, 3.85, 7.8, 4.64, 6.22, 6.22,
CUBIC_TO, 4.64, 7.8, 3.85, 9.73, 3.85, 12,
LINE_TO, 3.85, 12.38,
CUBIC_TO, 3.85, 12.49, 3.86, 12.62, 3.88, 12.75,
LINE_TO, 7.3, 12.75,
CUBIC_TO, 8.58, 12.75, 9.67, 13.2, 10.56, 14.09,
CUBIC_TO, 11.45, 14.98, 11.9, 16.06, 11.9, 17.34,
LINE_TO, 11.9, 18.5,
LINE_TO, 8.45, 18.5,
LINE_TO, 8.45, 19.35,
CUBIC_TO, 8.98, 19.62, 9.55, 19.82, 10.14, 19.95,
CUBIC_TO, 10.74, 20.08, 11.36, 20.15, 12, 20.15,
CLOSE,
MOVE_TO, 12, 20.15,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kGlobeRepList, kGlobeIcon, {kGlobePath})
VECTOR_ICON_REP_TEMPLATE(kGuardianPath, CANVAS_DIMENSIONS, 32,
FILL_RULE_NONZERO,
MOVE_TO, 16, 27.23,
R_CUBIC_TO, -3.17, 0, -5.83, -0.59, -8, -1.77,
R_CUBIC_TO, -2.17, -1.18, -3.25, -2.65, -3.25, -4.4,
R_CUBIC_TO, 0, -1.18, 0.54, -2.27, 1.63, -3.25,
R_CUBIC_TO, 1.08, -0.98, 2.58, -1.72, 4.47, -2.22,
R_V_LINE_TO, 2.3,
R_CUBIC_TO, -1.18, 0.38, -2.12, 0.87, -2.8, 1.45,
R_CUBIC_TO, -0.68, 0.57, -1.02, 1.14, -1.02, 1.73,
R_CUBIC_TO, 0, 1.05, 0.89, 1.97, 2.68, 2.75,
R_CUBIC_TO, 1.8, 0.77, 3.9, 1.15, 6.3, 1.15,
R_CUBIC_TO, 2.4, 0, 4.49, -0.38, 6.28, -1.15,
R_CUBIC_TO, 1.8, -0.78, 2.7, -1.7, 2.7, -2.75,
R_CUBIC_TO, 0, -0.58, -0.35, -1.16, -1.05, -1.72,
R_CUBIC_TO, -0.68, -0.58, -1.61, -1.07, -2.77, -1.45,
R_V_LINE_TO, -2.3,
R_CUBIC_TO, 1.9, 0.5, 3.39, 1.24, 4.47, 2.23,
R_CUBIC_TO, 1.08, 0.98, 1.63, 2.07, 1.63, 3.25,
R_CUBIC_TO, 0, 1.75, -1.08, 3.22, -3.25, 4.4,
R_CUBIC_TO, -2.17, 1.18, -4.83, 1.78, -8, 1.78,
CLOSE,
R_MOVE_TO, -3.15, -4.3,
V_LINE_TO, 12.35,
H_LINE_TO, 7.8,
R_V_LINE_TO, -2.27,
R_H_LINE_TO, 16.4,
R_V_LINE_TO, 2.28,
R_H_LINE_TO, -5.05,
R_V_LINE_TO, 10.58,
R_H_LINE_TO, -2.27,
V_LINE_TO, 18.05,
R_H_LINE_TO, -1.75,
R_V_LINE_TO, 4.88,
H_LINE_TO, 12.85,
CLOSE,
MOVE_TO, 16, 9.07,
R_ARC_TO, 2.13, 2.13, 0, 0, 1, -1.52, -0.62,
R_ARC_TO, 2.08, 2.08, 0, 0, 1, -0.62, -1.52,
R_CUBIC_TO, 0, -0.58, 0.21, -1.08, 0.63, -1.5,
ARC_TO, 2.13, 2.13, 0, 0, 1, 16, 4.8,
R_CUBIC_TO, 0.58, 0, 1.08, 0.21, 1.5, 0.63,
R_CUBIC_TO, 0.43, 0.42, 0.65, 0.92, 0.65, 1.5,
R_CUBIC_TO, 0, 0.6, -0.22, 1.11, -0.65, 1.53,
R_ARC_TO, 2.05, 2.05, 0, 0, 1, -1.5, 0.63,
CLOSE,
NEW_PATH)
VECTOR_ICON_TEMPLATE_CC(kGuardianRepList, kGuardianIcon, {kGuardianPath})
VECTOR_ICON_REP_TEMPLATE(kHardwareComputerPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 20, 18,
R_CUBIC_TO, 1.1, 0, 1.99, -0.9, 1.99, -2,
LINE_TO, 22, 6,
R_CUBIC_TO, 0, -1.1, -0.9, -2, -2, -2,
H_LINE_TO, 4,
R_CUBIC_TO, -1.1, 0, -2, 0.9, -2, 2,
R_V_LINE_TO, 10,
R_CUBIC_TO, 0, 1.1, 0.9, 2, 2, 2,
H_LINE_TO, 0,
R_V_LINE_TO, 2,
R_H_LINE_TO, 24,
R_V_LINE_TO, -2,
R_H_LINE_TO, -4,
CLOSE,
MOVE_TO, 4, 6,
R_H_LINE_TO, 16,
R_V_LINE_TO, 10,
H_LINE_TO, 4,
V_LINE_TO, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kHardwareComputerRepList, kHardwareComputerIcon, {kHardwareComputerPath})
VECTOR_ICON_REP_TEMPLATE(kHardwareComputerSmallPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 17.6, 16.2,
R_CUBIC_TO, 0.77, 0, 1.39, -0.63, 1.39, -1.4,
R_LINE_TO, 0.01, -7,
R_CUBIC_TO, 0, -0.77, -0.63, -1.4, -1.4, -1.4,
H_LINE_TO, 6.4,
R_CUBIC_TO, -0.77, 0, -1.4, 0.63, -1.4, 1.4,
R_V_LINE_TO, 7,
R_CUBIC_TO, 0, 0.77, 0.63, 1.4, 1.4, 1.4,
R_H_LINE_TO, 11.2,
CLOSE,
R_MOVE_TO, -11.2, -8.4,
R_H_LINE_TO, 11.2,
R_V_LINE_TO, 7,
H_LINE_TO, 6.4,
R_V_LINE_TO, -7,
CLOSE,
R_MOVE_TO, -2.1, 9.1,
R_H_LINE_TO, 15.4,
R_V_LINE_TO, 1.4,
H_LINE_TO, 4.3,
R_V_LINE_TO, -1.4,
CLOSE,)
VECTOR_ICON_TEMPLATE_CC(kHardwareComputerSmallRepList, kHardwareComputerSmallIcon, {kHardwareComputerSmallPath})
VECTOR_ICON_REP_TEMPLATE(kHardwareSmartphonePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 17, 1.01,
LINE_TO, 7, 1,
R_CUBIC_TO, -1.1, 0, -2, 0.9, -2, 2,
R_V_LINE_TO, 18,
R_CUBIC_TO, 0, 1.1, 0.9, 2, 2, 2,
R_H_LINE_TO, 10,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
V_LINE_TO, 3,
R_CUBIC_TO, 0, -1.1, -0.9, -1.99, -2, -1.99,
CLOSE,
MOVE_TO, 17, 19,
H_LINE_TO, 7,
V_LINE_TO, 5,
R_H_LINE_TO, 10,
R_V_LINE_TO, 14,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kHardwareSmartphoneRepList, kHardwareSmartphoneIcon, {kHardwareSmartphonePath})
VECTOR_ICON_REP_TEMPLATE(kHelpMenuPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 7.99, 12,
R_ARC_TO, 0.82, 0.82, 0, 0, 0, 0.6, -0.25,
R_ARC_TO, 0.82, 0.82, 0, 0, 0, 0.25, -0.6,
R_ARC_TO, 0.8, 0.8, 0, 0, 0, -0.25, -0.59,
R_ARC_TO, 0.82, 0.82, 0, 0, 0, -0.6, -0.25,
R_ARC_TO, 0.81, 0.81, 0, 0, 0, -0.6, 0.25,
R_ARC_TO, 0.8, 0.8, 0, 0, 0, -0.25, 0.59,
R_CUBIC_TO, 0, 0.24, 0.08, 0.43, 0.25, 0.6,
R_ARC_TO, 0.81, 0.81, 0, 0, 0, 0.6, 0.25,
CLOSE,
R_MOVE_TO, -0.64, -2.55,
H_LINE_TO, 8.64,
R_CUBIC_TO, 0, -0.4, 0.04, -0.69, 0.11, -0.86,
R_CUBIC_TO, 0.07, -0.18, 0.24, -0.39, 0.51, -0.64,
R_CUBIC_TO, 0.38, -0.37, 0.64, -0.69, 0.79, -0.96,
R_CUBIC_TO, 0.15, -0.27, 0.22, -0.57, 0.22, -0.9,
R_CUBIC_TO, 0, -0.62, -0.2, -1.12, -0.61, -1.51,
R_CUBIC_TO, -0.41, -0.39, -0.94, -0.58, -1.59, -0.58,
R_CUBIC_TO, -0.58, 0, -1.08, 0.16, -1.51, 0.47,
R_CUBIC_TO, -0.43, 0.31, -0.73, 0.73, -0.9, 1.26,
R_LINE_TO, 1.17, 0.48,
R_CUBIC_TO, 0.11, -0.32, 0.26, -0.56, 0.47, -0.73,
R_CUBIC_TO, 0.21, -0.17, 0.45, -0.25, 0.72, -0.25,
R_CUBIC_TO, 0.28, 0, 0.52, 0.08, 0.7, 0.25,
ARC_TO, 0.83, 0.83, 0, 0, 1, 9, 6.12,
R_CUBIC_TO, 0, 0.24, -0.08, 0.46, -0.25, 0.66,
R_ARC_TO, 6.56, 6.56, 0, 0, 1, -0.54, 0.56,
R_CUBIC_TO, -0.38, 0.35, -0.62, 0.65, -0.71, 0.88,
R_CUBIC_TO, -0.1, 0.24, -0.15, 0.65, -0.15, 1.24,
CLOSE,
MOVE_TO, 8, 14.53,
R_ARC_TO, 6.32, 6.32, 0, 0, 1, -2.54, -0.51,
R_ARC_TO, 6.52, 6.52, 0, 0, 1, -2.08, -1.4,
R_ARC_TO, 6.52, 6.52, 0, 0, 1, -1.4, -2.08,
ARC_TO, 6.32, 6.32, 0, 0, 1, 1.47, 8,
R_ARC_TO, 6.3, 6.3, 0, 0, 1, 0.51, -2.55,
ARC_TO, 6.53, 6.53, 0, 0, 1, 3.38, 3.38,
ARC_TO, 6.52, 6.52, 0, 0, 1, 5.46, 1.98,
ARC_TO, 6.32, 6.32, 0, 0, 1, 8, 1.47,
R_ARC_TO, 6.3, 6.3, 0, 0, 1, 2.55, 0.51,
R_CUBIC_TO, 0.79, 0.34, 1.48, 0.8, 2.07, 1.4,
R_ARC_TO, 6.53, 6.53, 0, 0, 1, 1.4, 2.07,
ARC_TO, 6.3, 6.3, 0, 0, 1, 14.54, 8,
R_CUBIC_TO, 0, 0.9, -0.17, 1.75, -0.51, 2.54,
R_ARC_TO, 6.52, 6.52, 0, 0, 1, -1.4, 2.08,
R_ARC_TO, 6.53, 6.53, 0, 0, 1, -2.07, 1.4,
ARC_TO, 6.3, 6.3, 0, 0, 1, 8, 14.54,
CLOSE,
R_MOVE_TO, 0, -1.38,
R_CUBIC_TO, 1.43, 0, 2.65, -0.5, 3.65, -1.5,
R_CUBIC_TO, 1, -1, 1.5, -2.22, 1.5, -3.65,
R_CUBIC_TO, 0, -1.43, -0.5, -2.65, -1.5, -3.65,
CUBIC_TO_SHORTHAND, 9.43, 2.85, 8, 2.85,
R_CUBIC_TO, -1.43, 0, -2.65, 0.5, -3.65, 1.5,
CUBIC_TO_SHORTHAND, 2.85, 6.57, 2.85, 8,
R_CUBIC_TO, 0, 1.43, 0.5, 2.65, 1.5, 3.65,
R_CUBIC_TO, 1, 1, 2.22, 1.5, 3.65, 1.5,
CLOSE,
MOVE_TO, 8, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kHelpMenuRepList, kHelpMenuIcon, {kHelpMenuPath})
VECTOR_ICON_REP_TEMPLATE(kHistoryPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 7.99, 13.73,
R_CUBIC_TO, -1.59, 0, -2.94, -0.55, -4.06, -1.67,
CUBIC_TO, 2.81, 10.95, 2.26, 9.59, 2.26, 8,
H_LINE_TO, 3.64,
R_CUBIC_TO, 0, 1.2, 0.43, 2.22, 1.28, 3.07,
R_CUBIC_TO, 0.85, 0.85, 1.88, 1.28, 3.07, 1.28,
R_CUBIC_TO, 1.2, 0, 2.22, -0.43, 3.07, -1.28,
R_CUBIC_TO, 0.85, -0.85, 1.28, -1.87, 1.28, -3.07,
R_CUBIC_TO, 0, -1.2, -0.43, -2.22, -1.28, -3.07,
R_CUBIC_TO, -0.85, -0.85, -1.87, -1.28, -3.07, -1.28,
R_CUBIC_TO, -0.66, 0, -1.26, 0.13, -1.83, 0.39,
ARC_TO, 4.16, 4.16, 0, 0, 0, 4.73, 5.13,
R_H_LINE_TO, 1.67,
R_V_LINE_TO, 1.26,
H_LINE_TO, 2.3,
V_LINE_TO, 2.3,
R_H_LINE_TO, 1.26,
R_V_LINE_TO, 2.11,
ARC_TO, 5.75, 5.75, 0, 0, 1, 5.49, 2.84,
R_ARC_TO, 5.51, 5.51, 0, 0, 1, 2.5, -0.57,
R_CUBIC_TO, 0.79, 0, 1.54, 0.15, 2.24, 0.45,
R_CUBIC_TO, 0.7, 0.3, 1.3, 0.71, 1.82, 1.23,
R_ARC_TO, 5.77, 5.77, 0, 0, 1, 1.23, 1.82,
R_CUBIC_TO, 0.31, 0.7, 0.45, 1.44, 0.45, 2.24,
R_CUBIC_TO, 0, 0.79, -0.15, 1.54, -0.45, 2.23,
R_CUBIC_TO, -0.3, 0.7, -0.71, 1.31, -1.23, 1.82,
R_ARC_TO, 5.77, 5.77, 0, 0, 1, -1.82, 1.23,
R_ARC_TO, 5.51, 5.51, 0, 0, 1, -2.23, 0.45,
CLOSE,
R_MOVE_TO, 1.65, -3.44,
LINE_TO, 7.37, 8.03,
R_V_LINE_TO, -3.23,
R_H_LINE_TO, 1.26,
V_LINE_TO, 7.5,
R_LINE_TO, 1.9, 1.9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kHistoryRepList, kHistoryIcon, {kHistoryPath})
VECTOR_ICON_REP_TEMPLATE(kIncognitoPath, CANVAS_DIMENSIONS, 25,
CIRCLE, 12.5, 12.5, 12.5,
MOVE_TO, 16.41, 13.37,
R_ARC_TO, 3.04, 3.04, 0, 0, 1, 3.04, 3.04,
R_ARC_TO, 3.04, 3.04, 0, 0, 1, -3.04, 3.04,
R_CUBIC_TO, -1.59, 0, -2.87, -1.22, -3.01, -2.78,
R_CUBIC_TO, -0.84, -0.54, -1.53, -0.2, -1.79, -0.02,
R_ARC_TO, 3.02, 3.02, 0, 0, 1, -3.01, 2.8,
R_ARC_TO, 3.04, 3.04, 0, 0, 1, -3.04, -3.04,
R_ARC_TO, 3.04, 3.04, 0, 0, 1, 3.04, -3.04,
R_ARC_TO, 3.04, 3.04, 0, 0, 1, 2.95, 2.34,
R_ARC_TO, 2.38, 2.38, 0, 0, 1, 1.91, 0.01,
R_ARC_TO, 3.03, 3.03, 0, 0, 1, 2.95, -2.35,
CLOSE,
R_MOVE_TO, -7.81, 0.87,
R_ARC_TO, 2.17, 2.17, 0, 1, 0, 0, 4.34,
R_ARC_TO, 2.17, 2.17, 0, 0, 0, 0, -4.34,
CLOSE,
R_MOVE_TO, 7.81, 0,
R_ARC_TO, 2.17, 2.17, 0, 1, 0, 0, 4.34,
R_ARC_TO, 2.17, 2.17, 0, 0, 0, 0, -4.34,
CLOSE,
MOVE_TO, 20.31, 11,
R_V_LINE_TO, 1,
H_LINE_TO, 4.69,
R_V_LINE_TO, -1,
R_H_LINE_TO, 15.63,
CLOSE,
R_MOVE_TO, -4.97, -5.64,
R_LINE_TO, 0.05, 0.11,
LINE_TO, 17.05, 10,
H_LINE_TO, 7.95,
R_LINE_TO, 1.65, -4.53,
R_ARC_TO, 0.87, 0.87, 0, 0, 1, 0.96, -0.55,
R_LINE_TO, 0.12, 0.03,
R_LINE_TO, 1.81, 0.61,
R_LINE_TO, 1.81, -0.61,
R_ARC_TO, 0.87, 0.87, 0, 0, 1, 1.03, 0.41,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kIncognito24Path, CANVAS_DIMENSIONS, 24,
CIRCLE, 12, 12, 12,
MOVE_TO, 15.75, 12.83,
R_ARC_TO, 2.92, 2.92, 0, 0, 1, 2.92, 2.92,
R_ARC_TO, 2.92, 2.92, 0, 0, 1, -2.92, 2.92,
R_CUBIC_TO, -1.52, 0, -2.76, -1.17, -2.89, -2.67,
R_CUBIC_TO, -0.81, -0.52, -1.47, -0.19, -1.72, -0.02,
R_ARC_TO, 2.9, 2.9, 0, 0, 1, -2.89, 2.68,
R_ARC_TO, 2.92, 2.92, 0, 0, 1, -2.92, -2.92,
R_ARC_TO, 2.92, 2.92, 0, 0, 1, 2.92, -2.92,
R_ARC_TO, 2.92, 2.92, 0, 0, 1, 2.83, 2.25,
R_ARC_TO, 2.29, 2.29, 0, 0, 1, 1.83, 0.01,
R_ARC_TO, 2.91, 2.91, 0, 0, 1, 2.83, -2.26,
CLOSE,
R_MOVE_TO, -7.5, 0.83,
R_ARC_TO, 2.08, 2.08, 0, 1, 0, 0, 4.17,
R_ARC_TO, 2.08, 2.08, 0, 0, 0, 0, -4.17,
CLOSE,
R_MOVE_TO, 7.5, 0,
R_ARC_TO, 2.08, 2.08, 0, 1, 0, 0, 4.17,
R_ARC_TO, 2.08, 2.08, 0, 0, 0, 0, -4.17,
CLOSE,
MOVE_TO, 19.5, 11,
R_V_LINE_TO, 1,
R_H_LINE_TO, -15,
R_V_LINE_TO, -1,
R_H_LINE_TO, 15,
CLOSE,
R_MOVE_TO, -4.77, -5.85,
R_LINE_TO, 0.05, 0.1,
R_LINE_TO, 1.6, 4.25,
R_LINE_TO, -8.74, -0.01,
LINE_TO, 9.22, 5.25,
R_ARC_TO, 0.84, 0.84, 0, 0, 1, 0.94, -0.53,
R_LINE_TO, 0.11, 0.03,
LINE_TO, 12, 5.33,
R_LINE_TO, 1.73, -0.58,
R_CUBIC_TO, 0.39, -0.13, 0.81, 0.05, 1, 0.4,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kIncognito20Path, CANVAS_DIMENSIONS, 20,
CIRCLE, 10, 10, 10,
MOVE_TO, 13.13, 10.69,
R_CUBIC_TO, 1.34, 0, 2.43, 1.09, 2.43, 2.43,
R_CUBIC_TO, 0, 1.34, -1.09, 2.43, -2.43, 2.43,
R_CUBIC_TO, -1.27, 0, -2.3, -0.98, -2.41, -2.22,
R_CUBIC_TO, -0.67, -0.43, -1.22, -0.16, -1.43, -0.01,
R_ARC_TO, 2.42, 2.42, 0, 0, 1, -2.41, 2.24,
R_CUBIC_TO, -1.34, 0, -2.43, -1.09, -2.43, -2.43,
R_CUBIC_TO, 0, -1.34, 1.09, -2.43, 2.43, -2.43,
R_CUBIC_TO, 1.15, 0, 2.1, 0.8, 2.36, 1.87,
R_ARC_TO, 1.91, 1.91, 0, 0, 1, 1.53, 0.01,
R_ARC_TO, 2.43, 2.43, 0, 0, 1, 2.36, -1.88,
CLOSE,
R_MOVE_TO, -6.25, 0.7,
R_ARC_TO, 1.74, 1.74, 0, 1, 0, 0, 3.47,
R_ARC_TO, 1.74, 1.74, 0, 0, 0, 0, -3.47,
CLOSE,
R_MOVE_TO, 6.25, 0,
R_ARC_TO, 1.74, 1.74, 0, 1, 0, 0, 3.47,
R_ARC_TO, 1.74, 1.74, 0, 0, 0, 0, -3.47,
CLOSE,
MOVE_TO, 16.25, 9,
R_V_LINE_TO, 1,
H_LINE_TO, 3.75,
V_LINE_TO, 9,
R_H_LINE_TO, 12.5,
CLOSE,
R_MOVE_TO, -3.98, -4.72,
R_LINE_TO, 0.04, 0.09,
LINE_TO, 13.64, 8,
H_LINE_TO, 6.36,
LINE_TO, 7.68, 4.38,
R_CUBIC_TO, 0.12, -0.32, 0.45, -0.5, 0.77, -0.44,
R_LINE_TO, 0.1, 0.02,
LINE_TO, 10, 4.44,
R_LINE_TO, 1.44, -0.49,
R_ARC_TO, 0.7, 0.7, 0, 0, 1, 0.83, 0.33,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kIncognitoRepList, kIncognitoIcon, {kIncognitoPath}, {kIncognito24Path}, {kIncognito20Path})
VECTOR_ICON_REP_TEMPLATE(kIncognitoProfilePath, CANVAS_DIMENSIONS, 40,
CIRCLE, 20, 20, 20,
MOVE_TO, 25.5, 21.64,
CUBIC_TO, 27.86, 21.64, 29.78, 23.52, 29.78, 25.82,
CUBIC_TO, 29.78, 28.13, 27.86, 30, 25.5, 30,
CUBIC_TO, 23.26, 30, 21.45, 28.32, 21.26, 26.18,
CUBIC_TO, 20.07, 25.44, 19.11, 25.9, 18.74, 26.16,
CUBIC_TO, 18.57, 28.3, 16.75, 30, 14.5, 30,
CUBIC_TO, 12.14, 30, 10.22, 28.13, 10.22, 25.82,
CUBIC_TO, 10.22, 23.52, 12.14, 21.64, 14.5, 21.64,
CUBIC_TO, 16.52, 21.64, 18.2, 23.02, 18.66, 24.87,
CUBIC_TO, 19.36, 24.57, 20.32, 24.45, 21.34, 24.88,
CUBIC_TO, 21.78, 23.03, 23.47, 21.64, 25.5, 21.64,
CLOSE,
MOVE_TO, 14.5, 22.84,
CUBIC_TO, 12.81, 22.84, 11.44, 24.17, 11.44, 25.82,
CUBIC_TO, 11.44, 27.47, 12.81, 28.81, 14.5, 28.81,
CUBIC_TO, 16.19, 28.81, 17.56, 27.47, 17.56, 25.82,
CUBIC_TO, 17.56, 24.17, 16.19, 22.84, 14.5, 22.84,
CLOSE,
MOVE_TO, 25.5, 22.84,
CUBIC_TO, 23.81, 22.84, 22.44, 24.17, 22.44, 25.82,
CUBIC_TO, 22.44, 27.47, 23.81, 28.81, 25.5, 28.81,
CUBIC_TO, 27.19, 28.81, 28.56, 27.47, 28.56, 25.82,
CUBIC_TO, 28.56, 24.17, 27.19, 22.84, 25.5, 22.84,
CLOSE,
MOVE_TO, 31, 19.02,
LINE_TO, 31, 20.5,
LINE_TO, 9, 20.5,
LINE_TO, 9, 19.02,
LINE_TO, 31, 19.02,
CLOSE,
MOVE_TO, 24.02, 10.66,
LINE_TO, 24.07, 10.78,
LINE_TO, 26.5, 17,
LINE_TO, 13.5, 17,
LINE_TO, 15.92, 10.78,
CUBIC_TO, 16.13, 10.22, 16.73, 9.9, 17.32, 10.03,
LINE_TO, 17.45, 10.06,
LINE_TO, 20, 10.9,
LINE_TO, 22.54, 10.06,
CUBIC_TO, 23.12, 9.87, 23.75, 10.14, 24.02, 10.66,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kIncognitoProfileRepList, kIncognitoProfileIcon, {kIncognitoProfilePath})
VECTOR_ICON_REP_TEMPLATE(kIncognitoRefreshMenuPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 5.16, 12.83,
R_ARC_TO, 1.95, 1.95, 0, 0, 1, -1.44, -0.59,
R_ARC_TO, 1.96, 1.96, 0, 0, 1, -0.59, -1.44,
R_CUBIC_TO, 0, -0.57, 0.2, -1.05, 0.59, -1.44,
R_CUBIC_TO, 0.39, -0.39, 0.87, -0.59, 1.44, -0.59,
R_CUBIC_TO, 0.42, 0, 0.8, 0.12, 1.14, 0.36,
R_CUBIC_TO, 0.34, 0.24, 0.59, 0.55, 0.75, 0.93,
R_CUBIC_TO, 0.14, -0.06, 0.29, -0.11, 0.44, -0.13,
R_CUBIC_TO, 0.16, -0.03, 0.32, -0.04, 0.47, -0.04,
R_ARC_TO, 2.43, 2.43, 0, 0, 1, 0.92, 0.18,
R_ARC_TO, 2.1, 2.1, 0, 0, 1, 0.74, -0.93,
R_CUBIC_TO, 0.34, -0.24, 0.72, -0.36, 1.14, -0.36,
R_CUBIC_TO, 0.57, 0, 1.04, 0.2, 1.44, 0.59,
R_CUBIC_TO, 0.4, 0.4, 0.59, 0.88, 0.59, 1.44,
R_CUBIC_TO, 0, 0.57, -0.2, 1.05, -0.59, 1.44,
R_CUBIC_TO, -0.39, 0.4, -0.87, 0.59, -1.44, 0.59,
R_CUBIC_TO, -0.43, 0, -0.82, -0.12, -1.16, -0.36,
R_ARC_TO, 1.89, 1.89, 0, 0, 1, -0.73, -0.95,
R_ARC_TO, 1.25, 1.25, 0, 0, 0, -1.41, -0.28,
R_CUBIC_TO, -0.16, 0.07, -0.29, 0.16, -0.41, 0.28,
R_CUBIC_TO, -0.14, 0.39, -0.38, 0.71, -0.73, 0.95,
R_ARC_TO, 2, 2, 0, 0, 1, -1.16, 0.36,
CLOSE,
R_MOVE_TO, 0, -1.27,
R_CUBIC_TO, 0.21, 0, 0.4, -0.07, 0.54, -0.22,
R_ARC_TO, 0.74, 0.74, 0, 0, 0, 0.23, -0.54,
R_ARC_TO, 0.74, 0.74, 0, 0, 0, -0.23, -0.54,
R_ARC_TO, 0.73, 0.73, 0, 0, 0, -0.54, -0.23,
R_ARC_TO, 0.73, 0.73, 0, 0, 0, -0.54, 0.23,
R_ARC_TO, 0.75, 0.75, 0, 0, 0, -0.23, 0.54,
R_CUBIC_TO, 0, 0.21, 0.08, 0.39, 0.23, 0.54,
R_ARC_TO, 0.74, 0.74, 0, 0, 0, 0.54, 0.22,
CLOSE,
R_MOVE_TO, 5.6, 0,
R_ARC_TO, 0.75, 0.75, 0, 0, 0, 0.54, -0.22,
R_ARC_TO, 0.74, 0.74, 0, 0, 0, 0.23, -0.54,
R_ARC_TO, 0.73, 0.73, 0, 0, 0, -0.23, -0.54,
R_ARC_TO, 0.74, 0.74, 0, 0, 0, -0.54, -0.23,
R_ARC_TO, 0.73, 0.73, 0, 0, 0, -0.54, 0.23,
R_ARC_TO, 0.73, 0.73, 0, 0, 0, -0.23, 0.54,
R_CUBIC_TO, 0, 0.21, 0.08, 0.39, 0.23, 0.54,
R_ARC_TO, 0.74, 0.74, 0, 0, 0, 0.54, 0.22,
CLOSE,
MOVE_TO, 2.3, 8,
V_LINE_TO, 6.68,
R_H_LINE_TO, 2.04,
LINE_TO, 5.59, 2.78,
R_CUBIC_TO, 0.1, -0.24, 0.25, -0.41, 0.45, -0.52,
R_CUBIC_TO, 0.2, -0.11, 0.42, -0.14, 0.68, -0.08,
R_LINE_TO, 1.25, 0.33,
R_LINE_TO, 1.25, -0.33,
R_ARC_TO, 0.91, 0.91, 0, 0, 1, 0.67, 0.08,
R_CUBIC_TO, 0.2, 0.11, 0.35, 0.28, 0.45, 0.52,
R_LINE_TO, 1.26, 3.9,
R_H_LINE_TO, 2.12,
V_LINE_TO, 8,
CLOSE,
R_MOVE_TO, 3.5, -1.32,
R_H_LINE_TO, 4.33,
R_LINE_TO, -0.99, -3.05,
R_LINE_TO, -1.18, 0.31,
R_LINE_TO, -1.18, -0.31,
CLOSE,
R_MOVE_TO, 2.18, -0.07,
R_H_LINE_TO, 2.19,
R_H_LINE_TO, -4.39,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kIncognitoRefreshMenuRepList, kIncognitoRefreshMenuIcon, {kIncognitoRefreshMenuPath})
VECTOR_ICON_REP_TEMPLATE(kInfoPath, CANVAS_DIMENSIONS, 960,
FILL_RULE_NONZERO,
MOVE_TO, 440, 680,
R_H_LINE_TO, 80,
R_V_LINE_TO, -240,
R_H_LINE_TO, -80,
R_V_LINE_TO, 240,
CLOSE,
R_MOVE_TO, 40, -320,
R_QUADRATIC_TO, 17, 0, 28.5, -11.5,
QUADRATIC_TO_SHORTHAND, 520, 320,
R_QUADRATIC_TO, 0, -17, -11.5, -28.5,
QUADRATIC_TO_SHORTHAND, 480, 280,
R_QUADRATIC_TO, -17, 0, -28.5, 11.5,
QUADRATIC_TO_SHORTHAND, 440, 320,
R_QUADRATIC_TO, 0, 17, 11.5, 28.5,
QUADRATIC_TO_SHORTHAND, 480, 360,
CLOSE,
R_MOVE_TO, 0, 520,
R_QUADRATIC_TO, -83, 0, -156, -31.5,
QUADRATIC_TO_SHORTHAND, 197, 763,
R_QUADRATIC_TO, -54, -54, -85.5, -127,
QUADRATIC_TO_SHORTHAND, 80, 480,
R_QUADRATIC_TO, 0, -83, 31.5, -156,
QUADRATIC_TO_SHORTHAND, 197, 197,
R_QUADRATIC_TO, 54, -54, 127, -85.5,
QUADRATIC_TO_SHORTHAND, 480, 80,
R_QUADRATIC_TO, 83, 0, 156, 31.5,
QUADRATIC_TO_SHORTHAND, 763, 197,
R_QUADRATIC_TO, 54, 54, 85.5, 127,
QUADRATIC_TO_SHORTHAND, 880, 480,
R_QUADRATIC_TO, 0, 83, -31.5, 156,
QUADRATIC_TO_SHORTHAND, 763, 763,
R_QUADRATIC_TO, -54, 54, -127, 85.5,
QUADRATIC_TO_SHORTHAND, 480, 880,
CLOSE,
R_MOVE_TO, 0, -80,
R_QUADRATIC_TO, 134, 0, 227, -93,
R_QUADRATIC_TO, 93, -93, 93, -227,
R_QUADRATIC_TO, 0, -134, -93, -227,
R_QUADRATIC_TO, -93, -93, -227, -93,
R_QUADRATIC_TO, -134, 0, -227, 93,
R_QUADRATIC_TO, -93, 93, -93, 227,
R_QUADRATIC_TO, 0, 134, 93, 227,
R_QUADRATIC_TO, 93, 93, 227, 93,
CLOSE,
R_MOVE_TO, 0, -320,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kInfoRepList, kInfoIcon, {kInfoPath})
VECTOR_ICON_REP_TEMPLATE(kInputPath, CANVAS_DIMENSIONS, 960,
FILL_RULE_NONZERO,
MOVE_TO, 160, 800,
R_QUADRATIC_TO, -33, 0, -56.5, -23.5,
QUADRATIC_TO_SHORTHAND, 80, 720,
R_V_LINE_TO, -120,
R_H_LINE_TO, 80,
R_V_LINE_TO, 120,
R_H_LINE_TO, 640,
R_V_LINE_TO, -480,
H_LINE_TO, 160,
R_V_LINE_TO, 120,
H_LINE_TO, 80,
R_V_LINE_TO, -120,
R_QUADRATIC_TO, 0, -33, 23.5, -56.5,
QUADRATIC_TO_SHORTHAND, 160, 160,
R_H_LINE_TO, 640,
R_QUADRATIC_TO, 33, 0, 56.5, 23.5,
QUADRATIC_TO_SHORTHAND, 880, 240,
R_V_LINE_TO, 480,
R_QUADRATIC_TO, 0, 33, -23.5, 56.5,
QUADRATIC_TO_SHORTHAND, 800, 800,
H_LINE_TO, 160,
CLOSE,
R_MOVE_TO, 300, -140,
R_LINE_TO, -56, -58,
R_LINE_TO, 83, -82,
H_LINE_TO, 80,
R_V_LINE_TO, -80,
R_H_LINE_TO, 407,
R_LINE_TO, -83, -82,
R_LINE_TO, 56, -58,
R_LINE_TO, 180, 180,
R_LINE_TO, -180, 180,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kInputRepList, kInputIcon, {kInputPath})
VECTOR_ICON_REP_TEMPLATE(kInstallDesktopChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 7, 17,
R_V_LINE_TO, -2,
H_LINE_TO, 3.5,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.45, 1.45, 0, 0, 1, 2, 13.5,
V_LINE_TO, 4.49,
R_CUBIC_TO, 0, -0.41, 0.15, -0.76, 0.44, -1.05,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3.5, 3,
H_LINE_TO, 11,
R_V_LINE_TO, 1.5,
H_LINE_TO, 3.5,
R_V_LINE_TO, 9,
R_H_LINE_TO, 13,
V_LINE_TO, 11,
H_LINE_TO, 18,
R_V_LINE_TO, 2.5,
R_CUBIC_TO, 0, 0.42, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 16.5, 15,
H_LINE_TO, 13,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 7.48, -6,
LINE_TO, 11, 7.52,
R_LINE_TO, 1.06, -1.06,
R_LINE_TO, 1.69, 1.69,
V_LINE_TO, 3,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 5.11,
R_LINE_TO, 1.69, -1.69,
LINE_TO, 18, 7.48,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kInstallDesktopChromeRefresh16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 5.53, 13.73,
R_V_LINE_TO, -1.6,
R_H_LINE_TO, -2.68,
R_CUBIC_TO, -0.38, 0, -0.71, -0.14, -0.98, -0.41,
R_ARC_TO, 1.33, 1.33, 0, 0, 1, -0.4, -0.98,
V_LINE_TO, 3.65,
R_CUBIC_TO, 0, -0.38, 0.13, -0.71, 0.4, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.4, 0.98, -0.4,
R_H_LINE_TO, 5.95,
R_V_LINE_TO, 1.38,
H_LINE_TO, 2.85,
R_V_LINE_TO, 7.11,
R_H_LINE_TO, 10.3,
V_LINE_TO, 8.68,
R_H_LINE_TO, 1.38,
R_V_LINE_TO, 2.07,
R_CUBIC_TO, 0, 0.38, -0.13, 0.71, -0.4, 0.98,
R_ARC_TO, 1.35, 1.35, 0, 0, 1, -0.98, 0.4,
R_H_LINE_TO, -2.68,
R_V_LINE_TO, 1.6,
CLOSE,
R_MOVE_TO, 6.06, -5,
LINE_TO, 8.76, 5.91,
R_LINE_TO, 0.89, -0.89,
R_LINE_TO, 1.32, 1.32,
V_LINE_TO, 2.27,
R_H_LINE_TO, 1.26,
R_V_LINE_TO, 4.04,
R_LINE_TO, 1.32, -1.32,
R_LINE_TO, 0.9, 0.9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kInstallDesktopChromeRefreshRepList, kInstallDesktopChromeRefreshIcon, {kInstallDesktopChromeRefreshPath}, {kInstallDesktopChromeRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kJourneysPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 19, 15,
R_CUBIC_TO, -1.3, 0, -2.4, 0.84, -2.82, 2,
H_LINE_TO, 11,
R_CUBIC_TO, -1.1, 0, -2, -0.9, -2, -2,
R_CUBIC_TO, 0, -1.1, 0.9, -2, 2, -2,
R_H_LINE_TO, 2,
R_CUBIC_TO, 2.21, 0, 4, -1.79, 4, -4,
R_CUBIC_TO, 0, -2.21, -1.79, -4, -4, -4,
H_LINE_TO, 7.82,
CUBIC_TO, 7.4, 3.84, 6.3, 3, 5, 3,
CUBIC_TO, 3.34, 3, 2, 4.34, 2, 6,
R_CUBIC_TO, 0, 1.66, 1.34, 3, 3, 3,
R_CUBIC_TO, 1.3, 0, 2.4, -0.84, 2.82, -2,
H_LINE_TO, 13,
R_CUBIC_TO, 1.1, 0, 2, 0.9, 2, 2,
R_CUBIC_TO, 0, 1.1, -0.9, 2, -2, 2,
R_H_LINE_TO, -2,
R_CUBIC_TO, -2.21, 0, -4, 1.79, -4, 4,
R_CUBIC_TO, 0, 2.21, 1.79, 4, 4, 4,
R_H_LINE_TO, 5.18,
ARC_TO, 3, 3, 0, 0, 0, 22, 18,
R_CUBIC_TO, 0, -1.66, -1.34, -3, -3, -3,
CLOSE,
MOVE_TO, 5, 7,
R_CUBIC_TO, -0.55, 0, -1, -0.45, -1, -1,
R_CUBIC_TO, 0, -0.55, 0.45, -1, 1, -1,
R_CUBIC_TO, 0.55, 0, 1, 0.45, 1, 1,
R_CUBIC_TO, 0, 0.55, -0.45, 1, -1, 1,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kJourneysRepList, kJourneysIcon, {kJourneysPath})
VECTOR_ICON_REP_TEMPLATE(kKeepPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 13, 10,
LINE_TO, 15, 12,
LINE_TO, 15, 13.5,
LINE_TO, 10.75, 13.5,
LINE_TO, 10.75, 18.25,
LINE_TO, 10, 19,
LINE_TO, 9.25, 18.25,
LINE_TO, 9.25, 13.5,
LINE_TO, 5, 13.5,
LINE_TO, 5, 12,
LINE_TO, 7, 10,
LINE_TO, 7, 4.5,
LINE_TO, 6, 4.5,
LINE_TO, 6, 3,
LINE_TO, 14, 3,
LINE_TO, 14, 4.5,
LINE_TO, 13, 4.5,
CLOSE,
MOVE_TO, 7.13, 12,
LINE_TO, 12.88, 12,
LINE_TO, 11.5, 10.63,
LINE_TO, 11.5, 4.5,
LINE_TO, 8.5, 4.5,
LINE_TO, 8.5, 10.63,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kKeepRepList, kKeepIcon, {kKeepPath})
VECTOR_ICON_REP_TEMPLATE(kKeepOffPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 11.2, 2.4,
R_V_LINE_TO, 1.2,
R_H_LINE_TO, -0.8,
R_V_LINE_TO, 5.12,
R_LINE_TO, -1.2, -1.2,
V_LINE_TO, 3.6,
H_LINE_TO, 6.8,
R_V_LINE_TO, 1.52,
R_LINE_TO, -1.5, -1.5,
R_LINE_TO, -0.5, -0.52,
R_V_LINE_TO, -0.7,
R_H_LINE_TO, 6.4,
CLOSE,
MOVE_TO, 8, 15.2,
R_LINE_TO, -0.6, -0.6,
R_V_LINE_TO, -3.8,
H_LINE_TO, 4,
V_LINE_TO, 9.6,
LINE_TO, 5.6, 8,
R_V_LINE_TO, -0.7,
LINE_TO, 1.5, 3.2,
R_LINE_TO, 0.85, -0.85,
R_LINE_TO, 11.3, 11.32,
R_LINE_TO, -0.85, 0.85,
LINE_TO, 9.1, 10.8,
R_H_LINE_TO, -0.5,
R_V_LINE_TO, 3.8,
R_LINE_TO, -0.6, 0.6,
CLOSE,
MOVE_TO, 5.7, 9.6,
R_H_LINE_TO, 2.2,
LINE_TO, 6.8, 8.5,
LINE_TO, 5.7, 9.6,
CLOSE,
NEW_PATH)
VECTOR_ICON_TEMPLATE_CC(kKeepOffRepList, kKeepOffIcon, {kKeepOffPath})
VECTOR_ICON_REP_TEMPLATE(kKeyPath, CANVAS_DIMENSIONS, 32,
MOVE_TO, 17.42, 12,
H_LINE_TO, 30,
R_V_LINE_TO, 5,
R_H_LINE_TO, -2,
R_V_LINE_TO, 5,
R_H_LINE_TO, -4,
R_V_LINE_TO, -5,
R_H_LINE_TO, -6.25,
CUBIC_TO, 16.86, 20.45, 13.73, 23, 10, 23,
R_CUBIC_TO, -4.42, 0, -8, -3.58, -8, -8,
R_CUBIC_TO, 0, -4.42, 3.58, -8, 8, -8,
R_CUBIC_TO, 3.36, 0, 6.23, 2.07, 7.42, 5,
CLOSE,
MOVE_TO, 10, 18,
R_CUBIC_TO, 1.66, 0, 3, -1.34, 3, -3,
R_CUBIC_TO, 0, -1.66, -1.34, -3, -3, -3,
R_CUBIC_TO, -1.66, 0, -3, 1.34, -3, 3,
R_CUBIC_TO, 0, 1.66, 1.34, 3, 3, 3,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kKey16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 8.41, 6,
CUBIC_TO, 7.89, 4.44, 6.48, 3.33, 4.82, 3.33,
CUBIC_TO, 2.71, 3.33, 1, 5.12, 1, 7.33,
CUBIC_TO, 1, 9.54, 2.71, 11.33, 4.82, 11.33,
CUBIC_TO, 6.48, 11.33, 7.89, 10.22, 8.41, 8.66,
LINE_TO, 11.18, 8.66,
LINE_TO, 11.18, 11.33,
LINE_TO, 13.73, 11.33,
LINE_TO, 13.73, 8.66,
LINE_TO, 15, 8.66,
LINE_TO, 15, 6,
LINE_TO, 8.41, 6,
CLOSE,
MOVE_TO, 4.82, 8.67,
CUBIC_TO, 4.12, 8.67, 3.55, 8.08, 3.55, 7.34,
CUBIC_TO, 3.55, 6.6, 4.12, 6.01, 4.82, 6.01,
CUBIC_TO, 5.52, 6.01, 6.09, 6.6, 6.09, 7.34,
CUBIC_TO, 6.09, 8.08, 5.52, 8.67, 4.82, 8.67,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kKeyRepList, kKeyIcon, {kKeyPath}, {kKey16Path})
VECTOR_ICON_REP_TEMPLATE(kKeyboardArrowDownPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 7.41, 8.59,
LINE_TO, 12, 13.17,
R_LINE_TO, 4.59, -4.58,
LINE_TO, 18, 10,
R_LINE_TO, -6, 6,
R_LINE_TO, -6, -6,
R_LINE_TO, 1.41, -1.41,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kKeyboardArrowDownRepList, kKeyboardArrowDownIcon, {kKeyboardArrowDownPath})
VECTOR_ICON_REP_TEMPLATE(kKeyboardArrowDownChromeRefreshPath, CANVAS_DIMENSIONS, 20,
R_MOVE_TO, 10, 13.22,
R_LINE_TO, -5.16, -5.16,
LINE_TO, 6.06, 6.84,
LINE_TO, 10, 10.78,
R_LINE_TO, 3.94, -3.94,
R_LINE_TO, 1.22, 1.22,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kKeyboardArrowDownChromeRefreshRepList, kKeyboardArrowDownChromeRefreshIcon, {kKeyboardArrowDownChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kKeyboardArrowRightPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 9.71, 18.71,
R_LINE_TO, -1.42, -1.42,
R_LINE_TO, 5.3, -5.29,
R_LINE_TO, -5.3, -5.29,
R_LINE_TO, 1.42, -1.42,
R_LINE_TO, 6.7, 6.71,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kKeyboardArrowRightRepList, kKeyboardArrowRightIcon, {kKeyboardArrowRightPath})
VECTOR_ICON_REP_TEMPLATE(kKeyboardArrowUpPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 7.41, 15.41,
LINE_TO, 12, 10.83,
R_LINE_TO, 4.59, 4.58,
LINE_TO, 18, 14,
R_LINE_TO, -6, -6,
R_LINE_TO, -6, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kKeyboardArrowUpRepList, kKeyboardArrowUpIcon, {kKeyboardArrowUpPath})
VECTOR_ICON_REP_TEMPLATE(kKeyboardArrowUpChromeRefreshPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 6.06, 13.16,
LINE_TO, 4.84, 11.94,
LINE_TO, 10, 6.78,
R_LINE_TO, 5.16, 5.16,
R_LINE_TO, -1.22, 1.22,
LINE_TO, 10, 9.22,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kKeyboardArrowUpChromeRefreshRepList, kKeyboardArrowUpChromeRefreshIcon, {kKeyboardArrowUpChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kLaptopPath, MOVE_TO, 40, 36,
R_CUBIC_TO, 2.2, 0, 4, -1.8, 4, -4,
V_LINE_TO, 12,
R_CUBIC_TO, 0, -2.2, -1.8, -4, -4, -4,
H_LINE_TO, 8,
R_CUBIC_TO, -2.2, 0, -4, 1.8, -4, 4,
R_V_LINE_TO, 20,
R_CUBIC_TO, 0, 2.2, 1.8, 4, 4, 4,
H_LINE_TO, 0,
R_V_LINE_TO, 4,
R_H_LINE_TO, 48,
R_V_LINE_TO, -4,
R_H_LINE_TO, -8,
CLOSE,
MOVE_TO, 8, 12,
R_H_LINE_TO, 32,
R_V_LINE_TO, 20,
H_LINE_TO, 8,
V_LINE_TO, 12,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kLaptopRepList, kLaptopIcon, {kLaptopPath})
VECTOR_ICON_REP_TEMPLATE(kLeadingScrollPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 7.03, 8,
LINE_TO, 12, 3.4,
LINE_TO, 10.49, 2,
LINE_TO, 4, 8,
R_LINE_TO, 6.49, 6,
LINE_TO, 12, 12.6,
LINE_TO, 7.03, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kLeadingScrollRepList, kLeadingScrollIcon, {kLeadingScrollPath})
VECTOR_ICON_REP_TEMPLATE(kLeftPanelClosePath, CANVAS_DIMENSIONS, 20,
FLIPS_IN_RTL,
MOVE_TO, 13.5, 13.25,
V_LINE_TO, 6.75,
LINE_TO, 10, 10,
LINE_TO, 13.5, 13.25,
CLOSE,
MOVE_TO, 4.4, 17,
CUBIC_TO, 4.01, 17, 3.68, 16.86, 3.41, 16.59,
CUBIC_TO, 3.14, 16.32, 3, 15.99, 3, 15.6,
V_LINE_TO, 4.4,
CUBIC_TO, 3, 4.01, 3.14, 3.68, 3.41, 3.41,
CUBIC_TO, 3.68, 3.14, 4.01, 3, 4.4, 3,
H_LINE_TO, 15.6,
CUBIC_TO, 15.99, 3, 16.32, 3.14, 16.59, 3.41,
CUBIC_TO, 16.86, 3.68, 17, 4.01, 17, 4.4,
V_LINE_TO, 15.6,
CUBIC_TO, 17, 15.99, 16.86, 16.32, 16.59, 16.59,
CUBIC_TO, 16.32, 16.86, 15.99, 17, 15.6, 17,
H_LINE_TO, 4.4,
CLOSE,
MOVE_TO, 7, 15.5,
V_LINE_TO, 4.5,
H_LINE_TO, 4.5,
V_LINE_TO, 15.5,
H_LINE_TO, 7,
CLOSE,
MOVE_TO, 8.5, 15.5,
H_LINE_TO, 15.5,
V_LINE_TO, 4.5,
H_LINE_TO, 8.5,
V_LINE_TO, 15.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kLeftPanelCloseRepList, kLeftPanelCloseIcon, {kLeftPanelClosePath})
VECTOR_ICON_REP_TEMPLATE(kLinkChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 9, 14,
H_LINE_TO, 6,
R_CUBIC_TO, -1.1, 0, -2.05, -0.39, -2.83, -1.17,
CUBIC_TO, 2.39, 12.05, 2, 11.1, 2, 10,
R_CUBIC_TO, 0, -1.11, 0.39, -2.05, 1.17, -2.83,
CUBIC_TO, 3.95, 6.39, 4.89, 6, 6, 6,
R_H_LINE_TO, 3,
R_V_LINE_TO, 1.5,
H_LINE_TO, 6,
R_CUBIC_TO, -0.69, 0, -1.28, 0.24, -1.77, 0.73,
ARC_TO, 2.4, 2.4, 0, 0, 0, 3.5, 10,
R_CUBIC_TO, 0, 0.7, 0.24, 1.29, 0.73, 1.77,
R_CUBIC_TO, 0.49, 0.49, 1.08, 0.73, 1.77, 0.73,
R_H_LINE_TO, 3,
CLOSE,
R_MOVE_TO, -2, -3.25,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 6,
R_V_LINE_TO, 1.5,
CLOSE,
MOVE_TO, 11, 14,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 3,
R_CUBIC_TO, 0.7, 0, 1.29, -0.24, 1.77, -0.73,
R_CUBIC_TO, 0.49, -0.48, 0.73, -1.07, 0.73, -1.77,
R_CUBIC_TO, 0, -0.69, -0.24, -1.28, -0.73, -1.77,
ARC_TO, 2.4, 2.4, 0, 0, 0, 14, 7.5,
R_H_LINE_TO, -3,
V_LINE_TO, 6,
R_H_LINE_TO, 3,
R_CUBIC_TO, 1.11, 0, 2.05, 0.39, 2.83, 1.17,
CUBIC_TO, 17.61, 7.95, 18, 8.9, 18, 10,
R_CUBIC_TO, 0, 1.11, -0.39, 2.05, -1.17, 2.83,
CUBIC_TO, 16.05, 13.61, 15.11, 14, 14, 14,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kLinkChromeRefresh16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 7.14, 11.34,
H_LINE_TO, 4.8,
R_CUBIC_TO, -0.92, 0, -1.71, -0.32, -2.36, -0.98,
R_ARC_TO, 3.21, 3.21, 0, 0, 1, -0.98, -2.36,
R_CUBIC_TO, 0, -0.92, 0.32, -1.71, 0.98, -2.36,
R_ARC_TO, 3.22, 3.22, 0, 0, 1, 2.36, -0.97,
R_H_LINE_TO, 2.34,
R_V_LINE_TO, 1.38,
H_LINE_TO, 4.8,
R_CUBIC_TO, -0.54, 0, -1, 0.19, -1.38, 0.57,
R_CUBIC_TO, -0.38, 0.38, -0.57, 0.84, -0.57, 1.38,
R_CUBIC_TO, 0, 0.54, 0.19, 1, 0.57, 1.38,
R_CUBIC_TO, 0.38, 0.38, 0.84, 0.57, 1.38, 0.57,
R_H_LINE_TO, 2.34,
CLOSE,
MOVE_TO, 5.51, 8.63,
V_LINE_TO, 7.37,
R_H_LINE_TO, 4.98,
R_V_LINE_TO, 1.27,
CLOSE,
R_MOVE_TO, 3.35, 2.7,
V_LINE_TO, 9.95,
R_H_LINE_TO, 2.34,
R_CUBIC_TO, 0.54, 0, 1, -0.19, 1.38, -0.57,
R_CUBIC_TO, 0.38, -0.38, 0.57, -0.84, 0.57, -1.38,
R_CUBIC_TO, 0, -0.54, -0.19, -1, -0.57, -1.38,
R_ARC_TO, 1.88, 1.88, 0, 0, 0, -1.38, -0.57,
H_LINE_TO, 8.86,
V_LINE_TO, 4.66,
R_H_LINE_TO, 2.34,
R_CUBIC_TO, 0.92, 0, 1.71, 0.32, 2.36, 0.98,
R_CUBIC_TO, 0.65, 0.65, 0.98, 1.44, 0.98, 2.36,
R_CUBIC_TO, 0, 0.92, -0.32, 1.71, -0.98, 2.36,
R_ARC_TO, 3.22, 3.22, 0, 0, 1, -2.36, 0.97,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kLinkChromeRefreshRepList, kLinkChromeRefreshIcon, {kLinkChromeRefreshPath}, {kLinkChromeRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kLogoutPath, CANVAS_DIMENSIONS, 960,
FILL_RULE_NONZERO,
MOVE_TO, 216, 816,
R_QUADRATIC_TO, -29.7, 0, -50.85, -21.15,
QUADRATIC_TO, 144, 773.7, 144, 744,
R_V_LINE_TO, -528,
R_QUADRATIC_TO, 0, -29.7, 21.15, -50.85,
QUADRATIC_TO, 186.3, 144, 216, 144,
R_H_LINE_TO, 264,
R_V_LINE_TO, 72,
H_LINE_TO, 216,
R_V_LINE_TO, 528,
R_H_LINE_TO, 264,
R_V_LINE_TO, 72,
H_LINE_TO, 216,
CLOSE,
R_MOVE_TO, 432, -168,
R_LINE_TO, -51, -51,
R_LINE_TO, 81, -81,
H_LINE_TO, 384,
R_V_LINE_TO, -72,
R_H_LINE_TO, 294,
R_LINE_TO, -81, -81,
R_LINE_TO, 51, -51,
R_LINE_TO, 168, 168,
R_LINE_TO, -168, 168,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kLogoutRepList, kLogoutIcon, {kLogoutPath})
VECTOR_ICON_REP_TEMPLATE(kMediaControlsArrowDropDownPath, CANVAS_DIMENSIONS, 24,
NEW_PATH,
MOVE_TO, 7, 10,
R_LINE_TO, 5, 5,
R_LINE_TO, 5, -5,
H_LINE_TO, 7,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaControlsArrowDropDownRepList, kMediaControlsArrowDropDownIcon, {kMediaControlsArrowDropDownPath})
VECTOR_ICON_REP_TEMPLATE(kMediaControlsArrowDropUpPath, CANVAS_DIMENSIONS, 24,
NEW_PATH,
MOVE_TO, 7, 14,
R_LINE_TO, 5, -5,
R_LINE_TO, 5, 5,
H_LINE_TO, 7,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaControlsArrowDropUpRepList, kMediaControlsArrowDropUpIcon, {kMediaControlsArrowDropUpPath})
VECTOR_ICON_REP_TEMPLATE(kMediaToolbarButtonChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 13, 15,
R_ARC_TO, 2.4, 2.4, 0, 0, 1, -1.77, -0.73,
R_ARC_TO, 2.4, 2.4, 0, 0, 1, -0.73, -1.77,
R_CUBIC_TO, 0, -0.69, 0.24, -1.28, 0.73, -1.77,
ARC_TO, 2.4, 2.4, 0, 0, 1, 13, 10,
R_ARC_TO, 2.46, 2.46, 0, 0, 1, 1, 0.21,
V_LINE_TO, 4,
R_H_LINE_TO, 4,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, -2.5,
R_V_LINE_TO, 7,
R_CUBIC_TO, 0, 0.7, -0.24, 1.29, -0.73, 1.77,
ARC_TO, 2.4, 2.4, 0, 0, 1, 13, 15,
CLOSE,
MOVE_TO, 3, 11.5,
V_LINE_TO, 10,
R_H_LINE_TO, 6,
R_V_LINE_TO, 1.5,
CLOSE,
R_MOVE_TO, 0, -3,
V_LINE_TO, 7,
R_H_LINE_TO, 9,
R_V_LINE_TO, 1.5,
CLOSE,
R_MOVE_TO, 0, -3,
V_LINE_TO, 4,
R_H_LINE_TO, 9,
R_V_LINE_TO, 1.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaToolbarButtonChromeRefreshRepList, kMediaToolbarButtonChromeRefreshIcon, {kMediaToolbarButtonChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kMediaToolbarButtonTouchPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 23, 3,
R_ARC_TO, 1, 1, 0, 0, 1, 0, 2,
R_H_LINE_TO, -3,
LINE_TO, 20, 17,
R_CUBIC_TO, -0.04, 2.27, -1.43, 4, -3.5, 4,
R_ARC_TO, 3.75, 3.75, 0, 1, 1, 1.5, -7.19,
LINE_TO, 18, 4.13,
R_LINE_TO, 0, -0.07,
ARC_TO, 1, 1, 0, 0, 1, 19, 3,
R_H_LINE_TO, 4,
CLOSE,
MOVE_TO, 10.33, 15,
R_ARC_TO, 4.71, 4.71, 0, 0, 0, -0.57, 2,
H_LINE_TO, 1,
R_ARC_TO, 1, 1, 0, 0, 1, 0, -2,
R_H_LINE_TO, 9.33,
CLOSE,
MOVE_TO, 14, 9,
R_ARC_TO, 1, 1, 0, 0, 1, 0, 2,
H_LINE_TO, 1,
R_ARC_TO, 1, 1, 0, 1, 1, 0, -2,
R_H_LINE_TO, 13,
CLOSE,
R_MOVE_TO, 0, -6,
R_ARC_TO, 1, 1, 0, 0, 1, 0, 2,
H_LINE_TO, 1,
R_ARC_TO, 1, 1, 0, 1, 1, 0, -2,
R_H_LINE_TO, 13,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaToolbarButtonTouchRepList, kMediaToolbarButtonTouchIcon, {kMediaToolbarButtonTouchPath})
VECTOR_ICON_REP_TEMPLATE(kMenuBookChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 11.75, 7.96,
V_LINE_TO, 6.38,
R_CUBIC_TO, 0.43, -0.14, 0.88, -0.24, 1.33, -0.3,
R_CUBIC_TO, 0.46, -0.06, 0.93, -0.09, 1.42, -0.09,
R_CUBIC_TO, 0.32, 0, 0.64, 0.02, 0.97, 0.05,
R_CUBIC_TO, 0.33, 0.04, 0.67, 0.09, 1.03, 0.16,
V_LINE_TO, 7.73,
R_ARC_TO, 11.87, 11.87, 0, 0, 0, -1.1, -0.21,
R_ARC_TO, 7.39, 7.39, 0, 0, 0, -0.89, -0.06,
R_CUBIC_TO, -0.47, 0, -0.94, 0.04, -1.39, 0.13,
R_CUBIC_TO, -0.46, 0.09, -0.91, 0.21, -1.35, 0.38,
CLOSE,
R_MOVE_TO, 0, 4.92,
R_V_LINE_TO, -1.58,
R_CUBIC_TO, 0.39, -0.12, 0.81, -0.23, 1.25, -0.3,
R_ARC_TO, 9.16, 9.16, 0, 0, 1, 1.5, -0.11,
R_CUBIC_TO, 0.38, 0, 0.73, 0.02, 1.05, 0.06,
R_CUBIC_TO, 0.33, 0.04, 0.65, 0.1, 0.95, 0.17,
R_V_LINE_TO, 1.54,
R_ARC_TO, 11.73, 11.73, 0, 0, 0, -1.1, -0.21,
R_ARC_TO, 6.68, 6.68, 0, 0, 0, -0.89, -0.06,
R_CUBIC_TO, -0.47, 0, -0.94, 0.04, -1.39, 0.13,
R_CUBIC_TO, -0.46, 0.08, -0.91, 0.21, -1.35, 0.38,
CLOSE,
R_MOVE_TO, 0, -2.46,
V_LINE_TO, 8.83,
R_ARC_TO, 9.45, 9.45, 0, 0, 1, 1.36, -0.31,
R_CUBIC_TO, 0.47, -0.07, 0.93, -0.1, 1.39, -0.1,
R_CUBIC_TO, 0.38, 0, 0.73, 0.02, 1.05, 0.06,
R_CUBIC_TO, 0.33, 0.04, 0.65, 0.1, 0.95, 0.17,
R_V_LINE_TO, 1.54,
R_ARC_TO, 7.19, 7.19, 0, 0, 0, -1.03, -0.21,
R_ARC_TO, 7.42, 7.42, 0, 0, 0, -2.31, 0.06,
R_ARC_TO, 9.42, 9.42, 0, 0, 0, -1.41, 0.38,
CLOSE,
MOVE_TO, 5.5, 14,
R_CUBIC_TO, 0.65, 0, 1.29, 0.08, 1.92, 0.25,
R_CUBIC_TO, 0.63, 0.17, 1.23, 0.38, 1.83, 0.63,
V_LINE_TO, 5.42,
R_ARC_TO, 7.79, 7.79, 0, 0, 0, -1.81, -0.69,
ARC_TO, 8.15, 8.15, 0, 0, 0, 5.5, 4.5,
R_CUBIC_TO, -0.52, 0, -1.02, 0.05, -1.53, 0.14,
R_ARC_TO, 6.44, 6.44, 0, 0, 0, -1.47, 0.45,
V_LINE_TO, 14.5,
R_CUBIC_TO, 0.48, -0.18, 0.98, -0.31, 1.48, -0.39,
CUBIC_TO, 4.48, 14.04, 4.98, 14, 5.5, 14,
CLOSE,
R_MOVE_TO, 5.25, 0.88,
R_ARC_TO, 9.92, 9.92, 0, 0, 1, 1.83, -0.64,
ARC_TO, 8.08, 8.08, 0, 0, 1, 14.5, 14,
R_CUBIC_TO, 0.52, 0, 1.02, 0.03, 1.53, 0.09,
R_CUBIC_TO, 0.51, 0.06, 1, 0.2, 1.47, 0.41,
V_LINE_TO, 5.08,
R_CUBIC_TO, -0.48, -0.18, -0.98, -0.32, -1.48, -0.43,
ARC_TO, 7.32, 7.32, 0, 0, 0, 14.5, 4.5,
R_CUBIC_TO, -0.67, 0, -1.31, 0.08, -1.94, 0.23,
R_ARC_TO, 7.79, 7.79, 0, 0, 0, -1.81, 0.69,
CLOSE,
MOVE_TO, 10, 17,
R_ARC_TO, 10.62, 10.62, 0, 0, 0, -2.14, -1.08,
ARC_TO, 6.74, 6.74, 0, 0, 0, 5.5, 15.5,
R_CUBIC_TO, -0.53, 0, -1.05, 0.05, -1.58, 0.16,
R_ARC_TO, 7.82, 7.82, 0, 0, 0, -1.52, 0.47,
R_ARC_TO, 0.97, 0.97, 0, 0, 1, -0.95, -0.07,
R_ARC_TO, 0.91, 0.91, 0, 0, 1, -0.45, -0.82,
V_LINE_TO, 4.75,
R_CUBIC_TO, 0, -0.19, 0.05, -0.37, 0.16, -0.54,
R_CUBIC_TO, 0.11, -0.16, 0.25, -0.29, 0.43, -0.37,
ARC_TO, 9.82, 9.82, 0, 0, 1, 3.5, 3.21,
R_ARC_TO, 9.73, 9.73, 0, 0, 1, 4.32, 0.07,
R_CUBIC_TO, 0.75, 0.19, 1.48, 0.47, 2.18, 0.84,
R_ARC_TO, 10.63, 10.63, 0, 0, 1, 2.19, -0.83,
ARC_TO, 9.13, 9.13, 0, 0, 1, 14.5, 3,
R_CUBIC_TO, 0.68, 0, 1.35, 0.07, 2, 0.21,
R_CUBIC_TO, 0.65, 0.14, 1.29, 0.35, 1.92, 0.63,
R_CUBIC_TO, 0.18, 0.09, 0.32, 0.21, 0.44, 0.38,
R_CUBIC_TO, 0.11, 0.17, 0.17, 0.35, 0.17, 0.54,
R_V_LINE_TO, 10.48,
R_CUBIC_TO, 0, 0.35, -0.11, 0.63, -0.32, 0.83,
R_CUBIC_TO, -0.22, 0.21, -0.44, 0.26, -0.68, 0.14,
R_ARC_TO, 7.5, 7.5, 0, 0, 0, -1.72, -0.54,
R_ARC_TO, 9.54, 9.54, 0, 0, 0, -1.8, -0.17,
R_CUBIC_TO, -0.82, 0, -1.6, 0.14, -2.35, 0.42,
R_CUBIC_TO, -0.75, 0.28, -1.46, 0.64, -2.14, 1.08,
CLOSE,
MOVE_TO, 5.9, 9.69,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMenuBookChromeRefreshRepList, kMenuBookChromeRefreshIcon, {kMenuBookChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kMixedContentPath, MOVE_TO, 26, 4,
LINE_TO, 10, 11.27,
LINE_TO, 10, 22.18,
CUBIC_TO, 10, 32.27, 16.83, 41.71, 26, 44,
CUBIC_TO, 35.17, 41.71, 42, 32.27, 42, 22.18,
LINE_TO, 42, 11.27,
LINE_TO, 26, 4,
LINE_TO, 26, 4,
CLOSE,
MOVE_TO, 26, 8,
LINE_TO, 39, 14,
LINE_TO, 39, 22.11,
CUBIC_TO, 39, 29.93, 33.34, 38.22, 26, 40,
LINE_TO, 26, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMixedContentRepList, kMixedContentIcon, {kMixedContentPath})
VECTOR_ICON_REP_TEMPLATE(kMoreToolsMenuPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 8, 9.23,
CLOSE,
R_MOVE_TO, -5.73, 3.7,
V_LINE_TO, 6.91,
R_CUBIC_TO, 0, -0.38, 0.13, -0.71, 0.4, -0.98,
R_ARC_TO, 1.35, 1.35, 0, 0, 1, 0.98, -0.4,
R_H_LINE_TO, 1.42,
V_LINE_TO, 4.45,
R_CUBIC_TO, 0, -0.39, 0.13, -0.71, 0.4, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.4, 0.98, -0.4,
R_H_LINE_TO, 3.1,
R_CUBIC_TO, 0.38, 0, 0.71, 0.13, 0.98, 0.4,
R_CUBIC_TO, 0.27, 0.27, 0.4, 0.6, 0.4, 0.98,
R_V_LINE_TO, 1.08,
R_H_LINE_TO, 1.42,
R_CUBIC_TO, 0.38, 0, 0.71, 0.14, 0.98, 0.41,
R_CUBIC_TO, 0.27, 0.27, 0.4, 0.59, 0.4, 0.98,
R_V_LINE_TO, 6.02,
CLOSE,
MOVE_TO, 6.15, 9.91,
R_V_LINE_TO, 0.6,
H_LINE_TO, 4.77,
V_LINE_TO, 9.91,
H_LINE_TO, 3.65,
R_V_LINE_TO, 1.64,
R_H_LINE_TO, 8.7,
V_LINE_TO, 9.91,
H_LINE_TO, 11.23,
R_V_LINE_TO, 0.6,
H_LINE_TO, 9.85,
V_LINE_TO, 9.91,
CLOSE,
R_MOVE_TO, -2.5, -3,
R_V_LINE_TO, 1.64,
H_LINE_TO, 4.77,
R_V_LINE_TO, -0.6,
R_H_LINE_TO, 1.38,
R_V_LINE_TO, 0.6,
R_H_LINE_TO, 3.7,
R_V_LINE_TO, -0.6,
R_H_LINE_TO, 1.38,
R_V_LINE_TO, 0.6,
R_H_LINE_TO, 1.12,
V_LINE_TO, 6.91,
CLOSE,
MOVE_TO, 6.45, 5.53,
R_H_LINE_TO, 3.1,
V_LINE_TO, 4.45,
H_LINE_TO, 6.45,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMoreToolsMenuRepList, kMoreToolsMenuIcon, {kMoreToolsMenuPath})
VECTOR_ICON_REP_TEMPLATE(kMoveGroupToNewWindowRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 6.5, 15,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 5, 13.5,
R_V_LINE_TO, -2,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 2,
R_H_LINE_TO, 10,
V_LINE_TO, 5,
R_H_LINE_TO, -10,
R_V_LINE_TO, 2,
H_LINE_TO, 5,
V_LINE_TO, 3.5,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 6.5, 2,
R_H_LINE_TO, 10,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 10,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 16.5, 15,
CLOSE,
R_MOVE_TO, -3, 3,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 2, 16.5,
V_LINE_TO, 5,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 11.5,
H_LINE_TO, 15,
V_LINE_TO, 18,
CLOSE,
R_MOVE_TO, 7.25, -5.5,
R_LINE_TO, -1.06, -1.06,
LINE_TO, 11.13, 10,
H_LINE_TO, 5,
V_LINE_TO, 8.5,
R_H_LINE_TO, 6.13,
LINE_TO, 9.69, 7.06,
LINE_TO, 10.75, 6,
LINE_TO, 14, 9.25,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kMoveGroupToNewWindowRefresh16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 5.34, 12.04,
R_CUBIC_TO, -0.38, 0, -0.71, -0.13, -0.98, -0.4,
R_ARC_TO, 1.34, 1.34, 0, 0, 1, -0.4, -0.98,
V_LINE_TO, 9.14,
H_LINE_TO, 5.34,
R_V_LINE_TO, 1.52,
R_H_LINE_TO, 7.9,
V_LINE_TO, 3.91,
H_LINE_TO, 5.34,
R_V_LINE_TO, 1.52,
H_LINE_TO, 3.96,
V_LINE_TO, 2.76,
R_CUBIC_TO, 0, -0.39, 0.13, -0.71, 0.4, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.41, 0.98, -0.41,
R_H_LINE_TO, 7.9,
R_CUBIC_TO, 0.39, 0, 0.71, 0.14, 0.98, 0.41,
R_CUBIC_TO, 0.27, 0.27, 0.41, 0.59, 0.41, 0.98,
R_V_LINE_TO, 7.9,
R_CUBIC_TO, 0, 0.38, -0.14, 0.71, -0.41, 0.98,
R_ARC_TO, 1.33, 1.33, 0, 0, 1, -0.98, 0.4,
CLOSE,
R_MOVE_TO, -2.58, 2.59,
R_CUBIC_TO, -0.39, 0, -0.71, -0.14, -0.98, -0.41,
R_ARC_TO, 1.33, 1.33, 0, 0, 1, -0.41, -0.98,
V_LINE_TO, 3.96,
R_H_LINE_TO, 1.39,
R_V_LINE_TO, 9.29,
R_H_LINE_TO, 9.29,
R_V_LINE_TO, 1.39,
CLOSE,
R_MOVE_TO, 6, -4.67,
R_LINE_TO, -0.92, -0.92,
R_LINE_TO, 1.1, -1.1,
R_H_LINE_TO, -4.98,
V_LINE_TO, 6.63,
R_H_LINE_TO, 4.98,
LINE_TO, 7.84, 5.54,
R_LINE_TO, 0.92, -0.92,
R_LINE_TO, 2.67, 2.67,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMoveGroupToNewWindowRefreshRepList, kMoveGroupToNewWindowRefreshIcon, {kMoveGroupToNewWindowRefreshPath}, {kMoveGroupToNewWindowRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kMyLocationPath, MOVE_TO, 24, 16,
R_CUBIC_TO, -4.42, 0, -8, 3.58, -8, 8,
R_CUBIC_TO, 0, 4.42, 3.58, 8, 8, 8,
R_CUBIC_TO, 4.42, 0, 8, -3.58, 8, -8,
R_CUBIC_TO, 0, -4.42, -3.58, -8, -8, -8,
CLOSE,
R_MOVE_TO, 17.88, 6,
CUBIC_TO, 40.96, 13.66, 34.34, 7.04, 26, 6.12,
V_LINE_TO, 2,
R_H_LINE_TO, -4,
R_V_LINE_TO, 4.12,
CUBIC_TO, 13.66, 7.04, 7.04, 13.66, 6.12, 22,
H_LINE_TO, 2,
R_V_LINE_TO, 4,
R_H_LINE_TO, 4.12,
R_CUBIC_TO, 0.92, 8.34, 7.54, 14.96, 15.88, 15.88,
V_LINE_TO, 46,
R_H_LINE_TO, 4,
R_V_LINE_TO, -4.12,
R_CUBIC_TO, 8.34, -0.92, 14.96, -7.54, 15.88, -15.88,
H_LINE_TO, 46,
R_V_LINE_TO, -4,
R_H_LINE_TO, -4.12,
CLOSE,
MOVE_TO, 24, 38,
R_CUBIC_TO, -7.73, 0, -14, -6.27, -14, -14,
R_CUBIC_TO, 0, -7.73, 6.27, -14, 14, -14,
R_CUBIC_TO, 7.73, 0, 14, 6.27, 14, 14,
R_CUBIC_TO, 0, 7.73, -6.27, 14, -14, 14,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMyLocationRepList, kMyLocationIcon, {kMyLocationPath})
VECTOR_ICON_REP_TEMPLATE(kNameWindowPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 2.85, 12.93,
R_CUBIC_TO, -0.38, 0, -0.71, -0.13, -0.98, -0.4,
R_ARC_TO, 1.34, 1.34, 0, 0, 1, -0.4, -0.98,
V_LINE_TO, 4.44,
R_CUBIC_TO, 0, -0.38, 0.13, -0.71, 0.4, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.4, 0.98, -0.4,
R_H_LINE_TO, 10.31,
R_CUBIC_TO, 0.38, 0, 0.71, 0.13, 0.98, 0.4,
R_CUBIC_TO, 0.27, 0.27, 0.4, 0.6, 0.4, 0.98,
R_V_LINE_TO, 7.11,
R_CUBIC_TO, 0, 0.38, -0.13, 0.71, -0.4, 0.98,
R_CUBIC_TO, -0.27, 0.27, -0.6, 0.4, -0.98, 0.4,
CLOSE,
R_MOVE_TO, 0, -1.38,
R_H_LINE_TO, 10.3,
V_LINE_TO, 5.73,
H_LINE_TO, 2.85,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNameWindowRepList, kNameWindowIcon, {kNameWindowPath})
VECTOR_ICON_REP_TEMPLATE(kNavigateHomePath, CANVAS_DIMENSIONS, 32,
MOVE_TO, 9, 14.46,
LINE_TO, 16, 7.63,
LINE_TO, 23, 14.46,
LINE_TO, 23, 25.13,
LINE_TO, 23, 25.13,
LINE_TO, 23, 26,
LINE_TO, 22.13, 26,
LINE_TO, 9.73, 26,
LINE_TO, 9, 26,
LINE_TO, 9, 25.27,
LINE_TO, 9, 14.46,
LINE_TO, 9, 14.46,
CLOSE,
MOVE_TO, 6, 17.39,
LINE_TO, 5.86, 17.52,
CUBIC_TO, 5.21, 18.16, 4.15, 18.16, 3.49, 17.52,
CUBIC_TO, 2.84, 16.88, 2.84, 15.85, 3.49, 15.21,
LINE_TO, 13.63, 5.31,
LINE_TO, 16, 3,
LINE_TO, 18.37, 5.31,
LINE_TO, 28.51, 15.21,
CUBIC_TO, 29.16, 15.85, 29.16, 16.88, 28.51, 17.52,
CUBIC_TO, 27.85, 18.16, 26.79, 18.16, 26.14, 17.52,
LINE_TO, 26, 17.39,
LINE_TO, 26, 27,
CUBIC_TO, 26, 28.1, 25.1, 29, 24, 29,
LINE_TO, 8, 29,
CUBIC_TO, 6.9, 29, 6, 28.1, 6, 27,
LINE_TO, 6, 17.39,
LINE_TO, 6, 17.39,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kNavigateHome16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 3.35, 7,
LINE_TO, 8, 2.5,
LINE_TO, 12.65, 7,
LINE_TO, 12, 7,
LINE_TO, 12, 14,
LINE_TO, 4, 14,
LINE_TO, 4, 7,
LINE_TO, 3.35, 7,
LINE_TO, 3.35, 7,
CLOSE,
MOVE_TO, 2, 8.3,
LINE_TO, 1.54, 8.74,
CUBIC_TO, 1.19, 9.09, 0.62, 9.09, 0.26, 8.74,
CUBIC_TO, -0.09, 8.4, -0.09, 7.85, 0.26, 7.51,
LINE_TO, 8, 0,
LINE_TO, 15.74, 7.51,
CUBIC_TO, 16.09, 7.85, 16.09, 8.4, 15.74, 8.74,
CUBIC_TO, 15.38, 9.09, 14.81, 9.09, 14.46, 8.74,
LINE_TO, 14, 8.3,
LINE_TO, 14, 14.5,
CUBIC_TO, 14, 15.5, 13.5, 16, 12.5, 16,
LINE_TO, 3.5, 16,
CUBIC_TO, 2.5, 16, 2, 15.5, 2, 14.5,
LINE_TO, 2, 8.3,
LINE_TO, 2, 8.3,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNavigateHomeRepList, kNavigateHomeIcon, {kNavigateHomePath}, {kNavigateHome16Path})
VECTOR_ICON_REP_TEMPLATE(kNavigateHomeChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 5.5, 15.5,
R_H_LINE_TO, 2,
R_V_LINE_TO, -5,
R_H_LINE_TO, 5,
R_V_LINE_TO, 5,
R_H_LINE_TO, 2,
V_LINE_TO, 8.25,
LINE_TO, 10, 4.88,
LINE_TO, 5.5, 8.25,
CLOSE,
MOVE_TO, 4, 17,
V_LINE_TO, 7.5,
LINE_TO, 10, 3,
R_LINE_TO, 6, 4.5,
V_LINE_TO, 17,
R_H_LINE_TO, -5,
R_V_LINE_TO, -5,
H_LINE_TO, 9,
R_V_LINE_TO, 5,
CLOSE,
R_MOVE_TO, 6, -6.81,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNavigateHomeChromeRefreshRepList, kNavigateHomeChromeRefreshIcon, {kNavigateHomeChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kNavigateHomeTouchPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 12.87, 3.54,
CUBIC_TO, 12.67, 3.33, 12.33, 3, 12, 3,
R_CUBIC_TO, -0.33, 0, -0.67, 0.33, -0.87, 0.54,
R_LINE_TO, -7.89, 7.84,
ARC_TO, 0.98, 0.98, 0, 0, 0, 3, 12,
R_ARC_TO, 1, 1, 0, 0, 0, 1, 1,
R_CUBIC_TO, 0.24, 0, 0.45, -0.09, 0.62, -0.24,
R_LINE_TO, 0.38, -0.35,
V_LINE_TO, 19,
R_ARC_TO, 2, 2, 0, 0, 0, 2, 2,
R_H_LINE_TO, 10,
R_ARC_TO, 2, 2, 0, 0, 0, 2, -2,
R_V_LINE_TO, -6.59,
R_LINE_TO, 0.38, 0.35,
ARC_TO, 0.98, 0.98, 0, 0, 0, 20, 13,
R_ARC_TO, 1, 1, 0, 0, 0, 1, -1,
R_ARC_TO, 0.98, 0.98, 0, 0, 0, -0.24, -0.62,
R_CUBIC_TO, 0, 0, -5.91, -5.88, -7.89, -7.84,
CLOSE,
MOVE_TO, 7, 19,
R_V_LINE_TO, -8.85,
LINE_TO, 12, 5,
R_LINE_TO, 5, 5.15,
V_LINE_TO, 19,
H_LINE_TO, 7,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNavigateHomeTouchRepList, kNavigateHomeTouchIcon, {kNavigateHomeTouchPath})
VECTOR_ICON_REP_TEMPLATE(kNavigateStopPath, CANVAS_DIMENSIONS, 32,
MOVE_TO, 16, 18.37,
LINE_TO, 6.86, 27.51,
CUBIC_TO, 6.21, 28.16, 5.15, 28.16, 4.49, 27.51,
CUBIC_TO, 3.84, 26.85, 3.84, 25.79, 4.49, 25.14,
LINE_TO, 13.63, 16,
LINE_TO, 4.49, 6.86,
CUBIC_TO, 3.84, 6.21, 3.84, 5.15, 4.49, 4.49,
CUBIC_TO, 5.15, 3.84, 6.21, 3.84, 6.86, 4.49,
LINE_TO, 16, 13.63,
LINE_TO, 25.14, 4.49,
CUBIC_TO, 25.79, 3.84, 26.85, 3.84, 27.51, 4.49,
CUBIC_TO, 28.16, 5.15, 28.16, 6.21, 27.51, 6.86,
LINE_TO, 18.37, 16,
LINE_TO, 27.51, 25.14,
CUBIC_TO, 28.16, 25.79, 28.16, 26.85, 27.51, 27.51,
CUBIC_TO, 26.85, 28.16, 25.79, 28.16, 25.14, 27.51,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kNavigateStop16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 8, 9.19,
LINE_TO, 3.43, 13.75,
CUBIC_TO, 3.1, 14.08, 2.57, 14.08, 2.25, 13.75,
CUBIC_TO, 1.92, 13.43, 1.92, 12.9, 2.25, 12.57,
LINE_TO, 6.81, 8,
LINE_TO, 2.25, 3.43,
CUBIC_TO, 1.92, 3.1, 1.92, 2.57, 2.25, 2.25,
CUBIC_TO, 2.57, 1.92, 3.1, 1.92, 3.43, 2.25,
LINE_TO, 8, 6.81,
LINE_TO, 12.57, 2.25,
CUBIC_TO, 12.9, 1.92, 13.43, 1.92, 13.75, 2.25,
CUBIC_TO, 14.08, 2.57, 14.08, 3.1, 13.75, 3.43,
LINE_TO, 9.19, 8,
LINE_TO, 13.75, 12.57,
CUBIC_TO, 14.08, 12.9, 14.08, 13.43, 13.75, 13.75,
CUBIC_TO, 13.43, 14.08, 12.9, 14.08, 12.57, 13.75,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNavigateStopRepList, kNavigateStopIcon, {kNavigateStopPath}, {kNavigateStop16Path})
VECTOR_ICON_REP_TEMPLATE(kNavigateStopChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 6.06, 15,
LINE_TO, 5, 13.94,
LINE_TO, 8.94, 10,
LINE_TO, 5, 6.06,
LINE_TO, 6.06, 5,
LINE_TO, 10, 8.94,
LINE_TO, 13.94, 5,
LINE_TO, 15, 6.06,
LINE_TO, 11.06, 10,
LINE_TO, 15, 13.94,
LINE_TO, 13.94, 15,
LINE_TO, 10, 11.06,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNavigateStopChromeRefreshRepList, kNavigateStopChromeRefreshIcon, {kNavigateStopChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kNavigateStopTouchPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 17.51, 5,
R_LINE_TO, 0.09, 0.09,
R_ARC_TO, 1, 1, 0, 0, 1, 1.32, 1.32,
R_LINE_TO, 0.09, 0.09,
LINE_TO, 14.49, 11,
R_LINE_TO, -0.99, 1,
R_LINE_TO, 0.99, 1,
LINE_TO, 19, 17.51,
R_LINE_TO, -0.09, 0.09,
R_ARC_TO, 1, 1, 0, 0, 1, -1.32, 1.32,
R_LINE_TO, -0.09, 0.09,
LINE_TO, 12, 13.5,
LINE_TO, 6.49, 19,
R_LINE_TO, -0.09, -0.09,
R_ARC_TO, 1, 1, 0, 0, 1, -1.32, -1.32,
LINE_TO, 5, 17.51,
LINE_TO, 9.51, 13,
R_LINE_TO, 0.99, -1,
R_LINE_TO, -0.99, -1,
LINE_TO, 5, 6.49,
R_LINE_TO, 0.09, -0.09,
R_ARC_TO, 1, 1, 0, 0, 1, 1.32, -1.32,
LINE_TO, 6.5, 5,
LINE_TO, 12, 10.51,
LINE_TO, 17.51, 5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNavigateStopTouchRepList, kNavigateStopTouchIcon, {kNavigateStopTouchPath})
VECTOR_ICON_REP_TEMPLATE(kNewTabInGroupRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 10.75, 12,
R_H_LINE_TO, 1.5,
V_LINE_TO, 9.25,
H_LINE_TO, 15,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, -2.75,
V_LINE_TO, 5,
R_H_LINE_TO, -1.5,
R_V_LINE_TO, 2.75,
H_LINE_TO, 8,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, 2.75,
CLOSE,
MOVE_TO, 6.5, 15,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 5, 13.5,
R_V_LINE_TO, -10,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 6.5, 2,
R_H_LINE_TO, 10,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 10,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 16.5, 15,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_H_LINE_TO, 10,
R_V_LINE_TO, -10,
R_H_LINE_TO, -10,
CLOSE,
R_MOVE_TO, -3, 4.5,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 2, 16.5,
V_LINE_TO, 5,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 11.5,
H_LINE_TO, 15,
V_LINE_TO, 18,
CLOSE,
R_MOVE_TO, 3, -14.5,
R_V_LINE_TO, 10,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kNewTabInGroupRefresh16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 8.69, 9.51,
R_H_LINE_TO, 1.2,
R_V_LINE_TO, -2.2,
R_H_LINE_TO, 2.2,
V_LINE_TO, 6.11,
R_H_LINE_TO, -2.2,
V_LINE_TO, 3.91,
H_LINE_TO, 8.69,
R_V_LINE_TO, 2.2,
H_LINE_TO, 6.49,
R_V_LINE_TO, 1.2,
R_H_LINE_TO, 2.2,
CLOSE,
MOVE_TO, 5.34, 12.04,
R_CUBIC_TO, -0.38, 0, -0.71, -0.13, -0.98, -0.4,
R_ARC_TO, 1.34, 1.34, 0, 0, 1, -0.4, -0.98,
V_LINE_TO, 2.76,
R_CUBIC_TO, 0, -0.39, 0.13, -0.71, 0.4, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.41, 0.98, -0.41,
R_H_LINE_TO, 7.9,
R_CUBIC_TO, 0.39, 0, 0.71, 0.14, 0.98, 0.41,
R_CUBIC_TO, 0.27, 0.27, 0.41, 0.59, 0.41, 0.98,
R_V_LINE_TO, 7.9,
R_CUBIC_TO, 0, 0.38, -0.14, 0.71, -0.41, 0.98,
R_ARC_TO, 1.33, 1.33, 0, 0, 1, -0.98, 0.4,
CLOSE,
R_MOVE_TO, 0, -1.38,
R_H_LINE_TO, 7.9,
V_LINE_TO, 2.76,
H_LINE_TO, 5.34,
CLOSE,
MOVE_TO, 2.76, 14.63,
R_CUBIC_TO, -0.39, 0, -0.71, -0.14, -0.98, -0.41,
R_ARC_TO, 1.33, 1.33, 0, 0, 1, -0.41, -0.98,
V_LINE_TO, 3.96,
R_H_LINE_TO, 1.39,
R_V_LINE_TO, 9.29,
R_H_LINE_TO, 9.29,
R_V_LINE_TO, 1.39,
CLOSE,
MOVE_TO, 5.34, 2.76,
R_V_LINE_TO, 7.9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNewTabInGroupRefreshRepList, kNewTabInGroupRefreshIcon, {kNewTabInGroupRefreshPath}, {kNewTabInGroupRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kNewTabRefreshPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 2.85, 11.55,
R_H_LINE_TO, 10.3,
V_LINE_TO, 7.2,
H_LINE_TO, 8.8,
V_LINE_TO, 4.45,
H_LINE_TO, 2.85,
CLOSE,
R_MOVE_TO, 0, 1.38,
R_CUBIC_TO, -0.38, 0, -0.71, -0.13, -0.98, -0.4,
R_ARC_TO, 1.34, 1.34, 0, 0, 1, -0.4, -0.98,
V_LINE_TO, 4.44,
R_CUBIC_TO, 0, -0.38, 0.13, -0.71, 0.4, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.4, 0.98, -0.4,
R_H_LINE_TO, 10.31,
R_CUBIC_TO, 0.38, 0, 0.71, 0.13, 0.98, 0.4,
R_CUBIC_TO, 0.27, 0.27, 0.4, 0.6, 0.4, 0.98,
R_V_LINE_TO, 7.11,
R_CUBIC_TO, 0, 0.38, -0.13, 0.71, -0.4, 0.98,
R_CUBIC_TO, -0.27, 0.27, -0.6, 0.4, -0.98, 0.4,
CLOSE,
R_MOVE_TO, 0, -1.38,
V_LINE_TO, 4.45,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNewTabRefreshRepList, kNewTabRefreshIcon, {kNewTabRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kNewWindowPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 3.65, 13.73,
R_CUBIC_TO, -0.38, 0, -0.71, -0.13, -0.98, -0.4,
R_ARC_TO, 1.34, 1.34, 0, 0, 1, -0.4, -0.98,
V_LINE_TO, 3.65,
R_CUBIC_TO, 0, -0.38, 0.13, -0.71, 0.4, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.4, 0.98, -0.4,
R_H_LINE_TO, 3.99,
R_V_LINE_TO, 1.38,
H_LINE_TO, 3.65,
R_V_LINE_TO, 8.7,
R_H_LINE_TO, 8.7,
V_LINE_TO, 8.37,
R_H_LINE_TO, 1.38,
R_V_LINE_TO, 3.99,
R_CUBIC_TO, 0, 0.39, -0.13, 0.71, -0.4, 0.98,
R_CUBIC_TO, -0.27, 0.27, -0.6, 0.4, -0.98, 0.4,
CLOSE,
R_MOVE_TO, 6.99, -6.57,
R_V_LINE_TO, -1.8,
H_LINE_TO, 8.83,
V_LINE_TO, 4.07,
R_H_LINE_TO, 1.8,
R_V_LINE_TO, -1.8,
R_H_LINE_TO, 1.3,
R_V_LINE_TO, 1.8,
R_H_LINE_TO, 1.8,
R_V_LINE_TO, 1.3,
R_H_LINE_TO, -1.8,
R_V_LINE_TO, 1.8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNewWindowRepList, kNewWindowIcon, {kNewWindowPath})
VECTOR_ICON_REP_TEMPLATE(kNotesPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 3, 18,
R_H_LINE_TO, 12,
R_V_LINE_TO, -2,
H_LINE_TO, 3,
R_V_LINE_TO, 2,
CLOSE,
MOVE_TO, 3, 6,
R_V_LINE_TO, 2,
R_H_LINE_TO, 18,
V_LINE_TO, 6,
H_LINE_TO, 3,
CLOSE,
R_MOVE_TO, 0, 7,
R_H_LINE_TO, 18,
R_V_LINE_TO, -2,
H_LINE_TO, 3,
R_V_LINE_TO, 2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNotesRepList, kNotesIcon, {kNotesPath})
VECTOR_ICON_REP_TEMPLATE(kOpenInBrowserPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 19, 4,
H_LINE_TO, 5,
R_ARC_TO, 2, 2, 0, 0, 0, -2, 2,
R_V_LINE_TO, 12,
R_ARC_TO, 2, 2, 0, 0, 0, 2, 2,
R_H_LINE_TO, 4,
R_V_LINE_TO, -2,
H_LINE_TO, 5,
V_LINE_TO, 8,
R_H_LINE_TO, 14,
R_V_LINE_TO, 10,
R_H_LINE_TO, -4,
R_V_LINE_TO, 2,
R_H_LINE_TO, 4,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
V_LINE_TO, 6,
R_ARC_TO, 2, 2, 0, 0, 0, -2, -2,
CLOSE,
R_MOVE_TO, -7, 6,
R_LINE_TO, -4, 4,
R_H_LINE_TO, 3,
R_V_LINE_TO, 6,
R_H_LINE_TO, 2,
R_V_LINE_TO, -6,
R_H_LINE_TO, 3,
R_LINE_TO, -4, -4,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kOpenInBrowser16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 3.65, 13.73,
R_CUBIC_TO, -0.38, 0, -0.71, -0.13, -0.98, -0.4,
R_ARC_TO, 1.34, 1.34, 0, 0, 1, -0.4, -0.98,
V_LINE_TO, 3.65,
R_CUBIC_TO, 0, -0.38, 0.13, -0.71, 0.4, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.4, 0.98, -0.4,
R_H_LINE_TO, 8.7,
R_CUBIC_TO, 0.38, 0, 0.71, 0.13, 0.98, 0.4,
R_CUBIC_TO, 0.27, 0.27, 0.4, 0.6, 0.4, 0.98,
R_V_LINE_TO, 8.7,
R_CUBIC_TO, 0, 0.38, -0.13, 0.71, -0.4, 0.98,
R_CUBIC_TO, -0.27, 0.27, -0.6, 0.4, -0.98, 0.4,
R_H_LINE_TO, -2.66,
R_V_LINE_TO, -1.38,
R_H_LINE_TO, 2.66,
V_LINE_TO, 4.91,
H_LINE_TO, 3.65,
R_V_LINE_TO, 7.44,
R_H_LINE_TO, 2.66,
R_V_LINE_TO, 1.38,
CLOSE,
R_MOVE_TO, 3.66, 0,
V_LINE_TO, 9.71,
R_LINE_TO, -0.89, 0.89,
R_LINE_TO, -0.98, -0.97,
LINE_TO, 8, 7.07,
R_LINE_TO, 2.56, 2.56,
R_LINE_TO, -0.98, 0.97,
R_LINE_TO, -0.89, -0.89,
R_V_LINE_TO, 4.03,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kOpenInBrowserRepList, kOpenInBrowserIcon, {kOpenInBrowserPath}, {kOpenInBrowser16Path})
VECTOR_ICON_REP_TEMPLATE(kOpenInFullPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 3, 21,
R_V_LINE_TO, -8,
R_H_LINE_TO, 2,
R_V_LINE_TO, 4.6,
LINE_TO, 17.6, 5,
H_LINE_TO, 13,
V_LINE_TO, 3,
R_H_LINE_TO, 8,
R_V_LINE_TO, 8,
R_H_LINE_TO, -2,
V_LINE_TO, 6.4,
LINE_TO, 6.4, 19,
H_LINE_TO, 11,
R_V_LINE_TO, 2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kOpenInFullRepList, kOpenInFullIcon, {kOpenInFullPath})
VECTOR_ICON_REP_TEMPLATE(kOpenInNewPath, MOVE_TO, 38, 38,
H_LINE_TO, 10,
V_LINE_TO, 10,
R_H_LINE_TO, 14,
V_LINE_TO, 6,
H_LINE_TO, 10,
R_CUBIC_TO, -2.21, 0, -4, 1.79, -4, 4,
R_V_LINE_TO, 28,
R_CUBIC_TO, 0, 2.21, 1.79, 4, 4, 4,
R_H_LINE_TO, 28,
R_CUBIC_TO, 2.21, 0, 4, -1.79, 4, -4,
V_LINE_TO, 24,
R_H_LINE_TO, -4,
R_V_LINE_TO, 14,
CLOSE,
MOVE_TO, 28, 6,
R_V_LINE_TO, 4,
R_H_LINE_TO, 7.17,
LINE_TO, 15.51, 29.66,
R_LINE_TO, 2.83, 2.83,
LINE_TO, 38, 12.83,
V_LINE_TO, 20,
R_H_LINE_TO, 4,
V_LINE_TO, 6,
H_LINE_TO, 28,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kOpenInNewRepList, kOpenInNewIcon, {kOpenInNewPath})
VECTOR_ICON_REP_TEMPLATE(kOpenInNewChromeRefreshPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 4.56, 17.17,
R_CUBIC_TO, -0.48, 0, -0.89, -0.17, -1.22, -0.5,
R_ARC_TO, 1.67, 1.67, 0, 0, 1, -0.5, -1.22,
V_LINE_TO, 4.56,
R_CUBIC_TO, 0, -0.48, 0.17, -0.89, 0.5, -1.22,
R_ARC_TO, 1.67, 1.67, 0, 0, 1, 1.22, -0.5,
H_LINE_TO, 10,
R_V_LINE_TO, 1.73,
H_LINE_TO, 4.56,
V_LINE_TO, 15.44,
H_LINE_TO, 15.44,
V_LINE_TO, 10,
R_H_LINE_TO, 1.73,
R_V_LINE_TO, 5.44,
R_CUBIC_TO, 0, 0.48, -0.17, 0.89, -0.5, 1.22,
R_ARC_TO, 1.67, 1.67, 0, 0, 1, -1.22, 0.5,
CLOSE,
MOVE_TO, 8.22, 13,
LINE_TO, 7, 11.78,
R_LINE_TO, 7.22, -7.22,
H_LINE_TO, 12,
V_LINE_TO, 2.83,
R_H_LINE_TO, 5.17,
V_LINE_TO, 8,
R_H_LINE_TO, -1.73,
V_LINE_TO, 5.78,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kOpenInNewChromeRefresh16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 3.72, 13.92,
R_ARC_TO, 1.58, 1.58, 0, 0, 1, -1.16, -0.48,
R_ARC_TO, 1.58, 1.58, 0, 0, 1, -0.48, -1.16,
R_V_LINE_TO, -8.57,
R_CUBIC_TO, 0, -0.46, 0.16, -0.84, 0.48, -1.16,
R_ARC_TO, 1.58, 1.58, 0, 0, 1, 1.16, -0.48,
H_LINE_TO, 8,
R_V_LINE_TO, 1.64,
H_LINE_TO, 3.72,
R_V_LINE_TO, 8.57,
R_H_LINE_TO, 8.57,
V_LINE_TO, 8,
R_H_LINE_TO, 1.64,
R_V_LINE_TO, 4.29,
R_CUBIC_TO, 0, 0.46, -0.16, 0.84, -0.48, 1.16,
R_ARC_TO, 1.58, 1.58, 0, 0, 1, -1.16, 0.48,
CLOSE,
R_MOVE_TO, 3.03, -3.52,
R_LINE_TO, -1.14, -1.14,
R_LINE_TO, 5.54, -5.54,
H_LINE_TO, 9.6,
V_LINE_TO, 2.08,
R_H_LINE_TO, 4.32,
R_V_LINE_TO, 4.32,
R_H_LINE_TO, -1.64,
V_LINE_TO, 4.86,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kOpenInNewChromeRefreshRepList, kOpenInNewChromeRefreshIcon, {kOpenInNewChromeRefreshPath}, {kOpenInNewChromeRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kOpenInNewOffChromeRefreshPath, CANVAS_DIMENSIONS, 20,
R_MOVE_TO, 16.19, 18.34,
R_LINE_TO, -1.17, -1.17,
R_CUBIC_TO, -0.02, 0, -0.03, 0, -0.04, 0,
H_LINE_TO, 4.56,
R_CUBIC_TO, -0.48, 0, -0.89, -0.17, -1.22, -0.5,
R_ARC_TO, 1.67, 1.67, 0, 0, 1, -0.5, -1.22,
V_LINE_TO, 5.02,
R_CUBIC_TO, 0, -0.01, 0, -0.02, 0, -0.04,
LINE_TO, 1.66, 3.81,
R_LINE_TO, 1.11, -1.11,
R_LINE_TO, 14.52, 14.52,
CLOSE,
MOVE_TO, 4.56, 15.44,
R_H_LINE_TO, 8.73,
R_LINE_TO, -3.75, -3.77,
LINE_TO, 8.22, 13,
LINE_TO, 7, 11.78,
R_LINE_TO, 1.33, -1.32,
R_LINE_TO, -3.77, -3.75,
CLOSE,
MOVE_TO, 6.86, 4.56,
LINE_TO, 5.14, 2.83,
H_LINE_TO, 10,
R_V_LINE_TO, 1.73,
CLOSE,
R_MOVE_TO, 4.88, 4.91,
R_LINE_TO, -1.22, -1.22,
R_LINE_TO, 3.69, -3.69,
H_LINE_TO, 12,
V_LINE_TO, 2.83,
R_H_LINE_TO, 5.17,
V_LINE_TO, 8,
R_H_LINE_TO, -1.73,
V_LINE_TO, 5.78,
CLOSE,
R_MOVE_TO, 5.42, 5.39,
R_LINE_TO, -1.73, -1.73,
V_LINE_TO, 10,
R_H_LINE_TO, 1.73,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kOpenInNewOffChromeRefreshRepList, kOpenInNewOffChromeRefreshIcon, {kOpenInNewOffChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kOverflowButtonPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 7.94, 10,
LINE_TO, 4, 6.06,
LINE_TO, 5.06, 5,
R_LINE_TO, 5, 5,
R_LINE_TO, -5, 5,
LINE_TO, 4, 13.94,
CLOSE,
R_MOVE_TO, 5.94, 0,
LINE_TO, 9.94, 6.06,
LINE_TO, 11, 5,
R_LINE_TO, 5, 5,
R_LINE_TO, -5, 5,
R_LINE_TO, -1.06, -1.06,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kOverflowButtonRepList, kOverflowButtonIcon, {kOverflowButtonPath})
VECTOR_ICON_REP_TEMPLATE(kOverflowButtonTouchPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 9.35, 12,
LINE_TO, 4.77, 7.4,
LINE_TO, 6.36, 5.81,
LINE_TO, 12.56, 12,
LINE_TO, 6.36, 18.19,
LINE_TO, 4.77, 16.6,
LINE_TO, 9.35, 12,
CLOSE,
MOVE_TO, 16.03, 12,
LINE_TO, 11.44, 7.4,
LINE_TO, 13.04, 5.81,
LINE_TO, 19.23, 12,
LINE_TO, 13.04, 18.19,
LINE_TO, 11.44, 16.6,
LINE_TO, 16.03, 12,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kOverflowButtonTouchRepList, kOverflowButtonTouchIcon, {kOverflowButtonTouchPath})
VECTOR_ICON_REP_TEMPLATE(kPaintbrushPath, MOVE_TO, 19.08, 26.09,
LINE_TO, 27.77, 34.8,
LINE_TO, 30.66, 31.9,
CUBIC_TO, 31.46, 31.09, 30.66, 28.99, 30.66, 28.99,
LINE_TO, 29.22, 24.63,
CUBIC_TO, 28.85, 23.54, 28.78, 22.17, 29.22, 21.73,
CUBIC_TO, 33.56, 17.37, 39.35, 14.47, 40.8, 13.01,
CUBIC_TO, 42.4, 11.41, 42.4, 8.81, 40.8, 7.2,
CUBIC_TO, 39.2, 5.6, 36.61, 5.6, 35.01, 7.2,
CUBIC_TO, 33.56, 8.66, 30.66, 14.47, 26.32, 18.82,
CUBIC_TO, 25.89, 19.26, 24.51, 19.19, 23.42, 18.82,
LINE_TO, 19.08, 17.37,
CUBIC_TO, 19.08, 17.37, 16.98, 16.57, 16.19, 17.37,
LINE_TO, 13.29, 20.28,
LINE_TO, 19.08, 26.09,
LINE_TO, 19.08, 26.09,
CLOSE,
MOVE_TO, 39.35, 8.66,
CUBIC_TO, 40.15, 9.46, 40.15, 10.77, 39.35, 11.57,
CUBIC_TO, 38.55, 12.37, 37.25, 12.37, 36.45, 11.57,
CUBIC_TO, 35.65, 10.77, 35.65, 9.46, 36.45, 8.66,
CUBIC_TO, 37.25, 7.86, 38.55, 7.86, 39.35, 8.66,
LINE_TO, 39.35, 8.66,
CLOSE,
MOVE_TO, 13.8, 35.83,
LINE_TO, 17.9, 35.83,
LINE_TO, 17.9, 39.94,
LINE_TO, 19.95, 42,
LINE_TO, 26.11, 35.83,
LINE_TO, 11.75, 21.43,
LINE_TO, 5.6, 27.6,
LINE_TO, 13.8, 35.83,
LINE_TO, 13.8, 35.83,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPaintbrushRepList, kPaintbrushIcon, {kPaintbrushPath})
VECTOR_ICON_REP_TEMPLATE(kPasswordFieldPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 2, 15,
V_LINE_TO, 13.5,
H_LINE_TO, 18,
V_LINE_TO, 15,
H_LINE_TO, 2,
CLOSE,
MOVE_TO, 2.9, 10.08,
LINE_TO, 1.6, 9.33,
LINE_TO, 2.21, 8.29,
H_LINE_TO, 1,
V_LINE_TO, 6.79,
H_LINE_TO, 2.21,
LINE_TO, 1.6, 5.75,
LINE_TO, 2.9, 5,
LINE_TO, 3.5, 6.04,
LINE_TO, 4.1, 5,
LINE_TO, 5.4, 5.75,
LINE_TO, 4.79, 6.79,
H_LINE_TO, 6,
V_LINE_TO, 8.29,
H_LINE_TO, 4.79,
LINE_TO, 5.4, 9.33,
LINE_TO, 4.1, 10.08,
LINE_TO, 3.5, 9.04,
LINE_TO, 2.9, 10.08,
CLOSE,
MOVE_TO, 9.4, 10.08,
LINE_TO, 8.1, 9.33,
LINE_TO, 8.71, 8.29,
H_LINE_TO, 7.5,
V_LINE_TO, 6.79,
H_LINE_TO, 8.71,
LINE_TO, 8.1, 5.75,
LINE_TO, 9.4, 5,
LINE_TO, 10, 6.04,
LINE_TO, 10.6, 5,
LINE_TO, 11.9, 5.75,
LINE_TO, 11.29, 6.79,
H_LINE_TO, 12.5,
V_LINE_TO, 8.29,
H_LINE_TO, 11.29,
LINE_TO, 11.9, 9.33,
LINE_TO, 10.6, 10.08,
LINE_TO, 10, 9.04,
LINE_TO, 9.4, 10.08,
CLOSE,
MOVE_TO, 15.9, 10.08,
LINE_TO, 14.6, 9.33,
LINE_TO, 15.21, 8.29,
H_LINE_TO, 14,
V_LINE_TO, 6.79,
H_LINE_TO, 15.21,
LINE_TO, 14.6, 5.75,
LINE_TO, 15.9, 5,
LINE_TO, 16.5, 6.04,
LINE_TO, 17.1, 5,
LINE_TO, 18.4, 5.75,
LINE_TO, 17.79, 6.79,
H_LINE_TO, 19,
V_LINE_TO, 8.29,
H_LINE_TO, 17.79,
LINE_TO, 18.4, 9.33,
LINE_TO, 17.1, 10.08,
LINE_TO, 16.5, 9.04,
LINE_TO, 15.9, 10.08,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPasswordFieldRepList, kPasswordFieldIcon, {kPasswordFieldPath})
VECTOR_ICON_REP_TEMPLATE(kPasteMenuPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 3.65, 13.73,
R_CUBIC_TO, -0.38, 0, -0.71, -0.13, -0.98, -0.41,
R_ARC_TO, 1.32, 1.32, 0, 0, 1, -0.41, -0.98,
V_LINE_TO, 3.65,
R_CUBIC_TO, 0, -0.38, 0.13, -0.71, 0.41, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.59, -0.41, 0.98, -0.41,
R_H_LINE_TO, 2.7,
R_CUBIC_TO, 0.11, -0.36, 0.3, -0.64, 0.61, -0.87,
R_CUBIC_TO, 0.3, -0.23, 0.65, -0.35, 1.05, -0.35,
R_CUBIC_TO, 0.39, 0, 0.74, 0.12, 1.04, 0.35,
R_CUBIC_TO, 0.3, 0.23, 0.51, 0.52, 0.61, 0.88,
R_H_LINE_TO, 2.7,
R_CUBIC_TO, 0.38, 0, 0.71, 0.13, 0.98, 0.41,
R_CUBIC_TO, 0.27, 0.27, 0.41, 0.59, 0.41, 0.98,
R_V_LINE_TO, 8.7,
R_CUBIC_TO, 0, 0.38, -0.13, 0.71, -0.41, 0.98,
R_CUBIC_TO, -0.27, 0.27, -0.59, 0.41, -0.98, 0.41,
CLOSE,
R_MOVE_TO, 0, -1.38,
R_H_LINE_TO, 8.7,
V_LINE_TO, 3.65,
H_LINE_TO, 11.18,
R_V_LINE_TO, 2.06,
H_LINE_TO, 4.82,
V_LINE_TO, 3.65,
H_LINE_TO, 3.65,
CLOSE,
MOVE_TO, 8, 3.59,
R_ARC_TO, 0.6, 0.6, 0, 0, 0, 0.43, -0.17,
R_ARC_TO, 0.58, 0.58, 0, 0, 0, 0.18, -0.43,
R_ARC_TO, 0.6, 0.6, 0, 0, 0, -0.17, -0.43,
R_ARC_TO, 0.58, 0.58, 0, 0, 0, -0.43, -0.17,
R_ARC_TO, 0.6, 0.6, 0, 0, 0, -0.43, 0.17,
R_ARC_TO, 0.58, 0.58, 0, 0, 0, -0.18, 0.43,
R_CUBIC_TO, 0, 0.17, 0.06, 0.31, 0.17, 0.43,
R_ARC_TO, 0.58, 0.58, 0, 0, 0, 0.43, 0.18,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPasteMenuRepList, kPasteMenuIcon, {kPasteMenuPath})
VECTOR_ICON_REP_TEMPLATE(kSaveCardAndVcnSuccessConfirmationPath, CANVAS_DIMENSIONS, 103,
PATH_COLOR_ARGB, 0xFF, 0x34, 0xA8, 0x53,
MOVE_TO, 48.29, 35.38,
CUBIC_TO, 36.13, 35.38, 26.27, 45.24, 26.27, 57.4,
CUBIC_TO, 26.27, 69.55, 36.13, 79.42, 48.29, 79.42,
CUBIC_TO, 60.44, 79.42, 70.3, 69.55, 70.3, 57.4,
CUBIC_TO, 70.3, 45.24, 60.44, 35.38, 48.29, 35.38,
CLOSE,
MOVE_TO, 43.88, 68.41,
LINE_TO, 35.08, 59.6,
LINE_TO, 38.16, 56.52,
LINE_TO, 43.88, 62.24,
LINE_TO, 58.41, 47.71,
LINE_TO, 61.5, 50.79,
LINE_TO, 43.88, 68.41,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x39, 0x82, 0xF8,
MOVE_TO, 76.53, 34.11,
CUBIC_TO, 78.54, 34.11, 80.18, 32.42, 80.18, 30.33,
CUBIC_TO, 80.18, 28.25, 78.54, 26.56, 76.53, 26.56,
CUBIC_TO, 74.52, 26.56, 72.89, 28.25, 72.89, 30.33,
CUBIC_TO, 72.89, 32.42, 74.52, 34.11, 76.53, 34.11,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xE8, 0xEA, 0xED,
MOVE_TO, 3.64, 70.92,
CUBIC_TO, 5.66, 70.92, 7.29, 69.23, 7.29, 67.15,
CUBIC_TO, 7.29, 65.06, 5.66, 63.37, 3.64, 63.37,
CUBIC_TO, 1.63, 63.37, 0, 65.06, 0, 67.15,
CUBIC_TO, 0, 69.23, 1.63, 70.92, 3.64, 70.92,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x34, 0xA8, 0x53,
MOVE_TO, 92.52, 83.11,
CUBIC_TO, 93.95, 83.58, 94.74, 85.15, 94.29, 86.63,
CUBIC_TO, 93.85, 88.11, 92.32, 88.94, 90.9, 88.47,
LINE_TO, 85.72, 86.79,
CUBIC_TO, 84.29, 86.33, 83.5, 84.75, 83.94, 83.27,
CUBIC_TO, 84.39, 81.79, 85.91, 80.97, 87.34, 81.43,
LINE_TO, 92.52, 83.11,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFB, 0xBC, 0x04,
MOVE_TO, 10.4, 27.22,
CUBIC_TO, 8.67, 25.5, 8.62, 22.66, 10.28, 20.87,
CUBIC_TO, 11.94, 19.08, 14.68, 19.03, 16.41, 20.75,
LINE_TO, 22.66, 26.98,
CUBIC_TO, 24.38, 28.7, 24.44, 31.54, 22.78, 33.33,
CUBIC_TO, 21.12, 35.12, 18.37, 35.17, 16.65, 33.45,
LINE_TO, 10.4, 27.22,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xEA, 0x43, 0x35,
MOVE_TO, 24.84, 87.96,
CUBIC_TO, 25.99, 86.79, 26.02, 84.88, 24.89, 83.68,
CUBIC_TO, 23.76, 82.48, 21.91, 82.45, 20.75, 83.62,
LINE_TO, 16.56, 87.86,
CUBIC_TO, 15.4, 89.02, 15.37, 90.94, 16.5, 92.14,
CUBIC_TO, 17.63, 93.34, 19.48, 93.37, 20.64, 92.2,
LINE_TO, 24.84, 87.96,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFB, 0xBC, 0x04,
MOVE_TO, 93.08, 55.06,
CUBIC_TO, 91.31, 55.99, 89.15, 55.26, 88.25, 53.43,
CUBIC_TO, 87.36, 51.6, 88.07, 49.36, 89.83, 48.43,
LINE_TO, 96.24, 45.07,
CUBIC_TO, 98.01, 44.14, 100.17, 44.87, 101.07, 46.7,
CUBIC_TO, 101.97, 48.53, 101.26, 50.77, 99.49, 51.7,
LINE_TO, 93.08, 55.06,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xE8, 0xEA, 0xED,
MOVE_TO, 49.06, 6.42,
CUBIC_TO, 49.05, 5.65, 49.89, 5.17, 50.55, 5.55,
LINE_TO, 61.56, 11.85,
CUBIC_TO, 62.22, 12.23, 62.23, 13.19, 61.56, 13.58,
LINE_TO, 50.61, 19.96,
CUBIC_TO, 49.94, 20.35, 49.11, 19.87, 49.11, 19.1,
LINE_TO, 49.06, 6.42,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xE8, 0xEA, 0xED,
MOVE_TO, 64.23, 94.97,
CUBIC_TO, 64.23, 95.74, 63.39, 96.22, 62.73, 95.84,
LINE_TO, 55.84, 91.86,
CUBIC_TO, 55.18, 91.48, 55.18, 90.52, 55.84, 90.13,
LINE_TO, 62.73, 86.16,
CUBIC_TO, 63.39, 85.77, 64.23, 86.25, 64.23, 87.02,
LINE_TO, 64.23, 94.97,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSaveCardAndVcnSuccessConfirmationRepList, kSaveCardAndVcnSuccessConfirmationIcon, {kSaveCardAndVcnSuccessConfirmationPath})
VECTOR_ICON_REP_TEMPLATE(kSaveCardAndVcnSuccessConfirmationDarkPath, CANVAS_DIMENSIONS, 103,
PATH_COLOR_ARGB, 0xFF, 0x81, 0xC9, 0x95,
MOVE_TO, 48.29, 35.38,
CUBIC_TO, 36.13, 35.38, 26.27, 45.24, 26.27, 57.4,
CUBIC_TO, 26.27, 69.55, 36.13, 79.42, 48.29, 79.42,
CUBIC_TO, 60.44, 79.42, 70.3, 69.55, 70.3, 57.4,
CUBIC_TO, 70.3, 45.24, 60.44, 35.38, 48.29, 35.38,
CLOSE,
MOVE_TO, 43.88, 68.41,
LINE_TO, 35.08, 59.6,
LINE_TO, 38.16, 56.52,
LINE_TO, 43.88, 62.24,
LINE_TO, 58.41, 47.71,
LINE_TO, 61.5, 50.79,
LINE_TO, 43.88, 68.41,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x8A, 0xB4, 0xF8,
MOVE_TO, 76.53, 34.11,
CUBIC_TO, 78.54, 34.11, 80.18, 32.42, 80.18, 30.33,
CUBIC_TO, 80.18, 28.25, 78.54, 26.56, 76.53, 26.56,
CUBIC_TO, 74.52, 26.56, 72.89, 28.25, 72.89, 30.33,
CUBIC_TO, 72.89, 32.42, 74.52, 34.11, 76.53, 34.11,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
MOVE_TO, 3.64, 70.92,
CUBIC_TO, 5.66, 70.92, 7.29, 69.23, 7.29, 67.15,
CUBIC_TO, 7.29, 65.06, 5.66, 63.37, 3.64, 63.37,
CUBIC_TO, 1.63, 63.37, 0, 65.06, 0, 67.15,
CUBIC_TO, 0, 69.23, 1.63, 70.92, 3.64, 70.92,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x81, 0xC9, 0x95,
MOVE_TO, 92.52, 83.11,
CUBIC_TO, 93.95, 83.58, 94.74, 85.15, 94.29, 86.63,
CUBIC_TO, 93.85, 88.11, 92.32, 88.94, 90.9, 88.47,
LINE_TO, 85.72, 86.79,
CUBIC_TO, 84.29, 86.33, 83.5, 84.75, 83.94, 83.27,
CUBIC_TO, 84.39, 81.79, 85.91, 80.97, 87.34, 81.43,
LINE_TO, 92.52, 83.11,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFD, 0xD6, 0x63,
MOVE_TO, 10.4, 27.22,
CUBIC_TO, 8.67, 25.5, 8.62, 22.66, 10.28, 20.87,
CUBIC_TO, 11.94, 19.08, 14.68, 19.03, 16.41, 20.75,
LINE_TO, 22.66, 26.98,
CUBIC_TO, 24.38, 28.7, 24.44, 31.54, 22.78, 33.33,
CUBIC_TO, 21.12, 35.12, 18.37, 35.17, 16.65, 33.45,
LINE_TO, 10.4, 27.22,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xF2, 0x8B, 0x82,
MOVE_TO, 24.84, 87.96,
CUBIC_TO, 25.99, 86.79, 26.02, 84.88, 24.89, 83.68,
CUBIC_TO, 23.76, 82.48, 21.91, 82.45, 20.75, 83.62,
LINE_TO, 16.56, 87.86,
CUBIC_TO, 15.4, 89.02, 15.37, 90.94, 16.5, 92.14,
CUBIC_TO, 17.63, 93.34, 19.48, 93.37, 20.64, 92.2,
LINE_TO, 24.84, 87.96,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFD, 0xD6, 0x63,
MOVE_TO, 93.08, 55.06,
CUBIC_TO, 91.31, 55.99, 89.15, 55.26, 88.25, 53.43,
CUBIC_TO, 87.36, 51.6, 88.07, 49.36, 89.83, 48.43,
LINE_TO, 96.24, 45.07,
CUBIC_TO, 98.01, 44.14, 100.17, 44.87, 101.07, 46.7,
CUBIC_TO, 101.97, 48.53, 101.26, 50.77, 99.49, 51.7,
LINE_TO, 93.08, 55.06,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
MOVE_TO, 49.06, 6.42,
CUBIC_TO, 49.05, 5.65, 49.89, 5.17, 50.55, 5.55,
LINE_TO, 61.56, 11.85,
CUBIC_TO, 62.22, 12.23, 62.23, 13.19, 61.56, 13.58,
LINE_TO, 50.61, 19.96,
CUBIC_TO, 49.94, 20.35, 49.11, 19.87, 49.11, 19.1,
LINE_TO, 49.06, 6.42,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
MOVE_TO, 64.23, 94.97,
CUBIC_TO, 64.23, 95.74, 63.39, 96.22, 62.73, 95.84,
LINE_TO, 55.84, 91.86,
CUBIC_TO, 55.18, 91.48, 55.18, 90.52, 55.84, 90.13,
LINE_TO, 62.73, 86.16,
CUBIC_TO, 63.39, 85.77, 64.23, 86.25, 64.23, 87.02,
LINE_TO, 64.23, 94.97,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSaveCardAndVcnSuccessConfirmationDarkRepList, kSaveCardAndVcnSuccessConfirmationDarkIcon, {kSaveCardAndVcnSuccessConfirmationDarkPath})
VECTOR_ICON_REP_TEMPLATE(kPeopleGroupPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 1.6, 12.8,
R_V_LINE_TO, -1.53,
R_CUBIC_TO, 0, -0.29, 0.07, -0.55, 0.21, -0.79,
R_CUBIC_TO, 0.14, -0.24, 0.33, -0.43, 0.57, -0.58,
R_ARC_TO, 8.09, 8.09, 0, 0, 1, 1.91, -0.82,
R_ARC_TO, 7.8, 7.8, 0, 0, 1, 2.11, -0.28,
R_CUBIC_TO, 0.74, 0, 1.44, 0.09, 2.11, 0.28,
R_CUBIC_TO, 0.67, 0.19, 1.31, 0.46, 1.91, 0.82,
R_ARC_TO, 1.58, 1.58, 0, 0, 1, 0.78, 1.37,
R_V_LINE_TO, 1.54,
CLOSE,
R_MOVE_TO, 10.8, 0,
R_V_LINE_TO, -1.53,
R_CUBIC_TO, 0, -0.46, -0.1, -0.9, -0.32, -1.3,
R_ARC_TO, 2.78, 2.78, 0, 0, 0, -0.87, -0.98,
R_CUBIC_TO, 0.43, 0.09, 0.86, 0.21, 1.26, 0.36,
R_CUBIC_TO, 0.41, 0.15, 0.79, 0.34, 1.16, 0.56,
R_CUBIC_TO, 0.24, 0.14, 0.44, 0.34, 0.57, 0.58,
R_CUBIC_TO, 0.14, 0.24, 0.21, 0.5, 0.21, 0.79,
V_LINE_TO, 12.8,
CLOSE,
R_MOVE_TO, -6, -4.8,
R_CUBIC_TO, -0.66, 0, -1.23, -0.23, -1.7, -0.7,
ARC_TO, 2.33, 2.33, 0, 0, 1, 4, 5.6,
R_CUBIC_TO, 0, -0.67, 0.23, -1.24, 0.7, -1.7,
ARC_TO, 2.33, 2.33, 0, 0, 1, 6.4, 3.2,
R_ARC_TO, 2.33, 2.33, 0, 0, 1, 1.7, 0.7,
R_CUBIC_TO, 0.46, 0.47, 0.7, 1.03, 0.7, 1.7,
R_CUBIC_TO, 0, 0.66, -0.23, 1.23, -0.7, 1.7,
ARC_TO, 2.33, 2.33, 0, 0, 1, 6.4, 8,
CLOSE,
MOVE_TO, 12, 5.6,
R_CUBIC_TO, 0, 0.66, -0.23, 1.23, -0.7, 1.7,
R_CUBIC_TO, -0.47, 0.47, -1.03, 0.7, -1.7, 0.7,
R_CUBIC_TO, -0.09, 0, -0.17, 0, -0.25, -0.01,
R_ARC_TO, 1.53, 1.53, 0, 0, 1, -0.25, -0.04,
R_CUBIC_TO, 0.28, -0.32, 0.5, -0.68, 0.66, -1.07,
R_CUBIC_TO, 0.16, -0.39, 0.24, -0.82, 0.24, -1.27,
R_CUBIC_TO, 0, -0.46, -0.08, -0.88, -0.24, -1.28,
R_ARC_TO, 3.83, 3.83, 0, 0, 0, -0.66, -1.07,
R_CUBIC_TO, 0.09, -0.02, 0.17, -0.04, 0.25, -0.04,
R_CUBIC_TO, 0.08, 0, 0.16, -0.01, 0.25, -0.01,
R_CUBIC_TO, 0.66, 0, 1.23, 0.24, 1.7, 0.7,
R_CUBIC_TO, 0.47, 0.47, 0.7, 1.03, 0.7, 1.7,
CLOSE,
R_MOVE_TO, -9.2, 6,
H_LINE_TO, 10,
R_V_LINE_TO, -0.34,
R_ARC_TO, 0.37, 0.37, 0, 0, 0, -0.05, -0.2,
R_ARC_TO, 0.37, 0.37, 0, 0, 0, -0.13, -0.14,
R_ARC_TO, 7.09, 7.09, 0, 0, 0, -1.65, -0.69,
ARC_TO, 6.6, 6.6, 0, 0, 0, 6.4, 10,
R_CUBIC_TO, -0.6, 0, -1.19, 0.08, -1.76, 0.23,
R_ARC_TO, 6.44, 6.44, 0, 0, 0, -1.65, 0.7,
R_ARC_TO, 0.33, 0.33, 0, 0, 0, -0.13, 0.13,
R_ARC_TO, 0.36, 0.36, 0, 0, 0, -0.05, 0.2,
CLOSE,
MOVE_TO, 6.4, 6.8,
R_CUBIC_TO, 0.33, 0, 0.61, -0.12, 0.85, -0.36,
R_ARC_TO, 1.16, 1.16, 0, 0, 0, 0.35, -0.85,
R_CUBIC_TO, 0, -0.33, -0.12, -0.61, -0.36, -0.85,
R_ARC_TO, 1.16, 1.16, 0, 0, 0, -0.85, -0.35,
R_CUBIC_TO, -0.33, 0, -0.61, 0.12, -0.85, 0.36,
R_ARC_TO, 1.16, 1.16, 0, 0, 0, -0.35, 0.85,
R_CUBIC_TO, 0, 0.33, 0.12, 0.61, 0.36, 0.85,
R_CUBIC_TO, 0.23, 0.24, 0.52, 0.35, 0.85, 0.35,
CLOSE,
R_MOVE_TO, 0, 4.8,
CLOSE,
R_MOVE_TO, 0, -6,
CLOSE,)
VECTOR_ICON_TEMPLATE_CC(kPeopleGroupRepList, kPeopleGroupIcon, {kPeopleGroupPath})
VECTOR_ICON_REP_TEMPLATE(kPerformancePath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 7.15, 10.04,
R_CUBIC_TO, 0.25, 0.24, 0.57, 0.36, 0.95, 0.34,
R_CUBIC_TO, 0.38, -0.02, 0.66, -0.16, 0.84, -0.43,
R_LINE_TO, 3.57, -5.25,
LINE_TO, 7.25, 8.27,
R_CUBIC_TO, -0.27, 0.19, -0.43, 0.47, -0.44, 0.84,
R_CUBIC_TO, -0.02, 0.37, 0.09, 0.68, 0.35, 0.92,
CLOSE,
R_MOVE_TO, 0.87, -6.97,
R_CUBIC_TO, 0.69, 0, 1.31, 0.09, 1.87, 0.27,
R_CUBIC_TO, 0.56, 0.18, 1.06, 0.4, 1.5, 0.66,
R_LINE_TO, -1.32, 0.88,
R_ARC_TO, 5.13, 5.13, 0, 0, 0, -0.95, -0.32,
R_ARC_TO, 5.18, 5.18, 0, 0, 0, -1.1, -0.11,
R_CUBIC_TO, -1.43, 0, -2.64, 0.51, -3.65, 1.54,
R_CUBIC_TO, -1.01, 1.03, -1.51, 2.23, -1.51, 3.61,
R_CUBIC_TO, 0, 0.42, 0.03, 0.76, 0.09, 1.02,
R_CUBIC_TO, 0.06, 0.26, 0.15, 0.57, 0.28, 0.93,
R_H_LINE_TO, 9.56,
R_ARC_TO, 5.93, 5.93, 0, 0, 0, 0.3, -0.98,
R_ARC_TO, 5.35, 5.35, 0, 0, 0, -0.1, -2.33,
R_ARC_TO, 4.71, 4.71, 0, 0, 0, -0.54, -1.27,
R_LINE_TO, 0.84, -1.24,
R_ARC_TO, 6.26, 6.26, 0, 0, 1, 0.94, 1.82,
R_CUBIC_TO, 0.22, 0.67, 0.33, 1.34, 0.33, 2.03,
R_ARC_TO, 7.24, 7.24, 0, 0, 1, -0.15, 1.52,
R_ARC_TO, 4.09, 4.09, 0, 0, 1, -0.47, 1.2,
R_ARC_TO, 1.32, 1.32, 0, 0, 1, -0.48, 0.49,
R_CUBIC_TO, -0.19, 0.11, -0.41, 0.16, -0.64, 0.16,
H_LINE_TO, 3.2,
R_ARC_TO, 1.26, 1.26, 0, 0, 1, -1.11, -0.65,
R_ARC_TO, 4.25, 4.25, 0, 0, 1, -0.47, -1.2,
R_ARC_TO, 7, 7, 0, 0, 1, -0.15, -1.52,
R_CUBIC_TO, 0, -0.9, 0.17, -1.75, 0.52, -2.54,
R_ARC_TO, 6.59, 6.59, 0, 0, 1, 1.4, -2.06,
R_ARC_TO, 6.62, 6.62, 0, 0, 1, 2.08, -1.39,
R_ARC_TO, 6.43, 6.43, 0, 0, 1, 2.55, -0.51,
CLOSE,
R_MOVE_TO, 0.06, 4.71,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPerformanceRepList, kPerformanceIcon, {kPerformancePath})
VECTOR_ICON_REP_TEMPLATE(kPerformanceSpeedometerPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 8.94, 12.54,
R_CUBIC_TO, 0.32, 0.31, 0.71, 0.45, 1.19, 0.43,
R_CUBIC_TO, 0.47, -0.02, 0.82, -0.2, 1.04, -0.53,
LINE_TO, 15.5, 6,
R_LINE_TO, -6.44, 4.34,
R_CUBIC_TO, -0.34, 0.23, -0.53, 0.58, -0.56, 1.05,
R_CUBIC_TO, -0.03, 0.47, 0.12, 0.85, 0.44, 1.16,
CLOSE,
MOVE_TO, 10.02, 4,
R_CUBIC_TO, 0.84, 0, 1.59, 0.11, 2.25, 0.32,
R_ARC_TO, 8.83, 8.83, 0, 0, 1, 1.81, 0.8,
R_LINE_TO, -1.44, 0.94,
R_ARC_TO, 6.15, 6.15, 0, 0, 0, -1.22, -0.42,
ARC_TO, 6.25, 6.25, 0, 0, 0, 10.02, 5.5,
R_CUBIC_TO, -1.8, 0, -3.34, 0.65, -4.61, 1.95,
CUBIC_TO, 4.14, 8.74, 3.5, 10.27, 3.5, 12,
R_CUBIC_TO, 0, 0.53, 0.04, 0.96, 0.11, 1.3,
R_CUBIC_TO, 0.08, 0.34, 0.2, 0.74, 0.37, 1.2,
H_LINE_TO, 16,
R_CUBIC_TO, 0.18, -0.46, 0.31, -0.88, 0.39, -1.26,
R_CUBIC_TO, 0.07, -0.38, 0.11, -0.79, 0.11, -1.24,
R_CUBIC_TO, 0, -0.58, -0.08, -1.17, -0.24, -1.75,
R_ARC_TO, 6.05, 6.05, 0, 0, 0, -0.7, -1.6,
R_LINE_TO, 0.9, -1.35,
ARC_TO, 7.98, 7.98, 0, 0, 1, 17.59, 9.5,
R_CUBIC_TO, 0.27, 0.81, 0.41, 1.63, 0.41, 2.46,
R_CUBIC_TO, 0, 0.71, -0.06, 1.33, -0.18, 1.86,
R_ARC_TO, 4.96, 4.96, 0, 0, 1, -0.57, 1.46,
ARC_TO, 1.4, 1.4, 0, 0, 1, 16, 16,
H_LINE_TO, 4,
R_ARC_TO, 1.4, 1.4, 0, 0, 1, -1.25, -0.73,
R_ARC_TO, 4.96, 4.96, 0, 0, 1, -0.57, -1.46,
CUBIC_TO, 2.06, 13.28, 2, 12.67, 2, 11.96,
R_CUBIC_TO, 0, -1.1, 0.21, -2.14, 0.64, -3.11,
R_ARC_TO, 8.01, 8.01, 0, 0, 1, 1.72, -2.52,
R_ARC_TO, 8.1, 8.1, 0, 0, 1, 2.55, -1.7,
ARC_TO, 7.83, 7.83, 0, 0, 1, 10.02, 4,
CLOSE,
MOVE_TO, 10, 9.81,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPerformanceSpeedometerRepList, kPerformanceSpeedometerIcon, {kPerformanceSpeedometerPath})
VECTOR_ICON_REP_TEMPLATE(kPersonPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 10, 10,
R_ARC_TO, 2.9, 2.9, 0, 0, 1, -2.12, -0.87,
ARC_TO, 2.9, 2.9, 0, 0, 1, 7, 7,
R_CUBIC_TO, 0, -0.83, 0.29, -1.54, 0.88, -2.12,
ARC_TO, 2.9, 2.9, 0, 0, 1, 10, 4,
R_CUBIC_TO, 0.83, 0, 1.54, 0.29, 2.13, 0.88,
CUBIC_TO, 12.71, 5.46, 13, 6.17, 13, 7,
R_CUBIC_TO, 0, 0.83, -0.29, 1.54, -0.87, 2.13,
ARC_TO, 2.9, 2.9, 0, 0, 1, 10, 10,
CLOSE,
R_MOVE_TO, -6, 6,
R_V_LINE_TO, -2,
R_CUBIC_TO, 0, -0.32, 0.09, -0.62, 0.26, -0.91,
R_CUBIC_TO, 0.17, -0.28, 0.41, -0.52, 0.72, -0.72,
R_CUBIC_TO, 0.76, -0.44, 1.57, -0.78, 2.42, -1.02,
R_ARC_TO, 9.62, 9.62, 0, 0, 1, 5.19, 0,
R_CUBIC_TO, 0.86, 0.24, 1.67, 0.57, 2.43, 1.02,
R_CUBIC_TO, 0.31, 0.18, 0.55, 0.42, 0.72, 0.71,
R_CUBIC_TO, 0.18, 0.29, 0.26, 0.6, 0.26, 0.92,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 1.5, -1.5,
R_H_LINE_TO, 9,
V_LINE_TO, 14,
R_CUBIC_TO, 0, -0.07, -0.02, -0.14, -0.06, -0.19,
R_ARC_TO, 0.41, 0.41, 0, 0, 0, -0.17, -0.14,
R_ARC_TO, 7.61, 7.61, 0, 0, 0, -2.04, -0.87,
ARC_TO, 8.5, 8.5, 0, 0, 0, 10, 12.5,
R_CUBIC_TO, -0.77, 0, -1.51, 0.1, -2.23, 0.29,
R_ARC_TO, 7.61, 7.61, 0, 0, 0, -2.04, 0.88,
R_CUBIC_TO, -0.07, 0.06, -0.12, 0.11, -0.17, 0.16,
ARC_TO, 0.26, 0.26, 0, 0, 0, 5.5, 14,
CLOSE,
R_MOVE_TO, 4.5, -6,
R_CUBIC_TO, 0.41, 0, 0.77, -0.15, 1.06, -0.44,
R_CUBIC_TO, 0.29, -0.3, 0.44, -0.65, 0.44, -1.06,
R_CUBIC_TO, 0, -0.41, -0.15, -0.77, -0.44, -1.06,
ARC_TO, 1.45, 1.45, 0, 0, 0, 10, 5.5,
R_CUBIC_TO, -0.41, 0, -0.77, 0.15, -1.06, 0.44,
ARC_TO, 1.45, 1.45, 0, 0, 0, 8.5, 7,
R_CUBIC_TO, 0, 0.41, 0.15, 0.77, 0.44, 1.06,
R_CUBIC_TO, 0.3, 0.29, 0.65, 0.44, 1.06, 0.44,
CLOSE,
MOVE_TO, 10, 7,
CLOSE,
R_MOVE_TO, 0, 7.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPersonRepList, kPersonIcon, {kPersonPath})
VECTOR_ICON_REP_TEMPLATE(kPersonFilledPaddedSmallPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 12, 5,
R_CUBIC_TO, -1.93, 0, -3.5, 1.57, -3.5, 3.5,
R_CUBIC_TO, 0, 1.93, 1.57, 3.5, 3.5, 3.5,
R_CUBIC_TO, 1.93, 0, 3.5, -1.57, 3.5, -3.5,
CUBIC_TO, 15.5, 6.57, 13.93, 5, 12, 5,
CLOSE,
R_MOVE_TO, 0, 7.88,
R_CUBIC_TO, -2.34, 0, -7, 1.17, -7, 3.5,
V_LINE_TO, 19,
R_H_LINE_TO, 14,
R_V_LINE_TO, -2.62,
R_CUBIC_TO, 0, -2.33, -4.66, -3.5, -7, -3.5,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kPersonFilledPaddedSmall22Path, CANVAS_DIMENSIONS, 22,
MOVE_TO, 11, 5,
CUBIC_TO, 9.34, 5, 8, 6.34, 8, 8,
R_CUBIC_TO, 0, 1.66, 1.34, 3, 3, 3,
R_CUBIC_TO, 1.66, 0, 3, -1.34, 3, -3,
R_CUBIC_TO, 0, -1.66, -1.34, -3, -3, -3,
CLOSE,
R_MOVE_TO, 0, 6.75,
R_CUBIC_TO, -2, 0, -6, 1, -6, 3,
V_LINE_TO, 17,
R_H_LINE_TO, 12,
R_V_LINE_TO, -2.25,
R_CUBIC_TO, 0, -1.99, -4, -3, -6, -3,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kPersonFilledPaddedSmall20Path, CANVAS_DIMENSIONS, 20,
MOVE_TO, 10, 4,
CUBIC_TO, 8.34, 4, 7, 5.34, 7, 7,
R_CUBIC_TO, 0, 1.66, 1.34, 3, 3, 3,
R_CUBIC_TO, 1.66, 0, 3, -1.34, 3, -3,
R_CUBIC_TO, 0, -1.66, -1.34, -3, -3, -3,
CLOSE,
R_MOVE_TO, 0, 6.75,
R_CUBIC_TO, -2, 0, -6, 1, -6, 3,
V_LINE_TO, 16,
R_H_LINE_TO, 12,
R_V_LINE_TO, -2.25,
R_CUBIC_TO, 0, -1.99, -4, -3, -6, -3,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPersonFilledPaddedSmallRepList, kPersonFilledPaddedSmallIcon, {kPersonFilledPaddedSmallPath}, {kPersonFilledPaddedSmall22Path}, {kPersonFilledPaddedSmall20Path})
VECTOR_ICON_REP_TEMPLATE(kPictureInPictureAltPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 16, 14,
H_LINE_TO, 0,
V_LINE_TO, 2,
R_H_LINE_TO, 16,
R_V_LINE_TO, 12,
CLOSE,
MOVE_TO, 1, 13,
R_H_LINE_TO, 14,
V_LINE_TO, 3,
H_LINE_TO, 1,
R_V_LINE_TO, 10,
CLOSE,
MOVE_TO, 8, 8,
R_H_LINE_TO, 6,
R_V_LINE_TO, 4,
H_LINE_TO, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPictureInPictureAltRepList, kPictureInPictureAltIcon, {kPictureInPictureAltPath})
VECTOR_ICON_REP_TEMPLATE(kPrintMenuPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 10.75, 5.47,
V_LINE_TO, 3.65,
H_LINE_TO, 5.25,
R_V_LINE_TO, 1.82,
H_LINE_TO, 3.86,
R_V_LINE_TO, -3.2,
R_H_LINE_TO, 8.27,
R_V_LINE_TO, 3.2,
CLOSE,
MOVE_TO, 2.85, 6.85,
R_H_LINE_TO, 10.32,
CLOSE,
R_MOVE_TO, 8.86, 1.72,
R_ARC_TO, 0.65, 0.65, 0, 0, 0, 0.66, -0.66,
R_ARC_TO, 0.66, 0.66, 0, 0, 0, -0.19, -0.47,
R_ARC_TO, 0.63, 0.63, 0, 0, 0, -0.47, -0.19,
R_ARC_TO, 0.67, 0.67, 0, 0, 0, -0.47, 0.19,
R_ARC_TO, 0.64, 0.64, 0, 0, 0, -0.19, 0.47,
R_ARC_TO, 0.66, 0.66, 0, 0, 0, 0.66, 0.66,
CLOSE,
R_MOVE_TO, -0.95, 3.88,
R_V_LINE_TO, -2.1,
H_LINE_TO, 5.25,
R_V_LINE_TO, 2.09,
CLOSE,
R_MOVE_TO, 1.38, 1.36,
H_LINE_TO, 3.86,
R_V_LINE_TO, -2.49,
H_LINE_TO, 1.47,
V_LINE_TO, 7.2,
R_CUBIC_TO, 0, -0.48, 0.17, -0.89, 0.5, -1.23,
R_CUBIC_TO, 0.33, -0.34, 0.74, -0.51, 1.22, -0.51,
R_H_LINE_TO, 9.63,
R_CUBIC_TO, 0.48, 0, 0.89, 0.17, 1.22, 0.51,
R_CUBIC_TO, 0.33, 0.34, 0.5, 0.75, 0.5, 1.23,
R_V_LINE_TO, 4.11,
R_H_LINE_TO, -2.4,
CLOSE,
R_MOVE_TO, 1.03, -3.87,
R_V_LINE_TO, -2.5,
R_ARC_TO, 0.53, 0.53, 0, 0, 0, -0.18, -0.41,
R_ARC_TO, 0.61, 0.61, 0, 0, 0, -0.42, -0.17,
H_LINE_TO, 3.42,
R_CUBIC_TO, -0.16, 0, -0.3, 0.06, -0.41, 0.17,
R_ARC_TO, 0.58, 0.58, 0, 0, 0, -0.16, 0.42,
V_LINE_TO, 9.93,
R_H_LINE_TO, 1.01,
R_V_LINE_TO, -0.96,
R_H_LINE_TO, 8.27,
R_V_LINE_TO, 0.96,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPrintMenuRepList, kPrintMenuIcon, {kPrintMenuPath})
VECTOR_ICON_REP_TEMPLATE(kPrivacyTipPath, CANVAS_DIMENSIONS, 960,
MOVE_TO, 440, 680,
R_H_LINE_TO, 80,
R_V_LINE_TO, -240,
R_H_LINE_TO, -80,
R_V_LINE_TO, 240,
CLOSE,
R_MOVE_TO, 40, -320,
R_QUADRATIC_TO, 17, 0, 28.5, -11.5,
QUADRATIC_TO_SHORTHAND, 520, 320,
R_QUADRATIC_TO, 0, -17, -11.5, -28.5,
QUADRATIC_TO_SHORTHAND, 480, 280,
R_QUADRATIC_TO, -17, 0, -28.5, 11.5,
QUADRATIC_TO_SHORTHAND, 440, 320,
R_QUADRATIC_TO, 0, 17, 11.5, 28.5,
QUADRATIC_TO_SHORTHAND, 480, 360,
CLOSE,
R_MOVE_TO, 0, 520,
R_QUADRATIC_TO, -139, -35, -229.5, -159.5,
QUADRATIC_TO_SHORTHAND, 160, 444,
R_V_LINE_TO, -244,
R_LINE_TO, 320, -120,
R_LINE_TO, 320, 120,
R_V_LINE_TO, 244,
R_QUADRATIC_TO, 0, 152, -90.5, 276.5,
QUADRATIC_TO_SHORTHAND, 480, 880,
CLOSE,
R_MOVE_TO, 0, -84,
R_QUADRATIC_TO, 104, -33, 172, -132,
R_QUADRATIC_TO, 68, -99, 68, -220,
R_V_LINE_TO, -189,
R_LINE_TO, -240, -90,
R_LINE_TO, -240, 90,
R_V_LINE_TO, 189,
R_QUADRATIC_TO, 0, 121, 68, 220,
R_QUADRATIC_TO, 68, 99, 172, 132,
CLOSE,
R_MOVE_TO, 0, -316,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPrivacyTipRepList, kPrivacyTipIcon, {kPrivacyTipPath})
VECTOR_ICON_REP_TEMPLATE(kQrCodeChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 3, 9,
V_LINE_TO, 3,
R_H_LINE_TO, 6,
R_V_LINE_TO, 6,
CLOSE,
R_MOVE_TO, 1.5, -1.5,
R_H_LINE_TO, 3,
R_V_LINE_TO, -3,
R_H_LINE_TO, -3,
CLOSE,
MOVE_TO, 3, 17,
R_V_LINE_TO, -6,
R_H_LINE_TO, 6,
R_V_LINE_TO, 6,
CLOSE,
R_MOVE_TO, 1.5, -1.5,
R_H_LINE_TO, 3,
R_V_LINE_TO, -3,
R_H_LINE_TO, -3,
CLOSE,
MOVE_TO, 11, 9,
V_LINE_TO, 3,
R_H_LINE_TO, 6,
R_V_LINE_TO, 6,
CLOSE,
R_MOVE_TO, 1.5, -1.5,
R_H_LINE_TO, 3,
R_V_LINE_TO, -3,
R_H_LINE_TO, -3,
CLOSE,
R_MOVE_TO, 3, 9.5,
R_V_LINE_TO, -1.5,
H_LINE_TO, 17,
V_LINE_TO, 17,
CLOSE,
MOVE_TO, 11, 12.5,
V_LINE_TO, 11,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 1.5,
CLOSE,
R_MOVE_TO, 1.5, 1.5,
R_V_LINE_TO, -1.5,
H_LINE_TO, 14,
V_LINE_TO, 14,
CLOSE,
MOVE_TO, 11, 15.5,
V_LINE_TO, 14,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 1.5,
CLOSE,
R_MOVE_TO, 1.5, 1.5,
R_V_LINE_TO, -1.5,
H_LINE_TO, 14,
V_LINE_TO, 17,
CLOSE,
R_MOVE_TO, 1.5, -1.5,
V_LINE_TO, 14,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 1.5,
CLOSE,
R_MOVE_TO, 0, -3,
V_LINE_TO, 11,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 1.5,
CLOSE,
R_MOVE_TO, 1.5, 1.5,
R_V_LINE_TO, -1.5,
H_LINE_TO, 17,
V_LINE_TO, 14,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kQrCodeChromeRefresh16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 2.22, 7.2,
V_LINE_TO, 2.21,
R_H_LINE_TO, 4.98,
R_V_LINE_TO, 4.98,
CLOSE,
R_MOVE_TO, 1.39, -1.38,
R_H_LINE_TO, 2.21,
V_LINE_TO, 3.6,
H_LINE_TO, 3.6,
CLOSE,
R_MOVE_TO, -1.39, 7.97,
V_LINE_TO, 8.8,
R_H_LINE_TO, 4.98,
R_V_LINE_TO, 4.98,
CLOSE,
R_MOVE_TO, 1.39, -1.39,
R_H_LINE_TO, 2.21,
R_V_LINE_TO, -2.21,
H_LINE_TO, 3.6,
CLOSE,
MOVE_TO, 8.8, 7.2,
V_LINE_TO, 2.22,
R_H_LINE_TO, 4.98,
R_V_LINE_TO, 4.98,
CLOSE,
R_MOVE_TO, 1.38, -1.38,
R_H_LINE_TO, 2.21,
V_LINE_TO, 3.6,
R_H_LINE_TO, -2.21,
CLOSE,
R_MOVE_TO, 2.36, 7.97,
R_V_LINE_TO, -1.25,
R_H_LINE_TO, 1.25,
R_V_LINE_TO, 1.25,
CLOSE,
R_MOVE_TO, -3.74, -3.74,
V_LINE_TO, 8.8,
R_H_LINE_TO, 1.25,
R_V_LINE_TO, 1.24,
CLOSE,
R_MOVE_TO, 1.25, 1.25,
R_V_LINE_TO, -1.25,
R_H_LINE_TO, 1.25,
R_V_LINE_TO, 1.25,
CLOSE,
MOVE_TO, 8.8, 12.54,
R_V_LINE_TO, -1.24,
R_H_LINE_TO, 1.25,
R_V_LINE_TO, 1.24,
CLOSE,
R_MOVE_TO, 1.25, 1.25,
R_V_LINE_TO, -1.25,
R_H_LINE_TO, 1.25,
R_V_LINE_TO, 1.25,
CLOSE,
R_MOVE_TO, 1.25, -1.25,
R_V_LINE_TO, -1.24,
R_H_LINE_TO, 1.25,
R_V_LINE_TO, 1.24,
CLOSE,
R_MOVE_TO, 0, -2.49,
V_LINE_TO, 8.8,
R_H_LINE_TO, 1.25,
R_V_LINE_TO, 1.24,
CLOSE,
R_MOVE_TO, 1.25, 1.25,
R_V_LINE_TO, -1.25,
R_H_LINE_TO, 1.25,
R_V_LINE_TO, 1.25,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kQrCodeChromeRefreshRepList, kQrCodeChromeRefreshIcon, {kQrCodeChromeRefreshPath}, {kQrCodeChromeRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kQrcodeGeneratorPath, CANVAS_DIMENSIONS, 18,
ROUND_RECT, 1, 1, 16, 16, 2,
CLOSE,
NEW_PATH,
PATH_MODE_CLEAR,
ROUND_RECT, 2, 2, 14, 14, 1.72,
CLOSE,
NEW_PATH,
PATH_MODE_CLEAR,
ROUND_RECT, 7.4, 0, 3.2, 18, 0,
ROUND_RECT, 0, 7.4, 18, 3.2, 0,
CLOSE,
NEW_PATH,
ROUND_RECT, 3.8, 3.8, 4.5, 4.5, 0.9,
ROUND_RECT, 9.7, 3.8, 4.5, 4.5, 0.9,
ROUND_RECT, 3.8, 9.7, 4.5, 4.5, 0.9,
ROUND_RECT, 9.7, 9.7, 4.5, 4.5, 0.9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kQrcodeGeneratorRepList, kQrcodeGeneratorIcon, {kQrcodeGeneratorPath})
VECTOR_ICON_REP_TEMPLATE(kReadLaterAddPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 11.52, 15.41,
R_V_LINE_TO, -1.8,
H_LINE_TO, 9.72,
R_V_LINE_TO, -1.3,
R_H_LINE_TO, 1.8,
R_V_LINE_TO, -1.8,
R_H_LINE_TO, 1.31,
R_V_LINE_TO, 1.8,
R_H_LINE_TO, 1.8,
R_V_LINE_TO, 1.3,
R_H_LINE_TO, -1.8,
R_V_LINE_TO, 1.8,
CLOSE,
R_MOVE_TO, -7.87, -3.06,
V_LINE_TO, 3.65,
CLOSE,
R_MOVE_TO, 0, 1.38,
R_CUBIC_TO, -0.39, 0, -0.72, -0.13, -0.98, -0.4,
R_ARC_TO, 1.34, 1.34, 0, 0, 1, -0.4, -0.98,
V_LINE_TO, 3.65,
R_CUBIC_TO, 0, -0.38, 0.13, -0.71, 0.4, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.4, 0.98, -0.4,
R_H_LINE_TO, 8.7,
R_CUBIC_TO, 0.38, 0, 0.71, 0.13, 0.98, 0.4,
R_CUBIC_TO, 0.27, 0.27, 0.4, 0.6, 0.4, 0.98,
R_V_LINE_TO, 5.59,
R_ARC_TO, 3.43, 3.43, 0, 0, 0, -0.67, -0.22,
R_ARC_TO, 3.92, 3.92, 0, 0, 0, -0.71, -0.08,
V_LINE_TO, 3.65,
H_LINE_TO, 3.65,
R_V_LINE_TO, 8.7,
R_H_LINE_TO, 4.52,
R_CUBIC_TO, -0.04, 0.23, -0.06, 0.46, -0.05, 0.69,
R_CUBIC_TO, 0, 0.23, 0.03, 0.46, 0.08, 0.69,
CLOSE,
R_MOVE_TO, 1.74, -2.56,
R_ARC_TO, 0.59, 0.59, 0, 0, 0, 0.43, -0.17,
R_ARC_TO, 0.57, 0.57, 0, 0, 0, 0.18, -0.43,
R_ARC_TO, 0.59, 0.59, 0, 0, 0, -0.17, -0.43,
R_ARC_TO, 0.57, 0.57, 0, 0, 0, -0.43, -0.17,
R_ARC_TO, 0.58, 0.58, 0, 0, 0, -0.42, 0.17,
R_ARC_TO, 0.57, 0.57, 0, 0, 0, -0.18, 0.43,
R_CUBIC_TO, 0, 0.17, 0.05, 0.31, 0.17, 0.43,
R_ARC_TO, 0.56, 0.56, 0, 0, 0, 0.42, 0.18,
CLOSE,
R_MOVE_TO, 0, -2.57,
ARC_TO, 0.59, 0.59, 0, 0, 0, 6, 8,
R_ARC_TO, 0.6, 0.6, 0, 0, 0, -0.17, -0.43,
R_ARC_TO, 0.57, 0.57, 0, 0, 0, -0.43, -0.18,
R_ARC_TO, 0.58, 0.58, 0, 0, 0, -0.42, 0.17,
R_ARC_TO, 0.58, 0.58, 0, 0, 0, -0.18, 0.43,
R_CUBIC_TO, 0, 0.17, 0.05, 0.31, 0.17, 0.43,
R_ARC_TO, 0.56, 0.56, 0, 0, 0, 0.42, 0.18,
CLOSE,
R_MOVE_TO, 0, -2.58,
R_ARC_TO, 0.59, 0.59, 0, 0, 0, 0.43, -0.17,
ARC_TO, 0.57, 0.57, 0, 0, 0, 6, 5.43,
ARC_TO, 0.59, 0.59, 0, 0, 0, 5.83, 5,
R_ARC_TO, 0.57, 0.57, 0, 0, 0, -0.43, -0.18,
R_ARC_TO, 0.58, 0.58, 0, 0, 0, -0.42, 0.17,
R_ARC_TO, 0.57, 0.57, 0, 0, 0, -0.18, 0.43,
R_CUBIC_TO, 0, 0.17, 0.05, 0.31, 0.17, 0.43,
R_ARC_TO, 0.56, 0.56, 0, 0, 0, 0.42, 0.18,
CLOSE,
R_MOVE_TO, 1.8, 2.58,
R_H_LINE_TO, 4,
V_LINE_TO, 7.4,
R_H_LINE_TO, -4,
CLOSE,
R_MOVE_TO, 0, -2.58,
R_H_LINE_TO, 4,
V_LINE_TO, 4.82,
R_H_LINE_TO, -4,
CLOSE,
R_MOVE_TO, 0, 5.15,
R_H_LINE_TO, 1.33,
R_CUBIC_TO, 0.12, -0.22, 0.25, -0.44, 0.41, -0.64,
R_CUBIC_TO, 0.16, -0.2, 0.33, -0.39, 0.51, -0.56,
H_LINE_TO, 7.2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kReadLaterAddRepList, kReadLaterAddIcon, {kReadLaterAddPath})
VECTOR_ICON_REP_TEMPLATE(kReadingListPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 6.75, 14,
R_CUBIC_TO, 0.21, 0, 0.39, -0.07, 0.54, -0.21,
R_ARC_TO, 0.72, 0.72, 0, 0, 0, 0.22, -0.53,
R_CUBIC_TO, 0, -0.21, -0.07, -0.39, -0.21, -0.53,
R_ARC_TO, 0.72, 0.72, 0, 0, 0, -0.53, -0.22,
R_CUBIC_TO, -0.21, 0, -0.39, 0.07, -0.53, 0.22,
R_ARC_TO, 0.72, 0.72, 0, 0, 0, -0.22, 0.53,
R_CUBIC_TO, 0, 0.21, 0.07, 0.39, 0.22, 0.54,
R_CUBIC_TO, 0.14, 0.14, 0.32, 0.22, 0.53, 0.22,
CLOSE,
R_MOVE_TO, 0, -3.25,
R_CUBIC_TO, 0.21, 0, 0.39, -0.07, 0.54, -0.21,
R_ARC_TO, 0.72, 0.72, 0, 0, 0, 0.22, -0.53,
R_CUBIC_TO, 0, -0.21, -0.07, -0.39, -0.21, -0.53,
R_ARC_TO, 0.72, 0.72, 0, 0, 0, -0.53, -0.22,
R_CUBIC_TO, -0.21, 0, -0.39, 0.07, -0.53, 0.22,
ARC_TO, 0.72, 0.72, 0, 0, 0, 6, 10,
R_CUBIC_TO, 0, 0.21, 0.07, 0.39, 0.22, 0.54,
R_CUBIC_TO, 0.14, 0.14, 0.32, 0.22, 0.53, 0.22,
CLOSE,
R_MOVE_TO, 0, -3.25,
R_CUBIC_TO, 0.21, 0, 0.39, -0.07, 0.54, -0.21,
R_ARC_TO, 0.72, 0.72, 0, 0, 0, 0.22, -0.53,
R_CUBIC_TO, 0, -0.21, -0.07, -0.39, -0.21, -0.53,
ARC_TO, 0.72, 0.72, 0, 0, 0, 6.75, 6,
R_CUBIC_TO, -0.21, 0, -0.39, 0.07, -0.53, 0.22,
ARC_TO, 0.72, 0.72, 0, 0, 0, 6, 6.75,
R_CUBIC_TO, 0, 0.21, 0.07, 0.39, 0.22, 0.54,
R_CUBIC_TO, 0.14, 0.14, 0.32, 0.22, 0.53, 0.22,
CLOSE,
MOVE_TO, 9, 14,
R_H_LINE_TO, 5,
R_V_LINE_TO, -1.5,
H_LINE_TO, 9,
CLOSE,
R_MOVE_TO, 0, -3.25,
R_H_LINE_TO, 5,
R_V_LINE_TO, -1.5,
H_LINE_TO, 9,
CLOSE,
MOVE_TO, 9, 7.5,
R_H_LINE_TO, 5,
V_LINE_TO, 6,
H_LINE_TO, 9,
CLOSE,
MOVE_TO, 4.5, 17,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3, 15.5,
R_V_LINE_TO, -11,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 4.5, 3,
R_H_LINE_TO, 11,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 11,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 15.5, 17,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_H_LINE_TO, 11,
R_V_LINE_TO, -11,
R_H_LINE_TO, -11,
CLOSE,
R_MOVE_TO, 0, -11,
R_V_LINE_TO, 11,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kReadingListRepList, kReadingListIcon, {kReadingListPath})
VECTOR_ICON_REP_TEMPLATE(kReleaseAlertPath, CANVAS_DIMENSIONS, 16,
R_MOVE_TO, 5.73, 14.97,
R_LINE_TO, -1.28, -2.12,
R_LINE_TO, -2.41, -0.54,
R_LINE_TO, 0.23, -2.46,
LINE_TO, 0.63, 8,
R_LINE_TO, 1.64, -1.84,
R_LINE_TO, -0.23, -2.46,
R_LINE_TO, 2.41, -0.54,
R_LINE_TO, 1.28, -2.12,
LINE_TO, 8, 2,
R_LINE_TO, 2.27, -0.98,
R_LINE_TO, 1.28, 2.13,
R_LINE_TO, 2.41, 0.54,
R_LINE_TO, -0.23, 2.46,
LINE_TO, 15.38, 8,
R_LINE_TO, -1.64, 1.84,
R_LINE_TO, 0.23, 2.46,
R_LINE_TO, -2.41, 0.54,
R_LINE_TO, -1.28, 2.13,
LINE_TO, 8, 14,
CLOSE,
R_MOVE_TO, 0.56, -1.75,
LINE_TO, 8, 12.5,
R_LINE_TO, 1.72, 0.73,
R_LINE_TO, 0.95, -1.6,
R_LINE_TO, 1.81, -0.41,
R_LINE_TO, -0.16, -1.84,
LINE_TO, 13.53, 8,
R_LINE_TO, -1.21, -1.38,
R_LINE_TO, 0.16, -1.84,
R_LINE_TO, -1.81, -0.41,
R_LINE_TO, -0.95, -1.6,
LINE_TO, 8, 3.5,
R_LINE_TO, -1.71, -0.73,
R_LINE_TO, -0.95, 1.6,
R_LINE_TO, -1.81, 0.39,
R_LINE_TO, 0.16, 1.85,
LINE_TO, 2.47, 8,
R_LINE_TO, 1.23, 1.38,
R_LINE_TO, -0.18, 1.85,
R_LINE_TO, 1.81, 0.41,
CLOSE,
MOVE_TO, 8, 8,
CLOSE,
R_MOVE_TO, -0.85, 2.44,
LINE_TO, 11.16, 6.45,
R_LINE_TO, -0.9, -0.89,
R_LINE_TO, -3.11, 3.1,
R_LINE_TO, -1.41, -1.4,
R_LINE_TO, -0.9, 0.89,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kReleaseAlertRepList, kReleaseAlertIcon, {kReleaseAlertPath})
VECTOR_ICON_REP_TEMPLATE(kReloadTouchPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 17.68, 6.32,
LINE_TO, 20, 4,
R_V_LINE_TO, 7,
R_H_LINE_TO, -7,
R_LINE_TO, 3.27, -3.27,
ARC_TO, 6.01, 6.01, 0, 0, 0, 12.04, 6,
R_CUBIC_TO, -3.33, 0, -6.03, 2.69, -6.03, 6,
R_CUBIC_TO, 0, 3.31, 2.7, 6, 6.03, 6,
R_CUBIC_TO, 2.62, 0, 4.71, -1.62, 5.47, -3.89,
R_LINE_TO, 0.11, -0.01,
R_ARC_TO, 1, 1, 0, 0, 1, 0.89, -0.6,
R_CUBIC_TO, 0.44, 0, 1, 0.32, 1, 1,
R_ARC_TO, 1, 1, 0, 0, 1, -0.09, 0.41,
R_LINE_TO, 0.05, 0,
CUBIC_TO, 18.26, 17.84, 15.41, 20, 12.04, 20,
CUBIC_TO, 7.6, 20, 4, 16.42, 4, 12,
R_CUBIC_TO, 0, -4.42, 3.6, -8, 8.04, -8,
R_CUBIC_TO, 2.2, 0, 4.2, 0.88, 5.65, 2.32,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kReloadTouchRepList, kReloadTouchIcon, {kReloadTouchPath})
VECTOR_ICON_REP_TEMPLATE(kRemovePath, CANVAS_DIMENSIONS, 16,
STROKE, 2.f,
CAP_SQUARE,
MOVE_TO, 3, 8,
R_H_LINE_TO, 10)
VECTOR_ICON_TEMPLATE_CC(kRemoveRepList, kRemoveIcon, {kRemovePath})
VECTOR_ICON_REP_TEMPLATE(kReportPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 8, 10.01,
R_ARC_TO, 0.64, 0.64, 0, 0, 0, 0.47, -0.19,
R_ARC_TO, 0.64, 0.64, 0, 0, 0, 0.19, -0.47,
R_ARC_TO, 0.65, 0.65, 0, 0, 0, -0.19, -0.47,
R_ARC_TO, 0.63, 0.63, 0, 0, 0, -0.47, -0.19,
R_ARC_TO, 0.64, 0.64, 0, 0, 0, -0.47, 0.19,
R_ARC_TO, 0.62, 0.62, 0, 0, 0, -0.19, 0.47,
R_ARC_TO, 0.65, 0.65, 0, 0, 0, 0.66, 0.67,
CLOSE,
MOVE_TO, 7.37, 8.03,
R_H_LINE_TO, 1.27,
R_V_LINE_TO, -4.43,
H_LINE_TO, 7.37,
CLOSE,
R_MOVE_TO, -5.9, 6.5,
V_LINE_TO, 2.85,
R_CUBIC_TO, 0, -0.38, 0.13, -0.71, 0.4, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.4, 0.98, -0.4,
R_H_LINE_TO, 10.31,
R_CUBIC_TO, 0.38, 0, 0.71, 0.13, 0.98, 0.4,
R_CUBIC_TO, 0.27, 0.27, 0.4, 0.6, 0.4, 0.98,
R_V_LINE_TO, 7.91,
R_CUBIC_TO, 0, 0.38, -0.13, 0.71, -0.4, 0.98,
R_CUBIC_TO, -0.27, 0.27, -0.6, 0.41, -0.98, 0.41,
R_H_LINE_TO, -9.29,
CLOSE,
R_MOVE_TO, 1.9, -3.78,
R_H_LINE_TO, 9.79,
V_LINE_TO, 2.85,
H_LINE_TO, 2.85,
R_V_LINE_TO, 8.43,
CLOSE,
R_MOVE_TO, -0.51, 0,
V_LINE_TO, 2.85,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kReportRepList, kReportIcon, {kReportPath})
VECTOR_ICON_REP_TEMPLATE(kRequestMobileSiteCheckedPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 3.66, 15.32,
R_CUBIC_TO, -0.38, 0, -0.71, -0.14, -0.98, -0.41,
R_ARC_TO, 1.33, 1.33, 0, 0, 1, -0.41, -0.98,
V_LINE_TO, 2.06,
R_CUBIC_TO, 0, -0.38, 0.13, -0.7, 0.41, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.41, 0.98, -0.41,
R_H_LINE_TO, 7.08,
R_CUBIC_TO, 0.38, 0, 0.71, 0.14, 0.98, 0.41,
R_CUBIC_TO, 0.27, 0.27, 0.41, 0.6, 0.41, 0.98,
V_LINE_TO, 4.8,
R_H_LINE_TO, -1.39,
R_V_LINE_TO, -0.74,
H_LINE_TO, 3.66,
R_V_LINE_TO, 7.88,
R_H_LINE_TO, 7.08,
V_LINE_TO, 11.2,
R_H_LINE_TO, 1.39,
R_V_LINE_TO, 2.74,
R_CUBIC_TO, 0, 0.38, -0.14, 0.7, -0.41, 0.98,
R_CUBIC_TO, -0.27, 0.27, -0.6, 0.41, -0.98, 0.41,
CLOSE,
R_MOVE_TO, 0, -2.18,
R_V_LINE_TO, 0.8,
R_H_LINE_TO, 7.08,
R_V_LINE_TO, -0.8,
CLOSE,
R_MOVE_TO, 6.37, -2.72,
LINE_TO, 7.15, 7.52,
R_LINE_TO, 0.96, -0.96,
R_LINE_TO, 1.92, 1.93,
R_LINE_TO, 3.63, -3.63,
R_LINE_TO, 0.96, 0.96,
CLOSE,
MOVE_TO, 3.66, 2.86,
R_H_LINE_TO, 7.08,
R_V_LINE_TO, -0.8,
H_LINE_TO, 3.66,
CLOSE,
R_MOVE_TO, 0, 0,
R_V_LINE_TO, -0.8,
CLOSE,
R_MOVE_TO, 0, 10.28,
R_V_LINE_TO, 0.8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kRequestMobileSiteCheckedRepList, kRequestMobileSiteCheckedIcon, {kRequestMobileSiteCheckedPath})
VECTOR_ICON_REP_TEMPLATE(kRequestMobileSiteUncheckedPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 4.46, 15.32,
R_CUBIC_TO, -0.38, 0, -0.71, -0.14, -0.98, -0.41,
R_ARC_TO, 1.33, 1.33, 0, 0, 1, -0.4, -0.98,
V_LINE_TO, 2.06,
R_CUBIC_TO, 0, -0.38, 0.13, -0.71, 0.4, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.41, 0.98, -0.41,
R_H_LINE_TO, 7.08,
R_CUBIC_TO, 0.38, 0, 0.71, 0.14, 0.98, 0.41,
R_CUBIC_TO, 0.27, 0.27, 0.4, 0.59, 0.4, 0.98,
V_LINE_TO, 13.94,
R_CUBIC_TO, 0, 0.38, -0.13, 0.71, -0.4, 0.98,
R_CUBIC_TO, -0.27, 0.27, -0.6, 0.41, -0.98, 0.41,
CLOSE,
R_MOVE_TO, 0, -2.18,
R_V_LINE_TO, 0.8,
R_H_LINE_TO, 7.08,
R_V_LINE_TO, -0.8,
CLOSE,
R_MOVE_TO, 0, -1.2,
R_H_LINE_TO, 7.08,
V_LINE_TO, 4.06,
H_LINE_TO, 4.46,
CLOSE,
R_MOVE_TO, 0, -9.08,
R_H_LINE_TO, 7.08,
R_V_LINE_TO, -0.8,
H_LINE_TO, 4.46,
CLOSE,
R_MOVE_TO, 0, 0,
R_V_LINE_TO, -0.8,
CLOSE,
R_MOVE_TO, 0, 10.28,
R_V_LINE_TO, 0.8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kRequestMobileSiteUncheckedRepList, kRequestMobileSiteUncheckedIcon, {kRequestMobileSiteUncheckedPath})
VECTOR_ICON_REP_TEMPLATE(kResizeHandlePath, CANVAS_DIMENSIONS, 21,
STROKE, 2.f,
MOVE_TO, 5, 5,
R_LINE_TO, 11.31, 11.31,
MOVE_TO, 12, 5,
R_LINE_TO, 4.24, 4.24,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kResizeHandleRepList, kResizeHandleIcon, {kResizeHandlePath})
VECTOR_ICON_REP_TEMPLATE(kRightPanelClosePath, CANVAS_DIMENSIONS, 20,
FLIPS_IN_RTL,
MOVE_TO, 6.5, 6.75,
V_LINE_TO, 13.25,
LINE_TO, 10, 10,
LINE_TO, 6.5, 6.75,
CLOSE,
MOVE_TO, 4.4, 17,
CUBIC_TO, 4.01, 17, 3.68, 16.86, 3.41, 16.59,
CUBIC_TO, 3.14, 16.32, 3, 15.99, 3, 15.6,
V_LINE_TO, 4.4,
CUBIC_TO, 3, 4.01, 3.14, 3.68, 3.41, 3.41,
CUBIC_TO, 3.68, 3.14, 4.01, 3, 4.4, 3,
H_LINE_TO, 15.6,
CUBIC_TO, 15.99, 3, 16.32, 3.14, 16.59, 3.41,
CUBIC_TO, 16.86, 3.68, 17, 4.01, 17, 4.4,
V_LINE_TO, 15.6,
CUBIC_TO, 17, 15.99, 16.86, 16.32, 16.59, 16.59,
CUBIC_TO, 16.32, 16.86, 15.99, 17, 15.6, 17,
H_LINE_TO, 4.4,
CLOSE,
MOVE_TO, 13, 15.5,
H_LINE_TO, 15.5,
V_LINE_TO, 4.5,
H_LINE_TO, 13,
V_LINE_TO, 15.5,
CLOSE,
MOVE_TO, 11.5, 15.5,
V_LINE_TO, 4.5,
H_LINE_TO, 4.5,
V_LINE_TO, 15.5,
H_LINE_TO, 11.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kRightPanelCloseRepList, kRightPanelCloseIcon, {kRightPanelClosePath})
VECTOR_ICON_REP_TEMPLATE(kSadTabPath, MOVE_TO, 38, 13,
LINE_TO, 21, 13,
LINE_TO, 17, 7,
LINE_TO, 10, 7,
CUBIC_TO, 7.7, 7, 6.02, 8.69, 6, 11,
LINE_TO, 6, 37,
CUBIC_TO, 6, 39.31, 7.7, 41, 10, 41,
LINE_TO, 38, 41,
CUBIC_TO, 40.3, 41, 42, 39.31, 42, 37,
LINE_TO, 42, 17,
CUBIC_TO, 42, 14.36, 40.3, 12.67, 38, 13,
LINE_TO, 38, 13,
LINE_TO, 38, 13,
CLOSE,
MOVE_TO, 16, 18,
LINE_TO, 20, 18,
LINE_TO, 20, 23,
LINE_TO, 16, 23,
LINE_TO, 16, 18,
LINE_TO, 16, 18,
CLOSE,
MOVE_TO, 33, 35,
LINE_TO, 29, 35,
LINE_TO, 29, 31,
LINE_TO, 20, 31,
LINE_TO, 20, 35,
LINE_TO, 16, 35,
LINE_TO, 16, 31,
LINE_TO, 20, 31,
LINE_TO, 20, 27,
LINE_TO, 29, 27,
LINE_TO, 29, 31,
LINE_TO, 33, 31,
LINE_TO, 33, 35,
LINE_TO, 33, 35,
CLOSE,
MOVE_TO, 28, 18,
LINE_TO, 32, 18,
LINE_TO, 32, 23,
LINE_TO, 28, 23,
LINE_TO, 28, 18,
LINE_TO, 28, 18,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSadTabRepList, kSadTabIcon, {kSadTabPath})
VECTOR_ICON_REP_TEMPLATE(kSafetyCheckPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 10, 1,
LINE_TO, 18, 4.27,
LINE_TO, 18, 9.18,
CUBIC_TO, 18, 13.72, 14.59, 17.97, 10, 19,
CUBIC_TO, 5.41, 17.97, 2, 13.72, 2, 9.18,
LINE_TO, 2, 9.18,
LINE_TO, 2, 4.27,
LINE_TO, 10, 1,
CLOSE,
MOVE_TO, 13.57, 6.38,
LINE_TO, 8.44, 11.78,
LINE_TO, 6.43, 9.66,
LINE_TO, 5.33, 10.82,
LINE_TO, 8.44, 14.09,
LINE_TO, 14.67, 7.55,
LINE_TO, 13.57, 6.38,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSafetyCheckRepList, kSafetyCheckIcon, {kSafetyCheckPath})
VECTOR_ICON_REP_TEMPLATE(kSaveGroupRefreshPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 4.51, 16.1,
R_V_LINE_TO, -1.58,
R_H_LINE_TO, 1.38,
R_LINE_TO, 0.07, 0.05,
R_ARC_TO, 6.67, 6.67, 0, 0, 1, -1.51, -2.03,
ARC_TO, 5.79, 5.79, 0, 0, 1, 3.88, 10,
R_CUBIC_TO, 0, -1.46, 0.45, -2.73, 1.35, -3.82,
R_ARC_TO, 6.1, 6.1, 0, 0, 1, 3.4, -2.12,
R_V_LINE_TO, 1.79,
R_ARC_TO, 4.41, 4.41, 0, 0, 0, -2.17, 1.56,
R_CUBIC_TO, -0.57, 0.75, -0.85, 1.61, -0.85, 2.59,
R_CUBIC_TO, 0, 0.65, 0.13, 1.25, 0.4, 1.8,
R_ARC_TO, 4.45, 4.45, 0, 0, 0, 1.07, 1.43,
R_LINE_TO, -0.04, -0.04,
V_LINE_TO, 12,
R_H_LINE_TO, 1.57,
R_V_LINE_TO, 4.1,
CLOSE,
R_MOVE_TO, 6.86, -0.16,
R_V_LINE_TO, -1.79,
R_ARC_TO, 4.41, 4.41, 0, 0, 0, 2.17, -1.56,
R_CUBIC_TO, 0.57, -0.75, 0.85, -1.61, 0.85, -2.59,
R_CUBIC_TO, 0, -0.65, -0.13, -1.25, -0.4, -1.8,
R_ARC_TO, 4.45, 4.45, 0, 0, 0, -1.07, -1.43,
R_LINE_TO, 0.04, 0.04,
V_LINE_TO, 8,
R_H_LINE_TO, -1.57,
V_LINE_TO, 3.9,
R_H_LINE_TO, 4.09,
R_V_LINE_TO, 1.58,
R_H_LINE_TO, -1.37,
R_LINE_TO, -0.07, -0.05,
R_ARC_TO, 6.38, 6.38, 0, 0, 1, 1.52, 2.03,
R_CUBIC_TO, 0.38, 0.79, 0.56, 1.63, 0.56, 2.55,
R_CUBIC_TO, 0, 1.46, -0.45, 2.73, -1.35, 3.82,
R_ARC_TO, 6.1, 6.1, 0, 0, 1, -3.4, 2.12,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSaveGroupRefreshRepList, kSaveGroupRefreshIcon, {kSaveGroupRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kSavePagePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 8.41, 9.09,
LINE_TO, 7, 10.5,
R_LINE_TO, 5, 5,
R_LINE_TO, 5, -5,
R_LINE_TO, -1.41, -1.41,
LINE_TO, 13, 11.67,
V_LINE_TO, 3,
R_H_LINE_TO, -2,
R_V_LINE_TO, 8.67,
LINE_TO, 8.41, 9.09,
CLOSE,
MOVE_TO, 21, 19,
V_LINE_TO, 5,
R_CUBIC_TO, 0, -1.11, -0.9, -2, -2, -2,
R_H_LINE_TO, -4,
R_V_LINE_TO, 2,
R_H_LINE_TO, 4,
R_V_LINE_TO, 14,
H_LINE_TO, 5,
V_LINE_TO, 5,
R_H_LINE_TO, 4,
V_LINE_TO, 3,
H_LINE_TO, 5,
R_CUBIC_TO, -1.1, 0, -2, 0.89, -2, 2,
R_V_LINE_TO, 14,
R_CUBIC_TO, 0, 1.1, 0.9, 2, 2, 2,
R_H_LINE_TO, 14,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSavePageRepList, kSavePageIcon, {kSavePagePath})
VECTOR_ICON_REP_TEMPLATE(kSavedTabGroupBarEverythingPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 3, 9,
V_LINE_TO, 3,
R_H_LINE_TO, 6,
R_V_LINE_TO, 6,
CLOSE,
R_MOVE_TO, 0, 8,
R_V_LINE_TO, -6,
R_H_LINE_TO, 6,
R_V_LINE_TO, 6,
CLOSE,
R_MOVE_TO, 8, -8,
V_LINE_TO, 3,
R_H_LINE_TO, 6,
R_V_LINE_TO, 6,
CLOSE,
R_MOVE_TO, 0, 8,
R_V_LINE_TO, -6,
R_H_LINE_TO, 6,
R_V_LINE_TO, 6,
CLOSE,
MOVE_TO, 4.5, 7.5,
R_H_LINE_TO, 3,
R_V_LINE_TO, -3,
R_H_LINE_TO, -3,
CLOSE,
R_MOVE_TO, 8, 0,
R_H_LINE_TO, 3,
R_V_LINE_TO, -3,
R_H_LINE_TO, -3,
CLOSE,
R_MOVE_TO, 0, 8,
R_H_LINE_TO, 3,
R_V_LINE_TO, -3,
R_H_LINE_TO, -3,
CLOSE,
R_MOVE_TO, -8, 0,
R_H_LINE_TO, 3,
R_V_LINE_TO, -3,
R_H_LINE_TO, -3,
CLOSE,
R_MOVE_TO, 8, -8,
CLOSE,
R_MOVE_TO, 0, 5,
CLOSE,
R_MOVE_TO, -5, 0,
CLOSE,
R_MOVE_TO, 0, -5,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kSavedTabGroupBarEverything16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 2.27, 7.2,
V_LINE_TO, 2.27,
R_H_LINE_TO, 4.93,
R_V_LINE_TO, 4.93,
CLOSE,
R_MOVE_TO, 0, 6.53,
V_LINE_TO, 8.8,
R_H_LINE_TO, 4.93,
R_V_LINE_TO, 4.93,
CLOSE,
MOVE_TO, 8.8, 7.2,
V_LINE_TO, 2.27,
R_H_LINE_TO, 4.93,
R_V_LINE_TO, 4.93,
CLOSE,
R_MOVE_TO, 0, 6.54,
V_LINE_TO, 8.8,
R_H_LINE_TO, 4.93,
R_V_LINE_TO, 4.93,
CLOSE,
MOVE_TO, 3.65, 5.82,
R_H_LINE_TO, 2.17,
V_LINE_TO, 3.65,
H_LINE_TO, 3.65,
CLOSE,
R_MOVE_TO, 6.54, 0,
R_H_LINE_TO, 2.17,
V_LINE_TO, 3.65,
R_H_LINE_TO, -2.17,
CLOSE,
R_MOVE_TO, 0, 6.54,
R_H_LINE_TO, 2.17,
R_V_LINE_TO, -2.17,
R_H_LINE_TO, -2.17,
CLOSE,
R_MOVE_TO, -6.54, 0,
R_H_LINE_TO, 2.17,
R_V_LINE_TO, -2.17,
H_LINE_TO, 3.65,
CLOSE,
R_MOVE_TO, 6.54, -6.54,
CLOSE,
R_MOVE_TO, 0, 4.37,
CLOSE,
R_MOVE_TO, -4.37, 0,
CLOSE,
R_MOVE_TO, 0, -4.37,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSavedTabGroupBarEverythingRepList, kSavedTabGroupBarEverythingIcon, {kSavedTabGroupBarEverythingPath}, {kSavedTabGroupBarEverything16Path})
VECTOR_ICON_REP_TEMPLATE(kSciencePath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 5, 21,
R_CUBIC_TO, -0.85, 0, -1.45, -0.38, -1.81, -1.14,
R_CUBIC_TO, -0.36, -0.76, -0.27, -1.46, 0.26, -2.11,
LINE_TO, 9, 11,
V_LINE_TO, 5,
H_LINE_TO, 8,
R_ARC_TO, 0.96, 0.96, 0, 0, 1, -0.71, -0.29,
ARC_TO, 0.96, 0.96, 0, 0, 1, 7, 4,
R_CUBIC_TO, 0, -0.28, 0.1, -0.52, 0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 8, 3,
R_H_LINE_TO, 8,
R_CUBIC_TO, 0.28, 0, 0.52, 0.1, 0.71, 0.29,
R_CUBIC_TO, 0.19, 0.19, 0.29, 0.43, 0.29, 0.71,
R_CUBIC_TO, 0, 0.28, -0.1, 0.52, -0.29, 0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 16, 5,
R_H_LINE_TO, -1,
R_V_LINE_TO, 6,
R_LINE_TO, 5.55, 6.75,
R_CUBIC_TO, 0.53, 0.65, 0.62, 1.36, 0.26, 2.11,
CUBIC_TO, 20.45, 20.62, 19.85, 21, 19, 21,
CLOSE,
R_MOVE_TO, 0, -2,
R_H_LINE_TO, 14,
R_LINE_TO, -6, -7.3,
V_LINE_TO, 5,
R_H_LINE_TO, -2,
R_V_LINE_TO, 6.7,
CLOSE,
R_MOVE_TO, 7, -7,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kScience20Path, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 4.5, 17,
R_CUBIC_TO, -0.64, 0, -1.1, -0.28, -1.37, -0.84,
R_CUBIC_TO, -0.28, -0.56, -0.21, -1.09, 0.19, -1.58,
LINE_TO, 7.5, 9.5,
R_V_LINE_TO, -5,
R_H_LINE_TO, -0.75,
R_CUBIC_TO, -0.21, 0, -0.39, -0.07, -0.53, -0.21,
ARC_TO, 0.72, 0.72, 0, 0, 1, 6, 3.75,
R_CUBIC_TO, 0, -0.21, 0.07, -0.39, 0.22, -0.53,
ARC_TO, 0.73, 0.73, 0, 0, 1, 6.75, 3,
R_H_LINE_TO, 6.5,
R_CUBIC_TO, 0.21, 0, 0.39, 0.07, 0.54, 0.22,
R_CUBIC_TO, 0.14, 0.14, 0.22, 0.32, 0.22, 0.53,
R_CUBIC_TO, 0, 0.21, -0.07, 0.39, -0.21, 0.54,
R_ARC_TO, 0.73, 0.73, 0, 0, 1, -0.53, 0.22,
R_H_LINE_TO, -0.75,
R_V_LINE_TO, 5,
R_LINE_TO, 4.19, 5.08,
R_CUBIC_TO, 0.39, 0.49, 0.45, 1.01, 0.17, 1.57,
R_CUBIC_TO, -0.28, 0.56, -0.73, 0.84, -1.35, 0.84,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_H_LINE_TO, 11,
LINE_TO, 11, 10,
V_LINE_TO, 4.5,
H_LINE_TO, 9,
V_LINE_TO, 10,
CLOSE,
R_MOVE_TO, 5.52, -5.5,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kScience16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 3.6, 13.73,
R_CUBIC_TO, -0.57, 0, -0.98, -0.25, -1.22, -0.75,
R_CUBIC_TO, -0.25, -0.5, -0.19, -0.97, 0.17, -1.41,
R_LINE_TO, 3.32, -4.03,
V_LINE_TO, 3.69,
R_H_LINE_TO, -0.47,
R_ARC_TO, 0.68, 0.68, 0, 0, 1, -0.49, -0.2,
R_ARC_TO, 0.67, 0.67, 0, 0, 1, -0.2, -0.49,
R_ARC_TO, 0.67, 0.67, 0, 0, 1, 0.2, -0.49,
R_ARC_TO, 0.66, 0.66, 0, 0, 1, 0.49, -0.2,
R_H_LINE_TO, 5.23,
R_CUBIC_TO, 0.19, 0, 0.36, 0.07, 0.49, 0.2,
R_ARC_TO, 0.66, 0.66, 0, 0, 1, 0.2, 0.49,
R_ARC_TO, 0.67, 0.67, 0, 0, 1, -0.2, 0.49,
R_ARC_TO, 0.66, 0.66, 0, 0, 1, -0.49, 0.2,
R_H_LINE_TO, -0.48,
R_V_LINE_TO, 3.86,
R_LINE_TO, 3.32, 4.03,
R_CUBIC_TO, 0.35, 0.43, 0.4, 0.9, 0.15, 1.4,
R_CUBIC_TO, -0.25, 0.5, -0.65, 0.75, -1.21, 0.75,
CLOSE,
R_MOVE_TO, 0.1, -1.38,
R_H_LINE_TO, 8.59,
LINE_TO, 8.75, 8.02,
V_LINE_TO, 3.69,
H_LINE_TO, 7.25,
V_LINE_TO, 8.02,
CLOSE,
MOVE_TO, 8.02, 8.02,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kScienceRepList, kScienceIcon, {kSciencePath}, {kScience20Path}, {kScience16Path})
VECTOR_ICON_REP_TEMPLATE(kScreensaverAutoPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 4.2f, 6,
LINE_TO, 4.2f, 18,
CLOSE,
MOVE_TO, 4.2f, 19.8f,
CUBIC_TO, 3.7f, 19.8f, 3.28f, 19.63f, 2.93f, 19.27f,
CUBIC_TO, 2.58f, 18.92f, 2.4f, 18.5f, 2.4f, 18,
LINE_TO, 2.4f, 6,
CUBIC_TO, 2.4f, 5.5f, 2.58f, 5.08f, 2.93f, 4.73f,
CUBIC_TO, 3.28f, 4.38f, 3.7f, 4.2f, 4.2f, 4.2f,
LINE_TO, 10.8f, 4.2f,
LINE_TO, 10.8f, 6,
LINE_TO, 4.2f, 6,
LINE_TO, 4.2f, 18,
LINE_TO, 19.8f, 18,
LINE_TO, 19.8f, 12,
LINE_TO, 21.6f, 12,
LINE_TO, 21.6f, 18,
CUBIC_TO, 21.6f, 18.5f, 21.42f, 18.92f, 21.07f, 19.27f,
CUBIC_TO, 20.72f, 19.63f, 20.3f, 19.8f, 19.8f, 19.8f,
CLOSE,
MOVE_TO, 17.4f, 12,
CUBIC_TO, 17.4f, 10.5f, 16.88f, 9.22f, 15.83f, 8.17f,
CUBIC_TO, 14.78f, 7.13f, 13.5f, 6.6f, 12, 6.6f,
CUBIC_TO, 13.5f, 6.6f, 14.78f, 6.08f, 15.83f, 5.03f,
CUBIC_TO, 16.88f, 3.98f, 17.4f, 2.71f, 17.4f, 1.2f,
CUBIC_TO, 17.4f, 2.71f, 17.92f, 3.98f, 18.97f, 5.03f,
CUBIC_TO, 20.02f, 6.08f, 21.29f, 6.6f, 22.8f, 6.6f,
CUBIC_TO, 21.29f, 6.6f, 20.02f, 7.13f, 18.97f, 8.17f,
CUBIC_TO, 17.92f, 9.22f, 17.4f, 10.5f, 17.4f, 12,
CLOSE,
MOVE_TO, 17.4f, 12,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kScreensaverAutoRepList, kScreensaverAutoIcon, {kScreensaverAutoPath})
VECTOR_ICON_REP_TEMPLATE(kSearchMenuPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
R_MOVE_TO, 9.69, 13.15,
R_LINE_TO, 1.38, 1.38,
H_LINE_TO, 4.45,
R_CUBIC_TO, -0.38, 0, -0.71, -0.13, -0.98, -0.4,
R_ARC_TO, 1.34, 1.34, 0, 0, 1, -0.4, -0.98,
V_LINE_TO, 2.85,
R_CUBIC_TO, 0, -0.38, 0.13, -0.71, 0.4, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.4, 0.98, -0.4,
R_H_LINE_TO, 5.21,
R_LINE_TO, 3.28, 3.28,
R_V_LINE_TO, 7.99,
R_CUBIC_TO, 0, 0.41, -0.04, 0.73, -0.11, 0.95,
R_CUBIC_TO, -0.07, 0.22, -0.18, 0.38, -0.33, 0.49,
LINE_TO, 9.25, 10.92,
R_CUBIC_TO, -0.17, 0.11, -0.36, 0.2, -0.57, 0.25,
R_CUBIC_TO, -0.21, 0.05, -0.44, 0.07, -0.68, 0.07,
R_ARC_TO, 2.38, 2.38, 0, 0, 1, -1.75, -0.72,
R_CUBIC_TO, -0.48, -0.48, -0.72, -1.06, -0.72, -1.75,
R_CUBIC_TO, 0, -0.69, 0.24, -1.27, 0.72, -1.75,
ARC_TO, 2.39, 2.39, 0, 0, 1, 8, 6.3,
R_CUBIC_TO, 0.69, 0, 1.27, 0.24, 1.75, 0.72,
R_CUBIC_TO, 0.48, 0.48, 0.72, 1.06, 0.72, 1.75,
R_CUBIC_TO, 0, 0.25, -0.03, 0.47, -0.09, 0.69,
R_CUBIC_TO, -0.06, 0.22, -0.14, 0.41, -0.25, 0.57,
R_LINE_TO, 1.41, 1.4,
V_LINE_TO, 5.3,
LINE_TO, 9.1, 2.85,
H_LINE_TO, 4.45,
R_V_LINE_TO, 10.3,
CLOSE,
MOVE_TO, 8, 9.92,
R_CUBIC_TO, 0.32, 0, 0.59, -0.11, 0.81, -0.34,
R_CUBIC_TO, 0.22, -0.23, 0.34, -0.5, 0.34, -0.82,
R_CUBIC_TO, 0, -0.32, -0.11, -0.59, -0.34, -0.81,
R_ARC_TO, 1.13, 1.13, 0, 0, 0, -0.82, -0.34,
R_CUBIC_TO, -0.32, 0, -0.59, 0.11, -0.81, 0.34,
R_ARC_TO, 1.11, 1.11, 0, 0, 0, -0.34, 0.82,
R_CUBIC_TO, 0, 0.32, 0.11, 0.59, 0.34, 0.82,
R_CUBIC_TO, 0.23, 0.22, 0.5, 0.33, 0.82, 0.33,
CLOSE,
MOVE_TO, 8, 8.6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSearchMenuRepList, kSearchMenuIcon, {kSearchMenuPath})
VECTOR_ICON_REP_TEMPLATE(kSecurityPath, CANVAS_DIMENSIONS, 48,
MOVE_TO, 24, 2,
LINE_TO, 6, 10,
R_V_LINE_TO, 12,
R_CUBIC_TO, 0, 11.1, 7.67, 21.47, 18, 24,
R_CUBIC_TO, 10.33, -2.53, 18, -12.9, 18, -24,
V_LINE_TO, 10,
LINE_TO, 24, 2,
CLOSE,
R_MOVE_TO, 0, 21.98,
R_H_LINE_TO, 14,
R_CUBIC_TO, -1.06, 8.24, -6.55, 15.58, -14, 17.87,
V_LINE_TO, 24,
H_LINE_TO, 10,
V_LINE_TO, 12.6,
R_LINE_TO, 14, -6.22,
R_V_LINE_TO, 17.6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSecurityRepList, kSecurityIcon, {kSecurityPath})
VECTOR_ICON_REP_TEMPLATE(kSettingsMenuPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
R_MOVE_TO, 6.6, 14.54,
R_LINE_TO, -0.37, -1.94,
R_CUBIC_TO, -0.23, -0.09, -0.46, -0.2, -0.68, -0.32,
R_ARC_TO, 3.78, 3.78, 0, 0, 1, -0.62, -0.43,
R_LINE_TO, -1.87, 0.64,
R_LINE_TO, -1.4, -2.43,
R_LINE_TO, 1.48, -1.29,
R_ARC_TO, 6.3, 6.3, 0, 0, 1, -0.05, -0.37,
ARC_TO, 4.13, 4.13, 0, 0, 1, 3.06, 8,
R_CUBIC_TO, 0, -0.13, 0.01, -0.26, 0.02, -0.39,
R_CUBIC_TO, 0.01, -0.12, 0.03, -0.24, 0.05, -0.37,
LINE_TO, 1.64, 5.96,
R_LINE_TO, 1.4, -2.43,
R_LINE_TO, 1.88, 0.63,
R_CUBIC_TO, 0.2, -0.16, 0.4, -0.3, 0.62, -0.43,
R_CUBIC_TO, 0.22, -0.12, 0.45, -0.23, 0.68, -0.32,
R_LINE_TO, 0.38, -1.95,
R_H_LINE_TO, 2.8,
R_LINE_TO, 0.38, 1.95,
R_CUBIC_TO, 0.24, 0.09, 0.46, 0.2, 0.68, 0.32,
R_CUBIC_TO, 0.22, 0.12, 0.43, 0.26, 0.63, 0.43,
R_LINE_TO, 1.88, -0.63,
R_LINE_TO, 1.4, 2.43,
R_LINE_TO, -1.49, 1.29,
R_ARC_TO, 4.15, 4.15, 0, 0, 1, 0.06, 0.75,
R_ARC_TO, 4.15, 4.15, 0, 0, 1, -0.06, 0.75,
R_LINE_TO, 1.49, 1.29,
R_LINE_TO, -1.41, 2.43,
R_LINE_TO, -1.88, -0.64,
R_ARC_TO, 4.07, 4.07, 0, 0, 1, -0.62, 0.43,
R_ARC_TO, 5.2, 5.2, 0, 0, 1, -0.68, 0.32,
R_LINE_TO, -0.37, 1.95,
CLOSE,
R_MOVE_TO, 1.14, -1.38,
R_H_LINE_TO, 0.51,
R_LINE_TO, 0.32, -1.64,
R_ARC_TO, 3.73, 3.73, 0, 0, 0, 1.2, -0.44,
R_ARC_TO, 3.28, 3.28, 0, 0, 0, 0.96, -0.82,
R_LINE_TO, 1.59, 0.53,
R_LINE_TO, 0.25, -0.43,
R_LINE_TO, -1.25, -1.11,
R_CUBIC_TO, 0.07, -0.19, 0.12, -0.39, 0.16, -0.6,
R_CUBIC_TO, 0.04, -0.21, 0.06, -0.42, 0.06, -0.65,
R_CUBIC_TO, 0, -0.23, -0.02, -0.44, -0.06, -0.65,
R_CUBIC_TO, -0.04, -0.21, -0.09, -0.41, -0.16, -0.61,
R_LINE_TO, 1.26, -1.11,
R_LINE_TO, -0.26, -0.42,
R_LINE_TO, -1.59, 0.53,
R_ARC_TO, 3.4, 3.4, 0, 0, 0, -0.96, -0.82,
R_ARC_TO, 3.72, 3.72, 0, 0, 0, -1.2, -0.44,
R_LINE_TO, -0.32, -1.64,
R_H_LINE_TO, -0.52,
LINE_TO, 7.43, 4.48,
R_ARC_TO, 3.76, 3.76, 0, 0, 0, -1.21, 0.44,
R_ARC_TO, 3.42, 3.42, 0, 0, 0, -0.96, 0.82,
R_LINE_TO, -1.59, -0.53,
R_LINE_TO, -0.26, 0.43,
R_LINE_TO, 1.25, 1.11,
R_ARC_TO, 4.45, 4.45, 0, 0, 0, -0.16, 0.61,
R_CUBIC_TO, -0.04, 0.21, -0.06, 0.43, -0.06, 0.65,
R_CUBIC_TO, 0, 0.23, 0.02, 0.44, 0.06, 0.65,
R_CUBIC_TO, 0.04, 0.21, 0.09, 0.41, 0.16, 0.61,
R_LINE_TO, -1.25, 1.1,
R_LINE_TO, 0.26, 0.43,
R_LINE_TO, 1.59, -0.53,
R_CUBIC_TO, 0.27, 0.33, 0.59, 0.6, 0.97, 0.81,
R_CUBIC_TO, 0.38, 0.22, 0.78, 0.36, 1.2, 0.44,
CLOSE,
R_MOVE_TO, 0.25, -2.75,
R_ARC_TO, 2.3, 2.3, 0, 0, 0, 1.7, -0.7,
ARC_TO, 2.3, 2.3, 0, 0, 0, 10.39, 8,
R_ARC_TO, 2.3, 2.3, 0, 0, 0, -0.7, -1.7,
R_ARC_TO, 2.3, 2.3, 0, 0, 0, -1.7, -0.7,
R_CUBIC_TO, -0.66, 0, -1.23, 0.23, -1.7, 0.7,
ARC_TO, 2.3, 2.3, 0, 0, 0, 5.59, 8,
R_ARC_TO, 2.3, 2.3, 0, 0, 0, 0.7, 1.7,
R_CUBIC_TO, 0.47, 0.47, 1.03, 0.7, 1.7, 0.7,
CLOSE,
MOVE_TO, 8, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSettingsMenuRepList, kSettingsMenuIcon, {kSettingsMenuPath})
VECTOR_ICON_REP_TEMPLATE(kSharingHubScreenshotPath, CANVAS_DIMENSIONS, 18,
ROUND_RECT, 2, 2, 15, 15, 2,
CLOSE,
NEW_PATH,
PATH_MODE_CLEAR,
ROUND_RECT, 3, 3, 13, 13, 1.72,
CLOSE,
NEW_PATH,
PATH_MODE_CLEAR,
ROUND_RECT, 7.4, 0, 3.2, 18, 0,
ROUND_RECT, 0, 7.4, 18, 3.2, 0,
CLOSE,
NEW_PATH,
STROKE, 1,
MOVE_TO, 16.5, 12,
R_V_LINE_TO, 7,
MOVE_TO, 12, 16.5,
R_H_LINE_TO, 7,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSharingHubScreenshotRepList, kSharingHubScreenshotIcon, {kSharingHubScreenshotPath})
VECTOR_ICON_REP_TEMPLATE(kSidePanelPath, CANVAS_DIMENSIONS, 16,
FLIPS_IN_RTL,
MOVE_TO, 15, 1,
H_LINE_TO, 1,
V_LINE_TO, 15,
H_LINE_TO, 15,
V_LINE_TO, 1,
CLOSE,
MOVE_TO, 10, 3,
H_LINE_TO, 3,
V_LINE_TO, 13,
H_LINE_TO, 10,
V_LINE_TO, 3,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSidePanelRepList, kSidePanelIcon, {kSidePanelPath})
VECTOR_ICON_REP_TEMPLATE(kSmartphonePath, MOVE_TO, 34, 2.02,
LINE_TO, 14, 2,
R_CUBIC_TO, -2.21, 0, -4, 1.79, -4, 4,
R_V_LINE_TO, 36,
R_CUBIC_TO, 0, 2.21, 1.79, 4, 4, 4,
R_H_LINE_TO, 20,
R_CUBIC_TO, 2.21, 0, 4, -1.79, 4, -4,
V_LINE_TO, 6,
R_CUBIC_TO, 0, -2.21, -1.79, -3.98, -4, -3.98,
CLOSE,
MOVE_TO, 34, 38,
H_LINE_TO, 14,
V_LINE_TO, 10,
R_H_LINE_TO, 20,
R_V_LINE_TO, 28,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSmartphoneRepList, kSmartphoneIcon, {kSmartphonePath})
VECTOR_ICON_REP_TEMPLATE(kSmartphoneRefreshPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 5.57, 19.16,
R_CUBIC_TO, -0.48, 0, -0.89, -0.17, -1.22, -0.51,
R_ARC_TO, 1.67, 1.67, 0, 0, 1, -0.51, -1.22,
V_LINE_TO, 2.57,
R_CUBIC_TO, 0, -0.48, 0.17, -0.89, 0.51, -1.22,
ARC_TO, 1.67, 1.67, 0, 0, 1, 5.57, 0.84,
R_H_LINE_TO, 8.85,
R_CUBIC_TO, 0.48, 0, 0.89, 0.17, 1.22, 0.51,
R_CUBIC_TO, 0.34, 0.34, 0.51, 0.75, 0.51, 1.22,
R_V_LINE_TO, 14.85,
R_CUBIC_TO, 0, 0.48, -0.17, 0.89, -0.51, 1.22,
R_ARC_TO, 1.67, 1.67, 0, 0, 1, -1.22, 0.51,
CLOSE,
R_MOVE_TO, 0, -2.73,
R_V_LINE_TO, 1,
R_H_LINE_TO, 8.85,
R_V_LINE_TO, -1,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_H_LINE_TO, 8.85,
V_LINE_TO, 5.07,
H_LINE_TO, 5.57,
CLOSE,
R_MOVE_TO, 0, -11.35,
R_H_LINE_TO, 8.85,
R_V_LINE_TO, -1,
H_LINE_TO, 5.57,
CLOSE,
R_MOVE_TO, 0, 0,
R_V_LINE_TO, -1,
CLOSE,
R_MOVE_TO, 0, 12.85,
R_V_LINE_TO, 1,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSmartphoneRefreshRepList, kSmartphoneRefreshIcon, {kSmartphoneRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kSpeakerPath, CANVAS_DIMENSIONS, 960,
FILL_RULE_NONZERO,
MOVE_TO, 680, 880,
H_LINE_TO, 280,
R_QUADRATIC_TO, -33, 0, -56.5, -23.5,
QUADRATIC_TO_SHORTHAND, 200, 800,
R_V_LINE_TO, -640,
R_QUADRATIC_TO, 0, -33, 23.5, -56.5,
QUADRATIC_TO_SHORTHAND, 280, 80,
R_H_LINE_TO, 400,
R_QUADRATIC_TO, 33, 0, 56.5, 23.5,
QUADRATIC_TO_SHORTHAND, 760, 160,
R_V_LINE_TO, 640,
R_QUADRATIC_TO, 0, 33, -23.5, 56.5,
QUADRATIC_TO_SHORTHAND, 680, 880,
CLOSE,
R_MOVE_TO, 0, -80,
R_V_LINE_TO, -640,
H_LINE_TO, 280,
R_V_LINE_TO, 640,
R_H_LINE_TO, 400,
CLOSE,
MOVE_TO, 480, 360,
R_QUADRATIC_TO, 33, 0, 56.5, -23.5,
QUADRATIC_TO_SHORTHAND, 560, 280,
R_QUADRATIC_TO, 0, -33, -23.5, -56.5,
QUADRATIC_TO_SHORTHAND, 480, 200,
R_QUADRATIC_TO, -33, 0, -56.5, 23.5,
QUADRATIC_TO_SHORTHAND, 400, 280,
R_QUADRATIC_TO, 0, 33, 23.5, 56.5,
QUADRATIC_TO_SHORTHAND, 480, 360,
CLOSE,
R_MOVE_TO, 0, 400,
R_QUADRATIC_TO, 66, 0, 113, -47,
R_QUADRATIC_TO, 47, -47, 47, -113,
R_QUADRATIC_TO, 0, -66, -47, -113,
R_QUADRATIC_TO, -47, -47, -113, -47,
R_QUADRATIC_TO, -66, 0, -113, 47,
R_QUADRATIC_TO, -47, 47, -47, 113,
R_QUADRATIC_TO, 0, 66, 47, 113,
R_QUADRATIC_TO, 47, 47, 113, 47,
CLOSE,
R_MOVE_TO, 0, -80,
R_QUADRATIC_TO, -33, 0, -56.5, -23.5,
QUADRATIC_TO_SHORTHAND, 400, 600,
R_QUADRATIC_TO, 0, -33, 23.5, -56.5,
QUADRATIC_TO_SHORTHAND, 480, 520,
R_QUADRATIC_TO, 33, 0, 56.5, 23.5,
QUADRATIC_TO_SHORTHAND, 560, 600,
R_QUADRATIC_TO, 0, 33, -23.5, 56.5,
QUADRATIC_TO_SHORTHAND, 480, 680,
CLOSE,
MOVE_TO, 280, 160,
R_V_LINE_TO, 640,
R_V_LINE_TO, -640,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSpeakerRepList, kSpeakerIcon, {kSpeakerPath})
VECTOR_ICON_REP_TEMPLATE(kSpeakerGroupPath, CANVAS_DIMENSIONS, 960,
FILL_RULE_NONZERO,
MOVE_TO, 400, 680,
R_H_LINE_TO, 360,
R_V_LINE_TO, -560,
H_LINE_TO, 400,
R_V_LINE_TO, 560,
CLOSE,
R_MOVE_TO, 0, 80,
R_QUADRATIC_TO, -33, 0, -56.5, -23.5,
QUADRATIC_TO_SHORTHAND, 320, 680,
R_V_LINE_TO, -560,
R_QUADRATIC_TO, 0, -33, 23.5, -56.5,
QUADRATIC_TO_SHORTHAND, 400, 40,
R_H_LINE_TO, 360,
R_QUADRATIC_TO, 33, 0, 56.5, 23.5,
QUADRATIC_TO_SHORTHAND, 840, 120,
R_V_LINE_TO, 560,
R_QUADRATIC_TO, 0, 33, -23.5, 56.5,
QUADRATIC_TO_SHORTHAND, 760, 760,
H_LINE_TO, 400,
CLOSE,
R_MOVE_TO, 180, -460,
R_QUADRATIC_TO, 25, 0, 42.5, -17.5,
QUADRATIC_TO_SHORTHAND, 640, 240,
R_QUADRATIC_TO, 0, -25, -17.5, -42.5,
QUADRATIC_TO_SHORTHAND, 580, 180,
R_QUADRATIC_TO, -25, 0, -42.5, 17.5,
QUADRATIC_TO_SHORTHAND, 520, 240,
R_QUADRATIC_TO, 0, 25, 17.5, 42.5,
QUADRATIC_TO_SHORTHAND, 580, 300,
CLOSE,
R_MOVE_TO, 0, 340,
R_QUADRATIC_TO, 58, 0, 99, -41,
R_QUADRATIC_TO, 41, -41, 41, -99,
R_QUADRATIC_TO, 0, -58, -41, -99,
R_QUADRATIC_TO, -41, -41, -99, -41,
R_QUADRATIC_TO, -58, 0, -99, 41,
R_QUADRATIC_TO, -41, 41, -41, 99,
R_QUADRATIC_TO, 0, 58, 41, 99,
R_QUADRATIC_TO, 41, 41, 99, 41,
CLOSE,
R_MOVE_TO, 0, -80,
R_QUADRATIC_TO, -25, 0, -42.5, -17.5,
QUADRATIC_TO_SHORTHAND, 520, 500,
R_QUADRATIC_TO, 0, -25, 17.5, -42.5,
QUADRATIC_TO_SHORTHAND, 580, 440,
R_QUADRATIC_TO, 25, 0, 42.5, 17.5,
QUADRATIC_TO_SHORTHAND, 640, 500,
R_QUADRATIC_TO, 0, 25, -17.5, 42.5,
QUADRATIC_TO_SHORTHAND, 580, 560,
CLOSE,
R_MOVE_TO, 60, 360,
H_LINE_TO, 240,
R_QUADRATIC_TO, -33, 0, -56.5, -23.5,
QUADRATIC_TO_SHORTHAND, 160, 840,
R_V_LINE_TO, -640,
R_H_LINE_TO, 80,
R_V_LINE_TO, 640,
R_H_LINE_TO, 400,
R_V_LINE_TO, 80,
CLOSE,
MOVE_TO, 400, 120,
R_V_LINE_TO, 560,
R_V_LINE_TO, -560,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSpeakerGroupRepList, kSpeakerGroupIcon, {kSpeakerGroupPath})
VECTOR_ICON_REP_TEMPLATE(kSplitScenePath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 5, 20,
CUBIC_TO, 4.45f, 20, 3.98f, 19.8f, 3.59f, 19.41f,
CUBIC_TO, 3.2f, 19.02f, 3, 18.55f, 3, 18,
LINE_TO, 3, 6,
CUBIC_TO, 3, 5.45f, 3.2f, 4.98f, 3.59f, 4.59f,
CUBIC_TO, 3.98f, 4.2f, 4.45f, 4, 5, 4,
LINE_TO, 9, 4,
LINE_TO, 9, 6,
LINE_TO, 5, 6,
LINE_TO, 5, 18,
LINE_TO, 9, 18,
LINE_TO, 9, 20,
CLOSE,
MOVE_TO, 11, 22,
LINE_TO, 11, 2,
LINE_TO, 13, 2,
LINE_TO, 13, 4,
LINE_TO, 19, 4,
CUBIC_TO, 19.55f, 4, 20.02f, 4.2f, 20.41f, 4.59f,
CUBIC_TO, 20.8f, 4.98f, 21, 5.45f, 21, 6,
LINE_TO, 21, 18,
CUBIC_TO, 21, 18.55f, 20.8f, 19.02f, 20.41f, 19.41f,
CUBIC_TO, 20.02f, 19.8f, 19.55f, 20, 19, 20,
LINE_TO, 13, 20,
LINE_TO, 13, 22,
CLOSE,
MOVE_TO, 13, 18,
LINE_TO, 19, 18,
LINE_TO, 19, 6,
LINE_TO, 13, 6,
CLOSE,
MOVE_TO, 5, 18,
LINE_TO, 5, 6,
CLOSE,
MOVE_TO, 19, 18,
LINE_TO, 19, 6,
CLOSE,
MOVE_TO, 19, 18,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSplitSceneRepList, kSplitSceneIcon, {kSplitScenePath})
VECTOR_ICON_REP_TEMPLATE(kSplitSceneDownPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 4, 9,
LINE_TO, 4, 5,
CUBIC_TO, 4, 4.45f, 4.2f, 3.98f, 4.59f, 3.59f,
CUBIC_TO, 4.98f, 3.2f, 5.45f, 3, 6, 3,
LINE_TO, 18, 3,
CUBIC_TO, 18.55f, 3, 19.02f, 3.2f, 19.41f, 3.59f,
CUBIC_TO, 19.8f, 3.98f, 20, 4.45f, 20, 5,
LINE_TO, 20, 9,
LINE_TO, 18, 9,
LINE_TO, 18, 5,
LINE_TO, 6, 5,
LINE_TO, 6, 9,
CLOSE,
MOVE_TO, 6, 21,
CUBIC_TO, 5.45f, 21, 4.98f, 20.8f, 4.59f, 20.41f,
CUBIC_TO, 4.2f, 20.02f, 4, 19.55f, 4, 19,
LINE_TO, 4, 13,
LINE_TO, 2, 13,
LINE_TO, 2, 11,
LINE_TO, 22, 11,
LINE_TO, 22, 13,
LINE_TO, 20, 13,
LINE_TO, 20, 19,
CUBIC_TO, 20, 19.55f, 19.8f, 20.02f, 19.41f, 20.41f,
CUBIC_TO, 19.02f, 20.8f, 18.55f, 21, 18, 21,
CLOSE,
MOVE_TO, 6, 5,
LINE_TO, 18, 5,
CLOSE,
MOVE_TO, 6, 5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSplitSceneDownRepList, kSplitSceneDownIcon, {kSplitSceneDownPath})
VECTOR_ICON_REP_TEMPLATE(kSplitSceneLeftPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 15, 20,
LINE_TO, 15, 18,
LINE_TO, 19, 18,
LINE_TO, 19, 6,
LINE_TO, 15, 6,
LINE_TO, 15, 4,
LINE_TO, 19, 4,
CUBIC_TO, 19.55f, 4, 20.02f, 4.2f, 20.41f, 4.59f,
CUBIC_TO, 20.8f, 4.98f, 21, 5.45f, 21, 6,
LINE_TO, 21, 18,
CUBIC_TO, 21, 18.55f, 20.8f, 19.02f, 20.41f, 19.41f,
CUBIC_TO, 20.02f, 19.8f, 19.55f, 20, 19, 20,
CLOSE,
MOVE_TO, 11, 22,
LINE_TO, 11, 20,
LINE_TO, 5, 20,
CUBIC_TO, 4.45f, 20, 3.98f, 19.8f, 3.59f, 19.41f,
CUBIC_TO, 3.2f, 19.02f, 3, 18.55f, 3, 18,
LINE_TO, 3, 6,
CUBIC_TO, 3, 5.45f, 3.2f, 4.98f, 3.59f, 4.59f,
CUBIC_TO, 3.98f, 4.2f, 4.45f, 4, 5, 4,
LINE_TO, 11, 4,
LINE_TO, 11, 2,
LINE_TO, 13, 2,
LINE_TO, 13, 22,
CLOSE,
MOVE_TO, 19, 6,
LINE_TO, 19, 18,
CLOSE,
MOVE_TO, 19, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSplitSceneLeftRepList, kSplitSceneLeftIcon, {kSplitSceneLeftPath})
VECTOR_ICON_REP_TEMPLATE(kSplitSceneRightPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 5, 20,
CUBIC_TO, 4.45f, 20, 3.98f, 19.8f, 3.59f, 19.41f,
CUBIC_TO, 3.2f, 19.02f, 3, 18.55f, 3, 18,
LINE_TO, 3, 6,
CUBIC_TO, 3, 5.45f, 3.2f, 4.98f, 3.59f, 4.59f,
CUBIC_TO, 3.98f, 4.2f, 4.45f, 4, 5, 4,
LINE_TO, 9, 4,
LINE_TO, 9, 6,
LINE_TO, 5, 6,
LINE_TO, 5, 18,
LINE_TO, 9, 18,
LINE_TO, 9, 20,
CLOSE,
MOVE_TO, 11, 22,
LINE_TO, 11, 2,
LINE_TO, 13, 2,
LINE_TO, 13, 4,
LINE_TO, 19, 4,
CUBIC_TO, 19.55f, 4, 20.02f, 4.2f, 20.41f, 4.59f,
CUBIC_TO, 20.8f, 4.98f, 21, 5.45f, 21, 6,
LINE_TO, 21, 18,
CUBIC_TO, 21, 18.55f, 20.8f, 19.02f, 20.41f, 19.41f,
CUBIC_TO, 20.02f, 19.8f, 19.55f, 20, 19, 20,
LINE_TO, 13, 20,
LINE_TO, 13, 22,
CLOSE,
MOVE_TO, 5, 18,
LINE_TO, 5, 6,
CLOSE,
MOVE_TO, 5, 18,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSplitSceneRightRepList, kSplitSceneRightIcon, {kSplitSceneRightPath})
VECTOR_ICON_REP_TEMPLATE(kSplitSceneUpPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 6, 21,
CUBIC_TO, 5.45f, 21, 4.98f, 20.8f, 4.59f, 20.41f,
CUBIC_TO, 4.2f, 20.02f, 4, 19.55f, 4, 19,
LINE_TO, 4, 15,
LINE_TO, 6, 15,
LINE_TO, 6, 19,
LINE_TO, 18, 19,
LINE_TO, 18, 15,
LINE_TO, 20, 15,
LINE_TO, 20, 19,
CUBIC_TO, 20, 19.55f, 19.8f, 20.02f, 19.41f, 20.41f,
CUBIC_TO, 19.02f, 20.8f, 18.55f, 21, 18, 21,
CLOSE,
MOVE_TO, 2, 13,
LINE_TO, 2, 11,
LINE_TO, 4, 11,
LINE_TO, 4, 5,
CUBIC_TO, 4, 4.45f, 4.2f, 3.98f, 4.59f, 3.59f,
CUBIC_TO, 4.98f, 3.2f, 5.45f, 3, 6, 3,
LINE_TO, 18, 3,
CUBIC_TO, 18.55f, 3, 19.02f, 3.2f, 19.41f, 3.59f,
CUBIC_TO, 19.8f, 3.98f, 20, 4.45f, 20, 5,
LINE_TO, 20, 11,
LINE_TO, 22, 11,
LINE_TO, 22, 13,
CLOSE,
MOVE_TO, 18, 19,
LINE_TO, 6, 19,
CLOSE,
MOVE_TO, 18, 19,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSplitSceneUpRepList, kSplitSceneUpIcon, {kSplitSceneUpPath})
VECTOR_ICON_REP_TEMPLATE(kSubmitFeedbackPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 10, 12.5,
R_CUBIC_TO, 0.21, 0, 0.39, -0.07, 0.54, -0.21,
R_ARC_TO, 0.72, 0.72, 0, 0, 0, 0.22, -0.53,
R_CUBIC_TO, 0, -0.21, -0.07, -0.39, -0.21, -0.53,
R_ARC_TO, 0.72, 0.72, 0, 0, 0, -0.53, -0.22,
R_CUBIC_TO, -0.21, 0, -0.39, 0.07, -0.53, 0.22,
R_ARC_TO, 0.72, 0.72, 0, 0, 0, -0.22, 0.53,
R_CUBIC_TO, 0, 0.21, 0.07, 0.39, 0.22, 0.54,
R_CUBIC_TO, 0.14, 0.14, 0.32, 0.22, 0.53, 0.22,
CLOSE,
MOVE_TO, 9.25, 10,
R_H_LINE_TO, 1.5,
V_LINE_TO, 4.5,
R_H_LINE_TO, -1.5,
CLOSE,
MOVE_TO, 2, 18,
V_LINE_TO, 3.5,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 3.5, 2,
R_H_LINE_TO, 13,
R_CUBIC_TO, 0.41, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 10,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 16.5, 15,
H_LINE_TO, 5,
CLOSE,
R_MOVE_TO, 2.38, -4.5,
H_LINE_TO, 16.5,
R_V_LINE_TO, -10,
R_H_LINE_TO, -13,
R_V_LINE_TO, 10.88,
CLOSE,
R_MOVE_TO, -0.87, 0,
R_V_LINE_TO, -10,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSubmitFeedbackRepList, kSubmitFeedbackIcon, {kSubmitFeedbackPath})
VECTOR_ICON_REP_TEMPLATE(kSupervisorAccountCirclePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 11.99, 2,
R_CUBIC_TO, -5.52, 0, -10, 4.48, -10, 10,
R_CUBIC_TO, 0, 5.52, 4.48, 10, 10, 10,
R_CUBIC_TO, 5.52, 0, 10, -4.48, 10, -10,
R_CUBIC_TO, 0, -5.52, -4.48, -10, -10, -10,
CLOSE,
R_MOVE_TO, 3.61, 6.34,
R_CUBIC_TO, 1.07, 0, 1.93, 0.86, 1.93, 1.93,
R_CUBIC_TO, 0, 1.07, -0.86, 1.93, -1.93, 1.93,
R_CUBIC_TO, -1.07, 0, -1.93, -0.86, -1.93, -1.93,
R_CUBIC_TO, -0.01, -1.07, 0.86, -1.93, 1.93, -1.93,
CLOSE,
R_MOVE_TO, -6, -1.58,
R_CUBIC_TO, 1.3, 0, 2.36, 1.06, 2.36, 2.36,
R_CUBIC_TO, 0, 1.3, -1.06, 2.36, -2.36, 2.36,
R_CUBIC_TO, -1.3, 0, -2.36, -1.06, -2.36, -2.36,
R_CUBIC_TO, 0, -1.31, 1.05, -2.36, 2.36, -2.36,
CLOSE,
R_MOVE_TO, 0, 9.13,
R_V_LINE_TO, 3.75,
R_CUBIC_TO, -2.4, -0.75, -4.3, -2.6, -5.14, -4.96,
R_CUBIC_TO, 1.05, -1.12, 3.67, -1.69, 5.14, -1.69,
R_CUBIC_TO, 0.53, 0, 1.2, 0.08, 1.9, 0.22,
R_CUBIC_TO, -1.64, 0.87, -1.9, 2.02, -1.9, 2.68,
CLOSE,
MOVE_TO, 11.99, 20,
R_CUBIC_TO, -0.27, 0, -0.53, -0.01, -0.79, -0.04,
R_V_LINE_TO, -4.07,
R_CUBIC_TO, 0, -1.42, 2.94, -2.13, 4.4, -2.13,
R_CUBIC_TO, 1.07, 0, 2.92, 0.39, 3.84, 1.15,
R_CUBIC_TO, -1.17, 2.97, -4.06, 5.09, -7.45, 5.09,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSupervisorAccountCircleRepList, kSupervisorAccountCircleIcon, {kSupervisorAccountCirclePath})
VECTOR_ICON_REP_TEMPLATE(kSyncChromeRefreshPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 4.51, 16.1,
R_V_LINE_TO, -1.58,
R_H_LINE_TO, 1.38,
R_LINE_TO, 0.07, 0.05,
R_ARC_TO, 6.67, 6.67, 0, 0, 1, -1.51, -2.03,
ARC_TO, 5.79, 5.79, 0, 0, 1, 3.88, 10,
R_CUBIC_TO, 0, -1.46, 0.45, -2.73, 1.35, -3.82,
R_ARC_TO, 6.1, 6.1, 0, 0, 1, 3.4, -2.12,
R_V_LINE_TO, 1.79,
R_ARC_TO, 4.41, 4.41, 0, 0, 0, -2.17, 1.56,
R_CUBIC_TO, -0.57, 0.75, -0.85, 1.61, -0.85, 2.59,
R_CUBIC_TO, 0, 0.65, 0.13, 1.25, 0.4, 1.8,
R_ARC_TO, 4.45, 4.45, 0, 0, 0, 1.07, 1.43,
R_LINE_TO, -0.04, -0.04,
V_LINE_TO, 12,
R_H_LINE_TO, 1.57,
R_V_LINE_TO, 4.1,
CLOSE,
R_MOVE_TO, 6.86, -0.16,
R_V_LINE_TO, -1.79,
R_ARC_TO, 4.41, 4.41, 0, 0, 0, 2.17, -1.56,
R_CUBIC_TO, 0.57, -0.75, 0.85, -1.61, 0.85, -2.59,
R_CUBIC_TO, 0, -0.65, -0.13, -1.25, -0.4, -1.8,
R_ARC_TO, 4.45, 4.45, 0, 0, 0, -1.07, -1.43,
R_LINE_TO, 0.04, 0.04,
V_LINE_TO, 8,
R_H_LINE_TO, -1.57,
V_LINE_TO, 3.9,
R_H_LINE_TO, 4.09,
R_V_LINE_TO, 1.58,
R_H_LINE_TO, -1.37,
R_LINE_TO, -0.07, -0.05,
R_ARC_TO, 6.38, 6.38, 0, 0, 1, 1.52, 2.03,
R_CUBIC_TO, 0.38, 0.79, 0.56, 1.63, 0.56, 2.55,
R_CUBIC_TO, 0, 1.46, -0.45, 2.73, -1.35, 3.82,
R_ARC_TO, 6.1, 6.1, 0, 0, 1, -3.4, 2.12,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSyncChromeRefreshRepList, kSyncChromeRefreshIcon, {kSyncChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kSyncCirclePath, CANVAS_DIMENSIONS, 16,
CIRCLE, 8, 8, 8,
MOVE_TO, 8, 11,
R_CUBIC_TO, -1.65, 0, -3, -1.34, -3, -3,
R_CUBIC_TO, 0, -0.5, 0.13, -0.98, 0.35, -1.4,
R_LINE_TO, -0.73, -0.73,
CUBIC_TO, 4.23, 6.49, 4, 7.22, 4, 8,
R_CUBIC_TO, 0, 2.21, 1.79, 4, 4, 4,
R_V_LINE_TO, 1.5,
R_LINE_TO, 2, -2,
R_LINE_TO, -2, -2,
V_LINE_TO, 11,
CLOSE,
R_MOVE_TO, 0, -7,
V_LINE_TO, 2.5,
R_LINE_TO, -2, 2,
R_LINE_TO, 2, 2,
V_LINE_TO, 5,
R_CUBIC_TO, 1.66, 0, 3, 1.35, 3, 3,
R_CUBIC_TO, 0, 0.51, -0.12, 0.99, -0.35, 1.4,
R_LINE_TO, 0.73, 0.73,
R_CUBIC_TO, 0.39, -0.61, 0.62, -1.34, 0.62, -2.13,
R_CUBIC_TO, 0, -2.21, -1.79, -4, -4, -4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSyncCircleRepList, kSyncCircleIcon, {kSyncCirclePath})
VECTOR_ICON_REP_TEMPLATE(kSyncErrorCirclePath, CANVAS_DIMENSIONS, 16,
CIRCLE, 8, 8, 8,
MOVE_TO, 3.5, 8,
R_CUBIC_TO, 0, 1.11, 0.46, 2.1, 1.18, 2.82,
LINE_TO, 3.5, 12,
R_H_LINE_TO, 3,
V_LINE_TO, 9,
R_LINE_TO, -1.12, 1.12,
CUBIC_TO, 4.84, 9.57, 4.5, 8.83, 4.5, 8,
R_CUBIC_TO, 0, -1.3, 0.84, -2.41, 2, -2.82,
V_LINE_TO, 4.13,
R_CUBIC_TO, -1.72, 0.45, -3, 2.01, -3, 3.87,
CLOSE,
R_MOVE_TO, 4, 2.5,
R_H_LINE_TO, 1,
R_V_LINE_TO, -1,
R_H_LINE_TO, -1,
R_V_LINE_TO, 1,
CLOSE,
R_MOVE_TO, 5, -6.5,
R_H_LINE_TO, -3,
R_V_LINE_TO, 3,
R_LINE_TO, 1.12, -1.12,
R_CUBIC_TO, 0.54, 0.55, 0.88, 1.29, 0.88, 2.12,
R_CUBIC_TO, 0, 1.31, -0.83, 2.42, -2, 2.83,
R_V_LINE_TO, 1.05,
R_CUBIC_TO, 1.73, -0.44, 3, -2, 3, -3.87,
R_CUBIC_TO, 0, -1.1, -0.45, -2.1, -1.18, -2.82,
LINE_TO, 12.5, 4,
CLOSE,
R_MOVE_TO, -5, 4.5,
R_H_LINE_TO, 1,
R_V_LINE_TO, -3,
R_H_LINE_TO, -1,
R_V_LINE_TO, 3,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSyncErrorCircleRepList, kSyncErrorCircleIcon, {kSyncErrorCirclePath})
VECTOR_ICON_REP_TEMPLATE(kSyncPausedCirclePath, CANVAS_DIMENSIONS, 16,
CIRCLE, 8, 8, 8,
MOVE_TO, 2, 2,
R_H_LINE_TO, 12,
R_V_LINE_TO, 12,
H_LINE_TO, 2,
V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, 0,
R_H_LINE_TO, 12,
R_V_LINE_TO, 12,
H_LINE_TO, 2,
V_LINE_TO, 2,
CLOSE,
MOVE_TO, 7, 5.18,
V_LINE_TO, 4.13,
R_CUBIC_TO, -0.4, 0.11, -0.77, 0.27, -1.11, 0.48,
R_LINE_TO, 0.73, 0.73,
R_CUBIC_TO, 0.13, -0.06, 0.25, -0.12, 0.39, -0.16,
CLOSE,
R_MOVE_TO, -3.57, -0.47,
R_LINE_TO, 1.18, 1.18,
R_ARC_TO, 3.96, 3.96, 0, 0, 0, 0.57, 4.93,
LINE_TO, 4, 12,
R_H_LINE_TO, 3,
V_LINE_TO, 9,
R_LINE_TO, -1.12, 1.12,
ARC_TO, 3, 3, 0, 0, 1, 5, 8,
R_CUBIC_TO, 0, -0.5, 0.13, -0.97, 0.34, -1.38,
R_LINE_TO, 4.04, 4.04,
R_CUBIC_TO, -0.12, 0.07, -0.25, 0.13, -0.38, 0.17,
R_V_LINE_TO, 1.05,
R_CUBIC_TO, 0.4, -0.1, 0.78, -0.27, 1.12, -0.48,
R_LINE_TO, 1.18, 1.18,
R_LINE_TO, 0.64, -0.63,
LINE_TO, 4.07, 4.07,
R_LINE_TO, -0.64, 0.64,
CLOSE,
MOVE_TO, 12, 4,
H_LINE_TO, 9,
R_V_LINE_TO, 3,
R_LINE_TO, 1.12, -1.12,
R_CUBIC_TO, 0.54, 0.55, 0.88, 1.29, 0.88, 2.12,
R_CUBIC_TO, 0, 0.5, -0.12, 0.97, -0.34, 1.39,
R_LINE_TO, 0.73, 0.73,
R_ARC_TO, 3.96, 3.96, 0, 0, 0, -0.57, -4.93,
LINE_TO, 12, 4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSyncPausedCircleRepList, kSyncPausedCircleIcon, {kSyncPausedCirclePath})
VECTOR_ICON_REP_TEMPLATE(kSyncRefreshPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 3.61, 12.88,
V_LINE_TO, 11.62,
R_H_LINE_TO, 1.1,
R_LINE_TO, 0.05, 0.04,
R_ARC_TO, 5.3, 5.3, 0, 0, 1, -1.21, -1.63,
ARC_TO, 4.57, 4.57, 0, 0, 1, 3.1, 8,
R_CUBIC_TO, 0, -1.16, 0.36, -2.18, 1.08, -3.06,
R_ARC_TO, 4.88, 4.88, 0, 0, 1, 2.72, -1.7,
R_V_LINE_TO, 1.43,
R_ARC_TO, 3.49, 3.49, 0, 0, 0, -1.73, 1.25,
R_CUBIC_TO, -0.45, 0.6, -0.68, 1.29, -0.68, 2.07,
R_CUBIC_TO, 0, 0.52, 0.11, 1, 0.32, 1.44,
R_CUBIC_TO, 0.22, 0.45, 0.5, 0.83, 0.86, 1.14,
R_LINE_TO, -0.03, -0.03,
V_LINE_TO, 9.6,
R_H_LINE_TO, 1.26,
R_V_LINE_TO, 3.28,
CLOSE,
R_MOVE_TO, 5.49, -0.12,
R_V_LINE_TO, -1.43,
R_ARC_TO, 3.49, 3.49, 0, 0, 0, 1.73, -1.25,
R_CUBIC_TO, 0.45, -0.6, 0.68, -1.29, 0.68, -2.07,
R_CUBIC_TO, 0, -0.52, -0.11, -1, -0.32, -1.44,
R_ARC_TO, 3.61, 3.61, 0, 0, 0, -0.85, -1.14,
R_LINE_TO, 0.03, 0.03,
R_V_LINE_TO, 0.95,
H_LINE_TO, 9.12,
V_LINE_TO, 3.12,
R_H_LINE_TO, 3.27,
V_LINE_TO, 4.38,
R_H_LINE_TO, -1.1,
R_LINE_TO, -0.05, -0.04,
R_CUBIC_TO, 0.51, 0.46, 0.91, 1, 1.21, 1.63,
R_CUBIC_TO, 0.3, 0.63, 0.45, 1.31, 0.45, 2.04,
R_CUBIC_TO, 0, 1.16, -0.36, 2.18, -1.08, 3.06,
R_ARC_TO, 4.88, 4.88, 0, 0, 1, -2.72, 1.7,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSyncRefreshRepList, kSyncRefreshIcon, {kSyncRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kTabPath, MOVE_TO, 42, 6,
H_LINE_TO, 6,
R_CUBIC_TO, -2.21, 0, -4, 1.79, -4, 4,
R_V_LINE_TO, 28,
R_CUBIC_TO, 0, 2.21, 1.79, 4, 4, 4,
R_H_LINE_TO, 36,
R_CUBIC_TO, 2.21, 0, 4, -1.79, 4, -4,
V_LINE_TO, 10,
R_CUBIC_TO, 0, -2.21, -1.79, -4, -4, -4,
CLOSE,
R_MOVE_TO, 0, 32,
H_LINE_TO, 6,
V_LINE_TO, 10,
R_H_LINE_TO, 20,
R_V_LINE_TO, 8,
R_H_LINE_TO, 16,
R_V_LINE_TO, 20,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTabRepList, kTabIcon, {kTabPath})
VECTOR_ICON_REP_TEMPLATE(kTabAudioPath, CANVAS_DIMENSIONS, 32,
MOVE_TO, 17, 7,
R_V_LINE_TO, 18,
R_LINE_TO, -6, -6,
R_H_LINE_TO, -4,
R_V_LINE_TO, -6,
R_H_LINE_TO, 4,
CLOSE,
MOVE_TO, 19, 13,
R_V_LINE_TO, 6,
R_H_LINE_TO, 2,
R_V_LINE_TO, -6,
CLOSE,
MOVE_TO, 23, 11,
R_V_LINE_TO, 10,
R_H_LINE_TO, 2,
R_V_LINE_TO, -10,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kTabAudio16Path, CANVAS_DIMENSIONS, 16,
DISABLE_AA,
MOVE_TO, 9, 2,
R_V_LINE_TO, 11,
R_LINE_TO, -4, -4,
R_H_LINE_TO, -1,
R_V_LINE_TO, -3,
R_H_LINE_TO, 1,
CLOSE,
NEW_PATH,
STROKE, 1,
MOVE_TO, 10.5, 6,
R_V_LINE_TO, 3,
MOVE_TO, 12.5, 5,
R_V_LINE_TO, 5)
VECTOR_ICON_TEMPLATE_CC(kTabAudioRepList, kTabAudioIcon, {kTabAudioPath}, {kTabAudio16Path})
VECTOR_ICON_REP_TEMPLATE(kTabCloseInactivePath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 9.2, 14.4,
V_LINE_TO, 13.2,
R_H_LINE_TO, 2.4,
R_V_LINE_TO, 1.2,
CLOSE,
R_MOVE_TO, -3.6, 0,
V_LINE_TO, 13.2,
H_LINE_TO, 8,
R_V_LINE_TO, 1.2,
CLOSE,
MOVE_TO, 2.8, 6.8,
H_LINE_TO, 1.6,
V_LINE_TO, 4.4,
R_H_LINE_TO, 1.2,
CLOSE,
R_MOVE_TO, 0, 3.6,
H_LINE_TO, 1.6,
V_LINE_TO, 8,
R_H_LINE_TO, 1.2,
CLOSE,
R_MOVE_TO, 1.6, 4,
H_LINE_TO, 2.8,
R_CUBIC_TO, -0.33, 0, -0.61, -0.12, -0.85, -0.35,
R_ARC_TO, 1.15, 1.15, 0, 0, 1, -0.35, -0.85,
R_V_LINE_TO, -1.6,
H_LINE_TO, 2.8,
R_V_LINE_TO, 1.6,
R_H_LINE_TO, 1.6,
CLOSE,
MOVE_TO, 7.65, 9.2,
LINE_TO, 9.2, 7.65,
R_LINE_TO, 1.55, 1.55,
R_LINE_TO, 0.85, -0.85,
LINE_TO, 10.05, 6.8,
LINE_TO, 11.6, 5.25,
R_LINE_TO, -0.85, -0.85,
LINE_TO, 9.2, 5.95,
LINE_TO, 7.65, 4.4,
R_LINE_TO, -0.85, 0.85,
LINE_TO, 8.35, 6.8,
R_LINE_TO, -1.55, 1.55,
CLOSE,
MOVE_TO, 5.2, 12,
R_ARC_TO, 1.16, 1.16, 0, 0, 1, -0.85, -0.35,
ARC_TO, 1.16, 1.16, 0, 0, 1, 4, 10.8,
R_V_LINE_TO, -8,
R_CUBIC_TO, 0, -0.33, 0.12, -0.61, 0.35, -0.85,
R_ARC_TO, 1.16, 1.16, 0, 0, 1, 0.85, -0.35,
R_H_LINE_TO, 8,
R_CUBIC_TO, 0.33, 0, 0.61, 0.12, 0.85, 0.35,
R_CUBIC_TO, 0.23, 0.23, 0.35, 0.52, 0.35, 0.85,
R_V_LINE_TO, 8,
R_CUBIC_TO, 0, 0.33, -0.12, 0.61, -0.35, 0.85,
R_ARC_TO, 1.15, 1.15, 0, 0, 1, -0.85, 0.35,
CLOSE,
R_MOVE_TO, 0, -1.2,
R_H_LINE_TO, 8,
R_V_LINE_TO, -8,
R_H_LINE_TO, -8,
CLOSE,
R_MOVE_TO, 0, -8,
R_V_LINE_TO, 8,
CLOSE,)
VECTOR_ICON_TEMPLATE_CC(kTabCloseInactiveRepList, kTabCloseInactiveIcon, {kTabCloseInactivePath})
VECTOR_ICON_REP_TEMPLATE(kTabCloseNormalPath, CANVAS_DIMENSIONS, 32,
STROKE, 2.45,
MOVE_TO, 10.25, 10.25,
R_LINE_TO, 11.5, 11.5,
MOVE_TO, 10.25, 21.75,
R_LINE_TO, 11.5, -11.5)
VECTOR_ICON_REP_TEMPLATE(kTabCloseNormal16Path, CANVAS_DIMENSIONS, 16,
STROKE, 1.415,
MOVE_TO, 4.75, 4.75,
R_LINE_TO, 6.5, 6.5,
MOVE_TO, 4.75, 11.25,
R_LINE_TO, 6.5, -6.5)
VECTOR_ICON_TEMPLATE_CC(kTabCloseNormalRepList, kTabCloseNormalIcon, {kTabCloseNormalPath}, {kTabCloseNormal16Path})
VECTOR_ICON_REP_TEMPLATE(kTabGroupPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 8, 14.4,
CUBIC_TO, 7.13, 14.4, 6.29, 14.23, 5.52, 13.9,
CUBIC_TO, 4.74, 13.57, 4.06, 13.11, 3.48, 12.52,
CUBIC_TO, 2.89, 11.94, 2.43, 11.26, 2.1, 10.48,
CUBIC_TO, 1.77, 9.71, 1.6, 8.88, 1.6, 7.99,
CUBIC_TO, 1.6, 7.11, 1.77, 6.28, 2.1, 5.51,
CUBIC_TO, 2.43, 4.73, 2.89, 4.06, 3.48, 3.48,
CUBIC_TO, 4.06, 2.89, 4.74, 2.43, 5.52, 2.1,
CUBIC_TO, 6.29, 1.77, 7.13, 1.6, 8.01, 1.6,
CUBIC_TO, 8.89, 1.6, 9.72, 1.77, 10.49, 2.1,
CUBIC_TO, 11.27, 2.43, 11.94, 2.89, 12.52, 3.48,
CUBIC_TO, 13.11, 4.06, 13.57, 4.74, 13.9, 5.51,
CUBIC_TO, 14.23, 6.29, 14.4, 7.11, 14.4, 8,
CUBIC_TO, 14.4, 8.88, 14.23, 9.71, 13.9, 10.48,
CUBIC_TO, 13.57, 11.26, 13.11, 11.94, 12.52, 12.52,
CUBIC_TO, 11.94, 13.11, 11.26, 13.57, 10.49, 13.9,
CUBIC_TO, 9.71, 14.23, 8.89, 14.4, 8, 14.4,
CLOSE,
MOVE_TO, 8, 14.4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTabGroupRepList, kTabGroupIcon, {kTabGroupPath})
VECTOR_ICON_REP_TEMPLATE(kTabGroupSharingPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 2, 16,
R_V_LINE_TO, -1.92,
R_CUBIC_TO, 0, -0.35, 0.09, -0.69, 0.26, -0.98,
R_CUBIC_TO, 0.17, -0.3, 0.41, -0.54, 0.72, -0.72,
R_ARC_TO, 9.81, 9.81, 0, 0, 1, 2.38, -1.02,
ARC_TO, 9.61, 9.61, 0, 0, 1, 8, 11,
R_CUBIC_TO, 0.92, 0, 1.8, 0.12, 2.64, 0.36,
R_CUBIC_TO, 0.84, 0.24, 1.63, 0.57, 2.38, 1.02,
R_CUBIC_TO, 0.31, 0.18, 0.55, 0.42, 0.72, 0.72,
R_CUBIC_TO, 0.18, 0.3, 0.26, 0.63, 0.26, 0.98,
V_LINE_TO, 16,
CLOSE,
R_MOVE_TO, 13.5, 0,
R_V_LINE_TO, -1.92,
R_CUBIC_TO, 0, -0.58, -0.14, -1.12, -0.41, -1.62,
R_CUBIC_TO, -0.27, -0.5, -0.64, -0.91, -1.09, -1.23,
R_CUBIC_TO, 0.54, 0.11, 1.07, 0.26, 1.57, 0.45,
R_CUBIC_TO, 0.5, 0.19, 0.99, 0.42, 1.45, 0.7,
R_CUBIC_TO, 0.31, 0.18, 0.55, 0.42, 0.72, 0.72,
R_CUBIC_TO, 0.18, 0.3, 0.26, 0.63, 0.26, 0.98,
V_LINE_TO, 16,
CLOSE,
MOVE_TO, 8, 10,
R_ARC_TO, 2.9, 2.9, 0, 0, 1, -2.12, -0.87,
ARC_TO, 2.9, 2.9, 0, 0, 1, 5, 7,
R_CUBIC_TO, 0, -0.83, 0.29, -1.54, 0.88, -2.12,
ARC_TO, 2.9, 2.9, 0, 0, 1, 8, 4,
R_CUBIC_TO, 0.83, 0, 1.54, 0.29, 2.13, 0.88,
CUBIC_TO, 10.71, 5.46, 11, 6.17, 11, 7,
R_CUBIC_TO, 0, 0.83, -0.29, 1.54, -0.87, 2.13,
ARC_TO, 2.9, 2.9, 0, 0, 1, 8, 10,
CLOSE,
R_MOVE_TO, 7, -3,
R_CUBIC_TO, 0, 0.83, -0.29, 1.54, -0.87, 2.13,
ARC_TO, 2.9, 2.9, 0, 0, 1, 12, 10,
R_CUBIC_TO, -0.11, 0, -0.21, 0, -0.31, -0.01,
R_ARC_TO, 1.57, 1.57, 0, 0, 1, -0.31, -0.05,
R_ARC_TO, 4.9, 4.9, 0, 0, 0, 0.82, -1.34,
R_CUBIC_TO, 0.2, -0.49, 0.3, -1.02, 0.3, -1.59,
R_CUBIC_TO, 0, -0.57, -0.1, -1.1, -0.3, -1.59,
R_ARC_TO, 4.9, 4.9, 0, 0, 0, -0.82, -1.34,
R_CUBIC_TO, 0.11, -0.03, 0.22, -0.05, 0.31, -0.05,
CUBIC_TO, 11.78, 4, 11.89, 4, 12, 4,
R_CUBIC_TO, 0.83, 0, 1.54, 0.29, 2.13, 0.88,
CUBIC_TO, 14.71, 5.46, 15, 6.17, 15, 7,
CLOSE,
MOVE_TO, 3.5, 14.5,
R_H_LINE_TO, 9,
R_V_LINE_TO, -0.42,
R_CUBIC_TO, 0, -0.09, -0.02, -0.17, -0.06, -0.24,
R_ARC_TO, 0.44, 0.44, 0, 0, 0, -0.17, -0.17,
R_ARC_TO, 9.02, 9.02, 0, 0, 0, -2.06, -0.87,
CUBIC_TO, 9.48, 12.6, 8.75, 12.5, 8, 12.5,
R_CUBIC_TO, -0.75, 0, -1.48, 0.1, -2.21, 0.29,
R_ARC_TO, 7.97, 7.97, 0, 0, 0, -2.06, 0.88,
R_ARC_TO, 0.45, 0.45, 0, 0, 0, -0.23, 0.41,
CLOSE,
R_MOVE_TO, 4.5, -6,
R_CUBIC_TO, 0.41, 0, 0.77, -0.15, 1.06, -0.44,
R_CUBIC_TO, 0.29, -0.3, 0.44, -0.65, 0.44, -1.06,
R_CUBIC_TO, 0, -0.41, -0.15, -0.77, -0.44, -1.06,
ARC_TO, 1.45, 1.45, 0, 0, 0, 8, 5.5,
R_CUBIC_TO, -0.41, 0, -0.77, 0.15, -1.06, 0.44,
ARC_TO, 1.45, 1.45, 0, 0, 0, 6.5, 7,
R_CUBIC_TO, 0, 0.41, 0.15, 0.77, 0.44, 1.06,
R_CUBIC_TO, 0.3, 0.29, 0.65, 0.44, 1.06, 0.44,
CLOSE,
MOVE_TO, 8, 14.5,
CLOSE,
MOVE_TO, 8, 7,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTabGroupSharingRepList, kTabGroupSharingIcon, {kTabGroupSharingPath})
VECTOR_ICON_REP_TEMPLATE(kTabGroupsSyncPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 3.62, 12.99,
R_V_LINE_TO, -1.34,
R_H_LINE_TO, 0.93,
R_LINE_TO, 0.12, 0.09,
R_ARC_TO, 5.92, 5.92, 0, 0, 1, -1.23, -1.68,
ARC_TO, 4.62, 4.62, 0, 0, 1, 2.96, 8,
R_CUBIC_TO, 0, -1.22, 0.39, -2.29, 1.17, -3.2,
R_ARC_TO, 5.07, 5.07, 0, 0, 1, 2.91, -1.73,
R_V_LINE_TO, 1.68,
R_CUBIC_TO, -0.71, 0.2, -1.29, 0.59, -1.75, 1.19,
ARC_TO, 3.28, 3.28, 0, 0, 0, 4.6, 8,
R_CUBIC_TO, 0, 0.5, 0.11, 0.96, 0.31, 1.38,
R_CUBIC_TO, 0.21, 0.43, 0.48, 0.8, 0.82, 1.11,
R_LINE_TO, -0.07, -0.07,
R_V_LINE_TO, -0.81,
R_H_LINE_TO, 1.34,
R_V_LINE_TO, 3.39,
CLOSE,
R_MOVE_TO, 5.35, -0.06,
R_V_LINE_TO, -1.68,
R_CUBIC_TO, 0.71, -0.2, 1.29, -0.59, 1.75, -1.19,
ARC_TO, 3.28, 3.28, 0, 0, 0, 11.4, 8,
R_CUBIC_TO, 0, -0.5, -0.1, -0.96, -0.31, -1.38,
R_ARC_TO, 3.57, 3.57, 0, 0, 0, -0.82, -1.1,
R_LINE_TO, 0.07, 0.07,
R_V_LINE_TO, 0.81,
R_H_LINE_TO, -1.34,
V_LINE_TO, 3.01,
R_H_LINE_TO, 3.38,
R_V_LINE_TO, 1.34,
R_H_LINE_TO, -0.93,
R_LINE_TO, -0.12, -0.09,
R_CUBIC_TO, 0.52, 0.47, 0.93, 1.03, 1.24, 1.67,
R_CUBIC_TO, 0.31, 0.64, 0.46, 1.33, 0.46, 2.07,
R_CUBIC_TO, 0, 1.22, -0.39, 2.29, -1.16, 3.2,
R_ARC_TO, 5.07, 5.07, 0, 0, 1, -2.91, 1.73,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTabGroupsSyncRepList, kTabGroupsSyncIcon, {kTabGroupsSyncPath})
VECTOR_ICON_REP_TEMPLATE(kTabUsbConnectedPath, CANVAS_DIMENSIONS, 32,
MOVE_TO, 19, 16,
R_H_LINE_TO, 1,
R_V_LINE_TO, 2,
R_H_LINE_TO, -3,
R_V_LINE_TO, -8,
R_H_LINE_TO, 2,
R_LINE_TO, -3, -4,
R_LINE_TO, -3, 4,
R_H_LINE_TO, 2,
R_V_LINE_TO, 8,
R_H_LINE_TO, -3,
R_V_LINE_TO, -2,
R_CUBIC_TO, 0.85, -0.53, 1.34, -1.23, 1, -2,
R_CUBIC_TO, 0.34, -1.27, -0.64, -2.25, -2, -2,
R_CUBIC_TO, -1.02, -0.25, -2, 0.73, -2, 2,
R_CUBIC_TO, 0, 0.77, 0.49, 1.47, 1, 2,
R_V_LINE_TO, 2,
R_CUBIC_TO, 0.18, 0.99, 1.06, 1.87, 2, 2,
R_H_LINE_TO, 3,
R_V_LINE_TO, 3,
R_CUBIC_TO, -0.59, 0.26, -1.07, 0.98, -1, 2,
R_CUBIC_TO, -0.07, 1.03, 0.91, 2, 2, 2,
R_CUBIC_TO, 1.29, 0, 2.27, -0.97, 2, -2,
R_CUBIC_TO, 0.27, -1.02, -0.21, -1.74, -1, -2,
R_V_LINE_TO, -3,
R_H_LINE_TO, 3,
R_CUBIC_TO, 1.14, -0.13, 2.01, -1.01, 2, -2,
R_V_LINE_TO, -2,
R_H_LINE_TO, 1,
R_V_LINE_TO, -4,
R_H_LINE_TO, -4,
R_V_LINE_TO, 4,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kTabUsbConnected16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 10, 8,
R_H_LINE_TO, 1,
R_V_LINE_TO, 1,
H_LINE_TO, 9,
V_LINE_TO, 5,
R_H_LINE_TO, 1,
LINE_TO, 8.5, 3,
LINE_TO, 7, 5,
R_H_LINE_TO, 1,
R_V_LINE_TO, 4,
H_LINE_TO, 7,
V_LINE_TO, 8,
R_CUBIC_TO, -0.08, -0.04, 0, -0.5, 0, -1,
R_CUBIC_TO, 0, -0.5, -0.5, -1, -1, -1,
R_CUBIC_TO, -0.5, 0, -1, 0.5, -1, 1,
R_CUBIC_TO, 0, 0.5, 0.25, 0.96, 1, 1,
R_V_LINE_TO, 1,
R_CUBIC_TO, 0, 0.5, 0.5, 1, 1, 1,
R_H_LINE_TO, 1,
R_V_LINE_TO, 2,
R_LINE_TO, -1, 1,
R_LINE_TO, 1, 1,
R_H_LINE_TO, 1,
R_LINE_TO, 1, -1,
R_LINE_TO, -1, -1,
R_V_LINE_TO, -2,
R_H_LINE_TO, 2,
R_CUBIC_TO, 0.5, 0, 1, -0.5, 1, -1,
V_LINE_TO, 6,
R_H_LINE_TO, -2,
R_V_LINE_TO, 2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTabUsbConnectedRepList, kTabUsbConnectedIcon, {kTabUsbConnectedPath}, {kTabUsbConnected16Path})
VECTOR_ICON_REP_TEMPLATE(kTabletPath, MOVE_TO, 42, 8,
H_LINE_TO, 6,
R_CUBIC_TO, -2.21, 0, -4, 1.79, -4, 4,
R_V_LINE_TO, 24,
R_CUBIC_TO, 0, 2.21, 1.79, 4, 4, 4,
R_H_LINE_TO, 36,
R_CUBIC_TO, 2.21, 0, 3.98, -1.79, 3.98, -4,
LINE_TO, 46, 12,
R_CUBIC_TO, 0, -2.21, -1.79, -4, -4, -4,
CLOSE,
R_MOVE_TO, -4, 28,
H_LINE_TO, 10,
V_LINE_TO, 12,
R_H_LINE_TO, 28,
R_V_LINE_TO, 24,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTabletRepList, kTabletIcon, {kTabletPath})
VECTOR_ICON_REP_TEMPLATE(kTaskManagerPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 12.35, 13.73,
H_LINE_TO, 3.65,
R_CUBIC_TO, -0.37, 0, -0.7, -0.14, -0.97, -0.41,
R_ARC_TO, 1.33, 1.33, 0, 0, 1, -0.41, -0.97,
V_LINE_TO, 3.65,
R_CUBIC_TO, 0, -0.38, 0.14, -0.71, 0.41, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.4, 0.97, -0.4,
R_H_LINE_TO, 8.7,
R_CUBIC_TO, 0.38, 0, 0.7, 0.13, 0.97, 0.4,
R_CUBIC_TO, 0.27, 0.27, 0.41, 0.6, 0.41, 0.98,
R_V_LINE_TO, 8.7,
R_CUBIC_TO, 0, 0.38, -0.14, 0.7, -0.41, 0.97,
R_ARC_TO, 1.33, 1.33, 0, 0, 1, -0.97, 0.41,
CLOSE,
MOVE_TO, 3.65, 5.41,
R_H_LINE_TO, 8.7,
V_LINE_TO, 3.65,
H_LINE_TO, 3.65,
CLOSE,
R_MOVE_TO, 1.57, 1.2,
R_H_LINE_TO, -1.57,
R_V_LINE_TO, 5.74,
R_H_LINE_TO, 1.57,
CLOSE,
R_MOVE_TO, 5.56, 0,
R_V_LINE_TO, 5.74,
R_H_LINE_TO, 1.57,
V_LINE_TO, 6.61,
CLOSE,
R_MOVE_TO, -1.2, 0,
H_LINE_TO, 6.42,
R_V_LINE_TO, 5.74,
R_H_LINE_TO, 3.16,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTaskManagerRepList, kTaskManagerIcon, {kTaskManagerPath})
VECTOR_ICON_REP_TEMPLATE(kTextAnalysisPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 2.5, 17.5,
LINE_TO, 2.5, 15.83,
LINE_TO, 12.5, 15.83,
LINE_TO, 12.5, 17.5,
CLOSE,
MOVE_TO, 2.5, 13.33,
LINE_TO, 2.5, 11.67,
LINE_TO, 17.5, 11.67,
LINE_TO, 17.5, 13.33,
CLOSE,
MOVE_TO, 2.5, 9.17,
LINE_TO, 2.5, 7.5,
LINE_TO, 11.67, 7.5,
LINE_TO, 11.67, 9.17,
CLOSE,
MOVE_TO, 14.58, 10,
CUBIC_TO, 14.58, 8.72, 14.14, 7.64, 13.25, 6.75,
CUBIC_TO, 12.36, 5.86, 11.28, 5.42, 10, 5.42,
CUBIC_TO, 11.28, 5.42, 12.36, 4.97, 13.25, 4.08,
CUBIC_TO, 14.14, 3.2, 14.58, 2.11, 14.58, 0.83,
CUBIC_TO, 14.58, 2.11, 15.03, 3.2, 15.92, 4.08,
CUBIC_TO, 16.8, 4.97, 17.89, 5.42, 19.17, 5.42,
CUBIC_TO, 17.89, 5.42, 16.8, 5.86, 15.92, 6.75,
CUBIC_TO, 15.03, 7.64, 14.58, 8.72, 14.58, 10,
CLOSE,
MOVE_TO, 14.58, 10,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTextAnalysisRepList, kTextAnalysisIcon, {kTextAnalysisPath})
VECTOR_ICON_REP_TEMPLATE(kToolbarChromeRefreshPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 3.57, 13.73,
CUBIC_TO, 3.19, 13.73, 2.88, 13.61, 2.63, 13.37,
CUBIC_TO, 2.39, 13.12, 2.27, 12.81, 2.27, 12.43,
LINE_TO, 2.27, 3.57,
CUBIC_TO, 2.27, 3.18, 2.39, 2.86, 2.63, 2.63,
CUBIC_TO, 2.88, 2.38, 3.19, 2.27, 3.57, 2.27,
LINE_TO, 12.43, 2.27,
CUBIC_TO, 12.82, 2.27, 13.14, 2.38, 13.38, 2.63,
CUBIC_TO, 13.62, 2.86, 13.73, 3.18, 13.73, 3.57,
LINE_TO, 13.73, 12.43,
CUBIC_TO, 13.73, 12.81, 13.62, 13.12, 13.38, 13.37,
CUBIC_TO, 13.14, 13.61, 12.82, 13.73, 12.43, 13.73,
CLOSE,
MOVE_TO, 3.65, 5.18,
LINE_TO, 12.35, 5.18,
LINE_TO, 12.35, 3.65,
LINE_TO, 3.65, 3.65,
CLOSE,
MOVE_TO, 12.35, 6.56,
LINE_TO, 3.65, 6.56,
LINE_TO, 3.65, 12.35,
LINE_TO, 12.35, 12.35,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kToolbarChromeRefreshRepList, kToolbarChromeRefreshIcon, {kToolbarChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kTopPanelClosePath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 12, 12.5f,
LINE_TO, 8, 16.5f,
LINE_TO, 16, 16.5f,
CLOSE,
MOVE_TO, 5, 21,
CUBIC_TO, 4.45f, 21, 3.98f, 20.8f, 3.59f, 20.41f,
CUBIC_TO, 3.2f, 20.02f, 3, 19.55f, 3, 19,
LINE_TO, 3, 5,
CUBIC_TO, 3, 4.45f, 3.2f, 3.98f, 3.59f, 3.59f,
CUBIC_TO, 3.98f, 3.2f, 4.45f, 3, 5, 3,
LINE_TO, 19, 3,
CUBIC_TO, 19.55f, 3, 20.02f, 3.2f, 20.41f, 3.59f,
CUBIC_TO, 20.8f, 3.98f, 21, 4.45f, 21, 5,
LINE_TO, 21, 19,
CUBIC_TO, 21, 19.55f, 20.8f, 20.02f, 20.41f, 20.41f,
CUBIC_TO, 20.02f, 20.8f, 19.55f, 21, 19, 21,
CLOSE,
MOVE_TO, 19, 8,
LINE_TO, 19, 5,
LINE_TO, 5, 5,
LINE_TO, 5, 8,
CLOSE,
MOVE_TO, 5, 10,
LINE_TO, 5, 19,
LINE_TO, 19, 19,
LINE_TO, 19, 10,
CLOSE,
MOVE_TO, 5, 8,
LINE_TO, 5, 5,
CLOSE,
MOVE_TO, 5, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTopPanelCloseRepList, kTopPanelCloseIcon, {kTopPanelClosePath})
VECTOR_ICON_REP_TEMPLATE(kTrailingScrollPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 8.97, 8,
LINE_TO, 4, 3.4,
LINE_TO, 5.51, 2,
LINE_TO, 12, 8,
R_LINE_TO, -6.49, 6,
LINE_TO, 4, 12.6,
LINE_TO, 8.97, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTrailingScrollRepList, kTrailingScrollIcon, {kTrailingScrollPath})
VECTOR_ICON_REP_TEMPLATE(kTranslatePath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
R_MOVE_TO, 8, 14.52,
R_LINE_TO, -0.81, -2.44,
H_LINE_TO, 2.7,
R_ARC_TO, 1.25, 1.25, 0, 0, 1, -0.87, -0.36,
R_ARC_TO, 1.16, 1.16, 0, 0, 1, -0.35, -0.86,
V_LINE_TO, 2.7,
R_CUBIC_TO, 0, -0.33, 0.12, -0.62, 0.36, -0.86,
R_CUBIC_TO, 0.24, -0.24, 0.53, -0.37, 0.87, -0.37,
R_H_LINE_TO, 3.67,
R_LINE_TO, 0.81, 2.44,
H_LINE_TO, 13.3,
R_CUBIC_TO, 0.33, 0, 0.62, 0.12, 0.86, 0.36,
R_CUBIC_TO, 0.24, 0.24, 0.36, 0.53, 0.36, 0.86,
R_V_LINE_TO, 8.16,
R_CUBIC_TO, 0, 0.34, -0.12, 0.63, -0.36, 0.87,
R_ARC_TO, 1.19, 1.19, 0, 0, 1, -0.86, 0.36,
CLOSE,
R_MOVE_TO, -3.21, -4.89,
R_CUBIC_TO, 0.65, 0, 1.2, -0.21, 1.66, -0.63,
R_CUBIC_TO, 0.46, -0.42, 0.69, -1.01, 0.69, -1.77,
R_CUBIC_TO, 0, -0.08, 0, -0.16, -0.01, -0.23,
R_ARC_TO, 1.33, 1.33, 0, 0, 0, -0.04, -0.25,
H_LINE_TO, 4.79,
R_V_LINE_TO, 0.83,
R_H_LINE_TO, 1.43,
R_CUBIC_TO, -0.04, 0.38, -0.19, 0.66, -0.46, 0.88,
R_ARC_TO, 1.56, 1.56, 0, 0, 1, -0.97, 0.31,
R_CUBIC_TO, -0.43, 0, -0.79, -0.15, -1.09, -0.46,
R_ARC_TO, 1.55, 1.55, 0, 0, 1, -0.45, -1.12,
R_CUBIC_TO, 0, -0.43, 0.15, -0.8, 0.45, -1.11,
R_CUBIC_TO, 0.3, -0.31, 0.67, -0.46, 1.1, -0.46,
R_CUBIC_TO, 0.18, 0, 0.36, 0.03, 0.53, 0.1,
R_CUBIC_TO, 0.17, 0.07, 0.32, 0.16, 0.46, 0.29,
R_LINE_TO, 0.65, -0.63,
R_ARC_TO, 2.18, 2.18, 0, 0, 0, -0.77, -0.47,
R_ARC_TO, 2.58, 2.58, 0, 0, 0, -0.87, -0.16,
R_CUBIC_TO, -0.68, 0, -1.26, 0.24, -1.74, 0.72,
R_ARC_TO, 2.37, 2.37, 0, 0, 0, -0.71, 1.73,
R_CUBIC_TO, 0, 0.68, 0.24, 1.25, 0.71, 1.73,
R_ARC_TO, 2.37, 2.37, 0, 0, 0, 1.74, 0.72,
CLOSE,
R_MOVE_TO, 4.31, 0.57,
R_LINE_TO, 0.33, -0.32,
R_CUBIC_TO, -0.16, -0.17, -0.3, -0.35, -0.43, -0.53,
R_ARC_TO, 7.06, 7.06, 0, 0, 1, -0.36, -0.59,
CLOSE,
R_MOVE_TO, 0.8, -0.83,
R_CUBIC_TO, 0.23, -0.27, 0.44, -0.56, 0.63, -0.86,
R_CUBIC_TO, 0.2, -0.3, 0.34, -0.63, 0.43, -0.99,
H_LINE_TO, 8.26,
R_LINE_TO, 0.24, 0.71,
R_LINE_TO, 0.66, -0.02,
R_CUBIC_TO, 0.1, 0.22, 0.21, 0.42, 0.33, 0.61,
R_CUBIC_TO, 0.12, 0.19, 0.26, 0.37, 0.42, 0.54,
CLOSE,
R_MOVE_TO, -1.09, 4.34,
R_H_LINE_TO, 4.49,
R_ARC_TO, 0.41, 0.41, 0, 0, 0, 0.29, -0.11,
R_ARC_TO, 0.4, 0.4, 0, 0, 0, 0.12, -0.3,
V_LINE_TO, 5.14,
R_ARC_TO, 0.4, 0.4, 0, 0, 0, -0.12, -0.29,
R_ARC_TO, 0.4, 0.4, 0, 0, 0, -0.29, -0.12,
H_LINE_TO, 7.39,
R_LINE_TO, 0.65, 2.1,
R_H_LINE_TO, 1.36,
V_LINE_TO, 6.13,
R_H_LINE_TO, 0.68,
R_V_LINE_TO, 0.7,
R_H_LINE_TO, 2.46,
R_V_LINE_TO, 0.7,
R_H_LINE_TO, -0.86,
R_ARC_TO, 4.86, 4.86, 0, 0, 1, -0.51, 1.26,
R_ARC_TO, 7.07, 7.07, 0, 0, 1, -0.78, 1.1,
R_LINE_TO, 1.84, 1.8,
R_LINE_TO, -0.49, 0.49,
R_LINE_TO, -1.8, -1.8,
R_LINE_TO, -0.59, 0.58,
R_LINE_TO, 0.61, 1.93,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTranslateRepList, kTranslateIcon, {kTranslatePath})
VECTOR_ICON_REP_TEMPLATE(kTrashCanPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 4, 12.67,
CUBIC_TO, 4, 13.4, 4.6, 14, 5.33, 14,
R_H_LINE_TO, 5.33,
CUBIC_TO, 11.4, 14, 12, 13.4, 12, 12.67,
R_V_LINE_TO, -8,
H_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 8.67, -10,
R_H_LINE_TO, -2.33,
LINE_TO, 9.67, 2,
H_LINE_TO, 6.33,
R_LINE_TO, -0.67, 0.67,
H_LINE_TO, 3.33,
V_LINE_TO, 4,
R_H_LINE_TO, 9.33,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTrashCanRepList, kTrashCanIcon, {kTrashCanPath})
VECTOR_ICON_REP_TEMPLATE(kTrashCanRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 6.5, 17,
CUBIC_TO, 6.09, 17, 5.73, 16.85, 5.44, 16.56,
CUBIC_TO, 5.15, 16.27, 5, 15.91, 5, 15.5,
LINE_TO, 5, 5.5,
LINE_TO, 4, 5.5,
LINE_TO, 4, 4,
LINE_TO, 8, 4,
LINE_TO, 8, 3,
LINE_TO, 12, 3,
LINE_TO, 12, 4,
LINE_TO, 16, 4,
LINE_TO, 16, 5.5,
LINE_TO, 15, 5.5,
LINE_TO, 15, 15.49,
CUBIC_TO, 15, 15.91, 14.85, 16.27, 14.56, 16.56,
CUBIC_TO, 14.27, 16.86, 13.91, 17, 13.5, 17,
CLOSE,
MOVE_TO, 13.5, 5.5,
LINE_TO, 6.5, 5.5,
LINE_TO, 6.5, 15.5,
LINE_TO, 13.5, 15.5,
CLOSE,
MOVE_TO, 8, 14,
LINE_TO, 9.5, 14,
LINE_TO, 9.5, 7,
LINE_TO, 8, 7,
CLOSE,
MOVE_TO, 10.5, 14,
LINE_TO, 12, 14,
LINE_TO, 12, 7,
LINE_TO, 10.5, 7,
CLOSE,
MOVE_TO, 6.5, 5.5,
LINE_TO, 6.5, 15.5,
CLOSE,
MOVE_TO, 6.5, 5.5,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kTrashCanRefresh16Path, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 5.16, 13.73,
R_CUBIC_TO, -0.38, 0, -0.71, -0.13, -0.98, -0.4,
R_ARC_TO, 1.34, 1.34, 0, 0, 1, -0.4, -0.98,
V_LINE_TO, 4.45,
R_H_LINE_TO, -0.89,
V_LINE_TO, 3.06,
R_H_LINE_TO, 3.43,
R_V_LINE_TO, -0.89,
R_H_LINE_TO, 3.38,
R_V_LINE_TO, 0.89,
R_H_LINE_TO, 3.43,
R_V_LINE_TO, 1.39,
R_H_LINE_TO, -0.89,
R_V_LINE_TO, 7.9,
R_CUBIC_TO, 0, 0.39, -0.13, 0.72, -0.4, 0.99,
R_CUBIC_TO, -0.27, 0.27, -0.6, 0.4, -0.98, 0.4,
CLOSE,
R_MOVE_TO, 5.69, -9.29,
H_LINE_TO, 5.16,
R_V_LINE_TO, 7.91,
R_H_LINE_TO, 5.69,
CLOSE,
R_MOVE_TO, -4.52, 6.75,
R_H_LINE_TO, 1.29,
V_LINE_TO, 5.6,
H_LINE_TO, 6.33,
CLOSE,
R_MOVE_TO, 2.05, 0,
R_H_LINE_TO, 1.29,
V_LINE_TO, 5.6,
H_LINE_TO, 8.38,
CLOSE,
R_MOVE_TO, -3.22, -6.75,
R_V_LINE_TO, 7.91,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTrashCanRefreshRepList, kTrashCanRefreshIcon, {kTrashCanRefreshPath}, {kTrashCanRefresh16Path})
VECTOR_ICON_REP_TEMPLATE(kTvPath, CANVAS_DIMENSIONS, 960,
FILL_RULE_NONZERO,
MOVE_TO, 320, 840,
R_V_LINE_TO, -80,
H_LINE_TO, 160,
R_QUADRATIC_TO, -33, 0, -56.5, -23.5,
QUADRATIC_TO_SHORTHAND, 80, 680,
R_V_LINE_TO, -480,
R_QUADRATIC_TO, 0, -33, 23.5, -56.5,
QUADRATIC_TO_SHORTHAND, 160, 120,
R_H_LINE_TO, 640,
R_QUADRATIC_TO, 33, 0, 56.5, 23.5,
QUADRATIC_TO_SHORTHAND, 880, 200,
R_V_LINE_TO, 480,
R_QUADRATIC_TO, 0, 33, -23.5, 56.5,
QUADRATIC_TO_SHORTHAND, 800, 760,
H_LINE_TO, 640,
R_V_LINE_TO, 80,
H_LINE_TO, 320,
CLOSE,
MOVE_TO, 160, 680,
R_H_LINE_TO, 640,
R_V_LINE_TO, -480,
H_LINE_TO, 160,
R_V_LINE_TO, 480,
CLOSE,
R_MOVE_TO, 0, 0,
R_V_LINE_TO, -480,
R_V_LINE_TO, 480,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTvRepList, kTvIcon, {kTvPath})
VECTOR_ICON_REP_TEMPLATE(kUngroupRefreshPath, CANVAS_DIMENSIONS, 20,
R_MOVE_TO, 7.06, 14.16,
R_LINE_TO, -1.23, -1.23,
R_LINE_TO, 3.86, -3.84,
H_LINE_TO, 6.41,
R_V_LINE_TO, -1.73,
R_H_LINE_TO, 6.23,
R_V_LINE_TO, 6.23,
R_H_LINE_TO, -1.73,
V_LINE_TO, 10.3,
CLOSE,
R_MOVE_TO, 8.38, -4.11,
R_V_LINE_TO, -5.5,
R_H_LINE_TO, -5.5,
V_LINE_TO, 2.83,
R_H_LINE_TO, 7.23,
R_V_LINE_TO, 7.23,
CLOSE,
MOVE_TO, 4.56, 17.17,
R_CUBIC_TO, -0.48, 0, -0.89, -0.17, -1.22, -0.5,
R_ARC_TO, 1.67, 1.67, 0, 0, 1, -0.5, -1.22,
V_LINE_TO, 2.83,
R_H_LINE_TO, 1.73,
R_V_LINE_TO, 12.61,
R_H_LINE_TO, 12.61,
R_V_LINE_TO, 1.73,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kUngroupRefreshRepList, kUngroupRefreshIcon, {kUngroupRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kUserAccountAvatarPath, CANVAS_DIMENSIONS, 64,
MOVE_TO, 32, 0,
CUBIC_TO, 14.34, 0, 0, 14.34, 0, 32,
CUBIC_TO, 0, 49.66, 14.34, 64, 32, 64,
CUBIC_TO, 49.66, 64, 64, 49.66, 64, 32,
CUBIC_TO, 64, 14.34, 49.66, 0, 32, 0,
CLOSE,
MOVE_TO, 32, 9.6,
CUBIC_TO, 37.31, 9.6, 41.6, 13.89, 41.6, 19.2,
CUBIC_TO, 41.6, 24.51, 37.31, 28.8, 32, 28.8,
CUBIC_TO, 26.69, 28.8, 22.4, 24.51, 22.4, 19.2,
CUBIC_TO, 22.4, 13.89, 26.69, 9.6, 32, 9.6,
CLOSE,
MOVE_TO, 32, 55.04,
CUBIC_TO, 24, 55.04, 16.93, 50.94, 12.8, 44.74,
CUBIC_TO, 12.9, 38.37, 25.6, 34.88, 32, 34.88,
CUBIC_TO, 38.37, 34.88, 51.1, 38.37, 51.2, 44.74,
CUBIC_TO, 47.07, 50.94, 40, 55.04, 32, 55.04,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kUserAccountAvatarRepList, kUserAccountAvatarIcon, {kUserAccountAvatarPath})
VECTOR_ICON_REP_TEMPLATE(kUserAccountAvatarRefreshPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 4.96, 13.99,
R_ARC_TO, 8.24, 8.24, 0, 0, 1, 2.4, -1.16,
R_ARC_TO, 9.28, 9.28, 0, 0, 1, 2.64, -0.37,
R_CUBIC_TO, 0.91, 0, 1.8, 0.13, 2.65, 0.38,
R_ARC_TO, 8.34, 8.34, 0, 0, 1, 2.39, 1.15,
R_ARC_TO, 5.84, 5.84, 0, 0, 0, 1.06, -1.87,
R_CUBIC_TO, 0.23, -0.68, 0.34, -1.38, 0.34, -2.12,
R_CUBIC_TO, 0, -1.78, -0.63, -3.3, -1.89, -4.55,
R_CUBIC_TO, -1.26, -1.26, -2.78, -1.89, -4.56, -1.89,
R_CUBIC_TO, -1.78, 0, -3.3, 0.63, -4.55, 1.89,
CUBIC_TO, 4.19, 6.7, 3.56, 8.22, 3.56, 10,
R_CUBIC_TO, 0, 0.73, 0.11, 1.44, 0.34, 2.11,
R_CUBIC_TO, 0.23, 0.68, 0.58, 1.3, 1.06, 1.88,
CLOSE,
MOVE_TO, 10, 11.54,
R_CUBIC_TO, -0.85, 0, -1.57, -0.29, -2.16, -0.88,
R_CUBIC_TO, -0.59, -0.59, -0.88, -1.31, -0.88, -2.15,
R_CUBIC_TO, 0, -0.85, 0.29, -1.57, 0.88, -2.16,
ARC_TO, 2.94, 2.94, 0, 0, 1, 10, 5.47,
R_CUBIC_TO, 0.85, 0, 1.57, 0.3, 2.16, 0.89,
R_CUBIC_TO, 0.59, 0.59, 0.88, 1.31, 0.88, 2.16,
R_CUBIC_TO, 0, 0.84, -0.29, 1.56, -0.88, 2.15,
R_CUBIC_TO, -0.59, 0.59, -1.31, 0.88, -2.16, 0.88,
CLOSE,
R_MOVE_TO, 0, 6.63,
R_ARC_TO, 7.96, 7.96, 0, 0, 1, -3.17, -0.64,
R_ARC_TO, 8.25, 8.25, 0, 0, 1, -2.61, -1.75,
R_ARC_TO, 8.25, 8.25, 0, 0, 1, -1.75, -2.61,
R_ARC_TO, 7.97, 7.97, 0, 0, 1, -0.64, -3.18,
R_CUBIC_TO, 0, -1.12, 0.21, -2.18, 0.64, -3.17,
R_ARC_TO, 8.29, 8.29, 0, 0, 1, 1.75, -2.6,
R_ARC_TO, 8.25, 8.25, 0, 0, 1, 2.61, -1.75,
R_ARC_TO, 7.97, 7.97, 0, 0, 1, 3.18, -0.64,
R_CUBIC_TO, 1.13, 0, 2.18, 0.21, 3.17, 0.64,
R_ARC_TO, 8.29, 8.29, 0, 0, 1, 2.6, 1.75,
R_ARC_TO, 8.26, 8.26, 0, 0, 1, 1.75, 2.6,
R_CUBIC_TO, 0.43, 0.99, 0.64, 2.05, 0.64, 3.17,
R_ARC_TO, 7.96, 7.96, 0, 0, 1, -0.64, 3.17,
R_ARC_TO, 8.25, 8.25, 0, 0, 1, -1.75, 2.61,
R_ARC_TO, 8.26, 8.26, 0, 0, 1, -2.6, 1.75,
R_ARC_TO, 7.93, 7.93, 0, 0, 1, -3.17, 0.64,
CLOSE,
MOVE_TO, 10, 16.44,
R_CUBIC_TO, 0.71, 0, 1.38, -0.11, 2.03, -0.33,
R_ARC_TO, 6.9, 6.9, 0, 0, 0, 1.85, -0.98,
R_ARC_TO, 7.87, 7.87, 0, 0, 0, -1.86, -0.83,
ARC_TO, 7.25, 7.25, 0, 0, 0, 10, 14.03,
R_CUBIC_TO, -0.7, 0, -1.37, 0.09, -2.02, 0.27,
R_ARC_TO, 6.69, 6.69, 0, 0, 0, -1.85, 0.84,
R_CUBIC_TO, 0.58, 0.43, 1.2, 0.75, 1.84, 0.98,
R_CUBIC_TO, 0.64, 0.22, 1.32, 0.33, 2.03, 0.33,
CLOSE,
R_MOVE_TO, 0, -6.47,
R_CUBIC_TO, 0.4, 0, 0.75, -0.14, 1.03, -0.43,
R_CUBIC_TO, 0.28, -0.28, 0.43, -0.63, 0.43, -1.03,
R_CUBIC_TO, 0, -0.41, -0.14, -0.75, -0.43, -1.03,
ARC_TO, 1.4, 1.4, 0, 0, 0, 10, 7.04,
R_CUBIC_TO, -0.4, 0, -0.75, 0.14, -1.03, 0.43,
R_ARC_TO, 1.41, 1.41, 0, 0, 0, -0.43, 1.03,
R_CUBIC_TO, 0, 0.4, 0.14, 0.75, 0.43, 1.03,
R_CUBIC_TO, 0.28, 0.28, 0.63, 0.43, 1.03, 0.43,
CLOSE,
R_MOVE_TO, 0, -1.46,
CLOSE,
R_MOVE_TO, 0, 6.62,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kUserAccountAvatarRefreshRepList, kUserAccountAvatarRefreshIcon, {kUserAccountAvatarRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kViewListPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 9, 18,
R_H_LINE_TO, 11,
R_V_LINE_TO, -2.68,
H_LINE_TO, 9,
CLOSE,
MOVE_TO, 4, 8.68,
R_H_LINE_TO, 3,
V_LINE_TO, 6,
H_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 0, 4.68,
R_H_LINE_TO, 3,
R_V_LINE_TO, -2.68,
H_LINE_TO, 4,
CLOSE,
MOVE_TO, 4, 18,
R_H_LINE_TO, 3,
R_V_LINE_TO, -2.68,
H_LINE_TO, 4,
CLOSE,
R_MOVE_TO, 5, -4.65,
R_H_LINE_TO, 11,
R_V_LINE_TO, -2.68,
H_LINE_TO, 9,
CLOSE,
R_MOVE_TO, 0, -4.68,
R_H_LINE_TO, 11,
V_LINE_TO, 6,
H_LINE_TO, 9,
CLOSE,
MOVE_TO, 4, 20,
R_CUBIC_TO, -0.55, 0, -1.02, -0.19, -1.41, -0.59,
ARC_TO, 1.94, 1.94, 0, 0, 1, 2, 18,
V_LINE_TO, 6,
R_CUBIC_TO, 0, -0.55, 0.2, -1.02, 0.59, -1.41,
CUBIC_TO, 2.98, 4.2, 3.45, 4, 4, 4,
R_H_LINE_TO, 16,
R_CUBIC_TO, 0.55, 0, 1.02, 0.2, 1.41, 0.59,
R_CUBIC_TO, 0.39, 0.39, 0.59, 0.86, 0.59, 1.41,
R_V_LINE_TO, 12,
R_CUBIC_TO, 0, 0.55, -0.19, 1.02, -0.59, 1.41,
R_CUBIC_TO, -0.39, 0.39, -0.86, 0.59, -1.41, 0.59,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kViewListRepList, kViewListIcon, {kViewListPath})
VECTOR_ICON_REP_TEMPLATE(kWebPath, MOVE_TO, 40, 8,
H_LINE_TO, 8,
R_CUBIC_TO, -2.21, 0, -3.98, 1.79, -3.98, 4,
LINE_TO, 4, 36,
R_CUBIC_TO, 0, 2.21, 1.79, 4, 4, 4,
R_H_LINE_TO, 32,
R_CUBIC_TO, 2.21, 0, 4, -1.79, 4, -4,
V_LINE_TO, 12,
R_CUBIC_TO, 0, -2.21, -1.79, -4, -4, -4,
CLOSE,
MOVE_TO, 30, 36,
H_LINE_TO, 8,
R_V_LINE_TO, -8,
R_H_LINE_TO, 22,
R_V_LINE_TO, 8,
CLOSE,
R_MOVE_TO, 0, -10,
H_LINE_TO, 8,
R_V_LINE_TO, -8,
R_H_LINE_TO, 22,
R_V_LINE_TO, 8,
CLOSE,
R_MOVE_TO, 10, 10,
R_H_LINE_TO, -8,
V_LINE_TO, 18,
R_H_LINE_TO, 8,
R_V_LINE_TO, 18,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kWebRepList, kWebIcon, {kWebPath})
VECTOR_ICON_REP_TEMPLATE(kCameraPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 10, 14.83,
CUBIC_TO, 11, 14.83, 11.83, 14.49, 12.5, 13.81,
CUBIC_TO, 13.17, 13.13, 13.5, 12.3, 13.5, 11.33,
CUBIC_TO, 13.5, 10.37, 13.17, 9.55, 12.5, 8.87,
CUBIC_TO, 11.83, 8.18, 11, 7.83, 10, 7.83,
CUBIC_TO, 9, 7.83, 8.17, 8.18, 7.5, 8.87,
CUBIC_TO, 6.83, 9.55, 6.5, 10.38, 6.5, 11.35,
CUBIC_TO, 6.5, 12.31, 6.83, 13.13, 7.5, 13.81,
CUBIC_TO, 8.17, 14.49, 9, 14.83, 10, 14.83,
CLOSE,
MOVE_TO, 10, 13.33,
CUBIC_TO, 9.42, 13.33, 8.94, 13.14, 8.56, 12.75,
CUBIC_TO, 8.19, 12.36, 8, 11.88, 8, 11.31,
CUBIC_TO, 8, 10.76, 8.19, 10.29, 8.56, 9.92,
CUBIC_TO, 8.94, 9.53, 9.42, 9.33, 10, 9.33,
CUBIC_TO, 10.58, 9.33, 11.06, 9.53, 11.44, 9.92,
CUBIC_TO, 11.81, 10.29, 12, 10.76, 12, 11.31,
CUBIC_TO, 12, 11.88, 11.81, 12.36, 11.44, 12.75,
CUBIC_TO, 11.06, 13.14, 10.58, 13.33, 10, 13.33,
CLOSE,
MOVE_TO, 3.5, 17.33,
CUBIC_TO, 3.1, 17.33, 2.74, 17.19, 2.44, 16.89,
CUBIC_TO, 2.15, 16.59, 2, 16.23, 2, 15.83,
V_LINE_TO, 6.83,
CUBIC_TO, 2, 6.43, 2.15, 6.08, 2.44, 5.79,
CUBIC_TO, 2.74, 5.48, 3.1, 5.33, 3.5, 5.33,
H_LINE_TO, 6,
LINE_TO, 7.5, 3.33,
H_LINE_TO, 12.5,
LINE_TO, 14, 5.33,
H_LINE_TO, 16.5,
CUBIC_TO, 16.92, 5.33, 17.27, 5.48, 17.56, 5.79,
CUBIC_TO, 17.85, 6.08, 18, 6.43, 18, 6.83,
V_LINE_TO, 15.83,
CUBIC_TO, 18, 16.23, 17.85, 16.59, 17.56, 16.89,
CUBIC_TO, 17.27, 17.19, 16.92, 17.33, 16.5, 17.33,
H_LINE_TO, 3.5,
CLOSE,
MOVE_TO, 3.5, 15.83,
H_LINE_TO, 16.5,
V_LINE_TO, 6.83,
H_LINE_TO, 13.25,
LINE_TO, 11.75, 4.83,
H_LINE_TO, 8.25,
LINE_TO, 6.75, 6.83,
H_LINE_TO, 3.5,
V_LINE_TO, 15.83,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCameraRepList, kCameraIcon, {kCameraPath})
VECTOR_ICON_REP_TEMPLATE(kIcloudKeychainPath, CANVAS_DIMENSIONS, 100,
MOVE_TO, 15.6, 79,
R_CUBIC_TO, -17.4, -4.7, -21, -30, -5.2, -37.1,
R_CUBIC_TO, 1, -0.5, 1.8, -0.5, 2.5, -2.6,
R_CUBIC_TO, 2.6, -7.8, 10.8, -13.1, 18.6, -10.4,
R_LINE_TO, 2, 0.7,
R_LINE_TO, 1.3, -1.8,
CUBIC_TO, 49.3, 7, 84.4, 15.9, 84.4, 40.2,
R_CUBIC_TO, 0, 1.5, 0.4, 1.9, 2.4, 2.5,
R_CUBIC_TO, 16.2, 4.8, 17.8, 27.6, 2.5, 35.2,
R_LINE_TO, -3.8, 2,
R_LINE_TO, -33.5, -0.1,
R_CUBIC_TO, -25, 0, -34.2, -0.3, -36.4, -0.9,
CLOSE,
R_MOVE_TO, 23.7, -12.5,
R_CUBIC_TO, 1.7, -0.4, 3.6, -1.7, 5.5, -3.8,
R_CUBIC_TO, 2.5, -2.5, 1.7, -3, 3.5, -3,
R_H_LINE_TO, 4.1,
R_LINE_TO, 2, -2.5,
R_LINE_TO, 2.3, 2.7,
R_LINE_TO, 1.4, -1.4,
R_LINE_TO, 1.3, -1.3,
R_LINE_TO, 1.5, 1.3,
R_LINE_TO, 1.4, 1.4,
R_LINE_TO, 1.3, -1.2,
R_LINE_TO, 1.3, -1.1,
R_LINE_TO, 1.2, 1.1,
R_LINE_TO, 1.3, 1.2,
R_LINE_TO, 1.5, -1.4,
R_LINE_TO, 1.4, -1.4,
R_LINE_TO, 1.2, 1.3,
CUBIC_TO, 73, 60, 74, 60, 75.9, 58,
R_CUBIC_TO, 1.9, -1.9, 2, -4.3, 0.3, -6,
R_LINE_TO, -1.3, -1.3,
H_LINE_TO, 47.3,
LINE_TO, 46, 48.7,
CUBIC_TO, 41.3, 41, 28.2, 42, 24.5, 50.4,
R_CUBIC_TO, -4.2, 9.2, 4.8, 18.9, 14.8, 16.1,
CLOSE,
NEW_PATH,
NEW_PATH,
CIRCLE, 31.7, 55.1, 2.7)
VECTOR_ICON_TEMPLATE_CC(kIcloudKeychainRepList, kIcloudKeychainIcon, {kIcloudKeychainPath})
VECTOR_ICON_REP_TEMPLATE(kIcloudKeychainColorPath, CANVAS_DIMENSIONS, 170,
FILL_RULE_NONZERO,
PATH_COLOR_ARGB, 0xFF, 0x4C, 0xD3, 0x6D,
MOVE_TO, 84.03f, 11.96f,
H_LINE_TO, 84,
R_ARC_TO, 38.13f, 38.13f, 0, 0, 0, -37.57f, 38.1f,
R_CUBIC_TO, 0, 15.83f, 9.78f, 30, 24.57f, 35.63f,
R_V_LINE_TO, 59.13f,
R_LINE_TO, 13.74f, 13.74f,
R_LINE_TO, 6.66f, -6.66f,
R_LINE_TO, -1.95f, -5.21f,
R_H_LINE_TO, -0.2f,
R_V_LINE_TO, -56.5f,
R_ARC_TO, 46.38f, 46.38f, 0, 0, 1, -24.34f, -40.77f,
R_ARC_TO, 46.38f, 46.38f, 0, 0, 1, 19.1f, -37.46f,
CLOSE,
NEW_PATH,
FILL_RULE_NONZERO,
PATH_COLOR_ARGB, 0xFF, 0xFD, 0xCE, 0x48,
MOVE_TO, 57.59f, 11.96f,
R_H_LINE_TO, -0.01f,
ARC_TO, 38.13f, 38.13f, 0, 0, 0, 20, 50.06f,
R_CUBIC_TO, 0, 15.83f, 9.78f, 30, 24.57f, 35.63f,
R_V_LINE_TO, 59.13f,
R_LINE_TO, 13.74f, 13.74f,
R_LINE_TO, 6.67f, -6.66f,
R_LINE_TO, -1.96f, -5.21f,
R_H_LINE_TO, -0.2f,
R_V_LINE_TO, -56.5f,
R_ARC_TO, 46.38f, 46.38f, 0, 0, 1, -24.33f, -40.77f,
R_ARC_TO, 46.38f, 46.38f, 0, 0, 1, 19.1f, -37.46f,
CLOSE,
NEW_PATH,
FILL_RULE_NONZERO,
PATH_COLOR_ARGB, 0xFF, 0x44, 0xA4, 0xF9,
MOVE_TO, 111.01f, 11.93f,
R_ARC_TO, 38.13f, 38.13f, 0, 0, 0, -38.13f, 38.14f,
R_ARC_TO, 38.13f, 38.13f, 0, 0, 0, 24.56f, 35.62f,
R_V_LINE_TO, 7.9f,
R_H_LINE_TO, 0.16f,
R_LINE_TO, -0.16f, 51.23f,
R_LINE_TO, 13.75f, 13.74f,
R_LINE_TO, 21.99f, -21.99f,
R_LINE_TO, -13.63f, -13.63f,
R_LINE_TO, 18.3f, -18.3f,
R_LINE_TO, -16.2f, -16.2f,
R_H_LINE_TO, -0.23f,
R_V_LINE_TO, -1.71f,
R_ARC_TO, 38.13f, 38.13f, 0, 0, 0, 27.73f, -36.66f,
ARC_TO, 38.13f, 38.13f, 0, 0, 0, 111, 11.93f,
CLOSE,
R_MOVE_TO, 0.23f, 13.69f,
R_ARC_TO, 10.88f, 10.88f, 0, 0, 1, 10.88f, 10.88f,
R_ARC_TO, 10.88f, 10.88f, 0, 0, 1, -10.88f, 10.88f,
R_ARC_TO, 10.88f, 10.88f, 0, 0, 1, -10.87f, -10.88f,
R_ARC_TO, 10.88f, 10.88f, 0, 0, 1, 10.87f, -10.88f,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kIcloudKeychainColorRepList, kIcloudKeychainColorIcon, {kIcloudKeychainColorPath})
VECTOR_ICON_REP_TEMPLATE(kPasskeyAoaPath, CANVAS_DIMENSIONS, 316,
PATH_COLOR_ARGB, 0xFF, 0x0B, 0x57, 0xD0,
STROKE, 2,
MOVE_TO, 216, 69.5,
R_V_LINE_TO, 29.75,
R_ARC_TO, 6.75, 6.75, 0, 1, 0, 13.5, 0,
V_LINE_TO, 99,
R_ARC_TO, 7, 7, 0, 0, 0, -7, -7,
H_LINE_TO, 183,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xDA, 0xDC, 0xE0,
ROUND_RECT, 202, 8, 28, 58, 3,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x4C, 0x8D, 0xF6,
STROKE, 2,
ROUND_RECT, 202, 8, 28, 58, 3,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xFF, 0xFF,
CIRCLE, 205, 11, 1,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xFF, 0xFF,
MOVE_TO, 210, 62,
R_ARC_TO, 1, 1, 0, 0, 0, 1, 1,
R_H_LINE_TO, 10,
R_ARC_TO, 1, 1, 0, 0, 0, 0, -2,
R_H_LINE_TO, -10,
R_ARC_TO, 1, 1, 0, 0, 0, -1, 1,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x4C, 0x8D, 0xF6,
MOVE_TO, 218, 67,
R_H_LINE_TO, -4,
R_V_LINE_TO, 4,
R_H_LINE_TO, 4,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xDA, 0xDC, 0xE0,
MOVE_TO, 95, 83,
R_ARC_TO, 4, 4, 0, 0, 0, 4, 4,
R_H_LINE_TO, 78,
R_ARC_TO, 4, 4, 0, 0, 0, 4, -4,
V_LINE_TO, 31,
R_ARC_TO, 4, 4, 0, 0, 0, -4, -4,
H_LINE_TO, 99,
R_ARC_TO, 4, 4, 0, 0, 0, -4, 4,
R_V_LINE_TO, 52,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x4C, 0x8D, 0xF6,
MOVE_TO, 177, 85,
H_LINE_TO, 99,
R_ARC_TO, 2, 2, 0, 0, 1, -2, -2,
V_LINE_TO, 31,
R_ARC_TO, 2, 2, 0, 0, 1, 2, -2,
R_H_LINE_TO, 78,
R_ARC_TO, 2, 2, 0, 0, 1, 2, 2,
R_V_LINE_TO, 52,
R_ARC_TO, 2, 2, 0, 0, 1, -2, 2,
CLOSE,
R_MOVE_TO, -78, 2,
R_ARC_TO, 4, 4, 0, 0, 1, -4, -4,
V_LINE_TO, 31,
R_ARC_TO, 4, 4, 0, 0, 1, 4, -4,
R_H_LINE_TO, 78,
R_ARC_TO, 4, 4, 0, 0, 1, 4, 4,
R_V_LINE_TO, 52,
R_ARC_TO, 4, 4, 0, 0, 1, -4, 4,
H_LINE_TO, 99,
CLOSE,
PATH_COLOR_ARGB, 0xFF, 0x4C, 0x8D, 0xF6,
MOVE_TO, 85, 90,
R_H_LINE_TO, 106,
R_ARC_TO, 4, 4, 0, 0, 1, -4, 4,
H_LINE_TO, 89,
R_ARC_TO, 4, 4, 0, 0, 1, -4, -4,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xFF, 0xFF,
CIRCLE, 138, 31, 1,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xDA, 0xDC, 0xE0,
CIRCLE, 92, 17, 1,
CIRCLE, 96, 17, 1,
CIRCLE, 84, 17, 1,
CIRCLE, 88, 17, 1,
CIRCLE, 100, 17, 1,
CIRCLE, 281, 37, 1,
CIRCLE, 285, 37, 1,
CIRCLE, 76, 21, 1,
CIRCLE, 80, 21, 1,
CIRCLE, 64, 21, 1,
CIRCLE, 84, 21, 1,
CIRCLE, 88, 21, 1,
CIRCLE, 273, 37, 1,
CIRCLE, 72, 21, 1,
CIRCLE, 277, 37, 1,
CIRCLE, 289, 37, 1,
CIRCLE, 293, 37, 1,
CIRCLE, 297, 37, 1,
CIRCLE, 265, 41, 1,
CIRCLE, 269, 41, 1,
CIRCLE, 273, 41, 1,
CIRCLE, 277, 90, 1,
CIRCLE, 281, 90, 1,
CIRCLE, 273, 86, 1,
CIRCLE, 277, 86, 1,
CIRCLE, 285, 90, 1,
CIRCLE, 41, 75, 1,
CIRCLE, 281, 86, 1,
CIRCLE, 45, 75, 1,
CIRCLE, 37, 71, 1,
CIRCLE, 273, 90, 1,
CIRCLE, 269, 86, 1,
CIRCLE, 41, 71, 1,
CIRCLE, 49, 75, 1,
CIRCLE, 45, 71, 1,
CIRCLE, 21, 75, 1,
CIRCLE, 37, 75, 1,
CIRCLE, 25, 75, 1,
CIRCLE, 29, 75, 1,
CIRCLE, 33, 75, 1,
CIRCLE, 33, 71, 1,
CIRCLE, 261, 41, 1,
CIRCLE, 277, 41, 1,
CIRCLE, 281, 41, 1,
CIRCLE, 64, 49, 3,
CIRCLE, 72, 49, 3,
CIRCLE, 48, 49, 3,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xDA, 0xDC, 0xE0,
MOVE_TO, 281, 66,
R_ARC_TO, 3, 3, 0, 1, 0, -6, 0,
R_ARC_TO, 3, 3, 0, 0, 0, 6, 0,
CLOSE,
R_MOVE_TO, -16, 0,
R_ARC_TO, 3, 3, 0, 1, 0, -6, 0,
R_ARC_TO, 3, 3, 0, 0, 0, 6, 0,
CLOSE,
R_MOVE_TO, -8, 0,
R_ARC_TO, 3, 3, 0, 1, 0, -6, 0,
R_ARC_TO, 3, 3, 0, 0, 0, 6, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPasskeyAoaRepList, kPasskeyAoaIcon, {kPasskeyAoaPath})
VECTOR_ICON_REP_TEMPLATE(kPasskeyAoaDarkPath, CANVAS_DIMENSIONS, 316,
PATH_COLOR_ARGB, 0xFF, 0x0B, 0x57, 0xD0,
STROKE, 2,
MOVE_TO, 216, 69.5,
R_V_LINE_TO, 29.75,
R_ARC_TO, 6.75, 6.75, 0, 1, 0, 13.5, 0,
V_LINE_TO, 99,
R_ARC_TO, 7, 7, 0, 0, 0, -7, -7,
H_LINE_TO, 183,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x3C, 0x40, 0x43,
ROUND_RECT, 202, 8, 28, 58, 3,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x4C, 0x8D, 0xF6,
STROKE, 2,
ROUND_RECT, 202, 8, 28, 58, 3,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
CIRCLE, 205, 11, 1,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
MOVE_TO, 210, 62,
R_ARC_TO, 1, 1, 0, 0, 0, 1, 1,
R_H_LINE_TO, 10,
R_ARC_TO, 1, 1, 0, 0, 0, 0, -2,
R_H_LINE_TO, -10,
R_ARC_TO, 1, 1, 0, 0, 0, -1, 1,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x4C, 0x8D, 0xF6,
MOVE_TO, 218, 67,
R_H_LINE_TO, -4,
R_V_LINE_TO, 4,
R_H_LINE_TO, 4,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x3C, 0x40, 0x43,
MOVE_TO, 95, 83,
R_ARC_TO, 4, 4, 0, 0, 0, 4, 4,
R_H_LINE_TO, 78,
R_ARC_TO, 4, 4, 0, 0, 0, 4, -4,
V_LINE_TO, 31,
R_ARC_TO, 4, 4, 0, 0, 0, -4, -4,
H_LINE_TO, 99,
R_ARC_TO, 4, 4, 0, 0, 0, -4, 4,
R_V_LINE_TO, 52,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x4C, 0x8D, 0xF6,
MOVE_TO, 177, 85,
H_LINE_TO, 99,
R_ARC_TO, 2, 2, 0, 0, 1, -2, -2,
V_LINE_TO, 31,
R_ARC_TO, 2, 2, 0, 0, 1, 2, -2,
R_H_LINE_TO, 78,
R_ARC_TO, 2, 2, 0, 0, 1, 2, 2,
R_V_LINE_TO, 52,
R_ARC_TO, 2, 2, 0, 0, 1, -2, 2,
CLOSE,
R_MOVE_TO, -78, 2,
R_ARC_TO, 4, 4, 0, 0, 1, -4, -4,
V_LINE_TO, 31,
R_ARC_TO, 4, 4, 0, 0, 1, 4, -4,
R_H_LINE_TO, 78,
R_ARC_TO, 4, 4, 0, 0, 1, 4, 4,
R_V_LINE_TO, 52,
R_ARC_TO, 4, 4, 0, 0, 1, -4, 4,
H_LINE_TO, 99,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x4C, 0x8D, 0xF6,
MOVE_TO, 85, 90,
R_H_LINE_TO, 106,
R_ARC_TO, 4, 4, 0, 0, 1, -4, 4,
H_LINE_TO, 89,
R_ARC_TO, 4, 4, 0, 0, 1, -4, -4,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
CIRCLE, 138, 31, 1,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
CIRCLE, 92, 17, 1,
CIRCLE, 96, 17, 1,
CIRCLE, 84, 17, 1,
CIRCLE, 88, 17, 1,
CIRCLE, 100, 17, 1,
CIRCLE, 281, 37, 1,
CIRCLE, 285, 37, 1,
CIRCLE, 76, 21, 1,
CIRCLE, 80, 21, 1,
CIRCLE, 64, 21, 1,
CIRCLE, 84, 21, 1,
CIRCLE, 88, 21, 1,
CIRCLE, 273, 37, 1,
CIRCLE, 72, 21, 1,
CIRCLE, 277, 37, 1,
CIRCLE, 289, 37, 1,
CIRCLE, 293, 37, 1,
CIRCLE, 297, 37, 1,
CIRCLE, 265, 41, 1,
CIRCLE, 269, 41, 1,
CIRCLE, 273, 41, 1,
CIRCLE, 277, 90, 1,
CIRCLE, 281, 90, 1,
CIRCLE, 273, 86, 1,
CIRCLE, 277, 86, 1,
CIRCLE, 285, 90, 1,
CIRCLE, 41, 75, 1,
CIRCLE, 281, 86, 1,
CIRCLE, 45, 75, 1,
CIRCLE, 37, 71, 1,
CIRCLE, 273, 90, 1,
CIRCLE, 269, 86, 1,
CIRCLE, 41, 71, 1,
CIRCLE, 49, 75, 1,
CIRCLE, 45, 71, 1,
CIRCLE, 21, 75, 1,
CIRCLE, 37, 75, 1,
CIRCLE, 25, 75, 1,
CIRCLE, 29, 75, 1,
CIRCLE, 33, 75, 1,
CIRCLE, 33, 71, 1,
CIRCLE, 261, 41, 1,
CIRCLE, 277, 41, 1,
CIRCLE, 281, 41, 1,
CIRCLE, 64, 49, 3,
CIRCLE, 72, 49, 3,
CIRCLE, 48, 49, 3,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
MOVE_TO, 281, 66,
R_ARC_TO, 3, 3, 0, 1, 0, -6, 0,
R_ARC_TO, 3, 3, 0, 0, 0, 6, 0,
CLOSE,
R_MOVE_TO, -16, 0,
R_ARC_TO, 3, 3, 0, 1, 0, -6, 0,
R_ARC_TO, 3, 3, 0, 0, 0, 6, 0,
CLOSE,
R_MOVE_TO, -8, 0,
R_ARC_TO, 3, 3, 0, 1, 0, -6, 0,
R_ARC_TO, 3, 3, 0, 0, 0, 6, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPasskeyAoaDarkRepList, kPasskeyAoaDarkIcon, {kPasskeyAoaDarkPath})
VECTOR_ICON_REP_TEMPLATE(kPasskeyErrorPath, CANVAS_DIMENSIONS, 316,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xDA, 0xDC, 0xE0,
CIRCLE, 206, 48, 10,
CIRCLE, 181, 48, 10,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x0B, 0x57, 0xD0,
MOVE_TO, 152.87, 70.67,
R_CUBIC_TO, 0, -4.95, 0.44, -8.51, 1.33, -10.68,
R_CUBIC_TO, 0.88, -2.17, 2.76, -4.54, 5.64, -7.1,
R_CUBIC_TO, 2.51, -2.2, 4.42, -4.11, 5.73, -5.73,
R_CUBIC_TO, 1.32, -1.62, 1.97, -3.47, 1.97, -5.54,
R_CUBIC_TO, 0, -2.5, -0.84, -4.58, -2.52, -6.23,
R_CUBIC_TO, -1.68, -1.65, -4.02, -2.47, -7.01, -2.47,
R_CUBIC_TO, -3.12, 0, -5.48, 0.95, -7.11, 2.84,
R_CUBIC_TO, -1.62, 1.89, -2.76, 3.82, -3.44, 5.78,
R_LINE_TO, -9.44, -4.03,
R_CUBIC_TO, 1.28, -3.91, 3.64, -7.3, 7.06, -10.18,
R_CUBIC_TO, 3.42, -2.87, 7.73, -4.31, 12.93, -4.31,
R_CUBIC_TO, 6.42, 0, 11.35, 1.79, 14.81, 5.36,
R_CUBIC_TO, 3.45, 3.57, 5.18, 7.87, 5.18, 12.88,
R_CUBIC_TO, 0, 3.06, -0.66, 5.67, -1.97, 7.84,
R_CUBIC_TO, -1.31, 2.17, -3.38, 4.63, -6.19, 7.38,
R_CUBIC_TO, -2.99, 2.87, -4.81, 5.06, -5.45, 6.55,
R_CUBIC_TO, -0.64, 1.5, -0.96, 4.05, -0.96, 7.66,
R_H_LINE_TO, -10.54,
CLOSE,
R_MOVE_TO, 5.13, 22,
R_CUBIC_TO, -2.02, 0, -3.74, -0.72, -5.18, -2.15,
R_CUBIC_TO, -1.44, -1.44, -2.16, -3.16, -2.16, -5.18,
R_CUBIC_TO, 0, -2.02, 0.72, -3.74, 2.16, -5.18,
R_CUBIC_TO, 1.43, -1.43, 3.16, -2.15, 5.18, -2.15,
R_CUBIC_TO, 2.02, 0, 3.74, 0.72, 5.18, 2.15,
R_CUBIC_TO, 1.44, 1.44, 2.15, 3.17, 2.15, 5.18,
R_CUBIC_TO, 0, 2.02, -0.72, 3.74, -2.15, 5.18,
R_CUBIC_TO, -1.44, 1.44, -3.16, 2.15, -5.18, 2.15,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xFF, 0xFF,
MOVE_TO, 172.65, 53.51,
ARC_TO, 9.96, 9.96, 0, 0, 1, 171, 48,
R_CUBIC_TO, 0, -4.4, 2.85, -8.15, 6.81, -9.48,
R_CUBIC_TO, 0.12, 0.88, 0.18, 1.79, 0.18, 2.72,
R_CUBIC_TO, 0, 3.06, -0.66, 5.67, -1.97, 7.84,
R_CUBIC_TO, -0.82, 1.36, -1.95, 2.84, -3.36, 4.43,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xDA, 0xDC, 0xE0,
CIRCLE, 135, 65, 10,
CIRCLE, 110, 65, 10,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xDA, 0xDC, 0xE0,
CIRCLE, 92, 17, 1,
CIRCLE, 96, 17, 1,
CIRCLE, 84, 17, 1,
CIRCLE, 88, 17, 1,
CIRCLE, 100, 17, 1,
CIRCLE, 107, 86, 1,
CIRCLE, 99, 86, 1,
CIRCLE, 103, 86, 1,
CIRCLE, 111, 86, 1,
CIRCLE, 229, 20, 1,
CIRCLE, 233, 20, 1,
CIRCLE, 221, 20, 1,
CIRCLE, 225, 20, 1,
CIRCLE, 115, 86, 1,
CIRCLE, 281, 37, 1,
CIRCLE, 285, 37, 1,
CIRCLE, 76, 21, 1,
CIRCLE, 80, 21, 1,
CIRCLE, 64, 21, 1,
CIRCLE, 84, 21, 1,
CIRCLE, 88, 21, 1,
CIRCLE, 273, 37, 1,
CIRCLE, 72, 21, 1,
CIRCLE, 277, 37, 1,
CIRCLE, 289, 37, 1,
CIRCLE, 293, 37, 1,
CIRCLE, 297, 37, 1,
CIRCLE, 91, 90, 1,
CIRCLE, 95, 90, 1,
CIRCLE, 99, 90, 1,
CIRCLE, 103, 90, 1,
CIRCLE, 107, 90, 1,
CIRCLE, 87, 90, 1,
CIRCLE, 265, 41, 1,
CIRCLE, 269, 41, 1,
CIRCLE, 273, 41, 1,
CIRCLE, 253, 90, 1,
CIRCLE, 257, 90, 1,
CIRCLE, 249, 86, 1,
CIRCLE, 253, 86, 1,
CIRCLE, 261, 90, 1,
CIRCLE, 39, 69, 1,
CIRCLE, 257, 86, 1,
CIRCLE, 43, 69, 1,
CIRCLE, 35, 65, 1,
CIRCLE, 233, 90, 1,
CIRCLE, 249, 90, 1,
CIRCLE, 237, 90, 1,
CIRCLE, 241, 90, 1,
CIRCLE, 245, 90, 1,
CIRCLE, 245, 86, 1,
CIRCLE, 39, 65, 1,
CIRCLE, 47, 69, 1,
CIRCLE, 43, 65, 1,
CIRCLE, 19, 69, 1,
CIRCLE, 35, 69, 1,
CIRCLE, 23, 69, 1,
CIRCLE, 27, 69, 1,
CIRCLE, 31, 69, 1,
CIRCLE, 31, 65, 1,
CIRCLE, 261, 41, 1,
CIRCLE, 277, 41, 1,
CIRCLE, 281, 41, 1,
CIRCLE, 70, 44, 3,
CIRCLE, 78, 44, 3,
CIRCLE, 86, 44, 3,
CIRCLE, 54, 44, 3,
CIRCLE, 220, 69, 3,
CIRCLE, 228, 69, 3,
CIRCLE, 236, 69, 3,
CIRCLE, 252, 69, 3)
VECTOR_ICON_TEMPLATE_CC(kPasskeyErrorRepList, kPasskeyErrorIcon, {kPasskeyErrorPath})
VECTOR_ICON_REP_TEMPLATE(kPasskeyErrorBluetoothPath, CANVAS_DIMENSIONS, 316,
PATH_COLOR_ARGB, 0xFF, 0xDA, 0xDC, 0xE0,
CIRCLE, 92, 17, 1,
CIRCLE, 96, 17, 1,
CIRCLE, 84, 17, 1,
CIRCLE, 88, 17, 1,
CIRCLE, 100, 17, 1,
CIRCLE, 107, 86, 1,
CIRCLE, 99, 86, 1,
CIRCLE, 103, 86, 1,
CIRCLE, 111, 86, 1,
CIRCLE, 229, 20, 1,
CIRCLE, 233, 20, 1,
CIRCLE, 221, 20, 1,
CIRCLE, 225, 20, 1,
CIRCLE, 115, 86, 1,
CIRCLE, 281, 37, 1,
CIRCLE, 285, 37, 1,
CIRCLE, 76, 21, 1,
CIRCLE, 80, 21, 1,
CIRCLE, 64, 21, 1,
CIRCLE, 84, 21, 1,
CIRCLE, 88, 21, 1,
CIRCLE, 273, 37, 1,
CIRCLE, 72, 21, 1,
CIRCLE, 277, 37, 1,
CIRCLE, 289, 37, 1,
CIRCLE, 293, 37, 1,
CIRCLE, 297, 37, 1,
CIRCLE, 91, 90, 1,
CIRCLE, 95, 90, 1,
CIRCLE, 99, 90, 1,
CIRCLE, 103, 90, 1,
CIRCLE, 107, 90, 1,
CIRCLE, 87, 90, 1,
CIRCLE, 265, 41, 1,
CIRCLE, 269, 41, 1,
CIRCLE, 273, 41, 1,
CIRCLE, 253, 90, 1,
CIRCLE, 257, 90, 1,
CIRCLE, 249, 86, 1,
CIRCLE, 253, 86, 1,
CIRCLE, 261, 90, 1,
CIRCLE, 39, 69, 1,
CIRCLE, 257, 86, 1,
CIRCLE, 43, 69, 1,
CIRCLE, 35, 65, 1,
CIRCLE, 233, 90, 1,
CIRCLE, 249, 90, 1,
CIRCLE, 237, 90, 1,
CIRCLE, 241, 90, 1,
CIRCLE, 245, 90, 1,
CIRCLE, 245, 86, 1,
CIRCLE, 39, 65, 1,
CIRCLE, 47, 69, 1,
CIRCLE, 43, 65, 1,
CIRCLE, 19, 69, 1,
CIRCLE, 35, 69, 1,
CIRCLE, 23, 69, 1,
CIRCLE, 27, 69, 1,
CIRCLE, 31, 69, 1,
CIRCLE, 31, 65, 1,
CIRCLE, 261, 41, 1,
CIRCLE, 277, 41, 1,
CIRCLE, 281, 41, 1,
CIRCLE, 70, 44, 3,
CIRCLE, 78, 44, 3,
CIRCLE, 86, 44, 3,
CIRCLE, 54, 44, 3,
CIRCLE, 220, 69, 3,
CIRCLE, 228, 69, 3,
CIRCLE, 236, 69, 3,
CIRCLE, 252, 69, 3,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xDA, 0xDC, 0xE0,
MOVE_TO, 125, 35,
R_CUBIC_TO, 0, 5.52, -4.48, 10, -10, 10,
R_CUBIC_TO, -5.52, 0, -10, -4.48, -10, -10,
R_CUBIC_TO, 0, -5.52, 4.48, -10, 10, -10,
R_CUBIC_TO, 5.52, 0, 10, 4.48, 10, 10,
CLOSE,
R_MOVE_TO, 25, 0,
R_CUBIC_TO, 0, 5.52, -4.48, 10, -10, 10,
R_CUBIC_TO, -5.52, 0, -10, -4.48, -10, -10,
R_CUBIC_TO, 0, -5.52, 4.48, -10, 10, -10,
R_CUBIC_TO, 5.52, 0, 10, 4.48, 10, 10,
CLOSE,
R_MOVE_TO, 41, 42,
R_CUBIC_TO, 0, 5.52, -4.48, 10, -10, 10,
R_CUBIC_TO, -5.52, 0, -10, -4.48, -10, -10,
R_CUBIC_TO, 0, -5.52, 4.48, -10, 10, -10,
R_CUBIC_TO, 5.52, 0, 10, 4.48, 10, 10,
CLOSE,
R_MOVE_TO, 25, 0,
R_CUBIC_TO, 0, 5.52, -4.48, 10, -10, 10,
R_CUBIC_TO, -5.52, 0, -10, -4.48, -10, -10,
R_CUBIC_TO, 0, -5.52, 4.48, -10, 10, -10,
R_CUBIC_TO, 5.52, 0, 10, 4.48, 10, 10,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x0B, 0x57, 0xD0,
R_MOVE_TO, 160.58, 40.06,
R_LINE_TO, 4.86, 4.86,
R_LINE_TO, -4.13, 4.13,
R_LINE_TO, 3.64, 3.64,
R_LINE_TO, 7.8, -7.8,
LINE_TO, 158, 30.17,
R_H_LINE_TO, -2.58,
V_LINE_TO, 43.16,
R_LINE_TO, 5.17, 5.17,
V_LINE_TO, 40.06,
CLOSE,
R_MOVE_TO, -19.61, -4.73,
R_LINE_TO, -3.64, 3.64,
LINE_TO, 154.36, 56,
R_LINE_TO, -14.44, 14.44,
R_LINE_TO, 3.64, 3.64,
R_LINE_TO, 11.86, -11.86,
R_V_LINE_TO, 19.61,
H_LINE_TO, 158,
R_LINE_TO, 11.08, -11.08,
R_LINE_TO, 5.94, 5.92,
R_LINE_TO, 3.64, -3.64,
R_LINE_TO, -37.69, -37.69,
CLOSE,
R_MOVE_TO, 24.46, 31.75,
R_LINE_TO, -4.86, -4.86,
R_V_LINE_TO, 9.71,
R_LINE_TO, 4.86, -4.86,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPasskeyErrorBluetoothRepList, kPasskeyErrorBluetoothIcon, {kPasskeyErrorBluetoothPath})
VECTOR_ICON_REP_TEMPLATE(kPasskeyErrorBluetoothDarkPath, CANVAS_DIMENSIONS, 316,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
CIRCLE, 92, 17, 1,
CIRCLE, 96, 17, 1,
CIRCLE, 84, 17, 1,
CIRCLE, 88, 17, 1,
CIRCLE, 100, 17, 1,
CIRCLE, 107, 86, 1,
CIRCLE, 99, 86, 1,
CIRCLE, 103, 86, 1,
CIRCLE, 111, 86, 1,
CIRCLE, 229, 20, 1,
CIRCLE, 233, 20, 1,
CIRCLE, 221, 20, 1,
CIRCLE, 225, 20, 1,
CIRCLE, 115, 86, 1,
CIRCLE, 281, 37, 1,
CIRCLE, 285, 37, 1,
CIRCLE, 76, 21, 1,
CIRCLE, 80, 21, 1,
CIRCLE, 64, 21, 1,
CIRCLE, 84, 21, 1,
CIRCLE, 88, 21, 1,
CIRCLE, 273, 37, 1,
CIRCLE, 72, 21, 1,
CIRCLE, 277, 37, 1,
CIRCLE, 289, 37, 1,
CIRCLE, 293, 37, 1,
CIRCLE, 297, 37, 1,
CIRCLE, 91, 90, 1,
CIRCLE, 95, 90, 1,
CIRCLE, 99, 90, 1,
CIRCLE, 103, 90, 1,
CIRCLE, 107, 90, 1,
CIRCLE, 87, 90, 1,
CIRCLE, 265, 41, 1,
CIRCLE, 269, 41, 1,
CIRCLE, 273, 41, 1,
CIRCLE, 253, 90, 1,
CIRCLE, 257, 90, 1,
CIRCLE, 249, 86, 1,
CIRCLE, 253, 86, 1,
CIRCLE, 261, 90, 1,
CIRCLE, 39, 69, 1,
CIRCLE, 257, 86, 1,
CIRCLE, 43, 69, 1,
CIRCLE, 35, 65, 1,
CIRCLE, 233, 90, 1,
CIRCLE, 249, 90, 1,
CIRCLE, 237, 90, 1,
CIRCLE, 241, 90, 1,
CIRCLE, 245, 90, 1,
CIRCLE, 245, 86, 1,
CIRCLE, 39, 65, 1,
CIRCLE, 47, 69, 1,
CIRCLE, 43, 65, 1,
CIRCLE, 19, 69, 1,
CIRCLE, 35, 69, 1,
CIRCLE, 23, 69, 1,
CIRCLE, 27, 69, 1,
CIRCLE, 31, 69, 1,
CIRCLE, 31, 65, 1,
CIRCLE, 261, 41, 1,
CIRCLE, 277, 41, 1,
CIRCLE, 281, 41, 1,
CIRCLE, 70, 44, 3,
CIRCLE, 78, 44, 3,
CIRCLE, 86, 44, 3,
CIRCLE, 54, 44, 3,
CIRCLE, 220, 69, 3,
CIRCLE, 228, 69, 3,
CIRCLE, 236, 69, 3,
CIRCLE, 252, 69, 3,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x3C, 0x40, 0x43,
MOVE_TO, 125, 35,
R_CUBIC_TO, 0, 5.52, -4.48, 10, -10, 10,
R_CUBIC_TO, -5.52, 0, -10, -4.48, -10, -10,
R_CUBIC_TO, 0, -5.52, 4.48, -10, 10, -10,
R_CUBIC_TO, 5.52, 0, 10, 4.48, 10, 10,
CLOSE,
R_MOVE_TO, 25, 0,
R_CUBIC_TO, 0, 5.52, -4.48, 10, -10, 10,
R_CUBIC_TO, -5.52, 0, -10, -4.48, -10, -10,
R_CUBIC_TO, 0, -5.52, 4.48, -10, 10, -10,
R_CUBIC_TO, 5.52, 0, 10, 4.48, 10, 10,
CLOSE,
R_MOVE_TO, 41, 42,
R_CUBIC_TO, 0, 5.52, -4.48, 10, -10, 10,
R_CUBIC_TO, -5.52, 0, -10, -4.48, -10, -10,
R_CUBIC_TO, 0, -5.52, 4.48, -10, 10, -10,
R_CUBIC_TO, 5.52, 0, 10, 4.48, 10, 10,
CLOSE,
R_MOVE_TO, 25, 0,
R_CUBIC_TO, 0, 5.52, -4.48, 10, -10, 10,
R_CUBIC_TO, -5.52, 0, -10, -4.48, -10, -10,
R_CUBIC_TO, 0, -5.52, 4.48, -10, 10, -10,
R_CUBIC_TO, 5.52, 0, 10, 4.48, 10, 10,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x4C, 0x8D, 0xF6,
R_MOVE_TO, 160.58, 40.06,
R_LINE_TO, 4.86, 4.86,
R_LINE_TO, -4.13, 4.13,
R_LINE_TO, 3.64, 3.64,
R_LINE_TO, 7.8, -7.8,
LINE_TO, 158, 30.17,
R_H_LINE_TO, -2.58,
V_LINE_TO, 43.16,
R_LINE_TO, 5.17, 5.17,
V_LINE_TO, 40.06,
CLOSE,
R_MOVE_TO, -19.61, -4.73,
R_LINE_TO, -3.64, 3.64,
LINE_TO, 154.36, 56,
R_LINE_TO, -14.44, 14.44,
R_LINE_TO, 3.64, 3.64,
R_LINE_TO, 11.86, -11.86,
R_V_LINE_TO, 19.61,
H_LINE_TO, 158,
R_LINE_TO, 11.08, -11.08,
R_LINE_TO, 5.94, 5.92,
R_LINE_TO, 3.64, -3.64,
R_LINE_TO, -37.69, -37.69,
CLOSE,
R_MOVE_TO, 24.46, 31.75,
R_LINE_TO, -4.86, -4.86,
R_V_LINE_TO, 9.71,
R_LINE_TO, 4.86, -4.86,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPasskeyErrorBluetoothDarkRepList, kPasskeyErrorBluetoothDarkIcon, {kPasskeyErrorBluetoothDarkPath})
VECTOR_ICON_REP_TEMPLATE(kPasskeyErrorDarkPath, CANVAS_DIMENSIONS, 316,
PATH_COLOR_ARGB, 0xFF, 0x3C, 0x40, 0x43,
CIRCLE, 206, 48, 10,
CIRCLE, 181, 48, 10,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x4C, 0x8D, 0xF6,
MOVE_TO, 152.87, 70.67,
R_CUBIC_TO, 0, -4.95, 0.44, -8.51, 1.33, -10.68,
R_CUBIC_TO, 0.88, -2.17, 2.76, -4.54, 5.64, -7.1,
R_CUBIC_TO, 2.51, -2.2, 4.42, -4.11, 5.73, -5.73,
R_CUBIC_TO, 1.32, -1.62, 1.97, -3.47, 1.97, -5.54,
R_CUBIC_TO, 0, -2.5, -0.84, -4.58, -2.52, -6.23,
R_CUBIC_TO, -1.68, -1.65, -4.02, -2.47, -7.01, -2.47,
R_CUBIC_TO, -3.12, 0, -5.48, 0.95, -7.11, 2.84,
R_CUBIC_TO, -1.62, 1.89, -2.76, 3.82, -3.44, 5.78,
R_LINE_TO, -9.44, -4.03,
R_CUBIC_TO, 1.28, -3.91, 3.64, -7.3, 7.06, -10.18,
R_CUBIC_TO, 3.42, -2.87, 7.73, -4.31, 12.93, -4.31,
R_CUBIC_TO, 6.42, 0, 11.35, 1.79, 14.81, 5.36,
R_CUBIC_TO, 3.45, 3.57, 5.18, 7.87, 5.18, 12.88,
R_CUBIC_TO, 0, 3.06, -0.66, 5.67, -1.97, 7.84,
R_CUBIC_TO, -1.31, 2.17, -3.38, 4.63, -6.19, 7.38,
R_CUBIC_TO, -2.99, 2.87, -4.81, 5.06, -5.45, 6.55,
R_CUBIC_TO, -0.64, 1.5, -0.96, 4.05, -0.96, 7.66,
R_H_LINE_TO, -10.54,
CLOSE,
R_MOVE_TO, 5.13, 22,
R_CUBIC_TO, -2.02, 0, -3.74, -0.72, -5.18, -2.15,
R_CUBIC_TO, -1.44, -1.44, -2.16, -3.16, -2.16, -5.18,
R_CUBIC_TO, 0, -2.02, 0.72, -3.74, 2.16, -5.18,
R_CUBIC_TO, 1.43, -1.43, 3.16, -2.15, 5.18, -2.15,
R_CUBIC_TO, 2.02, 0, 3.74, 0.72, 5.18, 2.15,
R_CUBIC_TO, 1.44, 1.44, 2.15, 3.17, 2.15, 5.18,
R_CUBIC_TO, 0, 2.02, -0.72, 3.74, -2.15, 5.18,
R_CUBIC_TO, -1.44, 1.44, -3.16, 2.15, -5.18, 2.15,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x20, 0x21, 0x24,
MOVE_TO, 172.65, 53.51,
ARC_TO, 9.96, 9.96, 0, 0, 1, 171, 48,
R_CUBIC_TO, 0, -4.4, 2.85, -8.15, 6.81, -9.48,
R_CUBIC_TO, 0.12, 0.88, 0.18, 1.79, 0.18, 2.72,
R_CUBIC_TO, 0, 3.06, -0.66, 5.67, -1.97, 7.84,
R_CUBIC_TO, -0.82, 1.36, -1.95, 2.84, -3.36, 4.43,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x3C, 0x40, 0x43,
CIRCLE, 135, 65, 10,
CIRCLE, 110, 65, 10,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
CIRCLE, 92, 17, 1,
CIRCLE, 96, 17, 1,
CIRCLE, 84, 17, 1,
CIRCLE, 88, 17, 1,
CIRCLE, 100, 17, 1,
CIRCLE, 107, 86, 1,
CIRCLE, 99, 86, 1,
CIRCLE, 103, 86, 1,
CIRCLE, 111, 86, 1,
CIRCLE, 229, 20, 1,
CIRCLE, 233, 20, 1,
CIRCLE, 221, 20, 1,
CIRCLE, 225, 20, 1,
CIRCLE, 115, 86, 1,
CIRCLE, 281, 37, 1,
CIRCLE, 285, 37, 1,
CIRCLE, 76, 21, 1,
CIRCLE, 80, 21, 1,
CIRCLE, 64, 21, 1,
CIRCLE, 84, 21, 1,
CIRCLE, 88, 21, 1,
CIRCLE, 273, 37, 1,
CIRCLE, 72, 21, 1,
CIRCLE, 277, 37, 1,
CIRCLE, 289, 37, 1,
CIRCLE, 293, 37, 1,
CIRCLE, 297, 37, 1,
CIRCLE, 91, 90, 1,
CIRCLE, 95, 90, 1,
CIRCLE, 99, 90, 1,
CIRCLE, 103, 90, 1,
CIRCLE, 107, 90, 1,
CIRCLE, 87, 90, 1,
CIRCLE, 265, 41, 1,
CIRCLE, 269, 41, 1,
CIRCLE, 273, 41, 1,
CIRCLE, 253, 90, 1,
CIRCLE, 257, 90, 1,
CIRCLE, 249, 86, 1,
CIRCLE, 253, 86, 1,
CIRCLE, 261, 90, 1,
CIRCLE, 39, 69, 1,
CIRCLE, 257, 86, 1,
CIRCLE, 43, 69, 1,
CIRCLE, 35, 65, 1,
CIRCLE, 233, 90, 1,
CIRCLE, 249, 90, 1,
CIRCLE, 237, 90, 1,
CIRCLE, 241, 90, 1,
CIRCLE, 245, 90, 1,
CIRCLE, 245, 86, 1,
CIRCLE, 39, 65, 1,
CIRCLE, 47, 69, 1,
CIRCLE, 43, 65, 1,
CIRCLE, 19, 69, 1,
CIRCLE, 35, 69, 1,
CIRCLE, 23, 69, 1,
CIRCLE, 27, 69, 1,
CIRCLE, 31, 69, 1,
CIRCLE, 31, 65, 1,
CIRCLE, 261, 41, 1,
CIRCLE, 277, 41, 1,
CIRCLE, 281, 41, 1,
CIRCLE, 70, 44, 3,
CIRCLE, 78, 44, 3,
CIRCLE, 86, 44, 3,
CIRCLE, 54, 44, 3,
CIRCLE, 220, 69, 3,
CIRCLE, 228, 69, 3,
CIRCLE, 236, 69, 3,
CIRCLE, 252, 69, 3)
VECTOR_ICON_TEMPLATE_CC(kPasskeyErrorDarkRepList, kPasskeyErrorDarkIcon, {kPasskeyErrorDarkPath})
VECTOR_ICON_REP_TEMPLATE(kPasskeyFingerprintPath, CANVAS_DIMENSIONS, 316,
PATH_COLOR_ARGB, 0xFF, 0xDA, 0xDC, 0xE0,
MOVE_TO, 152.39, 15.35,
R_CUBIC_TO, 3.03, -4.13, 9.2, -4.13, 12.23, 0,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, 9.17, 2.46,
R_CUBIC_TO, 4.69, -2.07, 10.03, 1.02, 10.59, 6.11,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, 6.71, 6.71,
R_CUBIC_TO, 5.09, 0.56, 8.18, 5.9, 6.11, 10.59,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, 2.46, 9.17,
R_CUBIC_TO, 4.13, 3.03, 4.13, 9.2, 0, 12.23,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, -2.46, 9.17,
R_CUBIC_TO, 2.07, 4.69, -1.02, 10.03, -6.11, 10.59,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, -6.71, 6.71,
R_CUBIC_TO, -0.56, 5.09, -5.9, 8.18, -10.59, 6.11,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, -9.17, 2.46,
R_CUBIC_TO, -3.03, 4.13, -9.2, 4.13, -12.23, 0,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, -9.17, -2.46,
R_CUBIC_TO, -4.69, 2.07, -10.03, -1.02, -10.59, -6.11,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, -6.71, -6.71,
R_CUBIC_TO, -5.09, -0.56, -8.18, -5.9, -6.11, -10.59,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, -2.46, -9.17,
R_CUBIC_TO, -4.13, -3.03, -4.13, -9.2, 0, -12.23,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, 2.46, -9.17,
R_CUBIC_TO, -2.07, -4.69, 1.02, -10.03, 6.11, -10.59,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, 6.71, -6.71,
R_CUBIC_TO, 0.56, -5.09, 5.9, -8.18, 10.59, -6.11,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, 9.17, -2.46,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x0B, 0x57, 0xD0,
MOVE_TO, 173.04, 36.8,
R_ARC_TO, 1.12, 1.12, 0, 0, 1, -0.56, -0.14,
R_CUBIC_TO, -4.64, -2.39, -8.65, -3.41, -13.46, -3.41,
R_CUBIC_TO, -4.78, 0, -9.33, 1.14, -13.46, 3.41,
R_CUBIC_TO, -0.58, 0.31, -1.3, 0.1, -1.64, -0.48,
R_ARC_TO, 1.22, 1.22, 0, 0, 1, 0.48, -1.64,
R_CUBIC_TO, 4.5, -2.44, 9.43, -3.7, 14.62, -3.7,
R_CUBIC_TO, 5.15, 0, 9.64, 1.14, 14.57, 3.67,
R_CUBIC_TO, 0.6, 0.31, 0.82, 1.04, 0.51, 1.62,
R_ARC_TO, 1.19, 1.19, 0, 0, 1, -1.06, 0.68,
CLOSE,
R_MOVE_TO, -34.58, 12.69,
R_ARC_TO, 1.21, 1.21, 0, 0, 1, -0.99, -1.91,
R_CUBIC_TO, 2.39, -3.38, 5.44, -6.04, 9.06, -7.9,
R_CUBIC_TO, 7.59, -3.91, 17.3, -3.94, 24.92, -0.02,
R_CUBIC_TO, 3.63, 1.86, 6.67, 4.5, 9.06, 7.85,
R_ARC_TO, 1.21, 1.21, 0, 0, 1, -0.29, 1.69,
R_ARC_TO, 1.21, 1.21, 0, 0, 1, -1.69, -0.29,
R_CUBIC_TO, -2.17, -3.04, -4.93, -5.44, -8.19, -7.1,
R_CUBIC_TO, -6.94, -3.55, -15.8, -3.55, -22.72, 0.03,
R_CUBIC_TO, -3.29, 1.69, -6.04, 4.11, -8.22, 7.15,
R_CUBIC_TO, -0.19, 0.34, -0.56, 0.51, -0.94, 0.51,
CLOSE,
R_MOVE_TO, 14.26, 28.81,
R_CUBIC_TO, 0.22, 0.24, 0.53, 0.36, 0.85, 0.36,
R_CUBIC_TO, 0.32, 0, 0.63, -0.12, 0.9, -0.36,
R_ARC_TO, 1.24, 1.24, 0, 0, 0, 0, -1.72,
R_CUBIC_TO, -1.86, -1.88, -2.92, -3.07, -4.47, -5.85,
R_CUBIC_TO, -1.47, -2.61, -2.25, -5.82, -2.25, -9.3,
R_CUBIC_TO, 0, -5.85, 5.05, -10.61, 11.26, -10.61,
R_CUBIC_TO, 6.21, 0, 11.26, 4.76, 11.26, 10.61,
R_CUBIC_TO, 0, 0.68, 0.53, 1.21, 1.21, 1.21,
R_CUBIC_TO, 0.68, 0, 1.21, -0.53, 1.21, -1.21,
R_CUBIC_TO, 0, -7.18, -6.14, -13.03, -13.68, -13.03,
R_CUBIC_TO, -7.54, 0, -13.68, 5.85, -13.68, 13.03,
R_CUBIC_TO, 0, 3.89, 0.87, 7.52, 2.54, 10.49,
R_CUBIC_TO, 1.62, 2.92, 2.76, 4.28, 4.86, 6.38,
CLOSE,
R_MOVE_TO, 18.17, -4.11,
R_CUBIC_TO, -2.88, 0, -5.41, -0.72, -7.49, -2.15,
R_CUBIC_TO, -3.6, -2.44, -5.75, -6.4, -5.75, -10.61,
R_CUBIC_TO, 0, -0.68, 0.53, -1.21, 1.21, -1.21,
R_CUBIC_TO, 0.68, 0, 1.21, 0.53, 1.21, 1.21,
R_CUBIC_TO, 0, 3.41, 1.74, 6.62, 4.69, 8.6,
R_CUBIC_TO, 1.72, 1.16, 3.72, 1.72, 6.14, 1.72,
R_CUBIC_TO, 0.58, 0, 1.55, -0.07, 2.51, -0.24,
R_CUBIC_TO, 0.65, -0.12, 1.28, 0.31, 1.4, 0.99,
R_ARC_TO, 1.2, 1.2, 0, 0, 1, -0.99, 1.4,
R_CUBIC_TO, -1.38, 0.27, -2.58, 0.29, -2.92, 0.29,
CLOSE,
R_MOVE_TO, -5.17, 4.93,
R_CUBIC_TO, 0.1, 0.03, 0.22, 0.05, 0.31, 0.05,
R_ARC_TO, 1.18, 1.18, 0, 0, 0, 1.14, -0.92,
R_ARC_TO, 1.2, 1.2, 0, 0, 0, -0.85, -1.47,
R_CUBIC_TO, -3.41, -0.94, -5.61, -2.2, -7.9, -4.47,
R_CUBIC_TO, -2.92, -2.9, -4.52, -6.77, -4.52, -10.9,
R_CUBIC_TO, 0, -2.58, 2.25, -4.69, 5.03, -4.69,
R_CUBIC_TO, 2.78, 0, 5.03, 2.1, 5.03, 4.69,
R_CUBIC_TO, 0, 3.92, 3.34, 7.11, 7.44, 7.11,
R_CUBIC_TO, 4.1, 0, 7.44, -3.19, 7.44, -7.1,
R_CUBIC_TO, 0, -10.44, -8.94, -18.92, -19.94, -18.92,
R_CUBIC_TO, -7.81, 0, -14.93, 4.37, -18.15, 11.12,
R_CUBIC_TO, -1.09, 2.3, -1.64, 4.93, -1.64, 7.83,
R_CUBIC_TO, 0, 3.26, 0.58, 6.4, 1.76, 9.57,
R_ARC_TO, 1.2, 1.2, 0, 0, 0, 1.55, 0.7,
R_ARC_TO, 1.18, 1.18, 0, 0, 0, 0.7, -1.55,
R_CUBIC_TO, -1.45, -3.87, -1.62, -6.84, -1.62, -8.72,
R_CUBIC_TO, 0, -2.51, 0.48, -4.81, 1.43, -6.77,
R_CUBIC_TO, 2.83, -5.92, 9.11, -9.74, 15.97, -9.74,
R_CUBIC_TO, 9.67, 0, 17.52, 7.4, 17.52, 16.51,
R_CUBIC_TO, 0, 2.59, -2.25, 4.69, -5.03, 4.69,
R_CUBIC_TO, -2.78, 0, -5.03, -2.1, -5.03, -4.69,
R_CUBIC_TO, 0, -3.91, -3.33, -7.1, -7.44, -7.1,
R_CUBIC_TO, -4.11, 0, -7.44, 3.19, -7.44, 7.11,
R_CUBIC_TO, 0, 4.79, 1.86, 9.26, 5.24, 12.62,
R_CUBIC_TO, 2.63, 2.59, 5.15, 4.01, 8.99, 5.08,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xDA, 0xDC, 0xE0,
CIRCLE, 92, 17, 1,
CIRCLE, 96, 17, 1,
CIRCLE, 84, 17, 1,
CIRCLE, 88, 17, 1,
CIRCLE, 100, 17, 1,
CIRCLE, 107, 86, 1,
CIRCLE, 99, 86, 1,
CIRCLE, 103, 86, 1,
CIRCLE, 111, 86, 1,
CIRCLE, 229, 20, 1,
CIRCLE, 233, 20, 1,
CIRCLE, 221, 20, 1,
CIRCLE, 225, 20, 1,
CIRCLE, 115, 86, 1,
CIRCLE, 281, 37, 1,
CIRCLE, 285, 37, 1,
CIRCLE, 76, 21, 1,
CIRCLE, 80, 21, 1,
CIRCLE, 64, 21, 1,
CIRCLE, 84, 21, 1,
CIRCLE, 88, 21, 1,
CIRCLE, 273, 37, 1,
CIRCLE, 72, 21, 1,
CIRCLE, 277, 37, 1,
CIRCLE, 289, 37, 1,
CIRCLE, 293, 37, 1,
CIRCLE, 297, 37, 1,
CIRCLE, 91, 90, 1,
CIRCLE, 95, 90, 1,
CIRCLE, 99, 90, 1,
CIRCLE, 103, 90, 1,
CIRCLE, 107, 90, 1,
CIRCLE, 87, 90, 1,
CIRCLE, 265, 41, 1,
CIRCLE, 269, 41, 1,
CIRCLE, 273, 41, 1,
CIRCLE, 253, 90, 1,
CIRCLE, 257, 90, 1,
CIRCLE, 249, 86, 1,
CIRCLE, 253, 86, 1,
CIRCLE, 261, 90, 1,
CIRCLE, 39, 69, 1,
CIRCLE, 257, 86, 1,
CIRCLE, 43, 69, 1,
CIRCLE, 35, 65, 1,
CIRCLE, 233, 90, 1,
CIRCLE, 249, 90, 1,
CIRCLE, 237, 90, 1,
CIRCLE, 241, 90, 1,
CIRCLE, 245, 90, 1,
CIRCLE, 245, 86, 1,
CIRCLE, 39, 65, 1,
CIRCLE, 47, 69, 1,
CIRCLE, 43, 65, 1,
CIRCLE, 19, 69, 1,
CIRCLE, 35, 69, 1,
CIRCLE, 23, 69, 1,
CIRCLE, 27, 69, 1,
CIRCLE, 31, 69, 1,
CIRCLE, 31, 65, 1,
CIRCLE, 261, 41, 1,
CIRCLE, 277, 41, 1,
CIRCLE, 281, 41, 1,
CIRCLE, 70, 44, 3,
CIRCLE, 78, 44, 3,
CIRCLE, 86, 44, 3,
CIRCLE, 54, 44, 3,
CIRCLE, 220, 69, 3,
CIRCLE, 228, 69, 3,
CIRCLE, 236, 69, 3,
CIRCLE, 252, 69, 3)
VECTOR_ICON_TEMPLATE_CC(kPasskeyFingerprintRepList, kPasskeyFingerprintIcon, {kPasskeyFingerprintPath})
VECTOR_ICON_REP_TEMPLATE(kPasskeyFingerprintDarkPath, CANVAS_DIMENSIONS, 316,
PATH_COLOR_ARGB, 0xFF, 0x3C, 0x40, 0x43,
MOVE_TO, 152.39, 15.35,
R_CUBIC_TO, 3.03, -4.13, 9.2, -4.13, 12.23, 0,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, 9.17, 2.46,
R_CUBIC_TO, 4.69, -2.07, 10.03, 1.02, 10.59, 6.11,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, 6.71, 6.71,
R_CUBIC_TO, 5.09, 0.56, 8.18, 5.9, 6.11, 10.59,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, 2.46, 9.17,
R_CUBIC_TO, 4.13, 3.03, 4.13, 9.2, 0, 12.23,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, -2.46, 9.17,
R_CUBIC_TO, 2.07, 4.69, -1.02, 10.03, -6.11, 10.59,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, -6.71, 6.71,
R_CUBIC_TO, -0.56, 5.09, -5.9, 8.18, -10.59, 6.11,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, -9.17, 2.46,
R_CUBIC_TO, -3.03, 4.13, -9.2, 4.13, -12.23, 0,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, -9.17, -2.46,
R_CUBIC_TO, -4.69, 2.07, -10.03, -1.02, -10.59, -6.11,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, -6.71, -6.71,
R_CUBIC_TO, -5.09, -0.56, -8.18, -5.9, -6.11, -10.59,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, -2.46, -9.17,
R_CUBIC_TO, -4.13, -3.03, -4.13, -9.2, 0, -12.23,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, 2.46, -9.17,
R_CUBIC_TO, -2.07, -4.69, 1.02, -10.03, 6.11, -10.59,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, 6.71, -6.71,
R_CUBIC_TO, 0.56, -5.09, 5.9, -8.18, 10.59, -6.11,
R_ARC_TO, 7.58, 7.58, 0, 0, 0, 9.17, -2.46,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x4C, 0x8D, 0xF6,
MOVE_TO, 173.04, 36.8,
R_ARC_TO, 1.12, 1.12, 0, 0, 1, -0.56, -0.14,
R_CUBIC_TO, -4.64, -2.39, -8.65, -3.41, -13.46, -3.41,
R_CUBIC_TO, -4.78, 0, -9.33, 1.14, -13.46, 3.41,
R_CUBIC_TO, -0.58, 0.31, -1.3, 0.1, -1.64, -0.48,
R_ARC_TO, 1.22, 1.22, 0, 0, 1, 0.48, -1.64,
R_CUBIC_TO, 4.5, -2.44, 9.43, -3.7, 14.62, -3.7,
R_CUBIC_TO, 5.15, 0, 9.64, 1.14, 14.57, 3.67,
R_CUBIC_TO, 0.6, 0.31, 0.82, 1.04, 0.51, 1.62,
R_ARC_TO, 1.19, 1.19, 0, 0, 1, -1.06, 0.68,
CLOSE,
R_MOVE_TO, -34.58, 12.69,
R_ARC_TO, 1.21, 1.21, 0, 0, 1, -0.99, -1.91,
R_CUBIC_TO, 2.39, -3.38, 5.44, -6.04, 9.06, -7.9,
R_CUBIC_TO, 7.59, -3.91, 17.3, -3.94, 24.92, -0.02,
R_CUBIC_TO, 3.63, 1.86, 6.67, 4.5, 9.06, 7.85,
R_ARC_TO, 1.21, 1.21, 0, 0, 1, -0.29, 1.69,
R_ARC_TO, 1.21, 1.21, 0, 0, 1, -1.69, -0.29,
R_CUBIC_TO, -2.17, -3.04, -4.93, -5.44, -8.19, -7.1,
R_CUBIC_TO, -6.94, -3.55, -15.8, -3.55, -22.72, 0.03,
R_CUBIC_TO, -3.29, 1.69, -6.04, 4.11, -8.22, 7.15,
R_CUBIC_TO, -0.19, 0.34, -0.56, 0.51, -0.94, 0.51,
CLOSE,
R_MOVE_TO, 14.26, 28.81,
R_CUBIC_TO, 0.22, 0.24, 0.53, 0.36, 0.85, 0.36,
R_CUBIC_TO, 0.32, 0, 0.63, -0.12, 0.9, -0.36,
R_ARC_TO, 1.24, 1.24, 0, 0, 0, 0, -1.72,
R_CUBIC_TO, -1.86, -1.88, -2.92, -3.07, -4.47, -5.85,
R_CUBIC_TO, -1.47, -2.61, -2.25, -5.82, -2.25, -9.3,
R_CUBIC_TO, 0, -5.85, 5.05, -10.61, 11.26, -10.61,
R_CUBIC_TO, 6.21, 0, 11.26, 4.76, 11.26, 10.61,
R_CUBIC_TO, 0, 0.68, 0.53, 1.21, 1.21, 1.21,
R_CUBIC_TO, 0.68, 0, 1.21, -0.53, 1.21, -1.21,
R_CUBIC_TO, 0, -7.18, -6.14, -13.03, -13.68, -13.03,
R_CUBIC_TO, -7.54, 0, -13.68, 5.85, -13.68, 13.03,
R_CUBIC_TO, 0, 3.89, 0.87, 7.52, 2.54, 10.49,
R_CUBIC_TO, 1.62, 2.92, 2.76, 4.28, 4.86, 6.38,
CLOSE,
R_MOVE_TO, 18.17, -4.11,
R_CUBIC_TO, -2.88, 0, -5.41, -0.72, -7.49, -2.15,
R_CUBIC_TO, -3.6, -2.44, -5.75, -6.4, -5.75, -10.61,
R_CUBIC_TO, 0, -0.68, 0.53, -1.21, 1.21, -1.21,
R_CUBIC_TO, 0.68, 0, 1.21, 0.53, 1.21, 1.21,
R_CUBIC_TO, 0, 3.41, 1.74, 6.62, 4.69, 8.6,
R_CUBIC_TO, 1.72, 1.16, 3.72, 1.72, 6.14, 1.72,
R_CUBIC_TO, 0.58, 0, 1.55, -0.07, 2.51, -0.24,
R_CUBIC_TO, 0.65, -0.12, 1.28, 0.31, 1.4, 0.99,
R_ARC_TO, 1.2, 1.2, 0, 0, 1, -0.99, 1.4,
R_CUBIC_TO, -1.38, 0.27, -2.58, 0.29, -2.92, 0.29,
CLOSE,
R_MOVE_TO, -5.17, 4.93,
R_CUBIC_TO, 0.1, 0.03, 0.22, 0.05, 0.31, 0.05,
R_ARC_TO, 1.18, 1.18, 0, 0, 0, 1.14, -0.92,
R_ARC_TO, 1.2, 1.2, 0, 0, 0, -0.85, -1.47,
R_CUBIC_TO, -3.41, -0.94, -5.61, -2.2, -7.9, -4.47,
R_CUBIC_TO, -2.92, -2.9, -4.52, -6.77, -4.52, -10.9,
R_CUBIC_TO, 0, -2.58, 2.25, -4.69, 5.03, -4.69,
R_CUBIC_TO, 2.78, 0, 5.03, 2.1, 5.03, 4.69,
R_CUBIC_TO, 0, 3.92, 3.34, 7.11, 7.44, 7.11,
R_CUBIC_TO, 4.1, 0, 7.44, -3.19, 7.44, -7.1,
R_CUBIC_TO, 0, -10.44, -8.94, -18.92, -19.94, -18.92,
R_CUBIC_TO, -7.81, 0, -14.93, 4.37, -18.15, 11.12,
R_CUBIC_TO, -1.09, 2.3, -1.64, 4.93, -1.64, 7.83,
R_CUBIC_TO, 0, 3.26, 0.58, 6.4, 1.76, 9.57,
R_ARC_TO, 1.2, 1.2, 0, 0, 0, 1.55, 0.7,
R_ARC_TO, 1.18, 1.18, 0, 0, 0, 0.7, -1.55,
R_CUBIC_TO, -1.45, -3.87, -1.62, -6.84, -1.62, -8.72,
R_CUBIC_TO, 0, -2.51, 0.48, -4.81, 1.43, -6.77,
R_CUBIC_TO, 2.83, -5.92, 9.11, -9.74, 15.97, -9.74,
R_CUBIC_TO, 9.67, 0, 17.52, 7.4, 17.52, 16.51,
R_CUBIC_TO, 0, 2.59, -2.25, 4.69, -5.03, 4.69,
R_CUBIC_TO, -2.78, 0, -5.03, -2.1, -5.03, -4.69,
R_CUBIC_TO, 0, -3.91, -3.33, -7.1, -7.44, -7.1,
R_CUBIC_TO, -4.11, 0, -7.44, 3.19, -7.44, 7.11,
R_CUBIC_TO, 0, 4.79, 1.86, 9.26, 5.24, 12.62,
R_CUBIC_TO, 2.63, 2.59, 5.15, 4.01, 8.99, 5.08,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
CIRCLE, 92, 17, 1,
CIRCLE, 96, 17, 1,
CIRCLE, 84, 17, 1,
CIRCLE, 88, 17, 1,
CIRCLE, 100, 17, 1,
CIRCLE, 107, 86, 1,
CIRCLE, 99, 86, 1,
CIRCLE, 103, 86, 1,
CIRCLE, 111, 86, 1,
CIRCLE, 229, 20, 1,
CIRCLE, 233, 20, 1,
CIRCLE, 221, 20, 1,
CIRCLE, 225, 20, 1,
CIRCLE, 115, 86, 1,
CIRCLE, 281, 37, 1,
CIRCLE, 285, 37, 1,
CIRCLE, 76, 21, 1,
CIRCLE, 80, 21, 1,
CIRCLE, 64, 21, 1,
CIRCLE, 84, 21, 1,
CIRCLE, 88, 21, 1,
CIRCLE, 273, 37, 1,
CIRCLE, 72, 21, 1,
CIRCLE, 277, 37, 1,
CIRCLE, 289, 37, 1,
CIRCLE, 293, 37, 1,
CIRCLE, 297, 37, 1,
CIRCLE, 91, 90, 1,
CIRCLE, 95, 90, 1,
CIRCLE, 99, 90, 1,
CIRCLE, 103, 90, 1,
CIRCLE, 107, 90, 1,
CIRCLE, 87, 90, 1,
CIRCLE, 265, 41, 1,
CIRCLE, 269, 41, 1,
CIRCLE, 273, 41, 1,
CIRCLE, 253, 90, 1,
CIRCLE, 257, 90, 1,
CIRCLE, 249, 86, 1,
CIRCLE, 253, 86, 1,
CIRCLE, 261, 90, 1,
CIRCLE, 39, 69, 1,
CIRCLE, 257, 86, 1,
CIRCLE, 43, 69, 1,
CIRCLE, 35, 65, 1,
CIRCLE, 233, 90, 1,
CIRCLE, 249, 90, 1,
CIRCLE, 237, 90, 1,
CIRCLE, 241, 90, 1,
CIRCLE, 245, 90, 1,
CIRCLE, 245, 86, 1,
CIRCLE, 39, 65, 1,
CIRCLE, 47, 69, 1,
CIRCLE, 43, 65, 1,
CIRCLE, 19, 69, 1,
CIRCLE, 35, 69, 1,
CIRCLE, 23, 69, 1,
CIRCLE, 27, 69, 1,
CIRCLE, 31, 69, 1,
CIRCLE, 31, 65, 1,
CIRCLE, 261, 41, 1,
CIRCLE, 277, 41, 1,
CIRCLE, 281, 41, 1,
CIRCLE, 70, 44, 3,
CIRCLE, 78, 44, 3,
CIRCLE, 86, 44, 3,
CIRCLE, 54, 44, 3,
CIRCLE, 220, 69, 3,
CIRCLE, 228, 69, 3,
CIRCLE, 236, 69, 3,
CIRCLE, 252, 69, 3)
VECTOR_ICON_TEMPLATE_CC(kPasskeyFingerprintDarkRepList, kPasskeyFingerprintDarkIcon, {kPasskeyFingerprintDarkPath})
VECTOR_ICON_REP_TEMPLATE(kPasskeyPhonePath, CANVAS_DIMENSIONS, 316,
PATH_COLOR_ARGB, 0xFF, 0xDA, 0xDC, 0xE0,
CIRCLE, 92, 16, 1,
CIRCLE, 96, 16, 1,
CIRCLE, 84, 16, 1,
CIRCLE, 88, 16, 1,
CIRCLE, 100, 16, 1,
CIRCLE, 107, 86, 1,
CIRCLE, 99, 86, 1,
CIRCLE, 103, 86, 1,
CIRCLE, 111, 86, 1,
CIRCLE, 229, 20, 1,
CIRCLE, 233, 20, 1,
CIRCLE, 221, 20, 1,
CIRCLE, 225, 20, 1,
CIRCLE, 115, 86, 1,
CIRCLE, 281, 37, 1,
CIRCLE, 285, 37, 1,
CIRCLE, 76, 20, 1,
CIRCLE, 80, 20, 1,
CIRCLE, 64, 20, 1,
CIRCLE, 84, 20, 1,
CIRCLE, 88, 20, 1,
CIRCLE, 273, 37, 1,
CIRCLE, 72, 20, 1,
CIRCLE, 277, 37, 1,
CIRCLE, 289, 37, 1,
CIRCLE, 293, 37, 1,
CIRCLE, 297, 37, 1,
CIRCLE, 91, 90, 1,
CIRCLE, 95, 90, 1,
CIRCLE, 99, 90, 1,
CIRCLE, 103, 90, 1,
CIRCLE, 107, 90, 1,
CIRCLE, 87, 90, 1,
CIRCLE, 265, 41, 1,
CIRCLE, 269, 41, 1,
CIRCLE, 273, 41, 1,
CIRCLE, 253, 90, 1,
CIRCLE, 257, 90, 1,
CIRCLE, 249, 86, 1,
CIRCLE, 253, 86, 1,
CIRCLE, 261, 90, 1,
CIRCLE, 39, 69, 1,
CIRCLE, 257, 86, 1,
CIRCLE, 43, 69, 1,
CIRCLE, 35, 65, 1,
CIRCLE, 233, 90, 1,
CIRCLE, 249, 90, 1,
CIRCLE, 237, 90, 1,
CIRCLE, 241, 90, 1,
CIRCLE, 245, 90, 1,
CIRCLE, 245, 86, 1,
CIRCLE, 39, 65, 1,
CIRCLE, 47, 69, 1,
CIRCLE, 43, 65, 1,
CIRCLE, 19, 69, 1,
CIRCLE, 35, 69, 1,
CIRCLE, 23, 69, 1,
CIRCLE, 27, 69, 1,
CIRCLE, 31, 69, 1,
CIRCLE, 31, 65, 1,
CIRCLE, 261, 41, 1,
CIRCLE, 277, 41, 1,
CIRCLE, 281, 41, 1,
CIRCLE, 70, 44, 3,
CIRCLE, 78, 44, 3,
CIRCLE, 86, 44, 3,
CIRCLE, 54, 44, 3,
CIRCLE, 220, 69, 3,
CIRCLE, 228, 69, 3,
CIRCLE, 236, 69, 3,
CIRCLE, 252, 69, 3,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xDA, 0xDC, 0xE0,
ROUND_RECT, 139, 14, 38, 82, 3,
NEW_PATH,
STROKE, 2,
PATH_COLOR_ARGB, 0xFF, 0x4C, 0x8D, 0xF6,
ROUND_RECT, 139, 14, 38, 82, 3,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x0B, 0x57, 0xD0,
MOVE_TO, 161.38, 59.62,
V_LINE_TO, 54.82,
R_LINE_TO, 0.01, -0.11,
R_ARC_TO, 3.27, 3.27, 0, 0, 0, -0.78, -2.41,
R_ARC_TO, 3.16, 3.16, 0, 0, 0, -1.61, -0.99,
R_ARC_TO, 3.09, 3.09, 0, 0, 0, -1.49, 0,
R_H_LINE_TO, 0,
R_ARC_TO, 3.14, 3.14, 0, 0, 0, -1.79, 1.22,
R_ARC_TO, 3.27, 3.27, 0, 0, 0, -0.6, 2.18,
R_LINE_TO, 0.01, 0.11,
R_V_LINE_TO, 4.8,
R_H_LINE_TO, 6.25,
CLOSE,
R_MOVE_TO, -7.81, -4.8,
R_ARC_TO, 4.98, 4.98, 0, 0, 1, 0.87, -3.18,
R_ARC_TO, 4.77, 4.77, 0, 0, 1, 2.65, -1.88,
R_V_LINE_TO, -0.55,
R_ARC_TO, 1.23, 1.23, 0, 0, 1, 0.34, -0.86,
R_ARC_TO, 1.17, 1.17, 0, 0, 1, 0.83, -0.36,
R_ARC_TO, 1.15, 1.15, 0, 0, 1, 0.83, 0.36,
R_ARC_TO, 1.22, 1.22, 0, 0, 1, 0.34, 0.86,
R_V_LINE_TO, 0.54,
R_ARC_TO, 4.76, 4.76, 0, 0, 1, 2.65, 1.88,
R_ARC_TO, 4.94, 4.94, 0, 0, 1, 0.87, 3.18,
R_V_LINE_TO, 4.8,
R_H_LINE_TO, 1.56,
R_V_LINE_TO, 1.6,
H_LINE_TO, 152,
R_V_LINE_TO, -1.6,
R_H_LINE_TO, 1.56,
R_V_LINE_TO, -4.8,
CLOSE,
R_MOVE_TO, 4.69, 8.81,
R_ARC_TO, 1.55, 1.55, 0, 0, 0, 1.1, -0.47,
R_CUBIC_TO, 0.29, -0.3, 0.46, -0.71, 0.46, -1.13,
R_H_LINE_TO, -3.12,
R_ARC_TO, 1.62, 1.62, 0, 0, 0, 0.53, 1.2,
R_CUBIC_TO, 0.28, 0.26, 0.65, 0.4, 1.03, 0.4,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xFF, 0xFF,
ROUND_RECT, 149, 92, 17.143, 2, 1,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x0B, 0x57, 0xD0,
STROKE, 2,
CIRCLE, 158, 56, 13,
CIRCLE, 158, 56, 27,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xFF, 0xFF,
CIRCLE, 144.055, 20, 2)
VECTOR_ICON_TEMPLATE_CC(kPasskeyPhoneRepList, kPasskeyPhoneIcon, {kPasskeyPhonePath})
VECTOR_ICON_REP_TEMPLATE(kPasskeyPhoneDarkPath, CANVAS_DIMENSIONS, 316,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
CIRCLE, 92, 16, 1,
CIRCLE, 96, 16, 1,
CIRCLE, 84, 16, 1,
CIRCLE, 88, 16, 1,
CIRCLE, 100, 16, 1,
CIRCLE, 107, 86, 1,
CIRCLE, 99, 86, 1,
CIRCLE, 103, 86, 1,
CIRCLE, 111, 86, 1,
CIRCLE, 229, 20, 1,
CIRCLE, 233, 20, 1,
CIRCLE, 221, 20, 1,
CIRCLE, 225, 20, 1,
CIRCLE, 115, 86, 1,
CIRCLE, 281, 37, 1,
CIRCLE, 285, 37, 1,
CIRCLE, 76, 20, 1,
CIRCLE, 80, 20, 1,
CIRCLE, 64, 20, 1,
CIRCLE, 84, 20, 1,
CIRCLE, 88, 20, 1,
CIRCLE, 273, 37, 1,
CIRCLE, 72, 20, 1,
CIRCLE, 277, 37, 1,
CIRCLE, 289, 37, 1,
CIRCLE, 293, 37, 1,
CIRCLE, 297, 37, 1,
CIRCLE, 91, 90, 1,
CIRCLE, 95, 90, 1,
CIRCLE, 99, 90, 1,
CIRCLE, 103, 90, 1,
CIRCLE, 107, 90, 1,
CIRCLE, 87, 90, 1,
CIRCLE, 265, 41, 1,
CIRCLE, 269, 41, 1,
CIRCLE, 273, 41, 1,
CIRCLE, 253, 90, 1,
CIRCLE, 257, 90, 1,
CIRCLE, 249, 86, 1,
CIRCLE, 253, 86, 1,
CIRCLE, 261, 90, 1,
CIRCLE, 39, 69, 1,
CIRCLE, 257, 86, 1,
CIRCLE, 43, 69, 1,
CIRCLE, 35, 65, 1,
CIRCLE, 233, 90, 1,
CIRCLE, 249, 90, 1,
CIRCLE, 237, 90, 1,
CIRCLE, 241, 90, 1,
CIRCLE, 245, 90, 1,
CIRCLE, 245, 86, 1,
CIRCLE, 39, 65, 1,
CIRCLE, 47, 69, 1,
CIRCLE, 43, 65, 1,
CIRCLE, 19, 69, 1,
CIRCLE, 35, 69, 1,
CIRCLE, 23, 69, 1,
CIRCLE, 27, 69, 1,
CIRCLE, 31, 69, 1,
CIRCLE, 31, 65, 1,
CIRCLE, 261, 41, 1,
CIRCLE, 277, 41, 1,
CIRCLE, 281, 41, 1,
CIRCLE, 70, 44, 3,
CIRCLE, 78, 44, 3,
CIRCLE, 86, 44, 3,
CIRCLE, 54, 44, 3,
CIRCLE, 220, 69, 3,
CIRCLE, 228, 69, 3,
CIRCLE, 236, 69, 3,
CIRCLE, 252, 69, 3,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x3C, 0x40, 0x43,
ROUND_RECT, 139, 14, 38, 82, 3,
NEW_PATH,
STROKE, 2,
PATH_COLOR_ARGB, 0xFF, 0x0B, 0x57, 0xD0,
ROUND_RECT, 139, 14, 38, 82, 3,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x4C, 0x8D, 0xF6,
MOVE_TO, 161.38, 59.62,
V_LINE_TO, 54.82,
R_LINE_TO, 0.01, -0.11,
R_ARC_TO, 3.27, 3.27, 0, 0, 0, -0.78, -2.41,
R_ARC_TO, 3.16, 3.16, 0, 0, 0, -1.61, -0.99,
R_ARC_TO, 3.09, 3.09, 0, 0, 0, -1.49, 0,
R_H_LINE_TO, 0,
R_ARC_TO, 3.14, 3.14, 0, 0, 0, -1.79, 1.22,
R_ARC_TO, 3.27, 3.27, 0, 0, 0, -0.6, 2.18,
R_LINE_TO, 0.01, 0.11,
R_V_LINE_TO, 4.8,
R_H_LINE_TO, 6.25,
CLOSE,
R_MOVE_TO, -7.81, -4.8,
R_ARC_TO, 4.98, 4.98, 0, 0, 1, 0.87, -3.18,
R_ARC_TO, 4.77, 4.77, 0, 0, 1, 2.65, -1.88,
R_V_LINE_TO, -0.55,
R_ARC_TO, 1.23, 1.23, 0, 0, 1, 0.34, -0.86,
R_ARC_TO, 1.17, 1.17, 0, 0, 1, 0.83, -0.36,
R_ARC_TO, 1.15, 1.15, 0, 0, 1, 0.83, 0.36,
R_ARC_TO, 1.22, 1.22, 0, 0, 1, 0.34, 0.86,
R_V_LINE_TO, 0.54,
R_ARC_TO, 4.76, 4.76, 0, 0, 1, 2.65, 1.88,
R_ARC_TO, 4.94, 4.94, 0, 0, 1, 0.87, 3.18,
R_V_LINE_TO, 4.8,
R_H_LINE_TO, 1.56,
R_V_LINE_TO, 1.6,
H_LINE_TO, 152,
R_V_LINE_TO, -1.6,
R_H_LINE_TO, 1.56,
R_V_LINE_TO, -4.8,
CLOSE,
R_MOVE_TO, 4.69, 8.81,
R_ARC_TO, 1.55, 1.55, 0, 0, 0, 1.1, -0.47,
R_CUBIC_TO, 0.29, -0.3, 0.46, -0.71, 0.46, -1.13,
R_H_LINE_TO, -3.12,
R_ARC_TO, 1.62, 1.62, 0, 0, 0, 0.53, 1.2,
R_CUBIC_TO, 0.28, 0.26, 0.65, 0.4, 1.03, 0.4,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
ROUND_RECT, 149, 92, 17.143, 2, 1,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x4C, 0x8D, 0xF6,
STROKE, 2,
CIRCLE, 158, 56, 13,
CIRCLE, 158, 56, 27,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
CIRCLE, 144.055, 20, 2)
VECTOR_ICON_TEMPLATE_CC(kPasskeyPhoneDarkRepList, kPasskeyPhoneDarkIcon, {kPasskeyPhoneDarkPath})
VECTOR_ICON_REP_TEMPLATE(kPasskeyUsbPath, CANVAS_DIMENSIONS, 316,
PATH_COLOR_ARGB, 0xFF, 0xDA, 0xDC, 0xE0,
MOVE_TO, 149, 74,
R_H_LINE_TO, 18,
R_V_LINE_TO, 16,
R_H_LINE_TO, -18,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x4C, 0x8D, 0xF6,
STROKE, 2,
MOVE_TO, 149, 74,
R_H_LINE_TO, 18,
R_V_LINE_TO, 16,
R_H_LINE_TO, -18,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xDA, 0xDC, 0xE0,
CIRCLE, 92, 17, 1,
CIRCLE, 96, 17, 1,
CIRCLE, 84, 17, 1,
CIRCLE, 88, 17, 1,
CIRCLE, 100, 17, 1,
CIRCLE, 107, 86, 1,
CIRCLE, 99, 86, 1,
CIRCLE, 103, 86, 1,
CIRCLE, 111, 86, 1,
CIRCLE, 229, 20, 1,
CIRCLE, 233, 20, 1,
CIRCLE, 221, 20, 1,
CIRCLE, 225, 20, 1,
CIRCLE, 115, 86, 1,
CIRCLE, 281, 37, 1,
CIRCLE, 285, 37, 1,
CIRCLE, 76, 21, 1,
CIRCLE, 80, 21, 1,
CIRCLE, 64, 21, 1,
CIRCLE, 84, 21, 1,
CIRCLE, 88, 21, 1,
CIRCLE, 273, 37, 1,
CIRCLE, 72, 21, 1,
CIRCLE, 277, 37, 1,
CIRCLE, 289, 37, 1,
CIRCLE, 293, 37, 1,
CIRCLE, 297, 37, 1,
CIRCLE, 91, 90, 1,
CIRCLE, 95, 90, 1,
CIRCLE, 99, 90, 1,
CIRCLE, 103, 90, 1,
CIRCLE, 107, 90, 1,
CIRCLE, 87, 90, 1,
CIRCLE, 265, 41, 1,
CIRCLE, 269, 41, 1,
CIRCLE, 273, 41, 1,
CIRCLE, 253, 90, 1,
CIRCLE, 257, 90, 1,
CIRCLE, 249, 86, 1,
CIRCLE, 253, 86, 1,
CIRCLE, 261, 90, 1,
CIRCLE, 39, 69, 1,
CIRCLE, 257, 86, 1,
CIRCLE, 43, 69, 1,
CIRCLE, 35, 65, 1,
CIRCLE, 233, 90, 1,
CIRCLE, 249, 90, 1,
CIRCLE, 237, 90, 1,
CIRCLE, 241, 90, 1,
CIRCLE, 245, 90, 1,
CIRCLE, 245, 86, 1,
CIRCLE, 39, 65, 1,
CIRCLE, 47, 69, 1,
CIRCLE, 43, 65, 1,
CIRCLE, 19, 69, 1,
CIRCLE, 35, 69, 1,
CIRCLE, 23, 69, 1,
CIRCLE, 27, 69, 1,
CIRCLE, 31, 69, 1,
CIRCLE, 31, 65, 1,
CIRCLE, 261, 41, 1,
CIRCLE, 277, 41, 1,
CIRCLE, 281, 41, 1,
CIRCLE, 70, 44, 3,
CIRCLE, 78, 44, 3,
CIRCLE, 86, 44, 3,
CIRCLE, 54, 44, 3,
CIRCLE, 220, 69, 3,
CIRCLE, 228, 69, 3,
CIRCLE, 236, 69, 3,
CIRCLE, 252, 69, 3,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x7C, 0xAC, 0xF8,
ROUND_RECT, 161, 75, 2, 10, 1,
ROUND_RECT, 157, 75, 2, 10, 1,
ROUND_RECT, 153, 75, 2, 10, 1,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x7C, 0xAC, 0xF8,
MOVE_TO, 150, 75,
R_H_LINE_TO, 16,
R_V_LINE_TO, 2,
R_H_LINE_TO, -16,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xDA, 0xDC, 0xE0,
MOVE_TO, 158, 20,
R_CUBIC_TO, 9.94, 0, 18, 8.06, 18, 18,
R_V_LINE_TO, 33,
R_ARC_TO, 4, 4, 0, 0, 1, -4, 4,
R_H_LINE_TO, -28,
R_ARC_TO, 4, 4, 0, 0, 1, -4, -4,
V_LINE_TO, 38,
R_CUBIC_TO, 0, -9.94, 8.06, -18, 18, -18,
CLOSE,
R_MOVE_TO, 0, 23,
R_ARC_TO, 5, 5, 0, 1, 0, 0, -10,
R_ARC_TO, 5, 5, 0, 0, 0, 0, 10,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x0B, 0x57, 0xD0,
STROKE, 2,
MOVE_TO, 158, 20,
R_CUBIC_TO, 9.94, 0, 18, 8.06, 18, 18,
R_V_LINE_TO, 33,
R_ARC_TO, 4, 4, 0, 0, 1, -4, 4,
R_H_LINE_TO, -28,
R_ARC_TO, 4, 4, 0, 0, 1, -4, -4,
V_LINE_TO, 38,
R_CUBIC_TO, 0, -9.94, 8.06, -18, 18, -18,
CLOSE,
R_MOVE_TO, 0, 23,
R_ARC_TO, 5, 5, 0, 1, 0, 0, -10,
R_ARC_TO, 5, 5, 0, 0, 0, 0, 10,
CLOSE,
NEW_PATH,
PATH_MODE_CLEAR,
CIRCLE, 158, 38, 6,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x4C, 0x8D, 0xF6,
STROKE, 2,
CIRCLE, 158, 38, 6)
VECTOR_ICON_TEMPLATE_CC(kPasskeyUsbRepList, kPasskeyUsbIcon, {kPasskeyUsbPath})
VECTOR_ICON_REP_TEMPLATE(kPasskeyUsbDarkPath, CANVAS_DIMENSIONS, 316,
PATH_COLOR_ARGB, 0xFF, 0x3C, 0x40, 0x43,
MOVE_TO, 149, 74,
R_H_LINE_TO, 18,
R_V_LINE_TO, 16,
R_H_LINE_TO, -18,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x1B, 0x6E, 0xF3,
STROKE, 2,
MOVE_TO, 149, 74,
R_H_LINE_TO, 18,
R_V_LINE_TO, 16,
R_H_LINE_TO, -18,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
CIRCLE, 92, 17, 1,
CIRCLE, 96, 17, 1,
CIRCLE, 84, 17, 1,
CIRCLE, 88, 17, 1,
CIRCLE, 100, 17, 1,
CIRCLE, 107, 86, 1,
CIRCLE, 99, 86, 1,
CIRCLE, 103, 86, 1,
CIRCLE, 111, 86, 1,
CIRCLE, 229, 20, 1,
CIRCLE, 233, 20, 1,
CIRCLE, 221, 20, 1,
CIRCLE, 225, 20, 1,
CIRCLE, 115, 86, 1,
CIRCLE, 281, 37, 1,
CIRCLE, 285, 37, 1,
CIRCLE, 76, 21, 1,
CIRCLE, 80, 21, 1,
CIRCLE, 64, 21, 1,
CIRCLE, 84, 21, 1,
CIRCLE, 88, 21, 1,
CIRCLE, 273, 37, 1,
CIRCLE, 72, 21, 1,
CIRCLE, 277, 37, 1,
CIRCLE, 289, 37, 1,
CIRCLE, 293, 37, 1,
CIRCLE, 297, 37, 1,
CIRCLE, 91, 90, 1,
CIRCLE, 95, 90, 1,
CIRCLE, 99, 90, 1,
CIRCLE, 103, 90, 1,
CIRCLE, 107, 90, 1,
CIRCLE, 87, 90, 1,
CIRCLE, 265, 41, 1,
CIRCLE, 269, 41, 1,
CIRCLE, 273, 41, 1,
CIRCLE, 253, 90, 1,
CIRCLE, 257, 90, 1,
CIRCLE, 249, 86, 1,
CIRCLE, 253, 86, 1,
CIRCLE, 261, 90, 1,
CIRCLE, 39, 69, 1,
CIRCLE, 257, 86, 1,
CIRCLE, 43, 69, 1,
CIRCLE, 35, 65, 1,
CIRCLE, 233, 90, 1,
CIRCLE, 249, 90, 1,
CIRCLE, 237, 90, 1,
CIRCLE, 241, 90, 1,
CIRCLE, 245, 90, 1,
CIRCLE, 245, 86, 1,
CIRCLE, 39, 65, 1,
CIRCLE, 47, 69, 1,
CIRCLE, 43, 65, 1,
CIRCLE, 19, 69, 1,
CIRCLE, 35, 69, 1,
CIRCLE, 23, 69, 1,
CIRCLE, 27, 69, 1,
CIRCLE, 31, 69, 1,
CIRCLE, 31, 65, 1,
CIRCLE, 261, 41, 1,
CIRCLE, 277, 41, 1,
CIRCLE, 281, 41, 1,
CIRCLE, 70, 44, 3,
CIRCLE, 78, 44, 3,
CIRCLE, 86, 44, 3,
CIRCLE, 54, 44, 3,
CIRCLE, 220, 69, 3,
CIRCLE, 228, 69, 3,
CIRCLE, 236, 69, 3,
CIRCLE, 252, 69, 3,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x0B, 0x57, 0xD0,
ROUND_RECT, 161, 75, 2, 10, 1,
ROUND_RECT, 157, 75, 2, 10, 1,
ROUND_RECT, 153, 75, 2, 10, 1,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x0B, 0x57, 0xD0,
MOVE_TO, 150, 75,
R_H_LINE_TO, 16,
R_V_LINE_TO, 2,
R_H_LINE_TO, -16,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x3C, 0x40, 0x43,
MOVE_TO, 158, 20,
R_CUBIC_TO, 9.94, 0, 18, 8.06, 18, 18,
R_V_LINE_TO, 33,
R_ARC_TO, 4, 4, 0, 0, 1, -4, 4,
R_H_LINE_TO, -28,
R_ARC_TO, 4, 4, 0, 0, 1, -4, -4,
V_LINE_TO, 38,
R_CUBIC_TO, 0, -9.94, 8.06, -18, 18, -18,
CLOSE,
R_MOVE_TO, 0, 23,
R_ARC_TO, 5, 5, 0, 1, 0, 0, -10,
R_ARC_TO, 5, 5, 0, 0, 0, 0, 10,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x4C, 0x8D, 0xF6,
STROKE, 2,
MOVE_TO, 158, 20,
R_CUBIC_TO, 9.94, 0, 18, 8.06, 18, 18,
R_V_LINE_TO, 33,
R_ARC_TO, 4, 4, 0, 0, 1, -4, 4,
R_H_LINE_TO, -28,
R_ARC_TO, 4, 4, 0, 0, 1, -4, -4,
V_LINE_TO, 38,
R_CUBIC_TO, 0, -9.94, 8.06, -18, 18, -18,
CLOSE,
R_MOVE_TO, 0, 23,
R_ARC_TO, 5, 5, 0, 1, 0, 0, -10,
R_ARC_TO, 5, 5, 0, 0, 0, 0, 10,
CLOSE,
NEW_PATH,
PATH_MODE_CLEAR,
CIRCLE, 158, 38, 6,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x0B, 0x57, 0xD0,
STROKE, 2,
CIRCLE, 158, 38, 6)
VECTOR_ICON_TEMPLATE_CC(kPasskeyUsbDarkRepList, kPasskeyUsbDarkIcon, {kPasskeyUsbDarkPath})
VECTOR_ICON_REP_TEMPLATE(kUsbSecurityKeyPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 9.5, 9.5,
R_ARC_TO, 2.5, 2.5, 0, 1, 1, 5, 0,
R_ARC_TO, 2.5, 2.5, 0, 0, 1, -5, 0,
CLOSE,
MOVE_TO, 16, 3,
R_V_LINE_TO, 12.5,
H_LINE_TO, 8,
LINE_TO, 8, 3,
H_LINE_TO, 16,
CLOSE,
MOVE_TO, 7.5, 17.5,
H_LINE_TO, 8,
R_V_LINE_TO, 4,
R_CUBIC_TO, 0, 0.83, 0.67, 1.5, 1.5, 1.5,
R_H_LINE_TO, 5,
R_CUBIC_TO, 0.83, 0, 1.5, -0.67, 1.5, -1.5,
R_V_LINE_TO, -4,
R_H_LINE_TO, 0.5,
R_CUBIC_TO, 0.83, 0, 1.5, -0.67, 1.5, -1.5,
V_LINE_TO, 3,
R_CUBIC_TO, 0, -1.1, -0.9, -2, -2, -2,
H_LINE_TO, 8,
R_CUBIC_TO, -1.1, 0, -2, 0.9, -2, 2,
R_V_LINE_TO, 13,
R_CUBIC_TO, 0, 0.83, 0.67, 1.5, 1.5, 1.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kUsbSecurityKeyRepList, kUsbSecurityKeyIcon, {kUsbSecurityKeyPath})
VECTOR_ICON_REP_TEMPLATE(kWebauthnErrorPath, CANVAS_DIMENSIONS, 448,
NEW_PATH,
PATH_COLOR_ARGB, 0x0A, 0x00, 0x00, 0x00,
MOVE_TO, 0, 0,
R_H_LINE_TO, 448,
R_V_LINE_TO, 119,
H_LINE_TO, 0,
CLOSE,
NEW_PATH,
STROKE, 1,
PATH_COLOR_ARGB, 0xFF, 0xE8, 0xE9, 0xEB,
MOVE_TO, 461.49, 67.44,
H_LINE_TO, 418,
R_CUBIC_TO, 0.36, -5.48, 4.94, -9.83, 10.51, -9.83,
R_CUBIC_TO, 1.18, 0, 2.36, 0.21, 3.51, 0.61,
R_LINE_TO, 0.47, 0.17,
R_LINE_TO, 0.31, -0.39,
ARC_TO, 16.09, 16.09, 0, 0, 1, 445.36, 52,
R_CUBIC_TO, 8.67, 0, 15.76, 6.87, 16.13, 15.44,
CLOSE,
R_MOVE_TO, -89, -34,
H_LINE_TO, 329,
R_CUBIC_TO, 0.36, -5.48, 4.94, -9.83, 10.51, -9.83,
R_CUBIC_TO, 1.18, 0, 2.36, 0.21, 3.51, 0.61,
R_LINE_TO, 0.47, 0.17,
R_LINE_TO, 0.31, -0.39,
ARC_TO, 16.09, 16.09, 0, 0, 1, 356.36, 18,
R_CUBIC_TO, 8.67, 0, 15.76, 6.87, 16.13, 15.44,
CLOSE,
R_MOVE_TO, -312, 39,
H_LINE_TO, 17,
R_CUBIC_TO, 0.36, -5.48, 4.94, -9.83, 10.51, -9.83,
R_CUBIC_TO, 1.18, 0, 2.36, 0.21, 3.51, 0.61,
R_LINE_TO, 0.47, 0.17,
R_LINE_TO, 0.31, -0.39,
ARC_TO, 16.09, 16.09, 0, 0, 1, 44.36, 57,
R_CUBIC_TO, 8.67, 0, 15.76, 6.87, 16.13, 15.44,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xFF, 0xFF,
MOVE_TO, 169.11, 40.08,
V_LINE_TO, 33.5,
R_ARC_TO, 4, 4, 0, 0, 1, 4, -4,
R_H_LINE_TO, 30.94,
R_ARC_TO, 4, 4, 0, 0, 1, 4, 4,
R_V_LINE_TO, 6.58,
H_LINE_TO, 288,
R_ARC_TO, 2, 2, 0, 0, 1, 2, 2,
V_LINE_TO, 131.5,
R_ARC_TO, 2, 2, 0, 0, 1, -2, 2,
H_LINE_TO, 163,
R_ARC_TO, 2, 2, 0, 0, 1, -2, -2,
V_LINE_TO, 42.08,
R_ARC_TO, 2, 2, 0, 0, 1, 2, -2,
R_H_LINE_TO, 6.11,
CLOSE,
NEW_PATH,
STROKE, 1,
PATH_COLOR_ARGB, 0xFF, 0xE8, 0xE9, 0xEB,
MOVE_TO, 169.11, 40.08,
V_LINE_TO, 33.5,
R_ARC_TO, 4, 4, 0, 0, 1, 4, -4,
R_H_LINE_TO, 30.94,
R_ARC_TO, 4, 4, 0, 0, 1, 4, 4,
R_V_LINE_TO, 6.58,
H_LINE_TO, 288,
R_ARC_TO, 2, 2, 0, 0, 1, 2, 2,
V_LINE_TO, 131.5,
R_ARC_TO, 2, 2, 0, 0, 1, -2, 2,
H_LINE_TO, 163,
R_ARC_TO, 2, 2, 0, 0, 1, -2, -2,
V_LINE_TO, 42.08,
R_ARC_TO, 2, 2, 0, 0, 1, 2, -2,
R_H_LINE_TO, 6.11,
CLOSE,
NEW_PATH,
STROKE, 1,
PATH_COLOR_ARGB, 0xFF, 0x97, 0x97, 0x97,
DISABLE_AA,
MOVE_TO, 208.88, 83.59,
R_LINE_TO, 0.70, -0.70,
R_LINE_TO, 3.54, 3.54,
R_LINE_TO, -0.70, 0.70,
CLOSE,
MOVE_TO, 212.41, 82.88,
R_LINE_TO, 0.70, 0.70,
R_LINE_TO, -3.53, 3.54,
R_LINE_TO, -0.70, -0.70,
CLOSE,
NEW_PATH,
STROKE, 1,
PATH_COLOR_ARGB, 0xFF, 0x97, 0x97, 0x97,
DISABLE_AA,
MOVE_TO, 229.5, 100.5,
R_V_LINE_TO, 1,
R_H_LINE_TO, -8,
R_V_LINE_TO, -1,
CLOSE,
R_MOVE_TO, -9, 2,
R_H_LINE_TO, -2,
R_V_LINE_TO, 1,
R_H_LINE_TO, 2,
R_V_LINE_TO, -1,
CLOSE,
R_MOVE_TO, 12, 0,
R_H_LINE_TO, -2,
R_V_LINE_TO, 1,
R_H_LINE_TO, 2,
R_V_LINE_TO, -1,
CLOSE,
NEW_PATH,
STROKE, 1,
PATH_COLOR_ARGB, 0xFF, 0x97, 0x97, 0x97,
DISABLE_AA,
MOVE_TO, 236.88, 83.59,
R_LINE_TO, 0.71, -0.70,
R_LINE_TO, 3.54, 3.54,
R_LINE_TO, -0.70, 0.71,
CLOSE,
MOVE_TO, 240.41, 82.88,
R_LINE_TO, 0.70, 0.70,
R_LINE_TO, -3.53, 3.54,
R_LINE_TO, -0.70, -0.70,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xF8, 0xF9, 0xFA,
ROUND_RECT, 170, 48, 111, 7, 3.5,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xBD, 0xC1, 0xC6,
CIRCLE, 147, 92.5, 31,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xff, 0xff, 0xff,
MOVE_TO, 148.48, 98.09,
R_H_LINE_TO, -2.91,
R_CUBIC_TO, -0.01, -1.57, 0.25, -3.23, 1.32, -4.45,
R_CUBIC_TO, 1.1, -1.47, 2.58, -2.62, 3.6, -4.15,
R_CUBIC_TO, 0.69, -1.43, 0.67, -3.35, -0.4, -4.59,
R_CUBIC_TO, -1.19, -1.23, -3.25, -1.17, -4.66, -0.36,
R_CUBIC_TO, -0.98, 0.44, -1.34, 1.63, -1.42, 2.54,
R_H_LINE_TO, -2.84,
R_CUBIC_TO, -0.04, -1.82, 0.89, -3.64, 2.48, -4.57,
R_CUBIC_TO, 2.03, -1.26, 4.67, -1.37, 6.89, -0.56,
R_CUBIC_TO, 2, 0.75, 3.27, 2.83, 3.31, 4.93,
R_CUBIC_TO, 0.16, 1.78, -0.51, 3.56, -1.69, 4.88,
R_CUBIC_TO, -0.78, 1.03, -1.75, 1.91, -2.64, 2.84,
R_CUBIC_TO, -0.78, 0.98, -1.04, 2.27, -1.03, 3.5,
CLOSE,
R_MOVE_TO, -3.03, 4.95,
R_CUBIC_TO, -0.09, -1.19, 1.21, -1.97, 2.28, -1.6,
R_CUBIC_TO, 1.43, 0.32, 1.54, 2.64, 0.17, 3.12,
R_CUBIC_TO, -1.01, 0.43, -2.4, -0.16, -2.44, -1.35,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xAC, 0xB0, 0xB5,
MOVE_TO, 161, 64.83,
CUBIC_TO, 171.09, 69.94, 178, 80.41, 178, 92.49,
R_CUBIC_TO, 0, 12.04, -6.87, 22.48, -16.9, 27.62,
R_ARC_TO, 2, 2, 0, 0, 1, -0.1, -0.62,
V_LINE_TO, 64.83,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kWebauthnErrorRepList, kWebauthnErrorIcon, {kWebauthnErrorPath})
VECTOR_ICON_REP_TEMPLATE(kWebauthnErrorDarkPath, CANVAS_DIMENSIONS, 448,
NEW_PATH,
PATH_COLOR_ARGB, 0x18, 0x00, 0x00, 0x00,
MOVE_TO, 0, 0,
R_H_LINE_TO, 448,
R_V_LINE_TO, 119,
H_LINE_TO, 0,
CLOSE,
NEW_PATH,
STROKE, 1,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
MOVE_TO, 461.49, 67.44,
H_LINE_TO, 418,
R_CUBIC_TO, 0.36, -5.48, 4.94, -9.83, 10.51, -9.83,
R_CUBIC_TO, 1.18, 0, 2.36, 0.21, 3.51, 0.61,
R_LINE_TO, 0.47, 0.17,
R_LINE_TO, 0.31, -0.39,
ARC_TO, 16.09, 16.09, 0, 0, 1, 445.36, 52,
R_CUBIC_TO, 8.67, 0, 15.76, 6.87, 16.13, 15.44,
CLOSE,
R_MOVE_TO, -89, -34,
H_LINE_TO, 329,
R_CUBIC_TO, 0.36, -5.48, 4.94, -9.83, 10.51, -9.83,
R_CUBIC_TO, 1.18, 0, 2.36, 0.21, 3.51, 0.61,
R_LINE_TO, 0.47, 0.17,
R_LINE_TO, 0.31, -0.39,
ARC_TO, 16.09, 16.09, 0, 0, 1, 356.36, 18,
R_CUBIC_TO, 8.67, 0, 15.76, 6.87, 16.13, 15.44,
CLOSE,
R_MOVE_TO, -312, 39,
H_LINE_TO, 17,
R_CUBIC_TO, 0.36, -5.48, 4.94, -9.83, 10.51, -9.83,
R_CUBIC_TO, 1.18, 0, 2.36, 0.21, 3.51, 0.61,
R_LINE_TO, 0.47, 0.17,
R_LINE_TO, 0.31, -0.39,
ARC_TO, 16.09, 16.09, 0, 0, 1, 44.36, 57,
R_CUBIC_TO, 8.67, 0, 15.76, 6.87, 16.13, 15.44,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xff, 0xff, 0xff,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x41, 0x44, 0x47,
MOVE_TO, 169.11, 40.08,
V_LINE_TO, 33.5,
R_ARC_TO, 4, 4, 0, 0, 1, 4, -4,
R_H_LINE_TO, 30.94,
R_ARC_TO, 4, 4, 0, 0, 1, 4, 4,
R_V_LINE_TO, 6.58,
H_LINE_TO, 288,
R_ARC_TO, 2, 2, 0, 0, 1, 2, 2,
V_LINE_TO, 131.5,
R_ARC_TO, 2, 2, 0, 0, 1, -2, 2,
H_LINE_TO, 163,
R_ARC_TO, 2, 2, 0, 0, 1, -2, -2,
V_LINE_TO, 42.08,
R_ARC_TO, 2, 2, 0, 0, 1, 2, -2,
R_H_LINE_TO, 6.11,
CLOSE,
NEW_PATH,
STROKE, 1,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
MOVE_TO, 169.11, 40.08,
V_LINE_TO, 33.5,
R_ARC_TO, 4, 4, 0, 0, 1, 4, -4,
R_H_LINE_TO, 30.94,
R_ARC_TO, 4, 4, 0, 0, 1, 4, 4,
R_V_LINE_TO, 6.58,
H_LINE_TO, 288,
R_ARC_TO, 2, 2, 0, 0, 1, 2, 2,
V_LINE_TO, 131.5,
R_ARC_TO, 2, 2, 0, 0, 1, -2, 2,
H_LINE_TO, 163,
R_ARC_TO, 2, 2, 0, 0, 1, -2, -2,
V_LINE_TO, 42.08,
R_ARC_TO, 2, 2, 0, 0, 1, 2, -2,
R_H_LINE_TO, 6.11,
CLOSE,
NEW_PATH,
STROKE, 1,
PATH_COLOR_ARGB, 0xFF, 0x97, 0x97, 0x97,
DISABLE_AA,
MOVE_TO, 208.88, 83.59,
R_LINE_TO, 0.70, -0.70,
R_LINE_TO, 3.54, 3.54,
R_LINE_TO, -0.70, 0.70,
CLOSE,
MOVE_TO, 212.41, 82.88,
R_LINE_TO, 0.70, 0.70,
R_LINE_TO, -3.53, 3.54,
R_LINE_TO, -0.70, -0.70,
CLOSE,
NEW_PATH,
STROKE, 1,
PATH_COLOR_ARGB, 0xFF, 0x97, 0x97, 0x97,
DISABLE_AA,
MOVE_TO, 229.5, 100.5,
R_V_LINE_TO, 1,
R_H_LINE_TO, -8,
R_V_LINE_TO, -1,
CLOSE,
R_MOVE_TO, -9, 2,
R_H_LINE_TO, -2,
R_V_LINE_TO, 1,
R_H_LINE_TO, 2,
R_V_LINE_TO, -1,
CLOSE,
R_MOVE_TO, 12, 0,
R_H_LINE_TO, -2,
R_V_LINE_TO, 1,
R_H_LINE_TO, 2,
R_V_LINE_TO, -1,
CLOSE,
NEW_PATH,
STROKE, 1,
PATH_COLOR_ARGB, 0xFF, 0x97, 0x97, 0x97,
DISABLE_AA,
MOVE_TO, 236.88, 83.59,
R_LINE_TO, 0.70, -0.70,
R_LINE_TO, 3.54, 3.54,
R_LINE_TO, -0.70, 0.70,
CLOSE,
MOVE_TO, 240.41, 82.88,
R_LINE_TO, 0.70, 0.70,
R_LINE_TO, -3.53, 3.54,
R_LINE_TO, -0.70, -0.70,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
ROUND_RECT, 170, 48, 111, 7, 3.5,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
CIRCLE, 147, 92.5, 31,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xff, 0xff, 0xff,
MOVE_TO, 148.48, 98.09,
R_H_LINE_TO, -2.91,
R_CUBIC_TO, -0.01, -1.57, 0.25, -3.23, 1.32, -4.45,
R_CUBIC_TO, 1.1, -1.47, 2.58, -2.62, 3.6, -4.15,
R_CUBIC_TO, 0.69, -1.43, 0.67, -3.35, -0.4, -4.59,
R_CUBIC_TO, -1.19, -1.23, -3.25, -1.17, -4.66, -0.36,
R_CUBIC_TO, -0.98, 0.44, -1.34, 1.63, -1.42, 2.54,
R_H_LINE_TO, -2.84,
R_CUBIC_TO, -0.04, -1.82, 0.89, -3.64, 2.48, -4.57,
R_CUBIC_TO, 2.03, -1.26, 4.67, -1.37, 6.89, -0.56,
R_CUBIC_TO, 2, 0.75, 3.27, 2.83, 3.31, 4.93,
R_CUBIC_TO, 0.16, 1.78, -0.51, 3.56, -1.69, 4.88,
R_CUBIC_TO, -0.78, 1.03, -1.75, 1.91, -2.64, 2.84,
R_CUBIC_TO, -0.78, 0.98, -1.04, 2.27, -1.03, 3.5,
CLOSE,
R_MOVE_TO, -3.03, 4.95,
R_CUBIC_TO, -0.09, -1.19, 1.21, -1.97, 2.28, -1.6,
R_CUBIC_TO, 1.43, 0.32, 1.54, 2.64, 0.17, 3.12,
R_CUBIC_TO, -1.01, 0.43, -2.4, -0.16, -2.44, -1.35,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x53, 0x57, 0x5C,
MOVE_TO, 161, 64.83,
CUBIC_TO, 171.09, 69.94, 178, 80.41, 178, 92.49,
R_CUBIC_TO, 0, 12.04, -6.87, 22.48, -16.9, 27.62,
R_ARC_TO, 2, 2, 0, 0, 1, -0.1, -0.62,
V_LINE_TO, 64.83,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kWebauthnErrorDarkRepList, kWebauthnErrorDarkIcon, {kWebauthnErrorDarkPath})
VECTOR_ICON_REP_TEMPLATE(kWindowsHelloColorPath, CANVAS_DIMENSIONS, 200,
PATH_COLOR_ARGB, 0xFF, 0x00, 0x89, 0xD0,
FILL_RULE_NONZERO,
MOVE_TO, 40.7f, 11.1f,
R_CUBIC_TO, -11.6f, 2.8f, -18.9f, 12.1f, -18.9f, 23.9f,
R_CUBIC_TO, 0, 6.6f, 1.8f, 11.3f, 6.1f, 16.2f,
R_CUBIC_TO, 11, 12.5f, 32.7f, 9.5f, 40, -5.5f,
R_CUBIC_TO, 2.7f, -5.6f, 2.8f, -15.6f, 0.2f, -21.2f,
R_CUBIC_TO, -4.6f, -10, -16.8f, -16, -27.4f, -13.4f,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x00, 0x89, 0xD0,
FILL_RULE_NONZERO,
MOVE_TO, 148.7f, 11,
R_CUBIC_TO, -7.9f, 2, -14.1f, 7.3f, -17.2f, 14.7f,
R_CUBIC_TO, -3.2f, 7.7f, -1, 19.9f, 4.8f, 26.2f,
R_CUBIC_TO, 5.7f, 6.2f, 19.2f, 9, 27.1f, 5.7f,
R_CUBIC_TO, 15.9f, -6.6f, 20, -27.8f, 8, -40,
R_CUBIC_TO, -5.5f, -5.6f, -15.3f, -8.4f, -22.7f, -6.6f,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x00, 0x89, 0xD0,
FILL_RULE_NONZERO,
MOVE_TO, 6.2f, 108,
R_CUBIC_TO, -4, 2.4f, -6.6f, 8, -5.7f, 12.2f,
R_CUBIC_TO, 2.1f, 9.3f, 23.1f, 31.9f, 38.8f, 41.6f,
R_CUBIC_TO, 38.5f, 23.9f, 82.9f, 23.9f, 121.4f, 0,
R_CUBIC_TO, 15.7f, -9.7f, 36.7f, -32.3f, 38.8f, -41.6f,
R_CUBIC_TO, 1.4f, -6.7f, -5.1f, -14.2f, -12.3f, -14.2f,
R_CUBIC_TO, -5, 0, -8.5f, 2.3f, -14.2f, 9.4f,
R_CUBIC_TO, -40.7f, 51.2f, -105.3f, 51.2f, -146, 0,
R_CUBIC_TO, -2.9f, -3.5f, -6.5f, -7.1f, -8.1f, -7.9f,
R_CUBIC_TO, -3.9f, -2.1f, -8.8f, -1.9f, -12.7f, 0.5f,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kWindowsHelloColorRepList, kWindowsHelloColorIcon, {kWindowsHelloColorPath})
VECTOR_ICON_REP_TEMPLATE(kWebidArrowPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 7, 16,
LINE_TO, 3, 12,
LINE_TO, 7, 8,
LINE_TO, 8.43, 9.4,
LINE_TO, 6.82, 11,
LINE_TO, 17.18, 11,
LINE_TO, 15.6, 9.4,
LINE_TO, 17, 8,
LINE_TO, 21, 12,
LINE_TO, 17, 16,
LINE_TO, 15.6, 14.6,
LINE_TO, 17.18, 13,
LINE_TO, 6.82, 13,
LINE_TO, 8.4, 14.6,
CLOSE,
MOVE_TO, 7, 16,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kWebidArrowRepList, kWebidArrowIcon, {kWebidArrowPath})
VECTOR_ICON_REP_TEMPLATE(kWebidGlobePath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
MOVE_TO, 12, 22,
CUBIC_TO, 10.62, 22, 9.32, 21.74, 8.1, 21.21,
CUBIC_TO, 6.88, 20.69, 5.82, 19.98, 4.93, 19.07,
CUBIC_TO, 4.02, 18.18, 3.31, 17.12, 2.79, 15.9,
CUBIC_TO, 2.26, 14.68, 2, 13.38, 2, 12,
CUBIC_TO, 2, 10.62, 2.26, 9.32, 2.79, 8.1,
CUBIC_TO, 3.31, 6.88, 4.02, 5.82, 4.93, 4.93,
CUBIC_TO, 5.82, 4.02, 6.88, 3.31, 8.1, 2.79,
CUBIC_TO, 9.32, 2.26, 10.62, 2, 12, 2,
CUBIC_TO, 13.38, 2, 14.68, 2.26, 15.9, 2.79,
CUBIC_TO, 17.12, 3.31, 18.18, 4.02, 19.07, 4.93,
CUBIC_TO, 19.98, 5.82, 20.69, 6.88, 21.21, 8.1,
CUBIC_TO, 21.74, 9.32, 22, 10.62, 22, 12,
CUBIC_TO, 22, 13.38, 21.74, 14.68, 21.21, 15.9,
CUBIC_TO, 20.69, 17.12, 19.98, 18.18, 19.07, 19.07,
CUBIC_TO, 18.18, 19.98, 17.12, 20.69, 15.9, 21.21,
CUBIC_TO, 14.68, 21.74, 13.38, 22, 12, 22,
CLOSE,
MOVE_TO, 12, 20,
CUBIC_TO, 14.23, 20, 16.13, 19.23, 17.68, 17.68,
CUBIC_TO, 19.23, 16.13, 20, 14.23, 20, 12,
CUBIC_TO, 20, 11.88, 20, 11.76, 19.99, 11.64,
CUBIC_TO, 19.98, 11.51, 19.98, 11.41, 19.98, 11.32,
CUBIC_TO, 19.89, 11.81, 19.67, 12.21, 19.3, 12.52,
CUBIC_TO, 18.93, 12.84, 18.5, 13, 18, 13,
LINE_TO, 16, 13,
CUBIC_TO, 15.45, 13, 14.98, 12.8, 14.59, 12.41,
CUBIC_TO, 14.2, 12.02, 14, 11.55, 14, 11,
LINE_TO, 14, 10,
LINE_TO, 10, 10,
LINE_TO, 10, 8,
CUBIC_TO, 10, 7.45, 10.2, 6.98, 10.59, 6.59,
CUBIC_TO, 10.98, 6.2, 11.45, 6, 12, 6,
LINE_TO, 13, 6,
CUBIC_TO, 13, 5.62, 13.11, 5.28, 13.31, 4.99,
CUBIC_TO, 13.52, 4.7, 13.77, 4.46, 14.07, 4.27,
CUBIC_TO, 13.74, 4.19, 13.4, 4.13, 13.06, 4.07,
CUBIC_TO, 12.72, 4.02, 12.37, 4, 12, 4,
CUBIC_TO, 9.77, 4, 7.88, 4.77, 6.32, 6.32,
CUBIC_TO, 4.77, 7.88, 4, 9.77, 4, 12,
LINE_TO, 9, 12,
CUBIC_TO, 10.1, 12, 11.04, 12.39, 11.82, 13.18,
CUBIC_TO, 12.61, 13.96, 13, 14.9, 13, 16,
LINE_TO, 13, 17,
LINE_TO, 10, 17,
LINE_TO, 10, 19.75,
CUBIC_TO, 10.33, 19.83, 10.66, 19.89, 10.99, 19.94,
CUBIC_TO, 11.31, 19.98, 11.65, 20, 12, 20,
CLOSE,
MOVE_TO, 12, 20,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kWebidGlobeRepList, kWebidGlobeIcon, {kWebidGlobePath})
VECTOR_ICON_REP_TEMPLATE(kZoomInPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 12.74, 13.75,
LINE_TO, 8.73, 9.72,
R_ARC_TO, 4.03, 4.03, 0, 0, 1, -1.09, 0.57,
R_CUBIC_TO, -0.4, 0.13, -0.82, 0.2, -1.27, 0.2,
R_CUBIC_TO, -1.13, 0, -2.1, -0.4, -2.89, -1.2,
R_CUBIC_TO, -0.8, -0.8, -1.2, -1.76, -1.2, -2.9,
R_CUBIC_TO, 0, -1.13, 0.4, -2.1, 1.2, -2.89,
R_CUBIC_TO, 0.79, -0.8, 1.76, -1.19, 2.89, -1.19,
R_CUBIC_TO, 1.14, 0, 2.1, 0.4, 2.9, 1.2,
R_CUBIC_TO, 0.8, 0.8, 1.2, 1.76, 1.2, 2.9,
R_CUBIC_TO, 0, 0.45, -0.07, 0.88, -0.2, 1.27,
R_ARC_TO, 4.1, 4.1, 0, 0, 1, -0.55, 1.08,
R_LINE_TO, 4.02, 4.02,
CLOSE,
MOVE_TO, 6.37, 9.11,
R_ARC_TO, 2.63, 2.63, 0, 0, 0, 1.92, -0.79,
R_ARC_TO, 2.63, 2.63, 0, 0, 0, 0.79, -1.92,
R_CUBIC_TO, 0, -0.75, -0.27, -1.39, -0.79, -1.92,
R_ARC_TO, 2.62, 2.62, 0, 0, 0, -1.92, -0.79,
R_CUBIC_TO, -0.75, 0, -1.39, 0.26, -1.92, 0.79,
R_ARC_TO, 2.61, 2.61, 0, 0, 0, -0.79, 1.92,
R_CUBIC_TO, 0, 0.75, 0.26, 1.4, 0.79, 1.92,
R_CUBIC_TO, 0.52, 0.52, 1.16, 0.79, 1.92, 0.79,
CLOSE,
R_MOVE_TO, -0.6, -0.93,
V_LINE_TO, 7,
H_LINE_TO, 4.59,
V_LINE_TO, 5.8,
H_LINE_TO, 5.77,
V_LINE_TO, 4.63,
R_H_LINE_TO, 1.2,
R_V_LINE_TO, 1.18,
R_H_LINE_TO, 1.18,
V_LINE_TO, 7,
H_LINE_TO, 6.97,
R_V_LINE_TO, 1.18,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kZoomInRepList, kZoomInIcon, {kZoomInPath})
VECTOR_ICON_REP_TEMPLATE(kZoomMinusPath, MOVE_TO, 32.15, 30.43,
CUBIC_TO, 34.57, 27.62, 36.02, 23.98, 36.02, 20.01,
CUBIC_TO, 36.02, 11.17, 28.85, 4, 20.01, 4,
CUBIC_TO, 11.17, 4, 4, 11.17, 4, 20.01,
CUBIC_TO, 4, 28.85, 11.17, 36.02, 20.01, 36.02,
CUBIC_TO, 23.98, 36.02, 27.62, 34.57, 30.43, 32.15,
LINE_TO, 31.09, 32.84,
LINE_TO, 31.09, 34.79,
LINE_TO, 40.33, 44,
LINE_TO, 44, 40.33,
LINE_TO, 34.79, 31.09,
LINE_TO, 32.84, 31.09,
LINE_TO, 32.15, 30.43,
CLOSE,
MOVE_TO, 20, 32,
CUBIC_TO, 13.36, 32, 8, 26.64, 8, 20,
CUBIC_TO, 8, 13.36, 13.36, 8, 20, 8,
CUBIC_TO, 26.64, 8, 32, 13.36, 32, 20,
CUBIC_TO, 32, 26.64, 26.64, 32, 20, 32,
LINE_TO, 20, 32,
CLOSE,
MOVE_TO, 13, 21.4,
LINE_TO, 13, 18.6,
LINE_TO, 27, 18.6,
LINE_TO, 27, 21.4,
LINE_TO, 13, 21.4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kZoomMinusRepList, kZoomMinusIcon, {kZoomMinusPath})
VECTOR_ICON_REP_TEMPLATE(kZoomMinusChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 15.94, 17,
R_LINE_TO, -4.98, -5,
R_CUBIC_TO, -0.41, 0.32, -0.87, 0.57, -1.37, 0.74,
ARC_TO, 4.71, 4.71, 0, 0, 1, 8, 13,
R_CUBIC_TO, -1.39, 0, -2.57, -0.48, -3.54, -1.46,
CUBIC_TO, 3.48, 10.57, 3, 9.39, 3, 8,
R_CUBIC_TO, 0, -1.39, 0.48, -2.57, 1.46, -3.54,
CUBIC_TO, 5.43, 3.48, 6.61, 3, 8, 3,
R_CUBIC_TO, 1.39, 0, 2.57, 0.48, 3.54, 1.46,
CUBIC_TO, 12.52, 5.43, 13, 6.61, 13, 8,
R_CUBIC_TO, 0, 0.56, -0.09, 1.09, -0.26, 1.59,
R_CUBIC_TO, -0.17, 0.5, -0.41, 0.96, -0.72, 1.37,
R_LINE_TO, 4.98, 4.98,
CLOSE,
MOVE_TO, 8, 11.5,
R_CUBIC_TO, 0.97, 0, 1.8, -0.34, 2.48, -1.02,
R_CUBIC_TO, 0.68, -0.68, 1.02, -1.51, 1.02, -2.48,
R_CUBIC_TO, 0, -0.97, -0.34, -1.8, -1.02, -2.48,
CUBIC_TO, 9.8, 4.84, 8.97, 4.5, 8, 4.5,
R_CUBIC_TO, -0.97, 0, -1.8, 0.34, -2.48, 1.02,
CUBIC_TO, 4.84, 6.2, 4.5, 7.03, 4.5, 8,
R_CUBIC_TO, 0, 0.97, 0.34, 1.8, 1.02, 2.48,
R_CUBIC_TO, 0.68, 0.68, 1.51, 1.02, 2.48, 1.02,
CLOSE,
MOVE_TO, 6, 8.75,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 4,
R_V_LINE_TO, 1.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kZoomMinusChromeRefreshRepList, kZoomMinusChromeRefreshIcon, {kZoomMinusChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kZoomMinusMenuRefreshPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 3.91, 8.69,
V_LINE_TO, 7.31,
R_H_LINE_TO, 8.18,
R_V_LINE_TO, 1.38,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kZoomMinusMenuRefreshRepList, kZoomMinusMenuRefreshIcon, {kZoomMinusMenuRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kZoomPlusChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 15.94, 17,
R_LINE_TO, -4.98, -5,
R_CUBIC_TO, -0.41, 0.32, -0.87, 0.57, -1.37, 0.74,
ARC_TO, 4.71, 4.71, 0, 0, 1, 8, 13,
R_CUBIC_TO, -1.39, 0, -2.57, -0.48, -3.54, -1.46,
CUBIC_TO, 3.48, 10.57, 3, 9.39, 3, 8,
R_CUBIC_TO, 0, -1.39, 0.48, -2.57, 1.46, -3.54,
CUBIC_TO, 5.43, 3.48, 6.61, 3, 8, 3,
R_CUBIC_TO, 1.39, 0, 2.57, 0.48, 3.54, 1.46,
CUBIC_TO, 12.52, 5.43, 13, 6.61, 13, 8,
R_CUBIC_TO, 0, 0.56, -0.09, 1.09, -0.26, 1.59,
R_CUBIC_TO, -0.17, 0.5, -0.41, 0.96, -0.72, 1.37,
R_LINE_TO, 4.98, 4.98,
CLOSE,
MOVE_TO, 8, 11.5,
R_CUBIC_TO, 0.97, 0, 1.8, -0.34, 2.48, -1.02,
R_CUBIC_TO, 0.68, -0.68, 1.02, -1.51, 1.02, -2.48,
R_CUBIC_TO, 0, -0.97, -0.34, -1.8, -1.02, -2.48,
CUBIC_TO, 9.8, 4.84, 8.97, 4.5, 8, 4.5,
R_CUBIC_TO, -0.97, 0, -1.8, 0.34, -2.48, 1.02,
CUBIC_TO, 4.84, 6.2, 4.5, 7.03, 4.5, 8,
R_CUBIC_TO, 0, 0.97, 0.34, 1.8, 1.02, 2.48,
R_CUBIC_TO, 0.68, 0.68, 1.51, 1.02, 2.48, 1.02,
CLOSE,
R_MOVE_TO, -0.75, -1.25,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, -1.5,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, -1.5,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, -1.5,
R_V_LINE_TO, 1.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kZoomPlusChromeRefreshRepList, kZoomPlusChromeRefreshIcon, {kZoomPlusChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kZoomPlusMenuRefreshPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 7.31, 12.09,
R_V_LINE_TO, -3.4,
H_LINE_TO, 3.91,
V_LINE_TO, 7.31,
R_H_LINE_TO, 3.4,
R_V_LINE_TO, -3.4,
R_H_LINE_TO, 1.38,
R_V_LINE_TO, 3.4,
R_H_LINE_TO, 3.4,
R_V_LINE_TO, 1.38,
H_LINE_TO, 8.69,
R_V_LINE_TO, 3.4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kZoomPlusMenuRefreshRepList, kZoomPlusMenuRefreshIcon, {kZoomPlusMenuRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kNewTabMacTouchbarPath, CANVAS_DIMENSIONS, 60,
MOVE_TO, 30, 0,
CUBIC_TO, 13.44, 0, 0, 13.44, 0, 30,
R_CUBIC_TO, 0, 16.56, 13.44, 30, 30, 30,
R_CUBIC_TO, 16.56, 0, 30, -13.44, 30, -30,
CUBIC_TO, 60, 13.44, 46.56, 0, 30, 0,
CLOSE,
R_MOVE_TO, 15, 33,
H_LINE_TO, 33,
R_V_LINE_TO, 12,
R_H_LINE_TO, -6,
V_LINE_TO, 33,
H_LINE_TO, 15,
R_V_LINE_TO, -6,
R_H_LINE_TO, 12,
V_LINE_TO, 15,
R_H_LINE_TO, 6,
R_V_LINE_TO, 12,
R_H_LINE_TO, 12,
R_V_LINE_TO, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNewTabMacTouchbarRepList, kNewTabMacTouchbarIcon, {kNewTabMacTouchbarPath})
VECTOR_ICON_REP_TEMPLATE(kSecurePaymentConfirmationFingerprintPath, CANVAS_DIMENSIONS, 448,
PATH_COLOR_ARGB, 0xFF, 0xD2, 0xE3, 0xFC,
CIRCLE, 223.99, 74.37, 45.68,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x42, 0x85, 0xF4,
R_MOVE_TO, 239.83, 53.86,
R_CUBIC_TO, -0.22, 0, -0.43, -0.05, -0.63, -0.16,
R_CUBIC_TO, -5.23, -2.7, -9.75, -3.84, -15.17, -3.84,
R_CUBIC_TO, -5.4, 0, -10.51, 1.28, -15.17, 3.84,
R_CUBIC_TO, -0.65, 0.35, -1.47, 0.11, -1.85, -0.55,
R_CUBIC_TO, -0.35, -0.65, -0.11, -1.5, 0.55, -1.85,
R_CUBIC_TO, 5.07, -2.75, 10.62, -4.17, 16.48, -4.17,
R_CUBIC_TO, 5.8, 0, 10.87, 1.28, 16.42, 4.14,
R_CUBIC_TO, 0.68, 0.35, 0.93, 1.17, 0.57, 1.82,
R_CUBIC_TO, -0.24, 0.5, -0.7, 0.77, -1.2, 0.77,
CLOSE,
R_MOVE_TO, -38.97, 14.3,
R_CUBIC_TO, -0.27, 0, -0.55, -0.08, -0.79, -0.25,
R_CUBIC_TO, -0.63, -0.43, -0.76, -1.28, -0.33, -1.9,
R_CUBIC_TO, 2.7, -3.81, 6.13, -6.81, 10.21, -8.9,
R_CUBIC_TO, 8.55, -4.41, 19.5, -4.44, 28.08, -0.03,
R_CUBIC_TO, 4.08, 2.1, 7.52, 5.07, 10.21, 8.85,
R_CUBIC_TO, 0.43, 0.6, 0.3, 1.47, -0.33, 1.9,
R_CUBIC_TO, -0.63, 0.43, -1.47, 0.3, -1.9, -0.33,
R_CUBIC_TO, -2.45, -3.43, -5.55, -6.13, -9.23, -8,
R_CUBIC_TO, -7.82, -4, -17.81, -4, -25.6, 0.03,
R_CUBIC_TO, -3.7, 1.9, -6.81, 4.63, -9.26, 8.06,
R_CUBIC_TO, -0.22, 0.38, -0.63, 0.57, -1.06, 0.57,
CLOSE,
R_MOVE_TO, 17.02, 32.87,
R_CUBIC_TO, -0.35, 0, -0.7, -0.13, -0.95, -0.41,
R_CUBIC_TO, -2.37, -2.37, -3.65, -3.9, -5.47, -7.19,
R_CUBIC_TO, -1.88, -3.35, -2.86, -7.43, -2.86, -11.82,
R_CUBIC_TO, 0, -8.09, 6.92, -14.68, 15.41, -14.68,
R_CUBIC_TO, 8.5, 0, 15.41, 6.59, 15.41, 14.68,
R_CUBIC_TO, 0, 0.76, -0.6, 1.36, -1.36, 1.36,
R_CUBIC_TO, -0.76, 0, -1.36, -0.6, -1.36, -1.36,
R_CUBIC_TO, 0, -6.59, -5.7, -11.95, -12.69, -11.95,
R_CUBIC_TO, -7, 0, -12.69, 5.37, -12.69, 11.95,
R_CUBIC_TO, 0, 3.92, 0.87, 7.55, 2.53, 10.48,
R_CUBIC_TO, 1.75, 3.13, 2.95, 4.47, 5.04, 6.59,
R_CUBIC_TO, 0.52, 0.55, 0.52, 1.39, 0, 1.93,
R_CUBIC_TO, -0.28, 0.27, -0.64, 0.4, -1, 0.4,
CLOSE,
R_MOVE_TO, 19.53, -5.04,
R_CUBIC_TO, -3.24, 0, -6.1, -0.82, -8.45, -2.42,
R_CUBIC_TO, -4.06, -2.75, -6.48, -7.22, -6.48, -11.95,
R_CUBIC_TO, 0, -0.76, 0.6, -1.36, 1.36, -1.36,
R_CUBIC_TO, 0.76, 0, 1.36, 0.6, 1.36, 1.36,
R_CUBIC_TO, 0, 3.84, 1.96, 7.46, 5.28, 9.7,
R_CUBIC_TO, 1.93, 1.3, 4.2, 1.93, 6.92, 1.93,
R_CUBIC_TO, 0.65, 0, 1.75, -0.08, 2.83, -0.27,
R_CUBIC_TO, 0.73, -0.13, 1.45, 0.35, 1.58, 1.12,
R_CUBIC_TO, 0.13, 0.73, -0.35, 1.45, -1.12, 1.58,
R_CUBIC_TO, -1.56, 0.28, -2.92, 0.31, -3.3, 0.31,
CLOSE,
R_MOVE_TO, -5.48, 5.61,
R_CUBIC_TO, -0.11, 0, -0.25, -0.03, -0.35, -0.05,
R_CUBIC_TO, -4.33, -1.2, -7.16, -2.8, -10.13, -5.72,
R_CUBIC_TO, -3.81, -3.78, -5.91, -8.83, -5.91, -14.22,
R_CUBIC_TO, 0, -4.41, 3.76, -8, 8.39, -8,
R_CUBIC_TO, 4.63, 0, 8.39, 3.6, 8.39, 8,
R_CUBIC_TO, 0, 2.92, 2.53, 5.28, 5.67, 5.28,
R_CUBIC_TO, 3.13, 0, 5.67, -2.37, 5.67, -5.28,
R_CUBIC_TO, 0, -10.27, -8.85, -18.6, -19.75, -18.6,
R_CUBIC_TO, -7.73, 0, -14.81, 4.3, -18, 10.98,
R_CUBIC_TO, -1.06, 2.2, -1.6, 4.8, -1.6, 7.63,
R_CUBIC_TO, 0, 2.12, 0.19, 5.47, 1.82, 9.83,
R_CUBIC_TO, 0.27, 0.7, -0.08, 1.5, -0.79, 1.75,
R_CUBIC_TO, -0.7, 0.27, -1.5, -0.11, -1.75, -0.79,
R_CUBIC_TO, -1.33, -3.57, -1.99, -7.11, -1.99, -10.78,
R_CUBIC_TO, 0, -3.27, 0.63, -6.23, 1.85, -8.83,
R_CUBIC_TO, 3.62, -7.6, 11.65, -12.53, 20.45, -12.53,
R_CUBIC_TO, 12.39, 0, 22.47, 9.56, 22.47, 21.33,
R_CUBIC_TO, 0, 4.41, -3.76, 8, -8.39, 8,
R_CUBIC_TO, -4.63, 0, -8.39, -3.6, -8.39, -8,
R_CUBIC_TO, 0, -2.92, -2.53, -5.28, -5.67, -5.28,
R_CUBIC_TO, -3.13, 0, -5.67, 2.37, -5.67, 5.28,
R_CUBIC_TO, 0, 4.65, 1.8, 9.01, 5.1, 12.28,
R_CUBIC_TO, 2.59, 2.56, 5.07, 3.98, 8.9, 5.04,
R_CUBIC_TO, 0.73, 0.19, 1.15, 0.95, 0.95, 1.66,
R_CUBIC_TO, -0.13, 0.61, -0.7, 1.02, -1.27, 1.02,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFB, 0xBC, 0x04,
R_MOVE_TO, 175.26, 137.79,
R_CUBIC_TO, -2.21, 1.85, -5.51, 1.55, -7.35, -0.66,
R_CUBIC_TO, -1.85, -2.21, -1.55, -5.51, 0.66, -7.35,
R_LINE_TO, 8.01, -6.69,
R_CUBIC_TO, 2.21, -1.85, 5.51, -1.55, 7.35, 0.66,
R_CUBIC_TO, 1.85, 2.21, 1.55, 5.51, -0.66, 7.35,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x34, 0xA8, 0x53,
R_MOVE_TO, 277.97, 24,
R_CUBIC_TO, -1.2, 0.21, -1.72, 1.63, -0.94, 2.57,
R_LINE_TO, 9.35, 11.2,
R_CUBIC_TO, 0.78, 0.93, 2.28, 0.67, 2.69, -0.47,
R_LINE_TO, 5.02, -13.69,
R_CUBIC_TO, 0.42, -1.15, -0.55, -2.32, -1.75, -2.11,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x42, 0x85, 0xF4,
R_MOVE_TO, 152, 26.5,
R_CUBIC_TO, -0.26, -0.54, -0.04, -1.19, 0.49, -1.45,
R_LINE_TO, 7.81, -3.84,
R_CUBIC_TO, 0.54, -0.26, 1.19, -0.04, 1.45, 0.49,
R_LINE_TO, 3.84, 7.81,
R_CUBIC_TO, 0.26, 0.54, 0.05, 1.19, -0.49, 1.45,
R_LINE_TO, -7.81, 3.84,
R_CUBIC_TO, -0.54, 0.27, -1.19, 0.05, -1.45, -0.49,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x34, 0xA8, 0x53,
STROKE, 1.49,
MOVE_TO, 133.45, 105.41,
LINE_TO, 142.93, 102.24,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xEA, 0x43, 0x35,
STROKE, 1.49,
MOVE_TO, 305.58, 60.83,
LINE_TO, 314.55, 58.24,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFB, 0xBC, 0x04,
STROKE, 1.49,
MOVE_TO, 229.57, 22.8,
LINE_TO, 232.04, 9.75,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xFF, 0xFF,
CIRCLE, 274.53, 74.37, 17.04,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xD2, 0xE3, 0xFC,
STROKE, 2.24,
CIRCLE, 274.53, 74.37, 17.04,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFF, 0xFF, 0xFF,
CIRCLE, 173.46, 74.37, 17.04,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xD2, 0xE3, 0xFC,
STROKE, 2.24,
CIRCLE, 173.46, 74.37, 17.04,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x34, 0xA8, 0x53,
STROKE, 2.24,
R_MOVE_TO, 179.52, 82.71,
R_H_LINE_TO, -12.11,
R_CUBIC_TO, -0.47, 0, -0.85, -0.38, -0.85, -0.85,
R_V_LINE_TO, -9.4,
R_CUBIC_TO, 0, -0.47, 0.38, -0.85, 0.85, -0.85,
R_H_LINE_TO, 12.11,
R_CUBIC_TO, 0.47, 0, 0.85, 0.38, 0.85, 0.85,
R_V_LINE_TO, 9.4,
R_CUBIC_TO, 0, 0.47, -0.38, 0.85, -0.85, 0.85,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x34, 0xA8, 0x53,
STROKE, 2.24,
R_MOVE_TO, 176.34, 71.6,
R_V_LINE_TO, -4.03,
R_CUBIC_TO, 0, -1.59, -1.29, -2.88, -2.88, -2.88,
R_CUBIC_TO, -1.59, 0, -2.88, 1.29, -2.88, 2.88,
R_V_LINE_TO, 4.03,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x34, 0xA8, 0x53,
STROKE, 2.80,
MOVE_TO, 265.45, 76.65,
LINE_TO, 271.07, 82.27,
LINE_TO, 283.62, 69.73,
MOVE_TO, 283.62, 69.73,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSecurePaymentConfirmationFingerprintRepList, kSecurePaymentConfirmationFingerprintIcon, {kSecurePaymentConfirmationFingerprintPath})
VECTOR_ICON_REP_TEMPLATE(kSecurePaymentConfirmationFingerprintDarkPath, CANVAS_DIMENSIONS, 448,
PATH_COLOR_ARGB, 0xFF, 0x18, 0x5A, 0xBC,
R_MOVE_TO, 257.48, 74.37,
R_CUBIC_TO, 0, -6.73, 3.9, -12.55, 9.56, -15.32,
R_CUBIC_TO, -2.2, -6.2, -5.78, -12.02, -10.75, -16.99,
R_CUBIC_TO, -17.84, -17.84, -46.77, -17.84, -64.61, 0,
R_CUBIC_TO, -4.96, 4.96, -8.54, 10.78, -10.75, 16.99,
R_CUBIC_TO, 5.67, 2.77, 9.56, 8.59, 9.56, 15.32,
R_CUBIC_TO, 0, 6.73, -3.9, 12.55, -9.56, 15.32,
R_CUBIC_TO, 2.2, 6.2, 5.78, 12.02, 10.75, 16.99,
R_CUBIC_TO, 17.84, 17.84, 46.77, 17.84, 64.61, 0,
R_CUBIC_TO, 4.96, -4.96, 8.54, -10.78, 10.75, -16.99,
R_CUBIC_TO, -5.66, -2.77, -9.56, -8.6, -9.56, -15.32,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x8A, 0xB4, 0xF8,
R_MOVE_TO, 239.83, 53.86,
R_CUBIC_TO, -0.22, 0, -0.43, -0.05, -0.63, -0.16,
R_CUBIC_TO, -5.23, -2.7, -9.75, -3.84, -15.17, -3.84,
R_CUBIC_TO, -5.4, 0, -10.51, 1.28, -15.17, 3.84,
R_CUBIC_TO, -0.65, 0.35, -1.47, 0.11, -1.85, -0.55,
R_CUBIC_TO, -0.35, -0.65, -0.11, -1.5, 0.55, -1.85,
R_CUBIC_TO, 5.07, -2.75, 10.62, -4.17, 16.48, -4.17,
R_CUBIC_TO, 5.8, 0, 10.87, 1.28, 16.42, 4.14,
R_CUBIC_TO, 0.68, 0.35, 0.93, 1.17, 0.57, 1.82,
R_CUBIC_TO, -0.24, 0.5, -0.7, 0.77, -1.2, 0.77,
CLOSE,
R_MOVE_TO, -38.97, 14.3,
R_CUBIC_TO, -0.27, 0, -0.55, -0.08, -0.79, -0.25,
R_CUBIC_TO, -0.63, -0.43, -0.76, -1.28, -0.33, -1.9,
R_CUBIC_TO, 2.7, -3.81, 6.13, -6.81, 10.21, -8.9,
R_CUBIC_TO, 8.55, -4.41, 19.5, -4.44, 28.08, -0.03,
R_CUBIC_TO, 4.08, 2.1, 7.52, 5.07, 10.21, 8.85,
R_CUBIC_TO, 0.43, 0.6, 0.3, 1.47, -0.33, 1.9,
R_CUBIC_TO, -0.63, 0.43, -1.47, 0.3, -1.9, -0.33,
R_CUBIC_TO, -2.45, -3.43, -5.55, -6.13, -9.23, -8,
R_CUBIC_TO, -7.82, -4, -17.81, -4, -25.6, 0.03,
R_CUBIC_TO, -3.7, 1.9, -6.81, 4.63, -9.26, 8.06,
R_CUBIC_TO, -0.22, 0.38, -0.63, 0.57, -1.06, 0.57,
CLOSE,
R_MOVE_TO, 17.02, 32.87,
R_CUBIC_TO, -0.35, 0, -0.7, -0.13, -0.95, -0.41,
R_CUBIC_TO, -2.37, -2.37, -3.65, -3.9, -5.47, -7.19,
R_CUBIC_TO, -1.88, -3.35, -2.86, -7.43, -2.86, -11.82,
R_CUBIC_TO, 0, -8.09, 6.92, -14.68, 15.41, -14.68,
R_CUBIC_TO, 8.5, 0, 15.41, 6.59, 15.41, 14.68,
R_CUBIC_TO, 0, 0.76, -0.6, 1.36, -1.36, 1.36,
R_CUBIC_TO, -0.76, 0, -1.36, -0.6, -1.36, -1.36,
R_CUBIC_TO, 0, -6.59, -5.7, -11.95, -12.69, -11.95,
R_CUBIC_TO, -7, 0, -12.69, 5.37, -12.69, 11.95,
R_CUBIC_TO, 0, 3.92, 0.87, 7.55, 2.53, 10.48,
R_CUBIC_TO, 1.75, 3.13, 2.95, 4.47, 5.04, 6.59,
R_CUBIC_TO, 0.52, 0.55, 0.52, 1.39, 0, 1.93,
R_CUBIC_TO, -0.28, 0.27, -0.64, 0.4, -1, 0.4,
CLOSE,
R_MOVE_TO, 19.53, -5.04,
R_CUBIC_TO, -3.24, 0, -6.1, -0.82, -8.45, -2.42,
R_CUBIC_TO, -4.06, -2.75, -6.48, -7.22, -6.48, -11.95,
R_CUBIC_TO, 0, -0.76, 0.6, -1.36, 1.36, -1.36,
R_CUBIC_TO, 0.76, 0, 1.36, 0.6, 1.36, 1.36,
R_CUBIC_TO, 0, 3.84, 1.96, 7.46, 5.28, 9.7,
R_CUBIC_TO, 1.93, 1.3, 4.2, 1.93, 6.92, 1.93,
R_CUBIC_TO, 0.65, 0, 1.75, -0.08, 2.83, -0.27,
R_CUBIC_TO, 0.73, -0.13, 1.45, 0.35, 1.58, 1.12,
R_CUBIC_TO, 0.13, 0.73, -0.35, 1.45, -1.12, 1.58,
R_CUBIC_TO, -1.56, 0.28, -2.92, 0.31, -3.3, 0.31,
CLOSE,
R_MOVE_TO, -5.48, 5.61,
R_CUBIC_TO, -0.11, 0, -0.25, -0.03, -0.35, -0.05,
R_CUBIC_TO, -4.33, -1.2, -7.16, -2.8, -10.13, -5.72,
R_CUBIC_TO, -3.81, -3.78, -5.91, -8.83, -5.91, -14.22,
R_CUBIC_TO, 0, -4.41, 3.76, -8, 8.39, -8,
R_CUBIC_TO, 4.63, 0, 8.39, 3.6, 8.39, 8,
R_CUBIC_TO, 0, 2.92, 2.53, 5.28, 5.67, 5.28,
R_CUBIC_TO, 3.13, 0, 5.67, -2.37, 5.67, -5.28,
R_CUBIC_TO, 0, -10.27, -8.85, -18.6, -19.75, -18.6,
R_CUBIC_TO, -7.73, 0, -14.81, 4.3, -18, 10.98,
R_CUBIC_TO, -1.06, 2.2, -1.6, 4.8, -1.6, 7.63,
R_CUBIC_TO, 0, 2.12, 0.19, 5.47, 1.82, 9.83,
R_CUBIC_TO, 0.27, 0.7, -0.08, 1.5, -0.79, 1.75,
R_CUBIC_TO, -0.7, 0.27, -1.5, -0.11, -1.75, -0.79,
R_CUBIC_TO, -1.33, -3.57, -1.99, -7.11, -1.99, -10.78,
R_CUBIC_TO, 0, -3.27, 0.63, -6.23, 1.85, -8.83,
R_CUBIC_TO, 3.62, -7.6, 11.65, -12.53, 20.45, -12.53,
R_CUBIC_TO, 12.39, 0, 22.47, 9.56, 22.47, 21.33,
R_CUBIC_TO, 0, 4.41, -3.76, 8, -8.39, 8,
R_CUBIC_TO, -4.63, 0, -8.39, -3.6, -8.39, -8,
R_CUBIC_TO, 0, -2.92, -2.53, -5.28, -5.67, -5.28,
R_CUBIC_TO, -3.13, 0, -5.67, 2.37, -5.67, 5.28,
R_CUBIC_TO, 0, 4.65, 1.8, 9.01, 5.1, 12.28,
R_CUBIC_TO, 2.59, 2.56, 5.07, 3.98, 8.9, 5.04,
R_CUBIC_TO, 0.73, 0.19, 1.15, 0.95, 0.95, 1.66,
R_CUBIC_TO, -0.13, 0.61, -0.7, 1.02, -1.27, 1.02,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFB, 0xBC, 0x04,
R_MOVE_TO, 175.26, 137.79,
R_CUBIC_TO, -2.21, 1.85, -5.51, 1.55, -7.35, -0.66,
R_CUBIC_TO, -1.85, -2.21, -1.55, -5.51, 0.66, -7.35,
R_LINE_TO, 8.01, -6.69,
R_CUBIC_TO, 2.21, -1.85, 5.51, -1.55, 7.35, 0.66,
R_CUBIC_TO, 1.85, 2.21, 1.55, 5.51, -0.66, 7.35,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x34, 0xA8, 0x53,
R_MOVE_TO, 277.97, 24,
R_CUBIC_TO, -1.2, 0.21, -1.72, 1.63, -0.94, 2.57,
R_LINE_TO, 9.35, 11.2,
R_CUBIC_TO, 0.78, 0.93, 2.28, 0.67, 2.69, -0.47,
R_LINE_TO, 5.02, -13.69,
R_CUBIC_TO, 0.42, -1.15, -0.55, -2.32, -1.75, -2.11,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x42, 0x85, 0xF4,
R_MOVE_TO, 152, 26.5,
R_CUBIC_TO, -0.26, -0.54, -0.04, -1.19, 0.49, -1.45,
R_LINE_TO, 7.81, -3.84,
R_CUBIC_TO, 0.54, -0.26, 1.19, -0.04, 1.45, 0.49,
R_LINE_TO, 3.84, 7.81,
R_CUBIC_TO, 0.26, 0.54, 0.05, 1.19, -0.49, 1.45,
R_LINE_TO, -7.81, 3.84,
R_CUBIC_TO, -0.54, 0.27, -1.19, 0.05, -1.45, -0.49,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x34, 0xA8, 0x53,
STROKE, 1.49,
MOVE_TO, 133.45, 105.41,
LINE_TO, 142.93, 102.24,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xEA, 0x43, 0x35,
STROKE, 1.49,
MOVE_TO, 305.58, 60.83,
LINE_TO, 314.55, 58.24,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFB, 0xBC, 0x04,
STROKE, 1.49,
MOVE_TO, 229.57, 22.8,
LINE_TO, 232.04, 9.75,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x18, 0x5A, 0xBC,
STROKE, 2.24,
CIRCLE, 274.53, 74.37, 17.04,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x18, 0x5A, 0xBC,
STROKE, 2.24,
CIRCLE, 173.46, 74.37, 17.04,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x34, 0xA8, 0x53,
STROKE, 2.24,
R_MOVE_TO, 179.52, 82.71,
R_H_LINE_TO, -12.11,
R_CUBIC_TO, -0.47, 0, -0.85, -0.38, -0.85, -0.85,
R_V_LINE_TO, -9.4,
R_CUBIC_TO, 0, -0.47, 0.38, -0.85, 0.85, -0.85,
R_H_LINE_TO, 12.11,
R_CUBIC_TO, 0.47, 0, 0.85, 0.38, 0.85, 0.85,
R_V_LINE_TO, 9.4,
R_CUBIC_TO, 0, 0.47, -0.38, 0.85, -0.85, 0.85,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x34, 0xA8, 0x53,
STROKE, 2.24,
R_MOVE_TO, 176.34, 71.6,
R_V_LINE_TO, -4.03,
R_CUBIC_TO, 0, -1.59, -1.29, -2.88, -2.88, -2.88,
R_CUBIC_TO, -1.59, 0, -2.88, 1.29, -2.88, 2.88,
R_V_LINE_TO, 4.03,
CLOSE,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x34, 0xA8, 0x53,
STROKE, 2.80,
MOVE_TO, 265.45, 76.65,
LINE_TO, 271.07, 82.27,
LINE_TO, 283.62, 69.73,
MOVE_TO, 283.62, 69.73,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSecurePaymentConfirmationFingerprintDarkRepList, kSecurePaymentConfirmationFingerprintDarkIcon, {kSecurePaymentConfirmationFingerprintDarkPath})
VECTOR_ICON_REP_TEMPLATE(kNearbySharePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 2.72, 8.87,
CUBIC_TO, 2.24, 9.32, 2.23, 10.07, 2.69, 10.54,
LINE_TO, 3.89, 11.78,
LINE_TO, 5.54, 10.08,
LINE_TO, 4.39, 8.89,
CUBIC_TO, 3.94, 8.42, 3.19, 8.41, 2.72, 8.87,
CLOSE,
MOVE_TO, 16.26, 15.75,
LINE_TO, 17.26, 14.73,
LINE_TO, 18.92, 13.04,
LINE_TO, 21.35, 10.55,
CUBIC_TO, 21.57, 10.31, 21.68, 10.02, 21.68, 9.72,
CUBIC_TO, 21.68, 9.41, 21.56, 9.11, 21.32, 8.87,
CUBIC_TO, 20.86, 8.42, 20.1, 8.42, 19.65, 8.89,
LINE_TO, 17.26, 11.35,
LINE_TO, 15.6, 13.04,
LINE_TO, 14.57, 14.09,
CUBIC_TO, 13.89, 14.79, 12.99, 15.17, 12.02, 15.17,
CUBIC_TO, 11.15, 15.17, 10.35, 14.86, 9.71, 14.3,
LINE_TO, 8.06, 15.99,
CUBIC_TO, 9.15, 16.99, 10.54, 17.54, 12.02, 17.54,
CUBIC_TO, 13.63, 17.54, 15.14, 16.91, 16.26, 15.75,
CLOSE,
MOVE_TO, 12.02, 8.54,
CUBIC_TO, 10.41, 8.54, 8.9, 9.17, 7.78, 10.33,
LINE_TO, 4.07, 14.13,
LINE_TO, 2.69, 15.54,
CUBIC_TO, 2.24, 16, 2.24, 16.76, 2.72, 17.21,
CUBIC_TO, 3.18, 17.66, 3.94, 17.66, 4.39, 17.19,
LINE_TO, 6.78, 14.73,
LINE_TO, 8.44, 13.04,
LINE_TO, 9.47, 11.99,
CUBIC_TO, 10.15, 11.29, 11.05, 10.91, 12.02, 10.91,
CUBIC_TO, 12.88, 10.91, 13.68, 11.22, 14.33, 11.78,
LINE_TO, 15.98, 10.09,
CUBIC_TO, 14.89, 9.09, 13.5, 8.54, 12.02, 8.54,
CLOSE,
MOVE_TO, 21.68, 16.37,
CUBIC_TO, 21.68, 16.07, 21.57, 15.77, 21.35, 15.54,
LINE_TO, 20.16, 14.32,
LINE_TO, 18.51, 16.03,
LINE_TO, 19.65, 17.2,
CUBIC_TO, 20.1, 17.67, 20.85, 17.69, 21.32, 17.22,
CUBIC_TO, 21.56, 16.99, 21.68, 16.68, 21.68, 16.37,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNearbyShareRepList, kNearbyShareIcon, {kNearbySharePath})
