// cc/mojom/layer_tree_debug_state.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "cc/mojom/layer_tree_debug_state.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "cc/mojom/layer_tree_debug_state.mojom-params-data.h"
#include "cc/mojom/layer_tree_debug_state.mojom-shared-message-ids.h"

#include "cc/mojom/layer_tree_debug_state.mojom-import-headers.h"
#include "cc/mojom/layer_tree_debug_state.mojom-test-utils.h"


namespace cc::mojom {
LayerTreeDebugState::LayerTreeDebugState()
    : debugger_paused(),
      show_fps_counter(),
      show_render_pass_borders(),
      show_surface_borders(),
      show_layer_borders(),
      show_layout_shift_regions(),
      show_paint_rects(),
      show_property_changed_rects(),
      show_surface_damage_rects(),
      show_screen_space_rects(),
      show_touch_event_handler_rects(),
      show_wheel_event_handler_rects(),
      show_scroll_event_handler_rects(),
      show_main_thread_scroll_hit_test_rects(),
      show_main_thread_scroll_repaint_rects(),
      show_raster_inducing_scroll_rects(),
      show_layer_animation_bounds_rects(),
      slow_down_raster_scale_factor(),
      rasterize_only_visible_content(),
      highlight_non_lcd_text_layers(),
      record_rendering_stats() {}

LayerTreeDebugState::LayerTreeDebugState(
    bool debugger_paused_in,
    bool show_fps_counter_in,
    bool show_render_pass_borders_in,
    bool show_surface_borders_in,
    bool show_layer_borders_in,
    bool show_layout_shift_regions_in,
    bool show_paint_rects_in,
    bool show_property_changed_rects_in,
    bool show_surface_damage_rects_in,
    bool show_screen_space_rects_in,
    bool show_touch_event_handler_rects_in,
    bool show_wheel_event_handler_rects_in,
    bool show_scroll_event_handler_rects_in,
    bool show_main_thread_scroll_hit_test_rects_in,
    bool show_main_thread_scroll_repaint_rects_in,
    bool show_raster_inducing_scroll_rects_in,
    bool show_layer_animation_bounds_rects_in,
    int32_t slow_down_raster_scale_factor_in,
    bool rasterize_only_visible_content_in,
    bool highlight_non_lcd_text_layers_in,
    bool record_rendering_stats_in)
    : debugger_paused(std::move(debugger_paused_in)),
      show_fps_counter(std::move(show_fps_counter_in)),
      show_render_pass_borders(std::move(show_render_pass_borders_in)),
      show_surface_borders(std::move(show_surface_borders_in)),
      show_layer_borders(std::move(show_layer_borders_in)),
      show_layout_shift_regions(std::move(show_layout_shift_regions_in)),
      show_paint_rects(std::move(show_paint_rects_in)),
      show_property_changed_rects(std::move(show_property_changed_rects_in)),
      show_surface_damage_rects(std::move(show_surface_damage_rects_in)),
      show_screen_space_rects(std::move(show_screen_space_rects_in)),
      show_touch_event_handler_rects(std::move(show_touch_event_handler_rects_in)),
      show_wheel_event_handler_rects(std::move(show_wheel_event_handler_rects_in)),
      show_scroll_event_handler_rects(std::move(show_scroll_event_handler_rects_in)),
      show_main_thread_scroll_hit_test_rects(std::move(show_main_thread_scroll_hit_test_rects_in)),
      show_main_thread_scroll_repaint_rects(std::move(show_main_thread_scroll_repaint_rects_in)),
      show_raster_inducing_scroll_rects(std::move(show_raster_inducing_scroll_rects_in)),
      show_layer_animation_bounds_rects(std::move(show_layer_animation_bounds_rects_in)),
      slow_down_raster_scale_factor(std::move(slow_down_raster_scale_factor_in)),
      rasterize_only_visible_content(std::move(rasterize_only_visible_content_in)),
      highlight_non_lcd_text_layers(std::move(highlight_non_lcd_text_layers_in)),
      record_rendering_stats(std::move(record_rendering_stats_in)) {}

LayerTreeDebugState::~LayerTreeDebugState() = default;

void LayerTreeDebugState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debugger_paused"), this->debugger_paused,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_fps_counter"), this->show_fps_counter,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_render_pass_borders"), this->show_render_pass_borders,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_surface_borders"), this->show_surface_borders,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_layer_borders"), this->show_layer_borders,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_layout_shift_regions"), this->show_layout_shift_regions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_paint_rects"), this->show_paint_rects,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_property_changed_rects"), this->show_property_changed_rects,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_surface_damage_rects"), this->show_surface_damage_rects,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_screen_space_rects"), this->show_screen_space_rects,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_touch_event_handler_rects"), this->show_touch_event_handler_rects,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_wheel_event_handler_rects"), this->show_wheel_event_handler_rects,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_scroll_event_handler_rects"), this->show_scroll_event_handler_rects,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_main_thread_scroll_hit_test_rects"), this->show_main_thread_scroll_hit_test_rects,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_main_thread_scroll_repaint_rects"), this->show_main_thread_scroll_repaint_rects,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_raster_inducing_scroll_rects"), this->show_raster_inducing_scroll_rects,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_layer_animation_bounds_rects"), this->show_layer_animation_bounds_rects,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "slow_down_raster_scale_factor"), this->slow_down_raster_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rasterize_only_visible_content"), this->rasterize_only_visible_content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "highlight_non_lcd_text_layers"), this->highlight_non_lcd_text_layers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "record_rendering_stats"), this->record_rendering_stats,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LayerTreeDebugState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // cc::mojom


namespace mojo {


// static
bool StructTraits<::cc::mojom::LayerTreeDebugState::DataView, ::cc::mojom::LayerTreeDebugStatePtr>::Read(
    ::cc::mojom::LayerTreeDebugState::DataView input,
    ::cc::mojom::LayerTreeDebugStatePtr* output) {
  bool success = true;
  ::cc::mojom::LayerTreeDebugStatePtr result(::cc::mojom::LayerTreeDebugState::New());
  
      if (success)
        result->debugger_paused = input.debugger_paused();
      if (success)
        result->show_fps_counter = input.show_fps_counter();
      if (success)
        result->show_render_pass_borders = input.show_render_pass_borders();
      if (success)
        result->show_surface_borders = input.show_surface_borders();
      if (success)
        result->show_layer_borders = input.show_layer_borders();
      if (success)
        result->show_layout_shift_regions = input.show_layout_shift_regions();
      if (success)
        result->show_paint_rects = input.show_paint_rects();
      if (success)
        result->show_property_changed_rects = input.show_property_changed_rects();
      if (success)
        result->show_surface_damage_rects = input.show_surface_damage_rects();
      if (success)
        result->show_screen_space_rects = input.show_screen_space_rects();
      if (success)
        result->show_touch_event_handler_rects = input.show_touch_event_handler_rects();
      if (success)
        result->show_wheel_event_handler_rects = input.show_wheel_event_handler_rects();
      if (success)
        result->show_scroll_event_handler_rects = input.show_scroll_event_handler_rects();
      if (success)
        result->show_main_thread_scroll_hit_test_rects = input.show_main_thread_scroll_hit_test_rects();
      if (success)
        result->show_main_thread_scroll_repaint_rects = input.show_main_thread_scroll_repaint_rects();
      if (success)
        result->show_raster_inducing_scroll_rects = input.show_raster_inducing_scroll_rects();
      if (success)
        result->show_layer_animation_bounds_rects = input.show_layer_animation_bounds_rects();
      if (success)
        result->slow_down_raster_scale_factor = input.slow_down_raster_scale_factor();
      if (success)
        result->rasterize_only_visible_content = input.rasterize_only_visible_content();
      if (success)
        result->highlight_non_lcd_text_layers = input.highlight_non_lcd_text_layers();
      if (success)
        result->record_rendering_stats = input.record_rendering_stats();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace cc::mojom {




}  // cc::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif