// cc/mojom/layer_selection_bound.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'cc/mojom/layer_selection_bound.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('cc.mojom');
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var selection_bound$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/selection_bound.mojom', '../../ui/gfx/mojom/selection_bound.mojom.js');
  }



  function LayerSelectionBound(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LayerSelectionBound.prototype.initDefaults_ = function() {
    this.type = 0;
    this.layerId = 0;
    this.edgeStart = null;
    this.edgeEnd = null;
    this.hidden = false;
  };
  LayerSelectionBound.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LayerSelectionBound.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerSelectionBound.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, selection_bound$.SelectionBoundType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerSelectionBound.edgeStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Point, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerSelectionBound.edgeEnd
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Point, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  LayerSelectionBound.encodedSize = codec.kStructHeaderSize + 32;

  LayerSelectionBound.decode = function(decoder) {
    var packed;
    var val = new LayerSelectionBound();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(selection_bound$.SelectionBoundType));
    val.layerId =
        decoder.decodeStruct(codec.Int32);
    val.edgeStart =
        decoder.decodeStructPointer(geometry$.Point);
    val.edgeEnd =
        decoder.decodeStructPointer(geometry$.Point);
    packed = decoder.readUint8();
    val.hidden = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LayerSelectionBound.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LayerSelectionBound.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStruct(codec.Int32, val.layerId);
    encoder.encodeStructPointer(geometry$.Point, val.edgeStart);
    encoder.encodeStructPointer(geometry$.Point, val.edgeEnd);
    packed = 0;
    packed |= (val.hidden & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function LayerSelection(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LayerSelection.prototype.initDefaults_ = function() {
    this.start = null;
    this.end = null;
  };
  LayerSelection.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LayerSelection.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerSelection.start
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, LayerSelectionBound, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerSelection.end
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, LayerSelectionBound, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LayerSelection.encodedSize = codec.kStructHeaderSize + 16;

  LayerSelection.decode = function(decoder) {
    var packed;
    var val = new LayerSelection();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.start =
        decoder.decodeStructPointer(LayerSelectionBound);
    val.end =
        decoder.decodeStructPointer(LayerSelectionBound);
    return val;
  };

  LayerSelection.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LayerSelection.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(LayerSelectionBound, val.start);
    encoder.encodeStructPointer(LayerSelectionBound, val.end);
  };
  exports.LayerSelectionBound = LayerSelectionBound;
  exports.LayerSelection = LayerSelection;
})();